<?php
namespace PHPMaker2020\baak;

/**
 * Page class
 */
class docmhs_delete extends docmhs
{

	// Page ID
	public $PageID = "delete";

	// Project ID
	public $ProjectID = "{A09D3AFF-419C-4918-948A-A3C8469EA234}";

	// Table name
	public $TableName = 'docmhs';

	// Page object name
	public $PageObjName = "docmhs_delete";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken;

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading != "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading != "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		$url = CurrentPageName() . "?";
		if ($this->UseTokenInUrl)
			$url .= "t=" . $this->TableVar . "&"; // Add page token
		return $url;
	}

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = TRUE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message != "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fas fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage != "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fas fa-exclamation"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage != "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fas fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage != "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fas fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = [];

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message != "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage != "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage != "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage != "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header != "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer != "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(Config("TOKEN_NAME")) === NULL)
			return FALSE;
		$fn = Config("CHECK_TOKEN_FUNC");
		if (is_callable($fn))
			return $fn(Post(Config("TOKEN_NAME")), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = Config("CREATE_TOKEN_FUNC"); // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $DashboardReport;
		global $UserTable;

		// Check token
		$this->CheckToken = Config("CHECK_TOKEN");

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (docmhs)
		if (!isset($GLOBALS["docmhs"]) || get_class($GLOBALS["docmhs"]) == PROJECT_NAMESPACE . "docmhs") {
			$GLOBALS["docmhs"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["docmhs"];
		}

		// Table object (Pass)
		if (!isset($GLOBALS['Pass']))
			$GLOBALS['Pass'] = new Pass();

		// Table object (IM_Lulusan)
		if (!isset($GLOBALS['IM_Lulusan']))
			$GLOBALS['IM_Lulusan'] = new IM_Lulusan();

		// Table object (IM_Mhs)
		if (!isset($GLOBALS['IM_Mhs']))
			$GLOBALS['IM_Mhs'] = new IM_Mhs();

		// Table object (ekpt_mhsfeed)
		if (!isset($GLOBALS['ekpt_mhsfeed']))
			$GLOBALS['ekpt_mhsfeed'] = new ekpt_mhsfeed();

		// Page ID (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'delete');

		// Table name (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'docmhs');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = $this->getConnection();

		// User table object (Pass)
		$UserTable = $UserTable ?: new Pass();
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages, $DashboardReport;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $docmhs;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, Config("EXPORT_CLASSES"))) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . Config("EXPORT_CLASSES." . $this->CustomExport);
			if (class_exists($class)) {
				$doc = new $class($docmhs);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url != "") {
			if (!Config("DEBUG") && ob_get_length())
				ob_end_clean();
			SaveDebugMessage();
			AddHeader("Location", $url);
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = [];
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
		$this->Ijazah->OldUploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/';
		$this->Ijazah->UploadPath = $this->Ijazah->OldUploadPath;
		$this->Ktp->OldUploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/';
		$this->Ktp->UploadPath = $this->Ktp->OldUploadPath;
		$this->KK->OldUploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/';
		$this->KK->UploadPath = $this->KK->OldUploadPath;
		$this->tandatangan->OldUploadPath = '../../../../D:/www/im/mhs/views/uploads/';
		$this->tandatangan->UploadPath = $this->tandatangan->OldUploadPath;
		$this->IjazahIM->OldUploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/riwayat/';
		$this->IjazahIM->UploadPath = $this->IjazahIM->OldUploadPath;
		$this->TranskriptIM->OldUploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/riwayat/';
		$this->TranskriptIM->UploadPath = $this->TranskriptIM->OldUploadPath;
		$this->Skripsi->OldUploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/riwayat/';
		$this->Skripsi->UploadPath = $this->Skripsi->OldUploadPath;
		$this->Plagiat->OldUploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/riwayat/';
		$this->Plagiat->UploadPath = $this->Plagiat->OldUploadPath;
		$this->riwayatakademik->OldUploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/riwayat/';
		$this->riwayatakademik->UploadPath = $this->riwayatakademik->OldUploadPath;
		$this->keuangan->OldUploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/keu/';
		$this->keuangan->UploadPath = $this->keuangan->OldUploadPath;
		$this->pendukung->OldUploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/pendukung/';
		$this->pendukung->UploadPath = $this->pendukung->OldUploadPath;
		$this->lainlain->OldUploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/lainlain/';
		$this->lainlain->UploadPath = $this->lainlain->OldUploadPath;
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = [];
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {
								$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
									Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
									Config("API_FIELD_NAME") . "=" . $fld->Param . "&" .
									Config("API_KEY_NAME") . "=" . rawurlencode($this->getRecordKeyValue($ar)))); //*** need to add this? API may not be in the same folder
								$row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
								$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
									Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
									"fn=" . Encrypt($fld->physicalUploadPath() . $val)));
								$row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
							} else { // Multiple files
								$files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
								$ar = [];
								foreach ($files as $file) {
									$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
										Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
										"fn=" . Encrypt($fld->physicalUploadPath() . $file)));
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['Nim'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
	}

	// Set up API security
	public function setupApiSecurity()
	{
		global $Security;

		// Setup security for API request
		if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
		$Security->loadCurrentUserLevel(Config("PROJECT_ID") . $this->TableName);
		if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
	}
	public $DbMasterFilter = "";
	public $DbDetailFilter = "";
	public $StartRecord;
	public $TotalRecords = 0;
	public $RecordCount;
	public $RecKeys = [];
	public $StartRowCount = 1;
	public $RowCount = 0;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $CurrentForm;

		// User profile
		$UserProfile = new UserProfile();

		// Security
		if (ValidApiRequest()) { // API request
			$this->setupApiSecurity(); // Set up API Security
			if (!$Security->canDelete()) {
				SetStatus(401); // Unauthorized
				return;
			}
		} else {
			$Security = new AdvancedSecurity();
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canDelete()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("docmhslist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
		}
		$this->CurrentAction = Param("action"); // Set up current action
		$this->Nim->Visible = FALSE;
		$this->Ijazah->setVisibility();
		$this->Ktp->setVisibility();
		$this->KK->setVisibility();
		$this->tandatangan->Visible = FALSE;
		$this->IjazahIM->setVisibility();
		$this->TranskriptIM->setVisibility();
		$this->Skripsi->setVisibility();
		$this->Plagiat->setVisibility();
		$this->riwayatakademik->setVisibility();
		$this->keuangan->setVisibility();
		$this->pendukung->setVisibility();
		$this->lainlain->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		// Check permission

		if (!$Security->canDelete()) {
			$this->setFailureMessage(DeniedMessage()); // No permission
			$this->terminate("docmhslist.php");
			return;
		}

		// Set up master/detail parameters
		$this->setupMasterParms();

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Load key parameters
		$this->RecKeys = $this->getRecordKeys(); // Load record keys
		$filter = $this->getFilterFromRecordKeys();
		if ($filter == "") {
			$this->terminate("docmhslist.php"); // Prevent SQL injection, return to list
			return;
		}

		// Set up filter (WHERE Clause)
		$this->CurrentFilter = $filter;

		// Get action
		if (IsApi()) {
			$this->CurrentAction = "delete"; // Delete record directly
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action");
		} elseif (Get("action") == "1") {
			$this->CurrentAction = "delete"; // Delete record directly
		} else {
			$this->CurrentAction = "show"; // Display record
		}
		if ($this->isDelete()) {
			$this->SendEmail = TRUE; // Send email on delete success
			if ($this->deleteRows()) { // Delete rows
				if ($this->getSuccessMessage() == "")
					$this->setSuccessMessage($Language->phrase("DeleteSuccess")); // Set up success message
				if (IsApi()) {
					$this->terminate(TRUE);
					return;
				} else {
					$this->terminate($this->getReturnUrl()); // Return to caller
				}
			} else { // Delete failed
				if (IsApi()) {
					$this->terminate();
					return;
				}
				$this->CurrentAction = "show"; // Display record
			}
		}
		if ($this->isShow()) { // Load records for display
			if ($this->Recordset = $this->loadRecordset())
				$this->TotalRecords = $this->Recordset->RecordCount(); // Get record count
			if ($this->TotalRecords <= 0) { // No record found, exit
				if ($this->Recordset)
					$this->Recordset->close();
				$this->terminate("docmhslist.php"); // Return to list
			}
		}
	}

	// Load recordset
	public function loadRecordset($offset = -1, $rowcnt = -1)
	{

		// Load List page SQL
		$sql = $this->getListSql();
		$conn = $this->getConnection();

		// Load recordset
		$dbtype = GetConnectionType($this->Dbid);
		if ($this->UseSelectLimit) {
			$conn->raiseErrorFn = Config("ERROR_FUNC");
			if ($dbtype == "MSSQL") {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset, ["_hasOrderBy" => trim($this->getOrderBy()) || trim($this->getSessionOrderBy())]);
			} else {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset);
			}
			$conn->raiseErrorFn = "";
		} else {
			$rs = LoadRecordset($sql, $conn);
		}

		// Call Recordset Selected event
		$this->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = $this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->Nim->setDbValue($row['Nim']);
		$this->Ijazah->Upload->DbValue = $row['Ijazah'];
		$this->Ijazah->setDbValue($this->Ijazah->Upload->DbValue);
		$this->Ktp->Upload->DbValue = $row['Ktp'];
		$this->Ktp->setDbValue($this->Ktp->Upload->DbValue);
		$this->KK->Upload->DbValue = $row['KK'];
		$this->KK->setDbValue($this->KK->Upload->DbValue);
		$this->tandatangan->Upload->DbValue = $row['tandatangan'];
		$this->tandatangan->setDbValue($this->tandatangan->Upload->DbValue);
		$this->IjazahIM->Upload->DbValue = $row['IjazahIM'];
		$this->IjazahIM->setDbValue($this->IjazahIM->Upload->DbValue);
		$this->TranskriptIM->Upload->DbValue = $row['TranskriptIM'];
		$this->TranskriptIM->setDbValue($this->TranskriptIM->Upload->DbValue);
		$this->Skripsi->Upload->DbValue = $row['Skripsi'];
		$this->Skripsi->setDbValue($this->Skripsi->Upload->DbValue);
		$this->Plagiat->Upload->DbValue = $row['Plagiat'];
		$this->Plagiat->setDbValue($this->Plagiat->Upload->DbValue);
		$this->riwayatakademik->Upload->DbValue = $row['riwayatakademik'];
		$this->riwayatakademik->setDbValue($this->riwayatakademik->Upload->DbValue);
		$this->keuangan->Upload->DbValue = $row['keuangan'];
		$this->keuangan->setDbValue($this->keuangan->Upload->DbValue);
		$this->pendukung->Upload->DbValue = $row['pendukung'];
		$this->pendukung->setDbValue($this->pendukung->Upload->DbValue);
		$this->lainlain->Upload->DbValue = $row['lainlain'];
		$this->lainlain->setDbValue($this->lainlain->Upload->DbValue);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['Nim'] = NULL;
		$row['Ijazah'] = NULL;
		$row['Ktp'] = NULL;
		$row['KK'] = NULL;
		$row['tandatangan'] = NULL;
		$row['IjazahIM'] = NULL;
		$row['TranskriptIM'] = NULL;
		$row['Skripsi'] = NULL;
		$row['Plagiat'] = NULL;
		$row['riwayatakademik'] = NULL;
		$row['keuangan'] = NULL;
		$row['pendukung'] = NULL;
		$row['lainlain'] = NULL;
		return $row;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Call Row_Rendering event

		$this->Row_Rendering();

		// Common render codes for all row types
		// Nim
		// Ijazah
		// Ktp
		// KK
		// tandatangan
		// IjazahIM
		// TranskriptIM
		// Skripsi
		// Plagiat
		// riwayatakademik
		// keuangan
		// pendukung
		// lainlain

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// Nim
			$this->Nim->ViewValue = $this->Nim->CurrentValue;
			$this->Nim->ViewCustomAttributes = "";

			// Ijazah
			$this->Ijazah->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/';
			if (!EmptyValue($this->Ijazah->Upload->DbValue)) {
				$this->Ijazah->ViewValue = $this->Ijazah->Upload->DbValue;
			} else {
				$this->Ijazah->ViewValue = "";
			}
			$this->Ijazah->ViewCustomAttributes = "";

			// Ktp
			$this->Ktp->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/';
			if (!EmptyValue($this->Ktp->Upload->DbValue)) {
				$this->Ktp->ViewValue = $this->Ktp->Upload->DbValue;
			} else {
				$this->Ktp->ViewValue = "";
			}
			$this->Ktp->ViewCustomAttributes = "";

			// KK
			$this->KK->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/';
			if (!EmptyValue($this->KK->Upload->DbValue)) {
				$this->KK->ViewValue = $this->KK->Upload->DbValue;
			} else {
				$this->KK->ViewValue = "";
			}
			$this->KK->ViewCustomAttributes = "";

			// tandatangan
			$this->tandatangan->UploadPath = '../../../../D:/www/im/mhs/views/uploads/';
			if (!EmptyValue($this->tandatangan->Upload->DbValue)) {
				$this->tandatangan->ViewValue = $this->tandatangan->Upload->DbValue;
			} else {
				$this->tandatangan->ViewValue = "";
			}
			$this->tandatangan->ViewCustomAttributes = "";

			// IjazahIM
			$this->IjazahIM->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/riwayat/';
			if (!EmptyValue($this->IjazahIM->Upload->DbValue)) {
				$this->IjazahIM->ViewValue = $this->IjazahIM->Upload->DbValue;
			} else {
				$this->IjazahIM->ViewValue = "";
			}
			$this->IjazahIM->ViewCustomAttributes = "";

			// TranskriptIM
			$this->TranskriptIM->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/riwayat/';
			if (!EmptyValue($this->TranskriptIM->Upload->DbValue)) {
				$this->TranskriptIM->ViewValue = $this->TranskriptIM->Upload->DbValue;
			} else {
				$this->TranskriptIM->ViewValue = "";
			}
			$this->TranskriptIM->ViewCustomAttributes = "";

			// Skripsi
			$this->Skripsi->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/riwayat/';
			if (!EmptyValue($this->Skripsi->Upload->DbValue)) {
				$this->Skripsi->ViewValue = $this->Skripsi->Upload->DbValue;
			} else {
				$this->Skripsi->ViewValue = "";
			}
			$this->Skripsi->ViewCustomAttributes = "";

			// Plagiat
			$this->Plagiat->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/riwayat/';
			if (!EmptyValue($this->Plagiat->Upload->DbValue)) {
				$this->Plagiat->ViewValue = $this->Plagiat->Upload->DbValue;
			} else {
				$this->Plagiat->ViewValue = "";
			}
			$this->Plagiat->ViewCustomAttributes = "";

			// riwayatakademik
			$this->riwayatakademik->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/riwayat/';
			if (!EmptyValue($this->riwayatakademik->Upload->DbValue)) {
				$this->riwayatakademik->ViewValue = $this->riwayatakademik->Upload->DbValue;
			} else {
				$this->riwayatakademik->ViewValue = "";
			}
			$this->riwayatakademik->ViewCustomAttributes = "";

			// keuangan
			$this->keuangan->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/keu/';
			if (!EmptyValue($this->keuangan->Upload->DbValue)) {
				$this->keuangan->ViewValue = $this->keuangan->Upload->DbValue;
			} else {
				$this->keuangan->ViewValue = "";
			}
			$this->keuangan->ViewCustomAttributes = "";

			// pendukung
			$this->pendukung->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/pendukung/';
			if (!EmptyValue($this->pendukung->Upload->DbValue)) {
				$this->pendukung->ViewValue = $this->pendukung->Upload->DbValue;
			} else {
				$this->pendukung->ViewValue = "";
			}
			$this->pendukung->ViewCustomAttributes = "";

			// lainlain
			$this->lainlain->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/lainlain/';
			if (!EmptyValue($this->lainlain->Upload->DbValue)) {
				$this->lainlain->ViewValue = $this->lainlain->Upload->DbValue;
			} else {
				$this->lainlain->ViewValue = "";
			}
			$this->lainlain->ViewCustomAttributes = "";

			// Ijazah
			$this->Ijazah->LinkCustomAttributes = "";
			$this->Ijazah->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/';
			if (!EmptyValue($this->Ijazah->Upload->DbValue)) {
				$this->Ijazah->HrefValue = GetFileUploadUrl($this->Ijazah, $this->Ijazah->htmlDecode($this->Ijazah->Upload->DbValue)); // Add prefix/suffix
				$this->Ijazah->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport())
					$this->Ijazah->HrefValue = FullUrl($this->Ijazah->HrefValue, "href");
			} else {
				$this->Ijazah->HrefValue = "";
			}
			$this->Ijazah->ExportHrefValue = $this->Ijazah->UploadPath . $this->Ijazah->Upload->DbValue;
			$this->Ijazah->TooltipValue = "";

			// Ktp
			$this->Ktp->LinkCustomAttributes = "";
			$this->Ktp->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/';
			if (!EmptyValue($this->Ktp->Upload->DbValue)) {
				$this->Ktp->HrefValue = GetFileUploadUrl($this->Ktp, $this->Ktp->htmlDecode($this->Ktp->Upload->DbValue)); // Add prefix/suffix
				$this->Ktp->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport())
					$this->Ktp->HrefValue = FullUrl($this->Ktp->HrefValue, "href");
			} else {
				$this->Ktp->HrefValue = "";
			}
			$this->Ktp->ExportHrefValue = $this->Ktp->UploadPath . $this->Ktp->Upload->DbValue;
			$this->Ktp->TooltipValue = "";

			// KK
			$this->KK->LinkCustomAttributes = "";
			$this->KK->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/';
			if (!EmptyValue($this->KK->Upload->DbValue)) {
				$this->KK->HrefValue = GetFileUploadUrl($this->KK, $this->KK->htmlDecode($this->KK->Upload->DbValue)); // Add prefix/suffix
				$this->KK->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport())
					$this->KK->HrefValue = FullUrl($this->KK->HrefValue, "href");
			} else {
				$this->KK->HrefValue = "";
			}
			$this->KK->ExportHrefValue = $this->KK->UploadPath . $this->KK->Upload->DbValue;
			$this->KK->TooltipValue = "";

			// IjazahIM
			$this->IjazahIM->LinkCustomAttributes = "";
			$this->IjazahIM->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/riwayat/';
			if (!EmptyValue($this->IjazahIM->Upload->DbValue)) {
				$this->IjazahIM->HrefValue = GetFileUploadUrl($this->IjazahIM, $this->IjazahIM->htmlDecode($this->IjazahIM->Upload->DbValue)); // Add prefix/suffix
				$this->IjazahIM->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport())
					$this->IjazahIM->HrefValue = FullUrl($this->IjazahIM->HrefValue, "href");
			} else {
				$this->IjazahIM->HrefValue = "";
			}
			$this->IjazahIM->ExportHrefValue = $this->IjazahIM->UploadPath . $this->IjazahIM->Upload->DbValue;
			$this->IjazahIM->TooltipValue = "";

			// TranskriptIM
			$this->TranskriptIM->LinkCustomAttributes = "";
			$this->TranskriptIM->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/riwayat/';
			if (!EmptyValue($this->TranskriptIM->Upload->DbValue)) {
				$this->TranskriptIM->HrefValue = GetFileUploadUrl($this->TranskriptIM, $this->TranskriptIM->htmlDecode($this->TranskriptIM->Upload->DbValue)); // Add prefix/suffix
				$this->TranskriptIM->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport())
					$this->TranskriptIM->HrefValue = FullUrl($this->TranskriptIM->HrefValue, "href");
			} else {
				$this->TranskriptIM->HrefValue = "";
			}
			$this->TranskriptIM->ExportHrefValue = $this->TranskriptIM->UploadPath . $this->TranskriptIM->Upload->DbValue;
			$this->TranskriptIM->TooltipValue = "";

			// Skripsi
			$this->Skripsi->LinkCustomAttributes = "";
			$this->Skripsi->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/riwayat/';
			if (!EmptyValue($this->Skripsi->Upload->DbValue)) {
				$this->Skripsi->HrefValue = GetFileUploadUrl($this->Skripsi, $this->Skripsi->htmlDecode($this->Skripsi->Upload->DbValue)); // Add prefix/suffix
				$this->Skripsi->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport())
					$this->Skripsi->HrefValue = FullUrl($this->Skripsi->HrefValue, "href");
			} else {
				$this->Skripsi->HrefValue = "";
			}
			$this->Skripsi->ExportHrefValue = $this->Skripsi->UploadPath . $this->Skripsi->Upload->DbValue;
			$this->Skripsi->TooltipValue = "";

			// Plagiat
			$this->Plagiat->LinkCustomAttributes = "";
			$this->Plagiat->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/riwayat/';
			if (!EmptyValue($this->Plagiat->Upload->DbValue)) {
				$this->Plagiat->HrefValue = GetFileUploadUrl($this->Plagiat, $this->Plagiat->htmlDecode($this->Plagiat->Upload->DbValue)); // Add prefix/suffix
				$this->Plagiat->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport())
					$this->Plagiat->HrefValue = FullUrl($this->Plagiat->HrefValue, "href");
			} else {
				$this->Plagiat->HrefValue = "";
			}
			$this->Plagiat->ExportHrefValue = $this->Plagiat->UploadPath . $this->Plagiat->Upload->DbValue;
			$this->Plagiat->TooltipValue = "";

			// riwayatakademik
			$this->riwayatakademik->LinkCustomAttributes = "";
			$this->riwayatakademik->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/riwayat/';
			if (!EmptyValue($this->riwayatakademik->Upload->DbValue)) {
				$this->riwayatakademik->HrefValue = GetFileUploadUrl($this->riwayatakademik, $this->riwayatakademik->htmlDecode($this->riwayatakademik->Upload->DbValue)); // Add prefix/suffix
				$this->riwayatakademik->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport())
					$this->riwayatakademik->HrefValue = FullUrl($this->riwayatakademik->HrefValue, "href");
			} else {
				$this->riwayatakademik->HrefValue = "";
			}
			$this->riwayatakademik->ExportHrefValue = $this->riwayatakademik->UploadPath . $this->riwayatakademik->Upload->DbValue;
			$this->riwayatakademik->TooltipValue = "";

			// keuangan
			$this->keuangan->LinkCustomAttributes = "";
			$this->keuangan->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/keu/';
			if (!EmptyValue($this->keuangan->Upload->DbValue)) {
				$this->keuangan->HrefValue = GetFileUploadUrl($this->keuangan, $this->keuangan->htmlDecode($this->keuangan->Upload->DbValue)); // Add prefix/suffix
				$this->keuangan->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport())
					$this->keuangan->HrefValue = FullUrl($this->keuangan->HrefValue, "href");
			} else {
				$this->keuangan->HrefValue = "";
			}
			$this->keuangan->ExportHrefValue = $this->keuangan->UploadPath . $this->keuangan->Upload->DbValue;
			$this->keuangan->TooltipValue = "";

			// pendukung
			$this->pendukung->LinkCustomAttributes = "";
			$this->pendukung->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/pendukung/';
			if (!EmptyValue($this->pendukung->Upload->DbValue)) {
				$this->pendukung->HrefValue = GetFileUploadUrl($this->pendukung, $this->pendukung->htmlDecode($this->pendukung->Upload->DbValue)); // Add prefix/suffix
				$this->pendukung->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport())
					$this->pendukung->HrefValue = FullUrl($this->pendukung->HrefValue, "href");
			} else {
				$this->pendukung->HrefValue = "";
			}
			$this->pendukung->ExportHrefValue = $this->pendukung->UploadPath . $this->pendukung->Upload->DbValue;
			$this->pendukung->TooltipValue = "";

			// lainlain
			$this->lainlain->LinkCustomAttributes = "";
			$this->lainlain->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/lainlain/';
			if (!EmptyValue($this->lainlain->Upload->DbValue)) {
				$this->lainlain->HrefValue = GetFileUploadUrl($this->lainlain, $this->lainlain->htmlDecode($this->lainlain->Upload->DbValue)); // Add prefix/suffix
				$this->lainlain->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport())
					$this->lainlain->HrefValue = FullUrl($this->lainlain->HrefValue, "href");
			} else {
				$this->lainlain->HrefValue = "";
			}
			$this->lainlain->ExportHrefValue = $this->lainlain->UploadPath . $this->lainlain->Upload->DbValue;
			$this->lainlain->TooltipValue = "";
		}

		// Call Row Rendered event
		if ($this->RowType != ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Delete records based on current filter
	protected function deleteRows()
	{
		global $Language, $Security;
		if (!$Security->canDelete()) {
			$this->setFailureMessage($Language->phrase("NoDeletePermission")); // No delete permission
			return FALSE;
		}
		$deleteRows = TRUE;
		$sql = $this->getCurrentSql();
		$conn = $this->getConnection();
		$conn->raiseErrorFn = Config("ERROR_FUNC");
		$rs = $conn->execute($sql);
		$conn->raiseErrorFn = "";
		if ($rs === FALSE) {
			return FALSE;
		} elseif ($rs->EOF) {
			$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
			$rs->close();
			return FALSE;
		}
		$rows = ($rs) ? $rs->getRows() : [];
		$conn->beginTrans();

		// Clone old rows
		$rsold = $rows;
		if ($rs)
			$rs->close();

		// Call row deleting event
		if ($deleteRows) {
			foreach ($rsold as $row) {
				$deleteRows = $this->Row_Deleting($row);
				if (!$deleteRows)
					break;
			}
		}
		if ($deleteRows) {
			$key = "";
			foreach ($rsold as $row) {
				$thisKey = "";
				if ($thisKey != "")
					$thisKey .= Config("COMPOSITE_KEY_SEPARATOR");
				$thisKey .= $row['Nim'];
				if (Config("DELETE_UPLOADED_FILES")) // Delete old files
					$this->deleteUploadedFiles($row);
				$conn->raiseErrorFn = Config("ERROR_FUNC");
				$deleteRows = $this->delete($row); // Delete
				$conn->raiseErrorFn = "";
				if ($deleteRows === FALSE)
					break;
				if ($key != "")
					$key .= ", ";
				$key .= $thisKey;
			}
		}
		if (!$deleteRows) {

			// Set up error message
			if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage != "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->phrase("DeleteCancelled"));
			}
		}
		if ($deleteRows) {
			$conn->commitTrans(); // Commit the changes
		} else {
			$conn->rollbackTrans(); // Rollback changes
		}

		// Call Row Deleted event
		if ($deleteRows) {
			foreach ($rsold as $row) {
				$this->Row_Deleted($row);
			}
		}

		// Write JSON for API request (Support single row only)
		if (IsApi() && $deleteRows) {
			$row = $this->getRecordsFromRecordset($rsold, TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $deleteRows;
	}

	// Set up master/detail based on QueryString
	protected function setupMasterParms()
	{
		$validMaster = FALSE;

		// Get the keys for master table
		if (($master = Get(Config("TABLE_SHOW_MASTER"), Get(Config("TABLE_MASTER")))) !== NULL) {
			$masterTblVar = $master;
			if ($masterTblVar == "") {
				$validMaster = TRUE;
				$this->DbMasterFilter = "";
				$this->DbDetailFilter = "";
			}
			if ($masterTblVar == "ekpt_mhsfeed") {
				$validMaster = TRUE;
				if (($parm = Get("fk_Nim", Get("Nim"))) !== NULL) {
					$GLOBALS["ekpt_mhsfeed"]->Nim->setQueryStringValue($parm);
					$this->Nim->setQueryStringValue($GLOBALS["ekpt_mhsfeed"]->Nim->QueryStringValue);
					$this->Nim->setSessionValue($this->Nim->QueryStringValue);
				} else {
					$validMaster = FALSE;
				}
			}
			if ($masterTblVar == "IM_Lulusan") {
				$validMaster = TRUE;
				if (($parm = Get("fk_NIM", Get("Nim"))) !== NULL) {
					$GLOBALS["IM_Lulusan"]->NIM->setQueryStringValue($parm);
					$this->Nim->setQueryStringValue($GLOBALS["IM_Lulusan"]->NIM->QueryStringValue);
					$this->Nim->setSessionValue($this->Nim->QueryStringValue);
				} else {
					$validMaster = FALSE;
				}
			}
			if ($masterTblVar == "IM_Mhs") {
				$validMaster = TRUE;
				if (($parm = Get("fk_Nim", Get("Nim"))) !== NULL) {
					$GLOBALS["IM_Mhs"]->Nim->setQueryStringValue($parm);
					$this->Nim->setQueryStringValue($GLOBALS["IM_Mhs"]->Nim->QueryStringValue);
					$this->Nim->setSessionValue($this->Nim->QueryStringValue);
				} else {
					$validMaster = FALSE;
				}
			}
		} elseif (($master = Post(Config("TABLE_SHOW_MASTER"), Post(Config("TABLE_MASTER")))) !== NULL) {
			$masterTblVar = $master;
			if ($masterTblVar == "") {
				$validMaster = TRUE;
				$this->DbMasterFilter = "";
				$this->DbDetailFilter = "";
			}
			if ($masterTblVar == "ekpt_mhsfeed") {
				$validMaster = TRUE;
				if (($parm = Post("fk_Nim", Post("Nim"))) !== NULL) {
					$GLOBALS["ekpt_mhsfeed"]->Nim->setFormValue($parm);
					$this->Nim->setFormValue($GLOBALS["ekpt_mhsfeed"]->Nim->FormValue);
					$this->Nim->setSessionValue($this->Nim->FormValue);
				} else {
					$validMaster = FALSE;
				}
			}
			if ($masterTblVar == "IM_Lulusan") {
				$validMaster = TRUE;
				if (($parm = Post("fk_NIM", Post("Nim"))) !== NULL) {
					$GLOBALS["IM_Lulusan"]->NIM->setFormValue($parm);
					$this->Nim->setFormValue($GLOBALS["IM_Lulusan"]->NIM->FormValue);
					$this->Nim->setSessionValue($this->Nim->FormValue);
				} else {
					$validMaster = FALSE;
				}
			}
			if ($masterTblVar == "IM_Mhs") {
				$validMaster = TRUE;
				if (($parm = Post("fk_Nim", Post("Nim"))) !== NULL) {
					$GLOBALS["IM_Mhs"]->Nim->setFormValue($parm);
					$this->Nim->setFormValue($GLOBALS["IM_Mhs"]->Nim->FormValue);
					$this->Nim->setSessionValue($this->Nim->FormValue);
				} else {
					$validMaster = FALSE;
				}
			}
		}
		if ($validMaster) {

			// Save current master table
			$this->setCurrentMasterTable($masterTblVar);

			// Reset start record counter (new master key)
			if (!$this->isAddOrEdit()) {
				$this->StartRecord = 1;
				$this->setStartRecordNumber($this->StartRecord);
			}

			// Clear previous master key from Session
			if ($masterTblVar != "ekpt_mhsfeed") {
				if ($this->Nim->CurrentValue == "")
					$this->Nim->setSessionValue("");
			}
			if ($masterTblVar != "IM_Lulusan") {
				if ($this->Nim->CurrentValue == "")
					$this->Nim->setSessionValue("");
			}
			if ($masterTblVar != "IM_Mhs") {
				if ($this->Nim->CurrentValue == "")
					$this->Nim->setSessionValue("");
			}
		}
		$this->DbMasterFilter = $this->getMasterFilter(); // Get master filter
		$this->DbDetailFilter = $this->getDetailFilter(); // Get detail filter
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("docmhslist.php"), "", $this->TableVar, TRUE);
		$pageId = "delete";
		$Breadcrumb->add("delete", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// Get default connection and filter
			$conn = $this->getConnection();
			$lookupFilter = "";

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL and connection
			switch ($fld->FieldVar) {
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0) {
				$totalCnt = $this->getRecordCount($sql, $conn);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}
} // End class
?>