<?php
namespace PHPMaker2020\baak;

/**
 * Page class
 */
class docmhs_edit extends docmhs
{

	// Page ID
	public $PageID = "edit";

	// Project ID
	public $ProjectID = "{A09D3AFF-419C-4918-948A-A3C8469EA234}";

	// Table name
	public $TableName = 'docmhs';

	// Page object name
	public $PageObjName = "docmhs_edit";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken;

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading != "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading != "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		$url = CurrentPageName() . "?";
		if ($this->UseTokenInUrl)
			$url .= "t=" . $this->TableVar . "&"; // Add page token
		return $url;
	}

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = TRUE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message != "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fas fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage != "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fas fa-exclamation"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage != "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fas fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage != "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fas fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = [];

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message != "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage != "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage != "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage != "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header != "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer != "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(Config("TOKEN_NAME")) === NULL)
			return FALSE;
		$fn = Config("CHECK_TOKEN_FUNC");
		if (is_callable($fn))
			return $fn(Post(Config("TOKEN_NAME")), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = Config("CREATE_TOKEN_FUNC"); // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $DashboardReport;
		global $UserTable;

		// Check token
		$this->CheckToken = Config("CHECK_TOKEN");

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (docmhs)
		if (!isset($GLOBALS["docmhs"]) || get_class($GLOBALS["docmhs"]) == PROJECT_NAMESPACE . "docmhs") {
			$GLOBALS["docmhs"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["docmhs"];
		}

		// Table object (Pass)
		if (!isset($GLOBALS['Pass']))
			$GLOBALS['Pass'] = new Pass();

		// Table object (IM_Lulusan)
		if (!isset($GLOBALS['IM_Lulusan']))
			$GLOBALS['IM_Lulusan'] = new IM_Lulusan();

		// Table object (IM_Mhs)
		if (!isset($GLOBALS['IM_Mhs']))
			$GLOBALS['IM_Mhs'] = new IM_Mhs();

		// Table object (ekpt_mhsfeed)
		if (!isset($GLOBALS['ekpt_mhsfeed']))
			$GLOBALS['ekpt_mhsfeed'] = new ekpt_mhsfeed();

		// Page ID (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'edit');

		// Table name (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'docmhs');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = $this->getConnection();

		// User table object (Pass)
		$UserTable = $UserTable ?: new Pass();
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages, $DashboardReport;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $docmhs;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, Config("EXPORT_CLASSES"))) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . Config("EXPORT_CLASSES." . $this->CustomExport);
			if (class_exists($class)) {
				$doc = new $class($docmhs);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url != "") {
			if (!Config("DEBUG") && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = ["url" => $url, "modal" => "1"];
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "docmhsview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = [];
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
		$this->Ijazah->OldUploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/';
		$this->Ijazah->UploadPath = $this->Ijazah->OldUploadPath;
		$this->Ktp->OldUploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/';
		$this->Ktp->UploadPath = $this->Ktp->OldUploadPath;
		$this->KK->OldUploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/';
		$this->KK->UploadPath = $this->KK->OldUploadPath;
		$this->tandatangan->OldUploadPath = '../../../../D:/www/im/mhs/views/uploads/';
		$this->tandatangan->UploadPath = $this->tandatangan->OldUploadPath;
		$this->IjazahIM->OldUploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/riwayat/';
		$this->IjazahIM->UploadPath = $this->IjazahIM->OldUploadPath;
		$this->TranskriptIM->OldUploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/riwayat/';
		$this->TranskriptIM->UploadPath = $this->TranskriptIM->OldUploadPath;
		$this->Skripsi->OldUploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/riwayat/';
		$this->Skripsi->UploadPath = $this->Skripsi->OldUploadPath;
		$this->Plagiat->OldUploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/riwayat/';
		$this->Plagiat->UploadPath = $this->Plagiat->OldUploadPath;
		$this->riwayatakademik->OldUploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/riwayat/';
		$this->riwayatakademik->UploadPath = $this->riwayatakademik->OldUploadPath;
		$this->keuangan->OldUploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/keu/';
		$this->keuangan->UploadPath = $this->keuangan->OldUploadPath;
		$this->pendukung->OldUploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/pendukung/';
		$this->pendukung->UploadPath = $this->pendukung->OldUploadPath;
		$this->lainlain->OldUploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/lainlain/';
		$this->lainlain->UploadPath = $this->lainlain->OldUploadPath;
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = [];
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {
								$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
									Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
									Config("API_FIELD_NAME") . "=" . $fld->Param . "&" .
									Config("API_KEY_NAME") . "=" . rawurlencode($this->getRecordKeyValue($ar)))); //*** need to add this? API may not be in the same folder
								$row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
								$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
									Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
									"fn=" . Encrypt($fld->physicalUploadPath() . $val)));
								$row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
							} else { // Multiple files
								$files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
								$ar = [];
								foreach ($files as $file) {
									$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
										Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
										"fn=" . Encrypt($fld->physicalUploadPath() . $file)));
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['Nim'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
	}

	// Lookup data
	public function lookup()
	{
		global $Language, $Security;
		if (!isset($Language))
			$Language = new Language(Config("LANGUAGE_FOLDER"), Post("language", ""));

		// Set up API request
		if (!ValidApiRequest())
			return FALSE;
		$this->setupApiSecurity();

		// Get lookup object
		$fieldName = Post("field");
		if (!array_key_exists($fieldName, $this->fields))
			return FALSE;
		$lookupField = $this->fields[$fieldName];
		$lookup = $lookupField->Lookup;
		if ($lookup === NULL)
			return FALSE;
		$tbl = $lookup->getTable();
		if (!$Security->allowLookup(Config("PROJECT_ID") . $tbl->TableName)) // Lookup permission
			return FALSE;

		// Get lookup parameters
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Param("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
			$lookup->FilterFields = []; // Skip parent fields if any
			$lookup->FilterValues[] = $keys; // Lookup values
			$pageSize = -1; // Show all records
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect != "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter != "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy != "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson($this); // Use settings from current page
	}

	// Set up API security
	public function setupApiSecurity()
	{
		global $Security;

		// Setup security for API request
		if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
		$Security->loadCurrentUserLevel(Config("PROJECT_ID") . $this->TableName);
		if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
	}
	public $FormClassName = "ew-horizontal ew-form ew-edit-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $DbMasterFilter;
	public $DbDetailFilter;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		if (ValidApiRequest()) { // API request
			$this->setupApiSecurity(); // Set up API Security
			if (!$Security->canEdit()) {
				SetStatus(401); // Unauthorized
				return;
			}
		} else {
			$Security = new AdvancedSecurity();
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canEdit()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("docmhslist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->Nim->setVisibility();
		$this->Ijazah->setVisibility();
		$this->Ktp->setVisibility();
		$this->KK->setVisibility();
		$this->tandatangan->Visible = FALSE;
		$this->IjazahIM->setVisibility();
		$this->TranskriptIM->setVisibility();
		$this->Skripsi->setVisibility();
		$this->Plagiat->setVisibility();
		$this->riwayatakademik->setVisibility();
		$this->keuangan->setVisibility();
		$this->pendukung->setVisibility();
		$this->lainlain->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		// Check permission

		if (!$Security->canEdit()) {
			$this->setFailureMessage(DeniedMessage()); // No permission
			$this->terminate("docmhslist.php");
			return;
		}

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-edit-form ew-horizontal";
		$loaded = FALSE;
		$postBack = FALSE;

		// Set up current action and primary key
		if (IsApi()) {

			// Load key values
			$loaded = TRUE;
			if (Get("Nim") !== NULL) {
				$this->Nim->setQueryStringValue(Get("Nim"));
				$this->Nim->setOldValue($this->Nim->QueryStringValue);
			} elseif (Key(0) !== NULL) {
				$this->Nim->setQueryStringValue(Key(0));
				$this->Nim->setOldValue($this->Nim->QueryStringValue);
			} elseif (Post("Nim") !== NULL) {
				$this->Nim->setFormValue(Post("Nim"));
				$this->Nim->setOldValue($this->Nim->FormValue);
			} elseif (Route(2) !== NULL) {
				$this->Nim->setQueryStringValue(Route(2));
				$this->Nim->setOldValue($this->Nim->QueryStringValue);
			} else {
				$loaded = FALSE; // Unable to load key
			}

			// Load record
			if ($loaded)
				$loaded = $this->loadRow();
			if (!$loaded) {
				$this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
				$this->terminate();
				return;
			}
			$this->CurrentAction = "update"; // Update record directly
			$postBack = TRUE;
		} else {
			if (Post("action") !== NULL) {
				$this->CurrentAction = Post("action"); // Get action code
				if (!$this->isShow()) // Not reload record, handle as postback
					$postBack = TRUE;

				// Load key from Form
				if ($CurrentForm->hasValue("x_Nim")) {
					$this->Nim->setFormValue($CurrentForm->getValue("x_Nim"));
				}
			} else {
				$this->CurrentAction = "show"; // Default action is display

				// Load key from QueryString / Route
				$loadByQuery = FALSE;
				if (Get("Nim") !== NULL) {
					$this->Nim->setQueryStringValue(Get("Nim"));
					$loadByQuery = TRUE;
				} elseif (Route(2) !== NULL) {
					$this->Nim->setQueryStringValue(Route(2));
					$loadByQuery = TRUE;
				} else {
					$this->Nim->CurrentValue = NULL;
				}
			}

			// Set up master detail parameters
			$this->setupMasterParms();

			// Load current record
			$loaded = $this->loadRow();
		}

		// Process form if post back
		if ($postBack) {
			$this->loadFormValues(); // Get form values
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->validateForm()) {
				$this->setFailureMessage($FormError);
				$this->EventCancelled = TRUE; // Event cancelled
				$this->restoreFormValues();
				if (IsApi()) {
					$this->terminate();
					return;
				} else {
					$this->CurrentAction = ""; // Form error, reset action
				}
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "show": // Get a record to display
				if (!$loaded) { // Load record based on key
					if ($this->getFailureMessage() == "")
						$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
					$this->terminate("docmhslist.php"); // No matching record, return to list
				}
				break;
			case "update": // Update
				$returnUrl = $this->getReturnUrl();
				if (GetPageName($returnUrl) == "docmhslist.php")
					$returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
				$this->SendEmail = TRUE; // Send email on update success
				if ($this->editRow()) { // Update record based on key
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Update success
					if (IsApi()) {
						$this->terminate(TRUE);
						return;
					} else {
						$this->terminate($returnUrl); // Return to caller
					}
				} elseif (IsApi()) { // API request, return
					$this->terminate();
					return;
				} elseif ($this->getFailureMessage() == $Language->phrase("NoRecord")) {
					$this->terminate($returnUrl); // Return to caller
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->restoreFormValues(); // Restore form values if update failed
				}
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Render the record
		$this->RowType = ROWTYPE_EDIT; // Render as Edit
		$this->resetAttributes();
		$this->renderRow();
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
		$this->Ijazah->Upload->Index = $CurrentForm->Index;
		$this->Ijazah->Upload->uploadFile();
		$this->Ijazah->CurrentValue = $this->Ijazah->Upload->FileName;
		$this->Ktp->Upload->Index = $CurrentForm->Index;
		$this->Ktp->Upload->uploadFile();
		$this->Ktp->CurrentValue = $this->Ktp->Upload->FileName;
		$this->KK->Upload->Index = $CurrentForm->Index;
		$this->KK->Upload->uploadFile();
		$this->KK->CurrentValue = $this->KK->Upload->FileName;
		$this->IjazahIM->Upload->Index = $CurrentForm->Index;
		$this->IjazahIM->Upload->uploadFile();
		$this->IjazahIM->CurrentValue = $this->IjazahIM->Upload->FileName;
		$this->TranskriptIM->Upload->Index = $CurrentForm->Index;
		$this->TranskriptIM->Upload->uploadFile();
		$this->TranskriptIM->CurrentValue = $this->TranskriptIM->Upload->FileName;
		$this->Skripsi->Upload->Index = $CurrentForm->Index;
		$this->Skripsi->Upload->uploadFile();
		$this->Skripsi->CurrentValue = $this->Skripsi->Upload->FileName;
		$this->Plagiat->Upload->Index = $CurrentForm->Index;
		$this->Plagiat->Upload->uploadFile();
		$this->Plagiat->CurrentValue = $this->Plagiat->Upload->FileName;
		$this->riwayatakademik->Upload->Index = $CurrentForm->Index;
		$this->riwayatakademik->Upload->uploadFile();
		$this->riwayatakademik->CurrentValue = $this->riwayatakademik->Upload->FileName;
		$this->keuangan->Upload->Index = $CurrentForm->Index;
		$this->keuangan->Upload->uploadFile();
		$this->keuangan->CurrentValue = $this->keuangan->Upload->FileName;
		$this->pendukung->Upload->Index = $CurrentForm->Index;
		$this->pendukung->Upload->uploadFile();
		$this->pendukung->CurrentValue = $this->pendukung->Upload->FileName;
		$this->lainlain->Upload->Index = $CurrentForm->Index;
		$this->lainlain->Upload->uploadFile();
		$this->lainlain->CurrentValue = $this->lainlain->Upload->FileName;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;

		// Check field name 'Nim' first before field var 'x_Nim'
		$val = $CurrentForm->hasValue("Nim") ? $CurrentForm->getValue("Nim") : $CurrentForm->getValue("x_Nim");
		if (!$this->Nim->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->Nim->Visible = FALSE; // Disable update for API request
			else
				$this->Nim->setFormValue($val);
		}
		if ($CurrentForm->hasValue("o_Nim"))
			$this->Nim->setOldValue($CurrentForm->getValue("o_Nim"));
		$this->Ijazah->OldUploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/';
		$this->Ijazah->UploadPath = $this->Ijazah->OldUploadPath;
		$this->Ktp->OldUploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/';
		$this->Ktp->UploadPath = $this->Ktp->OldUploadPath;
		$this->KK->OldUploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/';
		$this->KK->UploadPath = $this->KK->OldUploadPath;
		$this->tandatangan->OldUploadPath = '../../../../D:/www/im/mhs/views/uploads/';
		$this->tandatangan->UploadPath = $this->tandatangan->OldUploadPath;
		$this->IjazahIM->OldUploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/riwayat/';
		$this->IjazahIM->UploadPath = $this->IjazahIM->OldUploadPath;
		$this->TranskriptIM->OldUploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/riwayat/';
		$this->TranskriptIM->UploadPath = $this->TranskriptIM->OldUploadPath;
		$this->Skripsi->OldUploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/riwayat/';
		$this->Skripsi->UploadPath = $this->Skripsi->OldUploadPath;
		$this->Plagiat->OldUploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/riwayat/';
		$this->Plagiat->UploadPath = $this->Plagiat->OldUploadPath;
		$this->riwayatakademik->OldUploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/riwayat/';
		$this->riwayatakademik->UploadPath = $this->riwayatakademik->OldUploadPath;
		$this->keuangan->OldUploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/keu/';
		$this->keuangan->UploadPath = $this->keuangan->OldUploadPath;
		$this->pendukung->OldUploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/pendukung/';
		$this->pendukung->UploadPath = $this->pendukung->OldUploadPath;
		$this->lainlain->OldUploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/lainlain/';
		$this->lainlain->UploadPath = $this->lainlain->OldUploadPath;
		$this->getUploadFiles(); // Get upload files
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->Nim->CurrentValue = $this->Nim->FormValue;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = $this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->Nim->setDbValue($row['Nim']);
		$this->Ijazah->Upload->DbValue = $row['Ijazah'];
		$this->Ijazah->setDbValue($this->Ijazah->Upload->DbValue);
		$this->Ktp->Upload->DbValue = $row['Ktp'];
		$this->Ktp->setDbValue($this->Ktp->Upload->DbValue);
		$this->KK->Upload->DbValue = $row['KK'];
		$this->KK->setDbValue($this->KK->Upload->DbValue);
		$this->tandatangan->Upload->DbValue = $row['tandatangan'];
		$this->tandatangan->setDbValue($this->tandatangan->Upload->DbValue);
		$this->IjazahIM->Upload->DbValue = $row['IjazahIM'];
		$this->IjazahIM->setDbValue($this->IjazahIM->Upload->DbValue);
		$this->TranskriptIM->Upload->DbValue = $row['TranskriptIM'];
		$this->TranskriptIM->setDbValue($this->TranskriptIM->Upload->DbValue);
		$this->Skripsi->Upload->DbValue = $row['Skripsi'];
		$this->Skripsi->setDbValue($this->Skripsi->Upload->DbValue);
		$this->Plagiat->Upload->DbValue = $row['Plagiat'];
		$this->Plagiat->setDbValue($this->Plagiat->Upload->DbValue);
		$this->riwayatakademik->Upload->DbValue = $row['riwayatakademik'];
		$this->riwayatakademik->setDbValue($this->riwayatakademik->Upload->DbValue);
		$this->keuangan->Upload->DbValue = $row['keuangan'];
		$this->keuangan->setDbValue($this->keuangan->Upload->DbValue);
		$this->pendukung->Upload->DbValue = $row['pendukung'];
		$this->pendukung->setDbValue($this->pendukung->Upload->DbValue);
		$this->lainlain->Upload->DbValue = $row['lainlain'];
		$this->lainlain->setDbValue($this->lainlain->Upload->DbValue);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['Nim'] = NULL;
		$row['Ijazah'] = NULL;
		$row['Ktp'] = NULL;
		$row['KK'] = NULL;
		$row['tandatangan'] = NULL;
		$row['IjazahIM'] = NULL;
		$row['TranskriptIM'] = NULL;
		$row['Skripsi'] = NULL;
		$row['Plagiat'] = NULL;
		$row['riwayatakademik'] = NULL;
		$row['keuangan'] = NULL;
		$row['pendukung'] = NULL;
		$row['lainlain'] = NULL;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("Nim")) != "")
			$this->Nim->OldValue = $this->getKey("Nim"); // Nim
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = $this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Call Row_Rendering event

		$this->Row_Rendering();

		// Common render codes for all row types
		// Nim
		// Ijazah
		// Ktp
		// KK
		// tandatangan
		// IjazahIM
		// TranskriptIM
		// Skripsi
		// Plagiat
		// riwayatakademik
		// keuangan
		// pendukung
		// lainlain

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// Nim
			$this->Nim->ViewValue = $this->Nim->CurrentValue;
			$this->Nim->ViewCustomAttributes = "";

			// Ijazah
			$this->Ijazah->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/';
			if (!EmptyValue($this->Ijazah->Upload->DbValue)) {
				$this->Ijazah->ViewValue = $this->Ijazah->Upload->DbValue;
			} else {
				$this->Ijazah->ViewValue = "";
			}
			$this->Ijazah->ViewCustomAttributes = "";

			// Ktp
			$this->Ktp->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/';
			if (!EmptyValue($this->Ktp->Upload->DbValue)) {
				$this->Ktp->ViewValue = $this->Ktp->Upload->DbValue;
			} else {
				$this->Ktp->ViewValue = "";
			}
			$this->Ktp->ViewCustomAttributes = "";

			// KK
			$this->KK->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/';
			if (!EmptyValue($this->KK->Upload->DbValue)) {
				$this->KK->ViewValue = $this->KK->Upload->DbValue;
			} else {
				$this->KK->ViewValue = "";
			}
			$this->KK->ViewCustomAttributes = "";

			// tandatangan
			$this->tandatangan->UploadPath = '../../../../D:/www/im/mhs/views/uploads/';
			if (!EmptyValue($this->tandatangan->Upload->DbValue)) {
				$this->tandatangan->ViewValue = $this->tandatangan->Upload->DbValue;
			} else {
				$this->tandatangan->ViewValue = "";
			}
			$this->tandatangan->ViewCustomAttributes = "";

			// IjazahIM
			$this->IjazahIM->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/riwayat/';
			if (!EmptyValue($this->IjazahIM->Upload->DbValue)) {
				$this->IjazahIM->ViewValue = $this->IjazahIM->Upload->DbValue;
			} else {
				$this->IjazahIM->ViewValue = "";
			}
			$this->IjazahIM->ViewCustomAttributes = "";

			// TranskriptIM
			$this->TranskriptIM->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/riwayat/';
			if (!EmptyValue($this->TranskriptIM->Upload->DbValue)) {
				$this->TranskriptIM->ViewValue = $this->TranskriptIM->Upload->DbValue;
			} else {
				$this->TranskriptIM->ViewValue = "";
			}
			$this->TranskriptIM->ViewCustomAttributes = "";

			// Skripsi
			$this->Skripsi->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/riwayat/';
			if (!EmptyValue($this->Skripsi->Upload->DbValue)) {
				$this->Skripsi->ViewValue = $this->Skripsi->Upload->DbValue;
			} else {
				$this->Skripsi->ViewValue = "";
			}
			$this->Skripsi->ViewCustomAttributes = "";

			// Plagiat
			$this->Plagiat->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/riwayat/';
			if (!EmptyValue($this->Plagiat->Upload->DbValue)) {
				$this->Plagiat->ViewValue = $this->Plagiat->Upload->DbValue;
			} else {
				$this->Plagiat->ViewValue = "";
			}
			$this->Plagiat->ViewCustomAttributes = "";

			// riwayatakademik
			$this->riwayatakademik->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/riwayat/';
			if (!EmptyValue($this->riwayatakademik->Upload->DbValue)) {
				$this->riwayatakademik->ViewValue = $this->riwayatakademik->Upload->DbValue;
			} else {
				$this->riwayatakademik->ViewValue = "";
			}
			$this->riwayatakademik->ViewCustomAttributes = "";

			// keuangan
			$this->keuangan->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/keu/';
			if (!EmptyValue($this->keuangan->Upload->DbValue)) {
				$this->keuangan->ViewValue = $this->keuangan->Upload->DbValue;
			} else {
				$this->keuangan->ViewValue = "";
			}
			$this->keuangan->ViewCustomAttributes = "";

			// pendukung
			$this->pendukung->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/pendukung/';
			if (!EmptyValue($this->pendukung->Upload->DbValue)) {
				$this->pendukung->ViewValue = $this->pendukung->Upload->DbValue;
			} else {
				$this->pendukung->ViewValue = "";
			}
			$this->pendukung->ViewCustomAttributes = "";

			// lainlain
			$this->lainlain->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/lainlain/';
			if (!EmptyValue($this->lainlain->Upload->DbValue)) {
				$this->lainlain->ViewValue = $this->lainlain->Upload->DbValue;
			} else {
				$this->lainlain->ViewValue = "";
			}
			$this->lainlain->ViewCustomAttributes = "";

			// Nim
			$this->Nim->LinkCustomAttributes = "";
			$this->Nim->HrefValue = "";
			$this->Nim->TooltipValue = "";

			// Ijazah
			$this->Ijazah->LinkCustomAttributes = "";
			$this->Ijazah->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/';
			if (!EmptyValue($this->Ijazah->Upload->DbValue)) {
				$this->Ijazah->HrefValue = GetFileUploadUrl($this->Ijazah, $this->Ijazah->htmlDecode($this->Ijazah->Upload->DbValue)); // Add prefix/suffix
				$this->Ijazah->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport())
					$this->Ijazah->HrefValue = FullUrl($this->Ijazah->HrefValue, "href");
			} else {
				$this->Ijazah->HrefValue = "";
			}
			$this->Ijazah->ExportHrefValue = $this->Ijazah->UploadPath . $this->Ijazah->Upload->DbValue;
			$this->Ijazah->TooltipValue = "";

			// Ktp
			$this->Ktp->LinkCustomAttributes = "";
			$this->Ktp->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/';
			if (!EmptyValue($this->Ktp->Upload->DbValue)) {
				$this->Ktp->HrefValue = GetFileUploadUrl($this->Ktp, $this->Ktp->htmlDecode($this->Ktp->Upload->DbValue)); // Add prefix/suffix
				$this->Ktp->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport())
					$this->Ktp->HrefValue = FullUrl($this->Ktp->HrefValue, "href");
			} else {
				$this->Ktp->HrefValue = "";
			}
			$this->Ktp->ExportHrefValue = $this->Ktp->UploadPath . $this->Ktp->Upload->DbValue;
			$this->Ktp->TooltipValue = "";

			// KK
			$this->KK->LinkCustomAttributes = "";
			$this->KK->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/';
			if (!EmptyValue($this->KK->Upload->DbValue)) {
				$this->KK->HrefValue = GetFileUploadUrl($this->KK, $this->KK->htmlDecode($this->KK->Upload->DbValue)); // Add prefix/suffix
				$this->KK->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport())
					$this->KK->HrefValue = FullUrl($this->KK->HrefValue, "href");
			} else {
				$this->KK->HrefValue = "";
			}
			$this->KK->ExportHrefValue = $this->KK->UploadPath . $this->KK->Upload->DbValue;
			$this->KK->TooltipValue = "";

			// IjazahIM
			$this->IjazahIM->LinkCustomAttributes = "";
			$this->IjazahIM->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/riwayat/';
			if (!EmptyValue($this->IjazahIM->Upload->DbValue)) {
				$this->IjazahIM->HrefValue = GetFileUploadUrl($this->IjazahIM, $this->IjazahIM->htmlDecode($this->IjazahIM->Upload->DbValue)); // Add prefix/suffix
				$this->IjazahIM->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport())
					$this->IjazahIM->HrefValue = FullUrl($this->IjazahIM->HrefValue, "href");
			} else {
				$this->IjazahIM->HrefValue = "";
			}
			$this->IjazahIM->ExportHrefValue = $this->IjazahIM->UploadPath . $this->IjazahIM->Upload->DbValue;
			$this->IjazahIM->TooltipValue = "";

			// TranskriptIM
			$this->TranskriptIM->LinkCustomAttributes = "";
			$this->TranskriptIM->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/riwayat/';
			if (!EmptyValue($this->TranskriptIM->Upload->DbValue)) {
				$this->TranskriptIM->HrefValue = GetFileUploadUrl($this->TranskriptIM, $this->TranskriptIM->htmlDecode($this->TranskriptIM->Upload->DbValue)); // Add prefix/suffix
				$this->TranskriptIM->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport())
					$this->TranskriptIM->HrefValue = FullUrl($this->TranskriptIM->HrefValue, "href");
			} else {
				$this->TranskriptIM->HrefValue = "";
			}
			$this->TranskriptIM->ExportHrefValue = $this->TranskriptIM->UploadPath . $this->TranskriptIM->Upload->DbValue;
			$this->TranskriptIM->TooltipValue = "";

			// Skripsi
			$this->Skripsi->LinkCustomAttributes = "";
			$this->Skripsi->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/riwayat/';
			if (!EmptyValue($this->Skripsi->Upload->DbValue)) {
				$this->Skripsi->HrefValue = GetFileUploadUrl($this->Skripsi, $this->Skripsi->htmlDecode($this->Skripsi->Upload->DbValue)); // Add prefix/suffix
				$this->Skripsi->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport())
					$this->Skripsi->HrefValue = FullUrl($this->Skripsi->HrefValue, "href");
			} else {
				$this->Skripsi->HrefValue = "";
			}
			$this->Skripsi->ExportHrefValue = $this->Skripsi->UploadPath . $this->Skripsi->Upload->DbValue;
			$this->Skripsi->TooltipValue = "";

			// Plagiat
			$this->Plagiat->LinkCustomAttributes = "";
			$this->Plagiat->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/riwayat/';
			if (!EmptyValue($this->Plagiat->Upload->DbValue)) {
				$this->Plagiat->HrefValue = GetFileUploadUrl($this->Plagiat, $this->Plagiat->htmlDecode($this->Plagiat->Upload->DbValue)); // Add prefix/suffix
				$this->Plagiat->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport())
					$this->Plagiat->HrefValue = FullUrl($this->Plagiat->HrefValue, "href");
			} else {
				$this->Plagiat->HrefValue = "";
			}
			$this->Plagiat->ExportHrefValue = $this->Plagiat->UploadPath . $this->Plagiat->Upload->DbValue;
			$this->Plagiat->TooltipValue = "";

			// riwayatakademik
			$this->riwayatakademik->LinkCustomAttributes = "";
			$this->riwayatakademik->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/riwayat/';
			if (!EmptyValue($this->riwayatakademik->Upload->DbValue)) {
				$this->riwayatakademik->HrefValue = GetFileUploadUrl($this->riwayatakademik, $this->riwayatakademik->htmlDecode($this->riwayatakademik->Upload->DbValue)); // Add prefix/suffix
				$this->riwayatakademik->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport())
					$this->riwayatakademik->HrefValue = FullUrl($this->riwayatakademik->HrefValue, "href");
			} else {
				$this->riwayatakademik->HrefValue = "";
			}
			$this->riwayatakademik->ExportHrefValue = $this->riwayatakademik->UploadPath . $this->riwayatakademik->Upload->DbValue;
			$this->riwayatakademik->TooltipValue = "";

			// keuangan
			$this->keuangan->LinkCustomAttributes = "";
			$this->keuangan->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/keu/';
			if (!EmptyValue($this->keuangan->Upload->DbValue)) {
				$this->keuangan->HrefValue = GetFileUploadUrl($this->keuangan, $this->keuangan->htmlDecode($this->keuangan->Upload->DbValue)); // Add prefix/suffix
				$this->keuangan->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport())
					$this->keuangan->HrefValue = FullUrl($this->keuangan->HrefValue, "href");
			} else {
				$this->keuangan->HrefValue = "";
			}
			$this->keuangan->ExportHrefValue = $this->keuangan->UploadPath . $this->keuangan->Upload->DbValue;
			$this->keuangan->TooltipValue = "";

			// pendukung
			$this->pendukung->LinkCustomAttributes = "";
			$this->pendukung->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/pendukung/';
			if (!EmptyValue($this->pendukung->Upload->DbValue)) {
				$this->pendukung->HrefValue = GetFileUploadUrl($this->pendukung, $this->pendukung->htmlDecode($this->pendukung->Upload->DbValue)); // Add prefix/suffix
				$this->pendukung->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport())
					$this->pendukung->HrefValue = FullUrl($this->pendukung->HrefValue, "href");
			} else {
				$this->pendukung->HrefValue = "";
			}
			$this->pendukung->ExportHrefValue = $this->pendukung->UploadPath . $this->pendukung->Upload->DbValue;
			$this->pendukung->TooltipValue = "";

			// lainlain
			$this->lainlain->LinkCustomAttributes = "";
			$this->lainlain->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/lainlain/';
			if (!EmptyValue($this->lainlain->Upload->DbValue)) {
				$this->lainlain->HrefValue = GetFileUploadUrl($this->lainlain, $this->lainlain->htmlDecode($this->lainlain->Upload->DbValue)); // Add prefix/suffix
				$this->lainlain->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport())
					$this->lainlain->HrefValue = FullUrl($this->lainlain->HrefValue, "href");
			} else {
				$this->lainlain->HrefValue = "";
			}
			$this->lainlain->ExportHrefValue = $this->lainlain->UploadPath . $this->lainlain->Upload->DbValue;
			$this->lainlain->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_EDIT) { // Edit row

			// Nim
			$this->Nim->EditAttrs["class"] = "form-control";
			$this->Nim->EditCustomAttributes = "";
			if (!$this->Nim->Raw)
				$this->Nim->CurrentValue = HtmlDecode($this->Nim->CurrentValue);
			$this->Nim->EditValue = HtmlEncode($this->Nim->CurrentValue);
			$this->Nim->PlaceHolder = RemoveHtml($this->Nim->caption());

			// Ijazah
			$this->Ijazah->EditAttrs["class"] = "form-control";
			$this->Ijazah->EditCustomAttributes = "";
			$this->Ijazah->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/';
			if (!EmptyValue($this->Ijazah->Upload->DbValue)) {
				$this->Ijazah->EditValue = $this->Ijazah->Upload->DbValue;
			} else {
				$this->Ijazah->EditValue = "";
			}
			if (!EmptyValue($this->Ijazah->CurrentValue))
					$this->Ijazah->Upload->FileName = $this->Ijazah->CurrentValue;
			if ($this->isShow())
				RenderUploadField($this->Ijazah);

			// Ktp
			$this->Ktp->EditAttrs["class"] = "form-control";
			$this->Ktp->EditCustomAttributes = "";
			$this->Ktp->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/';
			if (!EmptyValue($this->Ktp->Upload->DbValue)) {
				$this->Ktp->EditValue = $this->Ktp->Upload->DbValue;
			} else {
				$this->Ktp->EditValue = "";
			}
			if (!EmptyValue($this->Ktp->CurrentValue))
					$this->Ktp->Upload->FileName = $this->Ktp->CurrentValue;
			if ($this->isShow())
				RenderUploadField($this->Ktp);

			// KK
			$this->KK->EditAttrs["class"] = "form-control";
			$this->KK->EditCustomAttributes = "";
			$this->KK->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/';
			if (!EmptyValue($this->KK->Upload->DbValue)) {
				$this->KK->EditValue = $this->KK->Upload->DbValue;
			} else {
				$this->KK->EditValue = "";
			}
			if (!EmptyValue($this->KK->CurrentValue))
					$this->KK->Upload->FileName = $this->KK->CurrentValue;
			if ($this->isShow())
				RenderUploadField($this->KK);

			// IjazahIM
			$this->IjazahIM->EditAttrs["class"] = "form-control";
			$this->IjazahIM->EditCustomAttributes = "";
			$this->IjazahIM->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/riwayat/';
			if (!EmptyValue($this->IjazahIM->Upload->DbValue)) {
				$this->IjazahIM->EditValue = $this->IjazahIM->Upload->DbValue;
			} else {
				$this->IjazahIM->EditValue = "";
			}
			if (!EmptyValue($this->IjazahIM->CurrentValue))
					$this->IjazahIM->Upload->FileName = $this->IjazahIM->CurrentValue;
			if ($this->isShow())
				RenderUploadField($this->IjazahIM);

			// TranskriptIM
			$this->TranskriptIM->EditAttrs["class"] = "form-control";
			$this->TranskriptIM->EditCustomAttributes = "";
			$this->TranskriptIM->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/riwayat/';
			if (!EmptyValue($this->TranskriptIM->Upload->DbValue)) {
				$this->TranskriptIM->EditValue = $this->TranskriptIM->Upload->DbValue;
			} else {
				$this->TranskriptIM->EditValue = "";
			}
			if (!EmptyValue($this->TranskriptIM->CurrentValue))
					$this->TranskriptIM->Upload->FileName = $this->TranskriptIM->CurrentValue;
			if ($this->isShow())
				RenderUploadField($this->TranskriptIM);

			// Skripsi
			$this->Skripsi->EditAttrs["class"] = "form-control";
			$this->Skripsi->EditCustomAttributes = "";
			$this->Skripsi->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/riwayat/';
			if (!EmptyValue($this->Skripsi->Upload->DbValue)) {
				$this->Skripsi->EditValue = $this->Skripsi->Upload->DbValue;
			} else {
				$this->Skripsi->EditValue = "";
			}
			if (!EmptyValue($this->Skripsi->CurrentValue))
					$this->Skripsi->Upload->FileName = $this->Skripsi->CurrentValue;
			if ($this->isShow())
				RenderUploadField($this->Skripsi);

			// Plagiat
			$this->Plagiat->EditAttrs["class"] = "form-control";
			$this->Plagiat->EditCustomAttributes = "";
			$this->Plagiat->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/riwayat/';
			if (!EmptyValue($this->Plagiat->Upload->DbValue)) {
				$this->Plagiat->EditValue = $this->Plagiat->Upload->DbValue;
			} else {
				$this->Plagiat->EditValue = "";
			}
			if (!EmptyValue($this->Plagiat->CurrentValue))
					$this->Plagiat->Upload->FileName = $this->Plagiat->CurrentValue;
			if ($this->isShow())
				RenderUploadField($this->Plagiat);

			// riwayatakademik
			$this->riwayatakademik->EditAttrs["class"] = "form-control";
			$this->riwayatakademik->EditCustomAttributes = "";
			$this->riwayatakademik->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/riwayat/';
			if (!EmptyValue($this->riwayatakademik->Upload->DbValue)) {
				$this->riwayatakademik->EditValue = $this->riwayatakademik->Upload->DbValue;
			} else {
				$this->riwayatakademik->EditValue = "";
			}
			if (!EmptyValue($this->riwayatakademik->CurrentValue))
					$this->riwayatakademik->Upload->FileName = $this->riwayatakademik->CurrentValue;
			if ($this->isShow())
				RenderUploadField($this->riwayatakademik);

			// keuangan
			$this->keuangan->EditAttrs["class"] = "form-control";
			$this->keuangan->EditCustomAttributes = "";
			$this->keuangan->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/keu/';
			if (!EmptyValue($this->keuangan->Upload->DbValue)) {
				$this->keuangan->EditValue = $this->keuangan->Upload->DbValue;
			} else {
				$this->keuangan->EditValue = "";
			}
			if (!EmptyValue($this->keuangan->CurrentValue))
					$this->keuangan->Upload->FileName = $this->keuangan->CurrentValue;
			if ($this->isShow())
				RenderUploadField($this->keuangan);

			// pendukung
			$this->pendukung->EditAttrs["class"] = "form-control";
			$this->pendukung->EditCustomAttributes = "";
			$this->pendukung->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/pendukung/';
			if (!EmptyValue($this->pendukung->Upload->DbValue)) {
				$this->pendukung->EditValue = $this->pendukung->Upload->DbValue;
			} else {
				$this->pendukung->EditValue = "";
			}
			if (!EmptyValue($this->pendukung->CurrentValue))
					$this->pendukung->Upload->FileName = $this->pendukung->CurrentValue;
			if ($this->isShow())
				RenderUploadField($this->pendukung);

			// lainlain
			$this->lainlain->EditAttrs["class"] = "form-control";
			$this->lainlain->EditCustomAttributes = "";
			$this->lainlain->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/lainlain/';
			if (!EmptyValue($this->lainlain->Upload->DbValue)) {
				$this->lainlain->EditValue = $this->lainlain->Upload->DbValue;
			} else {
				$this->lainlain->EditValue = "";
			}
			if (!EmptyValue($this->lainlain->CurrentValue))
					$this->lainlain->Upload->FileName = $this->lainlain->CurrentValue;
			if ($this->isShow())
				RenderUploadField($this->lainlain);

			// Edit refer script
			// Nim

			$this->Nim->LinkCustomAttributes = "";
			$this->Nim->HrefValue = "";

			// Ijazah
			$this->Ijazah->LinkCustomAttributes = "";
			$this->Ijazah->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/';
			if (!EmptyValue($this->Ijazah->Upload->DbValue)) {
				$this->Ijazah->HrefValue = GetFileUploadUrl($this->Ijazah, $this->Ijazah->htmlDecode($this->Ijazah->Upload->DbValue)); // Add prefix/suffix
				$this->Ijazah->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport())
					$this->Ijazah->HrefValue = FullUrl($this->Ijazah->HrefValue, "href");
			} else {
				$this->Ijazah->HrefValue = "";
			}
			$this->Ijazah->ExportHrefValue = $this->Ijazah->UploadPath . $this->Ijazah->Upload->DbValue;

			// Ktp
			$this->Ktp->LinkCustomAttributes = "";
			$this->Ktp->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/';
			if (!EmptyValue($this->Ktp->Upload->DbValue)) {
				$this->Ktp->HrefValue = GetFileUploadUrl($this->Ktp, $this->Ktp->htmlDecode($this->Ktp->Upload->DbValue)); // Add prefix/suffix
				$this->Ktp->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport())
					$this->Ktp->HrefValue = FullUrl($this->Ktp->HrefValue, "href");
			} else {
				$this->Ktp->HrefValue = "";
			}
			$this->Ktp->ExportHrefValue = $this->Ktp->UploadPath . $this->Ktp->Upload->DbValue;

			// KK
			$this->KK->LinkCustomAttributes = "";
			$this->KK->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/';
			if (!EmptyValue($this->KK->Upload->DbValue)) {
				$this->KK->HrefValue = GetFileUploadUrl($this->KK, $this->KK->htmlDecode($this->KK->Upload->DbValue)); // Add prefix/suffix
				$this->KK->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport())
					$this->KK->HrefValue = FullUrl($this->KK->HrefValue, "href");
			} else {
				$this->KK->HrefValue = "";
			}
			$this->KK->ExportHrefValue = $this->KK->UploadPath . $this->KK->Upload->DbValue;

			// IjazahIM
			$this->IjazahIM->LinkCustomAttributes = "";
			$this->IjazahIM->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/riwayat/';
			if (!EmptyValue($this->IjazahIM->Upload->DbValue)) {
				$this->IjazahIM->HrefValue = GetFileUploadUrl($this->IjazahIM, $this->IjazahIM->htmlDecode($this->IjazahIM->Upload->DbValue)); // Add prefix/suffix
				$this->IjazahIM->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport())
					$this->IjazahIM->HrefValue = FullUrl($this->IjazahIM->HrefValue, "href");
			} else {
				$this->IjazahIM->HrefValue = "";
			}
			$this->IjazahIM->ExportHrefValue = $this->IjazahIM->UploadPath . $this->IjazahIM->Upload->DbValue;

			// TranskriptIM
			$this->TranskriptIM->LinkCustomAttributes = "";
			$this->TranskriptIM->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/riwayat/';
			if (!EmptyValue($this->TranskriptIM->Upload->DbValue)) {
				$this->TranskriptIM->HrefValue = GetFileUploadUrl($this->TranskriptIM, $this->TranskriptIM->htmlDecode($this->TranskriptIM->Upload->DbValue)); // Add prefix/suffix
				$this->TranskriptIM->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport())
					$this->TranskriptIM->HrefValue = FullUrl($this->TranskriptIM->HrefValue, "href");
			} else {
				$this->TranskriptIM->HrefValue = "";
			}
			$this->TranskriptIM->ExportHrefValue = $this->TranskriptIM->UploadPath . $this->TranskriptIM->Upload->DbValue;

			// Skripsi
			$this->Skripsi->LinkCustomAttributes = "";
			$this->Skripsi->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/riwayat/';
			if (!EmptyValue($this->Skripsi->Upload->DbValue)) {
				$this->Skripsi->HrefValue = GetFileUploadUrl($this->Skripsi, $this->Skripsi->htmlDecode($this->Skripsi->Upload->DbValue)); // Add prefix/suffix
				$this->Skripsi->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport())
					$this->Skripsi->HrefValue = FullUrl($this->Skripsi->HrefValue, "href");
			} else {
				$this->Skripsi->HrefValue = "";
			}
			$this->Skripsi->ExportHrefValue = $this->Skripsi->UploadPath . $this->Skripsi->Upload->DbValue;

			// Plagiat
			$this->Plagiat->LinkCustomAttributes = "";
			$this->Plagiat->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/riwayat/';
			if (!EmptyValue($this->Plagiat->Upload->DbValue)) {
				$this->Plagiat->HrefValue = GetFileUploadUrl($this->Plagiat, $this->Plagiat->htmlDecode($this->Plagiat->Upload->DbValue)); // Add prefix/suffix
				$this->Plagiat->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport())
					$this->Plagiat->HrefValue = FullUrl($this->Plagiat->HrefValue, "href");
			} else {
				$this->Plagiat->HrefValue = "";
			}
			$this->Plagiat->ExportHrefValue = $this->Plagiat->UploadPath . $this->Plagiat->Upload->DbValue;

			// riwayatakademik
			$this->riwayatakademik->LinkCustomAttributes = "";
			$this->riwayatakademik->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/riwayat/';
			if (!EmptyValue($this->riwayatakademik->Upload->DbValue)) {
				$this->riwayatakademik->HrefValue = GetFileUploadUrl($this->riwayatakademik, $this->riwayatakademik->htmlDecode($this->riwayatakademik->Upload->DbValue)); // Add prefix/suffix
				$this->riwayatakademik->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport())
					$this->riwayatakademik->HrefValue = FullUrl($this->riwayatakademik->HrefValue, "href");
			} else {
				$this->riwayatakademik->HrefValue = "";
			}
			$this->riwayatakademik->ExportHrefValue = $this->riwayatakademik->UploadPath . $this->riwayatakademik->Upload->DbValue;

			// keuangan
			$this->keuangan->LinkCustomAttributes = "";
			$this->keuangan->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/keu/';
			if (!EmptyValue($this->keuangan->Upload->DbValue)) {
				$this->keuangan->HrefValue = GetFileUploadUrl($this->keuangan, $this->keuangan->htmlDecode($this->keuangan->Upload->DbValue)); // Add prefix/suffix
				$this->keuangan->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport())
					$this->keuangan->HrefValue = FullUrl($this->keuangan->HrefValue, "href");
			} else {
				$this->keuangan->HrefValue = "";
			}
			$this->keuangan->ExportHrefValue = $this->keuangan->UploadPath . $this->keuangan->Upload->DbValue;

			// pendukung
			$this->pendukung->LinkCustomAttributes = "";
			$this->pendukung->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/pendukung/';
			if (!EmptyValue($this->pendukung->Upload->DbValue)) {
				$this->pendukung->HrefValue = GetFileUploadUrl($this->pendukung, $this->pendukung->htmlDecode($this->pendukung->Upload->DbValue)); // Add prefix/suffix
				$this->pendukung->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport())
					$this->pendukung->HrefValue = FullUrl($this->pendukung->HrefValue, "href");
			} else {
				$this->pendukung->HrefValue = "";
			}
			$this->pendukung->ExportHrefValue = $this->pendukung->UploadPath . $this->pendukung->Upload->DbValue;

			// lainlain
			$this->lainlain->LinkCustomAttributes = "";
			$this->lainlain->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/lainlain/';
			if (!EmptyValue($this->lainlain->Upload->DbValue)) {
				$this->lainlain->HrefValue = GetFileUploadUrl($this->lainlain, $this->lainlain->htmlDecode($this->lainlain->Upload->DbValue)); // Add prefix/suffix
				$this->lainlain->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport())
					$this->lainlain->HrefValue = FullUrl($this->lainlain->HrefValue, "href");
			} else {
				$this->lainlain->HrefValue = "";
			}
			$this->lainlain->ExportHrefValue = $this->lainlain->UploadPath . $this->lainlain->Upload->DbValue;
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType != ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!Config("SERVER_VALIDATE"))
			return ($FormError == "");
		if ($this->Nim->Required) {
			if (!$this->Nim->IsDetailKey && $this->Nim->FormValue != NULL && $this->Nim->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Nim->caption(), $this->Nim->RequiredErrorMessage));
			}
		}
		if ($this->Ijazah->Required) {
			if ($this->Ijazah->Upload->FileName == "" && !$this->Ijazah->Upload->KeepFile) {
				AddMessage($FormError, str_replace("%s", $this->Ijazah->caption(), $this->Ijazah->RequiredErrorMessage));
			}
		}
		if ($this->Ktp->Required) {
			if ($this->Ktp->Upload->FileName == "" && !$this->Ktp->Upload->KeepFile) {
				AddMessage($FormError, str_replace("%s", $this->Ktp->caption(), $this->Ktp->RequiredErrorMessage));
			}
		}
		if ($this->KK->Required) {
			if ($this->KK->Upload->FileName == "" && !$this->KK->Upload->KeepFile) {
				AddMessage($FormError, str_replace("%s", $this->KK->caption(), $this->KK->RequiredErrorMessage));
			}
		}
		if ($this->IjazahIM->Required) {
			if ($this->IjazahIM->Upload->FileName == "" && !$this->IjazahIM->Upload->KeepFile) {
				AddMessage($FormError, str_replace("%s", $this->IjazahIM->caption(), $this->IjazahIM->RequiredErrorMessage));
			}
		}
		if ($this->TranskriptIM->Required) {
			if ($this->TranskriptIM->Upload->FileName == "" && !$this->TranskriptIM->Upload->KeepFile) {
				AddMessage($FormError, str_replace("%s", $this->TranskriptIM->caption(), $this->TranskriptIM->RequiredErrorMessage));
			}
		}
		if ($this->Skripsi->Required) {
			if ($this->Skripsi->Upload->FileName == "" && !$this->Skripsi->Upload->KeepFile) {
				AddMessage($FormError, str_replace("%s", $this->Skripsi->caption(), $this->Skripsi->RequiredErrorMessage));
			}
		}
		if ($this->Plagiat->Required) {
			if ($this->Plagiat->Upload->FileName == "" && !$this->Plagiat->Upload->KeepFile) {
				AddMessage($FormError, str_replace("%s", $this->Plagiat->caption(), $this->Plagiat->RequiredErrorMessage));
			}
		}
		if ($this->riwayatakademik->Required) {
			if ($this->riwayatakademik->Upload->FileName == "" && !$this->riwayatakademik->Upload->KeepFile) {
				AddMessage($FormError, str_replace("%s", $this->riwayatakademik->caption(), $this->riwayatakademik->RequiredErrorMessage));
			}
		}
		if ($this->keuangan->Required) {
			if ($this->keuangan->Upload->FileName == "" && !$this->keuangan->Upload->KeepFile) {
				AddMessage($FormError, str_replace("%s", $this->keuangan->caption(), $this->keuangan->RequiredErrorMessage));
			}
		}
		if ($this->pendukung->Required) {
			if ($this->pendukung->Upload->FileName == "" && !$this->pendukung->Upload->KeepFile) {
				AddMessage($FormError, str_replace("%s", $this->pendukung->caption(), $this->pendukung->RequiredErrorMessage));
			}
		}
		if ($this->lainlain->Required) {
			if ($this->lainlain->Upload->FileName == "" && !$this->lainlain->Upload->KeepFile) {
				AddMessage($FormError, str_replace("%s", $this->lainlain->caption(), $this->lainlain->RequiredErrorMessage));
			}
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError != "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Update record based on key values
	protected function editRow()
	{
		global $Security, $Language;
		$oldKeyFilter = $this->getRecordFilter();
		$filter = $this->applyUserIDFilters($oldKeyFilter);
		$conn = $this->getConnection();
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn->raiseErrorFn = Config("ERROR_FUNC");
		$rs = $conn->execute($sql);
		$conn->raiseErrorFn = "";
		if ($rs === FALSE)
			return FALSE;
		if ($rs->EOF) {
			$this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
			$editRow = FALSE; // Update Failed
		} else {

			// Save old values
			$rsold = &$rs->fields;
			$this->loadDbValues($rsold);
			$this->Ijazah->OldUploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/';
			$this->Ijazah->UploadPath = $this->Ijazah->OldUploadPath;
			$this->Ktp->OldUploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/';
			$this->Ktp->UploadPath = $this->Ktp->OldUploadPath;
			$this->KK->OldUploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/';
			$this->KK->UploadPath = $this->KK->OldUploadPath;
			$this->tandatangan->OldUploadPath = '../../../../D:/www/im/mhs/views/uploads/';
			$this->tandatangan->UploadPath = $this->tandatangan->OldUploadPath;
			$this->IjazahIM->OldUploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/riwayat/';
			$this->IjazahIM->UploadPath = $this->IjazahIM->OldUploadPath;
			$this->TranskriptIM->OldUploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/riwayat/';
			$this->TranskriptIM->UploadPath = $this->TranskriptIM->OldUploadPath;
			$this->Skripsi->OldUploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/riwayat/';
			$this->Skripsi->UploadPath = $this->Skripsi->OldUploadPath;
			$this->Plagiat->OldUploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/riwayat/';
			$this->Plagiat->UploadPath = $this->Plagiat->OldUploadPath;
			$this->riwayatakademik->OldUploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/riwayat/';
			$this->riwayatakademik->UploadPath = $this->riwayatakademik->OldUploadPath;
			$this->keuangan->OldUploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/keu/';
			$this->keuangan->UploadPath = $this->keuangan->OldUploadPath;
			$this->pendukung->OldUploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/pendukung/';
			$this->pendukung->UploadPath = $this->pendukung->OldUploadPath;
			$this->lainlain->OldUploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/lainlain/';
			$this->lainlain->UploadPath = $this->lainlain->OldUploadPath;
			$rsnew = [];

			// Nim
			$this->Nim->setDbValueDef($rsnew, $this->Nim->CurrentValue, "", $this->Nim->ReadOnly);

			// Ijazah
			if ($this->Ijazah->Visible && !$this->Ijazah->ReadOnly && !$this->Ijazah->Upload->KeepFile) {
				$this->Ijazah->Upload->DbValue = $rsold['Ijazah']; // Get original value
				if ($this->Ijazah->Upload->FileName == "") {
					$rsnew['Ijazah'] = NULL;
				} else {
					$rsnew['Ijazah'] = $this->Ijazah->Upload->FileName;
				}
			}

			// Ktp
			if ($this->Ktp->Visible && !$this->Ktp->ReadOnly && !$this->Ktp->Upload->KeepFile) {
				$this->Ktp->Upload->DbValue = $rsold['Ktp']; // Get original value
				if ($this->Ktp->Upload->FileName == "") {
					$rsnew['Ktp'] = NULL;
				} else {
					$rsnew['Ktp'] = $this->Ktp->Upload->FileName;
				}
			}

			// KK
			if ($this->KK->Visible && !$this->KK->ReadOnly && !$this->KK->Upload->KeepFile) {
				$this->KK->Upload->DbValue = $rsold['KK']; // Get original value
				if ($this->KK->Upload->FileName == "") {
					$rsnew['KK'] = NULL;
				} else {
					$rsnew['KK'] = $this->KK->Upload->FileName;
				}
			}

			// IjazahIM
			if ($this->IjazahIM->Visible && !$this->IjazahIM->ReadOnly && !$this->IjazahIM->Upload->KeepFile) {
				$this->IjazahIM->Upload->DbValue = $rsold['IjazahIM']; // Get original value
				if ($this->IjazahIM->Upload->FileName == "") {
					$rsnew['IjazahIM'] = NULL;
				} else {
					$rsnew['IjazahIM'] = $this->IjazahIM->Upload->FileName;
				}
			}

			// TranskriptIM
			if ($this->TranskriptIM->Visible && !$this->TranskriptIM->ReadOnly && !$this->TranskriptIM->Upload->KeepFile) {
				$this->TranskriptIM->Upload->DbValue = $rsold['TranskriptIM']; // Get original value
				if ($this->TranskriptIM->Upload->FileName == "") {
					$rsnew['TranskriptIM'] = NULL;
				} else {
					$rsnew['TranskriptIM'] = $this->TranskriptIM->Upload->FileName;
				}
			}

			// Skripsi
			if ($this->Skripsi->Visible && !$this->Skripsi->ReadOnly && !$this->Skripsi->Upload->KeepFile) {
				$this->Skripsi->Upload->DbValue = $rsold['Skripsi']; // Get original value
				if ($this->Skripsi->Upload->FileName == "") {
					$rsnew['Skripsi'] = NULL;
				} else {
					$rsnew['Skripsi'] = $this->Skripsi->Upload->FileName;
				}
			}

			// Plagiat
			if ($this->Plagiat->Visible && !$this->Plagiat->ReadOnly && !$this->Plagiat->Upload->KeepFile) {
				$this->Plagiat->Upload->DbValue = $rsold['Plagiat']; // Get original value
				if ($this->Plagiat->Upload->FileName == "") {
					$rsnew['Plagiat'] = NULL;
				} else {
					$rsnew['Plagiat'] = $this->Plagiat->Upload->FileName;
				}
			}

			// riwayatakademik
			if ($this->riwayatakademik->Visible && !$this->riwayatakademik->ReadOnly && !$this->riwayatakademik->Upload->KeepFile) {
				$this->riwayatakademik->Upload->DbValue = $rsold['riwayatakademik']; // Get original value
				if ($this->riwayatakademik->Upload->FileName == "") {
					$rsnew['riwayatakademik'] = NULL;
				} else {
					$rsnew['riwayatakademik'] = $this->riwayatakademik->Upload->FileName;
				}
			}

			// keuangan
			if ($this->keuangan->Visible && !$this->keuangan->ReadOnly && !$this->keuangan->Upload->KeepFile) {
				$this->keuangan->Upload->DbValue = $rsold['keuangan']; // Get original value
				if ($this->keuangan->Upload->FileName == "") {
					$rsnew['keuangan'] = NULL;
				} else {
					$rsnew['keuangan'] = $this->keuangan->Upload->FileName;
				}
			}

			// pendukung
			if ($this->pendukung->Visible && !$this->pendukung->ReadOnly && !$this->pendukung->Upload->KeepFile) {
				$this->pendukung->Upload->DbValue = $rsold['pendukung']; // Get original value
				if ($this->pendukung->Upload->FileName == "") {
					$rsnew['pendukung'] = NULL;
				} else {
					$rsnew['pendukung'] = $this->pendukung->Upload->FileName;
				}
			}

			// lainlain
			if ($this->lainlain->Visible && !$this->lainlain->ReadOnly && !$this->lainlain->Upload->KeepFile) {
				$this->lainlain->Upload->DbValue = $rsold['lainlain']; // Get original value
				if ($this->lainlain->Upload->FileName == "") {
					$rsnew['lainlain'] = NULL;
				} else {
					$rsnew['lainlain'] = $this->lainlain->Upload->FileName;
				}
			}

			// Check referential integrity for master table 'IM_Mhs'
			$validMasterRecord = TRUE;
			$masterFilter = $this->sqlMasterFilter_IM_Mhs();
			$keyValue = isset($rsnew['Nim']) ? $rsnew['Nim'] : $rsold['Nim'];
			if (strval($keyValue) != "") {
				$masterFilter = str_replace("@Nim@", AdjustSql($keyValue), $masterFilter);
			} else {
				$validMasterRecord = FALSE;
			}
			if ($validMasterRecord) {
				if (!isset($GLOBALS["IM_Mhs"]))
					$GLOBALS["IM_Mhs"] = new IM_Mhs();
				$rsmaster = $GLOBALS["IM_Mhs"]->loadRs($masterFilter);
				$validMasterRecord = ($rsmaster && !$rsmaster->EOF);
				$rsmaster->close();
			}
			if (!$validMasterRecord) {
				$relatedRecordMsg = str_replace("%t", "IM_Mhs", $Language->phrase("RelatedRecordRequired"));
				$this->setFailureMessage($relatedRecordMsg);
				$rs->close();
				return FALSE;
			}
			if ($this->Ijazah->Visible && !$this->Ijazah->Upload->KeepFile) {
				$this->Ijazah->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/';
				$oldFiles = EmptyValue($this->Ijazah->Upload->DbValue) ? [] : [$this->Ijazah->htmlDecode($this->Ijazah->Upload->DbValue)];
				if (!EmptyValue($this->Ijazah->Upload->FileName)) {
					$newFiles = [$this->Ijazah->Upload->FileName];
					$NewFileCount = count($newFiles);
					for ($i = 0; $i < $NewFileCount; $i++) {
						if ($newFiles[$i] != "") {
							$file = $newFiles[$i];
							$tempPath = UploadTempPath($this->Ijazah, $this->Ijazah->Upload->Index);
							if (file_exists($tempPath . $file)) {
								if (Config("DELETE_UPLOADED_FILES")) {
									$oldFileFound = FALSE;
									$oldFileCount = count($oldFiles);
									for ($j = 0; $j < $oldFileCount; $j++) {
										$oldFile = $oldFiles[$j];
										if ($oldFile == $file) { // Old file found, no need to delete anymore
											array_splice($oldFiles, $j, 1);
											$oldFileFound = TRUE;
											break;
										}
									}
									if ($oldFileFound) // No need to check if file exists further
										continue;
								}
								$file1 = UniqueFilename($this->Ijazah->physicalUploadPath(), $file); // Get new file name
								if ($file1 != $file) { // Rename temp file
									while (file_exists($tempPath . $file1) || file_exists($this->Ijazah->physicalUploadPath() . $file1)) // Make sure no file name clash
										$file1 = UniqueFilename($this->Ijazah->physicalUploadPath(), $file1, TRUE); // Use indexed name
									rename($tempPath . $file, $tempPath . $file1);
									$newFiles[$i] = $file1;
								}
							}
						}
					}
					$this->Ijazah->Upload->DbValue = empty($oldFiles) ? "" : implode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $oldFiles);
					$this->Ijazah->Upload->FileName = implode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $newFiles);
					$this->Ijazah->setDbValueDef($rsnew, $this->Ijazah->Upload->FileName, NULL, $this->Ijazah->ReadOnly);
				}
			}
			if ($this->Ktp->Visible && !$this->Ktp->Upload->KeepFile) {
				$this->Ktp->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/';
				$oldFiles = EmptyValue($this->Ktp->Upload->DbValue) ? [] : [$this->Ktp->htmlDecode($this->Ktp->Upload->DbValue)];
				if (!EmptyValue($this->Ktp->Upload->FileName)) {
					$newFiles = [$this->Ktp->Upload->FileName];
					$NewFileCount = count($newFiles);
					for ($i = 0; $i < $NewFileCount; $i++) {
						if ($newFiles[$i] != "") {
							$file = $newFiles[$i];
							$tempPath = UploadTempPath($this->Ktp, $this->Ktp->Upload->Index);
							if (file_exists($tempPath . $file)) {
								if (Config("DELETE_UPLOADED_FILES")) {
									$oldFileFound = FALSE;
									$oldFileCount = count($oldFiles);
									for ($j = 0; $j < $oldFileCount; $j++) {
										$oldFile = $oldFiles[$j];
										if ($oldFile == $file) { // Old file found, no need to delete anymore
											array_splice($oldFiles, $j, 1);
											$oldFileFound = TRUE;
											break;
										}
									}
									if ($oldFileFound) // No need to check if file exists further
										continue;
								}
								$file1 = UniqueFilename($this->Ktp->physicalUploadPath(), $file); // Get new file name
								if ($file1 != $file) { // Rename temp file
									while (file_exists($tempPath . $file1) || file_exists($this->Ktp->physicalUploadPath() . $file1)) // Make sure no file name clash
										$file1 = UniqueFilename($this->Ktp->physicalUploadPath(), $file1, TRUE); // Use indexed name
									rename($tempPath . $file, $tempPath . $file1);
									$newFiles[$i] = $file1;
								}
							}
						}
					}
					$this->Ktp->Upload->DbValue = empty($oldFiles) ? "" : implode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $oldFiles);
					$this->Ktp->Upload->FileName = implode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $newFiles);
					$this->Ktp->setDbValueDef($rsnew, $this->Ktp->Upload->FileName, NULL, $this->Ktp->ReadOnly);
				}
			}
			if ($this->KK->Visible && !$this->KK->Upload->KeepFile) {
				$this->KK->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/';
				$oldFiles = EmptyValue($this->KK->Upload->DbValue) ? [] : [$this->KK->htmlDecode($this->KK->Upload->DbValue)];
				if (!EmptyValue($this->KK->Upload->FileName)) {
					$newFiles = [$this->KK->Upload->FileName];
					$NewFileCount = count($newFiles);
					for ($i = 0; $i < $NewFileCount; $i++) {
						if ($newFiles[$i] != "") {
							$file = $newFiles[$i];
							$tempPath = UploadTempPath($this->KK, $this->KK->Upload->Index);
							if (file_exists($tempPath . $file)) {
								if (Config("DELETE_UPLOADED_FILES")) {
									$oldFileFound = FALSE;
									$oldFileCount = count($oldFiles);
									for ($j = 0; $j < $oldFileCount; $j++) {
										$oldFile = $oldFiles[$j];
										if ($oldFile == $file) { // Old file found, no need to delete anymore
											array_splice($oldFiles, $j, 1);
											$oldFileFound = TRUE;
											break;
										}
									}
									if ($oldFileFound) // No need to check if file exists further
										continue;
								}
								$file1 = UniqueFilename($this->KK->physicalUploadPath(), $file); // Get new file name
								if ($file1 != $file) { // Rename temp file
									while (file_exists($tempPath . $file1) || file_exists($this->KK->physicalUploadPath() . $file1)) // Make sure no file name clash
										$file1 = UniqueFilename($this->KK->physicalUploadPath(), $file1, TRUE); // Use indexed name
									rename($tempPath . $file, $tempPath . $file1);
									$newFiles[$i] = $file1;
								}
							}
						}
					}
					$this->KK->Upload->DbValue = empty($oldFiles) ? "" : implode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $oldFiles);
					$this->KK->Upload->FileName = implode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $newFiles);
					$this->KK->setDbValueDef($rsnew, $this->KK->Upload->FileName, NULL, $this->KK->ReadOnly);
				}
			}
			if ($this->IjazahIM->Visible && !$this->IjazahIM->Upload->KeepFile) {
				$this->IjazahIM->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/riwayat/';
				$oldFiles = EmptyValue($this->IjazahIM->Upload->DbValue) ? [] : [$this->IjazahIM->htmlDecode($this->IjazahIM->Upload->DbValue)];
				if (!EmptyValue($this->IjazahIM->Upload->FileName)) {
					$newFiles = [$this->IjazahIM->Upload->FileName];
					$NewFileCount = count($newFiles);
					for ($i = 0; $i < $NewFileCount; $i++) {
						if ($newFiles[$i] != "") {
							$file = $newFiles[$i];
							$tempPath = UploadTempPath($this->IjazahIM, $this->IjazahIM->Upload->Index);
							if (file_exists($tempPath . $file)) {
								if (Config("DELETE_UPLOADED_FILES")) {
									$oldFileFound = FALSE;
									$oldFileCount = count($oldFiles);
									for ($j = 0; $j < $oldFileCount; $j++) {
										$oldFile = $oldFiles[$j];
										if ($oldFile == $file) { // Old file found, no need to delete anymore
											array_splice($oldFiles, $j, 1);
											$oldFileFound = TRUE;
											break;
										}
									}
									if ($oldFileFound) // No need to check if file exists further
										continue;
								}
								$file1 = UniqueFilename($this->IjazahIM->physicalUploadPath(), $file); // Get new file name
								if ($file1 != $file) { // Rename temp file
									while (file_exists($tempPath . $file1) || file_exists($this->IjazahIM->physicalUploadPath() . $file1)) // Make sure no file name clash
										$file1 = UniqueFilename($this->IjazahIM->physicalUploadPath(), $file1, TRUE); // Use indexed name
									rename($tempPath . $file, $tempPath . $file1);
									$newFiles[$i] = $file1;
								}
							}
						}
					}
					$this->IjazahIM->Upload->DbValue = empty($oldFiles) ? "" : implode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $oldFiles);
					$this->IjazahIM->Upload->FileName = implode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $newFiles);
					$this->IjazahIM->setDbValueDef($rsnew, $this->IjazahIM->Upload->FileName, NULL, $this->IjazahIM->ReadOnly);
				}
			}
			if ($this->TranskriptIM->Visible && !$this->TranskriptIM->Upload->KeepFile) {
				$this->TranskriptIM->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/riwayat/';
				$oldFiles = EmptyValue($this->TranskriptIM->Upload->DbValue) ? [] : [$this->TranskriptIM->htmlDecode($this->TranskriptIM->Upload->DbValue)];
				if (!EmptyValue($this->TranskriptIM->Upload->FileName)) {
					$newFiles = [$this->TranskriptIM->Upload->FileName];
					$NewFileCount = count($newFiles);
					for ($i = 0; $i < $NewFileCount; $i++) {
						if ($newFiles[$i] != "") {
							$file = $newFiles[$i];
							$tempPath = UploadTempPath($this->TranskriptIM, $this->TranskriptIM->Upload->Index);
							if (file_exists($tempPath . $file)) {
								if (Config("DELETE_UPLOADED_FILES")) {
									$oldFileFound = FALSE;
									$oldFileCount = count($oldFiles);
									for ($j = 0; $j < $oldFileCount; $j++) {
										$oldFile = $oldFiles[$j];
										if ($oldFile == $file) { // Old file found, no need to delete anymore
											array_splice($oldFiles, $j, 1);
											$oldFileFound = TRUE;
											break;
										}
									}
									if ($oldFileFound) // No need to check if file exists further
										continue;
								}
								$file1 = UniqueFilename($this->TranskriptIM->physicalUploadPath(), $file); // Get new file name
								if ($file1 != $file) { // Rename temp file
									while (file_exists($tempPath . $file1) || file_exists($this->TranskriptIM->physicalUploadPath() . $file1)) // Make sure no file name clash
										$file1 = UniqueFilename($this->TranskriptIM->physicalUploadPath(), $file1, TRUE); // Use indexed name
									rename($tempPath . $file, $tempPath . $file1);
									$newFiles[$i] = $file1;
								}
							}
						}
					}
					$this->TranskriptIM->Upload->DbValue = empty($oldFiles) ? "" : implode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $oldFiles);
					$this->TranskriptIM->Upload->FileName = implode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $newFiles);
					$this->TranskriptIM->setDbValueDef($rsnew, $this->TranskriptIM->Upload->FileName, NULL, $this->TranskriptIM->ReadOnly);
				}
			}
			if ($this->Skripsi->Visible && !$this->Skripsi->Upload->KeepFile) {
				$this->Skripsi->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/riwayat/';
				$oldFiles = EmptyValue($this->Skripsi->Upload->DbValue) ? [] : [$this->Skripsi->htmlDecode($this->Skripsi->Upload->DbValue)];
				if (!EmptyValue($this->Skripsi->Upload->FileName)) {
					$newFiles = [$this->Skripsi->Upload->FileName];
					$NewFileCount = count($newFiles);
					for ($i = 0; $i < $NewFileCount; $i++) {
						if ($newFiles[$i] != "") {
							$file = $newFiles[$i];
							$tempPath = UploadTempPath($this->Skripsi, $this->Skripsi->Upload->Index);
							if (file_exists($tempPath . $file)) {
								if (Config("DELETE_UPLOADED_FILES")) {
									$oldFileFound = FALSE;
									$oldFileCount = count($oldFiles);
									for ($j = 0; $j < $oldFileCount; $j++) {
										$oldFile = $oldFiles[$j];
										if ($oldFile == $file) { // Old file found, no need to delete anymore
											array_splice($oldFiles, $j, 1);
											$oldFileFound = TRUE;
											break;
										}
									}
									if ($oldFileFound) // No need to check if file exists further
										continue;
								}
								$file1 = UniqueFilename($this->Skripsi->physicalUploadPath(), $file); // Get new file name
								if ($file1 != $file) { // Rename temp file
									while (file_exists($tempPath . $file1) || file_exists($this->Skripsi->physicalUploadPath() . $file1)) // Make sure no file name clash
										$file1 = UniqueFilename($this->Skripsi->physicalUploadPath(), $file1, TRUE); // Use indexed name
									rename($tempPath . $file, $tempPath . $file1);
									$newFiles[$i] = $file1;
								}
							}
						}
					}
					$this->Skripsi->Upload->DbValue = empty($oldFiles) ? "" : implode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $oldFiles);
					$this->Skripsi->Upload->FileName = implode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $newFiles);
					$this->Skripsi->setDbValueDef($rsnew, $this->Skripsi->Upload->FileName, NULL, $this->Skripsi->ReadOnly);
				}
			}
			if ($this->Plagiat->Visible && !$this->Plagiat->Upload->KeepFile) {
				$this->Plagiat->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/riwayat/';
				$oldFiles = EmptyValue($this->Plagiat->Upload->DbValue) ? [] : [$this->Plagiat->htmlDecode($this->Plagiat->Upload->DbValue)];
				if (!EmptyValue($this->Plagiat->Upload->FileName)) {
					$newFiles = [$this->Plagiat->Upload->FileName];
					$NewFileCount = count($newFiles);
					for ($i = 0; $i < $NewFileCount; $i++) {
						if ($newFiles[$i] != "") {
							$file = $newFiles[$i];
							$tempPath = UploadTempPath($this->Plagiat, $this->Plagiat->Upload->Index);
							if (file_exists($tempPath . $file)) {
								if (Config("DELETE_UPLOADED_FILES")) {
									$oldFileFound = FALSE;
									$oldFileCount = count($oldFiles);
									for ($j = 0; $j < $oldFileCount; $j++) {
										$oldFile = $oldFiles[$j];
										if ($oldFile == $file) { // Old file found, no need to delete anymore
											array_splice($oldFiles, $j, 1);
											$oldFileFound = TRUE;
											break;
										}
									}
									if ($oldFileFound) // No need to check if file exists further
										continue;
								}
								$file1 = UniqueFilename($this->Plagiat->physicalUploadPath(), $file); // Get new file name
								if ($file1 != $file) { // Rename temp file
									while (file_exists($tempPath . $file1) || file_exists($this->Plagiat->physicalUploadPath() . $file1)) // Make sure no file name clash
										$file1 = UniqueFilename($this->Plagiat->physicalUploadPath(), $file1, TRUE); // Use indexed name
									rename($tempPath . $file, $tempPath . $file1);
									$newFiles[$i] = $file1;
								}
							}
						}
					}
					$this->Plagiat->Upload->DbValue = empty($oldFiles) ? "" : implode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $oldFiles);
					$this->Plagiat->Upload->FileName = implode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $newFiles);
					$this->Plagiat->setDbValueDef($rsnew, $this->Plagiat->Upload->FileName, NULL, $this->Plagiat->ReadOnly);
				}
			}
			if ($this->riwayatakademik->Visible && !$this->riwayatakademik->Upload->KeepFile) {
				$this->riwayatakademik->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/riwayat/';
				$oldFiles = EmptyValue($this->riwayatakademik->Upload->DbValue) ? [] : [$this->riwayatakademik->htmlDecode($this->riwayatakademik->Upload->DbValue)];
				if (!EmptyValue($this->riwayatakademik->Upload->FileName)) {
					$newFiles = [$this->riwayatakademik->Upload->FileName];
					$NewFileCount = count($newFiles);
					for ($i = 0; $i < $NewFileCount; $i++) {
						if ($newFiles[$i] != "") {
							$file = $newFiles[$i];
							$tempPath = UploadTempPath($this->riwayatakademik, $this->riwayatakademik->Upload->Index);
							if (file_exists($tempPath . $file)) {
								if (Config("DELETE_UPLOADED_FILES")) {
									$oldFileFound = FALSE;
									$oldFileCount = count($oldFiles);
									for ($j = 0; $j < $oldFileCount; $j++) {
										$oldFile = $oldFiles[$j];
										if ($oldFile == $file) { // Old file found, no need to delete anymore
											array_splice($oldFiles, $j, 1);
											$oldFileFound = TRUE;
											break;
										}
									}
									if ($oldFileFound) // No need to check if file exists further
										continue;
								}
								$file1 = UniqueFilename($this->riwayatakademik->physicalUploadPath(), $file); // Get new file name
								if ($file1 != $file) { // Rename temp file
									while (file_exists($tempPath . $file1) || file_exists($this->riwayatakademik->physicalUploadPath() . $file1)) // Make sure no file name clash
										$file1 = UniqueFilename($this->riwayatakademik->physicalUploadPath(), $file1, TRUE); // Use indexed name
									rename($tempPath . $file, $tempPath . $file1);
									$newFiles[$i] = $file1;
								}
							}
						}
					}
					$this->riwayatakademik->Upload->DbValue = empty($oldFiles) ? "" : implode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $oldFiles);
					$this->riwayatakademik->Upload->FileName = implode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $newFiles);
					$this->riwayatakademik->setDbValueDef($rsnew, $this->riwayatakademik->Upload->FileName, NULL, $this->riwayatakademik->ReadOnly);
				}
			}
			if ($this->keuangan->Visible && !$this->keuangan->Upload->KeepFile) {
				$this->keuangan->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/keu/';
				$oldFiles = EmptyValue($this->keuangan->Upload->DbValue) ? [] : [$this->keuangan->htmlDecode($this->keuangan->Upload->DbValue)];
				if (!EmptyValue($this->keuangan->Upload->FileName)) {
					$newFiles = [$this->keuangan->Upload->FileName];
					$NewFileCount = count($newFiles);
					for ($i = 0; $i < $NewFileCount; $i++) {
						if ($newFiles[$i] != "") {
							$file = $newFiles[$i];
							$tempPath = UploadTempPath($this->keuangan, $this->keuangan->Upload->Index);
							if (file_exists($tempPath . $file)) {
								if (Config("DELETE_UPLOADED_FILES")) {
									$oldFileFound = FALSE;
									$oldFileCount = count($oldFiles);
									for ($j = 0; $j < $oldFileCount; $j++) {
										$oldFile = $oldFiles[$j];
										if ($oldFile == $file) { // Old file found, no need to delete anymore
											array_splice($oldFiles, $j, 1);
											$oldFileFound = TRUE;
											break;
										}
									}
									if ($oldFileFound) // No need to check if file exists further
										continue;
								}
								$file1 = UniqueFilename($this->keuangan->physicalUploadPath(), $file); // Get new file name
								if ($file1 != $file) { // Rename temp file
									while (file_exists($tempPath . $file1) || file_exists($this->keuangan->physicalUploadPath() . $file1)) // Make sure no file name clash
										$file1 = UniqueFilename($this->keuangan->physicalUploadPath(), $file1, TRUE); // Use indexed name
									rename($tempPath . $file, $tempPath . $file1);
									$newFiles[$i] = $file1;
								}
							}
						}
					}
					$this->keuangan->Upload->DbValue = empty($oldFiles) ? "" : implode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $oldFiles);
					$this->keuangan->Upload->FileName = implode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $newFiles);
					$this->keuangan->setDbValueDef($rsnew, $this->keuangan->Upload->FileName, NULL, $this->keuangan->ReadOnly);
				}
			}
			if ($this->pendukung->Visible && !$this->pendukung->Upload->KeepFile) {
				$this->pendukung->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/pendukung/';
				$oldFiles = EmptyValue($this->pendukung->Upload->DbValue) ? [] : [$this->pendukung->htmlDecode($this->pendukung->Upload->DbValue)];
				if (!EmptyValue($this->pendukung->Upload->FileName)) {
					$newFiles = [$this->pendukung->Upload->FileName];
					$NewFileCount = count($newFiles);
					for ($i = 0; $i < $NewFileCount; $i++) {
						if ($newFiles[$i] != "") {
							$file = $newFiles[$i];
							$tempPath = UploadTempPath($this->pendukung, $this->pendukung->Upload->Index);
							if (file_exists($tempPath . $file)) {
								if (Config("DELETE_UPLOADED_FILES")) {
									$oldFileFound = FALSE;
									$oldFileCount = count($oldFiles);
									for ($j = 0; $j < $oldFileCount; $j++) {
										$oldFile = $oldFiles[$j];
										if ($oldFile == $file) { // Old file found, no need to delete anymore
											array_splice($oldFiles, $j, 1);
											$oldFileFound = TRUE;
											break;
										}
									}
									if ($oldFileFound) // No need to check if file exists further
										continue;
								}
								$file1 = UniqueFilename($this->pendukung->physicalUploadPath(), $file); // Get new file name
								if ($file1 != $file) { // Rename temp file
									while (file_exists($tempPath . $file1) || file_exists($this->pendukung->physicalUploadPath() . $file1)) // Make sure no file name clash
										$file1 = UniqueFilename($this->pendukung->physicalUploadPath(), $file1, TRUE); // Use indexed name
									rename($tempPath . $file, $tempPath . $file1);
									$newFiles[$i] = $file1;
								}
							}
						}
					}
					$this->pendukung->Upload->DbValue = empty($oldFiles) ? "" : implode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $oldFiles);
					$this->pendukung->Upload->FileName = implode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $newFiles);
					$this->pendukung->setDbValueDef($rsnew, $this->pendukung->Upload->FileName, NULL, $this->pendukung->ReadOnly);
				}
			}
			if ($this->lainlain->Visible && !$this->lainlain->Upload->KeepFile) {
				$this->lainlain->UploadPath = '../../../../E:/wwwroot/akademik.imandiri.ac.id/views/uploads/lainlain/';
				$oldFiles = EmptyValue($this->lainlain->Upload->DbValue) ? [] : [$this->lainlain->htmlDecode($this->lainlain->Upload->DbValue)];
				if (!EmptyValue($this->lainlain->Upload->FileName)) {
					$newFiles = [$this->lainlain->Upload->FileName];
					$NewFileCount = count($newFiles);
					for ($i = 0; $i < $NewFileCount; $i++) {
						if ($newFiles[$i] != "") {
							$file = $newFiles[$i];
							$tempPath = UploadTempPath($this->lainlain, $this->lainlain->Upload->Index);
							if (file_exists($tempPath . $file)) {
								if (Config("DELETE_UPLOADED_FILES")) {
									$oldFileFound = FALSE;
									$oldFileCount = count($oldFiles);
									for ($j = 0; $j < $oldFileCount; $j++) {
										$oldFile = $oldFiles[$j];
										if ($oldFile == $file) { // Old file found, no need to delete anymore
											array_splice($oldFiles, $j, 1);
											$oldFileFound = TRUE;
											break;
										}
									}
									if ($oldFileFound) // No need to check if file exists further
										continue;
								}
								$file1 = UniqueFilename($this->lainlain->physicalUploadPath(), $file); // Get new file name
								if ($file1 != $file) { // Rename temp file
									while (file_exists($tempPath . $file1) || file_exists($this->lainlain->physicalUploadPath() . $file1)) // Make sure no file name clash
										$file1 = UniqueFilename($this->lainlain->physicalUploadPath(), $file1, TRUE); // Use indexed name
									rename($tempPath . $file, $tempPath . $file1);
									$newFiles[$i] = $file1;
								}
							}
						}
					}
					$this->lainlain->Upload->DbValue = empty($oldFiles) ? "" : implode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $oldFiles);
					$this->lainlain->Upload->FileName = implode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $newFiles);
					$this->lainlain->setDbValueDef($rsnew, $this->lainlain->Upload->FileName, NULL, $this->lainlain->ReadOnly);
				}
			}

			// Call Row Updating event
			$updateRow = $this->Row_Updating($rsold, $rsnew);

			// Check for duplicate key when key changed
			if ($updateRow) {
				$newKeyFilter = $this->getRecordFilter($rsnew);
				if ($newKeyFilter != $oldKeyFilter) {
					$rsChk = $this->loadRs($newKeyFilter);
					if ($rsChk && !$rsChk->EOF) {
						$keyErrMsg = str_replace("%f", $newKeyFilter, $Language->phrase("DupKey"));
						$this->setFailureMessage($keyErrMsg);
						$rsChk->close();
						$updateRow = FALSE;
					}
				}
			}
			if ($updateRow) {
				$conn->raiseErrorFn = Config("ERROR_FUNC");
				if (count($rsnew) > 0)
					$editRow = $this->update($rsnew, "", $rsold);
				else
					$editRow = TRUE; // No field to update
				$conn->raiseErrorFn = "";
				if ($editRow) {
					if ($this->Ijazah->Visible && !$this->Ijazah->Upload->KeepFile) {
						$oldFiles = EmptyValue($this->Ijazah->Upload->DbValue) ? [] : [$this->Ijazah->htmlDecode($this->Ijazah->Upload->DbValue)];
						if (!EmptyValue($this->Ijazah->Upload->FileName)) {
							$newFiles = [$this->Ijazah->Upload->FileName];
							$newFiles2 = [$this->Ijazah->htmlDecode($rsnew['Ijazah'])];
							$newFileCount = count($newFiles);
							for ($i = 0; $i < $newFileCount; $i++) {
								if ($newFiles[$i] != "") {
									$file = UploadTempPath($this->Ijazah, $this->Ijazah->Upload->Index) . $newFiles[$i];
									if (file_exists($file)) {
										if (@$newFiles2[$i] != "") // Use correct file name
											$newFiles[$i] = $newFiles2[$i];
										if (!$this->Ijazah->Upload->SaveToFile($newFiles[$i], TRUE, $i)) { // Just replace
											$this->setFailureMessage($Language->phrase("UploadErrMsg7"));
											return FALSE;
										}
									}
								}
							}
						} else {
							$newFiles = [];
						}
						if (Config("DELETE_UPLOADED_FILES")) {
							foreach ($oldFiles as $oldFile) {
								if ($oldFile != "" && !in_array($oldFile, $newFiles))
									@unlink($this->Ijazah->oldPhysicalUploadPath() . $oldFile);
							}
						}
					}
					if ($this->Ktp->Visible && !$this->Ktp->Upload->KeepFile) {
						$oldFiles = EmptyValue($this->Ktp->Upload->DbValue) ? [] : [$this->Ktp->htmlDecode($this->Ktp->Upload->DbValue)];
						if (!EmptyValue($this->Ktp->Upload->FileName)) {
							$newFiles = [$this->Ktp->Upload->FileName];
							$newFiles2 = [$this->Ktp->htmlDecode($rsnew['Ktp'])];
							$newFileCount = count($newFiles);
							for ($i = 0; $i < $newFileCount; $i++) {
								if ($newFiles[$i] != "") {
									$file = UploadTempPath($this->Ktp, $this->Ktp->Upload->Index) . $newFiles[$i];
									if (file_exists($file)) {
										if (@$newFiles2[$i] != "") // Use correct file name
											$newFiles[$i] = $newFiles2[$i];
										if (!$this->Ktp->Upload->SaveToFile($newFiles[$i], TRUE, $i)) { // Just replace
											$this->setFailureMessage($Language->phrase("UploadErrMsg7"));
											return FALSE;
										}
									}
								}
							}
						} else {
							$newFiles = [];
						}
						if (Config("DELETE_UPLOADED_FILES")) {
							foreach ($oldFiles as $oldFile) {
								if ($oldFile != "" && !in_array($oldFile, $newFiles))
									@unlink($this->Ktp->oldPhysicalUploadPath() . $oldFile);
							}
						}
					}
					if ($this->KK->Visible && !$this->KK->Upload->KeepFile) {
						$oldFiles = EmptyValue($this->KK->Upload->DbValue) ? [] : [$this->KK->htmlDecode($this->KK->Upload->DbValue)];
						if (!EmptyValue($this->KK->Upload->FileName)) {
							$newFiles = [$this->KK->Upload->FileName];
							$newFiles2 = [$this->KK->htmlDecode($rsnew['KK'])];
							$newFileCount = count($newFiles);
							for ($i = 0; $i < $newFileCount; $i++) {
								if ($newFiles[$i] != "") {
									$file = UploadTempPath($this->KK, $this->KK->Upload->Index) . $newFiles[$i];
									if (file_exists($file)) {
										if (@$newFiles2[$i] != "") // Use correct file name
											$newFiles[$i] = $newFiles2[$i];
										if (!$this->KK->Upload->SaveToFile($newFiles[$i], TRUE, $i)) { // Just replace
											$this->setFailureMessage($Language->phrase("UploadErrMsg7"));
											return FALSE;
										}
									}
								}
							}
						} else {
							$newFiles = [];
						}
						if (Config("DELETE_UPLOADED_FILES")) {
							foreach ($oldFiles as $oldFile) {
								if ($oldFile != "" && !in_array($oldFile, $newFiles))
									@unlink($this->KK->oldPhysicalUploadPath() . $oldFile);
							}
						}
					}
					if ($this->IjazahIM->Visible && !$this->IjazahIM->Upload->KeepFile) {
						$oldFiles = EmptyValue($this->IjazahIM->Upload->DbValue) ? [] : [$this->IjazahIM->htmlDecode($this->IjazahIM->Upload->DbValue)];
						if (!EmptyValue($this->IjazahIM->Upload->FileName)) {
							$newFiles = [$this->IjazahIM->Upload->FileName];
							$newFiles2 = [$this->IjazahIM->htmlDecode($rsnew['IjazahIM'])];
							$newFileCount = count($newFiles);
							for ($i = 0; $i < $newFileCount; $i++) {
								if ($newFiles[$i] != "") {
									$file = UploadTempPath($this->IjazahIM, $this->IjazahIM->Upload->Index) . $newFiles[$i];
									if (file_exists($file)) {
										if (@$newFiles2[$i] != "") // Use correct file name
											$newFiles[$i] = $newFiles2[$i];
										if (!$this->IjazahIM->Upload->SaveToFile($newFiles[$i], TRUE, $i)) { // Just replace
											$this->setFailureMessage($Language->phrase("UploadErrMsg7"));
											return FALSE;
										}
									}
								}
							}
						} else {
							$newFiles = [];
						}
						if (Config("DELETE_UPLOADED_FILES")) {
							foreach ($oldFiles as $oldFile) {
								if ($oldFile != "" && !in_array($oldFile, $newFiles))
									@unlink($this->IjazahIM->oldPhysicalUploadPath() . $oldFile);
							}
						}
					}
					if ($this->TranskriptIM->Visible && !$this->TranskriptIM->Upload->KeepFile) {
						$oldFiles = EmptyValue($this->TranskriptIM->Upload->DbValue) ? [] : [$this->TranskriptIM->htmlDecode($this->TranskriptIM->Upload->DbValue)];
						if (!EmptyValue($this->TranskriptIM->Upload->FileName)) {
							$newFiles = [$this->TranskriptIM->Upload->FileName];
							$newFiles2 = [$this->TranskriptIM->htmlDecode($rsnew['TranskriptIM'])];
							$newFileCount = count($newFiles);
							for ($i = 0; $i < $newFileCount; $i++) {
								if ($newFiles[$i] != "") {
									$file = UploadTempPath($this->TranskriptIM, $this->TranskriptIM->Upload->Index) . $newFiles[$i];
									if (file_exists($file)) {
										if (@$newFiles2[$i] != "") // Use correct file name
											$newFiles[$i] = $newFiles2[$i];
										if (!$this->TranskriptIM->Upload->SaveToFile($newFiles[$i], TRUE, $i)) { // Just replace
											$this->setFailureMessage($Language->phrase("UploadErrMsg7"));
											return FALSE;
										}
									}
								}
							}
						} else {
							$newFiles = [];
						}
						if (Config("DELETE_UPLOADED_FILES")) {
							foreach ($oldFiles as $oldFile) {
								if ($oldFile != "" && !in_array($oldFile, $newFiles))
									@unlink($this->TranskriptIM->oldPhysicalUploadPath() . $oldFile);
							}
						}
					}
					if ($this->Skripsi->Visible && !$this->Skripsi->Upload->KeepFile) {
						$oldFiles = EmptyValue($this->Skripsi->Upload->DbValue) ? [] : [$this->Skripsi->htmlDecode($this->Skripsi->Upload->DbValue)];
						if (!EmptyValue($this->Skripsi->Upload->FileName)) {
							$newFiles = [$this->Skripsi->Upload->FileName];
							$newFiles2 = [$this->Skripsi->htmlDecode($rsnew['Skripsi'])];
							$newFileCount = count($newFiles);
							for ($i = 0; $i < $newFileCount; $i++) {
								if ($newFiles[$i] != "") {
									$file = UploadTempPath($this->Skripsi, $this->Skripsi->Upload->Index) . $newFiles[$i];
									if (file_exists($file)) {
										if (@$newFiles2[$i] != "") // Use correct file name
											$newFiles[$i] = $newFiles2[$i];
										if (!$this->Skripsi->Upload->SaveToFile($newFiles[$i], TRUE, $i)) { // Just replace
											$this->setFailureMessage($Language->phrase("UploadErrMsg7"));
											return FALSE;
										}
									}
								}
							}
						} else {
							$newFiles = [];
						}
						if (Config("DELETE_UPLOADED_FILES")) {
							foreach ($oldFiles as $oldFile) {
								if ($oldFile != "" && !in_array($oldFile, $newFiles))
									@unlink($this->Skripsi->oldPhysicalUploadPath() . $oldFile);
							}
						}
					}
					if ($this->Plagiat->Visible && !$this->Plagiat->Upload->KeepFile) {
						$oldFiles = EmptyValue($this->Plagiat->Upload->DbValue) ? [] : [$this->Plagiat->htmlDecode($this->Plagiat->Upload->DbValue)];
						if (!EmptyValue($this->Plagiat->Upload->FileName)) {
							$newFiles = [$this->Plagiat->Upload->FileName];
							$newFiles2 = [$this->Plagiat->htmlDecode($rsnew['Plagiat'])];
							$newFileCount = count($newFiles);
							for ($i = 0; $i < $newFileCount; $i++) {
								if ($newFiles[$i] != "") {
									$file = UploadTempPath($this->Plagiat, $this->Plagiat->Upload->Index) . $newFiles[$i];
									if (file_exists($file)) {
										if (@$newFiles2[$i] != "") // Use correct file name
											$newFiles[$i] = $newFiles2[$i];
										if (!$this->Plagiat->Upload->SaveToFile($newFiles[$i], TRUE, $i)) { // Just replace
											$this->setFailureMessage($Language->phrase("UploadErrMsg7"));
											return FALSE;
										}
									}
								}
							}
						} else {
							$newFiles = [];
						}
						if (Config("DELETE_UPLOADED_FILES")) {
							foreach ($oldFiles as $oldFile) {
								if ($oldFile != "" && !in_array($oldFile, $newFiles))
									@unlink($this->Plagiat->oldPhysicalUploadPath() . $oldFile);
							}
						}
					}
					if ($this->riwayatakademik->Visible && !$this->riwayatakademik->Upload->KeepFile) {
						$oldFiles = EmptyValue($this->riwayatakademik->Upload->DbValue) ? [] : [$this->riwayatakademik->htmlDecode($this->riwayatakademik->Upload->DbValue)];
						if (!EmptyValue($this->riwayatakademik->Upload->FileName)) {
							$newFiles = [$this->riwayatakademik->Upload->FileName];
							$newFiles2 = [$this->riwayatakademik->htmlDecode($rsnew['riwayatakademik'])];
							$newFileCount = count($newFiles);
							for ($i = 0; $i < $newFileCount; $i++) {
								if ($newFiles[$i] != "") {
									$file = UploadTempPath($this->riwayatakademik, $this->riwayatakademik->Upload->Index) . $newFiles[$i];
									if (file_exists($file)) {
										if (@$newFiles2[$i] != "") // Use correct file name
											$newFiles[$i] = $newFiles2[$i];
										if (!$this->riwayatakademik->Upload->SaveToFile($newFiles[$i], TRUE, $i)) { // Just replace
											$this->setFailureMessage($Language->phrase("UploadErrMsg7"));
											return FALSE;
										}
									}
								}
							}
						} else {
							$newFiles = [];
						}
						if (Config("DELETE_UPLOADED_FILES")) {
							foreach ($oldFiles as $oldFile) {
								if ($oldFile != "" && !in_array($oldFile, $newFiles))
									@unlink($this->riwayatakademik->oldPhysicalUploadPath() . $oldFile);
							}
						}
					}
					if ($this->keuangan->Visible && !$this->keuangan->Upload->KeepFile) {
						$oldFiles = EmptyValue($this->keuangan->Upload->DbValue) ? [] : [$this->keuangan->htmlDecode($this->keuangan->Upload->DbValue)];
						if (!EmptyValue($this->keuangan->Upload->FileName)) {
							$newFiles = [$this->keuangan->Upload->FileName];
							$newFiles2 = [$this->keuangan->htmlDecode($rsnew['keuangan'])];
							$newFileCount = count($newFiles);
							for ($i = 0; $i < $newFileCount; $i++) {
								if ($newFiles[$i] != "") {
									$file = UploadTempPath($this->keuangan, $this->keuangan->Upload->Index) . $newFiles[$i];
									if (file_exists($file)) {
										if (@$newFiles2[$i] != "") // Use correct file name
											$newFiles[$i] = $newFiles2[$i];
										if (!$this->keuangan->Upload->SaveToFile($newFiles[$i], TRUE, $i)) { // Just replace
											$this->setFailureMessage($Language->phrase("UploadErrMsg7"));
											return FALSE;
										}
									}
								}
							}
						} else {
							$newFiles = [];
						}
						if (Config("DELETE_UPLOADED_FILES")) {
							foreach ($oldFiles as $oldFile) {
								if ($oldFile != "" && !in_array($oldFile, $newFiles))
									@unlink($this->keuangan->oldPhysicalUploadPath() . $oldFile);
							}
						}
					}
					if ($this->pendukung->Visible && !$this->pendukung->Upload->KeepFile) {
						$oldFiles = EmptyValue($this->pendukung->Upload->DbValue) ? [] : [$this->pendukung->htmlDecode($this->pendukung->Upload->DbValue)];
						if (!EmptyValue($this->pendukung->Upload->FileName)) {
							$newFiles = [$this->pendukung->Upload->FileName];
							$newFiles2 = [$this->pendukung->htmlDecode($rsnew['pendukung'])];
							$newFileCount = count($newFiles);
							for ($i = 0; $i < $newFileCount; $i++) {
								if ($newFiles[$i] != "") {
									$file = UploadTempPath($this->pendukung, $this->pendukung->Upload->Index) . $newFiles[$i];
									if (file_exists($file)) {
										if (@$newFiles2[$i] != "") // Use correct file name
											$newFiles[$i] = $newFiles2[$i];
										if (!$this->pendukung->Upload->SaveToFile($newFiles[$i], TRUE, $i)) { // Just replace
											$this->setFailureMessage($Language->phrase("UploadErrMsg7"));
											return FALSE;
										}
									}
								}
							}
						} else {
							$newFiles = [];
						}
						if (Config("DELETE_UPLOADED_FILES")) {
							foreach ($oldFiles as $oldFile) {
								if ($oldFile != "" && !in_array($oldFile, $newFiles))
									@unlink($this->pendukung->oldPhysicalUploadPath() . $oldFile);
							}
						}
					}
					if ($this->lainlain->Visible && !$this->lainlain->Upload->KeepFile) {
						$oldFiles = EmptyValue($this->lainlain->Upload->DbValue) ? [] : [$this->lainlain->htmlDecode($this->lainlain->Upload->DbValue)];
						if (!EmptyValue($this->lainlain->Upload->FileName)) {
							$newFiles = [$this->lainlain->Upload->FileName];
							$newFiles2 = [$this->lainlain->htmlDecode($rsnew['lainlain'])];
							$newFileCount = count($newFiles);
							for ($i = 0; $i < $newFileCount; $i++) {
								if ($newFiles[$i] != "") {
									$file = UploadTempPath($this->lainlain, $this->lainlain->Upload->Index) . $newFiles[$i];
									if (file_exists($file)) {
										if (@$newFiles2[$i] != "") // Use correct file name
											$newFiles[$i] = $newFiles2[$i];
										if (!$this->lainlain->Upload->SaveToFile($newFiles[$i], TRUE, $i)) { // Just replace
											$this->setFailureMessage($Language->phrase("UploadErrMsg7"));
											return FALSE;
										}
									}
								}
							}
						} else {
							$newFiles = [];
						}
						if (Config("DELETE_UPLOADED_FILES")) {
							foreach ($oldFiles as $oldFile) {
								if ($oldFile != "" && !in_array($oldFile, $newFiles))
									@unlink($this->lainlain->oldPhysicalUploadPath() . $oldFile);
							}
						}
					}
				}
			} else {
				if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {

					// Use the message, do nothing
				} elseif ($this->CancelMessage != "") {
					$this->setFailureMessage($this->CancelMessage);
					$this->CancelMessage = "";
				} else {
					$this->setFailureMessage($Language->phrase("UpdateCancelled"));
				}
				$editRow = FALSE;
			}
		}

		// Call Row_Updated event
		if ($editRow)
			$this->Row_Updated($rsold, $rsnew);
		$rs->close();

		// Clean upload path if any
		if ($editRow) {

			// Ijazah
			CleanUploadTempPath($this->Ijazah, $this->Ijazah->Upload->Index);

			// Ktp
			CleanUploadTempPath($this->Ktp, $this->Ktp->Upload->Index);

			// KK
			CleanUploadTempPath($this->KK, $this->KK->Upload->Index);

			// IjazahIM
			CleanUploadTempPath($this->IjazahIM, $this->IjazahIM->Upload->Index);

			// TranskriptIM
			CleanUploadTempPath($this->TranskriptIM, $this->TranskriptIM->Upload->Index);

			// Skripsi
			CleanUploadTempPath($this->Skripsi, $this->Skripsi->Upload->Index);

			// Plagiat
			CleanUploadTempPath($this->Plagiat, $this->Plagiat->Upload->Index);

			// riwayatakademik
			CleanUploadTempPath($this->riwayatakademik, $this->riwayatakademik->Upload->Index);

			// keuangan
			CleanUploadTempPath($this->keuangan, $this->keuangan->Upload->Index);

			// pendukung
			CleanUploadTempPath($this->pendukung, $this->pendukung->Upload->Index);

			// lainlain
			CleanUploadTempPath($this->lainlain, $this->lainlain->Upload->Index);
		}

		// Write JSON for API request
		if (IsApi() && $editRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $editRow;
	}

	// Set up master/detail based on QueryString
	protected function setupMasterParms()
	{
		$validMaster = FALSE;

		// Get the keys for master table
		if (($master = Get(Config("TABLE_SHOW_MASTER"), Get(Config("TABLE_MASTER")))) !== NULL) {
			$masterTblVar = $master;
			if ($masterTblVar == "") {
				$validMaster = TRUE;
				$this->DbMasterFilter = "";
				$this->DbDetailFilter = "";
			}
			if ($masterTblVar == "ekpt_mhsfeed") {
				$validMaster = TRUE;
				if (($parm = Get("fk_Nim", Get("Nim"))) !== NULL) {
					$GLOBALS["ekpt_mhsfeed"]->Nim->setQueryStringValue($parm);
					$this->Nim->setQueryStringValue($GLOBALS["ekpt_mhsfeed"]->Nim->QueryStringValue);
					$this->Nim->setSessionValue($this->Nim->QueryStringValue);
				} else {
					$validMaster = FALSE;
				}
			}
			if ($masterTblVar == "IM_Lulusan") {
				$validMaster = TRUE;
				if (($parm = Get("fk_NIM", Get("Nim"))) !== NULL) {
					$GLOBALS["IM_Lulusan"]->NIM->setQueryStringValue($parm);
					$this->Nim->setQueryStringValue($GLOBALS["IM_Lulusan"]->NIM->QueryStringValue);
					$this->Nim->setSessionValue($this->Nim->QueryStringValue);
				} else {
					$validMaster = FALSE;
				}
			}
			if ($masterTblVar == "IM_Mhs") {
				$validMaster = TRUE;
				if (($parm = Get("fk_Nim", Get("Nim"))) !== NULL) {
					$GLOBALS["IM_Mhs"]->Nim->setQueryStringValue($parm);
					$this->Nim->setQueryStringValue($GLOBALS["IM_Mhs"]->Nim->QueryStringValue);
					$this->Nim->setSessionValue($this->Nim->QueryStringValue);
				} else {
					$validMaster = FALSE;
				}
			}
		} elseif (($master = Post(Config("TABLE_SHOW_MASTER"), Post(Config("TABLE_MASTER")))) !== NULL) {
			$masterTblVar = $master;
			if ($masterTblVar == "") {
				$validMaster = TRUE;
				$this->DbMasterFilter = "";
				$this->DbDetailFilter = "";
			}
			if ($masterTblVar == "ekpt_mhsfeed") {
				$validMaster = TRUE;
				if (($parm = Post("fk_Nim", Post("Nim"))) !== NULL) {
					$GLOBALS["ekpt_mhsfeed"]->Nim->setFormValue($parm);
					$this->Nim->setFormValue($GLOBALS["ekpt_mhsfeed"]->Nim->FormValue);
					$this->Nim->setSessionValue($this->Nim->FormValue);
				} else {
					$validMaster = FALSE;
				}
			}
			if ($masterTblVar == "IM_Lulusan") {
				$validMaster = TRUE;
				if (($parm = Post("fk_NIM", Post("Nim"))) !== NULL) {
					$GLOBALS["IM_Lulusan"]->NIM->setFormValue($parm);
					$this->Nim->setFormValue($GLOBALS["IM_Lulusan"]->NIM->FormValue);
					$this->Nim->setSessionValue($this->Nim->FormValue);
				} else {
					$validMaster = FALSE;
				}
			}
			if ($masterTblVar == "IM_Mhs") {
				$validMaster = TRUE;
				if (($parm = Post("fk_Nim", Post("Nim"))) !== NULL) {
					$GLOBALS["IM_Mhs"]->Nim->setFormValue($parm);
					$this->Nim->setFormValue($GLOBALS["IM_Mhs"]->Nim->FormValue);
					$this->Nim->setSessionValue($this->Nim->FormValue);
				} else {
					$validMaster = FALSE;
				}
			}
		}
		if ($validMaster) {

			// Save current master table
			$this->setCurrentMasterTable($masterTblVar);
			$this->setSessionWhere($this->getDetailFilter());

			// Reset start record counter (new master key)
			if (!$this->isAddOrEdit()) {
				$this->StartRecord = 1;
				$this->setStartRecordNumber($this->StartRecord);
			}

			// Clear previous master key from Session
			if ($masterTblVar != "ekpt_mhsfeed") {
				if ($this->Nim->CurrentValue == "")
					$this->Nim->setSessionValue("");
			}
			if ($masterTblVar != "IM_Lulusan") {
				if ($this->Nim->CurrentValue == "")
					$this->Nim->setSessionValue("");
			}
			if ($masterTblVar != "IM_Mhs") {
				if ($this->Nim->CurrentValue == "")
					$this->Nim->setSessionValue("");
			}
		}
		$this->DbMasterFilter = $this->getMasterFilter(); // Get master filter
		$this->DbDetailFilter = $this->getDetailFilter(); // Get detail filter
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("docmhslist.php"), "", $this->TableVar, TRUE);
		$pageId = "edit";
		$Breadcrumb->add("edit", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// Get default connection and filter
			$conn = $this->getConnection();
			$lookupFilter = "";

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL and connection
			switch ($fld->FieldVar) {
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0) {
				$totalCnt = $this->getRecordCount($sql, $conn);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Set up starting record parameters
	public function setupStartRecord()
	{
		if ($this->DisplayRecords == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			$startRec = Get(Config("TABLE_START_REC"));
			$pageNo = Get(Config("TABLE_PAGE_NO"));
			if ($pageNo !== NULL) { // Check for "pageno" parameter first
				if (is_numeric($pageNo)) {
					$this->StartRecord = ($pageNo - 1) * $this->DisplayRecords + 1;
					if ($this->StartRecord <= 0) {
						$this->StartRecord = 1;
					} elseif ($this->StartRecord >= (int)(($this->TotalRecords - 1)/$this->DisplayRecords) * $this->DisplayRecords + 1) {
						$this->StartRecord = (int)(($this->TotalRecords - 1)/$this->DisplayRecords) * $this->DisplayRecords + 1;
					}
					$this->setStartRecordNumber($this->StartRecord);
				}
			} elseif ($startRec !== NULL) { // Check for "start" parameter
				$this->StartRecord = $startRec;
				$this->setStartRecordNumber($this->StartRecord);
			}
		}
		$this->StartRecord = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRecord) || $this->StartRecord == "") { // Avoid invalid start record counter
			$this->StartRecord = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRecord);
		} elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
			$this->StartRecord = (int)(($this->TotalRecords - 1)/$this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRecord);
		} elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
			$this->StartRecord = (int)(($this->StartRecord - 1)/$this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRecord);
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
} // End class
?>