<?php namespace PHPMaker2020\baak; ?>
<?php

/**
 * Table class for ekpt_mhsfeed
 */
class ekpt_mhsfeed extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $Kode_Fak;
	public $Kode_Jp;
	public $NimIM;
	public $Nim;
	public $NamaMhs;
	public $Status_Akd;
	public $TglLahir;
	public $TSKS;
	public $Prodi;
	public $PerMasuk;
	public $Status;
	public $PerKeluar;
	public $TglKeluar;
	public $Nama_Mhs;
	public $Tmp_Lahir;
	public $Tgl_Lahir;
	public $StatusSIAP;
	public $PerMasukIM;
	public $TaMasuk;
	public $PMasuk;
	public $tglmasuk;
	public $Status_Masuk;
	public $JalurMasuk;
	public $PerLulusIM;
	public $Tgl_Lulus;
	public $No_Ijazah;
	public $TA;
	public $per;
	public $ProdiIM;
	public $TaAkhir;
	public $xphoto;
	public $Ijazah;
	public $Ktp;
	public $KK;
	public $riwayatakademik;
	public $IjazahIM;
	public $TranskriptIM;
	public $Skripsi;
	public $TASkripsi;
	public $Plagiat;
	public $keuangan;
	public $pendukung;
	public $lainlain;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;
		parent::__construct();

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'ekpt_mhsfeed';
		$this->TableName = 'ekpt_mhsfeed';
		$this->TableType = 'VIEW';

		// Update Table
		$this->UpdateTable = "[dbo].[ekpt_mhsfeed]";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
		$this->BasicSearch = new BasicSearch($this->TableVar);

		// Kode_Fak
		$this->Kode_Fak = new DbField('ekpt_mhsfeed', 'ekpt_mhsfeed', 'x_Kode_Fak', 'Kode_Fak', '[Kode_Fak]', '[Kode_Fak]', 129, 10, -1, FALSE, '[Kode_Fak]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->Kode_Fak->Sortable = TRUE; // Allow sort
		$this->Kode_Fak->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->Kode_Fak->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
		$this->Kode_Fak->Lookup = new Lookup('Kode_Fak', 'tblFak', FALSE, 'Kode_Fak', ["Nama_Fak","","",""], [], [], [], [], [], [], '', '');
		$this->fields['Kode_Fak'] = &$this->Kode_Fak;

		// Kode_Jp
		$this->Kode_Jp = new DbField('ekpt_mhsfeed', 'ekpt_mhsfeed', 'x_Kode_Jp', 'Kode_Jp', '[Kode_Jp]', '[Kode_Jp]', 129, 4, -1, FALSE, '[Kode_Jp]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->Kode_Jp->IsPrimaryKey = TRUE; // Primary key field
		$this->Kode_Jp->Nullable = FALSE; // NOT NULL field
		$this->Kode_Jp->Required = TRUE; // Required field
		$this->Kode_Jp->Sortable = TRUE; // Allow sort
		$this->Kode_Jp->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->Kode_Jp->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
		$this->Kode_Jp->Lookup = new Lookup('Kode_Jp', 'TblJurusan', FALSE, 'Kode_Jp', ["Program","Jurusan","",""], [], [], [], [], [], [], '', '');
		$this->fields['Kode_Jp'] = &$this->Kode_Jp;

		// NimIM
		$this->NimIM = new DbField('ekpt_mhsfeed', 'ekpt_mhsfeed', 'x_NimIM', 'NimIM', '[NimIM]', '[NimIM]', 129, 14, -1, FALSE, '[NimIM]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->NimIM->IsPrimaryKey = TRUE; // Primary key field
		$this->NimIM->IsForeignKey = TRUE; // Foreign key field
		$this->NimIM->Nullable = FALSE; // NOT NULL field
		$this->NimIM->Required = TRUE; // Required field
		$this->NimIM->Sortable = TRUE; // Allow sort
		$this->fields['NimIM'] = &$this->NimIM;

		// Nim
		$this->Nim = new DbField('ekpt_mhsfeed', 'ekpt_mhsfeed', 'x_Nim', 'Nim', '[Nim]', '[Nim]', 200, 50, -1, FALSE, '[Nim]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Nim->IsForeignKey = TRUE; // Foreign key field
		$this->Nim->Sortable = TRUE; // Allow sort
		$this->fields['Nim'] = &$this->Nim;

		// NamaMhs
		$this->NamaMhs = new DbField('ekpt_mhsfeed', 'ekpt_mhsfeed', 'x_NamaMhs', 'NamaMhs', '[NamaMhs]', '[NamaMhs]', 200, 50, -1, FALSE, '[NamaMhs]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->NamaMhs->Sortable = TRUE; // Allow sort
		$this->fields['NamaMhs'] = &$this->NamaMhs;

		// Status_Akd
		$this->Status_Akd = new DbField('ekpt_mhsfeed', 'ekpt_mhsfeed', 'x_Status_Akd', 'Status_Akd', '[Status_Akd]', '[Status_Akd]', 200, 15, -1, FALSE, '[Status_Akd]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->Status_Akd->Sortable = TRUE; // Allow sort
		$this->Status_Akd->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->Status_Akd->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
		$this->Status_Akd->Lookup = new Lookup('Status_Akd', 'tblkelas', FALSE, 'Kelas', ["Kelas","","",""], [], [], [], [], [], [], '', '');
		$this->fields['Status_Akd'] = &$this->Status_Akd;

		// TglLahir
		$this->TglLahir = new DbField('ekpt_mhsfeed', 'ekpt_mhsfeed', 'x_TglLahir', 'TglLahir', '[TglLahir]', '[TglLahir]', 200, 50, -1, FALSE, '[TglLahir]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->TglLahir->Sortable = TRUE; // Allow sort
		$this->fields['TglLahir'] = &$this->TglLahir;

		// TSKS
		$this->TSKS = new DbField('ekpt_mhsfeed', 'ekpt_mhsfeed', 'x_TSKS', 'TSKS', '[TSKS]', '[TSKS]', 200, 50, -1, FALSE, '[TSKS]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->TSKS->Sortable = TRUE; // Allow sort
		$this->fields['TSKS'] = &$this->TSKS;

		// Prodi
		$this->Prodi = new DbField('ekpt_mhsfeed', 'ekpt_mhsfeed', 'x_Prodi', 'Prodi', '[Prodi]', '[Prodi]', 200, 50, -1, FALSE, '[Prodi]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Prodi->Sortable = TRUE; // Allow sort
		$this->fields['Prodi'] = &$this->Prodi;

		// PerMasuk
		$this->PerMasuk = new DbField('ekpt_mhsfeed', 'ekpt_mhsfeed', 'x_PerMasuk', 'PerMasuk', '[PerMasuk]', '[PerMasuk]', 200, 50, -1, FALSE, '[PerMasuk]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->PerMasuk->Sortable = TRUE; // Allow sort
		$this->fields['PerMasuk'] = &$this->PerMasuk;

		// Status
		$this->Status = new DbField('ekpt_mhsfeed', 'ekpt_mhsfeed', 'x_Status', 'Status', '[Status]', '[Status]', 200, 50, -1, FALSE, '[Status]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->Status->Sortable = TRUE; // Allow sort
		$this->Status->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->Status->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
		$this->Status->Lookup = new Lookup('Status', 'ekpt_mhsfeed', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->Status->OptionCount = 7;
		$this->fields['Status'] = &$this->Status;

		// PerKeluar
		$this->PerKeluar = new DbField('ekpt_mhsfeed', 'ekpt_mhsfeed', 'x_PerKeluar', 'PerKeluar', '[PerKeluar]', '[PerKeluar]', 200, 50, -1, FALSE, '[PerKeluar]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->PerKeluar->Sortable = TRUE; // Allow sort
		$this->fields['PerKeluar'] = &$this->PerKeluar;

		// TglKeluar
		$this->TglKeluar = new DbField('ekpt_mhsfeed', 'ekpt_mhsfeed', 'x_TglKeluar', 'TglKeluar', '[TglKeluar]', '[TglKeluar]', 200, 50, -1, FALSE, '[TglKeluar]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->TglKeluar->Sortable = TRUE; // Allow sort
		$this->fields['TglKeluar'] = &$this->TglKeluar;

		// Nama_Mhs
		$this->Nama_Mhs = new DbField('ekpt_mhsfeed', 'ekpt_mhsfeed', 'x_Nama_Mhs', 'Nama_Mhs', '[Nama_Mhs]', '[Nama_Mhs]', 129, 60, -1, FALSE, '[Nama_Mhs]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Nama_Mhs->Sortable = TRUE; // Allow sort
		$this->fields['Nama_Mhs'] = &$this->Nama_Mhs;

		// Tmp_Lahir
		$this->Tmp_Lahir = new DbField('ekpt_mhsfeed', 'ekpt_mhsfeed', 'x_Tmp_Lahir', 'Tmp_Lahir', '[Tmp_Lahir]', '[Tmp_Lahir]', 129, 40, -1, FALSE, '[Tmp_Lahir]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Tmp_Lahir->Sortable = TRUE; // Allow sort
		$this->fields['Tmp_Lahir'] = &$this->Tmp_Lahir;

		// Tgl_Lahir
		$this->Tgl_Lahir = new DbField('ekpt_mhsfeed', 'ekpt_mhsfeed', 'x_Tgl_Lahir', 'Tgl_Lahir', '[Tgl_Lahir]', CastDateFieldForLike("[Tgl_Lahir]", 7, "DB"), 135, 8, 7, FALSE, '[Tgl_Lahir]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Tgl_Lahir->Sortable = TRUE; // Allow sort
		$this->Tgl_Lahir->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_SEPARATOR"], $Language->phrase("IncorrectDateDMY"));
		$this->fields['Tgl_Lahir'] = &$this->Tgl_Lahir;

		// StatusSIAP
		$this->StatusSIAP = new DbField('ekpt_mhsfeed', 'ekpt_mhsfeed', 'x_StatusSIAP', 'StatusSIAP', '[StatusSIAP]', '[StatusSIAP]', 129, 10, -1, FALSE, '[StatusSIAP]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->StatusSIAP->Sortable = TRUE; // Allow sort
		$this->StatusSIAP->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->StatusSIAP->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
		$this->StatusSIAP->Lookup = new Lookup('StatusSIAP', 'ekpt_mhsfeed', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->StatusSIAP->OptionCount = 5;
		$this->fields['StatusSIAP'] = &$this->StatusSIAP;

		// PerMasukIM
		$this->PerMasukIM = new DbField('ekpt_mhsfeed', 'ekpt_mhsfeed', 'x_PerMasukIM', 'PerMasukIM', '[PerMasukIM]', '[PerMasukIM]', 200, 6, -1, FALSE, '[PerMasukIM]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->PerMasukIM->Sortable = TRUE; // Allow sort
		$this->fields['PerMasukIM'] = &$this->PerMasukIM;

		// TaMasuk
		$this->TaMasuk = new DbField('ekpt_mhsfeed', 'ekpt_mhsfeed', 'x_TaMasuk', 'TaMasuk', '[TaMasuk]', '[TaMasuk]', 129, 9, -1, FALSE, '[TaMasuk]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->TaMasuk->Sortable = TRUE; // Allow sort
		$this->TaMasuk->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->TaMasuk->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
		$this->TaMasuk->Lookup = new Lookup('TaMasuk', 'Qthakd', FALSE, 'TA', ["TA","","",""], [], [], [], [], [], [], '', '');
		$this->fields['TaMasuk'] = &$this->TaMasuk;

		// PMasuk
		$this->PMasuk = new DbField('ekpt_mhsfeed', 'ekpt_mhsfeed', 'x_PMasuk', 'PMasuk', '[PMasuk]', '[PMasuk]', 129, 2, -1, FALSE, '[PMasuk]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->PMasuk->Sortable = TRUE; // Allow sort
		$this->PMasuk->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->PMasuk->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
		$this->PMasuk->Lookup = new Lookup('PMasuk', 'ekpt_mhsfeed', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->PMasuk->OptionCount = 3;
		$this->fields['PMasuk'] = &$this->PMasuk;

		// tglmasuk
		$this->tglmasuk = new DbField('ekpt_mhsfeed', 'ekpt_mhsfeed', 'x_tglmasuk', 'tglmasuk', '[tglmasuk]', CastDateFieldForLike("[tglmasuk]", 7, "DB"), 135, 8, 7, FALSE, '[tglmasuk]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->tglmasuk->Sortable = TRUE; // Allow sort
		$this->tglmasuk->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_SEPARATOR"], $Language->phrase("IncorrectDateDMY"));
		$this->fields['tglmasuk'] = &$this->tglmasuk;

		// Status_Masuk
		$this->Status_Masuk = new DbField('ekpt_mhsfeed', 'ekpt_mhsfeed', 'x_Status_Masuk', 'Status_Masuk', '[Status_Masuk]', '[Status_Masuk]', 129, 10, -1, FALSE, '[Status_Masuk]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Status_Masuk->Sortable = TRUE; // Allow sort
		$this->fields['Status_Masuk'] = &$this->Status_Masuk;

		// JalurMasuk
		$this->JalurMasuk = new DbField('ekpt_mhsfeed', 'ekpt_mhsfeed', 'x_JalurMasuk', 'JalurMasuk', '[JalurMasuk]', '[JalurMasuk]', 200, 20, -1, FALSE, '[JalurMasuk]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->JalurMasuk->Sortable = TRUE; // Allow sort
		$this->fields['JalurMasuk'] = &$this->JalurMasuk;

		// PerLulusIM
		$this->PerLulusIM = new DbField('ekpt_mhsfeed', 'ekpt_mhsfeed', 'x_PerLulusIM', 'PerLulusIM', '[PerLulusIM]', '[PerLulusIM]', 200, 6, -1, FALSE, '[PerLulusIM]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->PerLulusIM->Sortable = TRUE; // Allow sort
		$this->fields['PerLulusIM'] = &$this->PerLulusIM;

		// Tgl_Lulus
		$this->Tgl_Lulus = new DbField('ekpt_mhsfeed', 'ekpt_mhsfeed', 'x_Tgl_Lulus', 'Tgl_Lulus', '[Tgl_Lulus]', CastDateFieldForLike("[Tgl_Lulus]", 7, "DB"), 135, 8, 7, FALSE, '[Tgl_Lulus]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Tgl_Lulus->Sortable = TRUE; // Allow sort
		$this->Tgl_Lulus->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_SEPARATOR"], $Language->phrase("IncorrectDateDMY"));
		$this->fields['Tgl_Lulus'] = &$this->Tgl_Lulus;

		// No_Ijazah
		$this->No_Ijazah = new DbField('ekpt_mhsfeed', 'ekpt_mhsfeed', 'x_No_Ijazah', 'No_Ijazah', '[No_Ijazah]', '[No_Ijazah]', 129, 100, -1, FALSE, '[No_Ijazah]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->No_Ijazah->Sortable = TRUE; // Allow sort
		$this->fields['No_Ijazah'] = &$this->No_Ijazah;

		// TA
		$this->TA = new DbField('ekpt_mhsfeed', 'ekpt_mhsfeed', 'x_TA', 'TA', '[TA]', '[TA]', 129, 9, -1, FALSE, '[TA]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->TA->Sortable = TRUE; // Allow sort
		$this->fields['TA'] = &$this->TA;

		// per
		$this->per = new DbField('ekpt_mhsfeed', 'ekpt_mhsfeed', 'x_per', 'per', '[per]', '[per]', 129, 2, -1, FALSE, '[per]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->per->Sortable = TRUE; // Allow sort
		$this->fields['per'] = &$this->per;

		// ProdiIM
		$this->ProdiIM = new DbField('ekpt_mhsfeed', 'ekpt_mhsfeed', 'x_ProdiIM', 'ProdiIM', '[ProdiIM]', '[ProdiIM]', 200, 32, -1, FALSE, '[ProdiIM]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->ProdiIM->Sortable = TRUE; // Allow sort
		$this->fields['ProdiIM'] = &$this->ProdiIM;

		// TaAkhir
		$this->TaAkhir = new DbField('ekpt_mhsfeed', 'ekpt_mhsfeed', 'x_TaAkhir', 'TaAkhir', '[TaAkhir]', '[TaAkhir]', 200, 6, -1, FALSE, '[TaAkhir]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->TaAkhir->Sortable = TRUE; // Allow sort
		$this->fields['TaAkhir'] = &$this->TaAkhir;

		// xphoto
		$this->xphoto = new DbField('ekpt_mhsfeed', 'ekpt_mhsfeed', 'x_xphoto', 'xphoto', '[xphoto]', '[xphoto]', 200, 100, -1, FALSE, '[xphoto]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->xphoto->Sortable = TRUE; // Allow sort
		$this->fields['xphoto'] = &$this->xphoto;

		// Ijazah
		$this->Ijazah = new DbField('ekpt_mhsfeed', 'ekpt_mhsfeed', 'x_Ijazah', 'Ijazah', '[Ijazah]', '[Ijazah]', 200, 150, -1, FALSE, '[Ijazah]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Ijazah->Sortable = TRUE; // Allow sort
		$this->fields['Ijazah'] = &$this->Ijazah;

		// Ktp
		$this->Ktp = new DbField('ekpt_mhsfeed', 'ekpt_mhsfeed', 'x_Ktp', 'Ktp', '[Ktp]', '[Ktp]', 200, 150, -1, FALSE, '[Ktp]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Ktp->Sortable = TRUE; // Allow sort
		$this->fields['Ktp'] = &$this->Ktp;

		// KK
		$this->KK = new DbField('ekpt_mhsfeed', 'ekpt_mhsfeed', 'x_KK', 'KK', '[KK]', '[KK]', 200, 150, -1, FALSE, '[KK]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->KK->Sortable = TRUE; // Allow sort
		$this->fields['KK'] = &$this->KK;

		// riwayatakademik
		$this->riwayatakademik = new DbField('ekpt_mhsfeed', 'ekpt_mhsfeed', 'x_riwayatakademik', 'riwayatakademik', '[riwayatakademik]', '[riwayatakademik]', 200, 150, -1, FALSE, '[riwayatakademik]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->riwayatakademik->Sortable = TRUE; // Allow sort
		$this->fields['riwayatakademik'] = &$this->riwayatakademik;

		// IjazahIM
		$this->IjazahIM = new DbField('ekpt_mhsfeed', 'ekpt_mhsfeed', 'x_IjazahIM', 'IjazahIM', '[IjazahIM]', '[IjazahIM]', 200, 150, -1, FALSE, '[IjazahIM]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->IjazahIM->Sortable = TRUE; // Allow sort
		$this->fields['IjazahIM'] = &$this->IjazahIM;

		// TranskriptIM
		$this->TranskriptIM = new DbField('ekpt_mhsfeed', 'ekpt_mhsfeed', 'x_TranskriptIM', 'TranskriptIM', '[TranskriptIM]', '[TranskriptIM]', 200, 150, -1, FALSE, '[TranskriptIM]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->TranskriptIM->Sortable = TRUE; // Allow sort
		$this->fields['TranskriptIM'] = &$this->TranskriptIM;

		// Skripsi
		$this->Skripsi = new DbField('ekpt_mhsfeed', 'ekpt_mhsfeed', 'x_Skripsi', 'Skripsi', '[Skripsi]', '[Skripsi]', 200, 150, -1, FALSE, '[Skripsi]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Skripsi->Sortable = TRUE; // Allow sort
		$this->fields['Skripsi'] = &$this->Skripsi;

		// TASkripsi
		$this->TASkripsi = new DbField('ekpt_mhsfeed', 'ekpt_mhsfeed', 'x_TASkripsi', 'TASkripsi', '[TASkripsi]', '[TASkripsi]', 200, 70, -1, FALSE, '[TASkripsi]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->TASkripsi->Sortable = TRUE; // Allow sort
		$this->fields['TASkripsi'] = &$this->TASkripsi;

		// Plagiat
		$this->Plagiat = new DbField('ekpt_mhsfeed', 'ekpt_mhsfeed', 'x_Plagiat', 'Plagiat', '[Plagiat]', '[Plagiat]', 200, 150, -1, FALSE, '[Plagiat]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Plagiat->Sortable = TRUE; // Allow sort
		$this->fields['Plagiat'] = &$this->Plagiat;

		// keuangan
		$this->keuangan = new DbField('ekpt_mhsfeed', 'ekpt_mhsfeed', 'x_keuangan', 'keuangan', '[keuangan]', '[keuangan]', 200, 150, -1, FALSE, '[keuangan]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->keuangan->Sortable = TRUE; // Allow sort
		$this->fields['keuangan'] = &$this->keuangan;

		// pendukung
		$this->pendukung = new DbField('ekpt_mhsfeed', 'ekpt_mhsfeed', 'x_pendukung', 'pendukung', '[pendukung]', '[pendukung]', 200, 150, -1, FALSE, '[pendukung]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->pendukung->Sortable = TRUE; // Allow sort
		$this->fields['pendukung'] = &$this->pendukung;

		// lainlain
		$this->lainlain = new DbField('ekpt_mhsfeed', 'ekpt_mhsfeed', 'x_lainlain', 'lainlain', '[lainlain]', '[lainlain]', 200, 150, -1, FALSE, '[lainlain]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->lainlain->Sortable = TRUE; // Allow sort
		$this->fields['lainlain'] = &$this->lainlain;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Single column sort
	public function updateSort(&$fld)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
		} else {
			$fld->setSort("");
		}
	}

	// Current detail table name
	public function getCurrentDetailTable()
	{
		return @$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_DETAIL_TABLE")];
	}
	public function setCurrentDetailTable($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_DETAIL_TABLE")] = $v;
	}

	// Get detail url
	public function getDetailUrl()
	{

		// Detail url
		$detailUrl = "";
		if ($this->getCurrentDetailTable() == "docmhs") {
			$detailUrl = $GLOBALS["docmhs"]->getListUrl() . "?" . Config("TABLE_SHOW_MASTER") . "=" . $this->TableVar;
			$detailUrl .= "&fk_Nim=" . urlencode($this->Nim->CurrentValue);
		}
		if ($this->getCurrentDetailTable() == "Wali_IPS") {
			$detailUrl = $GLOBALS["Wali_IPS"]->getListUrl() . "?" . Config("TABLE_SHOW_MASTER") . "=" . $this->TableVar;
			$detailUrl .= "&fk_NimIM=" . urlencode($this->NimIM->CurrentValue);
		}
		if ($this->getCurrentDetailTable() == "tblMHSEkpt") {
			$detailUrl = $GLOBALS["tblMHSEkpt"]->getListUrl() . "?" . Config("TABLE_SHOW_MASTER") . "=" . $this->TableVar;
			$detailUrl .= "&fk_NimIM=" . urlencode($this->NimIM->CurrentValue);
		}
		if ($detailUrl == "")
			$detailUrl = "ekpt_mhsfeedlist.php";
		return $detailUrl;
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom != "") ? $this->SqlFrom : "[dbo].[ekpt_mhsfeed]";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect != "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy != "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving != "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter, $id = "")
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = $this->UserIDAllowSecurity;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 32) == 32);
			case "search":
				return (($allow & 64) == 64);
			case "lookup":
				return (($allow & 256) == 256);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get recordset
	public function getRecordset($sql, $rowcnt = -1, $offset = -1)
	{
		$conn = $this->getConnection();
		$conn->raiseErrorFn = Config("ERROR_FUNC");
		$rs = $conn->selectLimit($sql, $rowcnt, $offset);
		$conn->raiseErrorFn = "";
		return $rs;
	}

	// Get record count
	public function getRecordCount($sql, $c = NULL)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) &&
			!preg_match('/^\s*select\s+distinct\s+/i', $sql) && !preg_match('/\s+order\s+by\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = $c ?: $this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->getSqlSelect();
		$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " (" . $names . ") VALUES (" . $values . ")";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = $this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsAutoIncrement)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter != "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = $this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('Kode_Jp', $rs))
				AddFilter($where, QuotedName('Kode_Jp', $this->Dbid) . '=' . QuotedValue($rs['Kode_Jp'], $this->Kode_Jp->DataType, $this->Dbid));
			if (array_key_exists('NimIM', $rs))
				AddFilter($where, QuotedName('NimIM', $this->Dbid) . '=' . QuotedValue($rs['NimIM'], $this->NimIM->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter != "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = $this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->Kode_Fak->DbValue = $row['Kode_Fak'];
		$this->Kode_Jp->DbValue = $row['Kode_Jp'];
		$this->NimIM->DbValue = $row['NimIM'];
		$this->Nim->DbValue = $row['Nim'];
		$this->NamaMhs->DbValue = $row['NamaMhs'];
		$this->Status_Akd->DbValue = $row['Status_Akd'];
		$this->TglLahir->DbValue = $row['TglLahir'];
		$this->TSKS->DbValue = $row['TSKS'];
		$this->Prodi->DbValue = $row['Prodi'];
		$this->PerMasuk->DbValue = $row['PerMasuk'];
		$this->Status->DbValue = $row['Status'];
		$this->PerKeluar->DbValue = $row['PerKeluar'];
		$this->TglKeluar->DbValue = $row['TglKeluar'];
		$this->Nama_Mhs->DbValue = $row['Nama_Mhs'];
		$this->Tmp_Lahir->DbValue = $row['Tmp_Lahir'];
		$this->Tgl_Lahir->DbValue = $row['Tgl_Lahir'];
		$this->StatusSIAP->DbValue = $row['StatusSIAP'];
		$this->PerMasukIM->DbValue = $row['PerMasukIM'];
		$this->TaMasuk->DbValue = $row['TaMasuk'];
		$this->PMasuk->DbValue = $row['PMasuk'];
		$this->tglmasuk->DbValue = $row['tglmasuk'];
		$this->Status_Masuk->DbValue = $row['Status_Masuk'];
		$this->JalurMasuk->DbValue = $row['JalurMasuk'];
		$this->PerLulusIM->DbValue = $row['PerLulusIM'];
		$this->Tgl_Lulus->DbValue = $row['Tgl_Lulus'];
		$this->No_Ijazah->DbValue = $row['No_Ijazah'];
		$this->TA->DbValue = $row['TA'];
		$this->per->DbValue = $row['per'];
		$this->ProdiIM->DbValue = $row['ProdiIM'];
		$this->TaAkhir->DbValue = $row['TaAkhir'];
		$this->xphoto->DbValue = $row['xphoto'];
		$this->Ijazah->DbValue = $row['Ijazah'];
		$this->Ktp->DbValue = $row['Ktp'];
		$this->KK->DbValue = $row['KK'];
		$this->riwayatakademik->DbValue = $row['riwayatakademik'];
		$this->IjazahIM->DbValue = $row['IjazahIM'];
		$this->TranskriptIM->DbValue = $row['TranskriptIM'];
		$this->Skripsi->DbValue = $row['Skripsi'];
		$this->TASkripsi->DbValue = $row['TASkripsi'];
		$this->Plagiat->DbValue = $row['Plagiat'];
		$this->keuangan->DbValue = $row['keuangan'];
		$this->pendukung->DbValue = $row['pendukung'];
		$this->lainlain->DbValue = $row['lainlain'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "[Kode_Jp] = '@Kode_Jp@' AND [NimIM] = '@NimIM@'";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		if (is_array($row))
			$val = array_key_exists('Kode_Jp', $row) ? $row['Kode_Jp'] : NULL;
		else
			$val = $this->Kode_Jp->OldValue !== NULL ? $this->Kode_Jp->OldValue : $this->Kode_Jp->CurrentValue;
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@Kode_Jp@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		if (is_array($row))
			$val = array_key_exists('NimIM', $row) ? $row['NimIM'] : NULL;
		else
			$val = $this->NimIM->OldValue !== NULL ? $this->NimIM->OldValue : $this->NimIM->CurrentValue;
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@NimIM@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") != "" && ReferPageName() != CurrentPageName() && ReferPageName() != "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] != "") {
			return $_SESSION[$name];
		} else {
			return "ekpt_mhsfeedlist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "ekpt_mhsfeedview.php")
			return $Language->phrase("View");
		elseif ($pageName == "ekpt_mhsfeededit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "ekpt_mhsfeedadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "ekpt_mhsfeedlist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm != "")
			$url = $this->keyUrl("ekpt_mhsfeedview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("ekpt_mhsfeedview.php", $this->getUrlParm(Config("TABLE_SHOW_DETAIL") . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm != "")
			$url = "ekpt_mhsfeedadd.php?" . $this->getUrlParm($parm);
		else
			$url = "ekpt_mhsfeedadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		if ($parm != "")
			$url = $this->keyUrl("ekpt_mhsfeededit.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("ekpt_mhsfeededit.php", $this->getUrlParm(Config("TABLE_SHOW_DETAIL") . "="));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		if ($parm != "")
			$url = $this->keyUrl("ekpt_mhsfeedadd.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("ekpt_mhsfeedadd.php", $this->getUrlParm(Config("TABLE_SHOW_DETAIL") . "="));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("ekpt_mhsfeeddelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "Kode_Jp:" . JsonEncode($this->Kode_Jp->CurrentValue, "string");
		$json .= ",NimIM:" . JsonEncode($this->NimIM->CurrentValue, "string");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm != "")
			$url .= $parm . "&";
		if ($this->Kode_Jp->CurrentValue != NULL) {
			$url .= "Kode_Jp=" . urlencode($this->Kode_Jp->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		if ($this->NimIM->CurrentValue != NULL) {
			$url .= "&NimIM=" . urlencode($this->NimIM->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, [141, 201, 203, 128, 204, 205])) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		$arKeys = [];
		$arKey = [];
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
			for ($i = 0; $i < $cnt; $i++)
				$arKeys[$i] = explode(Config("COMPOSITE_KEY_SEPARATOR"), $arKeys[$i]);
		} else {
			if (Param("Kode_Jp") !== NULL)
				$arKey[] = Param("Kode_Jp");
			elseif (IsApi() && Key(0) !== NULL)
				$arKey[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKey[] = Route(2);
			else
				$arKeys = NULL; // Do not setup
			if (Param("NimIM") !== NULL)
				$arKey[] = Param("NimIM");
			elseif (IsApi() && Key(1) !== NULL)
				$arKey[] = Key(1);
			elseif (IsApi() && Route(3) !== NULL)
				$arKey[] = Route(3);
			else
				$arKeys = NULL; // Do not setup
			if (is_array($arKeys)) $arKeys[] = $arKey;

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = [];
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_array($key) || count($key) != 2)
					continue; // Just skip so other keys will still work
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys($setCurrent = TRUE)
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter != "") $keyFilter .= " OR ";
			if ($setCurrent)
				$this->Kode_Jp->CurrentValue = $key[0];
			else
				$this->Kode_Jp->OldValue = $key[0];
			if ($setCurrent)
				$this->NimIM->CurrentValue = $key[1];
			else
				$this->NimIM->OldValue = $key[1];
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = $this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->Kode_Fak->setDbValue($rs->fields('Kode_Fak'));
		$this->Kode_Jp->setDbValue($rs->fields('Kode_Jp'));
		$this->NimIM->setDbValue($rs->fields('NimIM'));
		$this->Nim->setDbValue($rs->fields('Nim'));
		$this->NamaMhs->setDbValue($rs->fields('NamaMhs'));
		$this->Status_Akd->setDbValue($rs->fields('Status_Akd'));
		$this->TglLahir->setDbValue($rs->fields('TglLahir'));
		$this->TSKS->setDbValue($rs->fields('TSKS'));
		$this->Prodi->setDbValue($rs->fields('Prodi'));
		$this->PerMasuk->setDbValue($rs->fields('PerMasuk'));
		$this->Status->setDbValue($rs->fields('Status'));
		$this->PerKeluar->setDbValue($rs->fields('PerKeluar'));
		$this->TglKeluar->setDbValue($rs->fields('TglKeluar'));
		$this->Nama_Mhs->setDbValue($rs->fields('Nama_Mhs'));
		$this->Tmp_Lahir->setDbValue($rs->fields('Tmp_Lahir'));
		$this->Tgl_Lahir->setDbValue($rs->fields('Tgl_Lahir'));
		$this->StatusSIAP->setDbValue($rs->fields('StatusSIAP'));
		$this->PerMasukIM->setDbValue($rs->fields('PerMasukIM'));
		$this->TaMasuk->setDbValue($rs->fields('TaMasuk'));
		$this->PMasuk->setDbValue($rs->fields('PMasuk'));
		$this->tglmasuk->setDbValue($rs->fields('tglmasuk'));
		$this->Status_Masuk->setDbValue($rs->fields('Status_Masuk'));
		$this->JalurMasuk->setDbValue($rs->fields('JalurMasuk'));
		$this->PerLulusIM->setDbValue($rs->fields('PerLulusIM'));
		$this->Tgl_Lulus->setDbValue($rs->fields('Tgl_Lulus'));
		$this->No_Ijazah->setDbValue($rs->fields('No_Ijazah'));
		$this->TA->setDbValue($rs->fields('TA'));
		$this->per->setDbValue($rs->fields('per'));
		$this->ProdiIM->setDbValue($rs->fields('ProdiIM'));
		$this->TaAkhir->setDbValue($rs->fields('TaAkhir'));
		$this->xphoto->setDbValue($rs->fields('xphoto'));
		$this->Ijazah->setDbValue($rs->fields('Ijazah'));
		$this->Ktp->setDbValue($rs->fields('Ktp'));
		$this->KK->setDbValue($rs->fields('KK'));
		$this->riwayatakademik->setDbValue($rs->fields('riwayatakademik'));
		$this->IjazahIM->setDbValue($rs->fields('IjazahIM'));
		$this->TranskriptIM->setDbValue($rs->fields('TranskriptIM'));
		$this->Skripsi->setDbValue($rs->fields('Skripsi'));
		$this->TASkripsi->setDbValue($rs->fields('TASkripsi'));
		$this->Plagiat->setDbValue($rs->fields('Plagiat'));
		$this->keuangan->setDbValue($rs->fields('keuangan'));
		$this->pendukung->setDbValue($rs->fields('pendukung'));
		$this->lainlain->setDbValue($rs->fields('lainlain'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// Kode_Fak
		// Kode_Jp
		// NimIM
		// Nim
		// NamaMhs
		// Status_Akd
		// TglLahir
		// TSKS
		// Prodi
		// PerMasuk
		// Status
		// PerKeluar
		// TglKeluar
		// Nama_Mhs
		// Tmp_Lahir
		// Tgl_Lahir
		// StatusSIAP
		// PerMasukIM
		// TaMasuk
		// PMasuk
		// tglmasuk
		// Status_Masuk
		// JalurMasuk
		// PerLulusIM
		// Tgl_Lulus
		// No_Ijazah
		// TA
		// per
		// ProdiIM
		// TaAkhir
		// xphoto
		// Ijazah
		// Ktp
		// KK
		// riwayatakademik
		// IjazahIM
		// TranskriptIM
		// Skripsi
		// TASkripsi
		// Plagiat
		// keuangan
		// pendukung
		// lainlain
		// Kode_Fak

		$curVal = strval($this->Kode_Fak->CurrentValue);
		if ($curVal != "") {
			$this->Kode_Fak->ViewValue = $this->Kode_Fak->lookupCacheOption($curVal);
			if ($this->Kode_Fak->ViewValue === NULL) { // Lookup from database
				$filterWrk = "[Kode_Fak]" . SearchString("=", $curVal, DATATYPE_STRING, "");
				$sqlWrk = $this->Kode_Fak->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = [];
					$arwrk[1] = $rswrk->fields('df');
					$this->Kode_Fak->ViewValue = $this->Kode_Fak->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->Kode_Fak->ViewValue = $this->Kode_Fak->CurrentValue;
				}
			}
		} else {
			$this->Kode_Fak->ViewValue = NULL;
		}
		$this->Kode_Fak->ViewCustomAttributes = "";

		// Kode_Jp
		$curVal = strval($this->Kode_Jp->CurrentValue);
		if ($curVal != "") {
			$this->Kode_Jp->ViewValue = $this->Kode_Jp->lookupCacheOption($curVal);
			if ($this->Kode_Jp->ViewValue === NULL) { // Lookup from database
				$filterWrk = "[Kode_Jp]" . SearchString("=", $curVal, DATATYPE_STRING, "");
				$sqlWrk = $this->Kode_Jp->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = [];
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->Kode_Jp->ViewValue = $this->Kode_Jp->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->Kode_Jp->ViewValue = $this->Kode_Jp->CurrentValue;
				}
			}
		} else {
			$this->Kode_Jp->ViewValue = NULL;
		}
		$this->Kode_Jp->ViewCustomAttributes = "";

		// NimIM
		$this->NimIM->ViewValue = $this->NimIM->CurrentValue;
		$this->NimIM->ViewCustomAttributes = "";

		// Nim
		$this->Nim->ViewValue = $this->Nim->CurrentValue;
		$this->Nim->ViewCustomAttributes = "";

		// NamaMhs
		$this->NamaMhs->ViewValue = $this->NamaMhs->CurrentValue;
		$this->NamaMhs->ViewCustomAttributes = "";

		// Status_Akd
		$curVal = strval($this->Status_Akd->CurrentValue);
		if ($curVal != "") {
			$this->Status_Akd->ViewValue = $this->Status_Akd->lookupCacheOption($curVal);
			if ($this->Status_Akd->ViewValue === NULL) { // Lookup from database
				$filterWrk = "[Kelas]" . SearchString("=", $curVal, DATATYPE_STRING, "");
				$sqlWrk = $this->Status_Akd->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = [];
					$arwrk[1] = $rswrk->fields('df');
					$this->Status_Akd->ViewValue = $this->Status_Akd->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->Status_Akd->ViewValue = $this->Status_Akd->CurrentValue;
				}
			}
		} else {
			$this->Status_Akd->ViewValue = NULL;
		}
		$this->Status_Akd->ViewCustomAttributes = "";

		// TglLahir
		$this->TglLahir->ViewValue = $this->TglLahir->CurrentValue;
		$this->TglLahir->ViewCustomAttributes = "";

		// TSKS
		$this->TSKS->ViewValue = $this->TSKS->CurrentValue;
		$this->TSKS->ViewCustomAttributes = "";

		// Prodi
		$this->Prodi->ViewValue = $this->Prodi->CurrentValue;
		$this->Prodi->ViewCustomAttributes = "";

		// PerMasuk
		$this->PerMasuk->ViewValue = $this->PerMasuk->CurrentValue;
		$this->PerMasuk->ViewCustomAttributes = "";

		// Status
		if (strval($this->Status->CurrentValue) != "") {
			$this->Status->ViewValue = $this->Status->optionCaption($this->Status->CurrentValue);
		} else {
			$this->Status->ViewValue = NULL;
		}
		$this->Status->ViewCustomAttributes = "";

		// PerKeluar
		$this->PerKeluar->ViewValue = $this->PerKeluar->CurrentValue;
		$this->PerKeluar->ViewCustomAttributes = "";

		// TglKeluar
		$this->TglKeluar->ViewValue = $this->TglKeluar->CurrentValue;
		$this->TglKeluar->ViewCustomAttributes = "";

		// Nama_Mhs
		$this->Nama_Mhs->ViewValue = $this->Nama_Mhs->CurrentValue;
		$this->Nama_Mhs->ViewCustomAttributes = "";

		// Tmp_Lahir
		$this->Tmp_Lahir->ViewValue = $this->Tmp_Lahir->CurrentValue;
		$this->Tmp_Lahir->ViewCustomAttributes = "";

		// Tgl_Lahir
		$this->Tgl_Lahir->ViewValue = $this->Tgl_Lahir->CurrentValue;
		$this->Tgl_Lahir->ViewValue = FormatDateTime($this->Tgl_Lahir->ViewValue, 7);
		$this->Tgl_Lahir->ViewCustomAttributes = "";

		// StatusSIAP
		if (strval($this->StatusSIAP->CurrentValue) != "") {
			$this->StatusSIAP->ViewValue = $this->StatusSIAP->optionCaption($this->StatusSIAP->CurrentValue);
		} else {
			$this->StatusSIAP->ViewValue = NULL;
		}
		$this->StatusSIAP->ViewCustomAttributes = "";

		// PerMasukIM
		$this->PerMasukIM->ViewValue = $this->PerMasukIM->CurrentValue;
		$this->PerMasukIM->ViewCustomAttributes = "";

		// TaMasuk
		$curVal = strval($this->TaMasuk->CurrentValue);
		if ($curVal != "") {
			$this->TaMasuk->ViewValue = $this->TaMasuk->lookupCacheOption($curVal);
			if ($this->TaMasuk->ViewValue === NULL) { // Lookup from database
				$filterWrk = "[TA]" . SearchString("=", $curVal, DATATYPE_STRING, "");
				$sqlWrk = $this->TaMasuk->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = [];
					$arwrk[1] = $rswrk->fields('df');
					$this->TaMasuk->ViewValue = $this->TaMasuk->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->TaMasuk->ViewValue = $this->TaMasuk->CurrentValue;
				}
			}
		} else {
			$this->TaMasuk->ViewValue = NULL;
		}
		$this->TaMasuk->ViewCustomAttributes = "";

		// PMasuk
		if (strval($this->PMasuk->CurrentValue) != "") {
			$this->PMasuk->ViewValue = $this->PMasuk->optionCaption($this->PMasuk->CurrentValue);
		} else {
			$this->PMasuk->ViewValue = NULL;
		}
		$this->PMasuk->ViewCustomAttributes = "";

		// tglmasuk
		$this->tglmasuk->ViewValue = $this->tglmasuk->CurrentValue;
		$this->tglmasuk->ViewValue = FormatDateTime($this->tglmasuk->ViewValue, 7);
		$this->tglmasuk->ViewCustomAttributes = "";

		// Status_Masuk
		$this->Status_Masuk->ViewValue = $this->Status_Masuk->CurrentValue;
		$this->Status_Masuk->ViewCustomAttributes = "";

		// JalurMasuk
		$this->JalurMasuk->ViewValue = $this->JalurMasuk->CurrentValue;
		$this->JalurMasuk->ViewCustomAttributes = "";

		// PerLulusIM
		$this->PerLulusIM->ViewValue = $this->PerLulusIM->CurrentValue;
		$this->PerLulusIM->ViewCustomAttributes = "";

		// Tgl_Lulus
		$this->Tgl_Lulus->ViewValue = $this->Tgl_Lulus->CurrentValue;
		$this->Tgl_Lulus->ViewValue = FormatDateTime($this->Tgl_Lulus->ViewValue, 7);
		$this->Tgl_Lulus->ViewCustomAttributes = "";

		// No_Ijazah
		$this->No_Ijazah->ViewValue = $this->No_Ijazah->CurrentValue;
		$this->No_Ijazah->ViewCustomAttributes = "";

		// TA
		$this->TA->ViewValue = $this->TA->CurrentValue;
		$this->TA->ViewCustomAttributes = "";

		// per
		$this->per->ViewValue = $this->per->CurrentValue;
		$this->per->ViewCustomAttributes = "";

		// ProdiIM
		$this->ProdiIM->ViewValue = $this->ProdiIM->CurrentValue;
		$this->ProdiIM->ViewCustomAttributes = "";

		// TaAkhir
		$this->TaAkhir->ViewValue = $this->TaAkhir->CurrentValue;
		$this->TaAkhir->ViewCustomAttributes = "";

		// xphoto
		$this->xphoto->ViewValue = $this->xphoto->CurrentValue;
		$this->xphoto->ViewCustomAttributes = "";

		// Ijazah
		$this->Ijazah->ViewValue = $this->Ijazah->CurrentValue;
		$this->Ijazah->ViewCustomAttributes = "";

		// Ktp
		$this->Ktp->ViewValue = $this->Ktp->CurrentValue;
		$this->Ktp->ViewCustomAttributes = "";

		// KK
		$this->KK->ViewValue = $this->KK->CurrentValue;
		$this->KK->ViewCustomAttributes = "";

		// riwayatakademik
		$this->riwayatakademik->ViewValue = $this->riwayatakademik->CurrentValue;
		$this->riwayatakademik->ViewCustomAttributes = "";

		// IjazahIM
		$this->IjazahIM->ViewValue = $this->IjazahIM->CurrentValue;
		$this->IjazahIM->ViewCustomAttributes = "";

		// TranskriptIM
		$this->TranskriptIM->ViewValue = $this->TranskriptIM->CurrentValue;
		$this->TranskriptIM->ViewCustomAttributes = "";

		// Skripsi
		$this->Skripsi->ViewValue = $this->Skripsi->CurrentValue;
		$this->Skripsi->ViewCustomAttributes = "";

		// TASkripsi
		$this->TASkripsi->ViewValue = $this->TASkripsi->CurrentValue;
		$this->TASkripsi->ViewCustomAttributes = "";

		// Plagiat
		$this->Plagiat->ViewValue = $this->Plagiat->CurrentValue;
		$this->Plagiat->ViewCustomAttributes = "";

		// keuangan
		$this->keuangan->ViewValue = $this->keuangan->CurrentValue;
		$this->keuangan->ViewCustomAttributes = "";

		// pendukung
		$this->pendukung->ViewValue = $this->pendukung->CurrentValue;
		$this->pendukung->ViewCustomAttributes = "";

		// lainlain
		$this->lainlain->ViewValue = $this->lainlain->CurrentValue;
		$this->lainlain->ViewCustomAttributes = "";

		// Kode_Fak
		$this->Kode_Fak->LinkCustomAttributes = "";
		$this->Kode_Fak->HrefValue = "";
		$this->Kode_Fak->TooltipValue = "";

		// Kode_Jp
		$this->Kode_Jp->LinkCustomAttributes = "";
		$this->Kode_Jp->HrefValue = "";
		$this->Kode_Jp->TooltipValue = "";

		// NimIM
		$this->NimIM->LinkCustomAttributes = "";
		$this->NimIM->HrefValue = "";
		$this->NimIM->TooltipValue = "";

		// Nim
		$this->Nim->LinkCustomAttributes = "";
		$this->Nim->HrefValue = "";
		$this->Nim->TooltipValue = "";

		// NamaMhs
		$this->NamaMhs->LinkCustomAttributes = "";
		$this->NamaMhs->HrefValue = "";
		$this->NamaMhs->TooltipValue = "";

		// Status_Akd
		$this->Status_Akd->LinkCustomAttributes = "";
		$this->Status_Akd->HrefValue = "";
		$this->Status_Akd->TooltipValue = "";

		// TglLahir
		$this->TglLahir->LinkCustomAttributes = "";
		$this->TglLahir->HrefValue = "";
		$this->TglLahir->TooltipValue = "";

		// TSKS
		$this->TSKS->LinkCustomAttributes = "";
		$this->TSKS->HrefValue = "";
		$this->TSKS->TooltipValue = "";

		// Prodi
		$this->Prodi->LinkCustomAttributes = "";
		$this->Prodi->HrefValue = "";
		$this->Prodi->TooltipValue = "";

		// PerMasuk
		$this->PerMasuk->LinkCustomAttributes = "";
		$this->PerMasuk->HrefValue = "";
		$this->PerMasuk->TooltipValue = "";

		// Status
		$this->Status->LinkCustomAttributes = "";
		$this->Status->HrefValue = "";
		$this->Status->TooltipValue = "";

		// PerKeluar
		$this->PerKeluar->LinkCustomAttributes = "";
		$this->PerKeluar->HrefValue = "";
		$this->PerKeluar->TooltipValue = "";

		// TglKeluar
		$this->TglKeluar->LinkCustomAttributes = "";
		$this->TglKeluar->HrefValue = "";
		$this->TglKeluar->TooltipValue = "";

		// Nama_Mhs
		$this->Nama_Mhs->LinkCustomAttributes = "";
		$this->Nama_Mhs->HrefValue = "";
		$this->Nama_Mhs->TooltipValue = "";

		// Tmp_Lahir
		$this->Tmp_Lahir->LinkCustomAttributes = "";
		$this->Tmp_Lahir->HrefValue = "";
		$this->Tmp_Lahir->TooltipValue = "";

		// Tgl_Lahir
		$this->Tgl_Lahir->LinkCustomAttributes = "";
		$this->Tgl_Lahir->HrefValue = "";
		$this->Tgl_Lahir->TooltipValue = "";

		// StatusSIAP
		$this->StatusSIAP->LinkCustomAttributes = "";
		$this->StatusSIAP->HrefValue = "";
		$this->StatusSIAP->TooltipValue = "";

		// PerMasukIM
		$this->PerMasukIM->LinkCustomAttributes = "";
		$this->PerMasukIM->HrefValue = "";
		$this->PerMasukIM->TooltipValue = "";

		// TaMasuk
		$this->TaMasuk->LinkCustomAttributes = "";
		$this->TaMasuk->HrefValue = "";
		$this->TaMasuk->TooltipValue = "";

		// PMasuk
		$this->PMasuk->LinkCustomAttributes = "";
		$this->PMasuk->HrefValue = "";
		$this->PMasuk->TooltipValue = "";

		// tglmasuk
		$this->tglmasuk->LinkCustomAttributes = "";
		$this->tglmasuk->HrefValue = "";
		$this->tglmasuk->TooltipValue = "";

		// Status_Masuk
		$this->Status_Masuk->LinkCustomAttributes = "";
		$this->Status_Masuk->HrefValue = "";
		$this->Status_Masuk->TooltipValue = "";

		// JalurMasuk
		$this->JalurMasuk->LinkCustomAttributes = "";
		$this->JalurMasuk->HrefValue = "";
		$this->JalurMasuk->TooltipValue = "";

		// PerLulusIM
		$this->PerLulusIM->LinkCustomAttributes = "";
		$this->PerLulusIM->HrefValue = "";
		$this->PerLulusIM->TooltipValue = "";

		// Tgl_Lulus
		$this->Tgl_Lulus->LinkCustomAttributes = "";
		$this->Tgl_Lulus->HrefValue = "";
		$this->Tgl_Lulus->TooltipValue = "";

		// No_Ijazah
		$this->No_Ijazah->LinkCustomAttributes = "";
		$this->No_Ijazah->HrefValue = "";
		$this->No_Ijazah->TooltipValue = "";

		// TA
		$this->TA->LinkCustomAttributes = "";
		$this->TA->HrefValue = "";
		$this->TA->TooltipValue = "";

		// per
		$this->per->LinkCustomAttributes = "";
		$this->per->HrefValue = "";
		$this->per->TooltipValue = "";

		// ProdiIM
		$this->ProdiIM->LinkCustomAttributes = "";
		$this->ProdiIM->HrefValue = "";
		$this->ProdiIM->TooltipValue = "";

		// TaAkhir
		$this->TaAkhir->LinkCustomAttributes = "";
		$this->TaAkhir->HrefValue = "";
		$this->TaAkhir->TooltipValue = "";

		// xphoto
		$this->xphoto->LinkCustomAttributes = "";
		$this->xphoto->HrefValue = "";
		$this->xphoto->TooltipValue = "";

		// Ijazah
		$this->Ijazah->LinkCustomAttributes = "";
		if (!EmptyValue($this->Ijazah->CurrentValue)) {
			$this->Ijazah->HrefValue = "https://akademik.stmik-im.ac.id/views/uploads/" . (!empty($this->Ijazah->ViewValue) && !is_array($this->Ijazah->ViewValue) ? RemoveHtml($this->Ijazah->ViewValue) : $this->Ijazah->CurrentValue); // Add prefix/suffix
			$this->Ijazah->LinkAttrs["target"] = "_blank"; // Add target
			if ($this->isExport())
				$this->Ijazah->HrefValue = FullUrl($this->Ijazah->HrefValue, "href");
		} else {
			$this->Ijazah->HrefValue = "";
		}
		$this->Ijazah->TooltipValue = "";

		// Ktp
		$this->Ktp->LinkCustomAttributes = "";
		if (!EmptyValue($this->Ktp->CurrentValue)) {
			$this->Ktp->HrefValue = "https://akademik.stmik-im.ac.id/views/uploads/" . (!empty($this->Ktp->ViewValue) && !is_array($this->Ktp->ViewValue) ? RemoveHtml($this->Ktp->ViewValue) : $this->Ktp->CurrentValue); // Add prefix/suffix
			$this->Ktp->LinkAttrs["target"] = "_blank"; // Add target
			if ($this->isExport())
				$this->Ktp->HrefValue = FullUrl($this->Ktp->HrefValue, "href");
		} else {
			$this->Ktp->HrefValue = "";
		}
		$this->Ktp->TooltipValue = "";

		// KK
		$this->KK->LinkCustomAttributes = "";
		if (!EmptyValue($this->KK->CurrentValue)) {
			$this->KK->HrefValue = "https://akademik.stmik-im.ac.id/views/uploads/" . (!empty($this->KK->ViewValue) && !is_array($this->KK->ViewValue) ? RemoveHtml($this->KK->ViewValue) : $this->KK->CurrentValue); // Add prefix/suffix
			$this->KK->LinkAttrs["target"] = "_blank"; // Add target
			if ($this->isExport())
				$this->KK->HrefValue = FullUrl($this->KK->HrefValue, "href");
		} else {
			$this->KK->HrefValue = "";
		}
		$this->KK->TooltipValue = "";

		// riwayatakademik
		$this->riwayatakademik->LinkCustomAttributes = "";
		if (!EmptyValue($this->riwayatakademik->CurrentValue)) {
			$this->riwayatakademik->HrefValue = "https://akademik.stmik-im.ac.id/views/uploads/riwayat/" . (!empty($this->riwayatakademik->ViewValue) && !is_array($this->riwayatakademik->ViewValue) ? RemoveHtml($this->riwayatakademik->ViewValue) : $this->riwayatakademik->CurrentValue); // Add prefix/suffix
			$this->riwayatakademik->LinkAttrs["target"] = "_blank"; // Add target
			if ($this->isExport())
				$this->riwayatakademik->HrefValue = FullUrl($this->riwayatakademik->HrefValue, "href");
		} else {
			$this->riwayatakademik->HrefValue = "";
		}
		$this->riwayatakademik->TooltipValue = "";

		// IjazahIM
		$this->IjazahIM->LinkCustomAttributes = "";
		if (!EmptyValue($this->IjazahIM->CurrentValue)) {
			$this->IjazahIM->HrefValue = "https://akademik.stmik-im.ac.id/views/uploads/riwayat/" . (!empty($this->IjazahIM->ViewValue) && !is_array($this->IjazahIM->ViewValue) ? RemoveHtml($this->IjazahIM->ViewValue) : $this->IjazahIM->CurrentValue); // Add prefix/suffix
			$this->IjazahIM->LinkAttrs["target"] = "_blank"; // Add target
			if ($this->isExport())
				$this->IjazahIM->HrefValue = FullUrl($this->IjazahIM->HrefValue, "href");
		} else {
			$this->IjazahIM->HrefValue = "";
		}
		$this->IjazahIM->TooltipValue = "";

		// TranskriptIM
		$this->TranskriptIM->LinkCustomAttributes = "";
		if (!EmptyValue($this->TranskriptIM->CurrentValue)) {
			$this->TranskriptIM->HrefValue = "https://akademik.stmik-im.ac.id/views/uploads/riwayat/" . (!empty($this->TranskriptIM->ViewValue) && !is_array($this->TranskriptIM->ViewValue) ? RemoveHtml($this->TranskriptIM->ViewValue) : $this->TranskriptIM->CurrentValue); // Add prefix/suffix
			$this->TranskriptIM->LinkAttrs["target"] = "_blank"; // Add target
			if ($this->isExport())
				$this->TranskriptIM->HrefValue = FullUrl($this->TranskriptIM->HrefValue, "href");
		} else {
			$this->TranskriptIM->HrefValue = "";
		}
		$this->TranskriptIM->TooltipValue = "";

		// Skripsi
		$this->Skripsi->LinkCustomAttributes = "";
		if (!EmptyValue($this->Skripsi->CurrentValue)) {
			$this->Skripsi->HrefValue = "https://akademik.stmik-im.ac.id/views/uploads/riwayat/" . (!empty($this->Skripsi->ViewValue) && !is_array($this->Skripsi->ViewValue) ? RemoveHtml($this->Skripsi->ViewValue) : $this->Skripsi->CurrentValue); // Add prefix/suffix
			$this->Skripsi->LinkAttrs["target"] = "_blank"; // Add target
			if ($this->isExport())
				$this->Skripsi->HrefValue = FullUrl($this->Skripsi->HrefValue, "href");
		} else {
			$this->Skripsi->HrefValue = "";
		}
		$this->Skripsi->TooltipValue = "";

		// TASkripsi
		$this->TASkripsi->LinkCustomAttributes = "";
		if (!EmptyValue($this->TASkripsi->CurrentValue)) {
			$this->TASkripsi->HrefValue = "https://akademik.stmik-im.ac.id/docs/TaSkripsi/" . (!empty($this->TASkripsi->ViewValue) && !is_array($this->TASkripsi->ViewValue) ? RemoveHtml($this->TASkripsi->ViewValue) : $this->TASkripsi->CurrentValue); // Add prefix/suffix
			$this->TASkripsi->LinkAttrs["target"] = "_blank"; // Add target
			if ($this->isExport())
				$this->TASkripsi->HrefValue = FullUrl($this->TASkripsi->HrefValue, "href");
		} else {
			$this->TASkripsi->HrefValue = "";
		}
		$this->TASkripsi->TooltipValue = "";

		// Plagiat
		$this->Plagiat->LinkCustomAttributes = "";
		if (!EmptyValue($this->Plagiat->CurrentValue)) {
			$this->Plagiat->HrefValue = "https://akademik.stmik-im.ac.id/views/uploads/riwayat/" . (!empty($this->Plagiat->ViewValue) && !is_array($this->Plagiat->ViewValue) ? RemoveHtml($this->Plagiat->ViewValue) : $this->Plagiat->CurrentValue); // Add prefix/suffix
			$this->Plagiat->LinkAttrs["target"] = "_blank"; // Add target
			if ($this->isExport())
				$this->Plagiat->HrefValue = FullUrl($this->Plagiat->HrefValue, "href");
		} else {
			$this->Plagiat->HrefValue = "";
		}
		$this->Plagiat->TooltipValue = "";

		// keuangan
		$this->keuangan->LinkCustomAttributes = "";
		if (!EmptyValue($this->keuangan->CurrentValue)) {
			$this->keuangan->HrefValue = "https://akademik.stmik-im.ac.id/views/uploads/keu/" . (!empty($this->keuangan->ViewValue) && !is_array($this->keuangan->ViewValue) ? RemoveHtml($this->keuangan->ViewValue) : $this->keuangan->CurrentValue); // Add prefix/suffix
			$this->keuangan->LinkAttrs["target"] = "_blank"; // Add target
			if ($this->isExport())
				$this->keuangan->HrefValue = FullUrl($this->keuangan->HrefValue, "href");
		} else {
			$this->keuangan->HrefValue = "";
		}
		$this->keuangan->TooltipValue = "";

		// pendukung
		$this->pendukung->LinkCustomAttributes = "";
		if (!EmptyValue($this->pendukung->CurrentValue)) {
			$this->pendukung->HrefValue = "https://akademik.stmik-im.ac.id/views/uploads/pendukung/" . (!empty($this->pendukung->ViewValue) && !is_array($this->pendukung->ViewValue) ? RemoveHtml($this->pendukung->ViewValue) : $this->pendukung->CurrentValue); // Add prefix/suffix
			$this->pendukung->LinkAttrs["target"] = "_blank"; // Add target
			if ($this->isExport())
				$this->pendukung->HrefValue = FullUrl($this->pendukung->HrefValue, "href");
		} else {
			$this->pendukung->HrefValue = "";
		}
		$this->pendukung->TooltipValue = "";

		// lainlain
		$this->lainlain->LinkCustomAttributes = "";
		if (!EmptyValue($this->lainlain->CurrentValue)) {
			$this->lainlain->HrefValue = "https://akademik.stmik-im.ac.id/views/uploads/lainlain/" . (!empty($this->lainlain->ViewValue) && !is_array($this->lainlain->ViewValue) ? RemoveHtml($this->lainlain->ViewValue) : $this->lainlain->CurrentValue); // Add prefix/suffix
			$this->lainlain->LinkAttrs["target"] = "_blank"; // Add target
			if ($this->isExport())
				$this->lainlain->HrefValue = FullUrl($this->lainlain->HrefValue, "href");
		} else {
			$this->lainlain->HrefValue = "";
		}
		$this->lainlain->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Kode_Fak
		$this->Kode_Fak->EditAttrs["class"] = "form-control";
		$this->Kode_Fak->EditCustomAttributes = "";

		// Kode_Jp
		$this->Kode_Jp->EditAttrs["class"] = "form-control";
		$this->Kode_Jp->EditCustomAttributes = "";

		// NimIM
		$this->NimIM->EditAttrs["class"] = "form-control";
		$this->NimIM->EditCustomAttributes = "";
		if (!$this->NimIM->Raw)
			$this->NimIM->CurrentValue = HtmlDecode($this->NimIM->CurrentValue);
		$this->NimIM->EditValue = $this->NimIM->CurrentValue;
		$this->NimIM->PlaceHolder = RemoveHtml($this->NimIM->caption());

		// Nim
		$this->Nim->EditAttrs["class"] = "form-control";
		$this->Nim->EditCustomAttributes = "";
		if (!$this->Nim->Raw)
			$this->Nim->CurrentValue = HtmlDecode($this->Nim->CurrentValue);
		$this->Nim->EditValue = $this->Nim->CurrentValue;
		$this->Nim->PlaceHolder = RemoveHtml($this->Nim->caption());

		// NamaMhs
		$this->NamaMhs->EditAttrs["class"] = "form-control";
		$this->NamaMhs->EditCustomAttributes = "";
		if (!$this->NamaMhs->Raw)
			$this->NamaMhs->CurrentValue = HtmlDecode($this->NamaMhs->CurrentValue);
		$this->NamaMhs->EditValue = $this->NamaMhs->CurrentValue;
		$this->NamaMhs->PlaceHolder = RemoveHtml($this->NamaMhs->caption());

		// Status_Akd
		$this->Status_Akd->EditAttrs["class"] = "form-control";
		$this->Status_Akd->EditCustomAttributes = "";

		// TglLahir
		$this->TglLahir->EditAttrs["class"] = "form-control";
		$this->TglLahir->EditCustomAttributes = "";
		if (!$this->TglLahir->Raw)
			$this->TglLahir->CurrentValue = HtmlDecode($this->TglLahir->CurrentValue);
		$this->TglLahir->EditValue = $this->TglLahir->CurrentValue;
		$this->TglLahir->PlaceHolder = RemoveHtml($this->TglLahir->caption());

		// TSKS
		$this->TSKS->EditAttrs["class"] = "form-control";
		$this->TSKS->EditCustomAttributes = "";
		if (!$this->TSKS->Raw)
			$this->TSKS->CurrentValue = HtmlDecode($this->TSKS->CurrentValue);
		$this->TSKS->EditValue = $this->TSKS->CurrentValue;
		$this->TSKS->PlaceHolder = RemoveHtml($this->TSKS->caption());

		// Prodi
		$this->Prodi->EditAttrs["class"] = "form-control";
		$this->Prodi->EditCustomAttributes = "";
		if (!$this->Prodi->Raw)
			$this->Prodi->CurrentValue = HtmlDecode($this->Prodi->CurrentValue);
		$this->Prodi->EditValue = $this->Prodi->CurrentValue;
		$this->Prodi->PlaceHolder = RemoveHtml($this->Prodi->caption());

		// PerMasuk
		$this->PerMasuk->EditAttrs["class"] = "form-control";
		$this->PerMasuk->EditCustomAttributes = "";
		if (!$this->PerMasuk->Raw)
			$this->PerMasuk->CurrentValue = HtmlDecode($this->PerMasuk->CurrentValue);
		$this->PerMasuk->EditValue = $this->PerMasuk->CurrentValue;
		$this->PerMasuk->PlaceHolder = RemoveHtml($this->PerMasuk->caption());

		// Status
		$this->Status->EditAttrs["class"] = "form-control";
		$this->Status->EditCustomAttributes = "";
		$this->Status->EditValue = $this->Status->options(TRUE);

		// PerKeluar
		$this->PerKeluar->EditAttrs["class"] = "form-control";
		$this->PerKeluar->EditCustomAttributes = "";
		if (!$this->PerKeluar->Raw)
			$this->PerKeluar->CurrentValue = HtmlDecode($this->PerKeluar->CurrentValue);
		$this->PerKeluar->EditValue = $this->PerKeluar->CurrentValue;
		$this->PerKeluar->PlaceHolder = RemoveHtml($this->PerKeluar->caption());

		// TglKeluar
		$this->TglKeluar->EditAttrs["class"] = "form-control";
		$this->TglKeluar->EditCustomAttributes = "";
		if (!$this->TglKeluar->Raw)
			$this->TglKeluar->CurrentValue = HtmlDecode($this->TglKeluar->CurrentValue);
		$this->TglKeluar->EditValue = $this->TglKeluar->CurrentValue;
		$this->TglKeluar->PlaceHolder = RemoveHtml($this->TglKeluar->caption());

		// Nama_Mhs
		$this->Nama_Mhs->EditAttrs["class"] = "form-control";
		$this->Nama_Mhs->EditCustomAttributes = "";
		if (!$this->Nama_Mhs->Raw)
			$this->Nama_Mhs->CurrentValue = HtmlDecode($this->Nama_Mhs->CurrentValue);
		$this->Nama_Mhs->EditValue = $this->Nama_Mhs->CurrentValue;
		$this->Nama_Mhs->PlaceHolder = RemoveHtml($this->Nama_Mhs->caption());

		// Tmp_Lahir
		$this->Tmp_Lahir->EditAttrs["class"] = "form-control";
		$this->Tmp_Lahir->EditCustomAttributes = "";
		if (!$this->Tmp_Lahir->Raw)
			$this->Tmp_Lahir->CurrentValue = HtmlDecode($this->Tmp_Lahir->CurrentValue);
		$this->Tmp_Lahir->EditValue = $this->Tmp_Lahir->CurrentValue;
		$this->Tmp_Lahir->PlaceHolder = RemoveHtml($this->Tmp_Lahir->caption());

		// Tgl_Lahir
		$this->Tgl_Lahir->EditAttrs["class"] = "form-control";
		$this->Tgl_Lahir->EditCustomAttributes = "";
		$this->Tgl_Lahir->EditValue = FormatDateTime($this->Tgl_Lahir->CurrentValue, 7);
		$this->Tgl_Lahir->PlaceHolder = RemoveHtml($this->Tgl_Lahir->caption());

		// StatusSIAP
		$this->StatusSIAP->EditAttrs["class"] = "form-control";
		$this->StatusSIAP->EditCustomAttributes = "";
		$this->StatusSIAP->EditValue = $this->StatusSIAP->options(TRUE);

		// PerMasukIM
		$this->PerMasukIM->EditAttrs["class"] = "form-control";
		$this->PerMasukIM->EditCustomAttributes = "";
		if (!$this->PerMasukIM->Raw)
			$this->PerMasukIM->CurrentValue = HtmlDecode($this->PerMasukIM->CurrentValue);
		$this->PerMasukIM->EditValue = $this->PerMasukIM->CurrentValue;
		$this->PerMasukIM->PlaceHolder = RemoveHtml($this->PerMasukIM->caption());

		// TaMasuk
		$this->TaMasuk->EditAttrs["class"] = "form-control";
		$this->TaMasuk->EditCustomAttributes = "";

		// PMasuk
		$this->PMasuk->EditAttrs["class"] = "form-control";
		$this->PMasuk->EditCustomAttributes = "";
		$this->PMasuk->EditValue = $this->PMasuk->options(TRUE);

		// tglmasuk
		$this->tglmasuk->EditAttrs["class"] = "form-control";
		$this->tglmasuk->EditCustomAttributes = "";
		$this->tglmasuk->EditValue = FormatDateTime($this->tglmasuk->CurrentValue, 7);
		$this->tglmasuk->PlaceHolder = RemoveHtml($this->tglmasuk->caption());

		// Status_Masuk
		$this->Status_Masuk->EditAttrs["class"] = "form-control";
		$this->Status_Masuk->EditCustomAttributes = "";
		if (!$this->Status_Masuk->Raw)
			$this->Status_Masuk->CurrentValue = HtmlDecode($this->Status_Masuk->CurrentValue);
		$this->Status_Masuk->EditValue = $this->Status_Masuk->CurrentValue;
		$this->Status_Masuk->PlaceHolder = RemoveHtml($this->Status_Masuk->caption());

		// JalurMasuk
		$this->JalurMasuk->EditAttrs["class"] = "form-control";
		$this->JalurMasuk->EditCustomAttributes = "";
		if (!$this->JalurMasuk->Raw)
			$this->JalurMasuk->CurrentValue = HtmlDecode($this->JalurMasuk->CurrentValue);
		$this->JalurMasuk->EditValue = $this->JalurMasuk->CurrentValue;
		$this->JalurMasuk->PlaceHolder = RemoveHtml($this->JalurMasuk->caption());

		// PerLulusIM
		$this->PerLulusIM->EditAttrs["class"] = "form-control";
		$this->PerLulusIM->EditCustomAttributes = "";
		if (!$this->PerLulusIM->Raw)
			$this->PerLulusIM->CurrentValue = HtmlDecode($this->PerLulusIM->CurrentValue);
		$this->PerLulusIM->EditValue = $this->PerLulusIM->CurrentValue;
		$this->PerLulusIM->PlaceHolder = RemoveHtml($this->PerLulusIM->caption());

		// Tgl_Lulus
		$this->Tgl_Lulus->EditAttrs["class"] = "form-control";
		$this->Tgl_Lulus->EditCustomAttributes = "";
		$this->Tgl_Lulus->EditValue = FormatDateTime($this->Tgl_Lulus->CurrentValue, 7);
		$this->Tgl_Lulus->PlaceHolder = RemoveHtml($this->Tgl_Lulus->caption());

		// No_Ijazah
		$this->No_Ijazah->EditAttrs["class"] = "form-control";
		$this->No_Ijazah->EditCustomAttributes = "";
		if (!$this->No_Ijazah->Raw)
			$this->No_Ijazah->CurrentValue = HtmlDecode($this->No_Ijazah->CurrentValue);
		$this->No_Ijazah->EditValue = $this->No_Ijazah->CurrentValue;
		$this->No_Ijazah->PlaceHolder = RemoveHtml($this->No_Ijazah->caption());

		// TA
		$this->TA->EditAttrs["class"] = "form-control";
		$this->TA->EditCustomAttributes = "";
		if (!$this->TA->Raw)
			$this->TA->CurrentValue = HtmlDecode($this->TA->CurrentValue);
		$this->TA->EditValue = $this->TA->CurrentValue;
		$this->TA->PlaceHolder = RemoveHtml($this->TA->caption());

		// per
		$this->per->EditAttrs["class"] = "form-control";
		$this->per->EditCustomAttributes = "";
		if (!$this->per->Raw)
			$this->per->CurrentValue = HtmlDecode($this->per->CurrentValue);
		$this->per->EditValue = $this->per->CurrentValue;
		$this->per->PlaceHolder = RemoveHtml($this->per->caption());

		// ProdiIM
		$this->ProdiIM->EditAttrs["class"] = "form-control";
		$this->ProdiIM->EditCustomAttributes = "";
		if (!$this->ProdiIM->Raw)
			$this->ProdiIM->CurrentValue = HtmlDecode($this->ProdiIM->CurrentValue);
		$this->ProdiIM->EditValue = $this->ProdiIM->CurrentValue;
		$this->ProdiIM->PlaceHolder = RemoveHtml($this->ProdiIM->caption());

		// TaAkhir
		$this->TaAkhir->EditAttrs["class"] = "form-control";
		$this->TaAkhir->EditCustomAttributes = "";
		if (!$this->TaAkhir->Raw)
			$this->TaAkhir->CurrentValue = HtmlDecode($this->TaAkhir->CurrentValue);
		$this->TaAkhir->EditValue = $this->TaAkhir->CurrentValue;
		$this->TaAkhir->PlaceHolder = RemoveHtml($this->TaAkhir->caption());

		// xphoto
		$this->xphoto->EditAttrs["class"] = "form-control";
		$this->xphoto->EditCustomAttributes = "";
		if (!$this->xphoto->Raw)
			$this->xphoto->CurrentValue = HtmlDecode($this->xphoto->CurrentValue);
		$this->xphoto->EditValue = $this->xphoto->CurrentValue;
		$this->xphoto->PlaceHolder = RemoveHtml($this->xphoto->caption());

		// Ijazah
		$this->Ijazah->EditAttrs["class"] = "form-control";
		$this->Ijazah->EditCustomAttributes = "";
		if (!$this->Ijazah->Raw)
			$this->Ijazah->CurrentValue = HtmlDecode($this->Ijazah->CurrentValue);
		$this->Ijazah->EditValue = $this->Ijazah->CurrentValue;
		$this->Ijazah->PlaceHolder = RemoveHtml($this->Ijazah->caption());

		// Ktp
		$this->Ktp->EditAttrs["class"] = "form-control";
		$this->Ktp->EditCustomAttributes = "";
		if (!$this->Ktp->Raw)
			$this->Ktp->CurrentValue = HtmlDecode($this->Ktp->CurrentValue);
		$this->Ktp->EditValue = $this->Ktp->CurrentValue;
		$this->Ktp->PlaceHolder = RemoveHtml($this->Ktp->caption());

		// KK
		$this->KK->EditAttrs["class"] = "form-control";
		$this->KK->EditCustomAttributes = "";
		if (!$this->KK->Raw)
			$this->KK->CurrentValue = HtmlDecode($this->KK->CurrentValue);
		$this->KK->EditValue = $this->KK->CurrentValue;
		$this->KK->PlaceHolder = RemoveHtml($this->KK->caption());

		// riwayatakademik
		$this->riwayatakademik->EditAttrs["class"] = "form-control";
		$this->riwayatakademik->EditCustomAttributes = "";
		if (!$this->riwayatakademik->Raw)
			$this->riwayatakademik->CurrentValue = HtmlDecode($this->riwayatakademik->CurrentValue);
		$this->riwayatakademik->EditValue = $this->riwayatakademik->CurrentValue;
		$this->riwayatakademik->PlaceHolder = RemoveHtml($this->riwayatakademik->caption());

		// IjazahIM
		$this->IjazahIM->EditAttrs["class"] = "form-control";
		$this->IjazahIM->EditCustomAttributes = "";
		if (!$this->IjazahIM->Raw)
			$this->IjazahIM->CurrentValue = HtmlDecode($this->IjazahIM->CurrentValue);
		$this->IjazahIM->EditValue = $this->IjazahIM->CurrentValue;
		$this->IjazahIM->PlaceHolder = RemoveHtml($this->IjazahIM->caption());

		// TranskriptIM
		$this->TranskriptIM->EditAttrs["class"] = "form-control";
		$this->TranskriptIM->EditCustomAttributes = "";
		if (!$this->TranskriptIM->Raw)
			$this->TranskriptIM->CurrentValue = HtmlDecode($this->TranskriptIM->CurrentValue);
		$this->TranskriptIM->EditValue = $this->TranskriptIM->CurrentValue;
		$this->TranskriptIM->PlaceHolder = RemoveHtml($this->TranskriptIM->caption());

		// Skripsi
		$this->Skripsi->EditAttrs["class"] = "form-control";
		$this->Skripsi->EditCustomAttributes = "";
		if (!$this->Skripsi->Raw)
			$this->Skripsi->CurrentValue = HtmlDecode($this->Skripsi->CurrentValue);
		$this->Skripsi->EditValue = $this->Skripsi->CurrentValue;
		$this->Skripsi->PlaceHolder = RemoveHtml($this->Skripsi->caption());

		// TASkripsi
		$this->TASkripsi->EditAttrs["class"] = "form-control";
		$this->TASkripsi->EditCustomAttributes = "";
		if (!$this->TASkripsi->Raw)
			$this->TASkripsi->CurrentValue = HtmlDecode($this->TASkripsi->CurrentValue);
		$this->TASkripsi->EditValue = $this->TASkripsi->CurrentValue;
		$this->TASkripsi->PlaceHolder = RemoveHtml($this->TASkripsi->caption());

		// Plagiat
		$this->Plagiat->EditAttrs["class"] = "form-control";
		$this->Plagiat->EditCustomAttributes = "";
		if (!$this->Plagiat->Raw)
			$this->Plagiat->CurrentValue = HtmlDecode($this->Plagiat->CurrentValue);
		$this->Plagiat->EditValue = $this->Plagiat->CurrentValue;
		$this->Plagiat->PlaceHolder = RemoveHtml($this->Plagiat->caption());

		// keuangan
		$this->keuangan->EditAttrs["class"] = "form-control";
		$this->keuangan->EditCustomAttributes = "";
		if (!$this->keuangan->Raw)
			$this->keuangan->CurrentValue = HtmlDecode($this->keuangan->CurrentValue);
		$this->keuangan->EditValue = $this->keuangan->CurrentValue;
		$this->keuangan->PlaceHolder = RemoveHtml($this->keuangan->caption());

		// pendukung
		$this->pendukung->EditAttrs["class"] = "form-control";
		$this->pendukung->EditCustomAttributes = "";
		if (!$this->pendukung->Raw)
			$this->pendukung->CurrentValue = HtmlDecode($this->pendukung->CurrentValue);
		$this->pendukung->EditValue = $this->pendukung->CurrentValue;
		$this->pendukung->PlaceHolder = RemoveHtml($this->pendukung->caption());

		// lainlain
		$this->lainlain->EditAttrs["class"] = "form-control";
		$this->lainlain->EditCustomAttributes = "";
		if (!$this->lainlain->Raw)
			$this->lainlain->CurrentValue = HtmlDecode($this->lainlain->CurrentValue);
		$this->lainlain->EditValue = $this->lainlain->CurrentValue;
		$this->lainlain->PlaceHolder = RemoveHtml($this->lainlain->caption());

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->Kode_Fak);
					$doc->exportCaption($this->Kode_Jp);
					$doc->exportCaption($this->NimIM);
					$doc->exportCaption($this->Nim);
					$doc->exportCaption($this->NamaMhs);
					$doc->exportCaption($this->Status_Akd);
					$doc->exportCaption($this->TglLahir);
					$doc->exportCaption($this->TSKS);
					$doc->exportCaption($this->Prodi);
					$doc->exportCaption($this->PerMasuk);
					$doc->exportCaption($this->Status);
					$doc->exportCaption($this->PerKeluar);
					$doc->exportCaption($this->TglKeluar);
					$doc->exportCaption($this->Nama_Mhs);
					$doc->exportCaption($this->Tmp_Lahir);
					$doc->exportCaption($this->Tgl_Lahir);
					$doc->exportCaption($this->StatusSIAP);
					$doc->exportCaption($this->PerMasukIM);
					$doc->exportCaption($this->TaMasuk);
					$doc->exportCaption($this->PMasuk);
					$doc->exportCaption($this->tglmasuk);
					$doc->exportCaption($this->Status_Masuk);
					$doc->exportCaption($this->JalurMasuk);
					$doc->exportCaption($this->PerLulusIM);
					$doc->exportCaption($this->Tgl_Lulus);
					$doc->exportCaption($this->No_Ijazah);
					$doc->exportCaption($this->TA);
					$doc->exportCaption($this->per);
					$doc->exportCaption($this->ProdiIM);
					$doc->exportCaption($this->TaAkhir);
					$doc->exportCaption($this->xphoto);
					$doc->exportCaption($this->Ijazah);
					$doc->exportCaption($this->Ktp);
					$doc->exportCaption($this->KK);
					$doc->exportCaption($this->riwayatakademik);
					$doc->exportCaption($this->IjazahIM);
					$doc->exportCaption($this->TranskriptIM);
					$doc->exportCaption($this->Skripsi);
					$doc->exportCaption($this->TASkripsi);
					$doc->exportCaption($this->Plagiat);
					$doc->exportCaption($this->keuangan);
					$doc->exportCaption($this->pendukung);
					$doc->exportCaption($this->lainlain);
				} else {
					$doc->exportCaption($this->Kode_Fak);
					$doc->exportCaption($this->Kode_Jp);
					$doc->exportCaption($this->NimIM);
					$doc->exportCaption($this->Nim);
					$doc->exportCaption($this->NamaMhs);
					$doc->exportCaption($this->Status_Akd);
					$doc->exportCaption($this->TglLahir);
					$doc->exportCaption($this->TSKS);
					$doc->exportCaption($this->Prodi);
					$doc->exportCaption($this->PerMasuk);
					$doc->exportCaption($this->Status);
					$doc->exportCaption($this->PerKeluar);
					$doc->exportCaption($this->TglKeluar);
					$doc->exportCaption($this->Nama_Mhs);
					$doc->exportCaption($this->Tmp_Lahir);
					$doc->exportCaption($this->Tgl_Lahir);
					$doc->exportCaption($this->StatusSIAP);
					$doc->exportCaption($this->PerMasukIM);
					$doc->exportCaption($this->TaMasuk);
					$doc->exportCaption($this->PMasuk);
					$doc->exportCaption($this->tglmasuk);
					$doc->exportCaption($this->Status_Masuk);
					$doc->exportCaption($this->JalurMasuk);
					$doc->exportCaption($this->PerLulusIM);
					$doc->exportCaption($this->Tgl_Lulus);
					$doc->exportCaption($this->No_Ijazah);
					$doc->exportCaption($this->TA);
					$doc->exportCaption($this->per);
					$doc->exportCaption($this->ProdiIM);
					$doc->exportCaption($this->TaAkhir);
					$doc->exportCaption($this->xphoto);
					$doc->exportCaption($this->Ijazah);
					$doc->exportCaption($this->Ktp);
					$doc->exportCaption($this->KK);
					$doc->exportCaption($this->riwayatakademik);
					$doc->exportCaption($this->IjazahIM);
					$doc->exportCaption($this->TranskriptIM);
					$doc->exportCaption($this->Skripsi);
					$doc->exportCaption($this->TASkripsi);
					$doc->exportCaption($this->Plagiat);
					$doc->exportCaption($this->keuangan);
					$doc->exportCaption($this->pendukung);
					$doc->exportCaption($this->lainlain);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->Kode_Fak);
						$doc->exportField($this->Kode_Jp);
						$doc->exportField($this->NimIM);
						$doc->exportField($this->Nim);
						$doc->exportField($this->NamaMhs);
						$doc->exportField($this->Status_Akd);
						$doc->exportField($this->TglLahir);
						$doc->exportField($this->TSKS);
						$doc->exportField($this->Prodi);
						$doc->exportField($this->PerMasuk);
						$doc->exportField($this->Status);
						$doc->exportField($this->PerKeluar);
						$doc->exportField($this->TglKeluar);
						$doc->exportField($this->Nama_Mhs);
						$doc->exportField($this->Tmp_Lahir);
						$doc->exportField($this->Tgl_Lahir);
						$doc->exportField($this->StatusSIAP);
						$doc->exportField($this->PerMasukIM);
						$doc->exportField($this->TaMasuk);
						$doc->exportField($this->PMasuk);
						$doc->exportField($this->tglmasuk);
						$doc->exportField($this->Status_Masuk);
						$doc->exportField($this->JalurMasuk);
						$doc->exportField($this->PerLulusIM);
						$doc->exportField($this->Tgl_Lulus);
						$doc->exportField($this->No_Ijazah);
						$doc->exportField($this->TA);
						$doc->exportField($this->per);
						$doc->exportField($this->ProdiIM);
						$doc->exportField($this->TaAkhir);
						$doc->exportField($this->xphoto);
						$doc->exportField($this->Ijazah);
						$doc->exportField($this->Ktp);
						$doc->exportField($this->KK);
						$doc->exportField($this->riwayatakademik);
						$doc->exportField($this->IjazahIM);
						$doc->exportField($this->TranskriptIM);
						$doc->exportField($this->Skripsi);
						$doc->exportField($this->TASkripsi);
						$doc->exportField($this->Plagiat);
						$doc->exportField($this->keuangan);
						$doc->exportField($this->pendukung);
						$doc->exportField($this->lainlain);
					} else {
						$doc->exportField($this->Kode_Fak);
						$doc->exportField($this->Kode_Jp);
						$doc->exportField($this->NimIM);
						$doc->exportField($this->Nim);
						$doc->exportField($this->NamaMhs);
						$doc->exportField($this->Status_Akd);
						$doc->exportField($this->TglLahir);
						$doc->exportField($this->TSKS);
						$doc->exportField($this->Prodi);
						$doc->exportField($this->PerMasuk);
						$doc->exportField($this->Status);
						$doc->exportField($this->PerKeluar);
						$doc->exportField($this->TglKeluar);
						$doc->exportField($this->Nama_Mhs);
						$doc->exportField($this->Tmp_Lahir);
						$doc->exportField($this->Tgl_Lahir);
						$doc->exportField($this->StatusSIAP);
						$doc->exportField($this->PerMasukIM);
						$doc->exportField($this->TaMasuk);
						$doc->exportField($this->PMasuk);
						$doc->exportField($this->tglmasuk);
						$doc->exportField($this->Status_Masuk);
						$doc->exportField($this->JalurMasuk);
						$doc->exportField($this->PerLulusIM);
						$doc->exportField($this->Tgl_Lulus);
						$doc->exportField($this->No_Ijazah);
						$doc->exportField($this->TA);
						$doc->exportField($this->per);
						$doc->exportField($this->ProdiIM);
						$doc->exportField($this->TaAkhir);
						$doc->exportField($this->xphoto);
						$doc->exportField($this->Ijazah);
						$doc->exportField($this->Ktp);
						$doc->exportField($this->KK);
						$doc->exportField($this->riwayatakademik);
						$doc->exportField($this->IjazahIM);
						$doc->exportField($this->TranskriptIM);
						$doc->exportField($this->Skripsi);
						$doc->exportField($this->TASkripsi);
						$doc->exportField($this->Plagiat);
						$doc->exportField($this->keuangan);
						$doc->exportField($this->pendukung);
						$doc->exportField($this->lainlain);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0)
	{

		// No binary fields
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>