<?php
namespace PHPMaker2020\baak;

/**
 * Page class
 */
class ekpt_mhsfeed_search extends ekpt_mhsfeed
{

	// Page ID
	public $PageID = "search";

	// Project ID
	public $ProjectID = "{A09D3AFF-419C-4918-948A-A3C8469EA234}";

	// Table name
	public $TableName = 'ekpt_mhsfeed';

	// Page object name
	public $PageObjName = "ekpt_mhsfeed_search";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken;

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading != "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading != "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		$url = CurrentPageName() . "?";
		if ($this->UseTokenInUrl)
			$url .= "t=" . $this->TableVar . "&"; // Add page token
		return $url;
	}

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = TRUE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message != "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fas fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage != "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fas fa-exclamation"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage != "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fas fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage != "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fas fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = [];

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message != "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage != "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage != "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage != "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header != "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer != "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(Config("TOKEN_NAME")) === NULL)
			return FALSE;
		$fn = Config("CHECK_TOKEN_FUNC");
		if (is_callable($fn))
			return $fn(Post(Config("TOKEN_NAME")), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = Config("CREATE_TOKEN_FUNC"); // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $DashboardReport;
		global $UserTable;

		// Check token
		$this->CheckToken = Config("CHECK_TOKEN");

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (ekpt_mhsfeed)
		if (!isset($GLOBALS["ekpt_mhsfeed"]) || get_class($GLOBALS["ekpt_mhsfeed"]) == PROJECT_NAMESPACE . "ekpt_mhsfeed") {
			$GLOBALS["ekpt_mhsfeed"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["ekpt_mhsfeed"];
		}

		// Table object (Pass)
		if (!isset($GLOBALS['Pass']))
			$GLOBALS['Pass'] = new Pass();

		// Page ID (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'search');

		// Table name (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'ekpt_mhsfeed');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = $this->getConnection();

		// User table object (Pass)
		$UserTable = $UserTable ?: new Pass();
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages, $DashboardReport;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $ekpt_mhsfeed;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, Config("EXPORT_CLASSES"))) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . Config("EXPORT_CLASSES." . $this->CustomExport);
			if (class_exists($class)) {
				$doc = new $class($ekpt_mhsfeed);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url != "") {
			if (!Config("DEBUG") && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = ["url" => $url, "modal" => "1"];
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "ekpt_mhsfeedview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = [];
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = [];
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {
								$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
									Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
									Config("API_FIELD_NAME") . "=" . $fld->Param . "&" .
									Config("API_KEY_NAME") . "=" . rawurlencode($this->getRecordKeyValue($ar)))); //*** need to add this? API may not be in the same folder
								$row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
								$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
									Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
									"fn=" . Encrypt($fld->physicalUploadPath() . $val)));
								$row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
							} else { // Multiple files
								$files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
								$ar = [];
								foreach ($files as $file) {
									$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
										Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
										"fn=" . Encrypt($fld->physicalUploadPath() . $file)));
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['Kode_Jp'] . Config("COMPOSITE_KEY_SEPARATOR");
			$key .= @$ar['NimIM'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAddOrEdit())
			$this->Kode_Fak->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->Kode_Jp->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->NimIM->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->Status_Akd->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->Nama_Mhs->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->Tmp_Lahir->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->Tgl_Lahir->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->StatusSIAP->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->PerMasukIM->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->TaMasuk->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->PMasuk->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->tglmasuk->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->Status_Masuk->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->JalurMasuk->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->PerLulusIM->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->Tgl_Lulus->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->No_Ijazah->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->TA->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->per->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->ProdiIM->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->TaAkhir->Visible = FALSE;
	}

	// Lookup data
	public function lookup()
	{
		global $Language, $Security;
		if (!isset($Language))
			$Language = new Language(Config("LANGUAGE_FOLDER"), Post("language", ""));

		// Set up API request
		if (!ValidApiRequest())
			return FALSE;
		$this->setupApiSecurity();

		// Get lookup object
		$fieldName = Post("field");
		if (!array_key_exists($fieldName, $this->fields))
			return FALSE;
		$lookupField = $this->fields[$fieldName];
		$lookup = $lookupField->Lookup;
		if ($lookup === NULL)
			return FALSE;
		$tbl = $lookup->getTable();
		if (!$Security->allowLookup(Config("PROJECT_ID") . $tbl->TableName)) // Lookup permission
			return FALSE;

		// Get lookup parameters
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Param("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
			$lookup->FilterFields = []; // Skip parent fields if any
			$lookup->FilterValues[] = $keys; // Lookup values
			$pageSize = -1; // Show all records
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect != "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter != "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy != "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson($this); // Use settings from current page
	}

	// Set up API security
	public function setupApiSecurity()
	{
		global $Security;

		// Setup security for API request
		if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
		$Security->loadCurrentUserLevel(Config("PROJECT_ID") . $this->TableName);
		if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
	}
	public $FormClassName = "ew-horizontal ew-form ew-search-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $CurrentForm,
			$SearchError, $SkipHeaderFooter;

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		if (ValidApiRequest()) { // API request
			$this->setupApiSecurity(); // Set up API Security
		} else {
			$Security = new AdvancedSecurity();
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canSearch()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("ekpt_mhsfeedlist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->Kode_Fak->setVisibility();
		$this->Kode_Jp->setVisibility();
		$this->NimIM->setVisibility();
		$this->Nim->setVisibility();
		$this->NamaMhs->setVisibility();
		$this->Status_Akd->setVisibility();
		$this->TglLahir->setVisibility();
		$this->TSKS->setVisibility();
		$this->Prodi->setVisibility();
		$this->PerMasuk->setVisibility();
		$this->Status->setVisibility();
		$this->PerKeluar->setVisibility();
		$this->TglKeluar->setVisibility();
		$this->Nama_Mhs->setVisibility();
		$this->Tmp_Lahir->setVisibility();
		$this->Tgl_Lahir->setVisibility();
		$this->StatusSIAP->setVisibility();
		$this->PerMasukIM->setVisibility();
		$this->TaMasuk->setVisibility();
		$this->PMasuk->setVisibility();
		$this->tglmasuk->setVisibility();
		$this->Status_Masuk->setVisibility();
		$this->JalurMasuk->setVisibility();
		$this->PerLulusIM->setVisibility();
		$this->Tgl_Lulus->setVisibility();
		$this->No_Ijazah->setVisibility();
		$this->TA->setVisibility();
		$this->per->setVisibility();
		$this->ProdiIM->setVisibility();
		$this->TaAkhir->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->Kode_Fak);
		$this->setupLookupOptions($this->Kode_Jp);
		$this->setupLookupOptions($this->Status_Akd);
		$this->setupLookupOptions($this->TaMasuk);

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		if ($this->isPageRequest()) { // Validate request

			// Get action
			$this->CurrentAction = Post("action");
			if ($this->isSearch()) {

				// Build search string for advanced search, remove blank field
				$this->loadSearchValues(); // Get search values
				if ($this->validateSearch()) {
					$srchStr = $this->buildAdvancedSearch();
				} else {
					$srchStr = "";
					$this->setFailureMessage($SearchError);
				}
				if ($srchStr != "") {
					$srchStr = $this->getUrlParm($srchStr);
					$srchStr = "ekpt_mhsfeedlist.php" . "?" . $srchStr;
					$this->terminate($srchStr); // Go to list page
				}
			}
		}

		// Restore search settings from Session
		if ($SearchError == "")
			$this->loadAdvancedSearch();

		// Render row for search
		$this->RowType = ROWTYPE_SEARCH;
		$this->resetAttributes();
		$this->renderRow();
	}

	// Build advanced search
	protected function buildAdvancedSearch()
	{
		$srchUrl = "";
		$this->buildSearchUrl($srchUrl, $this->Kode_Fak); // Kode_Fak
		$this->buildSearchUrl($srchUrl, $this->Kode_Jp); // Kode_Jp
		$this->buildSearchUrl($srchUrl, $this->NimIM); // NimIM
		$this->buildSearchUrl($srchUrl, $this->Nim); // Nim
		$this->buildSearchUrl($srchUrl, $this->NamaMhs); // NamaMhs
		$this->buildSearchUrl($srchUrl, $this->Status_Akd); // Status_Akd
		$this->buildSearchUrl($srchUrl, $this->TglLahir); // TglLahir
		$this->buildSearchUrl($srchUrl, $this->TSKS); // TSKS
		$this->buildSearchUrl($srchUrl, $this->Prodi); // Prodi
		$this->buildSearchUrl($srchUrl, $this->PerMasuk); // PerMasuk
		$this->buildSearchUrl($srchUrl, $this->Status); // Status
		$this->buildSearchUrl($srchUrl, $this->PerKeluar); // PerKeluar
		$this->buildSearchUrl($srchUrl, $this->TglKeluar); // TglKeluar
		$this->buildSearchUrl($srchUrl, $this->Nama_Mhs); // Nama_Mhs
		$this->buildSearchUrl($srchUrl, $this->Tmp_Lahir); // Tmp_Lahir
		$this->buildSearchUrl($srchUrl, $this->Tgl_Lahir); // Tgl_Lahir
		$this->buildSearchUrl($srchUrl, $this->StatusSIAP); // StatusSIAP
		$this->buildSearchUrl($srchUrl, $this->PerMasukIM); // PerMasukIM
		$this->buildSearchUrl($srchUrl, $this->TaMasuk); // TaMasuk
		$this->buildSearchUrl($srchUrl, $this->PMasuk); // PMasuk
		$this->buildSearchUrl($srchUrl, $this->tglmasuk); // tglmasuk
		$this->buildSearchUrl($srchUrl, $this->Status_Masuk); // Status_Masuk
		$this->buildSearchUrl($srchUrl, $this->JalurMasuk); // JalurMasuk
		$this->buildSearchUrl($srchUrl, $this->PerLulusIM); // PerLulusIM
		$this->buildSearchUrl($srchUrl, $this->Tgl_Lulus); // Tgl_Lulus
		$this->buildSearchUrl($srchUrl, $this->No_Ijazah); // No_Ijazah
		$this->buildSearchUrl($srchUrl, $this->TA); // TA
		$this->buildSearchUrl($srchUrl, $this->per); // per
		$this->buildSearchUrl($srchUrl, $this->ProdiIM); // ProdiIM
		$this->buildSearchUrl($srchUrl, $this->TaAkhir); // TaAkhir
		if ($srchUrl != "")
			$srchUrl .= "&";
		$srchUrl .= "cmd=search";
		return $srchUrl;
	}

	// Build search URL
	protected function buildSearchUrl(&$url, &$fld, $oprOnly = FALSE)
	{
		global $CurrentForm;
		$wrk = "";
		$fldParm = $fld->Param;
		$fldVal = $CurrentForm->getValue("x_$fldParm");
		$fldOpr = $CurrentForm->getValue("z_$fldParm");
		$fldCond = $CurrentForm->getValue("v_$fldParm");
		$fldVal2 = $CurrentForm->getValue("y_$fldParm");
		$fldOpr2 = $CurrentForm->getValue("w_$fldParm");
		if (is_array($fldVal))
			$fldVal = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal);
		if (is_array($fldVal2))
			$fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
		$fldOpr = strtoupper(trim($fldOpr));
		$fldDataType = ($fld->IsVirtual) ? DATATYPE_STRING : $fld->DataType;
		if ($fldOpr == "BETWEEN") {
			$isValidValue = ($fldDataType != DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal) && $this->searchValueIsNumeric($fld, $fldVal2));
			if ($fldVal != "" && $fldVal2 != "" && $isValidValue) {
				$wrk = "x_" . $fldParm . "=" . urlencode($fldVal) .
					"&y_" . $fldParm . "=" . urlencode($fldVal2) .
					"&z_" . $fldParm . "=" . urlencode($fldOpr);
			}
		} else {
			$isValidValue = ($fldDataType != DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal));
			if ($fldVal != "" && $isValidValue && IsValidOperator($fldOpr, $fldDataType)) {
				$wrk = "x_" . $fldParm . "=" . urlencode($fldVal) .
					"&z_" . $fldParm . "=" . urlencode($fldOpr);
			} elseif ($fldOpr == "IS NULL" || $fldOpr == "IS NOT NULL" || ($fldOpr != "" && $oprOnly && IsValidOperator($fldOpr, $fldDataType))) {
				$wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
			}
			$isValidValue = ($fldDataType != DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal2));
			if ($fldVal2 != "" && $isValidValue && IsValidOperator($fldOpr2, $fldDataType)) {
				if ($wrk != "")
					$wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
				$wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) .
					"&w_" . $fldParm . "=" . urlencode($fldOpr2);
			} elseif ($fldOpr2 == "IS NULL" || $fldOpr2 == "IS NOT NULL" || ($fldOpr2 != "" && $oprOnly && IsValidOperator($fldOpr2, $fldDataType))) {
				if ($wrk != "")
					$wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
				$wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
			}
		}
		if ($wrk != "") {
			if ($url != "")
				$url .= "&";
			$url .= $wrk;
		}
	}
	protected function searchValueIsNumeric($fld, $value)
	{
		if (IsFloatFormat($fld->Type))
			$value = ConvertToFloatString($value);
		return is_numeric($value);
	}

	// Load search values for validation
	protected function loadSearchValues()
	{

		// Load search values
		$got = FALSE;
		if ($this->Kode_Fak->AdvancedSearch->post())
			$got = TRUE;
		if ($this->Kode_Jp->AdvancedSearch->post())
			$got = TRUE;
		if ($this->NimIM->AdvancedSearch->post())
			$got = TRUE;
		if ($this->Nim->AdvancedSearch->post())
			$got = TRUE;
		if ($this->NamaMhs->AdvancedSearch->post())
			$got = TRUE;
		if ($this->Status_Akd->AdvancedSearch->post())
			$got = TRUE;
		if ($this->TglLahir->AdvancedSearch->post())
			$got = TRUE;
		if ($this->TSKS->AdvancedSearch->post())
			$got = TRUE;
		if ($this->Prodi->AdvancedSearch->post())
			$got = TRUE;
		if ($this->PerMasuk->AdvancedSearch->post())
			$got = TRUE;
		if ($this->Status->AdvancedSearch->post())
			$got = TRUE;
		if ($this->PerKeluar->AdvancedSearch->post())
			$got = TRUE;
		if ($this->TglKeluar->AdvancedSearch->post())
			$got = TRUE;
		if ($this->Nama_Mhs->AdvancedSearch->post())
			$got = TRUE;
		if ($this->Tmp_Lahir->AdvancedSearch->post())
			$got = TRUE;
		if ($this->Tgl_Lahir->AdvancedSearch->post())
			$got = TRUE;
		if ($this->StatusSIAP->AdvancedSearch->post())
			$got = TRUE;
		if ($this->PerMasukIM->AdvancedSearch->post())
			$got = TRUE;
		if ($this->TaMasuk->AdvancedSearch->post())
			$got = TRUE;
		if ($this->PMasuk->AdvancedSearch->post())
			$got = TRUE;
		if ($this->tglmasuk->AdvancedSearch->post())
			$got = TRUE;
		if ($this->Status_Masuk->AdvancedSearch->post())
			$got = TRUE;
		if ($this->JalurMasuk->AdvancedSearch->post())
			$got = TRUE;
		if ($this->PerLulusIM->AdvancedSearch->post())
			$got = TRUE;
		if ($this->Tgl_Lulus->AdvancedSearch->post())
			$got = TRUE;
		if ($this->No_Ijazah->AdvancedSearch->post())
			$got = TRUE;
		if ($this->TA->AdvancedSearch->post())
			$got = TRUE;
		if ($this->per->AdvancedSearch->post())
			$got = TRUE;
		if ($this->ProdiIM->AdvancedSearch->post())
			$got = TRUE;
		if ($this->TaAkhir->AdvancedSearch->post())
			$got = TRUE;
		return $got;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Call Row_Rendering event

		$this->Row_Rendering();

		// Common render codes for all row types
		// Kode_Fak
		// Kode_Jp
		// NimIM
		// Nim
		// NamaMhs
		// Status_Akd
		// TglLahir
		// TSKS
		// Prodi
		// PerMasuk
		// Status
		// PerKeluar
		// TglKeluar
		// Nama_Mhs
		// Tmp_Lahir
		// Tgl_Lahir
		// StatusSIAP
		// PerMasukIM
		// TaMasuk
		// PMasuk
		// tglmasuk
		// Status_Masuk
		// JalurMasuk
		// PerLulusIM
		// Tgl_Lulus
		// No_Ijazah
		// TA
		// per
		// ProdiIM
		// TaAkhir

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// Kode_Fak
			$curVal = strval($this->Kode_Fak->CurrentValue);
			if ($curVal != "") {
				$this->Kode_Fak->ViewValue = $this->Kode_Fak->lookupCacheOption($curVal);
				if ($this->Kode_Fak->ViewValue === NULL) { // Lookup from database
					$filterWrk = "[Kode_Fak]" . SearchString("=", $curVal, DATATYPE_STRING, "");
					$sqlWrk = $this->Kode_Fak->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = [];
						$arwrk[1] = $rswrk->fields('df');
						$this->Kode_Fak->ViewValue = $this->Kode_Fak->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->Kode_Fak->ViewValue = $this->Kode_Fak->CurrentValue;
					}
				}
			} else {
				$this->Kode_Fak->ViewValue = NULL;
			}
			$this->Kode_Fak->ViewCustomAttributes = "";

			// Kode_Jp
			$curVal = strval($this->Kode_Jp->CurrentValue);
			if ($curVal != "") {
				$this->Kode_Jp->ViewValue = $this->Kode_Jp->lookupCacheOption($curVal);
				if ($this->Kode_Jp->ViewValue === NULL) { // Lookup from database
					$filterWrk = "[Kode_Jp]" . SearchString("=", $curVal, DATATYPE_STRING, "");
					$sqlWrk = $this->Kode_Jp->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = [];
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->Kode_Jp->ViewValue = $this->Kode_Jp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->Kode_Jp->ViewValue = $this->Kode_Jp->CurrentValue;
					}
				}
			} else {
				$this->Kode_Jp->ViewValue = NULL;
			}
			$this->Kode_Jp->ViewCustomAttributes = "";

			// NimIM
			$this->NimIM->ViewValue = $this->NimIM->CurrentValue;
			$this->NimIM->ViewCustomAttributes = "";

			// Nim
			$this->Nim->ViewValue = $this->Nim->CurrentValue;
			$this->Nim->ViewCustomAttributes = "";

			// NamaMhs
			$this->NamaMhs->ViewValue = $this->NamaMhs->CurrentValue;
			$this->NamaMhs->ViewCustomAttributes = "";

			// Status_Akd
			$curVal = strval($this->Status_Akd->CurrentValue);
			if ($curVal != "") {
				$this->Status_Akd->ViewValue = $this->Status_Akd->lookupCacheOption($curVal);
				if ($this->Status_Akd->ViewValue === NULL) { // Lookup from database
					$filterWrk = "[Kelas]" . SearchString("=", $curVal, DATATYPE_STRING, "");
					$sqlWrk = $this->Status_Akd->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = [];
						$arwrk[1] = $rswrk->fields('df');
						$this->Status_Akd->ViewValue = $this->Status_Akd->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->Status_Akd->ViewValue = $this->Status_Akd->CurrentValue;
					}
				}
			} else {
				$this->Status_Akd->ViewValue = NULL;
			}
			$this->Status_Akd->ViewCustomAttributes = "";

			// TglLahir
			$this->TglLahir->ViewValue = $this->TglLahir->CurrentValue;
			$this->TglLahir->ViewCustomAttributes = "";

			// TSKS
			$this->TSKS->ViewValue = $this->TSKS->CurrentValue;
			$this->TSKS->ViewCustomAttributes = "";

			// Prodi
			$this->Prodi->ViewValue = $this->Prodi->CurrentValue;
			$this->Prodi->ViewCustomAttributes = "";

			// PerMasuk
			$this->PerMasuk->ViewValue = $this->PerMasuk->CurrentValue;
			$this->PerMasuk->ViewCustomAttributes = "";

			// Status
			$this->Status->ViewValue = $this->Status->CurrentValue;
			$this->Status->ViewCustomAttributes = "";

			// PerKeluar
			$this->PerKeluar->ViewValue = $this->PerKeluar->CurrentValue;
			$this->PerKeluar->ViewCustomAttributes = "";

			// TglKeluar
			$this->TglKeluar->ViewValue = $this->TglKeluar->CurrentValue;
			$this->TglKeluar->ViewCustomAttributes = "";

			// Nama_Mhs
			$this->Nama_Mhs->ViewValue = $this->Nama_Mhs->CurrentValue;
			$this->Nama_Mhs->ViewCustomAttributes = "";

			// Tmp_Lahir
			$this->Tmp_Lahir->ViewValue = $this->Tmp_Lahir->CurrentValue;
			$this->Tmp_Lahir->ViewCustomAttributes = "";

			// Tgl_Lahir
			$this->Tgl_Lahir->ViewValue = $this->Tgl_Lahir->CurrentValue;
			$this->Tgl_Lahir->ViewValue = FormatDateTime($this->Tgl_Lahir->ViewValue, 7);
			$this->Tgl_Lahir->ViewCustomAttributes = "";

			// StatusSIAP
			if (strval($this->StatusSIAP->CurrentValue) != "") {
				$this->StatusSIAP->ViewValue = $this->StatusSIAP->optionCaption($this->StatusSIAP->CurrentValue);
			} else {
				$this->StatusSIAP->ViewValue = NULL;
			}
			$this->StatusSIAP->ViewCustomAttributes = "";

			// PerMasukIM
			$this->PerMasukIM->ViewValue = $this->PerMasukIM->CurrentValue;
			$this->PerMasukIM->ViewCustomAttributes = "";

			// TaMasuk
			$curVal = strval($this->TaMasuk->CurrentValue);
			if ($curVal != "") {
				$this->TaMasuk->ViewValue = $this->TaMasuk->lookupCacheOption($curVal);
				if ($this->TaMasuk->ViewValue === NULL) { // Lookup from database
					$filterWrk = "[TA]" . SearchString("=", $curVal, DATATYPE_STRING, "");
					$sqlWrk = $this->TaMasuk->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = [];
						$arwrk[1] = $rswrk->fields('df');
						$this->TaMasuk->ViewValue = $this->TaMasuk->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->TaMasuk->ViewValue = $this->TaMasuk->CurrentValue;
					}
				}
			} else {
				$this->TaMasuk->ViewValue = NULL;
			}
			$this->TaMasuk->ViewCustomAttributes = "";

			// PMasuk
			if (strval($this->PMasuk->CurrentValue) != "") {
				$this->PMasuk->ViewValue = $this->PMasuk->optionCaption($this->PMasuk->CurrentValue);
			} else {
				$this->PMasuk->ViewValue = NULL;
			}
			$this->PMasuk->ViewCustomAttributes = "";

			// tglmasuk
			$this->tglmasuk->ViewValue = $this->tglmasuk->CurrentValue;
			$this->tglmasuk->ViewValue = FormatDateTime($this->tglmasuk->ViewValue, 7);
			$this->tglmasuk->ViewCustomAttributes = "";

			// Status_Masuk
			$this->Status_Masuk->ViewValue = $this->Status_Masuk->CurrentValue;
			$this->Status_Masuk->ViewCustomAttributes = "";

			// JalurMasuk
			$this->JalurMasuk->ViewValue = $this->JalurMasuk->CurrentValue;
			$this->JalurMasuk->ViewCustomAttributes = "";

			// PerLulusIM
			$this->PerLulusIM->ViewValue = $this->PerLulusIM->CurrentValue;
			$this->PerLulusIM->ViewCustomAttributes = "";

			// Tgl_Lulus
			$this->Tgl_Lulus->ViewValue = $this->Tgl_Lulus->CurrentValue;
			$this->Tgl_Lulus->ViewValue = FormatDateTime($this->Tgl_Lulus->ViewValue, 7);
			$this->Tgl_Lulus->ViewCustomAttributes = "";

			// No_Ijazah
			$this->No_Ijazah->ViewValue = $this->No_Ijazah->CurrentValue;
			$this->No_Ijazah->ViewCustomAttributes = "";

			// TA
			$this->TA->ViewValue = $this->TA->CurrentValue;
			$this->TA->ViewCustomAttributes = "";

			// per
			$this->per->ViewValue = $this->per->CurrentValue;
			$this->per->ViewCustomAttributes = "";

			// ProdiIM
			$this->ProdiIM->ViewValue = $this->ProdiIM->CurrentValue;
			$this->ProdiIM->ViewCustomAttributes = "";

			// TaAkhir
			$this->TaAkhir->ViewValue = $this->TaAkhir->CurrentValue;
			$this->TaAkhir->ViewCustomAttributes = "";

			// Kode_Fak
			$this->Kode_Fak->LinkCustomAttributes = "";
			$this->Kode_Fak->HrefValue = "";
			$this->Kode_Fak->TooltipValue = "";

			// Kode_Jp
			$this->Kode_Jp->LinkCustomAttributes = "";
			$this->Kode_Jp->HrefValue = "";
			$this->Kode_Jp->TooltipValue = "";

			// NimIM
			$this->NimIM->LinkCustomAttributes = "";
			$this->NimIM->HrefValue = "";
			$this->NimIM->TooltipValue = "";

			// Nim
			$this->Nim->LinkCustomAttributes = "";
			$this->Nim->HrefValue = "";
			$this->Nim->TooltipValue = "";

			// NamaMhs
			$this->NamaMhs->LinkCustomAttributes = "";
			$this->NamaMhs->HrefValue = "";
			$this->NamaMhs->TooltipValue = "";

			// Status_Akd
			$this->Status_Akd->LinkCustomAttributes = "";
			$this->Status_Akd->HrefValue = "";
			$this->Status_Akd->TooltipValue = "";

			// TglLahir
			$this->TglLahir->LinkCustomAttributes = "";
			$this->TglLahir->HrefValue = "";
			$this->TglLahir->TooltipValue = "";

			// TSKS
			$this->TSKS->LinkCustomAttributes = "";
			$this->TSKS->HrefValue = "";
			$this->TSKS->TooltipValue = "";

			// Prodi
			$this->Prodi->LinkCustomAttributes = "";
			$this->Prodi->HrefValue = "";
			$this->Prodi->TooltipValue = "";

			// PerMasuk
			$this->PerMasuk->LinkCustomAttributes = "";
			$this->PerMasuk->HrefValue = "";
			$this->PerMasuk->TooltipValue = "";

			// Status
			$this->Status->LinkCustomAttributes = "";
			$this->Status->HrefValue = "";
			$this->Status->TooltipValue = "";

			// PerKeluar
			$this->PerKeluar->LinkCustomAttributes = "";
			$this->PerKeluar->HrefValue = "";
			$this->PerKeluar->TooltipValue = "";

			// TglKeluar
			$this->TglKeluar->LinkCustomAttributes = "";
			$this->TglKeluar->HrefValue = "";
			$this->TglKeluar->TooltipValue = "";

			// Nama_Mhs
			$this->Nama_Mhs->LinkCustomAttributes = "";
			$this->Nama_Mhs->HrefValue = "";
			$this->Nama_Mhs->TooltipValue = "";

			// Tmp_Lahir
			$this->Tmp_Lahir->LinkCustomAttributes = "";
			$this->Tmp_Lahir->HrefValue = "";
			$this->Tmp_Lahir->TooltipValue = "";

			// Tgl_Lahir
			$this->Tgl_Lahir->LinkCustomAttributes = "";
			$this->Tgl_Lahir->HrefValue = "";
			$this->Tgl_Lahir->TooltipValue = "";

			// StatusSIAP
			$this->StatusSIAP->LinkCustomAttributes = "";
			$this->StatusSIAP->HrefValue = "";
			$this->StatusSIAP->TooltipValue = "";

			// PerMasukIM
			$this->PerMasukIM->LinkCustomAttributes = "";
			$this->PerMasukIM->HrefValue = "";
			$this->PerMasukIM->TooltipValue = "";

			// TaMasuk
			$this->TaMasuk->LinkCustomAttributes = "";
			$this->TaMasuk->HrefValue = "";
			$this->TaMasuk->TooltipValue = "";

			// PMasuk
			$this->PMasuk->LinkCustomAttributes = "";
			$this->PMasuk->HrefValue = "";
			$this->PMasuk->TooltipValue = "";

			// tglmasuk
			$this->tglmasuk->LinkCustomAttributes = "";
			$this->tglmasuk->HrefValue = "";
			$this->tglmasuk->TooltipValue = "";

			// Status_Masuk
			$this->Status_Masuk->LinkCustomAttributes = "";
			$this->Status_Masuk->HrefValue = "";
			$this->Status_Masuk->TooltipValue = "";

			// JalurMasuk
			$this->JalurMasuk->LinkCustomAttributes = "";
			$this->JalurMasuk->HrefValue = "";
			$this->JalurMasuk->TooltipValue = "";

			// PerLulusIM
			$this->PerLulusIM->LinkCustomAttributes = "";
			$this->PerLulusIM->HrefValue = "";
			$this->PerLulusIM->TooltipValue = "";

			// Tgl_Lulus
			$this->Tgl_Lulus->LinkCustomAttributes = "";
			$this->Tgl_Lulus->HrefValue = "";
			$this->Tgl_Lulus->TooltipValue = "";

			// No_Ijazah
			$this->No_Ijazah->LinkCustomAttributes = "";
			$this->No_Ijazah->HrefValue = "";
			$this->No_Ijazah->TooltipValue = "";

			// TA
			$this->TA->LinkCustomAttributes = "";
			$this->TA->HrefValue = "";
			$this->TA->TooltipValue = "";

			// per
			$this->per->LinkCustomAttributes = "";
			$this->per->HrefValue = "";
			$this->per->TooltipValue = "";

			// ProdiIM
			$this->ProdiIM->LinkCustomAttributes = "";
			$this->ProdiIM->HrefValue = "";
			$this->ProdiIM->TooltipValue = "";

			// TaAkhir
			$this->TaAkhir->LinkCustomAttributes = "";
			$this->TaAkhir->HrefValue = "";
			$this->TaAkhir->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_SEARCH) { // Search row

			// Kode_Fak
			$this->Kode_Fak->EditAttrs["class"] = "form-control";
			$this->Kode_Fak->EditCustomAttributes = "";
			$curVal = trim(strval($this->Kode_Fak->AdvancedSearch->SearchValue));
			if ($curVal != "")
				$this->Kode_Fak->AdvancedSearch->ViewValue = $this->Kode_Fak->lookupCacheOption($curVal);
			else
				$this->Kode_Fak->AdvancedSearch->ViewValue = $this->Kode_Fak->Lookup !== NULL && is_array($this->Kode_Fak->Lookup->Options) ? $curVal : NULL;
			if ($this->Kode_Fak->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->Kode_Fak->EditValue = array_values($this->Kode_Fak->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "[Kode_Fak]" . SearchString("=", $this->Kode_Fak->AdvancedSearch->SearchValue, DATATYPE_STRING, "");
				}
				$sqlWrk = $this->Kode_Fak->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = $rswrk ? $rswrk->getRows() : [];
				if ($rswrk)
					$rswrk->close();
				$this->Kode_Fak->EditValue = $arwrk;
			}

			// Kode_Jp
			$this->Kode_Jp->EditAttrs["class"] = "form-control";
			$this->Kode_Jp->EditCustomAttributes = "";
			$curVal = trim(strval($this->Kode_Jp->AdvancedSearch->SearchValue));
			if ($curVal != "")
				$this->Kode_Jp->AdvancedSearch->ViewValue = $this->Kode_Jp->lookupCacheOption($curVal);
			else
				$this->Kode_Jp->AdvancedSearch->ViewValue = $this->Kode_Jp->Lookup !== NULL && is_array($this->Kode_Jp->Lookup->Options) ? $curVal : NULL;
			if ($this->Kode_Jp->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->Kode_Jp->EditValue = array_values($this->Kode_Jp->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "[Kode_Jp]" . SearchString("=", $this->Kode_Jp->AdvancedSearch->SearchValue, DATATYPE_STRING, "");
				}
				$sqlWrk = $this->Kode_Jp->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = $rswrk ? $rswrk->getRows() : [];
				if ($rswrk)
					$rswrk->close();
				$this->Kode_Jp->EditValue = $arwrk;
			}

			// NimIM
			$this->NimIM->EditAttrs["class"] = "form-control";
			$this->NimIM->EditCustomAttributes = "";
			if (!$this->NimIM->Raw)
				$this->NimIM->AdvancedSearch->SearchValue = HtmlDecode($this->NimIM->AdvancedSearch->SearchValue);
			$this->NimIM->EditValue = HtmlEncode($this->NimIM->AdvancedSearch->SearchValue);
			$this->NimIM->PlaceHolder = RemoveHtml($this->NimIM->caption());

			// Nim
			$this->Nim->EditAttrs["class"] = "form-control";
			$this->Nim->EditCustomAttributes = "";
			if (!$this->Nim->Raw)
				$this->Nim->AdvancedSearch->SearchValue = HtmlDecode($this->Nim->AdvancedSearch->SearchValue);
			$this->Nim->EditValue = HtmlEncode($this->Nim->AdvancedSearch->SearchValue);
			$this->Nim->PlaceHolder = RemoveHtml($this->Nim->caption());

			// NamaMhs
			$this->NamaMhs->EditAttrs["class"] = "form-control";
			$this->NamaMhs->EditCustomAttributes = "";
			if (!$this->NamaMhs->Raw)
				$this->NamaMhs->AdvancedSearch->SearchValue = HtmlDecode($this->NamaMhs->AdvancedSearch->SearchValue);
			$this->NamaMhs->EditValue = HtmlEncode($this->NamaMhs->AdvancedSearch->SearchValue);
			$this->NamaMhs->PlaceHolder = RemoveHtml($this->NamaMhs->caption());

			// Status_Akd
			$this->Status_Akd->EditAttrs["class"] = "form-control";
			$this->Status_Akd->EditCustomAttributes = "";
			$curVal = trim(strval($this->Status_Akd->AdvancedSearch->SearchValue));
			if ($curVal != "")
				$this->Status_Akd->AdvancedSearch->ViewValue = $this->Status_Akd->lookupCacheOption($curVal);
			else
				$this->Status_Akd->AdvancedSearch->ViewValue = $this->Status_Akd->Lookup !== NULL && is_array($this->Status_Akd->Lookup->Options) ? $curVal : NULL;
			if ($this->Status_Akd->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->Status_Akd->EditValue = array_values($this->Status_Akd->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "[Kelas]" . SearchString("=", $this->Status_Akd->AdvancedSearch->SearchValue, DATATYPE_STRING, "");
				}
				$sqlWrk = $this->Status_Akd->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = $rswrk ? $rswrk->getRows() : [];
				if ($rswrk)
					$rswrk->close();
				$this->Status_Akd->EditValue = $arwrk;
			}

			// TglLahir
			$this->TglLahir->EditAttrs["class"] = "form-control";
			$this->TglLahir->EditCustomAttributes = "";
			if (!$this->TglLahir->Raw)
				$this->TglLahir->AdvancedSearch->SearchValue = HtmlDecode($this->TglLahir->AdvancedSearch->SearchValue);
			$this->TglLahir->EditValue = HtmlEncode($this->TglLahir->AdvancedSearch->SearchValue);
			$this->TglLahir->PlaceHolder = RemoveHtml($this->TglLahir->caption());

			// TSKS
			$this->TSKS->EditAttrs["class"] = "form-control";
			$this->TSKS->EditCustomAttributes = "";
			if (!$this->TSKS->Raw)
				$this->TSKS->AdvancedSearch->SearchValue = HtmlDecode($this->TSKS->AdvancedSearch->SearchValue);
			$this->TSKS->EditValue = HtmlEncode($this->TSKS->AdvancedSearch->SearchValue);
			$this->TSKS->PlaceHolder = RemoveHtml($this->TSKS->caption());

			// Prodi
			$this->Prodi->EditAttrs["class"] = "form-control";
			$this->Prodi->EditCustomAttributes = "";
			if (!$this->Prodi->Raw)
				$this->Prodi->AdvancedSearch->SearchValue = HtmlDecode($this->Prodi->AdvancedSearch->SearchValue);
			$this->Prodi->EditValue = HtmlEncode($this->Prodi->AdvancedSearch->SearchValue);
			$this->Prodi->PlaceHolder = RemoveHtml($this->Prodi->caption());

			// PerMasuk
			$this->PerMasuk->EditAttrs["class"] = "form-control";
			$this->PerMasuk->EditCustomAttributes = "";
			if (!$this->PerMasuk->Raw)
				$this->PerMasuk->AdvancedSearch->SearchValue = HtmlDecode($this->PerMasuk->AdvancedSearch->SearchValue);
			$this->PerMasuk->EditValue = HtmlEncode($this->PerMasuk->AdvancedSearch->SearchValue);
			$this->PerMasuk->PlaceHolder = RemoveHtml($this->PerMasuk->caption());

			// Status
			$this->Status->EditAttrs["class"] = "form-control";
			$this->Status->EditCustomAttributes = "";
			if (!$this->Status->Raw)
				$this->Status->AdvancedSearch->SearchValue = HtmlDecode($this->Status->AdvancedSearch->SearchValue);
			$this->Status->EditValue = HtmlEncode($this->Status->AdvancedSearch->SearchValue);
			$this->Status->PlaceHolder = RemoveHtml($this->Status->caption());

			// PerKeluar
			$this->PerKeluar->EditAttrs["class"] = "form-control";
			$this->PerKeluar->EditCustomAttributes = "";
			if (!$this->PerKeluar->Raw)
				$this->PerKeluar->AdvancedSearch->SearchValue = HtmlDecode($this->PerKeluar->AdvancedSearch->SearchValue);
			$this->PerKeluar->EditValue = HtmlEncode($this->PerKeluar->AdvancedSearch->SearchValue);
			$this->PerKeluar->PlaceHolder = RemoveHtml($this->PerKeluar->caption());

			// TglKeluar
			$this->TglKeluar->EditAttrs["class"] = "form-control";
			$this->TglKeluar->EditCustomAttributes = "";
			if (!$this->TglKeluar->Raw)
				$this->TglKeluar->AdvancedSearch->SearchValue = HtmlDecode($this->TglKeluar->AdvancedSearch->SearchValue);
			$this->TglKeluar->EditValue = HtmlEncode($this->TglKeluar->AdvancedSearch->SearchValue);
			$this->TglKeluar->PlaceHolder = RemoveHtml($this->TglKeluar->caption());

			// Nama_Mhs
			$this->Nama_Mhs->EditAttrs["class"] = "form-control";
			$this->Nama_Mhs->EditCustomAttributes = "";
			if (!$this->Nama_Mhs->Raw)
				$this->Nama_Mhs->AdvancedSearch->SearchValue = HtmlDecode($this->Nama_Mhs->AdvancedSearch->SearchValue);
			$this->Nama_Mhs->EditValue = HtmlEncode($this->Nama_Mhs->AdvancedSearch->SearchValue);
			$this->Nama_Mhs->PlaceHolder = RemoveHtml($this->Nama_Mhs->caption());

			// Tmp_Lahir
			$this->Tmp_Lahir->EditAttrs["class"] = "form-control";
			$this->Tmp_Lahir->EditCustomAttributes = "";
			if (!$this->Tmp_Lahir->Raw)
				$this->Tmp_Lahir->AdvancedSearch->SearchValue = HtmlDecode($this->Tmp_Lahir->AdvancedSearch->SearchValue);
			$this->Tmp_Lahir->EditValue = HtmlEncode($this->Tmp_Lahir->AdvancedSearch->SearchValue);
			$this->Tmp_Lahir->PlaceHolder = RemoveHtml($this->Tmp_Lahir->caption());

			// Tgl_Lahir
			$this->Tgl_Lahir->EditAttrs["class"] = "form-control";
			$this->Tgl_Lahir->EditCustomAttributes = "";
			$this->Tgl_Lahir->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->Tgl_Lahir->AdvancedSearch->SearchValue, 7), 7));
			$this->Tgl_Lahir->PlaceHolder = RemoveHtml($this->Tgl_Lahir->caption());

			// StatusSIAP
			$this->StatusSIAP->EditAttrs["class"] = "form-control";
			$this->StatusSIAP->EditCustomAttributes = "";
			$this->StatusSIAP->EditValue = $this->StatusSIAP->options(TRUE);

			// PerMasukIM
			$this->PerMasukIM->EditAttrs["class"] = "form-control";
			$this->PerMasukIM->EditCustomAttributes = "";
			if (!$this->PerMasukIM->Raw)
				$this->PerMasukIM->AdvancedSearch->SearchValue = HtmlDecode($this->PerMasukIM->AdvancedSearch->SearchValue);
			$this->PerMasukIM->EditValue = HtmlEncode($this->PerMasukIM->AdvancedSearch->SearchValue);
			$this->PerMasukIM->PlaceHolder = RemoveHtml($this->PerMasukIM->caption());

			// TaMasuk
			$this->TaMasuk->EditAttrs["class"] = "form-control";
			$this->TaMasuk->EditCustomAttributes = "";
			$curVal = trim(strval($this->TaMasuk->AdvancedSearch->SearchValue));
			if ($curVal != "")
				$this->TaMasuk->AdvancedSearch->ViewValue = $this->TaMasuk->lookupCacheOption($curVal);
			else
				$this->TaMasuk->AdvancedSearch->ViewValue = $this->TaMasuk->Lookup !== NULL && is_array($this->TaMasuk->Lookup->Options) ? $curVal : NULL;
			if ($this->TaMasuk->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->TaMasuk->EditValue = array_values($this->TaMasuk->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "[TA]" . SearchString("=", $this->TaMasuk->AdvancedSearch->SearchValue, DATATYPE_STRING, "");
				}
				$sqlWrk = $this->TaMasuk->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = $rswrk ? $rswrk->getRows() : [];
				if ($rswrk)
					$rswrk->close();
				$this->TaMasuk->EditValue = $arwrk;
			}

			// PMasuk
			$this->PMasuk->EditAttrs["class"] = "form-control";
			$this->PMasuk->EditCustomAttributes = "";
			$this->PMasuk->EditValue = $this->PMasuk->options(TRUE);

			// tglmasuk
			$this->tglmasuk->EditAttrs["class"] = "form-control";
			$this->tglmasuk->EditCustomAttributes = "";
			$this->tglmasuk->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->tglmasuk->AdvancedSearch->SearchValue, 7), 7));
			$this->tglmasuk->PlaceHolder = RemoveHtml($this->tglmasuk->caption());

			// Status_Masuk
			$this->Status_Masuk->EditAttrs["class"] = "form-control";
			$this->Status_Masuk->EditCustomAttributes = "";
			if (!$this->Status_Masuk->Raw)
				$this->Status_Masuk->AdvancedSearch->SearchValue = HtmlDecode($this->Status_Masuk->AdvancedSearch->SearchValue);
			$this->Status_Masuk->EditValue = HtmlEncode($this->Status_Masuk->AdvancedSearch->SearchValue);
			$this->Status_Masuk->PlaceHolder = RemoveHtml($this->Status_Masuk->caption());

			// JalurMasuk
			$this->JalurMasuk->EditAttrs["class"] = "form-control";
			$this->JalurMasuk->EditCustomAttributes = "";
			if (!$this->JalurMasuk->Raw)
				$this->JalurMasuk->AdvancedSearch->SearchValue = HtmlDecode($this->JalurMasuk->AdvancedSearch->SearchValue);
			$this->JalurMasuk->EditValue = HtmlEncode($this->JalurMasuk->AdvancedSearch->SearchValue);
			$this->JalurMasuk->PlaceHolder = RemoveHtml($this->JalurMasuk->caption());

			// PerLulusIM
			$this->PerLulusIM->EditAttrs["class"] = "form-control";
			$this->PerLulusIM->EditCustomAttributes = "";
			if (!$this->PerLulusIM->Raw)
				$this->PerLulusIM->AdvancedSearch->SearchValue = HtmlDecode($this->PerLulusIM->AdvancedSearch->SearchValue);
			$this->PerLulusIM->EditValue = HtmlEncode($this->PerLulusIM->AdvancedSearch->SearchValue);
			$this->PerLulusIM->PlaceHolder = RemoveHtml($this->PerLulusIM->caption());

			// Tgl_Lulus
			$this->Tgl_Lulus->EditAttrs["class"] = "form-control";
			$this->Tgl_Lulus->EditCustomAttributes = "";
			$this->Tgl_Lulus->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->Tgl_Lulus->AdvancedSearch->SearchValue, 7), 7));
			$this->Tgl_Lulus->PlaceHolder = RemoveHtml($this->Tgl_Lulus->caption());

			// No_Ijazah
			$this->No_Ijazah->EditAttrs["class"] = "form-control";
			$this->No_Ijazah->EditCustomAttributes = "";
			if (!$this->No_Ijazah->Raw)
				$this->No_Ijazah->AdvancedSearch->SearchValue = HtmlDecode($this->No_Ijazah->AdvancedSearch->SearchValue);
			$this->No_Ijazah->EditValue = HtmlEncode($this->No_Ijazah->AdvancedSearch->SearchValue);
			$this->No_Ijazah->PlaceHolder = RemoveHtml($this->No_Ijazah->caption());

			// TA
			$this->TA->EditAttrs["class"] = "form-control";
			$this->TA->EditCustomAttributes = "";
			if (!$this->TA->Raw)
				$this->TA->AdvancedSearch->SearchValue = HtmlDecode($this->TA->AdvancedSearch->SearchValue);
			$this->TA->EditValue = HtmlEncode($this->TA->AdvancedSearch->SearchValue);
			$this->TA->PlaceHolder = RemoveHtml($this->TA->caption());

			// per
			$this->per->EditAttrs["class"] = "form-control";
			$this->per->EditCustomAttributes = "";
			if (!$this->per->Raw)
				$this->per->AdvancedSearch->SearchValue = HtmlDecode($this->per->AdvancedSearch->SearchValue);
			$this->per->EditValue = HtmlEncode($this->per->AdvancedSearch->SearchValue);
			$this->per->PlaceHolder = RemoveHtml($this->per->caption());

			// ProdiIM
			$this->ProdiIM->EditAttrs["class"] = "form-control";
			$this->ProdiIM->EditCustomAttributes = "";
			if (!$this->ProdiIM->Raw)
				$this->ProdiIM->AdvancedSearch->SearchValue = HtmlDecode($this->ProdiIM->AdvancedSearch->SearchValue);
			$this->ProdiIM->EditValue = HtmlEncode($this->ProdiIM->AdvancedSearch->SearchValue);
			$this->ProdiIM->PlaceHolder = RemoveHtml($this->ProdiIM->caption());

			// TaAkhir
			$this->TaAkhir->EditAttrs["class"] = "form-control";
			$this->TaAkhir->EditCustomAttributes = "";
			if (!$this->TaAkhir->Raw)
				$this->TaAkhir->AdvancedSearch->SearchValue = HtmlDecode($this->TaAkhir->AdvancedSearch->SearchValue);
			$this->TaAkhir->EditValue = HtmlEncode($this->TaAkhir->AdvancedSearch->SearchValue);
			$this->TaAkhir->PlaceHolder = RemoveHtml($this->TaAkhir->caption());
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType != ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate search
	protected function validateSearch()
	{
		global $SearchError;

		// Initialize
		$SearchError = "";

		// Check if validation required
		if (!Config("SERVER_VALIDATE"))
			return TRUE;
		if (!CheckEuroDate($this->Tgl_Lahir->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->Tgl_Lahir->errorMessage());
		}
		if (!CheckEuroDate($this->tglmasuk->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->tglmasuk->errorMessage());
		}
		if (!CheckEuroDate($this->Tgl_Lulus->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->Tgl_Lulus->errorMessage());
		}

		// Return validate result
		$validateSearch = ($SearchError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateSearch = $validateSearch && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError != "") {
			AddMessage($SearchError, $formCustomError);
		}
		return $validateSearch;
	}

	// Load advanced search
	public function loadAdvancedSearch()
	{
		$this->Kode_Fak->AdvancedSearch->load();
		$this->Kode_Jp->AdvancedSearch->load();
		$this->NimIM->AdvancedSearch->load();
		$this->Nim->AdvancedSearch->load();
		$this->NamaMhs->AdvancedSearch->load();
		$this->Status_Akd->AdvancedSearch->load();
		$this->TglLahir->AdvancedSearch->load();
		$this->TSKS->AdvancedSearch->load();
		$this->Prodi->AdvancedSearch->load();
		$this->PerMasuk->AdvancedSearch->load();
		$this->Status->AdvancedSearch->load();
		$this->PerKeluar->AdvancedSearch->load();
		$this->TglKeluar->AdvancedSearch->load();
		$this->Nama_Mhs->AdvancedSearch->load();
		$this->Tmp_Lahir->AdvancedSearch->load();
		$this->Tgl_Lahir->AdvancedSearch->load();
		$this->StatusSIAP->AdvancedSearch->load();
		$this->PerMasukIM->AdvancedSearch->load();
		$this->TaMasuk->AdvancedSearch->load();
		$this->PMasuk->AdvancedSearch->load();
		$this->tglmasuk->AdvancedSearch->load();
		$this->Status_Masuk->AdvancedSearch->load();
		$this->JalurMasuk->AdvancedSearch->load();
		$this->PerLulusIM->AdvancedSearch->load();
		$this->Tgl_Lulus->AdvancedSearch->load();
		$this->No_Ijazah->AdvancedSearch->load();
		$this->TA->AdvancedSearch->load();
		$this->per->AdvancedSearch->load();
		$this->ProdiIM->AdvancedSearch->load();
		$this->TaAkhir->AdvancedSearch->load();
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("ekpt_mhsfeedlist.php"), "", $this->TableVar, TRUE);
		$pageId = "search";
		$Breadcrumb->add("search", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// Get default connection and filter
			$conn = $this->getConnection();
			$lookupFilter = "";

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL and connection
			switch ($fld->FieldVar) {
				case "x_Kode_Fak":
					break;
				case "x_Kode_Jp":
					break;
				case "x_Status_Akd":
					break;
				case "x_StatusSIAP":
					break;
				case "x_TaMasuk":
					break;
				case "x_PMasuk":
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0) {
				$totalCnt = $this->getRecordCount($sql, $conn);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_Kode_Fak":
							break;
						case "x_Kode_Jp":
							break;
						case "x_Status_Akd":
							break;
						case "x_TaMasuk":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
} // End class
?>