<?php
namespace PHPMaker2020\baak;

/**
 * Class for index
 */
class index
{

	// Project ID
	public $ProjectID = "{A09D3AFF-419C-4918-948A-A3C8469EA234}";

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = TRUE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message != "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fas fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage != "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fas fa-exclamation"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage != "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fas fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage != "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fas fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = [];

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message != "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage != "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage != "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage != "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken;

	// Constructor
	public function __construct() {
		$this->CheckToken = Config("CHECK_TOKEN");
	}

	// Terminate page
	public function terminate($url = "")
	{

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Page Redirecting event
		$this->Page_Redirecting($url);

		// Go to URL if specified
		if ($url != "") {
			SaveDebugMessage();
			AddHeader("Location", $url);
		}
		exit();
	}

	//
	// Page run
	//

	public function run()
	{
		global $Language, $UserProfile, $Security, $Breadcrumb;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// User profile
		$UserProfile = new UserProfile();

		// Security object
		$Security = new AdvancedSecurity();
		if (!$Security->isLoggedIn())
			$Security->autoLogin();
		$Security->loadUserLevel(); // Load User Level

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Breadcrumb
		$Breadcrumb = new Breadcrumb();

		// If session expired, show session expired message
		if (Get("expired") == "1")
			$this->setFailureMessage($Language->phrase("SessionExpired"));
		if (!$Security->isLoggedIn())
			$Security->autoLogin();
		if ($Security->allowList(CurrentProjectID() . 'Wali_JadkulMin'))
			$this->terminate("Wali_JadkulMinlist.php"); // Exit and go to default page
		if ($Security->allowList(CurrentProjectID() . 'AWali'))
			$this->terminate("AWalilist.php");
		if ($Security->allowList(CurrentProjectID() . 'HtblNilai'))
			$this->terminate("HtblNilailist.php");
		if ($Security->allowList(CurrentProjectID() . 'mbkm_jadwal'))
			$this->terminate("mbkm_jadwallist.php");
		if ($Security->allowList(CurrentProjectID() . 'mbkm_jenis'))
			$this->terminate("mbkm_jenislist.php");
		if ($Security->allowList(CurrentProjectID() . 'mbkm_siswa'))
			$this->terminate("mbkm_siswalist.php");
		if ($Security->allowList(CurrentProjectID() . 'Perwalian'))
			$this->terminate("Perwalianlist.php");
		if ($Security->allowList(CurrentProjectID() . 'RKP_AbsenDosen'))
			$this->terminate("RKP_AbsenDosenlist.php");
		if ($Security->allowList(CurrentProjectID() . 'tblDosen'))
			$this->terminate("tblDosenlist.php");
		if ($Security->allowList(CurrentProjectID() . 'tbljadwal'))
			$this->terminate("tbljadwallist.php");
		if ($Security->allowList(CurrentProjectID() . 'TblJurusan'))
			$this->terminate("TblJurusanlist.php");
		if ($Security->allowList(CurrentProjectID() . 'tblMasterJadwal'))
			$this->terminate("tblMasterJadwallist.php");
		if ($Security->allowList(CurrentProjectID() . 'tblMHS'))
			$this->terminate("tblMHSlist.php");
		if ($Security->allowList(CurrentProjectID() . 'tblMK'))
			$this->terminate("tblMKlist.php");
		if ($Security->allowList(CurrentProjectID() . 'tblMk_PSmtr'))
			$this->terminate("tblMk_PSmtrlist.php");
		if ($Security->allowList(CurrentProjectID() . 'tblNilai'))
			$this->terminate("tblNilailist.php");
		if ($Security->allowList(CurrentProjectID() . 'IPSIPK'))
			$this->terminate("IPSIPKlist.php");
		if ($Security->allowList(CurrentProjectID() . 'QmhsAktif'))
			$this->terminate("QmhsAktiflist.php");
		if ($Security->allowList(CurrentProjectID() . 'v_jadwal'))
			$this->terminate("v_jadwallist.php");
		if ($Security->allowList(CurrentProjectID() . 'V_LMHS'))
			$this->terminate("V_LMHSlist.php");
		if ($Security->allowList(CurrentProjectID() . 'V_NilaiMhs'))
			$this->terminate("V_NilaiMhslist.php");
		if ($Security->allowList(CurrentProjectID() . 'v_tblnilai'))
			$this->terminate("v_tblnilailist.php");
		if ($Security->allowList(CurrentProjectID() . 'VJadwalKuliah'))
			$this->terminate("VJadwalKuliahlist.php");
		if ($Security->allowList(CurrentProjectID() . 'Wali_IPS'))
			$this->terminate("Wali_IPSlist.php");
		if ($Security->allowList(CurrentProjectID() . 'Wali_Nilai'))
			$this->terminate("Wali_Nilailist.php");
		if ($Security->allowList(CurrentProjectID() . 'Wli_DNS'))
			$this->terminate("Wli_DNSlist.php");
		if ($Security->allowList(CurrentProjectID() . 'QUjian_Soal'))
			$this->terminate("QUjian_Soallist.php");
		if ($Security->allowList(CurrentProjectID() . 'V_RkpHadirDsnMin'))
			$this->terminate("V_RkpHadirDsnMinlist.php");
		if ($Security->allowList(CurrentProjectID() . 'baak_rcndsnhadir'))
			$this->terminate("baak_rcndsnhadirlist.php");
		if ($Security->allowList(CurrentProjectID() . 'QBeasiswa'))
			$this->terminate("QBeasiswalist.php");
		if ($Security->allowList(CurrentProjectID() . 'tblNilaiPerMhs'))
			$this->terminate("tblNilaiPerMhslist.php");
		if ($Security->allowList(CurrentProjectID() . 'tblSK_PMB'))
			$this->terminate("tblSK_PMBlist.php");
		if ($Security->allowList(CurrentProjectID() . 'docmhs'))
			$this->terminate("docmhslist.php");
		if ($Security->allowList(CurrentProjectID() . 'tblPengesahanKHS'))
			$this->terminate("tblPengesahanKHSlist.php");
		if ($Security->allowList(CurrentProjectID() . 'tblPengesahanKRS'))
			$this->terminate("tblPengesahanKRSlist.php");
		if ($Security->allowList(CurrentProjectID() . 'tblPengesahanKEU'))
			$this->terminate("tblPengesahanKEUlist.php");
		if ($Security->allowList(CurrentProjectID() . 'IM_Lulusan'))
			$this->terminate("IM_Lulusanlist.php");
		if ($Security->allowList(CurrentProjectID() . 'IM_Mhs'))
			$this->terminate("IM_Mhslist.php");
		if ($Security->allowList(CurrentProjectID() . 'AuditTrail'))
			$this->terminate("AuditTraillist.php");
		if ($Security->allowList(CurrentProjectID() . 'tblPengesahanPMB'))
			$this->terminate("tblPengesahanPMBlist.php");
		if ($Security->allowList(CurrentProjectID() . 'ekpt_mhsfeed'))
			$this->terminate("ekpt_mhsfeedlist.php");
		if ($Security->allowList(CurrentProjectID() . 'tblMHSEkpt'))
			$this->terminate("tblMHSEkptlist.php");
		if ($Security->allowList(CurrentProjectID() . 'tblSilabus'))
			$this->terminate("tblSilabuslist.php");
		if ($Security->allowList(CurrentProjectID() . 'tblSilabusMaster'))
			$this->terminate("tblSilabusMasterlist.php");
		if ($Security->allowList(CurrentProjectID() . 'Wali_JadKul_All'))
			$this->terminate("Wali_JadKul_Alllist.php");
		if ($Security->allowList(CurrentProjectID() . 'IM_KeadiranKurang'))
			$this->terminate("IM_KeadiranKuranglist.php");
		if ($Security->allowList(CurrentProjectID() . 'IM_Periode3'))
			$this->terminate("IM_Periode3list.php");
		if ($Security->allowList(CurrentProjectID() . 'ekpt_Ferval'))
			$this->terminate("ekpt_Fervallist.php");
		if ($Security->allowList(CurrentProjectID() . 'QPerawali'))
			$this->terminate("QPerawalilist.php");
		if ($Security->allowList(CurrentProjectID() . 'QThawali'))
			$this->terminate("QThawalilist.php");
		if ($Security->allowList(CurrentProjectID() . 'tblPresensiMhs'))
			$this->terminate("tblPresensiMhslist.php");
		if ($Security->allowList(CurrentProjectID() . 'ttd.php'))
			$this->terminate("ttd.php");
		if ($Security->allowList(CurrentProjectID() . 'tblSK_PMB_Lulus'))
			$this->terminate("tblSK_PMB_Luluslist.php");
		if ($Security->isLoggedIn()) {
			$this->setFailureMessage(DeniedMessage() . "<br><br><a href=\"logout.php\">" . $Language->phrase("BackToLogin") . "</a>");
		} else {
			$this->terminate("login.php"); // Exit and go to login page
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'
	function Message_Showing(&$msg, $type) {

		// Example:
		//if ($type == 'success') $msg = "your success message";

	}
}
?>