<?php namespace PHPMaker2020\baak; ?>
<?php

/**
 * Table class for mbkm_jadwal
 */
class mbkm_jadwal extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $Kode_Fak;
	public $Tahun_Akd;
	public $Periode;
	public $Status_Akd;
	public $TM;
	public $TS;
	public $NoSKPenugasan;
	public $TglST;
	public $PejabatTTD;
	public $NIDNTTD;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;
		parent::__construct();

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'mbkm_jadwal';
		$this->TableName = 'mbkm_jadwal';
		$this->TableType = 'TABLE';

		// Update Table
		$this->UpdateTable = "[dbo].[mbkm_jadwal]";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
		$this->BasicSearch = new BasicSearch($this->TableVar);

		// Kode_Fak
		$this->Kode_Fak = new DbField('mbkm_jadwal', 'mbkm_jadwal', 'x_Kode_Fak', 'Kode_Fak', '[Kode_Fak]', '[Kode_Fak]', 129, 10, -1, FALSE, '[Kode_Fak]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->Kode_Fak->IsPrimaryKey = TRUE; // Primary key field
		$this->Kode_Fak->IsForeignKey = TRUE; // Foreign key field
		$this->Kode_Fak->Nullable = FALSE; // NOT NULL field
		$this->Kode_Fak->Required = TRUE; // Required field
		$this->Kode_Fak->Sortable = TRUE; // Allow sort
		$this->Kode_Fak->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->Kode_Fak->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
		$this->Kode_Fak->Lookup = new Lookup('Kode_Fak', 'tblFak', FALSE, 'Kode_Fak', ["Nama_Fak","","",""], [], [], [], [], [], [], '', '');
		$this->fields['Kode_Fak'] = &$this->Kode_Fak;

		// Tahun_Akd
		$this->Tahun_Akd = new DbField('mbkm_jadwal', 'mbkm_jadwal', 'x_Tahun_Akd', 'Tahun_Akd', '[Tahun_Akd]', '[Tahun_Akd]', 129, 10, -1, FALSE, '[Tahun_Akd]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Tahun_Akd->IsPrimaryKey = TRUE; // Primary key field
		$this->Tahun_Akd->IsForeignKey = TRUE; // Foreign key field
		$this->Tahun_Akd->Nullable = FALSE; // NOT NULL field
		$this->Tahun_Akd->Required = TRUE; // Required field
		$this->Tahun_Akd->Sortable = TRUE; // Allow sort
		$this->fields['Tahun_Akd'] = &$this->Tahun_Akd;

		// Periode
		$this->Periode = new DbField('mbkm_jadwal', 'mbkm_jadwal', 'x_Periode', 'Periode', '[Periode]', '[Periode]', 129, 5, -1, FALSE, '[Periode]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->Periode->IsPrimaryKey = TRUE; // Primary key field
		$this->Periode->IsForeignKey = TRUE; // Foreign key field
		$this->Periode->Nullable = FALSE; // NOT NULL field
		$this->Periode->Required = TRUE; // Required field
		$this->Periode->Sortable = TRUE; // Allow sort
		$this->Periode->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->Periode->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
		$this->Periode->Lookup = new Lookup('Periode', 'mbkm_jadwal', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->Periode->OptionCount = 3;
		$this->fields['Periode'] = &$this->Periode;

		// Status_Akd
		$this->Status_Akd = new DbField('mbkm_jadwal', 'mbkm_jadwal', 'x_Status_Akd', 'Status_Akd', '[Status_Akd]', '[Status_Akd]', 129, 15, -1, FALSE, '[Status_Akd]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->Status_Akd->IsPrimaryKey = TRUE; // Primary key field
		$this->Status_Akd->IsForeignKey = TRUE; // Foreign key field
		$this->Status_Akd->Nullable = FALSE; // NOT NULL field
		$this->Status_Akd->Required = TRUE; // Required field
		$this->Status_Akd->Sortable = TRUE; // Allow sort
		$this->Status_Akd->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->Status_Akd->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
		$this->Status_Akd->Lookup = new Lookup('Status_Akd', 'tblkelas', FALSE, 'Kelas', ["Kelas","","",""], [], [], [], [], [], [], '', '');
		$this->fields['Status_Akd'] = &$this->Status_Akd;

		// TM
		$this->TM = new DbField('mbkm_jadwal', 'mbkm_jadwal', 'x_TM', 'TM', '[TM]', CastDateFieldForLike("[TM]", 7, "DB"), 135, 8, 7, FALSE, '[TM]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->TM->Required = TRUE; // Required field
		$this->TM->Sortable = TRUE; // Allow sort
		$this->TM->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_SEPARATOR"], $Language->phrase("IncorrectDateDMY"));
		$this->fields['TM'] = &$this->TM;

		// TS
		$this->TS = new DbField('mbkm_jadwal', 'mbkm_jadwal', 'x_TS', 'TS', '[TS]', CastDateFieldForLike("[TS]", 7, "DB"), 135, 8, 7, FALSE, '[TS]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->TS->Required = TRUE; // Required field
		$this->TS->Sortable = TRUE; // Allow sort
		$this->TS->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_SEPARATOR"], $Language->phrase("IncorrectDateDMY"));
		$this->fields['TS'] = &$this->TS;

		// NoSKPenugasan
		$this->NoSKPenugasan = new DbField('mbkm_jadwal', 'mbkm_jadwal', 'x_NoSKPenugasan', 'NoSKPenugasan', '[NoSKPenugasan]', '[NoSKPenugasan]', 200, 100, -1, FALSE, '[NoSKPenugasan]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->NoSKPenugasan->Sortable = TRUE; // Allow sort
		$this->fields['NoSKPenugasan'] = &$this->NoSKPenugasan;

		// TglST
		$this->TglST = new DbField('mbkm_jadwal', 'mbkm_jadwal', 'x_TglST', 'TglST', '[TglST]', CastDateFieldForLike("[TglST]", 0, "DB"), 135, 8, 0, FALSE, '[TglST]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->TglST->Sortable = TRUE; // Allow sort
		$this->TglST->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['TglST'] = &$this->TglST;

		// PejabatTTD
		$this->PejabatTTD = new DbField('mbkm_jadwal', 'mbkm_jadwal', 'x_PejabatTTD', 'PejabatTTD', '[PejabatTTD]', '[PejabatTTD]', 200, 50, -1, FALSE, '[PejabatTTD]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->PejabatTTD->Sortable = TRUE; // Allow sort
		$this->fields['PejabatTTD'] = &$this->PejabatTTD;

		// NIDNTTD
		$this->NIDNTTD = new DbField('mbkm_jadwal', 'mbkm_jadwal', 'x_NIDNTTD', 'NIDNTTD', '[NIDNTTD]', '[NIDNTTD]', 129, 14, -1, FALSE, '[EV__NIDNTTD]', TRUE, TRUE, TRUE, 'FORMATTED TEXT', 'SELECT');
		$this->NIDNTTD->Sortable = TRUE; // Allow sort
		$this->NIDNTTD->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->NIDNTTD->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
		$this->NIDNTTD->Lookup = new Lookup('NIDNTTD', 'tblDosen', FALSE, 'NIDN', ["NIDN","Nama","",""], [], [], [], [], [], [], '', '');
		$this->fields['NIDNTTD'] = &$this->NIDNTTD;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Single column sort
	public function updateSort(&$fld)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
			$sortFieldList = ($fld->VirtualExpression != "") ? $fld->VirtualExpression : $sortField;
			$this->setSessionOrderByList($sortFieldList . " " . $thisSort); // Save to Session
		} else {
			$fld->setSort("");
		}
	}

	// Session ORDER BY for List page
	public function getSessionOrderByList()
	{
		return @$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_ORDER_BY_LIST")];
	}
	public function setSessionOrderByList($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_ORDER_BY_LIST")] = $v;
	}

	// Current detail table name
	public function getCurrentDetailTable()
	{
		return @$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_DETAIL_TABLE")];
	}
	public function setCurrentDetailTable($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_DETAIL_TABLE")] = $v;
	}

	// Get detail url
	public function getDetailUrl()
	{

		// Detail url
		$detailUrl = "";
		if ($this->getCurrentDetailTable() == "mbkm_siswa") {
			$detailUrl = $GLOBALS["mbkm_siswa"]->getListUrl() . "?" . Config("TABLE_SHOW_MASTER") . "=" . $this->TableVar;
			$detailUrl .= "&fk_Kode_Fak=" . urlencode($this->Kode_Fak->CurrentValue);
			$detailUrl .= "&fk_Tahun_Akd=" . urlencode($this->Tahun_Akd->CurrentValue);
			$detailUrl .= "&fk_Periode=" . urlencode($this->Periode->CurrentValue);
			$detailUrl .= "&fk_Status_Akd=" . urlencode($this->Status_Akd->CurrentValue);
		}
		if ($detailUrl == "")
			$detailUrl = "mbkm_jadwallist.php";
		return $detailUrl;
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom != "") ? $this->SqlFrom : "[dbo].[mbkm_jadwal]";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect != "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlSelectList() // Select for List page
	{
		$select = "";
		$select = "SELECT * FROM (" .
			"SELECT *, (SELECT TOP 1 CONVERT(NVARCHAR(MAX),[NIDN]) + '" . ValueSeparator(1, $this->NIDNTTD) . "' + CONVERT(NVARCHAR(MAX),[Nama]) FROM [dbo].[tblDosen] [TMP_LOOKUPTABLE] WHERE [TMP_LOOKUPTABLE].[NIDN] = [mbkm_jadwal].[NIDNTTD]) AS [EV__NIDNTTD] FROM [dbo].[mbkm_jadwal]" .
			") [TMP_TABLE]";
		return ($this->SqlSelectList != "") ? $this->SqlSelectList : $select;
	}
	public function sqlSelectList() // For backward compatibility
	{
		return $this->getSqlSelectList();
	}
	public function setSqlSelectList($v)
	{
		$this->SqlSelectList = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy != "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving != "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "[Tahun_Akd] DESC,[Periode] DESC,[Kode_Fak] ASC";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter, $id = "")
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = $this->UserIDAllowSecurity;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 32) == 32);
			case "search":
				return (($allow & 64) == 64);
			case "lookup":
				return (($allow & 256) == 256);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get recordset
	public function getRecordset($sql, $rowcnt = -1, $offset = -1)
	{
		$conn = $this->getConnection();
		$conn->raiseErrorFn = Config("ERROR_FUNC");
		$rs = $conn->selectLimit($sql, $rowcnt, $offset);
		$conn->raiseErrorFn = "";
		return $rs;
	}

	// Get record count
	public function getRecordCount($sql, $c = NULL)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) &&
			!preg_match('/^\s*select\s+distinct\s+/i', $sql) && !preg_match('/\s+order\s+by\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = $c ?: $this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		if ($this->useVirtualFields()) {
			$select = $this->getSqlSelectList();
			$sort = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
		} else {
			$select = $this->getSqlSelect();
			$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		}
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = ($this->useVirtualFields()) ? $this->getSessionOrderByList() : $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Check if virtual fields is used in SQL
	protected function useVirtualFields()
	{
		$where = $this->UseSessionForListSql ? $this->getSessionWhere() : $this->CurrentFilter;
		$orderBy = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
		if ($where != "")
			$where = " " . str_replace(["(", ")"], ["", ""], $where) . " ";
		if ($orderBy != "")
			$orderBy = " " . str_replace(["(", ")"], ["", ""], $orderBy) . " ";
		if ($this->BasicSearch->getKeyword() != "")
			return TRUE;
		if ($this->NIDNTTD->AdvancedSearch->SearchValue != "" ||
			$this->NIDNTTD->AdvancedSearch->SearchValue2 != "" ||
			ContainsString($where, " " . $this->NIDNTTD->VirtualExpression . " "))
			return TRUE;
		if (ContainsString($orderBy, " " . $this->NIDNTTD->VirtualExpression . " "))
			return TRUE;
		return FALSE;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		if ($this->useVirtualFields())
			$sql = BuildSelectSql($this->getSqlSelectList(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		else
			$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " (" . $names . ") VALUES (" . $values . ")";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = $this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsAutoIncrement)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter != "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = $this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('Kode_Fak', $rs))
				AddFilter($where, QuotedName('Kode_Fak', $this->Dbid) . '=' . QuotedValue($rs['Kode_Fak'], $this->Kode_Fak->DataType, $this->Dbid));
			if (array_key_exists('Tahun_Akd', $rs))
				AddFilter($where, QuotedName('Tahun_Akd', $this->Dbid) . '=' . QuotedValue($rs['Tahun_Akd'], $this->Tahun_Akd->DataType, $this->Dbid));
			if (array_key_exists('Periode', $rs))
				AddFilter($where, QuotedName('Periode', $this->Dbid) . '=' . QuotedValue($rs['Periode'], $this->Periode->DataType, $this->Dbid));
			if (array_key_exists('Status_Akd', $rs))
				AddFilter($where, QuotedName('Status_Akd', $this->Dbid) . '=' . QuotedValue($rs['Status_Akd'], $this->Status_Akd->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter != "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = $this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->Kode_Fak->DbValue = $row['Kode_Fak'];
		$this->Tahun_Akd->DbValue = $row['Tahun_Akd'];
		$this->Periode->DbValue = $row['Periode'];
		$this->Status_Akd->DbValue = $row['Status_Akd'];
		$this->TM->DbValue = $row['TM'];
		$this->TS->DbValue = $row['TS'];
		$this->NoSKPenugasan->DbValue = $row['NoSKPenugasan'];
		$this->TglST->DbValue = $row['TglST'];
		$this->PejabatTTD->DbValue = $row['PejabatTTD'];
		$this->NIDNTTD->DbValue = $row['NIDNTTD'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "[Kode_Fak] = '@Kode_Fak@' AND [Tahun_Akd] = '@Tahun_Akd@' AND [Periode] = '@Periode@' AND [Status_Akd] = '@Status_Akd@'";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		if (is_array($row))
			$val = array_key_exists('Kode_Fak', $row) ? $row['Kode_Fak'] : NULL;
		else
			$val = $this->Kode_Fak->OldValue !== NULL ? $this->Kode_Fak->OldValue : $this->Kode_Fak->CurrentValue;
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@Kode_Fak@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		if (is_array($row))
			$val = array_key_exists('Tahun_Akd', $row) ? $row['Tahun_Akd'] : NULL;
		else
			$val = $this->Tahun_Akd->OldValue !== NULL ? $this->Tahun_Akd->OldValue : $this->Tahun_Akd->CurrentValue;
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@Tahun_Akd@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		if (is_array($row))
			$val = array_key_exists('Periode', $row) ? $row['Periode'] : NULL;
		else
			$val = $this->Periode->OldValue !== NULL ? $this->Periode->OldValue : $this->Periode->CurrentValue;
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@Periode@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		if (is_array($row))
			$val = array_key_exists('Status_Akd', $row) ? $row['Status_Akd'] : NULL;
		else
			$val = $this->Status_Akd->OldValue !== NULL ? $this->Status_Akd->OldValue : $this->Status_Akd->CurrentValue;
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@Status_Akd@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") != "" && ReferPageName() != CurrentPageName() && ReferPageName() != "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] != "") {
			return $_SESSION[$name];
		} else {
			return "mbkm_jadwallist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "mbkm_jadwalview.php")
			return $Language->phrase("View");
		elseif ($pageName == "mbkm_jadwaledit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "mbkm_jadwaladd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "mbkm_jadwallist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm != "")
			$url = $this->keyUrl("mbkm_jadwalview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("mbkm_jadwalview.php", $this->getUrlParm(Config("TABLE_SHOW_DETAIL") . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm != "")
			$url = "mbkm_jadwaladd.php?" . $this->getUrlParm($parm);
		else
			$url = "mbkm_jadwaladd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		if ($parm != "")
			$url = $this->keyUrl("mbkm_jadwaledit.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("mbkm_jadwaledit.php", $this->getUrlParm(Config("TABLE_SHOW_DETAIL") . "="));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		if ($parm != "")
			$url = $this->keyUrl("mbkm_jadwaladd.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("mbkm_jadwaladd.php", $this->getUrlParm(Config("TABLE_SHOW_DETAIL") . "="));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("mbkm_jadwaldelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "Kode_Fak:" . JsonEncode($this->Kode_Fak->CurrentValue, "string");
		$json .= ",Tahun_Akd:" . JsonEncode($this->Tahun_Akd->CurrentValue, "string");
		$json .= ",Periode:" . JsonEncode($this->Periode->CurrentValue, "string");
		$json .= ",Status_Akd:" . JsonEncode($this->Status_Akd->CurrentValue, "string");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm != "")
			$url .= $parm . "&";
		if ($this->Kode_Fak->CurrentValue != NULL) {
			$url .= "Kode_Fak=" . urlencode($this->Kode_Fak->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		if ($this->Tahun_Akd->CurrentValue != NULL) {
			$url .= "&Tahun_Akd=" . urlencode($this->Tahun_Akd->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		if ($this->Periode->CurrentValue != NULL) {
			$url .= "&Periode=" . urlencode($this->Periode->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		if ($this->Status_Akd->CurrentValue != NULL) {
			$url .= "&Status_Akd=" . urlencode($this->Status_Akd->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, [141, 201, 203, 128, 204, 205])) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		$arKeys = [];
		$arKey = [];
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
			for ($i = 0; $i < $cnt; $i++)
				$arKeys[$i] = explode(Config("COMPOSITE_KEY_SEPARATOR"), $arKeys[$i]);
		} else {
			if (Param("Kode_Fak") !== NULL)
				$arKey[] = Param("Kode_Fak");
			elseif (IsApi() && Key(0) !== NULL)
				$arKey[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKey[] = Route(2);
			else
				$arKeys = NULL; // Do not setup
			if (Param("Tahun_Akd") !== NULL)
				$arKey[] = Param("Tahun_Akd");
			elseif (IsApi() && Key(1) !== NULL)
				$arKey[] = Key(1);
			elseif (IsApi() && Route(3) !== NULL)
				$arKey[] = Route(3);
			else
				$arKeys = NULL; // Do not setup
			if (Param("Periode") !== NULL)
				$arKey[] = Param("Periode");
			elseif (IsApi() && Key(2) !== NULL)
				$arKey[] = Key(2);
			elseif (IsApi() && Route(4) !== NULL)
				$arKey[] = Route(4);
			else
				$arKeys = NULL; // Do not setup
			if (Param("Status_Akd") !== NULL)
				$arKey[] = Param("Status_Akd");
			elseif (IsApi() && Key(3) !== NULL)
				$arKey[] = Key(3);
			elseif (IsApi() && Route(5) !== NULL)
				$arKey[] = Route(5);
			else
				$arKeys = NULL; // Do not setup
			if (is_array($arKeys)) $arKeys[] = $arKey;

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = [];
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_array($key) || count($key) != 4)
					continue; // Just skip so other keys will still work
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys($setCurrent = TRUE)
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter != "") $keyFilter .= " OR ";
			if ($setCurrent)
				$this->Kode_Fak->CurrentValue = $key[0];
			else
				$this->Kode_Fak->OldValue = $key[0];
			if ($setCurrent)
				$this->Tahun_Akd->CurrentValue = $key[1];
			else
				$this->Tahun_Akd->OldValue = $key[1];
			if ($setCurrent)
				$this->Periode->CurrentValue = $key[2];
			else
				$this->Periode->OldValue = $key[2];
			if ($setCurrent)
				$this->Status_Akd->CurrentValue = $key[3];
			else
				$this->Status_Akd->OldValue = $key[3];
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = $this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->Kode_Fak->setDbValue($rs->fields('Kode_Fak'));
		$this->Tahun_Akd->setDbValue($rs->fields('Tahun_Akd'));
		$this->Periode->setDbValue($rs->fields('Periode'));
		$this->Status_Akd->setDbValue($rs->fields('Status_Akd'));
		$this->TM->setDbValue($rs->fields('TM'));
		$this->TS->setDbValue($rs->fields('TS'));
		$this->NoSKPenugasan->setDbValue($rs->fields('NoSKPenugasan'));
		$this->TglST->setDbValue($rs->fields('TglST'));
		$this->PejabatTTD->setDbValue($rs->fields('PejabatTTD'));
		$this->NIDNTTD->setDbValue($rs->fields('NIDNTTD'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// Kode_Fak
		// Tahun_Akd
		// Periode
		// Status_Akd
		// TM
		// TS
		// NoSKPenugasan
		// TglST
		// PejabatTTD
		// NIDNTTD
		// Kode_Fak

		$curVal = strval($this->Kode_Fak->CurrentValue);
		if ($curVal != "") {
			$this->Kode_Fak->ViewValue = $this->Kode_Fak->lookupCacheOption($curVal);
			if ($this->Kode_Fak->ViewValue === NULL) { // Lookup from database
				$filterWrk = "[Kode_Fak]" . SearchString("=", $curVal, DATATYPE_STRING, "");
				$sqlWrk = $this->Kode_Fak->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = [];
					$arwrk[1] = $rswrk->fields('df');
					$this->Kode_Fak->ViewValue = $this->Kode_Fak->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->Kode_Fak->ViewValue = $this->Kode_Fak->CurrentValue;
				}
			}
		} else {
			$this->Kode_Fak->ViewValue = NULL;
		}
		$this->Kode_Fak->ViewCustomAttributes = "";

		// Tahun_Akd
		$this->Tahun_Akd->ViewValue = $this->Tahun_Akd->CurrentValue;
		$this->Tahun_Akd->ViewCustomAttributes = "";

		// Periode
		if (strval($this->Periode->CurrentValue) != "") {
			$this->Periode->ViewValue = $this->Periode->optionCaption($this->Periode->CurrentValue);
		} else {
			$this->Periode->ViewValue = NULL;
		}
		$this->Periode->ViewCustomAttributes = "";

		// Status_Akd
		$curVal = strval($this->Status_Akd->CurrentValue);
		if ($curVal != "") {
			$this->Status_Akd->ViewValue = $this->Status_Akd->lookupCacheOption($curVal);
			if ($this->Status_Akd->ViewValue === NULL) { // Lookup from database
				$filterWrk = "[Kelas]" . SearchString("=", $curVal, DATATYPE_STRING, "");
				$sqlWrk = $this->Status_Akd->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = [];
					$arwrk[1] = $rswrk->fields('df');
					$this->Status_Akd->ViewValue = $this->Status_Akd->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->Status_Akd->ViewValue = $this->Status_Akd->CurrentValue;
				}
			}
		} else {
			$this->Status_Akd->ViewValue = NULL;
		}
		$this->Status_Akd->ViewCustomAttributes = "";

		// TM
		$this->TM->ViewValue = $this->TM->CurrentValue;
		$this->TM->ViewValue = FormatDateTime($this->TM->ViewValue, 7);
		$this->TM->ViewCustomAttributes = "";

		// TS
		$this->TS->ViewValue = $this->TS->CurrentValue;
		$this->TS->ViewValue = FormatDateTime($this->TS->ViewValue, 7);
		$this->TS->ViewCustomAttributes = "";

		// NoSKPenugasan
		$this->NoSKPenugasan->ViewValue = $this->NoSKPenugasan->CurrentValue;
		$this->NoSKPenugasan->ViewCustomAttributes = "";

		// TglST
		$this->TglST->ViewValue = $this->TglST->CurrentValue;
		$this->TglST->ViewValue = FormatDateTime($this->TglST->ViewValue, 0);
		$this->TglST->ViewCustomAttributes = "";

		// PejabatTTD
		$this->PejabatTTD->ViewValue = $this->PejabatTTD->CurrentValue;
		$this->PejabatTTD->ViewCustomAttributes = "";

		// NIDNTTD
		if ($this->NIDNTTD->VirtualValue != "") {
			$this->NIDNTTD->ViewValue = $this->NIDNTTD->VirtualValue;
		} else {
			$curVal = strval($this->NIDNTTD->CurrentValue);
			if ($curVal != "") {
				$this->NIDNTTD->ViewValue = $this->NIDNTTD->lookupCacheOption($curVal);
				if ($this->NIDNTTD->ViewValue === NULL) { // Lookup from database
					$filterWrk = "[NIDN]" . SearchString("=", $curVal, DATATYPE_STRING, "");
					$sqlWrk = $this->NIDNTTD->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = [];
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->NIDNTTD->ViewValue = $this->NIDNTTD->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->NIDNTTD->ViewValue = $this->NIDNTTD->CurrentValue;
					}
				}
			} else {
				$this->NIDNTTD->ViewValue = NULL;
			}
		}
		$this->NIDNTTD->ViewCustomAttributes = "";

		// Kode_Fak
		$this->Kode_Fak->LinkCustomAttributes = "";
		$this->Kode_Fak->HrefValue = "";
		$this->Kode_Fak->TooltipValue = "";

		// Tahun_Akd
		$this->Tahun_Akd->LinkCustomAttributes = "";
		$this->Tahun_Akd->HrefValue = "";
		$this->Tahun_Akd->TooltipValue = "";

		// Periode
		$this->Periode->LinkCustomAttributes = "";
		$this->Periode->HrefValue = "";
		$this->Periode->TooltipValue = "";

		// Status_Akd
		$this->Status_Akd->LinkCustomAttributes = "";
		$this->Status_Akd->HrefValue = "";
		$this->Status_Akd->TooltipValue = "";

		// TM
		$this->TM->LinkCustomAttributes = "";
		$this->TM->HrefValue = "";
		$this->TM->TooltipValue = "";

		// TS
		$this->TS->LinkCustomAttributes = "";
		$this->TS->HrefValue = "";
		$this->TS->TooltipValue = "";

		// NoSKPenugasan
		$this->NoSKPenugasan->LinkCustomAttributes = "";
		$this->NoSKPenugasan->HrefValue = "";
		$this->NoSKPenugasan->TooltipValue = "";

		// TglST
		$this->TglST->LinkCustomAttributes = "";
		$this->TglST->HrefValue = "";
		$this->TglST->TooltipValue = "";

		// PejabatTTD
		$this->PejabatTTD->LinkCustomAttributes = "";
		$this->PejabatTTD->HrefValue = "";
		$this->PejabatTTD->TooltipValue = "";

		// NIDNTTD
		$this->NIDNTTD->LinkCustomAttributes = "";
		$this->NIDNTTD->HrefValue = "";
		$this->NIDNTTD->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Kode_Fak
		$this->Kode_Fak->EditAttrs["class"] = "form-control";
		$this->Kode_Fak->EditCustomAttributes = "";

		// Tahun_Akd
		$this->Tahun_Akd->EditAttrs["class"] = "form-control";
		$this->Tahun_Akd->EditCustomAttributes = "";
		if (!$this->Tahun_Akd->Raw)
			$this->Tahun_Akd->CurrentValue = HtmlDecode($this->Tahun_Akd->CurrentValue);
		$this->Tahun_Akd->EditValue = $this->Tahun_Akd->CurrentValue;
		$this->Tahun_Akd->PlaceHolder = RemoveHtml($this->Tahun_Akd->caption());

		// Periode
		$this->Periode->EditAttrs["class"] = "form-control";
		$this->Periode->EditCustomAttributes = "";
		$this->Periode->EditValue = $this->Periode->options(TRUE);

		// Status_Akd
		$this->Status_Akd->EditAttrs["class"] = "form-control";
		$this->Status_Akd->EditCustomAttributes = "";

		// TM
		$this->TM->EditAttrs["class"] = "form-control";
		$this->TM->EditCustomAttributes = "";
		$this->TM->EditValue = FormatDateTime($this->TM->CurrentValue, 7);
		$this->TM->PlaceHolder = RemoveHtml($this->TM->caption());

		// TS
		$this->TS->EditAttrs["class"] = "form-control";
		$this->TS->EditCustomAttributes = "";
		$this->TS->EditValue = FormatDateTime($this->TS->CurrentValue, 7);
		$this->TS->PlaceHolder = RemoveHtml($this->TS->caption());

		// NoSKPenugasan
		$this->NoSKPenugasan->EditAttrs["class"] = "form-control";
		$this->NoSKPenugasan->EditCustomAttributes = "";
		if (!$this->NoSKPenugasan->Raw)
			$this->NoSKPenugasan->CurrentValue = HtmlDecode($this->NoSKPenugasan->CurrentValue);
		$this->NoSKPenugasan->EditValue = $this->NoSKPenugasan->CurrentValue;
		$this->NoSKPenugasan->PlaceHolder = RemoveHtml($this->NoSKPenugasan->caption());

		// TglST
		$this->TglST->EditAttrs["class"] = "form-control";
		$this->TglST->EditCustomAttributes = "";
		$this->TglST->EditValue = FormatDateTime($this->TglST->CurrentValue, 8);
		$this->TglST->PlaceHolder = RemoveHtml($this->TglST->caption());

		// PejabatTTD
		$this->PejabatTTD->EditAttrs["class"] = "form-control";
		$this->PejabatTTD->EditCustomAttributes = "";
		if (!$this->PejabatTTD->Raw)
			$this->PejabatTTD->CurrentValue = HtmlDecode($this->PejabatTTD->CurrentValue);
		$this->PejabatTTD->EditValue = $this->PejabatTTD->CurrentValue;
		$this->PejabatTTD->PlaceHolder = RemoveHtml($this->PejabatTTD->caption());

		// NIDNTTD
		$this->NIDNTTD->EditAttrs["class"] = "form-control";
		$this->NIDNTTD->EditCustomAttributes = "";

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->Kode_Fak);
					$doc->exportCaption($this->Tahun_Akd);
					$doc->exportCaption($this->Periode);
					$doc->exportCaption($this->Status_Akd);
					$doc->exportCaption($this->TM);
					$doc->exportCaption($this->TS);
					$doc->exportCaption($this->NoSKPenugasan);
					$doc->exportCaption($this->TglST);
					$doc->exportCaption($this->PejabatTTD);
					$doc->exportCaption($this->NIDNTTD);
				} else {
					$doc->exportCaption($this->Kode_Fak);
					$doc->exportCaption($this->Tahun_Akd);
					$doc->exportCaption($this->Periode);
					$doc->exportCaption($this->Status_Akd);
					$doc->exportCaption($this->TM);
					$doc->exportCaption($this->TS);
					$doc->exportCaption($this->NoSKPenugasan);
					$doc->exportCaption($this->TglST);
					$doc->exportCaption($this->PejabatTTD);
					$doc->exportCaption($this->NIDNTTD);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->Kode_Fak);
						$doc->exportField($this->Tahun_Akd);
						$doc->exportField($this->Periode);
						$doc->exportField($this->Status_Akd);
						$doc->exportField($this->TM);
						$doc->exportField($this->TS);
						$doc->exportField($this->NoSKPenugasan);
						$doc->exportField($this->TglST);
						$doc->exportField($this->PejabatTTD);
						$doc->exportField($this->NIDNTTD);
					} else {
						$doc->exportField($this->Kode_Fak);
						$doc->exportField($this->Tahun_Akd);
						$doc->exportField($this->Periode);
						$doc->exportField($this->Status_Akd);
						$doc->exportField($this->TM);
						$doc->exportField($this->TS);
						$doc->exportField($this->NoSKPenugasan);
						$doc->exportField($this->TglST);
						$doc->exportField($this->PejabatTTD);
						$doc->exportField($this->NIDNTTD);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0)
	{

		// No binary fields
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>