<?php
namespace PHPMaker2020\baak;

/**
 * Page class
 */
class mbkm_jadwal_edit extends mbkm_jadwal
{

	// Page ID
	public $PageID = "edit";

	// Project ID
	public $ProjectID = "{A09D3AFF-419C-4918-948A-A3C8469EA234}";

	// Table name
	public $TableName = 'mbkm_jadwal';

	// Page object name
	public $PageObjName = "mbkm_jadwal_edit";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken;

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading != "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading != "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		$url = CurrentPageName() . "?";
		if ($this->UseTokenInUrl)
			$url .= "t=" . $this->TableVar . "&"; // Add page token
		return $url;
	}

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = TRUE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message != "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fas fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage != "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fas fa-exclamation"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage != "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fas fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage != "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fas fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = [];

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message != "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage != "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage != "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage != "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header != "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer != "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(Config("TOKEN_NAME")) === NULL)
			return FALSE;
		$fn = Config("CHECK_TOKEN_FUNC");
		if (is_callable($fn))
			return $fn(Post(Config("TOKEN_NAME")), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = Config("CREATE_TOKEN_FUNC"); // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $DashboardReport;
		global $UserTable;

		// Check token
		$this->CheckToken = Config("CHECK_TOKEN");

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (mbkm_jadwal)
		if (!isset($GLOBALS["mbkm_jadwal"]) || get_class($GLOBALS["mbkm_jadwal"]) == PROJECT_NAMESPACE . "mbkm_jadwal") {
			$GLOBALS["mbkm_jadwal"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["mbkm_jadwal"];
		}

		// Table object (Pass)
		if (!isset($GLOBALS['Pass']))
			$GLOBALS['Pass'] = new Pass();

		// Page ID (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'edit');

		// Table name (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'mbkm_jadwal');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = $this->getConnection();

		// User table object (Pass)
		$UserTable = $UserTable ?: new Pass();
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages, $DashboardReport;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $mbkm_jadwal;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, Config("EXPORT_CLASSES"))) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . Config("EXPORT_CLASSES." . $this->CustomExport);
			if (class_exists($class)) {
				$doc = new $class($mbkm_jadwal);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url != "") {
			if (!Config("DEBUG") && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = ["url" => $url, "modal" => "1"];
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "mbkm_jadwalview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = [];
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = [];
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {
								$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
									Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
									Config("API_FIELD_NAME") . "=" . $fld->Param . "&" .
									Config("API_KEY_NAME") . "=" . rawurlencode($this->getRecordKeyValue($ar)))); //*** need to add this? API may not be in the same folder
								$row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
								$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
									Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
									"fn=" . Encrypt($fld->physicalUploadPath() . $val)));
								$row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
							} else { // Multiple files
								$files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
								$ar = [];
								foreach ($files as $file) {
									$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
										Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
										"fn=" . Encrypt($fld->physicalUploadPath() . $file)));
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['Kode_Fak'] . Config("COMPOSITE_KEY_SEPARATOR");
			$key .= @$ar['Tahun_Akd'] . Config("COMPOSITE_KEY_SEPARATOR");
			$key .= @$ar['Periode'] . Config("COMPOSITE_KEY_SEPARATOR");
			$key .= @$ar['Status_Akd'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
	}

	// Lookup data
	public function lookup()
	{
		global $Language, $Security;
		if (!isset($Language))
			$Language = new Language(Config("LANGUAGE_FOLDER"), Post("language", ""));

		// Set up API request
		if (!ValidApiRequest())
			return FALSE;
		$this->setupApiSecurity();

		// Get lookup object
		$fieldName = Post("field");
		if (!array_key_exists($fieldName, $this->fields))
			return FALSE;
		$lookupField = $this->fields[$fieldName];
		$lookup = $lookupField->Lookup;
		if ($lookup === NULL)
			return FALSE;
		$tbl = $lookup->getTable();
		if (!$Security->allowLookup(Config("PROJECT_ID") . $tbl->TableName)) // Lookup permission
			return FALSE;

		// Get lookup parameters
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Param("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
			$lookup->FilterFields = []; // Skip parent fields if any
			$lookup->FilterValues[] = $keys; // Lookup values
			$pageSize = -1; // Show all records
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect != "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter != "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy != "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson($this); // Use settings from current page
	}

	// Set up API security
	public function setupApiSecurity()
	{
		global $Security;

		// Setup security for API request
		if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
		$Security->loadCurrentUserLevel(Config("PROJECT_ID") . $this->TableName);
		if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
	}
	public $FormClassName = "ew-horizontal ew-form ew-edit-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $DbMasterFilter;
	public $DbDetailFilter;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		if (ValidApiRequest()) { // API request
			$this->setupApiSecurity(); // Set up API Security
			if (!$Security->canEdit()) {
				SetStatus(401); // Unauthorized
				return;
			}
		} else {
			$Security = new AdvancedSecurity();
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canEdit()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("mbkm_jadwallist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->Kode_Fak->setVisibility();
		$this->Tahun_Akd->setVisibility();
		$this->Periode->setVisibility();
		$this->Status_Akd->setVisibility();
		$this->TM->setVisibility();
		$this->TS->setVisibility();
		$this->NoSKPenugasan->setVisibility();
		$this->TglST->setVisibility();
		$this->PejabatTTD->setVisibility();
		$this->NIDNTTD->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->Kode_Fak);
		$this->setupLookupOptions($this->Status_Akd);
		$this->setupLookupOptions($this->NIDNTTD);

		// Check permission
		if (!$Security->canEdit()) {
			$this->setFailureMessage(DeniedMessage()); // No permission
			$this->terminate("mbkm_jadwallist.php");
			return;
		}

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-edit-form ew-horizontal";
		$loaded = FALSE;
		$postBack = FALSE;

		// Set up current action and primary key
		if (IsApi()) {

			// Load key values
			$loaded = TRUE;
			if (Get("Kode_Fak") !== NULL) {
				$this->Kode_Fak->setQueryStringValue(Get("Kode_Fak"));
				$this->Kode_Fak->setOldValue($this->Kode_Fak->QueryStringValue);
			} elseif (Key(0) !== NULL) {
				$this->Kode_Fak->setQueryStringValue(Key(0));
				$this->Kode_Fak->setOldValue($this->Kode_Fak->QueryStringValue);
			} elseif (Post("Kode_Fak") !== NULL) {
				$this->Kode_Fak->setFormValue(Post("Kode_Fak"));
				$this->Kode_Fak->setOldValue($this->Kode_Fak->FormValue);
			} elseif (Route(2) !== NULL) {
				$this->Kode_Fak->setQueryStringValue(Route(2));
				$this->Kode_Fak->setOldValue($this->Kode_Fak->QueryStringValue);
			} else {
				$loaded = FALSE; // Unable to load key
			}
			if (Get("Tahun_Akd") !== NULL) {
				$this->Tahun_Akd->setQueryStringValue(Get("Tahun_Akd"));
				$this->Tahun_Akd->setOldValue($this->Tahun_Akd->QueryStringValue);
			} elseif (Key(1) !== NULL) {
				$this->Tahun_Akd->setQueryStringValue(Key(1));
				$this->Tahun_Akd->setOldValue($this->Tahun_Akd->QueryStringValue);
			} elseif (Post("Tahun_Akd") !== NULL) {
				$this->Tahun_Akd->setFormValue(Post("Tahun_Akd"));
				$this->Tahun_Akd->setOldValue($this->Tahun_Akd->FormValue);
			} elseif (Route(3) !== NULL) {
				$this->Tahun_Akd->setQueryStringValue(Route(3));
				$this->Tahun_Akd->setOldValue($this->Tahun_Akd->QueryStringValue);
			} else {
				$loaded = FALSE; // Unable to load key
			}
			if (Get("Periode") !== NULL) {
				$this->Periode->setQueryStringValue(Get("Periode"));
				$this->Periode->setOldValue($this->Periode->QueryStringValue);
			} elseif (Key(2) !== NULL) {
				$this->Periode->setQueryStringValue(Key(2));
				$this->Periode->setOldValue($this->Periode->QueryStringValue);
			} elseif (Post("Periode") !== NULL) {
				$this->Periode->setFormValue(Post("Periode"));
				$this->Periode->setOldValue($this->Periode->FormValue);
			} elseif (Route(4) !== NULL) {
				$this->Periode->setQueryStringValue(Route(4));
				$this->Periode->setOldValue($this->Periode->QueryStringValue);
			} else {
				$loaded = FALSE; // Unable to load key
			}
			if (Get("Status_Akd") !== NULL) {
				$this->Status_Akd->setQueryStringValue(Get("Status_Akd"));
				$this->Status_Akd->setOldValue($this->Status_Akd->QueryStringValue);
			} elseif (Key(3) !== NULL) {
				$this->Status_Akd->setQueryStringValue(Key(3));
				$this->Status_Akd->setOldValue($this->Status_Akd->QueryStringValue);
			} elseif (Post("Status_Akd") !== NULL) {
				$this->Status_Akd->setFormValue(Post("Status_Akd"));
				$this->Status_Akd->setOldValue($this->Status_Akd->FormValue);
			} elseif (Route(5) !== NULL) {
				$this->Status_Akd->setQueryStringValue(Route(5));
				$this->Status_Akd->setOldValue($this->Status_Akd->QueryStringValue);
			} else {
				$loaded = FALSE; // Unable to load key
			}

			// Load record
			if ($loaded)
				$loaded = $this->loadRow();
			if (!$loaded) {
				$this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
				$this->terminate();
				return;
			}
			$this->CurrentAction = "update"; // Update record directly
			$postBack = TRUE;
		} else {
			if (Post("action") !== NULL) {
				$this->CurrentAction = Post("action"); // Get action code
				if (!$this->isShow()) // Not reload record, handle as postback
					$postBack = TRUE;

				// Load key from Form
				if ($CurrentForm->hasValue("x_Kode_Fak")) {
					$this->Kode_Fak->setFormValue($CurrentForm->getValue("x_Kode_Fak"));
				}
				if ($CurrentForm->hasValue("x_Tahun_Akd")) {
					$this->Tahun_Akd->setFormValue($CurrentForm->getValue("x_Tahun_Akd"));
				}
				if ($CurrentForm->hasValue("x_Periode")) {
					$this->Periode->setFormValue($CurrentForm->getValue("x_Periode"));
				}
				if ($CurrentForm->hasValue("x_Status_Akd")) {
					$this->Status_Akd->setFormValue($CurrentForm->getValue("x_Status_Akd"));
				}
			} else {
				$this->CurrentAction = "show"; // Default action is display

				// Load key from QueryString / Route
				$loadByQuery = FALSE;
				if (Get("Kode_Fak") !== NULL) {
					$this->Kode_Fak->setQueryStringValue(Get("Kode_Fak"));
					$loadByQuery = TRUE;
				} elseif (Route(2) !== NULL) {
					$this->Kode_Fak->setQueryStringValue(Route(2));
					$loadByQuery = TRUE;
				} else {
					$this->Kode_Fak->CurrentValue = NULL;
				}
				if (Get("Tahun_Akd") !== NULL) {
					$this->Tahun_Akd->setQueryStringValue(Get("Tahun_Akd"));
					$loadByQuery = TRUE;
				} elseif (Route(3) !== NULL) {
					$this->Tahun_Akd->setQueryStringValue(Route(3));
					$loadByQuery = TRUE;
				} else {
					$this->Tahun_Akd->CurrentValue = NULL;
				}
				if (Get("Periode") !== NULL) {
					$this->Periode->setQueryStringValue(Get("Periode"));
					$loadByQuery = TRUE;
				} elseif (Route(4) !== NULL) {
					$this->Periode->setQueryStringValue(Route(4));
					$loadByQuery = TRUE;
				} else {
					$this->Periode->CurrentValue = NULL;
				}
				if (Get("Status_Akd") !== NULL) {
					$this->Status_Akd->setQueryStringValue(Get("Status_Akd"));
					$loadByQuery = TRUE;
				} elseif (Route(5) !== NULL) {
					$this->Status_Akd->setQueryStringValue(Route(5));
					$loadByQuery = TRUE;
				} else {
					$this->Status_Akd->CurrentValue = NULL;
				}
			}

			// Load current record
			$loaded = $this->loadRow();
		}

		// Process form if post back
		if ($postBack) {
			$this->loadFormValues(); // Get form values

			// Set up detail parameters
			$this->setupDetailParms();
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->validateForm()) {
				$this->setFailureMessage($FormError);
				$this->EventCancelled = TRUE; // Event cancelled
				$this->restoreFormValues();
				if (IsApi()) {
					$this->terminate();
					return;
				} else {
					$this->CurrentAction = ""; // Form error, reset action
				}
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "show": // Get a record to display
				if (!$loaded) { // Load record based on key
					if ($this->getFailureMessage() == "")
						$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
					$this->terminate("mbkm_jadwallist.php"); // No matching record, return to list
				}

				// Set up detail parameters
				$this->setupDetailParms();
				break;
			case "update": // Update
				if ($this->getCurrentDetailTable() != "") // Master/detail edit
					$returnUrl = $this->getViewUrl(Config("TABLE_SHOW_DETAIL") . "=" . $this->getCurrentDetailTable()); // Master/Detail view page
				else
					$returnUrl = $this->getReturnUrl();
				if (GetPageName($returnUrl) == "mbkm_jadwallist.php")
					$returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
				$this->SendEmail = TRUE; // Send email on update success
				if ($this->editRow()) { // Update record based on key
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Update success
					if (IsApi()) {
						$this->terminate(TRUE);
						return;
					} else {
						$this->terminate($returnUrl); // Return to caller
					}
				} elseif (IsApi()) { // API request, return
					$this->terminate();
					return;
				} elseif ($this->getFailureMessage() == $Language->phrase("NoRecord")) {
					$this->terminate($returnUrl); // Return to caller
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->restoreFormValues(); // Restore form values if update failed

					// Set up detail parameters
					$this->setupDetailParms();
				}
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Render the record
		$this->RowType = ROWTYPE_EDIT; // Render as Edit
		$this->resetAttributes();
		$this->renderRow();
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;

		// Check field name 'Kode_Fak' first before field var 'x_Kode_Fak'
		$val = $CurrentForm->hasValue("Kode_Fak") ? $CurrentForm->getValue("Kode_Fak") : $CurrentForm->getValue("x_Kode_Fak");
		if (!$this->Kode_Fak->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->Kode_Fak->Visible = FALSE; // Disable update for API request
			else
				$this->Kode_Fak->setFormValue($val);
		}
		if ($CurrentForm->hasValue("o_Kode_Fak"))
			$this->Kode_Fak->setOldValue($CurrentForm->getValue("o_Kode_Fak"));

		// Check field name 'Tahun_Akd' first before field var 'x_Tahun_Akd'
		$val = $CurrentForm->hasValue("Tahun_Akd") ? $CurrentForm->getValue("Tahun_Akd") : $CurrentForm->getValue("x_Tahun_Akd");
		if (!$this->Tahun_Akd->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->Tahun_Akd->Visible = FALSE; // Disable update for API request
			else
				$this->Tahun_Akd->setFormValue($val);
		}
		if ($CurrentForm->hasValue("o_Tahun_Akd"))
			$this->Tahun_Akd->setOldValue($CurrentForm->getValue("o_Tahun_Akd"));

		// Check field name 'Periode' first before field var 'x_Periode'
		$val = $CurrentForm->hasValue("Periode") ? $CurrentForm->getValue("Periode") : $CurrentForm->getValue("x_Periode");
		if (!$this->Periode->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->Periode->Visible = FALSE; // Disable update for API request
			else
				$this->Periode->setFormValue($val);
		}
		if ($CurrentForm->hasValue("o_Periode"))
			$this->Periode->setOldValue($CurrentForm->getValue("o_Periode"));

		// Check field name 'Status_Akd' first before field var 'x_Status_Akd'
		$val = $CurrentForm->hasValue("Status_Akd") ? $CurrentForm->getValue("Status_Akd") : $CurrentForm->getValue("x_Status_Akd");
		if (!$this->Status_Akd->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->Status_Akd->Visible = FALSE; // Disable update for API request
			else
				$this->Status_Akd->setFormValue($val);
		}
		if ($CurrentForm->hasValue("o_Status_Akd"))
			$this->Status_Akd->setOldValue($CurrentForm->getValue("o_Status_Akd"));

		// Check field name 'TM' first before field var 'x_TM'
		$val = $CurrentForm->hasValue("TM") ? $CurrentForm->getValue("TM") : $CurrentForm->getValue("x_TM");
		if (!$this->TM->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->TM->Visible = FALSE; // Disable update for API request
			else
				$this->TM->setFormValue($val);
			$this->TM->CurrentValue = UnFormatDateTime($this->TM->CurrentValue, 7);
		}

		// Check field name 'TS' first before field var 'x_TS'
		$val = $CurrentForm->hasValue("TS") ? $CurrentForm->getValue("TS") : $CurrentForm->getValue("x_TS");
		if (!$this->TS->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->TS->Visible = FALSE; // Disable update for API request
			else
				$this->TS->setFormValue($val);
			$this->TS->CurrentValue = UnFormatDateTime($this->TS->CurrentValue, 7);
		}

		// Check field name 'NoSKPenugasan' first before field var 'x_NoSKPenugasan'
		$val = $CurrentForm->hasValue("NoSKPenugasan") ? $CurrentForm->getValue("NoSKPenugasan") : $CurrentForm->getValue("x_NoSKPenugasan");
		if (!$this->NoSKPenugasan->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->NoSKPenugasan->Visible = FALSE; // Disable update for API request
			else
				$this->NoSKPenugasan->setFormValue($val);
		}

		// Check field name 'TglST' first before field var 'x_TglST'
		$val = $CurrentForm->hasValue("TglST") ? $CurrentForm->getValue("TglST") : $CurrentForm->getValue("x_TglST");
		if (!$this->TglST->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->TglST->Visible = FALSE; // Disable update for API request
			else
				$this->TglST->setFormValue($val);
			$this->TglST->CurrentValue = UnFormatDateTime($this->TglST->CurrentValue, 0);
		}

		// Check field name 'PejabatTTD' first before field var 'x_PejabatTTD'
		$val = $CurrentForm->hasValue("PejabatTTD") ? $CurrentForm->getValue("PejabatTTD") : $CurrentForm->getValue("x_PejabatTTD");
		if (!$this->PejabatTTD->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->PejabatTTD->Visible = FALSE; // Disable update for API request
			else
				$this->PejabatTTD->setFormValue($val);
		}

		// Check field name 'NIDNTTD' first before field var 'x_NIDNTTD'
		$val = $CurrentForm->hasValue("NIDNTTD") ? $CurrentForm->getValue("NIDNTTD") : $CurrentForm->getValue("x_NIDNTTD");
		if (!$this->NIDNTTD->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->NIDNTTD->Visible = FALSE; // Disable update for API request
			else
				$this->NIDNTTD->setFormValue($val);
		}
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->Kode_Fak->CurrentValue = $this->Kode_Fak->FormValue;
		$this->Tahun_Akd->CurrentValue = $this->Tahun_Akd->FormValue;
		$this->Periode->CurrentValue = $this->Periode->FormValue;
		$this->Status_Akd->CurrentValue = $this->Status_Akd->FormValue;
		$this->TM->CurrentValue = $this->TM->FormValue;
		$this->TM->CurrentValue = UnFormatDateTime($this->TM->CurrentValue, 7);
		$this->TS->CurrentValue = $this->TS->FormValue;
		$this->TS->CurrentValue = UnFormatDateTime($this->TS->CurrentValue, 7);
		$this->NoSKPenugasan->CurrentValue = $this->NoSKPenugasan->FormValue;
		$this->TglST->CurrentValue = $this->TglST->FormValue;
		$this->TglST->CurrentValue = UnFormatDateTime($this->TglST->CurrentValue, 0);
		$this->PejabatTTD->CurrentValue = $this->PejabatTTD->FormValue;
		$this->NIDNTTD->CurrentValue = $this->NIDNTTD->FormValue;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = $this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->Kode_Fak->setDbValue($row['Kode_Fak']);
		$this->Tahun_Akd->setDbValue($row['Tahun_Akd']);
		$this->Periode->setDbValue($row['Periode']);
		$this->Status_Akd->setDbValue($row['Status_Akd']);
		$this->TM->setDbValue($row['TM']);
		$this->TS->setDbValue($row['TS']);
		$this->NoSKPenugasan->setDbValue($row['NoSKPenugasan']);
		$this->TglST->setDbValue($row['TglST']);
		$this->PejabatTTD->setDbValue($row['PejabatTTD']);
		$this->NIDNTTD->setDbValue($row['NIDNTTD']);
		if (array_key_exists('EV__NIDNTTD', $rs->fields)) {
			$this->NIDNTTD->VirtualValue = $rs->fields('EV__NIDNTTD'); // Set up virtual field value
		} else {
			$this->NIDNTTD->VirtualValue = ""; // Clear value
		}
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['Kode_Fak'] = NULL;
		$row['Tahun_Akd'] = NULL;
		$row['Periode'] = NULL;
		$row['Status_Akd'] = NULL;
		$row['TM'] = NULL;
		$row['TS'] = NULL;
		$row['NoSKPenugasan'] = NULL;
		$row['TglST'] = NULL;
		$row['PejabatTTD'] = NULL;
		$row['NIDNTTD'] = NULL;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("Kode_Fak")) != "")
			$this->Kode_Fak->OldValue = $this->getKey("Kode_Fak"); // Kode_Fak
		else
			$validKey = FALSE;
		if (strval($this->getKey("Tahun_Akd")) != "")
			$this->Tahun_Akd->OldValue = $this->getKey("Tahun_Akd"); // Tahun_Akd
		else
			$validKey = FALSE;
		if (strval($this->getKey("Periode")) != "")
			$this->Periode->OldValue = $this->getKey("Periode"); // Periode
		else
			$validKey = FALSE;
		if (strval($this->getKey("Status_Akd")) != "")
			$this->Status_Akd->OldValue = $this->getKey("Status_Akd"); // Status_Akd
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = $this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Call Row_Rendering event

		$this->Row_Rendering();

		// Common render codes for all row types
		// Kode_Fak
		// Tahun_Akd
		// Periode
		// Status_Akd
		// TM
		// TS
		// NoSKPenugasan
		// TglST
		// PejabatTTD
		// NIDNTTD

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// Kode_Fak
			$curVal = strval($this->Kode_Fak->CurrentValue);
			if ($curVal != "") {
				$this->Kode_Fak->ViewValue = $this->Kode_Fak->lookupCacheOption($curVal);
				if ($this->Kode_Fak->ViewValue === NULL) { // Lookup from database
					$filterWrk = "[Kode_Fak]" . SearchString("=", $curVal, DATATYPE_STRING, "");
					$sqlWrk = $this->Kode_Fak->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = [];
						$arwrk[1] = $rswrk->fields('df');
						$this->Kode_Fak->ViewValue = $this->Kode_Fak->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->Kode_Fak->ViewValue = $this->Kode_Fak->CurrentValue;
					}
				}
			} else {
				$this->Kode_Fak->ViewValue = NULL;
			}
			$this->Kode_Fak->ViewCustomAttributes = "";

			// Tahun_Akd
			$this->Tahun_Akd->ViewValue = $this->Tahun_Akd->CurrentValue;
			$this->Tahun_Akd->ViewCustomAttributes = "";

			// Periode
			if (strval($this->Periode->CurrentValue) != "") {
				$this->Periode->ViewValue = $this->Periode->optionCaption($this->Periode->CurrentValue);
			} else {
				$this->Periode->ViewValue = NULL;
			}
			$this->Periode->ViewCustomAttributes = "";

			// Status_Akd
			$curVal = strval($this->Status_Akd->CurrentValue);
			if ($curVal != "") {
				$this->Status_Akd->ViewValue = $this->Status_Akd->lookupCacheOption($curVal);
				if ($this->Status_Akd->ViewValue === NULL) { // Lookup from database
					$filterWrk = "[Kelas]" . SearchString("=", $curVal, DATATYPE_STRING, "");
					$sqlWrk = $this->Status_Akd->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = [];
						$arwrk[1] = $rswrk->fields('df');
						$this->Status_Akd->ViewValue = $this->Status_Akd->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->Status_Akd->ViewValue = $this->Status_Akd->CurrentValue;
					}
				}
			} else {
				$this->Status_Akd->ViewValue = NULL;
			}
			$this->Status_Akd->ViewCustomAttributes = "";

			// TM
			$this->TM->ViewValue = $this->TM->CurrentValue;
			$this->TM->ViewValue = FormatDateTime($this->TM->ViewValue, 7);
			$this->TM->ViewCustomAttributes = "";

			// TS
			$this->TS->ViewValue = $this->TS->CurrentValue;
			$this->TS->ViewValue = FormatDateTime($this->TS->ViewValue, 7);
			$this->TS->ViewCustomAttributes = "";

			// NoSKPenugasan
			$this->NoSKPenugasan->ViewValue = $this->NoSKPenugasan->CurrentValue;
			$this->NoSKPenugasan->ViewCustomAttributes = "";

			// TglST
			$this->TglST->ViewValue = $this->TglST->CurrentValue;
			$this->TglST->ViewValue = FormatDateTime($this->TglST->ViewValue, 0);
			$this->TglST->ViewCustomAttributes = "";

			// PejabatTTD
			$this->PejabatTTD->ViewValue = $this->PejabatTTD->CurrentValue;
			$this->PejabatTTD->ViewCustomAttributes = "";

			// NIDNTTD
			if ($this->NIDNTTD->VirtualValue != "") {
				$this->NIDNTTD->ViewValue = $this->NIDNTTD->VirtualValue;
			} else {
				$curVal = strval($this->NIDNTTD->CurrentValue);
				if ($curVal != "") {
					$this->NIDNTTD->ViewValue = $this->NIDNTTD->lookupCacheOption($curVal);
					if ($this->NIDNTTD->ViewValue === NULL) { // Lookup from database
						$filterWrk = "[NIDN]" . SearchString("=", $curVal, DATATYPE_STRING, "");
						$sqlWrk = $this->NIDNTTD->Lookup->getSql(FALSE, $filterWrk, '', $this);
						$rswrk = Conn()->execute($sqlWrk);
						if ($rswrk && !$rswrk->EOF) { // Lookup values found
							$arwrk = [];
							$arwrk[1] = $rswrk->fields('df');
							$arwrk[2] = $rswrk->fields('df2');
							$this->NIDNTTD->ViewValue = $this->NIDNTTD->displayValue($arwrk);
							$rswrk->Close();
						} else {
							$this->NIDNTTD->ViewValue = $this->NIDNTTD->CurrentValue;
						}
					}
				} else {
					$this->NIDNTTD->ViewValue = NULL;
				}
			}
			$this->NIDNTTD->ViewCustomAttributes = "";

			// Kode_Fak
			$this->Kode_Fak->LinkCustomAttributes = "";
			$this->Kode_Fak->HrefValue = "";
			$this->Kode_Fak->TooltipValue = "";

			// Tahun_Akd
			$this->Tahun_Akd->LinkCustomAttributes = "";
			$this->Tahun_Akd->HrefValue = "";
			$this->Tahun_Akd->TooltipValue = "";

			// Periode
			$this->Periode->LinkCustomAttributes = "";
			$this->Periode->HrefValue = "";
			$this->Periode->TooltipValue = "";

			// Status_Akd
			$this->Status_Akd->LinkCustomAttributes = "";
			$this->Status_Akd->HrefValue = "";
			$this->Status_Akd->TooltipValue = "";

			// TM
			$this->TM->LinkCustomAttributes = "";
			$this->TM->HrefValue = "";
			$this->TM->TooltipValue = "";

			// TS
			$this->TS->LinkCustomAttributes = "";
			$this->TS->HrefValue = "";
			$this->TS->TooltipValue = "";

			// NoSKPenugasan
			$this->NoSKPenugasan->LinkCustomAttributes = "";
			$this->NoSKPenugasan->HrefValue = "";
			$this->NoSKPenugasan->TooltipValue = "";

			// TglST
			$this->TglST->LinkCustomAttributes = "";
			$this->TglST->HrefValue = "";
			$this->TglST->TooltipValue = "";

			// PejabatTTD
			$this->PejabatTTD->LinkCustomAttributes = "";
			$this->PejabatTTD->HrefValue = "";
			$this->PejabatTTD->TooltipValue = "";

			// NIDNTTD
			$this->NIDNTTD->LinkCustomAttributes = "";
			$this->NIDNTTD->HrefValue = "";
			$this->NIDNTTD->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_EDIT) { // Edit row

			// Kode_Fak
			$this->Kode_Fak->EditAttrs["class"] = "form-control";
			$this->Kode_Fak->EditCustomAttributes = "";
			$curVal = trim(strval($this->Kode_Fak->CurrentValue));
			if ($curVal != "")
				$this->Kode_Fak->ViewValue = $this->Kode_Fak->lookupCacheOption($curVal);
			else
				$this->Kode_Fak->ViewValue = $this->Kode_Fak->Lookup !== NULL && is_array($this->Kode_Fak->Lookup->Options) ? $curVal : NULL;
			if ($this->Kode_Fak->ViewValue !== NULL) { // Load from cache
				$this->Kode_Fak->EditValue = array_values($this->Kode_Fak->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "[Kode_Fak]" . SearchString("=", $this->Kode_Fak->CurrentValue, DATATYPE_STRING, "");
				}
				$sqlWrk = $this->Kode_Fak->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = $rswrk ? $rswrk->getRows() : [];
				if ($rswrk)
					$rswrk->close();
				$this->Kode_Fak->EditValue = $arwrk;
			}

			// Tahun_Akd
			$this->Tahun_Akd->EditAttrs["class"] = "form-control";
			$this->Tahun_Akd->EditCustomAttributes = "";
			if (!$this->Tahun_Akd->Raw)
				$this->Tahun_Akd->CurrentValue = HtmlDecode($this->Tahun_Akd->CurrentValue);
			$this->Tahun_Akd->EditValue = HtmlEncode($this->Tahun_Akd->CurrentValue);
			$this->Tahun_Akd->PlaceHolder = RemoveHtml($this->Tahun_Akd->caption());

			// Periode
			$this->Periode->EditAttrs["class"] = "form-control";
			$this->Periode->EditCustomAttributes = "";
			$this->Periode->EditValue = $this->Periode->options(TRUE);

			// Status_Akd
			$this->Status_Akd->EditAttrs["class"] = "form-control";
			$this->Status_Akd->EditCustomAttributes = "";
			$curVal = trim(strval($this->Status_Akd->CurrentValue));
			if ($curVal != "")
				$this->Status_Akd->ViewValue = $this->Status_Akd->lookupCacheOption($curVal);
			else
				$this->Status_Akd->ViewValue = $this->Status_Akd->Lookup !== NULL && is_array($this->Status_Akd->Lookup->Options) ? $curVal : NULL;
			if ($this->Status_Akd->ViewValue !== NULL) { // Load from cache
				$this->Status_Akd->EditValue = array_values($this->Status_Akd->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "[Kelas]" . SearchString("=", $this->Status_Akd->CurrentValue, DATATYPE_STRING, "");
				}
				$sqlWrk = $this->Status_Akd->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = $rswrk ? $rswrk->getRows() : [];
				if ($rswrk)
					$rswrk->close();
				$this->Status_Akd->EditValue = $arwrk;
			}

			// TM
			$this->TM->EditAttrs["class"] = "form-control";
			$this->TM->EditCustomAttributes = "";
			$this->TM->EditValue = HtmlEncode(FormatDateTime($this->TM->CurrentValue, 7));
			$this->TM->PlaceHolder = RemoveHtml($this->TM->caption());

			// TS
			$this->TS->EditAttrs["class"] = "form-control";
			$this->TS->EditCustomAttributes = "";
			$this->TS->EditValue = HtmlEncode(FormatDateTime($this->TS->CurrentValue, 7));
			$this->TS->PlaceHolder = RemoveHtml($this->TS->caption());

			// NoSKPenugasan
			$this->NoSKPenugasan->EditAttrs["class"] = "form-control";
			$this->NoSKPenugasan->EditCustomAttributes = "";
			if (!$this->NoSKPenugasan->Raw)
				$this->NoSKPenugasan->CurrentValue = HtmlDecode($this->NoSKPenugasan->CurrentValue);
			$this->NoSKPenugasan->EditValue = HtmlEncode($this->NoSKPenugasan->CurrentValue);
			$this->NoSKPenugasan->PlaceHolder = RemoveHtml($this->NoSKPenugasan->caption());

			// TglST
			$this->TglST->EditAttrs["class"] = "form-control";
			$this->TglST->EditCustomAttributes = "";
			$this->TglST->EditValue = HtmlEncode(FormatDateTime($this->TglST->CurrentValue, 8));
			$this->TglST->PlaceHolder = RemoveHtml($this->TglST->caption());

			// PejabatTTD
			$this->PejabatTTD->EditAttrs["class"] = "form-control";
			$this->PejabatTTD->EditCustomAttributes = "";
			if (!$this->PejabatTTD->Raw)
				$this->PejabatTTD->CurrentValue = HtmlDecode($this->PejabatTTD->CurrentValue);
			$this->PejabatTTD->EditValue = HtmlEncode($this->PejabatTTD->CurrentValue);
			$this->PejabatTTD->PlaceHolder = RemoveHtml($this->PejabatTTD->caption());

			// NIDNTTD
			$this->NIDNTTD->EditCustomAttributes = "";
			$curVal = trim(strval($this->NIDNTTD->CurrentValue));
			if ($curVal != "")
				$this->NIDNTTD->ViewValue = $this->NIDNTTD->lookupCacheOption($curVal);
			else
				$this->NIDNTTD->ViewValue = $this->NIDNTTD->Lookup !== NULL && is_array($this->NIDNTTD->Lookup->Options) ? $curVal : NULL;
			if ($this->NIDNTTD->ViewValue !== NULL) { // Load from cache
				$this->NIDNTTD->EditValue = array_values($this->NIDNTTD->Lookup->Options);
				if ($this->NIDNTTD->ViewValue == "")
					$this->NIDNTTD->ViewValue = $Language->phrase("PleaseSelect");
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "[NIDN]" . SearchString("=", $this->NIDNTTD->CurrentValue, DATATYPE_STRING, "");
				}
				$sqlWrk = $this->NIDNTTD->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = [];
					$arwrk[1] = HtmlEncode($rswrk->fields('df'));
					$arwrk[2] = HtmlEncode($rswrk->fields('df2'));
					$this->NIDNTTD->ViewValue = $this->NIDNTTD->displayValue($arwrk);
				} else {
					$this->NIDNTTD->ViewValue = $Language->phrase("PleaseSelect");
				}
				$arwrk = $rswrk ? $rswrk->getRows() : [];
				if ($rswrk)
					$rswrk->close();
				$this->NIDNTTD->EditValue = $arwrk;
			}

			// Edit refer script
			// Kode_Fak

			$this->Kode_Fak->LinkCustomAttributes = "";
			$this->Kode_Fak->HrefValue = "";

			// Tahun_Akd
			$this->Tahun_Akd->LinkCustomAttributes = "";
			$this->Tahun_Akd->HrefValue = "";

			// Periode
			$this->Periode->LinkCustomAttributes = "";
			$this->Periode->HrefValue = "";

			// Status_Akd
			$this->Status_Akd->LinkCustomAttributes = "";
			$this->Status_Akd->HrefValue = "";

			// TM
			$this->TM->LinkCustomAttributes = "";
			$this->TM->HrefValue = "";

			// TS
			$this->TS->LinkCustomAttributes = "";
			$this->TS->HrefValue = "";

			// NoSKPenugasan
			$this->NoSKPenugasan->LinkCustomAttributes = "";
			$this->NoSKPenugasan->HrefValue = "";

			// TglST
			$this->TglST->LinkCustomAttributes = "";
			$this->TglST->HrefValue = "";

			// PejabatTTD
			$this->PejabatTTD->LinkCustomAttributes = "";
			$this->PejabatTTD->HrefValue = "";

			// NIDNTTD
			$this->NIDNTTD->LinkCustomAttributes = "";
			$this->NIDNTTD->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType != ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!Config("SERVER_VALIDATE"))
			return ($FormError == "");
		if ($this->Kode_Fak->Required) {
			if (!$this->Kode_Fak->IsDetailKey && $this->Kode_Fak->FormValue != NULL && $this->Kode_Fak->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Kode_Fak->caption(), $this->Kode_Fak->RequiredErrorMessage));
			}
		}
		if ($this->Tahun_Akd->Required) {
			if (!$this->Tahun_Akd->IsDetailKey && $this->Tahun_Akd->FormValue != NULL && $this->Tahun_Akd->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Tahun_Akd->caption(), $this->Tahun_Akd->RequiredErrorMessage));
			}
		}
		if ($this->Periode->Required) {
			if (!$this->Periode->IsDetailKey && $this->Periode->FormValue != NULL && $this->Periode->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Periode->caption(), $this->Periode->RequiredErrorMessage));
			}
		}
		if ($this->Status_Akd->Required) {
			if (!$this->Status_Akd->IsDetailKey && $this->Status_Akd->FormValue != NULL && $this->Status_Akd->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Status_Akd->caption(), $this->Status_Akd->RequiredErrorMessage));
			}
		}
		if ($this->TM->Required) {
			if (!$this->TM->IsDetailKey && $this->TM->FormValue != NULL && $this->TM->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->TM->caption(), $this->TM->RequiredErrorMessage));
			}
		}
		if (!CheckEuroDate($this->TM->FormValue)) {
			AddMessage($FormError, $this->TM->errorMessage());
		}
		if ($this->TS->Required) {
			if (!$this->TS->IsDetailKey && $this->TS->FormValue != NULL && $this->TS->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->TS->caption(), $this->TS->RequiredErrorMessage));
			}
		}
		if (!CheckEuroDate($this->TS->FormValue)) {
			AddMessage($FormError, $this->TS->errorMessage());
		}
		if ($this->NoSKPenugasan->Required) {
			if (!$this->NoSKPenugasan->IsDetailKey && $this->NoSKPenugasan->FormValue != NULL && $this->NoSKPenugasan->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->NoSKPenugasan->caption(), $this->NoSKPenugasan->RequiredErrorMessage));
			}
		}
		if ($this->TglST->Required) {
			if (!$this->TglST->IsDetailKey && $this->TglST->FormValue != NULL && $this->TglST->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->TglST->caption(), $this->TglST->RequiredErrorMessage));
			}
		}
		if (!CheckDate($this->TglST->FormValue)) {
			AddMessage($FormError, $this->TglST->errorMessage());
		}
		if ($this->PejabatTTD->Required) {
			if (!$this->PejabatTTD->IsDetailKey && $this->PejabatTTD->FormValue != NULL && $this->PejabatTTD->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->PejabatTTD->caption(), $this->PejabatTTD->RequiredErrorMessage));
			}
		}
		if ($this->NIDNTTD->Required) {
			if (!$this->NIDNTTD->IsDetailKey && $this->NIDNTTD->FormValue != NULL && $this->NIDNTTD->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->NIDNTTD->caption(), $this->NIDNTTD->RequiredErrorMessage));
			}
		}

		// Validate detail grid
		$detailTblVar = explode(",", $this->getCurrentDetailTable());
		if (in_array("mbkm_siswa", $detailTblVar) && $GLOBALS["mbkm_siswa"]->DetailEdit) {
			if (!isset($GLOBALS["mbkm_siswa_grid"]))
				$GLOBALS["mbkm_siswa_grid"] = new mbkm_siswa_grid(); // Get detail page object
			$GLOBALS["mbkm_siswa_grid"]->validateGridForm();
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError != "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Update record based on key values
	protected function editRow()
	{
		global $Security, $Language;
		$oldKeyFilter = $this->getRecordFilter();
		$filter = $this->applyUserIDFilters($oldKeyFilter);
		$conn = $this->getConnection();
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn->raiseErrorFn = Config("ERROR_FUNC");
		$rs = $conn->execute($sql);
		$conn->raiseErrorFn = "";
		if ($rs === FALSE)
			return FALSE;
		if ($rs->EOF) {
			$this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
			$editRow = FALSE; // Update Failed
		} else {

			// Begin transaction
			if ($this->getCurrentDetailTable() != "")
				$conn->beginTrans();

			// Save old values
			$rsold = &$rs->fields;
			$this->loadDbValues($rsold);
			$rsnew = [];

			// Kode_Fak
			$this->Kode_Fak->setDbValueDef($rsnew, $this->Kode_Fak->CurrentValue, "", $this->Kode_Fak->ReadOnly);

			// Tahun_Akd
			$this->Tahun_Akd->setDbValueDef($rsnew, $this->Tahun_Akd->CurrentValue, "", $this->Tahun_Akd->ReadOnly);

			// Periode
			$this->Periode->setDbValueDef($rsnew, $this->Periode->CurrentValue, "", $this->Periode->ReadOnly);

			// Status_Akd
			$this->Status_Akd->setDbValueDef($rsnew, $this->Status_Akd->CurrentValue, "", $this->Status_Akd->ReadOnly);

			// TM
			$this->TM->setDbValueDef($rsnew, UnFormatDateTime($this->TM->CurrentValue, 7), NULL, $this->TM->ReadOnly);

			// TS
			$this->TS->setDbValueDef($rsnew, UnFormatDateTime($this->TS->CurrentValue, 7), NULL, $this->TS->ReadOnly);

			// NoSKPenugasan
			$this->NoSKPenugasan->setDbValueDef($rsnew, $this->NoSKPenugasan->CurrentValue, NULL, $this->NoSKPenugasan->ReadOnly);

			// TglST
			$this->TglST->setDbValueDef($rsnew, UnFormatDateTime($this->TglST->CurrentValue, 0), NULL, $this->TglST->ReadOnly);

			// PejabatTTD
			$this->PejabatTTD->setDbValueDef($rsnew, $this->PejabatTTD->CurrentValue, NULL, $this->PejabatTTD->ReadOnly);

			// NIDNTTD
			$this->NIDNTTD->setDbValueDef($rsnew, $this->NIDNTTD->CurrentValue, NULL, $this->NIDNTTD->ReadOnly);

			// Call Row Updating event
			$updateRow = $this->Row_Updating($rsold, $rsnew);

			// Check for duplicate key when key changed
			if ($updateRow) {
				$newKeyFilter = $this->getRecordFilter($rsnew);
				if ($newKeyFilter != $oldKeyFilter) {
					$rsChk = $this->loadRs($newKeyFilter);
					if ($rsChk && !$rsChk->EOF) {
						$keyErrMsg = str_replace("%f", $newKeyFilter, $Language->phrase("DupKey"));
						$this->setFailureMessage($keyErrMsg);
						$rsChk->close();
						$updateRow = FALSE;
					}
				}
			}
			if ($updateRow) {
				$conn->raiseErrorFn = Config("ERROR_FUNC");
				if (count($rsnew) > 0)
					$editRow = $this->update($rsnew, "", $rsold);
				else
					$editRow = TRUE; // No field to update
				$conn->raiseErrorFn = "";
				if ($editRow) {
				}

				// Update detail records
				$detailTblVar = explode(",", $this->getCurrentDetailTable());
				if ($editRow) {
					if (in_array("mbkm_siswa", $detailTblVar) && $GLOBALS["mbkm_siswa"]->DetailEdit) {
						if (!isset($GLOBALS["mbkm_siswa_grid"]))
							$GLOBALS["mbkm_siswa_grid"] = new mbkm_siswa_grid(); // Get detail page object
						$Security->loadCurrentUserLevel($this->ProjectID . "mbkm_siswa"); // Load user level of detail table
						$editRow = $GLOBALS["mbkm_siswa_grid"]->gridUpdate();
						$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName); // Restore user level of master table
					}
				}

				// Commit/Rollback transaction
				if ($this->getCurrentDetailTable() != "") {
					if ($editRow) {
						$conn->commitTrans(); // Commit transaction
					} else {
						$conn->rollbackTrans(); // Rollback transaction
					}
				}
			} else {
				if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {

					// Use the message, do nothing
				} elseif ($this->CancelMessage != "") {
					$this->setFailureMessage($this->CancelMessage);
					$this->CancelMessage = "";
				} else {
					$this->setFailureMessage($Language->phrase("UpdateCancelled"));
				}
				$editRow = FALSE;
			}
		}

		// Call Row_Updated event
		if ($editRow)
			$this->Row_Updated($rsold, $rsnew);
		$rs->close();

		// Clean upload path if any
		if ($editRow) {
		}

		// Write JSON for API request
		if (IsApi() && $editRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $editRow;
	}

	// Set up detail parms based on QueryString
	protected function setupDetailParms()
	{

		// Get the keys for master table
		$detailTblVar = Get(Config("TABLE_SHOW_DETAIL"));
		if ($detailTblVar !== NULL) {
			$this->setCurrentDetailTable($detailTblVar);
		} else {
			$detailTblVar = $this->getCurrentDetailTable();
		}
		if ($detailTblVar != "") {
			$detailTblVar = explode(",", $detailTblVar);
			if (in_array("mbkm_siswa", $detailTblVar)) {
				if (!isset($GLOBALS["mbkm_siswa_grid"]))
					$GLOBALS["mbkm_siswa_grid"] = new mbkm_siswa_grid();
				if ($GLOBALS["mbkm_siswa_grid"]->DetailEdit) {
					$GLOBALS["mbkm_siswa_grid"]->CurrentMode = "edit";
					$GLOBALS["mbkm_siswa_grid"]->CurrentAction = "gridedit";

					// Save current master table to detail table
					$GLOBALS["mbkm_siswa_grid"]->setCurrentMasterTable($this->TableVar);
					$GLOBALS["mbkm_siswa_grid"]->setStartRecordNumber(1);
					$GLOBALS["mbkm_siswa_grid"]->Kode_Fak->IsDetailKey = TRUE;
					$GLOBALS["mbkm_siswa_grid"]->Kode_Fak->CurrentValue = $this->Kode_Fak->CurrentValue;
					$GLOBALS["mbkm_siswa_grid"]->Kode_Fak->setSessionValue($GLOBALS["mbkm_siswa_grid"]->Kode_Fak->CurrentValue);
					$GLOBALS["mbkm_siswa_grid"]->Tahun_Akd->IsDetailKey = TRUE;
					$GLOBALS["mbkm_siswa_grid"]->Tahun_Akd->CurrentValue = $this->Tahun_Akd->CurrentValue;
					$GLOBALS["mbkm_siswa_grid"]->Tahun_Akd->setSessionValue($GLOBALS["mbkm_siswa_grid"]->Tahun_Akd->CurrentValue);
					$GLOBALS["mbkm_siswa_grid"]->Periode->IsDetailKey = TRUE;
					$GLOBALS["mbkm_siswa_grid"]->Periode->CurrentValue = $this->Periode->CurrentValue;
					$GLOBALS["mbkm_siswa_grid"]->Periode->setSessionValue($GLOBALS["mbkm_siswa_grid"]->Periode->CurrentValue);
					$GLOBALS["mbkm_siswa_grid"]->Status_Akd->IsDetailKey = TRUE;
					$GLOBALS["mbkm_siswa_grid"]->Status_Akd->CurrentValue = $this->Status_Akd->CurrentValue;
					$GLOBALS["mbkm_siswa_grid"]->Status_Akd->setSessionValue($GLOBALS["mbkm_siswa_grid"]->Status_Akd->CurrentValue);
				}
			}
		}
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("mbkm_jadwallist.php"), "", $this->TableVar, TRUE);
		$pageId = "edit";
		$Breadcrumb->add("edit", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// Get default connection and filter
			$conn = $this->getConnection();
			$lookupFilter = "";

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL and connection
			switch ($fld->FieldVar) {
				case "x_Kode_Fak":
					break;
				case "x_Periode":
					break;
				case "x_Status_Akd":
					break;
				case "x_NIDNTTD":
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0) {
				$totalCnt = $this->getRecordCount($sql, $conn);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_Kode_Fak":
							break;
						case "x_Status_Akd":
							break;
						case "x_NIDNTTD":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Set up starting record parameters
	public function setupStartRecord()
	{
		if ($this->DisplayRecords == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			$startRec = Get(Config("TABLE_START_REC"));
			$pageNo = Get(Config("TABLE_PAGE_NO"));
			if ($pageNo !== NULL) { // Check for "pageno" parameter first
				if (is_numeric($pageNo)) {
					$this->StartRecord = ($pageNo - 1) * $this->DisplayRecords + 1;
					if ($this->StartRecord <= 0) {
						$this->StartRecord = 1;
					} elseif ($this->StartRecord >= (int)(($this->TotalRecords - 1)/$this->DisplayRecords) * $this->DisplayRecords + 1) {
						$this->StartRecord = (int)(($this->TotalRecords - 1)/$this->DisplayRecords) * $this->DisplayRecords + 1;
					}
					$this->setStartRecordNumber($this->StartRecord);
				}
			} elseif ($startRec !== NULL) { // Check for "start" parameter
				$this->StartRecord = $startRec;
				$this->setStartRecordNumber($this->StartRecord);
			}
		}
		$this->StartRecord = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRecord) || $this->StartRecord == "") { // Avoid invalid start record counter
			$this->StartRecord = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRecord);
		} elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
			$this->StartRecord = (int)(($this->TotalRecords - 1)/$this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRecord);
		} elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
			$this->StartRecord = (int)(($this->StartRecord - 1)/$this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRecord);
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
} // End class
?>