<?php namespace PHPMaker2020\baak; ?>
<?php

/**
 * Table class for tblBeasiswa_Detail
 */
class tblBeasiswa_Detail extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $Nim;
	public $NoSk;
	public $IDBeasiswa;
	public $Status;
	public $JmlSemester;
	public $BiayaPerSemester;
	public $Keterangan;
	public $TABerhenti;
	public $PerBerhenti;
	public $Alasan;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;
		parent::__construct();

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'tblBeasiswa_Detail';
		$this->TableName = 'tblBeasiswa_Detail';
		$this->TableType = 'TABLE';

		// Update Table
		$this->UpdateTable = "[dbo].[tblBeasiswa_Detail]";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
		$this->BasicSearch = new BasicSearch($this->TableVar);

		// Nim
		$this->Nim = new DbField('tblBeasiswa_Detail', 'tblBeasiswa_Detail', 'x_Nim', 'Nim', '[Nim]', '[Nim]', 200, 14, -1, FALSE, '[EV__Nim]', TRUE, TRUE, TRUE, 'FORMATTED TEXT', 'SELECT');
		$this->Nim->IsPrimaryKey = TRUE; // Primary key field
		$this->Nim->Nullable = FALSE; // NOT NULL field
		$this->Nim->Required = TRUE; // Required field
		$this->Nim->Sortable = TRUE; // Allow sort
		$this->Nim->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->Nim->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
		$this->Nim->Lookup = new Lookup('Nim', 'tblMHS', FALSE, 'Nim', ["Nim","Nama_Mhs","",""], [], [], [], [], [], [], '', '');
		$this->fields['Nim'] = &$this->Nim;

		// NoSk
		$this->NoSk = new DbField('tblBeasiswa_Detail', 'tblBeasiswa_Detail', 'x_NoSk', 'NoSk', '[NoSk]', '[NoSk]', 200, 50, -1, FALSE, '[NoSk]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->NoSk->IsPrimaryKey = TRUE; // Primary key field
		$this->NoSk->IsForeignKey = TRUE; // Foreign key field
		$this->NoSk->Nullable = FALSE; // NOT NULL field
		$this->NoSk->Required = TRUE; // Required field
		$this->NoSk->Sortable = TRUE; // Allow sort
		$this->fields['NoSk'] = &$this->NoSk;

		// IDBeasiswa
		$this->IDBeasiswa = new DbField('tblBeasiswa_Detail', 'tblBeasiswa_Detail', 'x_IDBeasiswa', 'IDBeasiswa', '[IDBeasiswa]', 'CAST([IDBeasiswa] AS NVARCHAR)', 3, 4, -1, FALSE, '[IDBeasiswa]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->IDBeasiswa->Required = TRUE; // Required field
		$this->IDBeasiswa->Sortable = TRUE; // Allow sort
		$this->IDBeasiswa->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->IDBeasiswa->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
		$this->IDBeasiswa->Lookup = new Lookup('IDBeasiswa', 'tblBeasiswa_Jenis', FALSE, 'IDBeasiswa', ["NamaBeasiswa","","",""], [], [], [], [], [], [], '', '');
		$this->IDBeasiswa->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['IDBeasiswa'] = &$this->IDBeasiswa;

		// Status
		$this->Status = new DbField('tblBeasiswa_Detail', 'tblBeasiswa_Detail', 'x_Status', 'Status', '[Status]', 'CAST([Status] AS NVARCHAR)', 3, 4, -1, FALSE, '[Status]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->Status->Sortable = TRUE; // Allow sort
		$this->Status->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->Status->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
		$this->Status->Lookup = new Lookup('Status', 'tblBeasiswa_Detail', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->Status->OptionCount = 2;
		$this->Status->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['Status'] = &$this->Status;

		// JmlSemester
		$this->JmlSemester = new DbField('tblBeasiswa_Detail', 'tblBeasiswa_Detail', 'x_JmlSemester', 'JmlSemester', '[JmlSemester]', 'CAST([JmlSemester] AS NVARCHAR)', 3, 4, -1, FALSE, '[JmlSemester]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->JmlSemester->Sortable = TRUE; // Allow sort
		$this->JmlSemester->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['JmlSemester'] = &$this->JmlSemester;

		// BiayaPerSemester
		$this->BiayaPerSemester = new DbField('tblBeasiswa_Detail', 'tblBeasiswa_Detail', 'x_BiayaPerSemester', 'BiayaPerSemester', '[BiayaPerSemester]', 'CAST([BiayaPerSemester] AS NVARCHAR)', 131, 8, -1, FALSE, '[BiayaPerSemester]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->BiayaPerSemester->Sortable = TRUE; // Allow sort
		$this->BiayaPerSemester->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['BiayaPerSemester'] = &$this->BiayaPerSemester;

		// Keterangan
		$this->Keterangan = new DbField('tblBeasiswa_Detail', 'tblBeasiswa_Detail', 'x_Keterangan', 'Keterangan', '[Keterangan]', '[Keterangan]', 200, 70, -1, FALSE, '[Keterangan]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Keterangan->Sortable = TRUE; // Allow sort
		$this->fields['Keterangan'] = &$this->Keterangan;

		// TABerhenti
		$this->TABerhenti = new DbField('tblBeasiswa_Detail', 'tblBeasiswa_Detail', 'x_TABerhenti', 'TABerhenti', '[TABerhenti]', '[TABerhenti]', 200, 9, -1, FALSE, '[TABerhenti]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->TABerhenti->Sortable = TRUE; // Allow sort
		$this->fields['TABerhenti'] = &$this->TABerhenti;

		// PerBerhenti
		$this->PerBerhenti = new DbField('tblBeasiswa_Detail', 'tblBeasiswa_Detail', 'x_PerBerhenti', 'PerBerhenti', '[PerBerhenti]', '[PerBerhenti]', 200, 2, -1, FALSE, '[PerBerhenti]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->PerBerhenti->Sortable = TRUE; // Allow sort
		$this->fields['PerBerhenti'] = &$this->PerBerhenti;

		// Alasan
		$this->Alasan = new DbField('tblBeasiswa_Detail', 'tblBeasiswa_Detail', 'x_Alasan', 'Alasan', '[Alasan]', '[Alasan]', 200, 100, -1, FALSE, '[Alasan]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Alasan->Sortable = TRUE; // Allow sort
		$this->fields['Alasan'] = &$this->Alasan;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Single column sort
	public function updateSort(&$fld)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
			$sortFieldList = ($fld->VirtualExpression != "") ? $fld->VirtualExpression : $sortField;
			$this->setSessionOrderByList($sortFieldList . " " . $thisSort); // Save to Session
		} else {
			$fld->setSort("");
		}
	}

	// Session ORDER BY for List page
	public function getSessionOrderByList()
	{
		return @$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_ORDER_BY_LIST")];
	}
	public function setSessionOrderByList($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_ORDER_BY_LIST")] = $v;
	}

	// Current master table name
	public function getCurrentMasterTable()
	{
		return @$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_MASTER_TABLE")];
	}
	public function setCurrentMasterTable($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_MASTER_TABLE")] = $v;
	}

	// Session master WHERE clause
	public function getMasterFilter()
	{

		// Master filter
		$masterFilter = "";
		if ($this->getCurrentMasterTable() == "tblBeasiswa_master") {
			if ($this->NoSk->getSessionValue() != "")
				$masterFilter .= "[NoSK]=" . QuotedValue($this->NoSk->getSessionValue(), DATATYPE_STRING, "DB");
			else
				return "";
		}
		return $masterFilter;
	}

	// Session detail WHERE clause
	public function getDetailFilter()
	{

		// Detail filter
		$detailFilter = "";
		if ($this->getCurrentMasterTable() == "tblBeasiswa_master") {
			if ($this->NoSk->getSessionValue() != "")
				$detailFilter .= "[NoSk]=" . QuotedValue($this->NoSk->getSessionValue(), DATATYPE_STRING, "DB");
			else
				return "";
		}
		return $detailFilter;
	}

	// Master filter
	public function sqlMasterFilter_tblBeasiswa_master()
	{
		return "[NoSK]='@NoSK@'";
	}

	// Detail filter
	public function sqlDetailFilter_tblBeasiswa_master()
	{
		return "[NoSk]='@NoSk@'";
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom != "") ? $this->SqlFrom : "[dbo].[tblBeasiswa_Detail]";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect != "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlSelectList() // Select for List page
	{
		$select = "";
		$select = "SELECT * FROM (" .
			"SELECT *, (SELECT TOP 1 CONVERT(NVARCHAR(MAX),[Nim]) + '" . ValueSeparator(1, $this->Nim) . "' + CONVERT(NVARCHAR(MAX),[Nama_Mhs]) FROM [dbo].[tblMHS] [TMP_LOOKUPTABLE] WHERE [TMP_LOOKUPTABLE].[Nim] = [tblBeasiswa_Detail].[Nim]) AS [EV__Nim] FROM [dbo].[tblBeasiswa_Detail]" .
			") [TMP_TABLE]";
		return ($this->SqlSelectList != "") ? $this->SqlSelectList : $select;
	}
	public function sqlSelectList() // For backward compatibility
	{
		return $this->getSqlSelectList();
	}
	public function setSqlSelectList($v)
	{
		$this->SqlSelectList = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy != "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving != "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter, $id = "")
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = $this->UserIDAllowSecurity;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 32) == 32);
			case "search":
				return (($allow & 64) == 64);
			case "lookup":
				return (($allow & 256) == 256);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get recordset
	public function getRecordset($sql, $rowcnt = -1, $offset = -1)
	{
		$conn = $this->getConnection();
		$conn->raiseErrorFn = Config("ERROR_FUNC");
		$rs = $conn->selectLimit($sql, $rowcnt, $offset);
		$conn->raiseErrorFn = "";
		return $rs;
	}

	// Get record count
	public function getRecordCount($sql, $c = NULL)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) &&
			!preg_match('/^\s*select\s+distinct\s+/i', $sql) && !preg_match('/\s+order\s+by\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = $c ?: $this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		if ($this->useVirtualFields()) {
			$select = $this->getSqlSelectList();
			$sort = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
		} else {
			$select = $this->getSqlSelect();
			$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		}
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = ($this->useVirtualFields()) ? $this->getSessionOrderByList() : $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Check if virtual fields is used in SQL
	protected function useVirtualFields()
	{
		$where = $this->UseSessionForListSql ? $this->getSessionWhere() : $this->CurrentFilter;
		$orderBy = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
		if ($where != "")
			$where = " " . str_replace(["(", ")"], ["", ""], $where) . " ";
		if ($orderBy != "")
			$orderBy = " " . str_replace(["(", ")"], ["", ""], $orderBy) . " ";
		if ($this->BasicSearch->getKeyword() != "")
			return TRUE;
		if ($this->Nim->AdvancedSearch->SearchValue != "" ||
			$this->Nim->AdvancedSearch->SearchValue2 != "" ||
			ContainsString($where, " " . $this->Nim->VirtualExpression . " "))
			return TRUE;
		if (ContainsString($orderBy, " " . $this->Nim->VirtualExpression . " "))
			return TRUE;
		return FALSE;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		if ($this->useVirtualFields())
			$sql = BuildSelectSql($this->getSqlSelectList(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		else
			$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " (" . $names . ") VALUES (" . $values . ")";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = $this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsAutoIncrement)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter != "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = $this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('Nim', $rs))
				AddFilter($where, QuotedName('Nim', $this->Dbid) . '=' . QuotedValue($rs['Nim'], $this->Nim->DataType, $this->Dbid));
			if (array_key_exists('NoSk', $rs))
				AddFilter($where, QuotedName('NoSk', $this->Dbid) . '=' . QuotedValue($rs['NoSk'], $this->NoSk->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter != "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = $this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->Nim->DbValue = $row['Nim'];
		$this->NoSk->DbValue = $row['NoSk'];
		$this->IDBeasiswa->DbValue = $row['IDBeasiswa'];
		$this->Status->DbValue = $row['Status'];
		$this->JmlSemester->DbValue = $row['JmlSemester'];
		$this->BiayaPerSemester->DbValue = $row['BiayaPerSemester'];
		$this->Keterangan->DbValue = $row['Keterangan'];
		$this->TABerhenti->DbValue = $row['TABerhenti'];
		$this->PerBerhenti->DbValue = $row['PerBerhenti'];
		$this->Alasan->DbValue = $row['Alasan'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "[Nim] = '@Nim@' AND [NoSk] = '@NoSk@'";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		if (is_array($row))
			$val = array_key_exists('Nim', $row) ? $row['Nim'] : NULL;
		else
			$val = $this->Nim->OldValue !== NULL ? $this->Nim->OldValue : $this->Nim->CurrentValue;
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@Nim@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		if (is_array($row))
			$val = array_key_exists('NoSk', $row) ? $row['NoSk'] : NULL;
		else
			$val = $this->NoSk->OldValue !== NULL ? $this->NoSk->OldValue : $this->NoSk->CurrentValue;
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@NoSk@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") != "" && ReferPageName() != CurrentPageName() && ReferPageName() != "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] != "") {
			return $_SESSION[$name];
		} else {
			return "tblBeasiswa_Detaillist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "tblBeasiswa_Detailview.php")
			return $Language->phrase("View");
		elseif ($pageName == "tblBeasiswa_Detailedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "tblBeasiswa_Detailadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "tblBeasiswa_Detaillist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm != "")
			$url = $this->keyUrl("tblBeasiswa_Detailview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("tblBeasiswa_Detailview.php", $this->getUrlParm(Config("TABLE_SHOW_DETAIL") . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm != "")
			$url = "tblBeasiswa_Detailadd.php?" . $this->getUrlParm($parm);
		else
			$url = "tblBeasiswa_Detailadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("tblBeasiswa_Detailedit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("tblBeasiswa_Detailadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("tblBeasiswa_Detaildelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		if ($this->getCurrentMasterTable() == "tblBeasiswa_master" && !ContainsString($url, Config("TABLE_SHOW_MASTER") . "=")) {
			$url .= (ContainsString($url, "?") ? "&" : "?") . Config("TABLE_SHOW_MASTER") . "=" . $this->getCurrentMasterTable();
			$url .= "&fk_NoSK=" . urlencode($this->NoSk->CurrentValue);
		}
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "Nim:" . JsonEncode($this->Nim->CurrentValue, "string");
		$json .= ",NoSk:" . JsonEncode($this->NoSk->CurrentValue, "string");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm != "")
			$url .= $parm . "&";
		if ($this->Nim->CurrentValue != NULL) {
			$url .= "Nim=" . urlencode($this->Nim->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		if ($this->NoSk->CurrentValue != NULL) {
			$url .= "&NoSk=" . urlencode($this->NoSk->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, [141, 201, 203, 128, 204, 205])) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		$arKeys = [];
		$arKey = [];
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
			for ($i = 0; $i < $cnt; $i++)
				$arKeys[$i] = explode(Config("COMPOSITE_KEY_SEPARATOR"), $arKeys[$i]);
		} else {
			if (Param("Nim") !== NULL)
				$arKey[] = Param("Nim");
			elseif (IsApi() && Key(0) !== NULL)
				$arKey[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKey[] = Route(2);
			else
				$arKeys = NULL; // Do not setup
			if (Param("NoSk") !== NULL)
				$arKey[] = Param("NoSk");
			elseif (IsApi() && Key(1) !== NULL)
				$arKey[] = Key(1);
			elseif (IsApi() && Route(3) !== NULL)
				$arKey[] = Route(3);
			else
				$arKeys = NULL; // Do not setup
			if (is_array($arKeys)) $arKeys[] = $arKey;

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = [];
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_array($key) || count($key) != 2)
					continue; // Just skip so other keys will still work
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys($setCurrent = TRUE)
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter != "") $keyFilter .= " OR ";
			if ($setCurrent)
				$this->Nim->CurrentValue = $key[0];
			else
				$this->Nim->OldValue = $key[0];
			if ($setCurrent)
				$this->NoSk->CurrentValue = $key[1];
			else
				$this->NoSk->OldValue = $key[1];
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = $this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->Nim->setDbValue($rs->fields('Nim'));
		$this->NoSk->setDbValue($rs->fields('NoSk'));
		$this->IDBeasiswa->setDbValue($rs->fields('IDBeasiswa'));
		$this->Status->setDbValue($rs->fields('Status'));
		$this->JmlSemester->setDbValue($rs->fields('JmlSemester'));
		$this->BiayaPerSemester->setDbValue($rs->fields('BiayaPerSemester'));
		$this->Keterangan->setDbValue($rs->fields('Keterangan'));
		$this->TABerhenti->setDbValue($rs->fields('TABerhenti'));
		$this->PerBerhenti->setDbValue($rs->fields('PerBerhenti'));
		$this->Alasan->setDbValue($rs->fields('Alasan'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// Nim
		// NoSk
		// IDBeasiswa
		// Status
		// JmlSemester
		// BiayaPerSemester
		// Keterangan
		// TABerhenti
		// PerBerhenti
		// Alasan
		// Nim

		if ($this->Nim->VirtualValue != "") {
			$this->Nim->ViewValue = $this->Nim->VirtualValue;
		} else {
			$curVal = strval($this->Nim->CurrentValue);
			if ($curVal != "") {
				$this->Nim->ViewValue = $this->Nim->lookupCacheOption($curVal);
				if ($this->Nim->ViewValue === NULL) { // Lookup from database
					$filterWrk = "[Nim]" . SearchString("=", $curVal, DATATYPE_STRING, "");
					$sqlWrk = $this->Nim->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = [];
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->Nim->ViewValue = $this->Nim->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->Nim->ViewValue = $this->Nim->CurrentValue;
					}
				}
			} else {
				$this->Nim->ViewValue = NULL;
			}
		}
		$this->Nim->ViewCustomAttributes = "";

		// NoSk
		$this->NoSk->ViewValue = $this->NoSk->CurrentValue;
		$this->NoSk->ViewCustomAttributes = "";

		// IDBeasiswa
		$curVal = strval($this->IDBeasiswa->CurrentValue);
		if ($curVal != "") {
			$this->IDBeasiswa->ViewValue = $this->IDBeasiswa->lookupCacheOption($curVal);
			if ($this->IDBeasiswa->ViewValue === NULL) { // Lookup from database
				$filterWrk = "[IDBeasiswa]" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->IDBeasiswa->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = [];
					$arwrk[1] = $rswrk->fields('df');
					$this->IDBeasiswa->ViewValue = $this->IDBeasiswa->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->IDBeasiswa->ViewValue = $this->IDBeasiswa->CurrentValue;
				}
			}
		} else {
			$this->IDBeasiswa->ViewValue = NULL;
		}
		$this->IDBeasiswa->ViewCustomAttributes = "";

		// Status
		if (strval($this->Status->CurrentValue) != "") {
			$this->Status->ViewValue = $this->Status->optionCaption($this->Status->CurrentValue);
		} else {
			$this->Status->ViewValue = NULL;
		}
		$this->Status->ViewCustomAttributes = "";

		// JmlSemester
		$this->JmlSemester->ViewValue = $this->JmlSemester->CurrentValue;
		$this->JmlSemester->ViewValue = FormatNumber($this->JmlSemester->ViewValue, 0, -2, -2, -2);
		$this->JmlSemester->ViewCustomAttributes = "";

		// BiayaPerSemester
		$this->BiayaPerSemester->ViewValue = $this->BiayaPerSemester->CurrentValue;
		$this->BiayaPerSemester->ViewValue = FormatNumber($this->BiayaPerSemester->ViewValue, 2, -2, -2, -2);
		$this->BiayaPerSemester->ViewCustomAttributes = "";

		// Keterangan
		$this->Keterangan->ViewValue = $this->Keterangan->CurrentValue;
		$this->Keterangan->ViewCustomAttributes = "";

		// TABerhenti
		$this->TABerhenti->ViewValue = $this->TABerhenti->CurrentValue;
		$this->TABerhenti->ViewCustomAttributes = "";

		// PerBerhenti
		$this->PerBerhenti->ViewValue = $this->PerBerhenti->CurrentValue;
		$this->PerBerhenti->ViewCustomAttributes = "";

		// Alasan
		$this->Alasan->ViewValue = $this->Alasan->CurrentValue;
		$this->Alasan->ViewCustomAttributes = "";

		// Nim
		$this->Nim->LinkCustomAttributes = "";
		$this->Nim->HrefValue = "";
		$this->Nim->TooltipValue = "";

		// NoSk
		$this->NoSk->LinkCustomAttributes = "";
		$this->NoSk->HrefValue = "";
		$this->NoSk->TooltipValue = "";

		// IDBeasiswa
		$this->IDBeasiswa->LinkCustomAttributes = "";
		$this->IDBeasiswa->HrefValue = "";
		$this->IDBeasiswa->TooltipValue = "";

		// Status
		$this->Status->LinkCustomAttributes = "";
		$this->Status->HrefValue = "";
		$this->Status->TooltipValue = "";

		// JmlSemester
		$this->JmlSemester->LinkCustomAttributes = "";
		$this->JmlSemester->HrefValue = "";
		$this->JmlSemester->TooltipValue = "";

		// BiayaPerSemester
		$this->BiayaPerSemester->LinkCustomAttributes = "";
		$this->BiayaPerSemester->HrefValue = "";
		$this->BiayaPerSemester->TooltipValue = "";

		// Keterangan
		$this->Keterangan->LinkCustomAttributes = "";
		$this->Keterangan->HrefValue = "";
		$this->Keterangan->TooltipValue = "";

		// TABerhenti
		$this->TABerhenti->LinkCustomAttributes = "";
		$this->TABerhenti->HrefValue = "";
		$this->TABerhenti->TooltipValue = "";

		// PerBerhenti
		$this->PerBerhenti->LinkCustomAttributes = "";
		$this->PerBerhenti->HrefValue = "";
		$this->PerBerhenti->TooltipValue = "";

		// Alasan
		$this->Alasan->LinkCustomAttributes = "";
		$this->Alasan->HrefValue = "";
		$this->Alasan->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Nim
		$this->Nim->EditAttrs["class"] = "form-control";
		$this->Nim->EditCustomAttributes = "";

		// NoSk
		$this->NoSk->EditAttrs["class"] = "form-control";
		$this->NoSk->EditCustomAttributes = "";
		if (!$this->NoSk->Raw)
			$this->NoSk->CurrentValue = HtmlDecode($this->NoSk->CurrentValue);
		$this->NoSk->EditValue = $this->NoSk->CurrentValue;
		$this->NoSk->PlaceHolder = RemoveHtml($this->NoSk->caption());

		// IDBeasiswa
		$this->IDBeasiswa->EditAttrs["class"] = "form-control";
		$this->IDBeasiswa->EditCustomAttributes = "";

		// Status
		$this->Status->EditAttrs["class"] = "form-control";
		$this->Status->EditCustomAttributes = "";
		$this->Status->EditValue = $this->Status->options(TRUE);

		// JmlSemester
		$this->JmlSemester->EditAttrs["class"] = "form-control";
		$this->JmlSemester->EditCustomAttributes = "";
		$this->JmlSemester->EditValue = $this->JmlSemester->CurrentValue;
		$this->JmlSemester->PlaceHolder = RemoveHtml($this->JmlSemester->caption());

		// BiayaPerSemester
		$this->BiayaPerSemester->EditAttrs["class"] = "form-control";
		$this->BiayaPerSemester->EditCustomAttributes = "";
		$this->BiayaPerSemester->EditValue = $this->BiayaPerSemester->CurrentValue;
		$this->BiayaPerSemester->PlaceHolder = RemoveHtml($this->BiayaPerSemester->caption());
		if (strval($this->BiayaPerSemester->EditValue) != "" && is_numeric($this->BiayaPerSemester->EditValue))
			$this->BiayaPerSemester->EditValue = FormatNumber($this->BiayaPerSemester->EditValue, -2, -2, -2, -2);
		

		// Keterangan
		$this->Keterangan->EditAttrs["class"] = "form-control";
		$this->Keterangan->EditCustomAttributes = "";
		if (!$this->Keterangan->Raw)
			$this->Keterangan->CurrentValue = HtmlDecode($this->Keterangan->CurrentValue);
		$this->Keterangan->EditValue = $this->Keterangan->CurrentValue;
		$this->Keterangan->PlaceHolder = RemoveHtml($this->Keterangan->caption());

		// TABerhenti
		$this->TABerhenti->EditAttrs["class"] = "form-control";
		$this->TABerhenti->EditCustomAttributes = "";
		if (!$this->TABerhenti->Raw)
			$this->TABerhenti->CurrentValue = HtmlDecode($this->TABerhenti->CurrentValue);
		$this->TABerhenti->EditValue = $this->TABerhenti->CurrentValue;
		$this->TABerhenti->PlaceHolder = RemoveHtml($this->TABerhenti->caption());

		// PerBerhenti
		$this->PerBerhenti->EditAttrs["class"] = "form-control";
		$this->PerBerhenti->EditCustomAttributes = "";
		if (!$this->PerBerhenti->Raw)
			$this->PerBerhenti->CurrentValue = HtmlDecode($this->PerBerhenti->CurrentValue);
		$this->PerBerhenti->EditValue = $this->PerBerhenti->CurrentValue;
		$this->PerBerhenti->PlaceHolder = RemoveHtml($this->PerBerhenti->caption());

		// Alasan
		$this->Alasan->EditAttrs["class"] = "form-control";
		$this->Alasan->EditCustomAttributes = "";
		if (!$this->Alasan->Raw)
			$this->Alasan->CurrentValue = HtmlDecode($this->Alasan->CurrentValue);
		$this->Alasan->EditValue = $this->Alasan->CurrentValue;
		$this->Alasan->PlaceHolder = RemoveHtml($this->Alasan->caption());

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->Nim);
					$doc->exportCaption($this->NoSk);
					$doc->exportCaption($this->IDBeasiswa);
					$doc->exportCaption($this->Status);
					$doc->exportCaption($this->JmlSemester);
					$doc->exportCaption($this->BiayaPerSemester);
					$doc->exportCaption($this->Keterangan);
					$doc->exportCaption($this->TABerhenti);
					$doc->exportCaption($this->PerBerhenti);
					$doc->exportCaption($this->Alasan);
				} else {
					$doc->exportCaption($this->Nim);
					$doc->exportCaption($this->NoSk);
					$doc->exportCaption($this->IDBeasiswa);
					$doc->exportCaption($this->Status);
					$doc->exportCaption($this->JmlSemester);
					$doc->exportCaption($this->BiayaPerSemester);
					$doc->exportCaption($this->Keterangan);
					$doc->exportCaption($this->TABerhenti);
					$doc->exportCaption($this->PerBerhenti);
					$doc->exportCaption($this->Alasan);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->Nim);
						$doc->exportField($this->NoSk);
						$doc->exportField($this->IDBeasiswa);
						$doc->exportField($this->Status);
						$doc->exportField($this->JmlSemester);
						$doc->exportField($this->BiayaPerSemester);
						$doc->exportField($this->Keterangan);
						$doc->exportField($this->TABerhenti);
						$doc->exportField($this->PerBerhenti);
						$doc->exportField($this->Alasan);
					} else {
						$doc->exportField($this->Nim);
						$doc->exportField($this->NoSk);
						$doc->exportField($this->IDBeasiswa);
						$doc->exportField($this->Status);
						$doc->exportField($this->JmlSemester);
						$doc->exportField($this->BiayaPerSemester);
						$doc->exportField($this->Keterangan);
						$doc->exportField($this->TABerhenti);
						$doc->exportField($this->PerBerhenti);
						$doc->exportField($this->Alasan);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0)
	{

		// No binary fields
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>