<?php
namespace PHPMaker2020\baak;

/**
 * Page class
 */
class tblBeasiswa_Detail_add extends tblBeasiswa_Detail
{

	// Page ID
	public $PageID = "add";

	// Project ID
	public $ProjectID = "{A09D3AFF-419C-4918-948A-A3C8469EA234}";

	// Table name
	public $TableName = 'tblBeasiswa_Detail';

	// Page object name
	public $PageObjName = "tblBeasiswa_Detail_add";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken;

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading != "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading != "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		$url = CurrentPageName() . "?";
		if ($this->UseTokenInUrl)
			$url .= "t=" . $this->TableVar . "&"; // Add page token
		return $url;
	}

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = TRUE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message != "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fas fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage != "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fas fa-exclamation"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage != "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fas fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage != "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fas fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = [];

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message != "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage != "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage != "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage != "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header != "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer != "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(Config("TOKEN_NAME")) === NULL)
			return FALSE;
		$fn = Config("CHECK_TOKEN_FUNC");
		if (is_callable($fn))
			return $fn(Post(Config("TOKEN_NAME")), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = Config("CREATE_TOKEN_FUNC"); // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $DashboardReport;
		global $UserTable;

		// Check token
		$this->CheckToken = Config("CHECK_TOKEN");

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (tblBeasiswa_Detail)
		if (!isset($GLOBALS["tblBeasiswa_Detail"]) || get_class($GLOBALS["tblBeasiswa_Detail"]) == PROJECT_NAMESPACE . "tblBeasiswa_Detail") {
			$GLOBALS["tblBeasiswa_Detail"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["tblBeasiswa_Detail"];
		}

		// Table object (Pass)
		if (!isset($GLOBALS['Pass']))
			$GLOBALS['Pass'] = new Pass();

		// Table object (tblBeasiswa_master)
		if (!isset($GLOBALS['tblBeasiswa_master']))
			$GLOBALS['tblBeasiswa_master'] = new tblBeasiswa_master();

		// Page ID (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'add');

		// Table name (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'tblBeasiswa_Detail');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = $this->getConnection();

		// User table object (Pass)
		$UserTable = $UserTable ?: new Pass();
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages, $DashboardReport;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $tblBeasiswa_Detail;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, Config("EXPORT_CLASSES"))) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . Config("EXPORT_CLASSES." . $this->CustomExport);
			if (class_exists($class)) {
				$doc = new $class($tblBeasiswa_Detail);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url != "") {
			if (!Config("DEBUG") && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = ["url" => $url, "modal" => "1"];
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "tblBeasiswa_Detailview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = [];
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = [];
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {
								$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
									Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
									Config("API_FIELD_NAME") . "=" . $fld->Param . "&" .
									Config("API_KEY_NAME") . "=" . rawurlencode($this->getRecordKeyValue($ar)))); //*** need to add this? API may not be in the same folder
								$row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
								$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
									Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
									"fn=" . Encrypt($fld->physicalUploadPath() . $val)));
								$row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
							} else { // Multiple files
								$files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
								$ar = [];
								foreach ($files as $file) {
									$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
										Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
										"fn=" . Encrypt($fld->physicalUploadPath() . $file)));
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['Nim'] . Config("COMPOSITE_KEY_SEPARATOR");
			$key .= @$ar['NoSk'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
	}

	// Lookup data
	public function lookup()
	{
		global $Language, $Security;
		if (!isset($Language))
			$Language = new Language(Config("LANGUAGE_FOLDER"), Post("language", ""));

		// Set up API request
		if (!ValidApiRequest())
			return FALSE;
		$this->setupApiSecurity();

		// Get lookup object
		$fieldName = Post("field");
		if (!array_key_exists($fieldName, $this->fields))
			return FALSE;
		$lookupField = $this->fields[$fieldName];
		$lookup = $lookupField->Lookup;
		if ($lookup === NULL)
			return FALSE;
		$tbl = $lookup->getTable();
		if (!$Security->allowLookup(Config("PROJECT_ID") . $tbl->TableName)) // Lookup permission
			return FALSE;

		// Get lookup parameters
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Param("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
			$lookup->FilterFields = []; // Skip parent fields if any
			$lookup->FilterValues[] = $keys; // Lookup values
			$pageSize = -1; // Show all records
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect != "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter != "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy != "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson($this); // Use settings from current page
	}

	// Set up API security
	public function setupApiSecurity()
	{
		global $Security;

		// Setup security for API request
		if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
		$Security->loadCurrentUserLevel(Config("PROJECT_ID") . $this->TableName);
		if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
	}
	public $FormClassName = "ew-horizontal ew-form ew-add-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $DbMasterFilter = "";
	public $DbDetailFilter = "";
	public $StartRecord;
	public $Priv = 0;
	public $OldRecordset;
	public $CopyRecord;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		if (ValidApiRequest()) { // API request
			$this->setupApiSecurity(); // Set up API Security
			if (!$Security->canAdd()) {
				SetStatus(401); // Unauthorized
				return;
			}
		} else {
			$Security = new AdvancedSecurity();
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canAdd()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("tblBeasiswa_Detaillist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->Nim->setVisibility();
		$this->NoSk->setVisibility();
		$this->IDBeasiswa->setVisibility();
		$this->Status->setVisibility();
		$this->JmlSemester->setVisibility();
		$this->BiayaPerSemester->setVisibility();
		$this->Keterangan->setVisibility();
		$this->TABerhenti->Visible = FALSE;
		$this->PerBerhenti->Visible = FALSE;
		$this->Alasan->Visible = FALSE;
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->Nim);
		$this->setupLookupOptions($this->IDBeasiswa);

		// Check permission
		if (!$Security->canAdd()) {
			$this->setFailureMessage(DeniedMessage()); // No permission
			$this->terminate("tblBeasiswa_Detaillist.php");
			return;
		}

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-add-form ew-horizontal";
		$postBack = FALSE;

		// Set up current action
		if (IsApi()) {
			$this->CurrentAction = "insert"; // Add record directly
			$postBack = TRUE;
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action"); // Get form action
			$postBack = TRUE;
		} else { // Not post back

			// Load key values from QueryString
			$this->CopyRecord = TRUE;
			if (Get("Nim") !== NULL) {
				$this->Nim->setQueryStringValue(Get("Nim"));
				$this->setKey("Nim", $this->Nim->CurrentValue); // Set up key
			} else {
				$this->setKey("Nim", ""); // Clear key
				$this->CopyRecord = FALSE;
			}
			if (Get("NoSk") !== NULL) {
				$this->NoSk->setQueryStringValue(Get("NoSk"));
				$this->setKey("NoSk", $this->NoSk->CurrentValue); // Set up key
			} else {
				$this->setKey("NoSk", ""); // Clear key
				$this->CopyRecord = FALSE;
			}
			if ($this->CopyRecord) {
				$this->CurrentAction = "copy"; // Copy record
			} else {
				$this->CurrentAction = "show"; // Display blank record
			}
		}

		// Load old record / default values
		$loaded = $this->loadOldRecord();

		// Set up master/detail parameters
		// NOTE: must be after loadOldRecord to prevent master key values overwritten

		$this->setupMasterParms();

		// Load form values
		if ($postBack) {
			$this->loadFormValues(); // Load form values
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->validateForm()) {
				$this->EventCancelled = TRUE; // Event cancelled
				$this->restoreFormValues(); // Restore form values
				$this->setFailureMessage($FormError);
				if (IsApi()) {
					$this->terminate();
					return;
				} else {
					$this->CurrentAction = "show"; // Form error, reset action
				}
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "copy": // Copy an existing record
				if (!$loaded) { // Record not loaded
					if ($this->getFailureMessage() == "")
						$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
					$this->terminate("tblBeasiswa_Detaillist.php"); // No matching record, return to list
				}
				break;
			case "insert": // Add new record
				$this->SendEmail = TRUE; // Send email on add success
				if ($this->addRow($this->OldRecordset)) { // Add successful
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
					$returnUrl = $this->getReturnUrl();
					if (GetPageName($returnUrl) == "tblBeasiswa_Detaillist.php")
						$returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
					elseif (GetPageName($returnUrl) == "tblBeasiswa_Detailview.php")
						$returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
					if (IsApi()) { // Return to caller
						$this->terminate(TRUE);
						return;
					} else {
						$this->terminate($returnUrl);
					}
				} elseif (IsApi()) { // API request, return
					$this->terminate();
					return;
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->restoreFormValues(); // Add failed, restore form values
				}
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Render row based on row type
		$this->RowType = ROWTYPE_ADD; // Render add type

		// Render row
		$this->resetAttributes();
		$this->renderRow();
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
	}

	// Load default values
	protected function loadDefaultValues()
	{
		$this->Nim->CurrentValue = NULL;
		$this->Nim->OldValue = $this->Nim->CurrentValue;
		$this->NoSk->CurrentValue = NULL;
		$this->NoSk->OldValue = $this->NoSk->CurrentValue;
		$this->IDBeasiswa->CurrentValue = NULL;
		$this->IDBeasiswa->OldValue = $this->IDBeasiswa->CurrentValue;
		$this->Status->CurrentValue = NULL;
		$this->Status->OldValue = $this->Status->CurrentValue;
		$this->JmlSemester->CurrentValue = NULL;
		$this->JmlSemester->OldValue = $this->JmlSemester->CurrentValue;
		$this->BiayaPerSemester->CurrentValue = NULL;
		$this->BiayaPerSemester->OldValue = $this->BiayaPerSemester->CurrentValue;
		$this->Keterangan->CurrentValue = NULL;
		$this->Keterangan->OldValue = $this->Keterangan->CurrentValue;
		$this->TABerhenti->CurrentValue = NULL;
		$this->TABerhenti->OldValue = $this->TABerhenti->CurrentValue;
		$this->PerBerhenti->CurrentValue = NULL;
		$this->PerBerhenti->OldValue = $this->PerBerhenti->CurrentValue;
		$this->Alasan->CurrentValue = NULL;
		$this->Alasan->OldValue = $this->Alasan->CurrentValue;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;

		// Check field name 'Nim' first before field var 'x_Nim'
		$val = $CurrentForm->hasValue("Nim") ? $CurrentForm->getValue("Nim") : $CurrentForm->getValue("x_Nim");
		if (!$this->Nim->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->Nim->Visible = FALSE; // Disable update for API request
			else
				$this->Nim->setFormValue($val);
		}

		// Check field name 'NoSk' first before field var 'x_NoSk'
		$val = $CurrentForm->hasValue("NoSk") ? $CurrentForm->getValue("NoSk") : $CurrentForm->getValue("x_NoSk");
		if (!$this->NoSk->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->NoSk->Visible = FALSE; // Disable update for API request
			else
				$this->NoSk->setFormValue($val);
		}

		// Check field name 'IDBeasiswa' first before field var 'x_IDBeasiswa'
		$val = $CurrentForm->hasValue("IDBeasiswa") ? $CurrentForm->getValue("IDBeasiswa") : $CurrentForm->getValue("x_IDBeasiswa");
		if (!$this->IDBeasiswa->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->IDBeasiswa->Visible = FALSE; // Disable update for API request
			else
				$this->IDBeasiswa->setFormValue($val);
		}

		// Check field name 'Status' first before field var 'x_Status'
		$val = $CurrentForm->hasValue("Status") ? $CurrentForm->getValue("Status") : $CurrentForm->getValue("x_Status");
		if (!$this->Status->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->Status->Visible = FALSE; // Disable update for API request
			else
				$this->Status->setFormValue($val);
		}

		// Check field name 'JmlSemester' first before field var 'x_JmlSemester'
		$val = $CurrentForm->hasValue("JmlSemester") ? $CurrentForm->getValue("JmlSemester") : $CurrentForm->getValue("x_JmlSemester");
		if (!$this->JmlSemester->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->JmlSemester->Visible = FALSE; // Disable update for API request
			else
				$this->JmlSemester->setFormValue($val);
		}

		// Check field name 'BiayaPerSemester' first before field var 'x_BiayaPerSemester'
		$val = $CurrentForm->hasValue("BiayaPerSemester") ? $CurrentForm->getValue("BiayaPerSemester") : $CurrentForm->getValue("x_BiayaPerSemester");
		if (!$this->BiayaPerSemester->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->BiayaPerSemester->Visible = FALSE; // Disable update for API request
			else
				$this->BiayaPerSemester->setFormValue($val);
		}

		// Check field name 'Keterangan' first before field var 'x_Keterangan'
		$val = $CurrentForm->hasValue("Keterangan") ? $CurrentForm->getValue("Keterangan") : $CurrentForm->getValue("x_Keterangan");
		if (!$this->Keterangan->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->Keterangan->Visible = FALSE; // Disable update for API request
			else
				$this->Keterangan->setFormValue($val);
		}
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->Nim->CurrentValue = $this->Nim->FormValue;
		$this->NoSk->CurrentValue = $this->NoSk->FormValue;
		$this->IDBeasiswa->CurrentValue = $this->IDBeasiswa->FormValue;
		$this->Status->CurrentValue = $this->Status->FormValue;
		$this->JmlSemester->CurrentValue = $this->JmlSemester->FormValue;
		$this->BiayaPerSemester->CurrentValue = $this->BiayaPerSemester->FormValue;
		$this->Keterangan->CurrentValue = $this->Keterangan->FormValue;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = $this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->Nim->setDbValue($row['Nim']);
		if (array_key_exists('EV__Nim', $rs->fields)) {
			$this->Nim->VirtualValue = $rs->fields('EV__Nim'); // Set up virtual field value
		} else {
			$this->Nim->VirtualValue = ""; // Clear value
		}
		$this->NoSk->setDbValue($row['NoSk']);
		$this->IDBeasiswa->setDbValue($row['IDBeasiswa']);
		$this->Status->setDbValue($row['Status']);
		$this->JmlSemester->setDbValue($row['JmlSemester']);
		$this->BiayaPerSemester->setDbValue($row['BiayaPerSemester']);
		$this->Keterangan->setDbValue($row['Keterangan']);
		$this->TABerhenti->setDbValue($row['TABerhenti']);
		$this->PerBerhenti->setDbValue($row['PerBerhenti']);
		$this->Alasan->setDbValue($row['Alasan']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$this->loadDefaultValues();
		$row = [];
		$row['Nim'] = $this->Nim->CurrentValue;
		$row['NoSk'] = $this->NoSk->CurrentValue;
		$row['IDBeasiswa'] = $this->IDBeasiswa->CurrentValue;
		$row['Status'] = $this->Status->CurrentValue;
		$row['JmlSemester'] = $this->JmlSemester->CurrentValue;
		$row['BiayaPerSemester'] = $this->BiayaPerSemester->CurrentValue;
		$row['Keterangan'] = $this->Keterangan->CurrentValue;
		$row['TABerhenti'] = $this->TABerhenti->CurrentValue;
		$row['PerBerhenti'] = $this->PerBerhenti->CurrentValue;
		$row['Alasan'] = $this->Alasan->CurrentValue;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("Nim")) != "")
			$this->Nim->OldValue = $this->getKey("Nim"); // Nim
		else
			$validKey = FALSE;
		if (strval($this->getKey("NoSk")) != "")
			$this->NoSk->OldValue = $this->getKey("NoSk"); // NoSk
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = $this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->BiayaPerSemester->FormValue == $this->BiayaPerSemester->CurrentValue && is_numeric(ConvertToFloatString($this->BiayaPerSemester->CurrentValue)))
			$this->BiayaPerSemester->CurrentValue = ConvertToFloatString($this->BiayaPerSemester->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// Nim
		// NoSk
		// IDBeasiswa
		// Status
		// JmlSemester
		// BiayaPerSemester
		// Keterangan
		// TABerhenti
		// PerBerhenti
		// Alasan

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// Nim
			if ($this->Nim->VirtualValue != "") {
				$this->Nim->ViewValue = $this->Nim->VirtualValue;
			} else {
				$curVal = strval($this->Nim->CurrentValue);
				if ($curVal != "") {
					$this->Nim->ViewValue = $this->Nim->lookupCacheOption($curVal);
					if ($this->Nim->ViewValue === NULL) { // Lookup from database
						$filterWrk = "[Nim]" . SearchString("=", $curVal, DATATYPE_STRING, "");
						$sqlWrk = $this->Nim->Lookup->getSql(FALSE, $filterWrk, '', $this);
						$rswrk = Conn()->execute($sqlWrk);
						if ($rswrk && !$rswrk->EOF) { // Lookup values found
							$arwrk = [];
							$arwrk[1] = $rswrk->fields('df');
							$arwrk[2] = $rswrk->fields('df2');
							$this->Nim->ViewValue = $this->Nim->displayValue($arwrk);
							$rswrk->Close();
						} else {
							$this->Nim->ViewValue = $this->Nim->CurrentValue;
						}
					}
				} else {
					$this->Nim->ViewValue = NULL;
				}
			}
			$this->Nim->ViewCustomAttributes = "";

			// NoSk
			$this->NoSk->ViewValue = $this->NoSk->CurrentValue;
			$this->NoSk->ViewCustomAttributes = "";

			// IDBeasiswa
			$curVal = strval($this->IDBeasiswa->CurrentValue);
			if ($curVal != "") {
				$this->IDBeasiswa->ViewValue = $this->IDBeasiswa->lookupCacheOption($curVal);
				if ($this->IDBeasiswa->ViewValue === NULL) { // Lookup from database
					$filterWrk = "[IDBeasiswa]" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->IDBeasiswa->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = [];
						$arwrk[1] = $rswrk->fields('df');
						$this->IDBeasiswa->ViewValue = $this->IDBeasiswa->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->IDBeasiswa->ViewValue = $this->IDBeasiswa->CurrentValue;
					}
				}
			} else {
				$this->IDBeasiswa->ViewValue = NULL;
			}
			$this->IDBeasiswa->ViewCustomAttributes = "";

			// Status
			if (strval($this->Status->CurrentValue) != "") {
				$this->Status->ViewValue = $this->Status->optionCaption($this->Status->CurrentValue);
			} else {
				$this->Status->ViewValue = NULL;
			}
			$this->Status->ViewCustomAttributes = "";

			// JmlSemester
			$this->JmlSemester->ViewValue = $this->JmlSemester->CurrentValue;
			$this->JmlSemester->ViewValue = FormatNumber($this->JmlSemester->ViewValue, 0, -2, -2, -2);
			$this->JmlSemester->ViewCustomAttributes = "";

			// BiayaPerSemester
			$this->BiayaPerSemester->ViewValue = $this->BiayaPerSemester->CurrentValue;
			$this->BiayaPerSemester->ViewValue = FormatNumber($this->BiayaPerSemester->ViewValue, 2, -2, -2, -2);
			$this->BiayaPerSemester->ViewCustomAttributes = "";

			// Keterangan
			$this->Keterangan->ViewValue = $this->Keterangan->CurrentValue;
			$this->Keterangan->ViewCustomAttributes = "";

			// TABerhenti
			$this->TABerhenti->ViewValue = $this->TABerhenti->CurrentValue;
			$this->TABerhenti->ViewCustomAttributes = "";

			// PerBerhenti
			$this->PerBerhenti->ViewValue = $this->PerBerhenti->CurrentValue;
			$this->PerBerhenti->ViewCustomAttributes = "";

			// Alasan
			$this->Alasan->ViewValue = $this->Alasan->CurrentValue;
			$this->Alasan->ViewCustomAttributes = "";

			// Nim
			$this->Nim->LinkCustomAttributes = "";
			$this->Nim->HrefValue = "";
			$this->Nim->TooltipValue = "";

			// NoSk
			$this->NoSk->LinkCustomAttributes = "";
			$this->NoSk->HrefValue = "";
			$this->NoSk->TooltipValue = "";

			// IDBeasiswa
			$this->IDBeasiswa->LinkCustomAttributes = "";
			$this->IDBeasiswa->HrefValue = "";
			$this->IDBeasiswa->TooltipValue = "";

			// Status
			$this->Status->LinkCustomAttributes = "";
			$this->Status->HrefValue = "";
			$this->Status->TooltipValue = "";

			// JmlSemester
			$this->JmlSemester->LinkCustomAttributes = "";
			$this->JmlSemester->HrefValue = "";
			$this->JmlSemester->TooltipValue = "";

			// BiayaPerSemester
			$this->BiayaPerSemester->LinkCustomAttributes = "";
			$this->BiayaPerSemester->HrefValue = "";
			$this->BiayaPerSemester->TooltipValue = "";

			// Keterangan
			$this->Keterangan->LinkCustomAttributes = "";
			$this->Keterangan->HrefValue = "";
			$this->Keterangan->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_ADD) { // Add row

			// Nim
			$this->Nim->EditCustomAttributes = "";
			$curVal = trim(strval($this->Nim->CurrentValue));
			if ($curVal != "")
				$this->Nim->ViewValue = $this->Nim->lookupCacheOption($curVal);
			else
				$this->Nim->ViewValue = $this->Nim->Lookup !== NULL && is_array($this->Nim->Lookup->Options) ? $curVal : NULL;
			if ($this->Nim->ViewValue !== NULL) { // Load from cache
				$this->Nim->EditValue = array_values($this->Nim->Lookup->Options);
				if ($this->Nim->ViewValue == "")
					$this->Nim->ViewValue = $Language->phrase("PleaseSelect");
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "[Nim]" . SearchString("=", $this->Nim->CurrentValue, DATATYPE_STRING, "");
				}
				$sqlWrk = $this->Nim->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = [];
					$arwrk[1] = HtmlEncode($rswrk->fields('df'));
					$arwrk[2] = HtmlEncode($rswrk->fields('df2'));
					$this->Nim->ViewValue = $this->Nim->displayValue($arwrk);
				} else {
					$this->Nim->ViewValue = $Language->phrase("PleaseSelect");
				}
				$arwrk = $rswrk ? $rswrk->getRows() : [];
				if ($rswrk)
					$rswrk->close();
				$this->Nim->EditValue = $arwrk;
			}

			// NoSk
			$this->NoSk->EditAttrs["class"] = "form-control";
			$this->NoSk->EditCustomAttributes = "";
			if ($this->NoSk->getSessionValue() != "") {
				$this->NoSk->CurrentValue = $this->NoSk->getSessionValue();
				$this->NoSk->ViewValue = $this->NoSk->CurrentValue;
				$this->NoSk->ViewCustomAttributes = "";
			} else {
				if (!$this->NoSk->Raw)
					$this->NoSk->CurrentValue = HtmlDecode($this->NoSk->CurrentValue);
				$this->NoSk->EditValue = HtmlEncode($this->NoSk->CurrentValue);
				$this->NoSk->PlaceHolder = RemoveHtml($this->NoSk->caption());
			}

			// IDBeasiswa
			$this->IDBeasiswa->EditAttrs["class"] = "form-control";
			$this->IDBeasiswa->EditCustomAttributes = "";
			$curVal = trim(strval($this->IDBeasiswa->CurrentValue));
			if ($curVal != "")
				$this->IDBeasiswa->ViewValue = $this->IDBeasiswa->lookupCacheOption($curVal);
			else
				$this->IDBeasiswa->ViewValue = $this->IDBeasiswa->Lookup !== NULL && is_array($this->IDBeasiswa->Lookup->Options) ? $curVal : NULL;
			if ($this->IDBeasiswa->ViewValue !== NULL) { // Load from cache
				$this->IDBeasiswa->EditValue = array_values($this->IDBeasiswa->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "[IDBeasiswa]" . SearchString("=", $this->IDBeasiswa->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->IDBeasiswa->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = $rswrk ? $rswrk->getRows() : [];
				if ($rswrk)
					$rswrk->close();
				$this->IDBeasiswa->EditValue = $arwrk;
			}

			// Status
			$this->Status->EditAttrs["class"] = "form-control";
			$this->Status->EditCustomAttributes = "";
			$this->Status->EditValue = $this->Status->options(TRUE);

			// JmlSemester
			$this->JmlSemester->EditAttrs["class"] = "form-control";
			$this->JmlSemester->EditCustomAttributes = "";
			$this->JmlSemester->EditValue = HtmlEncode($this->JmlSemester->CurrentValue);
			$this->JmlSemester->PlaceHolder = RemoveHtml($this->JmlSemester->caption());

			// BiayaPerSemester
			$this->BiayaPerSemester->EditAttrs["class"] = "form-control";
			$this->BiayaPerSemester->EditCustomAttributes = "";
			$this->BiayaPerSemester->EditValue = HtmlEncode($this->BiayaPerSemester->CurrentValue);
			$this->BiayaPerSemester->PlaceHolder = RemoveHtml($this->BiayaPerSemester->caption());
			if (strval($this->BiayaPerSemester->EditValue) != "" && is_numeric($this->BiayaPerSemester->EditValue))
				$this->BiayaPerSemester->EditValue = FormatNumber($this->BiayaPerSemester->EditValue, -2, -2, -2, -2);
			

			// Keterangan
			$this->Keterangan->EditAttrs["class"] = "form-control";
			$this->Keterangan->EditCustomAttributes = "";
			if (!$this->Keterangan->Raw)
				$this->Keterangan->CurrentValue = HtmlDecode($this->Keterangan->CurrentValue);
			$this->Keterangan->EditValue = HtmlEncode($this->Keterangan->CurrentValue);
			$this->Keterangan->PlaceHolder = RemoveHtml($this->Keterangan->caption());

			// Add refer script
			// Nim

			$this->Nim->LinkCustomAttributes = "";
			$this->Nim->HrefValue = "";

			// NoSk
			$this->NoSk->LinkCustomAttributes = "";
			$this->NoSk->HrefValue = "";

			// IDBeasiswa
			$this->IDBeasiswa->LinkCustomAttributes = "";
			$this->IDBeasiswa->HrefValue = "";

			// Status
			$this->Status->LinkCustomAttributes = "";
			$this->Status->HrefValue = "";

			// JmlSemester
			$this->JmlSemester->LinkCustomAttributes = "";
			$this->JmlSemester->HrefValue = "";

			// BiayaPerSemester
			$this->BiayaPerSemester->LinkCustomAttributes = "";
			$this->BiayaPerSemester->HrefValue = "";

			// Keterangan
			$this->Keterangan->LinkCustomAttributes = "";
			$this->Keterangan->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType != ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!Config("SERVER_VALIDATE"))
			return ($FormError == "");
		if ($this->Nim->Required) {
			if (!$this->Nim->IsDetailKey && $this->Nim->FormValue != NULL && $this->Nim->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Nim->caption(), $this->Nim->RequiredErrorMessage));
			}
		}
		if ($this->NoSk->Required) {
			if (!$this->NoSk->IsDetailKey && $this->NoSk->FormValue != NULL && $this->NoSk->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->NoSk->caption(), $this->NoSk->RequiredErrorMessage));
			}
		}
		if ($this->IDBeasiswa->Required) {
			if (!$this->IDBeasiswa->IsDetailKey && $this->IDBeasiswa->FormValue != NULL && $this->IDBeasiswa->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->IDBeasiswa->caption(), $this->IDBeasiswa->RequiredErrorMessage));
			}
		}
		if ($this->Status->Required) {
			if (!$this->Status->IsDetailKey && $this->Status->FormValue != NULL && $this->Status->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Status->caption(), $this->Status->RequiredErrorMessage));
			}
		}
		if ($this->JmlSemester->Required) {
			if (!$this->JmlSemester->IsDetailKey && $this->JmlSemester->FormValue != NULL && $this->JmlSemester->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->JmlSemester->caption(), $this->JmlSemester->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->JmlSemester->FormValue)) {
			AddMessage($FormError, $this->JmlSemester->errorMessage());
		}
		if ($this->BiayaPerSemester->Required) {
			if (!$this->BiayaPerSemester->IsDetailKey && $this->BiayaPerSemester->FormValue != NULL && $this->BiayaPerSemester->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->BiayaPerSemester->caption(), $this->BiayaPerSemester->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->BiayaPerSemester->FormValue)) {
			AddMessage($FormError, $this->BiayaPerSemester->errorMessage());
		}
		if ($this->Keterangan->Required) {
			if (!$this->Keterangan->IsDetailKey && $this->Keterangan->FormValue != NULL && $this->Keterangan->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Keterangan->caption(), $this->Keterangan->RequiredErrorMessage));
			}
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError != "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Add record
	protected function addRow($rsold = NULL)
	{
		global $Language, $Security;
		$conn = $this->getConnection();

		// Load db values from rsold
		$this->loadDbValues($rsold);
		if ($rsold) {
		}
		$rsnew = [];

		// Nim
		$this->Nim->setDbValueDef($rsnew, $this->Nim->CurrentValue, "", FALSE);

		// NoSk
		$this->NoSk->setDbValueDef($rsnew, $this->NoSk->CurrentValue, "", FALSE);

		// IDBeasiswa
		$this->IDBeasiswa->setDbValueDef($rsnew, $this->IDBeasiswa->CurrentValue, NULL, FALSE);

		// Status
		$this->Status->setDbValueDef($rsnew, $this->Status->CurrentValue, NULL, strval($this->Status->CurrentValue) == "");

		// JmlSemester
		$this->JmlSemester->setDbValueDef($rsnew, $this->JmlSemester->CurrentValue, NULL, FALSE);

		// BiayaPerSemester
		$this->BiayaPerSemester->setDbValueDef($rsnew, $this->BiayaPerSemester->CurrentValue, NULL, FALSE);

		// Keterangan
		$this->Keterangan->setDbValueDef($rsnew, $this->Keterangan->CurrentValue, NULL, FALSE);

		// Call Row Inserting event
		$rs = ($rsold) ? $rsold->fields : NULL;
		$insertRow = $this->Row_Inserting($rs, $rsnew);

		// Check if key value entered
		if ($insertRow && $this->ValidateKey && strval($rsnew['Nim']) == "") {
			$this->setFailureMessage($Language->phrase("InvalidKeyValue"));
			$insertRow = FALSE;
		}

		// Check if key value entered
		if ($insertRow && $this->ValidateKey && strval($rsnew['NoSk']) == "") {
			$this->setFailureMessage($Language->phrase("InvalidKeyValue"));
			$insertRow = FALSE;
		}

		// Check for duplicate key
		if ($insertRow && $this->ValidateKey) {
			$filter = $this->getRecordFilter($rsnew);
			$rsChk = $this->loadRs($filter);
			if ($rsChk && !$rsChk->EOF) {
				$keyErrMsg = str_replace("%f", $filter, $Language->phrase("DupKey"));
				$this->setFailureMessage($keyErrMsg);
				$rsChk->close();
				$insertRow = FALSE;
			}
		}
		if ($insertRow) {
			$conn->raiseErrorFn = Config("ERROR_FUNC");
			$addRow = $this->insert($rsnew);
			$conn->raiseErrorFn = "";
			if ($addRow) {
			}
		} else {
			if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage != "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->phrase("InsertCancelled"));
			}
			$addRow = FALSE;
		}
		if ($addRow) {

			// Call Row Inserted event
			$rs = ($rsold) ? $rsold->fields : NULL;
			$this->Row_Inserted($rs, $rsnew);
		}

		// Clean upload path if any
		if ($addRow) {
		}

		// Write JSON for API request
		if (IsApi() && $addRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $addRow;
	}

	// Set up master/detail based on QueryString
	protected function setupMasterParms()
	{
		$validMaster = FALSE;

		// Get the keys for master table
		if (($master = Get(Config("TABLE_SHOW_MASTER"), Get(Config("TABLE_MASTER")))) !== NULL) {
			$masterTblVar = $master;
			if ($masterTblVar == "") {
				$validMaster = TRUE;
				$this->DbMasterFilter = "";
				$this->DbDetailFilter = "";
			}
			if ($masterTblVar == "tblBeasiswa_master") {
				$validMaster = TRUE;
				if (($parm = Get("fk_NoSK", Get("NoSk"))) !== NULL) {
					$GLOBALS["tblBeasiswa_master"]->NoSK->setQueryStringValue($parm);
					$this->NoSk->setQueryStringValue($GLOBALS["tblBeasiswa_master"]->NoSK->QueryStringValue);
					$this->NoSk->setSessionValue($this->NoSk->QueryStringValue);
				} else {
					$validMaster = FALSE;
				}
			}
		} elseif (($master = Post(Config("TABLE_SHOW_MASTER"), Post(Config("TABLE_MASTER")))) !== NULL) {
			$masterTblVar = $master;
			if ($masterTblVar == "") {
				$validMaster = TRUE;
				$this->DbMasterFilter = "";
				$this->DbDetailFilter = "";
			}
			if ($masterTblVar == "tblBeasiswa_master") {
				$validMaster = TRUE;
				if (($parm = Post("fk_NoSK", Post("NoSk"))) !== NULL) {
					$GLOBALS["tblBeasiswa_master"]->NoSK->setFormValue($parm);
					$this->NoSk->setFormValue($GLOBALS["tblBeasiswa_master"]->NoSK->FormValue);
					$this->NoSk->setSessionValue($this->NoSk->FormValue);
				} else {
					$validMaster = FALSE;
				}
			}
		}
		if ($validMaster) {

			// Save current master table
			$this->setCurrentMasterTable($masterTblVar);

			// Reset start record counter (new master key)
			if (!$this->isAddOrEdit()) {
				$this->StartRecord = 1;
				$this->setStartRecordNumber($this->StartRecord);
			}

			// Clear previous master key from Session
			if ($masterTblVar != "tblBeasiswa_master") {
				if ($this->NoSk->CurrentValue == "")
					$this->NoSk->setSessionValue("");
			}
		}
		$this->DbMasterFilter = $this->getMasterFilter(); // Get master filter
		$this->DbDetailFilter = $this->getDetailFilter(); // Get detail filter
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("tblBeasiswa_Detaillist.php"), "", $this->TableVar, TRUE);
		$pageId = ($this->isCopy()) ? "Copy" : "Add";
		$Breadcrumb->add("add", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// Get default connection and filter
			$conn = $this->getConnection();
			$lookupFilter = "";

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL and connection
			switch ($fld->FieldVar) {
				case "x_Nim":
					break;
				case "x_IDBeasiswa":
					break;
				case "x_Status":
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0) {
				$totalCnt = $this->getRecordCount($sql, $conn);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_Nim":
							break;
						case "x_IDBeasiswa":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
} // End class
?>