<?php namespace PHPMaker2020\baak; ?>
<?php

/**
 * Table class for tblDosen
 */
class tblDosen extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $NIDN;
	public $Nama;
	public $Status;
	public $NoSKStatus;
	public $TMTKerja;
	public $NoKtp;
	public $Tmp_Lahir;
	public $Tgl_Lahir;
	public $Kelamin;
	public $Alamat;
	public $Kelurahan;
	public $Kecamatan;
	public $Kota;
	public $Kode_pos;
	public $Phone;
	public $TlpRumah;
	public $KodeJafung;
	public $Gol;
	public $TMTJafung;
	public $PendidikanTerakhir;
	public $Status_Dosen;
	public $Kode_Jp;
	public $photo;
	public $PictureName;
	public $PictureSize;
	public $PictureType;
	public $PictureWidth;
	public $PictureHeight;
	public $Norek;
	public $Password;
	public $NPWP;
	public $_Email;
	public $KewajibanSKS;
	public $IDFIng;
	public $Profile;
	public $ttd;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;
		parent::__construct();

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'tblDosen';
		$this->TableName = 'tblDosen';
		$this->TableType = 'TABLE';

		// Update Table
		$this->UpdateTable = "[dbo].[tblDosen]";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
		$this->BasicSearch = new BasicSearch($this->TableVar);

		// NIDN
		$this->NIDN = new DbField('tblDosen', 'tblDosen', 'x_NIDN', 'NIDN', '[NIDN]', '[NIDN]', 129, 14, -1, FALSE, '[NIDN]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->NIDN->IsPrimaryKey = TRUE; // Primary key field
		$this->NIDN->Nullable = FALSE; // NOT NULL field
		$this->NIDN->Required = TRUE; // Required field
		$this->NIDN->Sortable = TRUE; // Allow sort
		$this->fields['NIDN'] = &$this->NIDN;

		// Nama
		$this->Nama = new DbField('tblDosen', 'tblDosen', 'x_Nama', 'Nama', '[Nama]', '[Nama]', 200, 40, -1, FALSE, '[Nama]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Nama->Sortable = TRUE; // Allow sort
		$this->fields['Nama'] = &$this->Nama;

		// Status
		$this->Status = new DbField('tblDosen', 'tblDosen', 'x_Status', 'Status', '[Status]', '[Status]', 200, 20, -1, FALSE, '[Status]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->Status->Sortable = TRUE; // Allow sort
		$this->Status->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->Status->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
		$this->Status->Lookup = new Lookup('Status', 'tblDosen', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->Status->OptionCount = 4;
		$this->fields['Status'] = &$this->Status;

		// NoSKStatus
		$this->NoSKStatus = new DbField('tblDosen', 'tblDosen', 'x_NoSKStatus', 'NoSKStatus', '[NoSKStatus]', '[NoSKStatus]', 200, 50, -1, FALSE, '[NoSKStatus]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->NoSKStatus->Sortable = TRUE; // Allow sort
		$this->fields['NoSKStatus'] = &$this->NoSKStatus;

		// TMTKerja
		$this->TMTKerja = new DbField('tblDosen', 'tblDosen', 'x_TMTKerja', 'TMTKerja', '[TMTKerja]', CastDateFieldForLike("[TMTKerja]", 0, "DB"), 135, 8, 0, FALSE, '[TMTKerja]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->TMTKerja->Sortable = TRUE; // Allow sort
		$this->TMTKerja->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['TMTKerja'] = &$this->TMTKerja;

		// NoKtp
		$this->NoKtp = new DbField('tblDosen', 'tblDosen', 'x_NoKtp', 'NoKtp', '[NoKtp]', '[NoKtp]', 200, 50, -1, FALSE, '[NoKtp]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->NoKtp->Sortable = TRUE; // Allow sort
		$this->fields['NoKtp'] = &$this->NoKtp;

		// Tmp_Lahir
		$this->Tmp_Lahir = new DbField('tblDosen', 'tblDosen', 'x_Tmp_Lahir', 'Tmp_Lahir', '[Tmp_Lahir]', '[Tmp_Lahir]', 200, 30, -1, FALSE, '[Tmp_Lahir]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Tmp_Lahir->Sortable = TRUE; // Allow sort
		$this->fields['Tmp_Lahir'] = &$this->Tmp_Lahir;

		// Tgl_Lahir
		$this->Tgl_Lahir = new DbField('tblDosen', 'tblDosen', 'x_Tgl_Lahir', 'Tgl_Lahir', '[Tgl_Lahir]', CastDateFieldForLike("[Tgl_Lahir]", 0, "DB"), 135, 8, 0, FALSE, '[Tgl_Lahir]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Tgl_Lahir->Sortable = TRUE; // Allow sort
		$this->Tgl_Lahir->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['Tgl_Lahir'] = &$this->Tgl_Lahir;

		// Kelamin
		$this->Kelamin = new DbField('tblDosen', 'tblDosen', 'x_Kelamin', 'Kelamin', '[Kelamin]', '[Kelamin]', 200, 15, -1, FALSE, '[Kelamin]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Kelamin->Sortable = TRUE; // Allow sort
		$this->fields['Kelamin'] = &$this->Kelamin;

		// Alamat
		$this->Alamat = new DbField('tblDosen', 'tblDosen', 'x_Alamat', 'Alamat', '[Alamat]', '[Alamat]', 200, 50, -1, FALSE, '[Alamat]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Alamat->Sortable = TRUE; // Allow sort
		$this->fields['Alamat'] = &$this->Alamat;

		// Kelurahan
		$this->Kelurahan = new DbField('tblDosen', 'tblDosen', 'x_Kelurahan', 'Kelurahan', '[Kelurahan]', '[Kelurahan]', 200, 30, -1, FALSE, '[Kelurahan]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Kelurahan->Sortable = TRUE; // Allow sort
		$this->fields['Kelurahan'] = &$this->Kelurahan;

		// Kecamatan
		$this->Kecamatan = new DbField('tblDosen', 'tblDosen', 'x_Kecamatan', 'Kecamatan', '[Kecamatan]', '[Kecamatan]', 200, 30, -1, FALSE, '[Kecamatan]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Kecamatan->Sortable = TRUE; // Allow sort
		$this->fields['Kecamatan'] = &$this->Kecamatan;

		// Kota
		$this->Kota = new DbField('tblDosen', 'tblDosen', 'x_Kota', 'Kota', '[Kota]', '[Kota]', 200, 30, -1, FALSE, '[Kota]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Kota->Sortable = TRUE; // Allow sort
		$this->fields['Kota'] = &$this->Kota;

		// Kode_pos
		$this->Kode_pos = new DbField('tblDosen', 'tblDosen', 'x_Kode_pos', 'Kode_pos', '[Kode_pos]', '[Kode_pos]', 129, 5, -1, FALSE, '[Kode_pos]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Kode_pos->Sortable = TRUE; // Allow sort
		$this->fields['Kode_pos'] = &$this->Kode_pos;

		// Phone
		$this->Phone = new DbField('tblDosen', 'tblDosen', 'x_Phone', 'Phone', '[Phone]', '[Phone]', 200, 15, -1, FALSE, '[Phone]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Phone->Sortable = TRUE; // Allow sort
		$this->fields['Phone'] = &$this->Phone;

		// TlpRumah
		$this->TlpRumah = new DbField('tblDosen', 'tblDosen', 'x_TlpRumah', 'TlpRumah', '[TlpRumah]', '[TlpRumah]', 200, 15, -1, FALSE, '[TlpRumah]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->TlpRumah->Sortable = TRUE; // Allow sort
		$this->fields['TlpRumah'] = &$this->TlpRumah;

		// KodeJafung
		$this->KodeJafung = new DbField('tblDosen', 'tblDosen', 'x_KodeJafung', 'KodeJafung', '[KodeJafung]', '[KodeJafung]', 200, 3, -1, FALSE, '[KodeJafung]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->KodeJafung->Sortable = TRUE; // Allow sort
		$this->fields['KodeJafung'] = &$this->KodeJafung;

		// Gol
		$this->Gol = new DbField('tblDosen', 'tblDosen', 'x_Gol', 'Gol', '[Gol]', '[Gol]', 200, 5, -1, FALSE, '[Gol]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Gol->Sortable = TRUE; // Allow sort
		$this->fields['Gol'] = &$this->Gol;

		// TMTJafung
		$this->TMTJafung = new DbField('tblDosen', 'tblDosen', 'x_TMTJafung', 'TMTJafung', '[TMTJafung]', CastDateFieldForLike("[TMTJafung]", 0, "DB"), 135, 8, 0, FALSE, '[TMTJafung]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->TMTJafung->Sortable = TRUE; // Allow sort
		$this->TMTJafung->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['TMTJafung'] = &$this->TMTJafung;

		// PendidikanTerakhir
		$this->PendidikanTerakhir = new DbField('tblDosen', 'tblDosen', 'x_PendidikanTerakhir', 'PendidikanTerakhir', '[PendidikanTerakhir]', '[PendidikanTerakhir]', 200, 10, -1, FALSE, '[PendidikanTerakhir]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->PendidikanTerakhir->Sortable = TRUE; // Allow sort
		$this->fields['PendidikanTerakhir'] = &$this->PendidikanTerakhir;

		// Status_Dosen
		$this->Status_Dosen = new DbField('tblDosen', 'tblDosen', 'x_Status_Dosen', 'Status_Dosen', '[Status_Dosen]', '[Status_Dosen]', 200, 20, -1, FALSE, '[Status_Dosen]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Status_Dosen->Sortable = TRUE; // Allow sort
		$this->fields['Status_Dosen'] = &$this->Status_Dosen;

		// Kode_Jp
		$this->Kode_Jp = new DbField('tblDosen', 'tblDosen', 'x_Kode_Jp', 'Kode_Jp', '[Kode_Jp]', '[Kode_Jp]', 129, 4, -1, FALSE, '[Kode_Jp]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->Kode_Jp->Sortable = TRUE; // Allow sort
		$this->Kode_Jp->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->Kode_Jp->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
		$this->Kode_Jp->Lookup = new Lookup('Kode_Jp', 'TblJurusan', FALSE, 'Kode_Jp', ["Program","Jurusan","",""], [], [], [], [], [], [], '', '');
		$this->fields['Kode_Jp'] = &$this->Kode_Jp;

		// photo
		$this->photo = new DbField('tblDosen', 'tblDosen', 'x_photo', 'photo', '[photo]', '[photo]', 205, 0, -1, TRUE, '[photo]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'FILE');
		$this->photo->Sortable = TRUE; // Allow sort
		$this->fields['photo'] = &$this->photo;

		// PictureName
		$this->PictureName = new DbField('tblDosen', 'tblDosen', 'x_PictureName', 'PictureName', '[PictureName]', '[PictureName]', 200, 50, -1, FALSE, '[PictureName]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->PictureName->Sortable = TRUE; // Allow sort
		$this->fields['PictureName'] = &$this->PictureName;

		// PictureSize
		$this->PictureSize = new DbField('tblDosen', 'tblDosen', 'x_PictureSize', 'PictureSize', '[PictureSize]', 'CAST([PictureSize] AS NVARCHAR)', 131, 8, -1, FALSE, '[PictureSize]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->PictureSize->Sortable = TRUE; // Allow sort
		$this->PictureSize->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['PictureSize'] = &$this->PictureSize;

		// PictureType
		$this->PictureType = new DbField('tblDosen', 'tblDosen', 'x_PictureType', 'PictureType', '[PictureType]', '[PictureType]', 200, 50, -1, FALSE, '[PictureType]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->PictureType->Sortable = TRUE; // Allow sort
		$this->fields['PictureType'] = &$this->PictureType;

		// PictureWidth
		$this->PictureWidth = new DbField('tblDosen', 'tblDosen', 'x_PictureWidth', 'PictureWidth', '[PictureWidth]', 'CAST([PictureWidth] AS NVARCHAR)', 131, 8, -1, FALSE, '[PictureWidth]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->PictureWidth->Sortable = TRUE; // Allow sort
		$this->PictureWidth->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['PictureWidth'] = &$this->PictureWidth;

		// PictureHeight
		$this->PictureHeight = new DbField('tblDosen', 'tblDosen', 'x_PictureHeight', 'PictureHeight', '[PictureHeight]', 'CAST([PictureHeight] AS NVARCHAR)', 131, 8, -1, FALSE, '[PictureHeight]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->PictureHeight->Sortable = TRUE; // Allow sort
		$this->PictureHeight->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['PictureHeight'] = &$this->PictureHeight;

		// Norek
		$this->Norek = new DbField('tblDosen', 'tblDosen', 'x_Norek', 'Norek', '[Norek]', '[Norek]', 200, 20, -1, FALSE, '[Norek]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Norek->Sortable = TRUE; // Allow sort
		$this->fields['Norek'] = &$this->Norek;

		// Password
		$this->Password = new DbField('tblDosen', 'tblDosen', 'x_Password', 'Password', '[Password]', '[Password]', 200, 32, -1, FALSE, '[Password]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Password->Sortable = TRUE; // Allow sort
		$this->fields['Password'] = &$this->Password;

		// NPWP
		$this->NPWP = new DbField('tblDosen', 'tblDosen', 'x_NPWP', 'NPWP', '[NPWP]', '[NPWP]', 200, 30, -1, FALSE, '[NPWP]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->NPWP->Sortable = TRUE; // Allow sort
		$this->fields['NPWP'] = &$this->NPWP;

		// Email
		$this->_Email = new DbField('tblDosen', 'tblDosen', 'x__Email', 'Email', '[Email]', '[Email]', 200, 50, -1, FALSE, '[Email]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_Email->Sortable = TRUE; // Allow sort
		$this->fields['Email'] = &$this->_Email;

		// KewajibanSKS
		$this->KewajibanSKS = new DbField('tblDosen', 'tblDosen', 'x_KewajibanSKS', 'KewajibanSKS', '[KewajibanSKS]', 'CAST([KewajibanSKS] AS NVARCHAR)', 3, 4, -1, FALSE, '[KewajibanSKS]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->KewajibanSKS->Sortable = TRUE; // Allow sort
		$this->KewajibanSKS->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['KewajibanSKS'] = &$this->KewajibanSKS;

		// IDFIng
		$this->IDFIng = new DbField('tblDosen', 'tblDosen', 'x_IDFIng', 'IDFIng', '[IDFIng]', '[IDFIng]', 200, 24, -1, FALSE, '[IDFIng]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->IDFIng->Sortable = TRUE; // Allow sort
		$this->fields['IDFIng'] = &$this->IDFIng;

		// Profile
		$this->Profile = new DbField('tblDosen', 'tblDosen', 'x_Profile', 'Profile', '[Profile]', '[Profile]', 200, 0, -1, FALSE, '[Profile]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Profile->Sortable = TRUE; // Allow sort
		$this->fields['Profile'] = &$this->Profile;

		// ttd
		$this->ttd = new DbField('tblDosen', 'tblDosen', 'x_ttd', 'ttd', '[ttd]', '[ttd]', 200, 100, -1, TRUE, '[ttd]', FALSE, FALSE, FALSE, 'IMAGE', 'FILE');
		$this->ttd->Sortable = TRUE; // Allow sort
		$this->fields['ttd'] = &$this->ttd;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Single column sort
	public function updateSort(&$fld)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
		} else {
			$fld->setSort("");
		}
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom != "") ? $this->SqlFrom : "[dbo].[tblDosen]";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect != "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy != "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving != "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter, $id = "")
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = $this->UserIDAllowSecurity;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 32) == 32);
			case "search":
				return (($allow & 64) == 64);
			case "lookup":
				return (($allow & 256) == 256);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get recordset
	public function getRecordset($sql, $rowcnt = -1, $offset = -1)
	{
		$conn = $this->getConnection();
		$conn->raiseErrorFn = Config("ERROR_FUNC");
		$rs = $conn->selectLimit($sql, $rowcnt, $offset);
		$conn->raiseErrorFn = "";
		return $rs;
	}

	// Get record count
	public function getRecordCount($sql, $c = NULL)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) &&
			!preg_match('/^\s*select\s+distinct\s+/i', $sql) && !preg_match('/\s+order\s+by\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = $c ?: $this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->getSqlSelect();
		$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " (" . $names . ") VALUES (" . $values . ")";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = $this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsAutoIncrement)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter != "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = $this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('NIDN', $rs))
				AddFilter($where, QuotedName('NIDN', $this->Dbid) . '=' . QuotedValue($rs['NIDN'], $this->NIDN->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter != "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = $this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->NIDN->DbValue = $row['NIDN'];
		$this->Nama->DbValue = $row['Nama'];
		$this->Status->DbValue = $row['Status'];
		$this->NoSKStatus->DbValue = $row['NoSKStatus'];
		$this->TMTKerja->DbValue = $row['TMTKerja'];
		$this->NoKtp->DbValue = $row['NoKtp'];
		$this->Tmp_Lahir->DbValue = $row['Tmp_Lahir'];
		$this->Tgl_Lahir->DbValue = $row['Tgl_Lahir'];
		$this->Kelamin->DbValue = $row['Kelamin'];
		$this->Alamat->DbValue = $row['Alamat'];
		$this->Kelurahan->DbValue = $row['Kelurahan'];
		$this->Kecamatan->DbValue = $row['Kecamatan'];
		$this->Kota->DbValue = $row['Kota'];
		$this->Kode_pos->DbValue = $row['Kode_pos'];
		$this->Phone->DbValue = $row['Phone'];
		$this->TlpRumah->DbValue = $row['TlpRumah'];
		$this->KodeJafung->DbValue = $row['KodeJafung'];
		$this->Gol->DbValue = $row['Gol'];
		$this->TMTJafung->DbValue = $row['TMTJafung'];
		$this->PendidikanTerakhir->DbValue = $row['PendidikanTerakhir'];
		$this->Status_Dosen->DbValue = $row['Status_Dosen'];
		$this->Kode_Jp->DbValue = $row['Kode_Jp'];
		$this->photo->Upload->DbValue = $row['photo'];
		$this->PictureName->DbValue = $row['PictureName'];
		$this->PictureSize->DbValue = $row['PictureSize'];
		$this->PictureType->DbValue = $row['PictureType'];
		$this->PictureWidth->DbValue = $row['PictureWidth'];
		$this->PictureHeight->DbValue = $row['PictureHeight'];
		$this->Norek->DbValue = $row['Norek'];
		$this->Password->DbValue = $row['Password'];
		$this->NPWP->DbValue = $row['NPWP'];
		$this->_Email->DbValue = $row['Email'];
		$this->KewajibanSKS->DbValue = $row['KewajibanSKS'];
		$this->IDFIng->DbValue = $row['IDFIng'];
		$this->Profile->DbValue = $row['Profile'];
		$this->ttd->Upload->DbValue = $row['ttd'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
		$this->ttd->OldUploadPath = 'files/ttd/';
		$oldFiles = EmptyValue($row['ttd']) ? [] : [$row['ttd']];
		foreach ($oldFiles as $oldFile) {
			if (file_exists($this->ttd->oldPhysicalUploadPath() . $oldFile))
				@unlink($this->ttd->oldPhysicalUploadPath() . $oldFile);
		}
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "[NIDN] = '@NIDN@'";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		if (is_array($row))
			$val = array_key_exists('NIDN', $row) ? $row['NIDN'] : NULL;
		else
			$val = $this->NIDN->OldValue !== NULL ? $this->NIDN->OldValue : $this->NIDN->CurrentValue;
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@NIDN@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") != "" && ReferPageName() != CurrentPageName() && ReferPageName() != "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] != "") {
			return $_SESSION[$name];
		} else {
			return "tblDosenlist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "tblDosenview.php")
			return $Language->phrase("View");
		elseif ($pageName == "tblDosenedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "tblDosenadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "tblDosenlist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm != "")
			$url = $this->keyUrl("tblDosenview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("tblDosenview.php", $this->getUrlParm(Config("TABLE_SHOW_DETAIL") . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm != "")
			$url = "tblDosenadd.php?" . $this->getUrlParm($parm);
		else
			$url = "tblDosenadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("tblDosenedit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("tblDosenadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("tblDosendelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "NIDN:" . JsonEncode($this->NIDN->CurrentValue, "string");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm != "")
			$url .= $parm . "&";
		if ($this->NIDN->CurrentValue != NULL) {
			$url .= "NIDN=" . urlencode($this->NIDN->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, [141, 201, 203, 128, 204, 205])) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		$arKeys = [];
		$arKey = [];
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("NIDN") !== NULL)
				$arKeys[] = Param("NIDN");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = [];
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys($setCurrent = TRUE)
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter != "") $keyFilter .= " OR ";
			if ($setCurrent)
				$this->NIDN->CurrentValue = $key;
			else
				$this->NIDN->OldValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = $this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->NIDN->setDbValue($rs->fields('NIDN'));
		$this->Nama->setDbValue($rs->fields('Nama'));
		$this->Status->setDbValue($rs->fields('Status'));
		$this->NoSKStatus->setDbValue($rs->fields('NoSKStatus'));
		$this->TMTKerja->setDbValue($rs->fields('TMTKerja'));
		$this->NoKtp->setDbValue($rs->fields('NoKtp'));
		$this->Tmp_Lahir->setDbValue($rs->fields('Tmp_Lahir'));
		$this->Tgl_Lahir->setDbValue($rs->fields('Tgl_Lahir'));
		$this->Kelamin->setDbValue($rs->fields('Kelamin'));
		$this->Alamat->setDbValue($rs->fields('Alamat'));
		$this->Kelurahan->setDbValue($rs->fields('Kelurahan'));
		$this->Kecamatan->setDbValue($rs->fields('Kecamatan'));
		$this->Kota->setDbValue($rs->fields('Kota'));
		$this->Kode_pos->setDbValue($rs->fields('Kode_pos'));
		$this->Phone->setDbValue($rs->fields('Phone'));
		$this->TlpRumah->setDbValue($rs->fields('TlpRumah'));
		$this->KodeJafung->setDbValue($rs->fields('KodeJafung'));
		$this->Gol->setDbValue($rs->fields('Gol'));
		$this->TMTJafung->setDbValue($rs->fields('TMTJafung'));
		$this->PendidikanTerakhir->setDbValue($rs->fields('PendidikanTerakhir'));
		$this->Status_Dosen->setDbValue($rs->fields('Status_Dosen'));
		$this->Kode_Jp->setDbValue($rs->fields('Kode_Jp'));
		$this->photo->Upload->DbValue = $rs->fields('photo');
		$this->PictureName->setDbValue($rs->fields('PictureName'));
		$this->PictureSize->setDbValue($rs->fields('PictureSize'));
		$this->PictureType->setDbValue($rs->fields('PictureType'));
		$this->PictureWidth->setDbValue($rs->fields('PictureWidth'));
		$this->PictureHeight->setDbValue($rs->fields('PictureHeight'));
		$this->Norek->setDbValue($rs->fields('Norek'));
		$this->Password->setDbValue($rs->fields('Password'));
		$this->NPWP->setDbValue($rs->fields('NPWP'));
		$this->_Email->setDbValue($rs->fields('Email'));
		$this->KewajibanSKS->setDbValue($rs->fields('KewajibanSKS'));
		$this->IDFIng->setDbValue($rs->fields('IDFIng'));
		$this->Profile->setDbValue($rs->fields('Profile'));
		$this->ttd->Upload->DbValue = $rs->fields('ttd');
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// NIDN
		// Nama
		// Status
		// NoSKStatus
		// TMTKerja
		// NoKtp
		// Tmp_Lahir
		// Tgl_Lahir
		// Kelamin
		// Alamat
		// Kelurahan
		// Kecamatan
		// Kota
		// Kode_pos
		// Phone
		// TlpRumah
		// KodeJafung
		// Gol
		// TMTJafung
		// PendidikanTerakhir
		// Status_Dosen
		// Kode_Jp
		// photo
		// PictureName
		// PictureSize
		// PictureType
		// PictureWidth
		// PictureHeight
		// Norek
		// Password
		// NPWP
		// Email
		// KewajibanSKS
		// IDFIng
		// Profile
		// ttd
		// NIDN

		$this->NIDN->ViewValue = $this->NIDN->CurrentValue;
		$this->NIDN->ViewCustomAttributes = "";

		// Nama
		$this->Nama->ViewValue = $this->Nama->CurrentValue;
		$this->Nama->ViewCustomAttributes = "";

		// Status
		if (strval($this->Status->CurrentValue) != "") {
			$this->Status->ViewValue = $this->Status->optionCaption($this->Status->CurrentValue);
		} else {
			$this->Status->ViewValue = NULL;
		}
		$this->Status->ViewCustomAttributes = "";

		// NoSKStatus
		$this->NoSKStatus->ViewValue = $this->NoSKStatus->CurrentValue;
		$this->NoSKStatus->ViewCustomAttributes = "";

		// TMTKerja
		$this->TMTKerja->ViewValue = $this->TMTKerja->CurrentValue;
		$this->TMTKerja->ViewValue = FormatDateTime($this->TMTKerja->ViewValue, 0);
		$this->TMTKerja->ViewCustomAttributes = "";

		// NoKtp
		$this->NoKtp->ViewValue = $this->NoKtp->CurrentValue;
		$this->NoKtp->ViewCustomAttributes = "";

		// Tmp_Lahir
		$this->Tmp_Lahir->ViewValue = $this->Tmp_Lahir->CurrentValue;
		$this->Tmp_Lahir->ViewCustomAttributes = "";

		// Tgl_Lahir
		$this->Tgl_Lahir->ViewValue = $this->Tgl_Lahir->CurrentValue;
		$this->Tgl_Lahir->ViewValue = FormatDateTime($this->Tgl_Lahir->ViewValue, 0);
		$this->Tgl_Lahir->ViewCustomAttributes = "";

		// Kelamin
		$this->Kelamin->ViewValue = $this->Kelamin->CurrentValue;
		$this->Kelamin->ViewCustomAttributes = "";

		// Alamat
		$this->Alamat->ViewValue = $this->Alamat->CurrentValue;
		$this->Alamat->ViewCustomAttributes = "";

		// Kelurahan
		$this->Kelurahan->ViewValue = $this->Kelurahan->CurrentValue;
		$this->Kelurahan->ViewCustomAttributes = "";

		// Kecamatan
		$this->Kecamatan->ViewValue = $this->Kecamatan->CurrentValue;
		$this->Kecamatan->ViewCustomAttributes = "";

		// Kota
		$this->Kota->ViewValue = $this->Kota->CurrentValue;
		$this->Kota->ViewCustomAttributes = "";

		// Kode_pos
		$this->Kode_pos->ViewValue = $this->Kode_pos->CurrentValue;
		$this->Kode_pos->ViewCustomAttributes = "";

		// Phone
		$this->Phone->ViewValue = $this->Phone->CurrentValue;
		$this->Phone->ViewCustomAttributes = "";

		// TlpRumah
		$this->TlpRumah->ViewValue = $this->TlpRumah->CurrentValue;
		$this->TlpRumah->ViewCustomAttributes = "";

		// KodeJafung
		$this->KodeJafung->ViewValue = $this->KodeJafung->CurrentValue;
		$this->KodeJafung->ViewCustomAttributes = "";

		// Gol
		$this->Gol->ViewValue = $this->Gol->CurrentValue;
		$this->Gol->ViewCustomAttributes = "";

		// TMTJafung
		$this->TMTJafung->ViewValue = $this->TMTJafung->CurrentValue;
		$this->TMTJafung->ViewValue = FormatDateTime($this->TMTJafung->ViewValue, 0);
		$this->TMTJafung->ViewCustomAttributes = "";

		// PendidikanTerakhir
		$this->PendidikanTerakhir->ViewValue = $this->PendidikanTerakhir->CurrentValue;
		$this->PendidikanTerakhir->ViewCustomAttributes = "";

		// Status_Dosen
		$this->Status_Dosen->ViewValue = $this->Status_Dosen->CurrentValue;
		$this->Status_Dosen->ViewCustomAttributes = "";

		// Kode_Jp
		$curVal = strval($this->Kode_Jp->CurrentValue);
		if ($curVal != "") {
			$this->Kode_Jp->ViewValue = $this->Kode_Jp->lookupCacheOption($curVal);
			if ($this->Kode_Jp->ViewValue === NULL) { // Lookup from database
				$filterWrk = "[Kode_Jp]" . SearchString("=", $curVal, DATATYPE_STRING, "");
				$sqlWrk = $this->Kode_Jp->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = [];
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->Kode_Jp->ViewValue = $this->Kode_Jp->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->Kode_Jp->ViewValue = $this->Kode_Jp->CurrentValue;
				}
			}
		} else {
			$this->Kode_Jp->ViewValue = NULL;
		}
		$this->Kode_Jp->ViewCustomAttributes = "";

		// photo
		if (!EmptyValue($this->photo->Upload->DbValue)) {
			$this->photo->ViewValue = $this->NIDN->CurrentValue;
			$this->photo->IsBlobImage = IsImageFile(ContentExtension($this->photo->Upload->DbValue));
		} else {
			$this->photo->ViewValue = "";
		}
		$this->photo->ViewCustomAttributes = "";

		// PictureName
		$this->PictureName->ViewValue = $this->PictureName->CurrentValue;
		$this->PictureName->ViewCustomAttributes = "";

		// PictureSize
		$this->PictureSize->ViewValue = $this->PictureSize->CurrentValue;
		$this->PictureSize->ViewValue = FormatNumber($this->PictureSize->ViewValue, 2, -2, -2, -2);
		$this->PictureSize->ViewCustomAttributes = "";

		// PictureType
		$this->PictureType->ViewValue = $this->PictureType->CurrentValue;
		$this->PictureType->ViewCustomAttributes = "";

		// PictureWidth
		$this->PictureWidth->ViewValue = $this->PictureWidth->CurrentValue;
		$this->PictureWidth->ViewValue = FormatNumber($this->PictureWidth->ViewValue, 2, -2, -2, -2);
		$this->PictureWidth->ViewCustomAttributes = "";

		// PictureHeight
		$this->PictureHeight->ViewValue = $this->PictureHeight->CurrentValue;
		$this->PictureHeight->ViewValue = FormatNumber($this->PictureHeight->ViewValue, 2, -2, -2, -2);
		$this->PictureHeight->ViewCustomAttributes = "";

		// Norek
		$this->Norek->ViewValue = $this->Norek->CurrentValue;
		$this->Norek->ViewCustomAttributes = "";

		// Password
		$this->Password->ViewValue = $this->Password->CurrentValue;
		$this->Password->ViewCustomAttributes = "";

		// NPWP
		$this->NPWP->ViewValue = $this->NPWP->CurrentValue;
		$this->NPWP->ViewCustomAttributes = "";

		// Email
		$this->_Email->ViewValue = $this->_Email->CurrentValue;
		$this->_Email->ViewCustomAttributes = "";

		// KewajibanSKS
		$this->KewajibanSKS->ViewValue = $this->KewajibanSKS->CurrentValue;
		$this->KewajibanSKS->ViewValue = FormatNumber($this->KewajibanSKS->ViewValue, 0, -2, -2, -2);
		$this->KewajibanSKS->ViewCustomAttributes = "";

		// IDFIng
		$this->IDFIng->ViewValue = $this->IDFIng->CurrentValue;
		$this->IDFIng->ViewCustomAttributes = "";

		// Profile
		$this->Profile->ViewValue = $this->Profile->CurrentValue;
		$this->Profile->ViewCustomAttributes = "";

		// ttd
		$this->ttd->UploadPath = 'files/ttd/';
		if (!EmptyValue($this->ttd->Upload->DbValue)) {
			$this->ttd->ImageWidth = 0;
			$this->ttd->ImageHeight = 90;
			$this->ttd->ImageAlt = $this->ttd->alt();
			$this->ttd->ViewValue = $this->ttd->Upload->DbValue;
		} else {
			$this->ttd->ViewValue = "";
		}
		$this->ttd->ViewCustomAttributes = "";

		// NIDN
		$this->NIDN->LinkCustomAttributes = "";
		$this->NIDN->HrefValue = "";
		$this->NIDN->TooltipValue = "";

		// Nama
		$this->Nama->LinkCustomAttributes = "";
		$this->Nama->HrefValue = "";
		$this->Nama->TooltipValue = "";

		// Status
		$this->Status->LinkCustomAttributes = "";
		$this->Status->HrefValue = "";
		$this->Status->TooltipValue = "";

		// NoSKStatus
		$this->NoSKStatus->LinkCustomAttributes = "";
		$this->NoSKStatus->HrefValue = "";
		$this->NoSKStatus->TooltipValue = "";

		// TMTKerja
		$this->TMTKerja->LinkCustomAttributes = "";
		$this->TMTKerja->HrefValue = "";
		$this->TMTKerja->TooltipValue = "";

		// NoKtp
		$this->NoKtp->LinkCustomAttributes = "";
		$this->NoKtp->HrefValue = "";
		$this->NoKtp->TooltipValue = "";

		// Tmp_Lahir
		$this->Tmp_Lahir->LinkCustomAttributes = "";
		$this->Tmp_Lahir->HrefValue = "";
		$this->Tmp_Lahir->TooltipValue = "";

		// Tgl_Lahir
		$this->Tgl_Lahir->LinkCustomAttributes = "";
		$this->Tgl_Lahir->HrefValue = "";
		$this->Tgl_Lahir->TooltipValue = "";

		// Kelamin
		$this->Kelamin->LinkCustomAttributes = "";
		$this->Kelamin->HrefValue = "";
		$this->Kelamin->TooltipValue = "";

		// Alamat
		$this->Alamat->LinkCustomAttributes = "";
		$this->Alamat->HrefValue = "";
		$this->Alamat->TooltipValue = "";

		// Kelurahan
		$this->Kelurahan->LinkCustomAttributes = "";
		$this->Kelurahan->HrefValue = "";
		$this->Kelurahan->TooltipValue = "";

		// Kecamatan
		$this->Kecamatan->LinkCustomAttributes = "";
		$this->Kecamatan->HrefValue = "";
		$this->Kecamatan->TooltipValue = "";

		// Kota
		$this->Kota->LinkCustomAttributes = "";
		$this->Kota->HrefValue = "";
		$this->Kota->TooltipValue = "";

		// Kode_pos
		$this->Kode_pos->LinkCustomAttributes = "";
		$this->Kode_pos->HrefValue = "";
		$this->Kode_pos->TooltipValue = "";

		// Phone
		$this->Phone->LinkCustomAttributes = "";
		$this->Phone->HrefValue = "";
		$this->Phone->TooltipValue = "";

		// TlpRumah
		$this->TlpRumah->LinkCustomAttributes = "";
		$this->TlpRumah->HrefValue = "";
		$this->TlpRumah->TooltipValue = "";

		// KodeJafung
		$this->KodeJafung->LinkCustomAttributes = "";
		$this->KodeJafung->HrefValue = "";
		$this->KodeJafung->TooltipValue = "";

		// Gol
		$this->Gol->LinkCustomAttributes = "";
		$this->Gol->HrefValue = "";
		$this->Gol->TooltipValue = "";

		// TMTJafung
		$this->TMTJafung->LinkCustomAttributes = "";
		$this->TMTJafung->HrefValue = "";
		$this->TMTJafung->TooltipValue = "";

		// PendidikanTerakhir
		$this->PendidikanTerakhir->LinkCustomAttributes = "";
		$this->PendidikanTerakhir->HrefValue = "";
		$this->PendidikanTerakhir->TooltipValue = "";

		// Status_Dosen
		$this->Status_Dosen->LinkCustomAttributes = "";
		$this->Status_Dosen->HrefValue = "";
		$this->Status_Dosen->TooltipValue = "";

		// Kode_Jp
		$this->Kode_Jp->LinkCustomAttributes = "";
		$this->Kode_Jp->HrefValue = "";
		$this->Kode_Jp->TooltipValue = "";

		// photo
		$this->photo->LinkCustomAttributes = "";
		if (!empty($this->photo->Upload->DbValue)) {
			$this->photo->HrefValue = GetFileUploadUrl($this->photo, $this->NIDN->CurrentValue);
			$this->photo->LinkAttrs["target"] = "";
			if ($this->photo->IsBlobImage && empty($this->photo->LinkAttrs["target"]))
				$this->photo->LinkAttrs["target"] = "_blank";
			if ($this->isExport())
				$this->photo->HrefValue = FullUrl($this->photo->HrefValue, "href");
		} else {
			$this->photo->HrefValue = "";
		}
		$this->photo->ExportHrefValue = GetFileUploadUrl($this->photo, $this->NIDN->CurrentValue);
		$this->photo->TooltipValue = "";

		// PictureName
		$this->PictureName->LinkCustomAttributes = "";
		$this->PictureName->HrefValue = "";
		$this->PictureName->TooltipValue = "";

		// PictureSize
		$this->PictureSize->LinkCustomAttributes = "";
		$this->PictureSize->HrefValue = "";
		$this->PictureSize->TooltipValue = "";

		// PictureType
		$this->PictureType->LinkCustomAttributes = "";
		$this->PictureType->HrefValue = "";
		$this->PictureType->TooltipValue = "";

		// PictureWidth
		$this->PictureWidth->LinkCustomAttributes = "";
		$this->PictureWidth->HrefValue = "";
		$this->PictureWidth->TooltipValue = "";

		// PictureHeight
		$this->PictureHeight->LinkCustomAttributes = "";
		$this->PictureHeight->HrefValue = "";
		$this->PictureHeight->TooltipValue = "";

		// Norek
		$this->Norek->LinkCustomAttributes = "";
		$this->Norek->HrefValue = "";
		$this->Norek->TooltipValue = "";

		// Password
		$this->Password->LinkCustomAttributes = "";
		$this->Password->HrefValue = "";
		$this->Password->TooltipValue = "";

		// NPWP
		$this->NPWP->LinkCustomAttributes = "";
		$this->NPWP->HrefValue = "";
		$this->NPWP->TooltipValue = "";

		// Email
		$this->_Email->LinkCustomAttributes = "";
		$this->_Email->HrefValue = "";
		$this->_Email->TooltipValue = "";

		// KewajibanSKS
		$this->KewajibanSKS->LinkCustomAttributes = "";
		$this->KewajibanSKS->HrefValue = "";
		$this->KewajibanSKS->TooltipValue = "";

		// IDFIng
		$this->IDFIng->LinkCustomAttributes = "";
		$this->IDFIng->HrefValue = "";
		$this->IDFIng->TooltipValue = "";

		// Profile
		$this->Profile->LinkCustomAttributes = "";
		$this->Profile->HrefValue = "";
		$this->Profile->TooltipValue = "";

		// ttd
		$this->ttd->LinkCustomAttributes = "";
		$this->ttd->UploadPath = 'files/ttd/';
		if (!EmptyValue($this->ttd->Upload->DbValue)) {
			$this->ttd->HrefValue = GetFileUploadUrl($this->ttd, $this->ttd->htmlDecode($this->ttd->Upload->DbValue)); // Add prefix/suffix
			$this->ttd->LinkAttrs["target"] = "_blank"; // Add target
			if ($this->isExport())
				$this->ttd->HrefValue = FullUrl($this->ttd->HrefValue, "href");
		} else {
			$this->ttd->HrefValue = "";
		}
		$this->ttd->ExportHrefValue = $this->ttd->UploadPath . $this->ttd->Upload->DbValue;
		$this->ttd->TooltipValue = "";
		if ($this->ttd->UseColorbox) {
			if (EmptyValue($this->ttd->TooltipValue))
				$this->ttd->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
			$this->ttd->LinkAttrs["data-rel"] = "tblDosen_x_ttd";
			$this->ttd->LinkAttrs->appendClass("ew-lightbox");
		}

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// NIDN
		$this->NIDN->EditAttrs["class"] = "form-control";
		$this->NIDN->EditCustomAttributes = "";
		if (!$this->NIDN->Raw)
			$this->NIDN->CurrentValue = HtmlDecode($this->NIDN->CurrentValue);
		$this->NIDN->EditValue = $this->NIDN->CurrentValue;
		$this->NIDN->PlaceHolder = RemoveHtml($this->NIDN->caption());

		// Nama
		$this->Nama->EditAttrs["class"] = "form-control";
		$this->Nama->EditCustomAttributes = "";
		if (!$this->Nama->Raw)
			$this->Nama->CurrentValue = HtmlDecode($this->Nama->CurrentValue);
		$this->Nama->EditValue = $this->Nama->CurrentValue;
		$this->Nama->PlaceHolder = RemoveHtml($this->Nama->caption());

		// Status
		$this->Status->EditAttrs["class"] = "form-control";
		$this->Status->EditCustomAttributes = "";
		$this->Status->EditValue = $this->Status->options(TRUE);

		// NoSKStatus
		$this->NoSKStatus->EditAttrs["class"] = "form-control";
		$this->NoSKStatus->EditCustomAttributes = "";
		if (!$this->NoSKStatus->Raw)
			$this->NoSKStatus->CurrentValue = HtmlDecode($this->NoSKStatus->CurrentValue);
		$this->NoSKStatus->EditValue = $this->NoSKStatus->CurrentValue;
		$this->NoSKStatus->PlaceHolder = RemoveHtml($this->NoSKStatus->caption());

		// TMTKerja
		$this->TMTKerja->EditAttrs["class"] = "form-control";
		$this->TMTKerja->EditCustomAttributes = "";
		$this->TMTKerja->EditValue = FormatDateTime($this->TMTKerja->CurrentValue, 8);
		$this->TMTKerja->PlaceHolder = RemoveHtml($this->TMTKerja->caption());

		// NoKtp
		$this->NoKtp->EditAttrs["class"] = "form-control";
		$this->NoKtp->EditCustomAttributes = "";
		if (!$this->NoKtp->Raw)
			$this->NoKtp->CurrentValue = HtmlDecode($this->NoKtp->CurrentValue);
		$this->NoKtp->EditValue = $this->NoKtp->CurrentValue;
		$this->NoKtp->PlaceHolder = RemoveHtml($this->NoKtp->caption());

		// Tmp_Lahir
		$this->Tmp_Lahir->EditAttrs["class"] = "form-control";
		$this->Tmp_Lahir->EditCustomAttributes = "";
		if (!$this->Tmp_Lahir->Raw)
			$this->Tmp_Lahir->CurrentValue = HtmlDecode($this->Tmp_Lahir->CurrentValue);
		$this->Tmp_Lahir->EditValue = $this->Tmp_Lahir->CurrentValue;
		$this->Tmp_Lahir->PlaceHolder = RemoveHtml($this->Tmp_Lahir->caption());

		// Tgl_Lahir
		$this->Tgl_Lahir->EditAttrs["class"] = "form-control";
		$this->Tgl_Lahir->EditCustomAttributes = "";
		$this->Tgl_Lahir->EditValue = FormatDateTime($this->Tgl_Lahir->CurrentValue, 8);
		$this->Tgl_Lahir->PlaceHolder = RemoveHtml($this->Tgl_Lahir->caption());

		// Kelamin
		$this->Kelamin->EditAttrs["class"] = "form-control";
		$this->Kelamin->EditCustomAttributes = "";
		if (!$this->Kelamin->Raw)
			$this->Kelamin->CurrentValue = HtmlDecode($this->Kelamin->CurrentValue);
		$this->Kelamin->EditValue = $this->Kelamin->CurrentValue;
		$this->Kelamin->PlaceHolder = RemoveHtml($this->Kelamin->caption());

		// Alamat
		$this->Alamat->EditAttrs["class"] = "form-control";
		$this->Alamat->EditCustomAttributes = "";
		if (!$this->Alamat->Raw)
			$this->Alamat->CurrentValue = HtmlDecode($this->Alamat->CurrentValue);
		$this->Alamat->EditValue = $this->Alamat->CurrentValue;
		$this->Alamat->PlaceHolder = RemoveHtml($this->Alamat->caption());

		// Kelurahan
		$this->Kelurahan->EditAttrs["class"] = "form-control";
		$this->Kelurahan->EditCustomAttributes = "";
		if (!$this->Kelurahan->Raw)
			$this->Kelurahan->CurrentValue = HtmlDecode($this->Kelurahan->CurrentValue);
		$this->Kelurahan->EditValue = $this->Kelurahan->CurrentValue;
		$this->Kelurahan->PlaceHolder = RemoveHtml($this->Kelurahan->caption());

		// Kecamatan
		$this->Kecamatan->EditAttrs["class"] = "form-control";
		$this->Kecamatan->EditCustomAttributes = "";
		if (!$this->Kecamatan->Raw)
			$this->Kecamatan->CurrentValue = HtmlDecode($this->Kecamatan->CurrentValue);
		$this->Kecamatan->EditValue = $this->Kecamatan->CurrentValue;
		$this->Kecamatan->PlaceHolder = RemoveHtml($this->Kecamatan->caption());

		// Kota
		$this->Kota->EditAttrs["class"] = "form-control";
		$this->Kota->EditCustomAttributes = "";
		if (!$this->Kota->Raw)
			$this->Kota->CurrentValue = HtmlDecode($this->Kota->CurrentValue);
		$this->Kota->EditValue = $this->Kota->CurrentValue;
		$this->Kota->PlaceHolder = RemoveHtml($this->Kota->caption());

		// Kode_pos
		$this->Kode_pos->EditAttrs["class"] = "form-control";
		$this->Kode_pos->EditCustomAttributes = "";
		if (!$this->Kode_pos->Raw)
			$this->Kode_pos->CurrentValue = HtmlDecode($this->Kode_pos->CurrentValue);
		$this->Kode_pos->EditValue = $this->Kode_pos->CurrentValue;
		$this->Kode_pos->PlaceHolder = RemoveHtml($this->Kode_pos->caption());

		// Phone
		$this->Phone->EditAttrs["class"] = "form-control";
		$this->Phone->EditCustomAttributes = "";
		if (!$this->Phone->Raw)
			$this->Phone->CurrentValue = HtmlDecode($this->Phone->CurrentValue);
		$this->Phone->EditValue = $this->Phone->CurrentValue;
		$this->Phone->PlaceHolder = RemoveHtml($this->Phone->caption());

		// TlpRumah
		$this->TlpRumah->EditAttrs["class"] = "form-control";
		$this->TlpRumah->EditCustomAttributes = "";
		if (!$this->TlpRumah->Raw)
			$this->TlpRumah->CurrentValue = HtmlDecode($this->TlpRumah->CurrentValue);
		$this->TlpRumah->EditValue = $this->TlpRumah->CurrentValue;
		$this->TlpRumah->PlaceHolder = RemoveHtml($this->TlpRumah->caption());

		// KodeJafung
		$this->KodeJafung->EditAttrs["class"] = "form-control";
		$this->KodeJafung->EditCustomAttributes = "";
		if (!$this->KodeJafung->Raw)
			$this->KodeJafung->CurrentValue = HtmlDecode($this->KodeJafung->CurrentValue);
		$this->KodeJafung->EditValue = $this->KodeJafung->CurrentValue;
		$this->KodeJafung->PlaceHolder = RemoveHtml($this->KodeJafung->caption());

		// Gol
		$this->Gol->EditAttrs["class"] = "form-control";
		$this->Gol->EditCustomAttributes = "";
		if (!$this->Gol->Raw)
			$this->Gol->CurrentValue = HtmlDecode($this->Gol->CurrentValue);
		$this->Gol->EditValue = $this->Gol->CurrentValue;
		$this->Gol->PlaceHolder = RemoveHtml($this->Gol->caption());

		// TMTJafung
		$this->TMTJafung->EditAttrs["class"] = "form-control";
		$this->TMTJafung->EditCustomAttributes = "";
		$this->TMTJafung->EditValue = FormatDateTime($this->TMTJafung->CurrentValue, 8);
		$this->TMTJafung->PlaceHolder = RemoveHtml($this->TMTJafung->caption());

		// PendidikanTerakhir
		$this->PendidikanTerakhir->EditAttrs["class"] = "form-control";
		$this->PendidikanTerakhir->EditCustomAttributes = "";
		if (!$this->PendidikanTerakhir->Raw)
			$this->PendidikanTerakhir->CurrentValue = HtmlDecode($this->PendidikanTerakhir->CurrentValue);
		$this->PendidikanTerakhir->EditValue = $this->PendidikanTerakhir->CurrentValue;
		$this->PendidikanTerakhir->PlaceHolder = RemoveHtml($this->PendidikanTerakhir->caption());

		// Status_Dosen
		$this->Status_Dosen->EditAttrs["class"] = "form-control";
		$this->Status_Dosen->EditCustomAttributes = "";
		if (!$this->Status_Dosen->Raw)
			$this->Status_Dosen->CurrentValue = HtmlDecode($this->Status_Dosen->CurrentValue);
		$this->Status_Dosen->EditValue = $this->Status_Dosen->CurrentValue;
		$this->Status_Dosen->PlaceHolder = RemoveHtml($this->Status_Dosen->caption());

		// Kode_Jp
		$this->Kode_Jp->EditAttrs["class"] = "form-control";
		$this->Kode_Jp->EditCustomAttributes = "";

		// photo
		$this->photo->EditAttrs["class"] = "form-control";
		$this->photo->EditCustomAttributes = "";
		if (!EmptyValue($this->photo->Upload->DbValue)) {
			$this->photo->EditValue = $this->NIDN->CurrentValue;
			$this->photo->IsBlobImage = IsImageFile(ContentExtension($this->photo->Upload->DbValue));
		} else {
			$this->photo->EditValue = "";
		}

		// PictureName
		$this->PictureName->EditAttrs["class"] = "form-control";
		$this->PictureName->EditCustomAttributes = "";
		if (!$this->PictureName->Raw)
			$this->PictureName->CurrentValue = HtmlDecode($this->PictureName->CurrentValue);
		$this->PictureName->EditValue = $this->PictureName->CurrentValue;
		$this->PictureName->PlaceHolder = RemoveHtml($this->PictureName->caption());

		// PictureSize
		$this->PictureSize->EditAttrs["class"] = "form-control";
		$this->PictureSize->EditCustomAttributes = "";
		$this->PictureSize->EditValue = $this->PictureSize->CurrentValue;
		$this->PictureSize->PlaceHolder = RemoveHtml($this->PictureSize->caption());
		if (strval($this->PictureSize->EditValue) != "" && is_numeric($this->PictureSize->EditValue))
			$this->PictureSize->EditValue = FormatNumber($this->PictureSize->EditValue, -2, -2, -2, -2);
		

		// PictureType
		$this->PictureType->EditAttrs["class"] = "form-control";
		$this->PictureType->EditCustomAttributes = "";
		if (!$this->PictureType->Raw)
			$this->PictureType->CurrentValue = HtmlDecode($this->PictureType->CurrentValue);
		$this->PictureType->EditValue = $this->PictureType->CurrentValue;
		$this->PictureType->PlaceHolder = RemoveHtml($this->PictureType->caption());

		// PictureWidth
		$this->PictureWidth->EditAttrs["class"] = "form-control";
		$this->PictureWidth->EditCustomAttributes = "";
		$this->PictureWidth->EditValue = $this->PictureWidth->CurrentValue;
		$this->PictureWidth->PlaceHolder = RemoveHtml($this->PictureWidth->caption());
		if (strval($this->PictureWidth->EditValue) != "" && is_numeric($this->PictureWidth->EditValue))
			$this->PictureWidth->EditValue = FormatNumber($this->PictureWidth->EditValue, -2, -2, -2, -2);
		

		// PictureHeight
		$this->PictureHeight->EditAttrs["class"] = "form-control";
		$this->PictureHeight->EditCustomAttributes = "";
		$this->PictureHeight->EditValue = $this->PictureHeight->CurrentValue;
		$this->PictureHeight->PlaceHolder = RemoveHtml($this->PictureHeight->caption());
		if (strval($this->PictureHeight->EditValue) != "" && is_numeric($this->PictureHeight->EditValue))
			$this->PictureHeight->EditValue = FormatNumber($this->PictureHeight->EditValue, -2, -2, -2, -2);
		

		// Norek
		$this->Norek->EditAttrs["class"] = "form-control";
		$this->Norek->EditCustomAttributes = "";
		if (!$this->Norek->Raw)
			$this->Norek->CurrentValue = HtmlDecode($this->Norek->CurrentValue);
		$this->Norek->EditValue = $this->Norek->CurrentValue;
		$this->Norek->PlaceHolder = RemoveHtml($this->Norek->caption());

		// Password
		$this->Password->EditAttrs["class"] = "form-control";
		$this->Password->EditCustomAttributes = "";
		if (!$this->Password->Raw)
			$this->Password->CurrentValue = HtmlDecode($this->Password->CurrentValue);
		$this->Password->EditValue = $this->Password->CurrentValue;
		$this->Password->PlaceHolder = RemoveHtml($this->Password->caption());

		// NPWP
		$this->NPWP->EditAttrs["class"] = "form-control";
		$this->NPWP->EditCustomAttributes = "";
		if (!$this->NPWP->Raw)
			$this->NPWP->CurrentValue = HtmlDecode($this->NPWP->CurrentValue);
		$this->NPWP->EditValue = $this->NPWP->CurrentValue;
		$this->NPWP->PlaceHolder = RemoveHtml($this->NPWP->caption());

		// Email
		$this->_Email->EditAttrs["class"] = "form-control";
		$this->_Email->EditCustomAttributes = "";
		if (!$this->_Email->Raw)
			$this->_Email->CurrentValue = HtmlDecode($this->_Email->CurrentValue);
		$this->_Email->EditValue = $this->_Email->CurrentValue;
		$this->_Email->PlaceHolder = RemoveHtml($this->_Email->caption());

		// KewajibanSKS
		$this->KewajibanSKS->EditAttrs["class"] = "form-control";
		$this->KewajibanSKS->EditCustomAttributes = "";
		$this->KewajibanSKS->EditValue = $this->KewajibanSKS->CurrentValue;
		$this->KewajibanSKS->PlaceHolder = RemoveHtml($this->KewajibanSKS->caption());

		// IDFIng
		$this->IDFIng->EditAttrs["class"] = "form-control";
		$this->IDFIng->EditCustomAttributes = "";
		if (!$this->IDFIng->Raw)
			$this->IDFIng->CurrentValue = HtmlDecode($this->IDFIng->CurrentValue);
		$this->IDFIng->EditValue = $this->IDFIng->CurrentValue;
		$this->IDFIng->PlaceHolder = RemoveHtml($this->IDFIng->caption());

		// Profile
		$this->Profile->EditAttrs["class"] = "form-control";
		$this->Profile->EditCustomAttributes = "";
		if (!$this->Profile->Raw)
			$this->Profile->CurrentValue = HtmlDecode($this->Profile->CurrentValue);
		$this->Profile->EditValue = $this->Profile->CurrentValue;
		$this->Profile->PlaceHolder = RemoveHtml($this->Profile->caption());

		// ttd
		$this->ttd->EditAttrs["class"] = "form-control";
		$this->ttd->EditCustomAttributes = "";
		$this->ttd->UploadPath = 'files/ttd/';
		if (!EmptyValue($this->ttd->Upload->DbValue)) {
			$this->ttd->ImageWidth = 0;
			$this->ttd->ImageHeight = 90;
			$this->ttd->ImageAlt = $this->ttd->alt();
			$this->ttd->EditValue = $this->ttd->Upload->DbValue;
		} else {
			$this->ttd->EditValue = "";
		}
		if (!EmptyValue($this->ttd->CurrentValue))
				$this->ttd->Upload->FileName = $this->ttd->CurrentValue;

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->NIDN);
					$doc->exportCaption($this->Nama);
					$doc->exportCaption($this->Status);
					$doc->exportCaption($this->NoSKStatus);
					$doc->exportCaption($this->TMTKerja);
					$doc->exportCaption($this->NoKtp);
					$doc->exportCaption($this->Tmp_Lahir);
					$doc->exportCaption($this->Tgl_Lahir);
					$doc->exportCaption($this->Kelamin);
					$doc->exportCaption($this->Alamat);
					$doc->exportCaption($this->Kelurahan);
					$doc->exportCaption($this->Kecamatan);
					$doc->exportCaption($this->Kota);
					$doc->exportCaption($this->Kode_pos);
					$doc->exportCaption($this->Phone);
					$doc->exportCaption($this->TlpRumah);
					$doc->exportCaption($this->KodeJafung);
					$doc->exportCaption($this->Gol);
					$doc->exportCaption($this->TMTJafung);
					$doc->exportCaption($this->PendidikanTerakhir);
					$doc->exportCaption($this->Status_Dosen);
					$doc->exportCaption($this->Kode_Jp);
					$doc->exportCaption($this->photo);
					$doc->exportCaption($this->PictureName);
					$doc->exportCaption($this->PictureSize);
					$doc->exportCaption($this->PictureType);
					$doc->exportCaption($this->PictureWidth);
					$doc->exportCaption($this->PictureHeight);
					$doc->exportCaption($this->Norek);
					$doc->exportCaption($this->Password);
					$doc->exportCaption($this->NPWP);
					$doc->exportCaption($this->_Email);
					$doc->exportCaption($this->KewajibanSKS);
					$doc->exportCaption($this->IDFIng);
					$doc->exportCaption($this->Profile);
					$doc->exportCaption($this->ttd);
				} else {
					$doc->exportCaption($this->NIDN);
					$doc->exportCaption($this->Nama);
					$doc->exportCaption($this->Status);
					$doc->exportCaption($this->NoSKStatus);
					$doc->exportCaption($this->TMTKerja);
					$doc->exportCaption($this->NoKtp);
					$doc->exportCaption($this->Tmp_Lahir);
					$doc->exportCaption($this->Tgl_Lahir);
					$doc->exportCaption($this->Kelamin);
					$doc->exportCaption($this->Alamat);
					$doc->exportCaption($this->Kelurahan);
					$doc->exportCaption($this->Kecamatan);
					$doc->exportCaption($this->Kota);
					$doc->exportCaption($this->Kode_pos);
					$doc->exportCaption($this->Phone);
					$doc->exportCaption($this->TlpRumah);
					$doc->exportCaption($this->KodeJafung);
					$doc->exportCaption($this->Gol);
					$doc->exportCaption($this->TMTJafung);
					$doc->exportCaption($this->PendidikanTerakhir);
					$doc->exportCaption($this->Status_Dosen);
					$doc->exportCaption($this->Kode_Jp);
					$doc->exportCaption($this->PictureName);
					$doc->exportCaption($this->PictureSize);
					$doc->exportCaption($this->PictureType);
					$doc->exportCaption($this->PictureWidth);
					$doc->exportCaption($this->PictureHeight);
					$doc->exportCaption($this->Norek);
					$doc->exportCaption($this->Password);
					$doc->exportCaption($this->NPWP);
					$doc->exportCaption($this->_Email);
					$doc->exportCaption($this->KewajibanSKS);
					$doc->exportCaption($this->IDFIng);
					$doc->exportCaption($this->Profile);
					$doc->exportCaption($this->ttd);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->NIDN);
						$doc->exportField($this->Nama);
						$doc->exportField($this->Status);
						$doc->exportField($this->NoSKStatus);
						$doc->exportField($this->TMTKerja);
						$doc->exportField($this->NoKtp);
						$doc->exportField($this->Tmp_Lahir);
						$doc->exportField($this->Tgl_Lahir);
						$doc->exportField($this->Kelamin);
						$doc->exportField($this->Alamat);
						$doc->exportField($this->Kelurahan);
						$doc->exportField($this->Kecamatan);
						$doc->exportField($this->Kota);
						$doc->exportField($this->Kode_pos);
						$doc->exportField($this->Phone);
						$doc->exportField($this->TlpRumah);
						$doc->exportField($this->KodeJafung);
						$doc->exportField($this->Gol);
						$doc->exportField($this->TMTJafung);
						$doc->exportField($this->PendidikanTerakhir);
						$doc->exportField($this->Status_Dosen);
						$doc->exportField($this->Kode_Jp);
						$doc->exportField($this->photo);
						$doc->exportField($this->PictureName);
						$doc->exportField($this->PictureSize);
						$doc->exportField($this->PictureType);
						$doc->exportField($this->PictureWidth);
						$doc->exportField($this->PictureHeight);
						$doc->exportField($this->Norek);
						$doc->exportField($this->Password);
						$doc->exportField($this->NPWP);
						$doc->exportField($this->_Email);
						$doc->exportField($this->KewajibanSKS);
						$doc->exportField($this->IDFIng);
						$doc->exportField($this->Profile);
						$doc->exportField($this->ttd);
					} else {
						$doc->exportField($this->NIDN);
						$doc->exportField($this->Nama);
						$doc->exportField($this->Status);
						$doc->exportField($this->NoSKStatus);
						$doc->exportField($this->TMTKerja);
						$doc->exportField($this->NoKtp);
						$doc->exportField($this->Tmp_Lahir);
						$doc->exportField($this->Tgl_Lahir);
						$doc->exportField($this->Kelamin);
						$doc->exportField($this->Alamat);
						$doc->exportField($this->Kelurahan);
						$doc->exportField($this->Kecamatan);
						$doc->exportField($this->Kota);
						$doc->exportField($this->Kode_pos);
						$doc->exportField($this->Phone);
						$doc->exportField($this->TlpRumah);
						$doc->exportField($this->KodeJafung);
						$doc->exportField($this->Gol);
						$doc->exportField($this->TMTJafung);
						$doc->exportField($this->PendidikanTerakhir);
						$doc->exportField($this->Status_Dosen);
						$doc->exportField($this->Kode_Jp);
						$doc->exportField($this->PictureName);
						$doc->exportField($this->PictureSize);
						$doc->exportField($this->PictureType);
						$doc->exportField($this->PictureWidth);
						$doc->exportField($this->PictureHeight);
						$doc->exportField($this->Norek);
						$doc->exportField($this->Password);
						$doc->exportField($this->NPWP);
						$doc->exportField($this->_Email);
						$doc->exportField($this->KewajibanSKS);
						$doc->exportField($this->IDFIng);
						$doc->exportField($this->Profile);
						$doc->exportField($this->ttd);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0)
	{
		$width = ($width > 0) ? $width : Config("THUMBNAIL_DEFAULT_WIDTH");
		$height = ($height > 0) ? $height : Config("THUMBNAIL_DEFAULT_HEIGHT");

		// Set up field name / file name field / file type field
		$fldName = "";
		$fileNameFld = "";
		$fileTypeFld = "";
		if ($fldparm == 'photo') {
			$fldName = "photo";
		} elseif ($fldparm == 'ttd') {
			$fldName = "ttd";
			$fileNameFld = "ttd";
		} else {
			return FALSE; // Incorrect field
		}

		// Set up key values
		$ar = explode(Config("COMPOSITE_KEY_SEPARATOR"), $key);
		if (count($ar) == 1) {
			$this->NIDN->CurrentValue = $ar[0];
		} else {
			return FALSE; // Incorrect key
		}

		// Set up filter (WHERE Clause)
		$filter = $this->getRecordFilter();
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = $this->getConnection();
		$dbtype = GetConnectionType($this->Dbid);
		if (($rs = $conn->execute($sql)) && !$rs->EOF) {
			$val = $rs->fields($fldName);
			if (!EmptyValue($val)) {
				$fld = $this->fields[$fldName];

				// Binary data
				if ($fld->DataType == DATATYPE_BLOB) {
					if ($dbtype != "MYSQL") {
						if (is_array($val) || is_object($val)) // Byte array
							$val = BytesToString($val);
					}
					if ($resize)
						ResizeBinary($val, $width, $height);

					// Write file type
					if ($fileTypeFld != "" && !EmptyValue($rs->fields($fileTypeFld))) {
						AddHeader("Content-type", $rs->fields($fileTypeFld));
					} else {
						AddHeader("Content-type", ContentType($val));
					}

					// Write file name
					$downloadPdf = !Config("EMBED_PDF") && Config("DOWNLOAD_PDF_FILE");
					if ($fileNameFld != "" && !EmptyValue($rs->fields($fileNameFld))) {
						$fileName = $rs->fields($fileNameFld);
						$pathinfo = pathinfo($fileName);
						$ext = strtolower(@$pathinfo["extension"]);
						$isPdf = SameText($ext, "pdf");
						if ($downloadPdf || !$isPdf) // Skip header if not download PDF
							AddHeader("Content-Disposition", "attachment; filename=\"" . $fileName . "\"");
					} else {
						$ext = ContentExtension($val);
						$isPdf = SameText($ext, ".pdf");
						if ($isPdf && $downloadPdf) // Add header if download PDF
							AddHeader("Content-Disposition", "attachment; filename=\"" . $fileName . "\"");
					}

					// Write file data
					if (StartsString("PK", $val) && ContainsString($val, "[Content_Types].xml") &&
						ContainsString($val, "_rels") && ContainsString($val, "docProps")) { // Fix Office 2007 documents
						if (!EndsString("\0\0\0", $val)) // Not ends with 3 or 4 \0
							$val .= "\0\0\0\0";
					}

					// Clear any debug message
					if (ob_get_length())
						ob_end_clean();

					// Write binary data
					Write($val);

				// Upload to folder
				} else {
					if ($fld->UploadMultiple)
						$files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
					else
						$files = [$val];
					$data = [];
					$ar = [];
					foreach ($files as $file) {
						if (!EmptyValue($file))
							$ar[$file] = FullUrl($fld->hrefPath() . $file);
					}
					$data[$fld->Param] = $ar;
					WriteJson($data);
				}
			}
			$rs->close();
			return TRUE;
		}
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>