<?php
namespace PHPMaker2020\baak;

/**
 * Page class
 */
class tblDosen_list extends tblDosen
{

	// Page ID
	public $PageID = "list";

	// Project ID
	public $ProjectID = "{A09D3AFF-419C-4918-948A-A3C8469EA234}";

	// Table name
	public $TableName = 'tblDosen';

	// Page object name
	public $PageObjName = "tblDosen_list";

	// Grid form hidden field names
	public $FormName = "ftblDosenlist";
	public $FormActionName = "k_action";
	public $FormKeyName = "k_key";
	public $FormOldKeyName = "k_oldkey";
	public $FormBlankRowName = "k_blankrow";
	public $FormKeyCountName = "key_count";

	// Page URLs
	public $AddUrl;
	public $EditUrl;
	public $CopyUrl;
	public $DeleteUrl;
	public $ViewUrl;
	public $ListUrl;

	// Export URLs
	public $ExportPrintUrl;
	public $ExportHtmlUrl;
	public $ExportExcelUrl;
	public $ExportWordUrl;
	public $ExportXmlUrl;
	public $ExportCsvUrl;
	public $ExportPdfUrl;

	// Custom export
	public $ExportExcelCustom = FALSE;
	public $ExportWordCustom = FALSE;
	public $ExportPdfCustom = FALSE;
	public $ExportEmailCustom = FALSE;

	// Update URLs
	public $InlineAddUrl;
	public $InlineCopyUrl;
	public $InlineEditUrl;
	public $GridAddUrl;
	public $GridEditUrl;
	public $MultiDeleteUrl;
	public $MultiUpdateUrl;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken;

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading != "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading != "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		$url = CurrentPageName() . "?";
		if ($this->UseTokenInUrl)
			$url .= "t=" . $this->TableVar . "&"; // Add page token
		return $url;
	}

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = TRUE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message != "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fas fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage != "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fas fa-exclamation"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage != "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fas fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage != "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fas fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = [];

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message != "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage != "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage != "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage != "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header != "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer != "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(Config("TOKEN_NAME")) === NULL)
			return FALSE;
		$fn = Config("CHECK_TOKEN_FUNC");
		if (is_callable($fn))
			return $fn(Post(Config("TOKEN_NAME")), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = Config("CREATE_TOKEN_FUNC"); // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $DashboardReport;
		global $UserTable;

		// Check token
		$this->CheckToken = Config("CHECK_TOKEN");

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (tblDosen)
		if (!isset($GLOBALS["tblDosen"]) || get_class($GLOBALS["tblDosen"]) == PROJECT_NAMESPACE . "tblDosen") {
			$GLOBALS["tblDosen"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["tblDosen"];
		}

		// Initialize URLs
		$this->ExportPrintUrl = $this->pageUrl() . "export=print";
		$this->ExportExcelUrl = $this->pageUrl() . "export=excel";
		$this->ExportWordUrl = $this->pageUrl() . "export=word";
		$this->ExportPdfUrl = $this->pageUrl() . "export=pdf";
		$this->ExportHtmlUrl = $this->pageUrl() . "export=html";
		$this->ExportXmlUrl = $this->pageUrl() . "export=xml";
		$this->ExportCsvUrl = $this->pageUrl() . "export=csv";
		$this->AddUrl = "tblDosenadd.php";
		$this->InlineAddUrl = $this->pageUrl() . "action=add";
		$this->GridAddUrl = $this->pageUrl() . "action=gridadd";
		$this->GridEditUrl = $this->pageUrl() . "action=gridedit";
		$this->MultiDeleteUrl = "tblDosendelete.php";
		$this->MultiUpdateUrl = "tblDosenupdate.php";

		// Table object (Pass)
		if (!isset($GLOBALS['Pass']))
			$GLOBALS['Pass'] = new Pass();

		// Page ID (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'list');

		// Table name (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'tblDosen');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = $this->getConnection();

		// User table object (Pass)
		$UserTable = $UserTable ?: new Pass();

		// List options
		$this->ListOptions = new ListOptions();
		$this->ListOptions->TableVar = $this->TableVar;

		// Export options
		$this->ExportOptions = new ListOptions("div");
		$this->ExportOptions->TagClassName = "ew-export-option";

		// Import options
		$this->ImportOptions = new ListOptions("div");
		$this->ImportOptions->TagClassName = "ew-import-option";

		// Other options
		if (!$this->OtherOptions)
			$this->OtherOptions = new ListOptionsArray();
		$this->OtherOptions["addedit"] = new ListOptions("div");
		$this->OtherOptions["addedit"]->TagClassName = "ew-add-edit-option";
		$this->OtherOptions["detail"] = new ListOptions("div");
		$this->OtherOptions["detail"]->TagClassName = "ew-detail-option";
		$this->OtherOptions["action"] = new ListOptions("div");
		$this->OtherOptions["action"]->TagClassName = "ew-action-option";

		// Filter options
		$this->FilterOptions = new ListOptions("div");
		$this->FilterOptions->TagClassName = "ew-filter-option ftblDosenlistsrch";

		// List actions
		$this->ListActions = new ListActions();
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages, $DashboardReport;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $tblDosen;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, Config("EXPORT_CLASSES"))) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . Config("EXPORT_CLASSES." . $this->CustomExport);
			if (class_exists($class)) {
				$doc = new $class($tblDosen);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url != "") {
			if (!Config("DEBUG") && ob_get_length())
				ob_end_clean();
			SaveDebugMessage();
			AddHeader("Location", $url);
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = [];
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
		$this->ttd->OldUploadPath = 'files/ttd/';
		$this->ttd->UploadPath = $this->ttd->OldUploadPath;
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = [];
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {
								$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
									Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
									Config("API_FIELD_NAME") . "=" . $fld->Param . "&" .
									Config("API_KEY_NAME") . "=" . rawurlencode($this->getRecordKeyValue($ar)))); //*** need to add this? API may not be in the same folder
								$row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
								$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
									Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
									"fn=" . Encrypt($fld->physicalUploadPath() . $val)));
								$row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
							} else { // Multiple files
								$files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
								$ar = [];
								foreach ($files as $file) {
									$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
										Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
										"fn=" . Encrypt($fld->physicalUploadPath() . $file)));
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						if ($fld->DataType == DATATYPE_MEMO && $fld->MemoMaxLength > 0)
							$val = TruncateMemo($val, $fld->MemoMaxLength, $fld->TruncateMemoRemoveHtml);
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['NIDN'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
	}

	// Lookup data
	public function lookup()
	{
		global $Language, $Security;
		if (!isset($Language))
			$Language = new Language(Config("LANGUAGE_FOLDER"), Post("language", ""));

		// Set up API request
		if (!ValidApiRequest())
			return FALSE;
		$this->setupApiSecurity();

		// Get lookup object
		$fieldName = Post("field");
		if (!array_key_exists($fieldName, $this->fields))
			return FALSE;
		$lookupField = $this->fields[$fieldName];
		$lookup = $lookupField->Lookup;
		if ($lookup === NULL)
			return FALSE;
		$tbl = $lookup->getTable();
		if (!$Security->allowLookup(Config("PROJECT_ID") . $tbl->TableName)) // Lookup permission
			return FALSE;

		// Get lookup parameters
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Param("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
			$lookup->FilterFields = []; // Skip parent fields if any
			$lookup->FilterValues[] = $keys; // Lookup values
			$pageSize = -1; // Show all records
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect != "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter != "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy != "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson($this); // Use settings from current page
	}

	// Set up API security
	public function setupApiSecurity()
	{
		global $Security;

		// Setup security for API request
		if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
		$Security->loadCurrentUserLevel(Config("PROJECT_ID") . $this->TableName);
		if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
	}

	// Class variables
	public $ListOptions; // List options
	public $ExportOptions; // Export options
	public $SearchOptions; // Search options
	public $OtherOptions; // Other options
	public $FilterOptions; // Filter options
	public $ImportOptions; // Import options
	public $ListActions; // List actions
	public $SelectedCount = 0;
	public $SelectedIndex = 0;
	public $DisplayRecords = 15;
	public $StartRecord;
	public $StopRecord;
	public $TotalRecords = 0;
	public $RecordRange = 10;
	public $PageSizes = "15,30,90,-1"; // Page sizes (comma separated)
	public $DefaultSearchWhere = ""; // Default search WHERE clause
	public $SearchWhere = ""; // Search WHERE clause
	public $SearchPanelClass = "ew-search-panel collapse show"; // Search Panel class
	public $SearchRowCount = 0; // For extended search
	public $SearchColumnCount = 0; // For extended search
	public $SearchFieldsPerRow = 1; // For extended search
	public $RecordCount = 0; // Record count
	public $EditRowCount;
	public $StartRowCount = 1;
	public $RowCount = 0;
	public $Attrs = []; // Row attributes and cell attributes
	public $RowIndex = 0; // Row index
	public $KeyCount = 0; // Key count
	public $RowAction = ""; // Row action
	public $RowOldKey = ""; // Row old key (for copy)
	public $MultiColumnClass = "col-sm";
	public $MultiColumnEditClass = "w-100";
	public $DbMasterFilter = ""; // Master filter
	public $DbDetailFilter = ""; // Detail filter
	public $MasterRecordExists;
	public $MultiSelectKey;
	public $Command;
	public $RestoreSearch = FALSE;
	public $DetailPages;
	public $OldRecordset;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $CurrentForm,
			$FormError, $SearchError;

		// User profile
		$UserProfile = new UserProfile();

		// Security
		if (ValidApiRequest()) { // API request
			$this->setupApiSecurity(); // Set up API Security
			if (!$Security->canList()) {
				SetStatus(401); // Unauthorized
				return;
			}
		} else {
			$Security = new AdvancedSecurity();
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canList()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				$this->terminate(GetUrl("index.php"));
				return;
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();

		// Get export parameters
		$custom = "";
		if (Param("export") !== NULL) {
			$this->Export = Param("export");
			$custom = Param("custom", "");
		} elseif (IsPost()) {
			if (Post("exporttype") !== NULL)
				$this->Export = Post("exporttype");
			$custom = Post("custom", "");
		} elseif (Get("cmd") == "json") {
			$this->Export = Get("cmd");
		} else {
			$this->setExportReturnUrl(CurrentUrl());
		}
		$ExportFileName = $this->TableVar; // Get export file, used in header

		// Get custom export parameters
		if ($this->isExport() && $custom != "") {
			$this->CustomExport = $this->Export;
			$this->Export = "print";
		}
		$CustomExportType = $this->CustomExport;
		$ExportType = $this->Export; // Get export parameter, used in header

		// Update Export URLs
		if (Config("USE_PHPEXCEL"))
			$this->ExportExcelCustom = FALSE;
		if ($this->ExportExcelCustom)
			$this->ExportExcelUrl .= "&amp;custom=1";
		if (Config("USE_PHPWORD"))
			$this->ExportWordCustom = FALSE;
		if ($this->ExportWordCustom)
			$this->ExportWordUrl .= "&amp;custom=1";
		if ($this->ExportPdfCustom)
			$this->ExportPdfUrl .= "&amp;custom=1";
		$this->CurrentAction = Param("action"); // Set up current action

		// Get grid add count
		$gridaddcnt = Get(Config("TABLE_GRID_ADD_ROW_COUNT"), "");
		if (is_numeric($gridaddcnt) && $gridaddcnt > 0)
			$this->GridAddRowCount = $gridaddcnt;

		// Set up list options
		$this->setupListOptions();

		// Setup export options
		$this->setupExportOptions();
		$this->NIDN->setVisibility();
		$this->Nama->setVisibility();
		$this->Status->setVisibility();
		$this->NoSKStatus->Visible = FALSE;
		$this->TMTKerja->Visible = FALSE;
		$this->NoKtp->Visible = FALSE;
		$this->Tmp_Lahir->Visible = FALSE;
		$this->Tgl_Lahir->Visible = FALSE;
		$this->Kelamin->Visible = FALSE;
		$this->Alamat->Visible = FALSE;
		$this->Kelurahan->Visible = FALSE;
		$this->Kecamatan->Visible = FALSE;
		$this->Kota->Visible = FALSE;
		$this->Kode_pos->Visible = FALSE;
		$this->Phone->Visible = FALSE;
		$this->TlpRumah->Visible = FALSE;
		$this->KodeJafung->Visible = FALSE;
		$this->Gol->Visible = FALSE;
		$this->TMTJafung->Visible = FALSE;
		$this->PendidikanTerakhir->Visible = FALSE;
		$this->Status_Dosen->Visible = FALSE;
		$this->Kode_Jp->setVisibility();
		$this->photo->Visible = FALSE;
		$this->PictureName->Visible = FALSE;
		$this->PictureSize->Visible = FALSE;
		$this->PictureType->Visible = FALSE;
		$this->PictureWidth->Visible = FALSE;
		$this->PictureHeight->Visible = FALSE;
		$this->Norek->Visible = FALSE;
		$this->Password->Visible = FALSE;
		$this->NPWP->Visible = FALSE;
		$this->_Email->Visible = FALSE;
		$this->KewajibanSKS->Visible = FALSE;
		$this->IDFIng->Visible = FALSE;
		$this->Profile->Visible = FALSE;
		$this->ttd->setVisibility();
		$this->hideFieldsForAddEdit();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Setup other options
		$this->setupOtherOptions();

		// Set up custom action (compatible with old version)
		foreach ($this->CustomActions as $name => $action)
			$this->ListActions->add($name, $action);

		// Show checkbox column if multiple action
		foreach ($this->ListActions->Items as $listaction) {
			if ($listaction->Select == ACTION_MULTIPLE && $listaction->Allow) {
				$this->ListOptions["checkbox"]->Visible = TRUE;
				break;
			}
		}

		// Set up lookup cache
		$this->setupLookupOptions($this->Kode_Jp);

		// Search filters
		$srchAdvanced = ""; // Advanced search filter
		$srchBasic = ""; // Basic search filter
		$filter = "";

		// Get command
		$this->Command = strtolower(Get("cmd"));
		if ($this->isPageRequest()) { // Validate request

			// Process list action first
			if ($this->processListAction()) // Ajax request
				$this->terminate();

			// Set up records per page
			$this->setupDisplayRecords();

			// Handle reset command
			$this->resetCmd();

			// Set up Breadcrumb
			if (!$this->isExport())
				$this->setupBreadcrumb();

			// Check QueryString parameters
			if (Get("action") !== NULL) {
				$this->CurrentAction = Get("action");

				// Clear inline mode
				if ($this->isCancel())
					$this->clearInlineMode();

				// Switch to inline edit mode
				if ($this->isEdit())
					$this->inlineEditMode();
			} else {
				if (Post("action") !== NULL) {
					$this->CurrentAction = Post("action"); // Get action

					// Inline Update
					if (($this->isUpdate() || $this->isOverwrite()) && @$_SESSION[SESSION_INLINE_MODE] == "edit")
						$this->inlineUpdate();
				}
			}

			// Hide list options
			if ($this->isExport()) {
				$this->ListOptions->hideAllOptions(["sequence"]);
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			} elseif ($this->isGridAdd() || $this->isGridEdit()) {
				$this->ListOptions->hideAllOptions();
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			}

			// Hide options
			if ($this->isExport() || $this->CurrentAction) {
				$this->ExportOptions->hideAllOptions();
				$this->FilterOptions->hideAllOptions();
				$this->ImportOptions->hideAllOptions();
			}

			// Hide other options
			if ($this->isExport())
				$this->OtherOptions->hideAllOptions();

			// Get default search criteria
			AddFilter($this->DefaultSearchWhere, $this->basicSearchWhere(TRUE));
			AddFilter($this->DefaultSearchWhere, $this->advancedSearchWhere(TRUE));

			// Get basic search values
			$this->loadBasicSearchValues();

			// Get and validate search values for advanced search
			$this->loadSearchValues(); // Get search values

			// Process filter list
			if ($this->processFilterList())
				$this->terminate();
			if (!$this->validateSearch())
				$this->setFailureMessage($SearchError);

			// Restore search parms from Session if not searching / reset / export
			if (($this->isExport() || $this->Command != "search" && $this->Command != "reset" && $this->Command != "resetall") && $this->Command != "json" && $this->checkSearchParms())
				$this->restoreSearchParms();

			// Call Recordset SearchValidated event
			$this->Recordset_SearchValidated();

			// Set up sorting order
			$this->setupSortOrder();

			// Get basic search criteria
			if ($SearchError == "")
				$srchBasic = $this->basicSearchWhere();

			// Get search criteria for advanced search
			if ($SearchError == "")
				$srchAdvanced = $this->advancedSearchWhere();
		}

		// Restore display records
		if ($this->Command != "json" && $this->getRecordsPerPage() != "") {
			$this->DisplayRecords = $this->getRecordsPerPage(); // Restore from Session
		} else {
			$this->DisplayRecords = 15; // Load default
			$this->setRecordsPerPage($this->DisplayRecords); // Save default to Session
		}

		// Load Sorting Order
		if ($this->Command != "json")
			$this->loadSortOrder();

		// Load search default if no existing search criteria
		if (!$this->checkSearchParms()) {

			// Load basic search from default
			$this->BasicSearch->loadDefault();
			if ($this->BasicSearch->Keyword != "")
				$srchBasic = $this->basicSearchWhere();

			// Load advanced search from default
			if ($this->loadAdvancedSearchDefault()) {
				$srchAdvanced = $this->advancedSearchWhere();
			}
		}

		// Restore search settings from Session
		if ($SearchError == "")
			$this->loadAdvancedSearch();

		// Build search criteria
		AddFilter($this->SearchWhere, $srchAdvanced);
		AddFilter($this->SearchWhere, $srchBasic);

		// Call Recordset_Searching event
		$this->Recordset_Searching($this->SearchWhere);

		// Save search criteria
		if ($this->Command == "search" && !$this->RestoreSearch) {
			$this->setSearchWhere($this->SearchWhere); // Save to Session
			$this->StartRecord = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRecord);
		} elseif ($this->Command != "json") {
			$this->SearchWhere = $this->getSearchWhere();
		}

		// Build filter
		$filter = "";
		if (!$Security->canList())
			$filter = "(0=1)"; // Filter all records
		AddFilter($filter, $this->DbDetailFilter);
		AddFilter($filter, $this->SearchWhere);

		// Set up filter
		if ($this->Command == "json") {
			$this->UseSessionForListSql = FALSE; // Do not use session for ListSQL
			$this->CurrentFilter = $filter;
		} else {
			$this->setSessionWhere($filter);
			$this->CurrentFilter = "";
		}

		// Export data only
		if (!$this->CustomExport && in_array($this->Export, array_keys(Config("EXPORT_CLASSES")))) {
			$this->exportData();
			$this->terminate();
		}
		if ($this->isGridAdd()) {
			$this->CurrentFilter = "0=1";
			$this->StartRecord = 1;
			$this->DisplayRecords = $this->GridAddRowCount;
			$this->TotalRecords = $this->DisplayRecords;
			$this->StopRecord = $this->DisplayRecords;
		} else {
			$selectLimit = $this->UseSelectLimit;
			if ($selectLimit) {
				$this->TotalRecords = $this->listRecordCount();
			} else {
				if ($this->Recordset = $this->loadRecordset())
					$this->TotalRecords = $this->Recordset->RecordCount();
			}
			$this->StartRecord = 1;
			if ($this->DisplayRecords <= 0 || ($this->isExport() && $this->ExportAll)) // Display all records
				$this->DisplayRecords = $this->TotalRecords;
			if (!($this->isExport() && $this->ExportAll)) // Set up start record position
				$this->setupStartRecord();
			if ($selectLimit)
				$this->Recordset = $this->loadRecordset($this->StartRecord - 1, $this->DisplayRecords);

			// Set no record found message
			if (!$this->CurrentAction && $this->TotalRecords == 0) {
				if (!$Security->canList())
					$this->setWarningMessage(DeniedMessage());
				if ($this->SearchWhere == "0=101")
					$this->setWarningMessage($Language->phrase("EnterSearchCriteria"));
				else
					$this->setWarningMessage($Language->phrase("NoRecord"));
			}
		}

		// Search options
		$this->setupSearchOptions();

		// Set up search panel class
		if ($this->SearchWhere != "")
			AppendClass($this->SearchPanelClass, "show");

		// Normal return
		if (IsApi()) {
			$rows = $this->getRecordsFromRecordset($this->Recordset);
			$this->Recordset->close();
			WriteJson(["success" => TRUE, $this->TableVar => $rows, "totalRecordCount" => $this->TotalRecords]);
			$this->terminate(TRUE);
		}

		// Set up pager
		$this->Pager = new PrevNextPager($this->StartRecord, $this->getRecordsPerPage(), $this->TotalRecords, $this->PageSizes, $this->RecordRange, $this->AutoHidePager, $this->AutoHidePageSizeSelector);
	}

	// Set up number of records displayed per page
	protected function setupDisplayRecords()
	{
		$wrk = Get(Config("TABLE_REC_PER_PAGE"), "");
		if ($wrk != "") {
			if (is_numeric($wrk)) {
				$this->DisplayRecords = (int)$wrk;
			} else {
				if (SameText($wrk, "all")) { // Display all records
					$this->DisplayRecords = -1;
				} else {
					$this->DisplayRecords = 15; // Non-numeric, load default
				}
			}
			$this->setRecordsPerPage($this->DisplayRecords); // Save to Session

			// Reset start position
			$this->StartRecord = 1;
			$this->setStartRecordNumber($this->StartRecord);
		}
	}

	// Exit inline mode
	protected function clearInlineMode()
	{
		$this->setKey("NIDN", ""); // Clear inline edit key
		$this->LastAction = $this->CurrentAction; // Save last action
		$this->CurrentAction = ""; // Clear action
		$_SESSION[SESSION_INLINE_MODE] = ""; // Clear inline mode
	}

	// Switch to Inline Edit mode
	protected function inlineEditMode()
	{
		global $Security, $Language;
		if (!$Security->canEdit())
			return FALSE; // Edit not allowed
		$inlineEdit = TRUE;
		if (Get("NIDN") !== NULL) {
			$this->NIDN->setQueryStringValue(Get("NIDN"));
		} else {
			$inlineEdit = FALSE;
		}
		if ($inlineEdit) {
			if ($this->loadRow()) {
				$this->setKey("NIDN", $this->NIDN->CurrentValue); // Set up inline edit key
				$_SESSION[SESSION_INLINE_MODE] = "edit"; // Enable inline edit
			}
		}
		return TRUE;
	}

	// Perform update to Inline Edit record
	protected function inlineUpdate()
	{
		global $Language, $CurrentForm, $FormError;
		$CurrentForm->Index = 1;
		$this->loadFormValues(); // Get form values

		// Validate form
		$inlineUpdate = TRUE;
		if (!$this->validateForm()) {
			$inlineUpdate = FALSE; // Form error, reset action
			$this->setFailureMessage($FormError);
		} else {
			$inlineUpdate = FALSE;
			$rowkey = strval($CurrentForm->getValue($this->FormKeyName));
			if ($this->setupKeyValues($rowkey)) { // Set up key values
				if ($this->checkInlineEditKey()) { // Check key
					$this->SendEmail = TRUE; // Send email on update success
					$inlineUpdate = $this->editRow(); // Update record
				} else {
					$inlineUpdate = FALSE;
				}
			}
		}
		if ($inlineUpdate) { // Update success
			if ($this->getSuccessMessage() == "")
				$this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Set up success message
			$this->clearInlineMode(); // Clear inline edit mode
		} else {
			if ($this->getFailureMessage() == "")
				$this->setFailureMessage($Language->phrase("UpdateFailed")); // Set update failed message
			$this->EventCancelled = TRUE; // Cancel event
			$this->CurrentAction = "edit"; // Stay in edit mode
		}
	}

	// Check Inline Edit key
	public function checkInlineEditKey()
	{
		if ($this->EventCancelled)
			$this->NIDN->OldValue = $this->NIDN->DbValue;
		$val = $this->NIDN->OldValue !== NULL ? $this->NIDN->OldValue : $this->NIDN->CurrentValue;
		if (strval($this->getKey("NIDN")) != strval($val))
			return FALSE;
		return TRUE;
	}

	// Build filter for all keys
	protected function buildKeyFilter()
	{
		global $CurrentForm;
		$wrkFilter = "";

		// Update row index and get row key
		$rowindex = 1;
		$CurrentForm->Index = $rowindex;
		$thisKey = strval($CurrentForm->getValue($this->FormKeyName));
		while ($thisKey != "") {
			if ($this->setupKeyValues($thisKey)) {
				$filter = $this->getRecordFilter();
				if ($wrkFilter != "")
					$wrkFilter .= " OR ";
				$wrkFilter .= $filter;
			} else {
				$wrkFilter = "0=1";
				break;
			}

			// Update row index and get row key
			$rowindex++; // Next row
			$CurrentForm->Index = $rowindex;
			$thisKey = strval($CurrentForm->getValue($this->FormKeyName));
		}
		return $wrkFilter;
	}

	// Set up key values
	protected function setupKeyValues($key)
	{
		$arKeyFlds = explode(Config("COMPOSITE_KEY_SEPARATOR"), $key);
		if (count($arKeyFlds) >= 1) {
			$this->NIDN->setOldValue($arKeyFlds[0]);
		}
		return TRUE;
	}

	// Get list of filters
	public function getFilterList()
	{
		global $UserProfile;

		// Initialize
		$filterList = "";
		$savedFilterList = "";
		$filterList = Concat($filterList, $this->NIDN->AdvancedSearch->toJson(), ","); // Field NIDN
		$filterList = Concat($filterList, $this->Nama->AdvancedSearch->toJson(), ","); // Field Nama
		$filterList = Concat($filterList, $this->Status->AdvancedSearch->toJson(), ","); // Field Status
		$filterList = Concat($filterList, $this->NoSKStatus->AdvancedSearch->toJson(), ","); // Field NoSKStatus
		$filterList = Concat($filterList, $this->TMTKerja->AdvancedSearch->toJson(), ","); // Field TMTKerja
		$filterList = Concat($filterList, $this->NoKtp->AdvancedSearch->toJson(), ","); // Field NoKtp
		$filterList = Concat($filterList, $this->Tmp_Lahir->AdvancedSearch->toJson(), ","); // Field Tmp_Lahir
		$filterList = Concat($filterList, $this->Tgl_Lahir->AdvancedSearch->toJson(), ","); // Field Tgl_Lahir
		$filterList = Concat($filterList, $this->Kelamin->AdvancedSearch->toJson(), ","); // Field Kelamin
		$filterList = Concat($filterList, $this->Alamat->AdvancedSearch->toJson(), ","); // Field Alamat
		$filterList = Concat($filterList, $this->Kelurahan->AdvancedSearch->toJson(), ","); // Field Kelurahan
		$filterList = Concat($filterList, $this->Kecamatan->AdvancedSearch->toJson(), ","); // Field Kecamatan
		$filterList = Concat($filterList, $this->Kota->AdvancedSearch->toJson(), ","); // Field Kota
		$filterList = Concat($filterList, $this->Kode_pos->AdvancedSearch->toJson(), ","); // Field Kode_pos
		$filterList = Concat($filterList, $this->Phone->AdvancedSearch->toJson(), ","); // Field Phone
		$filterList = Concat($filterList, $this->TlpRumah->AdvancedSearch->toJson(), ","); // Field TlpRumah
		$filterList = Concat($filterList, $this->KodeJafung->AdvancedSearch->toJson(), ","); // Field KodeJafung
		$filterList = Concat($filterList, $this->Gol->AdvancedSearch->toJson(), ","); // Field Gol
		$filterList = Concat($filterList, $this->TMTJafung->AdvancedSearch->toJson(), ","); // Field TMTJafung
		$filterList = Concat($filterList, $this->PendidikanTerakhir->AdvancedSearch->toJson(), ","); // Field PendidikanTerakhir
		$filterList = Concat($filterList, $this->Status_Dosen->AdvancedSearch->toJson(), ","); // Field Status_Dosen
		$filterList = Concat($filterList, $this->Kode_Jp->AdvancedSearch->toJson(), ","); // Field Kode_Jp
		$filterList = Concat($filterList, $this->PictureName->AdvancedSearch->toJson(), ","); // Field PictureName
		$filterList = Concat($filterList, $this->PictureSize->AdvancedSearch->toJson(), ","); // Field PictureSize
		$filterList = Concat($filterList, $this->PictureType->AdvancedSearch->toJson(), ","); // Field PictureType
		$filterList = Concat($filterList, $this->PictureWidth->AdvancedSearch->toJson(), ","); // Field PictureWidth
		$filterList = Concat($filterList, $this->PictureHeight->AdvancedSearch->toJson(), ","); // Field PictureHeight
		$filterList = Concat($filterList, $this->Norek->AdvancedSearch->toJson(), ","); // Field Norek
		$filterList = Concat($filterList, $this->Password->AdvancedSearch->toJson(), ","); // Field Password
		$filterList = Concat($filterList, $this->NPWP->AdvancedSearch->toJson(), ","); // Field NPWP
		$filterList = Concat($filterList, $this->_Email->AdvancedSearch->toJson(), ","); // Field Email
		$filterList = Concat($filterList, $this->KewajibanSKS->AdvancedSearch->toJson(), ","); // Field KewajibanSKS
		$filterList = Concat($filterList, $this->IDFIng->AdvancedSearch->toJson(), ","); // Field IDFIng
		$filterList = Concat($filterList, $this->Profile->AdvancedSearch->toJson(), ","); // Field Profile
		$filterList = Concat($filterList, $this->ttd->AdvancedSearch->toJson(), ","); // Field ttd
		if ($this->BasicSearch->Keyword != "") {
			$wrk = "\"" . Config("TABLE_BASIC_SEARCH") . "\":\"" . JsEncode($this->BasicSearch->Keyword) . "\",\"" . Config("TABLE_BASIC_SEARCH_TYPE") . "\":\"" . JsEncode($this->BasicSearch->Type) . "\"";
			$filterList = Concat($filterList, $wrk, ",");
		}

		// Return filter list in JSON
		if ($filterList != "")
			$filterList = "\"data\":{" . $filterList . "}";
		if ($savedFilterList != "")
			$filterList = Concat($filterList, "\"filters\":" . $savedFilterList, ",");
		return ($filterList != "") ? "{" . $filterList . "}" : "null";
	}

	// Process filter list
	protected function processFilterList()
	{
		global $UserProfile;
		if (Post("ajax") == "savefilters") { // Save filter request (Ajax)
			$filters = Post("filters");
			$UserProfile->setSearchFilters(CurrentUserName(), "ftblDosenlistsrch", $filters);
			WriteJson([["success" => TRUE]]); // Success
			return TRUE;
		} elseif (Post("cmd") == "resetfilter") {
			$this->restoreFilterList();
		}
		return FALSE;
	}

	// Restore list of filters
	protected function restoreFilterList()
	{

		// Return if not reset filter
		if (Post("cmd") !== "resetfilter")
			return FALSE;
		$filter = json_decode(Post("filter"), TRUE);
		$this->Command = "search";

		// Field NIDN
		$this->NIDN->AdvancedSearch->SearchValue = @$filter["x_NIDN"];
		$this->NIDN->AdvancedSearch->SearchOperator = @$filter["z_NIDN"];
		$this->NIDN->AdvancedSearch->SearchCondition = @$filter["v_NIDN"];
		$this->NIDN->AdvancedSearch->SearchValue2 = @$filter["y_NIDN"];
		$this->NIDN->AdvancedSearch->SearchOperator2 = @$filter["w_NIDN"];
		$this->NIDN->AdvancedSearch->save();

		// Field Nama
		$this->Nama->AdvancedSearch->SearchValue = @$filter["x_Nama"];
		$this->Nama->AdvancedSearch->SearchOperator = @$filter["z_Nama"];
		$this->Nama->AdvancedSearch->SearchCondition = @$filter["v_Nama"];
		$this->Nama->AdvancedSearch->SearchValue2 = @$filter["y_Nama"];
		$this->Nama->AdvancedSearch->SearchOperator2 = @$filter["w_Nama"];
		$this->Nama->AdvancedSearch->save();

		// Field Status
		$this->Status->AdvancedSearch->SearchValue = @$filter["x_Status"];
		$this->Status->AdvancedSearch->SearchOperator = @$filter["z_Status"];
		$this->Status->AdvancedSearch->SearchCondition = @$filter["v_Status"];
		$this->Status->AdvancedSearch->SearchValue2 = @$filter["y_Status"];
		$this->Status->AdvancedSearch->SearchOperator2 = @$filter["w_Status"];
		$this->Status->AdvancedSearch->save();

		// Field NoSKStatus
		$this->NoSKStatus->AdvancedSearch->SearchValue = @$filter["x_NoSKStatus"];
		$this->NoSKStatus->AdvancedSearch->SearchOperator = @$filter["z_NoSKStatus"];
		$this->NoSKStatus->AdvancedSearch->SearchCondition = @$filter["v_NoSKStatus"];
		$this->NoSKStatus->AdvancedSearch->SearchValue2 = @$filter["y_NoSKStatus"];
		$this->NoSKStatus->AdvancedSearch->SearchOperator2 = @$filter["w_NoSKStatus"];
		$this->NoSKStatus->AdvancedSearch->save();

		// Field TMTKerja
		$this->TMTKerja->AdvancedSearch->SearchValue = @$filter["x_TMTKerja"];
		$this->TMTKerja->AdvancedSearch->SearchOperator = @$filter["z_TMTKerja"];
		$this->TMTKerja->AdvancedSearch->SearchCondition = @$filter["v_TMTKerja"];
		$this->TMTKerja->AdvancedSearch->SearchValue2 = @$filter["y_TMTKerja"];
		$this->TMTKerja->AdvancedSearch->SearchOperator2 = @$filter["w_TMTKerja"];
		$this->TMTKerja->AdvancedSearch->save();

		// Field NoKtp
		$this->NoKtp->AdvancedSearch->SearchValue = @$filter["x_NoKtp"];
		$this->NoKtp->AdvancedSearch->SearchOperator = @$filter["z_NoKtp"];
		$this->NoKtp->AdvancedSearch->SearchCondition = @$filter["v_NoKtp"];
		$this->NoKtp->AdvancedSearch->SearchValue2 = @$filter["y_NoKtp"];
		$this->NoKtp->AdvancedSearch->SearchOperator2 = @$filter["w_NoKtp"];
		$this->NoKtp->AdvancedSearch->save();

		// Field Tmp_Lahir
		$this->Tmp_Lahir->AdvancedSearch->SearchValue = @$filter["x_Tmp_Lahir"];
		$this->Tmp_Lahir->AdvancedSearch->SearchOperator = @$filter["z_Tmp_Lahir"];
		$this->Tmp_Lahir->AdvancedSearch->SearchCondition = @$filter["v_Tmp_Lahir"];
		$this->Tmp_Lahir->AdvancedSearch->SearchValue2 = @$filter["y_Tmp_Lahir"];
		$this->Tmp_Lahir->AdvancedSearch->SearchOperator2 = @$filter["w_Tmp_Lahir"];
		$this->Tmp_Lahir->AdvancedSearch->save();

		// Field Tgl_Lahir
		$this->Tgl_Lahir->AdvancedSearch->SearchValue = @$filter["x_Tgl_Lahir"];
		$this->Tgl_Lahir->AdvancedSearch->SearchOperator = @$filter["z_Tgl_Lahir"];
		$this->Tgl_Lahir->AdvancedSearch->SearchCondition = @$filter["v_Tgl_Lahir"];
		$this->Tgl_Lahir->AdvancedSearch->SearchValue2 = @$filter["y_Tgl_Lahir"];
		$this->Tgl_Lahir->AdvancedSearch->SearchOperator2 = @$filter["w_Tgl_Lahir"];
		$this->Tgl_Lahir->AdvancedSearch->save();

		// Field Kelamin
		$this->Kelamin->AdvancedSearch->SearchValue = @$filter["x_Kelamin"];
		$this->Kelamin->AdvancedSearch->SearchOperator = @$filter["z_Kelamin"];
		$this->Kelamin->AdvancedSearch->SearchCondition = @$filter["v_Kelamin"];
		$this->Kelamin->AdvancedSearch->SearchValue2 = @$filter["y_Kelamin"];
		$this->Kelamin->AdvancedSearch->SearchOperator2 = @$filter["w_Kelamin"];
		$this->Kelamin->AdvancedSearch->save();

		// Field Alamat
		$this->Alamat->AdvancedSearch->SearchValue = @$filter["x_Alamat"];
		$this->Alamat->AdvancedSearch->SearchOperator = @$filter["z_Alamat"];
		$this->Alamat->AdvancedSearch->SearchCondition = @$filter["v_Alamat"];
		$this->Alamat->AdvancedSearch->SearchValue2 = @$filter["y_Alamat"];
		$this->Alamat->AdvancedSearch->SearchOperator2 = @$filter["w_Alamat"];
		$this->Alamat->AdvancedSearch->save();

		// Field Kelurahan
		$this->Kelurahan->AdvancedSearch->SearchValue = @$filter["x_Kelurahan"];
		$this->Kelurahan->AdvancedSearch->SearchOperator = @$filter["z_Kelurahan"];
		$this->Kelurahan->AdvancedSearch->SearchCondition = @$filter["v_Kelurahan"];
		$this->Kelurahan->AdvancedSearch->SearchValue2 = @$filter["y_Kelurahan"];
		$this->Kelurahan->AdvancedSearch->SearchOperator2 = @$filter["w_Kelurahan"];
		$this->Kelurahan->AdvancedSearch->save();

		// Field Kecamatan
		$this->Kecamatan->AdvancedSearch->SearchValue = @$filter["x_Kecamatan"];
		$this->Kecamatan->AdvancedSearch->SearchOperator = @$filter["z_Kecamatan"];
		$this->Kecamatan->AdvancedSearch->SearchCondition = @$filter["v_Kecamatan"];
		$this->Kecamatan->AdvancedSearch->SearchValue2 = @$filter["y_Kecamatan"];
		$this->Kecamatan->AdvancedSearch->SearchOperator2 = @$filter["w_Kecamatan"];
		$this->Kecamatan->AdvancedSearch->save();

		// Field Kota
		$this->Kota->AdvancedSearch->SearchValue = @$filter["x_Kota"];
		$this->Kota->AdvancedSearch->SearchOperator = @$filter["z_Kota"];
		$this->Kota->AdvancedSearch->SearchCondition = @$filter["v_Kota"];
		$this->Kota->AdvancedSearch->SearchValue2 = @$filter["y_Kota"];
		$this->Kota->AdvancedSearch->SearchOperator2 = @$filter["w_Kota"];
		$this->Kota->AdvancedSearch->save();

		// Field Kode_pos
		$this->Kode_pos->AdvancedSearch->SearchValue = @$filter["x_Kode_pos"];
		$this->Kode_pos->AdvancedSearch->SearchOperator = @$filter["z_Kode_pos"];
		$this->Kode_pos->AdvancedSearch->SearchCondition = @$filter["v_Kode_pos"];
		$this->Kode_pos->AdvancedSearch->SearchValue2 = @$filter["y_Kode_pos"];
		$this->Kode_pos->AdvancedSearch->SearchOperator2 = @$filter["w_Kode_pos"];
		$this->Kode_pos->AdvancedSearch->save();

		// Field Phone
		$this->Phone->AdvancedSearch->SearchValue = @$filter["x_Phone"];
		$this->Phone->AdvancedSearch->SearchOperator = @$filter["z_Phone"];
		$this->Phone->AdvancedSearch->SearchCondition = @$filter["v_Phone"];
		$this->Phone->AdvancedSearch->SearchValue2 = @$filter["y_Phone"];
		$this->Phone->AdvancedSearch->SearchOperator2 = @$filter["w_Phone"];
		$this->Phone->AdvancedSearch->save();

		// Field TlpRumah
		$this->TlpRumah->AdvancedSearch->SearchValue = @$filter["x_TlpRumah"];
		$this->TlpRumah->AdvancedSearch->SearchOperator = @$filter["z_TlpRumah"];
		$this->TlpRumah->AdvancedSearch->SearchCondition = @$filter["v_TlpRumah"];
		$this->TlpRumah->AdvancedSearch->SearchValue2 = @$filter["y_TlpRumah"];
		$this->TlpRumah->AdvancedSearch->SearchOperator2 = @$filter["w_TlpRumah"];
		$this->TlpRumah->AdvancedSearch->save();

		// Field KodeJafung
		$this->KodeJafung->AdvancedSearch->SearchValue = @$filter["x_KodeJafung"];
		$this->KodeJafung->AdvancedSearch->SearchOperator = @$filter["z_KodeJafung"];
		$this->KodeJafung->AdvancedSearch->SearchCondition = @$filter["v_KodeJafung"];
		$this->KodeJafung->AdvancedSearch->SearchValue2 = @$filter["y_KodeJafung"];
		$this->KodeJafung->AdvancedSearch->SearchOperator2 = @$filter["w_KodeJafung"];
		$this->KodeJafung->AdvancedSearch->save();

		// Field Gol
		$this->Gol->AdvancedSearch->SearchValue = @$filter["x_Gol"];
		$this->Gol->AdvancedSearch->SearchOperator = @$filter["z_Gol"];
		$this->Gol->AdvancedSearch->SearchCondition = @$filter["v_Gol"];
		$this->Gol->AdvancedSearch->SearchValue2 = @$filter["y_Gol"];
		$this->Gol->AdvancedSearch->SearchOperator2 = @$filter["w_Gol"];
		$this->Gol->AdvancedSearch->save();

		// Field TMTJafung
		$this->TMTJafung->AdvancedSearch->SearchValue = @$filter["x_TMTJafung"];
		$this->TMTJafung->AdvancedSearch->SearchOperator = @$filter["z_TMTJafung"];
		$this->TMTJafung->AdvancedSearch->SearchCondition = @$filter["v_TMTJafung"];
		$this->TMTJafung->AdvancedSearch->SearchValue2 = @$filter["y_TMTJafung"];
		$this->TMTJafung->AdvancedSearch->SearchOperator2 = @$filter["w_TMTJafung"];
		$this->TMTJafung->AdvancedSearch->save();

		// Field PendidikanTerakhir
		$this->PendidikanTerakhir->AdvancedSearch->SearchValue = @$filter["x_PendidikanTerakhir"];
		$this->PendidikanTerakhir->AdvancedSearch->SearchOperator = @$filter["z_PendidikanTerakhir"];
		$this->PendidikanTerakhir->AdvancedSearch->SearchCondition = @$filter["v_PendidikanTerakhir"];
		$this->PendidikanTerakhir->AdvancedSearch->SearchValue2 = @$filter["y_PendidikanTerakhir"];
		$this->PendidikanTerakhir->AdvancedSearch->SearchOperator2 = @$filter["w_PendidikanTerakhir"];
		$this->PendidikanTerakhir->AdvancedSearch->save();

		// Field Status_Dosen
		$this->Status_Dosen->AdvancedSearch->SearchValue = @$filter["x_Status_Dosen"];
		$this->Status_Dosen->AdvancedSearch->SearchOperator = @$filter["z_Status_Dosen"];
		$this->Status_Dosen->AdvancedSearch->SearchCondition = @$filter["v_Status_Dosen"];
		$this->Status_Dosen->AdvancedSearch->SearchValue2 = @$filter["y_Status_Dosen"];
		$this->Status_Dosen->AdvancedSearch->SearchOperator2 = @$filter["w_Status_Dosen"];
		$this->Status_Dosen->AdvancedSearch->save();

		// Field Kode_Jp
		$this->Kode_Jp->AdvancedSearch->SearchValue = @$filter["x_Kode_Jp"];
		$this->Kode_Jp->AdvancedSearch->SearchOperator = @$filter["z_Kode_Jp"];
		$this->Kode_Jp->AdvancedSearch->SearchCondition = @$filter["v_Kode_Jp"];
		$this->Kode_Jp->AdvancedSearch->SearchValue2 = @$filter["y_Kode_Jp"];
		$this->Kode_Jp->AdvancedSearch->SearchOperator2 = @$filter["w_Kode_Jp"];
		$this->Kode_Jp->AdvancedSearch->save();

		// Field PictureName
		$this->PictureName->AdvancedSearch->SearchValue = @$filter["x_PictureName"];
		$this->PictureName->AdvancedSearch->SearchOperator = @$filter["z_PictureName"];
		$this->PictureName->AdvancedSearch->SearchCondition = @$filter["v_PictureName"];
		$this->PictureName->AdvancedSearch->SearchValue2 = @$filter["y_PictureName"];
		$this->PictureName->AdvancedSearch->SearchOperator2 = @$filter["w_PictureName"];
		$this->PictureName->AdvancedSearch->save();

		// Field PictureSize
		$this->PictureSize->AdvancedSearch->SearchValue = @$filter["x_PictureSize"];
		$this->PictureSize->AdvancedSearch->SearchOperator = @$filter["z_PictureSize"];
		$this->PictureSize->AdvancedSearch->SearchCondition = @$filter["v_PictureSize"];
		$this->PictureSize->AdvancedSearch->SearchValue2 = @$filter["y_PictureSize"];
		$this->PictureSize->AdvancedSearch->SearchOperator2 = @$filter["w_PictureSize"];
		$this->PictureSize->AdvancedSearch->save();

		// Field PictureType
		$this->PictureType->AdvancedSearch->SearchValue = @$filter["x_PictureType"];
		$this->PictureType->AdvancedSearch->SearchOperator = @$filter["z_PictureType"];
		$this->PictureType->AdvancedSearch->SearchCondition = @$filter["v_PictureType"];
		$this->PictureType->AdvancedSearch->SearchValue2 = @$filter["y_PictureType"];
		$this->PictureType->AdvancedSearch->SearchOperator2 = @$filter["w_PictureType"];
		$this->PictureType->AdvancedSearch->save();

		// Field PictureWidth
		$this->PictureWidth->AdvancedSearch->SearchValue = @$filter["x_PictureWidth"];
		$this->PictureWidth->AdvancedSearch->SearchOperator = @$filter["z_PictureWidth"];
		$this->PictureWidth->AdvancedSearch->SearchCondition = @$filter["v_PictureWidth"];
		$this->PictureWidth->AdvancedSearch->SearchValue2 = @$filter["y_PictureWidth"];
		$this->PictureWidth->AdvancedSearch->SearchOperator2 = @$filter["w_PictureWidth"];
		$this->PictureWidth->AdvancedSearch->save();

		// Field PictureHeight
		$this->PictureHeight->AdvancedSearch->SearchValue = @$filter["x_PictureHeight"];
		$this->PictureHeight->AdvancedSearch->SearchOperator = @$filter["z_PictureHeight"];
		$this->PictureHeight->AdvancedSearch->SearchCondition = @$filter["v_PictureHeight"];
		$this->PictureHeight->AdvancedSearch->SearchValue2 = @$filter["y_PictureHeight"];
		$this->PictureHeight->AdvancedSearch->SearchOperator2 = @$filter["w_PictureHeight"];
		$this->PictureHeight->AdvancedSearch->save();

		// Field Norek
		$this->Norek->AdvancedSearch->SearchValue = @$filter["x_Norek"];
		$this->Norek->AdvancedSearch->SearchOperator = @$filter["z_Norek"];
		$this->Norek->AdvancedSearch->SearchCondition = @$filter["v_Norek"];
		$this->Norek->AdvancedSearch->SearchValue2 = @$filter["y_Norek"];
		$this->Norek->AdvancedSearch->SearchOperator2 = @$filter["w_Norek"];
		$this->Norek->AdvancedSearch->save();

		// Field Password
		$this->Password->AdvancedSearch->SearchValue = @$filter["x_Password"];
		$this->Password->AdvancedSearch->SearchOperator = @$filter["z_Password"];
		$this->Password->AdvancedSearch->SearchCondition = @$filter["v_Password"];
		$this->Password->AdvancedSearch->SearchValue2 = @$filter["y_Password"];
		$this->Password->AdvancedSearch->SearchOperator2 = @$filter["w_Password"];
		$this->Password->AdvancedSearch->save();

		// Field NPWP
		$this->NPWP->AdvancedSearch->SearchValue = @$filter["x_NPWP"];
		$this->NPWP->AdvancedSearch->SearchOperator = @$filter["z_NPWP"];
		$this->NPWP->AdvancedSearch->SearchCondition = @$filter["v_NPWP"];
		$this->NPWP->AdvancedSearch->SearchValue2 = @$filter["y_NPWP"];
		$this->NPWP->AdvancedSearch->SearchOperator2 = @$filter["w_NPWP"];
		$this->NPWP->AdvancedSearch->save();

		// Field Email
		$this->_Email->AdvancedSearch->SearchValue = @$filter["x__Email"];
		$this->_Email->AdvancedSearch->SearchOperator = @$filter["z__Email"];
		$this->_Email->AdvancedSearch->SearchCondition = @$filter["v__Email"];
		$this->_Email->AdvancedSearch->SearchValue2 = @$filter["y__Email"];
		$this->_Email->AdvancedSearch->SearchOperator2 = @$filter["w__Email"];
		$this->_Email->AdvancedSearch->save();

		// Field KewajibanSKS
		$this->KewajibanSKS->AdvancedSearch->SearchValue = @$filter["x_KewajibanSKS"];
		$this->KewajibanSKS->AdvancedSearch->SearchOperator = @$filter["z_KewajibanSKS"];
		$this->KewajibanSKS->AdvancedSearch->SearchCondition = @$filter["v_KewajibanSKS"];
		$this->KewajibanSKS->AdvancedSearch->SearchValue2 = @$filter["y_KewajibanSKS"];
		$this->KewajibanSKS->AdvancedSearch->SearchOperator2 = @$filter["w_KewajibanSKS"];
		$this->KewajibanSKS->AdvancedSearch->save();

		// Field IDFIng
		$this->IDFIng->AdvancedSearch->SearchValue = @$filter["x_IDFIng"];
		$this->IDFIng->AdvancedSearch->SearchOperator = @$filter["z_IDFIng"];
		$this->IDFIng->AdvancedSearch->SearchCondition = @$filter["v_IDFIng"];
		$this->IDFIng->AdvancedSearch->SearchValue2 = @$filter["y_IDFIng"];
		$this->IDFIng->AdvancedSearch->SearchOperator2 = @$filter["w_IDFIng"];
		$this->IDFIng->AdvancedSearch->save();

		// Field Profile
		$this->Profile->AdvancedSearch->SearchValue = @$filter["x_Profile"];
		$this->Profile->AdvancedSearch->SearchOperator = @$filter["z_Profile"];
		$this->Profile->AdvancedSearch->SearchCondition = @$filter["v_Profile"];
		$this->Profile->AdvancedSearch->SearchValue2 = @$filter["y_Profile"];
		$this->Profile->AdvancedSearch->SearchOperator2 = @$filter["w_Profile"];
		$this->Profile->AdvancedSearch->save();

		// Field ttd
		$this->ttd->AdvancedSearch->SearchValue = @$filter["x_ttd"];
		$this->ttd->AdvancedSearch->SearchOperator = @$filter["z_ttd"];
		$this->ttd->AdvancedSearch->SearchCondition = @$filter["v_ttd"];
		$this->ttd->AdvancedSearch->SearchValue2 = @$filter["y_ttd"];
		$this->ttd->AdvancedSearch->SearchOperator2 = @$filter["w_ttd"];
		$this->ttd->AdvancedSearch->save();
		$this->BasicSearch->setKeyword(@$filter[Config("TABLE_BASIC_SEARCH")]);
		$this->BasicSearch->setType(@$filter[Config("TABLE_BASIC_SEARCH_TYPE")]);
	}

	// Advanced search WHERE clause based on QueryString
	protected function advancedSearchWhere($default = FALSE)
	{
		global $Security;
		$where = "";
		if (!$Security->canSearch())
			return "";
		$this->buildSearchSql($where, $this->NIDN, $default, FALSE); // NIDN
		$this->buildSearchSql($where, $this->Nama, $default, FALSE); // Nama
		$this->buildSearchSql($where, $this->Status, $default, FALSE); // Status
		$this->buildSearchSql($where, $this->NoSKStatus, $default, FALSE); // NoSKStatus
		$this->buildSearchSql($where, $this->TMTKerja, $default, FALSE); // TMTKerja
		$this->buildSearchSql($where, $this->NoKtp, $default, FALSE); // NoKtp
		$this->buildSearchSql($where, $this->Tmp_Lahir, $default, FALSE); // Tmp_Lahir
		$this->buildSearchSql($where, $this->Tgl_Lahir, $default, FALSE); // Tgl_Lahir
		$this->buildSearchSql($where, $this->Kelamin, $default, FALSE); // Kelamin
		$this->buildSearchSql($where, $this->Alamat, $default, FALSE); // Alamat
		$this->buildSearchSql($where, $this->Kelurahan, $default, FALSE); // Kelurahan
		$this->buildSearchSql($where, $this->Kecamatan, $default, FALSE); // Kecamatan
		$this->buildSearchSql($where, $this->Kota, $default, FALSE); // Kota
		$this->buildSearchSql($where, $this->Kode_pos, $default, FALSE); // Kode_pos
		$this->buildSearchSql($where, $this->Phone, $default, FALSE); // Phone
		$this->buildSearchSql($where, $this->TlpRumah, $default, FALSE); // TlpRumah
		$this->buildSearchSql($where, $this->KodeJafung, $default, FALSE); // KodeJafung
		$this->buildSearchSql($where, $this->Gol, $default, FALSE); // Gol
		$this->buildSearchSql($where, $this->TMTJafung, $default, FALSE); // TMTJafung
		$this->buildSearchSql($where, $this->PendidikanTerakhir, $default, FALSE); // PendidikanTerakhir
		$this->buildSearchSql($where, $this->Status_Dosen, $default, FALSE); // Status_Dosen
		$this->buildSearchSql($where, $this->Kode_Jp, $default, FALSE); // Kode_Jp
		$this->buildSearchSql($where, $this->PictureName, $default, FALSE); // PictureName
		$this->buildSearchSql($where, $this->PictureSize, $default, FALSE); // PictureSize
		$this->buildSearchSql($where, $this->PictureType, $default, FALSE); // PictureType
		$this->buildSearchSql($where, $this->PictureWidth, $default, FALSE); // PictureWidth
		$this->buildSearchSql($where, $this->PictureHeight, $default, FALSE); // PictureHeight
		$this->buildSearchSql($where, $this->Norek, $default, FALSE); // Norek
		$this->buildSearchSql($where, $this->Password, $default, FALSE); // Password
		$this->buildSearchSql($where, $this->NPWP, $default, FALSE); // NPWP
		$this->buildSearchSql($where, $this->_Email, $default, FALSE); // Email
		$this->buildSearchSql($where, $this->KewajibanSKS, $default, FALSE); // KewajibanSKS
		$this->buildSearchSql($where, $this->IDFIng, $default, FALSE); // IDFIng
		$this->buildSearchSql($where, $this->Profile, $default, FALSE); // Profile
		$this->buildSearchSql($where, $this->ttd, $default, FALSE); // ttd

		// Set up search parm
		if (!$default && $where != "" && in_array($this->Command, ["", "reset", "resetall"])) {
			$this->Command = "search";
		}
		if (!$default && $this->Command == "search") {
			$this->NIDN->AdvancedSearch->save(); // NIDN
			$this->Nama->AdvancedSearch->save(); // Nama
			$this->Status->AdvancedSearch->save(); // Status
			$this->NoSKStatus->AdvancedSearch->save(); // NoSKStatus
			$this->TMTKerja->AdvancedSearch->save(); // TMTKerja
			$this->NoKtp->AdvancedSearch->save(); // NoKtp
			$this->Tmp_Lahir->AdvancedSearch->save(); // Tmp_Lahir
			$this->Tgl_Lahir->AdvancedSearch->save(); // Tgl_Lahir
			$this->Kelamin->AdvancedSearch->save(); // Kelamin
			$this->Alamat->AdvancedSearch->save(); // Alamat
			$this->Kelurahan->AdvancedSearch->save(); // Kelurahan
			$this->Kecamatan->AdvancedSearch->save(); // Kecamatan
			$this->Kota->AdvancedSearch->save(); // Kota
			$this->Kode_pos->AdvancedSearch->save(); // Kode_pos
			$this->Phone->AdvancedSearch->save(); // Phone
			$this->TlpRumah->AdvancedSearch->save(); // TlpRumah
			$this->KodeJafung->AdvancedSearch->save(); // KodeJafung
			$this->Gol->AdvancedSearch->save(); // Gol
			$this->TMTJafung->AdvancedSearch->save(); // TMTJafung
			$this->PendidikanTerakhir->AdvancedSearch->save(); // PendidikanTerakhir
			$this->Status_Dosen->AdvancedSearch->save(); // Status_Dosen
			$this->Kode_Jp->AdvancedSearch->save(); // Kode_Jp
			$this->PictureName->AdvancedSearch->save(); // PictureName
			$this->PictureSize->AdvancedSearch->save(); // PictureSize
			$this->PictureType->AdvancedSearch->save(); // PictureType
			$this->PictureWidth->AdvancedSearch->save(); // PictureWidth
			$this->PictureHeight->AdvancedSearch->save(); // PictureHeight
			$this->Norek->AdvancedSearch->save(); // Norek
			$this->Password->AdvancedSearch->save(); // Password
			$this->NPWP->AdvancedSearch->save(); // NPWP
			$this->_Email->AdvancedSearch->save(); // Email
			$this->KewajibanSKS->AdvancedSearch->save(); // KewajibanSKS
			$this->IDFIng->AdvancedSearch->save(); // IDFIng
			$this->Profile->AdvancedSearch->save(); // Profile
			$this->ttd->AdvancedSearch->save(); // ttd
		}
		return $where;
	}

	// Build search SQL
	protected function buildSearchSql(&$where, &$fld, $default, $multiValue)
	{
		$fldParm = $fld->Param;
		$fldVal = ($default) ? $fld->AdvancedSearch->SearchValueDefault : $fld->AdvancedSearch->SearchValue;
		$fldOpr = ($default) ? $fld->AdvancedSearch->SearchOperatorDefault : $fld->AdvancedSearch->SearchOperator;
		$fldCond = ($default) ? $fld->AdvancedSearch->SearchConditionDefault : $fld->AdvancedSearch->SearchCondition;
		$fldVal2 = ($default) ? $fld->AdvancedSearch->SearchValue2Default : $fld->AdvancedSearch->SearchValue2;
		$fldOpr2 = ($default) ? $fld->AdvancedSearch->SearchOperator2Default : $fld->AdvancedSearch->SearchOperator2;
		$wrk = "";
		if (is_array($fldVal))
			$fldVal = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal);
		if (is_array($fldVal2))
			$fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
		$fldOpr = strtoupper(trim($fldOpr));
		if ($fldOpr == "")
			$fldOpr = "=";
		$fldOpr2 = strtoupper(trim($fldOpr2));
		if ($fldOpr2 == "")
			$fldOpr2 = "=";
		if (Config("SEARCH_MULTI_VALUE_OPTION") == 1 || !IsMultiSearchOperator($fldOpr))
			$multiValue = FALSE;
		if ($multiValue) {
			$wrk1 = ($fldVal != "") ? GetMultiSearchSql($fld, $fldOpr, $fldVal, $this->Dbid) : ""; // Field value 1
			$wrk2 = ($fldVal2 != "") ? GetMultiSearchSql($fld, $fldOpr2, $fldVal2, $this->Dbid) : ""; // Field value 2
			$wrk = $wrk1; // Build final SQL
			if ($wrk2 != "")
				$wrk = ($wrk != "") ? "($wrk) $fldCond ($wrk2)" : $wrk2;
		} else {
			$fldVal = $this->convertSearchValue($fld, $fldVal);
			$fldVal2 = $this->convertSearchValue($fld, $fldVal2);
			$wrk = GetSearchSql($fld, $fldVal, $fldOpr, $fldCond, $fldVal2, $fldOpr2, $this->Dbid);
		}
		AddFilter($where, $wrk);
	}

	// Convert search value
	protected function convertSearchValue(&$fld, $fldVal)
	{
		if ($fldVal == Config("NULL_VALUE") || $fldVal == Config("NOT_NULL_VALUE"))
			return $fldVal;
		$value = $fldVal;
		if ($fld->isBoolean()) {
			if ($fldVal != "")
				$value = (SameText($fldVal, "1") || SameText($fldVal, "y") || SameText($fldVal, "t")) ? $fld->TrueValue : $fld->FalseValue;
		} elseif ($fld->DataType == DATATYPE_DATE || $fld->DataType == DATATYPE_TIME) {
			if ($fldVal != "")
				$value = UnFormatDateTime($fldVal, $fld->DateTimeFormat);
		}
		return $value;
	}

	// Return basic search SQL
	protected function basicSearchSql($arKeywords, $type)
	{
		$where = "";
		$this->buildBasicSearchSql($where, $this->NIDN, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->Nama, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->Status, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->NoSKStatus, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->NoKtp, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->Tmp_Lahir, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->Kelamin, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->Alamat, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->Kelurahan, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->Kecamatan, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->Kota, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->Kode_pos, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->Phone, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->TlpRumah, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->KodeJafung, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->Gol, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->PendidikanTerakhir, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->Status_Dosen, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->Kode_Jp, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->PictureName, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->PictureType, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->Norek, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->Password, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->NPWP, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->_Email, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->IDFIng, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->Profile, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->ttd, $arKeywords, $type);
		return $where;
	}

	// Build basic search SQL
	protected function buildBasicSearchSql(&$where, &$fld, $arKeywords, $type)
	{
		$defCond = ($type == "OR") ? "OR" : "AND";
		$arSql = []; // Array for SQL parts
		$arCond = []; // Array for search conditions
		$cnt = count($arKeywords);
		$j = 0; // Number of SQL parts
		for ($i = 0; $i < $cnt; $i++) {
			$keyword = $arKeywords[$i];
			$keyword = trim($keyword);
			if (Config("BASIC_SEARCH_IGNORE_PATTERN") != "") {
				$keyword = preg_replace(Config("BASIC_SEARCH_IGNORE_PATTERN"), "\\", $keyword);
				$ar = explode("\\", $keyword);
			} else {
				$ar = [$keyword];
			}
			foreach ($ar as $keyword) {
				if ($keyword != "") {
					$wrk = "";
					if ($keyword == "OR" && $type == "") {
						if ($j > 0)
							$arCond[$j - 1] = "OR";
					} elseif ($keyword == Config("NULL_VALUE")) {
						$wrk = $fld->Expression . " IS NULL";
					} elseif ($keyword == Config("NOT_NULL_VALUE")) {
						$wrk = $fld->Expression . " IS NOT NULL";
					} elseif ($fld->IsVirtual) {
						$wrk = $fld->VirtualExpression . Like(QuotedValue("%" . $keyword . "%", DATATYPE_STRING, $this->Dbid), $this->Dbid);
					} elseif ($fld->DataType != DATATYPE_NUMBER || is_numeric($keyword)) {
						$wrk = $fld->BasicSearchExpression . Like(QuotedValue("%" . $keyword . "%", DATATYPE_STRING, $this->Dbid), $this->Dbid);
					}
					if ($wrk != "") {
						$arSql[$j] = $wrk;
						$arCond[$j] = $defCond;
						$j += 1;
					}
				}
			}
		}
		$cnt = count($arSql);
		$quoted = FALSE;
		$sql = "";
		if ($cnt > 0) {
			for ($i = 0; $i < $cnt - 1; $i++) {
				if ($arCond[$i] == "OR") {
					if (!$quoted)
						$sql .= "(";
					$quoted = TRUE;
				}
				$sql .= $arSql[$i];
				if ($quoted && $arCond[$i] != "OR") {
					$sql .= ")";
					$quoted = FALSE;
				}
				$sql .= " " . $arCond[$i] . " ";
			}
			$sql .= $arSql[$cnt - 1];
			if ($quoted)
				$sql .= ")";
		}
		if ($sql != "") {
			if ($where != "")
				$where .= " OR ";
			$where .= "(" . $sql . ")";
		}
	}

	// Return basic search WHERE clause based on search keyword and type
	protected function basicSearchWhere($default = FALSE)
	{
		global $Security;
		$searchStr = "";
		if (!$Security->canSearch())
			return "";
		$searchKeyword = ($default) ? $this->BasicSearch->KeywordDefault : $this->BasicSearch->Keyword;
		$searchType = ($default) ? $this->BasicSearch->TypeDefault : $this->BasicSearch->Type;

		// Get search SQL
		if ($searchKeyword != "") {
			$ar = $this->BasicSearch->keywordList($default);

			// Search keyword in any fields
			if (($searchType == "OR" || $searchType == "AND") && $this->BasicSearch->BasicSearchAnyFields) {
				foreach ($ar as $keyword) {
					if ($keyword != "") {
						if ($searchStr != "")
							$searchStr .= " " . $searchType . " ";
						$searchStr .= "(" . $this->basicSearchSql([$keyword], $searchType) . ")";
					}
				}
			} else {
				$searchStr = $this->basicSearchSql($ar, $searchType);
			}
			if (!$default && in_array($this->Command, ["", "reset", "resetall"]))
				$this->Command = "search";
		}
		if (!$default && $this->Command == "search") {
			$this->BasicSearch->setKeyword($searchKeyword);
			$this->BasicSearch->setType($searchType);
		}
		return $searchStr;
	}

	// Check if search parm exists
	protected function checkSearchParms()
	{

		// Check basic search
		if ($this->BasicSearch->issetSession())
			return TRUE;
		if ($this->NIDN->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->Nama->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->Status->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->NoSKStatus->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->TMTKerja->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->NoKtp->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->Tmp_Lahir->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->Tgl_Lahir->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->Kelamin->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->Alamat->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->Kelurahan->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->Kecamatan->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->Kota->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->Kode_pos->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->Phone->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->TlpRumah->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->KodeJafung->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->Gol->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->TMTJafung->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->PendidikanTerakhir->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->Status_Dosen->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->Kode_Jp->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->PictureName->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->PictureSize->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->PictureType->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->PictureWidth->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->PictureHeight->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->Norek->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->Password->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->NPWP->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_Email->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->KewajibanSKS->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->IDFIng->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->Profile->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->ttd->AdvancedSearch->issetSession())
			return TRUE;
		return FALSE;
	}

	// Clear all search parameters
	protected function resetSearchParms()
	{

		// Clear search WHERE clause
		$this->SearchWhere = "";
		$this->setSearchWhere($this->SearchWhere);

		// Clear basic search parameters
		$this->resetBasicSearchParms();

		// Clear advanced search parameters
		$this->resetAdvancedSearchParms();
	}

	// Load advanced search default values
	protected function loadAdvancedSearchDefault()
	{
		return FALSE;
	}

	// Clear all basic search parameters
	protected function resetBasicSearchParms()
	{
		$this->BasicSearch->unsetSession();
	}

	// Clear all advanced search parameters
	protected function resetAdvancedSearchParms()
	{
		$this->NIDN->AdvancedSearch->unsetSession();
		$this->Nama->AdvancedSearch->unsetSession();
		$this->Status->AdvancedSearch->unsetSession();
		$this->NoSKStatus->AdvancedSearch->unsetSession();
		$this->TMTKerja->AdvancedSearch->unsetSession();
		$this->NoKtp->AdvancedSearch->unsetSession();
		$this->Tmp_Lahir->AdvancedSearch->unsetSession();
		$this->Tgl_Lahir->AdvancedSearch->unsetSession();
		$this->Kelamin->AdvancedSearch->unsetSession();
		$this->Alamat->AdvancedSearch->unsetSession();
		$this->Kelurahan->AdvancedSearch->unsetSession();
		$this->Kecamatan->AdvancedSearch->unsetSession();
		$this->Kota->AdvancedSearch->unsetSession();
		$this->Kode_pos->AdvancedSearch->unsetSession();
		$this->Phone->AdvancedSearch->unsetSession();
		$this->TlpRumah->AdvancedSearch->unsetSession();
		$this->KodeJafung->AdvancedSearch->unsetSession();
		$this->Gol->AdvancedSearch->unsetSession();
		$this->TMTJafung->AdvancedSearch->unsetSession();
		$this->PendidikanTerakhir->AdvancedSearch->unsetSession();
		$this->Status_Dosen->AdvancedSearch->unsetSession();
		$this->Kode_Jp->AdvancedSearch->unsetSession();
		$this->PictureName->AdvancedSearch->unsetSession();
		$this->PictureSize->AdvancedSearch->unsetSession();
		$this->PictureType->AdvancedSearch->unsetSession();
		$this->PictureWidth->AdvancedSearch->unsetSession();
		$this->PictureHeight->AdvancedSearch->unsetSession();
		$this->Norek->AdvancedSearch->unsetSession();
		$this->Password->AdvancedSearch->unsetSession();
		$this->NPWP->AdvancedSearch->unsetSession();
		$this->_Email->AdvancedSearch->unsetSession();
		$this->KewajibanSKS->AdvancedSearch->unsetSession();
		$this->IDFIng->AdvancedSearch->unsetSession();
		$this->Profile->AdvancedSearch->unsetSession();
		$this->ttd->AdvancedSearch->unsetSession();
	}

	// Restore all search parameters
	protected function restoreSearchParms()
	{
		$this->RestoreSearch = TRUE;

		// Restore basic search values
		$this->BasicSearch->load();

		// Restore advanced search values
		$this->NIDN->AdvancedSearch->load();
		$this->Nama->AdvancedSearch->load();
		$this->Status->AdvancedSearch->load();
		$this->NoSKStatus->AdvancedSearch->load();
		$this->TMTKerja->AdvancedSearch->load();
		$this->NoKtp->AdvancedSearch->load();
		$this->Tmp_Lahir->AdvancedSearch->load();
		$this->Tgl_Lahir->AdvancedSearch->load();
		$this->Kelamin->AdvancedSearch->load();
		$this->Alamat->AdvancedSearch->load();
		$this->Kelurahan->AdvancedSearch->load();
		$this->Kecamatan->AdvancedSearch->load();
		$this->Kota->AdvancedSearch->load();
		$this->Kode_pos->AdvancedSearch->load();
		$this->Phone->AdvancedSearch->load();
		$this->TlpRumah->AdvancedSearch->load();
		$this->KodeJafung->AdvancedSearch->load();
		$this->Gol->AdvancedSearch->load();
		$this->TMTJafung->AdvancedSearch->load();
		$this->PendidikanTerakhir->AdvancedSearch->load();
		$this->Status_Dosen->AdvancedSearch->load();
		$this->Kode_Jp->AdvancedSearch->load();
		$this->PictureName->AdvancedSearch->load();
		$this->PictureSize->AdvancedSearch->load();
		$this->PictureType->AdvancedSearch->load();
		$this->PictureWidth->AdvancedSearch->load();
		$this->PictureHeight->AdvancedSearch->load();
		$this->Norek->AdvancedSearch->load();
		$this->Password->AdvancedSearch->load();
		$this->NPWP->AdvancedSearch->load();
		$this->_Email->AdvancedSearch->load();
		$this->KewajibanSKS->AdvancedSearch->load();
		$this->IDFIng->AdvancedSearch->load();
		$this->Profile->AdvancedSearch->load();
		$this->ttd->AdvancedSearch->load();
	}

	// Set up sort parameters
	protected function setupSortOrder()
	{

		// Check for "order" parameter
		if (Get("order") !== NULL) {
			$this->CurrentOrder = Get("order");
			$this->CurrentOrderType = Get("ordertype", "");
			$this->updateSort($this->NIDN); // NIDN
			$this->updateSort($this->Nama); // Nama
			$this->updateSort($this->Status); // Status
			$this->updateSort($this->Kode_Jp); // Kode_Jp
			$this->updateSort($this->ttd); // ttd
			$this->setStartRecordNumber(1); // Reset start position
		}
	}

	// Load sort order parameters
	protected function loadSortOrder()
	{
		$orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
		if ($orderBy == "") {
			if ($this->getSqlOrderBy() != "") {
				$orderBy = $this->getSqlOrderBy();
				$this->setSessionOrderBy($orderBy);
			}
		}
	}

	// Reset command
	// - cmd=reset (Reset search parameters)
	// - cmd=resetall (Reset search and master/detail parameters)
	// - cmd=resetsort (Reset sort parameters)

	protected function resetCmd()
	{

		// Check if reset command
		if (StartsString("reset", $this->Command)) {

			// Reset search criteria
			if ($this->Command == "reset" || $this->Command == "resetall")
				$this->resetSearchParms();

			// Reset sorting order
			if ($this->Command == "resetsort") {
				$orderBy = "";
				$this->setSessionOrderBy($orderBy);
				$this->NIDN->setSort("");
				$this->Nama->setSort("");
				$this->Status->setSort("");
				$this->Kode_Jp->setSort("");
				$this->ttd->setSort("");
			}

			// Reset start position
			$this->StartRecord = 1;
			$this->setStartRecordNumber($this->StartRecord);
		}
	}

	// Set up list options
	protected function setupListOptions()
	{
		global $Security, $Language;

		// Add group option item
		$item = &$this->ListOptions->add($this->ListOptions->GroupOptionName);
		$item->Body = "";
		$item->OnLeft = TRUE;
		$item->Visible = FALSE;

		// "edit"
		$item = &$this->ListOptions->add("edit");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->canEdit();
		$item->OnLeft = TRUE;

		// List actions
		$item = &$this->ListOptions->add("listactions");
		$item->CssClass = "text-nowrap";
		$item->OnLeft = TRUE;
		$item->Visible = FALSE;
		$item->ShowInButtonGroup = FALSE;
		$item->ShowInDropDown = FALSE;

		// "checkbox"
		$item = &$this->ListOptions->add("checkbox");
		$item->Visible = $Security->canDelete();
		$item->OnLeft = TRUE;
		$item->Header = "<div class=\"custom-control custom-checkbox d-inline-block\"><input type=\"checkbox\" name=\"key\" id=\"key\" class=\"custom-control-input\" onclick=\"ew.selectAllKey(this);\"><label class=\"custom-control-label\" for=\"key\"></label></div>";
		$item->moveTo(0);
		$item->ShowInDropDown = FALSE;
		$item->ShowInButtonGroup = FALSE;

		// "sequence"
		$item = &$this->ListOptions->add("sequence");
		$item->CssClass = "text-nowrap";
		$item->Visible = TRUE;
		$item->OnLeft = TRUE; // Always on left
		$item->ShowInDropDown = FALSE;
		$item->ShowInButtonGroup = FALSE;

		// Drop down button for ListOptions
		$this->ListOptions->UseDropDownButton = FALSE;
		$this->ListOptions->DropDownButtonPhrase = $Language->phrase("ButtonListOptions");
		$this->ListOptions->UseButtonGroup = TRUE;
		if ($this->ListOptions->UseButtonGroup && IsMobile())
			$this->ListOptions->UseDropDownButton = TRUE;

		//$this->ListOptions->ButtonClass = ""; // Class for button group
		// Call ListOptions_Load event

		$this->ListOptions_Load();
		$this->setupListOptionsExt();
		$item = $this->ListOptions[$this->ListOptions->GroupOptionName];
		$item->Visible = $this->ListOptions->groupOptionVisible();
	}

	// Render list options
	public function renderListOptions()
	{
		global $Security, $Language, $CurrentForm;
		$this->ListOptions->loadDefault();

		// Call ListOptions_Rendering event
		$this->ListOptions_Rendering();

		// Set up row action and key
		if (is_numeric($this->RowIndex) && $this->CurrentMode != "view") {
			$CurrentForm->Index = $this->RowIndex;
			$actionName = str_replace("k_", "k" . $this->RowIndex . "_", $this->FormActionName);
			$oldKeyName = str_replace("k_", "k" . $this->RowIndex . "_", $this->FormOldKeyName);
			$keyName = str_replace("k_", "k" . $this->RowIndex . "_", $this->FormKeyName);
			$blankRowName = str_replace("k_", "k" . $this->RowIndex . "_", $this->FormBlankRowName);
			if ($this->RowAction != "")
				$this->MultiSelectKey .= "<input type=\"hidden\" name=\"" . $actionName . "\" id=\"" . $actionName . "\" value=\"" . $this->RowAction . "\">";
			if ($this->RowAction == "delete") {
				$rowkey = $CurrentForm->getValue($this->FormKeyName);
				$this->setupKeyValues($rowkey);

				// Reload hidden key for delete
				$this->MultiSelectKey .= "<input type=\"hidden\" name=\"" . $keyName . "\" id=\"" . $keyName . "\" value=\"" . HtmlEncode($rowkey) . "\">";
			}
			if ($this->RowAction == "insert" && $this->isConfirm() && $this->emptyRow())
				$this->MultiSelectKey .= "<input type=\"hidden\" name=\"" . $blankRowName . "\" id=\"" . $blankRowName . "\" value=\"1\">";
		}

		// "sequence"
		$opt = $this->ListOptions["sequence"];
		$opt->Body = FormatSequenceNumber($this->RecordCount);

		// "edit"
		$opt = $this->ListOptions["edit"];
		if ($this->isInlineEditRow()) { // Inline-Edit
			$this->ListOptions->CustomItem = "edit"; // Show edit column only
			$cancelurl = $this->addMasterUrl($this->pageUrl() . "action=cancel");
				$opt->Body = "<div" . (($opt->OnLeft) ? " class=\"text-right\"" : "") . ">" .
					"<a class=\"ew-grid-link ew-inline-update\" title=\"" . HtmlTitle($Language->phrase("UpdateLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("UpdateLink")) . "\" href=\"#\" onclick=\"return ew.forms(this).submit('" . UrlAddHash($this->pageName(), "r" . $this->RowCount . "_" . $this->TableVar) . "');\">" . $Language->phrase("UpdateLink") . "</a>&nbsp;" .
					"<a class=\"ew-grid-link ew-inline-cancel\" title=\"" . HtmlTitle($Language->phrase("CancelLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("CancelLink")) . "\" href=\"" . $cancelurl . "\">" . $Language->phrase("CancelLink") . "</a>" .
					"<input type=\"hidden\" name=\"action\" id=\"action\" value=\"update\"></div>";
			$opt->Body .= "<input type=\"hidden\" name=\"k" . $this->RowIndex . "_key\" id=\"k" . $this->RowIndex . "_key\" value=\"" . HtmlEncode($this->NIDN->CurrentValue) . "\">";
			return;
		}

		// "edit"
		$opt = $this->ListOptions["edit"];
		$editcaption = HtmlTitle($Language->phrase("EditLink"));
		if ($Security->canEdit()) {
			$opt->Body .= "<a class=\"ew-row-link ew-inline-edit\" title=\"" . HtmlTitle($Language->phrase("InlineEditLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("InlineEditLink")) . "\" href=\"" . HtmlEncode(UrlAddHash($this->InlineEditUrl, "r" . $this->RowCount . "_" . $this->TableVar)) . "\">" . $Language->phrase("InlineEditLink") . "</a>";
		} else {
			$opt->Body = "";
		}

		// Set up list action buttons
		$opt = $this->ListOptions["listactions"];
		if ($opt && !$this->isExport() && !$this->CurrentAction) {
			$body = "";
			$links = [];
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == ACTION_SINGLE && $listaction->Allow) {
					$action = $listaction->Action;
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon != "") ? "<i class=\"" . HtmlEncode(str_replace(" ew-icon", "", $listaction->Icon)) . "\" data-caption=\"" . HtmlTitle($caption) . "\"></i> " : "";
					$links[] = "<li><a class=\"dropdown-item ew-action ew-list-action\" data-action=\"" . HtmlEncode($action) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"#\" onclick=\"return ew.submitAction(event,jQuery.extend({key:" . $this->keyToJson(TRUE) . "}," . $listaction->toJson(TRUE) . "));\">" . $icon . $listaction->Caption . "</a></li>";
					if (count($links) == 1) // Single button
						$body = "<a class=\"ew-action ew-list-action\" data-action=\"" . HtmlEncode($action) . "\" title=\"" . HtmlTitle($caption) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"#\" onclick=\"return ew.submitAction(event,jQuery.extend({key:" . $this->keyToJson(TRUE) . "}," . $listaction->toJson(TRUE) . "));\">" . $icon . $listaction->Caption . "</a>";
				}
			}
			if (count($links) > 1) { // More than one buttons, use dropdown
				$body = "<button class=\"dropdown-toggle btn btn-default ew-actions\" title=\"" . HtmlTitle($Language->phrase("ListActionButton")) . "\" data-toggle=\"dropdown\">" . $Language->phrase("ListActionButton") . "</button>";
				$content = "";
				foreach ($links as $link)
					$content .= "<li>" . $link . "</li>";
				$body .= "<ul class=\"dropdown-menu" . ($opt->OnLeft ? "" : " dropdown-menu-right") . "\">". $content . "</ul>";
				$body = "<div class=\"btn-group btn-group-sm\">" . $body . "</div>";
			}
			if (count($links) > 0) {
				$opt->Body = $body;
				$opt->Visible = TRUE;
			}
		}

		// "checkbox"
		$opt = $this->ListOptions["checkbox"];
		$opt->Body = "<div class=\"custom-control custom-checkbox d-inline-block\"><input type=\"checkbox\" id=\"key_m_" . $this->RowCount . "\" name=\"key_m[]\" class=\"custom-control-input ew-multi-select\" value=\"" . HtmlEncode($this->NIDN->CurrentValue) . "\" onclick=\"ew.clickMultiCheckbox(event);\"><label class=\"custom-control-label\" for=\"key_m_" . $this->RowCount . "\"></label></div>";
		$this->renderListOptionsExt();

		// Call ListOptions_Rendered event
		$this->ListOptions_Rendered();
	}

	// Set up other options
	protected function setupOtherOptions()
	{
		global $Language, $Security;
		$options = &$this->OtherOptions;
		$option = $options["action"];

		// Add multi delete
		$item = &$option->add("multidelete");
		$item->Body = "<a class=\"ew-action ew-multi-delete\" title=\"" . HtmlTitle($Language->phrase("DeleteSelectedLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("DeleteSelectedLink")) . "\" href=\"#\" onclick=\"return ew.submitAction(event, {f:document.ftblDosenlist, url:'" . $this->MultiDeleteUrl . "', data:{action:'show'}});return false;\">" . $Language->phrase("DeleteSelectedLink") . "</a>";
		$item->Visible = $Security->canDelete();

		// Set up options default
		foreach ($options as $option) {
			$option->UseDropDownButton = FALSE;
			$option->UseButtonGroup = TRUE;

			//$option->ButtonClass = ""; // Class for button group
			$item = &$option->add($option->GroupOptionName);
			$item->Body = "";
			$item->Visible = FALSE;
		}
		$options["addedit"]->DropDownButtonPhrase = $Language->phrase("ButtonAddEdit");
		$options["detail"]->DropDownButtonPhrase = $Language->phrase("ButtonDetails");
		$options["action"]->DropDownButtonPhrase = $Language->phrase("ButtonActions");

		// Filter button
		$item = &$this->FilterOptions->add("savecurrentfilter");
		$item->Body = "<a class=\"ew-save-filter\" data-form=\"ftblDosenlistsrch\" href=\"#\" onclick=\"return false;\">" . $Language->phrase("SaveCurrentFilter") . "</a>";
		$item->Visible = TRUE;
		$item = &$this->FilterOptions->add("deletefilter");
		$item->Body = "<a class=\"ew-delete-filter\" data-form=\"ftblDosenlistsrch\" href=\"#\" onclick=\"return false;\">" . $Language->phrase("DeleteFilter") . "</a>";
		$item->Visible = TRUE;
		$this->FilterOptions->UseDropDownButton = TRUE;
		$this->FilterOptions->UseButtonGroup = !$this->FilterOptions->UseDropDownButton;
		$this->FilterOptions->DropDownButtonPhrase = $Language->phrase("Filters");

		// Add group option item
		$item = &$this->FilterOptions->add($this->FilterOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	// Render other options
	public function renderOtherOptions()
	{
		global $Language, $Security;
		$options = &$this->OtherOptions;
			$option = $options["action"];

			// Set up list action buttons
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == ACTION_MULTIPLE) {
					$item = &$option->add("custom_" . $listaction->Action);
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon != "") ? "<i class=\"" . HtmlEncode($listaction->Icon) . "\" data-caption=\"" . HtmlEncode($caption) . "\"></i> " . $caption : $caption;
					$item->Body = "<a class=\"ew-action ew-list-action\" title=\"" . HtmlEncode($caption) . "\" data-caption=\"" . HtmlEncode($caption) . "\" href=\"#\" onclick=\"return ew.submitAction(event,jQuery.extend({f:document.ftblDosenlist}," . $listaction->toJson(TRUE) . "));\">" . $icon . "</a>";
					$item->Visible = $listaction->Allow;
				}
			}

			// Hide grid edit and other options
			if ($this->TotalRecords <= 0) {
				$option = $options["addedit"];
				$item = $option["gridedit"];
				if ($item)
					$item->Visible = FALSE;
				$option = $options["action"];
				$option->hideAllOptions();
			}
	}

	// Process list action
	protected function processListAction()
	{
		global $Language, $Security;
		$userlist = "";
		$user = "";
		$filter = $this->getFilterFromRecordKeys();
		$userAction = Post("useraction", "");
		if ($filter != "" && $userAction != "") {

			// Check permission first
			$actionCaption = $userAction;
			if (array_key_exists($userAction, $this->ListActions->Items)) {
				$actionCaption = $this->ListActions[$userAction]->Caption;
				if (!$this->ListActions[$userAction]->Allow) {
					$errmsg = str_replace('%s', $actionCaption, $Language->phrase("CustomActionNotAllowed"));
					if (Post("ajax") == $userAction) // Ajax
						echo "<p class=\"text-danger\">" . $errmsg . "</p>";
					else
						$this->setFailureMessage($errmsg);
					return FALSE;
				}
			}
			$this->CurrentFilter = $filter;
			$sql = $this->getCurrentSql();
			$conn = $this->getConnection();
			$conn->raiseErrorFn = Config("ERROR_FUNC");
			$rs = $conn->execute($sql);
			$conn->raiseErrorFn = "";
			$this->CurrentAction = $userAction;

			// Call row action event
			if ($rs && !$rs->EOF) {
				$conn->beginTrans();
				$this->SelectedCount = $rs->RecordCount();
				$this->SelectedIndex = 0;
				while (!$rs->EOF) {
					$this->SelectedIndex++;
					$row = $rs->fields;
					$processed = $this->Row_CustomAction($userAction, $row);
					if (!$processed)
						break;
					$rs->moveNext();
				}
				if ($processed) {
					$conn->commitTrans(); // Commit the changes
					if ($this->getSuccessMessage() == "" && !ob_get_length()) // No output
						$this->setSuccessMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionCompleted"))); // Set up success message
				} else {
					$conn->rollbackTrans(); // Rollback changes

					// Set up error message
					if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {

						// Use the message, do nothing
					} elseif ($this->CancelMessage != "") {
						$this->setFailureMessage($this->CancelMessage);
						$this->CancelMessage = "";
					} else {
						$this->setFailureMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionFailed")));
					}
				}
			}
			if ($rs)
				$rs->close();
			$this->CurrentAction = ""; // Clear action
			if (Post("ajax") == $userAction) { // Ajax
				if ($this->getSuccessMessage() != "") {
					echo "<p class=\"text-success\">" . $this->getSuccessMessage() . "</p>";
					$this->clearSuccessMessage(); // Clear message
				}
				if ($this->getFailureMessage() != "") {
					echo "<p class=\"text-danger\">" . $this->getFailureMessage() . "</p>";
					$this->clearFailureMessage(); // Clear message
				}
				return TRUE;
			}
		}
		return FALSE; // Not ajax request
	}

	// Set up list options (extended codes)
	protected function setupListOptionsExt()
	{
	}

	// Render list options (extended codes)
	protected function renderListOptionsExt()
	{
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
		$this->ttd->Upload->Index = $CurrentForm->Index;
		$this->ttd->Upload->uploadFile();
		$this->ttd->CurrentValue = $this->ttd->Upload->FileName;
	}

	// Load default values
	protected function loadDefaultValues()
	{
		$this->NIDN->CurrentValue = NULL;
		$this->NIDN->OldValue = $this->NIDN->CurrentValue;
		$this->Nama->CurrentValue = NULL;
		$this->Nama->OldValue = $this->Nama->CurrentValue;
		$this->Status->CurrentValue = NULL;
		$this->Status->OldValue = $this->Status->CurrentValue;
		$this->NoSKStatus->CurrentValue = NULL;
		$this->NoSKStatus->OldValue = $this->NoSKStatus->CurrentValue;
		$this->TMTKerja->CurrentValue = NULL;
		$this->TMTKerja->OldValue = $this->TMTKerja->CurrentValue;
		$this->NoKtp->CurrentValue = NULL;
		$this->NoKtp->OldValue = $this->NoKtp->CurrentValue;
		$this->Tmp_Lahir->CurrentValue = NULL;
		$this->Tmp_Lahir->OldValue = $this->Tmp_Lahir->CurrentValue;
		$this->Tgl_Lahir->CurrentValue = NULL;
		$this->Tgl_Lahir->OldValue = $this->Tgl_Lahir->CurrentValue;
		$this->Kelamin->CurrentValue = NULL;
		$this->Kelamin->OldValue = $this->Kelamin->CurrentValue;
		$this->Alamat->CurrentValue = NULL;
		$this->Alamat->OldValue = $this->Alamat->CurrentValue;
		$this->Kelurahan->CurrentValue = NULL;
		$this->Kelurahan->OldValue = $this->Kelurahan->CurrentValue;
		$this->Kecamatan->CurrentValue = NULL;
		$this->Kecamatan->OldValue = $this->Kecamatan->CurrentValue;
		$this->Kota->CurrentValue = NULL;
		$this->Kota->OldValue = $this->Kota->CurrentValue;
		$this->Kode_pos->CurrentValue = NULL;
		$this->Kode_pos->OldValue = $this->Kode_pos->CurrentValue;
		$this->Phone->CurrentValue = NULL;
		$this->Phone->OldValue = $this->Phone->CurrentValue;
		$this->TlpRumah->CurrentValue = NULL;
		$this->TlpRumah->OldValue = $this->TlpRumah->CurrentValue;
		$this->KodeJafung->CurrentValue = NULL;
		$this->KodeJafung->OldValue = $this->KodeJafung->CurrentValue;
		$this->Gol->CurrentValue = NULL;
		$this->Gol->OldValue = $this->Gol->CurrentValue;
		$this->TMTJafung->CurrentValue = NULL;
		$this->TMTJafung->OldValue = $this->TMTJafung->CurrentValue;
		$this->PendidikanTerakhir->CurrentValue = NULL;
		$this->PendidikanTerakhir->OldValue = $this->PendidikanTerakhir->CurrentValue;
		$this->Status_Dosen->CurrentValue = NULL;
		$this->Status_Dosen->OldValue = $this->Status_Dosen->CurrentValue;
		$this->Kode_Jp->CurrentValue = NULL;
		$this->Kode_Jp->OldValue = $this->Kode_Jp->CurrentValue;
		$this->photo->Upload->DbValue = NULL;
		$this->photo->OldValue = $this->photo->Upload->DbValue;
		$this->PictureName->CurrentValue = NULL;
		$this->PictureName->OldValue = $this->PictureName->CurrentValue;
		$this->PictureSize->CurrentValue = NULL;
		$this->PictureSize->OldValue = $this->PictureSize->CurrentValue;
		$this->PictureType->CurrentValue = NULL;
		$this->PictureType->OldValue = $this->PictureType->CurrentValue;
		$this->PictureWidth->CurrentValue = NULL;
		$this->PictureWidth->OldValue = $this->PictureWidth->CurrentValue;
		$this->PictureHeight->CurrentValue = NULL;
		$this->PictureHeight->OldValue = $this->PictureHeight->CurrentValue;
		$this->Norek->CurrentValue = NULL;
		$this->Norek->OldValue = $this->Norek->CurrentValue;
		$this->Password->CurrentValue = NULL;
		$this->Password->OldValue = $this->Password->CurrentValue;
		$this->NPWP->CurrentValue = NULL;
		$this->NPWP->OldValue = $this->NPWP->CurrentValue;
		$this->_Email->CurrentValue = NULL;
		$this->_Email->OldValue = $this->_Email->CurrentValue;
		$this->KewajibanSKS->CurrentValue = NULL;
		$this->KewajibanSKS->OldValue = $this->KewajibanSKS->CurrentValue;
		$this->IDFIng->CurrentValue = NULL;
		$this->IDFIng->OldValue = $this->IDFIng->CurrentValue;
		$this->Profile->CurrentValue = NULL;
		$this->Profile->OldValue = $this->Profile->CurrentValue;
		$this->ttd->Upload->DbValue = NULL;
		$this->ttd->OldValue = $this->ttd->Upload->DbValue;
	}

	// Load basic search values
	protected function loadBasicSearchValues()
	{
		$this->BasicSearch->setKeyword(Get(Config("TABLE_BASIC_SEARCH"), ""), FALSE);
		if ($this->BasicSearch->Keyword != "" && $this->Command == "")
			$this->Command = "search";
		$this->BasicSearch->setType(Get(Config("TABLE_BASIC_SEARCH_TYPE"), ""), FALSE);
	}

	// Load search values for validation
	protected function loadSearchValues()
	{

		// Load search values
		$got = FALSE;

		// NIDN
		if (!$this->isAddOrEdit() && $this->NIDN->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->NIDN->AdvancedSearch->SearchValue != "" || $this->NIDN->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// Nama
		if (!$this->isAddOrEdit() && $this->Nama->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->Nama->AdvancedSearch->SearchValue != "" || $this->Nama->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// Status
		if (!$this->isAddOrEdit() && $this->Status->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->Status->AdvancedSearch->SearchValue != "" || $this->Status->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// NoSKStatus
		if (!$this->isAddOrEdit() && $this->NoSKStatus->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->NoSKStatus->AdvancedSearch->SearchValue != "" || $this->NoSKStatus->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// TMTKerja
		if (!$this->isAddOrEdit() && $this->TMTKerja->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->TMTKerja->AdvancedSearch->SearchValue != "" || $this->TMTKerja->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// NoKtp
		if (!$this->isAddOrEdit() && $this->NoKtp->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->NoKtp->AdvancedSearch->SearchValue != "" || $this->NoKtp->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// Tmp_Lahir
		if (!$this->isAddOrEdit() && $this->Tmp_Lahir->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->Tmp_Lahir->AdvancedSearch->SearchValue != "" || $this->Tmp_Lahir->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// Tgl_Lahir
		if (!$this->isAddOrEdit() && $this->Tgl_Lahir->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->Tgl_Lahir->AdvancedSearch->SearchValue != "" || $this->Tgl_Lahir->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// Kelamin
		if (!$this->isAddOrEdit() && $this->Kelamin->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->Kelamin->AdvancedSearch->SearchValue != "" || $this->Kelamin->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// Alamat
		if (!$this->isAddOrEdit() && $this->Alamat->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->Alamat->AdvancedSearch->SearchValue != "" || $this->Alamat->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// Kelurahan
		if (!$this->isAddOrEdit() && $this->Kelurahan->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->Kelurahan->AdvancedSearch->SearchValue != "" || $this->Kelurahan->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// Kecamatan
		if (!$this->isAddOrEdit() && $this->Kecamatan->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->Kecamatan->AdvancedSearch->SearchValue != "" || $this->Kecamatan->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// Kota
		if (!$this->isAddOrEdit() && $this->Kota->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->Kota->AdvancedSearch->SearchValue != "" || $this->Kota->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// Kode_pos
		if (!$this->isAddOrEdit() && $this->Kode_pos->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->Kode_pos->AdvancedSearch->SearchValue != "" || $this->Kode_pos->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// Phone
		if (!$this->isAddOrEdit() && $this->Phone->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->Phone->AdvancedSearch->SearchValue != "" || $this->Phone->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// TlpRumah
		if (!$this->isAddOrEdit() && $this->TlpRumah->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->TlpRumah->AdvancedSearch->SearchValue != "" || $this->TlpRumah->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// KodeJafung
		if (!$this->isAddOrEdit() && $this->KodeJafung->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->KodeJafung->AdvancedSearch->SearchValue != "" || $this->KodeJafung->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// Gol
		if (!$this->isAddOrEdit() && $this->Gol->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->Gol->AdvancedSearch->SearchValue != "" || $this->Gol->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// TMTJafung
		if (!$this->isAddOrEdit() && $this->TMTJafung->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->TMTJafung->AdvancedSearch->SearchValue != "" || $this->TMTJafung->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// PendidikanTerakhir
		if (!$this->isAddOrEdit() && $this->PendidikanTerakhir->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->PendidikanTerakhir->AdvancedSearch->SearchValue != "" || $this->PendidikanTerakhir->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// Status_Dosen
		if (!$this->isAddOrEdit() && $this->Status_Dosen->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->Status_Dosen->AdvancedSearch->SearchValue != "" || $this->Status_Dosen->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// Kode_Jp
		if (!$this->isAddOrEdit() && $this->Kode_Jp->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->Kode_Jp->AdvancedSearch->SearchValue != "" || $this->Kode_Jp->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// PictureName
		if (!$this->isAddOrEdit() && $this->PictureName->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->PictureName->AdvancedSearch->SearchValue != "" || $this->PictureName->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// PictureSize
		if (!$this->isAddOrEdit() && $this->PictureSize->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->PictureSize->AdvancedSearch->SearchValue != "" || $this->PictureSize->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// PictureType
		if (!$this->isAddOrEdit() && $this->PictureType->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->PictureType->AdvancedSearch->SearchValue != "" || $this->PictureType->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// PictureWidth
		if (!$this->isAddOrEdit() && $this->PictureWidth->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->PictureWidth->AdvancedSearch->SearchValue != "" || $this->PictureWidth->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// PictureHeight
		if (!$this->isAddOrEdit() && $this->PictureHeight->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->PictureHeight->AdvancedSearch->SearchValue != "" || $this->PictureHeight->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// Norek
		if (!$this->isAddOrEdit() && $this->Norek->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->Norek->AdvancedSearch->SearchValue != "" || $this->Norek->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// Password
		if (!$this->isAddOrEdit() && $this->Password->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->Password->AdvancedSearch->SearchValue != "" || $this->Password->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// NPWP
		if (!$this->isAddOrEdit() && $this->NPWP->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->NPWP->AdvancedSearch->SearchValue != "" || $this->NPWP->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// Email
		if (!$this->isAddOrEdit() && $this->_Email->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->_Email->AdvancedSearch->SearchValue != "" || $this->_Email->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// KewajibanSKS
		if (!$this->isAddOrEdit() && $this->KewajibanSKS->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->KewajibanSKS->AdvancedSearch->SearchValue != "" || $this->KewajibanSKS->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// IDFIng
		if (!$this->isAddOrEdit() && $this->IDFIng->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->IDFIng->AdvancedSearch->SearchValue != "" || $this->IDFIng->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// Profile
		if (!$this->isAddOrEdit() && $this->Profile->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->Profile->AdvancedSearch->SearchValue != "" || $this->Profile->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// ttd
		if (!$this->isAddOrEdit() && $this->ttd->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->ttd->AdvancedSearch->SearchValue != "" || $this->ttd->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}
		return $got;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;

		// Check field name 'NIDN' first before field var 'x_NIDN'
		$val = $CurrentForm->hasValue("NIDN") ? $CurrentForm->getValue("NIDN") : $CurrentForm->getValue("x_NIDN");
		if (!$this->NIDN->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->NIDN->Visible = FALSE; // Disable update for API request
			else
				$this->NIDN->setFormValue($val);
		}
		if ($CurrentForm->hasValue("o_NIDN"))
			$this->NIDN->setOldValue($CurrentForm->getValue("o_NIDN"));

		// Check field name 'Nama' first before field var 'x_Nama'
		$val = $CurrentForm->hasValue("Nama") ? $CurrentForm->getValue("Nama") : $CurrentForm->getValue("x_Nama");
		if (!$this->Nama->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->Nama->Visible = FALSE; // Disable update for API request
			else
				$this->Nama->setFormValue($val);
		}

		// Check field name 'Status' first before field var 'x_Status'
		$val = $CurrentForm->hasValue("Status") ? $CurrentForm->getValue("Status") : $CurrentForm->getValue("x_Status");
		if (!$this->Status->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->Status->Visible = FALSE; // Disable update for API request
			else
				$this->Status->setFormValue($val);
		}

		// Check field name 'Kode_Jp' first before field var 'x_Kode_Jp'
		$val = $CurrentForm->hasValue("Kode_Jp") ? $CurrentForm->getValue("Kode_Jp") : $CurrentForm->getValue("x_Kode_Jp");
		if (!$this->Kode_Jp->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->Kode_Jp->Visible = FALSE; // Disable update for API request
			else
				$this->Kode_Jp->setFormValue($val);
		}
		$this->ttd->OldUploadPath = 'files/ttd/';
		$this->ttd->UploadPath = $this->ttd->OldUploadPath;
		$this->getUploadFiles(); // Get upload files
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->NIDN->CurrentValue = $this->NIDN->FormValue;
		$this->Nama->CurrentValue = $this->Nama->FormValue;
		$this->Status->CurrentValue = $this->Status->FormValue;
		$this->Kode_Jp->CurrentValue = $this->Kode_Jp->FormValue;
	}

	// Load recordset
	public function loadRecordset($offset = -1, $rowcnt = -1)
	{

		// Load List page SQL
		$sql = $this->getListSql();
		$conn = $this->getConnection();

		// Load recordset
		$dbtype = GetConnectionType($this->Dbid);
		if ($this->UseSelectLimit) {
			$conn->raiseErrorFn = Config("ERROR_FUNC");
			if ($dbtype == "MSSQL") {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset, ["_hasOrderBy" => trim($this->getOrderBy()) || trim($this->getSessionOrderBy())]);
			} else {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset);
			}
			$conn->raiseErrorFn = "";
		} else {
			$rs = LoadRecordset($sql, $conn);
		}

		// Call Recordset Selected event
		$this->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = $this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			if (!$this->EventCancelled)
				$this->HashValue = $this->getRowHash($rs); // Get hash value for record
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->NIDN->setDbValue($row['NIDN']);
		$this->Nama->setDbValue($row['Nama']);
		$this->Status->setDbValue($row['Status']);
		$this->NoSKStatus->setDbValue($row['NoSKStatus']);
		$this->TMTKerja->setDbValue($row['TMTKerja']);
		$this->NoKtp->setDbValue($row['NoKtp']);
		$this->Tmp_Lahir->setDbValue($row['Tmp_Lahir']);
		$this->Tgl_Lahir->setDbValue($row['Tgl_Lahir']);
		$this->Kelamin->setDbValue($row['Kelamin']);
		$this->Alamat->setDbValue($row['Alamat']);
		$this->Kelurahan->setDbValue($row['Kelurahan']);
		$this->Kecamatan->setDbValue($row['Kecamatan']);
		$this->Kota->setDbValue($row['Kota']);
		$this->Kode_pos->setDbValue($row['Kode_pos']);
		$this->Phone->setDbValue($row['Phone']);
		$this->TlpRumah->setDbValue($row['TlpRumah']);
		$this->KodeJafung->setDbValue($row['KodeJafung']);
		$this->Gol->setDbValue($row['Gol']);
		$this->TMTJafung->setDbValue($row['TMTJafung']);
		$this->PendidikanTerakhir->setDbValue($row['PendidikanTerakhir']);
		$this->Status_Dosen->setDbValue($row['Status_Dosen']);
		$this->Kode_Jp->setDbValue($row['Kode_Jp']);
		$this->photo->Upload->DbValue = $row['photo'];
		if (is_array($this->photo->Upload->DbValue) || is_object($this->photo->Upload->DbValue)) // Byte array
			$this->photo->Upload->DbValue = BytesToString($this->photo->Upload->DbValue);
		$this->PictureName->setDbValue($row['PictureName']);
		$this->PictureSize->setDbValue($row['PictureSize']);
		$this->PictureType->setDbValue($row['PictureType']);
		$this->PictureWidth->setDbValue($row['PictureWidth']);
		$this->PictureHeight->setDbValue($row['PictureHeight']);
		$this->Norek->setDbValue($row['Norek']);
		$this->Password->setDbValue($row['Password']);
		$this->NPWP->setDbValue($row['NPWP']);
		$this->_Email->setDbValue($row['Email']);
		$this->KewajibanSKS->setDbValue($row['KewajibanSKS']);
		$this->IDFIng->setDbValue($row['IDFIng']);
		$this->Profile->setDbValue($row['Profile']);
		$this->ttd->Upload->DbValue = $row['ttd'];
		$this->ttd->setDbValue($this->ttd->Upload->DbValue);
	}

	// Return a row with default values
	protected function newRow()
	{
		$this->loadDefaultValues();
		$row = [];
		$row['NIDN'] = $this->NIDN->CurrentValue;
		$row['Nama'] = $this->Nama->CurrentValue;
		$row['Status'] = $this->Status->CurrentValue;
		$row['NoSKStatus'] = $this->NoSKStatus->CurrentValue;
		$row['TMTKerja'] = $this->TMTKerja->CurrentValue;
		$row['NoKtp'] = $this->NoKtp->CurrentValue;
		$row['Tmp_Lahir'] = $this->Tmp_Lahir->CurrentValue;
		$row['Tgl_Lahir'] = $this->Tgl_Lahir->CurrentValue;
		$row['Kelamin'] = $this->Kelamin->CurrentValue;
		$row['Alamat'] = $this->Alamat->CurrentValue;
		$row['Kelurahan'] = $this->Kelurahan->CurrentValue;
		$row['Kecamatan'] = $this->Kecamatan->CurrentValue;
		$row['Kota'] = $this->Kota->CurrentValue;
		$row['Kode_pos'] = $this->Kode_pos->CurrentValue;
		$row['Phone'] = $this->Phone->CurrentValue;
		$row['TlpRumah'] = $this->TlpRumah->CurrentValue;
		$row['KodeJafung'] = $this->KodeJafung->CurrentValue;
		$row['Gol'] = $this->Gol->CurrentValue;
		$row['TMTJafung'] = $this->TMTJafung->CurrentValue;
		$row['PendidikanTerakhir'] = $this->PendidikanTerakhir->CurrentValue;
		$row['Status_Dosen'] = $this->Status_Dosen->CurrentValue;
		$row['Kode_Jp'] = $this->Kode_Jp->CurrentValue;
		$row['photo'] = $this->photo->Upload->DbValue;
		$row['PictureName'] = $this->PictureName->CurrentValue;
		$row['PictureSize'] = $this->PictureSize->CurrentValue;
		$row['PictureType'] = $this->PictureType->CurrentValue;
		$row['PictureWidth'] = $this->PictureWidth->CurrentValue;
		$row['PictureHeight'] = $this->PictureHeight->CurrentValue;
		$row['Norek'] = $this->Norek->CurrentValue;
		$row['Password'] = $this->Password->CurrentValue;
		$row['NPWP'] = $this->NPWP->CurrentValue;
		$row['Email'] = $this->_Email->CurrentValue;
		$row['KewajibanSKS'] = $this->KewajibanSKS->CurrentValue;
		$row['IDFIng'] = $this->IDFIng->CurrentValue;
		$row['Profile'] = $this->Profile->CurrentValue;
		$row['ttd'] = $this->ttd->Upload->DbValue;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("NIDN")) != "")
			$this->NIDN->OldValue = $this->getKey("NIDN"); // NIDN
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = $this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		$this->ViewUrl = $this->getViewUrl();
		$this->EditUrl = $this->getEditUrl();
		$this->InlineEditUrl = $this->getInlineEditUrl();
		$this->CopyUrl = $this->getCopyUrl();
		$this->InlineCopyUrl = $this->getInlineCopyUrl();
		$this->DeleteUrl = $this->getDeleteUrl();

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// NIDN
		// Nama
		// Status
		// NoSKStatus
		// TMTKerja
		// NoKtp
		// Tmp_Lahir
		// Tgl_Lahir
		// Kelamin
		// Alamat
		// Kelurahan
		// Kecamatan
		// Kota
		// Kode_pos
		// Phone
		// TlpRumah
		// KodeJafung
		// Gol
		// TMTJafung
		// PendidikanTerakhir
		// Status_Dosen
		// Kode_Jp
		// photo
		// PictureName
		// PictureSize
		// PictureType
		// PictureWidth
		// PictureHeight
		// Norek
		// Password
		// NPWP
		// Email
		// KewajibanSKS
		// IDFIng
		// Profile
		// ttd

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// NIDN
			$this->NIDN->ViewValue = $this->NIDN->CurrentValue;
			$this->NIDN->ViewCustomAttributes = "";

			// Nama
			$this->Nama->ViewValue = $this->Nama->CurrentValue;
			$this->Nama->ViewCustomAttributes = "";

			// Status
			if (strval($this->Status->CurrentValue) != "") {
				$this->Status->ViewValue = $this->Status->optionCaption($this->Status->CurrentValue);
			} else {
				$this->Status->ViewValue = NULL;
			}
			$this->Status->ViewCustomAttributes = "";

			// NoSKStatus
			$this->NoSKStatus->ViewValue = $this->NoSKStatus->CurrentValue;
			$this->NoSKStatus->ViewCustomAttributes = "";

			// TMTKerja
			$this->TMTKerja->ViewValue = $this->TMTKerja->CurrentValue;
			$this->TMTKerja->ViewValue = FormatDateTime($this->TMTKerja->ViewValue, 0);
			$this->TMTKerja->ViewCustomAttributes = "";

			// NoKtp
			$this->NoKtp->ViewValue = $this->NoKtp->CurrentValue;
			$this->NoKtp->ViewCustomAttributes = "";

			// Tmp_Lahir
			$this->Tmp_Lahir->ViewValue = $this->Tmp_Lahir->CurrentValue;
			$this->Tmp_Lahir->ViewCustomAttributes = "";

			// Tgl_Lahir
			$this->Tgl_Lahir->ViewValue = $this->Tgl_Lahir->CurrentValue;
			$this->Tgl_Lahir->ViewValue = FormatDateTime($this->Tgl_Lahir->ViewValue, 0);
			$this->Tgl_Lahir->ViewCustomAttributes = "";

			// Kelamin
			$this->Kelamin->ViewValue = $this->Kelamin->CurrentValue;
			$this->Kelamin->ViewCustomAttributes = "";

			// Alamat
			$this->Alamat->ViewValue = $this->Alamat->CurrentValue;
			$this->Alamat->ViewCustomAttributes = "";

			// Kelurahan
			$this->Kelurahan->ViewValue = $this->Kelurahan->CurrentValue;
			$this->Kelurahan->ViewCustomAttributes = "";

			// Kecamatan
			$this->Kecamatan->ViewValue = $this->Kecamatan->CurrentValue;
			$this->Kecamatan->ViewCustomAttributes = "";

			// Kota
			$this->Kota->ViewValue = $this->Kota->CurrentValue;
			$this->Kota->ViewCustomAttributes = "";

			// Kode_pos
			$this->Kode_pos->ViewValue = $this->Kode_pos->CurrentValue;
			$this->Kode_pos->ViewCustomAttributes = "";

			// Phone
			$this->Phone->ViewValue = $this->Phone->CurrentValue;
			$this->Phone->ViewCustomAttributes = "";

			// TlpRumah
			$this->TlpRumah->ViewValue = $this->TlpRumah->CurrentValue;
			$this->TlpRumah->ViewCustomAttributes = "";

			// KodeJafung
			$this->KodeJafung->ViewValue = $this->KodeJafung->CurrentValue;
			$this->KodeJafung->ViewCustomAttributes = "";

			// Gol
			$this->Gol->ViewValue = $this->Gol->CurrentValue;
			$this->Gol->ViewCustomAttributes = "";

			// TMTJafung
			$this->TMTJafung->ViewValue = $this->TMTJafung->CurrentValue;
			$this->TMTJafung->ViewValue = FormatDateTime($this->TMTJafung->ViewValue, 0);
			$this->TMTJafung->ViewCustomAttributes = "";

			// PendidikanTerakhir
			$this->PendidikanTerakhir->ViewValue = $this->PendidikanTerakhir->CurrentValue;
			$this->PendidikanTerakhir->ViewCustomAttributes = "";

			// Status_Dosen
			$this->Status_Dosen->ViewValue = $this->Status_Dosen->CurrentValue;
			$this->Status_Dosen->ViewCustomAttributes = "";

			// Kode_Jp
			$curVal = strval($this->Kode_Jp->CurrentValue);
			if ($curVal != "") {
				$this->Kode_Jp->ViewValue = $this->Kode_Jp->lookupCacheOption($curVal);
				if ($this->Kode_Jp->ViewValue === NULL) { // Lookup from database
					$filterWrk = "[Kode_Jp]" . SearchString("=", $curVal, DATATYPE_STRING, "");
					$sqlWrk = $this->Kode_Jp->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = [];
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->Kode_Jp->ViewValue = $this->Kode_Jp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->Kode_Jp->ViewValue = $this->Kode_Jp->CurrentValue;
					}
				}
			} else {
				$this->Kode_Jp->ViewValue = NULL;
			}
			$this->Kode_Jp->ViewCustomAttributes = "";

			// PictureName
			$this->PictureName->ViewValue = $this->PictureName->CurrentValue;
			$this->PictureName->ViewCustomAttributes = "";

			// PictureSize
			$this->PictureSize->ViewValue = $this->PictureSize->CurrentValue;
			$this->PictureSize->ViewValue = FormatNumber($this->PictureSize->ViewValue, 2, -2, -2, -2);
			$this->PictureSize->ViewCustomAttributes = "";

			// PictureType
			$this->PictureType->ViewValue = $this->PictureType->CurrentValue;
			$this->PictureType->ViewCustomAttributes = "";

			// PictureWidth
			$this->PictureWidth->ViewValue = $this->PictureWidth->CurrentValue;
			$this->PictureWidth->ViewValue = FormatNumber($this->PictureWidth->ViewValue, 2, -2, -2, -2);
			$this->PictureWidth->ViewCustomAttributes = "";

			// PictureHeight
			$this->PictureHeight->ViewValue = $this->PictureHeight->CurrentValue;
			$this->PictureHeight->ViewValue = FormatNumber($this->PictureHeight->ViewValue, 2, -2, -2, -2);
			$this->PictureHeight->ViewCustomAttributes = "";

			// Norek
			$this->Norek->ViewValue = $this->Norek->CurrentValue;
			$this->Norek->ViewCustomAttributes = "";

			// Password
			$this->Password->ViewValue = $this->Password->CurrentValue;
			$this->Password->ViewCustomAttributes = "";

			// NPWP
			$this->NPWP->ViewValue = $this->NPWP->CurrentValue;
			$this->NPWP->ViewCustomAttributes = "";

			// Email
			$this->_Email->ViewValue = $this->_Email->CurrentValue;
			$this->_Email->ViewCustomAttributes = "";

			// KewajibanSKS
			$this->KewajibanSKS->ViewValue = $this->KewajibanSKS->CurrentValue;
			$this->KewajibanSKS->ViewValue = FormatNumber($this->KewajibanSKS->ViewValue, 0, -2, -2, -2);
			$this->KewajibanSKS->ViewCustomAttributes = "";

			// IDFIng
			$this->IDFIng->ViewValue = $this->IDFIng->CurrentValue;
			$this->IDFIng->ViewCustomAttributes = "";

			// Profile
			$this->Profile->ViewValue = $this->Profile->CurrentValue;
			$this->Profile->ViewCustomAttributes = "";

			// ttd
			$this->ttd->UploadPath = 'files/ttd/';
			if (!EmptyValue($this->ttd->Upload->DbValue)) {
				$this->ttd->ImageWidth = 0;
				$this->ttd->ImageHeight = 90;
				$this->ttd->ImageAlt = $this->ttd->alt();
				$this->ttd->ViewValue = $this->ttd->Upload->DbValue;
			} else {
				$this->ttd->ViewValue = "";
			}
			$this->ttd->ViewCustomAttributes = "";

			// NIDN
			$this->NIDN->LinkCustomAttributes = "";
			$this->NIDN->HrefValue = "";
			$this->NIDN->TooltipValue = "";

			// Nama
			$this->Nama->LinkCustomAttributes = "";
			$this->Nama->HrefValue = "";
			$this->Nama->TooltipValue = "";

			// Status
			$this->Status->LinkCustomAttributes = "";
			$this->Status->HrefValue = "";
			$this->Status->TooltipValue = "";

			// Kode_Jp
			$this->Kode_Jp->LinkCustomAttributes = "";
			$this->Kode_Jp->HrefValue = "";
			$this->Kode_Jp->TooltipValue = "";

			// ttd
			$this->ttd->LinkCustomAttributes = "";
			$this->ttd->UploadPath = 'files/ttd/';
			if (!EmptyValue($this->ttd->Upload->DbValue)) {
				$this->ttd->HrefValue = GetFileUploadUrl($this->ttd, $this->ttd->htmlDecode($this->ttd->Upload->DbValue)); // Add prefix/suffix
				$this->ttd->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport())
					$this->ttd->HrefValue = FullUrl($this->ttd->HrefValue, "href");
			} else {
				$this->ttd->HrefValue = "";
			}
			$this->ttd->ExportHrefValue = $this->ttd->UploadPath . $this->ttd->Upload->DbValue;
			$this->ttd->TooltipValue = "";
			if ($this->ttd->UseColorbox) {
				if (EmptyValue($this->ttd->TooltipValue))
					$this->ttd->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
				$this->ttd->LinkAttrs["data-rel"] = "tblDosen_x" . $this->RowCount . "_ttd";
				$this->ttd->LinkAttrs->appendClass("ew-lightbox");
			}
		} elseif ($this->RowType == ROWTYPE_ADD) { // Add row

			// NIDN
			$this->NIDN->EditAttrs["class"] = "form-control";
			$this->NIDN->EditCustomAttributes = "";
			if (!$this->NIDN->Raw)
				$this->NIDN->CurrentValue = HtmlDecode($this->NIDN->CurrentValue);
			$this->NIDN->EditValue = HtmlEncode($this->NIDN->CurrentValue);
			$this->NIDN->PlaceHolder = RemoveHtml($this->NIDN->caption());

			// Nama
			$this->Nama->EditAttrs["class"] = "form-control";
			$this->Nama->EditCustomAttributes = "";
			if (!$this->Nama->Raw)
				$this->Nama->CurrentValue = HtmlDecode($this->Nama->CurrentValue);
			$this->Nama->EditValue = HtmlEncode($this->Nama->CurrentValue);
			$this->Nama->PlaceHolder = RemoveHtml($this->Nama->caption());

			// Status
			$this->Status->EditAttrs["class"] = "form-control";
			$this->Status->EditCustomAttributes = "";
			$this->Status->EditValue = $this->Status->options(TRUE);

			// Kode_Jp
			$this->Kode_Jp->EditAttrs["class"] = "form-control";
			$this->Kode_Jp->EditCustomAttributes = "";

			// ttd
			$this->ttd->EditAttrs["class"] = "form-control";
			$this->ttd->EditCustomAttributes = "";
			$this->ttd->UploadPath = 'files/ttd/';
			if (!EmptyValue($this->ttd->Upload->DbValue)) {
				$this->ttd->ImageWidth = 0;
				$this->ttd->ImageHeight = 90;
				$this->ttd->ImageAlt = $this->ttd->alt();
				$this->ttd->EditValue = $this->ttd->Upload->DbValue;
			} else {
				$this->ttd->EditValue = "";
			}
			if (!EmptyValue($this->ttd->CurrentValue))
					if ($this->RowIndex == '$rowindex$')
						$this->ttd->Upload->FileName = "";
					else
						$this->ttd->Upload->FileName = $this->ttd->CurrentValue;
			if (is_numeric($this->RowIndex))
				RenderUploadField($this->ttd, $this->RowIndex);

			// Add refer script
			// NIDN

			$this->NIDN->LinkCustomAttributes = "";
			$this->NIDN->HrefValue = "";

			// Nama
			$this->Nama->LinkCustomAttributes = "";
			$this->Nama->HrefValue = "";

			// Status
			$this->Status->LinkCustomAttributes = "";
			$this->Status->HrefValue = "";

			// Kode_Jp
			$this->Kode_Jp->LinkCustomAttributes = "";
			$this->Kode_Jp->HrefValue = "";

			// ttd
			$this->ttd->LinkCustomAttributes = "";
			$this->ttd->UploadPath = 'files/ttd/';
			if (!EmptyValue($this->ttd->Upload->DbValue)) {
				$this->ttd->HrefValue = GetFileUploadUrl($this->ttd, $this->ttd->htmlDecode($this->ttd->Upload->DbValue)); // Add prefix/suffix
				$this->ttd->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport())
					$this->ttd->HrefValue = FullUrl($this->ttd->HrefValue, "href");
			} else {
				$this->ttd->HrefValue = "";
			}
			$this->ttd->ExportHrefValue = $this->ttd->UploadPath . $this->ttd->Upload->DbValue;
		} elseif ($this->RowType == ROWTYPE_EDIT) { // Edit row

			// NIDN
			$this->NIDN->EditAttrs["class"] = "form-control";
			$this->NIDN->EditCustomAttributes = "";
			if (!$this->NIDN->Raw)
				$this->NIDN->CurrentValue = HtmlDecode($this->NIDN->CurrentValue);
			$this->NIDN->EditValue = HtmlEncode($this->NIDN->CurrentValue);
			$this->NIDN->PlaceHolder = RemoveHtml($this->NIDN->caption());

			// Nama
			$this->Nama->EditAttrs["class"] = "form-control";
			$this->Nama->EditCustomAttributes = "";
			if (!$this->Nama->Raw)
				$this->Nama->CurrentValue = HtmlDecode($this->Nama->CurrentValue);
			$this->Nama->EditValue = HtmlEncode($this->Nama->CurrentValue);
			$this->Nama->PlaceHolder = RemoveHtml($this->Nama->caption());

			// Status
			$this->Status->EditAttrs["class"] = "form-control";
			$this->Status->EditCustomAttributes = "";
			$this->Status->EditValue = $this->Status->options(TRUE);

			// Kode_Jp
			$this->Kode_Jp->EditAttrs["class"] = "form-control";
			$this->Kode_Jp->EditCustomAttributes = "";
			$curVal = trim(strval($this->Kode_Jp->CurrentValue));
			if ($curVal != "")
				$this->Kode_Jp->ViewValue = $this->Kode_Jp->lookupCacheOption($curVal);
			else
				$this->Kode_Jp->ViewValue = $this->Kode_Jp->Lookup !== NULL && is_array($this->Kode_Jp->Lookup->Options) ? $curVal : NULL;
			if ($this->Kode_Jp->ViewValue !== NULL) { // Load from cache
				$this->Kode_Jp->EditValue = array_values($this->Kode_Jp->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "[Kode_Jp]" . SearchString("=", $this->Kode_Jp->CurrentValue, DATATYPE_STRING, "");
				}
				$sqlWrk = $this->Kode_Jp->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = $rswrk ? $rswrk->getRows() : [];
				if ($rswrk)
					$rswrk->close();
				$this->Kode_Jp->EditValue = $arwrk;
			}

			// ttd
			$this->ttd->EditAttrs["class"] = "form-control";
			$this->ttd->EditCustomAttributes = "";
			$this->ttd->UploadPath = 'files/ttd/';
			if (!EmptyValue($this->ttd->Upload->DbValue)) {
				$this->ttd->ImageWidth = 0;
				$this->ttd->ImageHeight = 90;
				$this->ttd->ImageAlt = $this->ttd->alt();
				$this->ttd->EditValue = $this->ttd->Upload->DbValue;
			} else {
				$this->ttd->EditValue = "";
			}
			if (!EmptyValue($this->ttd->CurrentValue))
					if ($this->RowIndex == '$rowindex$')
						$this->ttd->Upload->FileName = "";
					else
						$this->ttd->Upload->FileName = $this->ttd->CurrentValue;
			if (is_numeric($this->RowIndex))
				RenderUploadField($this->ttd, $this->RowIndex);

			// Edit refer script
			// NIDN

			$this->NIDN->LinkCustomAttributes = "";
			$this->NIDN->HrefValue = "";

			// Nama
			$this->Nama->LinkCustomAttributes = "";
			$this->Nama->HrefValue = "";

			// Status
			$this->Status->LinkCustomAttributes = "";
			$this->Status->HrefValue = "";

			// Kode_Jp
			$this->Kode_Jp->LinkCustomAttributes = "";
			$this->Kode_Jp->HrefValue = "";

			// ttd
			$this->ttd->LinkCustomAttributes = "";
			$this->ttd->UploadPath = 'files/ttd/';
			if (!EmptyValue($this->ttd->Upload->DbValue)) {
				$this->ttd->HrefValue = GetFileUploadUrl($this->ttd, $this->ttd->htmlDecode($this->ttd->Upload->DbValue)); // Add prefix/suffix
				$this->ttd->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport())
					$this->ttd->HrefValue = FullUrl($this->ttd->HrefValue, "href");
			} else {
				$this->ttd->HrefValue = "";
			}
			$this->ttd->ExportHrefValue = $this->ttd->UploadPath . $this->ttd->Upload->DbValue;
		} elseif ($this->RowType == ROWTYPE_SEARCH) { // Search row

			// NIDN
			$this->NIDN->EditAttrs["class"] = "form-control";
			$this->NIDN->EditCustomAttributes = "";
			if (!$this->NIDN->Raw)
				$this->NIDN->AdvancedSearch->SearchValue = HtmlDecode($this->NIDN->AdvancedSearch->SearchValue);
			$this->NIDN->EditValue = HtmlEncode($this->NIDN->AdvancedSearch->SearchValue);
			$this->NIDN->PlaceHolder = RemoveHtml($this->NIDN->caption());

			// Nama
			$this->Nama->EditAttrs["class"] = "form-control";
			$this->Nama->EditCustomAttributes = "";
			if (!$this->Nama->Raw)
				$this->Nama->AdvancedSearch->SearchValue = HtmlDecode($this->Nama->AdvancedSearch->SearchValue);
			$this->Nama->EditValue = HtmlEncode($this->Nama->AdvancedSearch->SearchValue);
			$this->Nama->PlaceHolder = RemoveHtml($this->Nama->caption());

			// Status
			$this->Status->EditAttrs["class"] = "form-control";
			$this->Status->EditCustomAttributes = "";
			$this->Status->EditValue = $this->Status->options(TRUE);

			// Kode_Jp
			$this->Kode_Jp->EditAttrs["class"] = "form-control";
			$this->Kode_Jp->EditCustomAttributes = "";
			$curVal = trim(strval($this->Kode_Jp->AdvancedSearch->SearchValue));
			if ($curVal != "")
				$this->Kode_Jp->AdvancedSearch->ViewValue = $this->Kode_Jp->lookupCacheOption($curVal);
			else
				$this->Kode_Jp->AdvancedSearch->ViewValue = $this->Kode_Jp->Lookup !== NULL && is_array($this->Kode_Jp->Lookup->Options) ? $curVal : NULL;
			if ($this->Kode_Jp->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->Kode_Jp->EditValue = array_values($this->Kode_Jp->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "[Kode_Jp]" . SearchString("=", $this->Kode_Jp->AdvancedSearch->SearchValue, DATATYPE_STRING, "");
				}
				$sqlWrk = $this->Kode_Jp->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = $rswrk ? $rswrk->getRows() : [];
				if ($rswrk)
					$rswrk->close();
				$this->Kode_Jp->EditValue = $arwrk;
			}

			// ttd
			$this->ttd->EditAttrs["class"] = "form-control";
			$this->ttd->EditCustomAttributes = "";
			if (!$this->ttd->Raw)
				$this->ttd->AdvancedSearch->SearchValue = HtmlDecode($this->ttd->AdvancedSearch->SearchValue);
			$this->ttd->EditValue = HtmlEncode($this->ttd->AdvancedSearch->SearchValue);
			$this->ttd->PlaceHolder = RemoveHtml($this->ttd->caption());
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType != ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate search
	protected function validateSearch()
	{
		global $SearchError;

		// Initialize
		$SearchError = "";

		// Check if validation required
		if (!Config("SERVER_VALIDATE"))
			return TRUE;

		// Return validate result
		$validateSearch = ($SearchError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateSearch = $validateSearch && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError != "") {
			AddMessage($SearchError, $formCustomError);
		}
		return $validateSearch;
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!Config("SERVER_VALIDATE"))
			return ($FormError == "");
		if ($this->NIDN->Required) {
			if (!$this->NIDN->IsDetailKey && $this->NIDN->FormValue != NULL && $this->NIDN->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->NIDN->caption(), $this->NIDN->RequiredErrorMessage));
			}
		}
		if ($this->Nama->Required) {
			if (!$this->Nama->IsDetailKey && $this->Nama->FormValue != NULL && $this->Nama->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Nama->caption(), $this->Nama->RequiredErrorMessage));
			}
		}
		if ($this->Status->Required) {
			if (!$this->Status->IsDetailKey && $this->Status->FormValue != NULL && $this->Status->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Status->caption(), $this->Status->RequiredErrorMessage));
			}
		}
		if ($this->Kode_Jp->Required) {
			if (!$this->Kode_Jp->IsDetailKey && $this->Kode_Jp->FormValue != NULL && $this->Kode_Jp->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Kode_Jp->caption(), $this->Kode_Jp->RequiredErrorMessage));
			}
		}
		if ($this->ttd->Required) {
			if ($this->ttd->Upload->FileName == "" && !$this->ttd->Upload->KeepFile) {
				AddMessage($FormError, str_replace("%s", $this->ttd->caption(), $this->ttd->RequiredErrorMessage));
			}
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError != "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Update record based on key values
	protected function editRow()
	{
		global $Security, $Language;
		$oldKeyFilter = $this->getRecordFilter();
		$filter = $this->applyUserIDFilters($oldKeyFilter);
		$conn = $this->getConnection();
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn->raiseErrorFn = Config("ERROR_FUNC");
		$rs = $conn->execute($sql);
		$conn->raiseErrorFn = "";
		if ($rs === FALSE)
			return FALSE;
		if ($rs->EOF) {
			$this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
			$editRow = FALSE; // Update Failed
		} else {

			// Save old values
			$rsold = &$rs->fields;
			$this->loadDbValues($rsold);
			$this->ttd->OldUploadPath = 'files/ttd/';
			$this->ttd->UploadPath = $this->ttd->OldUploadPath;
			$rsnew = [];

			// NIDN
			$this->NIDN->setDbValueDef($rsnew, $this->NIDN->CurrentValue, "", $this->NIDN->ReadOnly);

			// Nama
			$this->Nama->setDbValueDef($rsnew, $this->Nama->CurrentValue, NULL, $this->Nama->ReadOnly);

			// Status
			$this->Status->setDbValueDef($rsnew, $this->Status->CurrentValue, NULL, $this->Status->ReadOnly);

			// Kode_Jp
			$this->Kode_Jp->setDbValueDef($rsnew, $this->Kode_Jp->CurrentValue, NULL, $this->Kode_Jp->ReadOnly);

			// ttd
			if ($this->ttd->Visible && !$this->ttd->ReadOnly && !$this->ttd->Upload->KeepFile) {
				$this->ttd->Upload->DbValue = $rsold['ttd']; // Get original value
				if ($this->ttd->Upload->FileName == "") {
					$rsnew['ttd'] = NULL;
				} else {
					$rsnew['ttd'] = $this->ttd->Upload->FileName;
				}
			}
			if ($this->ttd->Visible && !$this->ttd->Upload->KeepFile) {
				$this->ttd->UploadPath = 'files/ttd/';
				$oldFiles = EmptyValue($this->ttd->Upload->DbValue) ? [] : [$this->ttd->htmlDecode($this->ttd->Upload->DbValue)];
				if (!EmptyValue($this->ttd->Upload->FileName)) {
					$newFiles = [$this->ttd->Upload->FileName];
					$NewFileCount = count($newFiles);
					for ($i = 0; $i < $NewFileCount; $i++) {
						if ($newFiles[$i] != "") {
							$file = $newFiles[$i];
							$tempPath = UploadTempPath($this->ttd, $this->ttd->Upload->Index);
							if (file_exists($tempPath . $file)) {
								if (Config("DELETE_UPLOADED_FILES")) {
									$oldFileFound = FALSE;
									$oldFileCount = count($oldFiles);
									for ($j = 0; $j < $oldFileCount; $j++) {
										$oldFile = $oldFiles[$j];
										if ($oldFile == $file) { // Old file found, no need to delete anymore
											array_splice($oldFiles, $j, 1);
											$oldFileFound = TRUE;
											break;
										}
									}
									if ($oldFileFound) // No need to check if file exists further
										continue;
								}
								$file1 = UniqueFilename($this->ttd->physicalUploadPath(), $file); // Get new file name
								if ($file1 != $file) { // Rename temp file
									while (file_exists($tempPath . $file1) || file_exists($this->ttd->physicalUploadPath() . $file1)) // Make sure no file name clash
										$file1 = UniqueFilename($this->ttd->physicalUploadPath(), $file1, TRUE); // Use indexed name
									rename($tempPath . $file, $tempPath . $file1);
									$newFiles[$i] = $file1;
								}
							}
						}
					}
					$this->ttd->Upload->DbValue = empty($oldFiles) ? "" : implode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $oldFiles);
					$this->ttd->Upload->FileName = implode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $newFiles);
					$this->ttd->setDbValueDef($rsnew, $this->ttd->Upload->FileName, NULL, $this->ttd->ReadOnly);
				}
			}

			// Call Row Updating event
			$updateRow = $this->Row_Updating($rsold, $rsnew);

			// Check for duplicate key when key changed
			if ($updateRow) {
				$newKeyFilter = $this->getRecordFilter($rsnew);
				if ($newKeyFilter != $oldKeyFilter) {
					$rsChk = $this->loadRs($newKeyFilter);
					if ($rsChk && !$rsChk->EOF) {
						$keyErrMsg = str_replace("%f", $newKeyFilter, $Language->phrase("DupKey"));
						$this->setFailureMessage($keyErrMsg);
						$rsChk->close();
						$updateRow = FALSE;
					}
				}
			}
			if ($updateRow) {
				$conn->raiseErrorFn = Config("ERROR_FUNC");
				if (count($rsnew) > 0)
					$editRow = $this->update($rsnew, "", $rsold);
				else
					$editRow = TRUE; // No field to update
				$conn->raiseErrorFn = "";
				if ($editRow) {
					if ($this->ttd->Visible && !$this->ttd->Upload->KeepFile) {
						$oldFiles = EmptyValue($this->ttd->Upload->DbValue) ? [] : [$this->ttd->htmlDecode($this->ttd->Upload->DbValue)];
						if (!EmptyValue($this->ttd->Upload->FileName)) {
							$newFiles = [$this->ttd->Upload->FileName];
							$newFiles2 = [$this->ttd->htmlDecode($rsnew['ttd'])];
							$newFileCount = count($newFiles);
							for ($i = 0; $i < $newFileCount; $i++) {
								if ($newFiles[$i] != "") {
									$file = UploadTempPath($this->ttd, $this->ttd->Upload->Index) . $newFiles[$i];
									if (file_exists($file)) {
										if (@$newFiles2[$i] != "") // Use correct file name
											$newFiles[$i] = $newFiles2[$i];
										if (!$this->ttd->Upload->SaveToFile($newFiles[$i], TRUE, $i)) { // Just replace
											$this->setFailureMessage($Language->phrase("UploadErrMsg7"));
											return FALSE;
										}
									}
								}
							}
						} else {
							$newFiles = [];
						}
						if (Config("DELETE_UPLOADED_FILES")) {
							foreach ($oldFiles as $oldFile) {
								if ($oldFile != "" && !in_array($oldFile, $newFiles))
									@unlink($this->ttd->oldPhysicalUploadPath() . $oldFile);
							}
						}
					}
				}
			} else {
				if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {

					// Use the message, do nothing
				} elseif ($this->CancelMessage != "") {
					$this->setFailureMessage($this->CancelMessage);
					$this->CancelMessage = "";
				} else {
					$this->setFailureMessage($Language->phrase("UpdateCancelled"));
				}
				$editRow = FALSE;
			}
		}

		// Call Row_Updated event
		if ($editRow)
			$this->Row_Updated($rsold, $rsnew);
		$rs->close();

		// Clean upload path if any
		if ($editRow) {

			// ttd
			CleanUploadTempPath($this->ttd, $this->ttd->Upload->Index);
		}

		// Write JSON for API request
		if (IsApi() && $editRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $editRow;
	}

	// Load row hash
	protected function loadRowHash()
	{
		$filter = $this->getRecordFilter();

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = $this->getConnection();
		$rsRow = $conn->Execute($sql);
		$this->HashValue = ($rsRow && !$rsRow->EOF) ? $this->getRowHash($rsRow) : ""; // Get hash value for record
		$rsRow->close();
	}

	// Get Row Hash
	public function getRowHash(&$rs)
	{
		if (!$rs)
			return "";
		$hash = "";
		$hash .= GetFieldHash($rs->fields('NIDN')); // NIDN
		$hash .= GetFieldHash($rs->fields('Nama')); // Nama
		$hash .= GetFieldHash($rs->fields('Status')); // Status
		$hash .= GetFieldHash($rs->fields('Kode_Jp')); // Kode_Jp
		$hash .= GetFieldHash($rs->fields('ttd')); // ttd
		return md5($hash);
	}

	// Add record
	protected function addRow($rsold = NULL)
	{
		global $Language, $Security;
		if ($this->NIDN->CurrentValue != "") { // Check field with unique index
			$filter = "([NIDN] = '" . AdjustSql($this->NIDN->CurrentValue, $this->Dbid) . "')";
			$rsChk = $this->loadRs($filter);
			if ($rsChk && !$rsChk->EOF) {
				$idxErrMsg = str_replace("%f", $this->NIDN->caption(), $Language->phrase("DupIndex"));
				$idxErrMsg = str_replace("%v", $this->NIDN->CurrentValue, $idxErrMsg);
				$this->setFailureMessage($idxErrMsg);
				$rsChk->close();
				return FALSE;
			}
		}
		$conn = $this->getConnection();

		// Load db values from rsold
		$this->loadDbValues($rsold);
		if ($rsold) {
			$this->ttd->OldUploadPath = 'files/ttd/';
			$this->ttd->UploadPath = $this->ttd->OldUploadPath;
		}
		$rsnew = [];

		// NIDN
		$this->NIDN->setDbValueDef($rsnew, $this->NIDN->CurrentValue, "", FALSE);

		// Nama
		$this->Nama->setDbValueDef($rsnew, $this->Nama->CurrentValue, NULL, FALSE);

		// Status
		$this->Status->setDbValueDef($rsnew, $this->Status->CurrentValue, NULL, FALSE);

		// Kode_Jp
		$this->Kode_Jp->setDbValueDef($rsnew, $this->Kode_Jp->CurrentValue, NULL, FALSE);

		// ttd
		if ($this->ttd->Visible && !$this->ttd->Upload->KeepFile) {
			$this->ttd->Upload->DbValue = ""; // No need to delete old file
			if ($this->ttd->Upload->FileName == "") {
				$rsnew['ttd'] = NULL;
			} else {
				$rsnew['ttd'] = $this->ttd->Upload->FileName;
			}
		}
		if ($this->ttd->Visible && !$this->ttd->Upload->KeepFile) {
			$this->ttd->UploadPath = 'files/ttd/';
			$oldFiles = EmptyValue($this->ttd->Upload->DbValue) ? [] : [$this->ttd->htmlDecode($this->ttd->Upload->DbValue)];
			if (!EmptyValue($this->ttd->Upload->FileName)) {
				$newFiles = [$this->ttd->Upload->FileName];
				$NewFileCount = count($newFiles);
				for ($i = 0; $i < $NewFileCount; $i++) {
					if ($newFiles[$i] != "") {
						$file = $newFiles[$i];
						$tempPath = UploadTempPath($this->ttd, $this->ttd->Upload->Index);
						if (file_exists($tempPath . $file)) {
							if (Config("DELETE_UPLOADED_FILES")) {
								$oldFileFound = FALSE;
								$oldFileCount = count($oldFiles);
								for ($j = 0; $j < $oldFileCount; $j++) {
									$oldFile = $oldFiles[$j];
									if ($oldFile == $file) { // Old file found, no need to delete anymore
										array_splice($oldFiles, $j, 1);
										$oldFileFound = TRUE;
										break;
									}
								}
								if ($oldFileFound) // No need to check if file exists further
									continue;
							}
							$file1 = UniqueFilename($this->ttd->physicalUploadPath(), $file); // Get new file name
							if ($file1 != $file) { // Rename temp file
								while (file_exists($tempPath . $file1) || file_exists($this->ttd->physicalUploadPath() . $file1)) // Make sure no file name clash
									$file1 = UniqueFilename($this->ttd->physicalUploadPath(), $file1, TRUE); // Use indexed name
								rename($tempPath . $file, $tempPath . $file1);
								$newFiles[$i] = $file1;
							}
						}
					}
				}
				$this->ttd->Upload->DbValue = empty($oldFiles) ? "" : implode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $oldFiles);
				$this->ttd->Upload->FileName = implode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $newFiles);
				$this->ttd->setDbValueDef($rsnew, $this->ttd->Upload->FileName, NULL, FALSE);
			}
		}

		// Call Row Inserting event
		$rs = ($rsold) ? $rsold->fields : NULL;
		$insertRow = $this->Row_Inserting($rs, $rsnew);

		// Check if key value entered
		if ($insertRow && $this->ValidateKey && strval($rsnew['NIDN']) == "") {
			$this->setFailureMessage($Language->phrase("InvalidKeyValue"));
			$insertRow = FALSE;
		}

		// Check for duplicate key
		if ($insertRow && $this->ValidateKey) {
			$filter = $this->getRecordFilter($rsnew);
			$rsChk = $this->loadRs($filter);
			if ($rsChk && !$rsChk->EOF) {
				$keyErrMsg = str_replace("%f", $filter, $Language->phrase("DupKey"));
				$this->setFailureMessage($keyErrMsg);
				$rsChk->close();
				$insertRow = FALSE;
			}
		}
		if ($insertRow) {
			$conn->raiseErrorFn = Config("ERROR_FUNC");
			$addRow = $this->insert($rsnew);
			$conn->raiseErrorFn = "";
			if ($addRow) {
				if ($this->ttd->Visible && !$this->ttd->Upload->KeepFile) {
					$oldFiles = EmptyValue($this->ttd->Upload->DbValue) ? [] : [$this->ttd->htmlDecode($this->ttd->Upload->DbValue)];
					if (!EmptyValue($this->ttd->Upload->FileName)) {
						$newFiles = [$this->ttd->Upload->FileName];
						$newFiles2 = [$this->ttd->htmlDecode($rsnew['ttd'])];
						$newFileCount = count($newFiles);
						for ($i = 0; $i < $newFileCount; $i++) {
							if ($newFiles[$i] != "") {
								$file = UploadTempPath($this->ttd, $this->ttd->Upload->Index) . $newFiles[$i];
								if (file_exists($file)) {
									if (@$newFiles2[$i] != "") // Use correct file name
										$newFiles[$i] = $newFiles2[$i];
									if (!$this->ttd->Upload->SaveToFile($newFiles[$i], TRUE, $i)) { // Just replace
										$this->setFailureMessage($Language->phrase("UploadErrMsg7"));
										return FALSE;
									}
								}
							}
						}
					} else {
						$newFiles = [];
					}
					if (Config("DELETE_UPLOADED_FILES")) {
						foreach ($oldFiles as $oldFile) {
							if ($oldFile != "" && !in_array($oldFile, $newFiles))
								@unlink($this->ttd->oldPhysicalUploadPath() . $oldFile);
						}
					}
				}
			}
		} else {
			if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage != "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->phrase("InsertCancelled"));
			}
			$addRow = FALSE;
		}
		if ($addRow) {

			// Call Row Inserted event
			$rs = ($rsold) ? $rsold->fields : NULL;
			$this->Row_Inserted($rs, $rsnew);
		}

		// Clean upload path if any
		if ($addRow) {

			// ttd
			CleanUploadTempPath($this->ttd, $this->ttd->Upload->Index);
		}

		// Write JSON for API request
		if (IsApi() && $addRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $addRow;
	}

	// Load advanced search
	public function loadAdvancedSearch()
	{
		$this->NIDN->AdvancedSearch->load();
		$this->Nama->AdvancedSearch->load();
		$this->Status->AdvancedSearch->load();
		$this->NoSKStatus->AdvancedSearch->load();
		$this->TMTKerja->AdvancedSearch->load();
		$this->NoKtp->AdvancedSearch->load();
		$this->Tmp_Lahir->AdvancedSearch->load();
		$this->Tgl_Lahir->AdvancedSearch->load();
		$this->Kelamin->AdvancedSearch->load();
		$this->Alamat->AdvancedSearch->load();
		$this->Kelurahan->AdvancedSearch->load();
		$this->Kecamatan->AdvancedSearch->load();
		$this->Kota->AdvancedSearch->load();
		$this->Kode_pos->AdvancedSearch->load();
		$this->Phone->AdvancedSearch->load();
		$this->TlpRumah->AdvancedSearch->load();
		$this->KodeJafung->AdvancedSearch->load();
		$this->Gol->AdvancedSearch->load();
		$this->TMTJafung->AdvancedSearch->load();
		$this->PendidikanTerakhir->AdvancedSearch->load();
		$this->Status_Dosen->AdvancedSearch->load();
		$this->Kode_Jp->AdvancedSearch->load();
		$this->PictureName->AdvancedSearch->load();
		$this->PictureSize->AdvancedSearch->load();
		$this->PictureType->AdvancedSearch->load();
		$this->PictureWidth->AdvancedSearch->load();
		$this->PictureHeight->AdvancedSearch->load();
		$this->Norek->AdvancedSearch->load();
		$this->Password->AdvancedSearch->load();
		$this->NPWP->AdvancedSearch->load();
		$this->_Email->AdvancedSearch->load();
		$this->KewajibanSKS->AdvancedSearch->load();
		$this->IDFIng->AdvancedSearch->load();
		$this->Profile->AdvancedSearch->load();
		$this->ttd->AdvancedSearch->load();
	}

	// Get export HTML tag
	protected function getExportTag($type, $custom = FALSE)
	{
		global $Language;
		if (SameText($type, "excel")) {
			if ($custom)
				return "<a href=\"#\" class=\"ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" onclick=\"return ew.export(document.ftblDosenlist, '" . $this->ExportExcelUrl . "', 'excel', true);\">" . $Language->phrase("ExportToExcel") . "</a>";
			else
				return "<a href=\"" . $this->ExportExcelUrl . "\" class=\"ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\">" . $Language->phrase("ExportToExcel") . "</a>";
		} elseif (SameText($type, "word")) {
			if ($custom)
				return "<a href=\"#\" class=\"ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" onclick=\"return ew.export(document.ftblDosenlist, '" . $this->ExportWordUrl . "', 'word', true);\">" . $Language->phrase("ExportToWord") . "</a>";
			else
				return "<a href=\"" . $this->ExportWordUrl . "\" class=\"ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\">" . $Language->phrase("ExportToWord") . "</a>";
		} elseif (SameText($type, "pdf")) {
			if ($custom)
				return "<a href=\"#\" class=\"ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" onclick=\"return ew.export(document.ftblDosenlist, '" . $this->ExportPdfUrl . "', 'pdf', true);\">" . $Language->phrase("ExportToPDF") . "</a>";
			else
				return "<a href=\"" . $this->ExportPdfUrl . "\" class=\"ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\">" . $Language->phrase("ExportToPDF") . "</a>";
		} elseif (SameText($type, "html")) {
			return "<a href=\"" . $this->ExportHtmlUrl . "\" class=\"ew-export-link ew-html\" title=\"" . HtmlEncode($Language->phrase("ExportToHtmlText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToHtmlText")) . "\">" . $Language->phrase("ExportToHtml") . "</a>";
		} elseif (SameText($type, "xml")) {
			return "<a href=\"" . $this->ExportXmlUrl . "\" class=\"ew-export-link ew-xml\" title=\"" . HtmlEncode($Language->phrase("ExportToXmlText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToXmlText")) . "\">" . $Language->phrase("ExportToXml") . "</a>";
		} elseif (SameText($type, "csv")) {
			return "<a href=\"" . $this->ExportCsvUrl . "\" class=\"ew-export-link ew-csv\" title=\"" . HtmlEncode($Language->phrase("ExportToCsvText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToCsvText")) . "\">" . $Language->phrase("ExportToCsv") . "</a>";
		} elseif (SameText($type, "email")) {
			$url = $custom ? ",url:'" . $this->pageUrl() . "export=email&amp;custom=1'" : "";
			return '<button id="emf_tblDosen" class="ew-export-link ew-email" title="' . $Language->phrase("ExportToEmailText") . '" data-caption="' . $Language->phrase("ExportToEmailText") . '" onclick="ew.emailDialogShow({lnk:\'emf_tblDosen\', hdr:ew.language.phrase(\'ExportToEmailText\'), f:document.ftblDosenlist, sel:false' . $url . '});">' . $Language->phrase("ExportToEmail") . '</button>';
		} elseif (SameText($type, "print")) {
			return "<a href=\"" . $this->ExportPrintUrl . "\" class=\"ew-export-link ew-print\" title=\"" . HtmlEncode($Language->phrase("PrinterFriendlyText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("PrinterFriendlyText")) . "\">" . $Language->phrase("PrinterFriendly") . "</a>";
		}
	}

	// Set up export options
	protected function setupExportOptions()
	{
		global $Language;

		// Printer friendly
		$item = &$this->ExportOptions->add("print");
		$item->Body = $this->getExportTag("print");
		$item->Visible = TRUE;

		// Export to Excel
		$item = &$this->ExportOptions->add("excel");
		$item->Body = $this->getExportTag("excel");
		$item->Visible = TRUE;

		// Export to Word
		$item = &$this->ExportOptions->add("word");
		$item->Body = $this->getExportTag("word");
		$item->Visible = FALSE;

		// Export to Html
		$item = &$this->ExportOptions->add("html");
		$item->Body = $this->getExportTag("html");
		$item->Visible = FALSE;

		// Export to Xml
		$item = &$this->ExportOptions->add("xml");
		$item->Body = $this->getExportTag("xml");
		$item->Visible = FALSE;

		// Export to Csv
		$item = &$this->ExportOptions->add("csv");
		$item->Body = $this->getExportTag("csv");
		$item->Visible = FALSE;

		// Export to Pdf
		$item = &$this->ExportOptions->add("pdf");
		$item->Body = $this->getExportTag("pdf");
		$item->Visible = FALSE;

		// Export to Email
		$item = &$this->ExportOptions->add("email");
		$item->Body = $this->getExportTag("email");
		$item->Visible = FALSE;

		// Drop down button for export
		$this->ExportOptions->UseButtonGroup = TRUE;
		$this->ExportOptions->UseDropDownButton = FALSE;
		if ($this->ExportOptions->UseButtonGroup && IsMobile())
			$this->ExportOptions->UseDropDownButton = TRUE;
		$this->ExportOptions->DropDownButtonPhrase = $Language->phrase("ButtonExport");

		// Add group option item
		$item = &$this->ExportOptions->add($this->ExportOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	// Set up search options
	protected function setupSearchOptions()
	{
		global $Language;
		$this->SearchOptions = new ListOptions("div");
		$this->SearchOptions->TagClassName = "ew-search-option";

		// Search button
		$item = &$this->SearchOptions->add("searchtoggle");
		$searchToggleClass = ($this->SearchWhere != "") ? " active" : " active";
		$item->Body = "<a class=\"btn btn-default ew-search-toggle" . $searchToggleClass . "\" href=\"#\" role=\"button\" title=\"" . $Language->phrase("SearchPanel") . "\" data-caption=\"" . $Language->phrase("SearchPanel") . "\" data-toggle=\"button\" data-form=\"ftblDosenlistsrch\" aria-pressed=\"" . ($searchToggleClass == " active" ? "true" : "false") . "\">" . $Language->phrase("SearchLink") . "</a>";
		$item->Visible = TRUE;

		// Show all button
		$item = &$this->SearchOptions->add("showall");
		$item->Body = "<a class=\"btn btn-default ew-show-all\" title=\"" . $Language->phrase("ShowAll") . "\" data-caption=\"" . $Language->phrase("ShowAll") . "\" href=\"" . $this->pageUrl() . "cmd=reset\">" . $Language->phrase("ShowAllBtn") . "</a>";
		$item->Visible = ($this->SearchWhere != $this->DefaultSearchWhere && $this->SearchWhere != "0=101");

		// Button group for search
		$this->SearchOptions->UseDropDownButton = FALSE;
		$this->SearchOptions->UseButtonGroup = TRUE;
		$this->SearchOptions->DropDownButtonPhrase = $Language->phrase("ButtonSearch");

		// Add group option item
		$item = &$this->SearchOptions->add($this->SearchOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;

		// Hide search options
		if ($this->isExport() || $this->CurrentAction)
			$this->SearchOptions->hideAllOptions();
		global $Security;
		if (!$Security->canSearch()) {
			$this->SearchOptions->hideAllOptions();
			$this->FilterOptions->hideAllOptions();
		}
	}

	/**
	 * Export data in HTML/CSV/Word/Excel/XML/Email/PDF format
	 *
	 * @param boolean $return Return the data rather than output it
	 * @return mixed
	 */
	public function exportData($return = FALSE)
	{
		global $Language;
		$utf8 = SameText(Config("PROJECT_CHARSET"), "utf-8");
		$selectLimit = $this->UseSelectLimit;

		// Load recordset
		if ($selectLimit) {
			$this->TotalRecords = $this->listRecordCount();
		} else {
			if (!$this->Recordset)
				$this->Recordset = $this->loadRecordset();
			$rs = &$this->Recordset;
			if ($rs)
				$this->TotalRecords = $rs->RecordCount();
		}
		$this->StartRecord = 1;

		// Export all
		if ($this->ExportAll) {
			set_time_limit(Config("EXPORT_ALL_TIME_LIMIT"));
			$this->DisplayRecords = $this->TotalRecords;
			$this->StopRecord = $this->TotalRecords;
		} else { // Export one page only
			$this->setupStartRecord(); // Set up start record position

			// Set the last record to display
			if ($this->DisplayRecords <= 0) {
				$this->StopRecord = $this->TotalRecords;
			} else {
				$this->StopRecord = $this->StartRecord + $this->DisplayRecords - 1;
			}
		}
		if ($selectLimit)
			$rs = $this->loadRecordset($this->StartRecord - 1, $this->DisplayRecords <= 0 ? $this->TotalRecords : $this->DisplayRecords);
		$this->ExportDoc = GetExportDocument($this, "h");
		$doc = &$this->ExportDoc;
		if (!$doc)
			$this->setFailureMessage($Language->phrase("ExportClassNotFound")); // Export class not found
		if (!$rs || !$doc) {
			RemoveHeader("Content-Type"); // Remove header
			RemoveHeader("Content-Disposition");
			$this->showMessage();
			return;
		}
		if ($selectLimit) {
			$this->StartRecord = 1;
			$this->StopRecord = $this->DisplayRecords <= 0 ? $this->TotalRecords : $this->DisplayRecords;
		}

		// Call Page Exporting server event
		$this->ExportDoc->ExportCustom = !$this->Page_Exporting();
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		$doc->Text .= $header;
		$this->exportDocument($doc, $rs, $this->StartRecord, $this->StopRecord, "");
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		$doc->Text .= $footer;

		// Close recordset
		$rs->close();

		// Call Page Exported server event
		$this->Page_Exported();

		// Export header and footer
		$doc->exportHeaderAndFooter();

		// Clean output buffer (without destroying output buffer)
		$buffer = ob_get_contents(); // Save the output buffer
		if (!Config("DEBUG") && $buffer)
			ob_clean();

		// Write debug message if enabled
		if (Config("DEBUG") && !$this->isExport("pdf"))
			echo GetDebugMessage();

		// Output data
		if ($this->isExport("email")) {

			// Export-to-email disabled
		} else {
			$doc->export();
			if ($return) {
				RemoveHeader("Content-Type"); // Remove header
				RemoveHeader("Content-Disposition");
				$content = ob_get_contents();
				if ($content)
					ob_clean();
				if ($buffer)
					echo $buffer; // Resume the output buffer
				return $content;
			}
		}
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$url = preg_replace('/\?cmd=reset(all){0,1}$/i', '', $url); // Remove cmd=reset / cmd=resetall
		$Breadcrumb->add("list", $this->TableVar, $url, "", $this->TableVar, TRUE);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// Get default connection and filter
			$conn = $this->getConnection();
			$lookupFilter = "";

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL and connection
			switch ($fld->FieldVar) {
				case "x_Status":
					break;
				case "x_Kode_Jp":
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0) {
				$totalCnt = $this->getRecordCount($sql, $conn);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_Kode_Jp":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Set up starting record parameters
	public function setupStartRecord()
	{
		if ($this->DisplayRecords == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			$startRec = Get(Config("TABLE_START_REC"));
			$pageNo = Get(Config("TABLE_PAGE_NO"));
			if ($pageNo !== NULL) { // Check for "pageno" parameter first
				if (is_numeric($pageNo)) {
					$this->StartRecord = ($pageNo - 1) * $this->DisplayRecords + 1;
					if ($this->StartRecord <= 0) {
						$this->StartRecord = 1;
					} elseif ($this->StartRecord >= (int)(($this->TotalRecords - 1)/$this->DisplayRecords) * $this->DisplayRecords + 1) {
						$this->StartRecord = (int)(($this->TotalRecords - 1)/$this->DisplayRecords) * $this->DisplayRecords + 1;
					}
					$this->setStartRecordNumber($this->StartRecord);
				}
			} elseif ($startRec !== NULL) { // Check for "start" parameter
				$this->StartRecord = $startRec;
				$this->setStartRecordNumber($this->StartRecord);
			}
		}
		$this->StartRecord = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRecord) || $this->StartRecord == "") { // Avoid invalid start record counter
			$this->StartRecord = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRecord);
		} elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
			$this->StartRecord = (int)(($this->TotalRecords - 1)/$this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRecord);
		} elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
			$this->StartRecord = (int)(($this->StartRecord - 1)/$this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRecord);
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}

	// ListOptions Load event
	function ListOptions_Load() {

		// Example:
		//$opt = &$this->ListOptions->Add("new");
		//$opt->Header = "xxx";
		//$opt->OnLeft = TRUE; // Link on left
		//$opt->MoveTo(0); // Move to first column

	}

	// ListOptions Rendering event
	function ListOptions_Rendering() {

		//$GLOBALS["xxx_grid"]->DetailAdd = (...condition...); // Set to TRUE or FALSE conditionally
		//$GLOBALS["xxx_grid"]->DetailEdit = (...condition...); // Set to TRUE or FALSE conditionally
		//$GLOBALS["xxx_grid"]->DetailView = (...condition...); // Set to TRUE or FALSE conditionally

	}

	// ListOptions Rendered event
	function ListOptions_Rendered() {

		// Example:
		//$this->ListOptions["new"]->Body = "xxx";

	}

	// Row Custom Action event
	function Row_CustomAction($action, $row) {

		// Return FALSE to abort
		return TRUE;
	}

	// Page Exporting event
	// $this->ExportDoc = export document object
	function Page_Exporting() {

		//$this->ExportDoc->Text = "my header"; // Export header
		//return FALSE; // Return FALSE to skip default export and use Row_Export event

		return TRUE; // Return TRUE to use default export and skip Row_Export event
	}

	// Row Export event
	// $this->ExportDoc = export document object
	function Row_Export($rs) {

		//$this->ExportDoc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
	}

	// Page Exported event
	// $this->ExportDoc = export document object
	function Page_Exported() {

		//$this->ExportDoc->Text .= "my footer"; // Export footer
		//echo $this->ExportDoc->Text;

	}

	// Page Importing event
	function Page_Importing($reader, &$options) {

		//var_dump($reader); // Import data reader
		//var_dump($options); // Show all options for importing
		//return FALSE; // Return FALSE to skip import

		return TRUE;
	}

	// Row Import event
	function Row_Import(&$row, $cnt) {

		//echo $cnt; // Import record count
		//var_dump($row); // Import row
		//return FALSE; // Return FALSE to skip import

		return TRUE;
	}

	// Page Imported event
	function Page_Imported($reader, $results) {

		//var_dump($reader); // Import data reader
		//var_dump($results); // Import results

	}
} // End class
?>