<?php namespace PHPMaker2020\baak; ?>
<?php

/**
 * Table class for tblFak
 */
class tblFak extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $Kode_Fak;
	public $Nama_Fak;
	public $Nama_Panjang;
	public $Nama_Fak_Eng;
	public $Dekan;
	public $Nid_Dekan;
	public $Pudek1;
	public $Nid_Pudek1;
	public $Pudek2;
	public $Nid_Pudek2;
	public $Pudek3;
	public $Nid_Pudek3;
	public $kajian;
	public $Logo;
	public $alamat;
	public $paxphone;
	public $website;
	public $NikBAAK;
	public $BAAK;
	public $ttdketua;
	public $ttwwk1;
	public $AkreditasiPT;
	public $Kopsurat;
	public $idpt;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;
		parent::__construct();

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'tblFak';
		$this->TableName = 'tblFak';
		$this->TableType = 'TABLE';

		// Update Table
		$this->UpdateTable = "[dbo].[tblFak]";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
		$this->BasicSearch = new BasicSearch($this->TableVar);

		// Kode_Fak
		$this->Kode_Fak = new DbField('tblFak', 'tblFak', 'x_Kode_Fak', 'Kode_Fak', '[Kode_Fak]', '[Kode_Fak]', 129, 10, -1, FALSE, '[Kode_Fak]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Kode_Fak->IsPrimaryKey = TRUE; // Primary key field
		$this->Kode_Fak->Nullable = FALSE; // NOT NULL field
		$this->Kode_Fak->Required = TRUE; // Required field
		$this->Kode_Fak->Sortable = TRUE; // Allow sort
		$this->fields['Kode_Fak'] = &$this->Kode_Fak;

		// Nama_Fak
		$this->Nama_Fak = new DbField('tblFak', 'tblFak', 'x_Nama_Fak', 'Nama_Fak', '[Nama_Fak]', '[Nama_Fak]', 129, 70, -1, FALSE, '[Nama_Fak]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Nama_Fak->Sortable = TRUE; // Allow sort
		$this->fields['Nama_Fak'] = &$this->Nama_Fak;

		// Nama_Panjang
		$this->Nama_Panjang = new DbField('tblFak', 'tblFak', 'x_Nama_Panjang', 'Nama_Panjang', '[Nama_Panjang]', '[Nama_Panjang]', 129, 100, -1, FALSE, '[Nama_Panjang]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Nama_Panjang->Sortable = TRUE; // Allow sort
		$this->fields['Nama_Panjang'] = &$this->Nama_Panjang;

		// Nama_Fak_Eng
		$this->Nama_Fak_Eng = new DbField('tblFak', 'tblFak', 'x_Nama_Fak_Eng', 'Nama_Fak_Eng', '[Nama_Fak_Eng]', '[Nama_Fak_Eng]', 129, 35, -1, FALSE, '[Nama_Fak_Eng]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Nama_Fak_Eng->Sortable = TRUE; // Allow sort
		$this->fields['Nama_Fak_Eng'] = &$this->Nama_Fak_Eng;

		// Dekan
		$this->Dekan = new DbField('tblFak', 'tblFak', 'x_Dekan', 'Dekan', '[Dekan]', '[Dekan]', 129, 70, -1, FALSE, '[Dekan]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Dekan->Sortable = TRUE; // Allow sort
		$this->fields['Dekan'] = &$this->Dekan;

		// Nid_Dekan
		$this->Nid_Dekan = new DbField('tblFak', 'tblFak', 'x_Nid_Dekan', 'Nid_Dekan', '[Nid_Dekan]', '[Nid_Dekan]', 129, 30, -1, FALSE, '[Nid_Dekan]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Nid_Dekan->Sortable = TRUE; // Allow sort
		$this->fields['Nid_Dekan'] = &$this->Nid_Dekan;

		// Pudek1
		$this->Pudek1 = new DbField('tblFak', 'tblFak', 'x_Pudek1', 'Pudek1', '[Pudek1]', '[Pudek1]', 129, 70, -1, FALSE, '[Pudek1]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Pudek1->Sortable = TRUE; // Allow sort
		$this->fields['Pudek1'] = &$this->Pudek1;

		// Nid_Pudek1
		$this->Nid_Pudek1 = new DbField('tblFak', 'tblFak', 'x_Nid_Pudek1', 'Nid_Pudek1', '[Nid_Pudek1]', '[Nid_Pudek1]', 129, 30, -1, FALSE, '[Nid_Pudek1]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Nid_Pudek1->Sortable = TRUE; // Allow sort
		$this->fields['Nid_Pudek1'] = &$this->Nid_Pudek1;

		// Pudek2
		$this->Pudek2 = new DbField('tblFak', 'tblFak', 'x_Pudek2', 'Pudek2', '[Pudek2]', '[Pudek2]', 129, 70, -1, FALSE, '[Pudek2]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Pudek2->Sortable = TRUE; // Allow sort
		$this->fields['Pudek2'] = &$this->Pudek2;

		// Nid_Pudek2
		$this->Nid_Pudek2 = new DbField('tblFak', 'tblFak', 'x_Nid_Pudek2', 'Nid_Pudek2', '[Nid_Pudek2]', '[Nid_Pudek2]', 129, 30, -1, FALSE, '[Nid_Pudek2]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Nid_Pudek2->Sortable = TRUE; // Allow sort
		$this->fields['Nid_Pudek2'] = &$this->Nid_Pudek2;

		// Pudek3
		$this->Pudek3 = new DbField('tblFak', 'tblFak', 'x_Pudek3', 'Pudek3', '[Pudek3]', '[Pudek3]', 129, 70, -1, FALSE, '[Pudek3]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Pudek3->Sortable = TRUE; // Allow sort
		$this->fields['Pudek3'] = &$this->Pudek3;

		// Nid_Pudek3
		$this->Nid_Pudek3 = new DbField('tblFak', 'tblFak', 'x_Nid_Pudek3', 'Nid_Pudek3', '[Nid_Pudek3]', '[Nid_Pudek3]', 129, 30, -1, FALSE, '[Nid_Pudek3]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Nid_Pudek3->Sortable = TRUE; // Allow sort
		$this->fields['Nid_Pudek3'] = &$this->Nid_Pudek3;

		// kajian
		$this->kajian = new DbField('tblFak', 'tblFak', 'x_kajian', 'kajian', '[kajian]', '[kajian]', 129, 10, -1, FALSE, '[kajian]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->kajian->Sortable = TRUE; // Allow sort
		$this->fields['kajian'] = &$this->kajian;

		// Logo
		$this->Logo = new DbField('tblFak', 'tblFak', 'x_Logo', 'Logo', '[Logo]', '[Logo]', 205, 0, -1, TRUE, '[Logo]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'FILE');
		$this->Logo->Sortable = TRUE; // Allow sort
		$this->fields['Logo'] = &$this->Logo;

		// alamat
		$this->alamat = new DbField('tblFak', 'tblFak', 'x_alamat', 'alamat', '[alamat]', '[alamat]', 129, 100, -1, FALSE, '[alamat]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->alamat->Sortable = TRUE; // Allow sort
		$this->fields['alamat'] = &$this->alamat;

		// paxphone
		$this->paxphone = new DbField('tblFak', 'tblFak', 'x_paxphone', 'paxphone', '[paxphone]', '[paxphone]', 129, 50, -1, FALSE, '[paxphone]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->paxphone->Sortable = TRUE; // Allow sort
		$this->fields['paxphone'] = &$this->paxphone;

		// website
		$this->website = new DbField('tblFak', 'tblFak', 'x_website', 'website', '[website]', '[website]', 129, 100, -1, FALSE, '[website]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->website->Sortable = TRUE; // Allow sort
		$this->fields['website'] = &$this->website;

		// NikBAAK
		$this->NikBAAK = new DbField('tblFak', 'tblFak', 'x_NikBAAK', 'NikBAAK', '[NikBAAK]', '[NikBAAK]', 129, 100, -1, FALSE, '[NikBAAK]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->NikBAAK->Sortable = TRUE; // Allow sort
		$this->fields['NikBAAK'] = &$this->NikBAAK;

		// BAAK
		$this->BAAK = new DbField('tblFak', 'tblFak', 'x_BAAK', 'BAAK', '[BAAK]', '[BAAK]', 129, 70, -1, FALSE, '[BAAK]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->BAAK->Sortable = TRUE; // Allow sort
		$this->fields['BAAK'] = &$this->BAAK;

		// ttdketua
		$this->ttdketua = new DbField('tblFak', 'tblFak', 'x_ttdketua', 'ttdketua', '[ttdketua]', '[ttdketua]', 205, 0, -1, TRUE, '[ttdketua]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'FILE');
		$this->ttdketua->Sortable = TRUE; // Allow sort
		$this->fields['ttdketua'] = &$this->ttdketua;

		// ttwwk1
		$this->ttwwk1 = new DbField('tblFak', 'tblFak', 'x_ttwwk1', 'ttwwk1', '[ttwwk1]', '[ttwwk1]', 205, 0, -1, TRUE, '[ttwwk1]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'FILE');
		$this->ttwwk1->Sortable = TRUE; // Allow sort
		$this->fields['ttwwk1'] = &$this->ttwwk1;

		// AkreditasiPT
		$this->AkreditasiPT = new DbField('tblFak', 'tblFak', 'x_AkreditasiPT', 'AkreditasiPT', '[AkreditasiPT]', '[AkreditasiPT]', 200, 100, -1, FALSE, '[AkreditasiPT]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->AkreditasiPT->Sortable = TRUE; // Allow sort
		$this->fields['AkreditasiPT'] = &$this->AkreditasiPT;

		// Kopsurat
		$this->Kopsurat = new DbField('tblFak', 'tblFak', 'x_Kopsurat', 'Kopsurat', '[Kopsurat]', '[Kopsurat]', 205, 0, -1, TRUE, '[Kopsurat]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'FILE');
		$this->Kopsurat->Sortable = TRUE; // Allow sort
		$this->fields['Kopsurat'] = &$this->Kopsurat;

		// idpt
		$this->idpt = new DbField('tblFak', 'tblFak', 'x_idpt', 'idpt', '[idpt]', '[idpt]', 200, 50, -1, FALSE, '[idpt]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->idpt->Sortable = TRUE; // Allow sort
		$this->fields['idpt'] = &$this->idpt;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Single column sort
	public function updateSort(&$fld)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
		} else {
			$fld->setSort("");
		}
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom != "") ? $this->SqlFrom : "[dbo].[tblFak]";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect != "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy != "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving != "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter, $id = "")
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = $this->UserIDAllowSecurity;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 32) == 32);
			case "search":
				return (($allow & 64) == 64);
			case "lookup":
				return (($allow & 256) == 256);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get recordset
	public function getRecordset($sql, $rowcnt = -1, $offset = -1)
	{
		$conn = $this->getConnection();
		$conn->raiseErrorFn = Config("ERROR_FUNC");
		$rs = $conn->selectLimit($sql, $rowcnt, $offset);
		$conn->raiseErrorFn = "";
		return $rs;
	}

	// Get record count
	public function getRecordCount($sql, $c = NULL)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) &&
			!preg_match('/^\s*select\s+distinct\s+/i', $sql) && !preg_match('/\s+order\s+by\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = $c ?: $this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->getSqlSelect();
		$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " (" . $names . ") VALUES (" . $values . ")";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = $this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsAutoIncrement)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter != "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = $this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('Kode_Fak', $rs))
				AddFilter($where, QuotedName('Kode_Fak', $this->Dbid) . '=' . QuotedValue($rs['Kode_Fak'], $this->Kode_Fak->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter != "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = $this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->Kode_Fak->DbValue = $row['Kode_Fak'];
		$this->Nama_Fak->DbValue = $row['Nama_Fak'];
		$this->Nama_Panjang->DbValue = $row['Nama_Panjang'];
		$this->Nama_Fak_Eng->DbValue = $row['Nama_Fak_Eng'];
		$this->Dekan->DbValue = $row['Dekan'];
		$this->Nid_Dekan->DbValue = $row['Nid_Dekan'];
		$this->Pudek1->DbValue = $row['Pudek1'];
		$this->Nid_Pudek1->DbValue = $row['Nid_Pudek1'];
		$this->Pudek2->DbValue = $row['Pudek2'];
		$this->Nid_Pudek2->DbValue = $row['Nid_Pudek2'];
		$this->Pudek3->DbValue = $row['Pudek3'];
		$this->Nid_Pudek3->DbValue = $row['Nid_Pudek3'];
		$this->kajian->DbValue = $row['kajian'];
		$this->Logo->Upload->DbValue = $row['Logo'];
		$this->alamat->DbValue = $row['alamat'];
		$this->paxphone->DbValue = $row['paxphone'];
		$this->website->DbValue = $row['website'];
		$this->NikBAAK->DbValue = $row['NikBAAK'];
		$this->BAAK->DbValue = $row['BAAK'];
		$this->ttdketua->Upload->DbValue = $row['ttdketua'];
		$this->ttwwk1->Upload->DbValue = $row['ttwwk1'];
		$this->AkreditasiPT->DbValue = $row['AkreditasiPT'];
		$this->Kopsurat->Upload->DbValue = $row['Kopsurat'];
		$this->idpt->DbValue = $row['idpt'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "[Kode_Fak] = '@Kode_Fak@'";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		if (is_array($row))
			$val = array_key_exists('Kode_Fak', $row) ? $row['Kode_Fak'] : NULL;
		else
			$val = $this->Kode_Fak->OldValue !== NULL ? $this->Kode_Fak->OldValue : $this->Kode_Fak->CurrentValue;
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@Kode_Fak@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") != "" && ReferPageName() != CurrentPageName() && ReferPageName() != "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] != "") {
			return $_SESSION[$name];
		} else {
			return "tblFaklist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "tblFakview.php")
			return $Language->phrase("View");
		elseif ($pageName == "tblFakedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "tblFakadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "tblFaklist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm != "")
			$url = $this->keyUrl("tblFakview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("tblFakview.php", $this->getUrlParm(Config("TABLE_SHOW_DETAIL") . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm != "")
			$url = "tblFakadd.php?" . $this->getUrlParm($parm);
		else
			$url = "tblFakadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("tblFakedit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("tblFakadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("tblFakdelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "Kode_Fak:" . JsonEncode($this->Kode_Fak->CurrentValue, "string");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm != "")
			$url .= $parm . "&";
		if ($this->Kode_Fak->CurrentValue != NULL) {
			$url .= "Kode_Fak=" . urlencode($this->Kode_Fak->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, [141, 201, 203, 128, 204, 205])) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		$arKeys = [];
		$arKey = [];
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("Kode_Fak") !== NULL)
				$arKeys[] = Param("Kode_Fak");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = [];
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys($setCurrent = TRUE)
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter != "") $keyFilter .= " OR ";
			if ($setCurrent)
				$this->Kode_Fak->CurrentValue = $key;
			else
				$this->Kode_Fak->OldValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = $this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->Kode_Fak->setDbValue($rs->fields('Kode_Fak'));
		$this->Nama_Fak->setDbValue($rs->fields('Nama_Fak'));
		$this->Nama_Panjang->setDbValue($rs->fields('Nama_Panjang'));
		$this->Nama_Fak_Eng->setDbValue($rs->fields('Nama_Fak_Eng'));
		$this->Dekan->setDbValue($rs->fields('Dekan'));
		$this->Nid_Dekan->setDbValue($rs->fields('Nid_Dekan'));
		$this->Pudek1->setDbValue($rs->fields('Pudek1'));
		$this->Nid_Pudek1->setDbValue($rs->fields('Nid_Pudek1'));
		$this->Pudek2->setDbValue($rs->fields('Pudek2'));
		$this->Nid_Pudek2->setDbValue($rs->fields('Nid_Pudek2'));
		$this->Pudek3->setDbValue($rs->fields('Pudek3'));
		$this->Nid_Pudek3->setDbValue($rs->fields('Nid_Pudek3'));
		$this->kajian->setDbValue($rs->fields('kajian'));
		$this->Logo->Upload->DbValue = $rs->fields('Logo');
		$this->alamat->setDbValue($rs->fields('alamat'));
		$this->paxphone->setDbValue($rs->fields('paxphone'));
		$this->website->setDbValue($rs->fields('website'));
		$this->NikBAAK->setDbValue($rs->fields('NikBAAK'));
		$this->BAAK->setDbValue($rs->fields('BAAK'));
		$this->ttdketua->Upload->DbValue = $rs->fields('ttdketua');
		$this->ttwwk1->Upload->DbValue = $rs->fields('ttwwk1');
		$this->AkreditasiPT->setDbValue($rs->fields('AkreditasiPT'));
		$this->Kopsurat->Upload->DbValue = $rs->fields('Kopsurat');
		$this->idpt->setDbValue($rs->fields('idpt'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// Kode_Fak
		// Nama_Fak
		// Nama_Panjang
		// Nama_Fak_Eng
		// Dekan
		// Nid_Dekan
		// Pudek1
		// Nid_Pudek1
		// Pudek2
		// Nid_Pudek2
		// Pudek3
		// Nid_Pudek3
		// kajian
		// Logo
		// alamat
		// paxphone
		// website
		// NikBAAK
		// BAAK
		// ttdketua
		// ttwwk1
		// AkreditasiPT
		// Kopsurat
		// idpt
		// Kode_Fak

		$this->Kode_Fak->ViewValue = $this->Kode_Fak->CurrentValue;
		$this->Kode_Fak->ViewCustomAttributes = "";

		// Nama_Fak
		$this->Nama_Fak->ViewValue = $this->Nama_Fak->CurrentValue;
		$this->Nama_Fak->ViewCustomAttributes = "";

		// Nama_Panjang
		$this->Nama_Panjang->ViewValue = $this->Nama_Panjang->CurrentValue;
		$this->Nama_Panjang->ViewCustomAttributes = "";

		// Nama_Fak_Eng
		$this->Nama_Fak_Eng->ViewValue = $this->Nama_Fak_Eng->CurrentValue;
		$this->Nama_Fak_Eng->ViewCustomAttributes = "";

		// Dekan
		$this->Dekan->ViewValue = $this->Dekan->CurrentValue;
		$this->Dekan->ViewCustomAttributes = "";

		// Nid_Dekan
		$this->Nid_Dekan->ViewValue = $this->Nid_Dekan->CurrentValue;
		$this->Nid_Dekan->ViewCustomAttributes = "";

		// Pudek1
		$this->Pudek1->ViewValue = $this->Pudek1->CurrentValue;
		$this->Pudek1->ViewCustomAttributes = "";

		// Nid_Pudek1
		$this->Nid_Pudek1->ViewValue = $this->Nid_Pudek1->CurrentValue;
		$this->Nid_Pudek1->ViewCustomAttributes = "";

		// Pudek2
		$this->Pudek2->ViewValue = $this->Pudek2->CurrentValue;
		$this->Pudek2->ViewCustomAttributes = "";

		// Nid_Pudek2
		$this->Nid_Pudek2->ViewValue = $this->Nid_Pudek2->CurrentValue;
		$this->Nid_Pudek2->ViewCustomAttributes = "";

		// Pudek3
		$this->Pudek3->ViewValue = $this->Pudek3->CurrentValue;
		$this->Pudek3->ViewCustomAttributes = "";

		// Nid_Pudek3
		$this->Nid_Pudek3->ViewValue = $this->Nid_Pudek3->CurrentValue;
		$this->Nid_Pudek3->ViewCustomAttributes = "";

		// kajian
		$this->kajian->ViewValue = $this->kajian->CurrentValue;
		$this->kajian->ViewCustomAttributes = "";

		// Logo
		if (!EmptyValue($this->Logo->Upload->DbValue)) {
			$this->Logo->ViewValue = $this->Kode_Fak->CurrentValue;
			$this->Logo->IsBlobImage = IsImageFile(ContentExtension($this->Logo->Upload->DbValue));
		} else {
			$this->Logo->ViewValue = "";
		}
		$this->Logo->ViewCustomAttributes = "";

		// alamat
		$this->alamat->ViewValue = $this->alamat->CurrentValue;
		$this->alamat->ViewCustomAttributes = "";

		// paxphone
		$this->paxphone->ViewValue = $this->paxphone->CurrentValue;
		$this->paxphone->ViewCustomAttributes = "";

		// website
		$this->website->ViewValue = $this->website->CurrentValue;
		$this->website->ViewCustomAttributes = "";

		// NikBAAK
		$this->NikBAAK->ViewValue = $this->NikBAAK->CurrentValue;
		$this->NikBAAK->ViewCustomAttributes = "";

		// BAAK
		$this->BAAK->ViewValue = $this->BAAK->CurrentValue;
		$this->BAAK->ViewCustomAttributes = "";

		// ttdketua
		if (!EmptyValue($this->ttdketua->Upload->DbValue)) {
			$this->ttdketua->ViewValue = $this->Kode_Fak->CurrentValue;
			$this->ttdketua->IsBlobImage = IsImageFile(ContentExtension($this->ttdketua->Upload->DbValue));
		} else {
			$this->ttdketua->ViewValue = "";
		}
		$this->ttdketua->ViewCustomAttributes = "";

		// ttwwk1
		if (!EmptyValue($this->ttwwk1->Upload->DbValue)) {
			$this->ttwwk1->ViewValue = $this->Kode_Fak->CurrentValue;
			$this->ttwwk1->IsBlobImage = IsImageFile(ContentExtension($this->ttwwk1->Upload->DbValue));
		} else {
			$this->ttwwk1->ViewValue = "";
		}
		$this->ttwwk1->ViewCustomAttributes = "";

		// AkreditasiPT
		$this->AkreditasiPT->ViewValue = $this->AkreditasiPT->CurrentValue;
		$this->AkreditasiPT->ViewCustomAttributes = "";

		// Kopsurat
		if (!EmptyValue($this->Kopsurat->Upload->DbValue)) {
			$this->Kopsurat->ViewValue = $this->Kode_Fak->CurrentValue;
			$this->Kopsurat->IsBlobImage = IsImageFile(ContentExtension($this->Kopsurat->Upload->DbValue));
		} else {
			$this->Kopsurat->ViewValue = "";
		}
		$this->Kopsurat->ViewCustomAttributes = "";

		// idpt
		$this->idpt->ViewValue = $this->idpt->CurrentValue;
		$this->idpt->ViewCustomAttributes = "";

		// Kode_Fak
		$this->Kode_Fak->LinkCustomAttributes = "";
		$this->Kode_Fak->HrefValue = "";
		$this->Kode_Fak->TooltipValue = "";

		// Nama_Fak
		$this->Nama_Fak->LinkCustomAttributes = "";
		$this->Nama_Fak->HrefValue = "";
		$this->Nama_Fak->TooltipValue = "";

		// Nama_Panjang
		$this->Nama_Panjang->LinkCustomAttributes = "";
		$this->Nama_Panjang->HrefValue = "";
		$this->Nama_Panjang->TooltipValue = "";

		// Nama_Fak_Eng
		$this->Nama_Fak_Eng->LinkCustomAttributes = "";
		$this->Nama_Fak_Eng->HrefValue = "";
		$this->Nama_Fak_Eng->TooltipValue = "";

		// Dekan
		$this->Dekan->LinkCustomAttributes = "";
		$this->Dekan->HrefValue = "";
		$this->Dekan->TooltipValue = "";

		// Nid_Dekan
		$this->Nid_Dekan->LinkCustomAttributes = "";
		$this->Nid_Dekan->HrefValue = "";
		$this->Nid_Dekan->TooltipValue = "";

		// Pudek1
		$this->Pudek1->LinkCustomAttributes = "";
		$this->Pudek1->HrefValue = "";
		$this->Pudek1->TooltipValue = "";

		// Nid_Pudek1
		$this->Nid_Pudek1->LinkCustomAttributes = "";
		$this->Nid_Pudek1->HrefValue = "";
		$this->Nid_Pudek1->TooltipValue = "";

		// Pudek2
		$this->Pudek2->LinkCustomAttributes = "";
		$this->Pudek2->HrefValue = "";
		$this->Pudek2->TooltipValue = "";

		// Nid_Pudek2
		$this->Nid_Pudek2->LinkCustomAttributes = "";
		$this->Nid_Pudek2->HrefValue = "";
		$this->Nid_Pudek2->TooltipValue = "";

		// Pudek3
		$this->Pudek3->LinkCustomAttributes = "";
		$this->Pudek3->HrefValue = "";
		$this->Pudek3->TooltipValue = "";

		// Nid_Pudek3
		$this->Nid_Pudek3->LinkCustomAttributes = "";
		$this->Nid_Pudek3->HrefValue = "";
		$this->Nid_Pudek3->TooltipValue = "";

		// kajian
		$this->kajian->LinkCustomAttributes = "";
		$this->kajian->HrefValue = "";
		$this->kajian->TooltipValue = "";

		// Logo
		$this->Logo->LinkCustomAttributes = "";
		if (!empty($this->Logo->Upload->DbValue)) {
			$this->Logo->HrefValue = GetFileUploadUrl($this->Logo, $this->Kode_Fak->CurrentValue);
			$this->Logo->LinkAttrs["target"] = "";
			if ($this->Logo->IsBlobImage && empty($this->Logo->LinkAttrs["target"]))
				$this->Logo->LinkAttrs["target"] = "_blank";
			if ($this->isExport())
				$this->Logo->HrefValue = FullUrl($this->Logo->HrefValue, "href");
		} else {
			$this->Logo->HrefValue = "";
		}
		$this->Logo->ExportHrefValue = GetFileUploadUrl($this->Logo, $this->Kode_Fak->CurrentValue);
		$this->Logo->TooltipValue = "";

		// alamat
		$this->alamat->LinkCustomAttributes = "";
		$this->alamat->HrefValue = "";
		$this->alamat->TooltipValue = "";

		// paxphone
		$this->paxphone->LinkCustomAttributes = "";
		$this->paxphone->HrefValue = "";
		$this->paxphone->TooltipValue = "";

		// website
		$this->website->LinkCustomAttributes = "";
		$this->website->HrefValue = "";
		$this->website->TooltipValue = "";

		// NikBAAK
		$this->NikBAAK->LinkCustomAttributes = "";
		$this->NikBAAK->HrefValue = "";
		$this->NikBAAK->TooltipValue = "";

		// BAAK
		$this->BAAK->LinkCustomAttributes = "";
		$this->BAAK->HrefValue = "";
		$this->BAAK->TooltipValue = "";

		// ttdketua
		$this->ttdketua->LinkCustomAttributes = "";
		if (!empty($this->ttdketua->Upload->DbValue)) {
			$this->ttdketua->HrefValue = GetFileUploadUrl($this->ttdketua, $this->Kode_Fak->CurrentValue);
			$this->ttdketua->LinkAttrs["target"] = "";
			if ($this->ttdketua->IsBlobImage && empty($this->ttdketua->LinkAttrs["target"]))
				$this->ttdketua->LinkAttrs["target"] = "_blank";
			if ($this->isExport())
				$this->ttdketua->HrefValue = FullUrl($this->ttdketua->HrefValue, "href");
		} else {
			$this->ttdketua->HrefValue = "";
		}
		$this->ttdketua->ExportHrefValue = GetFileUploadUrl($this->ttdketua, $this->Kode_Fak->CurrentValue);
		$this->ttdketua->TooltipValue = "";

		// ttwwk1
		$this->ttwwk1->LinkCustomAttributes = "";
		if (!empty($this->ttwwk1->Upload->DbValue)) {
			$this->ttwwk1->HrefValue = GetFileUploadUrl($this->ttwwk1, $this->Kode_Fak->CurrentValue);
			$this->ttwwk1->LinkAttrs["target"] = "";
			if ($this->ttwwk1->IsBlobImage && empty($this->ttwwk1->LinkAttrs["target"]))
				$this->ttwwk1->LinkAttrs["target"] = "_blank";
			if ($this->isExport())
				$this->ttwwk1->HrefValue = FullUrl($this->ttwwk1->HrefValue, "href");
		} else {
			$this->ttwwk1->HrefValue = "";
		}
		$this->ttwwk1->ExportHrefValue = GetFileUploadUrl($this->ttwwk1, $this->Kode_Fak->CurrentValue);
		$this->ttwwk1->TooltipValue = "";

		// AkreditasiPT
		$this->AkreditasiPT->LinkCustomAttributes = "";
		$this->AkreditasiPT->HrefValue = "";
		$this->AkreditasiPT->TooltipValue = "";

		// Kopsurat
		$this->Kopsurat->LinkCustomAttributes = "";
		if (!empty($this->Kopsurat->Upload->DbValue)) {
			$this->Kopsurat->HrefValue = GetFileUploadUrl($this->Kopsurat, $this->Kode_Fak->CurrentValue);
			$this->Kopsurat->LinkAttrs["target"] = "";
			if ($this->Kopsurat->IsBlobImage && empty($this->Kopsurat->LinkAttrs["target"]))
				$this->Kopsurat->LinkAttrs["target"] = "_blank";
			if ($this->isExport())
				$this->Kopsurat->HrefValue = FullUrl($this->Kopsurat->HrefValue, "href");
		} else {
			$this->Kopsurat->HrefValue = "";
		}
		$this->Kopsurat->ExportHrefValue = GetFileUploadUrl($this->Kopsurat, $this->Kode_Fak->CurrentValue);
		$this->Kopsurat->TooltipValue = "";

		// idpt
		$this->idpt->LinkCustomAttributes = "";
		$this->idpt->HrefValue = "";
		$this->idpt->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Kode_Fak
		$this->Kode_Fak->EditAttrs["class"] = "form-control";
		$this->Kode_Fak->EditCustomAttributes = "";
		if (!$this->Kode_Fak->Raw)
			$this->Kode_Fak->CurrentValue = HtmlDecode($this->Kode_Fak->CurrentValue);
		$this->Kode_Fak->EditValue = $this->Kode_Fak->CurrentValue;
		$this->Kode_Fak->PlaceHolder = RemoveHtml($this->Kode_Fak->caption());

		// Nama_Fak
		$this->Nama_Fak->EditAttrs["class"] = "form-control";
		$this->Nama_Fak->EditCustomAttributes = "";
		if (!$this->Nama_Fak->Raw)
			$this->Nama_Fak->CurrentValue = HtmlDecode($this->Nama_Fak->CurrentValue);
		$this->Nama_Fak->EditValue = $this->Nama_Fak->CurrentValue;
		$this->Nama_Fak->PlaceHolder = RemoveHtml($this->Nama_Fak->caption());

		// Nama_Panjang
		$this->Nama_Panjang->EditAttrs["class"] = "form-control";
		$this->Nama_Panjang->EditCustomAttributes = "";
		if (!$this->Nama_Panjang->Raw)
			$this->Nama_Panjang->CurrentValue = HtmlDecode($this->Nama_Panjang->CurrentValue);
		$this->Nama_Panjang->EditValue = $this->Nama_Panjang->CurrentValue;
		$this->Nama_Panjang->PlaceHolder = RemoveHtml($this->Nama_Panjang->caption());

		// Nama_Fak_Eng
		$this->Nama_Fak_Eng->EditAttrs["class"] = "form-control";
		$this->Nama_Fak_Eng->EditCustomAttributes = "";
		if (!$this->Nama_Fak_Eng->Raw)
			$this->Nama_Fak_Eng->CurrentValue = HtmlDecode($this->Nama_Fak_Eng->CurrentValue);
		$this->Nama_Fak_Eng->EditValue = $this->Nama_Fak_Eng->CurrentValue;
		$this->Nama_Fak_Eng->PlaceHolder = RemoveHtml($this->Nama_Fak_Eng->caption());

		// Dekan
		$this->Dekan->EditAttrs["class"] = "form-control";
		$this->Dekan->EditCustomAttributes = "";
		if (!$this->Dekan->Raw)
			$this->Dekan->CurrentValue = HtmlDecode($this->Dekan->CurrentValue);
		$this->Dekan->EditValue = $this->Dekan->CurrentValue;
		$this->Dekan->PlaceHolder = RemoveHtml($this->Dekan->caption());

		// Nid_Dekan
		$this->Nid_Dekan->EditAttrs["class"] = "form-control";
		$this->Nid_Dekan->EditCustomAttributes = "";
		if (!$this->Nid_Dekan->Raw)
			$this->Nid_Dekan->CurrentValue = HtmlDecode($this->Nid_Dekan->CurrentValue);
		$this->Nid_Dekan->EditValue = $this->Nid_Dekan->CurrentValue;
		$this->Nid_Dekan->PlaceHolder = RemoveHtml($this->Nid_Dekan->caption());

		// Pudek1
		$this->Pudek1->EditAttrs["class"] = "form-control";
		$this->Pudek1->EditCustomAttributes = "";
		if (!$this->Pudek1->Raw)
			$this->Pudek1->CurrentValue = HtmlDecode($this->Pudek1->CurrentValue);
		$this->Pudek1->EditValue = $this->Pudek1->CurrentValue;
		$this->Pudek1->PlaceHolder = RemoveHtml($this->Pudek1->caption());

		// Nid_Pudek1
		$this->Nid_Pudek1->EditAttrs["class"] = "form-control";
		$this->Nid_Pudek1->EditCustomAttributes = "";
		if (!$this->Nid_Pudek1->Raw)
			$this->Nid_Pudek1->CurrentValue = HtmlDecode($this->Nid_Pudek1->CurrentValue);
		$this->Nid_Pudek1->EditValue = $this->Nid_Pudek1->CurrentValue;
		$this->Nid_Pudek1->PlaceHolder = RemoveHtml($this->Nid_Pudek1->caption());

		// Pudek2
		$this->Pudek2->EditAttrs["class"] = "form-control";
		$this->Pudek2->EditCustomAttributes = "";
		if (!$this->Pudek2->Raw)
			$this->Pudek2->CurrentValue = HtmlDecode($this->Pudek2->CurrentValue);
		$this->Pudek2->EditValue = $this->Pudek2->CurrentValue;
		$this->Pudek2->PlaceHolder = RemoveHtml($this->Pudek2->caption());

		// Nid_Pudek2
		$this->Nid_Pudek2->EditAttrs["class"] = "form-control";
		$this->Nid_Pudek2->EditCustomAttributes = "";
		if (!$this->Nid_Pudek2->Raw)
			$this->Nid_Pudek2->CurrentValue = HtmlDecode($this->Nid_Pudek2->CurrentValue);
		$this->Nid_Pudek2->EditValue = $this->Nid_Pudek2->CurrentValue;
		$this->Nid_Pudek2->PlaceHolder = RemoveHtml($this->Nid_Pudek2->caption());

		// Pudek3
		$this->Pudek3->EditAttrs["class"] = "form-control";
		$this->Pudek3->EditCustomAttributes = "";
		if (!$this->Pudek3->Raw)
			$this->Pudek3->CurrentValue = HtmlDecode($this->Pudek3->CurrentValue);
		$this->Pudek3->EditValue = $this->Pudek3->CurrentValue;
		$this->Pudek3->PlaceHolder = RemoveHtml($this->Pudek3->caption());

		// Nid_Pudek3
		$this->Nid_Pudek3->EditAttrs["class"] = "form-control";
		$this->Nid_Pudek3->EditCustomAttributes = "";
		if (!$this->Nid_Pudek3->Raw)
			$this->Nid_Pudek3->CurrentValue = HtmlDecode($this->Nid_Pudek3->CurrentValue);
		$this->Nid_Pudek3->EditValue = $this->Nid_Pudek3->CurrentValue;
		$this->Nid_Pudek3->PlaceHolder = RemoveHtml($this->Nid_Pudek3->caption());

		// kajian
		$this->kajian->EditAttrs["class"] = "form-control";
		$this->kajian->EditCustomAttributes = "";
		if (!$this->kajian->Raw)
			$this->kajian->CurrentValue = HtmlDecode($this->kajian->CurrentValue);
		$this->kajian->EditValue = $this->kajian->CurrentValue;
		$this->kajian->PlaceHolder = RemoveHtml($this->kajian->caption());

		// Logo
		$this->Logo->EditAttrs["class"] = "form-control";
		$this->Logo->EditCustomAttributes = "";
		if (!EmptyValue($this->Logo->Upload->DbValue)) {
			$this->Logo->EditValue = $this->Kode_Fak->CurrentValue;
			$this->Logo->IsBlobImage = IsImageFile(ContentExtension($this->Logo->Upload->DbValue));
		} else {
			$this->Logo->EditValue = "";
		}

		// alamat
		$this->alamat->EditAttrs["class"] = "form-control";
		$this->alamat->EditCustomAttributes = "";
		if (!$this->alamat->Raw)
			$this->alamat->CurrentValue = HtmlDecode($this->alamat->CurrentValue);
		$this->alamat->EditValue = $this->alamat->CurrentValue;
		$this->alamat->PlaceHolder = RemoveHtml($this->alamat->caption());

		// paxphone
		$this->paxphone->EditAttrs["class"] = "form-control";
		$this->paxphone->EditCustomAttributes = "";
		if (!$this->paxphone->Raw)
			$this->paxphone->CurrentValue = HtmlDecode($this->paxphone->CurrentValue);
		$this->paxphone->EditValue = $this->paxphone->CurrentValue;
		$this->paxphone->PlaceHolder = RemoveHtml($this->paxphone->caption());

		// website
		$this->website->EditAttrs["class"] = "form-control";
		$this->website->EditCustomAttributes = "";
		if (!$this->website->Raw)
			$this->website->CurrentValue = HtmlDecode($this->website->CurrentValue);
		$this->website->EditValue = $this->website->CurrentValue;
		$this->website->PlaceHolder = RemoveHtml($this->website->caption());

		// NikBAAK
		$this->NikBAAK->EditAttrs["class"] = "form-control";
		$this->NikBAAK->EditCustomAttributes = "";
		if (!$this->NikBAAK->Raw)
			$this->NikBAAK->CurrentValue = HtmlDecode($this->NikBAAK->CurrentValue);
		$this->NikBAAK->EditValue = $this->NikBAAK->CurrentValue;
		$this->NikBAAK->PlaceHolder = RemoveHtml($this->NikBAAK->caption());

		// BAAK
		$this->BAAK->EditAttrs["class"] = "form-control";
		$this->BAAK->EditCustomAttributes = "";
		if (!$this->BAAK->Raw)
			$this->BAAK->CurrentValue = HtmlDecode($this->BAAK->CurrentValue);
		$this->BAAK->EditValue = $this->BAAK->CurrentValue;
		$this->BAAK->PlaceHolder = RemoveHtml($this->BAAK->caption());

		// ttdketua
		$this->ttdketua->EditAttrs["class"] = "form-control";
		$this->ttdketua->EditCustomAttributes = "";
		if (!EmptyValue($this->ttdketua->Upload->DbValue)) {
			$this->ttdketua->EditValue = $this->Kode_Fak->CurrentValue;
			$this->ttdketua->IsBlobImage = IsImageFile(ContentExtension($this->ttdketua->Upload->DbValue));
		} else {
			$this->ttdketua->EditValue = "";
		}

		// ttwwk1
		$this->ttwwk1->EditAttrs["class"] = "form-control";
		$this->ttwwk1->EditCustomAttributes = "";
		if (!EmptyValue($this->ttwwk1->Upload->DbValue)) {
			$this->ttwwk1->EditValue = $this->Kode_Fak->CurrentValue;
			$this->ttwwk1->IsBlobImage = IsImageFile(ContentExtension($this->ttwwk1->Upload->DbValue));
		} else {
			$this->ttwwk1->EditValue = "";
		}

		// AkreditasiPT
		$this->AkreditasiPT->EditAttrs["class"] = "form-control";
		$this->AkreditasiPT->EditCustomAttributes = "";
		if (!$this->AkreditasiPT->Raw)
			$this->AkreditasiPT->CurrentValue = HtmlDecode($this->AkreditasiPT->CurrentValue);
		$this->AkreditasiPT->EditValue = $this->AkreditasiPT->CurrentValue;
		$this->AkreditasiPT->PlaceHolder = RemoveHtml($this->AkreditasiPT->caption());

		// Kopsurat
		$this->Kopsurat->EditAttrs["class"] = "form-control";
		$this->Kopsurat->EditCustomAttributes = "";
		if (!EmptyValue($this->Kopsurat->Upload->DbValue)) {
			$this->Kopsurat->EditValue = $this->Kode_Fak->CurrentValue;
			$this->Kopsurat->IsBlobImage = IsImageFile(ContentExtension($this->Kopsurat->Upload->DbValue));
		} else {
			$this->Kopsurat->EditValue = "";
		}

		// idpt
		$this->idpt->EditAttrs["class"] = "form-control";
		$this->idpt->EditCustomAttributes = "";
		if (!$this->idpt->Raw)
			$this->idpt->CurrentValue = HtmlDecode($this->idpt->CurrentValue);
		$this->idpt->EditValue = $this->idpt->CurrentValue;
		$this->idpt->PlaceHolder = RemoveHtml($this->idpt->caption());

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->Kode_Fak);
					$doc->exportCaption($this->Nama_Fak);
					$doc->exportCaption($this->Nama_Panjang);
					$doc->exportCaption($this->Nama_Fak_Eng);
					$doc->exportCaption($this->Dekan);
					$doc->exportCaption($this->Nid_Dekan);
					$doc->exportCaption($this->Pudek1);
					$doc->exportCaption($this->Nid_Pudek1);
					$doc->exportCaption($this->Pudek2);
					$doc->exportCaption($this->Nid_Pudek2);
					$doc->exportCaption($this->Pudek3);
					$doc->exportCaption($this->Nid_Pudek3);
					$doc->exportCaption($this->kajian);
					$doc->exportCaption($this->Logo);
					$doc->exportCaption($this->alamat);
					$doc->exportCaption($this->paxphone);
					$doc->exportCaption($this->website);
					$doc->exportCaption($this->NikBAAK);
					$doc->exportCaption($this->BAAK);
					$doc->exportCaption($this->ttdketua);
					$doc->exportCaption($this->ttwwk1);
					$doc->exportCaption($this->AkreditasiPT);
					$doc->exportCaption($this->Kopsurat);
					$doc->exportCaption($this->idpt);
				} else {
					$doc->exportCaption($this->Kode_Fak);
					$doc->exportCaption($this->Nama_Fak);
					$doc->exportCaption($this->Nama_Panjang);
					$doc->exportCaption($this->Nama_Fak_Eng);
					$doc->exportCaption($this->Dekan);
					$doc->exportCaption($this->Nid_Dekan);
					$doc->exportCaption($this->Pudek1);
					$doc->exportCaption($this->Nid_Pudek1);
					$doc->exportCaption($this->Pudek2);
					$doc->exportCaption($this->Nid_Pudek2);
					$doc->exportCaption($this->Pudek3);
					$doc->exportCaption($this->Nid_Pudek3);
					$doc->exportCaption($this->kajian);
					$doc->exportCaption($this->alamat);
					$doc->exportCaption($this->paxphone);
					$doc->exportCaption($this->website);
					$doc->exportCaption($this->NikBAAK);
					$doc->exportCaption($this->BAAK);
					$doc->exportCaption($this->AkreditasiPT);
					$doc->exportCaption($this->idpt);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->Kode_Fak);
						$doc->exportField($this->Nama_Fak);
						$doc->exportField($this->Nama_Panjang);
						$doc->exportField($this->Nama_Fak_Eng);
						$doc->exportField($this->Dekan);
						$doc->exportField($this->Nid_Dekan);
						$doc->exportField($this->Pudek1);
						$doc->exportField($this->Nid_Pudek1);
						$doc->exportField($this->Pudek2);
						$doc->exportField($this->Nid_Pudek2);
						$doc->exportField($this->Pudek3);
						$doc->exportField($this->Nid_Pudek3);
						$doc->exportField($this->kajian);
						$doc->exportField($this->Logo);
						$doc->exportField($this->alamat);
						$doc->exportField($this->paxphone);
						$doc->exportField($this->website);
						$doc->exportField($this->NikBAAK);
						$doc->exportField($this->BAAK);
						$doc->exportField($this->ttdketua);
						$doc->exportField($this->ttwwk1);
						$doc->exportField($this->AkreditasiPT);
						$doc->exportField($this->Kopsurat);
						$doc->exportField($this->idpt);
					} else {
						$doc->exportField($this->Kode_Fak);
						$doc->exportField($this->Nama_Fak);
						$doc->exportField($this->Nama_Panjang);
						$doc->exportField($this->Nama_Fak_Eng);
						$doc->exportField($this->Dekan);
						$doc->exportField($this->Nid_Dekan);
						$doc->exportField($this->Pudek1);
						$doc->exportField($this->Nid_Pudek1);
						$doc->exportField($this->Pudek2);
						$doc->exportField($this->Nid_Pudek2);
						$doc->exportField($this->Pudek3);
						$doc->exportField($this->Nid_Pudek3);
						$doc->exportField($this->kajian);
						$doc->exportField($this->alamat);
						$doc->exportField($this->paxphone);
						$doc->exportField($this->website);
						$doc->exportField($this->NikBAAK);
						$doc->exportField($this->BAAK);
						$doc->exportField($this->AkreditasiPT);
						$doc->exportField($this->idpt);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0)
	{
		$width = ($width > 0) ? $width : Config("THUMBNAIL_DEFAULT_WIDTH");
		$height = ($height > 0) ? $height : Config("THUMBNAIL_DEFAULT_HEIGHT");

		// Set up field name / file name field / file type field
		$fldName = "";
		$fileNameFld = "";
		$fileTypeFld = "";
		if ($fldparm == 'Logo') {
			$fldName = "Logo";
		} elseif ($fldparm == 'ttdketua') {
			$fldName = "ttdketua";
		} elseif ($fldparm == 'ttwwk1') {
			$fldName = "ttwwk1";
		} elseif ($fldparm == 'Kopsurat') {
			$fldName = "Kopsurat";
		} else {
			return FALSE; // Incorrect field
		}

		// Set up key values
		$ar = explode(Config("COMPOSITE_KEY_SEPARATOR"), $key);
		if (count($ar) == 1) {
			$this->Kode_Fak->CurrentValue = $ar[0];
		} else {
			return FALSE; // Incorrect key
		}

		// Set up filter (WHERE Clause)
		$filter = $this->getRecordFilter();
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = $this->getConnection();
		$dbtype = GetConnectionType($this->Dbid);
		if (($rs = $conn->execute($sql)) && !$rs->EOF) {
			$val = $rs->fields($fldName);
			if (!EmptyValue($val)) {
				$fld = $this->fields[$fldName];

				// Binary data
				if ($fld->DataType == DATATYPE_BLOB) {
					if ($dbtype != "MYSQL") {
						if (is_array($val) || is_object($val)) // Byte array
							$val = BytesToString($val);
					}
					if ($resize)
						ResizeBinary($val, $width, $height);

					// Write file type
					if ($fileTypeFld != "" && !EmptyValue($rs->fields($fileTypeFld))) {
						AddHeader("Content-type", $rs->fields($fileTypeFld));
					} else {
						AddHeader("Content-type", ContentType($val));
					}

					// Write file name
					$downloadPdf = !Config("EMBED_PDF") && Config("DOWNLOAD_PDF_FILE");
					if ($fileNameFld != "" && !EmptyValue($rs->fields($fileNameFld))) {
						$fileName = $rs->fields($fileNameFld);
						$pathinfo = pathinfo($fileName);
						$ext = strtolower(@$pathinfo["extension"]);
						$isPdf = SameText($ext, "pdf");
						if ($downloadPdf || !$isPdf) // Skip header if not download PDF
							AddHeader("Content-Disposition", "attachment; filename=\"" . $fileName . "\"");
					} else {
						$ext = ContentExtension($val);
						$isPdf = SameText($ext, ".pdf");
						if ($isPdf && $downloadPdf) // Add header if download PDF
							AddHeader("Content-Disposition", "attachment; filename=\"" . $fileName . "\"");
					}

					// Write file data
					if (StartsString("PK", $val) && ContainsString($val, "[Content_Types].xml") &&
						ContainsString($val, "_rels") && ContainsString($val, "docProps")) { // Fix Office 2007 documents
						if (!EndsString("\0\0\0", $val)) // Not ends with 3 or 4 \0
							$val .= "\0\0\0\0";
					}

					// Clear any debug message
					if (ob_get_length())
						ob_end_clean();

					// Write binary data
					Write($val);

				// Upload to folder
				} else {
					if ($fld->UploadMultiple)
						$files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
					else
						$files = [$val];
					$data = [];
					$ar = [];
					foreach ($files as $file) {
						if (!EmptyValue($file))
							$ar[$file] = FullUrl($fld->hrefPath() . $file);
					}
					$data[$fld->Param] = $ar;
					WriteJson($data);
				}
			}
			$rs->close();
			return TRUE;
		}
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>