<?php namespace PHPMaker2020\baak; ?>
<?php

/**
 * Table class for tblMHS
 */
class tblMHS extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $Nim;
	public $Nama_Mhs;
	public $Kode_jp;
	public $Tmp_Lahir;
	public $Tgl_Lahir;
	public $Jenis_Kel;
	public $Gol_darah;
	public $Agama_Mhs;
	public $Alamat_Mhs;
	public $rt;
	public $rw;
	public $Kelurahan;
	public $Kecamatan;
	public $Kota_Mhs;
	public $Provinsi_mhs;
	public $Kodepos_Mhs;
	public $Tlp_Mhs;
	public $TlpRumah;
	public $_Email;
	public $Status_Akd;
	public $ThMasuk;
	public $tglmasuk;
	public $Status_Masuk;
	public $Sem_Masuk;
	public $TaMasuk;
	public $PerMasuk;
	public $Pendidikan_Akhir;
	public $Jurusan;
	public $Thn_Selesai;
	public $Kota_Pdkk;
	public $propinsi;
	public $NIMASAL;
	public $KPTSASAL;
	public $JENASAL;
	public $PSASAL;
	public $TSKSDIAKUI;
	public $NamaSekolahAsal;
	public $AlamatSekolahAsal;
	public $Status;
	public $Photo;
	public $Password;
	public $Gelombang;
	public $JalurMasuk;
	public $Konsentrasi;
	public $NIK;
	public $NamaIbu;
	public $BekerjaDi;
	public $Lama;
	public $AlamatPerusahaan;
	public $TlpPerusahaan;
	public $Posisi;
	public $Departemen;
	public $IdUser;
	public $TempID;
	public $xphoto;
	public $profile;
	public $id_agama;
	public $id_negara;
	public $id_wilayah;
	public $id_jenis_tinggal;
	public $id_alat_transportasi;
	public $no_kps;
	public $penerima_kps;
	public $id_kebutuhan_khusus_mahasiswa;
	public $nisn;
	public $iddesa;
	public $MulaiKerja;
	public $IdKlsKerjasama;
	public $IDBeasiswa;
	public $tglKonversi;
	public $NoSuratKonversi;
	public $Nopen;
	public $id_feedmhs;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;
		parent::__construct();

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'tblMHS';
		$this->TableName = 'tblMHS';
		$this->TableType = 'TABLE';

		// Update Table
		$this->UpdateTable = "[dbo].[tblMHS]";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
		$this->BasicSearch = new BasicSearch($this->TableVar);

		// Nim
		$this->Nim = new DbField('tblMHS', 'tblMHS', 'x_Nim', 'Nim', '[Nim]', '[Nim]', 129, 14, -1, FALSE, '[Nim]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Nim->IsPrimaryKey = TRUE; // Primary key field
		$this->Nim->IsForeignKey = TRUE; // Foreign key field
		$this->Nim->Nullable = FALSE; // NOT NULL field
		$this->Nim->Required = TRUE; // Required field
		$this->Nim->Sortable = TRUE; // Allow sort
		$this->fields['Nim'] = &$this->Nim;

		// Nama_Mhs
		$this->Nama_Mhs = new DbField('tblMHS', 'tblMHS', 'x_Nama_Mhs', 'Nama_Mhs', '[Nama_Mhs]', '[Nama_Mhs]', 129, 60, -1, FALSE, '[Nama_Mhs]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Nama_Mhs->Sortable = TRUE; // Allow sort
		$this->fields['Nama_Mhs'] = &$this->Nama_Mhs;

		// Kode_jp
		$this->Kode_jp = new DbField('tblMHS', 'tblMHS', 'x_Kode_jp', 'Kode_jp', '[Kode_jp]', '[Kode_jp]', 129, 4, -1, FALSE, '[Kode_jp]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->Kode_jp->Sortable = TRUE; // Allow sort
		$this->Kode_jp->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->Kode_jp->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
		$this->Kode_jp->Lookup = new Lookup('Kode_jp', 'TblJurusan', FALSE, 'Kode_Jp', ["Kode_Jp","Jurusan","Program",""], [], [], [], [], [], [], '', '');
		$this->fields['Kode_jp'] = &$this->Kode_jp;

		// Tmp_Lahir
		$this->Tmp_Lahir = new DbField('tblMHS', 'tblMHS', 'x_Tmp_Lahir', 'Tmp_Lahir', '[Tmp_Lahir]', '[Tmp_Lahir]', 129, 40, -1, FALSE, '[Tmp_Lahir]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Tmp_Lahir->Sortable = TRUE; // Allow sort
		$this->fields['Tmp_Lahir'] = &$this->Tmp_Lahir;

		// Tgl_Lahir
		$this->Tgl_Lahir = new DbField('tblMHS', 'tblMHS', 'x_Tgl_Lahir', 'Tgl_Lahir', '[Tgl_Lahir]', CastDateFieldForLike("[Tgl_Lahir]", 0, "DB"), 135, 8, 0, FALSE, '[Tgl_Lahir]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Tgl_Lahir->Sortable = TRUE; // Allow sort
		$this->Tgl_Lahir->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['Tgl_Lahir'] = &$this->Tgl_Lahir;

		// Jenis_Kel
		$this->Jenis_Kel = new DbField('tblMHS', 'tblMHS', 'x_Jenis_Kel', 'Jenis_Kel', '[Jenis_Kel]', '[Jenis_Kel]', 200, 9, -1, FALSE, '[Jenis_Kel]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->Jenis_Kel->Sortable = TRUE; // Allow sort
		$this->Jenis_Kel->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->Jenis_Kel->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
		$this->Jenis_Kel->Lookup = new Lookup('Jenis_Kel', 'tblMHS', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->Jenis_Kel->OptionCount = 3;
		$this->fields['Jenis_Kel'] = &$this->Jenis_Kel;

		// Gol_darah
		$this->Gol_darah = new DbField('tblMHS', 'tblMHS', 'x_Gol_darah', 'Gol_darah', '[Gol_darah]', '[Gol_darah]', 200, 2, -1, FALSE, '[Gol_darah]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Gol_darah->Sortable = TRUE; // Allow sort
		$this->fields['Gol_darah'] = &$this->Gol_darah;

		// Agama_Mhs
		$this->Agama_Mhs = new DbField('tblMHS', 'tblMHS', 'x_Agama_Mhs', 'Agama_Mhs', '[Agama_Mhs]', '[Agama_Mhs]', 129, 10, -1, FALSE, '[Agama_Mhs]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Agama_Mhs->Sortable = TRUE; // Allow sort
		$this->fields['Agama_Mhs'] = &$this->Agama_Mhs;

		// Alamat_Mhs
		$this->Alamat_Mhs = new DbField('tblMHS', 'tblMHS', 'x_Alamat_Mhs', 'Alamat_Mhs', '[Alamat_Mhs]', '[Alamat_Mhs]', 129, 70, -1, FALSE, '[Alamat_Mhs]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Alamat_Mhs->Sortable = TRUE; // Allow sort
		$this->fields['Alamat_Mhs'] = &$this->Alamat_Mhs;

		// rt
		$this->rt = new DbField('tblMHS', 'tblMHS', 'x_rt', 'rt', '[rt]', '[rt]', 200, 5, -1, FALSE, '[rt]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->rt->Sortable = TRUE; // Allow sort
		$this->fields['rt'] = &$this->rt;

		// rw
		$this->rw = new DbField('tblMHS', 'tblMHS', 'x_rw', 'rw', '[rw]', '[rw]', 200, 5, -1, FALSE, '[rw]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->rw->Sortable = TRUE; // Allow sort
		$this->fields['rw'] = &$this->rw;

		// Kelurahan
		$this->Kelurahan = new DbField('tblMHS', 'tblMHS', 'x_Kelurahan', 'Kelurahan', '[Kelurahan]', '[Kelurahan]', 129, 30, -1, FALSE, '[Kelurahan]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Kelurahan->Sortable = TRUE; // Allow sort
		$this->fields['Kelurahan'] = &$this->Kelurahan;

		// Kecamatan
		$this->Kecamatan = new DbField('tblMHS', 'tblMHS', 'x_Kecamatan', 'Kecamatan', '[Kecamatan]', '[Kecamatan]', 129, 30, -1, FALSE, '[Kecamatan]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Kecamatan->Sortable = TRUE; // Allow sort
		$this->fields['Kecamatan'] = &$this->Kecamatan;

		// Kota_Mhs
		$this->Kota_Mhs = new DbField('tblMHS', 'tblMHS', 'x_Kota_Mhs', 'Kota_Mhs', '[Kota_Mhs]', '[Kota_Mhs]', 129, 50, -1, FALSE, '[Kota_Mhs]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Kota_Mhs->Sortable = TRUE; // Allow sort
		$this->fields['Kota_Mhs'] = &$this->Kota_Mhs;

		// Provinsi_mhs
		$this->Provinsi_mhs = new DbField('tblMHS', 'tblMHS', 'x_Provinsi_mhs', 'Provinsi_mhs', '[Provinsi_mhs]', '[Provinsi_mhs]', 129, 30, -1, FALSE, '[Provinsi_mhs]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Provinsi_mhs->Sortable = TRUE; // Allow sort
		$this->fields['Provinsi_mhs'] = &$this->Provinsi_mhs;

		// Kodepos_Mhs
		$this->Kodepos_Mhs = new DbField('tblMHS', 'tblMHS', 'x_Kodepos_Mhs', 'Kodepos_Mhs', '[Kodepos_Mhs]', '[Kodepos_Mhs]', 129, 5, -1, FALSE, '[Kodepos_Mhs]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Kodepos_Mhs->Sortable = TRUE; // Allow sort
		$this->fields['Kodepos_Mhs'] = &$this->Kodepos_Mhs;

		// Tlp_Mhs
		$this->Tlp_Mhs = new DbField('tblMHS', 'tblMHS', 'x_Tlp_Mhs', 'Tlp_Mhs', '[Tlp_Mhs]', '[Tlp_Mhs]', 129, 15, -1, FALSE, '[Tlp_Mhs]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Tlp_Mhs->Sortable = TRUE; // Allow sort
		$this->fields['Tlp_Mhs'] = &$this->Tlp_Mhs;

		// TlpRumah
		$this->TlpRumah = new DbField('tblMHS', 'tblMHS', 'x_TlpRumah', 'TlpRumah', '[TlpRumah]', '[TlpRumah]', 129, 15, -1, FALSE, '[TlpRumah]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->TlpRumah->Sortable = TRUE; // Allow sort
		$this->fields['TlpRumah'] = &$this->TlpRumah;

		// Email
		$this->_Email = new DbField('tblMHS', 'tblMHS', 'x__Email', 'Email', '[Email]', '[Email]', 129, 50, -1, FALSE, '[Email]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_Email->Sortable = TRUE; // Allow sort
		$this->fields['Email'] = &$this->_Email;

		// Status_Akd
		$this->Status_Akd = new DbField('tblMHS', 'tblMHS', 'x_Status_Akd', 'Status_Akd', '[Status_Akd]', '[Status_Akd]', 200, 15, -1, FALSE, '[Status_Akd]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->Status_Akd->Sortable = TRUE; // Allow sort
		$this->Status_Akd->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->Status_Akd->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
		$this->Status_Akd->Lookup = new Lookup('Status_Akd', 'tblkelas', FALSE, 'Kelas', ["Kelas","","",""], [], [], [], [], [], [], '', '');
		$this->fields['Status_Akd'] = &$this->Status_Akd;

		// ThMasuk
		$this->ThMasuk = new DbField('tblMHS', 'tblMHS', 'x_ThMasuk', 'ThMasuk', '[ThMasuk]', '[ThMasuk]', 129, 4, -1, FALSE, '[ThMasuk]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->ThMasuk->Sortable = TRUE; // Allow sort
		$this->fields['ThMasuk'] = &$this->ThMasuk;

		// tglmasuk
		$this->tglmasuk = new DbField('tblMHS', 'tblMHS', 'x_tglmasuk', 'tglmasuk', '[tglmasuk]', CastDateFieldForLike("[tglmasuk]", 7, "DB"), 135, 8, 7, FALSE, '[tglmasuk]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->tglmasuk->Sortable = TRUE; // Allow sort
		$this->tglmasuk->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_SEPARATOR"], $Language->phrase("IncorrectDateDMY"));
		$this->fields['tglmasuk'] = &$this->tglmasuk;

		// Status_Masuk
		$this->Status_Masuk = new DbField('tblMHS', 'tblMHS', 'x_Status_Masuk', 'Status_Masuk', '[Status_Masuk]', '[Status_Masuk]', 129, 10, -1, FALSE, '[Status_Masuk]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->Status_Masuk->Sortable = TRUE; // Allow sort
		$this->Status_Masuk->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->Status_Masuk->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
		$this->Status_Masuk->Lookup = new Lookup('Status_Masuk', 'tblMHS', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->Status_Masuk->OptionCount = 2;
		$this->fields['Status_Masuk'] = &$this->Status_Masuk;

		// Sem_Masuk
		$this->Sem_Masuk = new DbField('tblMHS', 'tblMHS', 'x_Sem_Masuk', 'Sem_Masuk', '[Sem_Masuk]', '[Sem_Masuk]', 129, 6, -1, FALSE, '[Sem_Masuk]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Sem_Masuk->Sortable = TRUE; // Allow sort
		$this->fields['Sem_Masuk'] = &$this->Sem_Masuk;

		// TaMasuk
		$this->TaMasuk = new DbField('tblMHS', 'tblMHS', 'x_TaMasuk', 'TaMasuk', '[TaMasuk]', '[TaMasuk]', 129, 9, -1, FALSE, '[TaMasuk]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->TaMasuk->Sortable = TRUE; // Allow sort
		$this->TaMasuk->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->TaMasuk->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
		$this->TaMasuk->Lookup = new Lookup('TaMasuk', 'Qthakd', FALSE, 'TA', ["TA","","",""], [], [], [], [], [], [], '', '');
		$this->fields['TaMasuk'] = &$this->TaMasuk;

		// PerMasuk
		$this->PerMasuk = new DbField('tblMHS', 'tblMHS', 'x_PerMasuk', 'PerMasuk', '[PerMasuk]', '[PerMasuk]', 129, 2, -1, FALSE, '[PerMasuk]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->PerMasuk->Sortable = TRUE; // Allow sort
		$this->PerMasuk->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->PerMasuk->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
		$this->PerMasuk->Lookup = new Lookup('PerMasuk', 'tblMHS', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->PerMasuk->OptionCount = 3;
		$this->fields['PerMasuk'] = &$this->PerMasuk;

		// Pendidikan_Akhir
		$this->Pendidikan_Akhir = new DbField('tblMHS', 'tblMHS', 'x_Pendidikan_Akhir', 'Pendidikan_Akhir', '[Pendidikan_Akhir]', '[Pendidikan_Akhir]', 129, 10, -1, FALSE, '[Pendidikan_Akhir]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Pendidikan_Akhir->Sortable = TRUE; // Allow sort
		$this->fields['Pendidikan_Akhir'] = &$this->Pendidikan_Akhir;

		// Jurusan
		$this->Jurusan = new DbField('tblMHS', 'tblMHS', 'x_Jurusan', 'Jurusan', '[Jurusan]', '[Jurusan]', 129, 30, -1, FALSE, '[Jurusan]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Jurusan->Sortable = TRUE; // Allow sort
		$this->fields['Jurusan'] = &$this->Jurusan;

		// Thn_Selesai
		$this->Thn_Selesai = new DbField('tblMHS', 'tblMHS', 'x_Thn_Selesai', 'Thn_Selesai', '[Thn_Selesai]', '[Thn_Selesai]', 129, 4, -1, FALSE, '[Thn_Selesai]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Thn_Selesai->Sortable = TRUE; // Allow sort
		$this->fields['Thn_Selesai'] = &$this->Thn_Selesai;

		// Kota_Pdkk
		$this->Kota_Pdkk = new DbField('tblMHS', 'tblMHS', 'x_Kota_Pdkk', 'Kota_Pdkk', '[Kota_Pdkk]', '[Kota_Pdkk]', 129, 40, -1, FALSE, '[Kota_Pdkk]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Kota_Pdkk->Sortable = TRUE; // Allow sort
		$this->fields['Kota_Pdkk'] = &$this->Kota_Pdkk;

		// propinsi
		$this->propinsi = new DbField('tblMHS', 'tblMHS', 'x_propinsi', 'propinsi', '[propinsi]', '[propinsi]', 129, 40, -1, FALSE, '[propinsi]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->propinsi->Sortable = TRUE; // Allow sort
		$this->fields['propinsi'] = &$this->propinsi;

		// NIMASAL
		$this->NIMASAL = new DbField('tblMHS', 'tblMHS', 'x_NIMASAL', 'NIMASAL', '[NIMASAL]', '[NIMASAL]', 129, 15, -1, FALSE, '[NIMASAL]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->NIMASAL->Sortable = TRUE; // Allow sort
		$this->fields['NIMASAL'] = &$this->NIMASAL;

		// KPTSASAL
		$this->KPTSASAL = new DbField('tblMHS', 'tblMHS', 'x_KPTSASAL', 'KPTSASAL', '[KPTSASAL]', '[KPTSASAL]', 129, 7, -1, FALSE, '[KPTSASAL]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->KPTSASAL->Sortable = TRUE; // Allow sort
		$this->fields['KPTSASAL'] = &$this->KPTSASAL;

		// JENASAL
		$this->JENASAL = new DbField('tblMHS', 'tblMHS', 'x_JENASAL', 'JENASAL', '[JENASAL]', '[JENASAL]', 129, 2, -1, FALSE, '[JENASAL]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->JENASAL->Sortable = TRUE; // Allow sort
		$this->fields['JENASAL'] = &$this->JENASAL;

		// PSASAL
		$this->PSASAL = new DbField('tblMHS', 'tblMHS', 'x_PSASAL', 'PSASAL', '[PSASAL]', '[PSASAL]', 129, 6, -1, FALSE, '[PSASAL]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->PSASAL->Sortable = TRUE; // Allow sort
		$this->fields['PSASAL'] = &$this->PSASAL;

		// TSKSDIAKUI
		$this->TSKSDIAKUI = new DbField('tblMHS', 'tblMHS', 'x_TSKSDIAKUI', 'TSKSDIAKUI', '[TSKSDIAKUI]', 'CAST([TSKSDIAKUI] AS NVARCHAR)', 3, 4, -1, FALSE, '[TSKSDIAKUI]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->TSKSDIAKUI->Sortable = TRUE; // Allow sort
		$this->TSKSDIAKUI->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['TSKSDIAKUI'] = &$this->TSKSDIAKUI;

		// NamaSekolahAsal
		$this->NamaSekolahAsal = new DbField('tblMHS', 'tblMHS', 'x_NamaSekolahAsal', 'NamaSekolahAsal', '[NamaSekolahAsal]', '[NamaSekolahAsal]', 129, 50, -1, FALSE, '[NamaSekolahAsal]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->NamaSekolahAsal->Sortable = TRUE; // Allow sort
		$this->fields['NamaSekolahAsal'] = &$this->NamaSekolahAsal;

		// AlamatSekolahAsal
		$this->AlamatSekolahAsal = new DbField('tblMHS', 'tblMHS', 'x_AlamatSekolahAsal', 'AlamatSekolahAsal', '[AlamatSekolahAsal]', '[AlamatSekolahAsal]', 129, 50, -1, FALSE, '[AlamatSekolahAsal]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->AlamatSekolahAsal->Sortable = TRUE; // Allow sort
		$this->fields['AlamatSekolahAsal'] = &$this->AlamatSekolahAsal;

		// Status
		$this->Status = new DbField('tblMHS', 'tblMHS', 'x_Status', 'Status', '[Status]', '[Status]', 129, 10, -1, FALSE, '[Status]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->Status->Sortable = TRUE; // Allow sort
		$this->Status->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->Status->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
		$this->Status->Lookup = new Lookup('Status', 'tblMHS', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->Status->OptionCount = 7;
		$this->fields['Status'] = &$this->Status;

		// Photo
		$this->Photo = new DbField('tblMHS', 'tblMHS', 'x_Photo', 'Photo', '[Photo]', '[Photo]', 205, 0, -1, TRUE, '[Photo]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'FILE');
		$this->Photo->Sortable = TRUE; // Allow sort
		$this->fields['Photo'] = &$this->Photo;

		// Password
		$this->Password = new DbField('tblMHS', 'tblMHS', 'x_Password', 'Password', '[Password]', '[Password]', 200, 32, -1, FALSE, '[Password]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Password->Sortable = TRUE; // Allow sort
		$this->fields['Password'] = &$this->Password;

		// Gelombang
		$this->Gelombang = new DbField('tblMHS', 'tblMHS', 'x_Gelombang', 'Gelombang', '[Gelombang]', '[Gelombang]', 200, 20, -1, FALSE, '[Gelombang]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Gelombang->Sortable = TRUE; // Allow sort
		$this->fields['Gelombang'] = &$this->Gelombang;

		// JalurMasuk
		$this->JalurMasuk = new DbField('tblMHS', 'tblMHS', 'x_JalurMasuk', 'JalurMasuk', '[JalurMasuk]', '[JalurMasuk]', 200, 20, -1, FALSE, '[JalurMasuk]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->JalurMasuk->Sortable = TRUE; // Allow sort
		$this->fields['JalurMasuk'] = &$this->JalurMasuk;

		// Konsentrasi
		$this->Konsentrasi = new DbField('tblMHS', 'tblMHS', 'x_Konsentrasi', 'Konsentrasi', '[Konsentrasi]', '[Konsentrasi]', 129, 10, -1, FALSE, '[Konsentrasi]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Konsentrasi->Sortable = TRUE; // Allow sort
		$this->fields['Konsentrasi'] = &$this->Konsentrasi;

		// NIK
		$this->NIK = new DbField('tblMHS', 'tblMHS', 'x_NIK', 'NIK', '[NIK]', '[NIK]', 200, 20, -1, FALSE, '[NIK]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->NIK->Sortable = TRUE; // Allow sort
		$this->fields['NIK'] = &$this->NIK;

		// NamaIbu
		$this->NamaIbu = new DbField('tblMHS', 'tblMHS', 'x_NamaIbu', 'NamaIbu', '[NamaIbu]', '[NamaIbu]', 200, 50, -1, FALSE, '[NamaIbu]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->NamaIbu->Sortable = TRUE; // Allow sort
		$this->fields['NamaIbu'] = &$this->NamaIbu;

		// BekerjaDi
		$this->BekerjaDi = new DbField('tblMHS', 'tblMHS', 'x_BekerjaDi', 'BekerjaDi', '[BekerjaDi]', '[BekerjaDi]', 200, 100, -1, FALSE, '[BekerjaDi]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->BekerjaDi->Sortable = TRUE; // Allow sort
		$this->fields['BekerjaDi'] = &$this->BekerjaDi;

		// Lama
		$this->Lama = new DbField('tblMHS', 'tblMHS', 'x_Lama', 'Lama', '[Lama]', '[Lama]', 200, 50, -1, FALSE, '[Lama]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Lama->Sortable = TRUE; // Allow sort
		$this->fields['Lama'] = &$this->Lama;

		// AlamatPerusahaan
		$this->AlamatPerusahaan = new DbField('tblMHS', 'tblMHS', 'x_AlamatPerusahaan', 'AlamatPerusahaan', '[AlamatPerusahaan]', '[AlamatPerusahaan]', 200, 50, -1, FALSE, '[AlamatPerusahaan]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->AlamatPerusahaan->Sortable = TRUE; // Allow sort
		$this->fields['AlamatPerusahaan'] = &$this->AlamatPerusahaan;

		// TlpPerusahaan
		$this->TlpPerusahaan = new DbField('tblMHS', 'tblMHS', 'x_TlpPerusahaan', 'TlpPerusahaan', '[TlpPerusahaan]', '[TlpPerusahaan]', 200, 20, -1, FALSE, '[TlpPerusahaan]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->TlpPerusahaan->Sortable = TRUE; // Allow sort
		$this->fields['TlpPerusahaan'] = &$this->TlpPerusahaan;

		// Posisi
		$this->Posisi = new DbField('tblMHS', 'tblMHS', 'x_Posisi', 'Posisi', '[Posisi]', '[Posisi]', 200, 50, -1, FALSE, '[Posisi]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Posisi->Sortable = TRUE; // Allow sort
		$this->fields['Posisi'] = &$this->Posisi;

		// Departemen
		$this->Departemen = new DbField('tblMHS', 'tblMHS', 'x_Departemen', 'Departemen', '[Departemen]', '[Departemen]', 200, 50, -1, FALSE, '[Departemen]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Departemen->Sortable = TRUE; // Allow sort
		$this->fields['Departemen'] = &$this->Departemen;

		// IdUser
		$this->IdUser = new DbField('tblMHS', 'tblMHS', 'x_IdUser', 'IdUser', '[IdUser]', '[IdUser]', 200, 24, -1, FALSE, '[IdUser]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->IdUser->Sortable = TRUE; // Allow sort
		$this->fields['IdUser'] = &$this->IdUser;

		// TempID
		$this->TempID = new DbField('tblMHS', 'tblMHS', 'x_TempID', 'TempID', '[TempID]', 'CAST([TempID] AS NVARCHAR)', 3, 4, -1, FALSE, '[TempID]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->TempID->Sortable = TRUE; // Allow sort
		$this->TempID->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['TempID'] = &$this->TempID;

		// xphoto
		$this->xphoto = new DbField('tblMHS', 'tblMHS', 'x_xphoto', 'xphoto', '[xphoto]', '[xphoto]', 200, 100, -1, FALSE, '[xphoto]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->xphoto->Sortable = TRUE; // Allow sort
		$this->fields['xphoto'] = &$this->xphoto;

		// profile
		$this->profile = new DbField('tblMHS', 'tblMHS', 'x_profile', 'profile', '[profile]', '[profile]', 200, 0, -1, FALSE, '[profile]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->profile->Sortable = TRUE; // Allow sort
		$this->fields['profile'] = &$this->profile;

		// id_agama
		$this->id_agama = new DbField('tblMHS', 'tblMHS', 'x_id_agama', 'id_agama', '[id_agama]', 'CAST([id_agama] AS NVARCHAR)', 3, 4, -1, FALSE, '[id_agama]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->id_agama->Sortable = TRUE; // Allow sort
		$this->id_agama->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['id_agama'] = &$this->id_agama;

		// id_negara
		$this->id_negara = new DbField('tblMHS', 'tblMHS', 'x_id_negara', 'id_negara', '[id_negara]', '[id_negara]', 200, 2, -1, FALSE, '[id_negara]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->id_negara->Sortable = TRUE; // Allow sort
		$this->fields['id_negara'] = &$this->id_negara;

		// id_wilayah
		$this->id_wilayah = new DbField('tblMHS', 'tblMHS', 'x_id_wilayah', 'id_wilayah', '[id_wilayah]', '[id_wilayah]', 200, 8, -1, FALSE, '[id_wilayah]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->id_wilayah->Sortable = TRUE; // Allow sort
		$this->fields['id_wilayah'] = &$this->id_wilayah;

		// id_jenis_tinggal
		$this->id_jenis_tinggal = new DbField('tblMHS', 'tblMHS', 'x_id_jenis_tinggal', 'id_jenis_tinggal', '[id_jenis_tinggal]', 'CAST([id_jenis_tinggal] AS NVARCHAR)', 3, 4, -1, FALSE, '[id_jenis_tinggal]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->id_jenis_tinggal->Sortable = TRUE; // Allow sort
		$this->id_jenis_tinggal->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['id_jenis_tinggal'] = &$this->id_jenis_tinggal;

		// id_alat_transportasi
		$this->id_alat_transportasi = new DbField('tblMHS', 'tblMHS', 'x_id_alat_transportasi', 'id_alat_transportasi', '[id_alat_transportasi]', 'CAST([id_alat_transportasi] AS NVARCHAR)', 3, 4, -1, FALSE, '[id_alat_transportasi]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->id_alat_transportasi->Sortable = TRUE; // Allow sort
		$this->id_alat_transportasi->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['id_alat_transportasi'] = &$this->id_alat_transportasi;

		// no_kps
		$this->no_kps = new DbField('tblMHS', 'tblMHS', 'x_no_kps', 'no_kps', '[no_kps]', '[no_kps]', 200, 80, -1, FALSE, '[no_kps]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->no_kps->Sortable = TRUE; // Allow sort
		$this->fields['no_kps'] = &$this->no_kps;

		// penerima_kps
		$this->penerima_kps = new DbField('tblMHS', 'tblMHS', 'x_penerima_kps', 'penerima_kps', '[penerima_kps]', 'CAST([penerima_kps] AS NVARCHAR)', 3, 4, -1, FALSE, '[penerima_kps]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->penerima_kps->Sortable = TRUE; // Allow sort
		$this->penerima_kps->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['penerima_kps'] = &$this->penerima_kps;

		// id_kebutuhan_khusus_mahasiswa
		$this->id_kebutuhan_khusus_mahasiswa = new DbField('tblMHS', 'tblMHS', 'x_id_kebutuhan_khusus_mahasiswa', 'id_kebutuhan_khusus_mahasiswa', '[id_kebutuhan_khusus_mahasiswa]', 'CAST([id_kebutuhan_khusus_mahasiswa] AS NVARCHAR)', 3, 4, -1, FALSE, '[id_kebutuhan_khusus_mahasiswa]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->id_kebutuhan_khusus_mahasiswa->Sortable = TRUE; // Allow sort
		$this->id_kebutuhan_khusus_mahasiswa->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['id_kebutuhan_khusus_mahasiswa'] = &$this->id_kebutuhan_khusus_mahasiswa;

		// nisn
		$this->nisn = new DbField('tblMHS', 'tblMHS', 'x_nisn', 'nisn', '[nisn]', '[nisn]', 200, 10, -1, FALSE, '[nisn]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->nisn->Sortable = TRUE; // Allow sort
		$this->fields['nisn'] = &$this->nisn;

		// iddesa
		$this->iddesa = new DbField('tblMHS', 'tblMHS', 'x_iddesa', 'iddesa', '[iddesa]', 'CAST([iddesa] AS NVARCHAR)', 3, 4, -1, FALSE, '[iddesa]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->iddesa->Sortable = TRUE; // Allow sort
		$this->iddesa->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['iddesa'] = &$this->iddesa;

		// MulaiKerja
		$this->MulaiKerja = new DbField('tblMHS', 'tblMHS', 'x_MulaiKerja', 'MulaiKerja', '[MulaiKerja]', CastDateFieldForLike("[MulaiKerja]", 0, "DB"), 135, 8, 0, FALSE, '[MulaiKerja]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->MulaiKerja->Sortable = TRUE; // Allow sort
		$this->MulaiKerja->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['MulaiKerja'] = &$this->MulaiKerja;

		// IdKlsKerjasama
		$this->IdKlsKerjasama = new DbField('tblMHS', 'tblMHS', 'x_IdKlsKerjasama', 'IdKlsKerjasama', '[IdKlsKerjasama]', 'CAST([IdKlsKerjasama] AS NVARCHAR)', 3, 4, -1, FALSE, '[IdKlsKerjasama]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->IdKlsKerjasama->Sortable = TRUE; // Allow sort
		$this->IdKlsKerjasama->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['IdKlsKerjasama'] = &$this->IdKlsKerjasama;

		// IDBeasiswa
		$this->IDBeasiswa = new DbField('tblMHS', 'tblMHS', 'x_IDBeasiswa', 'IDBeasiswa', '[IDBeasiswa]', 'CAST([IDBeasiswa] AS NVARCHAR)', 3, 4, -1, FALSE, '[IDBeasiswa]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->IDBeasiswa->Sortable = TRUE; // Allow sort
		$this->IDBeasiswa->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['IDBeasiswa'] = &$this->IDBeasiswa;

		// tglKonversi
		$this->tglKonversi = new DbField('tblMHS', 'tblMHS', 'x_tglKonversi', 'tglKonversi', '[tglKonversi]', CastDateFieldForLike("[tglKonversi]", 0, "DB"), 135, 8, 0, FALSE, '[tglKonversi]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->tglKonversi->Sortable = TRUE; // Allow sort
		$this->tglKonversi->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['tglKonversi'] = &$this->tglKonversi;

		// NoSuratKonversi
		$this->NoSuratKonversi = new DbField('tblMHS', 'tblMHS', 'x_NoSuratKonversi', 'NoSuratKonversi', '[NoSuratKonversi]', '[NoSuratKonversi]', 200, 50, -1, FALSE, '[NoSuratKonversi]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->NoSuratKonversi->Sortable = TRUE; // Allow sort
		$this->fields['NoSuratKonversi'] = &$this->NoSuratKonversi;

		// Nopen
		$this->Nopen = new DbField('tblMHS', 'tblMHS', 'x_Nopen', 'Nopen', '[Nopen]', 'CAST([Nopen] AS NVARCHAR)', 3, 4, -1, FALSE, '[Nopen]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Nopen->Sortable = TRUE; // Allow sort
		$this->Nopen->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['Nopen'] = &$this->Nopen;

		// id_feedmhs
		$this->id_feedmhs = new DbField('tblMHS', 'tblMHS', 'x_id_feedmhs', 'id_feedmhs', '[id_feedmhs]', '[id_feedmhs]', 200, 40, -1, FALSE, '[id_feedmhs]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->id_feedmhs->Sortable = TRUE; // Allow sort
		$this->fields['id_feedmhs'] = &$this->id_feedmhs;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Single column sort
	public function updateSort(&$fld)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
		} else {
			$fld->setSort("");
		}
	}

	// Current detail table name
	public function getCurrentDetailTable()
	{
		return @$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_DETAIL_TABLE")];
	}
	public function setCurrentDetailTable($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_DETAIL_TABLE")] = $v;
	}

	// Get detail url
	public function getDetailUrl()
	{

		// Detail url
		$detailUrl = "";
		if ($this->getCurrentDetailTable() == "Wli_DNS") {
			$detailUrl = $GLOBALS["Wli_DNS"]->getListUrl() . "?" . Config("TABLE_SHOW_MASTER") . "=" . $this->TableVar;
			$detailUrl .= "&fk_Nim=" . urlencode($this->Nim->CurrentValue);
		}
		if ($this->getCurrentDetailTable() == "Wali_IPS") {
			$detailUrl = $GLOBALS["Wali_IPS"]->getListUrl() . "?" . Config("TABLE_SHOW_MASTER") . "=" . $this->TableVar;
			$detailUrl .= "&fk_Nim=" . urlencode($this->Nim->CurrentValue);
		}
		if ($detailUrl == "")
			$detailUrl = "tblMHSlist.php";
		return $detailUrl;
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom != "") ? $this->SqlFrom : "[dbo].[tblMHS]";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect != "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy != "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving != "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "[TaMasuk] DESC,[PerMasuk] ASC";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter, $id = "")
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = $this->UserIDAllowSecurity;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 32) == 32);
			case "search":
				return (($allow & 64) == 64);
			case "lookup":
				return (($allow & 256) == 256);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get recordset
	public function getRecordset($sql, $rowcnt = -1, $offset = -1)
	{
		$conn = $this->getConnection();
		$conn->raiseErrorFn = Config("ERROR_FUNC");
		$rs = $conn->selectLimit($sql, $rowcnt, $offset);
		$conn->raiseErrorFn = "";
		return $rs;
	}

	// Get record count
	public function getRecordCount($sql, $c = NULL)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) &&
			!preg_match('/^\s*select\s+distinct\s+/i', $sql) && !preg_match('/\s+order\s+by\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = $c ?: $this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->getSqlSelect();
		$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " (" . $names . ") VALUES (" . $values . ")";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = $this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsAutoIncrement)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter != "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = $this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('Nim', $rs))
				AddFilter($where, QuotedName('Nim', $this->Dbid) . '=' . QuotedValue($rs['Nim'], $this->Nim->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter != "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = $this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->Nim->DbValue = $row['Nim'];
		$this->Nama_Mhs->DbValue = $row['Nama_Mhs'];
		$this->Kode_jp->DbValue = $row['Kode_jp'];
		$this->Tmp_Lahir->DbValue = $row['Tmp_Lahir'];
		$this->Tgl_Lahir->DbValue = $row['Tgl_Lahir'];
		$this->Jenis_Kel->DbValue = $row['Jenis_Kel'];
		$this->Gol_darah->DbValue = $row['Gol_darah'];
		$this->Agama_Mhs->DbValue = $row['Agama_Mhs'];
		$this->Alamat_Mhs->DbValue = $row['Alamat_Mhs'];
		$this->rt->DbValue = $row['rt'];
		$this->rw->DbValue = $row['rw'];
		$this->Kelurahan->DbValue = $row['Kelurahan'];
		$this->Kecamatan->DbValue = $row['Kecamatan'];
		$this->Kota_Mhs->DbValue = $row['Kota_Mhs'];
		$this->Provinsi_mhs->DbValue = $row['Provinsi_mhs'];
		$this->Kodepos_Mhs->DbValue = $row['Kodepos_Mhs'];
		$this->Tlp_Mhs->DbValue = $row['Tlp_Mhs'];
		$this->TlpRumah->DbValue = $row['TlpRumah'];
		$this->_Email->DbValue = $row['Email'];
		$this->Status_Akd->DbValue = $row['Status_Akd'];
		$this->ThMasuk->DbValue = $row['ThMasuk'];
		$this->tglmasuk->DbValue = $row['tglmasuk'];
		$this->Status_Masuk->DbValue = $row['Status_Masuk'];
		$this->Sem_Masuk->DbValue = $row['Sem_Masuk'];
		$this->TaMasuk->DbValue = $row['TaMasuk'];
		$this->PerMasuk->DbValue = $row['PerMasuk'];
		$this->Pendidikan_Akhir->DbValue = $row['Pendidikan_Akhir'];
		$this->Jurusan->DbValue = $row['Jurusan'];
		$this->Thn_Selesai->DbValue = $row['Thn_Selesai'];
		$this->Kota_Pdkk->DbValue = $row['Kota_Pdkk'];
		$this->propinsi->DbValue = $row['propinsi'];
		$this->NIMASAL->DbValue = $row['NIMASAL'];
		$this->KPTSASAL->DbValue = $row['KPTSASAL'];
		$this->JENASAL->DbValue = $row['JENASAL'];
		$this->PSASAL->DbValue = $row['PSASAL'];
		$this->TSKSDIAKUI->DbValue = $row['TSKSDIAKUI'];
		$this->NamaSekolahAsal->DbValue = $row['NamaSekolahAsal'];
		$this->AlamatSekolahAsal->DbValue = $row['AlamatSekolahAsal'];
		$this->Status->DbValue = $row['Status'];
		$this->Photo->Upload->DbValue = $row['Photo'];
		$this->Password->DbValue = $row['Password'];
		$this->Gelombang->DbValue = $row['Gelombang'];
		$this->JalurMasuk->DbValue = $row['JalurMasuk'];
		$this->Konsentrasi->DbValue = $row['Konsentrasi'];
		$this->NIK->DbValue = $row['NIK'];
		$this->NamaIbu->DbValue = $row['NamaIbu'];
		$this->BekerjaDi->DbValue = $row['BekerjaDi'];
		$this->Lama->DbValue = $row['Lama'];
		$this->AlamatPerusahaan->DbValue = $row['AlamatPerusahaan'];
		$this->TlpPerusahaan->DbValue = $row['TlpPerusahaan'];
		$this->Posisi->DbValue = $row['Posisi'];
		$this->Departemen->DbValue = $row['Departemen'];
		$this->IdUser->DbValue = $row['IdUser'];
		$this->TempID->DbValue = $row['TempID'];
		$this->xphoto->DbValue = $row['xphoto'];
		$this->profile->DbValue = $row['profile'];
		$this->id_agama->DbValue = $row['id_agama'];
		$this->id_negara->DbValue = $row['id_negara'];
		$this->id_wilayah->DbValue = $row['id_wilayah'];
		$this->id_jenis_tinggal->DbValue = $row['id_jenis_tinggal'];
		$this->id_alat_transportasi->DbValue = $row['id_alat_transportasi'];
		$this->no_kps->DbValue = $row['no_kps'];
		$this->penerima_kps->DbValue = $row['penerima_kps'];
		$this->id_kebutuhan_khusus_mahasiswa->DbValue = $row['id_kebutuhan_khusus_mahasiswa'];
		$this->nisn->DbValue = $row['nisn'];
		$this->iddesa->DbValue = $row['iddesa'];
		$this->MulaiKerja->DbValue = $row['MulaiKerja'];
		$this->IdKlsKerjasama->DbValue = $row['IdKlsKerjasama'];
		$this->IDBeasiswa->DbValue = $row['IDBeasiswa'];
		$this->tglKonversi->DbValue = $row['tglKonversi'];
		$this->NoSuratKonversi->DbValue = $row['NoSuratKonversi'];
		$this->Nopen->DbValue = $row['Nopen'];
		$this->id_feedmhs->DbValue = $row['id_feedmhs'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "[Nim] = '@Nim@'";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		if (is_array($row))
			$val = array_key_exists('Nim', $row) ? $row['Nim'] : NULL;
		else
			$val = $this->Nim->OldValue !== NULL ? $this->Nim->OldValue : $this->Nim->CurrentValue;
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@Nim@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") != "" && ReferPageName() != CurrentPageName() && ReferPageName() != "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] != "") {
			return $_SESSION[$name];
		} else {
			return "tblMHSlist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "tblMHSview.php")
			return $Language->phrase("View");
		elseif ($pageName == "tblMHSedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "tblMHSadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "tblMHSlist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm != "")
			$url = $this->keyUrl("tblMHSview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("tblMHSview.php", $this->getUrlParm(Config("TABLE_SHOW_DETAIL") . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm != "")
			$url = "tblMHSadd.php?" . $this->getUrlParm($parm);
		else
			$url = "tblMHSadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		if ($parm != "")
			$url = $this->keyUrl("tblMHSedit.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("tblMHSedit.php", $this->getUrlParm(Config("TABLE_SHOW_DETAIL") . "="));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		if ($parm != "")
			$url = $this->keyUrl("tblMHSadd.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("tblMHSadd.php", $this->getUrlParm(Config("TABLE_SHOW_DETAIL") . "="));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("tblMHSdelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "Nim:" . JsonEncode($this->Nim->CurrentValue, "string");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm != "")
			$url .= $parm . "&";
		if ($this->Nim->CurrentValue != NULL) {
			$url .= "Nim=" . urlencode($this->Nim->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, [141, 201, 203, 128, 204, 205])) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		$arKeys = [];
		$arKey = [];
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("Nim") !== NULL)
				$arKeys[] = Param("Nim");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = [];
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys($setCurrent = TRUE)
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter != "") $keyFilter .= " OR ";
			if ($setCurrent)
				$this->Nim->CurrentValue = $key;
			else
				$this->Nim->OldValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = $this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->Nim->setDbValue($rs->fields('Nim'));
		$this->Nama_Mhs->setDbValue($rs->fields('Nama_Mhs'));
		$this->Kode_jp->setDbValue($rs->fields('Kode_jp'));
		$this->Tmp_Lahir->setDbValue($rs->fields('Tmp_Lahir'));
		$this->Tgl_Lahir->setDbValue($rs->fields('Tgl_Lahir'));
		$this->Jenis_Kel->setDbValue($rs->fields('Jenis_Kel'));
		$this->Gol_darah->setDbValue($rs->fields('Gol_darah'));
		$this->Agama_Mhs->setDbValue($rs->fields('Agama_Mhs'));
		$this->Alamat_Mhs->setDbValue($rs->fields('Alamat_Mhs'));
		$this->rt->setDbValue($rs->fields('rt'));
		$this->rw->setDbValue($rs->fields('rw'));
		$this->Kelurahan->setDbValue($rs->fields('Kelurahan'));
		$this->Kecamatan->setDbValue($rs->fields('Kecamatan'));
		$this->Kota_Mhs->setDbValue($rs->fields('Kota_Mhs'));
		$this->Provinsi_mhs->setDbValue($rs->fields('Provinsi_mhs'));
		$this->Kodepos_Mhs->setDbValue($rs->fields('Kodepos_Mhs'));
		$this->Tlp_Mhs->setDbValue($rs->fields('Tlp_Mhs'));
		$this->TlpRumah->setDbValue($rs->fields('TlpRumah'));
		$this->_Email->setDbValue($rs->fields('Email'));
		$this->Status_Akd->setDbValue($rs->fields('Status_Akd'));
		$this->ThMasuk->setDbValue($rs->fields('ThMasuk'));
		$this->tglmasuk->setDbValue($rs->fields('tglmasuk'));
		$this->Status_Masuk->setDbValue($rs->fields('Status_Masuk'));
		$this->Sem_Masuk->setDbValue($rs->fields('Sem_Masuk'));
		$this->TaMasuk->setDbValue($rs->fields('TaMasuk'));
		$this->PerMasuk->setDbValue($rs->fields('PerMasuk'));
		$this->Pendidikan_Akhir->setDbValue($rs->fields('Pendidikan_Akhir'));
		$this->Jurusan->setDbValue($rs->fields('Jurusan'));
		$this->Thn_Selesai->setDbValue($rs->fields('Thn_Selesai'));
		$this->Kota_Pdkk->setDbValue($rs->fields('Kota_Pdkk'));
		$this->propinsi->setDbValue($rs->fields('propinsi'));
		$this->NIMASAL->setDbValue($rs->fields('NIMASAL'));
		$this->KPTSASAL->setDbValue($rs->fields('KPTSASAL'));
		$this->JENASAL->setDbValue($rs->fields('JENASAL'));
		$this->PSASAL->setDbValue($rs->fields('PSASAL'));
		$this->TSKSDIAKUI->setDbValue($rs->fields('TSKSDIAKUI'));
		$this->NamaSekolahAsal->setDbValue($rs->fields('NamaSekolahAsal'));
		$this->AlamatSekolahAsal->setDbValue($rs->fields('AlamatSekolahAsal'));
		$this->Status->setDbValue($rs->fields('Status'));
		$this->Photo->Upload->DbValue = $rs->fields('Photo');
		$this->Password->setDbValue($rs->fields('Password'));
		$this->Gelombang->setDbValue($rs->fields('Gelombang'));
		$this->JalurMasuk->setDbValue($rs->fields('JalurMasuk'));
		$this->Konsentrasi->setDbValue($rs->fields('Konsentrasi'));
		$this->NIK->setDbValue($rs->fields('NIK'));
		$this->NamaIbu->setDbValue($rs->fields('NamaIbu'));
		$this->BekerjaDi->setDbValue($rs->fields('BekerjaDi'));
		$this->Lama->setDbValue($rs->fields('Lama'));
		$this->AlamatPerusahaan->setDbValue($rs->fields('AlamatPerusahaan'));
		$this->TlpPerusahaan->setDbValue($rs->fields('TlpPerusahaan'));
		$this->Posisi->setDbValue($rs->fields('Posisi'));
		$this->Departemen->setDbValue($rs->fields('Departemen'));
		$this->IdUser->setDbValue($rs->fields('IdUser'));
		$this->TempID->setDbValue($rs->fields('TempID'));
		$this->xphoto->setDbValue($rs->fields('xphoto'));
		$this->profile->setDbValue($rs->fields('profile'));
		$this->id_agama->setDbValue($rs->fields('id_agama'));
		$this->id_negara->setDbValue($rs->fields('id_negara'));
		$this->id_wilayah->setDbValue($rs->fields('id_wilayah'));
		$this->id_jenis_tinggal->setDbValue($rs->fields('id_jenis_tinggal'));
		$this->id_alat_transportasi->setDbValue($rs->fields('id_alat_transportasi'));
		$this->no_kps->setDbValue($rs->fields('no_kps'));
		$this->penerima_kps->setDbValue($rs->fields('penerima_kps'));
		$this->id_kebutuhan_khusus_mahasiswa->setDbValue($rs->fields('id_kebutuhan_khusus_mahasiswa'));
		$this->nisn->setDbValue($rs->fields('nisn'));
		$this->iddesa->setDbValue($rs->fields('iddesa'));
		$this->MulaiKerja->setDbValue($rs->fields('MulaiKerja'));
		$this->IdKlsKerjasama->setDbValue($rs->fields('IdKlsKerjasama'));
		$this->IDBeasiswa->setDbValue($rs->fields('IDBeasiswa'));
		$this->tglKonversi->setDbValue($rs->fields('tglKonversi'));
		$this->NoSuratKonversi->setDbValue($rs->fields('NoSuratKonversi'));
		$this->Nopen->setDbValue($rs->fields('Nopen'));
		$this->id_feedmhs->setDbValue($rs->fields('id_feedmhs'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// Nim
		// Nama_Mhs
		// Kode_jp
		// Tmp_Lahir
		// Tgl_Lahir
		// Jenis_Kel
		// Gol_darah
		// Agama_Mhs
		// Alamat_Mhs
		// rt
		// rw
		// Kelurahan
		// Kecamatan
		// Kota_Mhs
		// Provinsi_mhs
		// Kodepos_Mhs
		// Tlp_Mhs
		// TlpRumah
		// Email
		// Status_Akd
		// ThMasuk
		// tglmasuk
		// Status_Masuk
		// Sem_Masuk
		// TaMasuk
		// PerMasuk
		// Pendidikan_Akhir
		// Jurusan
		// Thn_Selesai
		// Kota_Pdkk
		// propinsi
		// NIMASAL
		// KPTSASAL
		// JENASAL
		// PSASAL
		// TSKSDIAKUI
		// NamaSekolahAsal
		// AlamatSekolahAsal
		// Status
		// Photo
		// Password
		// Gelombang
		// JalurMasuk
		// Konsentrasi
		// NIK
		// NamaIbu
		// BekerjaDi
		// Lama
		// AlamatPerusahaan
		// TlpPerusahaan
		// Posisi
		// Departemen
		// IdUser
		// TempID
		// xphoto
		// profile
		// id_agama
		// id_negara
		// id_wilayah
		// id_jenis_tinggal
		// id_alat_transportasi
		// no_kps
		// penerima_kps
		// id_kebutuhan_khusus_mahasiswa
		// nisn
		// iddesa
		// MulaiKerja
		// IdKlsKerjasama
		// IDBeasiswa
		// tglKonversi
		// NoSuratKonversi
		// Nopen
		// id_feedmhs
		// Nim

		$this->Nim->ViewValue = $this->Nim->CurrentValue;
		$this->Nim->ViewCustomAttributes = "";

		// Nama_Mhs
		$this->Nama_Mhs->ViewValue = $this->Nama_Mhs->CurrentValue;
		$this->Nama_Mhs->ViewCustomAttributes = "";

		// Kode_jp
		$curVal = strval($this->Kode_jp->CurrentValue);
		if ($curVal != "") {
			$this->Kode_jp->ViewValue = $this->Kode_jp->lookupCacheOption($curVal);
			if ($this->Kode_jp->ViewValue === NULL) { // Lookup from database
				$filterWrk = "[Kode_Jp]" . SearchString("=", $curVal, DATATYPE_STRING, "");
				$sqlWrk = $this->Kode_jp->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = [];
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$arwrk[3] = $rswrk->fields('df3');
					$this->Kode_jp->ViewValue = $this->Kode_jp->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->Kode_jp->ViewValue = $this->Kode_jp->CurrentValue;
				}
			}
		} else {
			$this->Kode_jp->ViewValue = NULL;
		}
		$this->Kode_jp->ViewCustomAttributes = "";

		// Tmp_Lahir
		$this->Tmp_Lahir->ViewValue = $this->Tmp_Lahir->CurrentValue;
		$this->Tmp_Lahir->ViewCustomAttributes = "";

		// Tgl_Lahir
		$this->Tgl_Lahir->ViewValue = $this->Tgl_Lahir->CurrentValue;
		$this->Tgl_Lahir->ViewValue = FormatDateTime($this->Tgl_Lahir->ViewValue, 0);
		$this->Tgl_Lahir->ViewCustomAttributes = "";

		// Jenis_Kel
		if (strval($this->Jenis_Kel->CurrentValue) != "") {
			$this->Jenis_Kel->ViewValue = $this->Jenis_Kel->optionCaption($this->Jenis_Kel->CurrentValue);
		} else {
			$this->Jenis_Kel->ViewValue = NULL;
		}
		$this->Jenis_Kel->ViewCustomAttributes = "";

		// Gol_darah
		$this->Gol_darah->ViewValue = $this->Gol_darah->CurrentValue;
		$this->Gol_darah->ViewCustomAttributes = "";

		// Agama_Mhs
		$this->Agama_Mhs->ViewValue = $this->Agama_Mhs->CurrentValue;
		$this->Agama_Mhs->ViewCustomAttributes = "";

		// Alamat_Mhs
		$this->Alamat_Mhs->ViewValue = $this->Alamat_Mhs->CurrentValue;
		$this->Alamat_Mhs->ViewCustomAttributes = "";

		// rt
		$this->rt->ViewValue = $this->rt->CurrentValue;
		$this->rt->ViewCustomAttributes = "";

		// rw
		$this->rw->ViewValue = $this->rw->CurrentValue;
		$this->rw->ViewCustomAttributes = "";

		// Kelurahan
		$this->Kelurahan->ViewValue = $this->Kelurahan->CurrentValue;
		$this->Kelurahan->ViewCustomAttributes = "";

		// Kecamatan
		$this->Kecamatan->ViewValue = $this->Kecamatan->CurrentValue;
		$this->Kecamatan->ViewCustomAttributes = "";

		// Kota_Mhs
		$this->Kota_Mhs->ViewValue = $this->Kota_Mhs->CurrentValue;
		$this->Kota_Mhs->ViewCustomAttributes = "";

		// Provinsi_mhs
		$this->Provinsi_mhs->ViewValue = $this->Provinsi_mhs->CurrentValue;
		$this->Provinsi_mhs->ViewCustomAttributes = "";

		// Kodepos_Mhs
		$this->Kodepos_Mhs->ViewValue = $this->Kodepos_Mhs->CurrentValue;
		$this->Kodepos_Mhs->ViewCustomAttributes = "";

		// Tlp_Mhs
		$this->Tlp_Mhs->ViewValue = $this->Tlp_Mhs->CurrentValue;
		$this->Tlp_Mhs->ViewCustomAttributes = "";

		// TlpRumah
		$this->TlpRumah->ViewValue = $this->TlpRumah->CurrentValue;
		$this->TlpRumah->ViewCustomAttributes = "";

		// Email
		$this->_Email->ViewValue = $this->_Email->CurrentValue;
		$this->_Email->ViewCustomAttributes = "";

		// Status_Akd
		$curVal = strval($this->Status_Akd->CurrentValue);
		if ($curVal != "") {
			$this->Status_Akd->ViewValue = $this->Status_Akd->lookupCacheOption($curVal);
			if ($this->Status_Akd->ViewValue === NULL) { // Lookup from database
				$filterWrk = "[Kelas]" . SearchString("=", $curVal, DATATYPE_STRING, "");
				$sqlWrk = $this->Status_Akd->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = [];
					$arwrk[1] = $rswrk->fields('df');
					$this->Status_Akd->ViewValue = $this->Status_Akd->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->Status_Akd->ViewValue = $this->Status_Akd->CurrentValue;
				}
			}
		} else {
			$this->Status_Akd->ViewValue = NULL;
		}
		$this->Status_Akd->ViewCustomAttributes = "";

		// ThMasuk
		$this->ThMasuk->ViewValue = $this->ThMasuk->CurrentValue;
		$this->ThMasuk->ViewCustomAttributes = "";

		// tglmasuk
		$this->tglmasuk->ViewValue = $this->tglmasuk->CurrentValue;
		$this->tglmasuk->ViewValue = FormatDateTime($this->tglmasuk->ViewValue, 7);
		$this->tglmasuk->ViewCustomAttributes = "";

		// Status_Masuk
		if (strval($this->Status_Masuk->CurrentValue) != "") {
			$this->Status_Masuk->ViewValue = $this->Status_Masuk->optionCaption($this->Status_Masuk->CurrentValue);
		} else {
			$this->Status_Masuk->ViewValue = NULL;
		}
		$this->Status_Masuk->ViewCustomAttributes = "";

		// Sem_Masuk
		$this->Sem_Masuk->ViewValue = $this->Sem_Masuk->CurrentValue;
		$this->Sem_Masuk->ViewCustomAttributes = "";

		// TaMasuk
		$curVal = strval($this->TaMasuk->CurrentValue);
		if ($curVal != "") {
			$this->TaMasuk->ViewValue = $this->TaMasuk->lookupCacheOption($curVal);
			if ($this->TaMasuk->ViewValue === NULL) { // Lookup from database
				$filterWrk = "[TA]" . SearchString("=", $curVal, DATATYPE_STRING, "");
				$sqlWrk = $this->TaMasuk->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = [];
					$arwrk[1] = $rswrk->fields('df');
					$this->TaMasuk->ViewValue = $this->TaMasuk->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->TaMasuk->ViewValue = $this->TaMasuk->CurrentValue;
				}
			}
		} else {
			$this->TaMasuk->ViewValue = NULL;
		}
		$this->TaMasuk->ViewCustomAttributes = "";

		// PerMasuk
		if (strval($this->PerMasuk->CurrentValue) != "") {
			$this->PerMasuk->ViewValue = $this->PerMasuk->optionCaption($this->PerMasuk->CurrentValue);
		} else {
			$this->PerMasuk->ViewValue = NULL;
		}
		$this->PerMasuk->ViewCustomAttributes = "";

		// Pendidikan_Akhir
		$this->Pendidikan_Akhir->ViewValue = $this->Pendidikan_Akhir->CurrentValue;
		$this->Pendidikan_Akhir->ViewCustomAttributes = "";

		// Jurusan
		$this->Jurusan->ViewValue = $this->Jurusan->CurrentValue;
		$this->Jurusan->ViewCustomAttributes = "";

		// Thn_Selesai
		$this->Thn_Selesai->ViewValue = $this->Thn_Selesai->CurrentValue;
		$this->Thn_Selesai->ViewCustomAttributes = "";

		// Kota_Pdkk
		$this->Kota_Pdkk->ViewValue = $this->Kota_Pdkk->CurrentValue;
		$this->Kota_Pdkk->ViewCustomAttributes = "";

		// propinsi
		$this->propinsi->ViewValue = $this->propinsi->CurrentValue;
		$this->propinsi->ViewCustomAttributes = "";

		// NIMASAL
		$this->NIMASAL->ViewValue = $this->NIMASAL->CurrentValue;
		$this->NIMASAL->ViewCustomAttributes = "";

		// KPTSASAL
		$this->KPTSASAL->ViewValue = $this->KPTSASAL->CurrentValue;
		$this->KPTSASAL->ViewCustomAttributes = "";

		// JENASAL
		$this->JENASAL->ViewValue = $this->JENASAL->CurrentValue;
		$this->JENASAL->ViewCustomAttributes = "";

		// PSASAL
		$this->PSASAL->ViewValue = $this->PSASAL->CurrentValue;
		$this->PSASAL->ViewCustomAttributes = "";

		// TSKSDIAKUI
		$this->TSKSDIAKUI->ViewValue = $this->TSKSDIAKUI->CurrentValue;
		$this->TSKSDIAKUI->ViewValue = FormatNumber($this->TSKSDIAKUI->ViewValue, 0, -2, -2, -2);
		$this->TSKSDIAKUI->ViewCustomAttributes = "";

		// NamaSekolahAsal
		$this->NamaSekolahAsal->ViewValue = $this->NamaSekolahAsal->CurrentValue;
		$this->NamaSekolahAsal->ViewCustomAttributes = "";

		// AlamatSekolahAsal
		$this->AlamatSekolahAsal->ViewValue = $this->AlamatSekolahAsal->CurrentValue;
		$this->AlamatSekolahAsal->ViewCustomAttributes = "";

		// Status
		if (strval($this->Status->CurrentValue) != "") {
			$this->Status->ViewValue = $this->Status->optionCaption($this->Status->CurrentValue);
		} else {
			$this->Status->ViewValue = NULL;
		}
		$this->Status->ViewCustomAttributes = "";

		// Photo
		if (!EmptyValue($this->Photo->Upload->DbValue)) {
			$this->Photo->ViewValue = $this->Nim->CurrentValue;
			$this->Photo->IsBlobImage = IsImageFile(ContentExtension($this->Photo->Upload->DbValue));
		} else {
			$this->Photo->ViewValue = "";
		}
		$this->Photo->ViewCustomAttributes = "";

		// Password
		$this->Password->ViewValue = $this->Password->CurrentValue;
		$this->Password->ViewCustomAttributes = "";

		// Gelombang
		$this->Gelombang->ViewValue = $this->Gelombang->CurrentValue;
		$this->Gelombang->ViewCustomAttributes = "";

		// JalurMasuk
		$this->JalurMasuk->ViewValue = $this->JalurMasuk->CurrentValue;
		$this->JalurMasuk->ViewCustomAttributes = "";

		// Konsentrasi
		$this->Konsentrasi->ViewValue = $this->Konsentrasi->CurrentValue;
		$this->Konsentrasi->ViewCustomAttributes = "";

		// NIK
		$this->NIK->ViewValue = $this->NIK->CurrentValue;
		$this->NIK->ViewCustomAttributes = "";

		// NamaIbu
		$this->NamaIbu->ViewValue = $this->NamaIbu->CurrentValue;
		$this->NamaIbu->ViewCustomAttributes = "";

		// BekerjaDi
		$this->BekerjaDi->ViewValue = $this->BekerjaDi->CurrentValue;
		$this->BekerjaDi->ViewCustomAttributes = "";

		// Lama
		$this->Lama->ViewValue = $this->Lama->CurrentValue;
		$this->Lama->ViewCustomAttributes = "";

		// AlamatPerusahaan
		$this->AlamatPerusahaan->ViewValue = $this->AlamatPerusahaan->CurrentValue;
		$this->AlamatPerusahaan->ViewCustomAttributes = "";

		// TlpPerusahaan
		$this->TlpPerusahaan->ViewValue = $this->TlpPerusahaan->CurrentValue;
		$this->TlpPerusahaan->ViewCustomAttributes = "";

		// Posisi
		$this->Posisi->ViewValue = $this->Posisi->CurrentValue;
		$this->Posisi->ViewCustomAttributes = "";

		// Departemen
		$this->Departemen->ViewValue = $this->Departemen->CurrentValue;
		$this->Departemen->ViewCustomAttributes = "";

		// IdUser
		$this->IdUser->ViewValue = $this->IdUser->CurrentValue;
		$this->IdUser->ViewCustomAttributes = "";

		// TempID
		$this->TempID->ViewValue = $this->TempID->CurrentValue;
		$this->TempID->ViewValue = FormatNumber($this->TempID->ViewValue, 0, -2, -2, -2);
		$this->TempID->ViewCustomAttributes = "";

		// xphoto
		$this->xphoto->ViewValue = $this->xphoto->CurrentValue;
		$this->xphoto->ViewCustomAttributes = "";

		// profile
		$this->profile->ViewValue = $this->profile->CurrentValue;
		$this->profile->ViewCustomAttributes = "";

		// id_agama
		$this->id_agama->ViewValue = $this->id_agama->CurrentValue;
		$this->id_agama->ViewValue = FormatNumber($this->id_agama->ViewValue, 0, -2, -2, -2);
		$this->id_agama->ViewCustomAttributes = "";

		// id_negara
		$this->id_negara->ViewValue = $this->id_negara->CurrentValue;
		$this->id_negara->ViewCustomAttributes = "";

		// id_wilayah
		$this->id_wilayah->ViewValue = $this->id_wilayah->CurrentValue;
		$this->id_wilayah->ViewCustomAttributes = "";

		// id_jenis_tinggal
		$this->id_jenis_tinggal->ViewValue = $this->id_jenis_tinggal->CurrentValue;
		$this->id_jenis_tinggal->ViewValue = FormatNumber($this->id_jenis_tinggal->ViewValue, 0, -2, -2, -2);
		$this->id_jenis_tinggal->ViewCustomAttributes = "";

		// id_alat_transportasi
		$this->id_alat_transportasi->ViewValue = $this->id_alat_transportasi->CurrentValue;
		$this->id_alat_transportasi->ViewValue = FormatNumber($this->id_alat_transportasi->ViewValue, 0, -2, -2, -2);
		$this->id_alat_transportasi->ViewCustomAttributes = "";

		// no_kps
		$this->no_kps->ViewValue = $this->no_kps->CurrentValue;
		$this->no_kps->ViewCustomAttributes = "";

		// penerima_kps
		$this->penerima_kps->ViewValue = $this->penerima_kps->CurrentValue;
		$this->penerima_kps->ViewValue = FormatNumber($this->penerima_kps->ViewValue, 0, -2, -2, -2);
		$this->penerima_kps->ViewCustomAttributes = "";

		// id_kebutuhan_khusus_mahasiswa
		$this->id_kebutuhan_khusus_mahasiswa->ViewValue = $this->id_kebutuhan_khusus_mahasiswa->CurrentValue;
		$this->id_kebutuhan_khusus_mahasiswa->ViewValue = FormatNumber($this->id_kebutuhan_khusus_mahasiswa->ViewValue, 0, -2, -2, -2);
		$this->id_kebutuhan_khusus_mahasiswa->ViewCustomAttributes = "";

		// nisn
		$this->nisn->ViewValue = $this->nisn->CurrentValue;
		$this->nisn->ViewCustomAttributes = "";

		// iddesa
		$this->iddesa->ViewValue = $this->iddesa->CurrentValue;
		$this->iddesa->ViewValue = FormatNumber($this->iddesa->ViewValue, 0, -2, -2, -2);
		$this->iddesa->ViewCustomAttributes = "";

		// MulaiKerja
		$this->MulaiKerja->ViewValue = $this->MulaiKerja->CurrentValue;
		$this->MulaiKerja->ViewValue = FormatDateTime($this->MulaiKerja->ViewValue, 0);
		$this->MulaiKerja->ViewCustomAttributes = "";

		// IdKlsKerjasama
		$this->IdKlsKerjasama->ViewValue = $this->IdKlsKerjasama->CurrentValue;
		$this->IdKlsKerjasama->ViewValue = FormatNumber($this->IdKlsKerjasama->ViewValue, 0, -2, -2, -2);
		$this->IdKlsKerjasama->ViewCustomAttributes = "";

		// IDBeasiswa
		$this->IDBeasiswa->ViewValue = $this->IDBeasiswa->CurrentValue;
		$this->IDBeasiswa->ViewValue = FormatNumber($this->IDBeasiswa->ViewValue, 0, -2, -2, -2);
		$this->IDBeasiswa->ViewCustomAttributes = "";

		// tglKonversi
		$this->tglKonversi->ViewValue = $this->tglKonversi->CurrentValue;
		$this->tglKonversi->ViewValue = FormatDateTime($this->tglKonversi->ViewValue, 0);
		$this->tglKonversi->ViewCustomAttributes = "";

		// NoSuratKonversi
		$this->NoSuratKonversi->ViewValue = $this->NoSuratKonversi->CurrentValue;
		$this->NoSuratKonversi->ViewCustomAttributes = "";

		// Nopen
		$this->Nopen->ViewValue = $this->Nopen->CurrentValue;
		$this->Nopen->ViewCustomAttributes = "";

		// id_feedmhs
		$this->id_feedmhs->ViewValue = $this->id_feedmhs->CurrentValue;
		$this->id_feedmhs->ViewCustomAttributes = "";

		// Nim
		$this->Nim->LinkCustomAttributes = "";
		$this->Nim->HrefValue = "";
		$this->Nim->TooltipValue = "";

		// Nama_Mhs
		$this->Nama_Mhs->LinkCustomAttributes = "";
		$this->Nama_Mhs->HrefValue = "";
		$this->Nama_Mhs->TooltipValue = "";

		// Kode_jp
		$this->Kode_jp->LinkCustomAttributes = "";
		$this->Kode_jp->HrefValue = "";
		$this->Kode_jp->TooltipValue = "";

		// Tmp_Lahir
		$this->Tmp_Lahir->LinkCustomAttributes = "";
		$this->Tmp_Lahir->HrefValue = "";
		$this->Tmp_Lahir->TooltipValue = "";

		// Tgl_Lahir
		$this->Tgl_Lahir->LinkCustomAttributes = "";
		$this->Tgl_Lahir->HrefValue = "";
		$this->Tgl_Lahir->TooltipValue = "";

		// Jenis_Kel
		$this->Jenis_Kel->LinkCustomAttributes = "";
		$this->Jenis_Kel->HrefValue = "";
		$this->Jenis_Kel->TooltipValue = "";

		// Gol_darah
		$this->Gol_darah->LinkCustomAttributes = "";
		$this->Gol_darah->HrefValue = "";
		$this->Gol_darah->TooltipValue = "";

		// Agama_Mhs
		$this->Agama_Mhs->LinkCustomAttributes = "";
		$this->Agama_Mhs->HrefValue = "";
		$this->Agama_Mhs->TooltipValue = "";

		// Alamat_Mhs
		$this->Alamat_Mhs->LinkCustomAttributes = "";
		$this->Alamat_Mhs->HrefValue = "";
		$this->Alamat_Mhs->TooltipValue = "";

		// rt
		$this->rt->LinkCustomAttributes = "";
		$this->rt->HrefValue = "";
		$this->rt->TooltipValue = "";

		// rw
		$this->rw->LinkCustomAttributes = "";
		$this->rw->HrefValue = "";
		$this->rw->TooltipValue = "";

		// Kelurahan
		$this->Kelurahan->LinkCustomAttributes = "";
		$this->Kelurahan->HrefValue = "";
		$this->Kelurahan->TooltipValue = "";

		// Kecamatan
		$this->Kecamatan->LinkCustomAttributes = "";
		$this->Kecamatan->HrefValue = "";
		$this->Kecamatan->TooltipValue = "";

		// Kota_Mhs
		$this->Kota_Mhs->LinkCustomAttributes = "";
		$this->Kota_Mhs->HrefValue = "";
		$this->Kota_Mhs->TooltipValue = "";

		// Provinsi_mhs
		$this->Provinsi_mhs->LinkCustomAttributes = "";
		$this->Provinsi_mhs->HrefValue = "";
		$this->Provinsi_mhs->TooltipValue = "";

		// Kodepos_Mhs
		$this->Kodepos_Mhs->LinkCustomAttributes = "";
		$this->Kodepos_Mhs->HrefValue = "";
		$this->Kodepos_Mhs->TooltipValue = "";

		// Tlp_Mhs
		$this->Tlp_Mhs->LinkCustomAttributes = "";
		if (!EmptyValue($this->Tlp_Mhs->CurrentValue)) {
			$this->Tlp_Mhs->HrefValue = "https://wa.me/62" . $this->Tlp_Mhs->CurrentValue; // Add prefix/suffix
			$this->Tlp_Mhs->LinkAttrs["target"] = "_blank"; // Add target
			if ($this->isExport())
				$this->Tlp_Mhs->HrefValue = FullUrl($this->Tlp_Mhs->HrefValue, "href");
		} else {
			$this->Tlp_Mhs->HrefValue = "";
		}
		$this->Tlp_Mhs->TooltipValue = "";

		// TlpRumah
		$this->TlpRumah->LinkCustomAttributes = "";
		$this->TlpRumah->HrefValue = "";
		$this->TlpRumah->TooltipValue = "";

		// Email
		$this->_Email->LinkCustomAttributes = "";
		if (!EmptyValue($this->_Email->CurrentValue)) {
			$this->_Email->HrefValue = "mailto:" . (!empty($this->_Email->ViewValue) && !is_array($this->_Email->ViewValue) ? RemoveHtml($this->_Email->ViewValue) : $this->_Email->CurrentValue); // Add prefix/suffix
			$this->_Email->LinkAttrs["target"] = "_blank"; // Add target
			if ($this->isExport())
				$this->_Email->HrefValue = FullUrl($this->_Email->HrefValue, "href");
		} else {
			$this->_Email->HrefValue = "";
		}
		$this->_Email->TooltipValue = "";

		// Status_Akd
		$this->Status_Akd->LinkCustomAttributes = "";
		$this->Status_Akd->HrefValue = "";
		$this->Status_Akd->TooltipValue = "";

		// ThMasuk
		$this->ThMasuk->LinkCustomAttributes = "";
		$this->ThMasuk->HrefValue = "";
		$this->ThMasuk->TooltipValue = "";

		// tglmasuk
		$this->tglmasuk->LinkCustomAttributes = "";
		$this->tglmasuk->HrefValue = "";
		$this->tglmasuk->TooltipValue = "";

		// Status_Masuk
		$this->Status_Masuk->LinkCustomAttributes = "";
		$this->Status_Masuk->HrefValue = "";
		$this->Status_Masuk->TooltipValue = "";

		// Sem_Masuk
		$this->Sem_Masuk->LinkCustomAttributes = "";
		$this->Sem_Masuk->HrefValue = "";
		$this->Sem_Masuk->TooltipValue = "";

		// TaMasuk
		$this->TaMasuk->LinkCustomAttributes = "";
		$this->TaMasuk->HrefValue = "";
		$this->TaMasuk->TooltipValue = "";

		// PerMasuk
		$this->PerMasuk->LinkCustomAttributes = "";
		$this->PerMasuk->HrefValue = "";
		$this->PerMasuk->TooltipValue = "";

		// Pendidikan_Akhir
		$this->Pendidikan_Akhir->LinkCustomAttributes = "";
		$this->Pendidikan_Akhir->HrefValue = "";
		$this->Pendidikan_Akhir->TooltipValue = "";

		// Jurusan
		$this->Jurusan->LinkCustomAttributes = "";
		$this->Jurusan->HrefValue = "";
		$this->Jurusan->TooltipValue = "";

		// Thn_Selesai
		$this->Thn_Selesai->LinkCustomAttributes = "";
		$this->Thn_Selesai->HrefValue = "";
		$this->Thn_Selesai->TooltipValue = "";

		// Kota_Pdkk
		$this->Kota_Pdkk->LinkCustomAttributes = "";
		$this->Kota_Pdkk->HrefValue = "";
		$this->Kota_Pdkk->TooltipValue = "";

		// propinsi
		$this->propinsi->LinkCustomAttributes = "";
		$this->propinsi->HrefValue = "";
		$this->propinsi->TooltipValue = "";

		// NIMASAL
		$this->NIMASAL->LinkCustomAttributes = "";
		$this->NIMASAL->HrefValue = "";
		$this->NIMASAL->TooltipValue = "";

		// KPTSASAL
		$this->KPTSASAL->LinkCustomAttributes = "";
		$this->KPTSASAL->HrefValue = "";
		$this->KPTSASAL->TooltipValue = "";

		// JENASAL
		$this->JENASAL->LinkCustomAttributes = "";
		$this->JENASAL->HrefValue = "";
		$this->JENASAL->TooltipValue = "";

		// PSASAL
		$this->PSASAL->LinkCustomAttributes = "";
		$this->PSASAL->HrefValue = "";
		$this->PSASAL->TooltipValue = "";

		// TSKSDIAKUI
		$this->TSKSDIAKUI->LinkCustomAttributes = "";
		$this->TSKSDIAKUI->HrefValue = "";
		$this->TSKSDIAKUI->TooltipValue = "";

		// NamaSekolahAsal
		$this->NamaSekolahAsal->LinkCustomAttributes = "";
		$this->NamaSekolahAsal->HrefValue = "";
		$this->NamaSekolahAsal->TooltipValue = "";

		// AlamatSekolahAsal
		$this->AlamatSekolahAsal->LinkCustomAttributes = "";
		$this->AlamatSekolahAsal->HrefValue = "";
		$this->AlamatSekolahAsal->TooltipValue = "";

		// Status
		$this->Status->LinkCustomAttributes = "";
		$this->Status->HrefValue = "";
		$this->Status->TooltipValue = "";

		// Photo
		$this->Photo->LinkCustomAttributes = "";
		if (!empty($this->Photo->Upload->DbValue)) {
			$this->Photo->HrefValue = GetFileUploadUrl($this->Photo, $this->Nim->CurrentValue);
			$this->Photo->LinkAttrs["target"] = "";
			if ($this->Photo->IsBlobImage && empty($this->Photo->LinkAttrs["target"]))
				$this->Photo->LinkAttrs["target"] = "_blank";
			if ($this->isExport())
				$this->Photo->HrefValue = FullUrl($this->Photo->HrefValue, "href");
		} else {
			$this->Photo->HrefValue = "";
		}
		$this->Photo->ExportHrefValue = GetFileUploadUrl($this->Photo, $this->Nim->CurrentValue);
		$this->Photo->TooltipValue = "";

		// Password
		$this->Password->LinkCustomAttributes = "";
		$this->Password->HrefValue = "";
		$this->Password->TooltipValue = "";

		// Gelombang
		$this->Gelombang->LinkCustomAttributes = "";
		$this->Gelombang->HrefValue = "";
		$this->Gelombang->TooltipValue = "";

		// JalurMasuk
		$this->JalurMasuk->LinkCustomAttributes = "";
		$this->JalurMasuk->HrefValue = "";
		$this->JalurMasuk->TooltipValue = "";

		// Konsentrasi
		$this->Konsentrasi->LinkCustomAttributes = "";
		$this->Konsentrasi->HrefValue = "";
		$this->Konsentrasi->TooltipValue = "";

		// NIK
		$this->NIK->LinkCustomAttributes = "";
		$this->NIK->HrefValue = "";
		$this->NIK->TooltipValue = "";

		// NamaIbu
		$this->NamaIbu->LinkCustomAttributes = "";
		$this->NamaIbu->HrefValue = "";
		$this->NamaIbu->TooltipValue = "";

		// BekerjaDi
		$this->BekerjaDi->LinkCustomAttributes = "";
		$this->BekerjaDi->HrefValue = "";
		$this->BekerjaDi->TooltipValue = "";

		// Lama
		$this->Lama->LinkCustomAttributes = "";
		$this->Lama->HrefValue = "";
		$this->Lama->TooltipValue = "";

		// AlamatPerusahaan
		$this->AlamatPerusahaan->LinkCustomAttributes = "";
		$this->AlamatPerusahaan->HrefValue = "";
		$this->AlamatPerusahaan->TooltipValue = "";

		// TlpPerusahaan
		$this->TlpPerusahaan->LinkCustomAttributes = "";
		$this->TlpPerusahaan->HrefValue = "";
		$this->TlpPerusahaan->TooltipValue = "";

		// Posisi
		$this->Posisi->LinkCustomAttributes = "";
		$this->Posisi->HrefValue = "";
		$this->Posisi->TooltipValue = "";

		// Departemen
		$this->Departemen->LinkCustomAttributes = "";
		$this->Departemen->HrefValue = "";
		$this->Departemen->TooltipValue = "";

		// IdUser
		$this->IdUser->LinkCustomAttributes = "";
		$this->IdUser->HrefValue = "";
		$this->IdUser->TooltipValue = "";

		// TempID
		$this->TempID->LinkCustomAttributes = "";
		$this->TempID->HrefValue = "";
		$this->TempID->TooltipValue = "";

		// xphoto
		$this->xphoto->LinkCustomAttributes = "";
		$this->xphoto->HrefValue = "";
		$this->xphoto->TooltipValue = "";

		// profile
		$this->profile->LinkCustomAttributes = "";
		$this->profile->HrefValue = "";
		$this->profile->TooltipValue = "";

		// id_agama
		$this->id_agama->LinkCustomAttributes = "";
		$this->id_agama->HrefValue = "";
		$this->id_agama->TooltipValue = "";

		// id_negara
		$this->id_negara->LinkCustomAttributes = "";
		$this->id_negara->HrefValue = "";
		$this->id_negara->TooltipValue = "";

		// id_wilayah
		$this->id_wilayah->LinkCustomAttributes = "";
		$this->id_wilayah->HrefValue = "";
		$this->id_wilayah->TooltipValue = "";

		// id_jenis_tinggal
		$this->id_jenis_tinggal->LinkCustomAttributes = "";
		$this->id_jenis_tinggal->HrefValue = "";
		$this->id_jenis_tinggal->TooltipValue = "";

		// id_alat_transportasi
		$this->id_alat_transportasi->LinkCustomAttributes = "";
		$this->id_alat_transportasi->HrefValue = "";
		$this->id_alat_transportasi->TooltipValue = "";

		// no_kps
		$this->no_kps->LinkCustomAttributes = "";
		$this->no_kps->HrefValue = "";
		$this->no_kps->TooltipValue = "";

		// penerima_kps
		$this->penerima_kps->LinkCustomAttributes = "";
		$this->penerima_kps->HrefValue = "";
		$this->penerima_kps->TooltipValue = "";

		// id_kebutuhan_khusus_mahasiswa
		$this->id_kebutuhan_khusus_mahasiswa->LinkCustomAttributes = "";
		$this->id_kebutuhan_khusus_mahasiswa->HrefValue = "";
		$this->id_kebutuhan_khusus_mahasiswa->TooltipValue = "";

		// nisn
		$this->nisn->LinkCustomAttributes = "";
		$this->nisn->HrefValue = "";
		$this->nisn->TooltipValue = "";

		// iddesa
		$this->iddesa->LinkCustomAttributes = "";
		$this->iddesa->HrefValue = "";
		$this->iddesa->TooltipValue = "";

		// MulaiKerja
		$this->MulaiKerja->LinkCustomAttributes = "";
		$this->MulaiKerja->HrefValue = "";
		$this->MulaiKerja->TooltipValue = "";

		// IdKlsKerjasama
		$this->IdKlsKerjasama->LinkCustomAttributes = "";
		$this->IdKlsKerjasama->HrefValue = "";
		$this->IdKlsKerjasama->TooltipValue = "";

		// IDBeasiswa
		$this->IDBeasiswa->LinkCustomAttributes = "";
		$this->IDBeasiswa->HrefValue = "";
		$this->IDBeasiswa->TooltipValue = "";

		// tglKonversi
		$this->tglKonversi->LinkCustomAttributes = "";
		$this->tglKonversi->HrefValue = "";
		$this->tglKonversi->TooltipValue = "";

		// NoSuratKonversi
		$this->NoSuratKonversi->LinkCustomAttributes = "";
		$this->NoSuratKonversi->HrefValue = "";
		$this->NoSuratKonversi->TooltipValue = "";

		// Nopen
		$this->Nopen->LinkCustomAttributes = "";
		$this->Nopen->HrefValue = "";
		$this->Nopen->TooltipValue = "";

		// id_feedmhs
		$this->id_feedmhs->LinkCustomAttributes = "";
		$this->id_feedmhs->HrefValue = "";
		$this->id_feedmhs->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Nim
		$this->Nim->EditAttrs["class"] = "form-control";
		$this->Nim->EditCustomAttributes = "";
		$this->Nim->EditValue = $this->Nim->CurrentValue;
		$this->Nim->ViewCustomAttributes = "";

		// Nama_Mhs
		$this->Nama_Mhs->EditAttrs["class"] = "form-control";
		$this->Nama_Mhs->EditCustomAttributes = "";
		if (!$this->Nama_Mhs->Raw)
			$this->Nama_Mhs->CurrentValue = HtmlDecode($this->Nama_Mhs->CurrentValue);
		$this->Nama_Mhs->EditValue = $this->Nama_Mhs->CurrentValue;
		$this->Nama_Mhs->PlaceHolder = RemoveHtml($this->Nama_Mhs->caption());

		// Kode_jp
		$this->Kode_jp->EditAttrs["class"] = "form-control";
		$this->Kode_jp->EditCustomAttributes = "";
		$curVal = strval($this->Kode_jp->CurrentValue);
		if ($curVal != "") {
			$this->Kode_jp->EditValue = $this->Kode_jp->lookupCacheOption($curVal);
			if ($this->Kode_jp->EditValue === NULL) { // Lookup from database
				$filterWrk = "[Kode_Jp]" . SearchString("=", $curVal, DATATYPE_STRING, "");
				$sqlWrk = $this->Kode_jp->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = [];
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$arwrk[3] = $rswrk->fields('df3');
					$this->Kode_jp->EditValue = $this->Kode_jp->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->Kode_jp->EditValue = $this->Kode_jp->CurrentValue;
				}
			}
		} else {
			$this->Kode_jp->EditValue = NULL;
		}
		$this->Kode_jp->ViewCustomAttributes = "";

		// Tmp_Lahir
		$this->Tmp_Lahir->EditAttrs["class"] = "form-control";
		$this->Tmp_Lahir->EditCustomAttributes = "";
		if (!$this->Tmp_Lahir->Raw)
			$this->Tmp_Lahir->CurrentValue = HtmlDecode($this->Tmp_Lahir->CurrentValue);
		$this->Tmp_Lahir->EditValue = $this->Tmp_Lahir->CurrentValue;
		$this->Tmp_Lahir->PlaceHolder = RemoveHtml($this->Tmp_Lahir->caption());

		// Tgl_Lahir
		$this->Tgl_Lahir->EditAttrs["class"] = "form-control";
		$this->Tgl_Lahir->EditCustomAttributes = "";
		$this->Tgl_Lahir->EditValue = FormatDateTime($this->Tgl_Lahir->CurrentValue, 8);
		$this->Tgl_Lahir->PlaceHolder = RemoveHtml($this->Tgl_Lahir->caption());

		// Jenis_Kel
		$this->Jenis_Kel->EditAttrs["class"] = "form-control";
		$this->Jenis_Kel->EditCustomAttributes = "";
		$this->Jenis_Kel->EditValue = $this->Jenis_Kel->options(TRUE);

		// Gol_darah
		$this->Gol_darah->EditAttrs["class"] = "form-control";
		$this->Gol_darah->EditCustomAttributes = "";
		if (!$this->Gol_darah->Raw)
			$this->Gol_darah->CurrentValue = HtmlDecode($this->Gol_darah->CurrentValue);
		$this->Gol_darah->EditValue = $this->Gol_darah->CurrentValue;
		$this->Gol_darah->PlaceHolder = RemoveHtml($this->Gol_darah->caption());

		// Agama_Mhs
		$this->Agama_Mhs->EditAttrs["class"] = "form-control";
		$this->Agama_Mhs->EditCustomAttributes = "";
		if (!$this->Agama_Mhs->Raw)
			$this->Agama_Mhs->CurrentValue = HtmlDecode($this->Agama_Mhs->CurrentValue);
		$this->Agama_Mhs->EditValue = $this->Agama_Mhs->CurrentValue;
		$this->Agama_Mhs->PlaceHolder = RemoveHtml($this->Agama_Mhs->caption());

		// Alamat_Mhs
		$this->Alamat_Mhs->EditAttrs["class"] = "form-control";
		$this->Alamat_Mhs->EditCustomAttributes = "";
		if (!$this->Alamat_Mhs->Raw)
			$this->Alamat_Mhs->CurrentValue = HtmlDecode($this->Alamat_Mhs->CurrentValue);
		$this->Alamat_Mhs->EditValue = $this->Alamat_Mhs->CurrentValue;
		$this->Alamat_Mhs->PlaceHolder = RemoveHtml($this->Alamat_Mhs->caption());

		// rt
		$this->rt->EditAttrs["class"] = "form-control";
		$this->rt->EditCustomAttributes = "";
		if (!$this->rt->Raw)
			$this->rt->CurrentValue = HtmlDecode($this->rt->CurrentValue);
		$this->rt->EditValue = $this->rt->CurrentValue;
		$this->rt->PlaceHolder = RemoveHtml($this->rt->caption());

		// rw
		$this->rw->EditAttrs["class"] = "form-control";
		$this->rw->EditCustomAttributes = "";
		if (!$this->rw->Raw)
			$this->rw->CurrentValue = HtmlDecode($this->rw->CurrentValue);
		$this->rw->EditValue = $this->rw->CurrentValue;
		$this->rw->PlaceHolder = RemoveHtml($this->rw->caption());

		// Kelurahan
		$this->Kelurahan->EditAttrs["class"] = "form-control";
		$this->Kelurahan->EditCustomAttributes = "";
		if (!$this->Kelurahan->Raw)
			$this->Kelurahan->CurrentValue = HtmlDecode($this->Kelurahan->CurrentValue);
		$this->Kelurahan->EditValue = $this->Kelurahan->CurrentValue;
		$this->Kelurahan->PlaceHolder = RemoveHtml($this->Kelurahan->caption());

		// Kecamatan
		$this->Kecamatan->EditAttrs["class"] = "form-control";
		$this->Kecamatan->EditCustomAttributes = "";
		if (!$this->Kecamatan->Raw)
			$this->Kecamatan->CurrentValue = HtmlDecode($this->Kecamatan->CurrentValue);
		$this->Kecamatan->EditValue = $this->Kecamatan->CurrentValue;
		$this->Kecamatan->PlaceHolder = RemoveHtml($this->Kecamatan->caption());

		// Kota_Mhs
		$this->Kota_Mhs->EditAttrs["class"] = "form-control";
		$this->Kota_Mhs->EditCustomAttributes = "";
		if (!$this->Kota_Mhs->Raw)
			$this->Kota_Mhs->CurrentValue = HtmlDecode($this->Kota_Mhs->CurrentValue);
		$this->Kota_Mhs->EditValue = $this->Kota_Mhs->CurrentValue;
		$this->Kota_Mhs->PlaceHolder = RemoveHtml($this->Kota_Mhs->caption());

		// Provinsi_mhs
		$this->Provinsi_mhs->EditAttrs["class"] = "form-control";
		$this->Provinsi_mhs->EditCustomAttributes = "";
		if (!$this->Provinsi_mhs->Raw)
			$this->Provinsi_mhs->CurrentValue = HtmlDecode($this->Provinsi_mhs->CurrentValue);
		$this->Provinsi_mhs->EditValue = $this->Provinsi_mhs->CurrentValue;
		$this->Provinsi_mhs->PlaceHolder = RemoveHtml($this->Provinsi_mhs->caption());

		// Kodepos_Mhs
		$this->Kodepos_Mhs->EditAttrs["class"] = "form-control";
		$this->Kodepos_Mhs->EditCustomAttributes = "";
		if (!$this->Kodepos_Mhs->Raw)
			$this->Kodepos_Mhs->CurrentValue = HtmlDecode($this->Kodepos_Mhs->CurrentValue);
		$this->Kodepos_Mhs->EditValue = $this->Kodepos_Mhs->CurrentValue;
		$this->Kodepos_Mhs->PlaceHolder = RemoveHtml($this->Kodepos_Mhs->caption());

		// Tlp_Mhs
		$this->Tlp_Mhs->EditAttrs["class"] = "form-control";
		$this->Tlp_Mhs->EditCustomAttributes = "";
		if (!$this->Tlp_Mhs->Raw)
			$this->Tlp_Mhs->CurrentValue = HtmlDecode($this->Tlp_Mhs->CurrentValue);
		$this->Tlp_Mhs->EditValue = $this->Tlp_Mhs->CurrentValue;
		$this->Tlp_Mhs->PlaceHolder = RemoveHtml($this->Tlp_Mhs->caption());

		// TlpRumah
		$this->TlpRumah->EditAttrs["class"] = "form-control";
		$this->TlpRumah->EditCustomAttributes = "";
		if (!$this->TlpRumah->Raw)
			$this->TlpRumah->CurrentValue = HtmlDecode($this->TlpRumah->CurrentValue);
		$this->TlpRumah->EditValue = $this->TlpRumah->CurrentValue;
		$this->TlpRumah->PlaceHolder = RemoveHtml($this->TlpRumah->caption());

		// Email
		$this->_Email->EditAttrs["class"] = "form-control";
		$this->_Email->EditCustomAttributes = "";
		if (!$this->_Email->Raw)
			$this->_Email->CurrentValue = HtmlDecode($this->_Email->CurrentValue);
		$this->_Email->EditValue = $this->_Email->CurrentValue;
		$this->_Email->PlaceHolder = RemoveHtml($this->_Email->caption());

		// Status_Akd
		$this->Status_Akd->EditAttrs["class"] = "form-control";
		$this->Status_Akd->EditCustomAttributes = "";

		// ThMasuk
		$this->ThMasuk->EditAttrs["class"] = "form-control";
		$this->ThMasuk->EditCustomAttributes = "";
		if (!$this->ThMasuk->Raw)
			$this->ThMasuk->CurrentValue = HtmlDecode($this->ThMasuk->CurrentValue);
		$this->ThMasuk->EditValue = $this->ThMasuk->CurrentValue;
		$this->ThMasuk->PlaceHolder = RemoveHtml($this->ThMasuk->caption());

		// tglmasuk
		$this->tglmasuk->EditAttrs["class"] = "form-control";
		$this->tglmasuk->EditCustomAttributes = "";
		$this->tglmasuk->EditValue = FormatDateTime($this->tglmasuk->CurrentValue, 7);
		$this->tglmasuk->PlaceHolder = RemoveHtml($this->tglmasuk->caption());

		// Status_Masuk
		$this->Status_Masuk->EditAttrs["class"] = "form-control";
		$this->Status_Masuk->EditCustomAttributes = "";
		$this->Status_Masuk->EditValue = $this->Status_Masuk->options(TRUE);

		// Sem_Masuk
		$this->Sem_Masuk->EditAttrs["class"] = "form-control";
		$this->Sem_Masuk->EditCustomAttributes = "";
		if (!$this->Sem_Masuk->Raw)
			$this->Sem_Masuk->CurrentValue = HtmlDecode($this->Sem_Masuk->CurrentValue);
		$this->Sem_Masuk->EditValue = $this->Sem_Masuk->CurrentValue;
		$this->Sem_Masuk->PlaceHolder = RemoveHtml($this->Sem_Masuk->caption());

		// TaMasuk
		$this->TaMasuk->EditAttrs["class"] = "form-control";
		$this->TaMasuk->EditCustomAttributes = "";

		// PerMasuk
		$this->PerMasuk->EditAttrs["class"] = "form-control";
		$this->PerMasuk->EditCustomAttributes = "";
		$this->PerMasuk->EditValue = $this->PerMasuk->options(TRUE);

		// Pendidikan_Akhir
		$this->Pendidikan_Akhir->EditAttrs["class"] = "form-control";
		$this->Pendidikan_Akhir->EditCustomAttributes = "";
		if (!$this->Pendidikan_Akhir->Raw)
			$this->Pendidikan_Akhir->CurrentValue = HtmlDecode($this->Pendidikan_Akhir->CurrentValue);
		$this->Pendidikan_Akhir->EditValue = $this->Pendidikan_Akhir->CurrentValue;
		$this->Pendidikan_Akhir->PlaceHolder = RemoveHtml($this->Pendidikan_Akhir->caption());

		// Jurusan
		$this->Jurusan->EditAttrs["class"] = "form-control";
		$this->Jurusan->EditCustomAttributes = "";
		if (!$this->Jurusan->Raw)
			$this->Jurusan->CurrentValue = HtmlDecode($this->Jurusan->CurrentValue);
		$this->Jurusan->EditValue = $this->Jurusan->CurrentValue;
		$this->Jurusan->PlaceHolder = RemoveHtml($this->Jurusan->caption());

		// Thn_Selesai
		$this->Thn_Selesai->EditAttrs["class"] = "form-control";
		$this->Thn_Selesai->EditCustomAttributes = "";
		if (!$this->Thn_Selesai->Raw)
			$this->Thn_Selesai->CurrentValue = HtmlDecode($this->Thn_Selesai->CurrentValue);
		$this->Thn_Selesai->EditValue = $this->Thn_Selesai->CurrentValue;
		$this->Thn_Selesai->PlaceHolder = RemoveHtml($this->Thn_Selesai->caption());

		// Kota_Pdkk
		$this->Kota_Pdkk->EditAttrs["class"] = "form-control";
		$this->Kota_Pdkk->EditCustomAttributes = "";
		if (!$this->Kota_Pdkk->Raw)
			$this->Kota_Pdkk->CurrentValue = HtmlDecode($this->Kota_Pdkk->CurrentValue);
		$this->Kota_Pdkk->EditValue = $this->Kota_Pdkk->CurrentValue;
		$this->Kota_Pdkk->PlaceHolder = RemoveHtml($this->Kota_Pdkk->caption());

		// propinsi
		$this->propinsi->EditAttrs["class"] = "form-control";
		$this->propinsi->EditCustomAttributes = "";
		if (!$this->propinsi->Raw)
			$this->propinsi->CurrentValue = HtmlDecode($this->propinsi->CurrentValue);
		$this->propinsi->EditValue = $this->propinsi->CurrentValue;
		$this->propinsi->PlaceHolder = RemoveHtml($this->propinsi->caption());

		// NIMASAL
		$this->NIMASAL->EditAttrs["class"] = "form-control";
		$this->NIMASAL->EditCustomAttributes = "";
		if (!$this->NIMASAL->Raw)
			$this->NIMASAL->CurrentValue = HtmlDecode($this->NIMASAL->CurrentValue);
		$this->NIMASAL->EditValue = $this->NIMASAL->CurrentValue;
		$this->NIMASAL->PlaceHolder = RemoveHtml($this->NIMASAL->caption());

		// KPTSASAL
		$this->KPTSASAL->EditAttrs["class"] = "form-control";
		$this->KPTSASAL->EditCustomAttributes = "";
		if (!$this->KPTSASAL->Raw)
			$this->KPTSASAL->CurrentValue = HtmlDecode($this->KPTSASAL->CurrentValue);
		$this->KPTSASAL->EditValue = $this->KPTSASAL->CurrentValue;
		$this->KPTSASAL->PlaceHolder = RemoveHtml($this->KPTSASAL->caption());

		// JENASAL
		$this->JENASAL->EditAttrs["class"] = "form-control";
		$this->JENASAL->EditCustomAttributes = "";
		if (!$this->JENASAL->Raw)
			$this->JENASAL->CurrentValue = HtmlDecode($this->JENASAL->CurrentValue);
		$this->JENASAL->EditValue = $this->JENASAL->CurrentValue;
		$this->JENASAL->PlaceHolder = RemoveHtml($this->JENASAL->caption());

		// PSASAL
		$this->PSASAL->EditAttrs["class"] = "form-control";
		$this->PSASAL->EditCustomAttributes = "";
		if (!$this->PSASAL->Raw)
			$this->PSASAL->CurrentValue = HtmlDecode($this->PSASAL->CurrentValue);
		$this->PSASAL->EditValue = $this->PSASAL->CurrentValue;
		$this->PSASAL->PlaceHolder = RemoveHtml($this->PSASAL->caption());

		// TSKSDIAKUI
		$this->TSKSDIAKUI->EditAttrs["class"] = "form-control";
		$this->TSKSDIAKUI->EditCustomAttributes = "";
		$this->TSKSDIAKUI->EditValue = $this->TSKSDIAKUI->CurrentValue;
		$this->TSKSDIAKUI->PlaceHolder = RemoveHtml($this->TSKSDIAKUI->caption());

		// NamaSekolahAsal
		$this->NamaSekolahAsal->EditAttrs["class"] = "form-control";
		$this->NamaSekolahAsal->EditCustomAttributes = "";
		if (!$this->NamaSekolahAsal->Raw)
			$this->NamaSekolahAsal->CurrentValue = HtmlDecode($this->NamaSekolahAsal->CurrentValue);
		$this->NamaSekolahAsal->EditValue = $this->NamaSekolahAsal->CurrentValue;
		$this->NamaSekolahAsal->PlaceHolder = RemoveHtml($this->NamaSekolahAsal->caption());

		// AlamatSekolahAsal
		$this->AlamatSekolahAsal->EditAttrs["class"] = "form-control";
		$this->AlamatSekolahAsal->EditCustomAttributes = "";
		if (!$this->AlamatSekolahAsal->Raw)
			$this->AlamatSekolahAsal->CurrentValue = HtmlDecode($this->AlamatSekolahAsal->CurrentValue);
		$this->AlamatSekolahAsal->EditValue = $this->AlamatSekolahAsal->CurrentValue;
		$this->AlamatSekolahAsal->PlaceHolder = RemoveHtml($this->AlamatSekolahAsal->caption());

		// Status
		$this->Status->EditAttrs["class"] = "form-control";
		$this->Status->EditCustomAttributes = "";
		$this->Status->EditValue = $this->Status->options(TRUE);

		// Photo
		$this->Photo->EditAttrs["class"] = "form-control";
		$this->Photo->EditCustomAttributes = "";
		if (!EmptyValue($this->Photo->Upload->DbValue)) {
			$this->Photo->EditValue = $this->Nim->CurrentValue;
			$this->Photo->IsBlobImage = IsImageFile(ContentExtension($this->Photo->Upload->DbValue));
		} else {
			$this->Photo->EditValue = "";
		}

		// Password
		$this->Password->EditAttrs["class"] = "form-control";
		$this->Password->EditCustomAttributes = "";
		if (!$this->Password->Raw)
			$this->Password->CurrentValue = HtmlDecode($this->Password->CurrentValue);
		$this->Password->EditValue = $this->Password->CurrentValue;
		$this->Password->PlaceHolder = RemoveHtml($this->Password->caption());

		// Gelombang
		$this->Gelombang->EditAttrs["class"] = "form-control";
		$this->Gelombang->EditCustomAttributes = "";
		if (!$this->Gelombang->Raw)
			$this->Gelombang->CurrentValue = HtmlDecode($this->Gelombang->CurrentValue);
		$this->Gelombang->EditValue = $this->Gelombang->CurrentValue;
		$this->Gelombang->PlaceHolder = RemoveHtml($this->Gelombang->caption());

		// JalurMasuk
		$this->JalurMasuk->EditAttrs["class"] = "form-control";
		$this->JalurMasuk->EditCustomAttributes = "";
		if (!$this->JalurMasuk->Raw)
			$this->JalurMasuk->CurrentValue = HtmlDecode($this->JalurMasuk->CurrentValue);
		$this->JalurMasuk->EditValue = $this->JalurMasuk->CurrentValue;
		$this->JalurMasuk->PlaceHolder = RemoveHtml($this->JalurMasuk->caption());

		// Konsentrasi
		$this->Konsentrasi->EditAttrs["class"] = "form-control";
		$this->Konsentrasi->EditCustomAttributes = "";
		if (!$this->Konsentrasi->Raw)
			$this->Konsentrasi->CurrentValue = HtmlDecode($this->Konsentrasi->CurrentValue);
		$this->Konsentrasi->EditValue = $this->Konsentrasi->CurrentValue;
		$this->Konsentrasi->PlaceHolder = RemoveHtml($this->Konsentrasi->caption());

		// NIK
		$this->NIK->EditAttrs["class"] = "form-control";
		$this->NIK->EditCustomAttributes = "";
		if (!$this->NIK->Raw)
			$this->NIK->CurrentValue = HtmlDecode($this->NIK->CurrentValue);
		$this->NIK->EditValue = $this->NIK->CurrentValue;
		$this->NIK->PlaceHolder = RemoveHtml($this->NIK->caption());

		// NamaIbu
		$this->NamaIbu->EditAttrs["class"] = "form-control";
		$this->NamaIbu->EditCustomAttributes = "";
		if (!$this->NamaIbu->Raw)
			$this->NamaIbu->CurrentValue = HtmlDecode($this->NamaIbu->CurrentValue);
		$this->NamaIbu->EditValue = $this->NamaIbu->CurrentValue;
		$this->NamaIbu->PlaceHolder = RemoveHtml($this->NamaIbu->caption());

		// BekerjaDi
		$this->BekerjaDi->EditAttrs["class"] = "form-control";
		$this->BekerjaDi->EditCustomAttributes = "";
		if (!$this->BekerjaDi->Raw)
			$this->BekerjaDi->CurrentValue = HtmlDecode($this->BekerjaDi->CurrentValue);
		$this->BekerjaDi->EditValue = $this->BekerjaDi->CurrentValue;
		$this->BekerjaDi->PlaceHolder = RemoveHtml($this->BekerjaDi->caption());

		// Lama
		$this->Lama->EditAttrs["class"] = "form-control";
		$this->Lama->EditCustomAttributes = "";
		if (!$this->Lama->Raw)
			$this->Lama->CurrentValue = HtmlDecode($this->Lama->CurrentValue);
		$this->Lama->EditValue = $this->Lama->CurrentValue;
		$this->Lama->PlaceHolder = RemoveHtml($this->Lama->caption());

		// AlamatPerusahaan
		$this->AlamatPerusahaan->EditAttrs["class"] = "form-control";
		$this->AlamatPerusahaan->EditCustomAttributes = "";
		if (!$this->AlamatPerusahaan->Raw)
			$this->AlamatPerusahaan->CurrentValue = HtmlDecode($this->AlamatPerusahaan->CurrentValue);
		$this->AlamatPerusahaan->EditValue = $this->AlamatPerusahaan->CurrentValue;
		$this->AlamatPerusahaan->PlaceHolder = RemoveHtml($this->AlamatPerusahaan->caption());

		// TlpPerusahaan
		$this->TlpPerusahaan->EditAttrs["class"] = "form-control";
		$this->TlpPerusahaan->EditCustomAttributes = "";
		if (!$this->TlpPerusahaan->Raw)
			$this->TlpPerusahaan->CurrentValue = HtmlDecode($this->TlpPerusahaan->CurrentValue);
		$this->TlpPerusahaan->EditValue = $this->TlpPerusahaan->CurrentValue;
		$this->TlpPerusahaan->PlaceHolder = RemoveHtml($this->TlpPerusahaan->caption());

		// Posisi
		$this->Posisi->EditAttrs["class"] = "form-control";
		$this->Posisi->EditCustomAttributes = "";
		if (!$this->Posisi->Raw)
			$this->Posisi->CurrentValue = HtmlDecode($this->Posisi->CurrentValue);
		$this->Posisi->EditValue = $this->Posisi->CurrentValue;
		$this->Posisi->PlaceHolder = RemoveHtml($this->Posisi->caption());

		// Departemen
		$this->Departemen->EditAttrs["class"] = "form-control";
		$this->Departemen->EditCustomAttributes = "";
		if (!$this->Departemen->Raw)
			$this->Departemen->CurrentValue = HtmlDecode($this->Departemen->CurrentValue);
		$this->Departemen->EditValue = $this->Departemen->CurrentValue;
		$this->Departemen->PlaceHolder = RemoveHtml($this->Departemen->caption());

		// IdUser
		$this->IdUser->EditAttrs["class"] = "form-control";
		$this->IdUser->EditCustomAttributes = "";
		if (!$this->IdUser->Raw)
			$this->IdUser->CurrentValue = HtmlDecode($this->IdUser->CurrentValue);
		$this->IdUser->EditValue = $this->IdUser->CurrentValue;
		$this->IdUser->PlaceHolder = RemoveHtml($this->IdUser->caption());

		// TempID
		$this->TempID->EditAttrs["class"] = "form-control";
		$this->TempID->EditCustomAttributes = "";
		$this->TempID->EditValue = $this->TempID->CurrentValue;
		$this->TempID->PlaceHolder = RemoveHtml($this->TempID->caption());

		// xphoto
		$this->xphoto->EditAttrs["class"] = "form-control";
		$this->xphoto->EditCustomAttributes = "";
		if (!$this->xphoto->Raw)
			$this->xphoto->CurrentValue = HtmlDecode($this->xphoto->CurrentValue);
		$this->xphoto->EditValue = $this->xphoto->CurrentValue;
		$this->xphoto->PlaceHolder = RemoveHtml($this->xphoto->caption());

		// profile
		$this->profile->EditAttrs["class"] = "form-control";
		$this->profile->EditCustomAttributes = "";
		if (!$this->profile->Raw)
			$this->profile->CurrentValue = HtmlDecode($this->profile->CurrentValue);
		$this->profile->EditValue = $this->profile->CurrentValue;
		$this->profile->PlaceHolder = RemoveHtml($this->profile->caption());

		// id_agama
		$this->id_agama->EditAttrs["class"] = "form-control";
		$this->id_agama->EditCustomAttributes = "";
		$this->id_agama->EditValue = $this->id_agama->CurrentValue;
		$this->id_agama->PlaceHolder = RemoveHtml($this->id_agama->caption());

		// id_negara
		$this->id_negara->EditAttrs["class"] = "form-control";
		$this->id_negara->EditCustomAttributes = "";
		if (!$this->id_negara->Raw)
			$this->id_negara->CurrentValue = HtmlDecode($this->id_negara->CurrentValue);
		$this->id_negara->EditValue = $this->id_negara->CurrentValue;
		$this->id_negara->PlaceHolder = RemoveHtml($this->id_negara->caption());

		// id_wilayah
		$this->id_wilayah->EditAttrs["class"] = "form-control";
		$this->id_wilayah->EditCustomAttributes = "";
		if (!$this->id_wilayah->Raw)
			$this->id_wilayah->CurrentValue = HtmlDecode($this->id_wilayah->CurrentValue);
		$this->id_wilayah->EditValue = $this->id_wilayah->CurrentValue;
		$this->id_wilayah->PlaceHolder = RemoveHtml($this->id_wilayah->caption());

		// id_jenis_tinggal
		$this->id_jenis_tinggal->EditAttrs["class"] = "form-control";
		$this->id_jenis_tinggal->EditCustomAttributes = "";
		$this->id_jenis_tinggal->EditValue = $this->id_jenis_tinggal->CurrentValue;
		$this->id_jenis_tinggal->PlaceHolder = RemoveHtml($this->id_jenis_tinggal->caption());

		// id_alat_transportasi
		$this->id_alat_transportasi->EditAttrs["class"] = "form-control";
		$this->id_alat_transportasi->EditCustomAttributes = "";
		$this->id_alat_transportasi->EditValue = $this->id_alat_transportasi->CurrentValue;
		$this->id_alat_transportasi->PlaceHolder = RemoveHtml($this->id_alat_transportasi->caption());

		// no_kps
		$this->no_kps->EditAttrs["class"] = "form-control";
		$this->no_kps->EditCustomAttributes = "";
		if (!$this->no_kps->Raw)
			$this->no_kps->CurrentValue = HtmlDecode($this->no_kps->CurrentValue);
		$this->no_kps->EditValue = $this->no_kps->CurrentValue;
		$this->no_kps->PlaceHolder = RemoveHtml($this->no_kps->caption());

		// penerima_kps
		$this->penerima_kps->EditAttrs["class"] = "form-control";
		$this->penerima_kps->EditCustomAttributes = "";
		$this->penerima_kps->EditValue = $this->penerima_kps->CurrentValue;
		$this->penerima_kps->PlaceHolder = RemoveHtml($this->penerima_kps->caption());

		// id_kebutuhan_khusus_mahasiswa
		$this->id_kebutuhan_khusus_mahasiswa->EditAttrs["class"] = "form-control";
		$this->id_kebutuhan_khusus_mahasiswa->EditCustomAttributes = "";
		$this->id_kebutuhan_khusus_mahasiswa->EditValue = $this->id_kebutuhan_khusus_mahasiswa->CurrentValue;
		$this->id_kebutuhan_khusus_mahasiswa->PlaceHolder = RemoveHtml($this->id_kebutuhan_khusus_mahasiswa->caption());

		// nisn
		$this->nisn->EditAttrs["class"] = "form-control";
		$this->nisn->EditCustomAttributes = "";
		if (!$this->nisn->Raw)
			$this->nisn->CurrentValue = HtmlDecode($this->nisn->CurrentValue);
		$this->nisn->EditValue = $this->nisn->CurrentValue;
		$this->nisn->PlaceHolder = RemoveHtml($this->nisn->caption());

		// iddesa
		$this->iddesa->EditAttrs["class"] = "form-control";
		$this->iddesa->EditCustomAttributes = "";
		$this->iddesa->EditValue = $this->iddesa->CurrentValue;
		$this->iddesa->PlaceHolder = RemoveHtml($this->iddesa->caption());

		// MulaiKerja
		$this->MulaiKerja->EditAttrs["class"] = "form-control";
		$this->MulaiKerja->EditCustomAttributes = "";
		$this->MulaiKerja->EditValue = FormatDateTime($this->MulaiKerja->CurrentValue, 8);
		$this->MulaiKerja->PlaceHolder = RemoveHtml($this->MulaiKerja->caption());

		// IdKlsKerjasama
		$this->IdKlsKerjasama->EditAttrs["class"] = "form-control";
		$this->IdKlsKerjasama->EditCustomAttributes = "";
		$this->IdKlsKerjasama->EditValue = $this->IdKlsKerjasama->CurrentValue;
		$this->IdKlsKerjasama->PlaceHolder = RemoveHtml($this->IdKlsKerjasama->caption());

		// IDBeasiswa
		$this->IDBeasiswa->EditAttrs["class"] = "form-control";
		$this->IDBeasiswa->EditCustomAttributes = "";
		$this->IDBeasiswa->EditValue = $this->IDBeasiswa->CurrentValue;
		$this->IDBeasiswa->PlaceHolder = RemoveHtml($this->IDBeasiswa->caption());

		// tglKonversi
		$this->tglKonversi->EditAttrs["class"] = "form-control";
		$this->tglKonversi->EditCustomAttributes = "";
		$this->tglKonversi->EditValue = FormatDateTime($this->tglKonversi->CurrentValue, 8);
		$this->tglKonversi->PlaceHolder = RemoveHtml($this->tglKonversi->caption());

		// NoSuratKonversi
		$this->NoSuratKonversi->EditAttrs["class"] = "form-control";
		$this->NoSuratKonversi->EditCustomAttributes = "";
		if (!$this->NoSuratKonversi->Raw)
			$this->NoSuratKonversi->CurrentValue = HtmlDecode($this->NoSuratKonversi->CurrentValue);
		$this->NoSuratKonversi->EditValue = $this->NoSuratKonversi->CurrentValue;
		$this->NoSuratKonversi->PlaceHolder = RemoveHtml($this->NoSuratKonversi->caption());

		// Nopen
		$this->Nopen->EditAttrs["class"] = "form-control";
		$this->Nopen->EditCustomAttributes = "";
		$this->Nopen->EditValue = $this->Nopen->CurrentValue;
		$this->Nopen->PlaceHolder = RemoveHtml($this->Nopen->caption());

		// id_feedmhs
		$this->id_feedmhs->EditAttrs["class"] = "form-control";
		$this->id_feedmhs->EditCustomAttributes = "";
		if (!$this->id_feedmhs->Raw)
			$this->id_feedmhs->CurrentValue = HtmlDecode($this->id_feedmhs->CurrentValue);
		$this->id_feedmhs->EditValue = $this->id_feedmhs->CurrentValue;
		$this->id_feedmhs->PlaceHolder = RemoveHtml($this->id_feedmhs->caption());

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->Nim);
					$doc->exportCaption($this->Nama_Mhs);
					$doc->exportCaption($this->Kode_jp);
					$doc->exportCaption($this->Tmp_Lahir);
					$doc->exportCaption($this->Tgl_Lahir);
					$doc->exportCaption($this->Jenis_Kel);
					$doc->exportCaption($this->Gol_darah);
					$doc->exportCaption($this->Agama_Mhs);
					$doc->exportCaption($this->Alamat_Mhs);
					$doc->exportCaption($this->rt);
					$doc->exportCaption($this->rw);
					$doc->exportCaption($this->Kelurahan);
					$doc->exportCaption($this->Kecamatan);
					$doc->exportCaption($this->Kota_Mhs);
					$doc->exportCaption($this->Provinsi_mhs);
					$doc->exportCaption($this->Kodepos_Mhs);
					$doc->exportCaption($this->Tlp_Mhs);
					$doc->exportCaption($this->TlpRumah);
					$doc->exportCaption($this->_Email);
					$doc->exportCaption($this->Status_Akd);
					$doc->exportCaption($this->ThMasuk);
					$doc->exportCaption($this->tglmasuk);
					$doc->exportCaption($this->Status_Masuk);
					$doc->exportCaption($this->Sem_Masuk);
					$doc->exportCaption($this->TaMasuk);
					$doc->exportCaption($this->PerMasuk);
					$doc->exportCaption($this->Pendidikan_Akhir);
					$doc->exportCaption($this->Jurusan);
					$doc->exportCaption($this->Thn_Selesai);
					$doc->exportCaption($this->Kota_Pdkk);
					$doc->exportCaption($this->propinsi);
					$doc->exportCaption($this->NIMASAL);
					$doc->exportCaption($this->KPTSASAL);
					$doc->exportCaption($this->JENASAL);
					$doc->exportCaption($this->PSASAL);
					$doc->exportCaption($this->TSKSDIAKUI);
					$doc->exportCaption($this->NamaSekolahAsal);
					$doc->exportCaption($this->AlamatSekolahAsal);
					$doc->exportCaption($this->Status);
					$doc->exportCaption($this->Photo);
					$doc->exportCaption($this->Password);
					$doc->exportCaption($this->Gelombang);
					$doc->exportCaption($this->JalurMasuk);
					$doc->exportCaption($this->Konsentrasi);
					$doc->exportCaption($this->NIK);
					$doc->exportCaption($this->NamaIbu);
					$doc->exportCaption($this->BekerjaDi);
					$doc->exportCaption($this->Lama);
					$doc->exportCaption($this->AlamatPerusahaan);
					$doc->exportCaption($this->TlpPerusahaan);
					$doc->exportCaption($this->Posisi);
					$doc->exportCaption($this->Departemen);
					$doc->exportCaption($this->IdUser);
					$doc->exportCaption($this->TempID);
					$doc->exportCaption($this->xphoto);
					$doc->exportCaption($this->profile);
					$doc->exportCaption($this->id_agama);
					$doc->exportCaption($this->id_negara);
					$doc->exportCaption($this->id_wilayah);
					$doc->exportCaption($this->id_jenis_tinggal);
					$doc->exportCaption($this->id_alat_transportasi);
					$doc->exportCaption($this->no_kps);
					$doc->exportCaption($this->penerima_kps);
					$doc->exportCaption($this->id_kebutuhan_khusus_mahasiswa);
					$doc->exportCaption($this->nisn);
					$doc->exportCaption($this->iddesa);
					$doc->exportCaption($this->MulaiKerja);
					$doc->exportCaption($this->IdKlsKerjasama);
					$doc->exportCaption($this->IDBeasiswa);
					$doc->exportCaption($this->tglKonversi);
					$doc->exportCaption($this->NoSuratKonversi);
					$doc->exportCaption($this->Nopen);
					$doc->exportCaption($this->id_feedmhs);
				} else {
					$doc->exportCaption($this->Nim);
					$doc->exportCaption($this->Nama_Mhs);
					$doc->exportCaption($this->Kode_jp);
					$doc->exportCaption($this->Tmp_Lahir);
					$doc->exportCaption($this->Tgl_Lahir);
					$doc->exportCaption($this->Jenis_Kel);
					$doc->exportCaption($this->Gol_darah);
					$doc->exportCaption($this->Agama_Mhs);
					$doc->exportCaption($this->Alamat_Mhs);
					$doc->exportCaption($this->rt);
					$doc->exportCaption($this->rw);
					$doc->exportCaption($this->Kelurahan);
					$doc->exportCaption($this->Kecamatan);
					$doc->exportCaption($this->Kota_Mhs);
					$doc->exportCaption($this->Provinsi_mhs);
					$doc->exportCaption($this->Kodepos_Mhs);
					$doc->exportCaption($this->Tlp_Mhs);
					$doc->exportCaption($this->TlpRumah);
					$doc->exportCaption($this->_Email);
					$doc->exportCaption($this->Status_Akd);
					$doc->exportCaption($this->ThMasuk);
					$doc->exportCaption($this->tglmasuk);
					$doc->exportCaption($this->Status_Masuk);
					$doc->exportCaption($this->Sem_Masuk);
					$doc->exportCaption($this->TaMasuk);
					$doc->exportCaption($this->PerMasuk);
					$doc->exportCaption($this->Pendidikan_Akhir);
					$doc->exportCaption($this->Jurusan);
					$doc->exportCaption($this->Thn_Selesai);
					$doc->exportCaption($this->Kota_Pdkk);
					$doc->exportCaption($this->propinsi);
					$doc->exportCaption($this->NIMASAL);
					$doc->exportCaption($this->KPTSASAL);
					$doc->exportCaption($this->JENASAL);
					$doc->exportCaption($this->PSASAL);
					$doc->exportCaption($this->TSKSDIAKUI);
					$doc->exportCaption($this->NamaSekolahAsal);
					$doc->exportCaption($this->AlamatSekolahAsal);
					$doc->exportCaption($this->Status);
					$doc->exportCaption($this->Password);
					$doc->exportCaption($this->Gelombang);
					$doc->exportCaption($this->JalurMasuk);
					$doc->exportCaption($this->Konsentrasi);
					$doc->exportCaption($this->NIK);
					$doc->exportCaption($this->NamaIbu);
					$doc->exportCaption($this->BekerjaDi);
					$doc->exportCaption($this->Lama);
					$doc->exportCaption($this->AlamatPerusahaan);
					$doc->exportCaption($this->TlpPerusahaan);
					$doc->exportCaption($this->Posisi);
					$doc->exportCaption($this->Departemen);
					$doc->exportCaption($this->IdUser);
					$doc->exportCaption($this->TempID);
					$doc->exportCaption($this->xphoto);
					$doc->exportCaption($this->profile);
					$doc->exportCaption($this->id_agama);
					$doc->exportCaption($this->id_negara);
					$doc->exportCaption($this->id_wilayah);
					$doc->exportCaption($this->id_jenis_tinggal);
					$doc->exportCaption($this->id_alat_transportasi);
					$doc->exportCaption($this->no_kps);
					$doc->exportCaption($this->penerima_kps);
					$doc->exportCaption($this->id_kebutuhan_khusus_mahasiswa);
					$doc->exportCaption($this->nisn);
					$doc->exportCaption($this->iddesa);
					$doc->exportCaption($this->MulaiKerja);
					$doc->exportCaption($this->IdKlsKerjasama);
					$doc->exportCaption($this->IDBeasiswa);
					$doc->exportCaption($this->tglKonversi);
					$doc->exportCaption($this->NoSuratKonversi);
					$doc->exportCaption($this->Nopen);
					$doc->exportCaption($this->id_feedmhs);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->Nim);
						$doc->exportField($this->Nama_Mhs);
						$doc->exportField($this->Kode_jp);
						$doc->exportField($this->Tmp_Lahir);
						$doc->exportField($this->Tgl_Lahir);
						$doc->exportField($this->Jenis_Kel);
						$doc->exportField($this->Gol_darah);
						$doc->exportField($this->Agama_Mhs);
						$doc->exportField($this->Alamat_Mhs);
						$doc->exportField($this->rt);
						$doc->exportField($this->rw);
						$doc->exportField($this->Kelurahan);
						$doc->exportField($this->Kecamatan);
						$doc->exportField($this->Kota_Mhs);
						$doc->exportField($this->Provinsi_mhs);
						$doc->exportField($this->Kodepos_Mhs);
						$doc->exportField($this->Tlp_Mhs);
						$doc->exportField($this->TlpRumah);
						$doc->exportField($this->_Email);
						$doc->exportField($this->Status_Akd);
						$doc->exportField($this->ThMasuk);
						$doc->exportField($this->tglmasuk);
						$doc->exportField($this->Status_Masuk);
						$doc->exportField($this->Sem_Masuk);
						$doc->exportField($this->TaMasuk);
						$doc->exportField($this->PerMasuk);
						$doc->exportField($this->Pendidikan_Akhir);
						$doc->exportField($this->Jurusan);
						$doc->exportField($this->Thn_Selesai);
						$doc->exportField($this->Kota_Pdkk);
						$doc->exportField($this->propinsi);
						$doc->exportField($this->NIMASAL);
						$doc->exportField($this->KPTSASAL);
						$doc->exportField($this->JENASAL);
						$doc->exportField($this->PSASAL);
						$doc->exportField($this->TSKSDIAKUI);
						$doc->exportField($this->NamaSekolahAsal);
						$doc->exportField($this->AlamatSekolahAsal);
						$doc->exportField($this->Status);
						$doc->exportField($this->Photo);
						$doc->exportField($this->Password);
						$doc->exportField($this->Gelombang);
						$doc->exportField($this->JalurMasuk);
						$doc->exportField($this->Konsentrasi);
						$doc->exportField($this->NIK);
						$doc->exportField($this->NamaIbu);
						$doc->exportField($this->BekerjaDi);
						$doc->exportField($this->Lama);
						$doc->exportField($this->AlamatPerusahaan);
						$doc->exportField($this->TlpPerusahaan);
						$doc->exportField($this->Posisi);
						$doc->exportField($this->Departemen);
						$doc->exportField($this->IdUser);
						$doc->exportField($this->TempID);
						$doc->exportField($this->xphoto);
						$doc->exportField($this->profile);
						$doc->exportField($this->id_agama);
						$doc->exportField($this->id_negara);
						$doc->exportField($this->id_wilayah);
						$doc->exportField($this->id_jenis_tinggal);
						$doc->exportField($this->id_alat_transportasi);
						$doc->exportField($this->no_kps);
						$doc->exportField($this->penerima_kps);
						$doc->exportField($this->id_kebutuhan_khusus_mahasiswa);
						$doc->exportField($this->nisn);
						$doc->exportField($this->iddesa);
						$doc->exportField($this->MulaiKerja);
						$doc->exportField($this->IdKlsKerjasama);
						$doc->exportField($this->IDBeasiswa);
						$doc->exportField($this->tglKonversi);
						$doc->exportField($this->NoSuratKonversi);
						$doc->exportField($this->Nopen);
						$doc->exportField($this->id_feedmhs);
					} else {
						$doc->exportField($this->Nim);
						$doc->exportField($this->Nama_Mhs);
						$doc->exportField($this->Kode_jp);
						$doc->exportField($this->Tmp_Lahir);
						$doc->exportField($this->Tgl_Lahir);
						$doc->exportField($this->Jenis_Kel);
						$doc->exportField($this->Gol_darah);
						$doc->exportField($this->Agama_Mhs);
						$doc->exportField($this->Alamat_Mhs);
						$doc->exportField($this->rt);
						$doc->exportField($this->rw);
						$doc->exportField($this->Kelurahan);
						$doc->exportField($this->Kecamatan);
						$doc->exportField($this->Kota_Mhs);
						$doc->exportField($this->Provinsi_mhs);
						$doc->exportField($this->Kodepos_Mhs);
						$doc->exportField($this->Tlp_Mhs);
						$doc->exportField($this->TlpRumah);
						$doc->exportField($this->_Email);
						$doc->exportField($this->Status_Akd);
						$doc->exportField($this->ThMasuk);
						$doc->exportField($this->tglmasuk);
						$doc->exportField($this->Status_Masuk);
						$doc->exportField($this->Sem_Masuk);
						$doc->exportField($this->TaMasuk);
						$doc->exportField($this->PerMasuk);
						$doc->exportField($this->Pendidikan_Akhir);
						$doc->exportField($this->Jurusan);
						$doc->exportField($this->Thn_Selesai);
						$doc->exportField($this->Kota_Pdkk);
						$doc->exportField($this->propinsi);
						$doc->exportField($this->NIMASAL);
						$doc->exportField($this->KPTSASAL);
						$doc->exportField($this->JENASAL);
						$doc->exportField($this->PSASAL);
						$doc->exportField($this->TSKSDIAKUI);
						$doc->exportField($this->NamaSekolahAsal);
						$doc->exportField($this->AlamatSekolahAsal);
						$doc->exportField($this->Status);
						$doc->exportField($this->Password);
						$doc->exportField($this->Gelombang);
						$doc->exportField($this->JalurMasuk);
						$doc->exportField($this->Konsentrasi);
						$doc->exportField($this->NIK);
						$doc->exportField($this->NamaIbu);
						$doc->exportField($this->BekerjaDi);
						$doc->exportField($this->Lama);
						$doc->exportField($this->AlamatPerusahaan);
						$doc->exportField($this->TlpPerusahaan);
						$doc->exportField($this->Posisi);
						$doc->exportField($this->Departemen);
						$doc->exportField($this->IdUser);
						$doc->exportField($this->TempID);
						$doc->exportField($this->xphoto);
						$doc->exportField($this->profile);
						$doc->exportField($this->id_agama);
						$doc->exportField($this->id_negara);
						$doc->exportField($this->id_wilayah);
						$doc->exportField($this->id_jenis_tinggal);
						$doc->exportField($this->id_alat_transportasi);
						$doc->exportField($this->no_kps);
						$doc->exportField($this->penerima_kps);
						$doc->exportField($this->id_kebutuhan_khusus_mahasiswa);
						$doc->exportField($this->nisn);
						$doc->exportField($this->iddesa);
						$doc->exportField($this->MulaiKerja);
						$doc->exportField($this->IdKlsKerjasama);
						$doc->exportField($this->IDBeasiswa);
						$doc->exportField($this->tglKonversi);
						$doc->exportField($this->NoSuratKonversi);
						$doc->exportField($this->Nopen);
						$doc->exportField($this->id_feedmhs);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0)
	{
		$width = ($width > 0) ? $width : Config("THUMBNAIL_DEFAULT_WIDTH");
		$height = ($height > 0) ? $height : Config("THUMBNAIL_DEFAULT_HEIGHT");

		// Set up field name / file name field / file type field
		$fldName = "";
		$fileNameFld = "";
		$fileTypeFld = "";
		if ($fldparm == 'Photo') {
			$fldName = "Photo";
		} else {
			return FALSE; // Incorrect field
		}

		// Set up key values
		$ar = explode(Config("COMPOSITE_KEY_SEPARATOR"), $key);
		if (count($ar) == 1) {
			$this->Nim->CurrentValue = $ar[0];
		} else {
			return FALSE; // Incorrect key
		}

		// Set up filter (WHERE Clause)
		$filter = $this->getRecordFilter();
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = $this->getConnection();
		$dbtype = GetConnectionType($this->Dbid);
		if (($rs = $conn->execute($sql)) && !$rs->EOF) {
			$val = $rs->fields($fldName);
			if (!EmptyValue($val)) {
				$fld = $this->fields[$fldName];

				// Binary data
				if ($fld->DataType == DATATYPE_BLOB) {
					if ($dbtype != "MYSQL") {
						if (is_array($val) || is_object($val)) // Byte array
							$val = BytesToString($val);
					}
					if ($resize)
						ResizeBinary($val, $width, $height);

					// Write file type
					if ($fileTypeFld != "" && !EmptyValue($rs->fields($fileTypeFld))) {
						AddHeader("Content-type", $rs->fields($fileTypeFld));
					} else {
						AddHeader("Content-type", ContentType($val));
					}

					// Write file name
					$downloadPdf = !Config("EMBED_PDF") && Config("DOWNLOAD_PDF_FILE");
					if ($fileNameFld != "" && !EmptyValue($rs->fields($fileNameFld))) {
						$fileName = $rs->fields($fileNameFld);
						$pathinfo = pathinfo($fileName);
						$ext = strtolower(@$pathinfo["extension"]);
						$isPdf = SameText($ext, "pdf");
						if ($downloadPdf || !$isPdf) // Skip header if not download PDF
							AddHeader("Content-Disposition", "attachment; filename=\"" . $fileName . "\"");
					} else {
						$ext = ContentExtension($val);
						$isPdf = SameText($ext, ".pdf");
						if ($isPdf && $downloadPdf) // Add header if download PDF
							AddHeader("Content-Disposition", "attachment; filename=\"" . $fileName . "\"");
					}

					// Write file data
					if (StartsString("PK", $val) && ContainsString($val, "[Content_Types].xml") &&
						ContainsString($val, "_rels") && ContainsString($val, "docProps")) { // Fix Office 2007 documents
						if (!EndsString("\0\0\0", $val)) // Not ends with 3 or 4 \0
							$val .= "\0\0\0\0";
					}

					// Clear any debug message
					if (ob_get_length())
						ob_end_clean();

					// Write binary data
					Write($val);

				// Upload to folder
				} else {
					if ($fld->UploadMultiple)
						$files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
					else
						$files = [$val];
					$data = [];
					$ar = [];
					foreach ($files as $file) {
						if (!EmptyValue($file))
							$ar[$file] = FullUrl($fld->hrefPath() . $file);
					}
					$data[$fld->Param] = $ar;
					WriteJson($data);
				}
			}
			$rs->close();
			return TRUE;
		}
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>