<?php
namespace PHPMaker2020\baak;

/**
 * Page class
 */
class tblMHSEkpt_edit extends tblMHSEkpt
{

	// Page ID
	public $PageID = "edit";

	// Project ID
	public $ProjectID = "{A09D3AFF-419C-4918-948A-A3C8469EA234}";

	// Table name
	public $TableName = 'tblMHSEkpt';

	// Page object name
	public $PageObjName = "tblMHSEkpt_edit";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken;

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading != "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading != "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		$url = CurrentPageName() . "?";
		if ($this->UseTokenInUrl)
			$url .= "t=" . $this->TableVar . "&"; // Add page token
		return $url;
	}

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = TRUE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message != "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fas fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage != "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fas fa-exclamation"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage != "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fas fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage != "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fas fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = [];

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message != "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage != "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage != "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage != "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header != "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer != "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(Config("TOKEN_NAME")) === NULL)
			return FALSE;
		$fn = Config("CHECK_TOKEN_FUNC");
		if (is_callable($fn))
			return $fn(Post(Config("TOKEN_NAME")), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = Config("CREATE_TOKEN_FUNC"); // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $DashboardReport;
		global $UserTable;

		// Check token
		$this->CheckToken = Config("CHECK_TOKEN");

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (tblMHSEkpt)
		if (!isset($GLOBALS["tblMHSEkpt"]) || get_class($GLOBALS["tblMHSEkpt"]) == PROJECT_NAMESPACE . "tblMHSEkpt") {
			$GLOBALS["tblMHSEkpt"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["tblMHSEkpt"];
		}

		// Table object (Pass)
		if (!isset($GLOBALS['Pass']))
			$GLOBALS['Pass'] = new Pass();

		// Table object (ekpt_mhsfeed)
		if (!isset($GLOBALS['ekpt_mhsfeed']))
			$GLOBALS['ekpt_mhsfeed'] = new ekpt_mhsfeed();

		// Page ID (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'edit');

		// Table name (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'tblMHSEkpt');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = $this->getConnection();

		// User table object (Pass)
		$UserTable = $UserTable ?: new Pass();
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages, $DashboardReport;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $tblMHSEkpt;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, Config("EXPORT_CLASSES"))) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . Config("EXPORT_CLASSES." . $this->CustomExport);
			if (class_exists($class)) {
				$doc = new $class($tblMHSEkpt);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url != "") {
			if (!Config("DEBUG") && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = ["url" => $url, "modal" => "1"];
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "tblMHSEkptview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = [];
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = [];
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {
								$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
									Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
									Config("API_FIELD_NAME") . "=" . $fld->Param . "&" .
									Config("API_KEY_NAME") . "=" . rawurlencode($this->getRecordKeyValue($ar)))); //*** need to add this? API may not be in the same folder
								$row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
								$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
									Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
									"fn=" . Encrypt($fld->physicalUploadPath() . $val)));
								$row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
							} else { // Multiple files
								$files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
								$ar = [];
								foreach ($files as $file) {
									$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
										Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
										"fn=" . Encrypt($fld->physicalUploadPath() . $file)));
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['Nim'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
	}

	// Lookup data
	public function lookup()
	{
		global $Language, $Security;
		if (!isset($Language))
			$Language = new Language(Config("LANGUAGE_FOLDER"), Post("language", ""));

		// Set up API request
		if (!ValidApiRequest())
			return FALSE;
		$this->setupApiSecurity();

		// Get lookup object
		$fieldName = Post("field");
		if (!array_key_exists($fieldName, $this->fields))
			return FALSE;
		$lookupField = $this->fields[$fieldName];
		$lookup = $lookupField->Lookup;
		if ($lookup === NULL)
			return FALSE;
		$tbl = $lookup->getTable();
		if (!$Security->allowLookup(Config("PROJECT_ID") . $tbl->TableName)) // Lookup permission
			return FALSE;

		// Get lookup parameters
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Param("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
			$lookup->FilterFields = []; // Skip parent fields if any
			$lookup->FilterValues[] = $keys; // Lookup values
			$pageSize = -1; // Show all records
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect != "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter != "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy != "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson($this); // Use settings from current page
	}

	// Set up API security
	public function setupApiSecurity()
	{
		global $Security;

		// Setup security for API request
		if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
		$Security->loadCurrentUserLevel(Config("PROJECT_ID") . $this->TableName);
		if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
	}
	public $FormClassName = "ew-horizontal ew-form ew-edit-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $DbMasterFilter;
	public $DbDetailFilter;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		if (ValidApiRequest()) { // API request
			$this->setupApiSecurity(); // Set up API Security
			if (!$Security->canEdit()) {
				SetStatus(401); // Unauthorized
				return;
			}
		} else {
			$Security = new AdvancedSecurity();
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canEdit()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("tblMHSEkptlist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->Nim->Visible = FALSE;
		$this->Nama_Mhs->setVisibility();
		$this->Kode_jp->Visible = FALSE;
		$this->Tmp_Lahir->setVisibility();
		$this->Tgl_Lahir->setVisibility();
		$this->Jenis_Kel->Visible = FALSE;
		$this->Gol_darah->Visible = FALSE;
		$this->Agama_Mhs->Visible = FALSE;
		$this->Alamat_Mhs->Visible = FALSE;
		$this->rt->Visible = FALSE;
		$this->rw->Visible = FALSE;
		$this->Kelurahan->Visible = FALSE;
		$this->Kecamatan->Visible = FALSE;
		$this->Kota_Mhs->Visible = FALSE;
		$this->Provinsi_mhs->Visible = FALSE;
		$this->Kodepos_Mhs->Visible = FALSE;
		$this->Tlp_Mhs->Visible = FALSE;
		$this->TlpRumah->Visible = FALSE;
		$this->_Email->Visible = FALSE;
		$this->Status_Akd->Visible = FALSE;
		$this->ThMasuk->Visible = FALSE;
		$this->tglmasuk->setVisibility();
		$this->Status_Masuk->Visible = FALSE;
		$this->Sem_Masuk->Visible = FALSE;
		$this->TaMasuk->setVisibility();
		$this->PerMasuk->setVisibility();
		$this->Pendidikan_Akhir->Visible = FALSE;
		$this->Jurusan->Visible = FALSE;
		$this->Thn_Selesai->Visible = FALSE;
		$this->Kota_Pdkk->Visible = FALSE;
		$this->propinsi->Visible = FALSE;
		$this->NIMASAL->Visible = FALSE;
		$this->KPTSASAL->Visible = FALSE;
		$this->JENASAL->Visible = FALSE;
		$this->PSASAL->Visible = FALSE;
		$this->TSKSDIAKUI->Visible = FALSE;
		$this->NamaSekolahAsal->Visible = FALSE;
		$this->AlamatSekolahAsal->Visible = FALSE;
		$this->Status->setVisibility();
		$this->Photo->Visible = FALSE;
		$this->Password->Visible = FALSE;
		$this->JalurMasuk->Visible = FALSE;
		$this->Konsentrasi->Visible = FALSE;
		$this->NIK->setVisibility();
		$this->NamaIbu->setVisibility();
		$this->BekerjaDi->Visible = FALSE;
		$this->Lama->Visible = FALSE;
		$this->AlamatPerusahaan->Visible = FALSE;
		$this->TlpPerusahaan->Visible = FALSE;
		$this->Posisi->Visible = FALSE;
		$this->Departemen->Visible = FALSE;
		$this->IdUser->Visible = FALSE;
		$this->TempID->Visible = FALSE;
		$this->xphoto->Visible = FALSE;
		$this->profile->Visible = FALSE;
		$this->id_agama->Visible = FALSE;
		$this->id_negara->Visible = FALSE;
		$this->id_wilayah->Visible = FALSE;
		$this->id_jenis_tinggal->Visible = FALSE;
		$this->id_alat_transportasi->Visible = FALSE;
		$this->no_kps->Visible = FALSE;
		$this->penerima_kps->Visible = FALSE;
		$this->id_kebutuhan_khusus_mahasiswa->Visible = FALSE;
		$this->nisn->Visible = FALSE;
		$this->MulaiKerja->Visible = FALSE;
		$this->IdKlsKerjasama->Visible = FALSE;
		$this->IDBeasiswa->Visible = FALSE;
		$this->Gelombang->Visible = FALSE;
		$this->iddesa->Visible = FALSE;
		$this->tglKonversi->Visible = FALSE;
		$this->NoSuratKonversi->Visible = FALSE;
		$this->Nopen->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		// Check permission

		if (!$Security->canEdit()) {
			$this->setFailureMessage(DeniedMessage()); // No permission
			$this->terminate("tblMHSEkptlist.php");
			return;
		}

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-edit-form ew-horizontal";
		$loaded = FALSE;
		$postBack = FALSE;

		// Set up current action and primary key
		if (IsApi()) {

			// Load key values
			$loaded = TRUE;
			if (Get("Nim") !== NULL) {
				$this->Nim->setQueryStringValue(Get("Nim"));
				$this->Nim->setOldValue($this->Nim->QueryStringValue);
			} elseif (Key(0) !== NULL) {
				$this->Nim->setQueryStringValue(Key(0));
				$this->Nim->setOldValue($this->Nim->QueryStringValue);
			} elseif (Post("Nim") !== NULL) {
				$this->Nim->setFormValue(Post("Nim"));
				$this->Nim->setOldValue($this->Nim->FormValue);
			} elseif (Route(2) !== NULL) {
				$this->Nim->setQueryStringValue(Route(2));
				$this->Nim->setOldValue($this->Nim->QueryStringValue);
			} else {
				$loaded = FALSE; // Unable to load key
			}

			// Load record
			if ($loaded)
				$loaded = $this->loadRow();
			if (!$loaded) {
				$this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
				$this->terminate();
				return;
			}
			$this->CurrentAction = "update"; // Update record directly
			$postBack = TRUE;
		} else {
			if (Post("action") !== NULL) {
				$this->CurrentAction = Post("action"); // Get action code
				if (!$this->isShow()) // Not reload record, handle as postback
					$postBack = TRUE;

				// Load key from Form
				if ($CurrentForm->hasValue("x_Nim")) {
					$this->Nim->setFormValue($CurrentForm->getValue("x_Nim"));
				}
			} else {
				$this->CurrentAction = "show"; // Default action is display

				// Load key from QueryString / Route
				$loadByQuery = FALSE;
				if (Get("Nim") !== NULL) {
					$this->Nim->setQueryStringValue(Get("Nim"));
					$loadByQuery = TRUE;
				} elseif (Route(2) !== NULL) {
					$this->Nim->setQueryStringValue(Route(2));
					$loadByQuery = TRUE;
				} else {
					$this->Nim->CurrentValue = NULL;
				}
			}

			// Set up master detail parameters
			$this->setupMasterParms();

			// Load current record
			$loaded = $this->loadRow();
		}

		// Process form if post back
		if ($postBack) {
			$this->loadFormValues(); // Get form values
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->validateForm()) {
				$this->setFailureMessage($FormError);
				$this->EventCancelled = TRUE; // Event cancelled
				$this->restoreFormValues();
				if (IsApi()) {
					$this->terminate();
					return;
				} else {
					$this->CurrentAction = ""; // Form error, reset action
				}
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "show": // Get a record to display
				if (!$loaded) { // Load record based on key
					if ($this->getFailureMessage() == "")
						$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
					$this->terminate("tblMHSEkptlist.php"); // No matching record, return to list
				}
				break;
			case "update": // Update
				$returnUrl = $this->getReturnUrl();
				if (GetPageName($returnUrl) == "tblMHSEkptlist.php")
					$returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
				$this->SendEmail = TRUE; // Send email on update success
				if ($this->editRow()) { // Update record based on key
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Update success
					if (IsApi()) {
						$this->terminate(TRUE);
						return;
					} else {
						$this->terminate($returnUrl); // Return to caller
					}
				} elseif (IsApi()) { // API request, return
					$this->terminate();
					return;
				} elseif ($this->getFailureMessage() == $Language->phrase("NoRecord")) {
					$this->terminate($returnUrl); // Return to caller
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->restoreFormValues(); // Restore form values if update failed
				}
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Render the record
		$this->RowType = ROWTYPE_EDIT; // Render as Edit
		$this->resetAttributes();
		$this->renderRow();
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;

		// Check field name 'Nama_Mhs' first before field var 'x_Nama_Mhs'
		$val = $CurrentForm->hasValue("Nama_Mhs") ? $CurrentForm->getValue("Nama_Mhs") : $CurrentForm->getValue("x_Nama_Mhs");
		if (!$this->Nama_Mhs->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->Nama_Mhs->Visible = FALSE; // Disable update for API request
			else
				$this->Nama_Mhs->setFormValue($val);
		}

		// Check field name 'Tmp_Lahir' first before field var 'x_Tmp_Lahir'
		$val = $CurrentForm->hasValue("Tmp_Lahir") ? $CurrentForm->getValue("Tmp_Lahir") : $CurrentForm->getValue("x_Tmp_Lahir");
		if (!$this->Tmp_Lahir->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->Tmp_Lahir->Visible = FALSE; // Disable update for API request
			else
				$this->Tmp_Lahir->setFormValue($val);
		}

		// Check field name 'Tgl_Lahir' first before field var 'x_Tgl_Lahir'
		$val = $CurrentForm->hasValue("Tgl_Lahir") ? $CurrentForm->getValue("Tgl_Lahir") : $CurrentForm->getValue("x_Tgl_Lahir");
		if (!$this->Tgl_Lahir->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->Tgl_Lahir->Visible = FALSE; // Disable update for API request
			else
				$this->Tgl_Lahir->setFormValue($val);
			$this->Tgl_Lahir->CurrentValue = UnFormatDateTime($this->Tgl_Lahir->CurrentValue, 0);
		}

		// Check field name 'tglmasuk' first before field var 'x_tglmasuk'
		$val = $CurrentForm->hasValue("tglmasuk") ? $CurrentForm->getValue("tglmasuk") : $CurrentForm->getValue("x_tglmasuk");
		if (!$this->tglmasuk->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->tglmasuk->Visible = FALSE; // Disable update for API request
			else
				$this->tglmasuk->setFormValue($val);
			$this->tglmasuk->CurrentValue = UnFormatDateTime($this->tglmasuk->CurrentValue, 7);
		}

		// Check field name 'TaMasuk' first before field var 'x_TaMasuk'
		$val = $CurrentForm->hasValue("TaMasuk") ? $CurrentForm->getValue("TaMasuk") : $CurrentForm->getValue("x_TaMasuk");
		if (!$this->TaMasuk->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->TaMasuk->Visible = FALSE; // Disable update for API request
			else
				$this->TaMasuk->setFormValue($val);
		}

		// Check field name 'PerMasuk' first before field var 'x_PerMasuk'
		$val = $CurrentForm->hasValue("PerMasuk") ? $CurrentForm->getValue("PerMasuk") : $CurrentForm->getValue("x_PerMasuk");
		if (!$this->PerMasuk->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->PerMasuk->Visible = FALSE; // Disable update for API request
			else
				$this->PerMasuk->setFormValue($val);
		}

		// Check field name 'Status' first before field var 'x_Status'
		$val = $CurrentForm->hasValue("Status") ? $CurrentForm->getValue("Status") : $CurrentForm->getValue("x_Status");
		if (!$this->Status->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->Status->Visible = FALSE; // Disable update for API request
			else
				$this->Status->setFormValue($val);
		}

		// Check field name 'NIK' first before field var 'x_NIK'
		$val = $CurrentForm->hasValue("NIK") ? $CurrentForm->getValue("NIK") : $CurrentForm->getValue("x_NIK");
		if (!$this->NIK->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->NIK->Visible = FALSE; // Disable update for API request
			else
				$this->NIK->setFormValue($val);
		}

		// Check field name 'NamaIbu' first before field var 'x_NamaIbu'
		$val = $CurrentForm->hasValue("NamaIbu") ? $CurrentForm->getValue("NamaIbu") : $CurrentForm->getValue("x_NamaIbu");
		if (!$this->NamaIbu->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->NamaIbu->Visible = FALSE; // Disable update for API request
			else
				$this->NamaIbu->setFormValue($val);
		}

		// Check field name 'Nopen' first before field var 'x_Nopen'
		$val = $CurrentForm->hasValue("Nopen") ? $CurrentForm->getValue("Nopen") : $CurrentForm->getValue("x_Nopen");
		if (!$this->Nopen->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->Nopen->Visible = FALSE; // Disable update for API request
			else
				$this->Nopen->setFormValue($val);
		}

		// Check field name 'Nim' first before field var 'x_Nim'
		$val = $CurrentForm->hasValue("Nim") ? $CurrentForm->getValue("Nim") : $CurrentForm->getValue("x_Nim");
		if (!$this->Nim->IsDetailKey)
			$this->Nim->setFormValue($val);
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->Nim->CurrentValue = $this->Nim->FormValue;
		$this->Nama_Mhs->CurrentValue = $this->Nama_Mhs->FormValue;
		$this->Tmp_Lahir->CurrentValue = $this->Tmp_Lahir->FormValue;
		$this->Tgl_Lahir->CurrentValue = $this->Tgl_Lahir->FormValue;
		$this->Tgl_Lahir->CurrentValue = UnFormatDateTime($this->Tgl_Lahir->CurrentValue, 0);
		$this->tglmasuk->CurrentValue = $this->tglmasuk->FormValue;
		$this->tglmasuk->CurrentValue = UnFormatDateTime($this->tglmasuk->CurrentValue, 7);
		$this->TaMasuk->CurrentValue = $this->TaMasuk->FormValue;
		$this->PerMasuk->CurrentValue = $this->PerMasuk->FormValue;
		$this->Status->CurrentValue = $this->Status->FormValue;
		$this->NIK->CurrentValue = $this->NIK->FormValue;
		$this->NamaIbu->CurrentValue = $this->NamaIbu->FormValue;
		$this->Nopen->CurrentValue = $this->Nopen->FormValue;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = $this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->Nim->setDbValue($row['Nim']);
		$this->Nama_Mhs->setDbValue($row['Nama_Mhs']);
		$this->Kode_jp->setDbValue($row['Kode_jp']);
		$this->Tmp_Lahir->setDbValue($row['Tmp_Lahir']);
		$this->Tgl_Lahir->setDbValue($row['Tgl_Lahir']);
		$this->Jenis_Kel->setDbValue($row['Jenis_Kel']);
		$this->Gol_darah->setDbValue($row['Gol_darah']);
		$this->Agama_Mhs->setDbValue($row['Agama_Mhs']);
		$this->Alamat_Mhs->setDbValue($row['Alamat_Mhs']);
		$this->rt->setDbValue($row['rt']);
		$this->rw->setDbValue($row['rw']);
		$this->Kelurahan->setDbValue($row['Kelurahan']);
		$this->Kecamatan->setDbValue($row['Kecamatan']);
		$this->Kota_Mhs->setDbValue($row['Kota_Mhs']);
		$this->Provinsi_mhs->setDbValue($row['Provinsi_mhs']);
		$this->Kodepos_Mhs->setDbValue($row['Kodepos_Mhs']);
		$this->Tlp_Mhs->setDbValue($row['Tlp_Mhs']);
		$this->TlpRumah->setDbValue($row['TlpRumah']);
		$this->_Email->setDbValue($row['Email']);
		$this->Status_Akd->setDbValue($row['Status_Akd']);
		$this->ThMasuk->setDbValue($row['ThMasuk']);
		$this->tglmasuk->setDbValue($row['tglmasuk']);
		$this->Status_Masuk->setDbValue($row['Status_Masuk']);
		$this->Sem_Masuk->setDbValue($row['Sem_Masuk']);
		$this->TaMasuk->setDbValue($row['TaMasuk']);
		$this->PerMasuk->setDbValue($row['PerMasuk']);
		$this->Pendidikan_Akhir->setDbValue($row['Pendidikan_Akhir']);
		$this->Jurusan->setDbValue($row['Jurusan']);
		$this->Thn_Selesai->setDbValue($row['Thn_Selesai']);
		$this->Kota_Pdkk->setDbValue($row['Kota_Pdkk']);
		$this->propinsi->setDbValue($row['propinsi']);
		$this->NIMASAL->setDbValue($row['NIMASAL']);
		$this->KPTSASAL->setDbValue($row['KPTSASAL']);
		$this->JENASAL->setDbValue($row['JENASAL']);
		$this->PSASAL->setDbValue($row['PSASAL']);
		$this->TSKSDIAKUI->setDbValue($row['TSKSDIAKUI']);
		$this->NamaSekolahAsal->setDbValue($row['NamaSekolahAsal']);
		$this->AlamatSekolahAsal->setDbValue($row['AlamatSekolahAsal']);
		$this->Status->setDbValue($row['Status']);
		$this->Photo->Upload->DbValue = $row['Photo'];
		if (is_array($this->Photo->Upload->DbValue) || is_object($this->Photo->Upload->DbValue)) // Byte array
			$this->Photo->Upload->DbValue = BytesToString($this->Photo->Upload->DbValue);
		$this->Password->setDbValue($row['Password']);
		$this->JalurMasuk->setDbValue($row['JalurMasuk']);
		$this->Konsentrasi->setDbValue($row['Konsentrasi']);
		$this->NIK->setDbValue($row['NIK']);
		$this->NamaIbu->setDbValue($row['NamaIbu']);
		$this->BekerjaDi->setDbValue($row['BekerjaDi']);
		$this->Lama->setDbValue($row['Lama']);
		$this->AlamatPerusahaan->setDbValue($row['AlamatPerusahaan']);
		$this->TlpPerusahaan->setDbValue($row['TlpPerusahaan']);
		$this->Posisi->setDbValue($row['Posisi']);
		$this->Departemen->setDbValue($row['Departemen']);
		$this->IdUser->setDbValue($row['IdUser']);
		$this->TempID->setDbValue($row['TempID']);
		$this->xphoto->setDbValue($row['xphoto']);
		$this->profile->setDbValue($row['profile']);
		$this->id_agama->setDbValue($row['id_agama']);
		$this->id_negara->setDbValue($row['id_negara']);
		$this->id_wilayah->setDbValue($row['id_wilayah']);
		$this->id_jenis_tinggal->setDbValue($row['id_jenis_tinggal']);
		$this->id_alat_transportasi->setDbValue($row['id_alat_transportasi']);
		$this->no_kps->setDbValue($row['no_kps']);
		$this->penerima_kps->setDbValue($row['penerima_kps']);
		$this->id_kebutuhan_khusus_mahasiswa->setDbValue($row['id_kebutuhan_khusus_mahasiswa']);
		$this->nisn->setDbValue($row['nisn']);
		$this->MulaiKerja->setDbValue($row['MulaiKerja']);
		$this->IdKlsKerjasama->setDbValue($row['IdKlsKerjasama']);
		$this->IDBeasiswa->setDbValue($row['IDBeasiswa']);
		$this->Gelombang->setDbValue($row['Gelombang']);
		$this->iddesa->setDbValue($row['iddesa']);
		$this->tglKonversi->setDbValue($row['tglKonversi']);
		$this->NoSuratKonversi->setDbValue($row['NoSuratKonversi']);
		$this->Nopen->setDbValue($row['Nopen']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['Nim'] = NULL;
		$row['Nama_Mhs'] = NULL;
		$row['Kode_jp'] = NULL;
		$row['Tmp_Lahir'] = NULL;
		$row['Tgl_Lahir'] = NULL;
		$row['Jenis_Kel'] = NULL;
		$row['Gol_darah'] = NULL;
		$row['Agama_Mhs'] = NULL;
		$row['Alamat_Mhs'] = NULL;
		$row['rt'] = NULL;
		$row['rw'] = NULL;
		$row['Kelurahan'] = NULL;
		$row['Kecamatan'] = NULL;
		$row['Kota_Mhs'] = NULL;
		$row['Provinsi_mhs'] = NULL;
		$row['Kodepos_Mhs'] = NULL;
		$row['Tlp_Mhs'] = NULL;
		$row['TlpRumah'] = NULL;
		$row['Email'] = NULL;
		$row['Status_Akd'] = NULL;
		$row['ThMasuk'] = NULL;
		$row['tglmasuk'] = NULL;
		$row['Status_Masuk'] = NULL;
		$row['Sem_Masuk'] = NULL;
		$row['TaMasuk'] = NULL;
		$row['PerMasuk'] = NULL;
		$row['Pendidikan_Akhir'] = NULL;
		$row['Jurusan'] = NULL;
		$row['Thn_Selesai'] = NULL;
		$row['Kota_Pdkk'] = NULL;
		$row['propinsi'] = NULL;
		$row['NIMASAL'] = NULL;
		$row['KPTSASAL'] = NULL;
		$row['JENASAL'] = NULL;
		$row['PSASAL'] = NULL;
		$row['TSKSDIAKUI'] = NULL;
		$row['NamaSekolahAsal'] = NULL;
		$row['AlamatSekolahAsal'] = NULL;
		$row['Status'] = NULL;
		$row['Photo'] = NULL;
		$row['Password'] = NULL;
		$row['JalurMasuk'] = NULL;
		$row['Konsentrasi'] = NULL;
		$row['NIK'] = NULL;
		$row['NamaIbu'] = NULL;
		$row['BekerjaDi'] = NULL;
		$row['Lama'] = NULL;
		$row['AlamatPerusahaan'] = NULL;
		$row['TlpPerusahaan'] = NULL;
		$row['Posisi'] = NULL;
		$row['Departemen'] = NULL;
		$row['IdUser'] = NULL;
		$row['TempID'] = NULL;
		$row['xphoto'] = NULL;
		$row['profile'] = NULL;
		$row['id_agama'] = NULL;
		$row['id_negara'] = NULL;
		$row['id_wilayah'] = NULL;
		$row['id_jenis_tinggal'] = NULL;
		$row['id_alat_transportasi'] = NULL;
		$row['no_kps'] = NULL;
		$row['penerima_kps'] = NULL;
		$row['id_kebutuhan_khusus_mahasiswa'] = NULL;
		$row['nisn'] = NULL;
		$row['MulaiKerja'] = NULL;
		$row['IdKlsKerjasama'] = NULL;
		$row['IDBeasiswa'] = NULL;
		$row['Gelombang'] = NULL;
		$row['iddesa'] = NULL;
		$row['tglKonversi'] = NULL;
		$row['NoSuratKonversi'] = NULL;
		$row['Nopen'] = NULL;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("Nim")) != "")
			$this->Nim->OldValue = $this->getKey("Nim"); // Nim
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = $this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Call Row_Rendering event

		$this->Row_Rendering();

		// Common render codes for all row types
		// Nim
		// Nama_Mhs
		// Kode_jp
		// Tmp_Lahir
		// Tgl_Lahir
		// Jenis_Kel
		// Gol_darah
		// Agama_Mhs
		// Alamat_Mhs
		// rt
		// rw
		// Kelurahan
		// Kecamatan
		// Kota_Mhs
		// Provinsi_mhs
		// Kodepos_Mhs
		// Tlp_Mhs
		// TlpRumah
		// Email
		// Status_Akd
		// ThMasuk
		// tglmasuk
		// Status_Masuk
		// Sem_Masuk
		// TaMasuk
		// PerMasuk
		// Pendidikan_Akhir
		// Jurusan
		// Thn_Selesai
		// Kota_Pdkk
		// propinsi
		// NIMASAL
		// KPTSASAL
		// JENASAL
		// PSASAL
		// TSKSDIAKUI
		// NamaSekolahAsal
		// AlamatSekolahAsal
		// Status
		// Photo
		// Password
		// JalurMasuk
		// Konsentrasi
		// NIK
		// NamaIbu
		// BekerjaDi
		// Lama
		// AlamatPerusahaan
		// TlpPerusahaan
		// Posisi
		// Departemen
		// IdUser
		// TempID
		// xphoto
		// profile
		// id_agama
		// id_negara
		// id_wilayah
		// id_jenis_tinggal
		// id_alat_transportasi
		// no_kps
		// penerima_kps
		// id_kebutuhan_khusus_mahasiswa
		// nisn
		// MulaiKerja
		// IdKlsKerjasama
		// IDBeasiswa
		// Gelombang
		// iddesa
		// tglKonversi
		// NoSuratKonversi
		// Nopen

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// Nim
			$this->Nim->ViewValue = $this->Nim->CurrentValue;
			$this->Nim->ViewCustomAttributes = "";

			// Nama_Mhs
			$this->Nama_Mhs->ViewValue = $this->Nama_Mhs->CurrentValue;
			$this->Nama_Mhs->ViewCustomAttributes = "";

			// Kode_jp
			$this->Kode_jp->ViewValue = $this->Kode_jp->CurrentValue;
			$this->Kode_jp->ViewCustomAttributes = "";

			// Tmp_Lahir
			$this->Tmp_Lahir->ViewValue = $this->Tmp_Lahir->CurrentValue;
			$this->Tmp_Lahir->ViewCustomAttributes = "";

			// Tgl_Lahir
			$this->Tgl_Lahir->ViewValue = $this->Tgl_Lahir->CurrentValue;
			$this->Tgl_Lahir->ViewValue = FormatDateTime($this->Tgl_Lahir->ViewValue, 0);
			$this->Tgl_Lahir->ViewCustomAttributes = "";

			// Jenis_Kel
			$this->Jenis_Kel->ViewValue = $this->Jenis_Kel->CurrentValue;
			$this->Jenis_Kel->ViewCustomAttributes = "";

			// Gol_darah
			$this->Gol_darah->ViewValue = $this->Gol_darah->CurrentValue;
			$this->Gol_darah->ViewCustomAttributes = "";

			// Agama_Mhs
			$this->Agama_Mhs->ViewValue = $this->Agama_Mhs->CurrentValue;
			$this->Agama_Mhs->ViewCustomAttributes = "";

			// Alamat_Mhs
			$this->Alamat_Mhs->ViewValue = $this->Alamat_Mhs->CurrentValue;
			$this->Alamat_Mhs->ViewCustomAttributes = "";

			// rt
			$this->rt->ViewValue = $this->rt->CurrentValue;
			$this->rt->ViewCustomAttributes = "";

			// rw
			$this->rw->ViewValue = $this->rw->CurrentValue;
			$this->rw->ViewCustomAttributes = "";

			// Kelurahan
			$this->Kelurahan->ViewValue = $this->Kelurahan->CurrentValue;
			$this->Kelurahan->ViewCustomAttributes = "";

			// Kecamatan
			$this->Kecamatan->ViewValue = $this->Kecamatan->CurrentValue;
			$this->Kecamatan->ViewCustomAttributes = "";

			// Kota_Mhs
			$this->Kota_Mhs->ViewValue = $this->Kota_Mhs->CurrentValue;
			$this->Kota_Mhs->ViewCustomAttributes = "";

			// Provinsi_mhs
			$this->Provinsi_mhs->ViewValue = $this->Provinsi_mhs->CurrentValue;
			$this->Provinsi_mhs->ViewCustomAttributes = "";

			// Kodepos_Mhs
			$this->Kodepos_Mhs->ViewValue = $this->Kodepos_Mhs->CurrentValue;
			$this->Kodepos_Mhs->ViewCustomAttributes = "";

			// Tlp_Mhs
			$this->Tlp_Mhs->ViewValue = $this->Tlp_Mhs->CurrentValue;
			$this->Tlp_Mhs->ViewCustomAttributes = "";

			// TlpRumah
			$this->TlpRumah->ViewValue = $this->TlpRumah->CurrentValue;
			$this->TlpRumah->ViewCustomAttributes = "";

			// Email
			$this->_Email->ViewValue = $this->_Email->CurrentValue;
			$this->_Email->ViewCustomAttributes = "";

			// Status_Akd
			$this->Status_Akd->ViewValue = $this->Status_Akd->CurrentValue;
			$this->Status_Akd->ViewCustomAttributes = "";

			// ThMasuk
			$this->ThMasuk->ViewValue = $this->ThMasuk->CurrentValue;
			$this->ThMasuk->ViewCustomAttributes = "";

			// tglmasuk
			$this->tglmasuk->ViewValue = $this->tglmasuk->CurrentValue;
			$this->tglmasuk->ViewValue = FormatDateTime($this->tglmasuk->ViewValue, 7);
			$this->tglmasuk->ViewCustomAttributes = "";

			// Status_Masuk
			$this->Status_Masuk->ViewValue = $this->Status_Masuk->CurrentValue;
			$this->Status_Masuk->ViewCustomAttributes = "";

			// Sem_Masuk
			$this->Sem_Masuk->ViewValue = $this->Sem_Masuk->CurrentValue;
			$this->Sem_Masuk->ViewCustomAttributes = "";

			// TaMasuk
			$this->TaMasuk->ViewValue = $this->TaMasuk->CurrentValue;
			$this->TaMasuk->ViewCustomAttributes = "";

			// PerMasuk
			$this->PerMasuk->ViewValue = $this->PerMasuk->CurrentValue;
			$this->PerMasuk->ViewCustomAttributes = "";

			// Pendidikan_Akhir
			$this->Pendidikan_Akhir->ViewValue = $this->Pendidikan_Akhir->CurrentValue;
			$this->Pendidikan_Akhir->ViewCustomAttributes = "";

			// Jurusan
			$this->Jurusan->ViewValue = $this->Jurusan->CurrentValue;
			$this->Jurusan->ViewCustomAttributes = "";

			// Thn_Selesai
			$this->Thn_Selesai->ViewValue = $this->Thn_Selesai->CurrentValue;
			$this->Thn_Selesai->ViewCustomAttributes = "";

			// Kota_Pdkk
			$this->Kota_Pdkk->ViewValue = $this->Kota_Pdkk->CurrentValue;
			$this->Kota_Pdkk->ViewCustomAttributes = "";

			// propinsi
			$this->propinsi->ViewValue = $this->propinsi->CurrentValue;
			$this->propinsi->ViewCustomAttributes = "";

			// NIMASAL
			$this->NIMASAL->ViewValue = $this->NIMASAL->CurrentValue;
			$this->NIMASAL->ViewCustomAttributes = "";

			// KPTSASAL
			$this->KPTSASAL->ViewValue = $this->KPTSASAL->CurrentValue;
			$this->KPTSASAL->ViewCustomAttributes = "";

			// JENASAL
			$this->JENASAL->ViewValue = $this->JENASAL->CurrentValue;
			$this->JENASAL->ViewCustomAttributes = "";

			// PSASAL
			$this->PSASAL->ViewValue = $this->PSASAL->CurrentValue;
			$this->PSASAL->ViewCustomAttributes = "";

			// TSKSDIAKUI
			$this->TSKSDIAKUI->ViewValue = $this->TSKSDIAKUI->CurrentValue;
			$this->TSKSDIAKUI->ViewValue = FormatNumber($this->TSKSDIAKUI->ViewValue, 0, -2, -2, -2);
			$this->TSKSDIAKUI->ViewCustomAttributes = "";

			// NamaSekolahAsal
			$this->NamaSekolahAsal->ViewValue = $this->NamaSekolahAsal->CurrentValue;
			$this->NamaSekolahAsal->ViewCustomAttributes = "";

			// AlamatSekolahAsal
			$this->AlamatSekolahAsal->ViewValue = $this->AlamatSekolahAsal->CurrentValue;
			$this->AlamatSekolahAsal->ViewCustomAttributes = "";

			// Status
			if (strval($this->Status->CurrentValue) != "") {
				$this->Status->ViewValue = $this->Status->optionCaption($this->Status->CurrentValue);
			} else {
				$this->Status->ViewValue = NULL;
			}
			$this->Status->ViewCustomAttributes = "";

			// Password
			$this->Password->ViewValue = $this->Password->CurrentValue;
			$this->Password->ViewCustomAttributes = "";

			// JalurMasuk
			$this->JalurMasuk->ViewValue = $this->JalurMasuk->CurrentValue;
			$this->JalurMasuk->ViewCustomAttributes = "";

			// Konsentrasi
			$this->Konsentrasi->ViewValue = $this->Konsentrasi->CurrentValue;
			$this->Konsentrasi->ViewCustomAttributes = "";

			// NIK
			$this->NIK->ViewValue = $this->NIK->CurrentValue;
			$this->NIK->ViewCustomAttributes = "";

			// NamaIbu
			$this->NamaIbu->ViewValue = $this->NamaIbu->CurrentValue;
			$this->NamaIbu->ViewCustomAttributes = "";

			// BekerjaDi
			$this->BekerjaDi->ViewValue = $this->BekerjaDi->CurrentValue;
			$this->BekerjaDi->ViewCustomAttributes = "";

			// Lama
			$this->Lama->ViewValue = $this->Lama->CurrentValue;
			$this->Lama->ViewCustomAttributes = "";

			// AlamatPerusahaan
			$this->AlamatPerusahaan->ViewValue = $this->AlamatPerusahaan->CurrentValue;
			$this->AlamatPerusahaan->ViewCustomAttributes = "";

			// TlpPerusahaan
			$this->TlpPerusahaan->ViewValue = $this->TlpPerusahaan->CurrentValue;
			$this->TlpPerusahaan->ViewCustomAttributes = "";

			// Posisi
			$this->Posisi->ViewValue = $this->Posisi->CurrentValue;
			$this->Posisi->ViewCustomAttributes = "";

			// Departemen
			$this->Departemen->ViewValue = $this->Departemen->CurrentValue;
			$this->Departemen->ViewCustomAttributes = "";

			// IdUser
			$this->IdUser->ViewValue = $this->IdUser->CurrentValue;
			$this->IdUser->ViewCustomAttributes = "";

			// TempID
			$this->TempID->ViewValue = $this->TempID->CurrentValue;
			$this->TempID->ViewValue = FormatNumber($this->TempID->ViewValue, 0, -2, -2, -2);
			$this->TempID->ViewCustomAttributes = "";

			// xphoto
			$this->xphoto->ViewValue = $this->xphoto->CurrentValue;
			$this->xphoto->ViewCustomAttributes = "";

			// profile
			$this->profile->ViewValue = $this->profile->CurrentValue;
			$this->profile->ViewCustomAttributes = "";

			// id_agama
			$this->id_agama->ViewValue = $this->id_agama->CurrentValue;
			$this->id_agama->ViewValue = FormatNumber($this->id_agama->ViewValue, 0, -2, -2, -2);
			$this->id_agama->ViewCustomAttributes = "";

			// id_negara
			$this->id_negara->ViewValue = $this->id_negara->CurrentValue;
			$this->id_negara->ViewCustomAttributes = "";

			// id_wilayah
			$this->id_wilayah->ViewValue = $this->id_wilayah->CurrentValue;
			$this->id_wilayah->ViewCustomAttributes = "";

			// id_jenis_tinggal
			$this->id_jenis_tinggal->ViewValue = $this->id_jenis_tinggal->CurrentValue;
			$this->id_jenis_tinggal->ViewValue = FormatNumber($this->id_jenis_tinggal->ViewValue, 0, -2, -2, -2);
			$this->id_jenis_tinggal->ViewCustomAttributes = "";

			// id_alat_transportasi
			$this->id_alat_transportasi->ViewValue = $this->id_alat_transportasi->CurrentValue;
			$this->id_alat_transportasi->ViewValue = FormatNumber($this->id_alat_transportasi->ViewValue, 0, -2, -2, -2);
			$this->id_alat_transportasi->ViewCustomAttributes = "";

			// no_kps
			$this->no_kps->ViewValue = $this->no_kps->CurrentValue;
			$this->no_kps->ViewCustomAttributes = "";

			// penerima_kps
			$this->penerima_kps->ViewValue = $this->penerima_kps->CurrentValue;
			$this->penerima_kps->ViewValue = FormatNumber($this->penerima_kps->ViewValue, 0, -2, -2, -2);
			$this->penerima_kps->ViewCustomAttributes = "";

			// id_kebutuhan_khusus_mahasiswa
			$this->id_kebutuhan_khusus_mahasiswa->ViewValue = $this->id_kebutuhan_khusus_mahasiswa->CurrentValue;
			$this->id_kebutuhan_khusus_mahasiswa->ViewValue = FormatNumber($this->id_kebutuhan_khusus_mahasiswa->ViewValue, 0, -2, -2, -2);
			$this->id_kebutuhan_khusus_mahasiswa->ViewCustomAttributes = "";

			// nisn
			$this->nisn->ViewValue = $this->nisn->CurrentValue;
			$this->nisn->ViewCustomAttributes = "";

			// MulaiKerja
			$this->MulaiKerja->ViewValue = $this->MulaiKerja->CurrentValue;
			$this->MulaiKerja->ViewValue = FormatDateTime($this->MulaiKerja->ViewValue, 0);
			$this->MulaiKerja->ViewCustomAttributes = "";

			// IdKlsKerjasama
			$this->IdKlsKerjasama->ViewValue = $this->IdKlsKerjasama->CurrentValue;
			$this->IdKlsKerjasama->ViewValue = FormatNumber($this->IdKlsKerjasama->ViewValue, 0, -2, -2, -2);
			$this->IdKlsKerjasama->ViewCustomAttributes = "";

			// IDBeasiswa
			$this->IDBeasiswa->ViewValue = $this->IDBeasiswa->CurrentValue;
			$this->IDBeasiswa->ViewValue = FormatNumber($this->IDBeasiswa->ViewValue, 0, -2, -2, -2);
			$this->IDBeasiswa->ViewCustomAttributes = "";

			// Gelombang
			$this->Gelombang->ViewValue = $this->Gelombang->CurrentValue;
			$this->Gelombang->ViewCustomAttributes = "";

			// iddesa
			$this->iddesa->ViewValue = $this->iddesa->CurrentValue;
			$this->iddesa->ViewValue = FormatNumber($this->iddesa->ViewValue, 0, -2, -2, -2);
			$this->iddesa->ViewCustomAttributes = "";

			// tglKonversi
			$this->tglKonversi->ViewValue = $this->tglKonversi->CurrentValue;
			$this->tglKonversi->ViewValue = FormatDateTime($this->tglKonversi->ViewValue, 0);
			$this->tglKonversi->ViewCustomAttributes = "";

			// NoSuratKonversi
			$this->NoSuratKonversi->ViewValue = $this->NoSuratKonversi->CurrentValue;
			$this->NoSuratKonversi->ViewCustomAttributes = "";

			// Nopen
			$this->Nopen->ViewValue = $this->Nopen->CurrentValue;
			$this->Nopen->ViewValue = FormatNumber($this->Nopen->ViewValue, 0, -2, -2, -2);
			$this->Nopen->ViewCustomAttributes = "";

			// Nama_Mhs
			$this->Nama_Mhs->LinkCustomAttributes = "";
			$this->Nama_Mhs->HrefValue = "";
			$this->Nama_Mhs->TooltipValue = "";

			// Tmp_Lahir
			$this->Tmp_Lahir->LinkCustomAttributes = "";
			$this->Tmp_Lahir->HrefValue = "";
			$this->Tmp_Lahir->TooltipValue = "";

			// Tgl_Lahir
			$this->Tgl_Lahir->LinkCustomAttributes = "";
			$this->Tgl_Lahir->HrefValue = "";
			$this->Tgl_Lahir->TooltipValue = "";

			// tglmasuk
			$this->tglmasuk->LinkCustomAttributes = "";
			$this->tglmasuk->HrefValue = "";
			$this->tglmasuk->TooltipValue = "";

			// TaMasuk
			$this->TaMasuk->LinkCustomAttributes = "";
			$this->TaMasuk->HrefValue = "";
			$this->TaMasuk->TooltipValue = "";

			// PerMasuk
			$this->PerMasuk->LinkCustomAttributes = "";
			$this->PerMasuk->HrefValue = "";
			$this->PerMasuk->TooltipValue = "";

			// Status
			$this->Status->LinkCustomAttributes = "";
			$this->Status->HrefValue = "";
			$this->Status->TooltipValue = "";

			// NIK
			$this->NIK->LinkCustomAttributes = "";
			$this->NIK->HrefValue = "";
			$this->NIK->TooltipValue = "";

			// NamaIbu
			$this->NamaIbu->LinkCustomAttributes = "";
			$this->NamaIbu->HrefValue = "";
			$this->NamaIbu->TooltipValue = "";

			// Nopen
			$this->Nopen->LinkCustomAttributes = "";
			$this->Nopen->HrefValue = "";
			$this->Nopen->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_EDIT) { // Edit row

			// Nama_Mhs
			$this->Nama_Mhs->EditAttrs["class"] = "form-control";
			$this->Nama_Mhs->EditCustomAttributes = "";
			if (!$this->Nama_Mhs->Raw)
				$this->Nama_Mhs->CurrentValue = HtmlDecode($this->Nama_Mhs->CurrentValue);
			$this->Nama_Mhs->EditValue = HtmlEncode($this->Nama_Mhs->CurrentValue);
			$this->Nama_Mhs->PlaceHolder = RemoveHtml($this->Nama_Mhs->caption());

			// Tmp_Lahir
			$this->Tmp_Lahir->EditAttrs["class"] = "form-control";
			$this->Tmp_Lahir->EditCustomAttributes = "";
			if (!$this->Tmp_Lahir->Raw)
				$this->Tmp_Lahir->CurrentValue = HtmlDecode($this->Tmp_Lahir->CurrentValue);
			$this->Tmp_Lahir->EditValue = HtmlEncode($this->Tmp_Lahir->CurrentValue);
			$this->Tmp_Lahir->PlaceHolder = RemoveHtml($this->Tmp_Lahir->caption());

			// Tgl_Lahir
			$this->Tgl_Lahir->EditAttrs["class"] = "form-control";
			$this->Tgl_Lahir->EditCustomAttributes = "";
			$this->Tgl_Lahir->EditValue = HtmlEncode(FormatDateTime($this->Tgl_Lahir->CurrentValue, 8));
			$this->Tgl_Lahir->PlaceHolder = RemoveHtml($this->Tgl_Lahir->caption());

			// tglmasuk
			$this->tglmasuk->EditAttrs["class"] = "form-control";
			$this->tglmasuk->EditCustomAttributes = "";
			$this->tglmasuk->EditValue = HtmlEncode(FormatDateTime($this->tglmasuk->CurrentValue, 7));
			$this->tglmasuk->PlaceHolder = RemoveHtml($this->tglmasuk->caption());

			// TaMasuk
			$this->TaMasuk->EditAttrs["class"] = "form-control";
			$this->TaMasuk->EditCustomAttributes = "";
			if (!$this->TaMasuk->Raw)
				$this->TaMasuk->CurrentValue = HtmlDecode($this->TaMasuk->CurrentValue);
			$this->TaMasuk->EditValue = HtmlEncode($this->TaMasuk->CurrentValue);
			$this->TaMasuk->PlaceHolder = RemoveHtml($this->TaMasuk->caption());

			// PerMasuk
			$this->PerMasuk->EditAttrs["class"] = "form-control";
			$this->PerMasuk->EditCustomAttributes = "";
			if (!$this->PerMasuk->Raw)
				$this->PerMasuk->CurrentValue = HtmlDecode($this->PerMasuk->CurrentValue);
			$this->PerMasuk->EditValue = HtmlEncode($this->PerMasuk->CurrentValue);
			$this->PerMasuk->PlaceHolder = RemoveHtml($this->PerMasuk->caption());

			// Status
			$this->Status->EditAttrs["class"] = "form-control";
			$this->Status->EditCustomAttributes = "";
			$this->Status->EditValue = $this->Status->options(TRUE);

			// NIK
			$this->NIK->EditAttrs["class"] = "form-control";
			$this->NIK->EditCustomAttributes = "";
			if (!$this->NIK->Raw)
				$this->NIK->CurrentValue = HtmlDecode($this->NIK->CurrentValue);
			$this->NIK->EditValue = HtmlEncode($this->NIK->CurrentValue);
			$this->NIK->PlaceHolder = RemoveHtml($this->NIK->caption());

			// NamaIbu
			$this->NamaIbu->EditAttrs["class"] = "form-control";
			$this->NamaIbu->EditCustomAttributes = "";
			if (!$this->NamaIbu->Raw)
				$this->NamaIbu->CurrentValue = HtmlDecode($this->NamaIbu->CurrentValue);
			$this->NamaIbu->EditValue = HtmlEncode($this->NamaIbu->CurrentValue);
			$this->NamaIbu->PlaceHolder = RemoveHtml($this->NamaIbu->caption());

			// Nopen
			$this->Nopen->EditAttrs["class"] = "form-control";
			$this->Nopen->EditCustomAttributes = "";
			$this->Nopen->EditValue = HtmlEncode($this->Nopen->CurrentValue);
			$this->Nopen->PlaceHolder = RemoveHtml($this->Nopen->caption());

			// Edit refer script
			// Nama_Mhs

			$this->Nama_Mhs->LinkCustomAttributes = "";
			$this->Nama_Mhs->HrefValue = "";

			// Tmp_Lahir
			$this->Tmp_Lahir->LinkCustomAttributes = "";
			$this->Tmp_Lahir->HrefValue = "";

			// Tgl_Lahir
			$this->Tgl_Lahir->LinkCustomAttributes = "";
			$this->Tgl_Lahir->HrefValue = "";

			// tglmasuk
			$this->tglmasuk->LinkCustomAttributes = "";
			$this->tglmasuk->HrefValue = "";

			// TaMasuk
			$this->TaMasuk->LinkCustomAttributes = "";
			$this->TaMasuk->HrefValue = "";

			// PerMasuk
			$this->PerMasuk->LinkCustomAttributes = "";
			$this->PerMasuk->HrefValue = "";

			// Status
			$this->Status->LinkCustomAttributes = "";
			$this->Status->HrefValue = "";

			// NIK
			$this->NIK->LinkCustomAttributes = "";
			$this->NIK->HrefValue = "";

			// NamaIbu
			$this->NamaIbu->LinkCustomAttributes = "";
			$this->NamaIbu->HrefValue = "";

			// Nopen
			$this->Nopen->LinkCustomAttributes = "";
			$this->Nopen->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType != ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!Config("SERVER_VALIDATE"))
			return ($FormError == "");
		if ($this->Nama_Mhs->Required) {
			if (!$this->Nama_Mhs->IsDetailKey && $this->Nama_Mhs->FormValue != NULL && $this->Nama_Mhs->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Nama_Mhs->caption(), $this->Nama_Mhs->RequiredErrorMessage));
			}
		}
		if ($this->Tmp_Lahir->Required) {
			if (!$this->Tmp_Lahir->IsDetailKey && $this->Tmp_Lahir->FormValue != NULL && $this->Tmp_Lahir->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Tmp_Lahir->caption(), $this->Tmp_Lahir->RequiredErrorMessage));
			}
		}
		if ($this->Tgl_Lahir->Required) {
			if (!$this->Tgl_Lahir->IsDetailKey && $this->Tgl_Lahir->FormValue != NULL && $this->Tgl_Lahir->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Tgl_Lahir->caption(), $this->Tgl_Lahir->RequiredErrorMessage));
			}
		}
		if (!CheckDate($this->Tgl_Lahir->FormValue)) {
			AddMessage($FormError, $this->Tgl_Lahir->errorMessage());
		}
		if ($this->tglmasuk->Required) {
			if (!$this->tglmasuk->IsDetailKey && $this->tglmasuk->FormValue != NULL && $this->tglmasuk->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->tglmasuk->caption(), $this->tglmasuk->RequiredErrorMessage));
			}
		}
		if (!CheckEuroDate($this->tglmasuk->FormValue)) {
			AddMessage($FormError, $this->tglmasuk->errorMessage());
		}
		if ($this->TaMasuk->Required) {
			if (!$this->TaMasuk->IsDetailKey && $this->TaMasuk->FormValue != NULL && $this->TaMasuk->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->TaMasuk->caption(), $this->TaMasuk->RequiredErrorMessage));
			}
		}
		if ($this->PerMasuk->Required) {
			if (!$this->PerMasuk->IsDetailKey && $this->PerMasuk->FormValue != NULL && $this->PerMasuk->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->PerMasuk->caption(), $this->PerMasuk->RequiredErrorMessage));
			}
		}
		if ($this->Status->Required) {
			if (!$this->Status->IsDetailKey && $this->Status->FormValue != NULL && $this->Status->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Status->caption(), $this->Status->RequiredErrorMessage));
			}
		}
		if ($this->NIK->Required) {
			if (!$this->NIK->IsDetailKey && $this->NIK->FormValue != NULL && $this->NIK->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->NIK->caption(), $this->NIK->RequiredErrorMessage));
			}
		}
		if ($this->NamaIbu->Required) {
			if (!$this->NamaIbu->IsDetailKey && $this->NamaIbu->FormValue != NULL && $this->NamaIbu->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->NamaIbu->caption(), $this->NamaIbu->RequiredErrorMessage));
			}
		}
		if ($this->Nopen->Required) {
			if (!$this->Nopen->IsDetailKey && $this->Nopen->FormValue != NULL && $this->Nopen->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Nopen->caption(), $this->Nopen->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->Nopen->FormValue)) {
			AddMessage($FormError, $this->Nopen->errorMessage());
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError != "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Update record based on key values
	protected function editRow()
	{
		global $Security, $Language;
		$oldKeyFilter = $this->getRecordFilter();
		$filter = $this->applyUserIDFilters($oldKeyFilter);
		$conn = $this->getConnection();
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn->raiseErrorFn = Config("ERROR_FUNC");
		$rs = $conn->execute($sql);
		$conn->raiseErrorFn = "";
		if ($rs === FALSE)
			return FALSE;
		if ($rs->EOF) {
			$this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
			$editRow = FALSE; // Update Failed
		} else {

			// Save old values
			$rsold = &$rs->fields;
			$this->loadDbValues($rsold);
			$rsnew = [];

			// Nama_Mhs
			$this->Nama_Mhs->setDbValueDef($rsnew, $this->Nama_Mhs->CurrentValue, NULL, $this->Nama_Mhs->ReadOnly);

			// Tmp_Lahir
			$this->Tmp_Lahir->setDbValueDef($rsnew, $this->Tmp_Lahir->CurrentValue, NULL, $this->Tmp_Lahir->ReadOnly);

			// Tgl_Lahir
			$this->Tgl_Lahir->setDbValueDef($rsnew, UnFormatDateTime($this->Tgl_Lahir->CurrentValue, 0), NULL, $this->Tgl_Lahir->ReadOnly);

			// tglmasuk
			$this->tglmasuk->setDbValueDef($rsnew, UnFormatDateTime($this->tglmasuk->CurrentValue, 7), NULL, $this->tglmasuk->ReadOnly);

			// TaMasuk
			$this->TaMasuk->setDbValueDef($rsnew, $this->TaMasuk->CurrentValue, NULL, $this->TaMasuk->ReadOnly);

			// PerMasuk
			$this->PerMasuk->setDbValueDef($rsnew, $this->PerMasuk->CurrentValue, NULL, $this->PerMasuk->ReadOnly);

			// Status
			$this->Status->setDbValueDef($rsnew, $this->Status->CurrentValue, NULL, $this->Status->ReadOnly);

			// NIK
			$this->NIK->setDbValueDef($rsnew, $this->NIK->CurrentValue, NULL, $this->NIK->ReadOnly);

			// NamaIbu
			$this->NamaIbu->setDbValueDef($rsnew, $this->NamaIbu->CurrentValue, NULL, $this->NamaIbu->ReadOnly);

			// Nopen
			$this->Nopen->setDbValueDef($rsnew, $this->Nopen->CurrentValue, NULL, $this->Nopen->ReadOnly);

			// Call Row Updating event
			$updateRow = $this->Row_Updating($rsold, $rsnew);

			// Check for duplicate key when key changed
			if ($updateRow) {
				$newKeyFilter = $this->getRecordFilter($rsnew);
				if ($newKeyFilter != $oldKeyFilter) {
					$rsChk = $this->loadRs($newKeyFilter);
					if ($rsChk && !$rsChk->EOF) {
						$keyErrMsg = str_replace("%f", $newKeyFilter, $Language->phrase("DupKey"));
						$this->setFailureMessage($keyErrMsg);
						$rsChk->close();
						$updateRow = FALSE;
					}
				}
			}
			if ($updateRow) {
				$conn->raiseErrorFn = Config("ERROR_FUNC");
				if (count($rsnew) > 0)
					$editRow = $this->update($rsnew, "", $rsold);
				else
					$editRow = TRUE; // No field to update
				$conn->raiseErrorFn = "";
				if ($editRow) {
				}
			} else {
				if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {

					// Use the message, do nothing
				} elseif ($this->CancelMessage != "") {
					$this->setFailureMessage($this->CancelMessage);
					$this->CancelMessage = "";
				} else {
					$this->setFailureMessage($Language->phrase("UpdateCancelled"));
				}
				$editRow = FALSE;
			}
		}

		// Call Row_Updated event
		if ($editRow)
			$this->Row_Updated($rsold, $rsnew);
		$rs->close();

		// Clean upload path if any
		if ($editRow) {
		}

		// Write JSON for API request
		if (IsApi() && $editRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $editRow;
	}

	// Set up master/detail based on QueryString
	protected function setupMasterParms()
	{
		$validMaster = FALSE;

		// Get the keys for master table
		if (($master = Get(Config("TABLE_SHOW_MASTER"), Get(Config("TABLE_MASTER")))) !== NULL) {
			$masterTblVar = $master;
			if ($masterTblVar == "") {
				$validMaster = TRUE;
				$this->DbMasterFilter = "";
				$this->DbDetailFilter = "";
			}
			if ($masterTblVar == "ekpt_mhsfeed") {
				$validMaster = TRUE;
				if (($parm = Get("fk_NimIM", Get("Nim"))) !== NULL) {
					$GLOBALS["ekpt_mhsfeed"]->NimIM->setQueryStringValue($parm);
					$this->Nim->setQueryStringValue($GLOBALS["ekpt_mhsfeed"]->NimIM->QueryStringValue);
					$this->Nim->setSessionValue($this->Nim->QueryStringValue);
				} else {
					$validMaster = FALSE;
				}
			}
		} elseif (($master = Post(Config("TABLE_SHOW_MASTER"), Post(Config("TABLE_MASTER")))) !== NULL) {
			$masterTblVar = $master;
			if ($masterTblVar == "") {
				$validMaster = TRUE;
				$this->DbMasterFilter = "";
				$this->DbDetailFilter = "";
			}
			if ($masterTblVar == "ekpt_mhsfeed") {
				$validMaster = TRUE;
				if (($parm = Post("fk_NimIM", Post("Nim"))) !== NULL) {
					$GLOBALS["ekpt_mhsfeed"]->NimIM->setFormValue($parm);
					$this->Nim->setFormValue($GLOBALS["ekpt_mhsfeed"]->NimIM->FormValue);
					$this->Nim->setSessionValue($this->Nim->FormValue);
				} else {
					$validMaster = FALSE;
				}
			}
		}
		if ($validMaster) {

			// Save current master table
			$this->setCurrentMasterTable($masterTblVar);
			$this->setSessionWhere($this->getDetailFilter());

			// Reset start record counter (new master key)
			if (!$this->isAddOrEdit()) {
				$this->StartRecord = 1;
				$this->setStartRecordNumber($this->StartRecord);
			}

			// Clear previous master key from Session
			if ($masterTblVar != "ekpt_mhsfeed") {
				if ($this->Nim->CurrentValue == "")
					$this->Nim->setSessionValue("");
			}
		}
		$this->DbMasterFilter = $this->getMasterFilter(); // Get master filter
		$this->DbDetailFilter = $this->getDetailFilter(); // Get detail filter
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("tblMHSEkptlist.php"), "", $this->TableVar, TRUE);
		$pageId = "edit";
		$Breadcrumb->add("edit", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// Get default connection and filter
			$conn = $this->getConnection();
			$lookupFilter = "";

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL and connection
			switch ($fld->FieldVar) {
				case "x_Status":
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0) {
				$totalCnt = $this->getRecordCount($sql, $conn);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Set up starting record parameters
	public function setupStartRecord()
	{
		if ($this->DisplayRecords == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			$startRec = Get(Config("TABLE_START_REC"));
			$pageNo = Get(Config("TABLE_PAGE_NO"));
			if ($pageNo !== NULL) { // Check for "pageno" parameter first
				if (is_numeric($pageNo)) {
					$this->StartRecord = ($pageNo - 1) * $this->DisplayRecords + 1;
					if ($this->StartRecord <= 0) {
						$this->StartRecord = 1;
					} elseif ($this->StartRecord >= (int)(($this->TotalRecords - 1)/$this->DisplayRecords) * $this->DisplayRecords + 1) {
						$this->StartRecord = (int)(($this->TotalRecords - 1)/$this->DisplayRecords) * $this->DisplayRecords + 1;
					}
					$this->setStartRecordNumber($this->StartRecord);
				}
			} elseif ($startRec !== NULL) { // Check for "start" parameter
				$this->StartRecord = $startRec;
				$this->setStartRecordNumber($this->StartRecord);
			}
		}
		$this->StartRecord = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRecord) || $this->StartRecord == "") { // Avoid invalid start record counter
			$this->StartRecord = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRecord);
		} elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
			$this->StartRecord = (int)(($this->TotalRecords - 1)/$this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRecord);
		} elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
			$this->StartRecord = (int)(($this->StartRecord - 1)/$this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRecord);
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
} // End class
?>