<?php
namespace PHPMaker2020\baak;

/**
 * Page class
 */
class tblMHSEkpt_list extends tblMHSEkpt
{

	// Page ID
	public $PageID = "list";

	// Project ID
	public $ProjectID = "{A09D3AFF-419C-4918-948A-A3C8469EA234}";

	// Table name
	public $TableName = 'tblMHSEkpt';

	// Page object name
	public $PageObjName = "tblMHSEkpt_list";

	// Grid form hidden field names
	public $FormName = "ftblMHSEkptlist";
	public $FormActionName = "k_action";
	public $FormKeyName = "k_key";
	public $FormOldKeyName = "k_oldkey";
	public $FormBlankRowName = "k_blankrow";
	public $FormKeyCountName = "key_count";

	// Page URLs
	public $AddUrl;
	public $EditUrl;
	public $CopyUrl;
	public $DeleteUrl;
	public $ViewUrl;
	public $ListUrl;

	// Export URLs
	public $ExportPrintUrl;
	public $ExportHtmlUrl;
	public $ExportExcelUrl;
	public $ExportWordUrl;
	public $ExportXmlUrl;
	public $ExportCsvUrl;
	public $ExportPdfUrl;

	// Custom export
	public $ExportExcelCustom = FALSE;
	public $ExportWordCustom = FALSE;
	public $ExportPdfCustom = FALSE;
	public $ExportEmailCustom = FALSE;

	// Update URLs
	public $InlineAddUrl;
	public $InlineCopyUrl;
	public $InlineEditUrl;
	public $GridAddUrl;
	public $GridEditUrl;
	public $MultiDeleteUrl;
	public $MultiUpdateUrl;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken;

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading != "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading != "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		$url = CurrentPageName() . "?";
		if ($this->UseTokenInUrl)
			$url .= "t=" . $this->TableVar . "&"; // Add page token
		return $url;
	}

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = TRUE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message != "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fas fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage != "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fas fa-exclamation"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage != "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fas fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage != "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fas fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = [];

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message != "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage != "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage != "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage != "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header != "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer != "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(Config("TOKEN_NAME")) === NULL)
			return FALSE;
		$fn = Config("CHECK_TOKEN_FUNC");
		if (is_callable($fn))
			return $fn(Post(Config("TOKEN_NAME")), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = Config("CREATE_TOKEN_FUNC"); // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $DashboardReport;
		global $UserTable;

		// Check token
		$this->CheckToken = Config("CHECK_TOKEN");

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (tblMHSEkpt)
		if (!isset($GLOBALS["tblMHSEkpt"]) || get_class($GLOBALS["tblMHSEkpt"]) == PROJECT_NAMESPACE . "tblMHSEkpt") {
			$GLOBALS["tblMHSEkpt"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["tblMHSEkpt"];
		}

		// Initialize URLs
		$this->ExportPrintUrl = $this->pageUrl() . "export=print";
		$this->ExportExcelUrl = $this->pageUrl() . "export=excel";
		$this->ExportWordUrl = $this->pageUrl() . "export=word";
		$this->ExportPdfUrl = $this->pageUrl() . "export=pdf";
		$this->ExportHtmlUrl = $this->pageUrl() . "export=html";
		$this->ExportXmlUrl = $this->pageUrl() . "export=xml";
		$this->ExportCsvUrl = $this->pageUrl() . "export=csv";
		$this->AddUrl = "tblMHSEkptadd.php";
		$this->InlineAddUrl = $this->pageUrl() . "action=add";
		$this->GridAddUrl = $this->pageUrl() . "action=gridadd";
		$this->GridEditUrl = $this->pageUrl() . "action=gridedit";
		$this->MultiDeleteUrl = "tblMHSEkptdelete.php";
		$this->MultiUpdateUrl = "tblMHSEkptupdate.php";

		// Table object (Pass)
		if (!isset($GLOBALS['Pass']))
			$GLOBALS['Pass'] = new Pass();

		// Table object (ekpt_mhsfeed)
		if (!isset($GLOBALS['ekpt_mhsfeed']))
			$GLOBALS['ekpt_mhsfeed'] = new ekpt_mhsfeed();

		// Page ID (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'list');

		// Table name (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'tblMHSEkpt');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = $this->getConnection();

		// User table object (Pass)
		$UserTable = $UserTable ?: new Pass();

		// List options
		$this->ListOptions = new ListOptions();
		$this->ListOptions->TableVar = $this->TableVar;

		// Export options
		$this->ExportOptions = new ListOptions("div");
		$this->ExportOptions->TagClassName = "ew-export-option";

		// Import options
		$this->ImportOptions = new ListOptions("div");
		$this->ImportOptions->TagClassName = "ew-import-option";

		// Other options
		if (!$this->OtherOptions)
			$this->OtherOptions = new ListOptionsArray();
		$this->OtherOptions["addedit"] = new ListOptions("div");
		$this->OtherOptions["addedit"]->TagClassName = "ew-add-edit-option";
		$this->OtherOptions["detail"] = new ListOptions("div");
		$this->OtherOptions["detail"]->TagClassName = "ew-detail-option";
		$this->OtherOptions["action"] = new ListOptions("div");
		$this->OtherOptions["action"]->TagClassName = "ew-action-option";

		// Filter options
		$this->FilterOptions = new ListOptions("div");
		$this->FilterOptions->TagClassName = "ew-filter-option ftblMHSEkptlistsrch";

		// List actions
		$this->ListActions = new ListActions();
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages, $DashboardReport;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $tblMHSEkpt;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, Config("EXPORT_CLASSES"))) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . Config("EXPORT_CLASSES." . $this->CustomExport);
			if (class_exists($class)) {
				$doc = new $class($tblMHSEkpt);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url != "") {
			if (!Config("DEBUG") && ob_get_length())
				ob_end_clean();
			SaveDebugMessage();
			AddHeader("Location", $url);
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = [];
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = [];
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {
								$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
									Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
									Config("API_FIELD_NAME") . "=" . $fld->Param . "&" .
									Config("API_KEY_NAME") . "=" . rawurlencode($this->getRecordKeyValue($ar)))); //*** need to add this? API may not be in the same folder
								$row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
								$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
									Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
									"fn=" . Encrypt($fld->physicalUploadPath() . $val)));
								$row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
							} else { // Multiple files
								$files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
								$ar = [];
								foreach ($files as $file) {
									$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
										Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
										"fn=" . Encrypt($fld->physicalUploadPath() . $file)));
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						if ($fld->DataType == DATATYPE_MEMO && $fld->MemoMaxLength > 0)
							$val = TruncateMemo($val, $fld->MemoMaxLength, $fld->TruncateMemoRemoveHtml);
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['Nim'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
	}

	// Lookup data
	public function lookup()
	{
		global $Language, $Security;
		if (!isset($Language))
			$Language = new Language(Config("LANGUAGE_FOLDER"), Post("language", ""));

		// Set up API request
		if (!ValidApiRequest())
			return FALSE;
		$this->setupApiSecurity();

		// Get lookup object
		$fieldName = Post("field");
		if (!array_key_exists($fieldName, $this->fields))
			return FALSE;
		$lookupField = $this->fields[$fieldName];
		$lookup = $lookupField->Lookup;
		if ($lookup === NULL)
			return FALSE;
		$tbl = $lookup->getTable();
		if (!$Security->allowLookup(Config("PROJECT_ID") . $tbl->TableName)) // Lookup permission
			return FALSE;

		// Get lookup parameters
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Param("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
			$lookup->FilterFields = []; // Skip parent fields if any
			$lookup->FilterValues[] = $keys; // Lookup values
			$pageSize = -1; // Show all records
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect != "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter != "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy != "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson($this); // Use settings from current page
	}

	// Set up API security
	public function setupApiSecurity()
	{
		global $Security;

		// Setup security for API request
		if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
		$Security->loadCurrentUserLevel(Config("PROJECT_ID") . $this->TableName);
		if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
	}

	// Class variables
	public $ListOptions; // List options
	public $ExportOptions; // Export options
	public $SearchOptions; // Search options
	public $OtherOptions; // Other options
	public $FilterOptions; // Filter options
	public $ImportOptions; // Import options
	public $ListActions; // List actions
	public $SelectedCount = 0;
	public $SelectedIndex = 0;
	public $DisplayRecords = 15;
	public $StartRecord;
	public $StopRecord;
	public $TotalRecords = 0;
	public $RecordRange = 10;
	public $PageSizes = "15,30,90,-1"; // Page sizes (comma separated)
	public $DefaultSearchWhere = ""; // Default search WHERE clause
	public $SearchWhere = ""; // Search WHERE clause
	public $SearchPanelClass = "ew-search-panel collapse show"; // Search Panel class
	public $SearchRowCount = 0; // For extended search
	public $SearchColumnCount = 0; // For extended search
	public $SearchFieldsPerRow = 1; // For extended search
	public $RecordCount = 0; // Record count
	public $EditRowCount;
	public $StartRowCount = 1;
	public $RowCount = 0;
	public $Attrs = []; // Row attributes and cell attributes
	public $RowIndex = 0; // Row index
	public $KeyCount = 0; // Key count
	public $RowAction = ""; // Row action
	public $RowOldKey = ""; // Row old key (for copy)
	public $MultiColumnClass = "col-sm";
	public $MultiColumnEditClass = "w-100";
	public $DbMasterFilter = ""; // Master filter
	public $DbDetailFilter = ""; // Detail filter
	public $MasterRecordExists;
	public $MultiSelectKey;
	public $Command;
	public $RestoreSearch = FALSE;
	public $DetailPages;
	public $OldRecordset;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $CurrentForm,
			$FormError, $SearchError;

		// User profile
		$UserProfile = new UserProfile();

		// Security
		if (ValidApiRequest()) { // API request
			$this->setupApiSecurity(); // Set up API Security
			if (!$Security->canList()) {
				SetStatus(401); // Unauthorized
				return;
			}
		} else {
			$Security = new AdvancedSecurity();
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canList()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				$this->terminate(GetUrl("index.php"));
				return;
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();

		// Get export parameters
		$custom = "";
		if (Param("export") !== NULL) {
			$this->Export = Param("export");
			$custom = Param("custom", "");
		} elseif (IsPost()) {
			if (Post("exporttype") !== NULL)
				$this->Export = Post("exporttype");
			$custom = Post("custom", "");
		} elseif (Get("cmd") == "json") {
			$this->Export = Get("cmd");
		} else {
			$this->setExportReturnUrl(CurrentUrl());
		}
		$ExportFileName = $this->TableVar; // Get export file, used in header

		// Get custom export parameters
		if ($this->isExport() && $custom != "") {
			$this->CustomExport = $this->Export;
			$this->Export = "print";
		}
		$CustomExportType = $this->CustomExport;
		$ExportType = $this->Export; // Get export parameter, used in header

		// Update Export URLs
		if (Config("USE_PHPEXCEL"))
			$this->ExportExcelCustom = FALSE;
		if ($this->ExportExcelCustom)
			$this->ExportExcelUrl .= "&amp;custom=1";
		if (Config("USE_PHPWORD"))
			$this->ExportWordCustom = FALSE;
		if ($this->ExportWordCustom)
			$this->ExportWordUrl .= "&amp;custom=1";
		if ($this->ExportPdfCustom)
			$this->ExportPdfUrl .= "&amp;custom=1";
		$this->CurrentAction = Param("action"); // Set up current action

		// Get grid add count
		$gridaddcnt = Get(Config("TABLE_GRID_ADD_ROW_COUNT"), "");
		if (is_numeric($gridaddcnt) && $gridaddcnt > 0)
			$this->GridAddRowCount = $gridaddcnt;

		// Set up list options
		$this->setupListOptions();

		// Setup export options
		$this->setupExportOptions();
		$this->Nim->setVisibility();
		$this->Nama_Mhs->setVisibility();
		$this->Kode_jp->Visible = FALSE;
		$this->Tmp_Lahir->Visible = FALSE;
		$this->Tgl_Lahir->Visible = FALSE;
		$this->Jenis_Kel->Visible = FALSE;
		$this->Gol_darah->Visible = FALSE;
		$this->Agama_Mhs->Visible = FALSE;
		$this->Alamat_Mhs->Visible = FALSE;
		$this->rt->Visible = FALSE;
		$this->rw->Visible = FALSE;
		$this->Kelurahan->Visible = FALSE;
		$this->Kecamatan->Visible = FALSE;
		$this->Kota_Mhs->Visible = FALSE;
		$this->Provinsi_mhs->Visible = FALSE;
		$this->Kodepos_Mhs->Visible = FALSE;
		$this->Tlp_Mhs->setVisibility();
		$this->TlpRumah->Visible = FALSE;
		$this->_Email->Visible = FALSE;
		$this->Status_Akd->setVisibility();
		$this->ThMasuk->Visible = FALSE;
		$this->tglmasuk->Visible = FALSE;
		$this->Status_Masuk->Visible = FALSE;
		$this->Sem_Masuk->Visible = FALSE;
		$this->TaMasuk->setVisibility();
		$this->PerMasuk->setVisibility();
		$this->Pendidikan_Akhir->Visible = FALSE;
		$this->Jurusan->Visible = FALSE;
		$this->Thn_Selesai->Visible = FALSE;
		$this->Kota_Pdkk->Visible = FALSE;
		$this->propinsi->Visible = FALSE;
		$this->NIMASAL->Visible = FALSE;
		$this->KPTSASAL->Visible = FALSE;
		$this->JENASAL->Visible = FALSE;
		$this->PSASAL->Visible = FALSE;
		$this->TSKSDIAKUI->Visible = FALSE;
		$this->NamaSekolahAsal->Visible = FALSE;
		$this->AlamatSekolahAsal->Visible = FALSE;
		$this->Status->setVisibility();
		$this->Photo->Visible = FALSE;
		$this->Password->Visible = FALSE;
		$this->JalurMasuk->Visible = FALSE;
		$this->Konsentrasi->Visible = FALSE;
		$this->NIK->Visible = FALSE;
		$this->NamaIbu->Visible = FALSE;
		$this->BekerjaDi->Visible = FALSE;
		$this->Lama->Visible = FALSE;
		$this->AlamatPerusahaan->Visible = FALSE;
		$this->TlpPerusahaan->Visible = FALSE;
		$this->Posisi->Visible = FALSE;
		$this->Departemen->Visible = FALSE;
		$this->IdUser->Visible = FALSE;
		$this->TempID->Visible = FALSE;
		$this->xphoto->Visible = FALSE;
		$this->profile->Visible = FALSE;
		$this->id_agama->Visible = FALSE;
		$this->id_negara->Visible = FALSE;
		$this->id_wilayah->Visible = FALSE;
		$this->id_jenis_tinggal->Visible = FALSE;
		$this->id_alat_transportasi->Visible = FALSE;
		$this->no_kps->Visible = FALSE;
		$this->penerima_kps->Visible = FALSE;
		$this->id_kebutuhan_khusus_mahasiswa->Visible = FALSE;
		$this->nisn->Visible = FALSE;
		$this->MulaiKerja->Visible = FALSE;
		$this->IdKlsKerjasama->Visible = FALSE;
		$this->IDBeasiswa->Visible = FALSE;
		$this->Gelombang->Visible = FALSE;
		$this->iddesa->Visible = FALSE;
		$this->tglKonversi->Visible = FALSE;
		$this->NoSuratKonversi->Visible = FALSE;
		$this->Nopen->Visible = FALSE;
		$this->hideFieldsForAddEdit();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up master detail parameters
		$this->setupMasterParms();

		// Setup other options
		$this->setupOtherOptions();

		// Set up custom action (compatible with old version)
		foreach ($this->CustomActions as $name => $action)
			$this->ListActions->add($name, $action);

		// Show checkbox column if multiple action
		foreach ($this->ListActions->Items as $listaction) {
			if ($listaction->Select == ACTION_MULTIPLE && $listaction->Allow) {
				$this->ListOptions["checkbox"]->Visible = TRUE;
				break;
			}
		}

		// Set up lookup cache
		// Search filters

		$srchAdvanced = ""; // Advanced search filter
		$srchBasic = ""; // Basic search filter
		$filter = "";

		// Get command
		$this->Command = strtolower(Get("cmd"));
		if ($this->isPageRequest()) { // Validate request

			// Process list action first
			if ($this->processListAction()) // Ajax request
				$this->terminate();

			// Set up records per page
			$this->setupDisplayRecords();

			// Handle reset command
			$this->resetCmd();

			// Set up Breadcrumb
			if (!$this->isExport())
				$this->setupBreadcrumb();

			// Check QueryString parameters
			if (Get("action") !== NULL) {
				$this->CurrentAction = Get("action");

				// Clear inline mode
				if ($this->isCancel())
					$this->clearInlineMode();

				// Switch to inline edit mode
				if ($this->isEdit())
					$this->inlineEditMode();
			} else {
				if (Post("action") !== NULL) {
					$this->CurrentAction = Post("action"); // Get action

					// Inline Update
					if (($this->isUpdate() || $this->isOverwrite()) && @$_SESSION[SESSION_INLINE_MODE] == "edit")
						$this->inlineUpdate();
				}
			}

			// Hide list options
			if ($this->isExport()) {
				$this->ListOptions->hideAllOptions(["sequence"]);
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			} elseif ($this->isGridAdd() || $this->isGridEdit()) {
				$this->ListOptions->hideAllOptions();
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			}

			// Hide options
			if ($this->isExport() || $this->CurrentAction) {
				$this->ExportOptions->hideAllOptions();
				$this->FilterOptions->hideAllOptions();
				$this->ImportOptions->hideAllOptions();
			}

			// Hide other options
			if ($this->isExport())
				$this->OtherOptions->hideAllOptions();

			// Set up sorting order
			$this->setupSortOrder();
		}

		// Restore display records
		if ($this->Command != "json" && $this->getRecordsPerPage() != "") {
			$this->DisplayRecords = $this->getRecordsPerPage(); // Restore from Session
		} else {
			$this->DisplayRecords = 15; // Load default
			$this->setRecordsPerPage($this->DisplayRecords); // Save default to Session
		}

		// Load Sorting Order
		if ($this->Command != "json")
			$this->loadSortOrder();

		// Build filter
		$filter = "";
		if (!$Security->canList())
			$filter = "(0=1)"; // Filter all records

		// Restore master/detail filter
		$this->DbMasterFilter = $this->getMasterFilter(); // Restore master filter
		$this->DbDetailFilter = $this->getDetailFilter(); // Restore detail filter
		AddFilter($filter, $this->DbDetailFilter);
		AddFilter($filter, $this->SearchWhere);

		// Load master record
		if ($this->CurrentMode != "add" && $this->getMasterFilter() != "" && $this->getCurrentMasterTable() == "ekpt_mhsfeed") {
			global $ekpt_mhsfeed;
			$rsmaster = $ekpt_mhsfeed->loadRs($this->DbMasterFilter);
			$this->MasterRecordExists = ($rsmaster && !$rsmaster->EOF);
			if (!$this->MasterRecordExists) {
				$this->setFailureMessage($Language->phrase("NoRecord")); // Set no record found
				$this->terminate("ekpt_mhsfeedlist.php"); // Return to master page
			} else {
				$ekpt_mhsfeed->loadListRowValues($rsmaster);
				$ekpt_mhsfeed->RowType = ROWTYPE_MASTER; // Master row
				$ekpt_mhsfeed->renderListRow();
				$rsmaster->close();
			}
		}

		// Set up filter
		if ($this->Command == "json") {
			$this->UseSessionForListSql = FALSE; // Do not use session for ListSQL
			$this->CurrentFilter = $filter;
		} else {
			$this->setSessionWhere($filter);
			$this->CurrentFilter = "";
		}

		// Export data only
		if (!$this->CustomExport && in_array($this->Export, array_keys(Config("EXPORT_CLASSES")))) {
			$this->exportData();
			$this->terminate();
		}
		if ($this->isGridAdd()) {
			$this->CurrentFilter = "0=1";
			$this->StartRecord = 1;
			$this->DisplayRecords = $this->GridAddRowCount;
			$this->TotalRecords = $this->DisplayRecords;
			$this->StopRecord = $this->DisplayRecords;
		} else {
			$selectLimit = $this->UseSelectLimit;
			if ($selectLimit) {
				$this->TotalRecords = $this->listRecordCount();
			} else {
				if ($this->Recordset = $this->loadRecordset())
					$this->TotalRecords = $this->Recordset->RecordCount();
			}
			$this->StartRecord = 1;
			if ($this->DisplayRecords <= 0 || ($this->isExport() && $this->ExportAll)) // Display all records
				$this->DisplayRecords = $this->TotalRecords;
			if (!($this->isExport() && $this->ExportAll)) // Set up start record position
				$this->setupStartRecord();
			if ($selectLimit)
				$this->Recordset = $this->loadRecordset($this->StartRecord - 1, $this->DisplayRecords);

			// Set no record found message
			if (!$this->CurrentAction && $this->TotalRecords == 0) {
				if (!$Security->canList())
					$this->setWarningMessage(DeniedMessage());
				if ($this->SearchWhere == "0=101")
					$this->setWarningMessage($Language->phrase("EnterSearchCriteria"));
				else
					$this->setWarningMessage($Language->phrase("NoRecord"));
			}
		}

		// Search options
		$this->setupSearchOptions();

		// Set up search panel class
		if ($this->SearchWhere != "")
			AppendClass($this->SearchPanelClass, "show");

		// Normal return
		if (IsApi()) {
			$rows = $this->getRecordsFromRecordset($this->Recordset);
			$this->Recordset->close();
			WriteJson(["success" => TRUE, $this->TableVar => $rows, "totalRecordCount" => $this->TotalRecords]);
			$this->terminate(TRUE);
		}

		// Set up pager
		$this->Pager = new PrevNextPager($this->StartRecord, $this->getRecordsPerPage(), $this->TotalRecords, $this->PageSizes, $this->RecordRange, $this->AutoHidePager, $this->AutoHidePageSizeSelector);
	}

	// Set up number of records displayed per page
	protected function setupDisplayRecords()
	{
		$wrk = Get(Config("TABLE_REC_PER_PAGE"), "");
		if ($wrk != "") {
			if (is_numeric($wrk)) {
				$this->DisplayRecords = (int)$wrk;
			} else {
				if (SameText($wrk, "all")) { // Display all records
					$this->DisplayRecords = -1;
				} else {
					$this->DisplayRecords = 15; // Non-numeric, load default
				}
			}
			$this->setRecordsPerPage($this->DisplayRecords); // Save to Session

			// Reset start position
			$this->StartRecord = 1;
			$this->setStartRecordNumber($this->StartRecord);
		}
	}

	// Exit inline mode
	protected function clearInlineMode()
	{
		$this->setKey("Nim", ""); // Clear inline edit key
		$this->LastAction = $this->CurrentAction; // Save last action
		$this->CurrentAction = ""; // Clear action
		$_SESSION[SESSION_INLINE_MODE] = ""; // Clear inline mode
	}

	// Switch to Inline Edit mode
	protected function inlineEditMode()
	{
		global $Security, $Language;
		if (!$Security->canEdit())
			return FALSE; // Edit not allowed
		$inlineEdit = TRUE;
		if (Get("Nim") !== NULL) {
			$this->Nim->setQueryStringValue(Get("Nim"));
		} else {
			$inlineEdit = FALSE;
		}
		if ($inlineEdit) {
			if ($this->loadRow()) {
				$this->setKey("Nim", $this->Nim->CurrentValue); // Set up inline edit key
				$_SESSION[SESSION_INLINE_MODE] = "edit"; // Enable inline edit
			}
		}
		return TRUE;
	}

	// Perform update to Inline Edit record
	protected function inlineUpdate()
	{
		global $Language, $CurrentForm, $FormError;
		$CurrentForm->Index = 1;
		$this->loadFormValues(); // Get form values

		// Validate form
		$inlineUpdate = TRUE;
		if (!$this->validateForm()) {
			$inlineUpdate = FALSE; // Form error, reset action
			$this->setFailureMessage($FormError);
		} else {
			$inlineUpdate = FALSE;
			$rowkey = strval($CurrentForm->getValue($this->FormKeyName));
			if ($this->setupKeyValues($rowkey)) { // Set up key values
				if ($this->checkInlineEditKey()) { // Check key
					$this->SendEmail = TRUE; // Send email on update success
					$inlineUpdate = $this->editRow(); // Update record
				} else {
					$inlineUpdate = FALSE;
				}
			}
		}
		if ($inlineUpdate) { // Update success
			if ($this->getSuccessMessage() == "")
				$this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Set up success message
			$this->clearInlineMode(); // Clear inline edit mode
		} else {
			if ($this->getFailureMessage() == "")
				$this->setFailureMessage($Language->phrase("UpdateFailed")); // Set update failed message
			$this->EventCancelled = TRUE; // Cancel event
			$this->CurrentAction = "edit"; // Stay in edit mode
		}
	}

	// Check Inline Edit key
	public function checkInlineEditKey()
	{
		if ($this->EventCancelled)
			$this->Nim->OldValue = $this->Nim->DbValue;
		$val = $this->Nim->OldValue !== NULL ? $this->Nim->OldValue : $this->Nim->CurrentValue;
		if (strval($this->getKey("Nim")) != strval($val))
			return FALSE;
		return TRUE;
	}

	// Build filter for all keys
	protected function buildKeyFilter()
	{
		global $CurrentForm;
		$wrkFilter = "";

		// Update row index and get row key
		$rowindex = 1;
		$CurrentForm->Index = $rowindex;
		$thisKey = strval($CurrentForm->getValue($this->FormKeyName));
		while ($thisKey != "") {
			if ($this->setupKeyValues($thisKey)) {
				$filter = $this->getRecordFilter();
				if ($wrkFilter != "")
					$wrkFilter .= " OR ";
				$wrkFilter .= $filter;
			} else {
				$wrkFilter = "0=1";
				break;
			}

			// Update row index and get row key
			$rowindex++; // Next row
			$CurrentForm->Index = $rowindex;
			$thisKey = strval($CurrentForm->getValue($this->FormKeyName));
		}
		return $wrkFilter;
	}

	// Set up key values
	protected function setupKeyValues($key)
	{
		$arKeyFlds = explode(Config("COMPOSITE_KEY_SEPARATOR"), $key);
		if (count($arKeyFlds) >= 1) {
			$this->Nim->setOldValue($arKeyFlds[0]);
		}
		return TRUE;
	}

	// Set up sort parameters
	protected function setupSortOrder()
	{

		// Check for "order" parameter
		if (Get("order") !== NULL) {
			$this->CurrentOrder = Get("order");
			$this->CurrentOrderType = Get("ordertype", "");
			$this->updateSort($this->Nim); // Nim
			$this->updateSort($this->Nama_Mhs); // Nama_Mhs
			$this->updateSort($this->Tlp_Mhs); // Tlp_Mhs
			$this->updateSort($this->Status_Akd); // Status_Akd
			$this->updateSort($this->TaMasuk); // TaMasuk
			$this->updateSort($this->PerMasuk); // PerMasuk
			$this->updateSort($this->Status); // Status
			$this->setStartRecordNumber(1); // Reset start position
		}
	}

	// Load sort order parameters
	protected function loadSortOrder()
	{
		$orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
		if ($orderBy == "") {
			if ($this->getSqlOrderBy() != "") {
				$orderBy = $this->getSqlOrderBy();
				$this->setSessionOrderBy($orderBy);
			}
		}
	}

	// Reset command
	// - cmd=reset (Reset search parameters)
	// - cmd=resetall (Reset search and master/detail parameters)
	// - cmd=resetsort (Reset sort parameters)

	protected function resetCmd()
	{

		// Check if reset command
		if (StartsString("reset", $this->Command)) {

			// Reset master/detail keys
			if ($this->Command == "resetall") {
				$this->setCurrentMasterTable(""); // Clear master table
				$this->DbMasterFilter = "";
				$this->DbDetailFilter = "";
				$this->Nim->setSessionValue("");
			}

			// Reset sorting order
			if ($this->Command == "resetsort") {
				$orderBy = "";
				$this->setSessionOrderBy($orderBy);
				$this->Nim->setSort("");
				$this->Nama_Mhs->setSort("");
				$this->Tlp_Mhs->setSort("");
				$this->Status_Akd->setSort("");
				$this->TaMasuk->setSort("");
				$this->PerMasuk->setSort("");
				$this->Status->setSort("");
			}

			// Reset start position
			$this->StartRecord = 1;
			$this->setStartRecordNumber($this->StartRecord);
		}
	}

	// Set up list options
	protected function setupListOptions()
	{
		global $Security, $Language;

		// Add group option item
		$item = &$this->ListOptions->add($this->ListOptions->GroupOptionName);
		$item->Body = "";
		$item->OnLeft = TRUE;
		$item->Visible = FALSE;

		// "edit"
		$item = &$this->ListOptions->add("edit");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->canEdit();
		$item->OnLeft = TRUE;

		// List actions
		$item = &$this->ListOptions->add("listactions");
		$item->CssClass = "text-nowrap";
		$item->OnLeft = TRUE;
		$item->Visible = FALSE;
		$item->ShowInButtonGroup = FALSE;
		$item->ShowInDropDown = FALSE;

		// "checkbox"
		$item = &$this->ListOptions->add("checkbox");
		$item->Visible = FALSE;
		$item->OnLeft = TRUE;
		$item->Header = "<div class=\"custom-control custom-checkbox d-inline-block\"><input type=\"checkbox\" name=\"key\" id=\"key\" class=\"custom-control-input\" onclick=\"ew.selectAllKey(this);\"><label class=\"custom-control-label\" for=\"key\"></label></div>";
		$item->moveTo(0);
		$item->ShowInDropDown = FALSE;
		$item->ShowInButtonGroup = FALSE;

		// Drop down button for ListOptions
		$this->ListOptions->UseDropDownButton = FALSE;
		$this->ListOptions->DropDownButtonPhrase = $Language->phrase("ButtonListOptions");
		$this->ListOptions->UseButtonGroup = TRUE;
		if ($this->ListOptions->UseButtonGroup && IsMobile())
			$this->ListOptions->UseDropDownButton = TRUE;

		//$this->ListOptions->ButtonClass = ""; // Class for button group
		// Call ListOptions_Load event

		$this->ListOptions_Load();
		$this->setupListOptionsExt();
		$item = $this->ListOptions[$this->ListOptions->GroupOptionName];
		$item->Visible = $this->ListOptions->groupOptionVisible();
	}

	// Render list options
	public function renderListOptions()
	{
		global $Security, $Language, $CurrentForm;
		$this->ListOptions->loadDefault();

		// Call ListOptions_Rendering event
		$this->ListOptions_Rendering();

		// Set up row action and key
		if (is_numeric($this->RowIndex) && $this->CurrentMode != "view") {
			$CurrentForm->Index = $this->RowIndex;
			$actionName = str_replace("k_", "k" . $this->RowIndex . "_", $this->FormActionName);
			$oldKeyName = str_replace("k_", "k" . $this->RowIndex . "_", $this->FormOldKeyName);
			$keyName = str_replace("k_", "k" . $this->RowIndex . "_", $this->FormKeyName);
			$blankRowName = str_replace("k_", "k" . $this->RowIndex . "_", $this->FormBlankRowName);
			if ($this->RowAction != "")
				$this->MultiSelectKey .= "<input type=\"hidden\" name=\"" . $actionName . "\" id=\"" . $actionName . "\" value=\"" . $this->RowAction . "\">";
			if ($this->RowAction == "delete") {
				$rowkey = $CurrentForm->getValue($this->FormKeyName);
				$this->setupKeyValues($rowkey);

				// Reload hidden key for delete
				$this->MultiSelectKey .= "<input type=\"hidden\" name=\"" . $keyName . "\" id=\"" . $keyName . "\" value=\"" . HtmlEncode($rowkey) . "\">";
			}
			if ($this->RowAction == "insert" && $this->isConfirm() && $this->emptyRow())
				$this->MultiSelectKey .= "<input type=\"hidden\" name=\"" . $blankRowName . "\" id=\"" . $blankRowName . "\" value=\"1\">";
		}

		// "edit"
		$opt = $this->ListOptions["edit"];
		if ($this->isInlineEditRow()) { // Inline-Edit
			$this->ListOptions->CustomItem = "edit"; // Show edit column only
			$cancelurl = $this->addMasterUrl($this->pageUrl() . "action=cancel");
				$opt->Body = "<div" . (($opt->OnLeft) ? " class=\"text-right\"" : "") . ">" .
					"<a class=\"ew-grid-link ew-inline-update\" title=\"" . HtmlTitle($Language->phrase("UpdateLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("UpdateLink")) . "\" href=\"#\" onclick=\"return ew.forms(this).submit('" . UrlAddHash($this->pageName(), "r" . $this->RowCount . "_" . $this->TableVar) . "');\">" . $Language->phrase("UpdateLink") . "</a>&nbsp;" .
					"<a class=\"ew-grid-link ew-inline-cancel\" title=\"" . HtmlTitle($Language->phrase("CancelLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("CancelLink")) . "\" href=\"" . $cancelurl . "\">" . $Language->phrase("CancelLink") . "</a>" .
					"<input type=\"hidden\" name=\"action\" id=\"action\" value=\"update\"></div>";
			$opt->Body .= "<input type=\"hidden\" name=\"k" . $this->RowIndex . "_key\" id=\"k" . $this->RowIndex . "_key\" value=\"" . HtmlEncode($this->Nim->CurrentValue) . "\">";
			return;
		}

		// "edit"
		$opt = $this->ListOptions["edit"];
		$editcaption = HtmlTitle($Language->phrase("EditLink"));
		if ($Security->canEdit()) {
			$opt->Body = "<a class=\"ew-row-link ew-edit\" title=\"" . HtmlTitle($Language->phrase("EditLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("EditLink")) . "\" href=\"" . HtmlEncode($this->EditUrl) . "\">" . $Language->phrase("EditLink") . "</a>";
			$opt->Body .= "<a class=\"ew-row-link ew-inline-edit\" title=\"" . HtmlTitle($Language->phrase("InlineEditLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("InlineEditLink")) . "\" href=\"" . HtmlEncode(UrlAddHash($this->InlineEditUrl, "r" . $this->RowCount . "_" . $this->TableVar)) . "\">" . $Language->phrase("InlineEditLink") . "</a>";
		} else {
			$opt->Body = "";
		}

		// Set up list action buttons
		$opt = $this->ListOptions["listactions"];
		if ($opt && !$this->isExport() && !$this->CurrentAction) {
			$body = "";
			$links = [];
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == ACTION_SINGLE && $listaction->Allow) {
					$action = $listaction->Action;
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon != "") ? "<i class=\"" . HtmlEncode(str_replace(" ew-icon", "", $listaction->Icon)) . "\" data-caption=\"" . HtmlTitle($caption) . "\"></i> " : "";
					$links[] = "<li><a class=\"dropdown-item ew-action ew-list-action\" data-action=\"" . HtmlEncode($action) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"#\" onclick=\"return ew.submitAction(event,jQuery.extend({key:" . $this->keyToJson(TRUE) . "}," . $listaction->toJson(TRUE) . "));\">" . $icon . $listaction->Caption . "</a></li>";
					if (count($links) == 1) // Single button
						$body = "<a class=\"ew-action ew-list-action\" data-action=\"" . HtmlEncode($action) . "\" title=\"" . HtmlTitle($caption) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"#\" onclick=\"return ew.submitAction(event,jQuery.extend({key:" . $this->keyToJson(TRUE) . "}," . $listaction->toJson(TRUE) . "));\">" . $icon . $listaction->Caption . "</a>";
				}
			}
			if (count($links) > 1) { // More than one buttons, use dropdown
				$body = "<button class=\"dropdown-toggle btn btn-default ew-actions\" title=\"" . HtmlTitle($Language->phrase("ListActionButton")) . "\" data-toggle=\"dropdown\">" . $Language->phrase("ListActionButton") . "</button>";
				$content = "";
				foreach ($links as $link)
					$content .= "<li>" . $link . "</li>";
				$body .= "<ul class=\"dropdown-menu" . ($opt->OnLeft ? "" : " dropdown-menu-right") . "\">". $content . "</ul>";
				$body = "<div class=\"btn-group btn-group-sm\">" . $body . "</div>";
			}
			if (count($links) > 0) {
				$opt->Body = $body;
				$opt->Visible = TRUE;
			}
		}

		// "checkbox"
		$opt = $this->ListOptions["checkbox"];
		$opt->Body = "<div class=\"custom-control custom-checkbox d-inline-block\"><input type=\"checkbox\" id=\"key_m_" . $this->RowCount . "\" name=\"key_m[]\" class=\"custom-control-input ew-multi-select\" value=\"" . HtmlEncode($this->Nim->CurrentValue) . "\" onclick=\"ew.clickMultiCheckbox(event);\"><label class=\"custom-control-label\" for=\"key_m_" . $this->RowCount . "\"></label></div>";
		$this->renderListOptionsExt();

		// Call ListOptions_Rendered event
		$this->ListOptions_Rendered();
	}

	// Set up other options
	protected function setupOtherOptions()
	{
		global $Language, $Security;
		$options = &$this->OtherOptions;
		$option = $options["action"];

		// Set up options default
		foreach ($options as $option) {
			$option->UseDropDownButton = FALSE;
			$option->UseButtonGroup = TRUE;

			//$option->ButtonClass = ""; // Class for button group
			$item = &$option->add($option->GroupOptionName);
			$item->Body = "";
			$item->Visible = FALSE;
		}
		$options["addedit"]->DropDownButtonPhrase = $Language->phrase("ButtonAddEdit");
		$options["detail"]->DropDownButtonPhrase = $Language->phrase("ButtonDetails");
		$options["action"]->DropDownButtonPhrase = $Language->phrase("ButtonActions");

		// Filter button
		$item = &$this->FilterOptions->add("savecurrentfilter");
		$item->Body = "<a class=\"ew-save-filter\" data-form=\"ftblMHSEkptlistsrch\" href=\"#\" onclick=\"return false;\">" . $Language->phrase("SaveCurrentFilter") . "</a>";
		$item->Visible = FALSE;
		$item = &$this->FilterOptions->add("deletefilter");
		$item->Body = "<a class=\"ew-delete-filter\" data-form=\"ftblMHSEkptlistsrch\" href=\"#\" onclick=\"return false;\">" . $Language->phrase("DeleteFilter") . "</a>";
		$item->Visible = FALSE;
		$this->FilterOptions->UseDropDownButton = TRUE;
		$this->FilterOptions->UseButtonGroup = !$this->FilterOptions->UseDropDownButton;
		$this->FilterOptions->DropDownButtonPhrase = $Language->phrase("Filters");

		// Add group option item
		$item = &$this->FilterOptions->add($this->FilterOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	// Render other options
	public function renderOtherOptions()
	{
		global $Language, $Security;
		$options = &$this->OtherOptions;
			$option = $options["action"];

			// Set up list action buttons
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == ACTION_MULTIPLE) {
					$item = &$option->add("custom_" . $listaction->Action);
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon != "") ? "<i class=\"" . HtmlEncode($listaction->Icon) . "\" data-caption=\"" . HtmlEncode($caption) . "\"></i> " . $caption : $caption;
					$item->Body = "<a class=\"ew-action ew-list-action\" title=\"" . HtmlEncode($caption) . "\" data-caption=\"" . HtmlEncode($caption) . "\" href=\"#\" onclick=\"return ew.submitAction(event,jQuery.extend({f:document.ftblMHSEkptlist}," . $listaction->toJson(TRUE) . "));\">" . $icon . "</a>";
					$item->Visible = $listaction->Allow;
				}
			}

			// Hide grid edit and other options
			if ($this->TotalRecords <= 0) {
				$option = $options["addedit"];
				$item = $option["gridedit"];
				if ($item)
					$item->Visible = FALSE;
				$option = $options["action"];
				$option->hideAllOptions();
			}
	}

	// Process list action
	protected function processListAction()
	{
		global $Language, $Security;
		$userlist = "";
		$user = "";
		$filter = $this->getFilterFromRecordKeys();
		$userAction = Post("useraction", "");
		if ($filter != "" && $userAction != "") {

			// Check permission first
			$actionCaption = $userAction;
			if (array_key_exists($userAction, $this->ListActions->Items)) {
				$actionCaption = $this->ListActions[$userAction]->Caption;
				if (!$this->ListActions[$userAction]->Allow) {
					$errmsg = str_replace('%s', $actionCaption, $Language->phrase("CustomActionNotAllowed"));
					if (Post("ajax") == $userAction) // Ajax
						echo "<p class=\"text-danger\">" . $errmsg . "</p>";
					else
						$this->setFailureMessage($errmsg);
					return FALSE;
				}
			}
			$this->CurrentFilter = $filter;
			$sql = $this->getCurrentSql();
			$conn = $this->getConnection();
			$conn->raiseErrorFn = Config("ERROR_FUNC");
			$rs = $conn->execute($sql);
			$conn->raiseErrorFn = "";
			$this->CurrentAction = $userAction;

			// Call row action event
			if ($rs && !$rs->EOF) {
				$conn->beginTrans();
				$this->SelectedCount = $rs->RecordCount();
				$this->SelectedIndex = 0;
				while (!$rs->EOF) {
					$this->SelectedIndex++;
					$row = $rs->fields;
					$processed = $this->Row_CustomAction($userAction, $row);
					if (!$processed)
						break;
					$rs->moveNext();
				}
				if ($processed) {
					$conn->commitTrans(); // Commit the changes
					if ($this->getSuccessMessage() == "" && !ob_get_length()) // No output
						$this->setSuccessMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionCompleted"))); // Set up success message
				} else {
					$conn->rollbackTrans(); // Rollback changes

					// Set up error message
					if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {

						// Use the message, do nothing
					} elseif ($this->CancelMessage != "") {
						$this->setFailureMessage($this->CancelMessage);
						$this->CancelMessage = "";
					} else {
						$this->setFailureMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionFailed")));
					}
				}
			}
			if ($rs)
				$rs->close();
			$this->CurrentAction = ""; // Clear action
			if (Post("ajax") == $userAction) { // Ajax
				if ($this->getSuccessMessage() != "") {
					echo "<p class=\"text-success\">" . $this->getSuccessMessage() . "</p>";
					$this->clearSuccessMessage(); // Clear message
				}
				if ($this->getFailureMessage() != "") {
					echo "<p class=\"text-danger\">" . $this->getFailureMessage() . "</p>";
					$this->clearFailureMessage(); // Clear message
				}
				return TRUE;
			}
		}
		return FALSE; // Not ajax request
	}

// Set up list options (extended codes)
	protected function setupListOptionsExt()
	{
	}

// Render list options (extended codes)
	protected function renderListOptionsExt()
	{
		global $Security, $Language;
	}

	// Load default values
	protected function loadDefaultValues()
	{
		$this->Nim->CurrentValue = NULL;
		$this->Nim->OldValue = $this->Nim->CurrentValue;
		$this->Nama_Mhs->CurrentValue = NULL;
		$this->Nama_Mhs->OldValue = $this->Nama_Mhs->CurrentValue;
		$this->Kode_jp->CurrentValue = NULL;
		$this->Kode_jp->OldValue = $this->Kode_jp->CurrentValue;
		$this->Tmp_Lahir->CurrentValue = NULL;
		$this->Tmp_Lahir->OldValue = $this->Tmp_Lahir->CurrentValue;
		$this->Tgl_Lahir->CurrentValue = NULL;
		$this->Tgl_Lahir->OldValue = $this->Tgl_Lahir->CurrentValue;
		$this->Jenis_Kel->CurrentValue = NULL;
		$this->Jenis_Kel->OldValue = $this->Jenis_Kel->CurrentValue;
		$this->Gol_darah->CurrentValue = NULL;
		$this->Gol_darah->OldValue = $this->Gol_darah->CurrentValue;
		$this->Agama_Mhs->CurrentValue = NULL;
		$this->Agama_Mhs->OldValue = $this->Agama_Mhs->CurrentValue;
		$this->Alamat_Mhs->CurrentValue = NULL;
		$this->Alamat_Mhs->OldValue = $this->Alamat_Mhs->CurrentValue;
		$this->rt->CurrentValue = NULL;
		$this->rt->OldValue = $this->rt->CurrentValue;
		$this->rw->CurrentValue = NULL;
		$this->rw->OldValue = $this->rw->CurrentValue;
		$this->Kelurahan->CurrentValue = NULL;
		$this->Kelurahan->OldValue = $this->Kelurahan->CurrentValue;
		$this->Kecamatan->CurrentValue = NULL;
		$this->Kecamatan->OldValue = $this->Kecamatan->CurrentValue;
		$this->Kota_Mhs->CurrentValue = NULL;
		$this->Kota_Mhs->OldValue = $this->Kota_Mhs->CurrentValue;
		$this->Provinsi_mhs->CurrentValue = NULL;
		$this->Provinsi_mhs->OldValue = $this->Provinsi_mhs->CurrentValue;
		$this->Kodepos_Mhs->CurrentValue = NULL;
		$this->Kodepos_Mhs->OldValue = $this->Kodepos_Mhs->CurrentValue;
		$this->Tlp_Mhs->CurrentValue = NULL;
		$this->Tlp_Mhs->OldValue = $this->Tlp_Mhs->CurrentValue;
		$this->TlpRumah->CurrentValue = NULL;
		$this->TlpRumah->OldValue = $this->TlpRumah->CurrentValue;
		$this->_Email->CurrentValue = NULL;
		$this->_Email->OldValue = $this->_Email->CurrentValue;
		$this->Status_Akd->CurrentValue = NULL;
		$this->Status_Akd->OldValue = $this->Status_Akd->CurrentValue;
		$this->ThMasuk->CurrentValue = NULL;
		$this->ThMasuk->OldValue = $this->ThMasuk->CurrentValue;
		$this->tglmasuk->CurrentValue = NULL;
		$this->tglmasuk->OldValue = $this->tglmasuk->CurrentValue;
		$this->Status_Masuk->CurrentValue = NULL;
		$this->Status_Masuk->OldValue = $this->Status_Masuk->CurrentValue;
		$this->Sem_Masuk->CurrentValue = NULL;
		$this->Sem_Masuk->OldValue = $this->Sem_Masuk->CurrentValue;
		$this->TaMasuk->CurrentValue = NULL;
		$this->TaMasuk->OldValue = $this->TaMasuk->CurrentValue;
		$this->PerMasuk->CurrentValue = NULL;
		$this->PerMasuk->OldValue = $this->PerMasuk->CurrentValue;
		$this->Pendidikan_Akhir->CurrentValue = NULL;
		$this->Pendidikan_Akhir->OldValue = $this->Pendidikan_Akhir->CurrentValue;
		$this->Jurusan->CurrentValue = NULL;
		$this->Jurusan->OldValue = $this->Jurusan->CurrentValue;
		$this->Thn_Selesai->CurrentValue = NULL;
		$this->Thn_Selesai->OldValue = $this->Thn_Selesai->CurrentValue;
		$this->Kota_Pdkk->CurrentValue = NULL;
		$this->Kota_Pdkk->OldValue = $this->Kota_Pdkk->CurrentValue;
		$this->propinsi->CurrentValue = NULL;
		$this->propinsi->OldValue = $this->propinsi->CurrentValue;
		$this->NIMASAL->CurrentValue = NULL;
		$this->NIMASAL->OldValue = $this->NIMASAL->CurrentValue;
		$this->KPTSASAL->CurrentValue = NULL;
		$this->KPTSASAL->OldValue = $this->KPTSASAL->CurrentValue;
		$this->JENASAL->CurrentValue = NULL;
		$this->JENASAL->OldValue = $this->JENASAL->CurrentValue;
		$this->PSASAL->CurrentValue = NULL;
		$this->PSASAL->OldValue = $this->PSASAL->CurrentValue;
		$this->TSKSDIAKUI->CurrentValue = NULL;
		$this->TSKSDIAKUI->OldValue = $this->TSKSDIAKUI->CurrentValue;
		$this->NamaSekolahAsal->CurrentValue = NULL;
		$this->NamaSekolahAsal->OldValue = $this->NamaSekolahAsal->CurrentValue;
		$this->AlamatSekolahAsal->CurrentValue = NULL;
		$this->AlamatSekolahAsal->OldValue = $this->AlamatSekolahAsal->CurrentValue;
		$this->Status->CurrentValue = "Aktif";
		$this->Photo->Upload->DbValue = NULL;
		$this->Photo->OldValue = $this->Photo->Upload->DbValue;
		$this->Password->CurrentValue = NULL;
		$this->Password->OldValue = $this->Password->CurrentValue;
		$this->JalurMasuk->CurrentValue = "Berbayar";
		$this->Konsentrasi->CurrentValue = NULL;
		$this->Konsentrasi->OldValue = $this->Konsentrasi->CurrentValue;
		$this->NIK->CurrentValue = NULL;
		$this->NIK->OldValue = $this->NIK->CurrentValue;
		$this->NamaIbu->CurrentValue = NULL;
		$this->NamaIbu->OldValue = $this->NamaIbu->CurrentValue;
		$this->BekerjaDi->CurrentValue = NULL;
		$this->BekerjaDi->OldValue = $this->BekerjaDi->CurrentValue;
		$this->Lama->CurrentValue = NULL;
		$this->Lama->OldValue = $this->Lama->CurrentValue;
		$this->AlamatPerusahaan->CurrentValue = NULL;
		$this->AlamatPerusahaan->OldValue = $this->AlamatPerusahaan->CurrentValue;
		$this->TlpPerusahaan->CurrentValue = NULL;
		$this->TlpPerusahaan->OldValue = $this->TlpPerusahaan->CurrentValue;
		$this->Posisi->CurrentValue = NULL;
		$this->Posisi->OldValue = $this->Posisi->CurrentValue;
		$this->Departemen->CurrentValue = NULL;
		$this->Departemen->OldValue = $this->Departemen->CurrentValue;
		$this->IdUser->CurrentValue = NULL;
		$this->IdUser->OldValue = $this->IdUser->CurrentValue;
		$this->TempID->CurrentValue = NULL;
		$this->TempID->OldValue = $this->TempID->CurrentValue;
		$this->xphoto->CurrentValue = NULL;
		$this->xphoto->OldValue = $this->xphoto->CurrentValue;
		$this->profile->CurrentValue = NULL;
		$this->profile->OldValue = $this->profile->CurrentValue;
		$this->id_agama->CurrentValue = NULL;
		$this->id_agama->OldValue = $this->id_agama->CurrentValue;
		$this->id_negara->CurrentValue = "ID";
		$this->id_wilayah->CurrentValue = NULL;
		$this->id_wilayah->OldValue = $this->id_wilayah->CurrentValue;
		$this->id_jenis_tinggal->CurrentValue = 1;
		$this->id_alat_transportasi->CurrentValue = 1;
		$this->no_kps->CurrentValue = NULL;
		$this->no_kps->OldValue = $this->no_kps->CurrentValue;
		$this->penerima_kps->CurrentValue = 0;
		$this->id_kebutuhan_khusus_mahasiswa->CurrentValue = 0;
		$this->nisn->CurrentValue = NULL;
		$this->nisn->OldValue = $this->nisn->CurrentValue;
		$this->MulaiKerja->CurrentValue = NULL;
		$this->MulaiKerja->OldValue = $this->MulaiKerja->CurrentValue;
		$this->IdKlsKerjasama->CurrentValue = NULL;
		$this->IdKlsKerjasama->OldValue = $this->IdKlsKerjasama->CurrentValue;
		$this->IDBeasiswa->CurrentValue = NULL;
		$this->IDBeasiswa->OldValue = $this->IDBeasiswa->CurrentValue;
		$this->Gelombang->CurrentValue = NULL;
		$this->Gelombang->OldValue = $this->Gelombang->CurrentValue;
		$this->iddesa->CurrentValue = NULL;
		$this->iddesa->OldValue = $this->iddesa->CurrentValue;
		$this->tglKonversi->CurrentValue = NULL;
		$this->tglKonversi->OldValue = $this->tglKonversi->CurrentValue;
		$this->NoSuratKonversi->CurrentValue = NULL;
		$this->NoSuratKonversi->OldValue = $this->NoSuratKonversi->CurrentValue;
		$this->Nopen->CurrentValue = NULL;
		$this->Nopen->OldValue = $this->Nopen->CurrentValue;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;

		// Check field name 'Nim' first before field var 'x_Nim'
		$val = $CurrentForm->hasValue("Nim") ? $CurrentForm->getValue("Nim") : $CurrentForm->getValue("x_Nim");
		if (!$this->Nim->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->Nim->Visible = FALSE; // Disable update for API request
			else
				$this->Nim->setFormValue($val);
		}

		// Check field name 'Nama_Mhs' first before field var 'x_Nama_Mhs'
		$val = $CurrentForm->hasValue("Nama_Mhs") ? $CurrentForm->getValue("Nama_Mhs") : $CurrentForm->getValue("x_Nama_Mhs");
		if (!$this->Nama_Mhs->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->Nama_Mhs->Visible = FALSE; // Disable update for API request
			else
				$this->Nama_Mhs->setFormValue($val);
		}

		// Check field name 'Tlp_Mhs' first before field var 'x_Tlp_Mhs'
		$val = $CurrentForm->hasValue("Tlp_Mhs") ? $CurrentForm->getValue("Tlp_Mhs") : $CurrentForm->getValue("x_Tlp_Mhs");
		if (!$this->Tlp_Mhs->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->Tlp_Mhs->Visible = FALSE; // Disable update for API request
			else
				$this->Tlp_Mhs->setFormValue($val);
		}

		// Check field name 'Status_Akd' first before field var 'x_Status_Akd'
		$val = $CurrentForm->hasValue("Status_Akd") ? $CurrentForm->getValue("Status_Akd") : $CurrentForm->getValue("x_Status_Akd");
		if (!$this->Status_Akd->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->Status_Akd->Visible = FALSE; // Disable update for API request
			else
				$this->Status_Akd->setFormValue($val);
		}

		// Check field name 'TaMasuk' first before field var 'x_TaMasuk'
		$val = $CurrentForm->hasValue("TaMasuk") ? $CurrentForm->getValue("TaMasuk") : $CurrentForm->getValue("x_TaMasuk");
		if (!$this->TaMasuk->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->TaMasuk->Visible = FALSE; // Disable update for API request
			else
				$this->TaMasuk->setFormValue($val);
		}

		// Check field name 'PerMasuk' first before field var 'x_PerMasuk'
		$val = $CurrentForm->hasValue("PerMasuk") ? $CurrentForm->getValue("PerMasuk") : $CurrentForm->getValue("x_PerMasuk");
		if (!$this->PerMasuk->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->PerMasuk->Visible = FALSE; // Disable update for API request
			else
				$this->PerMasuk->setFormValue($val);
		}

		// Check field name 'Status' first before field var 'x_Status'
		$val = $CurrentForm->hasValue("Status") ? $CurrentForm->getValue("Status") : $CurrentForm->getValue("x_Status");
		if (!$this->Status->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->Status->Visible = FALSE; // Disable update for API request
			else
				$this->Status->setFormValue($val);
		}
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->Nim->CurrentValue = $this->Nim->FormValue;
		$this->Nama_Mhs->CurrentValue = $this->Nama_Mhs->FormValue;
		$this->Tlp_Mhs->CurrentValue = $this->Tlp_Mhs->FormValue;
		$this->Status_Akd->CurrentValue = $this->Status_Akd->FormValue;
		$this->TaMasuk->CurrentValue = $this->TaMasuk->FormValue;
		$this->PerMasuk->CurrentValue = $this->PerMasuk->FormValue;
		$this->Status->CurrentValue = $this->Status->FormValue;
	}

	// Load recordset
	public function loadRecordset($offset = -1, $rowcnt = -1)
	{

		// Load List page SQL
		$sql = $this->getListSql();
		$conn = $this->getConnection();

		// Load recordset
		$dbtype = GetConnectionType($this->Dbid);
		if ($this->UseSelectLimit) {
			$conn->raiseErrorFn = Config("ERROR_FUNC");
			if ($dbtype == "MSSQL") {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset, ["_hasOrderBy" => trim($this->getOrderBy()) || trim($this->getSessionOrderBy())]);
			} else {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset);
			}
			$conn->raiseErrorFn = "";
		} else {
			$rs = LoadRecordset($sql, $conn);
		}

		// Call Recordset Selected event
		$this->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = $this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			if (!$this->EventCancelled)
				$this->HashValue = $this->getRowHash($rs); // Get hash value for record
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->Nim->setDbValue($row['Nim']);
		$this->Nama_Mhs->setDbValue($row['Nama_Mhs']);
		$this->Kode_jp->setDbValue($row['Kode_jp']);
		$this->Tmp_Lahir->setDbValue($row['Tmp_Lahir']);
		$this->Tgl_Lahir->setDbValue($row['Tgl_Lahir']);
		$this->Jenis_Kel->setDbValue($row['Jenis_Kel']);
		$this->Gol_darah->setDbValue($row['Gol_darah']);
		$this->Agama_Mhs->setDbValue($row['Agama_Mhs']);
		$this->Alamat_Mhs->setDbValue($row['Alamat_Mhs']);
		$this->rt->setDbValue($row['rt']);
		$this->rw->setDbValue($row['rw']);
		$this->Kelurahan->setDbValue($row['Kelurahan']);
		$this->Kecamatan->setDbValue($row['Kecamatan']);
		$this->Kota_Mhs->setDbValue($row['Kota_Mhs']);
		$this->Provinsi_mhs->setDbValue($row['Provinsi_mhs']);
		$this->Kodepos_Mhs->setDbValue($row['Kodepos_Mhs']);
		$this->Tlp_Mhs->setDbValue($row['Tlp_Mhs']);
		$this->TlpRumah->setDbValue($row['TlpRumah']);
		$this->_Email->setDbValue($row['Email']);
		$this->Status_Akd->setDbValue($row['Status_Akd']);
		$this->ThMasuk->setDbValue($row['ThMasuk']);
		$this->tglmasuk->setDbValue($row['tglmasuk']);
		$this->Status_Masuk->setDbValue($row['Status_Masuk']);
		$this->Sem_Masuk->setDbValue($row['Sem_Masuk']);
		$this->TaMasuk->setDbValue($row['TaMasuk']);
		$this->PerMasuk->setDbValue($row['PerMasuk']);
		$this->Pendidikan_Akhir->setDbValue($row['Pendidikan_Akhir']);
		$this->Jurusan->setDbValue($row['Jurusan']);
		$this->Thn_Selesai->setDbValue($row['Thn_Selesai']);
		$this->Kota_Pdkk->setDbValue($row['Kota_Pdkk']);
		$this->propinsi->setDbValue($row['propinsi']);
		$this->NIMASAL->setDbValue($row['NIMASAL']);
		$this->KPTSASAL->setDbValue($row['KPTSASAL']);
		$this->JENASAL->setDbValue($row['JENASAL']);
		$this->PSASAL->setDbValue($row['PSASAL']);
		$this->TSKSDIAKUI->setDbValue($row['TSKSDIAKUI']);
		$this->NamaSekolahAsal->setDbValue($row['NamaSekolahAsal']);
		$this->AlamatSekolahAsal->setDbValue($row['AlamatSekolahAsal']);
		$this->Status->setDbValue($row['Status']);
		$this->Photo->Upload->DbValue = $row['Photo'];
		if (is_array($this->Photo->Upload->DbValue) || is_object($this->Photo->Upload->DbValue)) // Byte array
			$this->Photo->Upload->DbValue = BytesToString($this->Photo->Upload->DbValue);
		$this->Password->setDbValue($row['Password']);
		$this->JalurMasuk->setDbValue($row['JalurMasuk']);
		$this->Konsentrasi->setDbValue($row['Konsentrasi']);
		$this->NIK->setDbValue($row['NIK']);
		$this->NamaIbu->setDbValue($row['NamaIbu']);
		$this->BekerjaDi->setDbValue($row['BekerjaDi']);
		$this->Lama->setDbValue($row['Lama']);
		$this->AlamatPerusahaan->setDbValue($row['AlamatPerusahaan']);
		$this->TlpPerusahaan->setDbValue($row['TlpPerusahaan']);
		$this->Posisi->setDbValue($row['Posisi']);
		$this->Departemen->setDbValue($row['Departemen']);
		$this->IdUser->setDbValue($row['IdUser']);
		$this->TempID->setDbValue($row['TempID']);
		$this->xphoto->setDbValue($row['xphoto']);
		$this->profile->setDbValue($row['profile']);
		$this->id_agama->setDbValue($row['id_agama']);
		$this->id_negara->setDbValue($row['id_negara']);
		$this->id_wilayah->setDbValue($row['id_wilayah']);
		$this->id_jenis_tinggal->setDbValue($row['id_jenis_tinggal']);
		$this->id_alat_transportasi->setDbValue($row['id_alat_transportasi']);
		$this->no_kps->setDbValue($row['no_kps']);
		$this->penerima_kps->setDbValue($row['penerima_kps']);
		$this->id_kebutuhan_khusus_mahasiswa->setDbValue($row['id_kebutuhan_khusus_mahasiswa']);
		$this->nisn->setDbValue($row['nisn']);
		$this->MulaiKerja->setDbValue($row['MulaiKerja']);
		$this->IdKlsKerjasama->setDbValue($row['IdKlsKerjasama']);
		$this->IDBeasiswa->setDbValue($row['IDBeasiswa']);
		$this->Gelombang->setDbValue($row['Gelombang']);
		$this->iddesa->setDbValue($row['iddesa']);
		$this->tglKonversi->setDbValue($row['tglKonversi']);
		$this->NoSuratKonversi->setDbValue($row['NoSuratKonversi']);
		$this->Nopen->setDbValue($row['Nopen']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$this->loadDefaultValues();
		$row = [];
		$row['Nim'] = $this->Nim->CurrentValue;
		$row['Nama_Mhs'] = $this->Nama_Mhs->CurrentValue;
		$row['Kode_jp'] = $this->Kode_jp->CurrentValue;
		$row['Tmp_Lahir'] = $this->Tmp_Lahir->CurrentValue;
		$row['Tgl_Lahir'] = $this->Tgl_Lahir->CurrentValue;
		$row['Jenis_Kel'] = $this->Jenis_Kel->CurrentValue;
		$row['Gol_darah'] = $this->Gol_darah->CurrentValue;
		$row['Agama_Mhs'] = $this->Agama_Mhs->CurrentValue;
		$row['Alamat_Mhs'] = $this->Alamat_Mhs->CurrentValue;
		$row['rt'] = $this->rt->CurrentValue;
		$row['rw'] = $this->rw->CurrentValue;
		$row['Kelurahan'] = $this->Kelurahan->CurrentValue;
		$row['Kecamatan'] = $this->Kecamatan->CurrentValue;
		$row['Kota_Mhs'] = $this->Kota_Mhs->CurrentValue;
		$row['Provinsi_mhs'] = $this->Provinsi_mhs->CurrentValue;
		$row['Kodepos_Mhs'] = $this->Kodepos_Mhs->CurrentValue;
		$row['Tlp_Mhs'] = $this->Tlp_Mhs->CurrentValue;
		$row['TlpRumah'] = $this->TlpRumah->CurrentValue;
		$row['Email'] = $this->_Email->CurrentValue;
		$row['Status_Akd'] = $this->Status_Akd->CurrentValue;
		$row['ThMasuk'] = $this->ThMasuk->CurrentValue;
		$row['tglmasuk'] = $this->tglmasuk->CurrentValue;
		$row['Status_Masuk'] = $this->Status_Masuk->CurrentValue;
		$row['Sem_Masuk'] = $this->Sem_Masuk->CurrentValue;
		$row['TaMasuk'] = $this->TaMasuk->CurrentValue;
		$row['PerMasuk'] = $this->PerMasuk->CurrentValue;
		$row['Pendidikan_Akhir'] = $this->Pendidikan_Akhir->CurrentValue;
		$row['Jurusan'] = $this->Jurusan->CurrentValue;
		$row['Thn_Selesai'] = $this->Thn_Selesai->CurrentValue;
		$row['Kota_Pdkk'] = $this->Kota_Pdkk->CurrentValue;
		$row['propinsi'] = $this->propinsi->CurrentValue;
		$row['NIMASAL'] = $this->NIMASAL->CurrentValue;
		$row['KPTSASAL'] = $this->KPTSASAL->CurrentValue;
		$row['JENASAL'] = $this->JENASAL->CurrentValue;
		$row['PSASAL'] = $this->PSASAL->CurrentValue;
		$row['TSKSDIAKUI'] = $this->TSKSDIAKUI->CurrentValue;
		$row['NamaSekolahAsal'] = $this->NamaSekolahAsal->CurrentValue;
		$row['AlamatSekolahAsal'] = $this->AlamatSekolahAsal->CurrentValue;
		$row['Status'] = $this->Status->CurrentValue;
		$row['Photo'] = $this->Photo->Upload->DbValue;
		$row['Password'] = $this->Password->CurrentValue;
		$row['JalurMasuk'] = $this->JalurMasuk->CurrentValue;
		$row['Konsentrasi'] = $this->Konsentrasi->CurrentValue;
		$row['NIK'] = $this->NIK->CurrentValue;
		$row['NamaIbu'] = $this->NamaIbu->CurrentValue;
		$row['BekerjaDi'] = $this->BekerjaDi->CurrentValue;
		$row['Lama'] = $this->Lama->CurrentValue;
		$row['AlamatPerusahaan'] = $this->AlamatPerusahaan->CurrentValue;
		$row['TlpPerusahaan'] = $this->TlpPerusahaan->CurrentValue;
		$row['Posisi'] = $this->Posisi->CurrentValue;
		$row['Departemen'] = $this->Departemen->CurrentValue;
		$row['IdUser'] = $this->IdUser->CurrentValue;
		$row['TempID'] = $this->TempID->CurrentValue;
		$row['xphoto'] = $this->xphoto->CurrentValue;
		$row['profile'] = $this->profile->CurrentValue;
		$row['id_agama'] = $this->id_agama->CurrentValue;
		$row['id_negara'] = $this->id_negara->CurrentValue;
		$row['id_wilayah'] = $this->id_wilayah->CurrentValue;
		$row['id_jenis_tinggal'] = $this->id_jenis_tinggal->CurrentValue;
		$row['id_alat_transportasi'] = $this->id_alat_transportasi->CurrentValue;
		$row['no_kps'] = $this->no_kps->CurrentValue;
		$row['penerima_kps'] = $this->penerima_kps->CurrentValue;
		$row['id_kebutuhan_khusus_mahasiswa'] = $this->id_kebutuhan_khusus_mahasiswa->CurrentValue;
		$row['nisn'] = $this->nisn->CurrentValue;
		$row['MulaiKerja'] = $this->MulaiKerja->CurrentValue;
		$row['IdKlsKerjasama'] = $this->IdKlsKerjasama->CurrentValue;
		$row['IDBeasiswa'] = $this->IDBeasiswa->CurrentValue;
		$row['Gelombang'] = $this->Gelombang->CurrentValue;
		$row['iddesa'] = $this->iddesa->CurrentValue;
		$row['tglKonversi'] = $this->tglKonversi->CurrentValue;
		$row['NoSuratKonversi'] = $this->NoSuratKonversi->CurrentValue;
		$row['Nopen'] = $this->Nopen->CurrentValue;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("Nim")) != "")
			$this->Nim->OldValue = $this->getKey("Nim"); // Nim
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = $this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		$this->ViewUrl = $this->getViewUrl();
		$this->EditUrl = $this->getEditUrl();
		$this->InlineEditUrl = $this->getInlineEditUrl();
		$this->CopyUrl = $this->getCopyUrl();
		$this->InlineCopyUrl = $this->getInlineCopyUrl();
		$this->DeleteUrl = $this->getDeleteUrl();

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// Nim
		// Nama_Mhs
		// Kode_jp
		// Tmp_Lahir
		// Tgl_Lahir
		// Jenis_Kel
		// Gol_darah
		// Agama_Mhs
		// Alamat_Mhs
		// rt
		// rw
		// Kelurahan
		// Kecamatan
		// Kota_Mhs
		// Provinsi_mhs
		// Kodepos_Mhs
		// Tlp_Mhs
		// TlpRumah
		// Email
		// Status_Akd
		// ThMasuk
		// tglmasuk
		// Status_Masuk
		// Sem_Masuk
		// TaMasuk
		// PerMasuk
		// Pendidikan_Akhir
		// Jurusan
		// Thn_Selesai
		// Kota_Pdkk
		// propinsi
		// NIMASAL
		// KPTSASAL
		// JENASAL
		// PSASAL
		// TSKSDIAKUI
		// NamaSekolahAsal
		// AlamatSekolahAsal
		// Status
		// Photo
		// Password
		// JalurMasuk
		// Konsentrasi
		// NIK
		// NamaIbu
		// BekerjaDi
		// Lama
		// AlamatPerusahaan
		// TlpPerusahaan
		// Posisi
		// Departemen
		// IdUser
		// TempID
		// xphoto
		// profile
		// id_agama
		// id_negara
		// id_wilayah
		// id_jenis_tinggal
		// id_alat_transportasi
		// no_kps
		// penerima_kps
		// id_kebutuhan_khusus_mahasiswa
		// nisn
		// MulaiKerja
		// IdKlsKerjasama
		// IDBeasiswa
		// Gelombang
		// iddesa
		// tglKonversi
		// NoSuratKonversi
		// Nopen

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// Nim
			$this->Nim->ViewValue = $this->Nim->CurrentValue;
			$this->Nim->ViewCustomAttributes = "";

			// Nama_Mhs
			$this->Nama_Mhs->ViewValue = $this->Nama_Mhs->CurrentValue;
			$this->Nama_Mhs->ViewCustomAttributes = "";

			// Kode_jp
			$this->Kode_jp->ViewValue = $this->Kode_jp->CurrentValue;
			$this->Kode_jp->ViewCustomAttributes = "";

			// Tmp_Lahir
			$this->Tmp_Lahir->ViewValue = $this->Tmp_Lahir->CurrentValue;
			$this->Tmp_Lahir->ViewCustomAttributes = "";

			// Tgl_Lahir
			$this->Tgl_Lahir->ViewValue = $this->Tgl_Lahir->CurrentValue;
			$this->Tgl_Lahir->ViewValue = FormatDateTime($this->Tgl_Lahir->ViewValue, 0);
			$this->Tgl_Lahir->ViewCustomAttributes = "";

			// Jenis_Kel
			$this->Jenis_Kel->ViewValue = $this->Jenis_Kel->CurrentValue;
			$this->Jenis_Kel->ViewCustomAttributes = "";

			// Gol_darah
			$this->Gol_darah->ViewValue = $this->Gol_darah->CurrentValue;
			$this->Gol_darah->ViewCustomAttributes = "";

			// Agama_Mhs
			$this->Agama_Mhs->ViewValue = $this->Agama_Mhs->CurrentValue;
			$this->Agama_Mhs->ViewCustomAttributes = "";

			// Alamat_Mhs
			$this->Alamat_Mhs->ViewValue = $this->Alamat_Mhs->CurrentValue;
			$this->Alamat_Mhs->ViewCustomAttributes = "";

			// rt
			$this->rt->ViewValue = $this->rt->CurrentValue;
			$this->rt->ViewCustomAttributes = "";

			// rw
			$this->rw->ViewValue = $this->rw->CurrentValue;
			$this->rw->ViewCustomAttributes = "";

			// Kelurahan
			$this->Kelurahan->ViewValue = $this->Kelurahan->CurrentValue;
			$this->Kelurahan->ViewCustomAttributes = "";

			// Kecamatan
			$this->Kecamatan->ViewValue = $this->Kecamatan->CurrentValue;
			$this->Kecamatan->ViewCustomAttributes = "";

			// Kota_Mhs
			$this->Kota_Mhs->ViewValue = $this->Kota_Mhs->CurrentValue;
			$this->Kota_Mhs->ViewCustomAttributes = "";

			// Provinsi_mhs
			$this->Provinsi_mhs->ViewValue = $this->Provinsi_mhs->CurrentValue;
			$this->Provinsi_mhs->ViewCustomAttributes = "";

			// Kodepos_Mhs
			$this->Kodepos_Mhs->ViewValue = $this->Kodepos_Mhs->CurrentValue;
			$this->Kodepos_Mhs->ViewCustomAttributes = "";

			// Tlp_Mhs
			$this->Tlp_Mhs->ViewValue = $this->Tlp_Mhs->CurrentValue;
			$this->Tlp_Mhs->ViewCustomAttributes = "";

			// TlpRumah
			$this->TlpRumah->ViewValue = $this->TlpRumah->CurrentValue;
			$this->TlpRumah->ViewCustomAttributes = "";

			// Email
			$this->_Email->ViewValue = $this->_Email->CurrentValue;
			$this->_Email->ViewCustomAttributes = "";

			// Status_Akd
			$this->Status_Akd->ViewValue = $this->Status_Akd->CurrentValue;
			$this->Status_Akd->ViewCustomAttributes = "";

			// ThMasuk
			$this->ThMasuk->ViewValue = $this->ThMasuk->CurrentValue;
			$this->ThMasuk->ViewCustomAttributes = "";

			// tglmasuk
			$this->tglmasuk->ViewValue = $this->tglmasuk->CurrentValue;
			$this->tglmasuk->ViewValue = FormatDateTime($this->tglmasuk->ViewValue, 7);
			$this->tglmasuk->ViewCustomAttributes = "";

			// Status_Masuk
			$this->Status_Masuk->ViewValue = $this->Status_Masuk->CurrentValue;
			$this->Status_Masuk->ViewCustomAttributes = "";

			// Sem_Masuk
			$this->Sem_Masuk->ViewValue = $this->Sem_Masuk->CurrentValue;
			$this->Sem_Masuk->ViewCustomAttributes = "";

			// TaMasuk
			$this->TaMasuk->ViewValue = $this->TaMasuk->CurrentValue;
			$this->TaMasuk->ViewCustomAttributes = "";

			// PerMasuk
			$this->PerMasuk->ViewValue = $this->PerMasuk->CurrentValue;
			$this->PerMasuk->ViewCustomAttributes = "";

			// Pendidikan_Akhir
			$this->Pendidikan_Akhir->ViewValue = $this->Pendidikan_Akhir->CurrentValue;
			$this->Pendidikan_Akhir->ViewCustomAttributes = "";

			// Jurusan
			$this->Jurusan->ViewValue = $this->Jurusan->CurrentValue;
			$this->Jurusan->ViewCustomAttributes = "";

			// Thn_Selesai
			$this->Thn_Selesai->ViewValue = $this->Thn_Selesai->CurrentValue;
			$this->Thn_Selesai->ViewCustomAttributes = "";

			// Kota_Pdkk
			$this->Kota_Pdkk->ViewValue = $this->Kota_Pdkk->CurrentValue;
			$this->Kota_Pdkk->ViewCustomAttributes = "";

			// propinsi
			$this->propinsi->ViewValue = $this->propinsi->CurrentValue;
			$this->propinsi->ViewCustomAttributes = "";

			// NIMASAL
			$this->NIMASAL->ViewValue = $this->NIMASAL->CurrentValue;
			$this->NIMASAL->ViewCustomAttributes = "";

			// KPTSASAL
			$this->KPTSASAL->ViewValue = $this->KPTSASAL->CurrentValue;
			$this->KPTSASAL->ViewCustomAttributes = "";

			// JENASAL
			$this->JENASAL->ViewValue = $this->JENASAL->CurrentValue;
			$this->JENASAL->ViewCustomAttributes = "";

			// PSASAL
			$this->PSASAL->ViewValue = $this->PSASAL->CurrentValue;
			$this->PSASAL->ViewCustomAttributes = "";

			// TSKSDIAKUI
			$this->TSKSDIAKUI->ViewValue = $this->TSKSDIAKUI->CurrentValue;
			$this->TSKSDIAKUI->ViewValue = FormatNumber($this->TSKSDIAKUI->ViewValue, 0, -2, -2, -2);
			$this->TSKSDIAKUI->ViewCustomAttributes = "";

			// NamaSekolahAsal
			$this->NamaSekolahAsal->ViewValue = $this->NamaSekolahAsal->CurrentValue;
			$this->NamaSekolahAsal->ViewCustomAttributes = "";

			// AlamatSekolahAsal
			$this->AlamatSekolahAsal->ViewValue = $this->AlamatSekolahAsal->CurrentValue;
			$this->AlamatSekolahAsal->ViewCustomAttributes = "";

			// Status
			if (strval($this->Status->CurrentValue) != "") {
				$this->Status->ViewValue = $this->Status->optionCaption($this->Status->CurrentValue);
			} else {
				$this->Status->ViewValue = NULL;
			}
			$this->Status->ViewCustomAttributes = "";

			// Password
			$this->Password->ViewValue = $this->Password->CurrentValue;
			$this->Password->ViewCustomAttributes = "";

			// JalurMasuk
			$this->JalurMasuk->ViewValue = $this->JalurMasuk->CurrentValue;
			$this->JalurMasuk->ViewCustomAttributes = "";

			// Konsentrasi
			$this->Konsentrasi->ViewValue = $this->Konsentrasi->CurrentValue;
			$this->Konsentrasi->ViewCustomAttributes = "";

			// NIK
			$this->NIK->ViewValue = $this->NIK->CurrentValue;
			$this->NIK->ViewCustomAttributes = "";

			// NamaIbu
			$this->NamaIbu->ViewValue = $this->NamaIbu->CurrentValue;
			$this->NamaIbu->ViewCustomAttributes = "";

			// BekerjaDi
			$this->BekerjaDi->ViewValue = $this->BekerjaDi->CurrentValue;
			$this->BekerjaDi->ViewCustomAttributes = "";

			// Lama
			$this->Lama->ViewValue = $this->Lama->CurrentValue;
			$this->Lama->ViewCustomAttributes = "";

			// AlamatPerusahaan
			$this->AlamatPerusahaan->ViewValue = $this->AlamatPerusahaan->CurrentValue;
			$this->AlamatPerusahaan->ViewCustomAttributes = "";

			// TlpPerusahaan
			$this->TlpPerusahaan->ViewValue = $this->TlpPerusahaan->CurrentValue;
			$this->TlpPerusahaan->ViewCustomAttributes = "";

			// Posisi
			$this->Posisi->ViewValue = $this->Posisi->CurrentValue;
			$this->Posisi->ViewCustomAttributes = "";

			// Departemen
			$this->Departemen->ViewValue = $this->Departemen->CurrentValue;
			$this->Departemen->ViewCustomAttributes = "";

			// IdUser
			$this->IdUser->ViewValue = $this->IdUser->CurrentValue;
			$this->IdUser->ViewCustomAttributes = "";

			// TempID
			$this->TempID->ViewValue = $this->TempID->CurrentValue;
			$this->TempID->ViewValue = FormatNumber($this->TempID->ViewValue, 0, -2, -2, -2);
			$this->TempID->ViewCustomAttributes = "";

			// xphoto
			$this->xphoto->ViewValue = $this->xphoto->CurrentValue;
			$this->xphoto->ViewCustomAttributes = "";

			// profile
			$this->profile->ViewValue = $this->profile->CurrentValue;
			$this->profile->ViewCustomAttributes = "";

			// id_agama
			$this->id_agama->ViewValue = $this->id_agama->CurrentValue;
			$this->id_agama->ViewValue = FormatNumber($this->id_agama->ViewValue, 0, -2, -2, -2);
			$this->id_agama->ViewCustomAttributes = "";

			// id_negara
			$this->id_negara->ViewValue = $this->id_negara->CurrentValue;
			$this->id_negara->ViewCustomAttributes = "";

			// id_wilayah
			$this->id_wilayah->ViewValue = $this->id_wilayah->CurrentValue;
			$this->id_wilayah->ViewCustomAttributes = "";

			// id_jenis_tinggal
			$this->id_jenis_tinggal->ViewValue = $this->id_jenis_tinggal->CurrentValue;
			$this->id_jenis_tinggal->ViewValue = FormatNumber($this->id_jenis_tinggal->ViewValue, 0, -2, -2, -2);
			$this->id_jenis_tinggal->ViewCustomAttributes = "";

			// id_alat_transportasi
			$this->id_alat_transportasi->ViewValue = $this->id_alat_transportasi->CurrentValue;
			$this->id_alat_transportasi->ViewValue = FormatNumber($this->id_alat_transportasi->ViewValue, 0, -2, -2, -2);
			$this->id_alat_transportasi->ViewCustomAttributes = "";

			// no_kps
			$this->no_kps->ViewValue = $this->no_kps->CurrentValue;
			$this->no_kps->ViewCustomAttributes = "";

			// penerima_kps
			$this->penerima_kps->ViewValue = $this->penerima_kps->CurrentValue;
			$this->penerima_kps->ViewValue = FormatNumber($this->penerima_kps->ViewValue, 0, -2, -2, -2);
			$this->penerima_kps->ViewCustomAttributes = "";

			// id_kebutuhan_khusus_mahasiswa
			$this->id_kebutuhan_khusus_mahasiswa->ViewValue = $this->id_kebutuhan_khusus_mahasiswa->CurrentValue;
			$this->id_kebutuhan_khusus_mahasiswa->ViewValue = FormatNumber($this->id_kebutuhan_khusus_mahasiswa->ViewValue, 0, -2, -2, -2);
			$this->id_kebutuhan_khusus_mahasiswa->ViewCustomAttributes = "";

			// nisn
			$this->nisn->ViewValue = $this->nisn->CurrentValue;
			$this->nisn->ViewCustomAttributes = "";

			// MulaiKerja
			$this->MulaiKerja->ViewValue = $this->MulaiKerja->CurrentValue;
			$this->MulaiKerja->ViewValue = FormatDateTime($this->MulaiKerja->ViewValue, 0);
			$this->MulaiKerja->ViewCustomAttributes = "";

			// IdKlsKerjasama
			$this->IdKlsKerjasama->ViewValue = $this->IdKlsKerjasama->CurrentValue;
			$this->IdKlsKerjasama->ViewValue = FormatNumber($this->IdKlsKerjasama->ViewValue, 0, -2, -2, -2);
			$this->IdKlsKerjasama->ViewCustomAttributes = "";

			// IDBeasiswa
			$this->IDBeasiswa->ViewValue = $this->IDBeasiswa->CurrentValue;
			$this->IDBeasiswa->ViewValue = FormatNumber($this->IDBeasiswa->ViewValue, 0, -2, -2, -2);
			$this->IDBeasiswa->ViewCustomAttributes = "";

			// Gelombang
			$this->Gelombang->ViewValue = $this->Gelombang->CurrentValue;
			$this->Gelombang->ViewCustomAttributes = "";

			// iddesa
			$this->iddesa->ViewValue = $this->iddesa->CurrentValue;
			$this->iddesa->ViewValue = FormatNumber($this->iddesa->ViewValue, 0, -2, -2, -2);
			$this->iddesa->ViewCustomAttributes = "";

			// tglKonversi
			$this->tglKonversi->ViewValue = $this->tglKonversi->CurrentValue;
			$this->tglKonversi->ViewValue = FormatDateTime($this->tglKonversi->ViewValue, 0);
			$this->tglKonversi->ViewCustomAttributes = "";

			// NoSuratKonversi
			$this->NoSuratKonversi->ViewValue = $this->NoSuratKonversi->CurrentValue;
			$this->NoSuratKonversi->ViewCustomAttributes = "";

			// Nopen
			$this->Nopen->ViewValue = $this->Nopen->CurrentValue;
			$this->Nopen->ViewValue = FormatNumber($this->Nopen->ViewValue, 0, -2, -2, -2);
			$this->Nopen->ViewCustomAttributes = "";

			// Nim
			$this->Nim->LinkCustomAttributes = "";
			$this->Nim->HrefValue = "";
			$this->Nim->TooltipValue = "";

			// Nama_Mhs
			$this->Nama_Mhs->LinkCustomAttributes = "";
			$this->Nama_Mhs->HrefValue = "";
			$this->Nama_Mhs->TooltipValue = "";

			// Tlp_Mhs
			$this->Tlp_Mhs->LinkCustomAttributes = "";
			$this->Tlp_Mhs->HrefValue = "";
			$this->Tlp_Mhs->TooltipValue = "";

			// Status_Akd
			$this->Status_Akd->LinkCustomAttributes = "";
			$this->Status_Akd->HrefValue = "";
			$this->Status_Akd->TooltipValue = "";

			// TaMasuk
			$this->TaMasuk->LinkCustomAttributes = "";
			$this->TaMasuk->HrefValue = "";
			$this->TaMasuk->TooltipValue = "";

			// PerMasuk
			$this->PerMasuk->LinkCustomAttributes = "";
			$this->PerMasuk->HrefValue = "";
			$this->PerMasuk->TooltipValue = "";

			// Status
			$this->Status->LinkCustomAttributes = "";
			$this->Status->HrefValue = "";
			$this->Status->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_ADD) { // Add row

			// Nim
			$this->Nim->EditAttrs["class"] = "form-control";
			$this->Nim->EditCustomAttributes = "";
			if ($this->Nim->getSessionValue() != "") {
				$this->Nim->CurrentValue = $this->Nim->getSessionValue();
				$this->Nim->ViewValue = $this->Nim->CurrentValue;
				$this->Nim->ViewCustomAttributes = "";
			} else {
				if (!$this->Nim->Raw)
					$this->Nim->CurrentValue = HtmlDecode($this->Nim->CurrentValue);
				$this->Nim->EditValue = HtmlEncode($this->Nim->CurrentValue);
				$this->Nim->PlaceHolder = RemoveHtml($this->Nim->caption());
			}

			// Nama_Mhs
			$this->Nama_Mhs->EditAttrs["class"] = "form-control";
			$this->Nama_Mhs->EditCustomAttributes = "";
			if (!$this->Nama_Mhs->Raw)
				$this->Nama_Mhs->CurrentValue = HtmlDecode($this->Nama_Mhs->CurrentValue);
			$this->Nama_Mhs->EditValue = HtmlEncode($this->Nama_Mhs->CurrentValue);
			$this->Nama_Mhs->PlaceHolder = RemoveHtml($this->Nama_Mhs->caption());

			// Tlp_Mhs
			$this->Tlp_Mhs->EditAttrs["class"] = "form-control";
			$this->Tlp_Mhs->EditCustomAttributes = "";
			if (!$this->Tlp_Mhs->Raw)
				$this->Tlp_Mhs->CurrentValue = HtmlDecode($this->Tlp_Mhs->CurrentValue);
			$this->Tlp_Mhs->EditValue = HtmlEncode($this->Tlp_Mhs->CurrentValue);
			$this->Tlp_Mhs->PlaceHolder = RemoveHtml($this->Tlp_Mhs->caption());

			// Status_Akd
			$this->Status_Akd->EditAttrs["class"] = "form-control";
			$this->Status_Akd->EditCustomAttributes = "";
			if (!$this->Status_Akd->Raw)
				$this->Status_Akd->CurrentValue = HtmlDecode($this->Status_Akd->CurrentValue);
			$this->Status_Akd->EditValue = HtmlEncode($this->Status_Akd->CurrentValue);
			$this->Status_Akd->PlaceHolder = RemoveHtml($this->Status_Akd->caption());

			// TaMasuk
			$this->TaMasuk->EditAttrs["class"] = "form-control";
			$this->TaMasuk->EditCustomAttributes = "";
			if (!$this->TaMasuk->Raw)
				$this->TaMasuk->CurrentValue = HtmlDecode($this->TaMasuk->CurrentValue);
			$this->TaMasuk->EditValue = HtmlEncode($this->TaMasuk->CurrentValue);
			$this->TaMasuk->PlaceHolder = RemoveHtml($this->TaMasuk->caption());

			// PerMasuk
			$this->PerMasuk->EditAttrs["class"] = "form-control";
			$this->PerMasuk->EditCustomAttributes = "";
			if (!$this->PerMasuk->Raw)
				$this->PerMasuk->CurrentValue = HtmlDecode($this->PerMasuk->CurrentValue);
			$this->PerMasuk->EditValue = HtmlEncode($this->PerMasuk->CurrentValue);
			$this->PerMasuk->PlaceHolder = RemoveHtml($this->PerMasuk->caption());

			// Status
			$this->Status->EditAttrs["class"] = "form-control";
			$this->Status->EditCustomAttributes = "";
			$this->Status->EditValue = $this->Status->options(TRUE);

			// Add refer script
			// Nim

			$this->Nim->LinkCustomAttributes = "";
			$this->Nim->HrefValue = "";

			// Nama_Mhs
			$this->Nama_Mhs->LinkCustomAttributes = "";
			$this->Nama_Mhs->HrefValue = "";

			// Tlp_Mhs
			$this->Tlp_Mhs->LinkCustomAttributes = "";
			$this->Tlp_Mhs->HrefValue = "";

			// Status_Akd
			$this->Status_Akd->LinkCustomAttributes = "";
			$this->Status_Akd->HrefValue = "";

			// TaMasuk
			$this->TaMasuk->LinkCustomAttributes = "";
			$this->TaMasuk->HrefValue = "";

			// PerMasuk
			$this->PerMasuk->LinkCustomAttributes = "";
			$this->PerMasuk->HrefValue = "";

			// Status
			$this->Status->LinkCustomAttributes = "";
			$this->Status->HrefValue = "";
		} elseif ($this->RowType == ROWTYPE_EDIT) { // Edit row

			// Nim
			$this->Nim->EditAttrs["class"] = "form-control";
			$this->Nim->EditCustomAttributes = "";
			$this->Nim->EditValue = $this->Nim->CurrentValue;
			$this->Nim->ViewCustomAttributes = "";

			// Nama_Mhs
			$this->Nama_Mhs->EditAttrs["class"] = "form-control";
			$this->Nama_Mhs->EditCustomAttributes = "";
			if (!$this->Nama_Mhs->Raw)
				$this->Nama_Mhs->CurrentValue = HtmlDecode($this->Nama_Mhs->CurrentValue);
			$this->Nama_Mhs->EditValue = HtmlEncode($this->Nama_Mhs->CurrentValue);
			$this->Nama_Mhs->PlaceHolder = RemoveHtml($this->Nama_Mhs->caption());

			// Tlp_Mhs
			$this->Tlp_Mhs->EditAttrs["class"] = "form-control";
			$this->Tlp_Mhs->EditCustomAttributes = "";
			if (!$this->Tlp_Mhs->Raw)
				$this->Tlp_Mhs->CurrentValue = HtmlDecode($this->Tlp_Mhs->CurrentValue);
			$this->Tlp_Mhs->EditValue = HtmlEncode($this->Tlp_Mhs->CurrentValue);
			$this->Tlp_Mhs->PlaceHolder = RemoveHtml($this->Tlp_Mhs->caption());

			// Status_Akd
			$this->Status_Akd->EditAttrs["class"] = "form-control";
			$this->Status_Akd->EditCustomAttributes = "";
			if (!$this->Status_Akd->Raw)
				$this->Status_Akd->CurrentValue = HtmlDecode($this->Status_Akd->CurrentValue);
			$this->Status_Akd->EditValue = HtmlEncode($this->Status_Akd->CurrentValue);
			$this->Status_Akd->PlaceHolder = RemoveHtml($this->Status_Akd->caption());

			// TaMasuk
			$this->TaMasuk->EditAttrs["class"] = "form-control";
			$this->TaMasuk->EditCustomAttributes = "";
			if (!$this->TaMasuk->Raw)
				$this->TaMasuk->CurrentValue = HtmlDecode($this->TaMasuk->CurrentValue);
			$this->TaMasuk->EditValue = HtmlEncode($this->TaMasuk->CurrentValue);
			$this->TaMasuk->PlaceHolder = RemoveHtml($this->TaMasuk->caption());

			// PerMasuk
			$this->PerMasuk->EditAttrs["class"] = "form-control";
			$this->PerMasuk->EditCustomAttributes = "";
			if (!$this->PerMasuk->Raw)
				$this->PerMasuk->CurrentValue = HtmlDecode($this->PerMasuk->CurrentValue);
			$this->PerMasuk->EditValue = HtmlEncode($this->PerMasuk->CurrentValue);
			$this->PerMasuk->PlaceHolder = RemoveHtml($this->PerMasuk->caption());

			// Status
			$this->Status->EditAttrs["class"] = "form-control";
			$this->Status->EditCustomAttributes = "";
			$this->Status->EditValue = $this->Status->options(TRUE);

			// Edit refer script
			// Nim

			$this->Nim->LinkCustomAttributes = "";
			$this->Nim->HrefValue = "";
			$this->Nim->TooltipValue = "";

			// Nama_Mhs
			$this->Nama_Mhs->LinkCustomAttributes = "";
			$this->Nama_Mhs->HrefValue = "";

			// Tlp_Mhs
			$this->Tlp_Mhs->LinkCustomAttributes = "";
			$this->Tlp_Mhs->HrefValue = "";

			// Status_Akd
			$this->Status_Akd->LinkCustomAttributes = "";
			$this->Status_Akd->HrefValue = "";

			// TaMasuk
			$this->TaMasuk->LinkCustomAttributes = "";
			$this->TaMasuk->HrefValue = "";

			// PerMasuk
			$this->PerMasuk->LinkCustomAttributes = "";
			$this->PerMasuk->HrefValue = "";

			// Status
			$this->Status->LinkCustomAttributes = "";
			$this->Status->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType != ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!Config("SERVER_VALIDATE"))
			return ($FormError == "");
		if ($this->Nim->Required) {
			if (!$this->Nim->IsDetailKey && $this->Nim->FormValue != NULL && $this->Nim->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Nim->caption(), $this->Nim->RequiredErrorMessage));
			}
		}
		if ($this->Nama_Mhs->Required) {
			if (!$this->Nama_Mhs->IsDetailKey && $this->Nama_Mhs->FormValue != NULL && $this->Nama_Mhs->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Nama_Mhs->caption(), $this->Nama_Mhs->RequiredErrorMessage));
			}
		}
		if ($this->Tlp_Mhs->Required) {
			if (!$this->Tlp_Mhs->IsDetailKey && $this->Tlp_Mhs->FormValue != NULL && $this->Tlp_Mhs->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Tlp_Mhs->caption(), $this->Tlp_Mhs->RequiredErrorMessage));
			}
		}
		if ($this->Status_Akd->Required) {
			if (!$this->Status_Akd->IsDetailKey && $this->Status_Akd->FormValue != NULL && $this->Status_Akd->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Status_Akd->caption(), $this->Status_Akd->RequiredErrorMessage));
			}
		}
		if ($this->TaMasuk->Required) {
			if (!$this->TaMasuk->IsDetailKey && $this->TaMasuk->FormValue != NULL && $this->TaMasuk->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->TaMasuk->caption(), $this->TaMasuk->RequiredErrorMessage));
			}
		}
		if ($this->PerMasuk->Required) {
			if (!$this->PerMasuk->IsDetailKey && $this->PerMasuk->FormValue != NULL && $this->PerMasuk->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->PerMasuk->caption(), $this->PerMasuk->RequiredErrorMessage));
			}
		}
		if ($this->Status->Required) {
			if (!$this->Status->IsDetailKey && $this->Status->FormValue != NULL && $this->Status->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Status->caption(), $this->Status->RequiredErrorMessage));
			}
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError != "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Update record based on key values
	protected function editRow()
	{
		global $Security, $Language;
		$oldKeyFilter = $this->getRecordFilter();
		$filter = $this->applyUserIDFilters($oldKeyFilter);
		$conn = $this->getConnection();
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn->raiseErrorFn = Config("ERROR_FUNC");
		$rs = $conn->execute($sql);
		$conn->raiseErrorFn = "";
		if ($rs === FALSE)
			return FALSE;
		if ($rs->EOF) {
			$this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
			$editRow = FALSE; // Update Failed
		} else {

			// Save old values
			$rsold = &$rs->fields;
			$this->loadDbValues($rsold);
			$rsnew = [];

			// Nama_Mhs
			$this->Nama_Mhs->setDbValueDef($rsnew, $this->Nama_Mhs->CurrentValue, NULL, $this->Nama_Mhs->ReadOnly);

			// Tlp_Mhs
			$this->Tlp_Mhs->setDbValueDef($rsnew, $this->Tlp_Mhs->CurrentValue, NULL, $this->Tlp_Mhs->ReadOnly);

			// Status_Akd
			$this->Status_Akd->setDbValueDef($rsnew, $this->Status_Akd->CurrentValue, NULL, $this->Status_Akd->ReadOnly);

			// TaMasuk
			$this->TaMasuk->setDbValueDef($rsnew, $this->TaMasuk->CurrentValue, NULL, $this->TaMasuk->ReadOnly);

			// PerMasuk
			$this->PerMasuk->setDbValueDef($rsnew, $this->PerMasuk->CurrentValue, NULL, $this->PerMasuk->ReadOnly);

			// Status
			$this->Status->setDbValueDef($rsnew, $this->Status->CurrentValue, NULL, $this->Status->ReadOnly);

			// Call Row Updating event
			$updateRow = $this->Row_Updating($rsold, $rsnew);

			// Check for duplicate key when key changed
			if ($updateRow) {
				$newKeyFilter = $this->getRecordFilter($rsnew);
				if ($newKeyFilter != $oldKeyFilter) {
					$rsChk = $this->loadRs($newKeyFilter);
					if ($rsChk && !$rsChk->EOF) {
						$keyErrMsg = str_replace("%f", $newKeyFilter, $Language->phrase("DupKey"));
						$this->setFailureMessage($keyErrMsg);
						$rsChk->close();
						$updateRow = FALSE;
					}
				}
			}
			if ($updateRow) {
				$conn->raiseErrorFn = Config("ERROR_FUNC");
				if (count($rsnew) > 0)
					$editRow = $this->update($rsnew, "", $rsold);
				else
					$editRow = TRUE; // No field to update
				$conn->raiseErrorFn = "";
				if ($editRow) {
				}
			} else {
				if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {

					// Use the message, do nothing
				} elseif ($this->CancelMessage != "") {
					$this->setFailureMessage($this->CancelMessage);
					$this->CancelMessage = "";
				} else {
					$this->setFailureMessage($Language->phrase("UpdateCancelled"));
				}
				$editRow = FALSE;
			}
		}

		// Call Row_Updated event
		if ($editRow)
			$this->Row_Updated($rsold, $rsnew);
		$rs->close();

		// Clean upload path if any
		if ($editRow) {
		}

		// Write JSON for API request
		if (IsApi() && $editRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $editRow;
	}

	// Load row hash
	protected function loadRowHash()
	{
		$filter = $this->getRecordFilter();

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = $this->getConnection();
		$rsRow = $conn->Execute($sql);
		$this->HashValue = ($rsRow && !$rsRow->EOF) ? $this->getRowHash($rsRow) : ""; // Get hash value for record
		$rsRow->close();
	}

	// Get Row Hash
	public function getRowHash(&$rs)
	{
		if (!$rs)
			return "";
		$hash = "";
		$hash .= GetFieldHash($rs->fields('Nama_Mhs')); // Nama_Mhs
		$hash .= GetFieldHash($rs->fields('Tlp_Mhs')); // Tlp_Mhs
		$hash .= GetFieldHash($rs->fields('Status_Akd')); // Status_Akd
		$hash .= GetFieldHash($rs->fields('TaMasuk')); // TaMasuk
		$hash .= GetFieldHash($rs->fields('PerMasuk')); // PerMasuk
		$hash .= GetFieldHash($rs->fields('Status')); // Status
		return md5($hash);
	}

	// Add record
	protected function addRow($rsold = NULL)
	{
		global $Language, $Security;
		if ($this->Nim->CurrentValue != "") { // Check field with unique index
			$filter = "([Nim] = '" . AdjustSql($this->Nim->CurrentValue, $this->Dbid) . "')";
			$rsChk = $this->loadRs($filter);
			if ($rsChk && !$rsChk->EOF) {
				$idxErrMsg = str_replace("%f", $this->Nim->caption(), $Language->phrase("DupIndex"));
				$idxErrMsg = str_replace("%v", $this->Nim->CurrentValue, $idxErrMsg);
				$this->setFailureMessage($idxErrMsg);
				$rsChk->close();
				return FALSE;
			}
		}
		$conn = $this->getConnection();

		// Load db values from rsold
		$this->loadDbValues($rsold);
		if ($rsold) {
		}
		$rsnew = [];

		// Nim
		$this->Nim->setDbValueDef($rsnew, $this->Nim->CurrentValue, "", FALSE);

		// Nama_Mhs
		$this->Nama_Mhs->setDbValueDef($rsnew, $this->Nama_Mhs->CurrentValue, NULL, FALSE);

		// Tlp_Mhs
		$this->Tlp_Mhs->setDbValueDef($rsnew, $this->Tlp_Mhs->CurrentValue, NULL, FALSE);

		// Status_Akd
		$this->Status_Akd->setDbValueDef($rsnew, $this->Status_Akd->CurrentValue, NULL, FALSE);

		// TaMasuk
		$this->TaMasuk->setDbValueDef($rsnew, $this->TaMasuk->CurrentValue, NULL, FALSE);

		// PerMasuk
		$this->PerMasuk->setDbValueDef($rsnew, $this->PerMasuk->CurrentValue, NULL, FALSE);

		// Status
		$this->Status->setDbValueDef($rsnew, $this->Status->CurrentValue, NULL, strval($this->Status->CurrentValue) == "");

		// Call Row Inserting event
		$rs = ($rsold) ? $rsold->fields : NULL;
		$insertRow = $this->Row_Inserting($rs, $rsnew);

		// Check if key value entered
		if ($insertRow && $this->ValidateKey && strval($rsnew['Nim']) == "") {
			$this->setFailureMessage($Language->phrase("InvalidKeyValue"));
			$insertRow = FALSE;
		}

		// Check for duplicate key
		if ($insertRow && $this->ValidateKey) {
			$filter = $this->getRecordFilter($rsnew);
			$rsChk = $this->loadRs($filter);
			if ($rsChk && !$rsChk->EOF) {
				$keyErrMsg = str_replace("%f", $filter, $Language->phrase("DupKey"));
				$this->setFailureMessage($keyErrMsg);
				$rsChk->close();
				$insertRow = FALSE;
			}
		}
		if ($insertRow) {
			$conn->raiseErrorFn = Config("ERROR_FUNC");
			$addRow = $this->insert($rsnew);
			$conn->raiseErrorFn = "";
			if ($addRow) {
			}
		} else {
			if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage != "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->phrase("InsertCancelled"));
			}
			$addRow = FALSE;
		}
		if ($addRow) {

			// Call Row Inserted event
			$rs = ($rsold) ? $rsold->fields : NULL;
			$this->Row_Inserted($rs, $rsnew);
		}

		// Clean upload path if any
		if ($addRow) {
		}

		// Write JSON for API request
		if (IsApi() && $addRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $addRow;
	}

	// Get export HTML tag
	protected function getExportTag($type, $custom = FALSE)
	{
		global $Language;
		if (SameText($type, "excel")) {
			if ($custom)
				return "<a href=\"#\" class=\"ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" onclick=\"return ew.export(document.ftblMHSEkptlist, '" . $this->ExportExcelUrl . "', 'excel', true);\">" . $Language->phrase("ExportToExcel") . "</a>";
			else
				return "<a href=\"" . $this->ExportExcelUrl . "\" class=\"ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\">" . $Language->phrase("ExportToExcel") . "</a>";
		} elseif (SameText($type, "word")) {
			if ($custom)
				return "<a href=\"#\" class=\"ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" onclick=\"return ew.export(document.ftblMHSEkptlist, '" . $this->ExportWordUrl . "', 'word', true);\">" . $Language->phrase("ExportToWord") . "</a>";
			else
				return "<a href=\"" . $this->ExportWordUrl . "\" class=\"ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\">" . $Language->phrase("ExportToWord") . "</a>";
		} elseif (SameText($type, "pdf")) {
			if ($custom)
				return "<a href=\"#\" class=\"ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" onclick=\"return ew.export(document.ftblMHSEkptlist, '" . $this->ExportPdfUrl . "', 'pdf', true);\">" . $Language->phrase("ExportToPDF") . "</a>";
			else
				return "<a href=\"" . $this->ExportPdfUrl . "\" class=\"ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\">" . $Language->phrase("ExportToPDF") . "</a>";
		} elseif (SameText($type, "html")) {
			return "<a href=\"" . $this->ExportHtmlUrl . "\" class=\"ew-export-link ew-html\" title=\"" . HtmlEncode($Language->phrase("ExportToHtmlText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToHtmlText")) . "\">" . $Language->phrase("ExportToHtml") . "</a>";
		} elseif (SameText($type, "xml")) {
			return "<a href=\"" . $this->ExportXmlUrl . "\" class=\"ew-export-link ew-xml\" title=\"" . HtmlEncode($Language->phrase("ExportToXmlText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToXmlText")) . "\">" . $Language->phrase("ExportToXml") . "</a>";
		} elseif (SameText($type, "csv")) {
			return "<a href=\"" . $this->ExportCsvUrl . "\" class=\"ew-export-link ew-csv\" title=\"" . HtmlEncode($Language->phrase("ExportToCsvText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToCsvText")) . "\">" . $Language->phrase("ExportToCsv") . "</a>";
		} elseif (SameText($type, "email")) {
			$url = $custom ? ",url:'" . $this->pageUrl() . "export=email&amp;custom=1'" : "";
			return '<button id="emf_tblMHSEkpt" class="ew-export-link ew-email" title="' . $Language->phrase("ExportToEmailText") . '" data-caption="' . $Language->phrase("ExportToEmailText") . '" onclick="ew.emailDialogShow({lnk:\'emf_tblMHSEkpt\', hdr:ew.language.phrase(\'ExportToEmailText\'), f:document.ftblMHSEkptlist, sel:false' . $url . '});">' . $Language->phrase("ExportToEmail") . '</button>';
		} elseif (SameText($type, "print")) {
			return "<a href=\"" . $this->ExportPrintUrl . "\" class=\"ew-export-link ew-print\" title=\"" . HtmlEncode($Language->phrase("PrinterFriendlyText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("PrinterFriendlyText")) . "\">" . $Language->phrase("PrinterFriendly") . "</a>";
		}
	}

	// Set up export options
	protected function setupExportOptions()
	{
		global $Language;

		// Printer friendly
		$item = &$this->ExportOptions->add("print");
		$item->Body = $this->getExportTag("print");
		$item->Visible = TRUE;

		// Export to Excel
		$item = &$this->ExportOptions->add("excel");
		$item->Body = $this->getExportTag("excel");
		$item->Visible = TRUE;

		// Export to Word
		$item = &$this->ExportOptions->add("word");
		$item->Body = $this->getExportTag("word");
		$item->Visible = FALSE;

		// Export to Html
		$item = &$this->ExportOptions->add("html");
		$item->Body = $this->getExportTag("html");
		$item->Visible = FALSE;

		// Export to Xml
		$item = &$this->ExportOptions->add("xml");
		$item->Body = $this->getExportTag("xml");
		$item->Visible = FALSE;

		// Export to Csv
		$item = &$this->ExportOptions->add("csv");
		$item->Body = $this->getExportTag("csv");
		$item->Visible = FALSE;

		// Export to Pdf
		$item = &$this->ExportOptions->add("pdf");
		$item->Body = $this->getExportTag("pdf");
		$item->Visible = FALSE;

		// Export to Email
		$item = &$this->ExportOptions->add("email");
		$item->Body = $this->getExportTag("email");
		$item->Visible = FALSE;

		// Drop down button for export
		$this->ExportOptions->UseButtonGroup = TRUE;
		$this->ExportOptions->UseDropDownButton = FALSE;
		if ($this->ExportOptions->UseButtonGroup && IsMobile())
			$this->ExportOptions->UseDropDownButton = TRUE;
		$this->ExportOptions->DropDownButtonPhrase = $Language->phrase("ButtonExport");

		// Add group option item
		$item = &$this->ExportOptions->add($this->ExportOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	// Set up search options
	protected function setupSearchOptions()
	{
		global $Language;
		$this->SearchOptions = new ListOptions("div");
		$this->SearchOptions->TagClassName = "ew-search-option";

		// Button group for search
		$this->SearchOptions->UseDropDownButton = FALSE;
		$this->SearchOptions->UseButtonGroup = TRUE;
		$this->SearchOptions->DropDownButtonPhrase = $Language->phrase("ButtonSearch");

		// Add group option item
		$item = &$this->SearchOptions->add($this->SearchOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;

		// Hide search options
		if ($this->isExport() || $this->CurrentAction)
			$this->SearchOptions->hideAllOptions();
		global $Security;
		if (!$Security->canSearch()) {
			$this->SearchOptions->hideAllOptions();
			$this->FilterOptions->hideAllOptions();
		}
	}

	/**
	 * Export data in HTML/CSV/Word/Excel/XML/Email/PDF format
	 *
	 * @param boolean $return Return the data rather than output it
	 * @return mixed
	 */
	public function exportData($return = FALSE)
	{
		global $Language;
		$utf8 = SameText(Config("PROJECT_CHARSET"), "utf-8");
		$selectLimit = $this->UseSelectLimit;

		// Load recordset
		if ($selectLimit) {
			$this->TotalRecords = $this->listRecordCount();
		} else {
			if (!$this->Recordset)
				$this->Recordset = $this->loadRecordset();
			$rs = &$this->Recordset;
			if ($rs)
				$this->TotalRecords = $rs->RecordCount();
		}
		$this->StartRecord = 1;

		// Export all
		if ($this->ExportAll) {
			set_time_limit(Config("EXPORT_ALL_TIME_LIMIT"));
			$this->DisplayRecords = $this->TotalRecords;
			$this->StopRecord = $this->TotalRecords;
		} else { // Export one page only
			$this->setupStartRecord(); // Set up start record position

			// Set the last record to display
			if ($this->DisplayRecords <= 0) {
				$this->StopRecord = $this->TotalRecords;
			} else {
				$this->StopRecord = $this->StartRecord + $this->DisplayRecords - 1;
			}
		}
		if ($selectLimit)
			$rs = $this->loadRecordset($this->StartRecord - 1, $this->DisplayRecords <= 0 ? $this->TotalRecords : $this->DisplayRecords);
		$this->ExportDoc = GetExportDocument($this, "h");
		$doc = &$this->ExportDoc;
		if (!$doc)
			$this->setFailureMessage($Language->phrase("ExportClassNotFound")); // Export class not found
		if (!$rs || !$doc) {
			RemoveHeader("Content-Type"); // Remove header
			RemoveHeader("Content-Disposition");
			$this->showMessage();
			return;
		}
		if ($selectLimit) {
			$this->StartRecord = 1;
			$this->StopRecord = $this->DisplayRecords <= 0 ? $this->TotalRecords : $this->DisplayRecords;
		}

		// Call Page Exporting server event
		$this->ExportDoc->ExportCustom = !$this->Page_Exporting();

		// Export master record
		if (Config("EXPORT_MASTER_RECORD") && $this->getMasterFilter() != "" && $this->getCurrentMasterTable() == "ekpt_mhsfeed") {
			global $ekpt_mhsfeed;
			if (!isset($ekpt_mhsfeed))
				$ekpt_mhsfeed = new ekpt_mhsfeed();
			$rsmaster = $ekpt_mhsfeed->loadRs($this->DbMasterFilter); // Load master record
			if ($rsmaster && !$rsmaster->EOF) {
				$exportStyle = $doc->Style;
				$doc->setStyle("v"); // Change to vertical
				if (!$this->isExport("csv") || Config("EXPORT_MASTER_RECORD_FOR_CSV")) {
					$doc->Table = &$ekpt_mhsfeed;
					$ekpt_mhsfeed->exportDocument($doc, $rsmaster);
					$doc->exportEmptyRow();
					$doc->Table = &$this;
				}
				$doc->setStyle($exportStyle); // Restore
				$rsmaster->close();
			}
		}
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		$doc->Text .= $header;
		$this->exportDocument($doc, $rs, $this->StartRecord, $this->StopRecord, "");
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		$doc->Text .= $footer;

		// Close recordset
		$rs->close();

		// Call Page Exported server event
		$this->Page_Exported();

		// Export header and footer
		$doc->exportHeaderAndFooter();

		// Clean output buffer (without destroying output buffer)
		$buffer = ob_get_contents(); // Save the output buffer
		if (!Config("DEBUG") && $buffer)
			ob_clean();

		// Write debug message if enabled
		if (Config("DEBUG") && !$this->isExport("pdf"))
			echo GetDebugMessage();

		// Output data
		if ($this->isExport("email")) {

			// Export-to-email disabled
		} else {
			$doc->export();
			if ($return) {
				RemoveHeader("Content-Type"); // Remove header
				RemoveHeader("Content-Disposition");
				$content = ob_get_contents();
				if ($content)
					ob_clean();
				if ($buffer)
					echo $buffer; // Resume the output buffer
				return $content;
			}
		}
	}

	// Set up master/detail based on QueryString
	protected function setupMasterParms()
	{
		$validMaster = FALSE;

		// Get the keys for master table
		if (($master = Get(Config("TABLE_SHOW_MASTER"), Get(Config("TABLE_MASTER")))) !== NULL) {
			$masterTblVar = $master;
			if ($masterTblVar == "") {
				$validMaster = TRUE;
				$this->DbMasterFilter = "";
				$this->DbDetailFilter = "";
			}
			if ($masterTblVar == "ekpt_mhsfeed") {
				$validMaster = TRUE;
				if (($parm = Get("fk_NimIM", Get("Nim"))) !== NULL) {
					$GLOBALS["ekpt_mhsfeed"]->NimIM->setQueryStringValue($parm);
					$this->Nim->setQueryStringValue($GLOBALS["ekpt_mhsfeed"]->NimIM->QueryStringValue);
					$this->Nim->setSessionValue($this->Nim->QueryStringValue);
				} else {
					$validMaster = FALSE;
				}
			}
		} elseif (($master = Post(Config("TABLE_SHOW_MASTER"), Post(Config("TABLE_MASTER")))) !== NULL) {
			$masterTblVar = $master;
			if ($masterTblVar == "") {
				$validMaster = TRUE;
				$this->DbMasterFilter = "";
				$this->DbDetailFilter = "";
			}
			if ($masterTblVar == "ekpt_mhsfeed") {
				$validMaster = TRUE;
				if (($parm = Post("fk_NimIM", Post("Nim"))) !== NULL) {
					$GLOBALS["ekpt_mhsfeed"]->NimIM->setFormValue($parm);
					$this->Nim->setFormValue($GLOBALS["ekpt_mhsfeed"]->NimIM->FormValue);
					$this->Nim->setSessionValue($this->Nim->FormValue);
				} else {
					$validMaster = FALSE;
				}
			}
		}
		if ($validMaster) {

			// Update URL
			$this->AddUrl = $this->addMasterUrl($this->AddUrl);
			$this->InlineAddUrl = $this->addMasterUrl($this->InlineAddUrl);
			$this->GridAddUrl = $this->addMasterUrl($this->GridAddUrl);
			$this->GridEditUrl = $this->addMasterUrl($this->GridEditUrl);

			// Save current master table
			$this->setCurrentMasterTable($masterTblVar);

			// Reset start record counter (new master key)
			if (!$this->isAddOrEdit()) {
				$this->StartRecord = 1;
				$this->setStartRecordNumber($this->StartRecord);
			}

			// Clear previous master key from Session
			if ($masterTblVar != "ekpt_mhsfeed") {
				if ($this->Nim->CurrentValue == "")
					$this->Nim->setSessionValue("");
			}
		}
		$this->DbMasterFilter = $this->getMasterFilter(); // Get master filter
		$this->DbDetailFilter = $this->getDetailFilter(); // Get detail filter
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$url = preg_replace('/\?cmd=reset(all){0,1}$/i', '', $url); // Remove cmd=reset / cmd=resetall
		$Breadcrumb->add("list", $this->TableVar, $url, "", $this->TableVar, TRUE);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// Get default connection and filter
			$conn = $this->getConnection();
			$lookupFilter = "";

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL and connection
			switch ($fld->FieldVar) {
				case "x_Status":
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0) {
				$totalCnt = $this->getRecordCount($sql, $conn);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Set up starting record parameters
	public function setupStartRecord()
	{
		if ($this->DisplayRecords == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			$startRec = Get(Config("TABLE_START_REC"));
			$pageNo = Get(Config("TABLE_PAGE_NO"));
			if ($pageNo !== NULL) { // Check for "pageno" parameter first
				if (is_numeric($pageNo)) {
					$this->StartRecord = ($pageNo - 1) * $this->DisplayRecords + 1;
					if ($this->StartRecord <= 0) {
						$this->StartRecord = 1;
					} elseif ($this->StartRecord >= (int)(($this->TotalRecords - 1)/$this->DisplayRecords) * $this->DisplayRecords + 1) {
						$this->StartRecord = (int)(($this->TotalRecords - 1)/$this->DisplayRecords) * $this->DisplayRecords + 1;
					}
					$this->setStartRecordNumber($this->StartRecord);
				}
			} elseif ($startRec !== NULL) { // Check for "start" parameter
				$this->StartRecord = $startRec;
				$this->setStartRecordNumber($this->StartRecord);
			}
		}
		$this->StartRecord = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRecord) || $this->StartRecord == "") { // Avoid invalid start record counter
			$this->StartRecord = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRecord);
		} elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
			$this->StartRecord = (int)(($this->TotalRecords - 1)/$this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRecord);
		} elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
			$this->StartRecord = (int)(($this->StartRecord - 1)/$this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRecord);
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}

	// ListOptions Load event
	function ListOptions_Load() {

		// Example:
		//$opt = &$this->ListOptions->Add("new");
		//$opt->Header = "xxx";
		//$opt->OnLeft = TRUE; // Link on left
		//$opt->MoveTo(0); // Move to first column

	}

	// ListOptions Rendering event
	function ListOptions_Rendering() {

		//$GLOBALS["xxx_grid"]->DetailAdd = (...condition...); // Set to TRUE or FALSE conditionally
		//$GLOBALS["xxx_grid"]->DetailEdit = (...condition...); // Set to TRUE or FALSE conditionally
		//$GLOBALS["xxx_grid"]->DetailView = (...condition...); // Set to TRUE or FALSE conditionally

	}

	// ListOptions Rendered event
	function ListOptions_Rendered() {

		// Example:
		//$this->ListOptions["new"]->Body = "xxx";

	}

	// Row Custom Action event
	function Row_CustomAction($action, $row) {

		// Return FALSE to abort
		return TRUE;
	}

	// Page Exporting event
	// $this->ExportDoc = export document object
	function Page_Exporting() {

		//$this->ExportDoc->Text = "my header"; // Export header
		//return FALSE; // Return FALSE to skip default export and use Row_Export event

		return TRUE; // Return TRUE to use default export and skip Row_Export event
	}

	// Row Export event
	// $this->ExportDoc = export document object
	function Row_Export($rs) {

		//$this->ExportDoc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
	}

	// Page Exported event
	// $this->ExportDoc = export document object
	function Page_Exported() {

		//$this->ExportDoc->Text .= "my footer"; // Export footer
		//echo $this->ExportDoc->Text;

	}

	// Page Importing event
	function Page_Importing($reader, &$options) {

		//var_dump($reader); // Import data reader
		//var_dump($options); // Show all options for importing
		//return FALSE; // Return FALSE to skip import

		return TRUE;
	}

	// Row Import event
	function Row_Import(&$row, $cnt) {

		//echo $cnt; // Import record count
		//var_dump($row); // Import row
		//return FALSE; // Return FALSE to skip import

		return TRUE;
	}

	// Page Imported event
	function Page_Imported($reader, $results) {

		//var_dump($reader); // Import data reader
		//var_dump($results); // Import results

	}
} // End class
?>