<?php
namespace PHPMaker2020\baak;

/**
 * Page class
 */
class tblMHS_delete extends tblMHS
{

	// Page ID
	public $PageID = "delete";

	// Project ID
	public $ProjectID = "{A09D3AFF-419C-4918-948A-A3C8469EA234}";

	// Table name
	public $TableName = 'tblMHS';

	// Page object name
	public $PageObjName = "tblMHS_delete";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken;

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading != "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading != "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		$url = CurrentPageName() . "?";
		if ($this->UseTokenInUrl)
			$url .= "t=" . $this->TableVar . "&"; // Add page token
		return $url;
	}

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = TRUE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message != "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fas fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage != "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fas fa-exclamation"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage != "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fas fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage != "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fas fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = [];

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message != "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage != "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage != "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage != "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header != "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer != "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(Config("TOKEN_NAME")) === NULL)
			return FALSE;
		$fn = Config("CHECK_TOKEN_FUNC");
		if (is_callable($fn))
			return $fn(Post(Config("TOKEN_NAME")), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = Config("CREATE_TOKEN_FUNC"); // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $DashboardReport;
		global $UserTable;

		// Check token
		$this->CheckToken = Config("CHECK_TOKEN");

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (tblMHS)
		if (!isset($GLOBALS["tblMHS"]) || get_class($GLOBALS["tblMHS"]) == PROJECT_NAMESPACE . "tblMHS") {
			$GLOBALS["tblMHS"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["tblMHS"];
		}

		// Table object (Pass)
		if (!isset($GLOBALS['Pass']))
			$GLOBALS['Pass'] = new Pass();

		// Page ID (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'delete');

		// Table name (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'tblMHS');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = $this->getConnection();

		// User table object (Pass)
		$UserTable = $UserTable ?: new Pass();
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages, $DashboardReport;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $tblMHS;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, Config("EXPORT_CLASSES"))) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . Config("EXPORT_CLASSES." . $this->CustomExport);
			if (class_exists($class)) {
				$doc = new $class($tblMHS);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url != "") {
			if (!Config("DEBUG") && ob_get_length())
				ob_end_clean();
			SaveDebugMessage();
			AddHeader("Location", $url);
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = [];
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = [];
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {
								$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
									Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
									Config("API_FIELD_NAME") . "=" . $fld->Param . "&" .
									Config("API_KEY_NAME") . "=" . rawurlencode($this->getRecordKeyValue($ar)))); //*** need to add this? API may not be in the same folder
								$row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
								$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
									Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
									"fn=" . Encrypt($fld->physicalUploadPath() . $val)));
								$row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
							} else { // Multiple files
								$files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
								$ar = [];
								foreach ($files as $file) {
									$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
										Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
										"fn=" . Encrypt($fld->physicalUploadPath() . $file)));
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['Nim'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
	}

	// Set up API security
	public function setupApiSecurity()
	{
		global $Security;

		// Setup security for API request
		if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
		$Security->loadCurrentUserLevel(Config("PROJECT_ID") . $this->TableName);
		if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
	}
	public $DbMasterFilter = "";
	public $DbDetailFilter = "";
	public $StartRecord;
	public $TotalRecords = 0;
	public $RecordCount;
	public $RecKeys = [];
	public $StartRowCount = 1;
	public $RowCount = 0;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $CurrentForm;

		// User profile
		$UserProfile = new UserProfile();

		// Security
		if (ValidApiRequest()) { // API request
			$this->setupApiSecurity(); // Set up API Security
			if (!$Security->canDelete()) {
				SetStatus(401); // Unauthorized
				return;
			}
		} else {
			$Security = new AdvancedSecurity();
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canDelete()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("tblMHSlist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
		}
		$this->CurrentAction = Param("action"); // Set up current action
		$this->Nim->setVisibility();
		$this->Nama_Mhs->setVisibility();
		$this->Kode_jp->setVisibility();
		$this->Tmp_Lahir->Visible = FALSE;
		$this->Tgl_Lahir->Visible = FALSE;
		$this->Jenis_Kel->Visible = FALSE;
		$this->Gol_darah->Visible = FALSE;
		$this->Agama_Mhs->Visible = FALSE;
		$this->Alamat_Mhs->Visible = FALSE;
		$this->rt->Visible = FALSE;
		$this->rw->Visible = FALSE;
		$this->Kelurahan->Visible = FALSE;
		$this->Kecamatan->Visible = FALSE;
		$this->Kota_Mhs->Visible = FALSE;
		$this->Provinsi_mhs->Visible = FALSE;
		$this->Kodepos_Mhs->Visible = FALSE;
		$this->Tlp_Mhs->setVisibility();
		$this->TlpRumah->Visible = FALSE;
		$this->_Email->setVisibility();
		$this->Status_Akd->setVisibility();
		$this->ThMasuk->Visible = FALSE;
		$this->tglmasuk->Visible = FALSE;
		$this->Status_Masuk->setVisibility();
		$this->Sem_Masuk->setVisibility();
		$this->TaMasuk->setVisibility();
		$this->PerMasuk->setVisibility();
		$this->Pendidikan_Akhir->Visible = FALSE;
		$this->Jurusan->Visible = FALSE;
		$this->Thn_Selesai->Visible = FALSE;
		$this->Kota_Pdkk->Visible = FALSE;
		$this->propinsi->Visible = FALSE;
		$this->NIMASAL->Visible = FALSE;
		$this->KPTSASAL->Visible = FALSE;
		$this->JENASAL->Visible = FALSE;
		$this->PSASAL->Visible = FALSE;
		$this->TSKSDIAKUI->Visible = FALSE;
		$this->NamaSekolahAsal->Visible = FALSE;
		$this->AlamatSekolahAsal->Visible = FALSE;
		$this->Status->setVisibility();
		$this->Photo->Visible = FALSE;
		$this->Password->Visible = FALSE;
		$this->Gelombang->Visible = FALSE;
		$this->JalurMasuk->Visible = FALSE;
		$this->Konsentrasi->Visible = FALSE;
		$this->NIK->Visible = FALSE;
		$this->NamaIbu->Visible = FALSE;
		$this->BekerjaDi->Visible = FALSE;
		$this->Lama->Visible = FALSE;
		$this->AlamatPerusahaan->Visible = FALSE;
		$this->TlpPerusahaan->Visible = FALSE;
		$this->Posisi->Visible = FALSE;
		$this->Departemen->Visible = FALSE;
		$this->IdUser->Visible = FALSE;
		$this->TempID->Visible = FALSE;
		$this->xphoto->Visible = FALSE;
		$this->profile->Visible = FALSE;
		$this->id_agama->Visible = FALSE;
		$this->id_negara->Visible = FALSE;
		$this->id_wilayah->Visible = FALSE;
		$this->id_jenis_tinggal->Visible = FALSE;
		$this->id_alat_transportasi->Visible = FALSE;
		$this->no_kps->Visible = FALSE;
		$this->penerima_kps->Visible = FALSE;
		$this->id_kebutuhan_khusus_mahasiswa->Visible = FALSE;
		$this->nisn->Visible = FALSE;
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->Kode_jp);

		// Check permission
		if (!$Security->canDelete()) {
			$this->setFailureMessage(DeniedMessage()); // No permission
			$this->terminate("tblMHSlist.php");
			return;
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Load key parameters
		$this->RecKeys = $this->getRecordKeys(); // Load record keys
		$filter = $this->getFilterFromRecordKeys();
		if ($filter == "") {
			$this->terminate("tblMHSlist.php"); // Prevent SQL injection, return to list
			return;
		}

		// Set up filter (WHERE Clause)
		$this->CurrentFilter = $filter;

		// Get action
		if (IsApi()) {
			$this->CurrentAction = "delete"; // Delete record directly
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action");
		} elseif (Get("action") == "1") {
			$this->CurrentAction = "delete"; // Delete record directly
		} else {
			$this->CurrentAction = "show"; // Display record
		}
		if ($this->isDelete()) {
			$this->SendEmail = TRUE; // Send email on delete success
			if ($this->deleteRows()) { // Delete rows
				if ($this->getSuccessMessage() == "")
					$this->setSuccessMessage($Language->phrase("DeleteSuccess")); // Set up success message
				if (IsApi()) {
					$this->terminate(TRUE);
					return;
				} else {
					$this->terminate($this->getReturnUrl()); // Return to caller
				}
			} else { // Delete failed
				if (IsApi()) {
					$this->terminate();
					return;
				}
				$this->CurrentAction = "show"; // Display record
			}
		}
		if ($this->isShow()) { // Load records for display
			if ($this->Recordset = $this->loadRecordset())
				$this->TotalRecords = $this->Recordset->RecordCount(); // Get record count
			if ($this->TotalRecords <= 0) { // No record found, exit
				if ($this->Recordset)
					$this->Recordset->close();
				$this->terminate("tblMHSlist.php"); // Return to list
			}
		}
	}

	// Load recordset
	public function loadRecordset($offset = -1, $rowcnt = -1)
	{

		// Load List page SQL
		$sql = $this->getListSql();
		$conn = $this->getConnection();

		// Load recordset
		$dbtype = GetConnectionType($this->Dbid);
		if ($this->UseSelectLimit) {
			$conn->raiseErrorFn = Config("ERROR_FUNC");
			if ($dbtype == "MSSQL") {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset, ["_hasOrderBy" => trim($this->getOrderBy()) || trim($this->getSessionOrderBy())]);
			} else {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset);
			}
			$conn->raiseErrorFn = "";
		} else {
			$rs = LoadRecordset($sql, $conn);
		}

		// Call Recordset Selected event
		$this->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = $this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->Nim->setDbValue($row['Nim']);
		$this->Nama_Mhs->setDbValue($row['Nama_Mhs']);
		$this->Kode_jp->setDbValue($row['Kode_jp']);
		$this->Tmp_Lahir->setDbValue($row['Tmp_Lahir']);
		$this->Tgl_Lahir->setDbValue($row['Tgl_Lahir']);
		$this->Jenis_Kel->setDbValue($row['Jenis_Kel']);
		$this->Gol_darah->setDbValue($row['Gol_darah']);
		$this->Agama_Mhs->setDbValue($row['Agama_Mhs']);
		$this->Alamat_Mhs->setDbValue($row['Alamat_Mhs']);
		$this->rt->setDbValue($row['rt']);
		$this->rw->setDbValue($row['rw']);
		$this->Kelurahan->setDbValue($row['Kelurahan']);
		$this->Kecamatan->setDbValue($row['Kecamatan']);
		$this->Kota_Mhs->setDbValue($row['Kota_Mhs']);
		$this->Provinsi_mhs->setDbValue($row['Provinsi_mhs']);
		$this->Kodepos_Mhs->setDbValue($row['Kodepos_Mhs']);
		$this->Tlp_Mhs->setDbValue($row['Tlp_Mhs']);
		$this->TlpRumah->setDbValue($row['TlpRumah']);
		$this->_Email->setDbValue($row['Email']);
		$this->Status_Akd->setDbValue($row['Status_Akd']);
		$this->ThMasuk->setDbValue($row['ThMasuk']);
		$this->tglmasuk->setDbValue($row['tglmasuk']);
		$this->Status_Masuk->setDbValue($row['Status_Masuk']);
		$this->Sem_Masuk->setDbValue($row['Sem_Masuk']);
		$this->TaMasuk->setDbValue($row['TaMasuk']);
		$this->PerMasuk->setDbValue($row['PerMasuk']);
		$this->Pendidikan_Akhir->setDbValue($row['Pendidikan_Akhir']);
		$this->Jurusan->setDbValue($row['Jurusan']);
		$this->Thn_Selesai->setDbValue($row['Thn_Selesai']);
		$this->Kota_Pdkk->setDbValue($row['Kota_Pdkk']);
		$this->propinsi->setDbValue($row['propinsi']);
		$this->NIMASAL->setDbValue($row['NIMASAL']);
		$this->KPTSASAL->setDbValue($row['KPTSASAL']);
		$this->JENASAL->setDbValue($row['JENASAL']);
		$this->PSASAL->setDbValue($row['PSASAL']);
		$this->TSKSDIAKUI->setDbValue($row['TSKSDIAKUI']);
		$this->NamaSekolahAsal->setDbValue($row['NamaSekolahAsal']);
		$this->AlamatSekolahAsal->setDbValue($row['AlamatSekolahAsal']);
		$this->Status->setDbValue($row['Status']);
		$this->Photo->Upload->DbValue = $row['Photo'];
		if (is_array($this->Photo->Upload->DbValue) || is_object($this->Photo->Upload->DbValue)) // Byte array
			$this->Photo->Upload->DbValue = BytesToString($this->Photo->Upload->DbValue);
		$this->Password->setDbValue($row['Password']);
		$this->Gelombang->setDbValue($row['Gelombang']);
		$this->JalurMasuk->setDbValue($row['JalurMasuk']);
		$this->Konsentrasi->setDbValue($row['Konsentrasi']);
		$this->NIK->setDbValue($row['NIK']);
		$this->NamaIbu->setDbValue($row['NamaIbu']);
		$this->BekerjaDi->setDbValue($row['BekerjaDi']);
		$this->Lama->setDbValue($row['Lama']);
		$this->AlamatPerusahaan->setDbValue($row['AlamatPerusahaan']);
		$this->TlpPerusahaan->setDbValue($row['TlpPerusahaan']);
		$this->Posisi->setDbValue($row['Posisi']);
		$this->Departemen->setDbValue($row['Departemen']);
		$this->IdUser->setDbValue($row['IdUser']);
		$this->TempID->setDbValue($row['TempID']);
		$this->xphoto->setDbValue($row['xphoto']);
		$this->profile->setDbValue($row['profile']);
		$this->id_agama->setDbValue($row['id_agama']);
		$this->id_negara->setDbValue($row['id_negara']);
		$this->id_wilayah->setDbValue($row['id_wilayah']);
		$this->id_jenis_tinggal->setDbValue($row['id_jenis_tinggal']);
		$this->id_alat_transportasi->setDbValue($row['id_alat_transportasi']);
		$this->no_kps->setDbValue($row['no_kps']);
		$this->penerima_kps->setDbValue($row['penerima_kps']);
		$this->id_kebutuhan_khusus_mahasiswa->setDbValue($row['id_kebutuhan_khusus_mahasiswa']);
		$this->nisn->setDbValue($row['nisn']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['Nim'] = NULL;
		$row['Nama_Mhs'] = NULL;
		$row['Kode_jp'] = NULL;
		$row['Tmp_Lahir'] = NULL;
		$row['Tgl_Lahir'] = NULL;
		$row['Jenis_Kel'] = NULL;
		$row['Gol_darah'] = NULL;
		$row['Agama_Mhs'] = NULL;
		$row['Alamat_Mhs'] = NULL;
		$row['rt'] = NULL;
		$row['rw'] = NULL;
		$row['Kelurahan'] = NULL;
		$row['Kecamatan'] = NULL;
		$row['Kota_Mhs'] = NULL;
		$row['Provinsi_mhs'] = NULL;
		$row['Kodepos_Mhs'] = NULL;
		$row['Tlp_Mhs'] = NULL;
		$row['TlpRumah'] = NULL;
		$row['Email'] = NULL;
		$row['Status_Akd'] = NULL;
		$row['ThMasuk'] = NULL;
		$row['tglmasuk'] = NULL;
		$row['Status_Masuk'] = NULL;
		$row['Sem_Masuk'] = NULL;
		$row['TaMasuk'] = NULL;
		$row['PerMasuk'] = NULL;
		$row['Pendidikan_Akhir'] = NULL;
		$row['Jurusan'] = NULL;
		$row['Thn_Selesai'] = NULL;
		$row['Kota_Pdkk'] = NULL;
		$row['propinsi'] = NULL;
		$row['NIMASAL'] = NULL;
		$row['KPTSASAL'] = NULL;
		$row['JENASAL'] = NULL;
		$row['PSASAL'] = NULL;
		$row['TSKSDIAKUI'] = NULL;
		$row['NamaSekolahAsal'] = NULL;
		$row['AlamatSekolahAsal'] = NULL;
		$row['Status'] = NULL;
		$row['Photo'] = NULL;
		$row['Password'] = NULL;
		$row['Gelombang'] = NULL;
		$row['JalurMasuk'] = NULL;
		$row['Konsentrasi'] = NULL;
		$row['NIK'] = NULL;
		$row['NamaIbu'] = NULL;
		$row['BekerjaDi'] = NULL;
		$row['Lama'] = NULL;
		$row['AlamatPerusahaan'] = NULL;
		$row['TlpPerusahaan'] = NULL;
		$row['Posisi'] = NULL;
		$row['Departemen'] = NULL;
		$row['IdUser'] = NULL;
		$row['TempID'] = NULL;
		$row['xphoto'] = NULL;
		$row['profile'] = NULL;
		$row['id_agama'] = NULL;
		$row['id_negara'] = NULL;
		$row['id_wilayah'] = NULL;
		$row['id_jenis_tinggal'] = NULL;
		$row['id_alat_transportasi'] = NULL;
		$row['no_kps'] = NULL;
		$row['penerima_kps'] = NULL;
		$row['id_kebutuhan_khusus_mahasiswa'] = NULL;
		$row['nisn'] = NULL;
		return $row;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Call Row_Rendering event

		$this->Row_Rendering();

		// Common render codes for all row types
		// Nim
		// Nama_Mhs
		// Kode_jp
		// Tmp_Lahir
		// Tgl_Lahir
		// Jenis_Kel
		// Gol_darah
		// Agama_Mhs
		// Alamat_Mhs
		// rt
		// rw
		// Kelurahan
		// Kecamatan
		// Kota_Mhs
		// Provinsi_mhs
		// Kodepos_Mhs
		// Tlp_Mhs
		// TlpRumah
		// Email
		// Status_Akd
		// ThMasuk
		// tglmasuk
		// Status_Masuk
		// Sem_Masuk
		// TaMasuk
		// PerMasuk
		// Pendidikan_Akhir
		// Jurusan
		// Thn_Selesai
		// Kota_Pdkk
		// propinsi
		// NIMASAL
		// KPTSASAL
		// JENASAL
		// PSASAL
		// TSKSDIAKUI
		// NamaSekolahAsal
		// AlamatSekolahAsal
		// Status
		// Photo
		// Password
		// Gelombang
		// JalurMasuk
		// Konsentrasi
		// NIK
		// NamaIbu
		// BekerjaDi
		// Lama
		// AlamatPerusahaan
		// TlpPerusahaan
		// Posisi
		// Departemen
		// IdUser
		// TempID
		// xphoto
		// profile
		// id_agama
		// id_negara
		// id_wilayah
		// id_jenis_tinggal
		// id_alat_transportasi
		// no_kps
		// penerima_kps
		// id_kebutuhan_khusus_mahasiswa
		// nisn

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// Nim
			$this->Nim->ViewValue = $this->Nim->CurrentValue;
			$this->Nim->ViewCustomAttributes = "";

			// Nama_Mhs
			$this->Nama_Mhs->ViewValue = $this->Nama_Mhs->CurrentValue;
			$this->Nama_Mhs->ViewCustomAttributes = "";

			// Kode_jp
			$curVal = strval($this->Kode_jp->CurrentValue);
			if ($curVal != "") {
				$this->Kode_jp->ViewValue = $this->Kode_jp->lookupCacheOption($curVal);
				if ($this->Kode_jp->ViewValue === NULL) { // Lookup from database
					$filterWrk = "[Kode_Jp]" . SearchString("=", $curVal, DATATYPE_STRING, "");
					$sqlWrk = $this->Kode_jp->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = [];
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$arwrk[3] = $rswrk->fields('df3');
						$this->Kode_jp->ViewValue = $this->Kode_jp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->Kode_jp->ViewValue = $this->Kode_jp->CurrentValue;
					}
				}
			} else {
				$this->Kode_jp->ViewValue = NULL;
			}
			$this->Kode_jp->ViewCustomAttributes = "";

			// Tmp_Lahir
			$this->Tmp_Lahir->ViewValue = $this->Tmp_Lahir->CurrentValue;
			$this->Tmp_Lahir->ViewCustomAttributes = "";

			// Tgl_Lahir
			$this->Tgl_Lahir->ViewValue = $this->Tgl_Lahir->CurrentValue;
			$this->Tgl_Lahir->ViewValue = FormatDateTime($this->Tgl_Lahir->ViewValue, 0);
			$this->Tgl_Lahir->ViewCustomAttributes = "";

			// Jenis_Kel
			$this->Jenis_Kel->ViewValue = $this->Jenis_Kel->CurrentValue;
			$this->Jenis_Kel->ViewCustomAttributes = "";

			// Gol_darah
			$this->Gol_darah->ViewValue = $this->Gol_darah->CurrentValue;
			$this->Gol_darah->ViewCustomAttributes = "";

			// Agama_Mhs
			$this->Agama_Mhs->ViewValue = $this->Agama_Mhs->CurrentValue;
			$this->Agama_Mhs->ViewCustomAttributes = "";

			// Alamat_Mhs
			$this->Alamat_Mhs->ViewValue = $this->Alamat_Mhs->CurrentValue;
			$this->Alamat_Mhs->ViewCustomAttributes = "";

			// rt
			$this->rt->ViewValue = $this->rt->CurrentValue;
			$this->rt->ViewCustomAttributes = "";

			// rw
			$this->rw->ViewValue = $this->rw->CurrentValue;
			$this->rw->ViewCustomAttributes = "";

			// Kelurahan
			$this->Kelurahan->ViewValue = $this->Kelurahan->CurrentValue;
			$this->Kelurahan->ViewCustomAttributes = "";

			// Kecamatan
			$this->Kecamatan->ViewValue = $this->Kecamatan->CurrentValue;
			$this->Kecamatan->ViewCustomAttributes = "";

			// Kota_Mhs
			$this->Kota_Mhs->ViewValue = $this->Kota_Mhs->CurrentValue;
			$this->Kota_Mhs->ViewCustomAttributes = "";

			// Provinsi_mhs
			$this->Provinsi_mhs->ViewValue = $this->Provinsi_mhs->CurrentValue;
			$this->Provinsi_mhs->ViewCustomAttributes = "";

			// Kodepos_Mhs
			$this->Kodepos_Mhs->ViewValue = $this->Kodepos_Mhs->CurrentValue;
			$this->Kodepos_Mhs->ViewCustomAttributes = "";

			// Tlp_Mhs
			$this->Tlp_Mhs->ViewValue = $this->Tlp_Mhs->CurrentValue;
			$this->Tlp_Mhs->ViewCustomAttributes = "";

			// TlpRumah
			$this->TlpRumah->ViewValue = $this->TlpRumah->CurrentValue;
			$this->TlpRumah->ViewCustomAttributes = "";

			// Email
			$this->_Email->ViewValue = $this->_Email->CurrentValue;
			$this->_Email->ViewCustomAttributes = "";

			// Status_Akd
			$this->Status_Akd->ViewValue = $this->Status_Akd->CurrentValue;
			$this->Status_Akd->ViewCustomAttributes = "";

			// ThMasuk
			$this->ThMasuk->ViewValue = $this->ThMasuk->CurrentValue;
			$this->ThMasuk->ViewCustomAttributes = "";

			// tglmasuk
			$this->tglmasuk->ViewValue = $this->tglmasuk->CurrentValue;
			$this->tglmasuk->ViewValue = FormatDateTime($this->tglmasuk->ViewValue, 0);
			$this->tglmasuk->ViewCustomAttributes = "";

			// Status_Masuk
			$this->Status_Masuk->ViewValue = $this->Status_Masuk->CurrentValue;
			$this->Status_Masuk->ViewCustomAttributes = "";

			// Sem_Masuk
			$this->Sem_Masuk->ViewValue = $this->Sem_Masuk->CurrentValue;
			$this->Sem_Masuk->ViewCustomAttributes = "";

			// TaMasuk
			$this->TaMasuk->ViewValue = $this->TaMasuk->CurrentValue;
			$this->TaMasuk->ViewCustomAttributes = "";

			// PerMasuk
			$this->PerMasuk->ViewValue = $this->PerMasuk->CurrentValue;
			$this->PerMasuk->ViewCustomAttributes = "";

			// Pendidikan_Akhir
			$this->Pendidikan_Akhir->ViewValue = $this->Pendidikan_Akhir->CurrentValue;
			$this->Pendidikan_Akhir->ViewCustomAttributes = "";

			// Jurusan
			$this->Jurusan->ViewValue = $this->Jurusan->CurrentValue;
			$this->Jurusan->ViewCustomAttributes = "";

			// Thn_Selesai
			$this->Thn_Selesai->ViewValue = $this->Thn_Selesai->CurrentValue;
			$this->Thn_Selesai->ViewCustomAttributes = "";

			// Kota_Pdkk
			$this->Kota_Pdkk->ViewValue = $this->Kota_Pdkk->CurrentValue;
			$this->Kota_Pdkk->ViewCustomAttributes = "";

			// propinsi
			$this->propinsi->ViewValue = $this->propinsi->CurrentValue;
			$this->propinsi->ViewCustomAttributes = "";

			// NIMASAL
			$this->NIMASAL->ViewValue = $this->NIMASAL->CurrentValue;
			$this->NIMASAL->ViewCustomAttributes = "";

			// KPTSASAL
			$this->KPTSASAL->ViewValue = $this->KPTSASAL->CurrentValue;
			$this->KPTSASAL->ViewCustomAttributes = "";

			// JENASAL
			$this->JENASAL->ViewValue = $this->JENASAL->CurrentValue;
			$this->JENASAL->ViewCustomAttributes = "";

			// PSASAL
			$this->PSASAL->ViewValue = $this->PSASAL->CurrentValue;
			$this->PSASAL->ViewCustomAttributes = "";

			// TSKSDIAKUI
			$this->TSKSDIAKUI->ViewValue = $this->TSKSDIAKUI->CurrentValue;
			$this->TSKSDIAKUI->ViewValue = FormatNumber($this->TSKSDIAKUI->ViewValue, 0, -2, -2, -2);
			$this->TSKSDIAKUI->ViewCustomAttributes = "";

			// NamaSekolahAsal
			$this->NamaSekolahAsal->ViewValue = $this->NamaSekolahAsal->CurrentValue;
			$this->NamaSekolahAsal->ViewCustomAttributes = "";

			// AlamatSekolahAsal
			$this->AlamatSekolahAsal->ViewValue = $this->AlamatSekolahAsal->CurrentValue;
			$this->AlamatSekolahAsal->ViewCustomAttributes = "";

			// Status
			$this->Status->ViewValue = $this->Status->CurrentValue;
			$this->Status->ViewCustomAttributes = "";

			// Password
			$this->Password->ViewValue = $this->Password->CurrentValue;
			$this->Password->ViewCustomAttributes = "";

			// Gelombang
			$this->Gelombang->ViewValue = $this->Gelombang->CurrentValue;
			$this->Gelombang->ViewCustomAttributes = "";

			// JalurMasuk
			$this->JalurMasuk->ViewValue = $this->JalurMasuk->CurrentValue;
			$this->JalurMasuk->ViewCustomAttributes = "";

			// Konsentrasi
			$this->Konsentrasi->ViewValue = $this->Konsentrasi->CurrentValue;
			$this->Konsentrasi->ViewCustomAttributes = "";

			// NIK
			$this->NIK->ViewValue = $this->NIK->CurrentValue;
			$this->NIK->ViewCustomAttributes = "";

			// NamaIbu
			$this->NamaIbu->ViewValue = $this->NamaIbu->CurrentValue;
			$this->NamaIbu->ViewCustomAttributes = "";

			// BekerjaDi
			$this->BekerjaDi->ViewValue = $this->BekerjaDi->CurrentValue;
			$this->BekerjaDi->ViewCustomAttributes = "";

			// Lama
			$this->Lama->ViewValue = $this->Lama->CurrentValue;
			$this->Lama->ViewCustomAttributes = "";

			// AlamatPerusahaan
			$this->AlamatPerusahaan->ViewValue = $this->AlamatPerusahaan->CurrentValue;
			$this->AlamatPerusahaan->ViewCustomAttributes = "";

			// TlpPerusahaan
			$this->TlpPerusahaan->ViewValue = $this->TlpPerusahaan->CurrentValue;
			$this->TlpPerusahaan->ViewCustomAttributes = "";

			// Posisi
			$this->Posisi->ViewValue = $this->Posisi->CurrentValue;
			$this->Posisi->ViewCustomAttributes = "";

			// Departemen
			$this->Departemen->ViewValue = $this->Departemen->CurrentValue;
			$this->Departemen->ViewCustomAttributes = "";

			// IdUser
			$this->IdUser->ViewValue = $this->IdUser->CurrentValue;
			$this->IdUser->ViewCustomAttributes = "";

			// TempID
			$this->TempID->ViewValue = $this->TempID->CurrentValue;
			$this->TempID->ViewValue = FormatNumber($this->TempID->ViewValue, 0, -2, -2, -2);
			$this->TempID->ViewCustomAttributes = "";

			// xphoto
			$this->xphoto->ViewValue = $this->xphoto->CurrentValue;
			$this->xphoto->ViewCustomAttributes = "";

			// profile
			$this->profile->ViewValue = $this->profile->CurrentValue;
			$this->profile->ViewCustomAttributes = "";

			// id_agama
			$this->id_agama->ViewValue = $this->id_agama->CurrentValue;
			$this->id_agama->ViewValue = FormatNumber($this->id_agama->ViewValue, 0, -2, -2, -2);
			$this->id_agama->ViewCustomAttributes = "";

			// id_negara
			$this->id_negara->ViewValue = $this->id_negara->CurrentValue;
			$this->id_negara->ViewCustomAttributes = "";

			// id_wilayah
			$this->id_wilayah->ViewValue = $this->id_wilayah->CurrentValue;
			$this->id_wilayah->ViewCustomAttributes = "";

			// id_jenis_tinggal
			$this->id_jenis_tinggal->ViewValue = $this->id_jenis_tinggal->CurrentValue;
			$this->id_jenis_tinggal->ViewValue = FormatNumber($this->id_jenis_tinggal->ViewValue, 0, -2, -2, -2);
			$this->id_jenis_tinggal->ViewCustomAttributes = "";

			// id_alat_transportasi
			$this->id_alat_transportasi->ViewValue = $this->id_alat_transportasi->CurrentValue;
			$this->id_alat_transportasi->ViewValue = FormatNumber($this->id_alat_transportasi->ViewValue, 0, -2, -2, -2);
			$this->id_alat_transportasi->ViewCustomAttributes = "";

			// no_kps
			$this->no_kps->ViewValue = $this->no_kps->CurrentValue;
			$this->no_kps->ViewCustomAttributes = "";

			// penerima_kps
			$this->penerima_kps->ViewValue = $this->penerima_kps->CurrentValue;
			$this->penerima_kps->ViewValue = FormatNumber($this->penerima_kps->ViewValue, 0, -2, -2, -2);
			$this->penerima_kps->ViewCustomAttributes = "";

			// id_kebutuhan_khusus_mahasiswa
			$this->id_kebutuhan_khusus_mahasiswa->ViewValue = $this->id_kebutuhan_khusus_mahasiswa->CurrentValue;
			$this->id_kebutuhan_khusus_mahasiswa->ViewValue = FormatNumber($this->id_kebutuhan_khusus_mahasiswa->ViewValue, 0, -2, -2, -2);
			$this->id_kebutuhan_khusus_mahasiswa->ViewCustomAttributes = "";

			// nisn
			$this->nisn->ViewValue = $this->nisn->CurrentValue;
			$this->nisn->ViewCustomAttributes = "";

			// Nim
			$this->Nim->LinkCustomAttributes = "";
			$this->Nim->HrefValue = "";
			$this->Nim->TooltipValue = "";

			// Nama_Mhs
			$this->Nama_Mhs->LinkCustomAttributes = "";
			$this->Nama_Mhs->HrefValue = "";
			$this->Nama_Mhs->TooltipValue = "";

			// Kode_jp
			$this->Kode_jp->LinkCustomAttributes = "";
			$this->Kode_jp->HrefValue = "";
			$this->Kode_jp->TooltipValue = "";

			// Tlp_Mhs
			$this->Tlp_Mhs->LinkCustomAttributes = "";
			$this->Tlp_Mhs->HrefValue = "";
			$this->Tlp_Mhs->TooltipValue = "";

			// Email
			$this->_Email->LinkCustomAttributes = "";
			$this->_Email->HrefValue = "";
			$this->_Email->TooltipValue = "";

			// Status_Akd
			$this->Status_Akd->LinkCustomAttributes = "";
			$this->Status_Akd->HrefValue = "";
			$this->Status_Akd->TooltipValue = "";

			// Status_Masuk
			$this->Status_Masuk->LinkCustomAttributes = "";
			$this->Status_Masuk->HrefValue = "";
			$this->Status_Masuk->TooltipValue = "";

			// Sem_Masuk
			$this->Sem_Masuk->LinkCustomAttributes = "";
			$this->Sem_Masuk->HrefValue = "";
			$this->Sem_Masuk->TooltipValue = "";

			// TaMasuk
			$this->TaMasuk->LinkCustomAttributes = "";
			$this->TaMasuk->HrefValue = "";
			$this->TaMasuk->TooltipValue = "";

			// PerMasuk
			$this->PerMasuk->LinkCustomAttributes = "";
			$this->PerMasuk->HrefValue = "";
			$this->PerMasuk->TooltipValue = "";

			// Status
			$this->Status->LinkCustomAttributes = "";
			$this->Status->HrefValue = "";
			$this->Status->TooltipValue = "";
		}

		// Call Row Rendered event
		if ($this->RowType != ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Delete records based on current filter
	protected function deleteRows()
	{
		global $Language, $Security;
		if (!$Security->canDelete()) {
			$this->setFailureMessage($Language->phrase("NoDeletePermission")); // No delete permission
			return FALSE;
		}
		$deleteRows = TRUE;
		$sql = $this->getCurrentSql();
		$conn = $this->getConnection();
		$conn->raiseErrorFn = Config("ERROR_FUNC");
		$rs = $conn->execute($sql);
		$conn->raiseErrorFn = "";
		if ($rs === FALSE) {
			return FALSE;
		} elseif ($rs->EOF) {
			$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
			$rs->close();
			return FALSE;
		}
		$rows = ($rs) ? $rs->getRows() : [];
		$conn->beginTrans();

		// Clone old rows
		$rsold = $rows;
		if ($rs)
			$rs->close();

		// Call row deleting event
		if ($deleteRows) {
			foreach ($rsold as $row) {
				$deleteRows = $this->Row_Deleting($row);
				if (!$deleteRows)
					break;
			}
		}
		if ($deleteRows) {
			$key = "";
			foreach ($rsold as $row) {
				$thisKey = "";
				if ($thisKey != "")
					$thisKey .= Config("COMPOSITE_KEY_SEPARATOR");
				$thisKey .= $row['Nim'];
				if (Config("DELETE_UPLOADED_FILES")) // Delete old files
					$this->deleteUploadedFiles($row);
				$conn->raiseErrorFn = Config("ERROR_FUNC");
				$deleteRows = $this->delete($row); // Delete
				$conn->raiseErrorFn = "";
				if ($deleteRows === FALSE)
					break;
				if ($key != "")
					$key .= ", ";
				$key .= $thisKey;
			}
		}
		if (!$deleteRows) {

			// Set up error message
			if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage != "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->phrase("DeleteCancelled"));
			}
		}
		if ($deleteRows) {
			$conn->commitTrans(); // Commit the changes
		} else {
			$conn->rollbackTrans(); // Rollback changes
		}

		// Call Row Deleted event
		if ($deleteRows) {
			foreach ($rsold as $row) {
				$this->Row_Deleted($row);
			}
		}

		// Write JSON for API request (Support single row only)
		if (IsApi() && $deleteRows) {
			$row = $this->getRecordsFromRecordset($rsold, TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $deleteRows;
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("tblMHSlist.php"), "", $this->TableVar, TRUE);
		$pageId = "delete";
		$Breadcrumb->add("delete", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// Get default connection and filter
			$conn = $this->getConnection();
			$lookupFilter = "";

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL and connection
			switch ($fld->FieldVar) {
				case "x_Kode_jp":
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0) {
				$totalCnt = $this->getRecordCount($sql, $conn);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_Kode_jp":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}
} // End class
?>