<?php
namespace PHPMaker2020\baak;

/**
 * Page class
 */
class tblMHS_edit extends tblMHS
{

	// Page ID
	public $PageID = "edit";

	// Project ID
	public $ProjectID = "{A09D3AFF-419C-4918-948A-A3C8469EA234}";

	// Table name
	public $TableName = 'tblMHS';

	// Page object name
	public $PageObjName = "tblMHS_edit";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken;

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading != "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading != "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		$url = CurrentPageName() . "?";
		if ($this->UseTokenInUrl)
			$url .= "t=" . $this->TableVar . "&"; // Add page token
		return $url;
	}

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = TRUE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message != "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fas fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage != "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fas fa-exclamation"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage != "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fas fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage != "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fas fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = [];

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message != "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage != "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage != "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage != "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header != "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer != "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(Config("TOKEN_NAME")) === NULL)
			return FALSE;
		$fn = Config("CHECK_TOKEN_FUNC");
		if (is_callable($fn))
			return $fn(Post(Config("TOKEN_NAME")), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = Config("CREATE_TOKEN_FUNC"); // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $DashboardReport;
		global $UserTable;

		// Check token
		$this->CheckToken = Config("CHECK_TOKEN");

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (tblMHS)
		if (!isset($GLOBALS["tblMHS"]) || get_class($GLOBALS["tblMHS"]) == PROJECT_NAMESPACE . "tblMHS") {
			$GLOBALS["tblMHS"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["tblMHS"];
		}

		// Table object (Pass)
		if (!isset($GLOBALS['Pass']))
			$GLOBALS['Pass'] = new Pass();

		// Page ID (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'edit');

		// Table name (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'tblMHS');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = $this->getConnection();

		// User table object (Pass)
		$UserTable = $UserTable ?: new Pass();
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages, $DashboardReport;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $tblMHS;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, Config("EXPORT_CLASSES"))) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . Config("EXPORT_CLASSES." . $this->CustomExport);
			if (class_exists($class)) {
				$doc = new $class($tblMHS);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url != "") {
			if (!Config("DEBUG") && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = ["url" => $url, "modal" => "1"];
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "tblMHSview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = [];
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = [];
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {
								$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
									Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
									Config("API_FIELD_NAME") . "=" . $fld->Param . "&" .
									Config("API_KEY_NAME") . "=" . rawurlencode($this->getRecordKeyValue($ar)))); //*** need to add this? API may not be in the same folder
								$row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
								$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
									Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
									"fn=" . Encrypt($fld->physicalUploadPath() . $val)));
								$row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
							} else { // Multiple files
								$files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
								$ar = [];
								foreach ($files as $file) {
									$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
										Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
										"fn=" . Encrypt($fld->physicalUploadPath() . $file)));
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['Nim'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
	}

	// Lookup data
	public function lookup()
	{
		global $Language, $Security;
		if (!isset($Language))
			$Language = new Language(Config("LANGUAGE_FOLDER"), Post("language", ""));

		// Set up API request
		if (!ValidApiRequest())
			return FALSE;
		$this->setupApiSecurity();

		// Get lookup object
		$fieldName = Post("field");
		if (!array_key_exists($fieldName, $this->fields))
			return FALSE;
		$lookupField = $this->fields[$fieldName];
		$lookup = $lookupField->Lookup;
		if ($lookup === NULL)
			return FALSE;
		$tbl = $lookup->getTable();
		if (!$Security->allowLookup(Config("PROJECT_ID") . $tbl->TableName)) // Lookup permission
			return FALSE;

		// Get lookup parameters
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Param("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
			$lookup->FilterFields = []; // Skip parent fields if any
			$lookup->FilterValues[] = $keys; // Lookup values
			$pageSize = -1; // Show all records
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect != "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter != "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy != "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson($this); // Use settings from current page
	}

	// Set up API security
	public function setupApiSecurity()
	{
		global $Security;

		// Setup security for API request
		if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
		$Security->loadCurrentUserLevel(Config("PROJECT_ID") . $this->TableName);
		if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
	}
	public $FormClassName = "ew-horizontal ew-form ew-edit-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $DbMasterFilter;
	public $DbDetailFilter;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		if (ValidApiRequest()) { // API request
			$this->setupApiSecurity(); // Set up API Security
			if (!$Security->canEdit()) {
				SetStatus(401); // Unauthorized
				return;
			}
		} else {
			$Security = new AdvancedSecurity();
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canEdit()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("tblMHSlist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->Nim->setVisibility();
		$this->Nama_Mhs->setVisibility();
		$this->Kode_jp->setVisibility();
		$this->Tmp_Lahir->setVisibility();
		$this->Tgl_Lahir->setVisibility();
		$this->Jenis_Kel->setVisibility();
		$this->Gol_darah->setVisibility();
		$this->Agama_Mhs->setVisibility();
		$this->Alamat_Mhs->setVisibility();
		$this->rt->setVisibility();
		$this->rw->setVisibility();
		$this->Kelurahan->setVisibility();
		$this->Kecamatan->setVisibility();
		$this->Kota_Mhs->setVisibility();
		$this->Provinsi_mhs->setVisibility();
		$this->Kodepos_Mhs->setVisibility();
		$this->Tlp_Mhs->setVisibility();
		$this->TlpRumah->setVisibility();
		$this->_Email->setVisibility();
		$this->Status_Akd->setVisibility();
		$this->ThMasuk->Visible = FALSE;
		$this->tglmasuk->setVisibility();
		$this->Status_Masuk->setVisibility();
		$this->Sem_Masuk->setVisibility();
		$this->TaMasuk->setVisibility();
		$this->PerMasuk->setVisibility();
		$this->Pendidikan_Akhir->Visible = FALSE;
		$this->Jurusan->Visible = FALSE;
		$this->Thn_Selesai->setVisibility();
		$this->Kota_Pdkk->Visible = FALSE;
		$this->propinsi->Visible = FALSE;
		$this->NIMASAL->Visible = FALSE;
		$this->KPTSASAL->Visible = FALSE;
		$this->JENASAL->Visible = FALSE;
		$this->PSASAL->Visible = FALSE;
		$this->TSKSDIAKUI->Visible = FALSE;
		$this->NamaSekolahAsal->Visible = FALSE;
		$this->AlamatSekolahAsal->Visible = FALSE;
		$this->Status->setVisibility();
		$this->Photo->Visible = FALSE;
		$this->Password->Visible = FALSE;
		$this->Gelombang->Visible = FALSE;
		$this->JalurMasuk->Visible = FALSE;
		$this->Konsentrasi->Visible = FALSE;
		$this->NIK->setVisibility();
		$this->NamaIbu->setVisibility();
		$this->BekerjaDi->Visible = FALSE;
		$this->Lama->Visible = FALSE;
		$this->AlamatPerusahaan->Visible = FALSE;
		$this->TlpPerusahaan->Visible = FALSE;
		$this->Posisi->Visible = FALSE;
		$this->Departemen->Visible = FALSE;
		$this->IdUser->Visible = FALSE;
		$this->TempID->Visible = FALSE;
		$this->xphoto->Visible = FALSE;
		$this->profile->Visible = FALSE;
		$this->id_agama->Visible = FALSE;
		$this->id_negara->Visible = FALSE;
		$this->id_wilayah->Visible = FALSE;
		$this->id_jenis_tinggal->Visible = FALSE;
		$this->id_alat_transportasi->Visible = FALSE;
		$this->no_kps->Visible = FALSE;
		$this->penerima_kps->Visible = FALSE;
		$this->id_kebutuhan_khusus_mahasiswa->Visible = FALSE;
		$this->nisn->Visible = FALSE;
		$this->iddesa->setVisibility();
		$this->MulaiKerja->setVisibility();
		$this->IdKlsKerjasama->setVisibility();
		$this->IDBeasiswa->setVisibility();
		$this->tglKonversi->setVisibility();
		$this->NoSuratKonversi->setVisibility();
		$this->Nopen->setVisibility();
		$this->id_feedmhs->setVisibility();
		$this->hideFieldsForAddEdit();
		$this->Nim->Required = FALSE;

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->Kode_jp);
		$this->setupLookupOptions($this->Status_Akd);
		$this->setupLookupOptions($this->TaMasuk);

		// Check permission
		if (!$Security->canEdit()) {
			$this->setFailureMessage(DeniedMessage()); // No permission
			$this->terminate("tblMHSlist.php");
			return;
		}

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-edit-form ew-horizontal";
		$loaded = FALSE;
		$postBack = FALSE;

		// Set up current action and primary key
		if (IsApi()) {

			// Load key values
			$loaded = TRUE;
			if (Get("Nim") !== NULL) {
				$this->Nim->setQueryStringValue(Get("Nim"));
				$this->Nim->setOldValue($this->Nim->QueryStringValue);
			} elseif (Key(0) !== NULL) {
				$this->Nim->setQueryStringValue(Key(0));
				$this->Nim->setOldValue($this->Nim->QueryStringValue);
			} elseif (Post("Nim") !== NULL) {
				$this->Nim->setFormValue(Post("Nim"));
				$this->Nim->setOldValue($this->Nim->FormValue);
			} elseif (Route(2) !== NULL) {
				$this->Nim->setQueryStringValue(Route(2));
				$this->Nim->setOldValue($this->Nim->QueryStringValue);
			} else {
				$loaded = FALSE; // Unable to load key
			}

			// Load record
			if ($loaded)
				$loaded = $this->loadRow();
			if (!$loaded) {
				$this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
				$this->terminate();
				return;
			}
			$this->CurrentAction = "update"; // Update record directly
			$postBack = TRUE;
		} else {
			if (Post("action") !== NULL) {
				$this->CurrentAction = Post("action"); // Get action code
				if (!$this->isShow()) // Not reload record, handle as postback
					$postBack = TRUE;

				// Load key from Form
				if ($CurrentForm->hasValue("x_Nim")) {
					$this->Nim->setFormValue($CurrentForm->getValue("x_Nim"));
				}
			} else {
				$this->CurrentAction = "show"; // Default action is display

				// Load key from QueryString / Route
				$loadByQuery = FALSE;
				if (Get("Nim") !== NULL) {
					$this->Nim->setQueryStringValue(Get("Nim"));
					$loadByQuery = TRUE;
				} elseif (Route(2) !== NULL) {
					$this->Nim->setQueryStringValue(Route(2));
					$loadByQuery = TRUE;
				} else {
					$this->Nim->CurrentValue = NULL;
				}
			}

			// Load current record
			$loaded = $this->loadRow();
		}

		// Process form if post back
		if ($postBack) {
			$this->loadFormValues(); // Get form values

			// Set up detail parameters
			$this->setupDetailParms();
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->validateForm()) {
				$this->setFailureMessage($FormError);
				$this->EventCancelled = TRUE; // Event cancelled
				$this->restoreFormValues();
				if (IsApi()) {
					$this->terminate();
					return;
				} else {
					$this->CurrentAction = ""; // Form error, reset action
				}
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "show": // Get a record to display
				if (!$loaded) { // Load record based on key
					if ($this->getFailureMessage() == "")
						$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
					$this->terminate("tblMHSlist.php"); // No matching record, return to list
				}

				// Set up detail parameters
				$this->setupDetailParms();
				break;
			case "update": // Update
				if ($this->getCurrentDetailTable() != "") // Master/detail edit
					$returnUrl = $this->getViewUrl(Config("TABLE_SHOW_DETAIL") . "=" . $this->getCurrentDetailTable()); // Master/Detail view page
				else
					$returnUrl = $this->getReturnUrl();
				if (GetPageName($returnUrl) == "tblMHSlist.php")
					$returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
				$this->SendEmail = TRUE; // Send email on update success
				if ($this->editRow()) { // Update record based on key
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Update success
					if (IsApi()) {
						$this->terminate(TRUE);
						return;
					} else {
						$this->terminate($returnUrl); // Return to caller
					}
				} elseif (IsApi()) { // API request, return
					$this->terminate();
					return;
				} elseif ($this->getFailureMessage() == $Language->phrase("NoRecord")) {
					$this->terminate($returnUrl); // Return to caller
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->restoreFormValues(); // Restore form values if update failed

					// Set up detail parameters
					$this->setupDetailParms();
				}
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Render the record
		$this->RowType = ROWTYPE_EDIT; // Render as Edit
		$this->resetAttributes();
		$this->renderRow();
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;

		// Check field name 'Nim' first before field var 'x_Nim'
		$val = $CurrentForm->hasValue("Nim") ? $CurrentForm->getValue("Nim") : $CurrentForm->getValue("x_Nim");
		if (!$this->Nim->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->Nim->Visible = FALSE; // Disable update for API request
			else
				$this->Nim->setFormValue($val);
		}

		// Check field name 'Nama_Mhs' first before field var 'x_Nama_Mhs'
		$val = $CurrentForm->hasValue("Nama_Mhs") ? $CurrentForm->getValue("Nama_Mhs") : $CurrentForm->getValue("x_Nama_Mhs");
		if (!$this->Nama_Mhs->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->Nama_Mhs->Visible = FALSE; // Disable update for API request
			else
				$this->Nama_Mhs->setFormValue($val);
		}

		// Check field name 'Kode_jp' first before field var 'x_Kode_jp'
		$val = $CurrentForm->hasValue("Kode_jp") ? $CurrentForm->getValue("Kode_jp") : $CurrentForm->getValue("x_Kode_jp");
		if (!$this->Kode_jp->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->Kode_jp->Visible = FALSE; // Disable update for API request
			else
				$this->Kode_jp->setFormValue($val);
		}

		// Check field name 'Tmp_Lahir' first before field var 'x_Tmp_Lahir'
		$val = $CurrentForm->hasValue("Tmp_Lahir") ? $CurrentForm->getValue("Tmp_Lahir") : $CurrentForm->getValue("x_Tmp_Lahir");
		if (!$this->Tmp_Lahir->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->Tmp_Lahir->Visible = FALSE; // Disable update for API request
			else
				$this->Tmp_Lahir->setFormValue($val);
		}

		// Check field name 'Tgl_Lahir' first before field var 'x_Tgl_Lahir'
		$val = $CurrentForm->hasValue("Tgl_Lahir") ? $CurrentForm->getValue("Tgl_Lahir") : $CurrentForm->getValue("x_Tgl_Lahir");
		if (!$this->Tgl_Lahir->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->Tgl_Lahir->Visible = FALSE; // Disable update for API request
			else
				$this->Tgl_Lahir->setFormValue($val);
			$this->Tgl_Lahir->CurrentValue = UnFormatDateTime($this->Tgl_Lahir->CurrentValue, 0);
		}

		// Check field name 'Jenis_Kel' first before field var 'x_Jenis_Kel'
		$val = $CurrentForm->hasValue("Jenis_Kel") ? $CurrentForm->getValue("Jenis_Kel") : $CurrentForm->getValue("x_Jenis_Kel");
		if (!$this->Jenis_Kel->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->Jenis_Kel->Visible = FALSE; // Disable update for API request
			else
				$this->Jenis_Kel->setFormValue($val);
		}

		// Check field name 'Gol_darah' first before field var 'x_Gol_darah'
		$val = $CurrentForm->hasValue("Gol_darah") ? $CurrentForm->getValue("Gol_darah") : $CurrentForm->getValue("x_Gol_darah");
		if (!$this->Gol_darah->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->Gol_darah->Visible = FALSE; // Disable update for API request
			else
				$this->Gol_darah->setFormValue($val);
		}

		// Check field name 'Agama_Mhs' first before field var 'x_Agama_Mhs'
		$val = $CurrentForm->hasValue("Agama_Mhs") ? $CurrentForm->getValue("Agama_Mhs") : $CurrentForm->getValue("x_Agama_Mhs");
		if (!$this->Agama_Mhs->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->Agama_Mhs->Visible = FALSE; // Disable update for API request
			else
				$this->Agama_Mhs->setFormValue($val);
		}

		// Check field name 'Alamat_Mhs' first before field var 'x_Alamat_Mhs'
		$val = $CurrentForm->hasValue("Alamat_Mhs") ? $CurrentForm->getValue("Alamat_Mhs") : $CurrentForm->getValue("x_Alamat_Mhs");
		if (!$this->Alamat_Mhs->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->Alamat_Mhs->Visible = FALSE; // Disable update for API request
			else
				$this->Alamat_Mhs->setFormValue($val);
		}

		// Check field name 'rt' first before field var 'x_rt'
		$val = $CurrentForm->hasValue("rt") ? $CurrentForm->getValue("rt") : $CurrentForm->getValue("x_rt");
		if (!$this->rt->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->rt->Visible = FALSE; // Disable update for API request
			else
				$this->rt->setFormValue($val);
		}

		// Check field name 'rw' first before field var 'x_rw'
		$val = $CurrentForm->hasValue("rw") ? $CurrentForm->getValue("rw") : $CurrentForm->getValue("x_rw");
		if (!$this->rw->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->rw->Visible = FALSE; // Disable update for API request
			else
				$this->rw->setFormValue($val);
		}

		// Check field name 'Kelurahan' first before field var 'x_Kelurahan'
		$val = $CurrentForm->hasValue("Kelurahan") ? $CurrentForm->getValue("Kelurahan") : $CurrentForm->getValue("x_Kelurahan");
		if (!$this->Kelurahan->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->Kelurahan->Visible = FALSE; // Disable update for API request
			else
				$this->Kelurahan->setFormValue($val);
		}

		// Check field name 'Kecamatan' first before field var 'x_Kecamatan'
		$val = $CurrentForm->hasValue("Kecamatan") ? $CurrentForm->getValue("Kecamatan") : $CurrentForm->getValue("x_Kecamatan");
		if (!$this->Kecamatan->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->Kecamatan->Visible = FALSE; // Disable update for API request
			else
				$this->Kecamatan->setFormValue($val);
		}

		// Check field name 'Kota_Mhs' first before field var 'x_Kota_Mhs'
		$val = $CurrentForm->hasValue("Kota_Mhs") ? $CurrentForm->getValue("Kota_Mhs") : $CurrentForm->getValue("x_Kota_Mhs");
		if (!$this->Kota_Mhs->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->Kota_Mhs->Visible = FALSE; // Disable update for API request
			else
				$this->Kota_Mhs->setFormValue($val);
		}

		// Check field name 'Provinsi_mhs' first before field var 'x_Provinsi_mhs'
		$val = $CurrentForm->hasValue("Provinsi_mhs") ? $CurrentForm->getValue("Provinsi_mhs") : $CurrentForm->getValue("x_Provinsi_mhs");
		if (!$this->Provinsi_mhs->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->Provinsi_mhs->Visible = FALSE; // Disable update for API request
			else
				$this->Provinsi_mhs->setFormValue($val);
		}

		// Check field name 'Kodepos_Mhs' first before field var 'x_Kodepos_Mhs'
		$val = $CurrentForm->hasValue("Kodepos_Mhs") ? $CurrentForm->getValue("Kodepos_Mhs") : $CurrentForm->getValue("x_Kodepos_Mhs");
		if (!$this->Kodepos_Mhs->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->Kodepos_Mhs->Visible = FALSE; // Disable update for API request
			else
				$this->Kodepos_Mhs->setFormValue($val);
		}

		// Check field name 'Tlp_Mhs' first before field var 'x_Tlp_Mhs'
		$val = $CurrentForm->hasValue("Tlp_Mhs") ? $CurrentForm->getValue("Tlp_Mhs") : $CurrentForm->getValue("x_Tlp_Mhs");
		if (!$this->Tlp_Mhs->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->Tlp_Mhs->Visible = FALSE; // Disable update for API request
			else
				$this->Tlp_Mhs->setFormValue($val);
		}

		// Check field name 'TlpRumah' first before field var 'x_TlpRumah'
		$val = $CurrentForm->hasValue("TlpRumah") ? $CurrentForm->getValue("TlpRumah") : $CurrentForm->getValue("x_TlpRumah");
		if (!$this->TlpRumah->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->TlpRumah->Visible = FALSE; // Disable update for API request
			else
				$this->TlpRumah->setFormValue($val);
		}

		// Check field name 'Email' first before field var 'x__Email'
		$val = $CurrentForm->hasValue("Email") ? $CurrentForm->getValue("Email") : $CurrentForm->getValue("x__Email");
		if (!$this->_Email->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->_Email->Visible = FALSE; // Disable update for API request
			else
				$this->_Email->setFormValue($val);
		}

		// Check field name 'Status_Akd' first before field var 'x_Status_Akd'
		$val = $CurrentForm->hasValue("Status_Akd") ? $CurrentForm->getValue("Status_Akd") : $CurrentForm->getValue("x_Status_Akd");
		if (!$this->Status_Akd->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->Status_Akd->Visible = FALSE; // Disable update for API request
			else
				$this->Status_Akd->setFormValue($val);
		}

		// Check field name 'tglmasuk' first before field var 'x_tglmasuk'
		$val = $CurrentForm->hasValue("tglmasuk") ? $CurrentForm->getValue("tglmasuk") : $CurrentForm->getValue("x_tglmasuk");
		if (!$this->tglmasuk->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->tglmasuk->Visible = FALSE; // Disable update for API request
			else
				$this->tglmasuk->setFormValue($val);
			$this->tglmasuk->CurrentValue = UnFormatDateTime($this->tglmasuk->CurrentValue, 7);
		}

		// Check field name 'Status_Masuk' first before field var 'x_Status_Masuk'
		$val = $CurrentForm->hasValue("Status_Masuk") ? $CurrentForm->getValue("Status_Masuk") : $CurrentForm->getValue("x_Status_Masuk");
		if (!$this->Status_Masuk->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->Status_Masuk->Visible = FALSE; // Disable update for API request
			else
				$this->Status_Masuk->setFormValue($val);
		}

		// Check field name 'Sem_Masuk' first before field var 'x_Sem_Masuk'
		$val = $CurrentForm->hasValue("Sem_Masuk") ? $CurrentForm->getValue("Sem_Masuk") : $CurrentForm->getValue("x_Sem_Masuk");
		if (!$this->Sem_Masuk->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->Sem_Masuk->Visible = FALSE; // Disable update for API request
			else
				$this->Sem_Masuk->setFormValue($val);
		}

		// Check field name 'TaMasuk' first before field var 'x_TaMasuk'
		$val = $CurrentForm->hasValue("TaMasuk") ? $CurrentForm->getValue("TaMasuk") : $CurrentForm->getValue("x_TaMasuk");
		if (!$this->TaMasuk->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->TaMasuk->Visible = FALSE; // Disable update for API request
			else
				$this->TaMasuk->setFormValue($val);
		}

		// Check field name 'PerMasuk' first before field var 'x_PerMasuk'
		$val = $CurrentForm->hasValue("PerMasuk") ? $CurrentForm->getValue("PerMasuk") : $CurrentForm->getValue("x_PerMasuk");
		if (!$this->PerMasuk->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->PerMasuk->Visible = FALSE; // Disable update for API request
			else
				$this->PerMasuk->setFormValue($val);
		}

		// Check field name 'Thn_Selesai' first before field var 'x_Thn_Selesai'
		$val = $CurrentForm->hasValue("Thn_Selesai") ? $CurrentForm->getValue("Thn_Selesai") : $CurrentForm->getValue("x_Thn_Selesai");
		if (!$this->Thn_Selesai->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->Thn_Selesai->Visible = FALSE; // Disable update for API request
			else
				$this->Thn_Selesai->setFormValue($val);
		}

		// Check field name 'Status' first before field var 'x_Status'
		$val = $CurrentForm->hasValue("Status") ? $CurrentForm->getValue("Status") : $CurrentForm->getValue("x_Status");
		if (!$this->Status->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->Status->Visible = FALSE; // Disable update for API request
			else
				$this->Status->setFormValue($val);
		}

		// Check field name 'NIK' first before field var 'x_NIK'
		$val = $CurrentForm->hasValue("NIK") ? $CurrentForm->getValue("NIK") : $CurrentForm->getValue("x_NIK");
		if (!$this->NIK->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->NIK->Visible = FALSE; // Disable update for API request
			else
				$this->NIK->setFormValue($val);
		}

		// Check field name 'NamaIbu' first before field var 'x_NamaIbu'
		$val = $CurrentForm->hasValue("NamaIbu") ? $CurrentForm->getValue("NamaIbu") : $CurrentForm->getValue("x_NamaIbu");
		if (!$this->NamaIbu->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->NamaIbu->Visible = FALSE; // Disable update for API request
			else
				$this->NamaIbu->setFormValue($val);
		}

		// Check field name 'iddesa' first before field var 'x_iddesa'
		$val = $CurrentForm->hasValue("iddesa") ? $CurrentForm->getValue("iddesa") : $CurrentForm->getValue("x_iddesa");
		if (!$this->iddesa->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->iddesa->Visible = FALSE; // Disable update for API request
			else
				$this->iddesa->setFormValue($val);
		}

		// Check field name 'MulaiKerja' first before field var 'x_MulaiKerja'
		$val = $CurrentForm->hasValue("MulaiKerja") ? $CurrentForm->getValue("MulaiKerja") : $CurrentForm->getValue("x_MulaiKerja");
		if (!$this->MulaiKerja->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->MulaiKerja->Visible = FALSE; // Disable update for API request
			else
				$this->MulaiKerja->setFormValue($val);
			$this->MulaiKerja->CurrentValue = UnFormatDateTime($this->MulaiKerja->CurrentValue, 0);
		}

		// Check field name 'IdKlsKerjasama' first before field var 'x_IdKlsKerjasama'
		$val = $CurrentForm->hasValue("IdKlsKerjasama") ? $CurrentForm->getValue("IdKlsKerjasama") : $CurrentForm->getValue("x_IdKlsKerjasama");
		if (!$this->IdKlsKerjasama->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->IdKlsKerjasama->Visible = FALSE; // Disable update for API request
			else
				$this->IdKlsKerjasama->setFormValue($val);
		}

		// Check field name 'IDBeasiswa' first before field var 'x_IDBeasiswa'
		$val = $CurrentForm->hasValue("IDBeasiswa") ? $CurrentForm->getValue("IDBeasiswa") : $CurrentForm->getValue("x_IDBeasiswa");
		if (!$this->IDBeasiswa->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->IDBeasiswa->Visible = FALSE; // Disable update for API request
			else
				$this->IDBeasiswa->setFormValue($val);
		}

		// Check field name 'tglKonversi' first before field var 'x_tglKonversi'
		$val = $CurrentForm->hasValue("tglKonversi") ? $CurrentForm->getValue("tglKonversi") : $CurrentForm->getValue("x_tglKonversi");
		if (!$this->tglKonversi->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->tglKonversi->Visible = FALSE; // Disable update for API request
			else
				$this->tglKonversi->setFormValue($val);
			$this->tglKonversi->CurrentValue = UnFormatDateTime($this->tglKonversi->CurrentValue, 0);
		}

		// Check field name 'NoSuratKonversi' first before field var 'x_NoSuratKonversi'
		$val = $CurrentForm->hasValue("NoSuratKonversi") ? $CurrentForm->getValue("NoSuratKonversi") : $CurrentForm->getValue("x_NoSuratKonversi");
		if (!$this->NoSuratKonversi->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->NoSuratKonversi->Visible = FALSE; // Disable update for API request
			else
				$this->NoSuratKonversi->setFormValue($val);
		}

		// Check field name 'Nopen' first before field var 'x_Nopen'
		$val = $CurrentForm->hasValue("Nopen") ? $CurrentForm->getValue("Nopen") : $CurrentForm->getValue("x_Nopen");
		if (!$this->Nopen->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->Nopen->Visible = FALSE; // Disable update for API request
			else
				$this->Nopen->setFormValue($val);
		}

		// Check field name 'id_feedmhs' first before field var 'x_id_feedmhs'
		$val = $CurrentForm->hasValue("id_feedmhs") ? $CurrentForm->getValue("id_feedmhs") : $CurrentForm->getValue("x_id_feedmhs");
		if (!$this->id_feedmhs->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->id_feedmhs->Visible = FALSE; // Disable update for API request
			else
				$this->id_feedmhs->setFormValue($val);
		}
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->Nim->CurrentValue = $this->Nim->FormValue;
		$this->Nama_Mhs->CurrentValue = $this->Nama_Mhs->FormValue;
		$this->Kode_jp->CurrentValue = $this->Kode_jp->FormValue;
		$this->Tmp_Lahir->CurrentValue = $this->Tmp_Lahir->FormValue;
		$this->Tgl_Lahir->CurrentValue = $this->Tgl_Lahir->FormValue;
		$this->Tgl_Lahir->CurrentValue = UnFormatDateTime($this->Tgl_Lahir->CurrentValue, 0);
		$this->Jenis_Kel->CurrentValue = $this->Jenis_Kel->FormValue;
		$this->Gol_darah->CurrentValue = $this->Gol_darah->FormValue;
		$this->Agama_Mhs->CurrentValue = $this->Agama_Mhs->FormValue;
		$this->Alamat_Mhs->CurrentValue = $this->Alamat_Mhs->FormValue;
		$this->rt->CurrentValue = $this->rt->FormValue;
		$this->rw->CurrentValue = $this->rw->FormValue;
		$this->Kelurahan->CurrentValue = $this->Kelurahan->FormValue;
		$this->Kecamatan->CurrentValue = $this->Kecamatan->FormValue;
		$this->Kota_Mhs->CurrentValue = $this->Kota_Mhs->FormValue;
		$this->Provinsi_mhs->CurrentValue = $this->Provinsi_mhs->FormValue;
		$this->Kodepos_Mhs->CurrentValue = $this->Kodepos_Mhs->FormValue;
		$this->Tlp_Mhs->CurrentValue = $this->Tlp_Mhs->FormValue;
		$this->TlpRumah->CurrentValue = $this->TlpRumah->FormValue;
		$this->_Email->CurrentValue = $this->_Email->FormValue;
		$this->Status_Akd->CurrentValue = $this->Status_Akd->FormValue;
		$this->tglmasuk->CurrentValue = $this->tglmasuk->FormValue;
		$this->tglmasuk->CurrentValue = UnFormatDateTime($this->tglmasuk->CurrentValue, 7);
		$this->Status_Masuk->CurrentValue = $this->Status_Masuk->FormValue;
		$this->Sem_Masuk->CurrentValue = $this->Sem_Masuk->FormValue;
		$this->TaMasuk->CurrentValue = $this->TaMasuk->FormValue;
		$this->PerMasuk->CurrentValue = $this->PerMasuk->FormValue;
		$this->Thn_Selesai->CurrentValue = $this->Thn_Selesai->FormValue;
		$this->Status->CurrentValue = $this->Status->FormValue;
		$this->NIK->CurrentValue = $this->NIK->FormValue;
		$this->NamaIbu->CurrentValue = $this->NamaIbu->FormValue;
		$this->iddesa->CurrentValue = $this->iddesa->FormValue;
		$this->MulaiKerja->CurrentValue = $this->MulaiKerja->FormValue;
		$this->MulaiKerja->CurrentValue = UnFormatDateTime($this->MulaiKerja->CurrentValue, 0);
		$this->IdKlsKerjasama->CurrentValue = $this->IdKlsKerjasama->FormValue;
		$this->IDBeasiswa->CurrentValue = $this->IDBeasiswa->FormValue;
		$this->tglKonversi->CurrentValue = $this->tglKonversi->FormValue;
		$this->tglKonversi->CurrentValue = UnFormatDateTime($this->tglKonversi->CurrentValue, 0);
		$this->NoSuratKonversi->CurrentValue = $this->NoSuratKonversi->FormValue;
		$this->Nopen->CurrentValue = $this->Nopen->FormValue;
		$this->id_feedmhs->CurrentValue = $this->id_feedmhs->FormValue;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = $this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->Nim->setDbValue($row['Nim']);
		$this->Nama_Mhs->setDbValue($row['Nama_Mhs']);
		$this->Kode_jp->setDbValue($row['Kode_jp']);
		$this->Tmp_Lahir->setDbValue($row['Tmp_Lahir']);
		$this->Tgl_Lahir->setDbValue($row['Tgl_Lahir']);
		$this->Jenis_Kel->setDbValue($row['Jenis_Kel']);
		$this->Gol_darah->setDbValue($row['Gol_darah']);
		$this->Agama_Mhs->setDbValue($row['Agama_Mhs']);
		$this->Alamat_Mhs->setDbValue($row['Alamat_Mhs']);
		$this->rt->setDbValue($row['rt']);
		$this->rw->setDbValue($row['rw']);
		$this->Kelurahan->setDbValue($row['Kelurahan']);
		$this->Kecamatan->setDbValue($row['Kecamatan']);
		$this->Kota_Mhs->setDbValue($row['Kota_Mhs']);
		$this->Provinsi_mhs->setDbValue($row['Provinsi_mhs']);
		$this->Kodepos_Mhs->setDbValue($row['Kodepos_Mhs']);
		$this->Tlp_Mhs->setDbValue($row['Tlp_Mhs']);
		$this->TlpRumah->setDbValue($row['TlpRumah']);
		$this->_Email->setDbValue($row['Email']);
		$this->Status_Akd->setDbValue($row['Status_Akd']);
		$this->ThMasuk->setDbValue($row['ThMasuk']);
		$this->tglmasuk->setDbValue($row['tglmasuk']);
		$this->Status_Masuk->setDbValue($row['Status_Masuk']);
		$this->Sem_Masuk->setDbValue($row['Sem_Masuk']);
		$this->TaMasuk->setDbValue($row['TaMasuk']);
		$this->PerMasuk->setDbValue($row['PerMasuk']);
		$this->Pendidikan_Akhir->setDbValue($row['Pendidikan_Akhir']);
		$this->Jurusan->setDbValue($row['Jurusan']);
		$this->Thn_Selesai->setDbValue($row['Thn_Selesai']);
		$this->Kota_Pdkk->setDbValue($row['Kota_Pdkk']);
		$this->propinsi->setDbValue($row['propinsi']);
		$this->NIMASAL->setDbValue($row['NIMASAL']);
		$this->KPTSASAL->setDbValue($row['KPTSASAL']);
		$this->JENASAL->setDbValue($row['JENASAL']);
		$this->PSASAL->setDbValue($row['PSASAL']);
		$this->TSKSDIAKUI->setDbValue($row['TSKSDIAKUI']);
		$this->NamaSekolahAsal->setDbValue($row['NamaSekolahAsal']);
		$this->AlamatSekolahAsal->setDbValue($row['AlamatSekolahAsal']);
		$this->Status->setDbValue($row['Status']);
		$this->Photo->Upload->DbValue = $row['Photo'];
		if (is_array($this->Photo->Upload->DbValue) || is_object($this->Photo->Upload->DbValue)) // Byte array
			$this->Photo->Upload->DbValue = BytesToString($this->Photo->Upload->DbValue);
		$this->Password->setDbValue($row['Password']);
		$this->Gelombang->setDbValue($row['Gelombang']);
		$this->JalurMasuk->setDbValue($row['JalurMasuk']);
		$this->Konsentrasi->setDbValue($row['Konsentrasi']);
		$this->NIK->setDbValue($row['NIK']);
		$this->NamaIbu->setDbValue($row['NamaIbu']);
		$this->BekerjaDi->setDbValue($row['BekerjaDi']);
		$this->Lama->setDbValue($row['Lama']);
		$this->AlamatPerusahaan->setDbValue($row['AlamatPerusahaan']);
		$this->TlpPerusahaan->setDbValue($row['TlpPerusahaan']);
		$this->Posisi->setDbValue($row['Posisi']);
		$this->Departemen->setDbValue($row['Departemen']);
		$this->IdUser->setDbValue($row['IdUser']);
		$this->TempID->setDbValue($row['TempID']);
		$this->xphoto->setDbValue($row['xphoto']);
		$this->profile->setDbValue($row['profile']);
		$this->id_agama->setDbValue($row['id_agama']);
		$this->id_negara->setDbValue($row['id_negara']);
		$this->id_wilayah->setDbValue($row['id_wilayah']);
		$this->id_jenis_tinggal->setDbValue($row['id_jenis_tinggal']);
		$this->id_alat_transportasi->setDbValue($row['id_alat_transportasi']);
		$this->no_kps->setDbValue($row['no_kps']);
		$this->penerima_kps->setDbValue($row['penerima_kps']);
		$this->id_kebutuhan_khusus_mahasiswa->setDbValue($row['id_kebutuhan_khusus_mahasiswa']);
		$this->nisn->setDbValue($row['nisn']);
		$this->iddesa->setDbValue($row['iddesa']);
		$this->MulaiKerja->setDbValue($row['MulaiKerja']);
		$this->IdKlsKerjasama->setDbValue($row['IdKlsKerjasama']);
		$this->IDBeasiswa->setDbValue($row['IDBeasiswa']);
		$this->tglKonversi->setDbValue($row['tglKonversi']);
		$this->NoSuratKonversi->setDbValue($row['NoSuratKonversi']);
		$this->Nopen->setDbValue($row['Nopen']);
		$this->id_feedmhs->setDbValue($row['id_feedmhs']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['Nim'] = NULL;
		$row['Nama_Mhs'] = NULL;
		$row['Kode_jp'] = NULL;
		$row['Tmp_Lahir'] = NULL;
		$row['Tgl_Lahir'] = NULL;
		$row['Jenis_Kel'] = NULL;
		$row['Gol_darah'] = NULL;
		$row['Agama_Mhs'] = NULL;
		$row['Alamat_Mhs'] = NULL;
		$row['rt'] = NULL;
		$row['rw'] = NULL;
		$row['Kelurahan'] = NULL;
		$row['Kecamatan'] = NULL;
		$row['Kota_Mhs'] = NULL;
		$row['Provinsi_mhs'] = NULL;
		$row['Kodepos_Mhs'] = NULL;
		$row['Tlp_Mhs'] = NULL;
		$row['TlpRumah'] = NULL;
		$row['Email'] = NULL;
		$row['Status_Akd'] = NULL;
		$row['ThMasuk'] = NULL;
		$row['tglmasuk'] = NULL;
		$row['Status_Masuk'] = NULL;
		$row['Sem_Masuk'] = NULL;
		$row['TaMasuk'] = NULL;
		$row['PerMasuk'] = NULL;
		$row['Pendidikan_Akhir'] = NULL;
		$row['Jurusan'] = NULL;
		$row['Thn_Selesai'] = NULL;
		$row['Kota_Pdkk'] = NULL;
		$row['propinsi'] = NULL;
		$row['NIMASAL'] = NULL;
		$row['KPTSASAL'] = NULL;
		$row['JENASAL'] = NULL;
		$row['PSASAL'] = NULL;
		$row['TSKSDIAKUI'] = NULL;
		$row['NamaSekolahAsal'] = NULL;
		$row['AlamatSekolahAsal'] = NULL;
		$row['Status'] = NULL;
		$row['Photo'] = NULL;
		$row['Password'] = NULL;
		$row['Gelombang'] = NULL;
		$row['JalurMasuk'] = NULL;
		$row['Konsentrasi'] = NULL;
		$row['NIK'] = NULL;
		$row['NamaIbu'] = NULL;
		$row['BekerjaDi'] = NULL;
		$row['Lama'] = NULL;
		$row['AlamatPerusahaan'] = NULL;
		$row['TlpPerusahaan'] = NULL;
		$row['Posisi'] = NULL;
		$row['Departemen'] = NULL;
		$row['IdUser'] = NULL;
		$row['TempID'] = NULL;
		$row['xphoto'] = NULL;
		$row['profile'] = NULL;
		$row['id_agama'] = NULL;
		$row['id_negara'] = NULL;
		$row['id_wilayah'] = NULL;
		$row['id_jenis_tinggal'] = NULL;
		$row['id_alat_transportasi'] = NULL;
		$row['no_kps'] = NULL;
		$row['penerima_kps'] = NULL;
		$row['id_kebutuhan_khusus_mahasiswa'] = NULL;
		$row['nisn'] = NULL;
		$row['iddesa'] = NULL;
		$row['MulaiKerja'] = NULL;
		$row['IdKlsKerjasama'] = NULL;
		$row['IDBeasiswa'] = NULL;
		$row['tglKonversi'] = NULL;
		$row['NoSuratKonversi'] = NULL;
		$row['Nopen'] = NULL;
		$row['id_feedmhs'] = NULL;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("Nim")) != "")
			$this->Nim->OldValue = $this->getKey("Nim"); // Nim
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = $this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Call Row_Rendering event

		$this->Row_Rendering();

		// Common render codes for all row types
		// Nim
		// Nama_Mhs
		// Kode_jp
		// Tmp_Lahir
		// Tgl_Lahir
		// Jenis_Kel
		// Gol_darah
		// Agama_Mhs
		// Alamat_Mhs
		// rt
		// rw
		// Kelurahan
		// Kecamatan
		// Kota_Mhs
		// Provinsi_mhs
		// Kodepos_Mhs
		// Tlp_Mhs
		// TlpRumah
		// Email
		// Status_Akd
		// ThMasuk
		// tglmasuk
		// Status_Masuk
		// Sem_Masuk
		// TaMasuk
		// PerMasuk
		// Pendidikan_Akhir
		// Jurusan
		// Thn_Selesai
		// Kota_Pdkk
		// propinsi
		// NIMASAL
		// KPTSASAL
		// JENASAL
		// PSASAL
		// TSKSDIAKUI
		// NamaSekolahAsal
		// AlamatSekolahAsal
		// Status
		// Photo
		// Password
		// Gelombang
		// JalurMasuk
		// Konsentrasi
		// NIK
		// NamaIbu
		// BekerjaDi
		// Lama
		// AlamatPerusahaan
		// TlpPerusahaan
		// Posisi
		// Departemen
		// IdUser
		// TempID
		// xphoto
		// profile
		// id_agama
		// id_negara
		// id_wilayah
		// id_jenis_tinggal
		// id_alat_transportasi
		// no_kps
		// penerima_kps
		// id_kebutuhan_khusus_mahasiswa
		// nisn
		// iddesa
		// MulaiKerja
		// IdKlsKerjasama
		// IDBeasiswa
		// tglKonversi
		// NoSuratKonversi
		// Nopen
		// id_feedmhs

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// Nim
			$this->Nim->ViewValue = $this->Nim->CurrentValue;
			$this->Nim->ViewCustomAttributes = "";

			// Nama_Mhs
			$this->Nama_Mhs->ViewValue = $this->Nama_Mhs->CurrentValue;
			$this->Nama_Mhs->ViewCustomAttributes = "";

			// Kode_jp
			$curVal = strval($this->Kode_jp->CurrentValue);
			if ($curVal != "") {
				$this->Kode_jp->ViewValue = $this->Kode_jp->lookupCacheOption($curVal);
				if ($this->Kode_jp->ViewValue === NULL) { // Lookup from database
					$filterWrk = "[Kode_Jp]" . SearchString("=", $curVal, DATATYPE_STRING, "");
					$sqlWrk = $this->Kode_jp->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = [];
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$arwrk[3] = $rswrk->fields('df3');
						$this->Kode_jp->ViewValue = $this->Kode_jp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->Kode_jp->ViewValue = $this->Kode_jp->CurrentValue;
					}
				}
			} else {
				$this->Kode_jp->ViewValue = NULL;
			}
			$this->Kode_jp->ViewCustomAttributes = "";

			// Tmp_Lahir
			$this->Tmp_Lahir->ViewValue = $this->Tmp_Lahir->CurrentValue;
			$this->Tmp_Lahir->ViewCustomAttributes = "";

			// Tgl_Lahir
			$this->Tgl_Lahir->ViewValue = $this->Tgl_Lahir->CurrentValue;
			$this->Tgl_Lahir->ViewValue = FormatDateTime($this->Tgl_Lahir->ViewValue, 0);
			$this->Tgl_Lahir->ViewCustomAttributes = "";

			// Jenis_Kel
			if (strval($this->Jenis_Kel->CurrentValue) != "") {
				$this->Jenis_Kel->ViewValue = $this->Jenis_Kel->optionCaption($this->Jenis_Kel->CurrentValue);
			} else {
				$this->Jenis_Kel->ViewValue = NULL;
			}
			$this->Jenis_Kel->ViewCustomAttributes = "";

			// Gol_darah
			$this->Gol_darah->ViewValue = $this->Gol_darah->CurrentValue;
			$this->Gol_darah->ViewCustomAttributes = "";

			// Agama_Mhs
			$this->Agama_Mhs->ViewValue = $this->Agama_Mhs->CurrentValue;
			$this->Agama_Mhs->ViewCustomAttributes = "";

			// Alamat_Mhs
			$this->Alamat_Mhs->ViewValue = $this->Alamat_Mhs->CurrentValue;
			$this->Alamat_Mhs->ViewCustomAttributes = "";

			// rt
			$this->rt->ViewValue = $this->rt->CurrentValue;
			$this->rt->ViewCustomAttributes = "";

			// rw
			$this->rw->ViewValue = $this->rw->CurrentValue;
			$this->rw->ViewCustomAttributes = "";

			// Kelurahan
			$this->Kelurahan->ViewValue = $this->Kelurahan->CurrentValue;
			$this->Kelurahan->ViewCustomAttributes = "";

			// Kecamatan
			$this->Kecamatan->ViewValue = $this->Kecamatan->CurrentValue;
			$this->Kecamatan->ViewCustomAttributes = "";

			// Kota_Mhs
			$this->Kota_Mhs->ViewValue = $this->Kota_Mhs->CurrentValue;
			$this->Kota_Mhs->ViewCustomAttributes = "";

			// Provinsi_mhs
			$this->Provinsi_mhs->ViewValue = $this->Provinsi_mhs->CurrentValue;
			$this->Provinsi_mhs->ViewCustomAttributes = "";

			// Kodepos_Mhs
			$this->Kodepos_Mhs->ViewValue = $this->Kodepos_Mhs->CurrentValue;
			$this->Kodepos_Mhs->ViewCustomAttributes = "";

			// Tlp_Mhs
			$this->Tlp_Mhs->ViewValue = $this->Tlp_Mhs->CurrentValue;
			$this->Tlp_Mhs->ViewCustomAttributes = "";

			// TlpRumah
			$this->TlpRumah->ViewValue = $this->TlpRumah->CurrentValue;
			$this->TlpRumah->ViewCustomAttributes = "";

			// Email
			$this->_Email->ViewValue = $this->_Email->CurrentValue;
			$this->_Email->ViewCustomAttributes = "";

			// Status_Akd
			$curVal = strval($this->Status_Akd->CurrentValue);
			if ($curVal != "") {
				$this->Status_Akd->ViewValue = $this->Status_Akd->lookupCacheOption($curVal);
				if ($this->Status_Akd->ViewValue === NULL) { // Lookup from database
					$filterWrk = "[Kelas]" . SearchString("=", $curVal, DATATYPE_STRING, "");
					$sqlWrk = $this->Status_Akd->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = [];
						$arwrk[1] = $rswrk->fields('df');
						$this->Status_Akd->ViewValue = $this->Status_Akd->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->Status_Akd->ViewValue = $this->Status_Akd->CurrentValue;
					}
				}
			} else {
				$this->Status_Akd->ViewValue = NULL;
			}
			$this->Status_Akd->ViewCustomAttributes = "";

			// ThMasuk
			$this->ThMasuk->ViewValue = $this->ThMasuk->CurrentValue;
			$this->ThMasuk->ViewCustomAttributes = "";

			// tglmasuk
			$this->tglmasuk->ViewValue = $this->tglmasuk->CurrentValue;
			$this->tglmasuk->ViewValue = FormatDateTime($this->tglmasuk->ViewValue, 7);
			$this->tglmasuk->ViewCustomAttributes = "";

			// Status_Masuk
			if (strval($this->Status_Masuk->CurrentValue) != "") {
				$this->Status_Masuk->ViewValue = $this->Status_Masuk->optionCaption($this->Status_Masuk->CurrentValue);
			} else {
				$this->Status_Masuk->ViewValue = NULL;
			}
			$this->Status_Masuk->ViewCustomAttributes = "";

			// Sem_Masuk
			$this->Sem_Masuk->ViewValue = $this->Sem_Masuk->CurrentValue;
			$this->Sem_Masuk->ViewCustomAttributes = "";

			// TaMasuk
			$curVal = strval($this->TaMasuk->CurrentValue);
			if ($curVal != "") {
				$this->TaMasuk->ViewValue = $this->TaMasuk->lookupCacheOption($curVal);
				if ($this->TaMasuk->ViewValue === NULL) { // Lookup from database
					$filterWrk = "[TA]" . SearchString("=", $curVal, DATATYPE_STRING, "");
					$sqlWrk = $this->TaMasuk->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = [];
						$arwrk[1] = $rswrk->fields('df');
						$this->TaMasuk->ViewValue = $this->TaMasuk->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->TaMasuk->ViewValue = $this->TaMasuk->CurrentValue;
					}
				}
			} else {
				$this->TaMasuk->ViewValue = NULL;
			}
			$this->TaMasuk->ViewCustomAttributes = "";

			// PerMasuk
			if (strval($this->PerMasuk->CurrentValue) != "") {
				$this->PerMasuk->ViewValue = $this->PerMasuk->optionCaption($this->PerMasuk->CurrentValue);
			} else {
				$this->PerMasuk->ViewValue = NULL;
			}
			$this->PerMasuk->ViewCustomAttributes = "";

			// Pendidikan_Akhir
			$this->Pendidikan_Akhir->ViewValue = $this->Pendidikan_Akhir->CurrentValue;
			$this->Pendidikan_Akhir->ViewCustomAttributes = "";

			// Jurusan
			$this->Jurusan->ViewValue = $this->Jurusan->CurrentValue;
			$this->Jurusan->ViewCustomAttributes = "";

			// Thn_Selesai
			$this->Thn_Selesai->ViewValue = $this->Thn_Selesai->CurrentValue;
			$this->Thn_Selesai->ViewCustomAttributes = "";

			// Kota_Pdkk
			$this->Kota_Pdkk->ViewValue = $this->Kota_Pdkk->CurrentValue;
			$this->Kota_Pdkk->ViewCustomAttributes = "";

			// propinsi
			$this->propinsi->ViewValue = $this->propinsi->CurrentValue;
			$this->propinsi->ViewCustomAttributes = "";

			// NIMASAL
			$this->NIMASAL->ViewValue = $this->NIMASAL->CurrentValue;
			$this->NIMASAL->ViewCustomAttributes = "";

			// KPTSASAL
			$this->KPTSASAL->ViewValue = $this->KPTSASAL->CurrentValue;
			$this->KPTSASAL->ViewCustomAttributes = "";

			// JENASAL
			$this->JENASAL->ViewValue = $this->JENASAL->CurrentValue;
			$this->JENASAL->ViewCustomAttributes = "";

			// PSASAL
			$this->PSASAL->ViewValue = $this->PSASAL->CurrentValue;
			$this->PSASAL->ViewCustomAttributes = "";

			// TSKSDIAKUI
			$this->TSKSDIAKUI->ViewValue = $this->TSKSDIAKUI->CurrentValue;
			$this->TSKSDIAKUI->ViewValue = FormatNumber($this->TSKSDIAKUI->ViewValue, 0, -2, -2, -2);
			$this->TSKSDIAKUI->ViewCustomAttributes = "";

			// NamaSekolahAsal
			$this->NamaSekolahAsal->ViewValue = $this->NamaSekolahAsal->CurrentValue;
			$this->NamaSekolahAsal->ViewCustomAttributes = "";

			// AlamatSekolahAsal
			$this->AlamatSekolahAsal->ViewValue = $this->AlamatSekolahAsal->CurrentValue;
			$this->AlamatSekolahAsal->ViewCustomAttributes = "";

			// Status
			if (strval($this->Status->CurrentValue) != "") {
				$this->Status->ViewValue = $this->Status->optionCaption($this->Status->CurrentValue);
			} else {
				$this->Status->ViewValue = NULL;
			}
			$this->Status->ViewCustomAttributes = "";

			// Password
			$this->Password->ViewValue = $this->Password->CurrentValue;
			$this->Password->ViewCustomAttributes = "";

			// Gelombang
			$this->Gelombang->ViewValue = $this->Gelombang->CurrentValue;
			$this->Gelombang->ViewCustomAttributes = "";

			// JalurMasuk
			$this->JalurMasuk->ViewValue = $this->JalurMasuk->CurrentValue;
			$this->JalurMasuk->ViewCustomAttributes = "";

			// Konsentrasi
			$this->Konsentrasi->ViewValue = $this->Konsentrasi->CurrentValue;
			$this->Konsentrasi->ViewCustomAttributes = "";

			// NIK
			$this->NIK->ViewValue = $this->NIK->CurrentValue;
			$this->NIK->ViewCustomAttributes = "";

			// NamaIbu
			$this->NamaIbu->ViewValue = $this->NamaIbu->CurrentValue;
			$this->NamaIbu->ViewCustomAttributes = "";

			// BekerjaDi
			$this->BekerjaDi->ViewValue = $this->BekerjaDi->CurrentValue;
			$this->BekerjaDi->ViewCustomAttributes = "";

			// Lama
			$this->Lama->ViewValue = $this->Lama->CurrentValue;
			$this->Lama->ViewCustomAttributes = "";

			// AlamatPerusahaan
			$this->AlamatPerusahaan->ViewValue = $this->AlamatPerusahaan->CurrentValue;
			$this->AlamatPerusahaan->ViewCustomAttributes = "";

			// TlpPerusahaan
			$this->TlpPerusahaan->ViewValue = $this->TlpPerusahaan->CurrentValue;
			$this->TlpPerusahaan->ViewCustomAttributes = "";

			// Posisi
			$this->Posisi->ViewValue = $this->Posisi->CurrentValue;
			$this->Posisi->ViewCustomAttributes = "";

			// Departemen
			$this->Departemen->ViewValue = $this->Departemen->CurrentValue;
			$this->Departemen->ViewCustomAttributes = "";

			// IdUser
			$this->IdUser->ViewValue = $this->IdUser->CurrentValue;
			$this->IdUser->ViewCustomAttributes = "";

			// TempID
			$this->TempID->ViewValue = $this->TempID->CurrentValue;
			$this->TempID->ViewValue = FormatNumber($this->TempID->ViewValue, 0, -2, -2, -2);
			$this->TempID->ViewCustomAttributes = "";

			// xphoto
			$this->xphoto->ViewValue = $this->xphoto->CurrentValue;
			$this->xphoto->ViewCustomAttributes = "";

			// profile
			$this->profile->ViewValue = $this->profile->CurrentValue;
			$this->profile->ViewCustomAttributes = "";

			// id_agama
			$this->id_agama->ViewValue = $this->id_agama->CurrentValue;
			$this->id_agama->ViewValue = FormatNumber($this->id_agama->ViewValue, 0, -2, -2, -2);
			$this->id_agama->ViewCustomAttributes = "";

			// id_negara
			$this->id_negara->ViewValue = $this->id_negara->CurrentValue;
			$this->id_negara->ViewCustomAttributes = "";

			// id_wilayah
			$this->id_wilayah->ViewValue = $this->id_wilayah->CurrentValue;
			$this->id_wilayah->ViewCustomAttributes = "";

			// id_jenis_tinggal
			$this->id_jenis_tinggal->ViewValue = $this->id_jenis_tinggal->CurrentValue;
			$this->id_jenis_tinggal->ViewValue = FormatNumber($this->id_jenis_tinggal->ViewValue, 0, -2, -2, -2);
			$this->id_jenis_tinggal->ViewCustomAttributes = "";

			// id_alat_transportasi
			$this->id_alat_transportasi->ViewValue = $this->id_alat_transportasi->CurrentValue;
			$this->id_alat_transportasi->ViewValue = FormatNumber($this->id_alat_transportasi->ViewValue, 0, -2, -2, -2);
			$this->id_alat_transportasi->ViewCustomAttributes = "";

			// no_kps
			$this->no_kps->ViewValue = $this->no_kps->CurrentValue;
			$this->no_kps->ViewCustomAttributes = "";

			// penerima_kps
			$this->penerima_kps->ViewValue = $this->penerima_kps->CurrentValue;
			$this->penerima_kps->ViewValue = FormatNumber($this->penerima_kps->ViewValue, 0, -2, -2, -2);
			$this->penerima_kps->ViewCustomAttributes = "";

			// id_kebutuhan_khusus_mahasiswa
			$this->id_kebutuhan_khusus_mahasiswa->ViewValue = $this->id_kebutuhan_khusus_mahasiswa->CurrentValue;
			$this->id_kebutuhan_khusus_mahasiswa->ViewValue = FormatNumber($this->id_kebutuhan_khusus_mahasiswa->ViewValue, 0, -2, -2, -2);
			$this->id_kebutuhan_khusus_mahasiswa->ViewCustomAttributes = "";

			// nisn
			$this->nisn->ViewValue = $this->nisn->CurrentValue;
			$this->nisn->ViewCustomAttributes = "";

			// iddesa
			$this->iddesa->ViewValue = $this->iddesa->CurrentValue;
			$this->iddesa->ViewValue = FormatNumber($this->iddesa->ViewValue, 0, -2, -2, -2);
			$this->iddesa->ViewCustomAttributes = "";

			// MulaiKerja
			$this->MulaiKerja->ViewValue = $this->MulaiKerja->CurrentValue;
			$this->MulaiKerja->ViewValue = FormatDateTime($this->MulaiKerja->ViewValue, 0);
			$this->MulaiKerja->ViewCustomAttributes = "";

			// IdKlsKerjasama
			$this->IdKlsKerjasama->ViewValue = $this->IdKlsKerjasama->CurrentValue;
			$this->IdKlsKerjasama->ViewValue = FormatNumber($this->IdKlsKerjasama->ViewValue, 0, -2, -2, -2);
			$this->IdKlsKerjasama->ViewCustomAttributes = "";

			// IDBeasiswa
			$this->IDBeasiswa->ViewValue = $this->IDBeasiswa->CurrentValue;
			$this->IDBeasiswa->ViewValue = FormatNumber($this->IDBeasiswa->ViewValue, 0, -2, -2, -2);
			$this->IDBeasiswa->ViewCustomAttributes = "";

			// tglKonversi
			$this->tglKonversi->ViewValue = $this->tglKonversi->CurrentValue;
			$this->tglKonversi->ViewValue = FormatDateTime($this->tglKonversi->ViewValue, 0);
			$this->tglKonversi->ViewCustomAttributes = "";

			// NoSuratKonversi
			$this->NoSuratKonversi->ViewValue = $this->NoSuratKonversi->CurrentValue;
			$this->NoSuratKonversi->ViewCustomAttributes = "";

			// Nopen
			$this->Nopen->ViewValue = $this->Nopen->CurrentValue;
			$this->Nopen->ViewCustomAttributes = "";

			// id_feedmhs
			$this->id_feedmhs->ViewValue = $this->id_feedmhs->CurrentValue;
			$this->id_feedmhs->ViewCustomAttributes = "";

			// Nim
			$this->Nim->LinkCustomAttributes = "";
			$this->Nim->HrefValue = "";
			$this->Nim->TooltipValue = "";

			// Nama_Mhs
			$this->Nama_Mhs->LinkCustomAttributes = "";
			$this->Nama_Mhs->HrefValue = "";
			$this->Nama_Mhs->TooltipValue = "";

			// Kode_jp
			$this->Kode_jp->LinkCustomAttributes = "";
			$this->Kode_jp->HrefValue = "";
			$this->Kode_jp->TooltipValue = "";

			// Tmp_Lahir
			$this->Tmp_Lahir->LinkCustomAttributes = "";
			$this->Tmp_Lahir->HrefValue = "";
			$this->Tmp_Lahir->TooltipValue = "";

			// Tgl_Lahir
			$this->Tgl_Lahir->LinkCustomAttributes = "";
			$this->Tgl_Lahir->HrefValue = "";
			$this->Tgl_Lahir->TooltipValue = "";

			// Jenis_Kel
			$this->Jenis_Kel->LinkCustomAttributes = "";
			$this->Jenis_Kel->HrefValue = "";
			$this->Jenis_Kel->TooltipValue = "";

			// Gol_darah
			$this->Gol_darah->LinkCustomAttributes = "";
			$this->Gol_darah->HrefValue = "";
			$this->Gol_darah->TooltipValue = "";

			// Agama_Mhs
			$this->Agama_Mhs->LinkCustomAttributes = "";
			$this->Agama_Mhs->HrefValue = "";
			$this->Agama_Mhs->TooltipValue = "";

			// Alamat_Mhs
			$this->Alamat_Mhs->LinkCustomAttributes = "";
			$this->Alamat_Mhs->HrefValue = "";
			$this->Alamat_Mhs->TooltipValue = "";

			// rt
			$this->rt->LinkCustomAttributes = "";
			$this->rt->HrefValue = "";
			$this->rt->TooltipValue = "";

			// rw
			$this->rw->LinkCustomAttributes = "";
			$this->rw->HrefValue = "";
			$this->rw->TooltipValue = "";

			// Kelurahan
			$this->Kelurahan->LinkCustomAttributes = "";
			$this->Kelurahan->HrefValue = "";
			$this->Kelurahan->TooltipValue = "";

			// Kecamatan
			$this->Kecamatan->LinkCustomAttributes = "";
			$this->Kecamatan->HrefValue = "";
			$this->Kecamatan->TooltipValue = "";

			// Kota_Mhs
			$this->Kota_Mhs->LinkCustomAttributes = "";
			$this->Kota_Mhs->HrefValue = "";
			$this->Kota_Mhs->TooltipValue = "";

			// Provinsi_mhs
			$this->Provinsi_mhs->LinkCustomAttributes = "";
			$this->Provinsi_mhs->HrefValue = "";
			$this->Provinsi_mhs->TooltipValue = "";

			// Kodepos_Mhs
			$this->Kodepos_Mhs->LinkCustomAttributes = "";
			$this->Kodepos_Mhs->HrefValue = "";
			$this->Kodepos_Mhs->TooltipValue = "";

			// Tlp_Mhs
			$this->Tlp_Mhs->LinkCustomAttributes = "";
			if (!EmptyValue($this->Tlp_Mhs->CurrentValue)) {
				$this->Tlp_Mhs->HrefValue = "https://wa.me/62" . $this->Tlp_Mhs->CurrentValue; // Add prefix/suffix
				$this->Tlp_Mhs->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport())
					$this->Tlp_Mhs->HrefValue = FullUrl($this->Tlp_Mhs->HrefValue, "href");
			} else {
				$this->Tlp_Mhs->HrefValue = "";
			}
			$this->Tlp_Mhs->TooltipValue = "";

			// TlpRumah
			$this->TlpRumah->LinkCustomAttributes = "";
			$this->TlpRumah->HrefValue = "";
			$this->TlpRumah->TooltipValue = "";

			// Email
			$this->_Email->LinkCustomAttributes = "";
			if (!EmptyValue($this->_Email->CurrentValue)) {
				$this->_Email->HrefValue = "mailto:" . (!empty($this->_Email->ViewValue) && !is_array($this->_Email->ViewValue) ? RemoveHtml($this->_Email->ViewValue) : $this->_Email->CurrentValue); // Add prefix/suffix
				$this->_Email->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport())
					$this->_Email->HrefValue = FullUrl($this->_Email->HrefValue, "href");
			} else {
				$this->_Email->HrefValue = "";
			}
			$this->_Email->TooltipValue = "";

			// Status_Akd
			$this->Status_Akd->LinkCustomAttributes = "";
			$this->Status_Akd->HrefValue = "";
			$this->Status_Akd->TooltipValue = "";

			// tglmasuk
			$this->tglmasuk->LinkCustomAttributes = "";
			$this->tglmasuk->HrefValue = "";
			$this->tglmasuk->TooltipValue = "";

			// Status_Masuk
			$this->Status_Masuk->LinkCustomAttributes = "";
			$this->Status_Masuk->HrefValue = "";
			$this->Status_Masuk->TooltipValue = "";

			// Sem_Masuk
			$this->Sem_Masuk->LinkCustomAttributes = "";
			$this->Sem_Masuk->HrefValue = "";
			$this->Sem_Masuk->TooltipValue = "";

			// TaMasuk
			$this->TaMasuk->LinkCustomAttributes = "";
			$this->TaMasuk->HrefValue = "";
			$this->TaMasuk->TooltipValue = "";

			// PerMasuk
			$this->PerMasuk->LinkCustomAttributes = "";
			$this->PerMasuk->HrefValue = "";
			$this->PerMasuk->TooltipValue = "";

			// Thn_Selesai
			$this->Thn_Selesai->LinkCustomAttributes = "";
			$this->Thn_Selesai->HrefValue = "";
			$this->Thn_Selesai->TooltipValue = "";

			// Status
			$this->Status->LinkCustomAttributes = "";
			$this->Status->HrefValue = "";
			$this->Status->TooltipValue = "";

			// NIK
			$this->NIK->LinkCustomAttributes = "";
			$this->NIK->HrefValue = "";
			$this->NIK->TooltipValue = "";

			// NamaIbu
			$this->NamaIbu->LinkCustomAttributes = "";
			$this->NamaIbu->HrefValue = "";
			$this->NamaIbu->TooltipValue = "";

			// iddesa
			$this->iddesa->LinkCustomAttributes = "";
			$this->iddesa->HrefValue = "";
			$this->iddesa->TooltipValue = "";

			// MulaiKerja
			$this->MulaiKerja->LinkCustomAttributes = "";
			$this->MulaiKerja->HrefValue = "";
			$this->MulaiKerja->TooltipValue = "";

			// IdKlsKerjasama
			$this->IdKlsKerjasama->LinkCustomAttributes = "";
			$this->IdKlsKerjasama->HrefValue = "";
			$this->IdKlsKerjasama->TooltipValue = "";

			// IDBeasiswa
			$this->IDBeasiswa->LinkCustomAttributes = "";
			$this->IDBeasiswa->HrefValue = "";
			$this->IDBeasiswa->TooltipValue = "";

			// tglKonversi
			$this->tglKonversi->LinkCustomAttributes = "";
			$this->tglKonversi->HrefValue = "";
			$this->tglKonversi->TooltipValue = "";

			// NoSuratKonversi
			$this->NoSuratKonversi->LinkCustomAttributes = "";
			$this->NoSuratKonversi->HrefValue = "";
			$this->NoSuratKonversi->TooltipValue = "";

			// Nopen
			$this->Nopen->LinkCustomAttributes = "";
			$this->Nopen->HrefValue = "";
			$this->Nopen->TooltipValue = "";

			// id_feedmhs
			$this->id_feedmhs->LinkCustomAttributes = "";
			$this->id_feedmhs->HrefValue = "";
			$this->id_feedmhs->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_EDIT) { // Edit row

			// Nim
			$this->Nim->EditAttrs["class"] = "form-control";
			$this->Nim->EditCustomAttributes = "";
			$this->Nim->EditValue = $this->Nim->CurrentValue;
			$this->Nim->ViewCustomAttributes = "";

			// Nama_Mhs
			$this->Nama_Mhs->EditAttrs["class"] = "form-control";
			$this->Nama_Mhs->EditCustomAttributes = "";
			if (!$this->Nama_Mhs->Raw)
				$this->Nama_Mhs->CurrentValue = HtmlDecode($this->Nama_Mhs->CurrentValue);
			$this->Nama_Mhs->EditValue = HtmlEncode($this->Nama_Mhs->CurrentValue);
			$this->Nama_Mhs->PlaceHolder = RemoveHtml($this->Nama_Mhs->caption());

			// Kode_jp
			$this->Kode_jp->EditAttrs["class"] = "form-control";
			$this->Kode_jp->EditCustomAttributes = "";
			$curVal = strval($this->Kode_jp->CurrentValue);
			if ($curVal != "") {
				$this->Kode_jp->EditValue = $this->Kode_jp->lookupCacheOption($curVal);
				if ($this->Kode_jp->EditValue === NULL) { // Lookup from database
					$filterWrk = "[Kode_Jp]" . SearchString("=", $curVal, DATATYPE_STRING, "");
					$sqlWrk = $this->Kode_jp->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = [];
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$arwrk[3] = $rswrk->fields('df3');
						$this->Kode_jp->EditValue = $this->Kode_jp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->Kode_jp->EditValue = $this->Kode_jp->CurrentValue;
					}
				}
			} else {
				$this->Kode_jp->EditValue = NULL;
			}
			$this->Kode_jp->ViewCustomAttributes = "";

			// Tmp_Lahir
			$this->Tmp_Lahir->EditAttrs["class"] = "form-control";
			$this->Tmp_Lahir->EditCustomAttributes = "";
			if (!$this->Tmp_Lahir->Raw)
				$this->Tmp_Lahir->CurrentValue = HtmlDecode($this->Tmp_Lahir->CurrentValue);
			$this->Tmp_Lahir->EditValue = HtmlEncode($this->Tmp_Lahir->CurrentValue);
			$this->Tmp_Lahir->PlaceHolder = RemoveHtml($this->Tmp_Lahir->caption());

			// Tgl_Lahir
			$this->Tgl_Lahir->EditAttrs["class"] = "form-control";
			$this->Tgl_Lahir->EditCustomAttributes = "";
			$this->Tgl_Lahir->EditValue = HtmlEncode(FormatDateTime($this->Tgl_Lahir->CurrentValue, 8));
			$this->Tgl_Lahir->PlaceHolder = RemoveHtml($this->Tgl_Lahir->caption());

			// Jenis_Kel
			$this->Jenis_Kel->EditAttrs["class"] = "form-control";
			$this->Jenis_Kel->EditCustomAttributes = "";
			$this->Jenis_Kel->EditValue = $this->Jenis_Kel->options(TRUE);

			// Gol_darah
			$this->Gol_darah->EditAttrs["class"] = "form-control";
			$this->Gol_darah->EditCustomAttributes = "";
			if (!$this->Gol_darah->Raw)
				$this->Gol_darah->CurrentValue = HtmlDecode($this->Gol_darah->CurrentValue);
			$this->Gol_darah->EditValue = HtmlEncode($this->Gol_darah->CurrentValue);
			$this->Gol_darah->PlaceHolder = RemoveHtml($this->Gol_darah->caption());

			// Agama_Mhs
			$this->Agama_Mhs->EditAttrs["class"] = "form-control";
			$this->Agama_Mhs->EditCustomAttributes = "";
			if (!$this->Agama_Mhs->Raw)
				$this->Agama_Mhs->CurrentValue = HtmlDecode($this->Agama_Mhs->CurrentValue);
			$this->Agama_Mhs->EditValue = HtmlEncode($this->Agama_Mhs->CurrentValue);
			$this->Agama_Mhs->PlaceHolder = RemoveHtml($this->Agama_Mhs->caption());

			// Alamat_Mhs
			$this->Alamat_Mhs->EditAttrs["class"] = "form-control";
			$this->Alamat_Mhs->EditCustomAttributes = "";
			if (!$this->Alamat_Mhs->Raw)
				$this->Alamat_Mhs->CurrentValue = HtmlDecode($this->Alamat_Mhs->CurrentValue);
			$this->Alamat_Mhs->EditValue = HtmlEncode($this->Alamat_Mhs->CurrentValue);
			$this->Alamat_Mhs->PlaceHolder = RemoveHtml($this->Alamat_Mhs->caption());

			// rt
			$this->rt->EditAttrs["class"] = "form-control";
			$this->rt->EditCustomAttributes = "";
			if (!$this->rt->Raw)
				$this->rt->CurrentValue = HtmlDecode($this->rt->CurrentValue);
			$this->rt->EditValue = HtmlEncode($this->rt->CurrentValue);
			$this->rt->PlaceHolder = RemoveHtml($this->rt->caption());

			// rw
			$this->rw->EditAttrs["class"] = "form-control";
			$this->rw->EditCustomAttributes = "";
			if (!$this->rw->Raw)
				$this->rw->CurrentValue = HtmlDecode($this->rw->CurrentValue);
			$this->rw->EditValue = HtmlEncode($this->rw->CurrentValue);
			$this->rw->PlaceHolder = RemoveHtml($this->rw->caption());

			// Kelurahan
			$this->Kelurahan->EditAttrs["class"] = "form-control";
			$this->Kelurahan->EditCustomAttributes = "";
			if (!$this->Kelurahan->Raw)
				$this->Kelurahan->CurrentValue = HtmlDecode($this->Kelurahan->CurrentValue);
			$this->Kelurahan->EditValue = HtmlEncode($this->Kelurahan->CurrentValue);
			$this->Kelurahan->PlaceHolder = RemoveHtml($this->Kelurahan->caption());

			// Kecamatan
			$this->Kecamatan->EditAttrs["class"] = "form-control";
			$this->Kecamatan->EditCustomAttributes = "";
			if (!$this->Kecamatan->Raw)
				$this->Kecamatan->CurrentValue = HtmlDecode($this->Kecamatan->CurrentValue);
			$this->Kecamatan->EditValue = HtmlEncode($this->Kecamatan->CurrentValue);
			$this->Kecamatan->PlaceHolder = RemoveHtml($this->Kecamatan->caption());

			// Kota_Mhs
			$this->Kota_Mhs->EditAttrs["class"] = "form-control";
			$this->Kota_Mhs->EditCustomAttributes = "";
			if (!$this->Kota_Mhs->Raw)
				$this->Kota_Mhs->CurrentValue = HtmlDecode($this->Kota_Mhs->CurrentValue);
			$this->Kota_Mhs->EditValue = HtmlEncode($this->Kota_Mhs->CurrentValue);
			$this->Kota_Mhs->PlaceHolder = RemoveHtml($this->Kota_Mhs->caption());

			// Provinsi_mhs
			$this->Provinsi_mhs->EditAttrs["class"] = "form-control";
			$this->Provinsi_mhs->EditCustomAttributes = "";
			if (!$this->Provinsi_mhs->Raw)
				$this->Provinsi_mhs->CurrentValue = HtmlDecode($this->Provinsi_mhs->CurrentValue);
			$this->Provinsi_mhs->EditValue = HtmlEncode($this->Provinsi_mhs->CurrentValue);
			$this->Provinsi_mhs->PlaceHolder = RemoveHtml($this->Provinsi_mhs->caption());

			// Kodepos_Mhs
			$this->Kodepos_Mhs->EditAttrs["class"] = "form-control";
			$this->Kodepos_Mhs->EditCustomAttributes = "";
			if (!$this->Kodepos_Mhs->Raw)
				$this->Kodepos_Mhs->CurrentValue = HtmlDecode($this->Kodepos_Mhs->CurrentValue);
			$this->Kodepos_Mhs->EditValue = HtmlEncode($this->Kodepos_Mhs->CurrentValue);
			$this->Kodepos_Mhs->PlaceHolder = RemoveHtml($this->Kodepos_Mhs->caption());

			// Tlp_Mhs
			$this->Tlp_Mhs->EditAttrs["class"] = "form-control";
			$this->Tlp_Mhs->EditCustomAttributes = "";
			if (!$this->Tlp_Mhs->Raw)
				$this->Tlp_Mhs->CurrentValue = HtmlDecode($this->Tlp_Mhs->CurrentValue);
			$this->Tlp_Mhs->EditValue = HtmlEncode($this->Tlp_Mhs->CurrentValue);
			$this->Tlp_Mhs->PlaceHolder = RemoveHtml($this->Tlp_Mhs->caption());

			// TlpRumah
			$this->TlpRumah->EditAttrs["class"] = "form-control";
			$this->TlpRumah->EditCustomAttributes = "";
			if (!$this->TlpRumah->Raw)
				$this->TlpRumah->CurrentValue = HtmlDecode($this->TlpRumah->CurrentValue);
			$this->TlpRumah->EditValue = HtmlEncode($this->TlpRumah->CurrentValue);
			$this->TlpRumah->PlaceHolder = RemoveHtml($this->TlpRumah->caption());

			// Email
			$this->_Email->EditAttrs["class"] = "form-control";
			$this->_Email->EditCustomAttributes = "";
			if (!$this->_Email->Raw)
				$this->_Email->CurrentValue = HtmlDecode($this->_Email->CurrentValue);
			$this->_Email->EditValue = HtmlEncode($this->_Email->CurrentValue);
			$this->_Email->PlaceHolder = RemoveHtml($this->_Email->caption());

			// Status_Akd
			$this->Status_Akd->EditAttrs["class"] = "form-control";
			$this->Status_Akd->EditCustomAttributes = "";
			$curVal = trim(strval($this->Status_Akd->CurrentValue));
			if ($curVal != "")
				$this->Status_Akd->ViewValue = $this->Status_Akd->lookupCacheOption($curVal);
			else
				$this->Status_Akd->ViewValue = $this->Status_Akd->Lookup !== NULL && is_array($this->Status_Akd->Lookup->Options) ? $curVal : NULL;
			if ($this->Status_Akd->ViewValue !== NULL) { // Load from cache
				$this->Status_Akd->EditValue = array_values($this->Status_Akd->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "[Kelas]" . SearchString("=", $this->Status_Akd->CurrentValue, DATATYPE_STRING, "");
				}
				$sqlWrk = $this->Status_Akd->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = $rswrk ? $rswrk->getRows() : [];
				if ($rswrk)
					$rswrk->close();
				$this->Status_Akd->EditValue = $arwrk;
			}

			// tglmasuk
			$this->tglmasuk->EditAttrs["class"] = "form-control";
			$this->tglmasuk->EditCustomAttributes = "";
			$this->tglmasuk->EditValue = HtmlEncode(FormatDateTime($this->tglmasuk->CurrentValue, 7));
			$this->tglmasuk->PlaceHolder = RemoveHtml($this->tglmasuk->caption());

			// Status_Masuk
			$this->Status_Masuk->EditAttrs["class"] = "form-control";
			$this->Status_Masuk->EditCustomAttributes = "";
			$this->Status_Masuk->EditValue = $this->Status_Masuk->options(TRUE);

			// Sem_Masuk
			$this->Sem_Masuk->EditAttrs["class"] = "form-control";
			$this->Sem_Masuk->EditCustomAttributes = "";
			if (!$this->Sem_Masuk->Raw)
				$this->Sem_Masuk->CurrentValue = HtmlDecode($this->Sem_Masuk->CurrentValue);
			$this->Sem_Masuk->EditValue = HtmlEncode($this->Sem_Masuk->CurrentValue);
			$this->Sem_Masuk->PlaceHolder = RemoveHtml($this->Sem_Masuk->caption());

			// TaMasuk
			$this->TaMasuk->EditAttrs["class"] = "form-control";
			$this->TaMasuk->EditCustomAttributes = "";
			$curVal = trim(strval($this->TaMasuk->CurrentValue));
			if ($curVal != "")
				$this->TaMasuk->ViewValue = $this->TaMasuk->lookupCacheOption($curVal);
			else
				$this->TaMasuk->ViewValue = $this->TaMasuk->Lookup !== NULL && is_array($this->TaMasuk->Lookup->Options) ? $curVal : NULL;
			if ($this->TaMasuk->ViewValue !== NULL) { // Load from cache
				$this->TaMasuk->EditValue = array_values($this->TaMasuk->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "[TA]" . SearchString("=", $this->TaMasuk->CurrentValue, DATATYPE_STRING, "");
				}
				$sqlWrk = $this->TaMasuk->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = $rswrk ? $rswrk->getRows() : [];
				if ($rswrk)
					$rswrk->close();
				$this->TaMasuk->EditValue = $arwrk;
			}

			// PerMasuk
			$this->PerMasuk->EditAttrs["class"] = "form-control";
			$this->PerMasuk->EditCustomAttributes = "";
			$this->PerMasuk->EditValue = $this->PerMasuk->options(TRUE);

			// Thn_Selesai
			$this->Thn_Selesai->EditAttrs["class"] = "form-control";
			$this->Thn_Selesai->EditCustomAttributes = "";
			if (!$this->Thn_Selesai->Raw)
				$this->Thn_Selesai->CurrentValue = HtmlDecode($this->Thn_Selesai->CurrentValue);
			$this->Thn_Selesai->EditValue = HtmlEncode($this->Thn_Selesai->CurrentValue);
			$this->Thn_Selesai->PlaceHolder = RemoveHtml($this->Thn_Selesai->caption());

			// Status
			$this->Status->EditAttrs["class"] = "form-control";
			$this->Status->EditCustomAttributes = "";
			$this->Status->EditValue = $this->Status->options(TRUE);

			// NIK
			$this->NIK->EditAttrs["class"] = "form-control";
			$this->NIK->EditCustomAttributes = "";
			if (!$this->NIK->Raw)
				$this->NIK->CurrentValue = HtmlDecode($this->NIK->CurrentValue);
			$this->NIK->EditValue = HtmlEncode($this->NIK->CurrentValue);
			$this->NIK->PlaceHolder = RemoveHtml($this->NIK->caption());

			// NamaIbu
			$this->NamaIbu->EditAttrs["class"] = "form-control";
			$this->NamaIbu->EditCustomAttributes = "";
			if (!$this->NamaIbu->Raw)
				$this->NamaIbu->CurrentValue = HtmlDecode($this->NamaIbu->CurrentValue);
			$this->NamaIbu->EditValue = HtmlEncode($this->NamaIbu->CurrentValue);
			$this->NamaIbu->PlaceHolder = RemoveHtml($this->NamaIbu->caption());

			// iddesa
			$this->iddesa->EditAttrs["class"] = "form-control";
			$this->iddesa->EditCustomAttributes = "";
			$this->iddesa->EditValue = HtmlEncode($this->iddesa->CurrentValue);
			$this->iddesa->PlaceHolder = RemoveHtml($this->iddesa->caption());

			// MulaiKerja
			$this->MulaiKerja->EditAttrs["class"] = "form-control";
			$this->MulaiKerja->EditCustomAttributes = "";
			$this->MulaiKerja->EditValue = HtmlEncode(FormatDateTime($this->MulaiKerja->CurrentValue, 8));
			$this->MulaiKerja->PlaceHolder = RemoveHtml($this->MulaiKerja->caption());

			// IdKlsKerjasama
			$this->IdKlsKerjasama->EditAttrs["class"] = "form-control";
			$this->IdKlsKerjasama->EditCustomAttributes = "";
			$this->IdKlsKerjasama->EditValue = HtmlEncode($this->IdKlsKerjasama->CurrentValue);
			$this->IdKlsKerjasama->PlaceHolder = RemoveHtml($this->IdKlsKerjasama->caption());

			// IDBeasiswa
			$this->IDBeasiswa->EditAttrs["class"] = "form-control";
			$this->IDBeasiswa->EditCustomAttributes = "";
			$this->IDBeasiswa->EditValue = HtmlEncode($this->IDBeasiswa->CurrentValue);
			$this->IDBeasiswa->PlaceHolder = RemoveHtml($this->IDBeasiswa->caption());

			// tglKonversi
			$this->tglKonversi->EditAttrs["class"] = "form-control";
			$this->tglKonversi->EditCustomAttributes = "";
			$this->tglKonversi->EditValue = HtmlEncode(FormatDateTime($this->tglKonversi->CurrentValue, 8));
			$this->tglKonversi->PlaceHolder = RemoveHtml($this->tglKonversi->caption());

			// NoSuratKonversi
			$this->NoSuratKonversi->EditAttrs["class"] = "form-control";
			$this->NoSuratKonversi->EditCustomAttributes = "";
			if (!$this->NoSuratKonversi->Raw)
				$this->NoSuratKonversi->CurrentValue = HtmlDecode($this->NoSuratKonversi->CurrentValue);
			$this->NoSuratKonversi->EditValue = HtmlEncode($this->NoSuratKonversi->CurrentValue);
			$this->NoSuratKonversi->PlaceHolder = RemoveHtml($this->NoSuratKonversi->caption());

			// Nopen
			$this->Nopen->EditAttrs["class"] = "form-control";
			$this->Nopen->EditCustomAttributes = "";
			$this->Nopen->EditValue = HtmlEncode($this->Nopen->CurrentValue);
			$this->Nopen->PlaceHolder = RemoveHtml($this->Nopen->caption());

			// id_feedmhs
			$this->id_feedmhs->EditAttrs["class"] = "form-control";
			$this->id_feedmhs->EditCustomAttributes = "";
			if (!$this->id_feedmhs->Raw)
				$this->id_feedmhs->CurrentValue = HtmlDecode($this->id_feedmhs->CurrentValue);
			$this->id_feedmhs->EditValue = HtmlEncode($this->id_feedmhs->CurrentValue);
			$this->id_feedmhs->PlaceHolder = RemoveHtml($this->id_feedmhs->caption());

			// Edit refer script
			// Nim

			$this->Nim->LinkCustomAttributes = "";
			$this->Nim->HrefValue = "";
			$this->Nim->TooltipValue = "";

			// Nama_Mhs
			$this->Nama_Mhs->LinkCustomAttributes = "";
			$this->Nama_Mhs->HrefValue = "";

			// Kode_jp
			$this->Kode_jp->LinkCustomAttributes = "";
			$this->Kode_jp->HrefValue = "";
			$this->Kode_jp->TooltipValue = "";

			// Tmp_Lahir
			$this->Tmp_Lahir->LinkCustomAttributes = "";
			$this->Tmp_Lahir->HrefValue = "";

			// Tgl_Lahir
			$this->Tgl_Lahir->LinkCustomAttributes = "";
			$this->Tgl_Lahir->HrefValue = "";

			// Jenis_Kel
			$this->Jenis_Kel->LinkCustomAttributes = "";
			$this->Jenis_Kel->HrefValue = "";

			// Gol_darah
			$this->Gol_darah->LinkCustomAttributes = "";
			$this->Gol_darah->HrefValue = "";

			// Agama_Mhs
			$this->Agama_Mhs->LinkCustomAttributes = "";
			$this->Agama_Mhs->HrefValue = "";

			// Alamat_Mhs
			$this->Alamat_Mhs->LinkCustomAttributes = "";
			$this->Alamat_Mhs->HrefValue = "";

			// rt
			$this->rt->LinkCustomAttributes = "";
			$this->rt->HrefValue = "";

			// rw
			$this->rw->LinkCustomAttributes = "";
			$this->rw->HrefValue = "";

			// Kelurahan
			$this->Kelurahan->LinkCustomAttributes = "";
			$this->Kelurahan->HrefValue = "";

			// Kecamatan
			$this->Kecamatan->LinkCustomAttributes = "";
			$this->Kecamatan->HrefValue = "";

			// Kota_Mhs
			$this->Kota_Mhs->LinkCustomAttributes = "";
			$this->Kota_Mhs->HrefValue = "";

			// Provinsi_mhs
			$this->Provinsi_mhs->LinkCustomAttributes = "";
			$this->Provinsi_mhs->HrefValue = "";

			// Kodepos_Mhs
			$this->Kodepos_Mhs->LinkCustomAttributes = "";
			$this->Kodepos_Mhs->HrefValue = "";

			// Tlp_Mhs
			$this->Tlp_Mhs->LinkCustomAttributes = "";
			if (!EmptyValue($this->Tlp_Mhs->CurrentValue)) {
				$this->Tlp_Mhs->HrefValue = "https://wa.me/62" . $this->Tlp_Mhs->CurrentValue; // Add prefix/suffix
				$this->Tlp_Mhs->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport())
					$this->Tlp_Mhs->HrefValue = FullUrl($this->Tlp_Mhs->HrefValue, "href");
			} else {
				$this->Tlp_Mhs->HrefValue = "";
			}

			// TlpRumah
			$this->TlpRumah->LinkCustomAttributes = "";
			$this->TlpRumah->HrefValue = "";

			// Email
			$this->_Email->LinkCustomAttributes = "";
			if (!EmptyValue($this->_Email->CurrentValue)) {
				$this->_Email->HrefValue = "mailto:" . (!empty($this->_Email->EditValue) && !is_array($this->_Email->EditValue) ? RemoveHtml($this->_Email->EditValue) : $this->_Email->CurrentValue); // Add prefix/suffix
				$this->_Email->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport())
					$this->_Email->HrefValue = FullUrl($this->_Email->HrefValue, "href");
			} else {
				$this->_Email->HrefValue = "";
			}

			// Status_Akd
			$this->Status_Akd->LinkCustomAttributes = "";
			$this->Status_Akd->HrefValue = "";

			// tglmasuk
			$this->tglmasuk->LinkCustomAttributes = "";
			$this->tglmasuk->HrefValue = "";

			// Status_Masuk
			$this->Status_Masuk->LinkCustomAttributes = "";
			$this->Status_Masuk->HrefValue = "";

			// Sem_Masuk
			$this->Sem_Masuk->LinkCustomAttributes = "";
			$this->Sem_Masuk->HrefValue = "";

			// TaMasuk
			$this->TaMasuk->LinkCustomAttributes = "";
			$this->TaMasuk->HrefValue = "";

			// PerMasuk
			$this->PerMasuk->LinkCustomAttributes = "";
			$this->PerMasuk->HrefValue = "";

			// Thn_Selesai
			$this->Thn_Selesai->LinkCustomAttributes = "";
			$this->Thn_Selesai->HrefValue = "";

			// Status
			$this->Status->LinkCustomAttributes = "";
			$this->Status->HrefValue = "";

			// NIK
			$this->NIK->LinkCustomAttributes = "";
			$this->NIK->HrefValue = "";

			// NamaIbu
			$this->NamaIbu->LinkCustomAttributes = "";
			$this->NamaIbu->HrefValue = "";

			// iddesa
			$this->iddesa->LinkCustomAttributes = "";
			$this->iddesa->HrefValue = "";

			// MulaiKerja
			$this->MulaiKerja->LinkCustomAttributes = "";
			$this->MulaiKerja->HrefValue = "";

			// IdKlsKerjasama
			$this->IdKlsKerjasama->LinkCustomAttributes = "";
			$this->IdKlsKerjasama->HrefValue = "";

			// IDBeasiswa
			$this->IDBeasiswa->LinkCustomAttributes = "";
			$this->IDBeasiswa->HrefValue = "";

			// tglKonversi
			$this->tglKonversi->LinkCustomAttributes = "";
			$this->tglKonversi->HrefValue = "";

			// NoSuratKonversi
			$this->NoSuratKonversi->LinkCustomAttributes = "";
			$this->NoSuratKonversi->HrefValue = "";

			// Nopen
			$this->Nopen->LinkCustomAttributes = "";
			$this->Nopen->HrefValue = "";

			// id_feedmhs
			$this->id_feedmhs->LinkCustomAttributes = "";
			$this->id_feedmhs->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType != ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!Config("SERVER_VALIDATE"))
			return ($FormError == "");
		if ($this->Nim->Required) {
			if (!$this->Nim->IsDetailKey && $this->Nim->FormValue != NULL && $this->Nim->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Nim->caption(), $this->Nim->RequiredErrorMessage));
			}
		}
		if ($this->Nama_Mhs->Required) {
			if (!$this->Nama_Mhs->IsDetailKey && $this->Nama_Mhs->FormValue != NULL && $this->Nama_Mhs->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Nama_Mhs->caption(), $this->Nama_Mhs->RequiredErrorMessage));
			}
		}
		if ($this->Kode_jp->Required) {
			if (!$this->Kode_jp->IsDetailKey && $this->Kode_jp->FormValue != NULL && $this->Kode_jp->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Kode_jp->caption(), $this->Kode_jp->RequiredErrorMessage));
			}
		}
		if ($this->Tmp_Lahir->Required) {
			if (!$this->Tmp_Lahir->IsDetailKey && $this->Tmp_Lahir->FormValue != NULL && $this->Tmp_Lahir->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Tmp_Lahir->caption(), $this->Tmp_Lahir->RequiredErrorMessage));
			}
		}
		if ($this->Tgl_Lahir->Required) {
			if (!$this->Tgl_Lahir->IsDetailKey && $this->Tgl_Lahir->FormValue != NULL && $this->Tgl_Lahir->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Tgl_Lahir->caption(), $this->Tgl_Lahir->RequiredErrorMessage));
			}
		}
		if (!CheckDate($this->Tgl_Lahir->FormValue)) {
			AddMessage($FormError, $this->Tgl_Lahir->errorMessage());
		}
		if ($this->Jenis_Kel->Required) {
			if (!$this->Jenis_Kel->IsDetailKey && $this->Jenis_Kel->FormValue != NULL && $this->Jenis_Kel->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Jenis_Kel->caption(), $this->Jenis_Kel->RequiredErrorMessage));
			}
		}
		if ($this->Gol_darah->Required) {
			if (!$this->Gol_darah->IsDetailKey && $this->Gol_darah->FormValue != NULL && $this->Gol_darah->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Gol_darah->caption(), $this->Gol_darah->RequiredErrorMessage));
			}
		}
		if ($this->Agama_Mhs->Required) {
			if (!$this->Agama_Mhs->IsDetailKey && $this->Agama_Mhs->FormValue != NULL && $this->Agama_Mhs->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Agama_Mhs->caption(), $this->Agama_Mhs->RequiredErrorMessage));
			}
		}
		if ($this->Alamat_Mhs->Required) {
			if (!$this->Alamat_Mhs->IsDetailKey && $this->Alamat_Mhs->FormValue != NULL && $this->Alamat_Mhs->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Alamat_Mhs->caption(), $this->Alamat_Mhs->RequiredErrorMessage));
			}
		}
		if ($this->rt->Required) {
			if (!$this->rt->IsDetailKey && $this->rt->FormValue != NULL && $this->rt->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->rt->caption(), $this->rt->RequiredErrorMessage));
			}
		}
		if ($this->rw->Required) {
			if (!$this->rw->IsDetailKey && $this->rw->FormValue != NULL && $this->rw->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->rw->caption(), $this->rw->RequiredErrorMessage));
			}
		}
		if ($this->Kelurahan->Required) {
			if (!$this->Kelurahan->IsDetailKey && $this->Kelurahan->FormValue != NULL && $this->Kelurahan->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Kelurahan->caption(), $this->Kelurahan->RequiredErrorMessage));
			}
		}
		if ($this->Kecamatan->Required) {
			if (!$this->Kecamatan->IsDetailKey && $this->Kecamatan->FormValue != NULL && $this->Kecamatan->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Kecamatan->caption(), $this->Kecamatan->RequiredErrorMessage));
			}
		}
		if ($this->Kota_Mhs->Required) {
			if (!$this->Kota_Mhs->IsDetailKey && $this->Kota_Mhs->FormValue != NULL && $this->Kota_Mhs->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Kota_Mhs->caption(), $this->Kota_Mhs->RequiredErrorMessage));
			}
		}
		if ($this->Provinsi_mhs->Required) {
			if (!$this->Provinsi_mhs->IsDetailKey && $this->Provinsi_mhs->FormValue != NULL && $this->Provinsi_mhs->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Provinsi_mhs->caption(), $this->Provinsi_mhs->RequiredErrorMessage));
			}
		}
		if ($this->Kodepos_Mhs->Required) {
			if (!$this->Kodepos_Mhs->IsDetailKey && $this->Kodepos_Mhs->FormValue != NULL && $this->Kodepos_Mhs->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Kodepos_Mhs->caption(), $this->Kodepos_Mhs->RequiredErrorMessage));
			}
		}
		if ($this->Tlp_Mhs->Required) {
			if (!$this->Tlp_Mhs->IsDetailKey && $this->Tlp_Mhs->FormValue != NULL && $this->Tlp_Mhs->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Tlp_Mhs->caption(), $this->Tlp_Mhs->RequiredErrorMessage));
			}
		}
		if ($this->TlpRumah->Required) {
			if (!$this->TlpRumah->IsDetailKey && $this->TlpRumah->FormValue != NULL && $this->TlpRumah->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->TlpRumah->caption(), $this->TlpRumah->RequiredErrorMessage));
			}
		}
		if ($this->_Email->Required) {
			if (!$this->_Email->IsDetailKey && $this->_Email->FormValue != NULL && $this->_Email->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_Email->caption(), $this->_Email->RequiredErrorMessage));
			}
		}
		if ($this->Status_Akd->Required) {
			if (!$this->Status_Akd->IsDetailKey && $this->Status_Akd->FormValue != NULL && $this->Status_Akd->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Status_Akd->caption(), $this->Status_Akd->RequiredErrorMessage));
			}
		}
		if ($this->tglmasuk->Required) {
			if (!$this->tglmasuk->IsDetailKey && $this->tglmasuk->FormValue != NULL && $this->tglmasuk->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->tglmasuk->caption(), $this->tglmasuk->RequiredErrorMessage));
			}
		}
		if (!CheckEuroDate($this->tglmasuk->FormValue)) {
			AddMessage($FormError, $this->tglmasuk->errorMessage());
		}
		if ($this->Status_Masuk->Required) {
			if (!$this->Status_Masuk->IsDetailKey && $this->Status_Masuk->FormValue != NULL && $this->Status_Masuk->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Status_Masuk->caption(), $this->Status_Masuk->RequiredErrorMessage));
			}
		}
		if ($this->Sem_Masuk->Required) {
			if (!$this->Sem_Masuk->IsDetailKey && $this->Sem_Masuk->FormValue != NULL && $this->Sem_Masuk->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Sem_Masuk->caption(), $this->Sem_Masuk->RequiredErrorMessage));
			}
		}
		if ($this->TaMasuk->Required) {
			if (!$this->TaMasuk->IsDetailKey && $this->TaMasuk->FormValue != NULL && $this->TaMasuk->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->TaMasuk->caption(), $this->TaMasuk->RequiredErrorMessage));
			}
		}
		if ($this->PerMasuk->Required) {
			if (!$this->PerMasuk->IsDetailKey && $this->PerMasuk->FormValue != NULL && $this->PerMasuk->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->PerMasuk->caption(), $this->PerMasuk->RequiredErrorMessage));
			}
		}
		if ($this->Thn_Selesai->Required) {
			if (!$this->Thn_Selesai->IsDetailKey && $this->Thn_Selesai->FormValue != NULL && $this->Thn_Selesai->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Thn_Selesai->caption(), $this->Thn_Selesai->RequiredErrorMessage));
			}
		}
		if ($this->Status->Required) {
			if (!$this->Status->IsDetailKey && $this->Status->FormValue != NULL && $this->Status->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Status->caption(), $this->Status->RequiredErrorMessage));
			}
		}
		if ($this->NIK->Required) {
			if (!$this->NIK->IsDetailKey && $this->NIK->FormValue != NULL && $this->NIK->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->NIK->caption(), $this->NIK->RequiredErrorMessage));
			}
		}
		if ($this->NamaIbu->Required) {
			if (!$this->NamaIbu->IsDetailKey && $this->NamaIbu->FormValue != NULL && $this->NamaIbu->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->NamaIbu->caption(), $this->NamaIbu->RequiredErrorMessage));
			}
		}
		if ($this->iddesa->Required) {
			if (!$this->iddesa->IsDetailKey && $this->iddesa->FormValue != NULL && $this->iddesa->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->iddesa->caption(), $this->iddesa->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->iddesa->FormValue)) {
			AddMessage($FormError, $this->iddesa->errorMessage());
		}
		if ($this->MulaiKerja->Required) {
			if (!$this->MulaiKerja->IsDetailKey && $this->MulaiKerja->FormValue != NULL && $this->MulaiKerja->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->MulaiKerja->caption(), $this->MulaiKerja->RequiredErrorMessage));
			}
		}
		if (!CheckDate($this->MulaiKerja->FormValue)) {
			AddMessage($FormError, $this->MulaiKerja->errorMessage());
		}
		if ($this->IdKlsKerjasama->Required) {
			if (!$this->IdKlsKerjasama->IsDetailKey && $this->IdKlsKerjasama->FormValue != NULL && $this->IdKlsKerjasama->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->IdKlsKerjasama->caption(), $this->IdKlsKerjasama->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->IdKlsKerjasama->FormValue)) {
			AddMessage($FormError, $this->IdKlsKerjasama->errorMessage());
		}
		if ($this->IDBeasiswa->Required) {
			if (!$this->IDBeasiswa->IsDetailKey && $this->IDBeasiswa->FormValue != NULL && $this->IDBeasiswa->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->IDBeasiswa->caption(), $this->IDBeasiswa->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->IDBeasiswa->FormValue)) {
			AddMessage($FormError, $this->IDBeasiswa->errorMessage());
		}
		if ($this->tglKonversi->Required) {
			if (!$this->tglKonversi->IsDetailKey && $this->tglKonversi->FormValue != NULL && $this->tglKonversi->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->tglKonversi->caption(), $this->tglKonversi->RequiredErrorMessage));
			}
		}
		if (!CheckDate($this->tglKonversi->FormValue)) {
			AddMessage($FormError, $this->tglKonversi->errorMessage());
		}
		if ($this->NoSuratKonversi->Required) {
			if (!$this->NoSuratKonversi->IsDetailKey && $this->NoSuratKonversi->FormValue != NULL && $this->NoSuratKonversi->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->NoSuratKonversi->caption(), $this->NoSuratKonversi->RequiredErrorMessage));
			}
		}
		if ($this->Nopen->Required) {
			if (!$this->Nopen->IsDetailKey && $this->Nopen->FormValue != NULL && $this->Nopen->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Nopen->caption(), $this->Nopen->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->Nopen->FormValue)) {
			AddMessage($FormError, $this->Nopen->errorMessage());
		}
		if ($this->id_feedmhs->Required) {
			if (!$this->id_feedmhs->IsDetailKey && $this->id_feedmhs->FormValue != NULL && $this->id_feedmhs->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->id_feedmhs->caption(), $this->id_feedmhs->RequiredErrorMessage));
			}
		}

		// Validate detail grid
		$detailTblVar = explode(",", $this->getCurrentDetailTable());
		if (in_array("Wli_DNS", $detailTblVar) && $GLOBALS["Wli_DNS"]->DetailEdit) {
			if (!isset($GLOBALS["Wli_DNS_grid"]))
				$GLOBALS["Wli_DNS_grid"] = new Wli_DNS_grid(); // Get detail page object
			$GLOBALS["Wli_DNS_grid"]->validateGridForm();
		}
		if (in_array("Wali_IPS", $detailTblVar) && $GLOBALS["Wali_IPS"]->DetailEdit) {
			if (!isset($GLOBALS["Wali_IPS_grid"]))
				$GLOBALS["Wali_IPS_grid"] = new Wali_IPS_grid(); // Get detail page object
			$GLOBALS["Wali_IPS_grid"]->validateGridForm();
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError != "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Update record based on key values
	protected function editRow()
	{
		global $Security, $Language;
		$oldKeyFilter = $this->getRecordFilter();
		$filter = $this->applyUserIDFilters($oldKeyFilter);
		$conn = $this->getConnection();
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn->raiseErrorFn = Config("ERROR_FUNC");
		$rs = $conn->execute($sql);
		$conn->raiseErrorFn = "";
		if ($rs === FALSE)
			return FALSE;
		if ($rs->EOF) {
			$this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
			$editRow = FALSE; // Update Failed
		} else {

			// Begin transaction
			if ($this->getCurrentDetailTable() != "")
				$conn->beginTrans();

			// Save old values
			$rsold = &$rs->fields;
			$this->loadDbValues($rsold);
			$rsnew = [];

			// Nama_Mhs
			$this->Nama_Mhs->setDbValueDef($rsnew, $this->Nama_Mhs->CurrentValue, NULL, $this->Nama_Mhs->ReadOnly);

			// Tmp_Lahir
			$this->Tmp_Lahir->setDbValueDef($rsnew, $this->Tmp_Lahir->CurrentValue, NULL, $this->Tmp_Lahir->ReadOnly);

			// Tgl_Lahir
			$this->Tgl_Lahir->setDbValueDef($rsnew, UnFormatDateTime($this->Tgl_Lahir->CurrentValue, 0), NULL, $this->Tgl_Lahir->ReadOnly);

			// Jenis_Kel
			$this->Jenis_Kel->setDbValueDef($rsnew, $this->Jenis_Kel->CurrentValue, NULL, $this->Jenis_Kel->ReadOnly);

			// Gol_darah
			$this->Gol_darah->setDbValueDef($rsnew, $this->Gol_darah->CurrentValue, NULL, $this->Gol_darah->ReadOnly);

			// Agama_Mhs
			$this->Agama_Mhs->setDbValueDef($rsnew, $this->Agama_Mhs->CurrentValue, NULL, $this->Agama_Mhs->ReadOnly);

			// Alamat_Mhs
			$this->Alamat_Mhs->setDbValueDef($rsnew, $this->Alamat_Mhs->CurrentValue, NULL, $this->Alamat_Mhs->ReadOnly);

			// rt
			$this->rt->setDbValueDef($rsnew, $this->rt->CurrentValue, NULL, $this->rt->ReadOnly);

			// rw
			$this->rw->setDbValueDef($rsnew, $this->rw->CurrentValue, NULL, $this->rw->ReadOnly);

			// Kelurahan
			$this->Kelurahan->setDbValueDef($rsnew, $this->Kelurahan->CurrentValue, NULL, $this->Kelurahan->ReadOnly);

			// Kecamatan
			$this->Kecamatan->setDbValueDef($rsnew, $this->Kecamatan->CurrentValue, NULL, $this->Kecamatan->ReadOnly);

			// Kota_Mhs
			$this->Kota_Mhs->setDbValueDef($rsnew, $this->Kota_Mhs->CurrentValue, NULL, $this->Kota_Mhs->ReadOnly);

			// Provinsi_mhs
			$this->Provinsi_mhs->setDbValueDef($rsnew, $this->Provinsi_mhs->CurrentValue, NULL, $this->Provinsi_mhs->ReadOnly);

			// Kodepos_Mhs
			$this->Kodepos_Mhs->setDbValueDef($rsnew, $this->Kodepos_Mhs->CurrentValue, NULL, $this->Kodepos_Mhs->ReadOnly);

			// Tlp_Mhs
			$this->Tlp_Mhs->setDbValueDef($rsnew, $this->Tlp_Mhs->CurrentValue, NULL, $this->Tlp_Mhs->ReadOnly);

			// TlpRumah
			$this->TlpRumah->setDbValueDef($rsnew, $this->TlpRumah->CurrentValue, NULL, $this->TlpRumah->ReadOnly);

			// Email
			$this->_Email->setDbValueDef($rsnew, $this->_Email->CurrentValue, NULL, $this->_Email->ReadOnly);

			// Status_Akd
			$this->Status_Akd->setDbValueDef($rsnew, $this->Status_Akd->CurrentValue, NULL, $this->Status_Akd->ReadOnly);

			// tglmasuk
			$this->tglmasuk->setDbValueDef($rsnew, UnFormatDateTime($this->tglmasuk->CurrentValue, 7), NULL, $this->tglmasuk->ReadOnly);

			// Status_Masuk
			$this->Status_Masuk->setDbValueDef($rsnew, $this->Status_Masuk->CurrentValue, NULL, $this->Status_Masuk->ReadOnly);

			// Sem_Masuk
			$this->Sem_Masuk->setDbValueDef($rsnew, $this->Sem_Masuk->CurrentValue, NULL, $this->Sem_Masuk->ReadOnly);

			// TaMasuk
			$this->TaMasuk->setDbValueDef($rsnew, $this->TaMasuk->CurrentValue, NULL, $this->TaMasuk->ReadOnly);

			// PerMasuk
			$this->PerMasuk->setDbValueDef($rsnew, $this->PerMasuk->CurrentValue, NULL, $this->PerMasuk->ReadOnly);

			// Thn_Selesai
			$this->Thn_Selesai->setDbValueDef($rsnew, $this->Thn_Selesai->CurrentValue, NULL, $this->Thn_Selesai->ReadOnly);

			// Status
			$this->Status->setDbValueDef($rsnew, $this->Status->CurrentValue, NULL, $this->Status->ReadOnly);

			// NIK
			$this->NIK->setDbValueDef($rsnew, $this->NIK->CurrentValue, NULL, $this->NIK->ReadOnly);

			// NamaIbu
			$this->NamaIbu->setDbValueDef($rsnew, $this->NamaIbu->CurrentValue, NULL, $this->NamaIbu->ReadOnly);

			// iddesa
			$this->iddesa->setDbValueDef($rsnew, $this->iddesa->CurrentValue, NULL, $this->iddesa->ReadOnly);

			// MulaiKerja
			$this->MulaiKerja->setDbValueDef($rsnew, UnFormatDateTime($this->MulaiKerja->CurrentValue, 0), NULL, $this->MulaiKerja->ReadOnly);

			// IdKlsKerjasama
			$this->IdKlsKerjasama->setDbValueDef($rsnew, $this->IdKlsKerjasama->CurrentValue, NULL, $this->IdKlsKerjasama->ReadOnly);

			// IDBeasiswa
			$this->IDBeasiswa->setDbValueDef($rsnew, $this->IDBeasiswa->CurrentValue, NULL, $this->IDBeasiswa->ReadOnly);

			// tglKonversi
			$this->tglKonversi->setDbValueDef($rsnew, UnFormatDateTime($this->tglKonversi->CurrentValue, 0), NULL, $this->tglKonversi->ReadOnly);

			// NoSuratKonversi
			$this->NoSuratKonversi->setDbValueDef($rsnew, $this->NoSuratKonversi->CurrentValue, NULL, $this->NoSuratKonversi->ReadOnly);

			// Nopen
			$this->Nopen->setDbValueDef($rsnew, $this->Nopen->CurrentValue, NULL, $this->Nopen->ReadOnly);

			// id_feedmhs
			$this->id_feedmhs->setDbValueDef($rsnew, $this->id_feedmhs->CurrentValue, NULL, $this->id_feedmhs->ReadOnly);

			// Call Row Updating event
			$updateRow = $this->Row_Updating($rsold, $rsnew);

			// Check for duplicate key when key changed
			if ($updateRow) {
				$newKeyFilter = $this->getRecordFilter($rsnew);
				if ($newKeyFilter != $oldKeyFilter) {
					$rsChk = $this->loadRs($newKeyFilter);
					if ($rsChk && !$rsChk->EOF) {
						$keyErrMsg = str_replace("%f", $newKeyFilter, $Language->phrase("DupKey"));
						$this->setFailureMessage($keyErrMsg);
						$rsChk->close();
						$updateRow = FALSE;
					}
				}
			}
			if ($updateRow) {
				$conn->raiseErrorFn = Config("ERROR_FUNC");
				if (count($rsnew) > 0)
					$editRow = $this->update($rsnew, "", $rsold);
				else
					$editRow = TRUE; // No field to update
				$conn->raiseErrorFn = "";
				if ($editRow) {
				}

				// Update detail records
				$detailTblVar = explode(",", $this->getCurrentDetailTable());
				if ($editRow) {
					if (in_array("Wli_DNS", $detailTblVar) && $GLOBALS["Wli_DNS"]->DetailEdit) {
						if (!isset($GLOBALS["Wli_DNS_grid"]))
							$GLOBALS["Wli_DNS_grid"] = new Wli_DNS_grid(); // Get detail page object
						$Security->loadCurrentUserLevel($this->ProjectID . "Wli_DNS"); // Load user level of detail table
						$editRow = $GLOBALS["Wli_DNS_grid"]->gridUpdate();
						$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName); // Restore user level of master table
					}
				}
				if ($editRow) {
					if (in_array("Wali_IPS", $detailTblVar) && $GLOBALS["Wali_IPS"]->DetailEdit) {
						if (!isset($GLOBALS["Wali_IPS_grid"]))
							$GLOBALS["Wali_IPS_grid"] = new Wali_IPS_grid(); // Get detail page object
						$Security->loadCurrentUserLevel($this->ProjectID . "Wali_IPS"); // Load user level of detail table
						$editRow = $GLOBALS["Wali_IPS_grid"]->gridUpdate();
						$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName); // Restore user level of master table
					}
				}

				// Commit/Rollback transaction
				if ($this->getCurrentDetailTable() != "") {
					if ($editRow) {
						$conn->commitTrans(); // Commit transaction
					} else {
						$conn->rollbackTrans(); // Rollback transaction
					}
				}
			} else {
				if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {

					// Use the message, do nothing
				} elseif ($this->CancelMessage != "") {
					$this->setFailureMessage($this->CancelMessage);
					$this->CancelMessage = "";
				} else {
					$this->setFailureMessage($Language->phrase("UpdateCancelled"));
				}
				$editRow = FALSE;
			}
		}

		// Call Row_Updated event
		if ($editRow)
			$this->Row_Updated($rsold, $rsnew);
		$rs->close();

		// Clean upload path if any
		if ($editRow) {
		}

		// Write JSON for API request
		if (IsApi() && $editRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $editRow;
	}

	// Set up detail parms based on QueryString
	protected function setupDetailParms()
	{

		// Get the keys for master table
		$detailTblVar = Get(Config("TABLE_SHOW_DETAIL"));
		if ($detailTblVar !== NULL) {
			$this->setCurrentDetailTable($detailTblVar);
		} else {
			$detailTblVar = $this->getCurrentDetailTable();
		}
		if ($detailTblVar != "") {
			$detailTblVar = explode(",", $detailTblVar);
			if (in_array("Wli_DNS", $detailTblVar)) {
				if (!isset($GLOBALS["Wli_DNS_grid"]))
					$GLOBALS["Wli_DNS_grid"] = new Wli_DNS_grid();
				if ($GLOBALS["Wli_DNS_grid"]->DetailEdit) {
					$GLOBALS["Wli_DNS_grid"]->CurrentMode = "edit";
					$GLOBALS["Wli_DNS_grid"]->CurrentAction = "gridedit";

					// Save current master table to detail table
					$GLOBALS["Wli_DNS_grid"]->setCurrentMasterTable($this->TableVar);
					$GLOBALS["Wli_DNS_grid"]->setStartRecordNumber(1);
					$GLOBALS["Wli_DNS_grid"]->Nim->IsDetailKey = TRUE;
					$GLOBALS["Wli_DNS_grid"]->Nim->CurrentValue = $this->Nim->CurrentValue;
					$GLOBALS["Wli_DNS_grid"]->Nim->setSessionValue($GLOBALS["Wli_DNS_grid"]->Nim->CurrentValue);
				}
			}
			if (in_array("Wali_IPS", $detailTblVar)) {
				if (!isset($GLOBALS["Wali_IPS_grid"]))
					$GLOBALS["Wali_IPS_grid"] = new Wali_IPS_grid();
				if ($GLOBALS["Wali_IPS_grid"]->DetailEdit) {
					$GLOBALS["Wali_IPS_grid"]->CurrentMode = "edit";
					$GLOBALS["Wali_IPS_grid"]->CurrentAction = "gridedit";

					// Save current master table to detail table
					$GLOBALS["Wali_IPS_grid"]->setCurrentMasterTable($this->TableVar);
					$GLOBALS["Wali_IPS_grid"]->setStartRecordNumber(1);
					$GLOBALS["Wali_IPS_grid"]->Nim->IsDetailKey = TRUE;
					$GLOBALS["Wali_IPS_grid"]->Nim->CurrentValue = $this->Nim->CurrentValue;
					$GLOBALS["Wali_IPS_grid"]->Nim->setSessionValue($GLOBALS["Wali_IPS_grid"]->Nim->CurrentValue);
					$GLOBALS["Wali_IPS_grid"]->Thn_Akademik->setSessionValue(""); // Clear session key
					$GLOBALS["Wali_IPS_grid"]->Periode->setSessionValue(""); // Clear session key
				}
			}
		}
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("tblMHSlist.php"), "", $this->TableVar, TRUE);
		$pageId = "edit";
		$Breadcrumb->add("edit", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// Get default connection and filter
			$conn = $this->getConnection();
			$lookupFilter = "";

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL and connection
			switch ($fld->FieldVar) {
				case "x_Kode_jp":
					break;
				case "x_Jenis_Kel":
					break;
				case "x_Status_Akd":
					break;
				case "x_Status_Masuk":
					break;
				case "x_TaMasuk":
					break;
				case "x_PerMasuk":
					break;
				case "x_Status":
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0) {
				$totalCnt = $this->getRecordCount($sql, $conn);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_Kode_jp":
							break;
						case "x_Status_Akd":
							break;
						case "x_TaMasuk":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Set up starting record parameters
	public function setupStartRecord()
	{
		if ($this->DisplayRecords == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			$startRec = Get(Config("TABLE_START_REC"));
			$pageNo = Get(Config("TABLE_PAGE_NO"));
			if ($pageNo !== NULL) { // Check for "pageno" parameter first
				if (is_numeric($pageNo)) {
					$this->StartRecord = ($pageNo - 1) * $this->DisplayRecords + 1;
					if ($this->StartRecord <= 0) {
						$this->StartRecord = 1;
					} elseif ($this->StartRecord >= (int)(($this->TotalRecords - 1)/$this->DisplayRecords) * $this->DisplayRecords + 1) {
						$this->StartRecord = (int)(($this->TotalRecords - 1)/$this->DisplayRecords) * $this->DisplayRecords + 1;
					}
					$this->setStartRecordNumber($this->StartRecord);
				}
			} elseif ($startRec !== NULL) { // Check for "start" parameter
				$this->StartRecord = $startRec;
				$this->setStartRecordNumber($this->StartRecord);
			}
		}
		$this->StartRecord = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRecord) || $this->StartRecord == "") { // Avoid invalid start record counter
			$this->StartRecord = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRecord);
		} elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
			$this->StartRecord = (int)(($this->TotalRecords - 1)/$this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRecord);
		} elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
			$this->StartRecord = (int)(($this->StartRecord - 1)/$this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRecord);
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
} // End class
?>