<?php
namespace PHPMaker2020\baak;

/**
 * Page class
 */
class tblMHS_list extends tblMHS
{

	// Page ID
	public $PageID = "list";

	// Project ID
	public $ProjectID = "{A09D3AFF-419C-4918-948A-A3C8469EA234}";

	// Table name
	public $TableName = 'tblMHS';

	// Page object name
	public $PageObjName = "tblMHS_list";

	// Grid form hidden field names
	public $FormName = "ftblMHSlist";
	public $FormActionName = "k_action";
	public $FormKeyName = "k_key";
	public $FormOldKeyName = "k_oldkey";
	public $FormBlankRowName = "k_blankrow";
	public $FormKeyCountName = "key_count";

	// Page URLs
	public $AddUrl;
	public $EditUrl;
	public $CopyUrl;
	public $DeleteUrl;
	public $ViewUrl;
	public $ListUrl;

	// Export URLs
	public $ExportPrintUrl;
	public $ExportHtmlUrl;
	public $ExportExcelUrl;
	public $ExportWordUrl;
	public $ExportXmlUrl;
	public $ExportCsvUrl;
	public $ExportPdfUrl;

	// Custom export
	public $ExportExcelCustom = FALSE;
	public $ExportWordCustom = FALSE;
	public $ExportPdfCustom = FALSE;
	public $ExportEmailCustom = FALSE;

	// Update URLs
	public $InlineAddUrl;
	public $InlineCopyUrl;
	public $InlineEditUrl;
	public $GridAddUrl;
	public $GridEditUrl;
	public $MultiDeleteUrl;
	public $MultiUpdateUrl;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken;

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading != "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading != "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		$url = CurrentPageName() . "?";
		if ($this->UseTokenInUrl)
			$url .= "t=" . $this->TableVar . "&"; // Add page token
		return $url;
	}

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = TRUE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message != "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fas fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage != "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fas fa-exclamation"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage != "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fas fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage != "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fas fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = [];

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message != "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage != "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage != "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage != "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header != "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer != "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(Config("TOKEN_NAME")) === NULL)
			return FALSE;
		$fn = Config("CHECK_TOKEN_FUNC");
		if (is_callable($fn))
			return $fn(Post(Config("TOKEN_NAME")), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = Config("CREATE_TOKEN_FUNC"); // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $DashboardReport;
		global $UserTable;

		// Check token
		$this->CheckToken = Config("CHECK_TOKEN");

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (tblMHS)
		if (!isset($GLOBALS["tblMHS"]) || get_class($GLOBALS["tblMHS"]) == PROJECT_NAMESPACE . "tblMHS") {
			$GLOBALS["tblMHS"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["tblMHS"];
		}

		// Initialize URLs
		$this->ExportPrintUrl = $this->pageUrl() . "export=print";
		$this->ExportExcelUrl = $this->pageUrl() . "export=excel";
		$this->ExportWordUrl = $this->pageUrl() . "export=word";
		$this->ExportPdfUrl = $this->pageUrl() . "export=pdf";
		$this->ExportHtmlUrl = $this->pageUrl() . "export=html";
		$this->ExportXmlUrl = $this->pageUrl() . "export=xml";
		$this->ExportCsvUrl = $this->pageUrl() . "export=csv";
		$this->AddUrl = "tblMHSadd.php?" . Config("TABLE_SHOW_DETAIL") . "=";
		$this->InlineAddUrl = $this->pageUrl() . "action=add";
		$this->GridAddUrl = $this->pageUrl() . "action=gridadd";
		$this->GridEditUrl = $this->pageUrl() . "action=gridedit";
		$this->MultiDeleteUrl = "tblMHSdelete.php";
		$this->MultiUpdateUrl = "tblMHSupdate.php";

		// Table object (Pass)
		if (!isset($GLOBALS['Pass']))
			$GLOBALS['Pass'] = new Pass();

		// Page ID (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'list');

		// Table name (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'tblMHS');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = $this->getConnection();

		// User table object (Pass)
		$UserTable = $UserTable ?: new Pass();

		// List options
		$this->ListOptions = new ListOptions();
		$this->ListOptions->TableVar = $this->TableVar;

		// Export options
		$this->ExportOptions = new ListOptions("div");
		$this->ExportOptions->TagClassName = "ew-export-option";

		// Import options
		$this->ImportOptions = new ListOptions("div");
		$this->ImportOptions->TagClassName = "ew-import-option";

		// Other options
		if (!$this->OtherOptions)
			$this->OtherOptions = new ListOptionsArray();
		$this->OtherOptions["addedit"] = new ListOptions("div");
		$this->OtherOptions["addedit"]->TagClassName = "ew-add-edit-option";
		$this->OtherOptions["detail"] = new ListOptions("div");
		$this->OtherOptions["detail"]->TagClassName = "ew-detail-option";
		$this->OtherOptions["action"] = new ListOptions("div");
		$this->OtherOptions["action"]->TagClassName = "ew-action-option";

		// Filter options
		$this->FilterOptions = new ListOptions("div");
		$this->FilterOptions->TagClassName = "ew-filter-option ftblMHSlistsrch";

		// List actions
		$this->ListActions = new ListActions();
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages, $DashboardReport;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $tblMHS;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, Config("EXPORT_CLASSES"))) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . Config("EXPORT_CLASSES." . $this->CustomExport);
			if (class_exists($class)) {
				$doc = new $class($tblMHS);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url != "") {
			if (!Config("DEBUG") && ob_get_length())
				ob_end_clean();
			SaveDebugMessage();
			AddHeader("Location", $url);
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = [];
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = [];
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {
								$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
									Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
									Config("API_FIELD_NAME") . "=" . $fld->Param . "&" .
									Config("API_KEY_NAME") . "=" . rawurlencode($this->getRecordKeyValue($ar)))); //*** need to add this? API may not be in the same folder
								$row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
								$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
									Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
									"fn=" . Encrypt($fld->physicalUploadPath() . $val)));
								$row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
							} else { // Multiple files
								$files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
								$ar = [];
								foreach ($files as $file) {
									$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
										Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
										"fn=" . Encrypt($fld->physicalUploadPath() . $file)));
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						if ($fld->DataType == DATATYPE_MEMO && $fld->MemoMaxLength > 0)
							$val = TruncateMemo($val, $fld->MemoMaxLength, $fld->TruncateMemoRemoveHtml);
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['Nim'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
	}

	// Lookup data
	public function lookup()
	{
		global $Language, $Security;
		if (!isset($Language))
			$Language = new Language(Config("LANGUAGE_FOLDER"), Post("language", ""));

		// Set up API request
		if (!ValidApiRequest())
			return FALSE;
		$this->setupApiSecurity();

		// Get lookup object
		$fieldName = Post("field");
		if (!array_key_exists($fieldName, $this->fields))
			return FALSE;
		$lookupField = $this->fields[$fieldName];
		$lookup = $lookupField->Lookup;
		if ($lookup === NULL)
			return FALSE;
		$tbl = $lookup->getTable();
		if (!$Security->allowLookup(Config("PROJECT_ID") . $tbl->TableName)) // Lookup permission
			return FALSE;

		// Get lookup parameters
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Param("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
			$lookup->FilterFields = []; // Skip parent fields if any
			$lookup->FilterValues[] = $keys; // Lookup values
			$pageSize = -1; // Show all records
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect != "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter != "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy != "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson($this); // Use settings from current page
	}

	// Set up API security
	public function setupApiSecurity()
	{
		global $Security;

		// Setup security for API request
		if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
		$Security->loadCurrentUserLevel(Config("PROJECT_ID") . $this->TableName);
		if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
	}

	// Class variables
	public $ListOptions; // List options
	public $ExportOptions; // Export options
	public $SearchOptions; // Search options
	public $OtherOptions; // Other options
	public $FilterOptions; // Filter options
	public $ImportOptions; // Import options
	public $ListActions; // List actions
	public $SelectedCount = 0;
	public $SelectedIndex = 0;
	public $DisplayRecords = 20;
	public $StartRecord;
	public $StopRecord;
	public $TotalRecords = 0;
	public $RecordRange = 10;
	public $PageSizes = "15,20,30,90,-1"; // Page sizes (comma separated)
	public $DefaultSearchWhere = ""; // Default search WHERE clause
	public $SearchWhere = ""; // Search WHERE clause
	public $SearchPanelClass = "ew-search-panel collapse show"; // Search Panel class
	public $SearchRowCount = 0; // For extended search
	public $SearchColumnCount = 0; // For extended search
	public $SearchFieldsPerRow = 1; // For extended search
	public $RecordCount = 0; // Record count
	public $EditRowCount;
	public $StartRowCount = 1;
	public $RowCount = 0;
	public $Attrs = []; // Row attributes and cell attributes
	public $RowIndex = 0; // Row index
	public $KeyCount = 0; // Key count
	public $RowAction = ""; // Row action
	public $RowOldKey = ""; // Row old key (for copy)
	public $MultiColumnClass = "col-sm";
	public $MultiColumnEditClass = "w-100";
	public $DbMasterFilter = ""; // Master filter
	public $DbDetailFilter = ""; // Detail filter
	public $MasterRecordExists;
	public $MultiSelectKey;
	public $Command;
	public $RestoreSearch = FALSE;
	public $Wli_DNS_Count;
	public $Wali_IPS_Count;
	public $DetailPages;
	public $OldRecordset;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $CurrentForm,
			$FormError, $SearchError;

		// User profile
		$UserProfile = new UserProfile();

		// Security
		if (ValidApiRequest()) { // API request
			$this->setupApiSecurity(); // Set up API Security
			if (!$Security->canList()) {
				SetStatus(401); // Unauthorized
				return;
			}
		} else {
			$Security = new AdvancedSecurity();
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canList()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				$this->terminate(GetUrl("index.php"));
				return;
			}
		}

		// Get export parameters
		$custom = "";
		if (Param("export") !== NULL) {
			$this->Export = Param("export");
			$custom = Param("custom", "");
		} elseif (IsPost()) {
			if (Post("exporttype") !== NULL)
				$this->Export = Post("exporttype");
			$custom = Post("custom", "");
		} elseif (Get("cmd") == "json") {
			$this->Export = Get("cmd");
		} else {
			$this->setExportReturnUrl(CurrentUrl());
		}
		$ExportFileName = $this->TableVar; // Get export file, used in header

		// Get custom export parameters
		if ($this->isExport() && $custom != "") {
			$this->CustomExport = $this->Export;
			$this->Export = "print";
		}
		$CustomExportType = $this->CustomExport;
		$ExportType = $this->Export; // Get export parameter, used in header

		// Update Export URLs
		if (Config("USE_PHPEXCEL"))
			$this->ExportExcelCustom = FALSE;
		if ($this->ExportExcelCustom)
			$this->ExportExcelUrl .= "&amp;custom=1";
		if (Config("USE_PHPWORD"))
			$this->ExportWordCustom = FALSE;
		if ($this->ExportWordCustom)
			$this->ExportWordUrl .= "&amp;custom=1";
		if ($this->ExportPdfCustom)
			$this->ExportPdfUrl .= "&amp;custom=1";
		$this->CurrentAction = Param("action"); // Set up current action

		// Get grid add count
		$gridaddcnt = Get(Config("TABLE_GRID_ADD_ROW_COUNT"), "");
		if (is_numeric($gridaddcnt) && $gridaddcnt > 0)
			$this->GridAddRowCount = $gridaddcnt;

		// Set up list options
		$this->setupListOptions();

		// Setup export options
		$this->setupExportOptions();
		$this->Nim->setVisibility();
		$this->Nama_Mhs->setVisibility();
		$this->Kode_jp->setVisibility();
		$this->Tmp_Lahir->Visible = FALSE;
		$this->Tgl_Lahir->Visible = FALSE;
		$this->Jenis_Kel->setVisibility();
		$this->Gol_darah->Visible = FALSE;
		$this->Agama_Mhs->Visible = FALSE;
		$this->Alamat_Mhs->Visible = FALSE;
		$this->rt->Visible = FALSE;
		$this->rw->Visible = FALSE;
		$this->Kelurahan->Visible = FALSE;
		$this->Kecamatan->Visible = FALSE;
		$this->Kota_Mhs->Visible = FALSE;
		$this->Provinsi_mhs->Visible = FALSE;
		$this->Kodepos_Mhs->Visible = FALSE;
		$this->Tlp_Mhs->setVisibility();
		$this->TlpRumah->Visible = FALSE;
		$this->_Email->Visible = FALSE;
		$this->Status_Akd->setVisibility();
		$this->ThMasuk->Visible = FALSE;
		$this->tglmasuk->Visible = FALSE;
		$this->Status_Masuk->setVisibility();
		$this->Sem_Masuk->Visible = FALSE;
		$this->TaMasuk->setVisibility();
		$this->PerMasuk->setVisibility();
		$this->Pendidikan_Akhir->Visible = FALSE;
		$this->Jurusan->Visible = FALSE;
		$this->Thn_Selesai->Visible = FALSE;
		$this->Kota_Pdkk->Visible = FALSE;
		$this->propinsi->Visible = FALSE;
		$this->NIMASAL->Visible = FALSE;
		$this->KPTSASAL->Visible = FALSE;
		$this->JENASAL->Visible = FALSE;
		$this->PSASAL->Visible = FALSE;
		$this->TSKSDIAKUI->Visible = FALSE;
		$this->NamaSekolahAsal->Visible = FALSE;
		$this->AlamatSekolahAsal->Visible = FALSE;
		$this->Status->setVisibility();
		$this->Photo->Visible = FALSE;
		$this->Password->Visible = FALSE;
		$this->Gelombang->Visible = FALSE;
		$this->JalurMasuk->Visible = FALSE;
		$this->Konsentrasi->Visible = FALSE;
		$this->NIK->Visible = FALSE;
		$this->NamaIbu->Visible = FALSE;
		$this->BekerjaDi->Visible = FALSE;
		$this->Lama->Visible = FALSE;
		$this->AlamatPerusahaan->Visible = FALSE;
		$this->TlpPerusahaan->Visible = FALSE;
		$this->Posisi->Visible = FALSE;
		$this->Departemen->Visible = FALSE;
		$this->IdUser->Visible = FALSE;
		$this->TempID->Visible = FALSE;
		$this->xphoto->Visible = FALSE;
		$this->profile->Visible = FALSE;
		$this->id_agama->Visible = FALSE;
		$this->id_negara->Visible = FALSE;
		$this->id_wilayah->Visible = FALSE;
		$this->id_jenis_tinggal->Visible = FALSE;
		$this->id_alat_transportasi->Visible = FALSE;
		$this->no_kps->Visible = FALSE;
		$this->penerima_kps->Visible = FALSE;
		$this->id_kebutuhan_khusus_mahasiswa->Visible = FALSE;
		$this->nisn->Visible = FALSE;
		$this->iddesa->Visible = FALSE;
		$this->MulaiKerja->Visible = FALSE;
		$this->IdKlsKerjasama->Visible = FALSE;
		$this->IDBeasiswa->Visible = FALSE;
		$this->tglKonversi->Visible = FALSE;
		$this->NoSuratKonversi->Visible = FALSE;
		$this->Nopen->setVisibility();
		$this->id_feedmhs->setVisibility();
		$this->hideFieldsForAddEdit();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Setup other options
		$this->setupOtherOptions();

		// Set up custom action (compatible with old version)
		foreach ($this->CustomActions as $name => $action)
			$this->ListActions->add($name, $action);

		// Show checkbox column if multiple action
		foreach ($this->ListActions->Items as $listaction) {
			if ($listaction->Select == ACTION_MULTIPLE && $listaction->Allow) {
				$this->ListOptions["checkbox"]->Visible = TRUE;
				break;
			}
		}

		// Set up lookup cache
		$this->setupLookupOptions($this->Kode_jp);
		$this->setupLookupOptions($this->Status_Akd);
		$this->setupLookupOptions($this->TaMasuk);

		// Search filters
		$srchAdvanced = ""; // Advanced search filter
		$srchBasic = ""; // Basic search filter
		$filter = "";

		// Get command
		$this->Command = strtolower(Get("cmd"));
		if ($this->isPageRequest()) { // Validate request

			// Process list action first
			if ($this->processListAction()) // Ajax request
				$this->terminate();

			// Set up records per page
			$this->setupDisplayRecords();

			// Handle reset command
			$this->resetCmd();

			// Set up Breadcrumb
			if (!$this->isExport())
				$this->setupBreadcrumb();

			// Hide list options
			if ($this->isExport()) {
				$this->ListOptions->hideAllOptions(["sequence"]);
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			} elseif ($this->isGridAdd() || $this->isGridEdit()) {
				$this->ListOptions->hideAllOptions();
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			}

			// Hide options
			if ($this->isExport() || $this->CurrentAction) {
				$this->ExportOptions->hideAllOptions();
				$this->FilterOptions->hideAllOptions();
				$this->ImportOptions->hideAllOptions();
			}

			// Hide other options
			if ($this->isExport())
				$this->OtherOptions->hideAllOptions();

			// Get default search criteria
			AddFilter($this->DefaultSearchWhere, $this->basicSearchWhere(TRUE));
			AddFilter($this->DefaultSearchWhere, $this->advancedSearchWhere(TRUE));

			// Get basic search values
			$this->loadBasicSearchValues();

			// Get and validate search values for advanced search
			$this->loadSearchValues(); // Get search values

			// Process filter list
			if ($this->processFilterList())
				$this->terminate();
			if (!$this->validateSearch())
				$this->setFailureMessage($SearchError);

			// Restore search parms from Session if not searching / reset / export
			if (($this->isExport() || $this->Command != "search" && $this->Command != "reset" && $this->Command != "resetall") && $this->Command != "json" && $this->checkSearchParms())
				$this->restoreSearchParms();

			// Call Recordset SearchValidated event
			$this->Recordset_SearchValidated();

			// Set up sorting order
			$this->setupSortOrder();

			// Get basic search criteria
			if ($SearchError == "")
				$srchBasic = $this->basicSearchWhere();

			// Get search criteria for advanced search
			if ($SearchError == "")
				$srchAdvanced = $this->advancedSearchWhere();
		}

		// Restore display records
		if ($this->Command != "json" && $this->getRecordsPerPage() != "") {
			$this->DisplayRecords = $this->getRecordsPerPage(); // Restore from Session
		} else {
			$this->DisplayRecords = 20; // Load default
			$this->setRecordsPerPage($this->DisplayRecords); // Save default to Session
		}

		// Load Sorting Order
		if ($this->Command != "json")
			$this->loadSortOrder();

		// Load search default if no existing search criteria
		if (!$this->checkSearchParms()) {

			// Load basic search from default
			$this->BasicSearch->loadDefault();
			if ($this->BasicSearch->Keyword != "")
				$srchBasic = $this->basicSearchWhere();

			// Load advanced search from default
			if ($this->loadAdvancedSearchDefault()) {
				$srchAdvanced = $this->advancedSearchWhere();
			}
		}

		// Restore search settings from Session
		if ($SearchError == "")
			$this->loadAdvancedSearch();

		// Build search criteria
		AddFilter($this->SearchWhere, $srchAdvanced);
		AddFilter($this->SearchWhere, $srchBasic);

		// Call Recordset_Searching event
		$this->Recordset_Searching($this->SearchWhere);

		// Save search criteria
		if ($this->Command == "search" && !$this->RestoreSearch) {
			$this->setSearchWhere($this->SearchWhere); // Save to Session
			$this->StartRecord = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRecord);
		} elseif ($this->Command != "json") {
			$this->SearchWhere = $this->getSearchWhere();
		}

		// Build filter
		$filter = "";
		if (!$Security->canList())
			$filter = "(0=1)"; // Filter all records
		AddFilter($filter, $this->DbDetailFilter);
		AddFilter($filter, $this->SearchWhere);

		// Set up filter
		if ($this->Command == "json") {
			$this->UseSessionForListSql = FALSE; // Do not use session for ListSQL
			$this->CurrentFilter = $filter;
		} else {
			$this->setSessionWhere($filter);
			$this->CurrentFilter = "";
		}

		// Export data only
		if (!$this->CustomExport && in_array($this->Export, array_keys(Config("EXPORT_CLASSES")))) {
			$this->exportData();
			$this->terminate();
		}
		if ($this->isGridAdd()) {
			$this->CurrentFilter = "0=1";
			$this->StartRecord = 1;
			$this->DisplayRecords = $this->GridAddRowCount;
			$this->TotalRecords = $this->DisplayRecords;
			$this->StopRecord = $this->DisplayRecords;
		} else {
			$selectLimit = $this->UseSelectLimit;
			if ($selectLimit) {
				$this->TotalRecords = $this->listRecordCount();
			} else {
				if ($this->Recordset = $this->loadRecordset())
					$this->TotalRecords = $this->Recordset->RecordCount();
			}
			$this->StartRecord = 1;
			if ($this->DisplayRecords <= 0 || ($this->isExport() && $this->ExportAll)) // Display all records
				$this->DisplayRecords = $this->TotalRecords;
			if (!($this->isExport() && $this->ExportAll)) // Set up start record position
				$this->setupStartRecord();
			if ($selectLimit)
				$this->Recordset = $this->loadRecordset($this->StartRecord - 1, $this->DisplayRecords);

			// Set no record found message
			if (!$this->CurrentAction && $this->TotalRecords == 0) {
				if (!$Security->canList())
					$this->setWarningMessage(DeniedMessage());
				if ($this->SearchWhere == "0=101")
					$this->setWarningMessage($Language->phrase("EnterSearchCriteria"));
				else
					$this->setWarningMessage($Language->phrase("NoRecord"));
			}
		}

		// Search options
		$this->setupSearchOptions();

		// Set up search panel class
		if ($this->SearchWhere != "")
			AppendClass($this->SearchPanelClass, "show");

		// Normal return
		if (IsApi()) {
			$rows = $this->getRecordsFromRecordset($this->Recordset);
			$this->Recordset->close();
			WriteJson(["success" => TRUE, $this->TableVar => $rows, "totalRecordCount" => $this->TotalRecords]);
			$this->terminate(TRUE);
		}

		// Set up pager
		$this->Pager = new PrevNextPager($this->StartRecord, $this->getRecordsPerPage(), $this->TotalRecords, $this->PageSizes, $this->RecordRange, $this->AutoHidePager, $this->AutoHidePageSizeSelector);
	}

	// Set up number of records displayed per page
	protected function setupDisplayRecords()
	{
		$wrk = Get(Config("TABLE_REC_PER_PAGE"), "");
		if ($wrk != "") {
			if (is_numeric($wrk)) {
				$this->DisplayRecords = (int)$wrk;
			} else {
				if (SameText($wrk, "all")) { // Display all records
					$this->DisplayRecords = -1;
				} else {
					$this->DisplayRecords = 20; // Non-numeric, load default
				}
			}
			$this->setRecordsPerPage($this->DisplayRecords); // Save to Session

			// Reset start position
			$this->StartRecord = 1;
			$this->setStartRecordNumber($this->StartRecord);
		}
	}

	// Build filter for all keys
	protected function buildKeyFilter()
	{
		global $CurrentForm;
		$wrkFilter = "";

		// Update row index and get row key
		$rowindex = 1;
		$CurrentForm->Index = $rowindex;
		$thisKey = strval($CurrentForm->getValue($this->FormKeyName));
		while ($thisKey != "") {
			if ($this->setupKeyValues($thisKey)) {
				$filter = $this->getRecordFilter();
				if ($wrkFilter != "")
					$wrkFilter .= " OR ";
				$wrkFilter .= $filter;
			} else {
				$wrkFilter = "0=1";
				break;
			}

			// Update row index and get row key
			$rowindex++; // Next row
			$CurrentForm->Index = $rowindex;
			$thisKey = strval($CurrentForm->getValue($this->FormKeyName));
		}
		return $wrkFilter;
	}

	// Set up key values
	protected function setupKeyValues($key)
	{
		$arKeyFlds = explode(Config("COMPOSITE_KEY_SEPARATOR"), $key);
		if (count($arKeyFlds) >= 1) {
			$this->Nim->setOldValue($arKeyFlds[0]);
		}
		return TRUE;
	}

	// Get list of filters
	public function getFilterList()
	{
		global $UserProfile;

		// Initialize
		$filterList = "";
		$savedFilterList = "";
		$filterList = Concat($filterList, $this->Nim->AdvancedSearch->toJson(), ","); // Field Nim
		$filterList = Concat($filterList, $this->Nama_Mhs->AdvancedSearch->toJson(), ","); // Field Nama_Mhs
		$filterList = Concat($filterList, $this->Kode_jp->AdvancedSearch->toJson(), ","); // Field Kode_jp
		$filterList = Concat($filterList, $this->Tmp_Lahir->AdvancedSearch->toJson(), ","); // Field Tmp_Lahir
		$filterList = Concat($filterList, $this->Tgl_Lahir->AdvancedSearch->toJson(), ","); // Field Tgl_Lahir
		$filterList = Concat($filterList, $this->Jenis_Kel->AdvancedSearch->toJson(), ","); // Field Jenis_Kel
		$filterList = Concat($filterList, $this->Gol_darah->AdvancedSearch->toJson(), ","); // Field Gol_darah
		$filterList = Concat($filterList, $this->Agama_Mhs->AdvancedSearch->toJson(), ","); // Field Agama_Mhs
		$filterList = Concat($filterList, $this->Alamat_Mhs->AdvancedSearch->toJson(), ","); // Field Alamat_Mhs
		$filterList = Concat($filterList, $this->rt->AdvancedSearch->toJson(), ","); // Field rt
		$filterList = Concat($filterList, $this->rw->AdvancedSearch->toJson(), ","); // Field rw
		$filterList = Concat($filterList, $this->Kelurahan->AdvancedSearch->toJson(), ","); // Field Kelurahan
		$filterList = Concat($filterList, $this->Kecamatan->AdvancedSearch->toJson(), ","); // Field Kecamatan
		$filterList = Concat($filterList, $this->Kota_Mhs->AdvancedSearch->toJson(), ","); // Field Kota_Mhs
		$filterList = Concat($filterList, $this->Provinsi_mhs->AdvancedSearch->toJson(), ","); // Field Provinsi_mhs
		$filterList = Concat($filterList, $this->Kodepos_Mhs->AdvancedSearch->toJson(), ","); // Field Kodepos_Mhs
		$filterList = Concat($filterList, $this->Tlp_Mhs->AdvancedSearch->toJson(), ","); // Field Tlp_Mhs
		$filterList = Concat($filterList, $this->TlpRumah->AdvancedSearch->toJson(), ","); // Field TlpRumah
		$filterList = Concat($filterList, $this->_Email->AdvancedSearch->toJson(), ","); // Field Email
		$filterList = Concat($filterList, $this->Status_Akd->AdvancedSearch->toJson(), ","); // Field Status_Akd
		$filterList = Concat($filterList, $this->ThMasuk->AdvancedSearch->toJson(), ","); // Field ThMasuk
		$filterList = Concat($filterList, $this->tglmasuk->AdvancedSearch->toJson(), ","); // Field tglmasuk
		$filterList = Concat($filterList, $this->Status_Masuk->AdvancedSearch->toJson(), ","); // Field Status_Masuk
		$filterList = Concat($filterList, $this->Sem_Masuk->AdvancedSearch->toJson(), ","); // Field Sem_Masuk
		$filterList = Concat($filterList, $this->TaMasuk->AdvancedSearch->toJson(), ","); // Field TaMasuk
		$filterList = Concat($filterList, $this->PerMasuk->AdvancedSearch->toJson(), ","); // Field PerMasuk
		$filterList = Concat($filterList, $this->Pendidikan_Akhir->AdvancedSearch->toJson(), ","); // Field Pendidikan_Akhir
		$filterList = Concat($filterList, $this->Jurusan->AdvancedSearch->toJson(), ","); // Field Jurusan
		$filterList = Concat($filterList, $this->Thn_Selesai->AdvancedSearch->toJson(), ","); // Field Thn_Selesai
		$filterList = Concat($filterList, $this->Kota_Pdkk->AdvancedSearch->toJson(), ","); // Field Kota_Pdkk
		$filterList = Concat($filterList, $this->propinsi->AdvancedSearch->toJson(), ","); // Field propinsi
		$filterList = Concat($filterList, $this->NIMASAL->AdvancedSearch->toJson(), ","); // Field NIMASAL
		$filterList = Concat($filterList, $this->KPTSASAL->AdvancedSearch->toJson(), ","); // Field KPTSASAL
		$filterList = Concat($filterList, $this->JENASAL->AdvancedSearch->toJson(), ","); // Field JENASAL
		$filterList = Concat($filterList, $this->PSASAL->AdvancedSearch->toJson(), ","); // Field PSASAL
		$filterList = Concat($filterList, $this->TSKSDIAKUI->AdvancedSearch->toJson(), ","); // Field TSKSDIAKUI
		$filterList = Concat($filterList, $this->NamaSekolahAsal->AdvancedSearch->toJson(), ","); // Field NamaSekolahAsal
		$filterList = Concat($filterList, $this->AlamatSekolahAsal->AdvancedSearch->toJson(), ","); // Field AlamatSekolahAsal
		$filterList = Concat($filterList, $this->Status->AdvancedSearch->toJson(), ","); // Field Status
		$filterList = Concat($filterList, $this->Password->AdvancedSearch->toJson(), ","); // Field Password
		$filterList = Concat($filterList, $this->Gelombang->AdvancedSearch->toJson(), ","); // Field Gelombang
		$filterList = Concat($filterList, $this->JalurMasuk->AdvancedSearch->toJson(), ","); // Field JalurMasuk
		$filterList = Concat($filterList, $this->Konsentrasi->AdvancedSearch->toJson(), ","); // Field Konsentrasi
		$filterList = Concat($filterList, $this->NIK->AdvancedSearch->toJson(), ","); // Field NIK
		$filterList = Concat($filterList, $this->NamaIbu->AdvancedSearch->toJson(), ","); // Field NamaIbu
		$filterList = Concat($filterList, $this->BekerjaDi->AdvancedSearch->toJson(), ","); // Field BekerjaDi
		$filterList = Concat($filterList, $this->Lama->AdvancedSearch->toJson(), ","); // Field Lama
		$filterList = Concat($filterList, $this->AlamatPerusahaan->AdvancedSearch->toJson(), ","); // Field AlamatPerusahaan
		$filterList = Concat($filterList, $this->TlpPerusahaan->AdvancedSearch->toJson(), ","); // Field TlpPerusahaan
		$filterList = Concat($filterList, $this->Posisi->AdvancedSearch->toJson(), ","); // Field Posisi
		$filterList = Concat($filterList, $this->Departemen->AdvancedSearch->toJson(), ","); // Field Departemen
		$filterList = Concat($filterList, $this->IdUser->AdvancedSearch->toJson(), ","); // Field IdUser
		$filterList = Concat($filterList, $this->TempID->AdvancedSearch->toJson(), ","); // Field TempID
		$filterList = Concat($filterList, $this->xphoto->AdvancedSearch->toJson(), ","); // Field xphoto
		$filterList = Concat($filterList, $this->profile->AdvancedSearch->toJson(), ","); // Field profile
		$filterList = Concat($filterList, $this->id_agama->AdvancedSearch->toJson(), ","); // Field id_agama
		$filterList = Concat($filterList, $this->id_negara->AdvancedSearch->toJson(), ","); // Field id_negara
		$filterList = Concat($filterList, $this->id_wilayah->AdvancedSearch->toJson(), ","); // Field id_wilayah
		$filterList = Concat($filterList, $this->id_jenis_tinggal->AdvancedSearch->toJson(), ","); // Field id_jenis_tinggal
		$filterList = Concat($filterList, $this->id_alat_transportasi->AdvancedSearch->toJson(), ","); // Field id_alat_transportasi
		$filterList = Concat($filterList, $this->no_kps->AdvancedSearch->toJson(), ","); // Field no_kps
		$filterList = Concat($filterList, $this->penerima_kps->AdvancedSearch->toJson(), ","); // Field penerima_kps
		$filterList = Concat($filterList, $this->id_kebutuhan_khusus_mahasiswa->AdvancedSearch->toJson(), ","); // Field id_kebutuhan_khusus_mahasiswa
		$filterList = Concat($filterList, $this->nisn->AdvancedSearch->toJson(), ","); // Field nisn
		$filterList = Concat($filterList, $this->iddesa->AdvancedSearch->toJson(), ","); // Field iddesa
		$filterList = Concat($filterList, $this->MulaiKerja->AdvancedSearch->toJson(), ","); // Field MulaiKerja
		$filterList = Concat($filterList, $this->IdKlsKerjasama->AdvancedSearch->toJson(), ","); // Field IdKlsKerjasama
		$filterList = Concat($filterList, $this->IDBeasiswa->AdvancedSearch->toJson(), ","); // Field IDBeasiswa
		$filterList = Concat($filterList, $this->tglKonversi->AdvancedSearch->toJson(), ","); // Field tglKonversi
		$filterList = Concat($filterList, $this->NoSuratKonversi->AdvancedSearch->toJson(), ","); // Field NoSuratKonversi
		$filterList = Concat($filterList, $this->Nopen->AdvancedSearch->toJson(), ","); // Field Nopen
		$filterList = Concat($filterList, $this->id_feedmhs->AdvancedSearch->toJson(), ","); // Field id_feedmhs
		if ($this->BasicSearch->Keyword != "") {
			$wrk = "\"" . Config("TABLE_BASIC_SEARCH") . "\":\"" . JsEncode($this->BasicSearch->Keyword) . "\",\"" . Config("TABLE_BASIC_SEARCH_TYPE") . "\":\"" . JsEncode($this->BasicSearch->Type) . "\"";
			$filterList = Concat($filterList, $wrk, ",");
		}

		// Return filter list in JSON
		if ($filterList != "")
			$filterList = "\"data\":{" . $filterList . "}";
		if ($savedFilterList != "")
			$filterList = Concat($filterList, "\"filters\":" . $savedFilterList, ",");
		return ($filterList != "") ? "{" . $filterList . "}" : "null";
	}

	// Process filter list
	protected function processFilterList()
	{
		global $UserProfile;
		if (Post("ajax") == "savefilters") { // Save filter request (Ajax)
			$filters = Post("filters");
			$UserProfile->setSearchFilters(CurrentUserName(), "ftblMHSlistsrch", $filters);
			WriteJson([["success" => TRUE]]); // Success
			return TRUE;
		} elseif (Post("cmd") == "resetfilter") {
			$this->restoreFilterList();
		}
		return FALSE;
	}

	// Restore list of filters
	protected function restoreFilterList()
	{

		// Return if not reset filter
		if (Post("cmd") !== "resetfilter")
			return FALSE;
		$filter = json_decode(Post("filter"), TRUE);
		$this->Command = "search";

		// Field Nim
		$this->Nim->AdvancedSearch->SearchValue = @$filter["x_Nim"];
		$this->Nim->AdvancedSearch->SearchOperator = @$filter["z_Nim"];
		$this->Nim->AdvancedSearch->SearchCondition = @$filter["v_Nim"];
		$this->Nim->AdvancedSearch->SearchValue2 = @$filter["y_Nim"];
		$this->Nim->AdvancedSearch->SearchOperator2 = @$filter["w_Nim"];
		$this->Nim->AdvancedSearch->save();

		// Field Nama_Mhs
		$this->Nama_Mhs->AdvancedSearch->SearchValue = @$filter["x_Nama_Mhs"];
		$this->Nama_Mhs->AdvancedSearch->SearchOperator = @$filter["z_Nama_Mhs"];
		$this->Nama_Mhs->AdvancedSearch->SearchCondition = @$filter["v_Nama_Mhs"];
		$this->Nama_Mhs->AdvancedSearch->SearchValue2 = @$filter["y_Nama_Mhs"];
		$this->Nama_Mhs->AdvancedSearch->SearchOperator2 = @$filter["w_Nama_Mhs"];
		$this->Nama_Mhs->AdvancedSearch->save();

		// Field Kode_jp
		$this->Kode_jp->AdvancedSearch->SearchValue = @$filter["x_Kode_jp"];
		$this->Kode_jp->AdvancedSearch->SearchOperator = @$filter["z_Kode_jp"];
		$this->Kode_jp->AdvancedSearch->SearchCondition = @$filter["v_Kode_jp"];
		$this->Kode_jp->AdvancedSearch->SearchValue2 = @$filter["y_Kode_jp"];
		$this->Kode_jp->AdvancedSearch->SearchOperator2 = @$filter["w_Kode_jp"];
		$this->Kode_jp->AdvancedSearch->save();

		// Field Tmp_Lahir
		$this->Tmp_Lahir->AdvancedSearch->SearchValue = @$filter["x_Tmp_Lahir"];
		$this->Tmp_Lahir->AdvancedSearch->SearchOperator = @$filter["z_Tmp_Lahir"];
		$this->Tmp_Lahir->AdvancedSearch->SearchCondition = @$filter["v_Tmp_Lahir"];
		$this->Tmp_Lahir->AdvancedSearch->SearchValue2 = @$filter["y_Tmp_Lahir"];
		$this->Tmp_Lahir->AdvancedSearch->SearchOperator2 = @$filter["w_Tmp_Lahir"];
		$this->Tmp_Lahir->AdvancedSearch->save();

		// Field Tgl_Lahir
		$this->Tgl_Lahir->AdvancedSearch->SearchValue = @$filter["x_Tgl_Lahir"];
		$this->Tgl_Lahir->AdvancedSearch->SearchOperator = @$filter["z_Tgl_Lahir"];
		$this->Tgl_Lahir->AdvancedSearch->SearchCondition = @$filter["v_Tgl_Lahir"];
		$this->Tgl_Lahir->AdvancedSearch->SearchValue2 = @$filter["y_Tgl_Lahir"];
		$this->Tgl_Lahir->AdvancedSearch->SearchOperator2 = @$filter["w_Tgl_Lahir"];
		$this->Tgl_Lahir->AdvancedSearch->save();

		// Field Jenis_Kel
		$this->Jenis_Kel->AdvancedSearch->SearchValue = @$filter["x_Jenis_Kel"];
		$this->Jenis_Kel->AdvancedSearch->SearchOperator = @$filter["z_Jenis_Kel"];
		$this->Jenis_Kel->AdvancedSearch->SearchCondition = @$filter["v_Jenis_Kel"];
		$this->Jenis_Kel->AdvancedSearch->SearchValue2 = @$filter["y_Jenis_Kel"];
		$this->Jenis_Kel->AdvancedSearch->SearchOperator2 = @$filter["w_Jenis_Kel"];
		$this->Jenis_Kel->AdvancedSearch->save();

		// Field Gol_darah
		$this->Gol_darah->AdvancedSearch->SearchValue = @$filter["x_Gol_darah"];
		$this->Gol_darah->AdvancedSearch->SearchOperator = @$filter["z_Gol_darah"];
		$this->Gol_darah->AdvancedSearch->SearchCondition = @$filter["v_Gol_darah"];
		$this->Gol_darah->AdvancedSearch->SearchValue2 = @$filter["y_Gol_darah"];
		$this->Gol_darah->AdvancedSearch->SearchOperator2 = @$filter["w_Gol_darah"];
		$this->Gol_darah->AdvancedSearch->save();

		// Field Agama_Mhs
		$this->Agama_Mhs->AdvancedSearch->SearchValue = @$filter["x_Agama_Mhs"];
		$this->Agama_Mhs->AdvancedSearch->SearchOperator = @$filter["z_Agama_Mhs"];
		$this->Agama_Mhs->AdvancedSearch->SearchCondition = @$filter["v_Agama_Mhs"];
		$this->Agama_Mhs->AdvancedSearch->SearchValue2 = @$filter["y_Agama_Mhs"];
		$this->Agama_Mhs->AdvancedSearch->SearchOperator2 = @$filter["w_Agama_Mhs"];
		$this->Agama_Mhs->AdvancedSearch->save();

		// Field Alamat_Mhs
		$this->Alamat_Mhs->AdvancedSearch->SearchValue = @$filter["x_Alamat_Mhs"];
		$this->Alamat_Mhs->AdvancedSearch->SearchOperator = @$filter["z_Alamat_Mhs"];
		$this->Alamat_Mhs->AdvancedSearch->SearchCondition = @$filter["v_Alamat_Mhs"];
		$this->Alamat_Mhs->AdvancedSearch->SearchValue2 = @$filter["y_Alamat_Mhs"];
		$this->Alamat_Mhs->AdvancedSearch->SearchOperator2 = @$filter["w_Alamat_Mhs"];
		$this->Alamat_Mhs->AdvancedSearch->save();

		// Field rt
		$this->rt->AdvancedSearch->SearchValue = @$filter["x_rt"];
		$this->rt->AdvancedSearch->SearchOperator = @$filter["z_rt"];
		$this->rt->AdvancedSearch->SearchCondition = @$filter["v_rt"];
		$this->rt->AdvancedSearch->SearchValue2 = @$filter["y_rt"];
		$this->rt->AdvancedSearch->SearchOperator2 = @$filter["w_rt"];
		$this->rt->AdvancedSearch->save();

		// Field rw
		$this->rw->AdvancedSearch->SearchValue = @$filter["x_rw"];
		$this->rw->AdvancedSearch->SearchOperator = @$filter["z_rw"];
		$this->rw->AdvancedSearch->SearchCondition = @$filter["v_rw"];
		$this->rw->AdvancedSearch->SearchValue2 = @$filter["y_rw"];
		$this->rw->AdvancedSearch->SearchOperator2 = @$filter["w_rw"];
		$this->rw->AdvancedSearch->save();

		// Field Kelurahan
		$this->Kelurahan->AdvancedSearch->SearchValue = @$filter["x_Kelurahan"];
		$this->Kelurahan->AdvancedSearch->SearchOperator = @$filter["z_Kelurahan"];
		$this->Kelurahan->AdvancedSearch->SearchCondition = @$filter["v_Kelurahan"];
		$this->Kelurahan->AdvancedSearch->SearchValue2 = @$filter["y_Kelurahan"];
		$this->Kelurahan->AdvancedSearch->SearchOperator2 = @$filter["w_Kelurahan"];
		$this->Kelurahan->AdvancedSearch->save();

		// Field Kecamatan
		$this->Kecamatan->AdvancedSearch->SearchValue = @$filter["x_Kecamatan"];
		$this->Kecamatan->AdvancedSearch->SearchOperator = @$filter["z_Kecamatan"];
		$this->Kecamatan->AdvancedSearch->SearchCondition = @$filter["v_Kecamatan"];
		$this->Kecamatan->AdvancedSearch->SearchValue2 = @$filter["y_Kecamatan"];
		$this->Kecamatan->AdvancedSearch->SearchOperator2 = @$filter["w_Kecamatan"];
		$this->Kecamatan->AdvancedSearch->save();

		// Field Kota_Mhs
		$this->Kota_Mhs->AdvancedSearch->SearchValue = @$filter["x_Kota_Mhs"];
		$this->Kota_Mhs->AdvancedSearch->SearchOperator = @$filter["z_Kota_Mhs"];
		$this->Kota_Mhs->AdvancedSearch->SearchCondition = @$filter["v_Kota_Mhs"];
		$this->Kota_Mhs->AdvancedSearch->SearchValue2 = @$filter["y_Kota_Mhs"];
		$this->Kota_Mhs->AdvancedSearch->SearchOperator2 = @$filter["w_Kota_Mhs"];
		$this->Kota_Mhs->AdvancedSearch->save();

		// Field Provinsi_mhs
		$this->Provinsi_mhs->AdvancedSearch->SearchValue = @$filter["x_Provinsi_mhs"];
		$this->Provinsi_mhs->AdvancedSearch->SearchOperator = @$filter["z_Provinsi_mhs"];
		$this->Provinsi_mhs->AdvancedSearch->SearchCondition = @$filter["v_Provinsi_mhs"];
		$this->Provinsi_mhs->AdvancedSearch->SearchValue2 = @$filter["y_Provinsi_mhs"];
		$this->Provinsi_mhs->AdvancedSearch->SearchOperator2 = @$filter["w_Provinsi_mhs"];
		$this->Provinsi_mhs->AdvancedSearch->save();

		// Field Kodepos_Mhs
		$this->Kodepos_Mhs->AdvancedSearch->SearchValue = @$filter["x_Kodepos_Mhs"];
		$this->Kodepos_Mhs->AdvancedSearch->SearchOperator = @$filter["z_Kodepos_Mhs"];
		$this->Kodepos_Mhs->AdvancedSearch->SearchCondition = @$filter["v_Kodepos_Mhs"];
		$this->Kodepos_Mhs->AdvancedSearch->SearchValue2 = @$filter["y_Kodepos_Mhs"];
		$this->Kodepos_Mhs->AdvancedSearch->SearchOperator2 = @$filter["w_Kodepos_Mhs"];
		$this->Kodepos_Mhs->AdvancedSearch->save();

		// Field Tlp_Mhs
		$this->Tlp_Mhs->AdvancedSearch->SearchValue = @$filter["x_Tlp_Mhs"];
		$this->Tlp_Mhs->AdvancedSearch->SearchOperator = @$filter["z_Tlp_Mhs"];
		$this->Tlp_Mhs->AdvancedSearch->SearchCondition = @$filter["v_Tlp_Mhs"];
		$this->Tlp_Mhs->AdvancedSearch->SearchValue2 = @$filter["y_Tlp_Mhs"];
		$this->Tlp_Mhs->AdvancedSearch->SearchOperator2 = @$filter["w_Tlp_Mhs"];
		$this->Tlp_Mhs->AdvancedSearch->save();

		// Field TlpRumah
		$this->TlpRumah->AdvancedSearch->SearchValue = @$filter["x_TlpRumah"];
		$this->TlpRumah->AdvancedSearch->SearchOperator = @$filter["z_TlpRumah"];
		$this->TlpRumah->AdvancedSearch->SearchCondition = @$filter["v_TlpRumah"];
		$this->TlpRumah->AdvancedSearch->SearchValue2 = @$filter["y_TlpRumah"];
		$this->TlpRumah->AdvancedSearch->SearchOperator2 = @$filter["w_TlpRumah"];
		$this->TlpRumah->AdvancedSearch->save();

		// Field Email
		$this->_Email->AdvancedSearch->SearchValue = @$filter["x__Email"];
		$this->_Email->AdvancedSearch->SearchOperator = @$filter["z__Email"];
		$this->_Email->AdvancedSearch->SearchCondition = @$filter["v__Email"];
		$this->_Email->AdvancedSearch->SearchValue2 = @$filter["y__Email"];
		$this->_Email->AdvancedSearch->SearchOperator2 = @$filter["w__Email"];
		$this->_Email->AdvancedSearch->save();

		// Field Status_Akd
		$this->Status_Akd->AdvancedSearch->SearchValue = @$filter["x_Status_Akd"];
		$this->Status_Akd->AdvancedSearch->SearchOperator = @$filter["z_Status_Akd"];
		$this->Status_Akd->AdvancedSearch->SearchCondition = @$filter["v_Status_Akd"];
		$this->Status_Akd->AdvancedSearch->SearchValue2 = @$filter["y_Status_Akd"];
		$this->Status_Akd->AdvancedSearch->SearchOperator2 = @$filter["w_Status_Akd"];
		$this->Status_Akd->AdvancedSearch->save();

		// Field ThMasuk
		$this->ThMasuk->AdvancedSearch->SearchValue = @$filter["x_ThMasuk"];
		$this->ThMasuk->AdvancedSearch->SearchOperator = @$filter["z_ThMasuk"];
		$this->ThMasuk->AdvancedSearch->SearchCondition = @$filter["v_ThMasuk"];
		$this->ThMasuk->AdvancedSearch->SearchValue2 = @$filter["y_ThMasuk"];
		$this->ThMasuk->AdvancedSearch->SearchOperator2 = @$filter["w_ThMasuk"];
		$this->ThMasuk->AdvancedSearch->save();

		// Field tglmasuk
		$this->tglmasuk->AdvancedSearch->SearchValue = @$filter["x_tglmasuk"];
		$this->tglmasuk->AdvancedSearch->SearchOperator = @$filter["z_tglmasuk"];
		$this->tglmasuk->AdvancedSearch->SearchCondition = @$filter["v_tglmasuk"];
		$this->tglmasuk->AdvancedSearch->SearchValue2 = @$filter["y_tglmasuk"];
		$this->tglmasuk->AdvancedSearch->SearchOperator2 = @$filter["w_tglmasuk"];
		$this->tglmasuk->AdvancedSearch->save();

		// Field Status_Masuk
		$this->Status_Masuk->AdvancedSearch->SearchValue = @$filter["x_Status_Masuk"];
		$this->Status_Masuk->AdvancedSearch->SearchOperator = @$filter["z_Status_Masuk"];
		$this->Status_Masuk->AdvancedSearch->SearchCondition = @$filter["v_Status_Masuk"];
		$this->Status_Masuk->AdvancedSearch->SearchValue2 = @$filter["y_Status_Masuk"];
		$this->Status_Masuk->AdvancedSearch->SearchOperator2 = @$filter["w_Status_Masuk"];
		$this->Status_Masuk->AdvancedSearch->save();

		// Field Sem_Masuk
		$this->Sem_Masuk->AdvancedSearch->SearchValue = @$filter["x_Sem_Masuk"];
		$this->Sem_Masuk->AdvancedSearch->SearchOperator = @$filter["z_Sem_Masuk"];
		$this->Sem_Masuk->AdvancedSearch->SearchCondition = @$filter["v_Sem_Masuk"];
		$this->Sem_Masuk->AdvancedSearch->SearchValue2 = @$filter["y_Sem_Masuk"];
		$this->Sem_Masuk->AdvancedSearch->SearchOperator2 = @$filter["w_Sem_Masuk"];
		$this->Sem_Masuk->AdvancedSearch->save();

		// Field TaMasuk
		$this->TaMasuk->AdvancedSearch->SearchValue = @$filter["x_TaMasuk"];
		$this->TaMasuk->AdvancedSearch->SearchOperator = @$filter["z_TaMasuk"];
		$this->TaMasuk->AdvancedSearch->SearchCondition = @$filter["v_TaMasuk"];
		$this->TaMasuk->AdvancedSearch->SearchValue2 = @$filter["y_TaMasuk"];
		$this->TaMasuk->AdvancedSearch->SearchOperator2 = @$filter["w_TaMasuk"];
		$this->TaMasuk->AdvancedSearch->save();

		// Field PerMasuk
		$this->PerMasuk->AdvancedSearch->SearchValue = @$filter["x_PerMasuk"];
		$this->PerMasuk->AdvancedSearch->SearchOperator = @$filter["z_PerMasuk"];
		$this->PerMasuk->AdvancedSearch->SearchCondition = @$filter["v_PerMasuk"];
		$this->PerMasuk->AdvancedSearch->SearchValue2 = @$filter["y_PerMasuk"];
		$this->PerMasuk->AdvancedSearch->SearchOperator2 = @$filter["w_PerMasuk"];
		$this->PerMasuk->AdvancedSearch->save();

		// Field Pendidikan_Akhir
		$this->Pendidikan_Akhir->AdvancedSearch->SearchValue = @$filter["x_Pendidikan_Akhir"];
		$this->Pendidikan_Akhir->AdvancedSearch->SearchOperator = @$filter["z_Pendidikan_Akhir"];
		$this->Pendidikan_Akhir->AdvancedSearch->SearchCondition = @$filter["v_Pendidikan_Akhir"];
		$this->Pendidikan_Akhir->AdvancedSearch->SearchValue2 = @$filter["y_Pendidikan_Akhir"];
		$this->Pendidikan_Akhir->AdvancedSearch->SearchOperator2 = @$filter["w_Pendidikan_Akhir"];
		$this->Pendidikan_Akhir->AdvancedSearch->save();

		// Field Jurusan
		$this->Jurusan->AdvancedSearch->SearchValue = @$filter["x_Jurusan"];
		$this->Jurusan->AdvancedSearch->SearchOperator = @$filter["z_Jurusan"];
		$this->Jurusan->AdvancedSearch->SearchCondition = @$filter["v_Jurusan"];
		$this->Jurusan->AdvancedSearch->SearchValue2 = @$filter["y_Jurusan"];
		$this->Jurusan->AdvancedSearch->SearchOperator2 = @$filter["w_Jurusan"];
		$this->Jurusan->AdvancedSearch->save();

		// Field Thn_Selesai
		$this->Thn_Selesai->AdvancedSearch->SearchValue = @$filter["x_Thn_Selesai"];
		$this->Thn_Selesai->AdvancedSearch->SearchOperator = @$filter["z_Thn_Selesai"];
		$this->Thn_Selesai->AdvancedSearch->SearchCondition = @$filter["v_Thn_Selesai"];
		$this->Thn_Selesai->AdvancedSearch->SearchValue2 = @$filter["y_Thn_Selesai"];
		$this->Thn_Selesai->AdvancedSearch->SearchOperator2 = @$filter["w_Thn_Selesai"];
		$this->Thn_Selesai->AdvancedSearch->save();

		// Field Kota_Pdkk
		$this->Kota_Pdkk->AdvancedSearch->SearchValue = @$filter["x_Kota_Pdkk"];
		$this->Kota_Pdkk->AdvancedSearch->SearchOperator = @$filter["z_Kota_Pdkk"];
		$this->Kota_Pdkk->AdvancedSearch->SearchCondition = @$filter["v_Kota_Pdkk"];
		$this->Kota_Pdkk->AdvancedSearch->SearchValue2 = @$filter["y_Kota_Pdkk"];
		$this->Kota_Pdkk->AdvancedSearch->SearchOperator2 = @$filter["w_Kota_Pdkk"];
		$this->Kota_Pdkk->AdvancedSearch->save();

		// Field propinsi
		$this->propinsi->AdvancedSearch->SearchValue = @$filter["x_propinsi"];
		$this->propinsi->AdvancedSearch->SearchOperator = @$filter["z_propinsi"];
		$this->propinsi->AdvancedSearch->SearchCondition = @$filter["v_propinsi"];
		$this->propinsi->AdvancedSearch->SearchValue2 = @$filter["y_propinsi"];
		$this->propinsi->AdvancedSearch->SearchOperator2 = @$filter["w_propinsi"];
		$this->propinsi->AdvancedSearch->save();

		// Field NIMASAL
		$this->NIMASAL->AdvancedSearch->SearchValue = @$filter["x_NIMASAL"];
		$this->NIMASAL->AdvancedSearch->SearchOperator = @$filter["z_NIMASAL"];
		$this->NIMASAL->AdvancedSearch->SearchCondition = @$filter["v_NIMASAL"];
		$this->NIMASAL->AdvancedSearch->SearchValue2 = @$filter["y_NIMASAL"];
		$this->NIMASAL->AdvancedSearch->SearchOperator2 = @$filter["w_NIMASAL"];
		$this->NIMASAL->AdvancedSearch->save();

		// Field KPTSASAL
		$this->KPTSASAL->AdvancedSearch->SearchValue = @$filter["x_KPTSASAL"];
		$this->KPTSASAL->AdvancedSearch->SearchOperator = @$filter["z_KPTSASAL"];
		$this->KPTSASAL->AdvancedSearch->SearchCondition = @$filter["v_KPTSASAL"];
		$this->KPTSASAL->AdvancedSearch->SearchValue2 = @$filter["y_KPTSASAL"];
		$this->KPTSASAL->AdvancedSearch->SearchOperator2 = @$filter["w_KPTSASAL"];
		$this->KPTSASAL->AdvancedSearch->save();

		// Field JENASAL
		$this->JENASAL->AdvancedSearch->SearchValue = @$filter["x_JENASAL"];
		$this->JENASAL->AdvancedSearch->SearchOperator = @$filter["z_JENASAL"];
		$this->JENASAL->AdvancedSearch->SearchCondition = @$filter["v_JENASAL"];
		$this->JENASAL->AdvancedSearch->SearchValue2 = @$filter["y_JENASAL"];
		$this->JENASAL->AdvancedSearch->SearchOperator2 = @$filter["w_JENASAL"];
		$this->JENASAL->AdvancedSearch->save();

		// Field PSASAL
		$this->PSASAL->AdvancedSearch->SearchValue = @$filter["x_PSASAL"];
		$this->PSASAL->AdvancedSearch->SearchOperator = @$filter["z_PSASAL"];
		$this->PSASAL->AdvancedSearch->SearchCondition = @$filter["v_PSASAL"];
		$this->PSASAL->AdvancedSearch->SearchValue2 = @$filter["y_PSASAL"];
		$this->PSASAL->AdvancedSearch->SearchOperator2 = @$filter["w_PSASAL"];
		$this->PSASAL->AdvancedSearch->save();

		// Field TSKSDIAKUI
		$this->TSKSDIAKUI->AdvancedSearch->SearchValue = @$filter["x_TSKSDIAKUI"];
		$this->TSKSDIAKUI->AdvancedSearch->SearchOperator = @$filter["z_TSKSDIAKUI"];
		$this->TSKSDIAKUI->AdvancedSearch->SearchCondition = @$filter["v_TSKSDIAKUI"];
		$this->TSKSDIAKUI->AdvancedSearch->SearchValue2 = @$filter["y_TSKSDIAKUI"];
		$this->TSKSDIAKUI->AdvancedSearch->SearchOperator2 = @$filter["w_TSKSDIAKUI"];
		$this->TSKSDIAKUI->AdvancedSearch->save();

		// Field NamaSekolahAsal
		$this->NamaSekolahAsal->AdvancedSearch->SearchValue = @$filter["x_NamaSekolahAsal"];
		$this->NamaSekolahAsal->AdvancedSearch->SearchOperator = @$filter["z_NamaSekolahAsal"];
		$this->NamaSekolahAsal->AdvancedSearch->SearchCondition = @$filter["v_NamaSekolahAsal"];
		$this->NamaSekolahAsal->AdvancedSearch->SearchValue2 = @$filter["y_NamaSekolahAsal"];
		$this->NamaSekolahAsal->AdvancedSearch->SearchOperator2 = @$filter["w_NamaSekolahAsal"];
		$this->NamaSekolahAsal->AdvancedSearch->save();

		// Field AlamatSekolahAsal
		$this->AlamatSekolahAsal->AdvancedSearch->SearchValue = @$filter["x_AlamatSekolahAsal"];
		$this->AlamatSekolahAsal->AdvancedSearch->SearchOperator = @$filter["z_AlamatSekolahAsal"];
		$this->AlamatSekolahAsal->AdvancedSearch->SearchCondition = @$filter["v_AlamatSekolahAsal"];
		$this->AlamatSekolahAsal->AdvancedSearch->SearchValue2 = @$filter["y_AlamatSekolahAsal"];
		$this->AlamatSekolahAsal->AdvancedSearch->SearchOperator2 = @$filter["w_AlamatSekolahAsal"];
		$this->AlamatSekolahAsal->AdvancedSearch->save();

		// Field Status
		$this->Status->AdvancedSearch->SearchValue = @$filter["x_Status"];
		$this->Status->AdvancedSearch->SearchOperator = @$filter["z_Status"];
		$this->Status->AdvancedSearch->SearchCondition = @$filter["v_Status"];
		$this->Status->AdvancedSearch->SearchValue2 = @$filter["y_Status"];
		$this->Status->AdvancedSearch->SearchOperator2 = @$filter["w_Status"];
		$this->Status->AdvancedSearch->save();

		// Field Password
		$this->Password->AdvancedSearch->SearchValue = @$filter["x_Password"];
		$this->Password->AdvancedSearch->SearchOperator = @$filter["z_Password"];
		$this->Password->AdvancedSearch->SearchCondition = @$filter["v_Password"];
		$this->Password->AdvancedSearch->SearchValue2 = @$filter["y_Password"];
		$this->Password->AdvancedSearch->SearchOperator2 = @$filter["w_Password"];
		$this->Password->AdvancedSearch->save();

		// Field Gelombang
		$this->Gelombang->AdvancedSearch->SearchValue = @$filter["x_Gelombang"];
		$this->Gelombang->AdvancedSearch->SearchOperator = @$filter["z_Gelombang"];
		$this->Gelombang->AdvancedSearch->SearchCondition = @$filter["v_Gelombang"];
		$this->Gelombang->AdvancedSearch->SearchValue2 = @$filter["y_Gelombang"];
		$this->Gelombang->AdvancedSearch->SearchOperator2 = @$filter["w_Gelombang"];
		$this->Gelombang->AdvancedSearch->save();

		// Field JalurMasuk
		$this->JalurMasuk->AdvancedSearch->SearchValue = @$filter["x_JalurMasuk"];
		$this->JalurMasuk->AdvancedSearch->SearchOperator = @$filter["z_JalurMasuk"];
		$this->JalurMasuk->AdvancedSearch->SearchCondition = @$filter["v_JalurMasuk"];
		$this->JalurMasuk->AdvancedSearch->SearchValue2 = @$filter["y_JalurMasuk"];
		$this->JalurMasuk->AdvancedSearch->SearchOperator2 = @$filter["w_JalurMasuk"];
		$this->JalurMasuk->AdvancedSearch->save();

		// Field Konsentrasi
		$this->Konsentrasi->AdvancedSearch->SearchValue = @$filter["x_Konsentrasi"];
		$this->Konsentrasi->AdvancedSearch->SearchOperator = @$filter["z_Konsentrasi"];
		$this->Konsentrasi->AdvancedSearch->SearchCondition = @$filter["v_Konsentrasi"];
		$this->Konsentrasi->AdvancedSearch->SearchValue2 = @$filter["y_Konsentrasi"];
		$this->Konsentrasi->AdvancedSearch->SearchOperator2 = @$filter["w_Konsentrasi"];
		$this->Konsentrasi->AdvancedSearch->save();

		// Field NIK
		$this->NIK->AdvancedSearch->SearchValue = @$filter["x_NIK"];
		$this->NIK->AdvancedSearch->SearchOperator = @$filter["z_NIK"];
		$this->NIK->AdvancedSearch->SearchCondition = @$filter["v_NIK"];
		$this->NIK->AdvancedSearch->SearchValue2 = @$filter["y_NIK"];
		$this->NIK->AdvancedSearch->SearchOperator2 = @$filter["w_NIK"];
		$this->NIK->AdvancedSearch->save();

		// Field NamaIbu
		$this->NamaIbu->AdvancedSearch->SearchValue = @$filter["x_NamaIbu"];
		$this->NamaIbu->AdvancedSearch->SearchOperator = @$filter["z_NamaIbu"];
		$this->NamaIbu->AdvancedSearch->SearchCondition = @$filter["v_NamaIbu"];
		$this->NamaIbu->AdvancedSearch->SearchValue2 = @$filter["y_NamaIbu"];
		$this->NamaIbu->AdvancedSearch->SearchOperator2 = @$filter["w_NamaIbu"];
		$this->NamaIbu->AdvancedSearch->save();

		// Field BekerjaDi
		$this->BekerjaDi->AdvancedSearch->SearchValue = @$filter["x_BekerjaDi"];
		$this->BekerjaDi->AdvancedSearch->SearchOperator = @$filter["z_BekerjaDi"];
		$this->BekerjaDi->AdvancedSearch->SearchCondition = @$filter["v_BekerjaDi"];
		$this->BekerjaDi->AdvancedSearch->SearchValue2 = @$filter["y_BekerjaDi"];
		$this->BekerjaDi->AdvancedSearch->SearchOperator2 = @$filter["w_BekerjaDi"];
		$this->BekerjaDi->AdvancedSearch->save();

		// Field Lama
		$this->Lama->AdvancedSearch->SearchValue = @$filter["x_Lama"];
		$this->Lama->AdvancedSearch->SearchOperator = @$filter["z_Lama"];
		$this->Lama->AdvancedSearch->SearchCondition = @$filter["v_Lama"];
		$this->Lama->AdvancedSearch->SearchValue2 = @$filter["y_Lama"];
		$this->Lama->AdvancedSearch->SearchOperator2 = @$filter["w_Lama"];
		$this->Lama->AdvancedSearch->save();

		// Field AlamatPerusahaan
		$this->AlamatPerusahaan->AdvancedSearch->SearchValue = @$filter["x_AlamatPerusahaan"];
		$this->AlamatPerusahaan->AdvancedSearch->SearchOperator = @$filter["z_AlamatPerusahaan"];
		$this->AlamatPerusahaan->AdvancedSearch->SearchCondition = @$filter["v_AlamatPerusahaan"];
		$this->AlamatPerusahaan->AdvancedSearch->SearchValue2 = @$filter["y_AlamatPerusahaan"];
		$this->AlamatPerusahaan->AdvancedSearch->SearchOperator2 = @$filter["w_AlamatPerusahaan"];
		$this->AlamatPerusahaan->AdvancedSearch->save();

		// Field TlpPerusahaan
		$this->TlpPerusahaan->AdvancedSearch->SearchValue = @$filter["x_TlpPerusahaan"];
		$this->TlpPerusahaan->AdvancedSearch->SearchOperator = @$filter["z_TlpPerusahaan"];
		$this->TlpPerusahaan->AdvancedSearch->SearchCondition = @$filter["v_TlpPerusahaan"];
		$this->TlpPerusahaan->AdvancedSearch->SearchValue2 = @$filter["y_TlpPerusahaan"];
		$this->TlpPerusahaan->AdvancedSearch->SearchOperator2 = @$filter["w_TlpPerusahaan"];
		$this->TlpPerusahaan->AdvancedSearch->save();

		// Field Posisi
		$this->Posisi->AdvancedSearch->SearchValue = @$filter["x_Posisi"];
		$this->Posisi->AdvancedSearch->SearchOperator = @$filter["z_Posisi"];
		$this->Posisi->AdvancedSearch->SearchCondition = @$filter["v_Posisi"];
		$this->Posisi->AdvancedSearch->SearchValue2 = @$filter["y_Posisi"];
		$this->Posisi->AdvancedSearch->SearchOperator2 = @$filter["w_Posisi"];
		$this->Posisi->AdvancedSearch->save();

		// Field Departemen
		$this->Departemen->AdvancedSearch->SearchValue = @$filter["x_Departemen"];
		$this->Departemen->AdvancedSearch->SearchOperator = @$filter["z_Departemen"];
		$this->Departemen->AdvancedSearch->SearchCondition = @$filter["v_Departemen"];
		$this->Departemen->AdvancedSearch->SearchValue2 = @$filter["y_Departemen"];
		$this->Departemen->AdvancedSearch->SearchOperator2 = @$filter["w_Departemen"];
		$this->Departemen->AdvancedSearch->save();

		// Field IdUser
		$this->IdUser->AdvancedSearch->SearchValue = @$filter["x_IdUser"];
		$this->IdUser->AdvancedSearch->SearchOperator = @$filter["z_IdUser"];
		$this->IdUser->AdvancedSearch->SearchCondition = @$filter["v_IdUser"];
		$this->IdUser->AdvancedSearch->SearchValue2 = @$filter["y_IdUser"];
		$this->IdUser->AdvancedSearch->SearchOperator2 = @$filter["w_IdUser"];
		$this->IdUser->AdvancedSearch->save();

		// Field TempID
		$this->TempID->AdvancedSearch->SearchValue = @$filter["x_TempID"];
		$this->TempID->AdvancedSearch->SearchOperator = @$filter["z_TempID"];
		$this->TempID->AdvancedSearch->SearchCondition = @$filter["v_TempID"];
		$this->TempID->AdvancedSearch->SearchValue2 = @$filter["y_TempID"];
		$this->TempID->AdvancedSearch->SearchOperator2 = @$filter["w_TempID"];
		$this->TempID->AdvancedSearch->save();

		// Field xphoto
		$this->xphoto->AdvancedSearch->SearchValue = @$filter["x_xphoto"];
		$this->xphoto->AdvancedSearch->SearchOperator = @$filter["z_xphoto"];
		$this->xphoto->AdvancedSearch->SearchCondition = @$filter["v_xphoto"];
		$this->xphoto->AdvancedSearch->SearchValue2 = @$filter["y_xphoto"];
		$this->xphoto->AdvancedSearch->SearchOperator2 = @$filter["w_xphoto"];
		$this->xphoto->AdvancedSearch->save();

		// Field profile
		$this->profile->AdvancedSearch->SearchValue = @$filter["x_profile"];
		$this->profile->AdvancedSearch->SearchOperator = @$filter["z_profile"];
		$this->profile->AdvancedSearch->SearchCondition = @$filter["v_profile"];
		$this->profile->AdvancedSearch->SearchValue2 = @$filter["y_profile"];
		$this->profile->AdvancedSearch->SearchOperator2 = @$filter["w_profile"];
		$this->profile->AdvancedSearch->save();

		// Field id_agama
		$this->id_agama->AdvancedSearch->SearchValue = @$filter["x_id_agama"];
		$this->id_agama->AdvancedSearch->SearchOperator = @$filter["z_id_agama"];
		$this->id_agama->AdvancedSearch->SearchCondition = @$filter["v_id_agama"];
		$this->id_agama->AdvancedSearch->SearchValue2 = @$filter["y_id_agama"];
		$this->id_agama->AdvancedSearch->SearchOperator2 = @$filter["w_id_agama"];
		$this->id_agama->AdvancedSearch->save();

		// Field id_negara
		$this->id_negara->AdvancedSearch->SearchValue = @$filter["x_id_negara"];
		$this->id_negara->AdvancedSearch->SearchOperator = @$filter["z_id_negara"];
		$this->id_negara->AdvancedSearch->SearchCondition = @$filter["v_id_negara"];
		$this->id_negara->AdvancedSearch->SearchValue2 = @$filter["y_id_negara"];
		$this->id_negara->AdvancedSearch->SearchOperator2 = @$filter["w_id_negara"];
		$this->id_negara->AdvancedSearch->save();

		// Field id_wilayah
		$this->id_wilayah->AdvancedSearch->SearchValue = @$filter["x_id_wilayah"];
		$this->id_wilayah->AdvancedSearch->SearchOperator = @$filter["z_id_wilayah"];
		$this->id_wilayah->AdvancedSearch->SearchCondition = @$filter["v_id_wilayah"];
		$this->id_wilayah->AdvancedSearch->SearchValue2 = @$filter["y_id_wilayah"];
		$this->id_wilayah->AdvancedSearch->SearchOperator2 = @$filter["w_id_wilayah"];
		$this->id_wilayah->AdvancedSearch->save();

		// Field id_jenis_tinggal
		$this->id_jenis_tinggal->AdvancedSearch->SearchValue = @$filter["x_id_jenis_tinggal"];
		$this->id_jenis_tinggal->AdvancedSearch->SearchOperator = @$filter["z_id_jenis_tinggal"];
		$this->id_jenis_tinggal->AdvancedSearch->SearchCondition = @$filter["v_id_jenis_tinggal"];
		$this->id_jenis_tinggal->AdvancedSearch->SearchValue2 = @$filter["y_id_jenis_tinggal"];
		$this->id_jenis_tinggal->AdvancedSearch->SearchOperator2 = @$filter["w_id_jenis_tinggal"];
		$this->id_jenis_tinggal->AdvancedSearch->save();

		// Field id_alat_transportasi
		$this->id_alat_transportasi->AdvancedSearch->SearchValue = @$filter["x_id_alat_transportasi"];
		$this->id_alat_transportasi->AdvancedSearch->SearchOperator = @$filter["z_id_alat_transportasi"];
		$this->id_alat_transportasi->AdvancedSearch->SearchCondition = @$filter["v_id_alat_transportasi"];
		$this->id_alat_transportasi->AdvancedSearch->SearchValue2 = @$filter["y_id_alat_transportasi"];
		$this->id_alat_transportasi->AdvancedSearch->SearchOperator2 = @$filter["w_id_alat_transportasi"];
		$this->id_alat_transportasi->AdvancedSearch->save();

		// Field no_kps
		$this->no_kps->AdvancedSearch->SearchValue = @$filter["x_no_kps"];
		$this->no_kps->AdvancedSearch->SearchOperator = @$filter["z_no_kps"];
		$this->no_kps->AdvancedSearch->SearchCondition = @$filter["v_no_kps"];
		$this->no_kps->AdvancedSearch->SearchValue2 = @$filter["y_no_kps"];
		$this->no_kps->AdvancedSearch->SearchOperator2 = @$filter["w_no_kps"];
		$this->no_kps->AdvancedSearch->save();

		// Field penerima_kps
		$this->penerima_kps->AdvancedSearch->SearchValue = @$filter["x_penerima_kps"];
		$this->penerima_kps->AdvancedSearch->SearchOperator = @$filter["z_penerima_kps"];
		$this->penerima_kps->AdvancedSearch->SearchCondition = @$filter["v_penerima_kps"];
		$this->penerima_kps->AdvancedSearch->SearchValue2 = @$filter["y_penerima_kps"];
		$this->penerima_kps->AdvancedSearch->SearchOperator2 = @$filter["w_penerima_kps"];
		$this->penerima_kps->AdvancedSearch->save();

		// Field id_kebutuhan_khusus_mahasiswa
		$this->id_kebutuhan_khusus_mahasiswa->AdvancedSearch->SearchValue = @$filter["x_id_kebutuhan_khusus_mahasiswa"];
		$this->id_kebutuhan_khusus_mahasiswa->AdvancedSearch->SearchOperator = @$filter["z_id_kebutuhan_khusus_mahasiswa"];
		$this->id_kebutuhan_khusus_mahasiswa->AdvancedSearch->SearchCondition = @$filter["v_id_kebutuhan_khusus_mahasiswa"];
		$this->id_kebutuhan_khusus_mahasiswa->AdvancedSearch->SearchValue2 = @$filter["y_id_kebutuhan_khusus_mahasiswa"];
		$this->id_kebutuhan_khusus_mahasiswa->AdvancedSearch->SearchOperator2 = @$filter["w_id_kebutuhan_khusus_mahasiswa"];
		$this->id_kebutuhan_khusus_mahasiswa->AdvancedSearch->save();

		// Field nisn
		$this->nisn->AdvancedSearch->SearchValue = @$filter["x_nisn"];
		$this->nisn->AdvancedSearch->SearchOperator = @$filter["z_nisn"];
		$this->nisn->AdvancedSearch->SearchCondition = @$filter["v_nisn"];
		$this->nisn->AdvancedSearch->SearchValue2 = @$filter["y_nisn"];
		$this->nisn->AdvancedSearch->SearchOperator2 = @$filter["w_nisn"];
		$this->nisn->AdvancedSearch->save();

		// Field iddesa
		$this->iddesa->AdvancedSearch->SearchValue = @$filter["x_iddesa"];
		$this->iddesa->AdvancedSearch->SearchOperator = @$filter["z_iddesa"];
		$this->iddesa->AdvancedSearch->SearchCondition = @$filter["v_iddesa"];
		$this->iddesa->AdvancedSearch->SearchValue2 = @$filter["y_iddesa"];
		$this->iddesa->AdvancedSearch->SearchOperator2 = @$filter["w_iddesa"];
		$this->iddesa->AdvancedSearch->save();

		// Field MulaiKerja
		$this->MulaiKerja->AdvancedSearch->SearchValue = @$filter["x_MulaiKerja"];
		$this->MulaiKerja->AdvancedSearch->SearchOperator = @$filter["z_MulaiKerja"];
		$this->MulaiKerja->AdvancedSearch->SearchCondition = @$filter["v_MulaiKerja"];
		$this->MulaiKerja->AdvancedSearch->SearchValue2 = @$filter["y_MulaiKerja"];
		$this->MulaiKerja->AdvancedSearch->SearchOperator2 = @$filter["w_MulaiKerja"];
		$this->MulaiKerja->AdvancedSearch->save();

		// Field IdKlsKerjasama
		$this->IdKlsKerjasama->AdvancedSearch->SearchValue = @$filter["x_IdKlsKerjasama"];
		$this->IdKlsKerjasama->AdvancedSearch->SearchOperator = @$filter["z_IdKlsKerjasama"];
		$this->IdKlsKerjasama->AdvancedSearch->SearchCondition = @$filter["v_IdKlsKerjasama"];
		$this->IdKlsKerjasama->AdvancedSearch->SearchValue2 = @$filter["y_IdKlsKerjasama"];
		$this->IdKlsKerjasama->AdvancedSearch->SearchOperator2 = @$filter["w_IdKlsKerjasama"];
		$this->IdKlsKerjasama->AdvancedSearch->save();

		// Field IDBeasiswa
		$this->IDBeasiswa->AdvancedSearch->SearchValue = @$filter["x_IDBeasiswa"];
		$this->IDBeasiswa->AdvancedSearch->SearchOperator = @$filter["z_IDBeasiswa"];
		$this->IDBeasiswa->AdvancedSearch->SearchCondition = @$filter["v_IDBeasiswa"];
		$this->IDBeasiswa->AdvancedSearch->SearchValue2 = @$filter["y_IDBeasiswa"];
		$this->IDBeasiswa->AdvancedSearch->SearchOperator2 = @$filter["w_IDBeasiswa"];
		$this->IDBeasiswa->AdvancedSearch->save();

		// Field tglKonversi
		$this->tglKonversi->AdvancedSearch->SearchValue = @$filter["x_tglKonversi"];
		$this->tglKonversi->AdvancedSearch->SearchOperator = @$filter["z_tglKonversi"];
		$this->tglKonversi->AdvancedSearch->SearchCondition = @$filter["v_tglKonversi"];
		$this->tglKonversi->AdvancedSearch->SearchValue2 = @$filter["y_tglKonversi"];
		$this->tglKonversi->AdvancedSearch->SearchOperator2 = @$filter["w_tglKonversi"];
		$this->tglKonversi->AdvancedSearch->save();

		// Field NoSuratKonversi
		$this->NoSuratKonversi->AdvancedSearch->SearchValue = @$filter["x_NoSuratKonversi"];
		$this->NoSuratKonversi->AdvancedSearch->SearchOperator = @$filter["z_NoSuratKonversi"];
		$this->NoSuratKonversi->AdvancedSearch->SearchCondition = @$filter["v_NoSuratKonversi"];
		$this->NoSuratKonversi->AdvancedSearch->SearchValue2 = @$filter["y_NoSuratKonversi"];
		$this->NoSuratKonversi->AdvancedSearch->SearchOperator2 = @$filter["w_NoSuratKonversi"];
		$this->NoSuratKonversi->AdvancedSearch->save();

		// Field Nopen
		$this->Nopen->AdvancedSearch->SearchValue = @$filter["x_Nopen"];
		$this->Nopen->AdvancedSearch->SearchOperator = @$filter["z_Nopen"];
		$this->Nopen->AdvancedSearch->SearchCondition = @$filter["v_Nopen"];
		$this->Nopen->AdvancedSearch->SearchValue2 = @$filter["y_Nopen"];
		$this->Nopen->AdvancedSearch->SearchOperator2 = @$filter["w_Nopen"];
		$this->Nopen->AdvancedSearch->save();

		// Field id_feedmhs
		$this->id_feedmhs->AdvancedSearch->SearchValue = @$filter["x_id_feedmhs"];
		$this->id_feedmhs->AdvancedSearch->SearchOperator = @$filter["z_id_feedmhs"];
		$this->id_feedmhs->AdvancedSearch->SearchCondition = @$filter["v_id_feedmhs"];
		$this->id_feedmhs->AdvancedSearch->SearchValue2 = @$filter["y_id_feedmhs"];
		$this->id_feedmhs->AdvancedSearch->SearchOperator2 = @$filter["w_id_feedmhs"];
		$this->id_feedmhs->AdvancedSearch->save();
		$this->BasicSearch->setKeyword(@$filter[Config("TABLE_BASIC_SEARCH")]);
		$this->BasicSearch->setType(@$filter[Config("TABLE_BASIC_SEARCH_TYPE")]);
	}

	// Advanced search WHERE clause based on QueryString
	protected function advancedSearchWhere($default = FALSE)
	{
		global $Security;
		$where = "";
		if (!$Security->canSearch())
			return "";
		$this->buildSearchSql($where, $this->Nim, $default, FALSE); // Nim
		$this->buildSearchSql($where, $this->Nama_Mhs, $default, FALSE); // Nama_Mhs
		$this->buildSearchSql($where, $this->Kode_jp, $default, FALSE); // Kode_jp
		$this->buildSearchSql($where, $this->Tmp_Lahir, $default, FALSE); // Tmp_Lahir
		$this->buildSearchSql($where, $this->Tgl_Lahir, $default, FALSE); // Tgl_Lahir
		$this->buildSearchSql($where, $this->Jenis_Kel, $default, FALSE); // Jenis_Kel
		$this->buildSearchSql($where, $this->Gol_darah, $default, FALSE); // Gol_darah
		$this->buildSearchSql($where, $this->Agama_Mhs, $default, FALSE); // Agama_Mhs
		$this->buildSearchSql($where, $this->Alamat_Mhs, $default, FALSE); // Alamat_Mhs
		$this->buildSearchSql($where, $this->rt, $default, FALSE); // rt
		$this->buildSearchSql($where, $this->rw, $default, FALSE); // rw
		$this->buildSearchSql($where, $this->Kelurahan, $default, FALSE); // Kelurahan
		$this->buildSearchSql($where, $this->Kecamatan, $default, FALSE); // Kecamatan
		$this->buildSearchSql($where, $this->Kota_Mhs, $default, FALSE); // Kota_Mhs
		$this->buildSearchSql($where, $this->Provinsi_mhs, $default, FALSE); // Provinsi_mhs
		$this->buildSearchSql($where, $this->Kodepos_Mhs, $default, FALSE); // Kodepos_Mhs
		$this->buildSearchSql($where, $this->Tlp_Mhs, $default, FALSE); // Tlp_Mhs
		$this->buildSearchSql($where, $this->TlpRumah, $default, FALSE); // TlpRumah
		$this->buildSearchSql($where, $this->_Email, $default, FALSE); // Email
		$this->buildSearchSql($where, $this->Status_Akd, $default, FALSE); // Status_Akd
		$this->buildSearchSql($where, $this->ThMasuk, $default, FALSE); // ThMasuk
		$this->buildSearchSql($where, $this->tglmasuk, $default, FALSE); // tglmasuk
		$this->buildSearchSql($where, $this->Status_Masuk, $default, FALSE); // Status_Masuk
		$this->buildSearchSql($where, $this->Sem_Masuk, $default, FALSE); // Sem_Masuk
		$this->buildSearchSql($where, $this->TaMasuk, $default, FALSE); // TaMasuk
		$this->buildSearchSql($where, $this->PerMasuk, $default, FALSE); // PerMasuk
		$this->buildSearchSql($where, $this->Pendidikan_Akhir, $default, FALSE); // Pendidikan_Akhir
		$this->buildSearchSql($where, $this->Jurusan, $default, FALSE); // Jurusan
		$this->buildSearchSql($where, $this->Thn_Selesai, $default, FALSE); // Thn_Selesai
		$this->buildSearchSql($where, $this->Kota_Pdkk, $default, FALSE); // Kota_Pdkk
		$this->buildSearchSql($where, $this->propinsi, $default, FALSE); // propinsi
		$this->buildSearchSql($where, $this->NIMASAL, $default, FALSE); // NIMASAL
		$this->buildSearchSql($where, $this->KPTSASAL, $default, FALSE); // KPTSASAL
		$this->buildSearchSql($where, $this->JENASAL, $default, FALSE); // JENASAL
		$this->buildSearchSql($where, $this->PSASAL, $default, FALSE); // PSASAL
		$this->buildSearchSql($where, $this->TSKSDIAKUI, $default, FALSE); // TSKSDIAKUI
		$this->buildSearchSql($where, $this->NamaSekolahAsal, $default, FALSE); // NamaSekolahAsal
		$this->buildSearchSql($where, $this->AlamatSekolahAsal, $default, FALSE); // AlamatSekolahAsal
		$this->buildSearchSql($where, $this->Status, $default, FALSE); // Status
		$this->buildSearchSql($where, $this->Password, $default, FALSE); // Password
		$this->buildSearchSql($where, $this->Gelombang, $default, FALSE); // Gelombang
		$this->buildSearchSql($where, $this->JalurMasuk, $default, FALSE); // JalurMasuk
		$this->buildSearchSql($where, $this->Konsentrasi, $default, FALSE); // Konsentrasi
		$this->buildSearchSql($where, $this->NIK, $default, FALSE); // NIK
		$this->buildSearchSql($where, $this->NamaIbu, $default, FALSE); // NamaIbu
		$this->buildSearchSql($where, $this->BekerjaDi, $default, FALSE); // BekerjaDi
		$this->buildSearchSql($where, $this->Lama, $default, FALSE); // Lama
		$this->buildSearchSql($where, $this->AlamatPerusahaan, $default, FALSE); // AlamatPerusahaan
		$this->buildSearchSql($where, $this->TlpPerusahaan, $default, FALSE); // TlpPerusahaan
		$this->buildSearchSql($where, $this->Posisi, $default, FALSE); // Posisi
		$this->buildSearchSql($where, $this->Departemen, $default, FALSE); // Departemen
		$this->buildSearchSql($where, $this->IdUser, $default, FALSE); // IdUser
		$this->buildSearchSql($where, $this->TempID, $default, FALSE); // TempID
		$this->buildSearchSql($where, $this->xphoto, $default, FALSE); // xphoto
		$this->buildSearchSql($where, $this->profile, $default, FALSE); // profile
		$this->buildSearchSql($where, $this->id_agama, $default, FALSE); // id_agama
		$this->buildSearchSql($where, $this->id_negara, $default, FALSE); // id_negara
		$this->buildSearchSql($where, $this->id_wilayah, $default, FALSE); // id_wilayah
		$this->buildSearchSql($where, $this->id_jenis_tinggal, $default, FALSE); // id_jenis_tinggal
		$this->buildSearchSql($where, $this->id_alat_transportasi, $default, FALSE); // id_alat_transportasi
		$this->buildSearchSql($where, $this->no_kps, $default, FALSE); // no_kps
		$this->buildSearchSql($where, $this->penerima_kps, $default, FALSE); // penerima_kps
		$this->buildSearchSql($where, $this->id_kebutuhan_khusus_mahasiswa, $default, FALSE); // id_kebutuhan_khusus_mahasiswa
		$this->buildSearchSql($where, $this->nisn, $default, FALSE); // nisn
		$this->buildSearchSql($where, $this->iddesa, $default, FALSE); // iddesa
		$this->buildSearchSql($where, $this->MulaiKerja, $default, FALSE); // MulaiKerja
		$this->buildSearchSql($where, $this->IdKlsKerjasama, $default, FALSE); // IdKlsKerjasama
		$this->buildSearchSql($where, $this->IDBeasiswa, $default, FALSE); // IDBeasiswa
		$this->buildSearchSql($where, $this->tglKonversi, $default, FALSE); // tglKonversi
		$this->buildSearchSql($where, $this->NoSuratKonversi, $default, FALSE); // NoSuratKonversi
		$this->buildSearchSql($where, $this->Nopen, $default, FALSE); // Nopen
		$this->buildSearchSql($where, $this->id_feedmhs, $default, FALSE); // id_feedmhs

		// Set up search parm
		if (!$default && $where != "" && in_array($this->Command, ["", "reset", "resetall"])) {
			$this->Command = "search";
		}
		if (!$default && $this->Command == "search") {
			$this->Nim->AdvancedSearch->save(); // Nim
			$this->Nama_Mhs->AdvancedSearch->save(); // Nama_Mhs
			$this->Kode_jp->AdvancedSearch->save(); // Kode_jp
			$this->Tmp_Lahir->AdvancedSearch->save(); // Tmp_Lahir
			$this->Tgl_Lahir->AdvancedSearch->save(); // Tgl_Lahir
			$this->Jenis_Kel->AdvancedSearch->save(); // Jenis_Kel
			$this->Gol_darah->AdvancedSearch->save(); // Gol_darah
			$this->Agama_Mhs->AdvancedSearch->save(); // Agama_Mhs
			$this->Alamat_Mhs->AdvancedSearch->save(); // Alamat_Mhs
			$this->rt->AdvancedSearch->save(); // rt
			$this->rw->AdvancedSearch->save(); // rw
			$this->Kelurahan->AdvancedSearch->save(); // Kelurahan
			$this->Kecamatan->AdvancedSearch->save(); // Kecamatan
			$this->Kota_Mhs->AdvancedSearch->save(); // Kota_Mhs
			$this->Provinsi_mhs->AdvancedSearch->save(); // Provinsi_mhs
			$this->Kodepos_Mhs->AdvancedSearch->save(); // Kodepos_Mhs
			$this->Tlp_Mhs->AdvancedSearch->save(); // Tlp_Mhs
			$this->TlpRumah->AdvancedSearch->save(); // TlpRumah
			$this->_Email->AdvancedSearch->save(); // Email
			$this->Status_Akd->AdvancedSearch->save(); // Status_Akd
			$this->ThMasuk->AdvancedSearch->save(); // ThMasuk
			$this->tglmasuk->AdvancedSearch->save(); // tglmasuk
			$this->Status_Masuk->AdvancedSearch->save(); // Status_Masuk
			$this->Sem_Masuk->AdvancedSearch->save(); // Sem_Masuk
			$this->TaMasuk->AdvancedSearch->save(); // TaMasuk
			$this->PerMasuk->AdvancedSearch->save(); // PerMasuk
			$this->Pendidikan_Akhir->AdvancedSearch->save(); // Pendidikan_Akhir
			$this->Jurusan->AdvancedSearch->save(); // Jurusan
			$this->Thn_Selesai->AdvancedSearch->save(); // Thn_Selesai
			$this->Kota_Pdkk->AdvancedSearch->save(); // Kota_Pdkk
			$this->propinsi->AdvancedSearch->save(); // propinsi
			$this->NIMASAL->AdvancedSearch->save(); // NIMASAL
			$this->KPTSASAL->AdvancedSearch->save(); // KPTSASAL
			$this->JENASAL->AdvancedSearch->save(); // JENASAL
			$this->PSASAL->AdvancedSearch->save(); // PSASAL
			$this->TSKSDIAKUI->AdvancedSearch->save(); // TSKSDIAKUI
			$this->NamaSekolahAsal->AdvancedSearch->save(); // NamaSekolahAsal
			$this->AlamatSekolahAsal->AdvancedSearch->save(); // AlamatSekolahAsal
			$this->Status->AdvancedSearch->save(); // Status
			$this->Password->AdvancedSearch->save(); // Password
			$this->Gelombang->AdvancedSearch->save(); // Gelombang
			$this->JalurMasuk->AdvancedSearch->save(); // JalurMasuk
			$this->Konsentrasi->AdvancedSearch->save(); // Konsentrasi
			$this->NIK->AdvancedSearch->save(); // NIK
			$this->NamaIbu->AdvancedSearch->save(); // NamaIbu
			$this->BekerjaDi->AdvancedSearch->save(); // BekerjaDi
			$this->Lama->AdvancedSearch->save(); // Lama
			$this->AlamatPerusahaan->AdvancedSearch->save(); // AlamatPerusahaan
			$this->TlpPerusahaan->AdvancedSearch->save(); // TlpPerusahaan
			$this->Posisi->AdvancedSearch->save(); // Posisi
			$this->Departemen->AdvancedSearch->save(); // Departemen
			$this->IdUser->AdvancedSearch->save(); // IdUser
			$this->TempID->AdvancedSearch->save(); // TempID
			$this->xphoto->AdvancedSearch->save(); // xphoto
			$this->profile->AdvancedSearch->save(); // profile
			$this->id_agama->AdvancedSearch->save(); // id_agama
			$this->id_negara->AdvancedSearch->save(); // id_negara
			$this->id_wilayah->AdvancedSearch->save(); // id_wilayah
			$this->id_jenis_tinggal->AdvancedSearch->save(); // id_jenis_tinggal
			$this->id_alat_transportasi->AdvancedSearch->save(); // id_alat_transportasi
			$this->no_kps->AdvancedSearch->save(); // no_kps
			$this->penerima_kps->AdvancedSearch->save(); // penerima_kps
			$this->id_kebutuhan_khusus_mahasiswa->AdvancedSearch->save(); // id_kebutuhan_khusus_mahasiswa
			$this->nisn->AdvancedSearch->save(); // nisn
			$this->iddesa->AdvancedSearch->save(); // iddesa
			$this->MulaiKerja->AdvancedSearch->save(); // MulaiKerja
			$this->IdKlsKerjasama->AdvancedSearch->save(); // IdKlsKerjasama
			$this->IDBeasiswa->AdvancedSearch->save(); // IDBeasiswa
			$this->tglKonversi->AdvancedSearch->save(); // tglKonversi
			$this->NoSuratKonversi->AdvancedSearch->save(); // NoSuratKonversi
			$this->Nopen->AdvancedSearch->save(); // Nopen
			$this->id_feedmhs->AdvancedSearch->save(); // id_feedmhs
		}
		return $where;
	}

	// Build search SQL
	protected function buildSearchSql(&$where, &$fld, $default, $multiValue)
	{
		$fldParm = $fld->Param;
		$fldVal = ($default) ? $fld->AdvancedSearch->SearchValueDefault : $fld->AdvancedSearch->SearchValue;
		$fldOpr = ($default) ? $fld->AdvancedSearch->SearchOperatorDefault : $fld->AdvancedSearch->SearchOperator;
		$fldCond = ($default) ? $fld->AdvancedSearch->SearchConditionDefault : $fld->AdvancedSearch->SearchCondition;
		$fldVal2 = ($default) ? $fld->AdvancedSearch->SearchValue2Default : $fld->AdvancedSearch->SearchValue2;
		$fldOpr2 = ($default) ? $fld->AdvancedSearch->SearchOperator2Default : $fld->AdvancedSearch->SearchOperator2;
		$wrk = "";
		if (is_array($fldVal))
			$fldVal = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal);
		if (is_array($fldVal2))
			$fldVal2 = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $fldVal2);
		$fldOpr = strtoupper(trim($fldOpr));
		if ($fldOpr == "")
			$fldOpr = "=";
		$fldOpr2 = strtoupper(trim($fldOpr2));
		if ($fldOpr2 == "")
			$fldOpr2 = "=";
		if (Config("SEARCH_MULTI_VALUE_OPTION") == 1 || !IsMultiSearchOperator($fldOpr))
			$multiValue = FALSE;
		if ($multiValue) {
			$wrk1 = ($fldVal != "") ? GetMultiSearchSql($fld, $fldOpr, $fldVal, $this->Dbid) : ""; // Field value 1
			$wrk2 = ($fldVal2 != "") ? GetMultiSearchSql($fld, $fldOpr2, $fldVal2, $this->Dbid) : ""; // Field value 2
			$wrk = $wrk1; // Build final SQL
			if ($wrk2 != "")
				$wrk = ($wrk != "") ? "($wrk) $fldCond ($wrk2)" : $wrk2;
		} else {
			$fldVal = $this->convertSearchValue($fld, $fldVal);
			$fldVal2 = $this->convertSearchValue($fld, $fldVal2);
			$wrk = GetSearchSql($fld, $fldVal, $fldOpr, $fldCond, $fldVal2, $fldOpr2, $this->Dbid);
		}
		AddFilter($where, $wrk);
	}

	// Convert search value
	protected function convertSearchValue(&$fld, $fldVal)
	{
		if ($fldVal == Config("NULL_VALUE") || $fldVal == Config("NOT_NULL_VALUE"))
			return $fldVal;
		$value = $fldVal;
		if ($fld->isBoolean()) {
			if ($fldVal != "")
				$value = (SameText($fldVal, "1") || SameText($fldVal, "y") || SameText($fldVal, "t")) ? $fld->TrueValue : $fld->FalseValue;
		} elseif ($fld->DataType == DATATYPE_DATE || $fld->DataType == DATATYPE_TIME) {
			if ($fldVal != "")
				$value = UnFormatDateTime($fldVal, $fld->DateTimeFormat);
		}
		return $value;
	}

	// Return basic search SQL
	protected function basicSearchSql($arKeywords, $type)
	{
		$where = "";
		$this->buildBasicSearchSql($where, $this->Nim, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->Nama_Mhs, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->Kode_jp, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->Tmp_Lahir, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->Jenis_Kel, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->Agama_Mhs, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->Alamat_Mhs, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->Kelurahan, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->Kecamatan, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->Kota_Mhs, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->Provinsi_mhs, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->Status_Akd, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->ThMasuk, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->Status_Masuk, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->JalurMasuk, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->Konsentrasi, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->NIK, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->NamaIbu, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->nisn, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->NoSuratKonversi, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->id_feedmhs, $arKeywords, $type);
		return $where;
	}

	// Build basic search SQL
	protected function buildBasicSearchSql(&$where, &$fld, $arKeywords, $type)
	{
		$defCond = ($type == "OR") ? "OR" : "AND";
		$arSql = []; // Array for SQL parts
		$arCond = []; // Array for search conditions
		$cnt = count($arKeywords);
		$j = 0; // Number of SQL parts
		for ($i = 0; $i < $cnt; $i++) {
			$keyword = $arKeywords[$i];
			$keyword = trim($keyword);
			if (Config("BASIC_SEARCH_IGNORE_PATTERN") != "") {
				$keyword = preg_replace(Config("BASIC_SEARCH_IGNORE_PATTERN"), "\\", $keyword);
				$ar = explode("\\", $keyword);
			} else {
				$ar = [$keyword];
			}
			foreach ($ar as $keyword) {
				if ($keyword != "") {
					$wrk = "";
					if ($keyword == "OR" && $type == "") {
						if ($j > 0)
							$arCond[$j - 1] = "OR";
					} elseif ($keyword == Config("NULL_VALUE")) {
						$wrk = $fld->Expression . " IS NULL";
					} elseif ($keyword == Config("NOT_NULL_VALUE")) {
						$wrk = $fld->Expression . " IS NOT NULL";
					} elseif ($fld->IsVirtual) {
						$wrk = $fld->VirtualExpression . Like(QuotedValue("%" . $keyword . "%", DATATYPE_STRING, $this->Dbid), $this->Dbid);
					} elseif ($fld->DataType != DATATYPE_NUMBER || is_numeric($keyword)) {
						$wrk = $fld->BasicSearchExpression . Like(QuotedValue("%" . $keyword . "%", DATATYPE_STRING, $this->Dbid), $this->Dbid);
					}
					if ($wrk != "") {
						$arSql[$j] = $wrk;
						$arCond[$j] = $defCond;
						$j += 1;
					}
				}
			}
		}
		$cnt = count($arSql);
		$quoted = FALSE;
		$sql = "";
		if ($cnt > 0) {
			for ($i = 0; $i < $cnt - 1; $i++) {
				if ($arCond[$i] == "OR") {
					if (!$quoted)
						$sql .= "(";
					$quoted = TRUE;
				}
				$sql .= $arSql[$i];
				if ($quoted && $arCond[$i] != "OR") {
					$sql .= ")";
					$quoted = FALSE;
				}
				$sql .= " " . $arCond[$i] . " ";
			}
			$sql .= $arSql[$cnt - 1];
			if ($quoted)
				$sql .= ")";
		}
		if ($sql != "") {
			if ($where != "")
				$where .= " OR ";
			$where .= "(" . $sql . ")";
		}
	}

	// Return basic search WHERE clause based on search keyword and type
	protected function basicSearchWhere($default = FALSE)
	{
		global $Security;
		$searchStr = "";
		if (!$Security->canSearch())
			return "";
		$searchKeyword = ($default) ? $this->BasicSearch->KeywordDefault : $this->BasicSearch->Keyword;
		$searchType = ($default) ? $this->BasicSearch->TypeDefault : $this->BasicSearch->Type;

		// Get search SQL
		if ($searchKeyword != "") {
			$ar = $this->BasicSearch->keywordList($default);

			// Search keyword in any fields
			if (($searchType == "OR" || $searchType == "AND") && $this->BasicSearch->BasicSearchAnyFields) {
				foreach ($ar as $keyword) {
					if ($keyword != "") {
						if ($searchStr != "")
							$searchStr .= " " . $searchType . " ";
						$searchStr .= "(" . $this->basicSearchSql([$keyword], $searchType) . ")";
					}
				}
			} else {
				$searchStr = $this->basicSearchSql($ar, $searchType);
			}
			if (!$default && in_array($this->Command, ["", "reset", "resetall"]))
				$this->Command = "search";
		}
		if (!$default && $this->Command == "search") {
			$this->BasicSearch->setKeyword($searchKeyword);
			$this->BasicSearch->setType($searchType);
		}
		return $searchStr;
	}

	// Check if search parm exists
	protected function checkSearchParms()
	{

		// Check basic search
		if ($this->BasicSearch->issetSession())
			return TRUE;
		if ($this->Nim->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->Nama_Mhs->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->Kode_jp->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->Tmp_Lahir->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->Tgl_Lahir->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->Jenis_Kel->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->Gol_darah->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->Agama_Mhs->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->Alamat_Mhs->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->rt->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->rw->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->Kelurahan->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->Kecamatan->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->Kota_Mhs->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->Provinsi_mhs->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->Kodepos_Mhs->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->Tlp_Mhs->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->TlpRumah->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_Email->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->Status_Akd->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->ThMasuk->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->tglmasuk->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->Status_Masuk->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->Sem_Masuk->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->TaMasuk->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->PerMasuk->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->Pendidikan_Akhir->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->Jurusan->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->Thn_Selesai->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->Kota_Pdkk->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->propinsi->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->NIMASAL->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->KPTSASAL->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->JENASAL->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->PSASAL->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->TSKSDIAKUI->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->NamaSekolahAsal->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->AlamatSekolahAsal->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->Status->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->Password->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->Gelombang->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->JalurMasuk->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->Konsentrasi->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->NIK->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->NamaIbu->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->BekerjaDi->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->Lama->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->AlamatPerusahaan->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->TlpPerusahaan->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->Posisi->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->Departemen->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->IdUser->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->TempID->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->xphoto->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->profile->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->id_agama->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->id_negara->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->id_wilayah->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->id_jenis_tinggal->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->id_alat_transportasi->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->no_kps->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->penerima_kps->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->id_kebutuhan_khusus_mahasiswa->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->nisn->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->iddesa->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->MulaiKerja->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->IdKlsKerjasama->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->IDBeasiswa->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->tglKonversi->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->NoSuratKonversi->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->Nopen->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->id_feedmhs->AdvancedSearch->issetSession())
			return TRUE;
		return FALSE;
	}

	// Clear all search parameters
	protected function resetSearchParms()
	{

		// Clear search WHERE clause
		$this->SearchWhere = "";
		$this->setSearchWhere($this->SearchWhere);

		// Clear basic search parameters
		$this->resetBasicSearchParms();

		// Clear advanced search parameters
		$this->resetAdvancedSearchParms();
	}

	// Load advanced search default values
	protected function loadAdvancedSearchDefault()
	{
		return FALSE;
	}

	// Clear all basic search parameters
	protected function resetBasicSearchParms()
	{
		$this->BasicSearch->unsetSession();
	}

	// Clear all advanced search parameters
	protected function resetAdvancedSearchParms()
	{
		$this->Nim->AdvancedSearch->unsetSession();
		$this->Nama_Mhs->AdvancedSearch->unsetSession();
		$this->Kode_jp->AdvancedSearch->unsetSession();
		$this->Tmp_Lahir->AdvancedSearch->unsetSession();
		$this->Tgl_Lahir->AdvancedSearch->unsetSession();
		$this->Jenis_Kel->AdvancedSearch->unsetSession();
		$this->Gol_darah->AdvancedSearch->unsetSession();
		$this->Agama_Mhs->AdvancedSearch->unsetSession();
		$this->Alamat_Mhs->AdvancedSearch->unsetSession();
		$this->rt->AdvancedSearch->unsetSession();
		$this->rw->AdvancedSearch->unsetSession();
		$this->Kelurahan->AdvancedSearch->unsetSession();
		$this->Kecamatan->AdvancedSearch->unsetSession();
		$this->Kota_Mhs->AdvancedSearch->unsetSession();
		$this->Provinsi_mhs->AdvancedSearch->unsetSession();
		$this->Kodepos_Mhs->AdvancedSearch->unsetSession();
		$this->Tlp_Mhs->AdvancedSearch->unsetSession();
		$this->TlpRumah->AdvancedSearch->unsetSession();
		$this->_Email->AdvancedSearch->unsetSession();
		$this->Status_Akd->AdvancedSearch->unsetSession();
		$this->ThMasuk->AdvancedSearch->unsetSession();
		$this->tglmasuk->AdvancedSearch->unsetSession();
		$this->Status_Masuk->AdvancedSearch->unsetSession();
		$this->Sem_Masuk->AdvancedSearch->unsetSession();
		$this->TaMasuk->AdvancedSearch->unsetSession();
		$this->PerMasuk->AdvancedSearch->unsetSession();
		$this->Pendidikan_Akhir->AdvancedSearch->unsetSession();
		$this->Jurusan->AdvancedSearch->unsetSession();
		$this->Thn_Selesai->AdvancedSearch->unsetSession();
		$this->Kota_Pdkk->AdvancedSearch->unsetSession();
		$this->propinsi->AdvancedSearch->unsetSession();
		$this->NIMASAL->AdvancedSearch->unsetSession();
		$this->KPTSASAL->AdvancedSearch->unsetSession();
		$this->JENASAL->AdvancedSearch->unsetSession();
		$this->PSASAL->AdvancedSearch->unsetSession();
		$this->TSKSDIAKUI->AdvancedSearch->unsetSession();
		$this->NamaSekolahAsal->AdvancedSearch->unsetSession();
		$this->AlamatSekolahAsal->AdvancedSearch->unsetSession();
		$this->Status->AdvancedSearch->unsetSession();
		$this->Password->AdvancedSearch->unsetSession();
		$this->Gelombang->AdvancedSearch->unsetSession();
		$this->JalurMasuk->AdvancedSearch->unsetSession();
		$this->Konsentrasi->AdvancedSearch->unsetSession();
		$this->NIK->AdvancedSearch->unsetSession();
		$this->NamaIbu->AdvancedSearch->unsetSession();
		$this->BekerjaDi->AdvancedSearch->unsetSession();
		$this->Lama->AdvancedSearch->unsetSession();
		$this->AlamatPerusahaan->AdvancedSearch->unsetSession();
		$this->TlpPerusahaan->AdvancedSearch->unsetSession();
		$this->Posisi->AdvancedSearch->unsetSession();
		$this->Departemen->AdvancedSearch->unsetSession();
		$this->IdUser->AdvancedSearch->unsetSession();
		$this->TempID->AdvancedSearch->unsetSession();
		$this->xphoto->AdvancedSearch->unsetSession();
		$this->profile->AdvancedSearch->unsetSession();
		$this->id_agama->AdvancedSearch->unsetSession();
		$this->id_negara->AdvancedSearch->unsetSession();
		$this->id_wilayah->AdvancedSearch->unsetSession();
		$this->id_jenis_tinggal->AdvancedSearch->unsetSession();
		$this->id_alat_transportasi->AdvancedSearch->unsetSession();
		$this->no_kps->AdvancedSearch->unsetSession();
		$this->penerima_kps->AdvancedSearch->unsetSession();
		$this->id_kebutuhan_khusus_mahasiswa->AdvancedSearch->unsetSession();
		$this->nisn->AdvancedSearch->unsetSession();
		$this->iddesa->AdvancedSearch->unsetSession();
		$this->MulaiKerja->AdvancedSearch->unsetSession();
		$this->IdKlsKerjasama->AdvancedSearch->unsetSession();
		$this->IDBeasiswa->AdvancedSearch->unsetSession();
		$this->tglKonversi->AdvancedSearch->unsetSession();
		$this->NoSuratKonversi->AdvancedSearch->unsetSession();
		$this->Nopen->AdvancedSearch->unsetSession();
		$this->id_feedmhs->AdvancedSearch->unsetSession();
	}

	// Restore all search parameters
	protected function restoreSearchParms()
	{
		$this->RestoreSearch = TRUE;

		// Restore basic search values
		$this->BasicSearch->load();

		// Restore advanced search values
		$this->Nim->AdvancedSearch->load();
		$this->Nama_Mhs->AdvancedSearch->load();
		$this->Kode_jp->AdvancedSearch->load();
		$this->Tmp_Lahir->AdvancedSearch->load();
		$this->Tgl_Lahir->AdvancedSearch->load();
		$this->Jenis_Kel->AdvancedSearch->load();
		$this->Gol_darah->AdvancedSearch->load();
		$this->Agama_Mhs->AdvancedSearch->load();
		$this->Alamat_Mhs->AdvancedSearch->load();
		$this->rt->AdvancedSearch->load();
		$this->rw->AdvancedSearch->load();
		$this->Kelurahan->AdvancedSearch->load();
		$this->Kecamatan->AdvancedSearch->load();
		$this->Kota_Mhs->AdvancedSearch->load();
		$this->Provinsi_mhs->AdvancedSearch->load();
		$this->Kodepos_Mhs->AdvancedSearch->load();
		$this->Tlp_Mhs->AdvancedSearch->load();
		$this->TlpRumah->AdvancedSearch->load();
		$this->_Email->AdvancedSearch->load();
		$this->Status_Akd->AdvancedSearch->load();
		$this->ThMasuk->AdvancedSearch->load();
		$this->tglmasuk->AdvancedSearch->load();
		$this->Status_Masuk->AdvancedSearch->load();
		$this->Sem_Masuk->AdvancedSearch->load();
		$this->TaMasuk->AdvancedSearch->load();
		$this->PerMasuk->AdvancedSearch->load();
		$this->Pendidikan_Akhir->AdvancedSearch->load();
		$this->Jurusan->AdvancedSearch->load();
		$this->Thn_Selesai->AdvancedSearch->load();
		$this->Kota_Pdkk->AdvancedSearch->load();
		$this->propinsi->AdvancedSearch->load();
		$this->NIMASAL->AdvancedSearch->load();
		$this->KPTSASAL->AdvancedSearch->load();
		$this->JENASAL->AdvancedSearch->load();
		$this->PSASAL->AdvancedSearch->load();
		$this->TSKSDIAKUI->AdvancedSearch->load();
		$this->NamaSekolahAsal->AdvancedSearch->load();
		$this->AlamatSekolahAsal->AdvancedSearch->load();
		$this->Status->AdvancedSearch->load();
		$this->Password->AdvancedSearch->load();
		$this->Gelombang->AdvancedSearch->load();
		$this->JalurMasuk->AdvancedSearch->load();
		$this->Konsentrasi->AdvancedSearch->load();
		$this->NIK->AdvancedSearch->load();
		$this->NamaIbu->AdvancedSearch->load();
		$this->BekerjaDi->AdvancedSearch->load();
		$this->Lama->AdvancedSearch->load();
		$this->AlamatPerusahaan->AdvancedSearch->load();
		$this->TlpPerusahaan->AdvancedSearch->load();
		$this->Posisi->AdvancedSearch->load();
		$this->Departemen->AdvancedSearch->load();
		$this->IdUser->AdvancedSearch->load();
		$this->TempID->AdvancedSearch->load();
		$this->xphoto->AdvancedSearch->load();
		$this->profile->AdvancedSearch->load();
		$this->id_agama->AdvancedSearch->load();
		$this->id_negara->AdvancedSearch->load();
		$this->id_wilayah->AdvancedSearch->load();
		$this->id_jenis_tinggal->AdvancedSearch->load();
		$this->id_alat_transportasi->AdvancedSearch->load();
		$this->no_kps->AdvancedSearch->load();
		$this->penerima_kps->AdvancedSearch->load();
		$this->id_kebutuhan_khusus_mahasiswa->AdvancedSearch->load();
		$this->nisn->AdvancedSearch->load();
		$this->iddesa->AdvancedSearch->load();
		$this->MulaiKerja->AdvancedSearch->load();
		$this->IdKlsKerjasama->AdvancedSearch->load();
		$this->IDBeasiswa->AdvancedSearch->load();
		$this->tglKonversi->AdvancedSearch->load();
		$this->NoSuratKonversi->AdvancedSearch->load();
		$this->Nopen->AdvancedSearch->load();
		$this->id_feedmhs->AdvancedSearch->load();
	}

	// Set up sort parameters
	protected function setupSortOrder()
	{

		// Check for "order" parameter
		if (Get("order") !== NULL) {
			$this->CurrentOrder = Get("order");
			$this->CurrentOrderType = Get("ordertype", "");
			$this->updateSort($this->Nim); // Nim
			$this->updateSort($this->Nama_Mhs); // Nama_Mhs
			$this->updateSort($this->Kode_jp); // Kode_jp
			$this->updateSort($this->Jenis_Kel); // Jenis_Kel
			$this->updateSort($this->Tlp_Mhs); // Tlp_Mhs
			$this->updateSort($this->Status_Akd); // Status_Akd
			$this->updateSort($this->Status_Masuk); // Status_Masuk
			$this->updateSort($this->TaMasuk); // TaMasuk
			$this->updateSort($this->PerMasuk); // PerMasuk
			$this->updateSort($this->Status); // Status
			$this->updateSort($this->Nopen); // Nopen
			$this->updateSort($this->id_feedmhs); // id_feedmhs
			$this->setStartRecordNumber(1); // Reset start position
		}
	}

	// Load sort order parameters
	protected function loadSortOrder()
	{
		$orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
		if ($orderBy == "") {
			if ($this->getSqlOrderBy() != "") {
				$orderBy = $this->getSqlOrderBy();
				$this->setSessionOrderBy($orderBy);
				$this->TaMasuk->setSort("DESC");
				$this->PerMasuk->setSort("ASC");
			}
		}
	}

	// Reset command
	// - cmd=reset (Reset search parameters)
	// - cmd=resetall (Reset search and master/detail parameters)
	// - cmd=resetsort (Reset sort parameters)

	protected function resetCmd()
	{

		// Check if reset command
		if (StartsString("reset", $this->Command)) {

			// Reset search criteria
			if ($this->Command == "reset" || $this->Command == "resetall")
				$this->resetSearchParms();

			// Reset sorting order
			if ($this->Command == "resetsort") {
				$orderBy = "";
				$this->setSessionOrderBy($orderBy);
				$this->Nim->setSort("");
				$this->Nama_Mhs->setSort("");
				$this->Kode_jp->setSort("");
				$this->Jenis_Kel->setSort("");
				$this->Tlp_Mhs->setSort("");
				$this->Status_Akd->setSort("");
				$this->Status_Masuk->setSort("");
				$this->TaMasuk->setSort("");
				$this->PerMasuk->setSort("");
				$this->Status->setSort("");
				$this->Nopen->setSort("");
				$this->id_feedmhs->setSort("");
			}

			// Reset start position
			$this->StartRecord = 1;
			$this->setStartRecordNumber($this->StartRecord);
		}
	}

	// Set up list options
	protected function setupListOptions()
	{
		global $Security, $Language;

		// Add group option item
		$item = &$this->ListOptions->add($this->ListOptions->GroupOptionName);
		$item->Body = "";
		$item->OnLeft = TRUE;
		$item->Visible = FALSE;

		// "edit"
		$item = &$this->ListOptions->add("edit");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->canEdit();
		$item->OnLeft = TRUE;

		// "detail_Wli_DNS"
		$item = &$this->ListOptions->add("detail_Wli_DNS");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->allowList(CurrentProjectID() . 'Wli_DNS') && !$this->ShowMultipleDetails;
		$item->OnLeft = TRUE;
		$item->ShowInButtonGroup = FALSE;
		if (!isset($GLOBALS["Wli_DNS_grid"]))
			$GLOBALS["Wli_DNS_grid"] = new Wli_DNS_grid();

		// "detail_Wali_IPS"
		$item = &$this->ListOptions->add("detail_Wali_IPS");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->allowList(CurrentProjectID() . 'Wali_IPS') && !$this->ShowMultipleDetails;
		$item->OnLeft = TRUE;
		$item->ShowInButtonGroup = FALSE;
		if (!isset($GLOBALS["Wali_IPS_grid"]))
			$GLOBALS["Wali_IPS_grid"] = new Wali_IPS_grid();

		// Multiple details
		if ($this->ShowMultipleDetails) {
			$item = &$this->ListOptions->add("details");
			$item->CssClass = "text-nowrap";
			$item->Visible = $this->ShowMultipleDetails;
			$item->OnLeft = TRUE;
			$item->ShowInButtonGroup = FALSE;
		}

		// Set up detail pages
		$pages = new SubPages();
		$pages->add("Wli_DNS");
		$pages->add("Wali_IPS");
		$this->DetailPages = $pages;

		// List actions
		$item = &$this->ListOptions->add("listactions");
		$item->CssClass = "text-nowrap";
		$item->OnLeft = TRUE;
		$item->Visible = FALSE;
		$item->ShowInButtonGroup = FALSE;
		$item->ShowInDropDown = FALSE;

		// "checkbox"
		$item = &$this->ListOptions->add("checkbox");
		$item->Visible = FALSE;
		$item->OnLeft = TRUE;
		$item->Header = "<div class=\"custom-control custom-checkbox d-inline-block\"><input type=\"checkbox\" name=\"key\" id=\"key\" class=\"custom-control-input\" onclick=\"ew.selectAllKey(this);\"><label class=\"custom-control-label\" for=\"key\"></label></div>";
		$item->moveTo(0);
		$item->ShowInDropDown = FALSE;
		$item->ShowInButtonGroup = FALSE;

		// Drop down button for ListOptions
		$this->ListOptions->UseDropDownButton = FALSE;
		$this->ListOptions->DropDownButtonPhrase = $Language->phrase("ButtonListOptions");
		$this->ListOptions->UseButtonGroup = TRUE;
		if ($this->ListOptions->UseButtonGroup && IsMobile())
			$this->ListOptions->UseDropDownButton = TRUE;

		//$this->ListOptions->ButtonClass = ""; // Class for button group
		// Call ListOptions_Load event

		$this->ListOptions_Load();
		$this->setupListOptionsExt();
		$item = $this->ListOptions[$this->ListOptions->GroupOptionName];
		$item->Visible = $this->ListOptions->groupOptionVisible();
	}

	// Render list options
	public function renderListOptions()
	{
		global $Security, $Language, $CurrentForm;
		$this->ListOptions->loadDefault();

		// Call ListOptions_Rendering event
		$this->ListOptions_Rendering();

		// "edit"
		$opt = $this->ListOptions["edit"];
		$editcaption = HtmlTitle($Language->phrase("EditLink"));
		if ($Security->canEdit()) {
			$opt->Body = "<a class=\"ew-row-link ew-edit\" title=\"" . HtmlTitle($Language->phrase("EditLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("EditLink")) . "\" href=\"" . HtmlEncode($this->EditUrl) . "\">" . $Language->phrase("EditLink") . "</a>";
		} else {
			$opt->Body = "";
		}

		// Set up list action buttons
		$opt = $this->ListOptions["listactions"];
		if ($opt && !$this->isExport() && !$this->CurrentAction) {
			$body = "";
			$links = [];
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == ACTION_SINGLE && $listaction->Allow) {
					$action = $listaction->Action;
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon != "") ? "<i class=\"" . HtmlEncode(str_replace(" ew-icon", "", $listaction->Icon)) . "\" data-caption=\"" . HtmlTitle($caption) . "\"></i> " : "";
					$links[] = "<li><a class=\"dropdown-item ew-action ew-list-action\" data-action=\"" . HtmlEncode($action) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"#\" onclick=\"return ew.submitAction(event,jQuery.extend({key:" . $this->keyToJson(TRUE) . "}," . $listaction->toJson(TRUE) . "));\">" . $icon . $listaction->Caption . "</a></li>";
					if (count($links) == 1) // Single button
						$body = "<a class=\"ew-action ew-list-action\" data-action=\"" . HtmlEncode($action) . "\" title=\"" . HtmlTitle($caption) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"#\" onclick=\"return ew.submitAction(event,jQuery.extend({key:" . $this->keyToJson(TRUE) . "}," . $listaction->toJson(TRUE) . "));\">" . $icon . $listaction->Caption . "</a>";
				}
			}
			if (count($links) > 1) { // More than one buttons, use dropdown
				$body = "<button class=\"dropdown-toggle btn btn-default ew-actions\" title=\"" . HtmlTitle($Language->phrase("ListActionButton")) . "\" data-toggle=\"dropdown\">" . $Language->phrase("ListActionButton") . "</button>";
				$content = "";
				foreach ($links as $link)
					$content .= "<li>" . $link . "</li>";
				$body .= "<ul class=\"dropdown-menu" . ($opt->OnLeft ? "" : " dropdown-menu-right") . "\">". $content . "</ul>";
				$body = "<div class=\"btn-group btn-group-sm\">" . $body . "</div>";
			}
			if (count($links) > 0) {
				$opt->Body = $body;
				$opt->Visible = TRUE;
			}
		}
		$detailViewTblVar = "";
		$detailCopyTblVar = "";
		$detailEditTblVar = "";

		// "detail_Wli_DNS"
		$opt = $this->ListOptions["detail_Wli_DNS"];
		if ($Security->allowList(CurrentProjectID() . 'Wli_DNS')) {
			$body = $Language->phrase("DetailLink") . $Language->TablePhrase("Wli_DNS", "TblCaption");
			$body .= "&nbsp;" . str_replace("%c", $this->Wli_DNS_Count, $Language->phrase("DetailCount"));
			$body = "<a class=\"btn btn-default ew-row-link ew-detail\" data-action=\"list\" href=\"" . HtmlEncode("Wli_DNSlist.php?" . Config("TABLE_SHOW_MASTER") . "=tblMHS&fk_Nim=" . urlencode(strval($this->Nim->CurrentValue)) . "") . "\">" . $body . "</a>";
			$links = "";
			if ($GLOBALS["Wli_DNS_grid"]->DetailEdit && $Security->canEdit() && $Security->allowEdit(CurrentProjectID() . 'tblMHS')) {
				$caption = $Language->phrase("MasterDetailEditLink");
				$url = $this->getEditUrl(Config("TABLE_SHOW_DETAIL") . "=Wli_DNS");
				$links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-edit\" data-action=\"edit\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"" . HtmlEncode($url) . "\">" . HtmlImageAndText($caption) . "</a></li>";
				if ($detailEditTblVar != "")
					$detailEditTblVar .= ",";
				$detailEditTblVar .= "Wli_DNS";
			}
			if ($links != "") {
				$body .= "<button class=\"dropdown-toggle btn btn-default ew-detail\" data-toggle=\"dropdown\"></button>";
				$body .= "<ul class=\"dropdown-menu\">". $links . "</ul>";
			}
			$body = "<div class=\"btn-group btn-group-sm ew-btn-group\">" . $body . "</div>";
			$opt->Body = $body;
			if ($this->ShowMultipleDetails)
				$opt->Visible = FALSE;
		}

		// "detail_Wali_IPS"
		$opt = $this->ListOptions["detail_Wali_IPS"];
		if ($Security->allowList(CurrentProjectID() . 'Wali_IPS')) {
			$body = $Language->phrase("DetailLink") . $Language->TablePhrase("Wali_IPS", "TblCaption");
			$body .= "&nbsp;" . str_replace("%c", $this->Wali_IPS_Count, $Language->phrase("DetailCount"));
			$body = "<a class=\"btn btn-default ew-row-link ew-detail\" data-action=\"list\" href=\"" . HtmlEncode("Wali_IPSlist.php?" . Config("TABLE_SHOW_MASTER") . "=tblMHS&fk_Nim=" . urlencode(strval($this->Nim->CurrentValue)) . "") . "\">" . $body . "</a>";
			$links = "";
			if ($GLOBALS["Wali_IPS_grid"]->DetailEdit && $Security->canEdit() && $Security->allowEdit(CurrentProjectID() . 'tblMHS')) {
				$caption = $Language->phrase("MasterDetailEditLink");
				$url = $this->getEditUrl(Config("TABLE_SHOW_DETAIL") . "=Wali_IPS");
				$links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-edit\" data-action=\"edit\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"" . HtmlEncode($url) . "\">" . HtmlImageAndText($caption) . "</a></li>";
				if ($detailEditTblVar != "")
					$detailEditTblVar .= ",";
				$detailEditTblVar .= "Wali_IPS";
			}
			if ($links != "") {
				$body .= "<button class=\"dropdown-toggle btn btn-default ew-detail\" data-toggle=\"dropdown\"></button>";
				$body .= "<ul class=\"dropdown-menu\">". $links . "</ul>";
			}
			$body = "<div class=\"btn-group btn-group-sm ew-btn-group\">" . $body . "</div>";
			$opt->Body = $body;
			if ($this->ShowMultipleDetails)
				$opt->Visible = FALSE;
		}
		if ($this->ShowMultipleDetails) {
			$body = "<div class=\"btn-group btn-group-sm ew-btn-group\">";
			$links = "";
			if ($detailViewTblVar != "") {
				$links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-view\" data-action=\"view\" data-caption=\"" . HtmlTitle($Language->phrase("MasterDetailViewLink")) . "\" href=\"" . HtmlEncode($this->getViewUrl(Config("TABLE_SHOW_DETAIL") . "=" . $detailViewTblVar)) . "\">" . HtmlImageAndText($Language->phrase("MasterDetailViewLink")) . "</a></li>";
			}
			if ($detailEditTblVar != "") {
				$links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-edit\" data-action=\"edit\" data-caption=\"" . HtmlTitle($Language->phrase("MasterDetailEditLink")) . "\" href=\"" . HtmlEncode($this->getEditUrl(Config("TABLE_SHOW_DETAIL") . "=" . $detailEditTblVar)) . "\">" . HtmlImageAndText($Language->phrase("MasterDetailEditLink")) . "</a></li>";
			}
			if ($detailCopyTblVar != "") {
				$links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-copy\" data-action=\"add\" data-caption=\"" . HtmlTitle($Language->phrase("MasterDetailCopyLink")) . "\" href=\"" . HtmlEncode($this->GetCopyUrl(Config("TABLE_SHOW_DETAIL") . "=" . $detailCopyTblVar)) . "\">" . HtmlImageAndText($Language->phrase("MasterDetailCopyLink")) . "</a></li>";
			}
			if ($links != "") {
				$body .= "<button class=\"dropdown-toggle btn btn-default ew-master-detail\" title=\"" . HtmlTitle($Language->phrase("MultipleMasterDetails")) . "\" data-toggle=\"dropdown\">" . $Language->phrase("MultipleMasterDetails") . "</button>";
				$body .= "<ul class=\"dropdown-menu ew-menu\">". $links . "</ul>";
			}
			$body .= "</div>";

			// Multiple details
			$opt = $this->ListOptions["details"];
			$opt->Body = $body;
		}

		// "checkbox"
		$opt = $this->ListOptions["checkbox"];
		$opt->Body = "<div class=\"custom-control custom-checkbox d-inline-block\"><input type=\"checkbox\" id=\"key_m_" . $this->RowCount . "\" name=\"key_m[]\" class=\"custom-control-input ew-multi-select\" value=\"" . HtmlEncode($this->Nim->CurrentValue) . "\" onclick=\"ew.clickMultiCheckbox(event);\"><label class=\"custom-control-label\" for=\"key_m_" . $this->RowCount . "\"></label></div>";
		$this->renderListOptionsExt();

		// Call ListOptions_Rendered event
		$this->ListOptions_Rendered();
	}

	// Set up other options
	protected function setupOtherOptions()
	{
		global $Language, $Security;
		$options = &$this->OtherOptions;
		$option = $options["action"];

		// Set up options default
		foreach ($options as $option) {
			$option->UseDropDownButton = FALSE;
			$option->UseButtonGroup = TRUE;

			//$option->ButtonClass = ""; // Class for button group
			$item = &$option->add($option->GroupOptionName);
			$item->Body = "";
			$item->Visible = FALSE;
		}
		$options["addedit"]->DropDownButtonPhrase = $Language->phrase("ButtonAddEdit");
		$options["detail"]->DropDownButtonPhrase = $Language->phrase("ButtonDetails");
		$options["action"]->DropDownButtonPhrase = $Language->phrase("ButtonActions");

		// Filter button
		$item = &$this->FilterOptions->add("savecurrentfilter");
		$item->Body = "<a class=\"ew-save-filter\" data-form=\"ftblMHSlistsrch\" href=\"#\" onclick=\"return false;\">" . $Language->phrase("SaveCurrentFilter") . "</a>";
		$item->Visible = TRUE;
		$item = &$this->FilterOptions->add("deletefilter");
		$item->Body = "<a class=\"ew-delete-filter\" data-form=\"ftblMHSlistsrch\" href=\"#\" onclick=\"return false;\">" . $Language->phrase("DeleteFilter") . "</a>";
		$item->Visible = TRUE;
		$this->FilterOptions->UseDropDownButton = TRUE;
		$this->FilterOptions->UseButtonGroup = !$this->FilterOptions->UseDropDownButton;
		$this->FilterOptions->DropDownButtonPhrase = $Language->phrase("Filters");

		// Add group option item
		$item = &$this->FilterOptions->add($this->FilterOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	// Render other options
	public function renderOtherOptions()
	{
		global $Language, $Security;
		$options = &$this->OtherOptions;
			$option = $options["action"];

			// Set up list action buttons
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == ACTION_MULTIPLE) {
					$item = &$option->add("custom_" . $listaction->Action);
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon != "") ? "<i class=\"" . HtmlEncode($listaction->Icon) . "\" data-caption=\"" . HtmlEncode($caption) . "\"></i> " . $caption : $caption;
					$item->Body = "<a class=\"ew-action ew-list-action\" title=\"" . HtmlEncode($caption) . "\" data-caption=\"" . HtmlEncode($caption) . "\" href=\"#\" onclick=\"return ew.submitAction(event,jQuery.extend({f:document.ftblMHSlist}," . $listaction->toJson(TRUE) . "));\">" . $icon . "</a>";
					$item->Visible = $listaction->Allow;
				}
			}

			// Hide grid edit and other options
			if ($this->TotalRecords <= 0) {
				$option = $options["addedit"];
				$item = $option["gridedit"];
				if ($item)
					$item->Visible = FALSE;
				$option = $options["action"];
				$option->hideAllOptions();
			}
	}

	// Process list action
	protected function processListAction()
	{
		global $Language, $Security;
		$userlist = "";
		$user = "";
		$filter = $this->getFilterFromRecordKeys();
		$userAction = Post("useraction", "");
		if ($filter != "" && $userAction != "") {

			// Check permission first
			$actionCaption = $userAction;
			if (array_key_exists($userAction, $this->ListActions->Items)) {
				$actionCaption = $this->ListActions[$userAction]->Caption;
				if (!$this->ListActions[$userAction]->Allow) {
					$errmsg = str_replace('%s', $actionCaption, $Language->phrase("CustomActionNotAllowed"));
					if (Post("ajax") == $userAction) // Ajax
						echo "<p class=\"text-danger\">" . $errmsg . "</p>";
					else
						$this->setFailureMessage($errmsg);
					return FALSE;
				}
			}
			$this->CurrentFilter = $filter;
			$sql = $this->getCurrentSql();
			$conn = $this->getConnection();
			$conn->raiseErrorFn = Config("ERROR_FUNC");
			$rs = $conn->execute($sql);
			$conn->raiseErrorFn = "";
			$this->CurrentAction = $userAction;

			// Call row action event
			if ($rs && !$rs->EOF) {
				$conn->beginTrans();
				$this->SelectedCount = $rs->RecordCount();
				$this->SelectedIndex = 0;
				while (!$rs->EOF) {
					$this->SelectedIndex++;
					$row = $rs->fields;
					$processed = $this->Row_CustomAction($userAction, $row);
					if (!$processed)
						break;
					$rs->moveNext();
				}
				if ($processed) {
					$conn->commitTrans(); // Commit the changes
					if ($this->getSuccessMessage() == "" && !ob_get_length()) // No output
						$this->setSuccessMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionCompleted"))); // Set up success message
				} else {
					$conn->rollbackTrans(); // Rollback changes

					// Set up error message
					if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {

						// Use the message, do nothing
					} elseif ($this->CancelMessage != "") {
						$this->setFailureMessage($this->CancelMessage);
						$this->CancelMessage = "";
					} else {
						$this->setFailureMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionFailed")));
					}
				}
			}
			if ($rs)
				$rs->close();
			$this->CurrentAction = ""; // Clear action
			if (Post("ajax") == $userAction) { // Ajax
				if ($this->getSuccessMessage() != "") {
					echo "<p class=\"text-success\">" . $this->getSuccessMessage() . "</p>";
					$this->clearSuccessMessage(); // Clear message
				}
				if ($this->getFailureMessage() != "") {
					echo "<p class=\"text-danger\">" . $this->getFailureMessage() . "</p>";
					$this->clearFailureMessage(); // Clear message
				}
				return TRUE;
			}
		}
		return FALSE; // Not ajax request
	}

// Set up list options (extended codes)
	protected function setupListOptionsExt()
	{
	}

// Render list options (extended codes)
	protected function renderListOptionsExt()
	{
		global $Security, $Language;
	}

	// Load basic search values
	protected function loadBasicSearchValues()
	{
		$this->BasicSearch->setKeyword(Get(Config("TABLE_BASIC_SEARCH"), ""), FALSE);
		if ($this->BasicSearch->Keyword != "" && $this->Command == "")
			$this->Command = "search";
		$this->BasicSearch->setType(Get(Config("TABLE_BASIC_SEARCH_TYPE"), ""), FALSE);
	}

	// Load search values for validation
	protected function loadSearchValues()
	{

		// Load search values
		$got = FALSE;

		// Nim
		if (!$this->isAddOrEdit() && $this->Nim->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->Nim->AdvancedSearch->SearchValue != "" || $this->Nim->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// Nama_Mhs
		if (!$this->isAddOrEdit() && $this->Nama_Mhs->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->Nama_Mhs->AdvancedSearch->SearchValue != "" || $this->Nama_Mhs->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// Kode_jp
		if (!$this->isAddOrEdit() && $this->Kode_jp->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->Kode_jp->AdvancedSearch->SearchValue != "" || $this->Kode_jp->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// Tmp_Lahir
		if (!$this->isAddOrEdit() && $this->Tmp_Lahir->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->Tmp_Lahir->AdvancedSearch->SearchValue != "" || $this->Tmp_Lahir->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// Tgl_Lahir
		if (!$this->isAddOrEdit() && $this->Tgl_Lahir->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->Tgl_Lahir->AdvancedSearch->SearchValue != "" || $this->Tgl_Lahir->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// Jenis_Kel
		if (!$this->isAddOrEdit() && $this->Jenis_Kel->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->Jenis_Kel->AdvancedSearch->SearchValue != "" || $this->Jenis_Kel->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// Gol_darah
		if (!$this->isAddOrEdit() && $this->Gol_darah->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->Gol_darah->AdvancedSearch->SearchValue != "" || $this->Gol_darah->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// Agama_Mhs
		if (!$this->isAddOrEdit() && $this->Agama_Mhs->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->Agama_Mhs->AdvancedSearch->SearchValue != "" || $this->Agama_Mhs->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// Alamat_Mhs
		if (!$this->isAddOrEdit() && $this->Alamat_Mhs->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->Alamat_Mhs->AdvancedSearch->SearchValue != "" || $this->Alamat_Mhs->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// rt
		if (!$this->isAddOrEdit() && $this->rt->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->rt->AdvancedSearch->SearchValue != "" || $this->rt->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// rw
		if (!$this->isAddOrEdit() && $this->rw->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->rw->AdvancedSearch->SearchValue != "" || $this->rw->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// Kelurahan
		if (!$this->isAddOrEdit() && $this->Kelurahan->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->Kelurahan->AdvancedSearch->SearchValue != "" || $this->Kelurahan->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// Kecamatan
		if (!$this->isAddOrEdit() && $this->Kecamatan->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->Kecamatan->AdvancedSearch->SearchValue != "" || $this->Kecamatan->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// Kota_Mhs
		if (!$this->isAddOrEdit() && $this->Kota_Mhs->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->Kota_Mhs->AdvancedSearch->SearchValue != "" || $this->Kota_Mhs->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// Provinsi_mhs
		if (!$this->isAddOrEdit() && $this->Provinsi_mhs->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->Provinsi_mhs->AdvancedSearch->SearchValue != "" || $this->Provinsi_mhs->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// Kodepos_Mhs
		if (!$this->isAddOrEdit() && $this->Kodepos_Mhs->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->Kodepos_Mhs->AdvancedSearch->SearchValue != "" || $this->Kodepos_Mhs->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// Tlp_Mhs
		if (!$this->isAddOrEdit() && $this->Tlp_Mhs->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->Tlp_Mhs->AdvancedSearch->SearchValue != "" || $this->Tlp_Mhs->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// TlpRumah
		if (!$this->isAddOrEdit() && $this->TlpRumah->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->TlpRumah->AdvancedSearch->SearchValue != "" || $this->TlpRumah->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// Email
		if (!$this->isAddOrEdit() && $this->_Email->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->_Email->AdvancedSearch->SearchValue != "" || $this->_Email->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// Status_Akd
		if (!$this->isAddOrEdit() && $this->Status_Akd->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->Status_Akd->AdvancedSearch->SearchValue != "" || $this->Status_Akd->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// ThMasuk
		if (!$this->isAddOrEdit() && $this->ThMasuk->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->ThMasuk->AdvancedSearch->SearchValue != "" || $this->ThMasuk->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// tglmasuk
		if (!$this->isAddOrEdit() && $this->tglmasuk->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->tglmasuk->AdvancedSearch->SearchValue != "" || $this->tglmasuk->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// Status_Masuk
		if (!$this->isAddOrEdit() && $this->Status_Masuk->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->Status_Masuk->AdvancedSearch->SearchValue != "" || $this->Status_Masuk->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// Sem_Masuk
		if (!$this->isAddOrEdit() && $this->Sem_Masuk->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->Sem_Masuk->AdvancedSearch->SearchValue != "" || $this->Sem_Masuk->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// TaMasuk
		if (!$this->isAddOrEdit() && $this->TaMasuk->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->TaMasuk->AdvancedSearch->SearchValue != "" || $this->TaMasuk->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// PerMasuk
		if (!$this->isAddOrEdit() && $this->PerMasuk->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->PerMasuk->AdvancedSearch->SearchValue != "" || $this->PerMasuk->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// Pendidikan_Akhir
		if (!$this->isAddOrEdit() && $this->Pendidikan_Akhir->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->Pendidikan_Akhir->AdvancedSearch->SearchValue != "" || $this->Pendidikan_Akhir->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// Jurusan
		if (!$this->isAddOrEdit() && $this->Jurusan->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->Jurusan->AdvancedSearch->SearchValue != "" || $this->Jurusan->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// Thn_Selesai
		if (!$this->isAddOrEdit() && $this->Thn_Selesai->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->Thn_Selesai->AdvancedSearch->SearchValue != "" || $this->Thn_Selesai->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// Kota_Pdkk
		if (!$this->isAddOrEdit() && $this->Kota_Pdkk->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->Kota_Pdkk->AdvancedSearch->SearchValue != "" || $this->Kota_Pdkk->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// propinsi
		if (!$this->isAddOrEdit() && $this->propinsi->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->propinsi->AdvancedSearch->SearchValue != "" || $this->propinsi->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// NIMASAL
		if (!$this->isAddOrEdit() && $this->NIMASAL->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->NIMASAL->AdvancedSearch->SearchValue != "" || $this->NIMASAL->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// KPTSASAL
		if (!$this->isAddOrEdit() && $this->KPTSASAL->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->KPTSASAL->AdvancedSearch->SearchValue != "" || $this->KPTSASAL->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// JENASAL
		if (!$this->isAddOrEdit() && $this->JENASAL->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->JENASAL->AdvancedSearch->SearchValue != "" || $this->JENASAL->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// PSASAL
		if (!$this->isAddOrEdit() && $this->PSASAL->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->PSASAL->AdvancedSearch->SearchValue != "" || $this->PSASAL->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// TSKSDIAKUI
		if (!$this->isAddOrEdit() && $this->TSKSDIAKUI->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->TSKSDIAKUI->AdvancedSearch->SearchValue != "" || $this->TSKSDIAKUI->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// NamaSekolahAsal
		if (!$this->isAddOrEdit() && $this->NamaSekolahAsal->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->NamaSekolahAsal->AdvancedSearch->SearchValue != "" || $this->NamaSekolahAsal->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// AlamatSekolahAsal
		if (!$this->isAddOrEdit() && $this->AlamatSekolahAsal->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->AlamatSekolahAsal->AdvancedSearch->SearchValue != "" || $this->AlamatSekolahAsal->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// Status
		if (!$this->isAddOrEdit() && $this->Status->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->Status->AdvancedSearch->SearchValue != "" || $this->Status->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// Password
		if (!$this->isAddOrEdit() && $this->Password->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->Password->AdvancedSearch->SearchValue != "" || $this->Password->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// Gelombang
		if (!$this->isAddOrEdit() && $this->Gelombang->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->Gelombang->AdvancedSearch->SearchValue != "" || $this->Gelombang->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// JalurMasuk
		if (!$this->isAddOrEdit() && $this->JalurMasuk->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->JalurMasuk->AdvancedSearch->SearchValue != "" || $this->JalurMasuk->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// Konsentrasi
		if (!$this->isAddOrEdit() && $this->Konsentrasi->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->Konsentrasi->AdvancedSearch->SearchValue != "" || $this->Konsentrasi->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// NIK
		if (!$this->isAddOrEdit() && $this->NIK->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->NIK->AdvancedSearch->SearchValue != "" || $this->NIK->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// NamaIbu
		if (!$this->isAddOrEdit() && $this->NamaIbu->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->NamaIbu->AdvancedSearch->SearchValue != "" || $this->NamaIbu->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// BekerjaDi
		if (!$this->isAddOrEdit() && $this->BekerjaDi->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->BekerjaDi->AdvancedSearch->SearchValue != "" || $this->BekerjaDi->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// Lama
		if (!$this->isAddOrEdit() && $this->Lama->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->Lama->AdvancedSearch->SearchValue != "" || $this->Lama->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// AlamatPerusahaan
		if (!$this->isAddOrEdit() && $this->AlamatPerusahaan->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->AlamatPerusahaan->AdvancedSearch->SearchValue != "" || $this->AlamatPerusahaan->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// TlpPerusahaan
		if (!$this->isAddOrEdit() && $this->TlpPerusahaan->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->TlpPerusahaan->AdvancedSearch->SearchValue != "" || $this->TlpPerusahaan->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// Posisi
		if (!$this->isAddOrEdit() && $this->Posisi->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->Posisi->AdvancedSearch->SearchValue != "" || $this->Posisi->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// Departemen
		if (!$this->isAddOrEdit() && $this->Departemen->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->Departemen->AdvancedSearch->SearchValue != "" || $this->Departemen->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// IdUser
		if (!$this->isAddOrEdit() && $this->IdUser->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->IdUser->AdvancedSearch->SearchValue != "" || $this->IdUser->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// TempID
		if (!$this->isAddOrEdit() && $this->TempID->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->TempID->AdvancedSearch->SearchValue != "" || $this->TempID->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// xphoto
		if (!$this->isAddOrEdit() && $this->xphoto->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->xphoto->AdvancedSearch->SearchValue != "" || $this->xphoto->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// profile
		if (!$this->isAddOrEdit() && $this->profile->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->profile->AdvancedSearch->SearchValue != "" || $this->profile->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// id_agama
		if (!$this->isAddOrEdit() && $this->id_agama->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->id_agama->AdvancedSearch->SearchValue != "" || $this->id_agama->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// id_negara
		if (!$this->isAddOrEdit() && $this->id_negara->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->id_negara->AdvancedSearch->SearchValue != "" || $this->id_negara->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// id_wilayah
		if (!$this->isAddOrEdit() && $this->id_wilayah->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->id_wilayah->AdvancedSearch->SearchValue != "" || $this->id_wilayah->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// id_jenis_tinggal
		if (!$this->isAddOrEdit() && $this->id_jenis_tinggal->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->id_jenis_tinggal->AdvancedSearch->SearchValue != "" || $this->id_jenis_tinggal->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// id_alat_transportasi
		if (!$this->isAddOrEdit() && $this->id_alat_transportasi->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->id_alat_transportasi->AdvancedSearch->SearchValue != "" || $this->id_alat_transportasi->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// no_kps
		if (!$this->isAddOrEdit() && $this->no_kps->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->no_kps->AdvancedSearch->SearchValue != "" || $this->no_kps->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// penerima_kps
		if (!$this->isAddOrEdit() && $this->penerima_kps->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->penerima_kps->AdvancedSearch->SearchValue != "" || $this->penerima_kps->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// id_kebutuhan_khusus_mahasiswa
		if (!$this->isAddOrEdit() && $this->id_kebutuhan_khusus_mahasiswa->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->id_kebutuhan_khusus_mahasiswa->AdvancedSearch->SearchValue != "" || $this->id_kebutuhan_khusus_mahasiswa->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// nisn
		if (!$this->isAddOrEdit() && $this->nisn->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->nisn->AdvancedSearch->SearchValue != "" || $this->nisn->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// iddesa
		if (!$this->isAddOrEdit() && $this->iddesa->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->iddesa->AdvancedSearch->SearchValue != "" || $this->iddesa->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// MulaiKerja
		if (!$this->isAddOrEdit() && $this->MulaiKerja->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->MulaiKerja->AdvancedSearch->SearchValue != "" || $this->MulaiKerja->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// IdKlsKerjasama
		if (!$this->isAddOrEdit() && $this->IdKlsKerjasama->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->IdKlsKerjasama->AdvancedSearch->SearchValue != "" || $this->IdKlsKerjasama->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// IDBeasiswa
		if (!$this->isAddOrEdit() && $this->IDBeasiswa->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->IDBeasiswa->AdvancedSearch->SearchValue != "" || $this->IDBeasiswa->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// tglKonversi
		if (!$this->isAddOrEdit() && $this->tglKonversi->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->tglKonversi->AdvancedSearch->SearchValue != "" || $this->tglKonversi->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// NoSuratKonversi
		if (!$this->isAddOrEdit() && $this->NoSuratKonversi->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->NoSuratKonversi->AdvancedSearch->SearchValue != "" || $this->NoSuratKonversi->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// Nopen
		if (!$this->isAddOrEdit() && $this->Nopen->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->Nopen->AdvancedSearch->SearchValue != "" || $this->Nopen->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}

		// id_feedmhs
		if (!$this->isAddOrEdit() && $this->id_feedmhs->AdvancedSearch->get()) {
			$got = TRUE;
			if (($this->id_feedmhs->AdvancedSearch->SearchValue != "" || $this->id_feedmhs->AdvancedSearch->SearchValue2 != "") && $this->Command == "")
				$this->Command = "search";
		}
		return $got;
	}

	// Load recordset
	public function loadRecordset($offset = -1, $rowcnt = -1)
	{

		// Load List page SQL
		$sql = $this->getListSql();
		$conn = $this->getConnection();

		// Load recordset
		$dbtype = GetConnectionType($this->Dbid);
		if ($this->UseSelectLimit) {
			$conn->raiseErrorFn = Config("ERROR_FUNC");
			if ($dbtype == "MSSQL") {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset, ["_hasOrderBy" => trim($this->getOrderBy()) || trim($this->getSessionOrderBy())]);
			} else {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset);
			}
			$conn->raiseErrorFn = "";
		} else {
			$rs = LoadRecordset($sql, $conn);
		}

		// Call Recordset Selected event
		$this->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = $this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->Nim->setDbValue($row['Nim']);
		$this->Nama_Mhs->setDbValue($row['Nama_Mhs']);
		$this->Kode_jp->setDbValue($row['Kode_jp']);
		$this->Tmp_Lahir->setDbValue($row['Tmp_Lahir']);
		$this->Tgl_Lahir->setDbValue($row['Tgl_Lahir']);
		$this->Jenis_Kel->setDbValue($row['Jenis_Kel']);
		$this->Gol_darah->setDbValue($row['Gol_darah']);
		$this->Agama_Mhs->setDbValue($row['Agama_Mhs']);
		$this->Alamat_Mhs->setDbValue($row['Alamat_Mhs']);
		$this->rt->setDbValue($row['rt']);
		$this->rw->setDbValue($row['rw']);
		$this->Kelurahan->setDbValue($row['Kelurahan']);
		$this->Kecamatan->setDbValue($row['Kecamatan']);
		$this->Kota_Mhs->setDbValue($row['Kota_Mhs']);
		$this->Provinsi_mhs->setDbValue($row['Provinsi_mhs']);
		$this->Kodepos_Mhs->setDbValue($row['Kodepos_Mhs']);
		$this->Tlp_Mhs->setDbValue($row['Tlp_Mhs']);
		$this->TlpRumah->setDbValue($row['TlpRumah']);
		$this->_Email->setDbValue($row['Email']);
		$this->Status_Akd->setDbValue($row['Status_Akd']);
		$this->ThMasuk->setDbValue($row['ThMasuk']);
		$this->tglmasuk->setDbValue($row['tglmasuk']);
		$this->Status_Masuk->setDbValue($row['Status_Masuk']);
		$this->Sem_Masuk->setDbValue($row['Sem_Masuk']);
		$this->TaMasuk->setDbValue($row['TaMasuk']);
		$this->PerMasuk->setDbValue($row['PerMasuk']);
		$this->Pendidikan_Akhir->setDbValue($row['Pendidikan_Akhir']);
		$this->Jurusan->setDbValue($row['Jurusan']);
		$this->Thn_Selesai->setDbValue($row['Thn_Selesai']);
		$this->Kota_Pdkk->setDbValue($row['Kota_Pdkk']);
		$this->propinsi->setDbValue($row['propinsi']);
		$this->NIMASAL->setDbValue($row['NIMASAL']);
		$this->KPTSASAL->setDbValue($row['KPTSASAL']);
		$this->JENASAL->setDbValue($row['JENASAL']);
		$this->PSASAL->setDbValue($row['PSASAL']);
		$this->TSKSDIAKUI->setDbValue($row['TSKSDIAKUI']);
		$this->NamaSekolahAsal->setDbValue($row['NamaSekolahAsal']);
		$this->AlamatSekolahAsal->setDbValue($row['AlamatSekolahAsal']);
		$this->Status->setDbValue($row['Status']);
		$this->Photo->Upload->DbValue = $row['Photo'];
		if (is_array($this->Photo->Upload->DbValue) || is_object($this->Photo->Upload->DbValue)) // Byte array
			$this->Photo->Upload->DbValue = BytesToString($this->Photo->Upload->DbValue);
		$this->Password->setDbValue($row['Password']);
		$this->Gelombang->setDbValue($row['Gelombang']);
		$this->JalurMasuk->setDbValue($row['JalurMasuk']);
		$this->Konsentrasi->setDbValue($row['Konsentrasi']);
		$this->NIK->setDbValue($row['NIK']);
		$this->NamaIbu->setDbValue($row['NamaIbu']);
		$this->BekerjaDi->setDbValue($row['BekerjaDi']);
		$this->Lama->setDbValue($row['Lama']);
		$this->AlamatPerusahaan->setDbValue($row['AlamatPerusahaan']);
		$this->TlpPerusahaan->setDbValue($row['TlpPerusahaan']);
		$this->Posisi->setDbValue($row['Posisi']);
		$this->Departemen->setDbValue($row['Departemen']);
		$this->IdUser->setDbValue($row['IdUser']);
		$this->TempID->setDbValue($row['TempID']);
		$this->xphoto->setDbValue($row['xphoto']);
		$this->profile->setDbValue($row['profile']);
		$this->id_agama->setDbValue($row['id_agama']);
		$this->id_negara->setDbValue($row['id_negara']);
		$this->id_wilayah->setDbValue($row['id_wilayah']);
		$this->id_jenis_tinggal->setDbValue($row['id_jenis_tinggal']);
		$this->id_alat_transportasi->setDbValue($row['id_alat_transportasi']);
		$this->no_kps->setDbValue($row['no_kps']);
		$this->penerima_kps->setDbValue($row['penerima_kps']);
		$this->id_kebutuhan_khusus_mahasiswa->setDbValue($row['id_kebutuhan_khusus_mahasiswa']);
		$this->nisn->setDbValue($row['nisn']);
		$this->iddesa->setDbValue($row['iddesa']);
		$this->MulaiKerja->setDbValue($row['MulaiKerja']);
		$this->IdKlsKerjasama->setDbValue($row['IdKlsKerjasama']);
		$this->IDBeasiswa->setDbValue($row['IDBeasiswa']);
		$this->tglKonversi->setDbValue($row['tglKonversi']);
		$this->NoSuratKonversi->setDbValue($row['NoSuratKonversi']);
		$this->Nopen->setDbValue($row['Nopen']);
		$this->id_feedmhs->setDbValue($row['id_feedmhs']);
		if (!isset($GLOBALS["Wli_DNS_grid"]))
			$GLOBALS["Wli_DNS_grid"] = new Wli_DNS_grid();
		$detailFilter = $GLOBALS["Wli_DNS"]->sqlDetailFilter_tblMHS();
		$detailFilter = str_replace("@Nim@", AdjustSql($this->Nim->DbValue, "DB"), $detailFilter);
		$GLOBALS["Wli_DNS"]->setCurrentMasterTable("tblMHS");
		$detailFilter = $GLOBALS["Wli_DNS"]->applyUserIDFilters($detailFilter);
		$this->Wli_DNS_Count = $GLOBALS["Wli_DNS"]->loadRecordCount($detailFilter);
		if (!isset($GLOBALS["Wali_IPS_grid"]))
			$GLOBALS["Wali_IPS_grid"] = new Wali_IPS_grid();
		$detailFilter = $GLOBALS["Wali_IPS"]->sqlDetailFilter_tblMHS();
		$detailFilter = str_replace("@Nim@", AdjustSql($this->Nim->DbValue, "DB"), $detailFilter);
		$GLOBALS["Wali_IPS"]->setCurrentMasterTable("tblMHS");
		$detailFilter = $GLOBALS["Wali_IPS"]->applyUserIDFilters($detailFilter);
		$this->Wali_IPS_Count = $GLOBALS["Wali_IPS"]->loadRecordCount($detailFilter);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['Nim'] = NULL;
		$row['Nama_Mhs'] = NULL;
		$row['Kode_jp'] = NULL;
		$row['Tmp_Lahir'] = NULL;
		$row['Tgl_Lahir'] = NULL;
		$row['Jenis_Kel'] = NULL;
		$row['Gol_darah'] = NULL;
		$row['Agama_Mhs'] = NULL;
		$row['Alamat_Mhs'] = NULL;
		$row['rt'] = NULL;
		$row['rw'] = NULL;
		$row['Kelurahan'] = NULL;
		$row['Kecamatan'] = NULL;
		$row['Kota_Mhs'] = NULL;
		$row['Provinsi_mhs'] = NULL;
		$row['Kodepos_Mhs'] = NULL;
		$row['Tlp_Mhs'] = NULL;
		$row['TlpRumah'] = NULL;
		$row['Email'] = NULL;
		$row['Status_Akd'] = NULL;
		$row['ThMasuk'] = NULL;
		$row['tglmasuk'] = NULL;
		$row['Status_Masuk'] = NULL;
		$row['Sem_Masuk'] = NULL;
		$row['TaMasuk'] = NULL;
		$row['PerMasuk'] = NULL;
		$row['Pendidikan_Akhir'] = NULL;
		$row['Jurusan'] = NULL;
		$row['Thn_Selesai'] = NULL;
		$row['Kota_Pdkk'] = NULL;
		$row['propinsi'] = NULL;
		$row['NIMASAL'] = NULL;
		$row['KPTSASAL'] = NULL;
		$row['JENASAL'] = NULL;
		$row['PSASAL'] = NULL;
		$row['TSKSDIAKUI'] = NULL;
		$row['NamaSekolahAsal'] = NULL;
		$row['AlamatSekolahAsal'] = NULL;
		$row['Status'] = NULL;
		$row['Photo'] = NULL;
		$row['Password'] = NULL;
		$row['Gelombang'] = NULL;
		$row['JalurMasuk'] = NULL;
		$row['Konsentrasi'] = NULL;
		$row['NIK'] = NULL;
		$row['NamaIbu'] = NULL;
		$row['BekerjaDi'] = NULL;
		$row['Lama'] = NULL;
		$row['AlamatPerusahaan'] = NULL;
		$row['TlpPerusahaan'] = NULL;
		$row['Posisi'] = NULL;
		$row['Departemen'] = NULL;
		$row['IdUser'] = NULL;
		$row['TempID'] = NULL;
		$row['xphoto'] = NULL;
		$row['profile'] = NULL;
		$row['id_agama'] = NULL;
		$row['id_negara'] = NULL;
		$row['id_wilayah'] = NULL;
		$row['id_jenis_tinggal'] = NULL;
		$row['id_alat_transportasi'] = NULL;
		$row['no_kps'] = NULL;
		$row['penerima_kps'] = NULL;
		$row['id_kebutuhan_khusus_mahasiswa'] = NULL;
		$row['nisn'] = NULL;
		$row['iddesa'] = NULL;
		$row['MulaiKerja'] = NULL;
		$row['IdKlsKerjasama'] = NULL;
		$row['IDBeasiswa'] = NULL;
		$row['tglKonversi'] = NULL;
		$row['NoSuratKonversi'] = NULL;
		$row['Nopen'] = NULL;
		$row['id_feedmhs'] = NULL;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("Nim")) != "")
			$this->Nim->OldValue = $this->getKey("Nim"); // Nim
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = $this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		$this->ViewUrl = $this->getViewUrl();
		$this->EditUrl = $this->getEditUrl();
		$this->InlineEditUrl = $this->getInlineEditUrl();
		$this->CopyUrl = $this->getCopyUrl();
		$this->InlineCopyUrl = $this->getInlineCopyUrl();
		$this->DeleteUrl = $this->getDeleteUrl();

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// Nim
		// Nama_Mhs
		// Kode_jp
		// Tmp_Lahir
		// Tgl_Lahir
		// Jenis_Kel
		// Gol_darah
		// Agama_Mhs
		// Alamat_Mhs
		// rt
		// rw
		// Kelurahan
		// Kecamatan
		// Kota_Mhs
		// Provinsi_mhs
		// Kodepos_Mhs
		// Tlp_Mhs
		// TlpRumah
		// Email
		// Status_Akd
		// ThMasuk
		// tglmasuk
		// Status_Masuk
		// Sem_Masuk
		// TaMasuk
		// PerMasuk
		// Pendidikan_Akhir
		// Jurusan
		// Thn_Selesai
		// Kota_Pdkk
		// propinsi
		// NIMASAL
		// KPTSASAL
		// JENASAL
		// PSASAL
		// TSKSDIAKUI
		// NamaSekolahAsal
		// AlamatSekolahAsal
		// Status
		// Photo
		// Password
		// Gelombang
		// JalurMasuk
		// Konsentrasi
		// NIK
		// NamaIbu
		// BekerjaDi
		// Lama
		// AlamatPerusahaan
		// TlpPerusahaan
		// Posisi
		// Departemen
		// IdUser
		// TempID
		// xphoto
		// profile
		// id_agama
		// id_negara
		// id_wilayah
		// id_jenis_tinggal
		// id_alat_transportasi
		// no_kps
		// penerima_kps
		// id_kebutuhan_khusus_mahasiswa
		// nisn
		// iddesa
		// MulaiKerja
		// IdKlsKerjasama
		// IDBeasiswa
		// tglKonversi
		// NoSuratKonversi
		// Nopen
		// id_feedmhs

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// Nim
			$this->Nim->ViewValue = $this->Nim->CurrentValue;
			$this->Nim->ViewCustomAttributes = "";

			// Nama_Mhs
			$this->Nama_Mhs->ViewValue = $this->Nama_Mhs->CurrentValue;
			$this->Nama_Mhs->ViewCustomAttributes = "";

			// Kode_jp
			$curVal = strval($this->Kode_jp->CurrentValue);
			if ($curVal != "") {
				$this->Kode_jp->ViewValue = $this->Kode_jp->lookupCacheOption($curVal);
				if ($this->Kode_jp->ViewValue === NULL) { // Lookup from database
					$filterWrk = "[Kode_Jp]" . SearchString("=", $curVal, DATATYPE_STRING, "");
					$sqlWrk = $this->Kode_jp->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = [];
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$arwrk[3] = $rswrk->fields('df3');
						$this->Kode_jp->ViewValue = $this->Kode_jp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->Kode_jp->ViewValue = $this->Kode_jp->CurrentValue;
					}
				}
			} else {
				$this->Kode_jp->ViewValue = NULL;
			}
			$this->Kode_jp->ViewCustomAttributes = "";

			// Tmp_Lahir
			$this->Tmp_Lahir->ViewValue = $this->Tmp_Lahir->CurrentValue;
			$this->Tmp_Lahir->ViewCustomAttributes = "";

			// Tgl_Lahir
			$this->Tgl_Lahir->ViewValue = $this->Tgl_Lahir->CurrentValue;
			$this->Tgl_Lahir->ViewValue = FormatDateTime($this->Tgl_Lahir->ViewValue, 0);
			$this->Tgl_Lahir->ViewCustomAttributes = "";

			// Jenis_Kel
			if (strval($this->Jenis_Kel->CurrentValue) != "") {
				$this->Jenis_Kel->ViewValue = $this->Jenis_Kel->optionCaption($this->Jenis_Kel->CurrentValue);
			} else {
				$this->Jenis_Kel->ViewValue = NULL;
			}
			$this->Jenis_Kel->ViewCustomAttributes = "";

			// Gol_darah
			$this->Gol_darah->ViewValue = $this->Gol_darah->CurrentValue;
			$this->Gol_darah->ViewCustomAttributes = "";

			// Agama_Mhs
			$this->Agama_Mhs->ViewValue = $this->Agama_Mhs->CurrentValue;
			$this->Agama_Mhs->ViewCustomAttributes = "";

			// Alamat_Mhs
			$this->Alamat_Mhs->ViewValue = $this->Alamat_Mhs->CurrentValue;
			$this->Alamat_Mhs->ViewCustomAttributes = "";

			// rt
			$this->rt->ViewValue = $this->rt->CurrentValue;
			$this->rt->ViewCustomAttributes = "";

			// rw
			$this->rw->ViewValue = $this->rw->CurrentValue;
			$this->rw->ViewCustomAttributes = "";

			// Kelurahan
			$this->Kelurahan->ViewValue = $this->Kelurahan->CurrentValue;
			$this->Kelurahan->ViewCustomAttributes = "";

			// Kecamatan
			$this->Kecamatan->ViewValue = $this->Kecamatan->CurrentValue;
			$this->Kecamatan->ViewCustomAttributes = "";

			// Kota_Mhs
			$this->Kota_Mhs->ViewValue = $this->Kota_Mhs->CurrentValue;
			$this->Kota_Mhs->ViewCustomAttributes = "";

			// Provinsi_mhs
			$this->Provinsi_mhs->ViewValue = $this->Provinsi_mhs->CurrentValue;
			$this->Provinsi_mhs->ViewCustomAttributes = "";

			// Kodepos_Mhs
			$this->Kodepos_Mhs->ViewValue = $this->Kodepos_Mhs->CurrentValue;
			$this->Kodepos_Mhs->ViewCustomAttributes = "";

			// Tlp_Mhs
			$this->Tlp_Mhs->ViewValue = $this->Tlp_Mhs->CurrentValue;
			$this->Tlp_Mhs->ViewCustomAttributes = "";

			// TlpRumah
			$this->TlpRumah->ViewValue = $this->TlpRumah->CurrentValue;
			$this->TlpRumah->ViewCustomAttributes = "";

			// Email
			$this->_Email->ViewValue = $this->_Email->CurrentValue;
			$this->_Email->ViewCustomAttributes = "";

			// Status_Akd
			$curVal = strval($this->Status_Akd->CurrentValue);
			if ($curVal != "") {
				$this->Status_Akd->ViewValue = $this->Status_Akd->lookupCacheOption($curVal);
				if ($this->Status_Akd->ViewValue === NULL) { // Lookup from database
					$filterWrk = "[Kelas]" . SearchString("=", $curVal, DATATYPE_STRING, "");
					$sqlWrk = $this->Status_Akd->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = [];
						$arwrk[1] = $rswrk->fields('df');
						$this->Status_Akd->ViewValue = $this->Status_Akd->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->Status_Akd->ViewValue = $this->Status_Akd->CurrentValue;
					}
				}
			} else {
				$this->Status_Akd->ViewValue = NULL;
			}
			$this->Status_Akd->ViewCustomAttributes = "";

			// ThMasuk
			$this->ThMasuk->ViewValue = $this->ThMasuk->CurrentValue;
			$this->ThMasuk->ViewCustomAttributes = "";

			// tglmasuk
			$this->tglmasuk->ViewValue = $this->tglmasuk->CurrentValue;
			$this->tglmasuk->ViewValue = FormatDateTime($this->tglmasuk->ViewValue, 7);
			$this->tglmasuk->ViewCustomAttributes = "";

			// Status_Masuk
			if (strval($this->Status_Masuk->CurrentValue) != "") {
				$this->Status_Masuk->ViewValue = $this->Status_Masuk->optionCaption($this->Status_Masuk->CurrentValue);
			} else {
				$this->Status_Masuk->ViewValue = NULL;
			}
			$this->Status_Masuk->ViewCustomAttributes = "";

			// Sem_Masuk
			$this->Sem_Masuk->ViewValue = $this->Sem_Masuk->CurrentValue;
			$this->Sem_Masuk->ViewCustomAttributes = "";

			// TaMasuk
			$curVal = strval($this->TaMasuk->CurrentValue);
			if ($curVal != "") {
				$this->TaMasuk->ViewValue = $this->TaMasuk->lookupCacheOption($curVal);
				if ($this->TaMasuk->ViewValue === NULL) { // Lookup from database
					$filterWrk = "[TA]" . SearchString("=", $curVal, DATATYPE_STRING, "");
					$sqlWrk = $this->TaMasuk->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = [];
						$arwrk[1] = $rswrk->fields('df');
						$this->TaMasuk->ViewValue = $this->TaMasuk->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->TaMasuk->ViewValue = $this->TaMasuk->CurrentValue;
					}
				}
			} else {
				$this->TaMasuk->ViewValue = NULL;
			}
			$this->TaMasuk->ViewCustomAttributes = "";

			// PerMasuk
			if (strval($this->PerMasuk->CurrentValue) != "") {
				$this->PerMasuk->ViewValue = $this->PerMasuk->optionCaption($this->PerMasuk->CurrentValue);
			} else {
				$this->PerMasuk->ViewValue = NULL;
			}
			$this->PerMasuk->ViewCustomAttributes = "";

			// Pendidikan_Akhir
			$this->Pendidikan_Akhir->ViewValue = $this->Pendidikan_Akhir->CurrentValue;
			$this->Pendidikan_Akhir->ViewCustomAttributes = "";

			// Jurusan
			$this->Jurusan->ViewValue = $this->Jurusan->CurrentValue;
			$this->Jurusan->ViewCustomAttributes = "";

			// Thn_Selesai
			$this->Thn_Selesai->ViewValue = $this->Thn_Selesai->CurrentValue;
			$this->Thn_Selesai->ViewCustomAttributes = "";

			// Kota_Pdkk
			$this->Kota_Pdkk->ViewValue = $this->Kota_Pdkk->CurrentValue;
			$this->Kota_Pdkk->ViewCustomAttributes = "";

			// propinsi
			$this->propinsi->ViewValue = $this->propinsi->CurrentValue;
			$this->propinsi->ViewCustomAttributes = "";

			// NIMASAL
			$this->NIMASAL->ViewValue = $this->NIMASAL->CurrentValue;
			$this->NIMASAL->ViewCustomAttributes = "";

			// KPTSASAL
			$this->KPTSASAL->ViewValue = $this->KPTSASAL->CurrentValue;
			$this->KPTSASAL->ViewCustomAttributes = "";

			// JENASAL
			$this->JENASAL->ViewValue = $this->JENASAL->CurrentValue;
			$this->JENASAL->ViewCustomAttributes = "";

			// PSASAL
			$this->PSASAL->ViewValue = $this->PSASAL->CurrentValue;
			$this->PSASAL->ViewCustomAttributes = "";

			// TSKSDIAKUI
			$this->TSKSDIAKUI->ViewValue = $this->TSKSDIAKUI->CurrentValue;
			$this->TSKSDIAKUI->ViewValue = FormatNumber($this->TSKSDIAKUI->ViewValue, 0, -2, -2, -2);
			$this->TSKSDIAKUI->ViewCustomAttributes = "";

			// NamaSekolahAsal
			$this->NamaSekolahAsal->ViewValue = $this->NamaSekolahAsal->CurrentValue;
			$this->NamaSekolahAsal->ViewCustomAttributes = "";

			// AlamatSekolahAsal
			$this->AlamatSekolahAsal->ViewValue = $this->AlamatSekolahAsal->CurrentValue;
			$this->AlamatSekolahAsal->ViewCustomAttributes = "";

			// Status
			if (strval($this->Status->CurrentValue) != "") {
				$this->Status->ViewValue = $this->Status->optionCaption($this->Status->CurrentValue);
			} else {
				$this->Status->ViewValue = NULL;
			}
			$this->Status->ViewCustomAttributes = "";

			// Password
			$this->Password->ViewValue = $this->Password->CurrentValue;
			$this->Password->ViewCustomAttributes = "";

			// Gelombang
			$this->Gelombang->ViewValue = $this->Gelombang->CurrentValue;
			$this->Gelombang->ViewCustomAttributes = "";

			// JalurMasuk
			$this->JalurMasuk->ViewValue = $this->JalurMasuk->CurrentValue;
			$this->JalurMasuk->ViewCustomAttributes = "";

			// Konsentrasi
			$this->Konsentrasi->ViewValue = $this->Konsentrasi->CurrentValue;
			$this->Konsentrasi->ViewCustomAttributes = "";

			// NIK
			$this->NIK->ViewValue = $this->NIK->CurrentValue;
			$this->NIK->ViewCustomAttributes = "";

			// NamaIbu
			$this->NamaIbu->ViewValue = $this->NamaIbu->CurrentValue;
			$this->NamaIbu->ViewCustomAttributes = "";

			// BekerjaDi
			$this->BekerjaDi->ViewValue = $this->BekerjaDi->CurrentValue;
			$this->BekerjaDi->ViewCustomAttributes = "";

			// Lama
			$this->Lama->ViewValue = $this->Lama->CurrentValue;
			$this->Lama->ViewCustomAttributes = "";

			// AlamatPerusahaan
			$this->AlamatPerusahaan->ViewValue = $this->AlamatPerusahaan->CurrentValue;
			$this->AlamatPerusahaan->ViewCustomAttributes = "";

			// TlpPerusahaan
			$this->TlpPerusahaan->ViewValue = $this->TlpPerusahaan->CurrentValue;
			$this->TlpPerusahaan->ViewCustomAttributes = "";

			// Posisi
			$this->Posisi->ViewValue = $this->Posisi->CurrentValue;
			$this->Posisi->ViewCustomAttributes = "";

			// Departemen
			$this->Departemen->ViewValue = $this->Departemen->CurrentValue;
			$this->Departemen->ViewCustomAttributes = "";

			// IdUser
			$this->IdUser->ViewValue = $this->IdUser->CurrentValue;
			$this->IdUser->ViewCustomAttributes = "";

			// TempID
			$this->TempID->ViewValue = $this->TempID->CurrentValue;
			$this->TempID->ViewValue = FormatNumber($this->TempID->ViewValue, 0, -2, -2, -2);
			$this->TempID->ViewCustomAttributes = "";

			// xphoto
			$this->xphoto->ViewValue = $this->xphoto->CurrentValue;
			$this->xphoto->ViewCustomAttributes = "";

			// profile
			$this->profile->ViewValue = $this->profile->CurrentValue;
			$this->profile->ViewCustomAttributes = "";

			// id_agama
			$this->id_agama->ViewValue = $this->id_agama->CurrentValue;
			$this->id_agama->ViewValue = FormatNumber($this->id_agama->ViewValue, 0, -2, -2, -2);
			$this->id_agama->ViewCustomAttributes = "";

			// id_negara
			$this->id_negara->ViewValue = $this->id_negara->CurrentValue;
			$this->id_negara->ViewCustomAttributes = "";

			// id_wilayah
			$this->id_wilayah->ViewValue = $this->id_wilayah->CurrentValue;
			$this->id_wilayah->ViewCustomAttributes = "";

			// id_jenis_tinggal
			$this->id_jenis_tinggal->ViewValue = $this->id_jenis_tinggal->CurrentValue;
			$this->id_jenis_tinggal->ViewValue = FormatNumber($this->id_jenis_tinggal->ViewValue, 0, -2, -2, -2);
			$this->id_jenis_tinggal->ViewCustomAttributes = "";

			// id_alat_transportasi
			$this->id_alat_transportasi->ViewValue = $this->id_alat_transportasi->CurrentValue;
			$this->id_alat_transportasi->ViewValue = FormatNumber($this->id_alat_transportasi->ViewValue, 0, -2, -2, -2);
			$this->id_alat_transportasi->ViewCustomAttributes = "";

			// no_kps
			$this->no_kps->ViewValue = $this->no_kps->CurrentValue;
			$this->no_kps->ViewCustomAttributes = "";

			// penerima_kps
			$this->penerima_kps->ViewValue = $this->penerima_kps->CurrentValue;
			$this->penerima_kps->ViewValue = FormatNumber($this->penerima_kps->ViewValue, 0, -2, -2, -2);
			$this->penerima_kps->ViewCustomAttributes = "";

			// id_kebutuhan_khusus_mahasiswa
			$this->id_kebutuhan_khusus_mahasiswa->ViewValue = $this->id_kebutuhan_khusus_mahasiswa->CurrentValue;
			$this->id_kebutuhan_khusus_mahasiswa->ViewValue = FormatNumber($this->id_kebutuhan_khusus_mahasiswa->ViewValue, 0, -2, -2, -2);
			$this->id_kebutuhan_khusus_mahasiswa->ViewCustomAttributes = "";

			// nisn
			$this->nisn->ViewValue = $this->nisn->CurrentValue;
			$this->nisn->ViewCustomAttributes = "";

			// iddesa
			$this->iddesa->ViewValue = $this->iddesa->CurrentValue;
			$this->iddesa->ViewValue = FormatNumber($this->iddesa->ViewValue, 0, -2, -2, -2);
			$this->iddesa->ViewCustomAttributes = "";

			// MulaiKerja
			$this->MulaiKerja->ViewValue = $this->MulaiKerja->CurrentValue;
			$this->MulaiKerja->ViewValue = FormatDateTime($this->MulaiKerja->ViewValue, 0);
			$this->MulaiKerja->ViewCustomAttributes = "";

			// IdKlsKerjasama
			$this->IdKlsKerjasama->ViewValue = $this->IdKlsKerjasama->CurrentValue;
			$this->IdKlsKerjasama->ViewValue = FormatNumber($this->IdKlsKerjasama->ViewValue, 0, -2, -2, -2);
			$this->IdKlsKerjasama->ViewCustomAttributes = "";

			// IDBeasiswa
			$this->IDBeasiswa->ViewValue = $this->IDBeasiswa->CurrentValue;
			$this->IDBeasiswa->ViewValue = FormatNumber($this->IDBeasiswa->ViewValue, 0, -2, -2, -2);
			$this->IDBeasiswa->ViewCustomAttributes = "";

			// tglKonversi
			$this->tglKonversi->ViewValue = $this->tglKonversi->CurrentValue;
			$this->tglKonversi->ViewValue = FormatDateTime($this->tglKonversi->ViewValue, 0);
			$this->tglKonversi->ViewCustomAttributes = "";

			// NoSuratKonversi
			$this->NoSuratKonversi->ViewValue = $this->NoSuratKonversi->CurrentValue;
			$this->NoSuratKonversi->ViewCustomAttributes = "";

			// Nopen
			$this->Nopen->ViewValue = $this->Nopen->CurrentValue;
			$this->Nopen->ViewCustomAttributes = "";

			// id_feedmhs
			$this->id_feedmhs->ViewValue = $this->id_feedmhs->CurrentValue;
			$this->id_feedmhs->ViewCustomAttributes = "";

			// Nim
			$this->Nim->LinkCustomAttributes = "";
			$this->Nim->HrefValue = "";
			$this->Nim->TooltipValue = "";

			// Nama_Mhs
			$this->Nama_Mhs->LinkCustomAttributes = "";
			$this->Nama_Mhs->HrefValue = "";
			$this->Nama_Mhs->TooltipValue = "";

			// Kode_jp
			$this->Kode_jp->LinkCustomAttributes = "";
			$this->Kode_jp->HrefValue = "";
			$this->Kode_jp->TooltipValue = "";

			// Jenis_Kel
			$this->Jenis_Kel->LinkCustomAttributes = "";
			$this->Jenis_Kel->HrefValue = "";
			$this->Jenis_Kel->TooltipValue = "";

			// Tlp_Mhs
			$this->Tlp_Mhs->LinkCustomAttributes = "";
			if (!EmptyValue($this->Tlp_Mhs->CurrentValue)) {
				$this->Tlp_Mhs->HrefValue = "https://wa.me/62" . $this->Tlp_Mhs->CurrentValue; // Add prefix/suffix
				$this->Tlp_Mhs->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport())
					$this->Tlp_Mhs->HrefValue = FullUrl($this->Tlp_Mhs->HrefValue, "href");
			} else {
				$this->Tlp_Mhs->HrefValue = "";
			}
			$this->Tlp_Mhs->TooltipValue = "";

			// Status_Akd
			$this->Status_Akd->LinkCustomAttributes = "";
			$this->Status_Akd->HrefValue = "";
			$this->Status_Akd->TooltipValue = "";

			// Status_Masuk
			$this->Status_Masuk->LinkCustomAttributes = "";
			$this->Status_Masuk->HrefValue = "";
			$this->Status_Masuk->TooltipValue = "";

			// TaMasuk
			$this->TaMasuk->LinkCustomAttributes = "";
			$this->TaMasuk->HrefValue = "";
			$this->TaMasuk->TooltipValue = "";

			// PerMasuk
			$this->PerMasuk->LinkCustomAttributes = "";
			$this->PerMasuk->HrefValue = "";
			$this->PerMasuk->TooltipValue = "";

			// Status
			$this->Status->LinkCustomAttributes = "";
			$this->Status->HrefValue = "";
			$this->Status->TooltipValue = "";

			// Nopen
			$this->Nopen->LinkCustomAttributes = "";
			$this->Nopen->HrefValue = "";
			$this->Nopen->TooltipValue = "";

			// id_feedmhs
			$this->id_feedmhs->LinkCustomAttributes = "";
			$this->id_feedmhs->HrefValue = "";
			$this->id_feedmhs->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_SEARCH) { // Search row

			// Nim
			$this->Nim->EditAttrs["class"] = "form-control";
			$this->Nim->EditCustomAttributes = "";
			if (!$this->Nim->Raw)
				$this->Nim->AdvancedSearch->SearchValue = HtmlDecode($this->Nim->AdvancedSearch->SearchValue);
			$this->Nim->EditValue = HtmlEncode($this->Nim->AdvancedSearch->SearchValue);
			$this->Nim->PlaceHolder = RemoveHtml($this->Nim->caption());

			// Nama_Mhs
			$this->Nama_Mhs->EditAttrs["class"] = "form-control";
			$this->Nama_Mhs->EditCustomAttributes = "";
			if (!$this->Nama_Mhs->Raw)
				$this->Nama_Mhs->AdvancedSearch->SearchValue = HtmlDecode($this->Nama_Mhs->AdvancedSearch->SearchValue);
			$this->Nama_Mhs->EditValue = HtmlEncode($this->Nama_Mhs->AdvancedSearch->SearchValue);
			$this->Nama_Mhs->PlaceHolder = RemoveHtml($this->Nama_Mhs->caption());

			// Kode_jp
			$this->Kode_jp->EditAttrs["class"] = "form-control";
			$this->Kode_jp->EditCustomAttributes = "";
			$curVal = trim(strval($this->Kode_jp->AdvancedSearch->SearchValue));
			if ($curVal != "")
				$this->Kode_jp->AdvancedSearch->ViewValue = $this->Kode_jp->lookupCacheOption($curVal);
			else
				$this->Kode_jp->AdvancedSearch->ViewValue = $this->Kode_jp->Lookup !== NULL && is_array($this->Kode_jp->Lookup->Options) ? $curVal : NULL;
			if ($this->Kode_jp->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->Kode_jp->EditValue = array_values($this->Kode_jp->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "[Kode_Jp]" . SearchString("=", $this->Kode_jp->AdvancedSearch->SearchValue, DATATYPE_STRING, "");
				}
				$sqlWrk = $this->Kode_jp->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = $rswrk ? $rswrk->getRows() : [];
				if ($rswrk)
					$rswrk->close();
				$this->Kode_jp->EditValue = $arwrk;
			}

			// Jenis_Kel
			$this->Jenis_Kel->EditAttrs["class"] = "form-control";
			$this->Jenis_Kel->EditCustomAttributes = "";
			$this->Jenis_Kel->EditValue = $this->Jenis_Kel->options(TRUE);

			// Tlp_Mhs
			$this->Tlp_Mhs->EditAttrs["class"] = "form-control";
			$this->Tlp_Mhs->EditCustomAttributes = "";
			if (!$this->Tlp_Mhs->Raw)
				$this->Tlp_Mhs->AdvancedSearch->SearchValue = HtmlDecode($this->Tlp_Mhs->AdvancedSearch->SearchValue);
			$this->Tlp_Mhs->EditValue = HtmlEncode($this->Tlp_Mhs->AdvancedSearch->SearchValue);
			$this->Tlp_Mhs->PlaceHolder = RemoveHtml($this->Tlp_Mhs->caption());

			// Status_Akd
			$this->Status_Akd->EditAttrs["class"] = "form-control";
			$this->Status_Akd->EditCustomAttributes = "";
			$curVal = trim(strval($this->Status_Akd->AdvancedSearch->SearchValue));
			if ($curVal != "")
				$this->Status_Akd->AdvancedSearch->ViewValue = $this->Status_Akd->lookupCacheOption($curVal);
			else
				$this->Status_Akd->AdvancedSearch->ViewValue = $this->Status_Akd->Lookup !== NULL && is_array($this->Status_Akd->Lookup->Options) ? $curVal : NULL;
			if ($this->Status_Akd->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->Status_Akd->EditValue = array_values($this->Status_Akd->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "[Kelas]" . SearchString("=", $this->Status_Akd->AdvancedSearch->SearchValue, DATATYPE_STRING, "");
				}
				$sqlWrk = $this->Status_Akd->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = $rswrk ? $rswrk->getRows() : [];
				if ($rswrk)
					$rswrk->close();
				$this->Status_Akd->EditValue = $arwrk;
			}

			// Status_Masuk
			$this->Status_Masuk->EditAttrs["class"] = "form-control";
			$this->Status_Masuk->EditCustomAttributes = "";
			$this->Status_Masuk->EditValue = $this->Status_Masuk->options(TRUE);

			// TaMasuk
			$this->TaMasuk->EditAttrs["class"] = "form-control";
			$this->TaMasuk->EditCustomAttributes = "";
			$curVal = trim(strval($this->TaMasuk->AdvancedSearch->SearchValue));
			if ($curVal != "")
				$this->TaMasuk->AdvancedSearch->ViewValue = $this->TaMasuk->lookupCacheOption($curVal);
			else
				$this->TaMasuk->AdvancedSearch->ViewValue = $this->TaMasuk->Lookup !== NULL && is_array($this->TaMasuk->Lookup->Options) ? $curVal : NULL;
			if ($this->TaMasuk->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->TaMasuk->EditValue = array_values($this->TaMasuk->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "[TA]" . SearchString("=", $this->TaMasuk->AdvancedSearch->SearchValue, DATATYPE_STRING, "");
				}
				$sqlWrk = $this->TaMasuk->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = $rswrk ? $rswrk->getRows() : [];
				if ($rswrk)
					$rswrk->close();
				$this->TaMasuk->EditValue = $arwrk;
			}

			// PerMasuk
			$this->PerMasuk->EditAttrs["class"] = "form-control";
			$this->PerMasuk->EditCustomAttributes = "";
			$this->PerMasuk->EditValue = $this->PerMasuk->options(TRUE);

			// Status
			$this->Status->EditAttrs["class"] = "form-control";
			$this->Status->EditCustomAttributes = "";
			$this->Status->EditValue = $this->Status->options(TRUE);

			// Nopen
			$this->Nopen->EditAttrs["class"] = "form-control";
			$this->Nopen->EditCustomAttributes = "";
			$this->Nopen->EditValue = HtmlEncode($this->Nopen->AdvancedSearch->SearchValue);
			$this->Nopen->PlaceHolder = RemoveHtml($this->Nopen->caption());

			// id_feedmhs
			$this->id_feedmhs->EditAttrs["class"] = "form-control";
			$this->id_feedmhs->EditCustomAttributes = "";
			if (!$this->id_feedmhs->Raw)
				$this->id_feedmhs->AdvancedSearch->SearchValue = HtmlDecode($this->id_feedmhs->AdvancedSearch->SearchValue);
			$this->id_feedmhs->EditValue = HtmlEncode($this->id_feedmhs->AdvancedSearch->SearchValue);
			$this->id_feedmhs->PlaceHolder = RemoveHtml($this->id_feedmhs->caption());
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType != ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate search
	protected function validateSearch()
	{
		global $SearchError;

		// Initialize
		$SearchError = "";

		// Check if validation required
		if (!Config("SERVER_VALIDATE"))
			return TRUE;

		// Return validate result
		$validateSearch = ($SearchError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateSearch = $validateSearch && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError != "") {
			AddMessage($SearchError, $formCustomError);
		}
		return $validateSearch;
	}

	// Load advanced search
	public function loadAdvancedSearch()
	{
		$this->Nim->AdvancedSearch->load();
		$this->Nama_Mhs->AdvancedSearch->load();
		$this->Kode_jp->AdvancedSearch->load();
		$this->Tmp_Lahir->AdvancedSearch->load();
		$this->Tgl_Lahir->AdvancedSearch->load();
		$this->Jenis_Kel->AdvancedSearch->load();
		$this->Gol_darah->AdvancedSearch->load();
		$this->Agama_Mhs->AdvancedSearch->load();
		$this->Alamat_Mhs->AdvancedSearch->load();
		$this->rt->AdvancedSearch->load();
		$this->rw->AdvancedSearch->load();
		$this->Kelurahan->AdvancedSearch->load();
		$this->Kecamatan->AdvancedSearch->load();
		$this->Kota_Mhs->AdvancedSearch->load();
		$this->Provinsi_mhs->AdvancedSearch->load();
		$this->Kodepos_Mhs->AdvancedSearch->load();
		$this->Tlp_Mhs->AdvancedSearch->load();
		$this->TlpRumah->AdvancedSearch->load();
		$this->_Email->AdvancedSearch->load();
		$this->Status_Akd->AdvancedSearch->load();
		$this->ThMasuk->AdvancedSearch->load();
		$this->tglmasuk->AdvancedSearch->load();
		$this->Status_Masuk->AdvancedSearch->load();
		$this->Sem_Masuk->AdvancedSearch->load();
		$this->TaMasuk->AdvancedSearch->load();
		$this->PerMasuk->AdvancedSearch->load();
		$this->Pendidikan_Akhir->AdvancedSearch->load();
		$this->Jurusan->AdvancedSearch->load();
		$this->Thn_Selesai->AdvancedSearch->load();
		$this->Kota_Pdkk->AdvancedSearch->load();
		$this->propinsi->AdvancedSearch->load();
		$this->NIMASAL->AdvancedSearch->load();
		$this->KPTSASAL->AdvancedSearch->load();
		$this->JENASAL->AdvancedSearch->load();
		$this->PSASAL->AdvancedSearch->load();
		$this->TSKSDIAKUI->AdvancedSearch->load();
		$this->NamaSekolahAsal->AdvancedSearch->load();
		$this->AlamatSekolahAsal->AdvancedSearch->load();
		$this->Status->AdvancedSearch->load();
		$this->Password->AdvancedSearch->load();
		$this->Gelombang->AdvancedSearch->load();
		$this->JalurMasuk->AdvancedSearch->load();
		$this->Konsentrasi->AdvancedSearch->load();
		$this->NIK->AdvancedSearch->load();
		$this->NamaIbu->AdvancedSearch->load();
		$this->BekerjaDi->AdvancedSearch->load();
		$this->Lama->AdvancedSearch->load();
		$this->AlamatPerusahaan->AdvancedSearch->load();
		$this->TlpPerusahaan->AdvancedSearch->load();
		$this->Posisi->AdvancedSearch->load();
		$this->Departemen->AdvancedSearch->load();
		$this->IdUser->AdvancedSearch->load();
		$this->TempID->AdvancedSearch->load();
		$this->xphoto->AdvancedSearch->load();
		$this->profile->AdvancedSearch->load();
		$this->id_agama->AdvancedSearch->load();
		$this->id_negara->AdvancedSearch->load();
		$this->id_wilayah->AdvancedSearch->load();
		$this->id_jenis_tinggal->AdvancedSearch->load();
		$this->id_alat_transportasi->AdvancedSearch->load();
		$this->no_kps->AdvancedSearch->load();
		$this->penerima_kps->AdvancedSearch->load();
		$this->id_kebutuhan_khusus_mahasiswa->AdvancedSearch->load();
		$this->nisn->AdvancedSearch->load();
		$this->iddesa->AdvancedSearch->load();
		$this->MulaiKerja->AdvancedSearch->load();
		$this->IdKlsKerjasama->AdvancedSearch->load();
		$this->IDBeasiswa->AdvancedSearch->load();
		$this->tglKonversi->AdvancedSearch->load();
		$this->NoSuratKonversi->AdvancedSearch->load();
		$this->Nopen->AdvancedSearch->load();
		$this->id_feedmhs->AdvancedSearch->load();
	}

	// Get export HTML tag
	protected function getExportTag($type, $custom = FALSE)
	{
		global $Language;
		if (SameText($type, "excel")) {
			if ($custom)
				return "<a href=\"#\" class=\"ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" onclick=\"return ew.export(document.ftblMHSlist, '" . $this->ExportExcelUrl . "', 'excel', true);\">" . $Language->phrase("ExportToExcel") . "</a>";
			else
				return "<a href=\"" . $this->ExportExcelUrl . "\" class=\"ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\">" . $Language->phrase("ExportToExcel") . "</a>";
		} elseif (SameText($type, "word")) {
			if ($custom)
				return "<a href=\"#\" class=\"ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" onclick=\"return ew.export(document.ftblMHSlist, '" . $this->ExportWordUrl . "', 'word', true);\">" . $Language->phrase("ExportToWord") . "</a>";
			else
				return "<a href=\"" . $this->ExportWordUrl . "\" class=\"ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\">" . $Language->phrase("ExportToWord") . "</a>";
		} elseif (SameText($type, "pdf")) {
			if ($custom)
				return "<a href=\"#\" class=\"ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" onclick=\"return ew.export(document.ftblMHSlist, '" . $this->ExportPdfUrl . "', 'pdf', true);\">" . $Language->phrase("ExportToPDF") . "</a>";
			else
				return "<a href=\"" . $this->ExportPdfUrl . "\" class=\"ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\">" . $Language->phrase("ExportToPDF") . "</a>";
		} elseif (SameText($type, "html")) {
			return "<a href=\"" . $this->ExportHtmlUrl . "\" class=\"ew-export-link ew-html\" title=\"" . HtmlEncode($Language->phrase("ExportToHtmlText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToHtmlText")) . "\">" . $Language->phrase("ExportToHtml") . "</a>";
		} elseif (SameText($type, "xml")) {
			return "<a href=\"" . $this->ExportXmlUrl . "\" class=\"ew-export-link ew-xml\" title=\"" . HtmlEncode($Language->phrase("ExportToXmlText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToXmlText")) . "\">" . $Language->phrase("ExportToXml") . "</a>";
		} elseif (SameText($type, "csv")) {
			return "<a href=\"" . $this->ExportCsvUrl . "\" class=\"ew-export-link ew-csv\" title=\"" . HtmlEncode($Language->phrase("ExportToCsvText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToCsvText")) . "\">" . $Language->phrase("ExportToCsv") . "</a>";
		} elseif (SameText($type, "email")) {
			$url = $custom ? ",url:'" . $this->pageUrl() . "export=email&amp;custom=1'" : "";
			return '<button id="emf_tblMHS" class="ew-export-link ew-email" title="' . $Language->phrase("ExportToEmailText") . '" data-caption="' . $Language->phrase("ExportToEmailText") . '" onclick="ew.emailDialogShow({lnk:\'emf_tblMHS\', hdr:ew.language.phrase(\'ExportToEmailText\'), f:document.ftblMHSlist, sel:false' . $url . '});">' . $Language->phrase("ExportToEmail") . '</button>';
		} elseif (SameText($type, "print")) {
			return "<a href=\"" . $this->ExportPrintUrl . "\" class=\"ew-export-link ew-print\" title=\"" . HtmlEncode($Language->phrase("PrinterFriendlyText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("PrinterFriendlyText")) . "\">" . $Language->phrase("PrinterFriendly") . "</a>";
		}
	}

	// Set up export options
	protected function setupExportOptions()
	{
		global $Language;

		// Printer friendly
		$item = &$this->ExportOptions->add("print");
		$item->Body = $this->getExportTag("print");
		$item->Visible = TRUE;

		// Export to Excel
		$item = &$this->ExportOptions->add("excel");
		$item->Body = $this->getExportTag("excel");
		$item->Visible = TRUE;

		// Export to Word
		$item = &$this->ExportOptions->add("word");
		$item->Body = $this->getExportTag("word");
		$item->Visible = FALSE;

		// Export to Html
		$item = &$this->ExportOptions->add("html");
		$item->Body = $this->getExportTag("html");
		$item->Visible = FALSE;

		// Export to Xml
		$item = &$this->ExportOptions->add("xml");
		$item->Body = $this->getExportTag("xml");
		$item->Visible = FALSE;

		// Export to Csv
		$item = &$this->ExportOptions->add("csv");
		$item->Body = $this->getExportTag("csv");
		$item->Visible = FALSE;

		// Export to Pdf
		$item = &$this->ExportOptions->add("pdf");
		$item->Body = $this->getExportTag("pdf");
		$item->Visible = FALSE;

		// Export to Email
		$item = &$this->ExportOptions->add("email");
		$item->Body = $this->getExportTag("email");
		$item->Visible = FALSE;

		// Drop down button for export
		$this->ExportOptions->UseButtonGroup = TRUE;
		$this->ExportOptions->UseDropDownButton = FALSE;
		if ($this->ExportOptions->UseButtonGroup && IsMobile())
			$this->ExportOptions->UseDropDownButton = TRUE;
		$this->ExportOptions->DropDownButtonPhrase = $Language->phrase("ButtonExport");

		// Add group option item
		$item = &$this->ExportOptions->add($this->ExportOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	// Set up search options
	protected function setupSearchOptions()
	{
		global $Language;
		$this->SearchOptions = new ListOptions("div");
		$this->SearchOptions->TagClassName = "ew-search-option";

		// Search button
		$item = &$this->SearchOptions->add("searchtoggle");
		$searchToggleClass = ($this->SearchWhere != "") ? " active" : " active";
		$item->Body = "<a class=\"btn btn-default ew-search-toggle" . $searchToggleClass . "\" href=\"#\" role=\"button\" title=\"" . $Language->phrase("SearchPanel") . "\" data-caption=\"" . $Language->phrase("SearchPanel") . "\" data-toggle=\"button\" data-form=\"ftblMHSlistsrch\" aria-pressed=\"" . ($searchToggleClass == " active" ? "true" : "false") . "\">" . $Language->phrase("SearchLink") . "</a>";
		$item->Visible = TRUE;

		// Show all button
		$item = &$this->SearchOptions->add("showall");
		$item->Body = "<a class=\"btn btn-default ew-show-all\" title=\"" . $Language->phrase("ShowAll") . "\" data-caption=\"" . $Language->phrase("ShowAll") . "\" href=\"" . $this->pageUrl() . "cmd=reset\">" . $Language->phrase("ShowAllBtn") . "</a>";
		$item->Visible = ($this->SearchWhere != $this->DefaultSearchWhere && $this->SearchWhere != "0=101");

		// Button group for search
		$this->SearchOptions->UseDropDownButton = FALSE;
		$this->SearchOptions->UseButtonGroup = TRUE;
		$this->SearchOptions->DropDownButtonPhrase = $Language->phrase("ButtonSearch");

		// Add group option item
		$item = &$this->SearchOptions->add($this->SearchOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;

		// Hide search options
		if ($this->isExport() || $this->CurrentAction)
			$this->SearchOptions->hideAllOptions();
		global $Security;
		if (!$Security->canSearch()) {
			$this->SearchOptions->hideAllOptions();
			$this->FilterOptions->hideAllOptions();
		}
	}

	/**
	 * Export data in HTML/CSV/Word/Excel/XML/Email/PDF format
	 *
	 * @param boolean $return Return the data rather than output it
	 * @return mixed
	 */
	public function exportData($return = FALSE)
	{
		global $Language;
		$utf8 = SameText(Config("PROJECT_CHARSET"), "utf-8");
		$selectLimit = $this->UseSelectLimit;

		// Load recordset
		if ($selectLimit) {
			$this->TotalRecords = $this->listRecordCount();
		} else {
			if (!$this->Recordset)
				$this->Recordset = $this->loadRecordset();
			$rs = &$this->Recordset;
			if ($rs)
				$this->TotalRecords = $rs->RecordCount();
		}
		$this->StartRecord = 1;

		// Export all
		if ($this->ExportAll) {
			set_time_limit(Config("EXPORT_ALL_TIME_LIMIT"));
			$this->DisplayRecords = $this->TotalRecords;
			$this->StopRecord = $this->TotalRecords;
		} else { // Export one page only
			$this->setupStartRecord(); // Set up start record position

			// Set the last record to display
			if ($this->DisplayRecords <= 0) {
				$this->StopRecord = $this->TotalRecords;
			} else {
				$this->StopRecord = $this->StartRecord + $this->DisplayRecords - 1;
			}
		}
		if ($selectLimit)
			$rs = $this->loadRecordset($this->StartRecord - 1, $this->DisplayRecords <= 0 ? $this->TotalRecords : $this->DisplayRecords);
		$this->ExportDoc = GetExportDocument($this, "h");
		$doc = &$this->ExportDoc;
		if (!$doc)
			$this->setFailureMessage($Language->phrase("ExportClassNotFound")); // Export class not found
		if (!$rs || !$doc) {
			RemoveHeader("Content-Type"); // Remove header
			RemoveHeader("Content-Disposition");
			$this->showMessage();
			return;
		}
		if ($selectLimit) {
			$this->StartRecord = 1;
			$this->StopRecord = $this->DisplayRecords <= 0 ? $this->TotalRecords : $this->DisplayRecords;
		}

		// Call Page Exporting server event
		$this->ExportDoc->ExportCustom = !$this->Page_Exporting();
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		$doc->Text .= $header;
		$this->exportDocument($doc, $rs, $this->StartRecord, $this->StopRecord, "");
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		$doc->Text .= $footer;

		// Close recordset
		$rs->close();

		// Call Page Exported server event
		$this->Page_Exported();

		// Export header and footer
		$doc->exportHeaderAndFooter();

		// Clean output buffer (without destroying output buffer)
		$buffer = ob_get_contents(); // Save the output buffer
		if (!Config("DEBUG") && $buffer)
			ob_clean();

		// Write debug message if enabled
		if (Config("DEBUG") && !$this->isExport("pdf"))
			echo GetDebugMessage();

		// Output data
		if ($this->isExport("email")) {

			// Export-to-email disabled
		} else {
			$doc->export();
			if ($return) {
				RemoveHeader("Content-Type"); // Remove header
				RemoveHeader("Content-Disposition");
				$content = ob_get_contents();
				if ($content)
					ob_clean();
				if ($buffer)
					echo $buffer; // Resume the output buffer
				return $content;
			}
		}
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$url = preg_replace('/\?cmd=reset(all){0,1}$/i', '', $url); // Remove cmd=reset / cmd=resetall
		$Breadcrumb->add("list", $this->TableVar, $url, "", $this->TableVar, TRUE);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// Get default connection and filter
			$conn = $this->getConnection();
			$lookupFilter = "";

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL and connection
			switch ($fld->FieldVar) {
				case "x_Kode_jp":
					break;
				case "x_Jenis_Kel":
					break;
				case "x_Status_Akd":
					break;
				case "x_Status_Masuk":
					break;
				case "x_TaMasuk":
					break;
				case "x_PerMasuk":
					break;
				case "x_Status":
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0) {
				$totalCnt = $this->getRecordCount($sql, $conn);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_Kode_jp":
							break;
						case "x_Status_Akd":
							break;
						case "x_TaMasuk":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Set up starting record parameters
	public function setupStartRecord()
	{
		if ($this->DisplayRecords == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			$startRec = Get(Config("TABLE_START_REC"));
			$pageNo = Get(Config("TABLE_PAGE_NO"));
			if ($pageNo !== NULL) { // Check for "pageno" parameter first
				if (is_numeric($pageNo)) {
					$this->StartRecord = ($pageNo - 1) * $this->DisplayRecords + 1;
					if ($this->StartRecord <= 0) {
						$this->StartRecord = 1;
					} elseif ($this->StartRecord >= (int)(($this->TotalRecords - 1)/$this->DisplayRecords) * $this->DisplayRecords + 1) {
						$this->StartRecord = (int)(($this->TotalRecords - 1)/$this->DisplayRecords) * $this->DisplayRecords + 1;
					}
					$this->setStartRecordNumber($this->StartRecord);
				}
			} elseif ($startRec !== NULL) { // Check for "start" parameter
				$this->StartRecord = $startRec;
				$this->setStartRecordNumber($this->StartRecord);
			}
		}
		$this->StartRecord = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRecord) || $this->StartRecord == "") { // Avoid invalid start record counter
			$this->StartRecord = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRecord);
		} elseif ($this->StartRecord > $this->TotalRecords) { // Avoid starting record > total records
			$this->StartRecord = (int)(($this->TotalRecords - 1)/$this->DisplayRecords) * $this->DisplayRecords + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRecord);
		} elseif (($this->StartRecord - 1) % $this->DisplayRecords != 0) {
			$this->StartRecord = (int)(($this->StartRecord - 1)/$this->DisplayRecords) * $this->DisplayRecords + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRecord);
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}

	// ListOptions Load event
	function ListOptions_Load() {

		// Example:
		//$opt = &$this->ListOptions->Add("new");
		//$opt->Header = "xxx";
		//$opt->OnLeft = TRUE; // Link on left
		//$opt->MoveTo(0); // Move to first column

	}

	// ListOptions Rendering event
	function ListOptions_Rendering() {

		//$GLOBALS["xxx_grid"]->DetailAdd = (...condition...); // Set to TRUE or FALSE conditionally
		//$GLOBALS["xxx_grid"]->DetailEdit = (...condition...); // Set to TRUE or FALSE conditionally
		//$GLOBALS["xxx_grid"]->DetailView = (...condition...); // Set to TRUE or FALSE conditionally

	}

	// ListOptions Rendered event
	function ListOptions_Rendered() {

		// Example:
		//$this->ListOptions["new"]->Body = "xxx";

	}

	// Row Custom Action event
	function Row_CustomAction($action, $row) {

		// Return FALSE to abort
		return TRUE;
	}

	// Page Exporting event
	// $this->ExportDoc = export document object
	function Page_Exporting() {

		//$this->ExportDoc->Text = "my header"; // Export header
		//return FALSE; // Return FALSE to skip default export and use Row_Export event

		return TRUE; // Return TRUE to use default export and skip Row_Export event
	}

	// Row Export event
	// $this->ExportDoc = export document object
	function Row_Export($rs) {

		//$this->ExportDoc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
	}

	// Page Exported event
	// $this->ExportDoc = export document object
	function Page_Exported() {

		//$this->ExportDoc->Text .= "my footer"; // Export footer
		//echo $this->ExportDoc->Text;

	}

	// Page Importing event
	function Page_Importing($reader, &$options) {

		//var_dump($reader); // Import data reader
		//var_dump($options); // Show all options for importing
		//return FALSE; // Return FALSE to skip import

		return TRUE;
	}

	// Row Import event
	function Row_Import(&$row, $cnt) {

		//echo $cnt; // Import record count
		//var_dump($row); // Import row
		//return FALSE; // Return FALSE to skip import

		return TRUE;
	}

	// Page Imported event
	function Page_Imported($reader, $results) {

		//var_dump($reader); // Import data reader
		//var_dump($results); // Import results

	}
} // End class
?>