<?php
namespace PHPMaker2020\baak;

/**
 * Page class
 */
class tblMk_PSmtr_add extends tblMk_PSmtr
{

	// Page ID
	public $PageID = "add";

	// Project ID
	public $ProjectID = "{A09D3AFF-419C-4918-948A-A3C8469EA234}";

	// Table name
	public $TableName = 'tblMk_PSmtr';

	// Page object name
	public $PageObjName = "tblMk_PSmtr_add";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken;

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading != "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading != "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		$url = CurrentPageName() . "?";
		if ($this->UseTokenInUrl)
			$url .= "t=" . $this->TableVar . "&"; // Add page token
		return $url;
	}

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = TRUE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message != "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fas fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage != "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fas fa-exclamation"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage != "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fas fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage != "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fas fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = [];

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message != "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage != "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage != "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage != "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header != "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer != "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(Config("TOKEN_NAME")) === NULL)
			return FALSE;
		$fn = Config("CHECK_TOKEN_FUNC");
		if (is_callable($fn))
			return $fn(Post(Config("TOKEN_NAME")), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = Config("CREATE_TOKEN_FUNC"); // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $DashboardReport;
		global $UserTable;

		// Check token
		$this->CheckToken = Config("CHECK_TOKEN");

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (tblMk_PSmtr)
		if (!isset($GLOBALS["tblMk_PSmtr"]) || get_class($GLOBALS["tblMk_PSmtr"]) == PROJECT_NAMESPACE . "tblMk_PSmtr") {
			$GLOBALS["tblMk_PSmtr"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["tblMk_PSmtr"];
		}

		// Table object (Pass)
		if (!isset($GLOBALS['Pass']))
			$GLOBALS['Pass'] = new Pass();

		// Table object (TblJurusan)
		if (!isset($GLOBALS['TblJurusan']))
			$GLOBALS['TblJurusan'] = new TblJurusan();

		// Page ID (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'add');

		// Table name (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'tblMk_PSmtr');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = $this->getConnection();

		// User table object (Pass)
		$UserTable = $UserTable ?: new Pass();
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages, $DashboardReport;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $tblMk_PSmtr;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, Config("EXPORT_CLASSES"))) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . Config("EXPORT_CLASSES." . $this->CustomExport);
			if (class_exists($class)) {
				$doc = new $class($tblMk_PSmtr);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url != "") {
			if (!Config("DEBUG") && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = ["url" => $url, "modal" => "1"];
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "tblMk_PSmtrview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = [];
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = [];
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {
								$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
									Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
									Config("API_FIELD_NAME") . "=" . $fld->Param . "&" .
									Config("API_KEY_NAME") . "=" . rawurlencode($this->getRecordKeyValue($ar)))); //*** need to add this? API may not be in the same folder
								$row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
								$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
									Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
									"fn=" . Encrypt($fld->physicalUploadPath() . $val)));
								$row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
							} else { // Multiple files
								$files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
								$ar = [];
								foreach ($files as $file) {
									$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
										Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
										"fn=" . Encrypt($fld->physicalUploadPath() . $file)));
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['Kode_Jp'] . Config("COMPOSITE_KEY_SEPARATOR");
			$key .= @$ar['Kode_Mk'] . Config("COMPOSITE_KEY_SEPARATOR");
			$key .= @$ar['Semester'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
	}

	// Lookup data
	public function lookup()
	{
		global $Language, $Security;
		if (!isset($Language))
			$Language = new Language(Config("LANGUAGE_FOLDER"), Post("language", ""));

		// Set up API request
		if (!ValidApiRequest())
			return FALSE;
		$this->setupApiSecurity();

		// Get lookup object
		$fieldName = Post("field");
		if (!array_key_exists($fieldName, $this->fields))
			return FALSE;
		$lookupField = $this->fields[$fieldName];
		$lookup = $lookupField->Lookup;
		if ($lookup === NULL)
			return FALSE;
		$tbl = $lookup->getTable();
		if (!$Security->allowLookup(Config("PROJECT_ID") . $tbl->TableName)) // Lookup permission
			return FALSE;

		// Get lookup parameters
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Param("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
			$lookup->FilterFields = []; // Skip parent fields if any
			$lookup->FilterValues[] = $keys; // Lookup values
			$pageSize = -1; // Show all records
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect != "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter != "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy != "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson($this); // Use settings from current page
	}

	// Set up API security
	public function setupApiSecurity()
	{
		global $Security;

		// Setup security for API request
		if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
		$Security->loadCurrentUserLevel(Config("PROJECT_ID") . $this->TableName);
		if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
	}
	public $FormClassName = "ew-horizontal ew-form ew-add-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $DbMasterFilter = "";
	public $DbDetailFilter = "";
	public $StartRecord;
	public $Priv = 0;
	public $OldRecordset;
	public $CopyRecord;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		if (ValidApiRequest()) { // API request
			$this->setupApiSecurity(); // Set up API Security
			if (!$Security->canAdd()) {
				SetStatus(401); // Unauthorized
				return;
			}
		} else {
			$Security = new AdvancedSecurity();
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canAdd()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("tblMk_PSmtrlist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->Kode_Jp->Visible = FALSE;
		$this->Kode_Mk->setVisibility();
		$this->SKS->setVisibility();
		$this->Semester->setVisibility();
		$this->wp->setVisibility();
		$this->jk->setVisibility();
		$this->Konsentrasi->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->Kode_Mk);
		$this->setupLookupOptions($this->wp);
		$this->setupLookupOptions($this->jk);
		$this->setupLookupOptions($this->Konsentrasi);

		// Check permission
		if (!$Security->canAdd()) {
			$this->setFailureMessage(DeniedMessage()); // No permission
			$this->terminate("tblMk_PSmtrlist.php");
			return;
		}

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-add-form ew-horizontal";
		$postBack = FALSE;

		// Set up current action
		if (IsApi()) {
			$this->CurrentAction = "insert"; // Add record directly
			$postBack = TRUE;
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action"); // Get form action
			$postBack = TRUE;
		} else { // Not post back

			// Load key values from QueryString
			$this->CopyRecord = TRUE;
			if (Get("Kode_Jp") !== NULL) {
				$this->Kode_Jp->setQueryStringValue(Get("Kode_Jp"));
				$this->setKey("Kode_Jp", $this->Kode_Jp->CurrentValue); // Set up key
			} else {
				$this->setKey("Kode_Jp", ""); // Clear key
				$this->CopyRecord = FALSE;
			}
			if (Get("Kode_Mk") !== NULL) {
				$this->Kode_Mk->setQueryStringValue(Get("Kode_Mk"));
				$this->setKey("Kode_Mk", $this->Kode_Mk->CurrentValue); // Set up key
			} else {
				$this->setKey("Kode_Mk", ""); // Clear key
				$this->CopyRecord = FALSE;
			}
			if (Get("Semester") !== NULL) {
				$this->Semester->setQueryStringValue(Get("Semester"));
				$this->setKey("Semester", $this->Semester->CurrentValue); // Set up key
			} else {
				$this->setKey("Semester", ""); // Clear key
				$this->CopyRecord = FALSE;
			}
			if ($this->CopyRecord) {
				$this->CurrentAction = "copy"; // Copy record
			} else {
				$this->CurrentAction = "show"; // Display blank record
			}
		}

		// Load old record / default values
		$loaded = $this->loadOldRecord();

		// Set up master/detail parameters
		// NOTE: must be after loadOldRecord to prevent master key values overwritten

		$this->setupMasterParms();

		// Load form values
		if ($postBack) {
			$this->loadFormValues(); // Load form values
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->validateForm()) {
				$this->EventCancelled = TRUE; // Event cancelled
				$this->restoreFormValues(); // Restore form values
				$this->setFailureMessage($FormError);
				if (IsApi()) {
					$this->terminate();
					return;
				} else {
					$this->CurrentAction = "show"; // Form error, reset action
				}
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "copy": // Copy an existing record
				if (!$loaded) { // Record not loaded
					if ($this->getFailureMessage() == "")
						$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
					$this->terminate("tblMk_PSmtrlist.php"); // No matching record, return to list
				}
				break;
			case "insert": // Add new record
				$this->SendEmail = TRUE; // Send email on add success
				if ($this->addRow($this->OldRecordset)) { // Add successful
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
					$returnUrl = $this->getReturnUrl();
					if (GetPageName($returnUrl) == "tblMk_PSmtrlist.php")
						$returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
					elseif (GetPageName($returnUrl) == "tblMk_PSmtrview.php")
						$returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
					if (IsApi()) { // Return to caller
						$this->terminate(TRUE);
						return;
					} else {
						$this->terminate($returnUrl);
					}
				} elseif (IsApi()) { // API request, return
					$this->terminate();
					return;
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->restoreFormValues(); // Add failed, restore form values
				}
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Render row based on row type
		$this->RowType = ROWTYPE_ADD; // Render add type

		// Render row
		$this->resetAttributes();
		$this->renderRow();
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
	}

	// Load default values
	protected function loadDefaultValues()
	{
		$this->Kode_Jp->CurrentValue = NULL;
		$this->Kode_Jp->OldValue = $this->Kode_Jp->CurrentValue;
		$this->Kode_Mk->CurrentValue = NULL;
		$this->Kode_Mk->OldValue = $this->Kode_Mk->CurrentValue;
		$this->SKS->CurrentValue = NULL;
		$this->SKS->OldValue = $this->SKS->CurrentValue;
		$this->Semester->CurrentValue = NULL;
		$this->Semester->OldValue = $this->Semester->CurrentValue;
		$this->wp->CurrentValue = NULL;
		$this->wp->OldValue = $this->wp->CurrentValue;
		$this->jk->CurrentValue = NULL;
		$this->jk->OldValue = $this->jk->CurrentValue;
		$this->Konsentrasi->CurrentValue = NULL;
		$this->Konsentrasi->OldValue = $this->Konsentrasi->CurrentValue;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;

		// Check field name 'Kode_Mk' first before field var 'x_Kode_Mk'
		$val = $CurrentForm->hasValue("Kode_Mk") ? $CurrentForm->getValue("Kode_Mk") : $CurrentForm->getValue("x_Kode_Mk");
		if (!$this->Kode_Mk->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->Kode_Mk->Visible = FALSE; // Disable update for API request
			else
				$this->Kode_Mk->setFormValue($val);
		}

		// Check field name 'SKS' first before field var 'x_SKS'
		$val = $CurrentForm->hasValue("SKS") ? $CurrentForm->getValue("SKS") : $CurrentForm->getValue("x_SKS");
		if (!$this->SKS->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->SKS->Visible = FALSE; // Disable update for API request
			else
				$this->SKS->setFormValue($val);
		}

		// Check field name 'Semester' first before field var 'x_Semester'
		$val = $CurrentForm->hasValue("Semester") ? $CurrentForm->getValue("Semester") : $CurrentForm->getValue("x_Semester");
		if (!$this->Semester->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->Semester->Visible = FALSE; // Disable update for API request
			else
				$this->Semester->setFormValue($val);
		}

		// Check field name 'wp' first before field var 'x_wp'
		$val = $CurrentForm->hasValue("wp") ? $CurrentForm->getValue("wp") : $CurrentForm->getValue("x_wp");
		if (!$this->wp->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->wp->Visible = FALSE; // Disable update for API request
			else
				$this->wp->setFormValue($val);
		}

		// Check field name 'jk' first before field var 'x_jk'
		$val = $CurrentForm->hasValue("jk") ? $CurrentForm->getValue("jk") : $CurrentForm->getValue("x_jk");
		if (!$this->jk->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->jk->Visible = FALSE; // Disable update for API request
			else
				$this->jk->setFormValue($val);
		}

		// Check field name 'Konsentrasi' first before field var 'x_Konsentrasi'
		$val = $CurrentForm->hasValue("Konsentrasi") ? $CurrentForm->getValue("Konsentrasi") : $CurrentForm->getValue("x_Konsentrasi");
		if (!$this->Konsentrasi->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->Konsentrasi->Visible = FALSE; // Disable update for API request
			else
				$this->Konsentrasi->setFormValue($val);
		}

		// Check field name 'Kode_Jp' first before field var 'x_Kode_Jp'
		$val = $CurrentForm->hasValue("Kode_Jp") ? $CurrentForm->getValue("Kode_Jp") : $CurrentForm->getValue("x_Kode_Jp");
		if (!$this->Kode_Jp->IsDetailKey)
			$this->Kode_Jp->setFormValue($val);
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->Kode_Jp->CurrentValue = $this->Kode_Jp->FormValue;
		$this->Kode_Mk->CurrentValue = $this->Kode_Mk->FormValue;
		$this->SKS->CurrentValue = $this->SKS->FormValue;
		$this->Semester->CurrentValue = $this->Semester->FormValue;
		$this->wp->CurrentValue = $this->wp->FormValue;
		$this->jk->CurrentValue = $this->jk->FormValue;
		$this->Konsentrasi->CurrentValue = $this->Konsentrasi->FormValue;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = $this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->Kode_Jp->setDbValue($row['Kode_Jp']);
		$this->Kode_Mk->setDbValue($row['Kode_Mk']);
		if (array_key_exists('EV__Kode_Mk', $rs->fields)) {
			$this->Kode_Mk->VirtualValue = $rs->fields('EV__Kode_Mk'); // Set up virtual field value
		} else {
			$this->Kode_Mk->VirtualValue = ""; // Clear value
		}
		$this->SKS->setDbValue($row['SKS']);
		$this->Semester->setDbValue($row['Semester']);
		$this->wp->setDbValue($row['wp']);
		$this->jk->setDbValue($row['jk']);
		$this->Konsentrasi->setDbValue($row['Konsentrasi']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$this->loadDefaultValues();
		$row = [];
		$row['Kode_Jp'] = $this->Kode_Jp->CurrentValue;
		$row['Kode_Mk'] = $this->Kode_Mk->CurrentValue;
		$row['SKS'] = $this->SKS->CurrentValue;
		$row['Semester'] = $this->Semester->CurrentValue;
		$row['wp'] = $this->wp->CurrentValue;
		$row['jk'] = $this->jk->CurrentValue;
		$row['Konsentrasi'] = $this->Konsentrasi->CurrentValue;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("Kode_Jp")) != "")
			$this->Kode_Jp->OldValue = $this->getKey("Kode_Jp"); // Kode_Jp
		else
			$validKey = FALSE;
		if (strval($this->getKey("Kode_Mk")) != "")
			$this->Kode_Mk->OldValue = $this->getKey("Kode_Mk"); // Kode_Mk
		else
			$validKey = FALSE;
		if (strval($this->getKey("Semester")) != "")
			$this->Semester->OldValue = $this->getKey("Semester"); // Semester
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = $this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Call Row_Rendering event

		$this->Row_Rendering();

		// Common render codes for all row types
		// Kode_Jp
		// Kode_Mk
		// SKS
		// Semester
		// wp
		// jk
		// Konsentrasi

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// Kode_Jp
			$this->Kode_Jp->ViewValue = $this->Kode_Jp->CurrentValue;
			$this->Kode_Jp->ViewCustomAttributes = "";

			// Kode_Mk
			if ($this->Kode_Mk->VirtualValue != "") {
				$this->Kode_Mk->ViewValue = $this->Kode_Mk->VirtualValue;
			} else {
				$curVal = strval($this->Kode_Mk->CurrentValue);
				if ($curVal != "") {
					$this->Kode_Mk->ViewValue = $this->Kode_Mk->lookupCacheOption($curVal);
					if ($this->Kode_Mk->ViewValue === NULL) { // Lookup from database
						$filterWrk = "[Kode_MK]" . SearchString("=", $curVal, DATATYPE_STRING, "");
						$sqlWrk = $this->Kode_Mk->Lookup->getSql(FALSE, $filterWrk, '', $this);
						$rswrk = Conn()->execute($sqlWrk);
						if ($rswrk && !$rswrk->EOF) { // Lookup values found
							$arwrk = [];
							$arwrk[1] = $rswrk->fields('df');
							$arwrk[2] = $rswrk->fields('df2');
							$this->Kode_Mk->ViewValue = $this->Kode_Mk->displayValue($arwrk);
							$rswrk->Close();
						} else {
							$this->Kode_Mk->ViewValue = $this->Kode_Mk->CurrentValue;
						}
					}
				} else {
					$this->Kode_Mk->ViewValue = NULL;
				}
			}
			$this->Kode_Mk->ViewCustomAttributes = "";

			// SKS
			$this->SKS->ViewValue = $this->SKS->CurrentValue;
			$this->SKS->ViewValue = FormatNumber($this->SKS->ViewValue, 0, -2, -2, -2);
			$this->SKS->ViewCustomAttributes = "";

			// Semester
			if (strval($this->Semester->CurrentValue) != "") {
				$this->Semester->ViewValue = $this->Semester->optionCaption($this->Semester->CurrentValue);
			} else {
				$this->Semester->ViewValue = NULL;
			}
			$this->Semester->ViewCustomAttributes = "";

			// wp
			$curVal = strval($this->wp->CurrentValue);
			if ($curVal != "") {
				$this->wp->ViewValue = $this->wp->lookupCacheOption($curVal);
				if ($this->wp->ViewValue === NULL) { // Lookup from database
					$filterWrk = "[KDKODTBKOD]" . SearchString("=", $curVal, DATATYPE_STRING, "");
					$lookupFilter = function() {
						return "[KDAPLTBKOD]='28'";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->wp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = [];
						$arwrk[1] = $rswrk->fields('df');
						$this->wp->ViewValue = $this->wp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->wp->ViewValue = $this->wp->CurrentValue;
					}
				}
			} else {
				$this->wp->ViewValue = NULL;
			}
			$this->wp->ViewCustomAttributes = "";

			// jk
			$curVal = strval($this->jk->CurrentValue);
			if ($curVal != "") {
				$this->jk->ViewValue = $this->jk->lookupCacheOption($curVal);
				if ($this->jk->ViewValue === NULL) { // Lookup from database
					$filterWrk = "[KDKODTBKOD]" . SearchString("=", $curVal, DATATYPE_STRING, "");
					$lookupFilter = function() {
						return "[KDAPLTBKOD]='11'";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->jk->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = [];
						$arwrk[1] = $rswrk->fields('df');
						$this->jk->ViewValue = $this->jk->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->jk->ViewValue = $this->jk->CurrentValue;
					}
				}
			} else {
				$this->jk->ViewValue = NULL;
			}
			$this->jk->ViewCustomAttributes = "";

			// Konsentrasi
			$curVal = strval($this->Konsentrasi->CurrentValue);
			if ($curVal != "") {
				$this->Konsentrasi->ViewValue = $this->Konsentrasi->lookupCacheOption($curVal);
				if ($this->Konsentrasi->ViewValue === NULL) { // Lookup from database
					$filterWrk = "[Konsentrasi]" . SearchString("=", $curVal, DATATYPE_STRING, "");
					$sqlWrk = $this->Konsentrasi->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = [];
						$arwrk[1] = $rswrk->fields('df');
						$this->Konsentrasi->ViewValue = $this->Konsentrasi->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->Konsentrasi->ViewValue = $this->Konsentrasi->CurrentValue;
					}
				}
			} else {
				$this->Konsentrasi->ViewValue = NULL;
			}
			$this->Konsentrasi->ViewCustomAttributes = "";

			// Kode_Mk
			$this->Kode_Mk->LinkCustomAttributes = "";
			$this->Kode_Mk->HrefValue = "";
			$this->Kode_Mk->TooltipValue = "";

			// SKS
			$this->SKS->LinkCustomAttributes = "";
			$this->SKS->HrefValue = "";
			$this->SKS->TooltipValue = "";

			// Semester
			$this->Semester->LinkCustomAttributes = "";
			$this->Semester->HrefValue = "";
			$this->Semester->TooltipValue = "";

			// wp
			$this->wp->LinkCustomAttributes = "";
			$this->wp->HrefValue = "";
			$this->wp->TooltipValue = "";

			// jk
			$this->jk->LinkCustomAttributes = "";
			$this->jk->HrefValue = "";
			$this->jk->TooltipValue = "";

			// Konsentrasi
			$this->Konsentrasi->LinkCustomAttributes = "";
			$this->Konsentrasi->HrefValue = "";
			$this->Konsentrasi->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_ADD) { // Add row

			// Kode_Mk
			$this->Kode_Mk->EditCustomAttributes = "";
			$curVal = trim(strval($this->Kode_Mk->CurrentValue));
			if ($curVal != "")
				$this->Kode_Mk->ViewValue = $this->Kode_Mk->lookupCacheOption($curVal);
			else
				$this->Kode_Mk->ViewValue = $this->Kode_Mk->Lookup !== NULL && is_array($this->Kode_Mk->Lookup->Options) ? $curVal : NULL;
			if ($this->Kode_Mk->ViewValue !== NULL) { // Load from cache
				$this->Kode_Mk->EditValue = array_values($this->Kode_Mk->Lookup->Options);
				if ($this->Kode_Mk->ViewValue == "")
					$this->Kode_Mk->ViewValue = $Language->phrase("PleaseSelect");
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "[Kode_MK]" . SearchString("=", $this->Kode_Mk->CurrentValue, DATATYPE_STRING, "");
				}
				$sqlWrk = $this->Kode_Mk->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = [];
					$arwrk[1] = HtmlEncode($rswrk->fields('df'));
					$arwrk[2] = HtmlEncode($rswrk->fields('df2'));
					$this->Kode_Mk->ViewValue = $this->Kode_Mk->displayValue($arwrk);
				} else {
					$this->Kode_Mk->ViewValue = $Language->phrase("PleaseSelect");
				}
				$arwrk = $rswrk ? $rswrk->getRows() : [];
				if ($rswrk)
					$rswrk->close();
				$this->Kode_Mk->EditValue = $arwrk;
			}

			// SKS
			$this->SKS->EditAttrs["class"] = "form-control";
			$this->SKS->EditCustomAttributes = "";
			$this->SKS->EditValue = HtmlEncode($this->SKS->CurrentValue);
			$this->SKS->PlaceHolder = RemoveHtml($this->SKS->caption());

			// Semester
			$this->Semester->EditAttrs["class"] = "form-control";
			$this->Semester->EditCustomAttributes = "";
			$this->Semester->EditValue = $this->Semester->options(TRUE);

			// wp
			$this->wp->EditAttrs["class"] = "form-control";
			$this->wp->EditCustomAttributes = "";
			$curVal = trim(strval($this->wp->CurrentValue));
			if ($curVal != "")
				$this->wp->ViewValue = $this->wp->lookupCacheOption($curVal);
			else
				$this->wp->ViewValue = $this->wp->Lookup !== NULL && is_array($this->wp->Lookup->Options) ? $curVal : NULL;
			if ($this->wp->ViewValue !== NULL) { // Load from cache
				$this->wp->EditValue = array_values($this->wp->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "[KDKODTBKOD]" . SearchString("=", $this->wp->CurrentValue, DATATYPE_STRING, "");
				}
				$lookupFilter = function() {
					return "[KDAPLTBKOD]='28'";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->wp->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = $rswrk ? $rswrk->getRows() : [];
				if ($rswrk)
					$rswrk->close();
				$this->wp->EditValue = $arwrk;
			}

			// jk
			$this->jk->EditAttrs["class"] = "form-control";
			$this->jk->EditCustomAttributes = "";
			$curVal = trim(strval($this->jk->CurrentValue));
			if ($curVal != "")
				$this->jk->ViewValue = $this->jk->lookupCacheOption($curVal);
			else
				$this->jk->ViewValue = $this->jk->Lookup !== NULL && is_array($this->jk->Lookup->Options) ? $curVal : NULL;
			if ($this->jk->ViewValue !== NULL) { // Load from cache
				$this->jk->EditValue = array_values($this->jk->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "[KDKODTBKOD]" . SearchString("=", $this->jk->CurrentValue, DATATYPE_STRING, "");
				}
				$lookupFilter = function() {
					return "[KDAPLTBKOD]='11'";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->jk->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = $rswrk ? $rswrk->getRows() : [];
				if ($rswrk)
					$rswrk->close();
				$this->jk->EditValue = $arwrk;
			}

			// Konsentrasi
			$this->Konsentrasi->EditAttrs["class"] = "form-control";
			$this->Konsentrasi->EditCustomAttributes = "";
			$curVal = trim(strval($this->Konsentrasi->CurrentValue));
			if ($curVal != "")
				$this->Konsentrasi->ViewValue = $this->Konsentrasi->lookupCacheOption($curVal);
			else
				$this->Konsentrasi->ViewValue = $this->Konsentrasi->Lookup !== NULL && is_array($this->Konsentrasi->Lookup->Options) ? $curVal : NULL;
			if ($this->Konsentrasi->ViewValue !== NULL) { // Load from cache
				$this->Konsentrasi->EditValue = array_values($this->Konsentrasi->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "[Konsentrasi]" . SearchString("=", $this->Konsentrasi->CurrentValue, DATATYPE_STRING, "");
				}
				$sqlWrk = $this->Konsentrasi->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = $rswrk ? $rswrk->getRows() : [];
				if ($rswrk)
					$rswrk->close();
				$this->Konsentrasi->EditValue = $arwrk;
			}

			// Add refer script
			// Kode_Mk

			$this->Kode_Mk->LinkCustomAttributes = "";
			$this->Kode_Mk->HrefValue = "";

			// SKS
			$this->SKS->LinkCustomAttributes = "";
			$this->SKS->HrefValue = "";

			// Semester
			$this->Semester->LinkCustomAttributes = "";
			$this->Semester->HrefValue = "";

			// wp
			$this->wp->LinkCustomAttributes = "";
			$this->wp->HrefValue = "";

			// jk
			$this->jk->LinkCustomAttributes = "";
			$this->jk->HrefValue = "";

			// Konsentrasi
			$this->Konsentrasi->LinkCustomAttributes = "";
			$this->Konsentrasi->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType != ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!Config("SERVER_VALIDATE"))
			return ($FormError == "");
		if ($this->Kode_Mk->Required) {
			if (!$this->Kode_Mk->IsDetailKey && $this->Kode_Mk->FormValue != NULL && $this->Kode_Mk->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Kode_Mk->caption(), $this->Kode_Mk->RequiredErrorMessage));
			}
		}
		if ($this->SKS->Required) {
			if (!$this->SKS->IsDetailKey && $this->SKS->FormValue != NULL && $this->SKS->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->SKS->caption(), $this->SKS->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->SKS->FormValue)) {
			AddMessage($FormError, $this->SKS->errorMessage());
		}
		if ($this->Semester->Required) {
			if (!$this->Semester->IsDetailKey && $this->Semester->FormValue != NULL && $this->Semester->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Semester->caption(), $this->Semester->RequiredErrorMessage));
			}
		}
		if ($this->wp->Required) {
			if (!$this->wp->IsDetailKey && $this->wp->FormValue != NULL && $this->wp->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->wp->caption(), $this->wp->RequiredErrorMessage));
			}
		}
		if ($this->jk->Required) {
			if (!$this->jk->IsDetailKey && $this->jk->FormValue != NULL && $this->jk->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->jk->caption(), $this->jk->RequiredErrorMessage));
			}
		}
		if ($this->Konsentrasi->Required) {
			if (!$this->Konsentrasi->IsDetailKey && $this->Konsentrasi->FormValue != NULL && $this->Konsentrasi->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Konsentrasi->caption(), $this->Konsentrasi->RequiredErrorMessage));
			}
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError != "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Add record
	protected function addRow($rsold = NULL)
	{
		global $Language, $Security;
		$conn = $this->getConnection();

		// Load db values from rsold
		$this->loadDbValues($rsold);
		if ($rsold) {
		}
		$rsnew = [];

		// Kode_Mk
		$this->Kode_Mk->setDbValueDef($rsnew, $this->Kode_Mk->CurrentValue, "", FALSE);

		// SKS
		$this->SKS->setDbValueDef($rsnew, $this->SKS->CurrentValue, NULL, FALSE);

		// Semester
		$this->Semester->setDbValueDef($rsnew, $this->Semester->CurrentValue, "", FALSE);

		// wp
		$this->wp->setDbValueDef($rsnew, $this->wp->CurrentValue, NULL, FALSE);

		// jk
		$this->jk->setDbValueDef($rsnew, $this->jk->CurrentValue, NULL, FALSE);

		// Konsentrasi
		$this->Konsentrasi->setDbValueDef($rsnew, $this->Konsentrasi->CurrentValue, NULL, FALSE);

		// Kode_Jp
		if ($this->Kode_Jp->getSessionValue() != "") {
			$rsnew['Kode_Jp'] = $this->Kode_Jp->getSessionValue();
		}

		// Call Row Inserting event
		$rs = ($rsold) ? $rsold->fields : NULL;
		$insertRow = $this->Row_Inserting($rs, $rsnew);

		// Check if key value entered
		if ($insertRow && $this->ValidateKey && strval($rsnew['Kode_Jp']) == "") {
			$this->setFailureMessage($Language->phrase("InvalidKeyValue"));
			$insertRow = FALSE;
		}

		// Check if key value entered
		if ($insertRow && $this->ValidateKey && strval($rsnew['Kode_Mk']) == "") {
			$this->setFailureMessage($Language->phrase("InvalidKeyValue"));
			$insertRow = FALSE;
		}

		// Check if key value entered
		if ($insertRow && $this->ValidateKey && strval($rsnew['Semester']) == "") {
			$this->setFailureMessage($Language->phrase("InvalidKeyValue"));
			$insertRow = FALSE;
		}

		// Check for duplicate key
		if ($insertRow && $this->ValidateKey) {
			$filter = $this->getRecordFilter($rsnew);
			$rsChk = $this->loadRs($filter);
			if ($rsChk && !$rsChk->EOF) {
				$keyErrMsg = str_replace("%f", $filter, $Language->phrase("DupKey"));
				$this->setFailureMessage($keyErrMsg);
				$rsChk->close();
				$insertRow = FALSE;
			}
		}
		if ($insertRow) {
			$conn->raiseErrorFn = Config("ERROR_FUNC");
			$addRow = $this->insert($rsnew);
			$conn->raiseErrorFn = "";
			if ($addRow) {
			}
		} else {
			if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage != "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->phrase("InsertCancelled"));
			}
			$addRow = FALSE;
		}
		if ($addRow) {

			// Call Row Inserted event
			$rs = ($rsold) ? $rsold->fields : NULL;
			$this->Row_Inserted($rs, $rsnew);
		}

		// Clean upload path if any
		if ($addRow) {
		}

		// Write JSON for API request
		if (IsApi() && $addRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $addRow;
	}

	// Set up master/detail based on QueryString
	protected function setupMasterParms()
	{
		$validMaster = FALSE;

		// Get the keys for master table
		if (($master = Get(Config("TABLE_SHOW_MASTER"), Get(Config("TABLE_MASTER")))) !== NULL) {
			$masterTblVar = $master;
			if ($masterTblVar == "") {
				$validMaster = TRUE;
				$this->DbMasterFilter = "";
				$this->DbDetailFilter = "";
			}
			if ($masterTblVar == "TblJurusan") {
				$validMaster = TRUE;
				if (($parm = Get("fk_Kode_Jp", Get("Kode_Jp"))) !== NULL) {
					$GLOBALS["TblJurusan"]->Kode_Jp->setQueryStringValue($parm);
					$this->Kode_Jp->setQueryStringValue($GLOBALS["TblJurusan"]->Kode_Jp->QueryStringValue);
					$this->Kode_Jp->setSessionValue($this->Kode_Jp->QueryStringValue);
				} else {
					$validMaster = FALSE;
				}
			}
		} elseif (($master = Post(Config("TABLE_SHOW_MASTER"), Post(Config("TABLE_MASTER")))) !== NULL) {
			$masterTblVar = $master;
			if ($masterTblVar == "") {
				$validMaster = TRUE;
				$this->DbMasterFilter = "";
				$this->DbDetailFilter = "";
			}
			if ($masterTblVar == "TblJurusan") {
				$validMaster = TRUE;
				if (($parm = Post("fk_Kode_Jp", Post("Kode_Jp"))) !== NULL) {
					$GLOBALS["TblJurusan"]->Kode_Jp->setFormValue($parm);
					$this->Kode_Jp->setFormValue($GLOBALS["TblJurusan"]->Kode_Jp->FormValue);
					$this->Kode_Jp->setSessionValue($this->Kode_Jp->FormValue);
				} else {
					$validMaster = FALSE;
				}
			}
		}
		if ($validMaster) {

			// Save current master table
			$this->setCurrentMasterTable($masterTblVar);

			// Reset start record counter (new master key)
			if (!$this->isAddOrEdit()) {
				$this->StartRecord = 1;
				$this->setStartRecordNumber($this->StartRecord);
			}

			// Clear previous master key from Session
			if ($masterTblVar != "TblJurusan") {
				if ($this->Kode_Jp->CurrentValue == "")
					$this->Kode_Jp->setSessionValue("");
			}
		}
		$this->DbMasterFilter = $this->getMasterFilter(); // Get master filter
		$this->DbDetailFilter = $this->getDetailFilter(); // Get detail filter
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("tblMk_PSmtrlist.php"), "", $this->TableVar, TRUE);
		$pageId = ($this->isCopy()) ? "Copy" : "Add";
		$Breadcrumb->add("add", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// Get default connection and filter
			$conn = $this->getConnection();
			$lookupFilter = "";

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL and connection
			switch ($fld->FieldVar) {
				case "x_Kode_Mk":
					break;
				case "x_Semester":
					break;
				case "x_wp":
					$lookupFilter = function() {
						return "[KDAPLTBKOD]='28'";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_jk":
					$lookupFilter = function() {
						return "[KDAPLTBKOD]='11'";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_Konsentrasi":
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0) {
				$totalCnt = $this->getRecordCount($sql, $conn);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_Kode_Mk":
							break;
						case "x_wp":
							break;
						case "x_jk":
							break;
						case "x_Konsentrasi":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
} // End class
?>