<?php
namespace PHPMaker2020\baak;

/**
 * Page class
 */
class tblNilaiPerMhs_add extends tblNilaiPerMhs
{

	// Page ID
	public $PageID = "add";

	// Project ID
	public $ProjectID = "{A09D3AFF-419C-4918-948A-A3C8469EA234}";

	// Table name
	public $TableName = 'tblNilaiPerMhs';

	// Page object name
	public $PageObjName = "tblNilaiPerMhs_add";

	// Audit Trail
	public $AuditTrailOnAdd = TRUE;
	public $AuditTrailOnEdit = TRUE;
	public $AuditTrailOnDelete = TRUE;
	public $AuditTrailOnView = FALSE;
	public $AuditTrailOnViewData = FALSE;
	public $AuditTrailOnSearch = FALSE;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken;

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading != "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading != "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		$url = CurrentPageName() . "?";
		if ($this->UseTokenInUrl)
			$url .= "t=" . $this->TableVar . "&"; // Add page token
		return $url;
	}

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = TRUE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message != "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fas fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage != "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fas fa-exclamation"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage != "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fas fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage != "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fas fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = [];

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message != "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage != "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage != "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage != "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header != "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer != "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(Config("TOKEN_NAME")) === NULL)
			return FALSE;
		$fn = Config("CHECK_TOKEN_FUNC");
		if (is_callable($fn))
			return $fn(Post(Config("TOKEN_NAME")), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = Config("CREATE_TOKEN_FUNC"); // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $DashboardReport;
		global $UserTable;

		// Check token
		$this->CheckToken = Config("CHECK_TOKEN");

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (tblNilaiPerMhs)
		if (!isset($GLOBALS["tblNilaiPerMhs"]) || get_class($GLOBALS["tblNilaiPerMhs"]) == PROJECT_NAMESPACE . "tblNilaiPerMhs") {
			$GLOBALS["tblNilaiPerMhs"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["tblNilaiPerMhs"];
		}

		// Table object (Pass)
		if (!isset($GLOBALS['Pass']))
			$GLOBALS['Pass'] = new Pass();

		// Table object (V_LMHS)
		if (!isset($GLOBALS['V_LMHS']))
			$GLOBALS['V_LMHS'] = new V_LMHS();

		// Table object (IM_Mhs)
		if (!isset($GLOBALS['IM_Mhs']))
			$GLOBALS['IM_Mhs'] = new IM_Mhs();

		// Page ID (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'add');

		// Table name (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'tblNilaiPerMhs');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = $this->getConnection();

		// User table object (Pass)
		$UserTable = $UserTable ?: new Pass();
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages, $DashboardReport;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $tblNilaiPerMhs;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, Config("EXPORT_CLASSES"))) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . Config("EXPORT_CLASSES." . $this->CustomExport);
			if (class_exists($class)) {
				$doc = new $class($tblNilaiPerMhs);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url != "") {
			if (!Config("DEBUG") && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = ["url" => $url, "modal" => "1"];
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "tblNilaiPerMhsview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = [];
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = [];
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {
								$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
									Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
									Config("API_FIELD_NAME") . "=" . $fld->Param . "&" .
									Config("API_KEY_NAME") . "=" . rawurlencode($this->getRecordKeyValue($ar)))); //*** need to add this? API may not be in the same folder
								$row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
								$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
									Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
									"fn=" . Encrypt($fld->physicalUploadPath() . $val)));
								$row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
							} else { // Multiple files
								$files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
								$ar = [];
								foreach ($files as $file) {
									$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
										Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
										"fn=" . Encrypt($fld->physicalUploadPath() . $file)));
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['Nim'] . Config("COMPOSITE_KEY_SEPARATOR");
			$key .= @$ar['Thn_Akademik'] . Config("COMPOSITE_KEY_SEPARATOR");
			$key .= @$ar['Periode'] . Config("COMPOSITE_KEY_SEPARATOR");
			$key .= @$ar['Kode_MK'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
	}

	// Lookup data
	public function lookup()
	{
		global $Language, $Security;
		if (!isset($Language))
			$Language = new Language(Config("LANGUAGE_FOLDER"), Post("language", ""));

		// Set up API request
		if (!ValidApiRequest())
			return FALSE;
		$this->setupApiSecurity();

		// Get lookup object
		$fieldName = Post("field");
		if (!array_key_exists($fieldName, $this->fields))
			return FALSE;
		$lookupField = $this->fields[$fieldName];
		$lookup = $lookupField->Lookup;
		if ($lookup === NULL)
			return FALSE;
		$tbl = $lookup->getTable();
		if (!$Security->allowLookup(Config("PROJECT_ID") . $tbl->TableName)) // Lookup permission
			return FALSE;

		// Get lookup parameters
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Param("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
			$lookup->FilterFields = []; // Skip parent fields if any
			$lookup->FilterValues[] = $keys; // Lookup values
			$pageSize = -1; // Show all records
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect != "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter != "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy != "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson($this); // Use settings from current page
	}

	// Set up API security
	public function setupApiSecurity()
	{
		global $Security;

		// Setup security for API request
		if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
		$Security->loadCurrentUserLevel(Config("PROJECT_ID") . $this->TableName);
		if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
	}
	public $FormClassName = "ew-horizontal ew-form ew-add-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $DbMasterFilter = "";
	public $DbDetailFilter = "";
	public $StartRecord;
	public $Priv = 0;
	public $OldRecordset;
	public $CopyRecord;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		if (ValidApiRequest()) { // API request
			$this->setupApiSecurity(); // Set up API Security
			if (!$Security->canAdd()) {
				SetStatus(401); // Unauthorized
				return;
			}
		} else {
			$Security = new AdvancedSecurity();
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canAdd()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("tblNilaiPerMhslist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->Nim->setVisibility();
		$this->Thn_Akademik->setVisibility();
		$this->Periode->setVisibility();
		$this->Kode_MK->setVisibility();
		$this->Kehadiran->setVisibility();
		$this->Tugas->setVisibility();
		$this->Quiz->setVisibility();
		$this->UTS->setVisibility();
		$this->UAS->setVisibility();
		$this->Jumlah->setVisibility();
		$this->Nilai->setVisibility();
		$this->Angka->setVisibility();
		$this->kunci->setVisibility();
		$this->inp->setVisibility();
		$this->kls->setVisibility();
		$this->Gujian->setVisibility();
		$this->Minggu1->setVisibility();
		$this->Minggu2->setVisibility();
		$this->Minggu3->setVisibility();
		$this->Minggu4->setVisibility();
		$this->Minggu5->setVisibility();
		$this->Minggu6->setVisibility();
		$this->Minggu7->setVisibility();
		$this->Minggu8->setVisibility();
		$this->Minggu9->setVisibility();
		$this->Minggu10->setVisibility();
		$this->Minggu11->setVisibility();
		$this->Minggu12->setVisibility();
		$this->Minggu13->setVisibility();
		$this->Minggu14->setVisibility();
		$this->Minggu15->setVisibility();
		$this->Minggu16->setVisibility();
		$this->Persentase->setVisibility();
		$this->KelasAkd->setVisibility();
		$this->stat_feeder->Visible = FALSE;
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->Thn_Akademik);
		$this->setupLookupOptions($this->Kode_MK);

		// Check permission
		if (!$Security->canAdd()) {
			$this->setFailureMessage(DeniedMessage()); // No permission
			$this->terminate("tblNilaiPerMhslist.php");
			return;
		}

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-add-form ew-horizontal";
		$postBack = FALSE;

		// Set up current action
		if (IsApi()) {
			$this->CurrentAction = "insert"; // Add record directly
			$postBack = TRUE;
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action"); // Get form action
			$postBack = TRUE;
		} else { // Not post back

			// Load key values from QueryString
			$this->CopyRecord = TRUE;
			if (Get("Nim") !== NULL) {
				$this->Nim->setQueryStringValue(Get("Nim"));
				$this->setKey("Nim", $this->Nim->CurrentValue); // Set up key
			} else {
				$this->setKey("Nim", ""); // Clear key
				$this->CopyRecord = FALSE;
			}
			if (Get("Thn_Akademik") !== NULL) {
				$this->Thn_Akademik->setQueryStringValue(Get("Thn_Akademik"));
				$this->setKey("Thn_Akademik", $this->Thn_Akademik->CurrentValue); // Set up key
			} else {
				$this->setKey("Thn_Akademik", ""); // Clear key
				$this->CopyRecord = FALSE;
			}
			if (Get("Periode") !== NULL) {
				$this->Periode->setQueryStringValue(Get("Periode"));
				$this->setKey("Periode", $this->Periode->CurrentValue); // Set up key
			} else {
				$this->setKey("Periode", ""); // Clear key
				$this->CopyRecord = FALSE;
			}
			if (Get("Kode_MK") !== NULL) {
				$this->Kode_MK->setQueryStringValue(Get("Kode_MK"));
				$this->setKey("Kode_MK", $this->Kode_MK->CurrentValue); // Set up key
			} else {
				$this->setKey("Kode_MK", ""); // Clear key
				$this->CopyRecord = FALSE;
			}
			if ($this->CopyRecord) {
				$this->CurrentAction = "copy"; // Copy record
			} else {
				$this->CurrentAction = "show"; // Display blank record
			}
		}

		// Load old record / default values
		$loaded = $this->loadOldRecord();

		// Set up master/detail parameters
		// NOTE: must be after loadOldRecord to prevent master key values overwritten

		$this->setupMasterParms();

		// Load form values
		if ($postBack) {
			$this->loadFormValues(); // Load form values
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->validateForm()) {
				$this->EventCancelled = TRUE; // Event cancelled
				$this->restoreFormValues(); // Restore form values
				$this->setFailureMessage($FormError);
				if (IsApi()) {
					$this->terminate();
					return;
				} else {
					$this->CurrentAction = "show"; // Form error, reset action
				}
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "copy": // Copy an existing record
				if (!$loaded) { // Record not loaded
					if ($this->getFailureMessage() == "")
						$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
					$this->terminate("tblNilaiPerMhslist.php"); // No matching record, return to list
				}
				break;
			case "insert": // Add new record
				$this->SendEmail = TRUE; // Send email on add success
				if ($this->addRow($this->OldRecordset)) { // Add successful
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
					$returnUrl = $this->getReturnUrl();
					if (GetPageName($returnUrl) == "tblNilaiPerMhslist.php")
						$returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
					elseif (GetPageName($returnUrl) == "tblNilaiPerMhsview.php")
						$returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
					if (IsApi()) { // Return to caller
						$this->terminate(TRUE);
						return;
					} else {
						$this->terminate($returnUrl);
					}
				} elseif (IsApi()) { // API request, return
					$this->terminate();
					return;
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->restoreFormValues(); // Add failed, restore form values
				}
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Render row based on row type
		$this->RowType = ROWTYPE_ADD; // Render add type

		// Render row
		$this->resetAttributes();
		$this->renderRow();
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
	}

	// Load default values
	protected function loadDefaultValues()
	{
		$this->Nim->CurrentValue = NULL;
		$this->Nim->OldValue = $this->Nim->CurrentValue;
		$this->Thn_Akademik->CurrentValue = NULL;
		$this->Thn_Akademik->OldValue = $this->Thn_Akademik->CurrentValue;
		$this->Periode->CurrentValue = NULL;
		$this->Periode->OldValue = $this->Periode->CurrentValue;
		$this->Kode_MK->CurrentValue = NULL;
		$this->Kode_MK->OldValue = $this->Kode_MK->CurrentValue;
		$this->Kehadiran->CurrentValue = 0;
		$this->Tugas->CurrentValue = NULL;
		$this->Tugas->OldValue = $this->Tugas->CurrentValue;
		$this->Quiz->CurrentValue = NULL;
		$this->Quiz->OldValue = $this->Quiz->CurrentValue;
		$this->UTS->CurrentValue = NULL;
		$this->UTS->OldValue = $this->UTS->CurrentValue;
		$this->UAS->CurrentValue = NULL;
		$this->UAS->OldValue = $this->UAS->CurrentValue;
		$this->Jumlah->CurrentValue = NULL;
		$this->Jumlah->OldValue = $this->Jumlah->CurrentValue;
		$this->Nilai->CurrentValue = "-";
		$this->Angka->CurrentValue = 0;
		$this->kunci->CurrentValue = NULL;
		$this->kunci->OldValue = $this->kunci->CurrentValue;
		$this->inp->CurrentValue = NULL;
		$this->inp->OldValue = $this->inp->CurrentValue;
		$this->kls->CurrentValue = "A";
		$this->Gujian->CurrentValue = "A";
		$this->Minggu1->CurrentValue = NULL;
		$this->Minggu1->OldValue = $this->Minggu1->CurrentValue;
		$this->Minggu2->CurrentValue = NULL;
		$this->Minggu2->OldValue = $this->Minggu2->CurrentValue;
		$this->Minggu3->CurrentValue = NULL;
		$this->Minggu3->OldValue = $this->Minggu3->CurrentValue;
		$this->Minggu4->CurrentValue = NULL;
		$this->Minggu4->OldValue = $this->Minggu4->CurrentValue;
		$this->Minggu5->CurrentValue = NULL;
		$this->Minggu5->OldValue = $this->Minggu5->CurrentValue;
		$this->Minggu6->CurrentValue = NULL;
		$this->Minggu6->OldValue = $this->Minggu6->CurrentValue;
		$this->Minggu7->CurrentValue = NULL;
		$this->Minggu7->OldValue = $this->Minggu7->CurrentValue;
		$this->Minggu8->CurrentValue = NULL;
		$this->Minggu8->OldValue = $this->Minggu8->CurrentValue;
		$this->Minggu9->CurrentValue = NULL;
		$this->Minggu9->OldValue = $this->Minggu9->CurrentValue;
		$this->Minggu10->CurrentValue = NULL;
		$this->Minggu10->OldValue = $this->Minggu10->CurrentValue;
		$this->Minggu11->CurrentValue = NULL;
		$this->Minggu11->OldValue = $this->Minggu11->CurrentValue;
		$this->Minggu12->CurrentValue = NULL;
		$this->Minggu12->OldValue = $this->Minggu12->CurrentValue;
		$this->Minggu13->CurrentValue = NULL;
		$this->Minggu13->OldValue = $this->Minggu13->CurrentValue;
		$this->Minggu14->CurrentValue = NULL;
		$this->Minggu14->OldValue = $this->Minggu14->CurrentValue;
		$this->Minggu15->CurrentValue = NULL;
		$this->Minggu15->OldValue = $this->Minggu15->CurrentValue;
		$this->Minggu16->CurrentValue = NULL;
		$this->Minggu16->OldValue = $this->Minggu16->CurrentValue;
		$this->Persentase->CurrentValue = NULL;
		$this->Persentase->OldValue = $this->Persentase->CurrentValue;
		$this->KelasAkd->CurrentValue = NULL;
		$this->KelasAkd->OldValue = $this->KelasAkd->CurrentValue;
		$this->stat_feeder->CurrentValue = NULL;
		$this->stat_feeder->OldValue = $this->stat_feeder->CurrentValue;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;

		// Check field name 'Nim' first before field var 'x_Nim'
		$val = $CurrentForm->hasValue("Nim") ? $CurrentForm->getValue("Nim") : $CurrentForm->getValue("x_Nim");
		if (!$this->Nim->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->Nim->Visible = FALSE; // Disable update for API request
			else
				$this->Nim->setFormValue($val);
		}

		// Check field name 'Thn_Akademik' first before field var 'x_Thn_Akademik'
		$val = $CurrentForm->hasValue("Thn_Akademik") ? $CurrentForm->getValue("Thn_Akademik") : $CurrentForm->getValue("x_Thn_Akademik");
		if (!$this->Thn_Akademik->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->Thn_Akademik->Visible = FALSE; // Disable update for API request
			else
				$this->Thn_Akademik->setFormValue($val);
		}

		// Check field name 'Periode' first before field var 'x_Periode'
		$val = $CurrentForm->hasValue("Periode") ? $CurrentForm->getValue("Periode") : $CurrentForm->getValue("x_Periode");
		if (!$this->Periode->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->Periode->Visible = FALSE; // Disable update for API request
			else
				$this->Periode->setFormValue($val);
		}

		// Check field name 'Kode_MK' first before field var 'x_Kode_MK'
		$val = $CurrentForm->hasValue("Kode_MK") ? $CurrentForm->getValue("Kode_MK") : $CurrentForm->getValue("x_Kode_MK");
		if (!$this->Kode_MK->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->Kode_MK->Visible = FALSE; // Disable update for API request
			else
				$this->Kode_MK->setFormValue($val);
		}

		// Check field name 'Kehadiran' first before field var 'x_Kehadiran'
		$val = $CurrentForm->hasValue("Kehadiran") ? $CurrentForm->getValue("Kehadiran") : $CurrentForm->getValue("x_Kehadiran");
		if (!$this->Kehadiran->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->Kehadiran->Visible = FALSE; // Disable update for API request
			else
				$this->Kehadiran->setFormValue($val);
		}

		// Check field name 'Tugas' first before field var 'x_Tugas'
		$val = $CurrentForm->hasValue("Tugas") ? $CurrentForm->getValue("Tugas") : $CurrentForm->getValue("x_Tugas");
		if (!$this->Tugas->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->Tugas->Visible = FALSE; // Disable update for API request
			else
				$this->Tugas->setFormValue($val);
		}

		// Check field name 'Quiz' first before field var 'x_Quiz'
		$val = $CurrentForm->hasValue("Quiz") ? $CurrentForm->getValue("Quiz") : $CurrentForm->getValue("x_Quiz");
		if (!$this->Quiz->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->Quiz->Visible = FALSE; // Disable update for API request
			else
				$this->Quiz->setFormValue($val);
		}

		// Check field name 'UTS' first before field var 'x_UTS'
		$val = $CurrentForm->hasValue("UTS") ? $CurrentForm->getValue("UTS") : $CurrentForm->getValue("x_UTS");
		if (!$this->UTS->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->UTS->Visible = FALSE; // Disable update for API request
			else
				$this->UTS->setFormValue($val);
		}

		// Check field name 'UAS' first before field var 'x_UAS'
		$val = $CurrentForm->hasValue("UAS") ? $CurrentForm->getValue("UAS") : $CurrentForm->getValue("x_UAS");
		if (!$this->UAS->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->UAS->Visible = FALSE; // Disable update for API request
			else
				$this->UAS->setFormValue($val);
		}

		// Check field name 'Jumlah' first before field var 'x_Jumlah'
		$val = $CurrentForm->hasValue("Jumlah") ? $CurrentForm->getValue("Jumlah") : $CurrentForm->getValue("x_Jumlah");
		if (!$this->Jumlah->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->Jumlah->Visible = FALSE; // Disable update for API request
			else
				$this->Jumlah->setFormValue($val);
		}

		// Check field name 'Nilai' first before field var 'x_Nilai'
		$val = $CurrentForm->hasValue("Nilai") ? $CurrentForm->getValue("Nilai") : $CurrentForm->getValue("x_Nilai");
		if (!$this->Nilai->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->Nilai->Visible = FALSE; // Disable update for API request
			else
				$this->Nilai->setFormValue($val);
		}

		// Check field name 'Angka' first before field var 'x_Angka'
		$val = $CurrentForm->hasValue("Angka") ? $CurrentForm->getValue("Angka") : $CurrentForm->getValue("x_Angka");
		if (!$this->Angka->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->Angka->Visible = FALSE; // Disable update for API request
			else
				$this->Angka->setFormValue($val);
		}

		// Check field name 'kunci' first before field var 'x_kunci'
		$val = $CurrentForm->hasValue("kunci") ? $CurrentForm->getValue("kunci") : $CurrentForm->getValue("x_kunci");
		if (!$this->kunci->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->kunci->Visible = FALSE; // Disable update for API request
			else
				$this->kunci->setFormValue($val);
		}

		// Check field name 'inp' first before field var 'x_inp'
		$val = $CurrentForm->hasValue("inp") ? $CurrentForm->getValue("inp") : $CurrentForm->getValue("x_inp");
		if (!$this->inp->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->inp->Visible = FALSE; // Disable update for API request
			else
				$this->inp->setFormValue($val);
		}

		// Check field name 'kls' first before field var 'x_kls'
		$val = $CurrentForm->hasValue("kls") ? $CurrentForm->getValue("kls") : $CurrentForm->getValue("x_kls");
		if (!$this->kls->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->kls->Visible = FALSE; // Disable update for API request
			else
				$this->kls->setFormValue($val);
		}

		// Check field name 'Gujian' first before field var 'x_Gujian'
		$val = $CurrentForm->hasValue("Gujian") ? $CurrentForm->getValue("Gujian") : $CurrentForm->getValue("x_Gujian");
		if (!$this->Gujian->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->Gujian->Visible = FALSE; // Disable update for API request
			else
				$this->Gujian->setFormValue($val);
		}

		// Check field name 'Minggu1' first before field var 'x_Minggu1'
		$val = $CurrentForm->hasValue("Minggu1") ? $CurrentForm->getValue("Minggu1") : $CurrentForm->getValue("x_Minggu1");
		if (!$this->Minggu1->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->Minggu1->Visible = FALSE; // Disable update for API request
			else
				$this->Minggu1->setFormValue($val);
		}

		// Check field name 'Minggu2' first before field var 'x_Minggu2'
		$val = $CurrentForm->hasValue("Minggu2") ? $CurrentForm->getValue("Minggu2") : $CurrentForm->getValue("x_Minggu2");
		if (!$this->Minggu2->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->Minggu2->Visible = FALSE; // Disable update for API request
			else
				$this->Minggu2->setFormValue($val);
		}

		// Check field name 'Minggu3' first before field var 'x_Minggu3'
		$val = $CurrentForm->hasValue("Minggu3") ? $CurrentForm->getValue("Minggu3") : $CurrentForm->getValue("x_Minggu3");
		if (!$this->Minggu3->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->Minggu3->Visible = FALSE; // Disable update for API request
			else
				$this->Minggu3->setFormValue($val);
		}

		// Check field name 'Minggu4' first before field var 'x_Minggu4'
		$val = $CurrentForm->hasValue("Minggu4") ? $CurrentForm->getValue("Minggu4") : $CurrentForm->getValue("x_Minggu4");
		if (!$this->Minggu4->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->Minggu4->Visible = FALSE; // Disable update for API request
			else
				$this->Minggu4->setFormValue($val);
		}

		// Check field name 'Minggu5' first before field var 'x_Minggu5'
		$val = $CurrentForm->hasValue("Minggu5") ? $CurrentForm->getValue("Minggu5") : $CurrentForm->getValue("x_Minggu5");
		if (!$this->Minggu5->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->Minggu5->Visible = FALSE; // Disable update for API request
			else
				$this->Minggu5->setFormValue($val);
		}

		// Check field name 'Minggu6' first before field var 'x_Minggu6'
		$val = $CurrentForm->hasValue("Minggu6") ? $CurrentForm->getValue("Minggu6") : $CurrentForm->getValue("x_Minggu6");
		if (!$this->Minggu6->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->Minggu6->Visible = FALSE; // Disable update for API request
			else
				$this->Minggu6->setFormValue($val);
		}

		// Check field name 'Minggu7' first before field var 'x_Minggu7'
		$val = $CurrentForm->hasValue("Minggu7") ? $CurrentForm->getValue("Minggu7") : $CurrentForm->getValue("x_Minggu7");
		if (!$this->Minggu7->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->Minggu7->Visible = FALSE; // Disable update for API request
			else
				$this->Minggu7->setFormValue($val);
		}

		// Check field name 'Minggu8' first before field var 'x_Minggu8'
		$val = $CurrentForm->hasValue("Minggu8") ? $CurrentForm->getValue("Minggu8") : $CurrentForm->getValue("x_Minggu8");
		if (!$this->Minggu8->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->Minggu8->Visible = FALSE; // Disable update for API request
			else
				$this->Minggu8->setFormValue($val);
		}

		// Check field name 'Minggu9' first before field var 'x_Minggu9'
		$val = $CurrentForm->hasValue("Minggu9") ? $CurrentForm->getValue("Minggu9") : $CurrentForm->getValue("x_Minggu9");
		if (!$this->Minggu9->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->Minggu9->Visible = FALSE; // Disable update for API request
			else
				$this->Minggu9->setFormValue($val);
		}

		// Check field name 'Minggu10' first before field var 'x_Minggu10'
		$val = $CurrentForm->hasValue("Minggu10") ? $CurrentForm->getValue("Minggu10") : $CurrentForm->getValue("x_Minggu10");
		if (!$this->Minggu10->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->Minggu10->Visible = FALSE; // Disable update for API request
			else
				$this->Minggu10->setFormValue($val);
		}

		// Check field name 'Minggu11' first before field var 'x_Minggu11'
		$val = $CurrentForm->hasValue("Minggu11") ? $CurrentForm->getValue("Minggu11") : $CurrentForm->getValue("x_Minggu11");
		if (!$this->Minggu11->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->Minggu11->Visible = FALSE; // Disable update for API request
			else
				$this->Minggu11->setFormValue($val);
		}

		// Check field name 'Minggu12' first before field var 'x_Minggu12'
		$val = $CurrentForm->hasValue("Minggu12") ? $CurrentForm->getValue("Minggu12") : $CurrentForm->getValue("x_Minggu12");
		if (!$this->Minggu12->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->Minggu12->Visible = FALSE; // Disable update for API request
			else
				$this->Minggu12->setFormValue($val);
		}

		// Check field name 'Minggu13' first before field var 'x_Minggu13'
		$val = $CurrentForm->hasValue("Minggu13") ? $CurrentForm->getValue("Minggu13") : $CurrentForm->getValue("x_Minggu13");
		if (!$this->Minggu13->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->Minggu13->Visible = FALSE; // Disable update for API request
			else
				$this->Minggu13->setFormValue($val);
		}

		// Check field name 'Minggu14' first before field var 'x_Minggu14'
		$val = $CurrentForm->hasValue("Minggu14") ? $CurrentForm->getValue("Minggu14") : $CurrentForm->getValue("x_Minggu14");
		if (!$this->Minggu14->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->Minggu14->Visible = FALSE; // Disable update for API request
			else
				$this->Minggu14->setFormValue($val);
		}

		// Check field name 'Minggu15' first before field var 'x_Minggu15'
		$val = $CurrentForm->hasValue("Minggu15") ? $CurrentForm->getValue("Minggu15") : $CurrentForm->getValue("x_Minggu15");
		if (!$this->Minggu15->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->Minggu15->Visible = FALSE; // Disable update for API request
			else
				$this->Minggu15->setFormValue($val);
		}

		// Check field name 'Minggu16' first before field var 'x_Minggu16'
		$val = $CurrentForm->hasValue("Minggu16") ? $CurrentForm->getValue("Minggu16") : $CurrentForm->getValue("x_Minggu16");
		if (!$this->Minggu16->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->Minggu16->Visible = FALSE; // Disable update for API request
			else
				$this->Minggu16->setFormValue($val);
		}

		// Check field name 'Persentase' first before field var 'x_Persentase'
		$val = $CurrentForm->hasValue("Persentase") ? $CurrentForm->getValue("Persentase") : $CurrentForm->getValue("x_Persentase");
		if (!$this->Persentase->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->Persentase->Visible = FALSE; // Disable update for API request
			else
				$this->Persentase->setFormValue($val);
		}

		// Check field name 'KelasAkd' first before field var 'x_KelasAkd'
		$val = $CurrentForm->hasValue("KelasAkd") ? $CurrentForm->getValue("KelasAkd") : $CurrentForm->getValue("x_KelasAkd");
		if (!$this->KelasAkd->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->KelasAkd->Visible = FALSE; // Disable update for API request
			else
				$this->KelasAkd->setFormValue($val);
		}
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->Nim->CurrentValue = $this->Nim->FormValue;
		$this->Thn_Akademik->CurrentValue = $this->Thn_Akademik->FormValue;
		$this->Periode->CurrentValue = $this->Periode->FormValue;
		$this->Kode_MK->CurrentValue = $this->Kode_MK->FormValue;
		$this->Kehadiran->CurrentValue = $this->Kehadiran->FormValue;
		$this->Tugas->CurrentValue = $this->Tugas->FormValue;
		$this->Quiz->CurrentValue = $this->Quiz->FormValue;
		$this->UTS->CurrentValue = $this->UTS->FormValue;
		$this->UAS->CurrentValue = $this->UAS->FormValue;
		$this->Jumlah->CurrentValue = $this->Jumlah->FormValue;
		$this->Nilai->CurrentValue = $this->Nilai->FormValue;
		$this->Angka->CurrentValue = $this->Angka->FormValue;
		$this->kunci->CurrentValue = $this->kunci->FormValue;
		$this->inp->CurrentValue = $this->inp->FormValue;
		$this->kls->CurrentValue = $this->kls->FormValue;
		$this->Gujian->CurrentValue = $this->Gujian->FormValue;
		$this->Minggu1->CurrentValue = $this->Minggu1->FormValue;
		$this->Minggu2->CurrentValue = $this->Minggu2->FormValue;
		$this->Minggu3->CurrentValue = $this->Minggu3->FormValue;
		$this->Minggu4->CurrentValue = $this->Minggu4->FormValue;
		$this->Minggu5->CurrentValue = $this->Minggu5->FormValue;
		$this->Minggu6->CurrentValue = $this->Minggu6->FormValue;
		$this->Minggu7->CurrentValue = $this->Minggu7->FormValue;
		$this->Minggu8->CurrentValue = $this->Minggu8->FormValue;
		$this->Minggu9->CurrentValue = $this->Minggu9->FormValue;
		$this->Minggu10->CurrentValue = $this->Minggu10->FormValue;
		$this->Minggu11->CurrentValue = $this->Minggu11->FormValue;
		$this->Minggu12->CurrentValue = $this->Minggu12->FormValue;
		$this->Minggu13->CurrentValue = $this->Minggu13->FormValue;
		$this->Minggu14->CurrentValue = $this->Minggu14->FormValue;
		$this->Minggu15->CurrentValue = $this->Minggu15->FormValue;
		$this->Minggu16->CurrentValue = $this->Minggu16->FormValue;
		$this->Persentase->CurrentValue = $this->Persentase->FormValue;
		$this->KelasAkd->CurrentValue = $this->KelasAkd->FormValue;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = $this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->Nim->setDbValue($row['Nim']);
		$this->Thn_Akademik->setDbValue($row['Thn_Akademik']);
		$this->Periode->setDbValue($row['Periode']);
		$this->Kode_MK->setDbValue($row['Kode_MK']);
		$this->Kehadiran->setDbValue($row['Kehadiran']);
		$this->Tugas->setDbValue($row['Tugas']);
		$this->Quiz->setDbValue($row['Quiz']);
		$this->UTS->setDbValue($row['UTS']);
		$this->UAS->setDbValue($row['UAS']);
		$this->Jumlah->setDbValue($row['Jumlah']);
		$this->Nilai->setDbValue($row['Nilai']);
		$this->Angka->setDbValue($row['Angka']);
		$this->kunci->setDbValue($row['kunci']);
		$this->inp->setDbValue($row['inp']);
		$this->kls->setDbValue($row['kls']);
		$this->Gujian->setDbValue($row['Gujian']);
		$this->Minggu1->setDbValue($row['Minggu1']);
		$this->Minggu2->setDbValue($row['Minggu2']);
		$this->Minggu3->setDbValue($row['Minggu3']);
		$this->Minggu4->setDbValue($row['Minggu4']);
		$this->Minggu5->setDbValue($row['Minggu5']);
		$this->Minggu6->setDbValue($row['Minggu6']);
		$this->Minggu7->setDbValue($row['Minggu7']);
		$this->Minggu8->setDbValue($row['Minggu8']);
		$this->Minggu9->setDbValue($row['Minggu9']);
		$this->Minggu10->setDbValue($row['Minggu10']);
		$this->Minggu11->setDbValue($row['Minggu11']);
		$this->Minggu12->setDbValue($row['Minggu12']);
		$this->Minggu13->setDbValue($row['Minggu13']);
		$this->Minggu14->setDbValue($row['Minggu14']);
		$this->Minggu15->setDbValue($row['Minggu15']);
		$this->Minggu16->setDbValue($row['Minggu16']);
		$this->Persentase->setDbValue($row['Persentase']);
		$this->KelasAkd->setDbValue($row['KelasAkd']);
		$this->stat_feeder->setDbValue($row['stat_feeder']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$this->loadDefaultValues();
		$row = [];
		$row['Nim'] = $this->Nim->CurrentValue;
		$row['Thn_Akademik'] = $this->Thn_Akademik->CurrentValue;
		$row['Periode'] = $this->Periode->CurrentValue;
		$row['Kode_MK'] = $this->Kode_MK->CurrentValue;
		$row['Kehadiran'] = $this->Kehadiran->CurrentValue;
		$row['Tugas'] = $this->Tugas->CurrentValue;
		$row['Quiz'] = $this->Quiz->CurrentValue;
		$row['UTS'] = $this->UTS->CurrentValue;
		$row['UAS'] = $this->UAS->CurrentValue;
		$row['Jumlah'] = $this->Jumlah->CurrentValue;
		$row['Nilai'] = $this->Nilai->CurrentValue;
		$row['Angka'] = $this->Angka->CurrentValue;
		$row['kunci'] = $this->kunci->CurrentValue;
		$row['inp'] = $this->inp->CurrentValue;
		$row['kls'] = $this->kls->CurrentValue;
		$row['Gujian'] = $this->Gujian->CurrentValue;
		$row['Minggu1'] = $this->Minggu1->CurrentValue;
		$row['Minggu2'] = $this->Minggu2->CurrentValue;
		$row['Minggu3'] = $this->Minggu3->CurrentValue;
		$row['Minggu4'] = $this->Minggu4->CurrentValue;
		$row['Minggu5'] = $this->Minggu5->CurrentValue;
		$row['Minggu6'] = $this->Minggu6->CurrentValue;
		$row['Minggu7'] = $this->Minggu7->CurrentValue;
		$row['Minggu8'] = $this->Minggu8->CurrentValue;
		$row['Minggu9'] = $this->Minggu9->CurrentValue;
		$row['Minggu10'] = $this->Minggu10->CurrentValue;
		$row['Minggu11'] = $this->Minggu11->CurrentValue;
		$row['Minggu12'] = $this->Minggu12->CurrentValue;
		$row['Minggu13'] = $this->Minggu13->CurrentValue;
		$row['Minggu14'] = $this->Minggu14->CurrentValue;
		$row['Minggu15'] = $this->Minggu15->CurrentValue;
		$row['Minggu16'] = $this->Minggu16->CurrentValue;
		$row['Persentase'] = $this->Persentase->CurrentValue;
		$row['KelasAkd'] = $this->KelasAkd->CurrentValue;
		$row['stat_feeder'] = $this->stat_feeder->CurrentValue;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("Nim")) != "")
			$this->Nim->OldValue = $this->getKey("Nim"); // Nim
		else
			$validKey = FALSE;
		if (strval($this->getKey("Thn_Akademik")) != "")
			$this->Thn_Akademik->OldValue = $this->getKey("Thn_Akademik"); // Thn_Akademik
		else
			$validKey = FALSE;
		if (strval($this->getKey("Periode")) != "")
			$this->Periode->OldValue = $this->getKey("Periode"); // Periode
		else
			$validKey = FALSE;
		if (strval($this->getKey("Kode_MK")) != "")
			$this->Kode_MK->OldValue = $this->getKey("Kode_MK"); // Kode_MK
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = $this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->Kehadiran->FormValue == $this->Kehadiran->CurrentValue && is_numeric(ConvertToFloatString($this->Kehadiran->CurrentValue)))
			$this->Kehadiran->CurrentValue = ConvertToFloatString($this->Kehadiran->CurrentValue);

		// Convert decimal values if posted back
		if ($this->Tugas->FormValue == $this->Tugas->CurrentValue && is_numeric(ConvertToFloatString($this->Tugas->CurrentValue)))
			$this->Tugas->CurrentValue = ConvertToFloatString($this->Tugas->CurrentValue);

		// Convert decimal values if posted back
		if ($this->Quiz->FormValue == $this->Quiz->CurrentValue && is_numeric(ConvertToFloatString($this->Quiz->CurrentValue)))
			$this->Quiz->CurrentValue = ConvertToFloatString($this->Quiz->CurrentValue);

		// Convert decimal values if posted back
		if ($this->UTS->FormValue == $this->UTS->CurrentValue && is_numeric(ConvertToFloatString($this->UTS->CurrentValue)))
			$this->UTS->CurrentValue = ConvertToFloatString($this->UTS->CurrentValue);

		// Convert decimal values if posted back
		if ($this->UAS->FormValue == $this->UAS->CurrentValue && is_numeric(ConvertToFloatString($this->UAS->CurrentValue)))
			$this->UAS->CurrentValue = ConvertToFloatString($this->UAS->CurrentValue);

		// Convert decimal values if posted back
		if ($this->Jumlah->FormValue == $this->Jumlah->CurrentValue && is_numeric(ConvertToFloatString($this->Jumlah->CurrentValue)))
			$this->Jumlah->CurrentValue = ConvertToFloatString($this->Jumlah->CurrentValue);

		// Convert decimal values if posted back
		if ($this->Angka->FormValue == $this->Angka->CurrentValue && is_numeric(ConvertToFloatString($this->Angka->CurrentValue)))
			$this->Angka->CurrentValue = ConvertToFloatString($this->Angka->CurrentValue);

		// Convert decimal values if posted back
		if ($this->Persentase->FormValue == $this->Persentase->CurrentValue && is_numeric(ConvertToFloatString($this->Persentase->CurrentValue)))
			$this->Persentase->CurrentValue = ConvertToFloatString($this->Persentase->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// Nim
		// Thn_Akademik
		// Periode
		// Kode_MK
		// Kehadiran
		// Tugas
		// Quiz
		// UTS
		// UAS
		// Jumlah
		// Nilai
		// Angka
		// kunci
		// inp
		// kls
		// Gujian
		// Minggu1
		// Minggu2
		// Minggu3
		// Minggu4
		// Minggu5
		// Minggu6
		// Minggu7
		// Minggu8
		// Minggu9
		// Minggu10
		// Minggu11
		// Minggu12
		// Minggu13
		// Minggu14
		// Minggu15
		// Minggu16
		// Persentase
		// KelasAkd
		// stat_feeder

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// Nim
			$this->Nim->ViewValue = $this->Nim->CurrentValue;
			$this->Nim->ViewCustomAttributes = "";

			// Thn_Akademik
			$curVal = strval($this->Thn_Akademik->CurrentValue);
			if ($curVal != "") {
				$this->Thn_Akademik->ViewValue = $this->Thn_Akademik->lookupCacheOption($curVal);
				if ($this->Thn_Akademik->ViewValue === NULL) { // Lookup from database
					$filterWrk = "[TA]" . SearchString("=", $curVal, DATATYPE_STRING, "");
					$sqlWrk = $this->Thn_Akademik->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = [];
						$arwrk[1] = $rswrk->fields('df');
						$this->Thn_Akademik->ViewValue = $this->Thn_Akademik->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->Thn_Akademik->ViewValue = $this->Thn_Akademik->CurrentValue;
					}
				}
			} else {
				$this->Thn_Akademik->ViewValue = NULL;
			}
			$this->Thn_Akademik->ViewCustomAttributes = "";

			// Periode
			if (strval($this->Periode->CurrentValue) != "") {
				$this->Periode->ViewValue = $this->Periode->optionCaption($this->Periode->CurrentValue);
			} else {
				$this->Periode->ViewValue = NULL;
			}
			$this->Periode->ViewCustomAttributes = "";

			// Kode_MK
			$this->Kode_MK->ViewValue = $this->Kode_MK->CurrentValue;
			$curVal = strval($this->Kode_MK->CurrentValue);
			if ($curVal != "") {
				$this->Kode_MK->ViewValue = $this->Kode_MK->lookupCacheOption($curVal);
				if ($this->Kode_MK->ViewValue === NULL) { // Lookup from database
					$filterWrk = "[Kode_MK]" . SearchString("=", $curVal, DATATYPE_STRING, "");
					$sqlWrk = $this->Kode_MK->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = [];
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$arwrk[3] = FormatNumber($rswrk->fields('df3'), 0, -2, -2, -2);
						$this->Kode_MK->ViewValue = $this->Kode_MK->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->Kode_MK->ViewValue = $this->Kode_MK->CurrentValue;
					}
				}
			} else {
				$this->Kode_MK->ViewValue = NULL;
			}
			$this->Kode_MK->ViewCustomAttributes = "";

			// Kehadiran
			$this->Kehadiran->ViewValue = $this->Kehadiran->CurrentValue;
			$this->Kehadiran->ViewValue = FormatNumber($this->Kehadiran->ViewValue, 2, -2, -2, -2);
			$this->Kehadiran->CellCssStyle .= "text-align: right;";
			$this->Kehadiran->ViewCustomAttributes = "";

			// Tugas
			$this->Tugas->ViewValue = $this->Tugas->CurrentValue;
			$this->Tugas->ViewValue = FormatNumber($this->Tugas->ViewValue, 2, -2, -2, -2);
			$this->Tugas->CellCssStyle .= "text-align: right;";
			$this->Tugas->ViewCustomAttributes = "";

			// Quiz
			$this->Quiz->ViewValue = $this->Quiz->CurrentValue;
			$this->Quiz->ViewValue = FormatNumber($this->Quiz->ViewValue, 2, -2, -2, -2);
			$this->Quiz->ViewCustomAttributes = "";

			// UTS
			$this->UTS->ViewValue = $this->UTS->CurrentValue;
			$this->UTS->ViewValue = FormatNumber($this->UTS->ViewValue, 2, -2, -2, -2);
			$this->UTS->CellCssStyle .= "text-align: right;";
			$this->UTS->ViewCustomAttributes = "";

			// UAS
			$this->UAS->ViewValue = $this->UAS->CurrentValue;
			$this->UAS->ViewValue = FormatNumber($this->UAS->ViewValue, 2, -2, -2, -2);
			$this->UAS->CellCssStyle .= "text-align: right;";
			$this->UAS->ViewCustomAttributes = "";

			// Jumlah
			$this->Jumlah->ViewValue = $this->Jumlah->CurrentValue;
			$this->Jumlah->ViewValue = FormatNumber($this->Jumlah->ViewValue, 2, -2, -2, -2);
			$this->Jumlah->CellCssStyle .= "text-align: right;";
			$this->Jumlah->ViewCustomAttributes = "";

			// Nilai
			$this->Nilai->ViewValue = $this->Nilai->CurrentValue;
			$this->Nilai->CellCssStyle .= "text-align: right;";
			$this->Nilai->ViewCustomAttributes = "";

			// Angka
			$this->Angka->ViewValue = $this->Angka->CurrentValue;
			$this->Angka->ViewValue = FormatNumber($this->Angka->ViewValue, 2, -2, -2, -2);
			$this->Angka->CellCssStyle .= "text-align: right;";
			$this->Angka->ViewCustomAttributes = "";

			// kunci
			$this->kunci->ViewValue = $this->kunci->CurrentValue;
			$this->kunci->ViewCustomAttributes = "";

			// inp
			$this->inp->ViewValue = $this->inp->CurrentValue;
			$this->inp->ViewCustomAttributes = "";

			// kls
			$this->kls->ViewValue = $this->kls->CurrentValue;
			$this->kls->CellCssStyle .= "text-align: right;";
			$this->kls->ViewCustomAttributes = "";

			// Gujian
			$this->Gujian->ViewValue = $this->Gujian->CurrentValue;
			$this->Gujian->ViewCustomAttributes = "";

			// Minggu1
			$this->Minggu1->ViewValue = $this->Minggu1->CurrentValue;
			$this->Minggu1->ViewCustomAttributes = "";

			// Minggu2
			$this->Minggu2->ViewValue = $this->Minggu2->CurrentValue;
			$this->Minggu2->ViewCustomAttributes = "";

			// Minggu3
			$this->Minggu3->ViewValue = $this->Minggu3->CurrentValue;
			$this->Minggu3->ViewCustomAttributes = "";

			// Minggu4
			$this->Minggu4->ViewValue = $this->Minggu4->CurrentValue;
			$this->Minggu4->ViewCustomAttributes = "";

			// Minggu5
			$this->Minggu5->ViewValue = $this->Minggu5->CurrentValue;
			$this->Minggu5->ViewCustomAttributes = "";

			// Minggu6
			$this->Minggu6->ViewValue = $this->Minggu6->CurrentValue;
			$this->Minggu6->ViewCustomAttributes = "";

			// Minggu7
			$this->Minggu7->ViewValue = $this->Minggu7->CurrentValue;
			$this->Minggu7->ViewCustomAttributes = "";

			// Minggu8
			$this->Minggu8->ViewValue = $this->Minggu8->CurrentValue;
			$this->Minggu8->ViewCustomAttributes = "";

			// Minggu9
			$this->Minggu9->ViewValue = $this->Minggu9->CurrentValue;
			$this->Minggu9->ViewCustomAttributes = "";

			// Minggu10
			$this->Minggu10->ViewValue = $this->Minggu10->CurrentValue;
			$this->Minggu10->ViewCustomAttributes = "";

			// Minggu11
			$this->Minggu11->ViewValue = $this->Minggu11->CurrentValue;
			$this->Minggu11->ViewCustomAttributes = "";

			// Minggu12
			$this->Minggu12->ViewValue = $this->Minggu12->CurrentValue;
			$this->Minggu12->ViewCustomAttributes = "";

			// Minggu13
			$this->Minggu13->ViewValue = $this->Minggu13->CurrentValue;
			$this->Minggu13->ViewCustomAttributes = "";

			// Minggu14
			$this->Minggu14->ViewValue = $this->Minggu14->CurrentValue;
			$this->Minggu14->ViewCustomAttributes = "";

			// Minggu15
			$this->Minggu15->ViewValue = $this->Minggu15->CurrentValue;
			$this->Minggu15->ViewCustomAttributes = "";

			// Minggu16
			$this->Minggu16->ViewValue = $this->Minggu16->CurrentValue;
			$this->Minggu16->ViewCustomAttributes = "";

			// Persentase
			$this->Persentase->ViewValue = $this->Persentase->CurrentValue;
			$this->Persentase->ViewValue = FormatNumber($this->Persentase->ViewValue, 2, -2, -2, -2);
			$this->Persentase->ViewCustomAttributes = "";

			// KelasAkd
			$this->KelasAkd->ViewValue = $this->KelasAkd->CurrentValue;
			$this->KelasAkd->ViewCustomAttributes = "";

			// stat_feeder
			$this->stat_feeder->ViewValue = $this->stat_feeder->CurrentValue;
			$this->stat_feeder->ViewCustomAttributes = "";

			// Nim
			$this->Nim->LinkCustomAttributes = "";
			$this->Nim->HrefValue = "";
			$this->Nim->TooltipValue = "";

			// Thn_Akademik
			$this->Thn_Akademik->LinkCustomAttributes = "";
			$this->Thn_Akademik->HrefValue = "";
			$this->Thn_Akademik->TooltipValue = "";

			// Periode
			$this->Periode->LinkCustomAttributes = "";
			$this->Periode->HrefValue = "";
			$this->Periode->TooltipValue = "";

			// Kode_MK
			$this->Kode_MK->LinkCustomAttributes = "";
			$this->Kode_MK->HrefValue = "";
			$this->Kode_MK->TooltipValue = "";

			// Kehadiran
			$this->Kehadiran->LinkCustomAttributes = "";
			$this->Kehadiran->HrefValue = "";
			$this->Kehadiran->TooltipValue = "";

			// Tugas
			$this->Tugas->LinkCustomAttributes = "";
			$this->Tugas->HrefValue = "";
			$this->Tugas->TooltipValue = "";

			// Quiz
			$this->Quiz->LinkCustomAttributes = "";
			$this->Quiz->HrefValue = "";
			$this->Quiz->TooltipValue = "";

			// UTS
			$this->UTS->LinkCustomAttributes = "";
			$this->UTS->HrefValue = "";
			$this->UTS->TooltipValue = "";

			// UAS
			$this->UAS->LinkCustomAttributes = "";
			$this->UAS->HrefValue = "";
			$this->UAS->TooltipValue = "";

			// Jumlah
			$this->Jumlah->LinkCustomAttributes = "";
			$this->Jumlah->HrefValue = "";
			$this->Jumlah->TooltipValue = "";

			// Nilai
			$this->Nilai->LinkCustomAttributes = "";
			$this->Nilai->HrefValue = "";
			$this->Nilai->TooltipValue = "";

			// Angka
			$this->Angka->LinkCustomAttributes = "";
			$this->Angka->HrefValue = "";
			$this->Angka->TooltipValue = "";

			// kunci
			$this->kunci->LinkCustomAttributes = "";
			$this->kunci->HrefValue = "";
			$this->kunci->TooltipValue = "";

			// inp
			$this->inp->LinkCustomAttributes = "";
			$this->inp->HrefValue = "";
			$this->inp->TooltipValue = "";

			// kls
			$this->kls->LinkCustomAttributes = "";
			$this->kls->HrefValue = "";
			$this->kls->TooltipValue = "";

			// Gujian
			$this->Gujian->LinkCustomAttributes = "";
			$this->Gujian->HrefValue = "";
			$this->Gujian->TooltipValue = "";

			// Minggu1
			$this->Minggu1->LinkCustomAttributes = "";
			$this->Minggu1->HrefValue = "";
			$this->Minggu1->TooltipValue = "";

			// Minggu2
			$this->Minggu2->LinkCustomAttributes = "";
			$this->Minggu2->HrefValue = "";
			$this->Minggu2->TooltipValue = "";

			// Minggu3
			$this->Minggu3->LinkCustomAttributes = "";
			$this->Minggu3->HrefValue = "";
			$this->Minggu3->TooltipValue = "";

			// Minggu4
			$this->Minggu4->LinkCustomAttributes = "";
			$this->Minggu4->HrefValue = "";
			$this->Minggu4->TooltipValue = "";

			// Minggu5
			$this->Minggu5->LinkCustomAttributes = "";
			$this->Minggu5->HrefValue = "";
			$this->Minggu5->TooltipValue = "";

			// Minggu6
			$this->Minggu6->LinkCustomAttributes = "";
			$this->Minggu6->HrefValue = "";
			$this->Minggu6->TooltipValue = "";

			// Minggu7
			$this->Minggu7->LinkCustomAttributes = "";
			$this->Minggu7->HrefValue = "";
			$this->Minggu7->TooltipValue = "";

			// Minggu8
			$this->Minggu8->LinkCustomAttributes = "";
			$this->Minggu8->HrefValue = "";
			$this->Minggu8->TooltipValue = "";

			// Minggu9
			$this->Minggu9->LinkCustomAttributes = "";
			$this->Minggu9->HrefValue = "";
			$this->Minggu9->TooltipValue = "";

			// Minggu10
			$this->Minggu10->LinkCustomAttributes = "";
			$this->Minggu10->HrefValue = "";
			$this->Minggu10->TooltipValue = "";

			// Minggu11
			$this->Minggu11->LinkCustomAttributes = "";
			$this->Minggu11->HrefValue = "";
			$this->Minggu11->TooltipValue = "";

			// Minggu12
			$this->Minggu12->LinkCustomAttributes = "";
			$this->Minggu12->HrefValue = "";
			$this->Minggu12->TooltipValue = "";

			// Minggu13
			$this->Minggu13->LinkCustomAttributes = "";
			$this->Minggu13->HrefValue = "";
			$this->Minggu13->TooltipValue = "";

			// Minggu14
			$this->Minggu14->LinkCustomAttributes = "";
			$this->Minggu14->HrefValue = "";
			$this->Minggu14->TooltipValue = "";

			// Minggu15
			$this->Minggu15->LinkCustomAttributes = "";
			$this->Minggu15->HrefValue = "";
			$this->Minggu15->TooltipValue = "";

			// Minggu16
			$this->Minggu16->LinkCustomAttributes = "";
			$this->Minggu16->HrefValue = "";
			$this->Minggu16->TooltipValue = "";

			// Persentase
			$this->Persentase->LinkCustomAttributes = "";
			$this->Persentase->HrefValue = "";
			$this->Persentase->TooltipValue = "";

			// KelasAkd
			$this->KelasAkd->LinkCustomAttributes = "";
			$this->KelasAkd->HrefValue = "";
			$this->KelasAkd->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_ADD) { // Add row

			// Nim
			$this->Nim->EditAttrs["class"] = "form-control";
			$this->Nim->EditCustomAttributes = "";
			if ($this->Nim->getSessionValue() != "") {
				$this->Nim->CurrentValue = $this->Nim->getSessionValue();
				$this->Nim->ViewValue = $this->Nim->CurrentValue;
				$this->Nim->ViewCustomAttributes = "";
			} else {
				if (!$this->Nim->Raw)
					$this->Nim->CurrentValue = HtmlDecode($this->Nim->CurrentValue);
				$this->Nim->EditValue = HtmlEncode($this->Nim->CurrentValue);
				$this->Nim->PlaceHolder = RemoveHtml($this->Nim->caption());
			}

			// Thn_Akademik
			$this->Thn_Akademik->EditAttrs["class"] = "form-control";
			$this->Thn_Akademik->EditCustomAttributes = "";
			$curVal = trim(strval($this->Thn_Akademik->CurrentValue));
			if ($curVal != "")
				$this->Thn_Akademik->ViewValue = $this->Thn_Akademik->lookupCacheOption($curVal);
			else
				$this->Thn_Akademik->ViewValue = $this->Thn_Akademik->Lookup !== NULL && is_array($this->Thn_Akademik->Lookup->Options) ? $curVal : NULL;
			if ($this->Thn_Akademik->ViewValue !== NULL) { // Load from cache
				$this->Thn_Akademik->EditValue = array_values($this->Thn_Akademik->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "[TA]" . SearchString("=", $this->Thn_Akademik->CurrentValue, DATATYPE_STRING, "");
				}
				$sqlWrk = $this->Thn_Akademik->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = $rswrk ? $rswrk->getRows() : [];
				if ($rswrk)
					$rswrk->close();
				$this->Thn_Akademik->EditValue = $arwrk;
			}

			// Periode
			$this->Periode->EditAttrs["class"] = "form-control";
			$this->Periode->EditCustomAttributes = "";
			$this->Periode->EditValue = $this->Periode->options(TRUE);

			// Kode_MK
			$this->Kode_MK->EditAttrs["class"] = "form-control";
			$this->Kode_MK->EditCustomAttributes = "";
			if (!$this->Kode_MK->Raw)
				$this->Kode_MK->CurrentValue = HtmlDecode($this->Kode_MK->CurrentValue);
			$this->Kode_MK->EditValue = HtmlEncode($this->Kode_MK->CurrentValue);
			$curVal = strval($this->Kode_MK->CurrentValue);
			if ($curVal != "") {
				$this->Kode_MK->EditValue = $this->Kode_MK->lookupCacheOption($curVal);
				if ($this->Kode_MK->EditValue === NULL) { // Lookup from database
					$filterWrk = "[Kode_MK]" . SearchString("=", $curVal, DATATYPE_STRING, "");
					$sqlWrk = $this->Kode_MK->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = [];
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$arwrk[2] = HtmlEncode($rswrk->fields('df2'));
						$arwrk[3] = HtmlEncode(FormatNumber($rswrk->fields('df3'), 0, -2, -2, -2));
						$this->Kode_MK->EditValue = $this->Kode_MK->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->Kode_MK->EditValue = HtmlEncode($this->Kode_MK->CurrentValue);
					}
				}
			} else {
				$this->Kode_MK->EditValue = NULL;
			}
			$this->Kode_MK->PlaceHolder = RemoveHtml($this->Kode_MK->caption());

			// Kehadiran
			$this->Kehadiran->EditAttrs["class"] = "form-control";
			$this->Kehadiran->EditCustomAttributes = "";
			$this->Kehadiran->EditValue = HtmlEncode($this->Kehadiran->CurrentValue);
			$this->Kehadiran->PlaceHolder = RemoveHtml($this->Kehadiran->caption());
			if (strval($this->Kehadiran->EditValue) != "" && is_numeric($this->Kehadiran->EditValue))
				$this->Kehadiran->EditValue = FormatNumber($this->Kehadiran->EditValue, -2, -2, -2, -2);
			

			// Tugas
			$this->Tugas->EditAttrs["class"] = "form-control";
			$this->Tugas->EditCustomAttributes = "";
			$this->Tugas->EditValue = HtmlEncode($this->Tugas->CurrentValue);
			$this->Tugas->PlaceHolder = RemoveHtml($this->Tugas->caption());
			if (strval($this->Tugas->EditValue) != "" && is_numeric($this->Tugas->EditValue))
				$this->Tugas->EditValue = FormatNumber($this->Tugas->EditValue, -2, -2, -2, -2);
			

			// Quiz
			$this->Quiz->EditAttrs["class"] = "form-control";
			$this->Quiz->EditCustomAttributes = "";
			$this->Quiz->EditValue = HtmlEncode($this->Quiz->CurrentValue);
			$this->Quiz->PlaceHolder = RemoveHtml($this->Quiz->caption());
			if (strval($this->Quiz->EditValue) != "" && is_numeric($this->Quiz->EditValue))
				$this->Quiz->EditValue = FormatNumber($this->Quiz->EditValue, -2, -2, -2, -2);
			

			// UTS
			$this->UTS->EditAttrs["class"] = "form-control";
			$this->UTS->EditCustomAttributes = "";
			$this->UTS->EditValue = HtmlEncode($this->UTS->CurrentValue);
			$this->UTS->PlaceHolder = RemoveHtml($this->UTS->caption());
			if (strval($this->UTS->EditValue) != "" && is_numeric($this->UTS->EditValue))
				$this->UTS->EditValue = FormatNumber($this->UTS->EditValue, -2, -2, -2, -2);
			

			// UAS
			$this->UAS->EditAttrs["class"] = "form-control";
			$this->UAS->EditCustomAttributes = "";
			$this->UAS->EditValue = HtmlEncode($this->UAS->CurrentValue);
			$this->UAS->PlaceHolder = RemoveHtml($this->UAS->caption());
			if (strval($this->UAS->EditValue) != "" && is_numeric($this->UAS->EditValue))
				$this->UAS->EditValue = FormatNumber($this->UAS->EditValue, -2, -2, -2, -2);
			

			// Jumlah
			$this->Jumlah->EditAttrs["class"] = "form-control";
			$this->Jumlah->EditCustomAttributes = "";
			$this->Jumlah->EditValue = HtmlEncode($this->Jumlah->CurrentValue);
			$this->Jumlah->PlaceHolder = RemoveHtml($this->Jumlah->caption());
			if (strval($this->Jumlah->EditValue) != "" && is_numeric($this->Jumlah->EditValue))
				$this->Jumlah->EditValue = FormatNumber($this->Jumlah->EditValue, -2, -2, -2, -2);
			

			// Nilai
			$this->Nilai->EditAttrs["class"] = "form-control";
			$this->Nilai->EditCustomAttributes = "";
			if (!$this->Nilai->Raw)
				$this->Nilai->CurrentValue = HtmlDecode($this->Nilai->CurrentValue);
			$this->Nilai->EditValue = HtmlEncode($this->Nilai->CurrentValue);
			$this->Nilai->PlaceHolder = RemoveHtml($this->Nilai->caption());

			// Angka
			$this->Angka->EditAttrs["class"] = "form-control";
			$this->Angka->EditCustomAttributes = "";
			$this->Angka->EditValue = HtmlEncode($this->Angka->CurrentValue);
			$this->Angka->PlaceHolder = RemoveHtml($this->Angka->caption());
			if (strval($this->Angka->EditValue) != "" && is_numeric($this->Angka->EditValue))
				$this->Angka->EditValue = FormatNumber($this->Angka->EditValue, -2, -2, -2, -2);
			

			// kunci
			$this->kunci->EditAttrs["class"] = "form-control";
			$this->kunci->EditCustomAttributes = "";
			if (!$this->kunci->Raw)
				$this->kunci->CurrentValue = HtmlDecode($this->kunci->CurrentValue);
			$this->kunci->EditValue = HtmlEncode($this->kunci->CurrentValue);
			$this->kunci->PlaceHolder = RemoveHtml($this->kunci->caption());

			// inp
			$this->inp->EditAttrs["class"] = "form-control";
			$this->inp->EditCustomAttributes = "";
			if (!$this->inp->Raw)
				$this->inp->CurrentValue = HtmlDecode($this->inp->CurrentValue);
			$this->inp->EditValue = HtmlEncode($this->inp->CurrentValue);
			$this->inp->PlaceHolder = RemoveHtml($this->inp->caption());

			// kls
			$this->kls->EditAttrs["class"] = "form-control";
			$this->kls->EditCustomAttributes = "";
			if (!$this->kls->Raw)
				$this->kls->CurrentValue = HtmlDecode($this->kls->CurrentValue);
			$this->kls->EditValue = HtmlEncode($this->kls->CurrentValue);
			$this->kls->PlaceHolder = RemoveHtml($this->kls->caption());

			// Gujian
			$this->Gujian->EditAttrs["class"] = "form-control";
			$this->Gujian->EditCustomAttributes = "";
			if (!$this->Gujian->Raw)
				$this->Gujian->CurrentValue = HtmlDecode($this->Gujian->CurrentValue);
			$this->Gujian->EditValue = HtmlEncode($this->Gujian->CurrentValue);
			$this->Gujian->PlaceHolder = RemoveHtml($this->Gujian->caption());

			// Minggu1
			$this->Minggu1->EditAttrs["class"] = "form-control";
			$this->Minggu1->EditCustomAttributes = "";
			if (!$this->Minggu1->Raw)
				$this->Minggu1->CurrentValue = HtmlDecode($this->Minggu1->CurrentValue);
			$this->Minggu1->EditValue = HtmlEncode($this->Minggu1->CurrentValue);
			$this->Minggu1->PlaceHolder = RemoveHtml($this->Minggu1->caption());

			// Minggu2
			$this->Minggu2->EditAttrs["class"] = "form-control";
			$this->Minggu2->EditCustomAttributes = "";
			if (!$this->Minggu2->Raw)
				$this->Minggu2->CurrentValue = HtmlDecode($this->Minggu2->CurrentValue);
			$this->Minggu2->EditValue = HtmlEncode($this->Minggu2->CurrentValue);
			$this->Minggu2->PlaceHolder = RemoveHtml($this->Minggu2->caption());

			// Minggu3
			$this->Minggu3->EditAttrs["class"] = "form-control";
			$this->Minggu3->EditCustomAttributes = "";
			if (!$this->Minggu3->Raw)
				$this->Minggu3->CurrentValue = HtmlDecode($this->Minggu3->CurrentValue);
			$this->Minggu3->EditValue = HtmlEncode($this->Minggu3->CurrentValue);
			$this->Minggu3->PlaceHolder = RemoveHtml($this->Minggu3->caption());

			// Minggu4
			$this->Minggu4->EditAttrs["class"] = "form-control";
			$this->Minggu4->EditCustomAttributes = "";
			if (!$this->Minggu4->Raw)
				$this->Minggu4->CurrentValue = HtmlDecode($this->Minggu4->CurrentValue);
			$this->Minggu4->EditValue = HtmlEncode($this->Minggu4->CurrentValue);
			$this->Minggu4->PlaceHolder = RemoveHtml($this->Minggu4->caption());

			// Minggu5
			$this->Minggu5->EditAttrs["class"] = "form-control";
			$this->Minggu5->EditCustomAttributes = "";
			if (!$this->Minggu5->Raw)
				$this->Minggu5->CurrentValue = HtmlDecode($this->Minggu5->CurrentValue);
			$this->Minggu5->EditValue = HtmlEncode($this->Minggu5->CurrentValue);
			$this->Minggu5->PlaceHolder = RemoveHtml($this->Minggu5->caption());

			// Minggu6
			$this->Minggu6->EditAttrs["class"] = "form-control";
			$this->Minggu6->EditCustomAttributes = "";
			if (!$this->Minggu6->Raw)
				$this->Minggu6->CurrentValue = HtmlDecode($this->Minggu6->CurrentValue);
			$this->Minggu6->EditValue = HtmlEncode($this->Minggu6->CurrentValue);
			$this->Minggu6->PlaceHolder = RemoveHtml($this->Minggu6->caption());

			// Minggu7
			$this->Minggu7->EditAttrs["class"] = "form-control";
			$this->Minggu7->EditCustomAttributes = "";
			if (!$this->Minggu7->Raw)
				$this->Minggu7->CurrentValue = HtmlDecode($this->Minggu7->CurrentValue);
			$this->Minggu7->EditValue = HtmlEncode($this->Minggu7->CurrentValue);
			$this->Minggu7->PlaceHolder = RemoveHtml($this->Minggu7->caption());

			// Minggu8
			$this->Minggu8->EditAttrs["class"] = "form-control";
			$this->Minggu8->EditCustomAttributes = "";
			if (!$this->Minggu8->Raw)
				$this->Minggu8->CurrentValue = HtmlDecode($this->Minggu8->CurrentValue);
			$this->Minggu8->EditValue = HtmlEncode($this->Minggu8->CurrentValue);
			$this->Minggu8->PlaceHolder = RemoveHtml($this->Minggu8->caption());

			// Minggu9
			$this->Minggu9->EditAttrs["class"] = "form-control";
			$this->Minggu9->EditCustomAttributes = "";
			if (!$this->Minggu9->Raw)
				$this->Minggu9->CurrentValue = HtmlDecode($this->Minggu9->CurrentValue);
			$this->Minggu9->EditValue = HtmlEncode($this->Minggu9->CurrentValue);
			$this->Minggu9->PlaceHolder = RemoveHtml($this->Minggu9->caption());

			// Minggu10
			$this->Minggu10->EditAttrs["class"] = "form-control";
			$this->Minggu10->EditCustomAttributes = "";
			if (!$this->Minggu10->Raw)
				$this->Minggu10->CurrentValue = HtmlDecode($this->Minggu10->CurrentValue);
			$this->Minggu10->EditValue = HtmlEncode($this->Minggu10->CurrentValue);
			$this->Minggu10->PlaceHolder = RemoveHtml($this->Minggu10->caption());

			// Minggu11
			$this->Minggu11->EditAttrs["class"] = "form-control";
			$this->Minggu11->EditCustomAttributes = "";
			if (!$this->Minggu11->Raw)
				$this->Minggu11->CurrentValue = HtmlDecode($this->Minggu11->CurrentValue);
			$this->Minggu11->EditValue = HtmlEncode($this->Minggu11->CurrentValue);
			$this->Minggu11->PlaceHolder = RemoveHtml($this->Minggu11->caption());

			// Minggu12
			$this->Minggu12->EditAttrs["class"] = "form-control";
			$this->Minggu12->EditCustomAttributes = "";
			if (!$this->Minggu12->Raw)
				$this->Minggu12->CurrentValue = HtmlDecode($this->Minggu12->CurrentValue);
			$this->Minggu12->EditValue = HtmlEncode($this->Minggu12->CurrentValue);
			$this->Minggu12->PlaceHolder = RemoveHtml($this->Minggu12->caption());

			// Minggu13
			$this->Minggu13->EditAttrs["class"] = "form-control";
			$this->Minggu13->EditCustomAttributes = "";
			if (!$this->Minggu13->Raw)
				$this->Minggu13->CurrentValue = HtmlDecode($this->Minggu13->CurrentValue);
			$this->Minggu13->EditValue = HtmlEncode($this->Minggu13->CurrentValue);
			$this->Minggu13->PlaceHolder = RemoveHtml($this->Minggu13->caption());

			// Minggu14
			$this->Minggu14->EditAttrs["class"] = "form-control";
			$this->Minggu14->EditCustomAttributes = "";
			if (!$this->Minggu14->Raw)
				$this->Minggu14->CurrentValue = HtmlDecode($this->Minggu14->CurrentValue);
			$this->Minggu14->EditValue = HtmlEncode($this->Minggu14->CurrentValue);
			$this->Minggu14->PlaceHolder = RemoveHtml($this->Minggu14->caption());

			// Minggu15
			$this->Minggu15->EditAttrs["class"] = "form-control";
			$this->Minggu15->EditCustomAttributes = "";
			if (!$this->Minggu15->Raw)
				$this->Minggu15->CurrentValue = HtmlDecode($this->Minggu15->CurrentValue);
			$this->Minggu15->EditValue = HtmlEncode($this->Minggu15->CurrentValue);
			$this->Minggu15->PlaceHolder = RemoveHtml($this->Minggu15->caption());

			// Minggu16
			$this->Minggu16->EditAttrs["class"] = "form-control";
			$this->Minggu16->EditCustomAttributes = "";
			if (!$this->Minggu16->Raw)
				$this->Minggu16->CurrentValue = HtmlDecode($this->Minggu16->CurrentValue);
			$this->Minggu16->EditValue = HtmlEncode($this->Minggu16->CurrentValue);
			$this->Minggu16->PlaceHolder = RemoveHtml($this->Minggu16->caption());

			// Persentase
			$this->Persentase->EditAttrs["class"] = "form-control";
			$this->Persentase->EditCustomAttributes = "";
			$this->Persentase->EditValue = HtmlEncode($this->Persentase->CurrentValue);
			$this->Persentase->PlaceHolder = RemoveHtml($this->Persentase->caption());
			if (strval($this->Persentase->EditValue) != "" && is_numeric($this->Persentase->EditValue))
				$this->Persentase->EditValue = FormatNumber($this->Persentase->EditValue, -2, -2, -2, -2);
			

			// KelasAkd
			$this->KelasAkd->EditAttrs["class"] = "form-control";
			$this->KelasAkd->EditCustomAttributes = "";
			if (!$this->KelasAkd->Raw)
				$this->KelasAkd->CurrentValue = HtmlDecode($this->KelasAkd->CurrentValue);
			$this->KelasAkd->EditValue = HtmlEncode($this->KelasAkd->CurrentValue);
			$this->KelasAkd->PlaceHolder = RemoveHtml($this->KelasAkd->caption());

			// Add refer script
			// Nim

			$this->Nim->LinkCustomAttributes = "";
			$this->Nim->HrefValue = "";

			// Thn_Akademik
			$this->Thn_Akademik->LinkCustomAttributes = "";
			$this->Thn_Akademik->HrefValue = "";

			// Periode
			$this->Periode->LinkCustomAttributes = "";
			$this->Periode->HrefValue = "";

			// Kode_MK
			$this->Kode_MK->LinkCustomAttributes = "";
			$this->Kode_MK->HrefValue = "";

			// Kehadiran
			$this->Kehadiran->LinkCustomAttributes = "";
			$this->Kehadiran->HrefValue = "";

			// Tugas
			$this->Tugas->LinkCustomAttributes = "";
			$this->Tugas->HrefValue = "";

			// Quiz
			$this->Quiz->LinkCustomAttributes = "";
			$this->Quiz->HrefValue = "";

			// UTS
			$this->UTS->LinkCustomAttributes = "";
			$this->UTS->HrefValue = "";

			// UAS
			$this->UAS->LinkCustomAttributes = "";
			$this->UAS->HrefValue = "";

			// Jumlah
			$this->Jumlah->LinkCustomAttributes = "";
			$this->Jumlah->HrefValue = "";

			// Nilai
			$this->Nilai->LinkCustomAttributes = "";
			$this->Nilai->HrefValue = "";

			// Angka
			$this->Angka->LinkCustomAttributes = "";
			$this->Angka->HrefValue = "";

			// kunci
			$this->kunci->LinkCustomAttributes = "";
			$this->kunci->HrefValue = "";

			// inp
			$this->inp->LinkCustomAttributes = "";
			$this->inp->HrefValue = "";

			// kls
			$this->kls->LinkCustomAttributes = "";
			$this->kls->HrefValue = "";

			// Gujian
			$this->Gujian->LinkCustomAttributes = "";
			$this->Gujian->HrefValue = "";

			// Minggu1
			$this->Minggu1->LinkCustomAttributes = "";
			$this->Minggu1->HrefValue = "";

			// Minggu2
			$this->Minggu2->LinkCustomAttributes = "";
			$this->Minggu2->HrefValue = "";

			// Minggu3
			$this->Minggu3->LinkCustomAttributes = "";
			$this->Minggu3->HrefValue = "";

			// Minggu4
			$this->Minggu4->LinkCustomAttributes = "";
			$this->Minggu4->HrefValue = "";

			// Minggu5
			$this->Minggu5->LinkCustomAttributes = "";
			$this->Minggu5->HrefValue = "";

			// Minggu6
			$this->Minggu6->LinkCustomAttributes = "";
			$this->Minggu6->HrefValue = "";

			// Minggu7
			$this->Minggu7->LinkCustomAttributes = "";
			$this->Minggu7->HrefValue = "";

			// Minggu8
			$this->Minggu8->LinkCustomAttributes = "";
			$this->Minggu8->HrefValue = "";

			// Minggu9
			$this->Minggu9->LinkCustomAttributes = "";
			$this->Minggu9->HrefValue = "";

			// Minggu10
			$this->Minggu10->LinkCustomAttributes = "";
			$this->Minggu10->HrefValue = "";

			// Minggu11
			$this->Minggu11->LinkCustomAttributes = "";
			$this->Minggu11->HrefValue = "";

			// Minggu12
			$this->Minggu12->LinkCustomAttributes = "";
			$this->Minggu12->HrefValue = "";

			// Minggu13
			$this->Minggu13->LinkCustomAttributes = "";
			$this->Minggu13->HrefValue = "";

			// Minggu14
			$this->Minggu14->LinkCustomAttributes = "";
			$this->Minggu14->HrefValue = "";

			// Minggu15
			$this->Minggu15->LinkCustomAttributes = "";
			$this->Minggu15->HrefValue = "";

			// Minggu16
			$this->Minggu16->LinkCustomAttributes = "";
			$this->Minggu16->HrefValue = "";

			// Persentase
			$this->Persentase->LinkCustomAttributes = "";
			$this->Persentase->HrefValue = "";

			// KelasAkd
			$this->KelasAkd->LinkCustomAttributes = "";
			$this->KelasAkd->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType != ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!Config("SERVER_VALIDATE"))
			return ($FormError == "");
		if ($this->Nim->Required) {
			if (!$this->Nim->IsDetailKey && $this->Nim->FormValue != NULL && $this->Nim->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Nim->caption(), $this->Nim->RequiredErrorMessage));
			}
		}
		if ($this->Thn_Akademik->Required) {
			if (!$this->Thn_Akademik->IsDetailKey && $this->Thn_Akademik->FormValue != NULL && $this->Thn_Akademik->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Thn_Akademik->caption(), $this->Thn_Akademik->RequiredErrorMessage));
			}
		}
		if ($this->Periode->Required) {
			if (!$this->Periode->IsDetailKey && $this->Periode->FormValue != NULL && $this->Periode->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Periode->caption(), $this->Periode->RequiredErrorMessage));
			}
		}
		if ($this->Kode_MK->Required) {
			if (!$this->Kode_MK->IsDetailKey && $this->Kode_MK->FormValue != NULL && $this->Kode_MK->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Kode_MK->caption(), $this->Kode_MK->RequiredErrorMessage));
			}
		}
		if ($this->Kehadiran->Required) {
			if (!$this->Kehadiran->IsDetailKey && $this->Kehadiran->FormValue != NULL && $this->Kehadiran->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Kehadiran->caption(), $this->Kehadiran->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->Kehadiran->FormValue)) {
			AddMessage($FormError, $this->Kehadiran->errorMessage());
		}
		if ($this->Tugas->Required) {
			if (!$this->Tugas->IsDetailKey && $this->Tugas->FormValue != NULL && $this->Tugas->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Tugas->caption(), $this->Tugas->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->Tugas->FormValue)) {
			AddMessage($FormError, $this->Tugas->errorMessage());
		}
		if ($this->Quiz->Required) {
			if (!$this->Quiz->IsDetailKey && $this->Quiz->FormValue != NULL && $this->Quiz->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Quiz->caption(), $this->Quiz->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->Quiz->FormValue)) {
			AddMessage($FormError, $this->Quiz->errorMessage());
		}
		if ($this->UTS->Required) {
			if (!$this->UTS->IsDetailKey && $this->UTS->FormValue != NULL && $this->UTS->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->UTS->caption(), $this->UTS->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->UTS->FormValue)) {
			AddMessage($FormError, $this->UTS->errorMessage());
		}
		if ($this->UAS->Required) {
			if (!$this->UAS->IsDetailKey && $this->UAS->FormValue != NULL && $this->UAS->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->UAS->caption(), $this->UAS->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->UAS->FormValue)) {
			AddMessage($FormError, $this->UAS->errorMessage());
		}
		if ($this->Jumlah->Required) {
			if (!$this->Jumlah->IsDetailKey && $this->Jumlah->FormValue != NULL && $this->Jumlah->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Jumlah->caption(), $this->Jumlah->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->Jumlah->FormValue)) {
			AddMessage($FormError, $this->Jumlah->errorMessage());
		}
		if ($this->Nilai->Required) {
			if (!$this->Nilai->IsDetailKey && $this->Nilai->FormValue != NULL && $this->Nilai->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Nilai->caption(), $this->Nilai->RequiredErrorMessage));
			}
		}
		if ($this->Angka->Required) {
			if (!$this->Angka->IsDetailKey && $this->Angka->FormValue != NULL && $this->Angka->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Angka->caption(), $this->Angka->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->Angka->FormValue)) {
			AddMessage($FormError, $this->Angka->errorMessage());
		}
		if ($this->kunci->Required) {
			if (!$this->kunci->IsDetailKey && $this->kunci->FormValue != NULL && $this->kunci->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->kunci->caption(), $this->kunci->RequiredErrorMessage));
			}
		}
		if ($this->inp->Required) {
			if (!$this->inp->IsDetailKey && $this->inp->FormValue != NULL && $this->inp->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->inp->caption(), $this->inp->RequiredErrorMessage));
			}
		}
		if ($this->kls->Required) {
			if (!$this->kls->IsDetailKey && $this->kls->FormValue != NULL && $this->kls->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->kls->caption(), $this->kls->RequiredErrorMessage));
			}
		}
		if ($this->Gujian->Required) {
			if (!$this->Gujian->IsDetailKey && $this->Gujian->FormValue != NULL && $this->Gujian->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Gujian->caption(), $this->Gujian->RequiredErrorMessage));
			}
		}
		if ($this->Minggu1->Required) {
			if (!$this->Minggu1->IsDetailKey && $this->Minggu1->FormValue != NULL && $this->Minggu1->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Minggu1->caption(), $this->Minggu1->RequiredErrorMessage));
			}
		}
		if ($this->Minggu2->Required) {
			if (!$this->Minggu2->IsDetailKey && $this->Minggu2->FormValue != NULL && $this->Minggu2->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Minggu2->caption(), $this->Minggu2->RequiredErrorMessage));
			}
		}
		if ($this->Minggu3->Required) {
			if (!$this->Minggu3->IsDetailKey && $this->Minggu3->FormValue != NULL && $this->Minggu3->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Minggu3->caption(), $this->Minggu3->RequiredErrorMessage));
			}
		}
		if ($this->Minggu4->Required) {
			if (!$this->Minggu4->IsDetailKey && $this->Minggu4->FormValue != NULL && $this->Minggu4->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Minggu4->caption(), $this->Minggu4->RequiredErrorMessage));
			}
		}
		if ($this->Minggu5->Required) {
			if (!$this->Minggu5->IsDetailKey && $this->Minggu5->FormValue != NULL && $this->Minggu5->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Minggu5->caption(), $this->Minggu5->RequiredErrorMessage));
			}
		}
		if ($this->Minggu6->Required) {
			if (!$this->Minggu6->IsDetailKey && $this->Minggu6->FormValue != NULL && $this->Minggu6->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Minggu6->caption(), $this->Minggu6->RequiredErrorMessage));
			}
		}
		if ($this->Minggu7->Required) {
			if (!$this->Minggu7->IsDetailKey && $this->Minggu7->FormValue != NULL && $this->Minggu7->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Minggu7->caption(), $this->Minggu7->RequiredErrorMessage));
			}
		}
		if ($this->Minggu8->Required) {
			if (!$this->Minggu8->IsDetailKey && $this->Minggu8->FormValue != NULL && $this->Minggu8->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Minggu8->caption(), $this->Minggu8->RequiredErrorMessage));
			}
		}
		if ($this->Minggu9->Required) {
			if (!$this->Minggu9->IsDetailKey && $this->Minggu9->FormValue != NULL && $this->Minggu9->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Minggu9->caption(), $this->Minggu9->RequiredErrorMessage));
			}
		}
		if ($this->Minggu10->Required) {
			if (!$this->Minggu10->IsDetailKey && $this->Minggu10->FormValue != NULL && $this->Minggu10->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Minggu10->caption(), $this->Minggu10->RequiredErrorMessage));
			}
		}
		if ($this->Minggu11->Required) {
			if (!$this->Minggu11->IsDetailKey && $this->Minggu11->FormValue != NULL && $this->Minggu11->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Minggu11->caption(), $this->Minggu11->RequiredErrorMessage));
			}
		}
		if ($this->Minggu12->Required) {
			if (!$this->Minggu12->IsDetailKey && $this->Minggu12->FormValue != NULL && $this->Minggu12->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Minggu12->caption(), $this->Minggu12->RequiredErrorMessage));
			}
		}
		if ($this->Minggu13->Required) {
			if (!$this->Minggu13->IsDetailKey && $this->Minggu13->FormValue != NULL && $this->Minggu13->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Minggu13->caption(), $this->Minggu13->RequiredErrorMessage));
			}
		}
		if ($this->Minggu14->Required) {
			if (!$this->Minggu14->IsDetailKey && $this->Minggu14->FormValue != NULL && $this->Minggu14->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Minggu14->caption(), $this->Minggu14->RequiredErrorMessage));
			}
		}
		if ($this->Minggu15->Required) {
			if (!$this->Minggu15->IsDetailKey && $this->Minggu15->FormValue != NULL && $this->Minggu15->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Minggu15->caption(), $this->Minggu15->RequiredErrorMessage));
			}
		}
		if ($this->Minggu16->Required) {
			if (!$this->Minggu16->IsDetailKey && $this->Minggu16->FormValue != NULL && $this->Minggu16->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Minggu16->caption(), $this->Minggu16->RequiredErrorMessage));
			}
		}
		if ($this->Persentase->Required) {
			if (!$this->Persentase->IsDetailKey && $this->Persentase->FormValue != NULL && $this->Persentase->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Persentase->caption(), $this->Persentase->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->Persentase->FormValue)) {
			AddMessage($FormError, $this->Persentase->errorMessage());
		}
		if ($this->KelasAkd->Required) {
			if (!$this->KelasAkd->IsDetailKey && $this->KelasAkd->FormValue != NULL && $this->KelasAkd->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->KelasAkd->caption(), $this->KelasAkd->RequiredErrorMessage));
			}
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError != "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Add record
	protected function addRow($rsold = NULL)
	{
		global $Language, $Security;
		$conn = $this->getConnection();

		// Load db values from rsold
		$this->loadDbValues($rsold);
		if ($rsold) {
		}
		$rsnew = [];

		// Nim
		$this->Nim->setDbValueDef($rsnew, $this->Nim->CurrentValue, "", FALSE);

		// Thn_Akademik
		$this->Thn_Akademik->setDbValueDef($rsnew, $this->Thn_Akademik->CurrentValue, "", FALSE);

		// Periode
		$this->Periode->setDbValueDef($rsnew, $this->Periode->CurrentValue, "", FALSE);

		// Kode_MK
		$this->Kode_MK->setDbValueDef($rsnew, $this->Kode_MK->CurrentValue, "", FALSE);

		// Kehadiran
		$this->Kehadiran->setDbValueDef($rsnew, $this->Kehadiran->CurrentValue, NULL, strval($this->Kehadiran->CurrentValue) == "");

		// Tugas
		$this->Tugas->setDbValueDef($rsnew, $this->Tugas->CurrentValue, NULL, FALSE);

		// Quiz
		$this->Quiz->setDbValueDef($rsnew, $this->Quiz->CurrentValue, NULL, FALSE);

		// UTS
		$this->UTS->setDbValueDef($rsnew, $this->UTS->CurrentValue, NULL, FALSE);

		// UAS
		$this->UAS->setDbValueDef($rsnew, $this->UAS->CurrentValue, NULL, FALSE);

		// Jumlah
		$this->Jumlah->setDbValueDef($rsnew, $this->Jumlah->CurrentValue, NULL, FALSE);

		// Nilai
		$this->Nilai->setDbValueDef($rsnew, $this->Nilai->CurrentValue, NULL, strval($this->Nilai->CurrentValue) == "");

		// Angka
		$this->Angka->setDbValueDef($rsnew, $this->Angka->CurrentValue, NULL, strval($this->Angka->CurrentValue) == "");

		// kunci
		$this->kunci->setDbValueDef($rsnew, $this->kunci->CurrentValue, NULL, FALSE);

		// inp
		$this->inp->setDbValueDef($rsnew, $this->inp->CurrentValue, NULL, FALSE);

		// kls
		$this->kls->setDbValueDef($rsnew, $this->kls->CurrentValue, NULL, strval($this->kls->CurrentValue) == "");

		// Gujian
		$this->Gujian->setDbValueDef($rsnew, $this->Gujian->CurrentValue, NULL, strval($this->Gujian->CurrentValue) == "");

		// Minggu1
		$this->Minggu1->setDbValueDef($rsnew, $this->Minggu1->CurrentValue, NULL, FALSE);

		// Minggu2
		$this->Minggu2->setDbValueDef($rsnew, $this->Minggu2->CurrentValue, NULL, FALSE);

		// Minggu3
		$this->Minggu3->setDbValueDef($rsnew, $this->Minggu3->CurrentValue, NULL, FALSE);

		// Minggu4
		$this->Minggu4->setDbValueDef($rsnew, $this->Minggu4->CurrentValue, NULL, FALSE);

		// Minggu5
		$this->Minggu5->setDbValueDef($rsnew, $this->Minggu5->CurrentValue, NULL, FALSE);

		// Minggu6
		$this->Minggu6->setDbValueDef($rsnew, $this->Minggu6->CurrentValue, NULL, FALSE);

		// Minggu7
		$this->Minggu7->setDbValueDef($rsnew, $this->Minggu7->CurrentValue, NULL, FALSE);

		// Minggu8
		$this->Minggu8->setDbValueDef($rsnew, $this->Minggu8->CurrentValue, NULL, FALSE);

		// Minggu9
		$this->Minggu9->setDbValueDef($rsnew, $this->Minggu9->CurrentValue, NULL, FALSE);

		// Minggu10
		$this->Minggu10->setDbValueDef($rsnew, $this->Minggu10->CurrentValue, NULL, FALSE);

		// Minggu11
		$this->Minggu11->setDbValueDef($rsnew, $this->Minggu11->CurrentValue, NULL, FALSE);

		// Minggu12
		$this->Minggu12->setDbValueDef($rsnew, $this->Minggu12->CurrentValue, NULL, FALSE);

		// Minggu13
		$this->Minggu13->setDbValueDef($rsnew, $this->Minggu13->CurrentValue, NULL, FALSE);

		// Minggu14
		$this->Minggu14->setDbValueDef($rsnew, $this->Minggu14->CurrentValue, NULL, FALSE);

		// Minggu15
		$this->Minggu15->setDbValueDef($rsnew, $this->Minggu15->CurrentValue, NULL, FALSE);

		// Minggu16
		$this->Minggu16->setDbValueDef($rsnew, $this->Minggu16->CurrentValue, NULL, FALSE);

		// Persentase
		$this->Persentase->setDbValueDef($rsnew, $this->Persentase->CurrentValue, NULL, FALSE);

		// KelasAkd
		$this->KelasAkd->setDbValueDef($rsnew, $this->KelasAkd->CurrentValue, NULL, FALSE);

		// Call Row Inserting event
		$rs = ($rsold) ? $rsold->fields : NULL;
		$insertRow = $this->Row_Inserting($rs, $rsnew);

		// Check if key value entered
		if ($insertRow && $this->ValidateKey && strval($rsnew['Nim']) == "") {
			$this->setFailureMessage($Language->phrase("InvalidKeyValue"));
			$insertRow = FALSE;
		}

		// Check if key value entered
		if ($insertRow && $this->ValidateKey && strval($rsnew['Thn_Akademik']) == "") {
			$this->setFailureMessage($Language->phrase("InvalidKeyValue"));
			$insertRow = FALSE;
		}

		// Check if key value entered
		if ($insertRow && $this->ValidateKey && strval($rsnew['Periode']) == "") {
			$this->setFailureMessage($Language->phrase("InvalidKeyValue"));
			$insertRow = FALSE;
		}

		// Check if key value entered
		if ($insertRow && $this->ValidateKey && strval($rsnew['Kode_MK']) == "") {
			$this->setFailureMessage($Language->phrase("InvalidKeyValue"));
			$insertRow = FALSE;
		}

		// Check for duplicate key
		if ($insertRow && $this->ValidateKey) {
			$filter = $this->getRecordFilter($rsnew);
			$rsChk = $this->loadRs($filter);
			if ($rsChk && !$rsChk->EOF) {
				$keyErrMsg = str_replace("%f", $filter, $Language->phrase("DupKey"));
				$this->setFailureMessage($keyErrMsg);
				$rsChk->close();
				$insertRow = FALSE;
			}
		}
		if ($insertRow) {
			$conn->raiseErrorFn = Config("ERROR_FUNC");
			$addRow = $this->insert($rsnew);
			$conn->raiseErrorFn = "";
			if ($addRow) {
			}
		} else {
			if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage != "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->phrase("InsertCancelled"));
			}
			$addRow = FALSE;
		}
		if ($addRow) {

			// Call Row Inserted event
			$rs = ($rsold) ? $rsold->fields : NULL;
			$this->Row_Inserted($rs, $rsnew);
		}

		// Clean upload path if any
		if ($addRow) {
		}

		// Write JSON for API request
		if (IsApi() && $addRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $addRow;
	}

	// Set up master/detail based on QueryString
	protected function setupMasterParms()
	{
		$validMaster = FALSE;

		// Get the keys for master table
		if (($master = Get(Config("TABLE_SHOW_MASTER"), Get(Config("TABLE_MASTER")))) !== NULL) {
			$masterTblVar = $master;
			if ($masterTblVar == "") {
				$validMaster = TRUE;
				$this->DbMasterFilter = "";
				$this->DbDetailFilter = "";
			}
			if ($masterTblVar == "V_LMHS") {
				$validMaster = TRUE;
				if (($parm = Get("fk_Nim", Get("Nim"))) !== NULL) {
					$GLOBALS["V_LMHS"]->Nim->setQueryStringValue($parm);
					$this->Nim->setQueryStringValue($GLOBALS["V_LMHS"]->Nim->QueryStringValue);
					$this->Nim->setSessionValue($this->Nim->QueryStringValue);
				} else {
					$validMaster = FALSE;
				}
			}
			if ($masterTblVar == "IM_Mhs") {
				$validMaster = TRUE;
				if (($parm = Get("fk_Nim", Get("Nim"))) !== NULL) {
					$GLOBALS["IM_Mhs"]->Nim->setQueryStringValue($parm);
					$this->Nim->setQueryStringValue($GLOBALS["IM_Mhs"]->Nim->QueryStringValue);
					$this->Nim->setSessionValue($this->Nim->QueryStringValue);
				} else {
					$validMaster = FALSE;
				}
			}
		} elseif (($master = Post(Config("TABLE_SHOW_MASTER"), Post(Config("TABLE_MASTER")))) !== NULL) {
			$masterTblVar = $master;
			if ($masterTblVar == "") {
				$validMaster = TRUE;
				$this->DbMasterFilter = "";
				$this->DbDetailFilter = "";
			}
			if ($masterTblVar == "V_LMHS") {
				$validMaster = TRUE;
				if (($parm = Post("fk_Nim", Post("Nim"))) !== NULL) {
					$GLOBALS["V_LMHS"]->Nim->setFormValue($parm);
					$this->Nim->setFormValue($GLOBALS["V_LMHS"]->Nim->FormValue);
					$this->Nim->setSessionValue($this->Nim->FormValue);
				} else {
					$validMaster = FALSE;
				}
			}
			if ($masterTblVar == "IM_Mhs") {
				$validMaster = TRUE;
				if (($parm = Post("fk_Nim", Post("Nim"))) !== NULL) {
					$GLOBALS["IM_Mhs"]->Nim->setFormValue($parm);
					$this->Nim->setFormValue($GLOBALS["IM_Mhs"]->Nim->FormValue);
					$this->Nim->setSessionValue($this->Nim->FormValue);
				} else {
					$validMaster = FALSE;
				}
			}
		}
		if ($validMaster) {

			// Save current master table
			$this->setCurrentMasterTable($masterTblVar);

			// Reset start record counter (new master key)
			if (!$this->isAddOrEdit()) {
				$this->StartRecord = 1;
				$this->setStartRecordNumber($this->StartRecord);
			}

			// Clear previous master key from Session
			if ($masterTblVar != "V_LMHS") {
				if ($this->Nim->CurrentValue == "")
					$this->Nim->setSessionValue("");
			}
			if ($masterTblVar != "IM_Mhs") {
				if ($this->Nim->CurrentValue == "")
					$this->Nim->setSessionValue("");
			}
		}
		$this->DbMasterFilter = $this->getMasterFilter(); // Get master filter
		$this->DbDetailFilter = $this->getDetailFilter(); // Get detail filter
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("tblNilaiPerMhslist.php"), "", $this->TableVar, TRUE);
		$pageId = ($this->isCopy()) ? "Copy" : "Add";
		$Breadcrumb->add("add", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// Get default connection and filter
			$conn = $this->getConnection();
			$lookupFilter = "";

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL and connection
			switch ($fld->FieldVar) {
				case "x_Thn_Akademik":
					$conn = Conn("DB");
					break;
				case "x_Periode":
					break;
				case "x_Kode_MK":
					$conn = Conn("DB");
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0) {
				$totalCnt = $this->getRecordCount($sql, $conn);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_Thn_Akademik":
							break;
						case "x_Kode_MK":
							$row[3] = FormatNumber($row[3], 0, -2, -2, -2);
							$row['df3'] = $row[3];
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
} // End class
?>