<?php
namespace PHPMaker2020\baak;

/**
 * Page class
 */
class tblNilaiPerMhs_delete extends tblNilaiPerMhs
{

	// Page ID
	public $PageID = "delete";

	// Project ID
	public $ProjectID = "{A09D3AFF-419C-4918-948A-A3C8469EA234}";

	// Table name
	public $TableName = 'tblNilaiPerMhs';

	// Page object name
	public $PageObjName = "tblNilaiPerMhs_delete";

	// Audit Trail
	public $AuditTrailOnAdd = TRUE;
	public $AuditTrailOnEdit = TRUE;
	public $AuditTrailOnDelete = TRUE;
	public $AuditTrailOnView = FALSE;
	public $AuditTrailOnViewData = FALSE;
	public $AuditTrailOnSearch = FALSE;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken;

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading != "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading != "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		$url = CurrentPageName() . "?";
		if ($this->UseTokenInUrl)
			$url .= "t=" . $this->TableVar . "&"; // Add page token
		return $url;
	}

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = TRUE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message != "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fas fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage != "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fas fa-exclamation"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage != "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fas fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage != "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fas fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = [];

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message != "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage != "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage != "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage != "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header != "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer != "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(Config("TOKEN_NAME")) === NULL)
			return FALSE;
		$fn = Config("CHECK_TOKEN_FUNC");
		if (is_callable($fn))
			return $fn(Post(Config("TOKEN_NAME")), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = Config("CREATE_TOKEN_FUNC"); // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $DashboardReport;
		global $UserTable;

		// Check token
		$this->CheckToken = Config("CHECK_TOKEN");

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (tblNilaiPerMhs)
		if (!isset($GLOBALS["tblNilaiPerMhs"]) || get_class($GLOBALS["tblNilaiPerMhs"]) == PROJECT_NAMESPACE . "tblNilaiPerMhs") {
			$GLOBALS["tblNilaiPerMhs"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["tblNilaiPerMhs"];
		}

		// Table object (Pass)
		if (!isset($GLOBALS['Pass']))
			$GLOBALS['Pass'] = new Pass();

		// Table object (V_LMHS)
		if (!isset($GLOBALS['V_LMHS']))
			$GLOBALS['V_LMHS'] = new V_LMHS();

		// Table object (IM_Mhs)
		if (!isset($GLOBALS['IM_Mhs']))
			$GLOBALS['IM_Mhs'] = new IM_Mhs();

		// Page ID (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'delete');

		// Table name (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'tblNilaiPerMhs');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = $this->getConnection();

		// User table object (Pass)
		$UserTable = $UserTable ?: new Pass();
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages, $DashboardReport;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $tblNilaiPerMhs;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, Config("EXPORT_CLASSES"))) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . Config("EXPORT_CLASSES." . $this->CustomExport);
			if (class_exists($class)) {
				$doc = new $class($tblNilaiPerMhs);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url != "") {
			if (!Config("DEBUG") && ob_get_length())
				ob_end_clean();
			SaveDebugMessage();
			AddHeader("Location", $url);
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = [];
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = [];
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {
								$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
									Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
									Config("API_FIELD_NAME") . "=" . $fld->Param . "&" .
									Config("API_KEY_NAME") . "=" . rawurlencode($this->getRecordKeyValue($ar)))); //*** need to add this? API may not be in the same folder
								$row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
								$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
									Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
									"fn=" . Encrypt($fld->physicalUploadPath() . $val)));
								$row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
							} else { // Multiple files
								$files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
								$ar = [];
								foreach ($files as $file) {
									$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
										Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
										"fn=" . Encrypt($fld->physicalUploadPath() . $file)));
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['Nim'] . Config("COMPOSITE_KEY_SEPARATOR");
			$key .= @$ar['Thn_Akademik'] . Config("COMPOSITE_KEY_SEPARATOR");
			$key .= @$ar['Periode'] . Config("COMPOSITE_KEY_SEPARATOR");
			$key .= @$ar['Kode_MK'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
	}

	// Set up API security
	public function setupApiSecurity()
	{
		global $Security;

		// Setup security for API request
		if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
		$Security->loadCurrentUserLevel(Config("PROJECT_ID") . $this->TableName);
		if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
	}
	public $DbMasterFilter = "";
	public $DbDetailFilter = "";
	public $StartRecord;
	public $TotalRecords = 0;
	public $RecordCount;
	public $RecKeys = [];
	public $StartRowCount = 1;
	public $RowCount = 0;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $CurrentForm;

		// User profile
		$UserProfile = new UserProfile();

		// Security
		if (ValidApiRequest()) { // API request
			$this->setupApiSecurity(); // Set up API Security
			if (!$Security->canDelete()) {
				SetStatus(401); // Unauthorized
				return;
			}
		} else {
			$Security = new AdvancedSecurity();
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canDelete()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("tblNilaiPerMhslist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
		}
		$this->CurrentAction = Param("action"); // Set up current action
		$this->Nim->Visible = FALSE;
		$this->Thn_Akademik->setVisibility();
		$this->Periode->setVisibility();
		$this->Kode_MK->setVisibility();
		$this->Kehadiran->setVisibility();
		$this->Tugas->setVisibility();
		$this->Quiz->Visible = FALSE;
		$this->UTS->setVisibility();
		$this->UAS->setVisibility();
		$this->Jumlah->setVisibility();
		$this->Nilai->setVisibility();
		$this->Angka->setVisibility();
		$this->kunci->Visible = FALSE;
		$this->inp->Visible = FALSE;
		$this->kls->Visible = FALSE;
		$this->Gujian->Visible = FALSE;
		$this->Minggu1->Visible = FALSE;
		$this->Minggu2->Visible = FALSE;
		$this->Minggu3->Visible = FALSE;
		$this->Minggu4->Visible = FALSE;
		$this->Minggu5->Visible = FALSE;
		$this->Minggu6->Visible = FALSE;
		$this->Minggu7->Visible = FALSE;
		$this->Minggu8->Visible = FALSE;
		$this->Minggu9->Visible = FALSE;
		$this->Minggu10->Visible = FALSE;
		$this->Minggu11->Visible = FALSE;
		$this->Minggu12->Visible = FALSE;
		$this->Minggu13->Visible = FALSE;
		$this->Minggu14->Visible = FALSE;
		$this->Minggu15->Visible = FALSE;
		$this->Minggu16->Visible = FALSE;
		$this->Persentase->Visible = FALSE;
		$this->KelasAkd->Visible = FALSE;
		$this->stat_feeder->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->Thn_Akademik);
		$this->setupLookupOptions($this->Kode_MK);

		// Check permission
		if (!$Security->canDelete()) {
			$this->setFailureMessage(DeniedMessage()); // No permission
			$this->terminate("tblNilaiPerMhslist.php");
			return;
		}

		// Set up master/detail parameters
		$this->setupMasterParms();

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Load key parameters
		$this->RecKeys = $this->getRecordKeys(); // Load record keys
		$filter = $this->getFilterFromRecordKeys();
		if ($filter == "") {
			$this->terminate("tblNilaiPerMhslist.php"); // Prevent SQL injection, return to list
			return;
		}

		// Set up filter (WHERE Clause)
		$this->CurrentFilter = $filter;

		// Get action
		if (IsApi()) {
			$this->CurrentAction = "delete"; // Delete record directly
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action");
		} elseif (Get("action") == "1") {
			$this->CurrentAction = "delete"; // Delete record directly
		} else {
			$this->CurrentAction = "show"; // Display record
		}
		if ($this->isDelete()) {
			$this->SendEmail = TRUE; // Send email on delete success
			if ($this->deleteRows()) { // Delete rows
				if ($this->getSuccessMessage() == "")
					$this->setSuccessMessage($Language->phrase("DeleteSuccess")); // Set up success message
				if (IsApi()) {
					$this->terminate(TRUE);
					return;
				} else {
					$this->terminate($this->getReturnUrl()); // Return to caller
				}
			} else { // Delete failed
				if (IsApi()) {
					$this->terminate();
					return;
				}
				$this->CurrentAction = "show"; // Display record
			}
		}
		if ($this->isShow()) { // Load records for display
			if ($this->Recordset = $this->loadRecordset())
				$this->TotalRecords = $this->Recordset->RecordCount(); // Get record count
			if ($this->TotalRecords <= 0) { // No record found, exit
				if ($this->Recordset)
					$this->Recordset->close();
				$this->terminate("tblNilaiPerMhslist.php"); // Return to list
			}
		}
	}

	// Load recordset
	public function loadRecordset($offset = -1, $rowcnt = -1)
	{

		// Load List page SQL
		$sql = $this->getListSql();
		$conn = $this->getConnection();

		// Load recordset
		$dbtype = GetConnectionType($this->Dbid);
		if ($this->UseSelectLimit) {
			$conn->raiseErrorFn = Config("ERROR_FUNC");
			if ($dbtype == "MSSQL") {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset, ["_hasOrderBy" => trim($this->getOrderBy()) || trim($this->getSessionOrderBy())]);
			} else {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset);
			}
			$conn->raiseErrorFn = "";
		} else {
			$rs = LoadRecordset($sql, $conn);
		}

		// Call Recordset Selected event
		$this->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = $this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->Nim->setDbValue($row['Nim']);
		$this->Thn_Akademik->setDbValue($row['Thn_Akademik']);
		$this->Periode->setDbValue($row['Periode']);
		$this->Kode_MK->setDbValue($row['Kode_MK']);
		$this->Kehadiran->setDbValue($row['Kehadiran']);
		$this->Tugas->setDbValue($row['Tugas']);
		$this->Quiz->setDbValue($row['Quiz']);
		$this->UTS->setDbValue($row['UTS']);
		$this->UAS->setDbValue($row['UAS']);
		$this->Jumlah->setDbValue($row['Jumlah']);
		$this->Nilai->setDbValue($row['Nilai']);
		$this->Angka->setDbValue($row['Angka']);
		$this->kunci->setDbValue($row['kunci']);
		$this->inp->setDbValue($row['inp']);
		$this->kls->setDbValue($row['kls']);
		$this->Gujian->setDbValue($row['Gujian']);
		$this->Minggu1->setDbValue($row['Minggu1']);
		$this->Minggu2->setDbValue($row['Minggu2']);
		$this->Minggu3->setDbValue($row['Minggu3']);
		$this->Minggu4->setDbValue($row['Minggu4']);
		$this->Minggu5->setDbValue($row['Minggu5']);
		$this->Minggu6->setDbValue($row['Minggu6']);
		$this->Minggu7->setDbValue($row['Minggu7']);
		$this->Minggu8->setDbValue($row['Minggu8']);
		$this->Minggu9->setDbValue($row['Minggu9']);
		$this->Minggu10->setDbValue($row['Minggu10']);
		$this->Minggu11->setDbValue($row['Minggu11']);
		$this->Minggu12->setDbValue($row['Minggu12']);
		$this->Minggu13->setDbValue($row['Minggu13']);
		$this->Minggu14->setDbValue($row['Minggu14']);
		$this->Minggu15->setDbValue($row['Minggu15']);
		$this->Minggu16->setDbValue($row['Minggu16']);
		$this->Persentase->setDbValue($row['Persentase']);
		$this->KelasAkd->setDbValue($row['KelasAkd']);
		$this->stat_feeder->setDbValue($row['stat_feeder']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['Nim'] = NULL;
		$row['Thn_Akademik'] = NULL;
		$row['Periode'] = NULL;
		$row['Kode_MK'] = NULL;
		$row['Kehadiran'] = NULL;
		$row['Tugas'] = NULL;
		$row['Quiz'] = NULL;
		$row['UTS'] = NULL;
		$row['UAS'] = NULL;
		$row['Jumlah'] = NULL;
		$row['Nilai'] = NULL;
		$row['Angka'] = NULL;
		$row['kunci'] = NULL;
		$row['inp'] = NULL;
		$row['kls'] = NULL;
		$row['Gujian'] = NULL;
		$row['Minggu1'] = NULL;
		$row['Minggu2'] = NULL;
		$row['Minggu3'] = NULL;
		$row['Minggu4'] = NULL;
		$row['Minggu5'] = NULL;
		$row['Minggu6'] = NULL;
		$row['Minggu7'] = NULL;
		$row['Minggu8'] = NULL;
		$row['Minggu9'] = NULL;
		$row['Minggu10'] = NULL;
		$row['Minggu11'] = NULL;
		$row['Minggu12'] = NULL;
		$row['Minggu13'] = NULL;
		$row['Minggu14'] = NULL;
		$row['Minggu15'] = NULL;
		$row['Minggu16'] = NULL;
		$row['Persentase'] = NULL;
		$row['KelasAkd'] = NULL;
		$row['stat_feeder'] = NULL;
		return $row;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->Kehadiran->FormValue == $this->Kehadiran->CurrentValue && is_numeric(ConvertToFloatString($this->Kehadiran->CurrentValue)))
			$this->Kehadiran->CurrentValue = ConvertToFloatString($this->Kehadiran->CurrentValue);

		// Convert decimal values if posted back
		if ($this->Tugas->FormValue == $this->Tugas->CurrentValue && is_numeric(ConvertToFloatString($this->Tugas->CurrentValue)))
			$this->Tugas->CurrentValue = ConvertToFloatString($this->Tugas->CurrentValue);

		// Convert decimal values if posted back
		if ($this->UTS->FormValue == $this->UTS->CurrentValue && is_numeric(ConvertToFloatString($this->UTS->CurrentValue)))
			$this->UTS->CurrentValue = ConvertToFloatString($this->UTS->CurrentValue);

		// Convert decimal values if posted back
		if ($this->UAS->FormValue == $this->UAS->CurrentValue && is_numeric(ConvertToFloatString($this->UAS->CurrentValue)))
			$this->UAS->CurrentValue = ConvertToFloatString($this->UAS->CurrentValue);

		// Convert decimal values if posted back
		if ($this->Jumlah->FormValue == $this->Jumlah->CurrentValue && is_numeric(ConvertToFloatString($this->Jumlah->CurrentValue)))
			$this->Jumlah->CurrentValue = ConvertToFloatString($this->Jumlah->CurrentValue);

		// Convert decimal values if posted back
		if ($this->Angka->FormValue == $this->Angka->CurrentValue && is_numeric(ConvertToFloatString($this->Angka->CurrentValue)))
			$this->Angka->CurrentValue = ConvertToFloatString($this->Angka->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// Nim
		// Thn_Akademik
		// Periode
		// Kode_MK
		// Kehadiran
		// Tugas
		// Quiz
		// UTS
		// UAS
		// Jumlah
		// Nilai
		// Angka
		// kunci
		// inp
		// kls
		// Gujian
		// Minggu1
		// Minggu2
		// Minggu3
		// Minggu4
		// Minggu5
		// Minggu6
		// Minggu7
		// Minggu8
		// Minggu9
		// Minggu10
		// Minggu11
		// Minggu12
		// Minggu13
		// Minggu14
		// Minggu15
		// Minggu16
		// Persentase
		// KelasAkd
		// stat_feeder

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// Nim
			$this->Nim->ViewValue = $this->Nim->CurrentValue;
			$this->Nim->ViewCustomAttributes = "";

			// Thn_Akademik
			$curVal = strval($this->Thn_Akademik->CurrentValue);
			if ($curVal != "") {
				$this->Thn_Akademik->ViewValue = $this->Thn_Akademik->lookupCacheOption($curVal);
				if ($this->Thn_Akademik->ViewValue === NULL) { // Lookup from database
					$filterWrk = "[TA]" . SearchString("=", $curVal, DATATYPE_STRING, "");
					$sqlWrk = $this->Thn_Akademik->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = [];
						$arwrk[1] = $rswrk->fields('df');
						$this->Thn_Akademik->ViewValue = $this->Thn_Akademik->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->Thn_Akademik->ViewValue = $this->Thn_Akademik->CurrentValue;
					}
				}
			} else {
				$this->Thn_Akademik->ViewValue = NULL;
			}
			$this->Thn_Akademik->ViewCustomAttributes = "";

			// Periode
			if (strval($this->Periode->CurrentValue) != "") {
				$this->Periode->ViewValue = $this->Periode->optionCaption($this->Periode->CurrentValue);
			} else {
				$this->Periode->ViewValue = NULL;
			}
			$this->Periode->ViewCustomAttributes = "";

			// Kode_MK
			$this->Kode_MK->ViewValue = $this->Kode_MK->CurrentValue;
			$curVal = strval($this->Kode_MK->CurrentValue);
			if ($curVal != "") {
				$this->Kode_MK->ViewValue = $this->Kode_MK->lookupCacheOption($curVal);
				if ($this->Kode_MK->ViewValue === NULL) { // Lookup from database
					$filterWrk = "[Kode_MK]" . SearchString("=", $curVal, DATATYPE_STRING, "");
					$sqlWrk = $this->Kode_MK->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = [];
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$arwrk[3] = FormatNumber($rswrk->fields('df3'), 0, -2, -2, -2);
						$this->Kode_MK->ViewValue = $this->Kode_MK->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->Kode_MK->ViewValue = $this->Kode_MK->CurrentValue;
					}
				}
			} else {
				$this->Kode_MK->ViewValue = NULL;
			}
			$this->Kode_MK->ViewCustomAttributes = "";

			// Kehadiran
			$this->Kehadiran->ViewValue = $this->Kehadiran->CurrentValue;
			$this->Kehadiran->ViewValue = FormatNumber($this->Kehadiran->ViewValue, 2, -2, -2, -2);
			$this->Kehadiran->CellCssStyle .= "text-align: right;";
			$this->Kehadiran->ViewCustomAttributes = "";

			// Tugas
			$this->Tugas->ViewValue = $this->Tugas->CurrentValue;
			$this->Tugas->ViewValue = FormatNumber($this->Tugas->ViewValue, 2, -2, -2, -2);
			$this->Tugas->CellCssStyle .= "text-align: right;";
			$this->Tugas->ViewCustomAttributes = "";

			// Quiz
			$this->Quiz->ViewValue = $this->Quiz->CurrentValue;
			$this->Quiz->ViewValue = FormatNumber($this->Quiz->ViewValue, 2, -2, -2, -2);
			$this->Quiz->ViewCustomAttributes = "";

			// UTS
			$this->UTS->ViewValue = $this->UTS->CurrentValue;
			$this->UTS->ViewValue = FormatNumber($this->UTS->ViewValue, 2, -2, -2, -2);
			$this->UTS->CellCssStyle .= "text-align: right;";
			$this->UTS->ViewCustomAttributes = "";

			// UAS
			$this->UAS->ViewValue = $this->UAS->CurrentValue;
			$this->UAS->ViewValue = FormatNumber($this->UAS->ViewValue, 2, -2, -2, -2);
			$this->UAS->CellCssStyle .= "text-align: right;";
			$this->UAS->ViewCustomAttributes = "";

			// Jumlah
			$this->Jumlah->ViewValue = $this->Jumlah->CurrentValue;
			$this->Jumlah->ViewValue = FormatNumber($this->Jumlah->ViewValue, 2, -2, -2, -2);
			$this->Jumlah->CellCssStyle .= "text-align: right;";
			$this->Jumlah->ViewCustomAttributes = "";

			// Nilai
			$this->Nilai->ViewValue = $this->Nilai->CurrentValue;
			$this->Nilai->CellCssStyle .= "text-align: right;";
			$this->Nilai->ViewCustomAttributes = "";

			// Angka
			$this->Angka->ViewValue = $this->Angka->CurrentValue;
			$this->Angka->ViewValue = FormatNumber($this->Angka->ViewValue, 2, -2, -2, -2);
			$this->Angka->CellCssStyle .= "text-align: right;";
			$this->Angka->ViewCustomAttributes = "";

			// kunci
			$this->kunci->ViewValue = $this->kunci->CurrentValue;
			$this->kunci->ViewCustomAttributes = "";

			// inp
			$this->inp->ViewValue = $this->inp->CurrentValue;
			$this->inp->ViewCustomAttributes = "";

			// kls
			$this->kls->ViewValue = $this->kls->CurrentValue;
			$this->kls->CellCssStyle .= "text-align: right;";
			$this->kls->ViewCustomAttributes = "";

			// Gujian
			$this->Gujian->ViewValue = $this->Gujian->CurrentValue;
			$this->Gujian->ViewCustomAttributes = "";

			// Minggu1
			$this->Minggu1->ViewValue = $this->Minggu1->CurrentValue;
			$this->Minggu1->ViewCustomAttributes = "";

			// Minggu2
			$this->Minggu2->ViewValue = $this->Minggu2->CurrentValue;
			$this->Minggu2->ViewCustomAttributes = "";

			// Minggu3
			$this->Minggu3->ViewValue = $this->Minggu3->CurrentValue;
			$this->Minggu3->ViewCustomAttributes = "";

			// Minggu4
			$this->Minggu4->ViewValue = $this->Minggu4->CurrentValue;
			$this->Minggu4->ViewCustomAttributes = "";

			// Minggu5
			$this->Minggu5->ViewValue = $this->Minggu5->CurrentValue;
			$this->Minggu5->ViewCustomAttributes = "";

			// Minggu6
			$this->Minggu6->ViewValue = $this->Minggu6->CurrentValue;
			$this->Minggu6->ViewCustomAttributes = "";

			// Minggu7
			$this->Minggu7->ViewValue = $this->Minggu7->CurrentValue;
			$this->Minggu7->ViewCustomAttributes = "";

			// Minggu8
			$this->Minggu8->ViewValue = $this->Minggu8->CurrentValue;
			$this->Minggu8->ViewCustomAttributes = "";

			// Minggu9
			$this->Minggu9->ViewValue = $this->Minggu9->CurrentValue;
			$this->Minggu9->ViewCustomAttributes = "";

			// Minggu10
			$this->Minggu10->ViewValue = $this->Minggu10->CurrentValue;
			$this->Minggu10->ViewCustomAttributes = "";

			// Minggu11
			$this->Minggu11->ViewValue = $this->Minggu11->CurrentValue;
			$this->Minggu11->ViewCustomAttributes = "";

			// Minggu12
			$this->Minggu12->ViewValue = $this->Minggu12->CurrentValue;
			$this->Minggu12->ViewCustomAttributes = "";

			// Minggu13
			$this->Minggu13->ViewValue = $this->Minggu13->CurrentValue;
			$this->Minggu13->ViewCustomAttributes = "";

			// Minggu14
			$this->Minggu14->ViewValue = $this->Minggu14->CurrentValue;
			$this->Minggu14->ViewCustomAttributes = "";

			// Minggu15
			$this->Minggu15->ViewValue = $this->Minggu15->CurrentValue;
			$this->Minggu15->ViewCustomAttributes = "";

			// Minggu16
			$this->Minggu16->ViewValue = $this->Minggu16->CurrentValue;
			$this->Minggu16->ViewCustomAttributes = "";

			// Persentase
			$this->Persentase->ViewValue = $this->Persentase->CurrentValue;
			$this->Persentase->ViewValue = FormatNumber($this->Persentase->ViewValue, 2, -2, -2, -2);
			$this->Persentase->ViewCustomAttributes = "";

			// KelasAkd
			$this->KelasAkd->ViewValue = $this->KelasAkd->CurrentValue;
			$this->KelasAkd->ViewCustomAttributes = "";

			// stat_feeder
			$this->stat_feeder->ViewValue = $this->stat_feeder->CurrentValue;
			$this->stat_feeder->ViewCustomAttributes = "";

			// Thn_Akademik
			$this->Thn_Akademik->LinkCustomAttributes = "";
			$this->Thn_Akademik->HrefValue = "";
			$this->Thn_Akademik->TooltipValue = "";

			// Periode
			$this->Periode->LinkCustomAttributes = "";
			$this->Periode->HrefValue = "";
			$this->Periode->TooltipValue = "";

			// Kode_MK
			$this->Kode_MK->LinkCustomAttributes = "";
			$this->Kode_MK->HrefValue = "";
			$this->Kode_MK->TooltipValue = "";

			// Kehadiran
			$this->Kehadiran->LinkCustomAttributes = "";
			$this->Kehadiran->HrefValue = "";
			$this->Kehadiran->TooltipValue = "";

			// Tugas
			$this->Tugas->LinkCustomAttributes = "";
			$this->Tugas->HrefValue = "";
			$this->Tugas->TooltipValue = "";

			// UTS
			$this->UTS->LinkCustomAttributes = "";
			$this->UTS->HrefValue = "";
			$this->UTS->TooltipValue = "";

			// UAS
			$this->UAS->LinkCustomAttributes = "";
			$this->UAS->HrefValue = "";
			$this->UAS->TooltipValue = "";

			// Jumlah
			$this->Jumlah->LinkCustomAttributes = "";
			$this->Jumlah->HrefValue = "";
			$this->Jumlah->TooltipValue = "";

			// Nilai
			$this->Nilai->LinkCustomAttributes = "";
			$this->Nilai->HrefValue = "";
			$this->Nilai->TooltipValue = "";

			// Angka
			$this->Angka->LinkCustomAttributes = "";
			$this->Angka->HrefValue = "";
			$this->Angka->TooltipValue = "";

			// stat_feeder
			$this->stat_feeder->LinkCustomAttributes = "";
			$this->stat_feeder->HrefValue = "";
			$this->stat_feeder->TooltipValue = "";
		}

		// Call Row Rendered event
		if ($this->RowType != ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Delete records based on current filter
	protected function deleteRows()
	{
		global $Language, $Security;
		if (!$Security->canDelete()) {
			$this->setFailureMessage($Language->phrase("NoDeletePermission")); // No delete permission
			return FALSE;
		}
		$deleteRows = TRUE;
		$sql = $this->getCurrentSql();
		$conn = $this->getConnection();
		$conn->raiseErrorFn = Config("ERROR_FUNC");
		$rs = $conn->execute($sql);
		$conn->raiseErrorFn = "";
		if ($rs === FALSE) {
			return FALSE;
		} elseif ($rs->EOF) {
			$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
			$rs->close();
			return FALSE;
		}
		$rows = ($rs) ? $rs->getRows() : [];
		$conn->beginTrans();
		if ($this->AuditTrailOnDelete)
			$this->writeAuditTrailDummy($Language->phrase("BatchDeleteBegin")); // Batch delete begin

		// Clone old rows
		$rsold = $rows;
		if ($rs)
			$rs->close();

		// Call row deleting event
		if ($deleteRows) {
			foreach ($rsold as $row) {
				$deleteRows = $this->Row_Deleting($row);
				if (!$deleteRows)
					break;
			}
		}
		if ($deleteRows) {
			$key = "";
			foreach ($rsold as $row) {
				$thisKey = "";
				if ($thisKey != "")
					$thisKey .= Config("COMPOSITE_KEY_SEPARATOR");
				$thisKey .= $row['Nim'];
				if ($thisKey != "")
					$thisKey .= Config("COMPOSITE_KEY_SEPARATOR");
				$thisKey .= $row['Thn_Akademik'];
				if ($thisKey != "")
					$thisKey .= Config("COMPOSITE_KEY_SEPARATOR");
				$thisKey .= $row['Periode'];
				if ($thisKey != "")
					$thisKey .= Config("COMPOSITE_KEY_SEPARATOR");
				$thisKey .= $row['Kode_MK'];
				if (Config("DELETE_UPLOADED_FILES")) // Delete old files
					$this->deleteUploadedFiles($row);
				$conn->raiseErrorFn = Config("ERROR_FUNC");
				$deleteRows = $this->delete($row); // Delete
				$conn->raiseErrorFn = "";
				if ($deleteRows === FALSE)
					break;
				if ($key != "")
					$key .= ", ";
				$key .= $thisKey;
			}
		}
		if (!$deleteRows) {

			// Set up error message
			if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage != "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->phrase("DeleteCancelled"));
			}
		}
		if ($deleteRows) {
			$conn->commitTrans(); // Commit the changes
			if ($this->AuditTrailOnDelete)
				$this->writeAuditTrailDummy($Language->phrase("BatchDeleteSuccess")); // Batch delete success
		} else {
			$conn->rollbackTrans(); // Rollback changes
			if ($this->AuditTrailOnDelete)
				$this->writeAuditTrailDummy($Language->phrase("BatchDeleteRollback")); // Batch delete rollback
		}

		// Call Row Deleted event
		if ($deleteRows) {
			foreach ($rsold as $row) {
				$this->Row_Deleted($row);
			}
		}

		// Write JSON for API request (Support single row only)
		if (IsApi() && $deleteRows) {
			$row = $this->getRecordsFromRecordset($rsold, TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $deleteRows;
	}

	// Set up master/detail based on QueryString
	protected function setupMasterParms()
	{
		$validMaster = FALSE;

		// Get the keys for master table
		if (($master = Get(Config("TABLE_SHOW_MASTER"), Get(Config("TABLE_MASTER")))) !== NULL) {
			$masterTblVar = $master;
			if ($masterTblVar == "") {
				$validMaster = TRUE;
				$this->DbMasterFilter = "";
				$this->DbDetailFilter = "";
			}
			if ($masterTblVar == "V_LMHS") {
				$validMaster = TRUE;
				if (($parm = Get("fk_Nim", Get("Nim"))) !== NULL) {
					$GLOBALS["V_LMHS"]->Nim->setQueryStringValue($parm);
					$this->Nim->setQueryStringValue($GLOBALS["V_LMHS"]->Nim->QueryStringValue);
					$this->Nim->setSessionValue($this->Nim->QueryStringValue);
				} else {
					$validMaster = FALSE;
				}
			}
			if ($masterTblVar == "IM_Mhs") {
				$validMaster = TRUE;
				if (($parm = Get("fk_Nim", Get("Nim"))) !== NULL) {
					$GLOBALS["IM_Mhs"]->Nim->setQueryStringValue($parm);
					$this->Nim->setQueryStringValue($GLOBALS["IM_Mhs"]->Nim->QueryStringValue);
					$this->Nim->setSessionValue($this->Nim->QueryStringValue);
				} else {
					$validMaster = FALSE;
				}
			}
		} elseif (($master = Post(Config("TABLE_SHOW_MASTER"), Post(Config("TABLE_MASTER")))) !== NULL) {
			$masterTblVar = $master;
			if ($masterTblVar == "") {
				$validMaster = TRUE;
				$this->DbMasterFilter = "";
				$this->DbDetailFilter = "";
			}
			if ($masterTblVar == "V_LMHS") {
				$validMaster = TRUE;
				if (($parm = Post("fk_Nim", Post("Nim"))) !== NULL) {
					$GLOBALS["V_LMHS"]->Nim->setFormValue($parm);
					$this->Nim->setFormValue($GLOBALS["V_LMHS"]->Nim->FormValue);
					$this->Nim->setSessionValue($this->Nim->FormValue);
				} else {
					$validMaster = FALSE;
				}
			}
			if ($masterTblVar == "IM_Mhs") {
				$validMaster = TRUE;
				if (($parm = Post("fk_Nim", Post("Nim"))) !== NULL) {
					$GLOBALS["IM_Mhs"]->Nim->setFormValue($parm);
					$this->Nim->setFormValue($GLOBALS["IM_Mhs"]->Nim->FormValue);
					$this->Nim->setSessionValue($this->Nim->FormValue);
				} else {
					$validMaster = FALSE;
				}
			}
		}
		if ($validMaster) {

			// Save current master table
			$this->setCurrentMasterTable($masterTblVar);

			// Reset start record counter (new master key)
			if (!$this->isAddOrEdit()) {
				$this->StartRecord = 1;
				$this->setStartRecordNumber($this->StartRecord);
			}

			// Clear previous master key from Session
			if ($masterTblVar != "V_LMHS") {
				if ($this->Nim->CurrentValue == "")
					$this->Nim->setSessionValue("");
			}
			if ($masterTblVar != "IM_Mhs") {
				if ($this->Nim->CurrentValue == "")
					$this->Nim->setSessionValue("");
			}
		}
		$this->DbMasterFilter = $this->getMasterFilter(); // Get master filter
		$this->DbDetailFilter = $this->getDetailFilter(); // Get detail filter
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("tblNilaiPerMhslist.php"), "", $this->TableVar, TRUE);
		$pageId = "delete";
		$Breadcrumb->add("delete", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// Get default connection and filter
			$conn = $this->getConnection();
			$lookupFilter = "";

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL and connection
			switch ($fld->FieldVar) {
				case "x_Thn_Akademik":
					$conn = Conn("DB");
					break;
				case "x_Periode":
					break;
				case "x_Kode_MK":
					$conn = Conn("DB");
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0) {
				$totalCnt = $this->getRecordCount($sql, $conn);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_Thn_Akademik":
							break;
						case "x_Kode_MK":
							$row[3] = FormatNumber($row[3], 0, -2, -2, -2);
							$row['df3'] = $row[3];
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}
} // End class
?>