<?php namespace PHPMaker2020\baak; ?>
<?php

/**
 * Table class for tblSilabusMaster
 */
class tblSilabusMaster extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $Kode_Fak;
	public $Kode_MK;
	public $Kopentensi;
	public $Penjelasan;
	public $Prasyarat;
	public $DaftarPustaka;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;
		parent::__construct();

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'tblSilabusMaster';
		$this->TableName = 'tblSilabusMaster';
		$this->TableType = 'TABLE';

		// Update Table
		$this->UpdateTable = "[dbo].[tblSilabusMaster]";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
		$this->BasicSearch = new BasicSearch($this->TableVar);

		// Kode_Fak
		$this->Kode_Fak = new DbField('tblSilabusMaster', 'tblSilabusMaster', 'x_Kode_Fak', 'Kode_Fak', '[Kode_Fak]', '[Kode_Fak]', 129, 10, -1, FALSE, '[Kode_Fak]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->Kode_Fak->IsPrimaryKey = TRUE; // Primary key field
		$this->Kode_Fak->IsForeignKey = TRUE; // Foreign key field
		$this->Kode_Fak->Nullable = FALSE; // NOT NULL field
		$this->Kode_Fak->Required = TRUE; // Required field
		$this->Kode_Fak->Sortable = TRUE; // Allow sort
		$this->Kode_Fak->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->Kode_Fak->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
		$this->Kode_Fak->Lookup = new Lookup('Kode_Fak', 'tblFak', FALSE, 'Kode_Fak', ["Nama_Fak","","",""], [], [], [], [], [], [], '', '');
		$this->fields['Kode_Fak'] = &$this->Kode_Fak;

		// Kode_MK
		$this->Kode_MK = new DbField('tblSilabusMaster', 'tblSilabusMaster', 'x_Kode_MK', 'Kode_MK', '[Kode_MK]', '[Kode_MK]', 129, 14, -1, FALSE, '[EV__Kode_MK]', TRUE, TRUE, TRUE, 'FORMATTED TEXT', 'SELECT');
		$this->Kode_MK->IsPrimaryKey = TRUE; // Primary key field
		$this->Kode_MK->IsForeignKey = TRUE; // Foreign key field
		$this->Kode_MK->Nullable = FALSE; // NOT NULL field
		$this->Kode_MK->Required = TRUE; // Required field
		$this->Kode_MK->Sortable = TRUE; // Allow sort
		$this->Kode_MK->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->Kode_MK->PleaseSelectText = $Language->phrase("PleaseSelect"); // "PleaseSelect" text
		$this->Kode_MK->Lookup = new Lookup('Kode_MK', 'tblMK', FALSE, 'Kode_MK', ["Kode_MK","Nama_Mk_Ind","SKS",""], [], [], [], [], [], [], '', '');
		$this->fields['Kode_MK'] = &$this->Kode_MK;

		// Kopentensi
		$this->Kopentensi = new DbField('tblSilabusMaster', 'tblSilabusMaster', 'x_Kopentensi', 'Kopentensi', '[Kopentensi]', '[Kopentensi]', 200, 0, -1, FALSE, '[Kopentensi]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->Kopentensi->Sortable = TRUE; // Allow sort
		$this->fields['Kopentensi'] = &$this->Kopentensi;

		// Penjelasan
		$this->Penjelasan = new DbField('tblSilabusMaster', 'tblSilabusMaster', 'x_Penjelasan', 'Penjelasan', '[Penjelasan]', '[Penjelasan]', 200, 0, -1, FALSE, '[Penjelasan]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->Penjelasan->Sortable = TRUE; // Allow sort
		$this->fields['Penjelasan'] = &$this->Penjelasan;

		// Prasyarat
		$this->Prasyarat = new DbField('tblSilabusMaster', 'tblSilabusMaster', 'x_Prasyarat', 'Prasyarat', '[Prasyarat]', '[Prasyarat]', 200, 255, -1, FALSE, '[Prasyarat]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->Prasyarat->Sortable = TRUE; // Allow sort
		$this->fields['Prasyarat'] = &$this->Prasyarat;

		// DaftarPustaka
		$this->DaftarPustaka = new DbField('tblSilabusMaster', 'tblSilabusMaster', 'x_DaftarPustaka', 'DaftarPustaka', '[DaftarPustaka]', '[DaftarPustaka]', 200, 0, -1, FALSE, '[DaftarPustaka]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->DaftarPustaka->Sortable = TRUE; // Allow sort
		$this->fields['DaftarPustaka'] = &$this->DaftarPustaka;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Single column sort
	public function updateSort(&$fld)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
			$sortFieldList = ($fld->VirtualExpression != "") ? $fld->VirtualExpression : $sortField;
			$this->setSessionOrderByList($sortFieldList . " " . $thisSort); // Save to Session
		} else {
			$fld->setSort("");
		}
	}

	// Session ORDER BY for List page
	public function getSessionOrderByList()
	{
		return @$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_ORDER_BY_LIST")];
	}
	public function setSessionOrderByList($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_ORDER_BY_LIST")] = $v;
	}

	// Current detail table name
	public function getCurrentDetailTable()
	{
		return @$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_DETAIL_TABLE")];
	}
	public function setCurrentDetailTable($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_DETAIL_TABLE")] = $v;
	}

	// Get detail url
	public function getDetailUrl()
	{

		// Detail url
		$detailUrl = "";
		if ($this->getCurrentDetailTable() == "tblSilabus") {
			$detailUrl = $GLOBALS["tblSilabus"]->getListUrl() . "?" . Config("TABLE_SHOW_MASTER") . "=" . $this->TableVar;
			$detailUrl .= "&fk_Kode_Fak=" . urlencode($this->Kode_Fak->CurrentValue);
			$detailUrl .= "&fk_Kode_MK=" . urlencode($this->Kode_MK->CurrentValue);
		}
		if ($detailUrl == "")
			$detailUrl = "tblSilabusMasterlist.php";
		return $detailUrl;
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom != "") ? $this->SqlFrom : "[dbo].[tblSilabusMaster]";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect != "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlSelectList() // Select for List page
	{
		$select = "";
		$select = "SELECT * FROM (" .
			"SELECT *, (SELECT TOP 1 CONVERT(NVARCHAR(MAX),[Kode_MK]) + '" . ValueSeparator(1, $this->Kode_MK) . "' + CONVERT(NVARCHAR(MAX),[Nama_Mk_Ind]) + '" . ValueSeparator(2, $this->Kode_MK) . "' + CONVERT(NVARCHAR(MAX),[SKS]) FROM [dbo].[tblMK] [TMP_LOOKUPTABLE] WHERE [TMP_LOOKUPTABLE].[Kode_MK] = [tblSilabusMaster].[Kode_MK]) AS [EV__Kode_MK] FROM [dbo].[tblSilabusMaster]" .
			") [TMP_TABLE]";
		return ($this->SqlSelectList != "") ? $this->SqlSelectList : $select;
	}
	public function sqlSelectList() // For backward compatibility
	{
		return $this->getSqlSelectList();
	}
	public function setSqlSelectList($v)
	{
		$this->SqlSelectList = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy != "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving != "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter, $id = "")
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = $this->UserIDAllowSecurity;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 32) == 32);
			case "search":
				return (($allow & 64) == 64);
			case "lookup":
				return (($allow & 256) == 256);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get recordset
	public function getRecordset($sql, $rowcnt = -1, $offset = -1)
	{
		$conn = $this->getConnection();
		$conn->raiseErrorFn = Config("ERROR_FUNC");
		$rs = $conn->selectLimit($sql, $rowcnt, $offset);
		$conn->raiseErrorFn = "";
		return $rs;
	}

	// Get record count
	public function getRecordCount($sql, $c = NULL)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) &&
			!preg_match('/^\s*select\s+distinct\s+/i', $sql) && !preg_match('/\s+order\s+by\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = $c ?: $this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		if ($this->useVirtualFields()) {
			$select = $this->getSqlSelectList();
			$sort = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
		} else {
			$select = $this->getSqlSelect();
			$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		}
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = ($this->useVirtualFields()) ? $this->getSessionOrderByList() : $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Check if virtual fields is used in SQL
	protected function useVirtualFields()
	{
		$where = $this->UseSessionForListSql ? $this->getSessionWhere() : $this->CurrentFilter;
		$orderBy = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
		if ($where != "")
			$where = " " . str_replace(["(", ")"], ["", ""], $where) . " ";
		if ($orderBy != "")
			$orderBy = " " . str_replace(["(", ")"], ["", ""], $orderBy) . " ";
		if ($this->BasicSearch->getKeyword() != "")
			return TRUE;
		if ($this->Kode_MK->AdvancedSearch->SearchValue != "" ||
			$this->Kode_MK->AdvancedSearch->SearchValue2 != "" ||
			ContainsString($where, " " . $this->Kode_MK->VirtualExpression . " "))
			return TRUE;
		if (ContainsString($orderBy, " " . $this->Kode_MK->VirtualExpression . " "))
			return TRUE;
		return FALSE;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		if ($this->useVirtualFields())
			$sql = BuildSelectSql($this->getSqlSelectList(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		else
			$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " (" . $names . ") VALUES (" . $values . ")";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = $this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsAutoIncrement)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter != "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = $this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('Kode_Fak', $rs))
				AddFilter($where, QuotedName('Kode_Fak', $this->Dbid) . '=' . QuotedValue($rs['Kode_Fak'], $this->Kode_Fak->DataType, $this->Dbid));
			if (array_key_exists('Kode_MK', $rs))
				AddFilter($where, QuotedName('Kode_MK', $this->Dbid) . '=' . QuotedValue($rs['Kode_MK'], $this->Kode_MK->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter != "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = $this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->Kode_Fak->DbValue = $row['Kode_Fak'];
		$this->Kode_MK->DbValue = $row['Kode_MK'];
		$this->Kopentensi->DbValue = $row['Kopentensi'];
		$this->Penjelasan->DbValue = $row['Penjelasan'];
		$this->Prasyarat->DbValue = $row['Prasyarat'];
		$this->DaftarPustaka->DbValue = $row['DaftarPustaka'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "[Kode_Fak] = '@Kode_Fak@' AND [Kode_MK] = '@Kode_MK@'";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		if (is_array($row))
			$val = array_key_exists('Kode_Fak', $row) ? $row['Kode_Fak'] : NULL;
		else
			$val = $this->Kode_Fak->OldValue !== NULL ? $this->Kode_Fak->OldValue : $this->Kode_Fak->CurrentValue;
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@Kode_Fak@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		if (is_array($row))
			$val = array_key_exists('Kode_MK', $row) ? $row['Kode_MK'] : NULL;
		else
			$val = $this->Kode_MK->OldValue !== NULL ? $this->Kode_MK->OldValue : $this->Kode_MK->CurrentValue;
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@Kode_MK@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") != "" && ReferPageName() != CurrentPageName() && ReferPageName() != "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] != "") {
			return $_SESSION[$name];
		} else {
			return "tblSilabusMasterlist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "tblSilabusMasterview.php")
			return $Language->phrase("View");
		elseif ($pageName == "tblSilabusMasteredit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "tblSilabusMasteradd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "tblSilabusMasterlist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm != "")
			$url = $this->keyUrl("tblSilabusMasterview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("tblSilabusMasterview.php", $this->getUrlParm(Config("TABLE_SHOW_DETAIL") . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm != "")
			$url = "tblSilabusMasteradd.php?" . $this->getUrlParm($parm);
		else
			$url = "tblSilabusMasteradd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		if ($parm != "")
			$url = $this->keyUrl("tblSilabusMasteredit.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("tblSilabusMasteredit.php", $this->getUrlParm(Config("TABLE_SHOW_DETAIL") . "="));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		if ($parm != "")
			$url = $this->keyUrl("tblSilabusMasteradd.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("tblSilabusMasteradd.php", $this->getUrlParm(Config("TABLE_SHOW_DETAIL") . "="));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("tblSilabusMasterdelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "Kode_Fak:" . JsonEncode($this->Kode_Fak->CurrentValue, "string");
		$json .= ",Kode_MK:" . JsonEncode($this->Kode_MK->CurrentValue, "string");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm != "")
			$url .= $parm . "&";
		if ($this->Kode_Fak->CurrentValue != NULL) {
			$url .= "Kode_Fak=" . urlencode($this->Kode_Fak->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		if ($this->Kode_MK->CurrentValue != NULL) {
			$url .= "&Kode_MK=" . urlencode($this->Kode_MK->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, [141, 201, 203, 128, 204, 205])) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		$arKeys = [];
		$arKey = [];
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
			for ($i = 0; $i < $cnt; $i++)
				$arKeys[$i] = explode(Config("COMPOSITE_KEY_SEPARATOR"), $arKeys[$i]);
		} else {
			if (Param("Kode_Fak") !== NULL)
				$arKey[] = Param("Kode_Fak");
			elseif (IsApi() && Key(0) !== NULL)
				$arKey[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKey[] = Route(2);
			else
				$arKeys = NULL; // Do not setup
			if (Param("Kode_MK") !== NULL)
				$arKey[] = Param("Kode_MK");
			elseif (IsApi() && Key(1) !== NULL)
				$arKey[] = Key(1);
			elseif (IsApi() && Route(3) !== NULL)
				$arKey[] = Route(3);
			else
				$arKeys = NULL; // Do not setup
			if (is_array($arKeys)) $arKeys[] = $arKey;

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = [];
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_array($key) || count($key) != 2)
					continue; // Just skip so other keys will still work
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys($setCurrent = TRUE)
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter != "") $keyFilter .= " OR ";
			if ($setCurrent)
				$this->Kode_Fak->CurrentValue = $key[0];
			else
				$this->Kode_Fak->OldValue = $key[0];
			if ($setCurrent)
				$this->Kode_MK->CurrentValue = $key[1];
			else
				$this->Kode_MK->OldValue = $key[1];
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = $this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->Kode_Fak->setDbValue($rs->fields('Kode_Fak'));
		$this->Kode_MK->setDbValue($rs->fields('Kode_MK'));
		$this->Kopentensi->setDbValue($rs->fields('Kopentensi'));
		$this->Penjelasan->setDbValue($rs->fields('Penjelasan'));
		$this->Prasyarat->setDbValue($rs->fields('Prasyarat'));
		$this->DaftarPustaka->setDbValue($rs->fields('DaftarPustaka'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// Kode_Fak
		// Kode_MK
		// Kopentensi
		// Penjelasan
		// Prasyarat
		// DaftarPustaka
		// Kode_Fak

		$curVal = strval($this->Kode_Fak->CurrentValue);
		if ($curVal != "") {
			$this->Kode_Fak->ViewValue = $this->Kode_Fak->lookupCacheOption($curVal);
			if ($this->Kode_Fak->ViewValue === NULL) { // Lookup from database
				$filterWrk = "[Kode_Fak]" . SearchString("=", $curVal, DATATYPE_STRING, "");
				$sqlWrk = $this->Kode_Fak->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = [];
					$arwrk[1] = $rswrk->fields('df');
					$this->Kode_Fak->ViewValue = $this->Kode_Fak->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->Kode_Fak->ViewValue = $this->Kode_Fak->CurrentValue;
				}
			}
		} else {
			$this->Kode_Fak->ViewValue = NULL;
		}
		$this->Kode_Fak->ViewCustomAttributes = "";

		// Kode_MK
		if ($this->Kode_MK->VirtualValue != "") {
			$this->Kode_MK->ViewValue = $this->Kode_MK->VirtualValue;
		} else {
			$curVal = strval($this->Kode_MK->CurrentValue);
			if ($curVal != "") {
				$this->Kode_MK->ViewValue = $this->Kode_MK->lookupCacheOption($curVal);
				if ($this->Kode_MK->ViewValue === NULL) { // Lookup from database
					$filterWrk = "[Kode_MK]" . SearchString("=", $curVal, DATATYPE_STRING, "");
					$sqlWrk = $this->Kode_MK->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = [];
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$arwrk[3] = FormatNumber($rswrk->fields('df3'), 0, -2, -2, -2);
						$this->Kode_MK->ViewValue = $this->Kode_MK->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->Kode_MK->ViewValue = $this->Kode_MK->CurrentValue;
					}
				}
			} else {
				$this->Kode_MK->ViewValue = NULL;
			}
		}
		$this->Kode_MK->ViewCustomAttributes = "";

		// Kopentensi
		$this->Kopentensi->ViewValue = $this->Kopentensi->CurrentValue;
		if ($this->Kopentensi->ViewValue != NULL)
			$this->Kopentensi->ViewValue = str_replace("\n", "<br>", $this->Kopentensi->ViewValue);
		$this->Kopentensi->ViewCustomAttributes = "";

		// Penjelasan
		$this->Penjelasan->ViewValue = $this->Penjelasan->CurrentValue;
		$this->Penjelasan->ViewCustomAttributes = "";

		// Prasyarat
		$this->Prasyarat->ViewValue = $this->Prasyarat->CurrentValue;
		if ($this->Prasyarat->ViewValue != NULL)
			$this->Prasyarat->ViewValue = str_replace("\n", "<br>", $this->Prasyarat->ViewValue);
		$this->Prasyarat->ViewCustomAttributes = "";

		// DaftarPustaka
		$this->DaftarPustaka->ViewValue = $this->DaftarPustaka->CurrentValue;
		if ($this->DaftarPustaka->ViewValue != NULL)
			$this->DaftarPustaka->ViewValue = str_replace("\n", "<br>", $this->DaftarPustaka->ViewValue);
		$this->DaftarPustaka->ViewCustomAttributes = "";

		// Kode_Fak
		$this->Kode_Fak->LinkCustomAttributes = "";
		$this->Kode_Fak->HrefValue = "";
		$this->Kode_Fak->TooltipValue = "";

		// Kode_MK
		$this->Kode_MK->LinkCustomAttributes = "";
		$this->Kode_MK->HrefValue = "";
		$this->Kode_MK->TooltipValue = "";

		// Kopentensi
		$this->Kopentensi->LinkCustomAttributes = "";
		$this->Kopentensi->HrefValue = "";
		$this->Kopentensi->TooltipValue = "";

		// Penjelasan
		$this->Penjelasan->LinkCustomAttributes = "";
		$this->Penjelasan->HrefValue = "";
		$this->Penjelasan->TooltipValue = "";

		// Prasyarat
		$this->Prasyarat->LinkCustomAttributes = "";
		$this->Prasyarat->HrefValue = "";
		$this->Prasyarat->TooltipValue = "";

		// DaftarPustaka
		$this->DaftarPustaka->LinkCustomAttributes = "";
		$this->DaftarPustaka->HrefValue = "";
		$this->DaftarPustaka->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Kode_Fak
		$this->Kode_Fak->EditAttrs["class"] = "form-control";
		$this->Kode_Fak->EditCustomAttributes = "";

		// Kode_MK
		$this->Kode_MK->EditAttrs["class"] = "form-control";
		$this->Kode_MK->EditCustomAttributes = "";

		// Kopentensi
		$this->Kopentensi->EditAttrs["class"] = "form-control";
		$this->Kopentensi->EditCustomAttributes = "";
		$this->Kopentensi->EditValue = $this->Kopentensi->CurrentValue;
		$this->Kopentensi->PlaceHolder = RemoveHtml($this->Kopentensi->caption());

		// Penjelasan
		$this->Penjelasan->EditAttrs["class"] = "form-control";
		$this->Penjelasan->EditCustomAttributes = "";
		$this->Penjelasan->EditValue = $this->Penjelasan->CurrentValue;
		$this->Penjelasan->PlaceHolder = RemoveHtml($this->Penjelasan->caption());

		// Prasyarat
		$this->Prasyarat->EditAttrs["class"] = "form-control";
		$this->Prasyarat->EditCustomAttributes = "";
		$this->Prasyarat->EditValue = $this->Prasyarat->CurrentValue;
		$this->Prasyarat->PlaceHolder = RemoveHtml($this->Prasyarat->caption());

		// DaftarPustaka
		$this->DaftarPustaka->EditAttrs["class"] = "form-control";
		$this->DaftarPustaka->EditCustomAttributes = "";
		$this->DaftarPustaka->EditValue = $this->DaftarPustaka->CurrentValue;
		$this->DaftarPustaka->PlaceHolder = RemoveHtml($this->DaftarPustaka->caption());

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->Kode_Fak);
					$doc->exportCaption($this->Kode_MK);
					$doc->exportCaption($this->Kopentensi);
					$doc->exportCaption($this->Penjelasan);
					$doc->exportCaption($this->Prasyarat);
					$doc->exportCaption($this->DaftarPustaka);
				} else {
					$doc->exportCaption($this->Kode_Fak);
					$doc->exportCaption($this->Kode_MK);
					$doc->exportCaption($this->Kopentensi);
					$doc->exportCaption($this->Penjelasan);
					$doc->exportCaption($this->Prasyarat);
					$doc->exportCaption($this->DaftarPustaka);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->Kode_Fak);
						$doc->exportField($this->Kode_MK);
						$doc->exportField($this->Kopentensi);
						$doc->exportField($this->Penjelasan);
						$doc->exportField($this->Prasyarat);
						$doc->exportField($this->DaftarPustaka);
					} else {
						$doc->exportField($this->Kode_Fak);
						$doc->exportField($this->Kode_MK);
						$doc->exportField($this->Kopentensi);
						$doc->exportField($this->Penjelasan);
						$doc->exportField($this->Prasyarat);
						$doc->exportField($this->DaftarPustaka);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0)
	{

		// No binary fields
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>