<?php
namespace PHPMaker2020\baak;

/**
 * Page class
 */
class tblSilabusMaster_add extends tblSilabusMaster
{

	// Page ID
	public $PageID = "add";

	// Project ID
	public $ProjectID = "{A09D3AFF-419C-4918-948A-A3C8469EA234}";

	// Table name
	public $TableName = 'tblSilabusMaster';

	// Page object name
	public $PageObjName = "tblSilabusMaster_add";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken;

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading != "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading != "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		$url = CurrentPageName() . "?";
		if ($this->UseTokenInUrl)
			$url .= "t=" . $this->TableVar . "&"; // Add page token
		return $url;
	}

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = TRUE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message != "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fas fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage != "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fas fa-exclamation"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage != "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fas fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage != "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fas fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = [];

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message != "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage != "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage != "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage != "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header != "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer != "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(Config("TOKEN_NAME")) === NULL)
			return FALSE;
		$fn = Config("CHECK_TOKEN_FUNC");
		if (is_callable($fn))
			return $fn(Post(Config("TOKEN_NAME")), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = Config("CREATE_TOKEN_FUNC"); // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $DashboardReport;
		global $UserTable;

		// Check token
		$this->CheckToken = Config("CHECK_TOKEN");

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (tblSilabusMaster)
		if (!isset($GLOBALS["tblSilabusMaster"]) || get_class($GLOBALS["tblSilabusMaster"]) == PROJECT_NAMESPACE . "tblSilabusMaster") {
			$GLOBALS["tblSilabusMaster"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["tblSilabusMaster"];
		}

		// Table object (Pass)
		if (!isset($GLOBALS['Pass']))
			$GLOBALS['Pass'] = new Pass();

		// Page ID (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'add');

		// Table name (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'tblSilabusMaster');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = $this->getConnection();

		// User table object (Pass)
		$UserTable = $UserTable ?: new Pass();
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages, $DashboardReport;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $tblSilabusMaster;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, Config("EXPORT_CLASSES"))) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . Config("EXPORT_CLASSES." . $this->CustomExport);
			if (class_exists($class)) {
				$doc = new $class($tblSilabusMaster);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url != "") {
			if (!Config("DEBUG") && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = ["url" => $url, "modal" => "1"];
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "tblSilabusMasterview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = [];
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = [];
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {
								$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
									Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
									Config("API_FIELD_NAME") . "=" . $fld->Param . "&" .
									Config("API_KEY_NAME") . "=" . rawurlencode($this->getRecordKeyValue($ar)))); //*** need to add this? API may not be in the same folder
								$row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
								$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
									Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
									"fn=" . Encrypt($fld->physicalUploadPath() . $val)));
								$row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
							} else { // Multiple files
								$files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
								$ar = [];
								foreach ($files as $file) {
									$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
										Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
										"fn=" . Encrypt($fld->physicalUploadPath() . $file)));
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['Kode_Fak'] . Config("COMPOSITE_KEY_SEPARATOR");
			$key .= @$ar['Kode_MK'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
	}

	// Lookup data
	public function lookup()
	{
		global $Language, $Security;
		if (!isset($Language))
			$Language = new Language(Config("LANGUAGE_FOLDER"), Post("language", ""));

		// Set up API request
		if (!ValidApiRequest())
			return FALSE;
		$this->setupApiSecurity();

		// Get lookup object
		$fieldName = Post("field");
		if (!array_key_exists($fieldName, $this->fields))
			return FALSE;
		$lookupField = $this->fields[$fieldName];
		$lookup = $lookupField->Lookup;
		if ($lookup === NULL)
			return FALSE;
		$tbl = $lookup->getTable();
		if (!$Security->allowLookup(Config("PROJECT_ID") . $tbl->TableName)) // Lookup permission
			return FALSE;

		// Get lookup parameters
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Param("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
			$lookup->FilterFields = []; // Skip parent fields if any
			$lookup->FilterValues[] = $keys; // Lookup values
			$pageSize = -1; // Show all records
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect != "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter != "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy != "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson($this); // Use settings from current page
	}

	// Set up API security
	public function setupApiSecurity()
	{
		global $Security;

		// Setup security for API request
		if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
		$Security->loadCurrentUserLevel(Config("PROJECT_ID") . $this->TableName);
		if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
	}
	public $FormClassName = "ew-horizontal ew-form ew-add-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $DbMasterFilter = "";
	public $DbDetailFilter = "";
	public $StartRecord;
	public $Priv = 0;
	public $OldRecordset;
	public $CopyRecord;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		if (ValidApiRequest()) { // API request
			$this->setupApiSecurity(); // Set up API Security
			if (!$Security->canAdd()) {
				SetStatus(401); // Unauthorized
				return;
			}
		} else {
			$Security = new AdvancedSecurity();
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canAdd()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("tblSilabusMasterlist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->Kode_Fak->setVisibility();
		$this->Kode_MK->setVisibility();
		$this->Kopentensi->setVisibility();
		$this->Penjelasan->setVisibility();
		$this->Prasyarat->setVisibility();
		$this->DaftarPustaka->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->Kode_Fak);
		$this->setupLookupOptions($this->Kode_MK);

		// Check permission
		if (!$Security->canAdd()) {
			$this->setFailureMessage(DeniedMessage()); // No permission
			$this->terminate("tblSilabusMasterlist.php");
			return;
		}

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-add-form ew-horizontal";
		$postBack = FALSE;

		// Set up current action
		if (IsApi()) {
			$this->CurrentAction = "insert"; // Add record directly
			$postBack = TRUE;
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action"); // Get form action
			$postBack = TRUE;
		} else { // Not post back

			// Load key values from QueryString
			$this->CopyRecord = TRUE;
			if (Get("Kode_Fak") !== NULL) {
				$this->Kode_Fak->setQueryStringValue(Get("Kode_Fak"));
				$this->setKey("Kode_Fak", $this->Kode_Fak->CurrentValue); // Set up key
			} else {
				$this->setKey("Kode_Fak", ""); // Clear key
				$this->CopyRecord = FALSE;
			}
			if (Get("Kode_MK") !== NULL) {
				$this->Kode_MK->setQueryStringValue(Get("Kode_MK"));
				$this->setKey("Kode_MK", $this->Kode_MK->CurrentValue); // Set up key
			} else {
				$this->setKey("Kode_MK", ""); // Clear key
				$this->CopyRecord = FALSE;
			}
			if ($this->CopyRecord) {
				$this->CurrentAction = "copy"; // Copy record
			} else {
				$this->CurrentAction = "show"; // Display blank record
			}
		}

		// Load old record / default values
		$loaded = $this->loadOldRecord();

		// Load form values
		if ($postBack) {
			$this->loadFormValues(); // Load form values
		}

		// Set up detail parameters
		$this->setupDetailParms();

		// Validate form if post back
		if ($postBack) {
			if (!$this->validateForm()) {
				$this->EventCancelled = TRUE; // Event cancelled
				$this->restoreFormValues(); // Restore form values
				$this->setFailureMessage($FormError);
				if (IsApi()) {
					$this->terminate();
					return;
				} else {
					$this->CurrentAction = "show"; // Form error, reset action
				}
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "copy": // Copy an existing record
				if (!$loaded) { // Record not loaded
					if ($this->getFailureMessage() == "")
						$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
					$this->terminate("tblSilabusMasterlist.php"); // No matching record, return to list
				}

				// Set up detail parameters
				$this->setupDetailParms();
				break;
			case "insert": // Add new record
				$this->SendEmail = TRUE; // Send email on add success
				if ($this->addRow($this->OldRecordset)) { // Add successful
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
					if ($this->getCurrentDetailTable() != "") // Master/detail add
						$returnUrl = $this->getDetailUrl();
					else
						$returnUrl = $this->getReturnUrl();
					if (GetPageName($returnUrl) == "tblSilabusMasterlist.php")
						$returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
					elseif (GetPageName($returnUrl) == "tblSilabusMasterview.php")
						$returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
					if (IsApi()) { // Return to caller
						$this->terminate(TRUE);
						return;
					} else {
						$this->terminate($returnUrl);
					}
				} elseif (IsApi()) { // API request, return
					$this->terminate();
					return;
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->restoreFormValues(); // Add failed, restore form values

					// Set up detail parameters
					$this->setupDetailParms();
				}
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Render row based on row type
		$this->RowType = ROWTYPE_ADD; // Render add type

		// Render row
		$this->resetAttributes();
		$this->renderRow();
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
	}

	// Load default values
	protected function loadDefaultValues()
	{
		$this->Kode_Fak->CurrentValue = NULL;
		$this->Kode_Fak->OldValue = $this->Kode_Fak->CurrentValue;
		$this->Kode_MK->CurrentValue = NULL;
		$this->Kode_MK->OldValue = $this->Kode_MK->CurrentValue;
		$this->Kopentensi->CurrentValue = NULL;
		$this->Kopentensi->OldValue = $this->Kopentensi->CurrentValue;
		$this->Penjelasan->CurrentValue = NULL;
		$this->Penjelasan->OldValue = $this->Penjelasan->CurrentValue;
		$this->Prasyarat->CurrentValue = NULL;
		$this->Prasyarat->OldValue = $this->Prasyarat->CurrentValue;
		$this->DaftarPustaka->CurrentValue = NULL;
		$this->DaftarPustaka->OldValue = $this->DaftarPustaka->CurrentValue;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;

		// Check field name 'Kode_Fak' first before field var 'x_Kode_Fak'
		$val = $CurrentForm->hasValue("Kode_Fak") ? $CurrentForm->getValue("Kode_Fak") : $CurrentForm->getValue("x_Kode_Fak");
		if (!$this->Kode_Fak->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->Kode_Fak->Visible = FALSE; // Disable update for API request
			else
				$this->Kode_Fak->setFormValue($val);
		}

		// Check field name 'Kode_MK' first before field var 'x_Kode_MK'
		$val = $CurrentForm->hasValue("Kode_MK") ? $CurrentForm->getValue("Kode_MK") : $CurrentForm->getValue("x_Kode_MK");
		if (!$this->Kode_MK->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->Kode_MK->Visible = FALSE; // Disable update for API request
			else
				$this->Kode_MK->setFormValue($val);
		}

		// Check field name 'Kopentensi' first before field var 'x_Kopentensi'
		$val = $CurrentForm->hasValue("Kopentensi") ? $CurrentForm->getValue("Kopentensi") : $CurrentForm->getValue("x_Kopentensi");
		if (!$this->Kopentensi->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->Kopentensi->Visible = FALSE; // Disable update for API request
			else
				$this->Kopentensi->setFormValue($val);
		}

		// Check field name 'Penjelasan' first before field var 'x_Penjelasan'
		$val = $CurrentForm->hasValue("Penjelasan") ? $CurrentForm->getValue("Penjelasan") : $CurrentForm->getValue("x_Penjelasan");
		if (!$this->Penjelasan->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->Penjelasan->Visible = FALSE; // Disable update for API request
			else
				$this->Penjelasan->setFormValue($val);
		}

		// Check field name 'Prasyarat' first before field var 'x_Prasyarat'
		$val = $CurrentForm->hasValue("Prasyarat") ? $CurrentForm->getValue("Prasyarat") : $CurrentForm->getValue("x_Prasyarat");
		if (!$this->Prasyarat->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->Prasyarat->Visible = FALSE; // Disable update for API request
			else
				$this->Prasyarat->setFormValue($val);
		}

		// Check field name 'DaftarPustaka' first before field var 'x_DaftarPustaka'
		$val = $CurrentForm->hasValue("DaftarPustaka") ? $CurrentForm->getValue("DaftarPustaka") : $CurrentForm->getValue("x_DaftarPustaka");
		if (!$this->DaftarPustaka->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->DaftarPustaka->Visible = FALSE; // Disable update for API request
			else
				$this->DaftarPustaka->setFormValue($val);
		}
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->Kode_Fak->CurrentValue = $this->Kode_Fak->FormValue;
		$this->Kode_MK->CurrentValue = $this->Kode_MK->FormValue;
		$this->Kopentensi->CurrentValue = $this->Kopentensi->FormValue;
		$this->Penjelasan->CurrentValue = $this->Penjelasan->FormValue;
		$this->Prasyarat->CurrentValue = $this->Prasyarat->FormValue;
		$this->DaftarPustaka->CurrentValue = $this->DaftarPustaka->FormValue;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = $this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->Kode_Fak->setDbValue($row['Kode_Fak']);
		$this->Kode_MK->setDbValue($row['Kode_MK']);
		if (array_key_exists('EV__Kode_MK', $rs->fields)) {
			$this->Kode_MK->VirtualValue = $rs->fields('EV__Kode_MK'); // Set up virtual field value
		} else {
			$this->Kode_MK->VirtualValue = ""; // Clear value
		}
		$this->Kopentensi->setDbValue($row['Kopentensi']);
		$this->Penjelasan->setDbValue($row['Penjelasan']);
		$this->Prasyarat->setDbValue($row['Prasyarat']);
		$this->DaftarPustaka->setDbValue($row['DaftarPustaka']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$this->loadDefaultValues();
		$row = [];
		$row['Kode_Fak'] = $this->Kode_Fak->CurrentValue;
		$row['Kode_MK'] = $this->Kode_MK->CurrentValue;
		$row['Kopentensi'] = $this->Kopentensi->CurrentValue;
		$row['Penjelasan'] = $this->Penjelasan->CurrentValue;
		$row['Prasyarat'] = $this->Prasyarat->CurrentValue;
		$row['DaftarPustaka'] = $this->DaftarPustaka->CurrentValue;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("Kode_Fak")) != "")
			$this->Kode_Fak->OldValue = $this->getKey("Kode_Fak"); // Kode_Fak
		else
			$validKey = FALSE;
		if (strval($this->getKey("Kode_MK")) != "")
			$this->Kode_MK->OldValue = $this->getKey("Kode_MK"); // Kode_MK
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = $this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Call Row_Rendering event

		$this->Row_Rendering();

		// Common render codes for all row types
		// Kode_Fak
		// Kode_MK
		// Kopentensi
		// Penjelasan
		// Prasyarat
		// DaftarPustaka

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// Kode_Fak
			$curVal = strval($this->Kode_Fak->CurrentValue);
			if ($curVal != "") {
				$this->Kode_Fak->ViewValue = $this->Kode_Fak->lookupCacheOption($curVal);
				if ($this->Kode_Fak->ViewValue === NULL) { // Lookup from database
					$filterWrk = "[Kode_Fak]" . SearchString("=", $curVal, DATATYPE_STRING, "");
					$sqlWrk = $this->Kode_Fak->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = [];
						$arwrk[1] = $rswrk->fields('df');
						$this->Kode_Fak->ViewValue = $this->Kode_Fak->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->Kode_Fak->ViewValue = $this->Kode_Fak->CurrentValue;
					}
				}
			} else {
				$this->Kode_Fak->ViewValue = NULL;
			}
			$this->Kode_Fak->ViewCustomAttributes = "";

			// Kode_MK
			if ($this->Kode_MK->VirtualValue != "") {
				$this->Kode_MK->ViewValue = $this->Kode_MK->VirtualValue;
			} else {
				$curVal = strval($this->Kode_MK->CurrentValue);
				if ($curVal != "") {
					$this->Kode_MK->ViewValue = $this->Kode_MK->lookupCacheOption($curVal);
					if ($this->Kode_MK->ViewValue === NULL) { // Lookup from database
						$filterWrk = "[Kode_MK]" . SearchString("=", $curVal, DATATYPE_STRING, "");
						$sqlWrk = $this->Kode_MK->Lookup->getSql(FALSE, $filterWrk, '', $this);
						$rswrk = Conn()->execute($sqlWrk);
						if ($rswrk && !$rswrk->EOF) { // Lookup values found
							$arwrk = [];
							$arwrk[1] = $rswrk->fields('df');
							$arwrk[2] = $rswrk->fields('df2');
							$arwrk[3] = FormatNumber($rswrk->fields('df3'), 0, -2, -2, -2);
							$this->Kode_MK->ViewValue = $this->Kode_MK->displayValue($arwrk);
							$rswrk->Close();
						} else {
							$this->Kode_MK->ViewValue = $this->Kode_MK->CurrentValue;
						}
					}
				} else {
					$this->Kode_MK->ViewValue = NULL;
				}
			}
			$this->Kode_MK->ViewCustomAttributes = "";

			// Kopentensi
			$this->Kopentensi->ViewValue = $this->Kopentensi->CurrentValue;
			if ($this->Kopentensi->ViewValue != NULL)
				$this->Kopentensi->ViewValue = str_replace("\n", "<br>", $this->Kopentensi->ViewValue);
			$this->Kopentensi->ViewCustomAttributes = "";

			// Penjelasan
			$this->Penjelasan->ViewValue = $this->Penjelasan->CurrentValue;
			$this->Penjelasan->ViewCustomAttributes = "";

			// Prasyarat
			$this->Prasyarat->ViewValue = $this->Prasyarat->CurrentValue;
			if ($this->Prasyarat->ViewValue != NULL)
				$this->Prasyarat->ViewValue = str_replace("\n", "<br>", $this->Prasyarat->ViewValue);
			$this->Prasyarat->ViewCustomAttributes = "";

			// DaftarPustaka
			$this->DaftarPustaka->ViewValue = $this->DaftarPustaka->CurrentValue;
			if ($this->DaftarPustaka->ViewValue != NULL)
				$this->DaftarPustaka->ViewValue = str_replace("\n", "<br>", $this->DaftarPustaka->ViewValue);
			$this->DaftarPustaka->ViewCustomAttributes = "";

			// Kode_Fak
			$this->Kode_Fak->LinkCustomAttributes = "";
			$this->Kode_Fak->HrefValue = "";
			$this->Kode_Fak->TooltipValue = "";

			// Kode_MK
			$this->Kode_MK->LinkCustomAttributes = "";
			$this->Kode_MK->HrefValue = "";
			$this->Kode_MK->TooltipValue = "";

			// Kopentensi
			$this->Kopentensi->LinkCustomAttributes = "";
			$this->Kopentensi->HrefValue = "";
			$this->Kopentensi->TooltipValue = "";

			// Penjelasan
			$this->Penjelasan->LinkCustomAttributes = "";
			$this->Penjelasan->HrefValue = "";
			$this->Penjelasan->TooltipValue = "";

			// Prasyarat
			$this->Prasyarat->LinkCustomAttributes = "";
			$this->Prasyarat->HrefValue = "";
			$this->Prasyarat->TooltipValue = "";

			// DaftarPustaka
			$this->DaftarPustaka->LinkCustomAttributes = "";
			$this->DaftarPustaka->HrefValue = "";
			$this->DaftarPustaka->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_ADD) { // Add row

			// Kode_Fak
			$this->Kode_Fak->EditAttrs["class"] = "form-control";
			$this->Kode_Fak->EditCustomAttributes = "";
			$curVal = trim(strval($this->Kode_Fak->CurrentValue));
			if ($curVal != "")
				$this->Kode_Fak->ViewValue = $this->Kode_Fak->lookupCacheOption($curVal);
			else
				$this->Kode_Fak->ViewValue = $this->Kode_Fak->Lookup !== NULL && is_array($this->Kode_Fak->Lookup->Options) ? $curVal : NULL;
			if ($this->Kode_Fak->ViewValue !== NULL) { // Load from cache
				$this->Kode_Fak->EditValue = array_values($this->Kode_Fak->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "[Kode_Fak]" . SearchString("=", $this->Kode_Fak->CurrentValue, DATATYPE_STRING, "");
				}
				$sqlWrk = $this->Kode_Fak->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = $rswrk ? $rswrk->getRows() : [];
				if ($rswrk)
					$rswrk->close();
				$this->Kode_Fak->EditValue = $arwrk;
			}

			// Kode_MK
			$this->Kode_MK->EditCustomAttributes = "";
			$curVal = trim(strval($this->Kode_MK->CurrentValue));
			if ($curVal != "")
				$this->Kode_MK->ViewValue = $this->Kode_MK->lookupCacheOption($curVal);
			else
				$this->Kode_MK->ViewValue = $this->Kode_MK->Lookup !== NULL && is_array($this->Kode_MK->Lookup->Options) ? $curVal : NULL;
			if ($this->Kode_MK->ViewValue !== NULL) { // Load from cache
				$this->Kode_MK->EditValue = array_values($this->Kode_MK->Lookup->Options);
				if ($this->Kode_MK->ViewValue == "")
					$this->Kode_MK->ViewValue = $Language->phrase("PleaseSelect");
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "[Kode_MK]" . SearchString("=", $this->Kode_MK->CurrentValue, DATATYPE_STRING, "");
				}
				$sqlWrk = $this->Kode_MK->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = [];
					$arwrk[1] = HtmlEncode($rswrk->fields('df'));
					$arwrk[2] = HtmlEncode($rswrk->fields('df2'));
					$arwrk[3] = HtmlEncode(FormatNumber($rswrk->fields('df3'), 0, -2, -2, -2));
					$this->Kode_MK->ViewValue = $this->Kode_MK->displayValue($arwrk);
				} else {
					$this->Kode_MK->ViewValue = $Language->phrase("PleaseSelect");
				}
				$arwrk = $rswrk ? $rswrk->getRows() : [];
				if ($rswrk)
					$rswrk->close();
				$rowcnt = count($arwrk);
				for ($i = 0; $i < $rowcnt; $i++) {
					$arwrk[$i][3] = FormatNumber($arwrk[$i][3], 0, -2, -2, -2);
				}
				$this->Kode_MK->EditValue = $arwrk;
			}

			// Kopentensi
			$this->Kopentensi->EditAttrs["class"] = "form-control";
			$this->Kopentensi->EditCustomAttributes = "";
			$this->Kopentensi->EditValue = HtmlEncode($this->Kopentensi->CurrentValue);
			$this->Kopentensi->PlaceHolder = RemoveHtml($this->Kopentensi->caption());

			// Penjelasan
			$this->Penjelasan->EditAttrs["class"] = "form-control";
			$this->Penjelasan->EditCustomAttributes = "";
			$this->Penjelasan->EditValue = HtmlEncode($this->Penjelasan->CurrentValue);
			$this->Penjelasan->PlaceHolder = RemoveHtml($this->Penjelasan->caption());

			// Prasyarat
			$this->Prasyarat->EditAttrs["class"] = "form-control";
			$this->Prasyarat->EditCustomAttributes = "";
			$this->Prasyarat->EditValue = HtmlEncode($this->Prasyarat->CurrentValue);
			$this->Prasyarat->PlaceHolder = RemoveHtml($this->Prasyarat->caption());

			// DaftarPustaka
			$this->DaftarPustaka->EditAttrs["class"] = "form-control";
			$this->DaftarPustaka->EditCustomAttributes = "";
			$this->DaftarPustaka->EditValue = HtmlEncode($this->DaftarPustaka->CurrentValue);
			$this->DaftarPustaka->PlaceHolder = RemoveHtml($this->DaftarPustaka->caption());

			// Add refer script
			// Kode_Fak

			$this->Kode_Fak->LinkCustomAttributes = "";
			$this->Kode_Fak->HrefValue = "";

			// Kode_MK
			$this->Kode_MK->LinkCustomAttributes = "";
			$this->Kode_MK->HrefValue = "";

			// Kopentensi
			$this->Kopentensi->LinkCustomAttributes = "";
			$this->Kopentensi->HrefValue = "";

			// Penjelasan
			$this->Penjelasan->LinkCustomAttributes = "";
			$this->Penjelasan->HrefValue = "";

			// Prasyarat
			$this->Prasyarat->LinkCustomAttributes = "";
			$this->Prasyarat->HrefValue = "";

			// DaftarPustaka
			$this->DaftarPustaka->LinkCustomAttributes = "";
			$this->DaftarPustaka->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType != ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!Config("SERVER_VALIDATE"))
			return ($FormError == "");
		if ($this->Kode_Fak->Required) {
			if (!$this->Kode_Fak->IsDetailKey && $this->Kode_Fak->FormValue != NULL && $this->Kode_Fak->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Kode_Fak->caption(), $this->Kode_Fak->RequiredErrorMessage));
			}
		}
		if ($this->Kode_MK->Required) {
			if (!$this->Kode_MK->IsDetailKey && $this->Kode_MK->FormValue != NULL && $this->Kode_MK->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Kode_MK->caption(), $this->Kode_MK->RequiredErrorMessage));
			}
		}
		if ($this->Kopentensi->Required) {
			if (!$this->Kopentensi->IsDetailKey && $this->Kopentensi->FormValue != NULL && $this->Kopentensi->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Kopentensi->caption(), $this->Kopentensi->RequiredErrorMessage));
			}
		}
		if ($this->Penjelasan->Required) {
			if (!$this->Penjelasan->IsDetailKey && $this->Penjelasan->FormValue != NULL && $this->Penjelasan->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Penjelasan->caption(), $this->Penjelasan->RequiredErrorMessage));
			}
		}
		if ($this->Prasyarat->Required) {
			if (!$this->Prasyarat->IsDetailKey && $this->Prasyarat->FormValue != NULL && $this->Prasyarat->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Prasyarat->caption(), $this->Prasyarat->RequiredErrorMessage));
			}
		}
		if ($this->DaftarPustaka->Required) {
			if (!$this->DaftarPustaka->IsDetailKey && $this->DaftarPustaka->FormValue != NULL && $this->DaftarPustaka->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->DaftarPustaka->caption(), $this->DaftarPustaka->RequiredErrorMessage));
			}
		}

		// Validate detail grid
		$detailTblVar = explode(",", $this->getCurrentDetailTable());
		if (in_array("tblSilabus", $detailTblVar) && $GLOBALS["tblSilabus"]->DetailAdd) {
			if (!isset($GLOBALS["tblSilabus_grid"]))
				$GLOBALS["tblSilabus_grid"] = new tblSilabus_grid(); // Get detail page object
			$GLOBALS["tblSilabus_grid"]->validateGridForm();
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError != "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Add record
	protected function addRow($rsold = NULL)
	{
		global $Language, $Security;
		$conn = $this->getConnection();

		// Begin transaction
		if ($this->getCurrentDetailTable() != "")
			$conn->beginTrans();

		// Load db values from rsold
		$this->loadDbValues($rsold);
		if ($rsold) {
		}
		$rsnew = [];

		// Kode_Fak
		$this->Kode_Fak->setDbValueDef($rsnew, $this->Kode_Fak->CurrentValue, "", FALSE);

		// Kode_MK
		$this->Kode_MK->setDbValueDef($rsnew, $this->Kode_MK->CurrentValue, "", FALSE);

		// Kopentensi
		$this->Kopentensi->setDbValueDef($rsnew, $this->Kopentensi->CurrentValue, NULL, FALSE);

		// Penjelasan
		$this->Penjelasan->setDbValueDef($rsnew, $this->Penjelasan->CurrentValue, NULL, FALSE);

		// Prasyarat
		$this->Prasyarat->setDbValueDef($rsnew, $this->Prasyarat->CurrentValue, NULL, FALSE);

		// DaftarPustaka
		$this->DaftarPustaka->setDbValueDef($rsnew, $this->DaftarPustaka->CurrentValue, NULL, FALSE);

		// Call Row Inserting event
		$rs = ($rsold) ? $rsold->fields : NULL;
		$insertRow = $this->Row_Inserting($rs, $rsnew);

		// Check if key value entered
		if ($insertRow && $this->ValidateKey && strval($rsnew['Kode_Fak']) == "") {
			$this->setFailureMessage($Language->phrase("InvalidKeyValue"));
			$insertRow = FALSE;
		}

		// Check if key value entered
		if ($insertRow && $this->ValidateKey && strval($rsnew['Kode_MK']) == "") {
			$this->setFailureMessage($Language->phrase("InvalidKeyValue"));
			$insertRow = FALSE;
		}

		// Check for duplicate key
		if ($insertRow && $this->ValidateKey) {
			$filter = $this->getRecordFilter($rsnew);
			$rsChk = $this->loadRs($filter);
			if ($rsChk && !$rsChk->EOF) {
				$keyErrMsg = str_replace("%f", $filter, $Language->phrase("DupKey"));
				$this->setFailureMessage($keyErrMsg);
				$rsChk->close();
				$insertRow = FALSE;
			}
		}
		if ($insertRow) {
			$conn->raiseErrorFn = Config("ERROR_FUNC");
			$addRow = $this->insert($rsnew);
			$conn->raiseErrorFn = "";
			if ($addRow) {
			}
		} else {
			if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage != "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->phrase("InsertCancelled"));
			}
			$addRow = FALSE;
		}

		// Add detail records
		if ($addRow) {
			$detailTblVar = explode(",", $this->getCurrentDetailTable());
			if (in_array("tblSilabus", $detailTblVar) && $GLOBALS["tblSilabus"]->DetailAdd) {
				$GLOBALS["tblSilabus"]->Kode_Fak->setSessionValue($this->Kode_Fak->CurrentValue); // Set master key
				$GLOBALS["tblSilabus"]->Kode_MK->setSessionValue($this->Kode_MK->CurrentValue); // Set master key
				if (!isset($GLOBALS["tblSilabus_grid"]))
					$GLOBALS["tblSilabus_grid"] = new tblSilabus_grid(); // Get detail page object
				$Security->loadCurrentUserLevel($this->ProjectID . "tblSilabus"); // Load user level of detail table
				$addRow = $GLOBALS["tblSilabus_grid"]->gridInsert();
				$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName); // Restore user level of master table
				if (!$addRow) {
					$GLOBALS["tblSilabus"]->Kode_Fak->setSessionValue(""); // Clear master key if insert failed
					$GLOBALS["tblSilabus"]->Kode_MK->setSessionValue(""); // Clear master key if insert failed
				}
			}
		}

		// Commit/Rollback transaction
		if ($this->getCurrentDetailTable() != "") {
			if ($addRow) {
				$conn->commitTrans(); // Commit transaction
			} else {
				$conn->rollbackTrans(); // Rollback transaction
			}
		}
		if ($addRow) {

			// Call Row Inserted event
			$rs = ($rsold) ? $rsold->fields : NULL;
			$this->Row_Inserted($rs, $rsnew);
		}

		// Clean upload path if any
		if ($addRow) {
		}

		// Write JSON for API request
		if (IsApi() && $addRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $addRow;
	}

	// Set up detail parms based on QueryString
	protected function setupDetailParms()
	{

		// Get the keys for master table
		$detailTblVar = Get(Config("TABLE_SHOW_DETAIL"));
		if ($detailTblVar !== NULL) {
			$this->setCurrentDetailTable($detailTblVar);
		} else {
			$detailTblVar = $this->getCurrentDetailTable();
		}
		if ($detailTblVar != "") {
			$detailTblVar = explode(",", $detailTblVar);
			if (in_array("tblSilabus", $detailTblVar)) {
				if (!isset($GLOBALS["tblSilabus_grid"]))
					$GLOBALS["tblSilabus_grid"] = new tblSilabus_grid();
				if ($GLOBALS["tblSilabus_grid"]->DetailAdd) {
					if ($this->CopyRecord)
						$GLOBALS["tblSilabus_grid"]->CurrentMode = "copy";
					else
						$GLOBALS["tblSilabus_grid"]->CurrentMode = "add";
					$GLOBALS["tblSilabus_grid"]->CurrentAction = "gridadd";

					// Save current master table to detail table
					$GLOBALS["tblSilabus_grid"]->setCurrentMasterTable($this->TableVar);
					$GLOBALS["tblSilabus_grid"]->setStartRecordNumber(1);
					$GLOBALS["tblSilabus_grid"]->Kode_Fak->IsDetailKey = TRUE;
					$GLOBALS["tblSilabus_grid"]->Kode_Fak->CurrentValue = $this->Kode_Fak->CurrentValue;
					$GLOBALS["tblSilabus_grid"]->Kode_Fak->setSessionValue($GLOBALS["tblSilabus_grid"]->Kode_Fak->CurrentValue);
					$GLOBALS["tblSilabus_grid"]->Kode_MK->IsDetailKey = TRUE;
					$GLOBALS["tblSilabus_grid"]->Kode_MK->CurrentValue = $this->Kode_MK->CurrentValue;
					$GLOBALS["tblSilabus_grid"]->Kode_MK->setSessionValue($GLOBALS["tblSilabus_grid"]->Kode_MK->CurrentValue);
				}
			}
		}
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("tblSilabusMasterlist.php"), "", $this->TableVar, TRUE);
		$pageId = ($this->isCopy()) ? "Copy" : "Add";
		$Breadcrumb->add("add", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// Get default connection and filter
			$conn = $this->getConnection();
			$lookupFilter = "";

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL and connection
			switch ($fld->FieldVar) {
				case "x_Kode_Fak":
					break;
				case "x_Kode_MK":
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0) {
				$totalCnt = $this->getRecordCount($sql, $conn);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_Kode_Fak":
							break;
						case "x_Kode_MK":
							$row[3] = FormatNumber($row[3], 0, -2, -2, -2);
							$row['df3'] = $row[3];
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
} // End class
?>