<?php
namespace PHPMaker2020\baak;

/**
 * Page class
 */
class tbljadwal_add extends tbljadwal
{

	// Page ID
	public $PageID = "add";

	// Project ID
	public $ProjectID = "{A09D3AFF-419C-4918-948A-A3C8469EA234}";

	// Table name
	public $TableName = 'tbljadwal';

	// Page object name
	public $PageObjName = "tbljadwal_add";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken;

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading != "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading != "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		$url = CurrentPageName() . "?";
		if ($this->UseTokenInUrl)
			$url .= "t=" . $this->TableVar . "&"; // Add page token
		return $url;
	}

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = TRUE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message != "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fas fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage != "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fas fa-exclamation"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage != "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fas fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage != "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fas fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = [];

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message != "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage != "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage != "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage != "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header != "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer != "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(Config("TOKEN_NAME")) === NULL)
			return FALSE;
		$fn = Config("CHECK_TOKEN_FUNC");
		if (is_callable($fn))
			return $fn(Post(Config("TOKEN_NAME")), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = Config("CREATE_TOKEN_FUNC"); // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $DashboardReport;
		global $UserTable;

		// Check token
		$this->CheckToken = Config("CHECK_TOKEN");

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (tbljadwal)
		if (!isset($GLOBALS["tbljadwal"]) || get_class($GLOBALS["tbljadwal"]) == PROJECT_NAMESPACE . "tbljadwal") {
			$GLOBALS["tbljadwal"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["tbljadwal"];
		}

		// Table object (Pass)
		if (!isset($GLOBALS['Pass']))
			$GLOBALS['Pass'] = new Pass();

		// Table object (tblMasterJadwal)
		if (!isset($GLOBALS['tblMasterJadwal']))
			$GLOBALS['tblMasterJadwal'] = new tblMasterJadwal();

		// Page ID (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'add');

		// Table name (for backward compatibility only)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'tbljadwal');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = $this->getConnection();

		// User table object (Pass)
		$UserTable = $UserTable ?: new Pass();
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages, $DashboardReport;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $tbljadwal;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, Config("EXPORT_CLASSES"))) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . Config("EXPORT_CLASSES." . $this->CustomExport);
			if (class_exists($class)) {
				$doc = new $class($tbljadwal);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url != "") {
			if (!Config("DEBUG") && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = ["url" => $url, "modal" => "1"];
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "tbljadwalview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = [];
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = [];
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {
								$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
									Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
									Config("API_FIELD_NAME") . "=" . $fld->Param . "&" .
									Config("API_KEY_NAME") . "=" . rawurlencode($this->getRecordKeyValue($ar)))); //*** need to add this? API may not be in the same folder
								$row[$fldname] = ["type" => ContentType($val), "url" => $url, "name" => $fld->Param . ContentExtension($val)];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, Config("MULTIPLE_UPLOAD_SEPARATOR"))) { // Single file
								$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
									Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
									"fn=" . Encrypt($fld->physicalUploadPath() . $val)));
								$row[$fldname] = ["type" => MimeContentType($val), "url" => $url, "name" => $val];
							} else { // Multiple files
								$files = explode(Config("MULTIPLE_UPLOAD_SEPARATOR"), $val);
								$ar = [];
								foreach ($files as $file) {
									$url = FullUrl(GetApiUrl(Config("API_FILE_ACTION"),
										Config("API_OBJECT_NAME") . "=" . $fld->TableVar . "&" .
										"fn=" . Encrypt($fld->physicalUploadPath() . $file)));
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => $url, "name" => $file];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['Thn_Akademik'] . Config("COMPOSITE_KEY_SEPARATOR");
			$key .= @$ar['Periode'] . Config("COMPOSITE_KEY_SEPARATOR");
			$key .= @$ar['Kelas_Akd'] . Config("COMPOSITE_KEY_SEPARATOR");
			$key .= @$ar['Jenis'] . Config("COMPOSITE_KEY_SEPARATOR");
			$key .= @$ar['Kode_Jp'] . Config("COMPOSITE_KEY_SEPARATOR");
			$key .= @$ar['Kode_Mk'] . Config("COMPOSITE_KEY_SEPARATOR");
			$key .= @$ar['Kelas'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
	}

	// Lookup data
	public function lookup()
	{
		global $Language, $Security;
		if (!isset($Language))
			$Language = new Language(Config("LANGUAGE_FOLDER"), Post("language", ""));

		// Set up API request
		if (!ValidApiRequest())
			return FALSE;
		$this->setupApiSecurity();

		// Get lookup object
		$fieldName = Post("field");
		if (!array_key_exists($fieldName, $this->fields))
			return FALSE;
		$lookupField = $this->fields[$fieldName];
		$lookup = $lookupField->Lookup;
		if ($lookup === NULL)
			return FALSE;
		$tbl = $lookup->getTable();
		if (!$Security->allowLookup(Config("PROJECT_ID") . $tbl->TableName)) // Lookup permission
			return FALSE;

		// Get lookup parameters
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Param("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = Config("AUTO_SUGGEST_MAX_ENTRIES");
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(Config("MULTIPLE_OPTION_SEPARATOR"), $keys);
			$lookup->FilterFields = []; // Skip parent fields if any
			$lookup->FilterValues[] = $keys; // Lookup values
			$pageSize = -1; // Show all records
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($lookup->FilterFields) ? count($lookup->FilterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect != "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter != "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy != "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson($this); // Use settings from current page
	}

	// Set up API security
	public function setupApiSecurity()
	{
		global $Security;

		// Setup security for API request
		if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
		$Security->loadCurrentUserLevel(Config("PROJECT_ID") . $this->TableName);
		if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
	}
	public $FormClassName = "ew-horizontal ew-form ew-add-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $DbMasterFilter = "";
	public $DbDetailFilter = "";
	public $StartRecord;
	public $Priv = 0;
	public $OldRecordset;
	public $CopyRecord;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		if (ValidApiRequest()) { // API request
			$this->setupApiSecurity(); // Set up API Security
			if (!$Security->canAdd()) {
				SetStatus(401); // Unauthorized
				return;
			}
		} else {
			$Security = new AdvancedSecurity();
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canAdd()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("tbljadwallist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->Thn_Akademik->Visible = FALSE;
		$this->Periode->Visible = FALSE;
		$this->Kelas_Akd->Visible = FALSE;
		$this->Jenis->Visible = FALSE;
		$this->Kode_Jp->setVisibility();
		$this->Kode_Fak->Visible = FALSE;
		$this->Kode_Mk->setVisibility();
		$this->Kelas->setVisibility();
		$this->Hari->Visible = FALSE;
		$this->Hari1->Visible = FALSE;
		$this->JM->Visible = FALSE;
		$this->JS->Visible = FALSE;
		$this->Kode_Ruangan->Visible = FALSE;
		$this->NIDN->setVisibility();
		$this->NIDN1->setVisibility();
		$this->NIDN2->Visible = FALSE;
		$this->Tanggal->Visible = FALSE;
		$this->Rdosen->Visible = FALSE;
		$this->Rsiswa->Visible = FALSE;
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->Kode_Jp);
		$this->setupLookupOptions($this->Kode_Mk);
		$this->setupLookupOptions($this->NIDN);
		$this->setupLookupOptions($this->NIDN1);

		// Check permission
		if (!$Security->canAdd()) {
			$this->setFailureMessage(DeniedMessage()); // No permission
			$this->terminate("tbljadwallist.php");
			return;
		}

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-add-form ew-horizontal";
		$postBack = FALSE;

		// Set up current action
		if (IsApi()) {
			$this->CurrentAction = "insert"; // Add record directly
			$postBack = TRUE;
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action"); // Get form action
			$postBack = TRUE;
		} else { // Not post back

			// Load key values from QueryString
			$this->CopyRecord = TRUE;
			if (Get("Thn_Akademik") !== NULL) {
				$this->Thn_Akademik->setQueryStringValue(Get("Thn_Akademik"));
				$this->setKey("Thn_Akademik", $this->Thn_Akademik->CurrentValue); // Set up key
			} else {
				$this->setKey("Thn_Akademik", ""); // Clear key
				$this->CopyRecord = FALSE;
			}
			if (Get("Periode") !== NULL) {
				$this->Periode->setQueryStringValue(Get("Periode"));
				$this->setKey("Periode", $this->Periode->CurrentValue); // Set up key
			} else {
				$this->setKey("Periode", ""); // Clear key
				$this->CopyRecord = FALSE;
			}
			if (Get("Kelas_Akd") !== NULL) {
				$this->Kelas_Akd->setQueryStringValue(Get("Kelas_Akd"));
				$this->setKey("Kelas_Akd", $this->Kelas_Akd->CurrentValue); // Set up key
			} else {
				$this->setKey("Kelas_Akd", ""); // Clear key
				$this->CopyRecord = FALSE;
			}
			if (Get("Jenis") !== NULL) {
				$this->Jenis->setQueryStringValue(Get("Jenis"));
				$this->setKey("Jenis", $this->Jenis->CurrentValue); // Set up key
			} else {
				$this->setKey("Jenis", ""); // Clear key
				$this->CopyRecord = FALSE;
			}
			if (Get("Kode_Jp") !== NULL) {
				$this->Kode_Jp->setQueryStringValue(Get("Kode_Jp"));
				$this->setKey("Kode_Jp", $this->Kode_Jp->CurrentValue); // Set up key
			} else {
				$this->setKey("Kode_Jp", ""); // Clear key
				$this->CopyRecord = FALSE;
			}
			if (Get("Kode_Mk") !== NULL) {
				$this->Kode_Mk->setQueryStringValue(Get("Kode_Mk"));
				$this->setKey("Kode_Mk", $this->Kode_Mk->CurrentValue); // Set up key
			} else {
				$this->setKey("Kode_Mk", ""); // Clear key
				$this->CopyRecord = FALSE;
			}
			if (Get("Kelas") !== NULL) {
				$this->Kelas->setQueryStringValue(Get("Kelas"));
				$this->setKey("Kelas", $this->Kelas->CurrentValue); // Set up key
			} else {
				$this->setKey("Kelas", ""); // Clear key
				$this->CopyRecord = FALSE;
			}
			if ($this->CopyRecord) {
				$this->CurrentAction = "copy"; // Copy record
			} else {
				$this->CurrentAction = "show"; // Display blank record
			}
		}

		// Load old record / default values
		$loaded = $this->loadOldRecord();

		// Set up master/detail parameters
		// NOTE: must be after loadOldRecord to prevent master key values overwritten

		$this->setupMasterParms();

		// Load form values
		if ($postBack) {
			$this->loadFormValues(); // Load form values
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->validateForm()) {
				$this->EventCancelled = TRUE; // Event cancelled
				$this->restoreFormValues(); // Restore form values
				$this->setFailureMessage($FormError);
				if (IsApi()) {
					$this->terminate();
					return;
				} else {
					$this->CurrentAction = "show"; // Form error, reset action
				}
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "copy": // Copy an existing record
				if (!$loaded) { // Record not loaded
					if ($this->getFailureMessage() == "")
						$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
					$this->terminate("tbljadwallist.php"); // No matching record, return to list
				}
				break;
			case "insert": // Add new record
				$this->SendEmail = TRUE; // Send email on add success
				if ($this->addRow($this->OldRecordset)) { // Add successful
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
					$returnUrl = $this->getReturnUrl();
					if (GetPageName($returnUrl) == "tbljadwallist.php")
						$returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
					elseif (GetPageName($returnUrl) == "tbljadwalview.php")
						$returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
					if (IsApi()) { // Return to caller
						$this->terminate(TRUE);
						return;
					} else {
						$this->terminate($returnUrl);
					}
				} elseif (IsApi()) { // API request, return
					$this->terminate();
					return;
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->restoreFormValues(); // Add failed, restore form values
				}
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Render row based on row type
		$this->RowType = ROWTYPE_ADD; // Render add type

		// Render row
		$this->resetAttributes();
		$this->renderRow();
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
	}

	// Load default values
	protected function loadDefaultValues()
	{
		$this->Thn_Akademik->CurrentValue = NULL;
		$this->Thn_Akademik->OldValue = $this->Thn_Akademik->CurrentValue;
		$this->Periode->CurrentValue = NULL;
		$this->Periode->OldValue = $this->Periode->CurrentValue;
		$this->Kelas_Akd->CurrentValue = NULL;
		$this->Kelas_Akd->OldValue = $this->Kelas_Akd->CurrentValue;
		$this->Jenis->CurrentValue = "Jadwal Kuliah";
		$this->Kode_Jp->CurrentValue = NULL;
		$this->Kode_Jp->OldValue = $this->Kode_Jp->CurrentValue;
		$this->Kode_Fak->CurrentValue = NULL;
		$this->Kode_Fak->OldValue = $this->Kode_Fak->CurrentValue;
		$this->Kode_Mk->CurrentValue = NULL;
		$this->Kode_Mk->OldValue = $this->Kode_Mk->CurrentValue;
		$this->Kelas->CurrentValue = NULL;
		$this->Kelas->OldValue = $this->Kelas->CurrentValue;
		$this->Hari->CurrentValue = NULL;
		$this->Hari->OldValue = $this->Hari->CurrentValue;
		$this->Hari1->CurrentValue = NULL;
		$this->Hari1->OldValue = $this->Hari1->CurrentValue;
		$this->JM->CurrentValue = NULL;
		$this->JM->OldValue = $this->JM->CurrentValue;
		$this->JS->CurrentValue = NULL;
		$this->JS->OldValue = $this->JS->CurrentValue;
		$this->Kode_Ruangan->CurrentValue = NULL;
		$this->Kode_Ruangan->OldValue = $this->Kode_Ruangan->CurrentValue;
		$this->NIDN->CurrentValue = NULL;
		$this->NIDN->OldValue = $this->NIDN->CurrentValue;
		$this->NIDN1->CurrentValue = NULL;
		$this->NIDN1->OldValue = $this->NIDN1->CurrentValue;
		$this->NIDN2->CurrentValue = NULL;
		$this->NIDN2->OldValue = $this->NIDN2->CurrentValue;
		$this->Tanggal->CurrentValue = NULL;
		$this->Tanggal->OldValue = $this->Tanggal->CurrentValue;
		$this->Rdosen->CurrentValue = NULL;
		$this->Rdosen->OldValue = $this->Rdosen->CurrentValue;
		$this->Rsiswa->CurrentValue = NULL;
		$this->Rsiswa->OldValue = $this->Rsiswa->CurrentValue;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;

		// Check field name 'Kode_Jp' first before field var 'x_Kode_Jp'
		$val = $CurrentForm->hasValue("Kode_Jp") ? $CurrentForm->getValue("Kode_Jp") : $CurrentForm->getValue("x_Kode_Jp");
		if (!$this->Kode_Jp->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->Kode_Jp->Visible = FALSE; // Disable update for API request
			else
				$this->Kode_Jp->setFormValue($val);
		}

		// Check field name 'Kode_Mk' first before field var 'x_Kode_Mk'
		$val = $CurrentForm->hasValue("Kode_Mk") ? $CurrentForm->getValue("Kode_Mk") : $CurrentForm->getValue("x_Kode_Mk");
		if (!$this->Kode_Mk->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->Kode_Mk->Visible = FALSE; // Disable update for API request
			else
				$this->Kode_Mk->setFormValue($val);
		}

		// Check field name 'Kelas' first before field var 'x_Kelas'
		$val = $CurrentForm->hasValue("Kelas") ? $CurrentForm->getValue("Kelas") : $CurrentForm->getValue("x_Kelas");
		if (!$this->Kelas->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->Kelas->Visible = FALSE; // Disable update for API request
			else
				$this->Kelas->setFormValue($val);
		}

		// Check field name 'NIDN' first before field var 'x_NIDN'
		$val = $CurrentForm->hasValue("NIDN") ? $CurrentForm->getValue("NIDN") : $CurrentForm->getValue("x_NIDN");
		if (!$this->NIDN->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->NIDN->Visible = FALSE; // Disable update for API request
			else
				$this->NIDN->setFormValue($val);
		}

		// Check field name 'NIDN1' first before field var 'x_NIDN1'
		$val = $CurrentForm->hasValue("NIDN1") ? $CurrentForm->getValue("NIDN1") : $CurrentForm->getValue("x_NIDN1");
		if (!$this->NIDN1->IsDetailKey) {
			if (IsApi() && $val === NULL)
				$this->NIDN1->Visible = FALSE; // Disable update for API request
			else
				$this->NIDN1->setFormValue($val);
		}

		// Check field name 'Thn_Akademik' first before field var 'x_Thn_Akademik'
		$val = $CurrentForm->hasValue("Thn_Akademik") ? $CurrentForm->getValue("Thn_Akademik") : $CurrentForm->getValue("x_Thn_Akademik");
		if (!$this->Thn_Akademik->IsDetailKey)
			$this->Thn_Akademik->setFormValue($val);

		// Check field name 'Periode' first before field var 'x_Periode'
		$val = $CurrentForm->hasValue("Periode") ? $CurrentForm->getValue("Periode") : $CurrentForm->getValue("x_Periode");
		if (!$this->Periode->IsDetailKey)
			$this->Periode->setFormValue($val);

		// Check field name 'Kelas_Akd' first before field var 'x_Kelas_Akd'
		$val = $CurrentForm->hasValue("Kelas_Akd") ? $CurrentForm->getValue("Kelas_Akd") : $CurrentForm->getValue("x_Kelas_Akd");
		if (!$this->Kelas_Akd->IsDetailKey)
			$this->Kelas_Akd->setFormValue($val);

		// Check field name 'Jenis' first before field var 'x_Jenis'
		$val = $CurrentForm->hasValue("Jenis") ? $CurrentForm->getValue("Jenis") : $CurrentForm->getValue("x_Jenis");
		if (!$this->Jenis->IsDetailKey)
			$this->Jenis->setFormValue($val);
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->Thn_Akademik->CurrentValue = $this->Thn_Akademik->FormValue;
		$this->Periode->CurrentValue = $this->Periode->FormValue;
		$this->Kelas_Akd->CurrentValue = $this->Kelas_Akd->FormValue;
		$this->Jenis->CurrentValue = $this->Jenis->FormValue;
		$this->Kode_Jp->CurrentValue = $this->Kode_Jp->FormValue;
		$this->Kode_Mk->CurrentValue = $this->Kode_Mk->FormValue;
		$this->Kelas->CurrentValue = $this->Kelas->FormValue;
		$this->NIDN->CurrentValue = $this->NIDN->FormValue;
		$this->NIDN1->CurrentValue = $this->NIDN1->FormValue;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = $this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->Thn_Akademik->setDbValue($row['Thn_Akademik']);
		$this->Periode->setDbValue($row['Periode']);
		$this->Kelas_Akd->setDbValue($row['Kelas_Akd']);
		$this->Jenis->setDbValue($row['Jenis']);
		$this->Kode_Jp->setDbValue($row['Kode_Jp']);
		$this->Kode_Fak->setDbValue($row['Kode_Fak']);
		$this->Kode_Mk->setDbValue($row['Kode_Mk']);
		if (array_key_exists('EV__Kode_Mk', $rs->fields)) {
			$this->Kode_Mk->VirtualValue = $rs->fields('EV__Kode_Mk'); // Set up virtual field value
		} else {
			$this->Kode_Mk->VirtualValue = ""; // Clear value
		}
		$this->Kelas->setDbValue($row['Kelas']);
		$this->Hari->setDbValue($row['Hari']);
		$this->Hari1->setDbValue($row['Hari1']);
		$this->JM->setDbValue($row['JM']);
		$this->JS->setDbValue($row['JS']);
		$this->Kode_Ruangan->setDbValue($row['Kode_Ruangan']);
		$this->NIDN->setDbValue($row['NIDN']);
		if (array_key_exists('EV__NIDN', $rs->fields)) {
			$this->NIDN->VirtualValue = $rs->fields('EV__NIDN'); // Set up virtual field value
		} else {
			$this->NIDN->VirtualValue = ""; // Clear value
		}
		$this->NIDN1->setDbValue($row['NIDN1']);
		if (array_key_exists('EV__NIDN1', $rs->fields)) {
			$this->NIDN1->VirtualValue = $rs->fields('EV__NIDN1'); // Set up virtual field value
		} else {
			$this->NIDN1->VirtualValue = ""; // Clear value
		}
		$this->NIDN2->setDbValue($row['NIDN2']);
		$this->Tanggal->setDbValue($row['Tanggal']);
		$this->Rdosen->setDbValue($row['Rdosen']);
		$this->Rsiswa->setDbValue($row['Rsiswa']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$this->loadDefaultValues();
		$row = [];
		$row['Thn_Akademik'] = $this->Thn_Akademik->CurrentValue;
		$row['Periode'] = $this->Periode->CurrentValue;
		$row['Kelas_Akd'] = $this->Kelas_Akd->CurrentValue;
		$row['Jenis'] = $this->Jenis->CurrentValue;
		$row['Kode_Jp'] = $this->Kode_Jp->CurrentValue;
		$row['Kode_Fak'] = $this->Kode_Fak->CurrentValue;
		$row['Kode_Mk'] = $this->Kode_Mk->CurrentValue;
		$row['Kelas'] = $this->Kelas->CurrentValue;
		$row['Hari'] = $this->Hari->CurrentValue;
		$row['Hari1'] = $this->Hari1->CurrentValue;
		$row['JM'] = $this->JM->CurrentValue;
		$row['JS'] = $this->JS->CurrentValue;
		$row['Kode_Ruangan'] = $this->Kode_Ruangan->CurrentValue;
		$row['NIDN'] = $this->NIDN->CurrentValue;
		$row['NIDN1'] = $this->NIDN1->CurrentValue;
		$row['NIDN2'] = $this->NIDN2->CurrentValue;
		$row['Tanggal'] = $this->Tanggal->CurrentValue;
		$row['Rdosen'] = $this->Rdosen->CurrentValue;
		$row['Rsiswa'] = $this->Rsiswa->CurrentValue;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("Thn_Akademik")) != "")
			$this->Thn_Akademik->OldValue = $this->getKey("Thn_Akademik"); // Thn_Akademik
		else
			$validKey = FALSE;
		if (strval($this->getKey("Periode")) != "")
			$this->Periode->OldValue = $this->getKey("Periode"); // Periode
		else
			$validKey = FALSE;
		if (strval($this->getKey("Kelas_Akd")) != "")
			$this->Kelas_Akd->OldValue = $this->getKey("Kelas_Akd"); // Kelas_Akd
		else
			$validKey = FALSE;
		if (strval($this->getKey("Jenis")) != "")
			$this->Jenis->OldValue = $this->getKey("Jenis"); // Jenis
		else
			$validKey = FALSE;
		if (strval($this->getKey("Kode_Jp")) != "")
			$this->Kode_Jp->OldValue = $this->getKey("Kode_Jp"); // Kode_Jp
		else
			$validKey = FALSE;
		if (strval($this->getKey("Kode_Mk")) != "")
			$this->Kode_Mk->OldValue = $this->getKey("Kode_Mk"); // Kode_Mk
		else
			$validKey = FALSE;
		if (strval($this->getKey("Kelas")) != "")
			$this->Kelas->OldValue = $this->getKey("Kelas"); // Kelas
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = $this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Call Row_Rendering event

		$this->Row_Rendering();

		// Common render codes for all row types
		// Thn_Akademik
		// Periode
		// Kelas_Akd
		// Jenis
		// Kode_Jp
		// Kode_Fak
		// Kode_Mk
		// Kelas
		// Hari
		// Hari1
		// JM
		// JS
		// Kode_Ruangan
		// NIDN
		// NIDN1
		// NIDN2
		// Tanggal
		// Rdosen
		// Rsiswa

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// Thn_Akademik
			$this->Thn_Akademik->ViewValue = $this->Thn_Akademik->CurrentValue;
			$this->Thn_Akademik->ViewCustomAttributes = "";

			// Periode
			$this->Periode->ViewValue = $this->Periode->CurrentValue;
			$this->Periode->ViewCustomAttributes = "";

			// Kelas_Akd
			$this->Kelas_Akd->ViewValue = $this->Kelas_Akd->CurrentValue;
			$this->Kelas_Akd->ViewCustomAttributes = "";

			// Jenis
			$this->Jenis->ViewValue = $this->Jenis->CurrentValue;
			$this->Jenis->ViewCustomAttributes = "";

			// Kode_Jp
			$curVal = strval($this->Kode_Jp->CurrentValue);
			if ($curVal != "") {
				$this->Kode_Jp->ViewValue = $this->Kode_Jp->lookupCacheOption($curVal);
				if ($this->Kode_Jp->ViewValue === NULL) { // Lookup from database
					$filterWrk = "[Kode_Jp]" . SearchString("=", $curVal, DATATYPE_STRING, "");
					$sqlWrk = $this->Kode_Jp->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = [];
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->Kode_Jp->ViewValue = $this->Kode_Jp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->Kode_Jp->ViewValue = $this->Kode_Jp->CurrentValue;
					}
				}
			} else {
				$this->Kode_Jp->ViewValue = NULL;
			}
			$this->Kode_Jp->ViewCustomAttributes = "";

			// Kode_Fak
			$this->Kode_Fak->ViewValue = $this->Kode_Fak->CurrentValue;
			$this->Kode_Fak->ViewCustomAttributes = "";

			// Kode_Mk
			if ($this->Kode_Mk->VirtualValue != "") {
				$this->Kode_Mk->ViewValue = $this->Kode_Mk->VirtualValue;
			} else {
				$curVal = strval($this->Kode_Mk->CurrentValue);
				if ($curVal != "") {
					$this->Kode_Mk->ViewValue = $this->Kode_Mk->lookupCacheOption($curVal);
					if ($this->Kode_Mk->ViewValue === NULL) { // Lookup from database
						$filterWrk = "[Kode_MK]" . SearchString("=", $curVal, DATATYPE_STRING, "");
						$sqlWrk = $this->Kode_Mk->Lookup->getSql(FALSE, $filterWrk, '', $this);
						$rswrk = Conn()->execute($sqlWrk);
						if ($rswrk && !$rswrk->EOF) { // Lookup values found
							$arwrk = [];
							$arwrk[1] = $rswrk->fields('df');
							$arwrk[2] = $rswrk->fields('df2');
							$arwrk[3] = FormatNumber($rswrk->fields('df3'), 0, -2, -2, -2);
							$this->Kode_Mk->ViewValue = $this->Kode_Mk->displayValue($arwrk);
							$rswrk->Close();
						} else {
							$this->Kode_Mk->ViewValue = $this->Kode_Mk->CurrentValue;
						}
					}
				} else {
					$this->Kode_Mk->ViewValue = NULL;
				}
			}
			$this->Kode_Mk->ViewCustomAttributes = "";

			// Kelas
			if (strval($this->Kelas->CurrentValue) != "") {
				$this->Kelas->ViewValue = $this->Kelas->optionCaption($this->Kelas->CurrentValue);
			} else {
				$this->Kelas->ViewValue = NULL;
			}
			$this->Kelas->ViewCustomAttributes = "";

			// Hari
			$this->Hari->ViewValue = $this->Hari->CurrentValue;
			$this->Hari->ViewCustomAttributes = "";

			// Hari1
			$this->Hari1->ViewValue = $this->Hari1->CurrentValue;
			$this->Hari1->ViewCustomAttributes = "";

			// JM
			$this->JM->ViewValue = $this->JM->CurrentValue;
			$this->JM->ViewValue = FormatDateTime($this->JM->ViewValue, 0);
			$this->JM->ViewCustomAttributes = "";

			// JS
			$this->JS->ViewValue = $this->JS->CurrentValue;
			$this->JS->ViewValue = FormatDateTime($this->JS->ViewValue, 0);
			$this->JS->ViewCustomAttributes = "";

			// Kode_Ruangan
			$this->Kode_Ruangan->ViewValue = $this->Kode_Ruangan->CurrentValue;
			$this->Kode_Ruangan->ViewCustomAttributes = "";

			// NIDN
			if ($this->NIDN->VirtualValue != "") {
				$this->NIDN->ViewValue = $this->NIDN->VirtualValue;
			} else {
				$curVal = strval($this->NIDN->CurrentValue);
				if ($curVal != "") {
					$this->NIDN->ViewValue = $this->NIDN->lookupCacheOption($curVal);
					if ($this->NIDN->ViewValue === NULL) { // Lookup from database
						$filterWrk = "[NIDN]" . SearchString("=", $curVal, DATATYPE_STRING, "");
						$sqlWrk = $this->NIDN->Lookup->getSql(FALSE, $filterWrk, '', $this);
						$rswrk = Conn()->execute($sqlWrk);
						if ($rswrk && !$rswrk->EOF) { // Lookup values found
							$arwrk = [];
							$arwrk[1] = $rswrk->fields('df');
							$arwrk[2] = $rswrk->fields('df2');
							$this->NIDN->ViewValue = $this->NIDN->displayValue($arwrk);
							$rswrk->Close();
						} else {
							$this->NIDN->ViewValue = $this->NIDN->CurrentValue;
						}
					}
				} else {
					$this->NIDN->ViewValue = NULL;
				}
			}
			$this->NIDN->ViewCustomAttributes = "";

			// NIDN1
			if ($this->NIDN1->VirtualValue != "") {
				$this->NIDN1->ViewValue = $this->NIDN1->VirtualValue;
			} else {
				$curVal = strval($this->NIDN1->CurrentValue);
				if ($curVal != "") {
					$this->NIDN1->ViewValue = $this->NIDN1->lookupCacheOption($curVal);
					if ($this->NIDN1->ViewValue === NULL) { // Lookup from database
						$filterWrk = "[NIDN]" . SearchString("=", $curVal, DATATYPE_STRING, "");
						$sqlWrk = $this->NIDN1->Lookup->getSql(FALSE, $filterWrk, '', $this);
						$rswrk = Conn()->execute($sqlWrk);
						if ($rswrk && !$rswrk->EOF) { // Lookup values found
							$arwrk = [];
							$arwrk[1] = $rswrk->fields('df');
							$arwrk[2] = $rswrk->fields('df2');
							$this->NIDN1->ViewValue = $this->NIDN1->displayValue($arwrk);
							$rswrk->Close();
						} else {
							$this->NIDN1->ViewValue = $this->NIDN1->CurrentValue;
						}
					}
				} else {
					$this->NIDN1->ViewValue = NULL;
				}
			}
			$this->NIDN1->ViewCustomAttributes = "";

			// NIDN2
			$this->NIDN2->ViewValue = $this->NIDN2->CurrentValue;
			$this->NIDN2->ViewCustomAttributes = "";

			// Tanggal
			$this->Tanggal->ViewValue = $this->Tanggal->CurrentValue;
			$this->Tanggal->ViewValue = FormatDateTime($this->Tanggal->ViewValue, 0);
			$this->Tanggal->ViewCustomAttributes = "";

			// Rdosen
			$this->Rdosen->ViewValue = $this->Rdosen->CurrentValue;
			$this->Rdosen->ViewValue = FormatNumber($this->Rdosen->ViewValue, 2, -2, -2, -2);
			$this->Rdosen->ViewCustomAttributes = "";

			// Rsiswa
			$this->Rsiswa->ViewValue = $this->Rsiswa->CurrentValue;
			$this->Rsiswa->ViewValue = FormatNumber($this->Rsiswa->ViewValue, 2, -2, -2, -2);
			$this->Rsiswa->ViewCustomAttributes = "";

			// Kode_Jp
			$this->Kode_Jp->LinkCustomAttributes = "";
			$this->Kode_Jp->HrefValue = "";
			$this->Kode_Jp->TooltipValue = "";

			// Kode_Mk
			$this->Kode_Mk->LinkCustomAttributes = "";
			$this->Kode_Mk->HrefValue = "";
			$this->Kode_Mk->TooltipValue = "";

			// Kelas
			$this->Kelas->LinkCustomAttributes = "";
			$this->Kelas->HrefValue = "";
			$this->Kelas->TooltipValue = "";

			// NIDN
			$this->NIDN->LinkCustomAttributes = "";
			$this->NIDN->HrefValue = "";
			$this->NIDN->TooltipValue = "";

			// NIDN1
			$this->NIDN1->LinkCustomAttributes = "";
			$this->NIDN1->HrefValue = "";
			$this->NIDN1->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_ADD) { // Add row

			// Kode_Jp
			$this->Kode_Jp->EditAttrs["class"] = "form-control";
			$this->Kode_Jp->EditCustomAttributes = "";
			$curVal = trim(strval($this->Kode_Jp->CurrentValue));
			if ($curVal != "")
				$this->Kode_Jp->ViewValue = $this->Kode_Jp->lookupCacheOption($curVal);
			else
				$this->Kode_Jp->ViewValue = $this->Kode_Jp->Lookup !== NULL && is_array($this->Kode_Jp->Lookup->Options) ? $curVal : NULL;
			if ($this->Kode_Jp->ViewValue !== NULL) { // Load from cache
				$this->Kode_Jp->EditValue = array_values($this->Kode_Jp->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "[Kode_Jp]" . SearchString("=", $this->Kode_Jp->CurrentValue, DATATYPE_STRING, "");
				}
				$sqlWrk = $this->Kode_Jp->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = $rswrk ? $rswrk->getRows() : [];
				if ($rswrk)
					$rswrk->close();
				$this->Kode_Jp->EditValue = $arwrk;
			}

			// Kode_Mk
			$this->Kode_Mk->EditCustomAttributes = "";
			$curVal = trim(strval($this->Kode_Mk->CurrentValue));
			if ($curVal != "")
				$this->Kode_Mk->ViewValue = $this->Kode_Mk->lookupCacheOption($curVal);
			else
				$this->Kode_Mk->ViewValue = $this->Kode_Mk->Lookup !== NULL && is_array($this->Kode_Mk->Lookup->Options) ? $curVal : NULL;
			if ($this->Kode_Mk->ViewValue !== NULL) { // Load from cache
				$this->Kode_Mk->EditValue = array_values($this->Kode_Mk->Lookup->Options);
				if ($this->Kode_Mk->ViewValue == "")
					$this->Kode_Mk->ViewValue = $Language->phrase("PleaseSelect");
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "[Kode_MK]" . SearchString("=", $this->Kode_Mk->CurrentValue, DATATYPE_STRING, "");
				}
				$sqlWrk = $this->Kode_Mk->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = [];
					$arwrk[1] = HtmlEncode($rswrk->fields('df'));
					$arwrk[2] = HtmlEncode($rswrk->fields('df2'));
					$arwrk[3] = HtmlEncode(FormatNumber($rswrk->fields('df3'), 0, -2, -2, -2));
					$this->Kode_Mk->ViewValue = $this->Kode_Mk->displayValue($arwrk);
				} else {
					$this->Kode_Mk->ViewValue = $Language->phrase("PleaseSelect");
				}
				$arwrk = $rswrk ? $rswrk->getRows() : [];
				if ($rswrk)
					$rswrk->close();
				$rowcnt = count($arwrk);
				for ($i = 0; $i < $rowcnt; $i++) {
					$arwrk[$i][3] = FormatNumber($arwrk[$i][3], 0, -2, -2, -2);
				}
				$this->Kode_Mk->EditValue = $arwrk;
			}

			// Kelas
			$this->Kelas->EditAttrs["class"] = "form-control";
			$this->Kelas->EditCustomAttributes = "";
			$this->Kelas->EditValue = $this->Kelas->options(TRUE);

			// NIDN
			$this->NIDN->EditCustomAttributes = "";
			$curVal = trim(strval($this->NIDN->CurrentValue));
			if ($curVal != "")
				$this->NIDN->ViewValue = $this->NIDN->lookupCacheOption($curVal);
			else
				$this->NIDN->ViewValue = $this->NIDN->Lookup !== NULL && is_array($this->NIDN->Lookup->Options) ? $curVal : NULL;
			if ($this->NIDN->ViewValue !== NULL) { // Load from cache
				$this->NIDN->EditValue = array_values($this->NIDN->Lookup->Options);
				if ($this->NIDN->ViewValue == "")
					$this->NIDN->ViewValue = $Language->phrase("PleaseSelect");
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "[NIDN]" . SearchString("=", $this->NIDN->CurrentValue, DATATYPE_STRING, "");
				}
				$sqlWrk = $this->NIDN->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = [];
					$arwrk[1] = HtmlEncode($rswrk->fields('df'));
					$arwrk[2] = HtmlEncode($rswrk->fields('df2'));
					$this->NIDN->ViewValue = $this->NIDN->displayValue($arwrk);
				} else {
					$this->NIDN->ViewValue = $Language->phrase("PleaseSelect");
				}
				$arwrk = $rswrk ? $rswrk->getRows() : [];
				if ($rswrk)
					$rswrk->close();
				$this->NIDN->EditValue = $arwrk;
			}

			// NIDN1
			$this->NIDN1->EditCustomAttributes = "";
			$curVal = trim(strval($this->NIDN1->CurrentValue));
			if ($curVal != "")
				$this->NIDN1->ViewValue = $this->NIDN1->lookupCacheOption($curVal);
			else
				$this->NIDN1->ViewValue = $this->NIDN1->Lookup !== NULL && is_array($this->NIDN1->Lookup->Options) ? $curVal : NULL;
			if ($this->NIDN1->ViewValue !== NULL) { // Load from cache
				$this->NIDN1->EditValue = array_values($this->NIDN1->Lookup->Options);
				if ($this->NIDN1->ViewValue == "")
					$this->NIDN1->ViewValue = $Language->phrase("PleaseSelect");
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "[NIDN]" . SearchString("=", $this->NIDN1->CurrentValue, DATATYPE_STRING, "");
				}
				$sqlWrk = $this->NIDN1->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = [];
					$arwrk[1] = HtmlEncode($rswrk->fields('df'));
					$arwrk[2] = HtmlEncode($rswrk->fields('df2'));
					$this->NIDN1->ViewValue = $this->NIDN1->displayValue($arwrk);
				} else {
					$this->NIDN1->ViewValue = $Language->phrase("PleaseSelect");
				}
				$arwrk = $rswrk ? $rswrk->getRows() : [];
				if ($rswrk)
					$rswrk->close();
				$this->NIDN1->EditValue = $arwrk;
			}

			// Add refer script
			// Kode_Jp

			$this->Kode_Jp->LinkCustomAttributes = "";
			$this->Kode_Jp->HrefValue = "";

			// Kode_Mk
			$this->Kode_Mk->LinkCustomAttributes = "";
			$this->Kode_Mk->HrefValue = "";

			// Kelas
			$this->Kelas->LinkCustomAttributes = "";
			$this->Kelas->HrefValue = "";

			// NIDN
			$this->NIDN->LinkCustomAttributes = "";
			$this->NIDN->HrefValue = "";

			// NIDN1
			$this->NIDN1->LinkCustomAttributes = "";
			$this->NIDN1->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType != ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!Config("SERVER_VALIDATE"))
			return ($FormError == "");
		if ($this->Kode_Jp->Required) {
			if (!$this->Kode_Jp->IsDetailKey && $this->Kode_Jp->FormValue != NULL && $this->Kode_Jp->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Kode_Jp->caption(), $this->Kode_Jp->RequiredErrorMessage));
			}
		}
		if ($this->Kode_Mk->Required) {
			if (!$this->Kode_Mk->IsDetailKey && $this->Kode_Mk->FormValue != NULL && $this->Kode_Mk->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Kode_Mk->caption(), $this->Kode_Mk->RequiredErrorMessage));
			}
		}
		if ($this->Kelas->Required) {
			if (!$this->Kelas->IsDetailKey && $this->Kelas->FormValue != NULL && $this->Kelas->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Kelas->caption(), $this->Kelas->RequiredErrorMessage));
			}
		}
		if ($this->NIDN->Required) {
			if (!$this->NIDN->IsDetailKey && $this->NIDN->FormValue != NULL && $this->NIDN->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->NIDN->caption(), $this->NIDN->RequiredErrorMessage));
			}
		}
		if ($this->NIDN1->Required) {
			if (!$this->NIDN1->IsDetailKey && $this->NIDN1->FormValue != NULL && $this->NIDN1->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->NIDN1->caption(), $this->NIDN1->RequiredErrorMessage));
			}
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError != "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Add record
	protected function addRow($rsold = NULL)
	{
		global $Language, $Security;
		$conn = $this->getConnection();

		// Load db values from rsold
		$this->loadDbValues($rsold);
		if ($rsold) {
		}
		$rsnew = [];

		// Kode_Jp
		$this->Kode_Jp->setDbValueDef($rsnew, $this->Kode_Jp->CurrentValue, "", FALSE);

		// Kode_Mk
		$this->Kode_Mk->setDbValueDef($rsnew, $this->Kode_Mk->CurrentValue, "", FALSE);

		// Kelas
		$this->Kelas->setDbValueDef($rsnew, $this->Kelas->CurrentValue, "", FALSE);

		// NIDN
		$this->NIDN->setDbValueDef($rsnew, $this->NIDN->CurrentValue, NULL, FALSE);

		// NIDN1
		$this->NIDN1->setDbValueDef($rsnew, $this->NIDN1->CurrentValue, NULL, FALSE);

		// Thn_Akademik
		if ($this->Thn_Akademik->getSessionValue() != "") {
			$rsnew['Thn_Akademik'] = $this->Thn_Akademik->getSessionValue();
		}

		// Periode
		if ($this->Periode->getSessionValue() != "") {
			$rsnew['Periode'] = $this->Periode->getSessionValue();
		}

		// Kelas_Akd
		if ($this->Kelas_Akd->getSessionValue() != "") {
			$rsnew['Kelas_Akd'] = $this->Kelas_Akd->getSessionValue();
		}

		// Kode_Fak
		if ($this->Kode_Fak->getSessionValue() != "") {
			$rsnew['Kode_Fak'] = $this->Kode_Fak->getSessionValue();
		}

		// Call Row Inserting event
		$rs = ($rsold) ? $rsold->fields : NULL;
		$insertRow = $this->Row_Inserting($rs, $rsnew);

		// Check if key value entered
		if ($insertRow && $this->ValidateKey && strval($rsnew['Thn_Akademik']) == "") {
			$this->setFailureMessage($Language->phrase("InvalidKeyValue"));
			$insertRow = FALSE;
		}

		// Check if key value entered
		if ($insertRow && $this->ValidateKey && strval($rsnew['Periode']) == "") {
			$this->setFailureMessage($Language->phrase("InvalidKeyValue"));
			$insertRow = FALSE;
		}

		// Check if key value entered
		if ($insertRow && $this->ValidateKey && strval($rsnew['Kelas_Akd']) == "") {
			$this->setFailureMessage($Language->phrase("InvalidKeyValue"));
			$insertRow = FALSE;
		}

		// Check if key value entered
		if ($insertRow && $this->ValidateKey && strval($rsnew['Jenis']) == "") {
			$this->setFailureMessage($Language->phrase("InvalidKeyValue"));
			$insertRow = FALSE;
		}

		// Check if key value entered
		if ($insertRow && $this->ValidateKey && strval($rsnew['Kode_Jp']) == "") {
			$this->setFailureMessage($Language->phrase("InvalidKeyValue"));
			$insertRow = FALSE;
		}

		// Check if key value entered
		if ($insertRow && $this->ValidateKey && strval($rsnew['Kode_Mk']) == "") {
			$this->setFailureMessage($Language->phrase("InvalidKeyValue"));
			$insertRow = FALSE;
		}

		// Check if key value entered
		if ($insertRow && $this->ValidateKey && strval($rsnew['Kelas']) == "") {
			$this->setFailureMessage($Language->phrase("InvalidKeyValue"));
			$insertRow = FALSE;
		}

		// Check for duplicate key
		if ($insertRow && $this->ValidateKey) {
			$filter = $this->getRecordFilter($rsnew);
			$rsChk = $this->loadRs($filter);
			if ($rsChk && !$rsChk->EOF) {
				$keyErrMsg = str_replace("%f", $filter, $Language->phrase("DupKey"));
				$this->setFailureMessage($keyErrMsg);
				$rsChk->close();
				$insertRow = FALSE;
			}
		}
		if ($insertRow) {
			$conn->raiseErrorFn = Config("ERROR_FUNC");
			$addRow = $this->insert($rsnew);
			$conn->raiseErrorFn = "";
			if ($addRow) {
			}
		} else {
			if ($this->getSuccessMessage() != "" || $this->getFailureMessage() != "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage != "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->phrase("InsertCancelled"));
			}
			$addRow = FALSE;
		}
		if ($addRow) {

			// Call Row Inserted event
			$rs = ($rsold) ? $rsold->fields : NULL;
			$this->Row_Inserted($rs, $rsnew);
		}

		// Clean upload path if any
		if ($addRow) {
		}

		// Write JSON for API request
		if (IsApi() && $addRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $addRow;
	}

	// Set up master/detail based on QueryString
	protected function setupMasterParms()
	{
		$validMaster = FALSE;

		// Get the keys for master table
		if (($master = Get(Config("TABLE_SHOW_MASTER"), Get(Config("TABLE_MASTER")))) !== NULL) {
			$masterTblVar = $master;
			if ($masterTblVar == "") {
				$validMaster = TRUE;
				$this->DbMasterFilter = "";
				$this->DbDetailFilter = "";
			}
			if ($masterTblVar == "tblMasterJadwal") {
				$validMaster = TRUE;
				if (($parm = Get("fk_Thn_Akademik", Get("Thn_Akademik"))) !== NULL) {
					$GLOBALS["tblMasterJadwal"]->Thn_Akademik->setQueryStringValue($parm);
					$this->Thn_Akademik->setQueryStringValue($GLOBALS["tblMasterJadwal"]->Thn_Akademik->QueryStringValue);
					$this->Thn_Akademik->setSessionValue($this->Thn_Akademik->QueryStringValue);
				} else {
					$validMaster = FALSE;
				}
				if (($parm = Get("fk_Periode", Get("Periode"))) !== NULL) {
					$GLOBALS["tblMasterJadwal"]->Periode->setQueryStringValue($parm);
					$this->Periode->setQueryStringValue($GLOBALS["tblMasterJadwal"]->Periode->QueryStringValue);
					$this->Periode->setSessionValue($this->Periode->QueryStringValue);
				} else {
					$validMaster = FALSE;
				}
				if (($parm = Get("fk_Kelas_Akd", Get("Kelas_Akd"))) !== NULL) {
					$GLOBALS["tblMasterJadwal"]->Kelas_Akd->setQueryStringValue($parm);
					$this->Kelas_Akd->setQueryStringValue($GLOBALS["tblMasterJadwal"]->Kelas_Akd->QueryStringValue);
					$this->Kelas_Akd->setSessionValue($this->Kelas_Akd->QueryStringValue);
				} else {
					$validMaster = FALSE;
				}
				if (($parm = Get("fk_Kode_Fak", Get("Kode_Fak"))) !== NULL) {
					$GLOBALS["tblMasterJadwal"]->Kode_Fak->setQueryStringValue($parm);
					$this->Kode_Fak->setQueryStringValue($GLOBALS["tblMasterJadwal"]->Kode_Fak->QueryStringValue);
					$this->Kode_Fak->setSessionValue($this->Kode_Fak->QueryStringValue);
				} else {
					$validMaster = FALSE;
				}
			}
		} elseif (($master = Post(Config("TABLE_SHOW_MASTER"), Post(Config("TABLE_MASTER")))) !== NULL) {
			$masterTblVar = $master;
			if ($masterTblVar == "") {
				$validMaster = TRUE;
				$this->DbMasterFilter = "";
				$this->DbDetailFilter = "";
			}
			if ($masterTblVar == "tblMasterJadwal") {
				$validMaster = TRUE;
				if (($parm = Post("fk_Thn_Akademik", Post("Thn_Akademik"))) !== NULL) {
					$GLOBALS["tblMasterJadwal"]->Thn_Akademik->setFormValue($parm);
					$this->Thn_Akademik->setFormValue($GLOBALS["tblMasterJadwal"]->Thn_Akademik->FormValue);
					$this->Thn_Akademik->setSessionValue($this->Thn_Akademik->FormValue);
				} else {
					$validMaster = FALSE;
				}
				if (($parm = Post("fk_Periode", Post("Periode"))) !== NULL) {
					$GLOBALS["tblMasterJadwal"]->Periode->setFormValue($parm);
					$this->Periode->setFormValue($GLOBALS["tblMasterJadwal"]->Periode->FormValue);
					$this->Periode->setSessionValue($this->Periode->FormValue);
				} else {
					$validMaster = FALSE;
				}
				if (($parm = Post("fk_Kelas_Akd", Post("Kelas_Akd"))) !== NULL) {
					$GLOBALS["tblMasterJadwal"]->Kelas_Akd->setFormValue($parm);
					$this->Kelas_Akd->setFormValue($GLOBALS["tblMasterJadwal"]->Kelas_Akd->FormValue);
					$this->Kelas_Akd->setSessionValue($this->Kelas_Akd->FormValue);
				} else {
					$validMaster = FALSE;
				}
				if (($parm = Post("fk_Kode_Fak", Post("Kode_Fak"))) !== NULL) {
					$GLOBALS["tblMasterJadwal"]->Kode_Fak->setFormValue($parm);
					$this->Kode_Fak->setFormValue($GLOBALS["tblMasterJadwal"]->Kode_Fak->FormValue);
					$this->Kode_Fak->setSessionValue($this->Kode_Fak->FormValue);
				} else {
					$validMaster = FALSE;
				}
			}
		}
		if ($validMaster) {

			// Save current master table
			$this->setCurrentMasterTable($masterTblVar);

			// Reset start record counter (new master key)
			if (!$this->isAddOrEdit()) {
				$this->StartRecord = 1;
				$this->setStartRecordNumber($this->StartRecord);
			}

			// Clear previous master key from Session
			if ($masterTblVar != "tblMasterJadwal") {
				if ($this->Thn_Akademik->CurrentValue == "")
					$this->Thn_Akademik->setSessionValue("");
				if ($this->Periode->CurrentValue == "")
					$this->Periode->setSessionValue("");
				if ($this->Kelas_Akd->CurrentValue == "")
					$this->Kelas_Akd->setSessionValue("");
				if ($this->Kode_Fak->CurrentValue == "")
					$this->Kode_Fak->setSessionValue("");
			}
		}
		$this->DbMasterFilter = $this->getMasterFilter(); // Get master filter
		$this->DbDetailFilter = $this->getDetailFilter(); // Get detail filter
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("tbljadwallist.php"), "", $this->TableVar, TRUE);
		$pageId = ($this->isCopy()) ? "Copy" : "Add";
		$Breadcrumb->add("add", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// Get default connection and filter
			$conn = $this->getConnection();
			$lookupFilter = "";

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL and connection
			switch ($fld->FieldVar) {
				case "x_Kode_Jp":
					break;
				case "x_Kode_Mk":
					break;
				case "x_Kelas":
					break;
				case "x_NIDN":
					break;
				case "x_NIDN1":
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql != "" && count($fld->Lookup->Options) == 0) {
				$totalCnt = $this->getRecordCount($sql, $conn);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_Kode_Jp":
							break;
						case "x_Kode_Mk":
							$row[3] = FormatNumber($row[3], 0, -2, -2, -2);
							$row['df3'] = $row[3];
							break;
						case "x_NIDN":
							break;
						case "x_NIDN1":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
} // End class
?>