<?php namespace PHPMaker2020\baak; ?>
<?php

/**
 * Table class for v_tblnilai
 */
class v_tblnilai extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $Nim;
	public $Nama_Mhs;
	public $Kode_jp;
	public $Status_Akd;
	public $Thn_Akademik;
	public $Periode;
	public $Kode_MK;
	public $kls;
	public $Kehadiran;
	public $Tugas;
	public $UTS;
	public $UAS;
	public $Jumlah;
	public $Nilai;
	public $Angka;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;
		parent::__construct();

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'v_tblnilai';
		$this->TableName = 'v_tblnilai';
		$this->TableType = 'VIEW';

		// Update Table
		$this->UpdateTable = "[dbo].[v_tblnilai]";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = Config("DEFAULT_USER_ID_ALLOW_SECURITY"); // Default User ID allowed permissions
		$this->BasicSearch = new BasicSearch($this->TableVar);

		// Nim
		$this->Nim = new DbField('v_tblnilai', 'v_tblnilai', 'x_Nim', 'Nim', '[Nim]', '[Nim]', 129, 14, -1, FALSE, '[Nim]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Nim->IsPrimaryKey = TRUE; // Primary key field
		$this->Nim->Nullable = FALSE; // NOT NULL field
		$this->Nim->Required = TRUE; // Required field
		$this->Nim->Sortable = TRUE; // Allow sort
		$this->fields['Nim'] = &$this->Nim;

		// Nama_Mhs
		$this->Nama_Mhs = new DbField('v_tblnilai', 'v_tblnilai', 'x_Nama_Mhs', 'Nama_Mhs', '[Nama_Mhs]', '[Nama_Mhs]', 129, 60, -1, FALSE, '[Nama_Mhs]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Nama_Mhs->Sortable = TRUE; // Allow sort
		$this->fields['Nama_Mhs'] = &$this->Nama_Mhs;

		// Kode_jp
		$this->Kode_jp = new DbField('v_tblnilai', 'v_tblnilai', 'x_Kode_jp', 'Kode_jp', '[Kode_jp]', '[Kode_jp]', 129, 4, -1, FALSE, '[Kode_jp]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Kode_jp->Sortable = TRUE; // Allow sort
		$this->fields['Kode_jp'] = &$this->Kode_jp;

		// Status_Akd
		$this->Status_Akd = new DbField('v_tblnilai', 'v_tblnilai', 'x_Status_Akd', 'Status_Akd', '[Status_Akd]', '[Status_Akd]', 200, 15, -1, FALSE, '[Status_Akd]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Status_Akd->IsForeignKey = TRUE; // Foreign key field
		$this->Status_Akd->Sortable = TRUE; // Allow sort
		$this->fields['Status_Akd'] = &$this->Status_Akd;

		// Thn_Akademik
		$this->Thn_Akademik = new DbField('v_tblnilai', 'v_tblnilai', 'x_Thn_Akademik', 'Thn_Akademik', '[Thn_Akademik]', '[Thn_Akademik]', 129, 12, -1, FALSE, '[Thn_Akademik]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Thn_Akademik->IsPrimaryKey = TRUE; // Primary key field
		$this->Thn_Akademik->IsForeignKey = TRUE; // Foreign key field
		$this->Thn_Akademik->Nullable = FALSE; // NOT NULL field
		$this->Thn_Akademik->Required = TRUE; // Required field
		$this->Thn_Akademik->Sortable = TRUE; // Allow sort
		$this->fields['Thn_Akademik'] = &$this->Thn_Akademik;

		// Periode
		$this->Periode = new DbField('v_tblnilai', 'v_tblnilai', 'x_Periode', 'Periode', '[Periode]', '[Periode]', 129, 3, -1, FALSE, '[Periode]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Periode->IsPrimaryKey = TRUE; // Primary key field
		$this->Periode->IsForeignKey = TRUE; // Foreign key field
		$this->Periode->Nullable = FALSE; // NOT NULL field
		$this->Periode->Required = TRUE; // Required field
		$this->Periode->Sortable = TRUE; // Allow sort
		$this->fields['Periode'] = &$this->Periode;

		// Kode_MK
		$this->Kode_MK = new DbField('v_tblnilai', 'v_tblnilai', 'x_Kode_MK', 'Kode_MK', '[Kode_MK]', '[Kode_MK]', 129, 14, -1, FALSE, '[Kode_MK]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Kode_MK->IsPrimaryKey = TRUE; // Primary key field
		$this->Kode_MK->IsForeignKey = TRUE; // Foreign key field
		$this->Kode_MK->Nullable = FALSE; // NOT NULL field
		$this->Kode_MK->Required = TRUE; // Required field
		$this->Kode_MK->Sortable = TRUE; // Allow sort
		$this->fields['Kode_MK'] = &$this->Kode_MK;

		// kls
		$this->kls = new DbField('v_tblnilai', 'v_tblnilai', 'x_kls', 'kls', '[kls]', '[kls]', 200, 4, -1, FALSE, '[kls]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->kls->IsForeignKey = TRUE; // Foreign key field
		$this->kls->Sortable = TRUE; // Allow sort
		$this->fields['kls'] = &$this->kls;

		// Kehadiran
		$this->Kehadiran = new DbField('v_tblnilai', 'v_tblnilai', 'x_Kehadiran', 'Kehadiran', '[Kehadiran]', 'CAST([Kehadiran] AS NVARCHAR)', 5, 8, -1, FALSE, '[Kehadiran]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Kehadiran->Sortable = TRUE; // Allow sort
		$this->Kehadiran->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['Kehadiran'] = &$this->Kehadiran;

		// Tugas
		$this->Tugas = new DbField('v_tblnilai', 'v_tblnilai', 'x_Tugas', 'Tugas', '[Tugas]', 'CAST([Tugas] AS NVARCHAR)', 5, 8, -1, FALSE, '[Tugas]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Tugas->Sortable = TRUE; // Allow sort
		$this->Tugas->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['Tugas'] = &$this->Tugas;

		// UTS
		$this->UTS = new DbField('v_tblnilai', 'v_tblnilai', 'x_UTS', 'UTS', '[UTS]', 'CAST([UTS] AS NVARCHAR)', 5, 8, -1, FALSE, '[UTS]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->UTS->Sortable = TRUE; // Allow sort
		$this->UTS->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['UTS'] = &$this->UTS;

		// UAS
		$this->UAS = new DbField('v_tblnilai', 'v_tblnilai', 'x_UAS', 'UAS', '[UAS]', 'CAST([UAS] AS NVARCHAR)', 5, 8, -1, FALSE, '[UAS]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->UAS->Sortable = TRUE; // Allow sort
		$this->UAS->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['UAS'] = &$this->UAS;

		// Jumlah
		$this->Jumlah = new DbField('v_tblnilai', 'v_tblnilai', 'x_Jumlah', 'Jumlah', '[Jumlah]', 'CAST([Jumlah] AS NVARCHAR)', 5, 8, -1, FALSE, '[Jumlah]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Jumlah->Sortable = TRUE; // Allow sort
		$this->Jumlah->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['Jumlah'] = &$this->Jumlah;

		// Nilai
		$this->Nilai = new DbField('v_tblnilai', 'v_tblnilai', 'x_Nilai', 'Nilai', '[Nilai]', '[Nilai]', 129, 2, -1, FALSE, '[Nilai]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Nilai->Sortable = TRUE; // Allow sort
		$this->fields['Nilai'] = &$this->Nilai;

		// Angka
		$this->Angka = new DbField('v_tblnilai', 'v_tblnilai', 'x_Angka', 'Angka', '[Angka]', 'CAST([Angka] AS NVARCHAR)', 5, 8, -1, FALSE, '[Angka]', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Angka->Sortable = TRUE; // Allow sort
		$this->Angka->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['Angka'] = &$this->Angka;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Single column sort
	public function updateSort(&$fld)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
		} else {
			$fld->setSort("");
		}
	}

	// Current master table name
	public function getCurrentMasterTable()
	{
		return @$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_MASTER_TABLE")];
	}
	public function setCurrentMasterTable($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_MASTER_TABLE")] = $v;
	}

	// Session master WHERE clause
	public function getMasterFilter()
	{

		// Master filter
		$masterFilter = "";
		if ($this->getCurrentMasterTable() == "v_jadwal") {
			if ($this->Thn_Akademik->getSessionValue() != "")
				$masterFilter .= "[Thn_Akademik]=" . QuotedValue($this->Thn_Akademik->getSessionValue(), DATATYPE_STRING, "DB");
			else
				return "";
			if ($this->Periode->getSessionValue() != "")
				$masterFilter .= " AND [Periode]=" . QuotedValue($this->Periode->getSessionValue(), DATATYPE_STRING, "DB");
			else
				return "";
			if ($this->Status_Akd->getSessionValue() != "")
				$masterFilter .= " AND [Kelas_Akd]=" . QuotedValue($this->Status_Akd->getSessionValue(), DATATYPE_STRING, "DB");
			else
				return "";
			if ($this->Kode_MK->getSessionValue() != "")
				$masterFilter .= " AND [Kode_Mk]=" . QuotedValue($this->Kode_MK->getSessionValue(), DATATYPE_STRING, "DB");
			else
				return "";
			if ($this->kls->getSessionValue() != "")
				$masterFilter .= " AND [Kelas]=" . QuotedValue($this->kls->getSessionValue(), DATATYPE_STRING, "DB");
			else
				return "";
		}
		return $masterFilter;
	}

	// Session detail WHERE clause
	public function getDetailFilter()
	{

		// Detail filter
		$detailFilter = "";
		if ($this->getCurrentMasterTable() == "v_jadwal") {
			if ($this->Thn_Akademik->getSessionValue() != "")
				$detailFilter .= "[Thn_Akademik]=" . QuotedValue($this->Thn_Akademik->getSessionValue(), DATATYPE_STRING, "DB");
			else
				return "";
			if ($this->Periode->getSessionValue() != "")
				$detailFilter .= " AND [Periode]=" . QuotedValue($this->Periode->getSessionValue(), DATATYPE_STRING, "DB");
			else
				return "";
			if ($this->Status_Akd->getSessionValue() != "")
				$detailFilter .= " AND [Status_Akd]=" . QuotedValue($this->Status_Akd->getSessionValue(), DATATYPE_STRING, "DB");
			else
				return "";
			if ($this->Kode_MK->getSessionValue() != "")
				$detailFilter .= " AND [Kode_MK]=" . QuotedValue($this->Kode_MK->getSessionValue(), DATATYPE_STRING, "DB");
			else
				return "";
			if ($this->kls->getSessionValue() != "")
				$detailFilter .= " AND [kls]=" . QuotedValue($this->kls->getSessionValue(), DATATYPE_STRING, "DB");
			else
				return "";
		}
		return $detailFilter;
	}

	// Master filter
	public function sqlMasterFilter_v_jadwal()
	{
		return "[Thn_Akademik]='@Thn_Akademik@' AND [Periode]='@Periode@' AND [Kelas_Akd]='@Kelas_Akd@' AND [Kode_Mk]='@Kode_Mk@' AND [Kelas]='@Kelas@'";
	}

	// Detail filter
	public function sqlDetailFilter_v_jadwal()
	{
		return "[Thn_Akademik]='@Thn_Akademik@' AND [Periode]='@Periode@' AND [Status_Akd]='@Status_Akd@' AND [Kode_MK]='@Kode_MK@' AND [kls]='@kls@'";
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom != "") ? $this->SqlFrom : "[dbo].[v_tblnilai]";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect != "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere != "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy != "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving != "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy != "") ? $this->SqlOrderBy : "";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter, $id = "")
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = $this->UserIDAllowSecurity;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 32) == 32);
			case "search":
				return (($allow & 64) == 64);
			case "lookup":
				return (($allow & 256) == 256);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get recordset
	public function getRecordset($sql, $rowcnt = -1, $offset = -1)
	{
		$conn = $this->getConnection();
		$conn->raiseErrorFn = Config("ERROR_FUNC");
		$rs = $conn->selectLimit($sql, $rowcnt, $offset);
		$conn->raiseErrorFn = "";
		return $rs;
	}

	// Get record count
	public function getRecordCount($sql, $c = NULL)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery / SELECT DISTINCT / ORDER BY
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) &&
			!preg_match('/^\s*select\s+distinct\s+/i', $sql) && !preg_match('/\s+order\s+by\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = $c ?: $this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->getSqlSelect();
		$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " (" . $names . ") VALUES (" . $values . ")";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = $this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsAutoIncrement)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter != "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = $this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('Nim', $rs))
				AddFilter($where, QuotedName('Nim', $this->Dbid) . '=' . QuotedValue($rs['Nim'], $this->Nim->DataType, $this->Dbid));
			if (array_key_exists('Thn_Akademik', $rs))
				AddFilter($where, QuotedName('Thn_Akademik', $this->Dbid) . '=' . QuotedValue($rs['Thn_Akademik'], $this->Thn_Akademik->DataType, $this->Dbid));
			if (array_key_exists('Periode', $rs))
				AddFilter($where, QuotedName('Periode', $this->Dbid) . '=' . QuotedValue($rs['Periode'], $this->Periode->DataType, $this->Dbid));
			if (array_key_exists('Kode_MK', $rs))
				AddFilter($where, QuotedName('Kode_MK', $this->Dbid) . '=' . QuotedValue($rs['Kode_MK'], $this->Kode_MK->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter != "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = $this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->Nim->DbValue = $row['Nim'];
		$this->Nama_Mhs->DbValue = $row['Nama_Mhs'];
		$this->Kode_jp->DbValue = $row['Kode_jp'];
		$this->Status_Akd->DbValue = $row['Status_Akd'];
		$this->Thn_Akademik->DbValue = $row['Thn_Akademik'];
		$this->Periode->DbValue = $row['Periode'];
		$this->Kode_MK->DbValue = $row['Kode_MK'];
		$this->kls->DbValue = $row['kls'];
		$this->Kehadiran->DbValue = $row['Kehadiran'];
		$this->Tugas->DbValue = $row['Tugas'];
		$this->UTS->DbValue = $row['UTS'];
		$this->UAS->DbValue = $row['UAS'];
		$this->Jumlah->DbValue = $row['Jumlah'];
		$this->Nilai->DbValue = $row['Nilai'];
		$this->Angka->DbValue = $row['Angka'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "[Nim] = '@Nim@' AND [Thn_Akademik] = '@Thn_Akademik@' AND [Periode] = '@Periode@' AND [Kode_MK] = '@Kode_MK@'";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		if (is_array($row))
			$val = array_key_exists('Nim', $row) ? $row['Nim'] : NULL;
		else
			$val = $this->Nim->OldValue !== NULL ? $this->Nim->OldValue : $this->Nim->CurrentValue;
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@Nim@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		if (is_array($row))
			$val = array_key_exists('Thn_Akademik', $row) ? $row['Thn_Akademik'] : NULL;
		else
			$val = $this->Thn_Akademik->OldValue !== NULL ? $this->Thn_Akademik->OldValue : $this->Thn_Akademik->CurrentValue;
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@Thn_Akademik@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		if (is_array($row))
			$val = array_key_exists('Periode', $row) ? $row['Periode'] : NULL;
		else
			$val = $this->Periode->OldValue !== NULL ? $this->Periode->OldValue : $this->Periode->CurrentValue;
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@Periode@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		if (is_array($row))
			$val = array_key_exists('Kode_MK', $row) ? $row['Kode_MK'] : NULL;
		else
			$val = $this->Kode_MK->OldValue !== NULL ? $this->Kode_MK->OldValue : $this->Kode_MK->CurrentValue;
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@Kode_MK@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL");

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") != "" && ReferPageName() != CurrentPageName() && ReferPageName() != "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] != "") {
			return $_SESSION[$name];
		} else {
			return "v_tblnilailist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . Config("TABLE_RETURN_URL")] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "v_tblnilaiview.php")
			return $Language->phrase("View");
		elseif ($pageName == "v_tblnilaiedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "v_tblnilaiadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "v_tblnilailist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm != "")
			$url = $this->keyUrl("v_tblnilaiview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("v_tblnilaiview.php", $this->getUrlParm(Config("TABLE_SHOW_DETAIL") . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm != "")
			$url = "v_tblnilaiadd.php?" . $this->getUrlParm($parm);
		else
			$url = "v_tblnilaiadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("v_tblnilaiedit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("v_tblnilaiadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("v_tblnilaidelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		if ($this->getCurrentMasterTable() == "v_jadwal" && !ContainsString($url, Config("TABLE_SHOW_MASTER") . "=")) {
			$url .= (ContainsString($url, "?") ? "&" : "?") . Config("TABLE_SHOW_MASTER") . "=" . $this->getCurrentMasterTable();
			$url .= "&fk_Thn_Akademik=" . urlencode($this->Thn_Akademik->CurrentValue);
			$url .= "&fk_Periode=" . urlencode($this->Periode->CurrentValue);
			$url .= "&fk_Kelas_Akd=" . urlencode($this->Status_Akd->CurrentValue);
			$url .= "&fk_Kode_Mk=" . urlencode($this->Kode_MK->CurrentValue);
			$url .= "&fk_Kelas=" . urlencode($this->kls->CurrentValue);
		}
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "Nim:" . JsonEncode($this->Nim->CurrentValue, "string");
		$json .= ",Thn_Akademik:" . JsonEncode($this->Thn_Akademik->CurrentValue, "string");
		$json .= ",Periode:" . JsonEncode($this->Periode->CurrentValue, "string");
		$json .= ",Kode_MK:" . JsonEncode($this->Kode_MK->CurrentValue, "string");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm != "")
			$url .= $parm . "&";
		if ($this->Nim->CurrentValue != NULL) {
			$url .= "Nim=" . urlencode($this->Nim->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		if ($this->Thn_Akademik->CurrentValue != NULL) {
			$url .= "&Thn_Akademik=" . urlencode($this->Thn_Akademik->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		if ($this->Periode->CurrentValue != NULL) {
			$url .= "&Periode=" . urlencode($this->Periode->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		if ($this->Kode_MK->CurrentValue != NULL) {
			$url .= "&Kode_MK=" . urlencode($this->Kode_MK->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, [141, 201, 203, 128, 204, 205])) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		$arKeys = [];
		$arKey = [];
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
			for ($i = 0; $i < $cnt; $i++)
				$arKeys[$i] = explode(Config("COMPOSITE_KEY_SEPARATOR"), $arKeys[$i]);
		} else {
			if (Param("Nim") !== NULL)
				$arKey[] = Param("Nim");
			elseif (IsApi() && Key(0) !== NULL)
				$arKey[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKey[] = Route(2);
			else
				$arKeys = NULL; // Do not setup
			if (Param("Thn_Akademik") !== NULL)
				$arKey[] = Param("Thn_Akademik");
			elseif (IsApi() && Key(1) !== NULL)
				$arKey[] = Key(1);
			elseif (IsApi() && Route(3) !== NULL)
				$arKey[] = Route(3);
			else
				$arKeys = NULL; // Do not setup
			if (Param("Periode") !== NULL)
				$arKey[] = Param("Periode");
			elseif (IsApi() && Key(2) !== NULL)
				$arKey[] = Key(2);
			elseif (IsApi() && Route(4) !== NULL)
				$arKey[] = Route(4);
			else
				$arKeys = NULL; // Do not setup
			if (Param("Kode_MK") !== NULL)
				$arKey[] = Param("Kode_MK");
			elseif (IsApi() && Key(3) !== NULL)
				$arKey[] = Key(3);
			elseif (IsApi() && Route(5) !== NULL)
				$arKey[] = Route(5);
			else
				$arKeys = NULL; // Do not setup
			if (is_array($arKeys)) $arKeys[] = $arKey;

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = [];
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_array($key) || count($key) != 4)
					continue; // Just skip so other keys will still work
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys($setCurrent = TRUE)
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter != "") $keyFilter .= " OR ";
			if ($setCurrent)
				$this->Nim->CurrentValue = $key[0];
			else
				$this->Nim->OldValue = $key[0];
			if ($setCurrent)
				$this->Thn_Akademik->CurrentValue = $key[1];
			else
				$this->Thn_Akademik->OldValue = $key[1];
			if ($setCurrent)
				$this->Periode->CurrentValue = $key[2];
			else
				$this->Periode->OldValue = $key[2];
			if ($setCurrent)
				$this->Kode_MK->CurrentValue = $key[3];
			else
				$this->Kode_MK->OldValue = $key[3];
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = $this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->Nim->setDbValue($rs->fields('Nim'));
		$this->Nama_Mhs->setDbValue($rs->fields('Nama_Mhs'));
		$this->Kode_jp->setDbValue($rs->fields('Kode_jp'));
		$this->Status_Akd->setDbValue($rs->fields('Status_Akd'));
		$this->Thn_Akademik->setDbValue($rs->fields('Thn_Akademik'));
		$this->Periode->setDbValue($rs->fields('Periode'));
		$this->Kode_MK->setDbValue($rs->fields('Kode_MK'));
		$this->kls->setDbValue($rs->fields('kls'));
		$this->Kehadiran->setDbValue($rs->fields('Kehadiran'));
		$this->Tugas->setDbValue($rs->fields('Tugas'));
		$this->UTS->setDbValue($rs->fields('UTS'));
		$this->UAS->setDbValue($rs->fields('UAS'));
		$this->Jumlah->setDbValue($rs->fields('Jumlah'));
		$this->Nilai->setDbValue($rs->fields('Nilai'));
		$this->Angka->setDbValue($rs->fields('Angka'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// Nim
		// Nama_Mhs
		// Kode_jp
		// Status_Akd
		// Thn_Akademik
		// Periode
		// Kode_MK
		// kls
		// Kehadiran
		// Tugas
		// UTS
		// UAS
		// Jumlah
		// Nilai
		// Angka
		// Nim

		$this->Nim->ViewValue = $this->Nim->CurrentValue;
		$this->Nim->ViewCustomAttributes = "";

		// Nama_Mhs
		$this->Nama_Mhs->ViewValue = $this->Nama_Mhs->CurrentValue;
		$this->Nama_Mhs->ViewCustomAttributes = "";

		// Kode_jp
		$this->Kode_jp->ViewValue = $this->Kode_jp->CurrentValue;
		$this->Kode_jp->ViewCustomAttributes = "";

		// Status_Akd
		$this->Status_Akd->ViewValue = $this->Status_Akd->CurrentValue;
		$this->Status_Akd->ViewCustomAttributes = "";

		// Thn_Akademik
		$this->Thn_Akademik->ViewValue = $this->Thn_Akademik->CurrentValue;
		$this->Thn_Akademik->ViewCustomAttributes = "";

		// Periode
		$this->Periode->ViewValue = $this->Periode->CurrentValue;
		$this->Periode->ViewCustomAttributes = "";

		// Kode_MK
		$this->Kode_MK->ViewValue = $this->Kode_MK->CurrentValue;
		$this->Kode_MK->ViewCustomAttributes = "";

		// kls
		$this->kls->ViewValue = $this->kls->CurrentValue;
		$this->kls->ViewCustomAttributes = "";

		// Kehadiran
		$this->Kehadiran->ViewValue = $this->Kehadiran->CurrentValue;
		$this->Kehadiran->ViewValue = FormatNumber($this->Kehadiran->ViewValue, 2, -2, -2, -2);
		$this->Kehadiran->ViewCustomAttributes = "";

		// Tugas
		$this->Tugas->ViewValue = $this->Tugas->CurrentValue;
		$this->Tugas->ViewValue = FormatNumber($this->Tugas->ViewValue, 2, -2, -2, -2);
		$this->Tugas->ViewCustomAttributes = "";

		// UTS
		$this->UTS->ViewValue = $this->UTS->CurrentValue;
		$this->UTS->ViewValue = FormatNumber($this->UTS->ViewValue, 2, -2, -2, -2);
		$this->UTS->ViewCustomAttributes = "";

		// UAS
		$this->UAS->ViewValue = $this->UAS->CurrentValue;
		$this->UAS->ViewValue = FormatNumber($this->UAS->ViewValue, 2, -2, -2, -2);
		$this->UAS->ViewCustomAttributes = "";

		// Jumlah
		$this->Jumlah->ViewValue = $this->Jumlah->CurrentValue;
		$this->Jumlah->ViewValue = FormatNumber($this->Jumlah->ViewValue, 2, -2, -2, -2);
		$this->Jumlah->ViewCustomAttributes = "";

		// Nilai
		$this->Nilai->ViewValue = $this->Nilai->CurrentValue;
		$this->Nilai->CellCssStyle .= "text-align: center;";
		$this->Nilai->ViewCustomAttributes = "";

		// Angka
		$this->Angka->ViewValue = $this->Angka->CurrentValue;
		$this->Angka->ViewValue = FormatNumber($this->Angka->ViewValue, 2, -2, -2, -2);
		$this->Angka->ViewCustomAttributes = "";

		// Nim
		$this->Nim->LinkCustomAttributes = "";
		$this->Nim->HrefValue = "";
		$this->Nim->TooltipValue = "";

		// Nama_Mhs
		$this->Nama_Mhs->LinkCustomAttributes = "";
		$this->Nama_Mhs->HrefValue = "";
		$this->Nama_Mhs->TooltipValue = "";

		// Kode_jp
		$this->Kode_jp->LinkCustomAttributes = "";
		$this->Kode_jp->HrefValue = "";
		$this->Kode_jp->TooltipValue = "";

		// Status_Akd
		$this->Status_Akd->LinkCustomAttributes = "";
		$this->Status_Akd->HrefValue = "";
		$this->Status_Akd->TooltipValue = "";

		// Thn_Akademik
		$this->Thn_Akademik->LinkCustomAttributes = "";
		$this->Thn_Akademik->HrefValue = "";
		$this->Thn_Akademik->TooltipValue = "";

		// Periode
		$this->Periode->LinkCustomAttributes = "";
		$this->Periode->HrefValue = "";
		$this->Periode->TooltipValue = "";

		// Kode_MK
		$this->Kode_MK->LinkCustomAttributes = "";
		$this->Kode_MK->HrefValue = "";
		$this->Kode_MK->TooltipValue = "";

		// kls
		$this->kls->LinkCustomAttributes = "";
		$this->kls->HrefValue = "";
		$this->kls->TooltipValue = "";

		// Kehadiran
		$this->Kehadiran->LinkCustomAttributes = "";
		$this->Kehadiran->HrefValue = "";
		$this->Kehadiran->TooltipValue = "";

		// Tugas
		$this->Tugas->LinkCustomAttributes = "";
		$this->Tugas->HrefValue = "";
		$this->Tugas->TooltipValue = "";

		// UTS
		$this->UTS->LinkCustomAttributes = "";
		$this->UTS->HrefValue = "";
		$this->UTS->TooltipValue = "";

		// UAS
		$this->UAS->LinkCustomAttributes = "";
		$this->UAS->HrefValue = "";
		$this->UAS->TooltipValue = "";

		// Jumlah
		$this->Jumlah->LinkCustomAttributes = "";
		$this->Jumlah->HrefValue = "";
		$this->Jumlah->TooltipValue = "";

		// Nilai
		$this->Nilai->LinkCustomAttributes = "";
		$this->Nilai->HrefValue = "";
		$this->Nilai->TooltipValue = "";

		// Angka
		$this->Angka->LinkCustomAttributes = "";
		$this->Angka->HrefValue = "";
		$this->Angka->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Nim
		$this->Nim->EditAttrs["class"] = "form-control";
		$this->Nim->EditCustomAttributes = "";
		if (!$this->Nim->Raw)
			$this->Nim->CurrentValue = HtmlDecode($this->Nim->CurrentValue);
		$this->Nim->EditValue = $this->Nim->CurrentValue;
		$this->Nim->PlaceHolder = RemoveHtml($this->Nim->caption());

		// Nama_Mhs
		$this->Nama_Mhs->EditAttrs["class"] = "form-control";
		$this->Nama_Mhs->EditCustomAttributes = "";
		if (!$this->Nama_Mhs->Raw)
			$this->Nama_Mhs->CurrentValue = HtmlDecode($this->Nama_Mhs->CurrentValue);
		$this->Nama_Mhs->EditValue = $this->Nama_Mhs->CurrentValue;
		$this->Nama_Mhs->PlaceHolder = RemoveHtml($this->Nama_Mhs->caption());

		// Kode_jp
		$this->Kode_jp->EditAttrs["class"] = "form-control";
		$this->Kode_jp->EditCustomAttributes = "";
		if (!$this->Kode_jp->Raw)
			$this->Kode_jp->CurrentValue = HtmlDecode($this->Kode_jp->CurrentValue);
		$this->Kode_jp->EditValue = $this->Kode_jp->CurrentValue;
		$this->Kode_jp->PlaceHolder = RemoveHtml($this->Kode_jp->caption());

		// Status_Akd
		$this->Status_Akd->EditAttrs["class"] = "form-control";
		$this->Status_Akd->EditCustomAttributes = "";
		if ($this->Status_Akd->getSessionValue() != "") {
			$this->Status_Akd->CurrentValue = $this->Status_Akd->getSessionValue();
			$this->Status_Akd->ViewValue = $this->Status_Akd->CurrentValue;
			$this->Status_Akd->ViewCustomAttributes = "";
		} else {
			if (!$this->Status_Akd->Raw)
				$this->Status_Akd->CurrentValue = HtmlDecode($this->Status_Akd->CurrentValue);
			$this->Status_Akd->EditValue = $this->Status_Akd->CurrentValue;
			$this->Status_Akd->PlaceHolder = RemoveHtml($this->Status_Akd->caption());
		}

		// Thn_Akademik
		$this->Thn_Akademik->EditAttrs["class"] = "form-control";
		$this->Thn_Akademik->EditCustomAttributes = "";
		if (!$this->Thn_Akademik->Raw)
			$this->Thn_Akademik->CurrentValue = HtmlDecode($this->Thn_Akademik->CurrentValue);
		$this->Thn_Akademik->EditValue = $this->Thn_Akademik->CurrentValue;
		$this->Thn_Akademik->PlaceHolder = RemoveHtml($this->Thn_Akademik->caption());

		// Periode
		$this->Periode->EditAttrs["class"] = "form-control";
		$this->Periode->EditCustomAttributes = "";
		if (!$this->Periode->Raw)
			$this->Periode->CurrentValue = HtmlDecode($this->Periode->CurrentValue);
		$this->Periode->EditValue = $this->Periode->CurrentValue;
		$this->Periode->PlaceHolder = RemoveHtml($this->Periode->caption());

		// Kode_MK
		$this->Kode_MK->EditAttrs["class"] = "form-control";
		$this->Kode_MK->EditCustomAttributes = "";
		if (!$this->Kode_MK->Raw)
			$this->Kode_MK->CurrentValue = HtmlDecode($this->Kode_MK->CurrentValue);
		$this->Kode_MK->EditValue = $this->Kode_MK->CurrentValue;
		$this->Kode_MK->PlaceHolder = RemoveHtml($this->Kode_MK->caption());

		// kls
		$this->kls->EditAttrs["class"] = "form-control";
		$this->kls->EditCustomAttributes = "";
		if ($this->kls->getSessionValue() != "") {
			$this->kls->CurrentValue = $this->kls->getSessionValue();
			$this->kls->ViewValue = $this->kls->CurrentValue;
			$this->kls->ViewCustomAttributes = "";
		} else {
			if (!$this->kls->Raw)
				$this->kls->CurrentValue = HtmlDecode($this->kls->CurrentValue);
			$this->kls->EditValue = $this->kls->CurrentValue;
			$this->kls->PlaceHolder = RemoveHtml($this->kls->caption());
		}

		// Kehadiran
		$this->Kehadiran->EditAttrs["class"] = "form-control";
		$this->Kehadiran->EditCustomAttributes = "";
		$this->Kehadiran->EditValue = $this->Kehadiran->CurrentValue;
		$this->Kehadiran->PlaceHolder = RemoveHtml($this->Kehadiran->caption());
		if (strval($this->Kehadiran->EditValue) != "" && is_numeric($this->Kehadiran->EditValue))
			$this->Kehadiran->EditValue = FormatNumber($this->Kehadiran->EditValue, -2, -2, -2, -2);
		

		// Tugas
		$this->Tugas->EditAttrs["class"] = "form-control";
		$this->Tugas->EditCustomAttributes = "";
		$this->Tugas->EditValue = $this->Tugas->CurrentValue;
		$this->Tugas->PlaceHolder = RemoveHtml($this->Tugas->caption());
		if (strval($this->Tugas->EditValue) != "" && is_numeric($this->Tugas->EditValue))
			$this->Tugas->EditValue = FormatNumber($this->Tugas->EditValue, -2, -2, -2, -2);
		

		// UTS
		$this->UTS->EditAttrs["class"] = "form-control";
		$this->UTS->EditCustomAttributes = "";
		$this->UTS->EditValue = $this->UTS->CurrentValue;
		$this->UTS->PlaceHolder = RemoveHtml($this->UTS->caption());
		if (strval($this->UTS->EditValue) != "" && is_numeric($this->UTS->EditValue))
			$this->UTS->EditValue = FormatNumber($this->UTS->EditValue, -2, -2, -2, -2);
		

		// UAS
		$this->UAS->EditAttrs["class"] = "form-control";
		$this->UAS->EditCustomAttributes = "";
		$this->UAS->EditValue = $this->UAS->CurrentValue;
		$this->UAS->PlaceHolder = RemoveHtml($this->UAS->caption());
		if (strval($this->UAS->EditValue) != "" && is_numeric($this->UAS->EditValue))
			$this->UAS->EditValue = FormatNumber($this->UAS->EditValue, -2, -2, -2, -2);
		

		// Jumlah
		$this->Jumlah->EditAttrs["class"] = "form-control";
		$this->Jumlah->EditCustomAttributes = "";
		$this->Jumlah->EditValue = $this->Jumlah->CurrentValue;
		$this->Jumlah->PlaceHolder = RemoveHtml($this->Jumlah->caption());
		if (strval($this->Jumlah->EditValue) != "" && is_numeric($this->Jumlah->EditValue))
			$this->Jumlah->EditValue = FormatNumber($this->Jumlah->EditValue, -2, -2, -2, -2);
		

		// Nilai
		$this->Nilai->EditAttrs["class"] = "form-control";
		$this->Nilai->EditCustomAttributes = "";
		if (!$this->Nilai->Raw)
			$this->Nilai->CurrentValue = HtmlDecode($this->Nilai->CurrentValue);
		$this->Nilai->EditValue = $this->Nilai->CurrentValue;
		$this->Nilai->PlaceHolder = RemoveHtml($this->Nilai->caption());

		// Angka
		$this->Angka->EditAttrs["class"] = "form-control";
		$this->Angka->EditCustomAttributes = "";
		$this->Angka->EditValue = $this->Angka->CurrentValue;
		$this->Angka->PlaceHolder = RemoveHtml($this->Angka->caption());
		if (strval($this->Angka->EditValue) != "" && is_numeric($this->Angka->EditValue))
			$this->Angka->EditValue = FormatNumber($this->Angka->EditValue, -2, -2, -2, -2);
		

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
			$this->Kehadiran->Count++; // Increment count
			if (is_numeric($this->Kehadiran->CurrentValue))
				$this->Kehadiran->Total += $this->Kehadiran->CurrentValue; // Accumulate total
			$this->Tugas->Count++; // Increment count
			if (is_numeric($this->Tugas->CurrentValue))
				$this->Tugas->Total += $this->Tugas->CurrentValue; // Accumulate total
			$this->UTS->Count++; // Increment count
			if (is_numeric($this->UTS->CurrentValue))
				$this->UTS->Total += $this->UTS->CurrentValue; // Accumulate total
			$this->UAS->Count++; // Increment count
			if (is_numeric($this->UAS->CurrentValue))
				$this->UAS->Total += $this->UAS->CurrentValue; // Accumulate total
			$this->Jumlah->Count++; // Increment count
			if (is_numeric($this->Jumlah->CurrentValue))
				$this->Jumlah->Total += $this->Jumlah->CurrentValue; // Accumulate total
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{
			if ($this->Kehadiran->Count > 0) {
				$this->Kehadiran->CurrentValue = $this->Kehadiran->Total / $this->Kehadiran->Count;
			}
			$this->Kehadiran->ViewValue = $this->Kehadiran->CurrentValue;
			$this->Kehadiran->ViewValue = FormatNumber($this->Kehadiran->ViewValue, 2, -2, -2, -2);
			$this->Kehadiran->ViewCustomAttributes = "";
			$this->Kehadiran->HrefValue = ""; // Clear href value
			if ($this->Tugas->Count > 0) {
				$this->Tugas->CurrentValue = $this->Tugas->Total / $this->Tugas->Count;
			}
			$this->Tugas->ViewValue = $this->Tugas->CurrentValue;
			$this->Tugas->ViewValue = FormatNumber($this->Tugas->ViewValue, 2, -2, -2, -2);
			$this->Tugas->ViewCustomAttributes = "";
			$this->Tugas->HrefValue = ""; // Clear href value
			if ($this->UTS->Count > 0) {
				$this->UTS->CurrentValue = $this->UTS->Total / $this->UTS->Count;
			}
			$this->UTS->ViewValue = $this->UTS->CurrentValue;
			$this->UTS->ViewValue = FormatNumber($this->UTS->ViewValue, 2, -2, -2, -2);
			$this->UTS->ViewCustomAttributes = "";
			$this->UTS->HrefValue = ""; // Clear href value
			if ($this->UAS->Count > 0) {
				$this->UAS->CurrentValue = $this->UAS->Total / $this->UAS->Count;
			}
			$this->UAS->ViewValue = $this->UAS->CurrentValue;
			$this->UAS->ViewValue = FormatNumber($this->UAS->ViewValue, 2, -2, -2, -2);
			$this->UAS->ViewCustomAttributes = "";
			$this->UAS->HrefValue = ""; // Clear href value
			if ($this->Jumlah->Count > 0) {
				$this->Jumlah->CurrentValue = $this->Jumlah->Total / $this->Jumlah->Count;
			}
			$this->Jumlah->ViewValue = $this->Jumlah->CurrentValue;
			$this->Jumlah->ViewValue = FormatNumber($this->Jumlah->ViewValue, 2, -2, -2, -2);
			$this->Jumlah->ViewCustomAttributes = "";
			$this->Jumlah->HrefValue = ""; // Clear href value

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->Nim);
					$doc->exportCaption($this->Nama_Mhs);
					$doc->exportCaption($this->Kode_jp);
					$doc->exportCaption($this->Status_Akd);
					$doc->exportCaption($this->Thn_Akademik);
					$doc->exportCaption($this->Periode);
					$doc->exportCaption($this->Kode_MK);
					$doc->exportCaption($this->kls);
					$doc->exportCaption($this->Kehadiran);
					$doc->exportCaption($this->Tugas);
					$doc->exportCaption($this->UTS);
					$doc->exportCaption($this->UAS);
					$doc->exportCaption($this->Jumlah);
					$doc->exportCaption($this->Nilai);
					$doc->exportCaption($this->Angka);
				} else {
					$doc->exportCaption($this->Nim);
					$doc->exportCaption($this->Nama_Mhs);
					$doc->exportCaption($this->Kode_jp);
					$doc->exportCaption($this->Status_Akd);
					$doc->exportCaption($this->Thn_Akademik);
					$doc->exportCaption($this->Periode);
					$doc->exportCaption($this->Kode_MK);
					$doc->exportCaption($this->kls);
					$doc->exportCaption($this->Kehadiran);
					$doc->exportCaption($this->Tugas);
					$doc->exportCaption($this->UTS);
					$doc->exportCaption($this->UAS);
					$doc->exportCaption($this->Jumlah);
					$doc->exportCaption($this->Nilai);
					$doc->exportCaption($this->Angka);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);
				$this->aggregateListRowValues(); // Aggregate row values

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->Nim);
						$doc->exportField($this->Nama_Mhs);
						$doc->exportField($this->Kode_jp);
						$doc->exportField($this->Status_Akd);
						$doc->exportField($this->Thn_Akademik);
						$doc->exportField($this->Periode);
						$doc->exportField($this->Kode_MK);
						$doc->exportField($this->kls);
						$doc->exportField($this->Kehadiran);
						$doc->exportField($this->Tugas);
						$doc->exportField($this->UTS);
						$doc->exportField($this->UAS);
						$doc->exportField($this->Jumlah);
						$doc->exportField($this->Nilai);
						$doc->exportField($this->Angka);
					} else {
						$doc->exportField($this->Nim);
						$doc->exportField($this->Nama_Mhs);
						$doc->exportField($this->Kode_jp);
						$doc->exportField($this->Status_Akd);
						$doc->exportField($this->Thn_Akademik);
						$doc->exportField($this->Periode);
						$doc->exportField($this->Kode_MK);
						$doc->exportField($this->kls);
						$doc->exportField($this->Kehadiran);
						$doc->exportField($this->Tugas);
						$doc->exportField($this->UTS);
						$doc->exportField($this->UAS);
						$doc->exportField($this->Jumlah);
						$doc->exportField($this->Nilai);
						$doc->exportField($this->Angka);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}

		// Export aggregates (horizontal format only)
		if ($doc->Horizontal) {
			$this->RowType = ROWTYPE_AGGREGATE;
			$this->resetAttributes();
			$this->aggregateListRow();
			if (!$doc->ExportCustom) {
				$doc->beginExportRow(-1);
				$doc->exportAggregate($this->Nim, '');
				$doc->exportAggregate($this->Nama_Mhs, '');
				$doc->exportAggregate($this->Kode_jp, '');
				$doc->exportAggregate($this->Status_Akd, '');
				$doc->exportAggregate($this->Thn_Akademik, '');
				$doc->exportAggregate($this->Periode, '');
				$doc->exportAggregate($this->Kode_MK, '');
				$doc->exportAggregate($this->kls, '');
				$doc->exportAggregate($this->Kehadiran, 'AVERAGE');
				$doc->exportAggregate($this->Tugas, 'AVERAGE');
				$doc->exportAggregate($this->UTS, 'AVERAGE');
				$doc->exportAggregate($this->UAS, 'AVERAGE');
				$doc->exportAggregate($this->Jumlah, 'AVERAGE');
				$doc->exportAggregate($this->Nilai, '');
				$doc->exportAggregate($this->Angka, '');
				$doc->endExportRow();
			}
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = 0, $height = 0)
	{

		// No binary fields
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>