<?php 
include 'db.php';
include 'funct.php';
?>
<!doctype html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">    
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <style>
        @media print {          
            table {
                page-break-inside: auto;
                font-size: 10pt;
                font-family: 'Calibri', sans-serif;
            }

            tr {
                page-break-inside: avoid;
                page-break-after: auto;
            }

            thead {
                display: table-header-group;
            }

            tfoot {
                display: table-footer-group;
            }
        }
    </style>
    <style>
        .page-break {
      page-break-before: always; /* Gunakan 'always' jika ingin elemen dimulai di halaman baru */    
    }
  </style>
    <script src="https://cdn.rawgit.com/davidshimjs/qrcodejs/gh-pages/qrcode.min.js"></script>
    <title>Berita Acara Perkuloiahan - ATB Bandung</title>
</head>


<body>
<div class='container mt-3'>
<?php
// Ambil parameter Nim dari metode GET
if (isset($_GET['nidn']) && isset($_GET['thn_akademik']) && isset($_GET['periode']) && isset($_GET['klsakd']) && isset($_GET['kodemk']) && isset($_GET['grp']) && isset($_GET['kjp'])) {
  // Lindungi dari SQL Injection dan XSS Injection
  $nidn = htmlspecialchars($_GET['nidn']);
  $thn_akademik = htmlspecialchars($_GET['thn_akademik']);
  $periode = htmlspecialchars($_GET['periode']);
  $klsakd = htmlspecialchars($_GET['klsakd']);
  $kmk = htmlspecialchars($_GET['kodemk']);
  $grp = htmlspecialchars($_GET['grp']);
  $kjp = htmlspecialchars($_GET['kjp']);
  $jenis = htmlspecialchars($_GET['jenis']);
  if ($periode=="1") {
    $sem = "Ganjil";
  } elseif ($periode=="2") {
    $sem = "Genap";
  } else {
    $sem = "Alih Tahun";
  }

  if ($jenis=="UTS") {
    $ujian = "Ujian Tengah Semester";
  } elseif ($jenis=="UAS") {
    $ujian = "Ujian Akhir Semester";
  }
      
    // Query untuk mengambil data dari VIEW_MHS dengan kondisi Nim
    $query = "SELECT TOP 1 Thn_Akademik, Periode, Kelas_Akd, Kode_Mk, MataKuliah, SKS, Kelas, Tanggal, JM, JS, Ruang, NIDN, Nama, Kode_Jp, Prodi, Jenis, CatatanKhusus, Pengawas, Pengawas1,
              dbo.hdrujian(Thn_Akademik,Periode,Kelas_Akd,Kode_Mk,Kelas,Kode_Jp,Jenis) as jhdr,
              dbo.jmlujian(Thn_Akademik,Periode,Kelas_Akd,Kode_Mk,Kelas,Kode_Jp) as jml
              FROM VJadwalUjian WHERE Thn_Akademik=:th AND Periode=:per AND Kelas_Akd=:kls AND NIDN=:nidn AND Kode_Mk=:kmk AND Kelas=:grp AND Kode_Jp=:kjp AND Jenis=:jenis";
    
    try {
        // Eksekusi query menggunakan prepared statement
        $stmt = $conn->prepare($query);
        
        // Binding parameter        
        $stmt->bindParam(':th', $thn_akademik, PDO::PARAM_STR);
        $stmt->bindParam(':per', $periode, PDO::PARAM_STR);
        $stmt->bindParam(':kls', $klsakd, PDO::PARAM_STR);
        $stmt->bindParam(':nidn', $nidn, PDO::PARAM_STR);
        $stmt->bindParam(':kmk', $kmk, PDO::PARAM_STR);
        $stmt->bindParam(':grp', $grp, PDO::PARAM_STR);
        $stmt->bindParam(':kjp', $kjp, PDO::PARAM_STR);
        $stmt->bindParam(':jenis', $jenis, PDO::PARAM_STR);
        
        // Eksekusi prepared statement
        $stmt->execute();
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {        
          $xnama = $row['Nama'];
          $mk = $row['Kode_Mk'].' - '.$row['MataKuliah'].' ('.$row['SKS'].'SKS)';
          $jadwal =date('d-m-Y', strtotime($row['Tanggal'])).', '.date('H:i', strtotime($row['JM'])).'-'.date('H:i', strtotime($row['JS'])).' / '. $row['Ruang'];
          $prod = $row['Prodi'];
          $xkunci = md5(time() . $nidn);
          $tgl = date('d-m-Y', strtotime($row['Tanggal'])).', '.date('H:i', strtotime($row['JM'])).'-'.date('H:i', strtotime($row['JS']));
          $tglsaja = date('Y-m-d', strtotime($row['Tanggal']));
          $tglp = date('d-m-Y', strtotime($row['Tanggal'] . ' +7 days'));
          

 ?>

<table width="100%" border="0" cellspacing="0" cellpadding="0">
  <tbody>
    <tr>
      <td colspan="3"><img src="kopatb.png" height="85" alt=""/><hr></td>
      </tr>
    <tr>
      <td colspan="3" align="center"><b><u>BERITA ACARA PELAKSANAAN <?php echo strtoupper($ujian); ?></u></b><br> <br></td>
      </tr>
    <tr>
      <td colspan="3">Pada hari ini <?php echo getHari($row['Tanggal']); ?>, <?php echo formatTanggal($tglsaja); ?>, Akademi Tata Boga Bandung telah melaksanakan <?php echo $ujian; ?> Tahun Akademik <?php echo $thn_akademik; ?>, Semester <?php echo $sem; ?>. Berikut adalah rangkuman pelaksanaan ujian tersebut :</td>
    </tr>
    <tr>
      <td colspan="3"><strong> Identitas Ujian:</strong></td>
      </tr>
    <tr>
     <td width="2%">&nbsp;</td>
      <td width="25%">Matakuliah</td>
      <td width="73%">: <?php echo $mk; ?></td>
    </tr>
    <tr>
    <td>&nbsp;</td>
      <td>Rombel</td>
      <td>: <?php echo $row['Kelas'];?></td>
    </tr>
    <tr>
      <td>&nbsp;</td>
      <td>Dosen Pengampu</td>
      <td>: <?php echo $row['NIDN'];?> - <?php echo $row['Nama'];?></td>
    </tr>
    <tr>
    <td>&nbsp;</td>
      <td>Tanggal, Jam / Ruang</td>
      <td>:  <?php echo $jadwal; ?></td>
    </tr>
    <tr>
    <td>&nbsp;</td>
      <td valign="top">Pengawas</td>
      <td>: 1. <?php echo $row['Pengawas'];?> <br>
      &nbsp;&nbsp;2. <?php echo $row['Pengawas1'];?>
    </td>
    </tr>    
    <tr>
    <td>&nbsp;</td>
      <td>Jumlah Peserta</td>
      <td>: <?php echo $row['jml'];?> Orang; Hadir = <?php echo $row['jhdr'];?> Orang; Tidak Hadir = <?php echo $row['jml']-$row['jhdr'];?> Orang.</td>
    </tr>
    <tr>
      <td colspan="3"><p><strong>Catatan Khusus : </strong></p>
        <p><?php echo $row['CatatanKhusus'];?></p>
        </td>
    </tr>
    <tr>
      <td colspan="3"><strong>Ketentuan Ujian:</strong>
        <ol>
          <li>Ujian dilaksanakan sesuai dengan kurikulum dan pedoman penilaian Akademi Tata Boga Bandung.</li>
          <li>Peserta diberi waktu yang cukup untuk mengerjakan setiap bagian ujian.</li>
          <li>Pengawas dan dosen pengampu memastikan keamanan dan kelancaran pelaksanaan ujian.</li>
        </ol></td>
    </tr>
    <tr>
      <td colspan="3"><strong>Hasil Ujian:</strong>
        <ol>
          <li>Hasil ujian akan diumumkan pada tanggal <?php echo $tglp; ?>.</li>
          <li>Pemberian nilai akan mengacu pada kriteria penilaian Akademi Tata Boga Bandung.</li>
        </ol></td>
    </tr>
    <tr>
      <td colspan="3">Demikianlah berita acara ini dibuat dengan sebenarnya untuk dapat digunakan sebagaimana mestinya.</td>
      </tr>
  </tbody>
</table>
<?php
}
  } catch (PDOException $e) {
    echo "Terjadi Kesalahan: " . $e->getMessage();
  } 
  
?>
	<br>  
<?php
$protocol = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http';
$host = $_SERVER['HTTP_HOST'];
$url = $_SERVER['REQUEST_URI'];
$full_url = $protocol . "://" . $host . $url;

$xLink = $full_url;
$arraypesan = array(
  'Jenis Dokumen' => 'BERITA ACARA PELAKSANAAN '.strtoupper($ujian),
  'SN' => $xkunci,
  'Tanggal Dokumen' => $tgl,
  'Tahun Akademik' => $thn_akademik.' - '.$sem,
  'Nama Dosen' => $xnama,
  'NIDN' => $nidn,
  'Program Studi' => $prod,
  'Matakuliah' => $mk,        
  'Ditandatangani oleh' => $xnama,
  'Tanggal Cetak' => date('d-m-Y H:i:s'),
);
$pesan = json_encode($arraypesan);
catatdoc($xkunci, $pesan, $xLink);
$urlverify = $protocol . "://" . $host . "/custom/verifikasi.php?kunci=" . $xkunci;
?>
 <table width="100%" border="0" cellspacing="0" cellpadding="0">
        <tbody>
          <tr>
            <td width="40%" align="center">Ka. Subag Akademik,</td>
            <td width="20%">&nbsp;</td>
            <td width="40%" align="center">Bandung, <?php echo formatTanggal($tglsaja); ?><br> Dosen Pengampu Matakuliah,</td>
          </tr>
          <tr>
            <td>
          <div align="center" id="qrcodex"></div>
          <script type="text/javascript">
             new QRCode(document.getElementById("qrcodex"), {
             text: "<?= $urlverify; ?>",
             width: 90,
             height: 90,
             colorDark: "#000000",
             colorLight: "#ffffff",
             correctLevel: QRCode.CorrectLevel.M
            });            
          </script> 

            </td>
            <td>&nbsp;</td>
            <td>
          <div align="center" id="qrcode"></div>
          <script type="text/javascript">
             new QRCode(document.getElementById("qrcode"), {
             text: "<?= $urlverify; ?>",
             width: 90,
             height: 90,
             colorDark: "#000000",
             colorLight: "#ffffff",
             correctLevel: QRCode.CorrectLevel.M
            });            
          </script>  
            </td>
          </tr>
          <tr>
            <td align="center"><strong><?php echo getbaak(); ?></strong></td>
            <td>&nbsp;</td>
            <td align="center">(<strong><?php echo $xnama; ?></strong>)</td>
          </tr>
        </tbody>
  </table>
      <p>&nbsp;</p>
<?php

// Daftar hadir Mahasiswa


// Query SQL dengan parameter yang telah dibersihkan
$sql = "SELECT tblnilai.Nim, Nama_Mhs, Kehadiran, HUTS, HUAS, Afektif, Prak, Tugas, UTS, UAS, Jumlah, Nilai, Angka  FROM tblNilai INNER JOIN tblMHS ON tblNilai.Nim = tblmhs.Nim 
        WHERE Thn_Akademik = :th AND Periode = :per AND tblMHS.Status_Akd = :kelas AND Kode_Mk = :mk AND Kls = :grp AND tblMHS.Kode_jp = :jp";

// Gunakan bind parameters untuk mencegah SQL injection
$stmt = $conn->prepare($sql);
$stmt->bindParam(':th', $thn_akademik, PDO::PARAM_STR);
$stmt->bindParam(':per', $periode, PDO::PARAM_STR);
$stmt->bindParam(':kelas', $klsakd, PDO::PARAM_STR);
$stmt->bindParam(':mk', $kmk, PDO::PARAM_STR);
$stmt->bindParam(':jp', $kjp, PDO::PARAM_STR);
$stmt->bindParam(':grp', $grp, PDO::PARAM_STR);

// Eksekusi query
$stmt->execute();

// Ambil hasil query
$results = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Tutup koneksi
$conn = null;

?>

</div>
<div class="container mt-3 page-break">
<table width="100%" border="0" cellspacing="0" cellpadding="0">
  <tbody>
    <tr>
      <td colspan="6"><img src="kopatb.png" height="85" alt=""/><hr></td>
    </tr>
    <tr>
      <td colspan="6" align="center"><b><u>DAFTAR HADIR PESERTA & NILAI <?php echo strtoupper($ujian);?></u></b><br>TAHUN <?php echo $thn_akademik; ?>, SEMESTER <?php echo strtoupper($sem); ?> <br> <br></td>
    </tr>
    <tr>
      <td width="12%" valign="top">Matakuliah</td>
      <td width="1%" valign="top">:</td>
      <td width="38%"><?php echo $mk; ?></td>
      <td width="12%" valign="top">Program Studi</td>
      <td width="1%" valign="top">:</td>
      <td width="36%" valign="top"><?php echo $prod; ?> </td>
    </tr>
    <tr>
      <td>Jadwal / Ruang</td>
      <td>:</td>
      <td><?php echo $jadwal; ?></td>
      <td valign="top">Pengampu</td>
      <td valign="top">:</td>
      <td valign="top"><?php echo $nidn; ?> - <?php echo $xnama; ?></td>
    </tr>
  </tbody>
</table>
    <table class="table table-sm table-hover table-bordered">
        <thead>
            <tr>
              <th>No</th>
              <th>Nim</th>
              <th>Nama Mahasiswa</th>              
              <th align="center">% HDR</th>
              <th align="center">AFK</th>
              <th align="center">PRK</th>
              <th align="center">TGS</th>
              <th align="center">UTS</th>
              <th align="center">UAS</th>
              <th align="center">JML</th>
              <th align="center">NIL</th>
              <th align="center" >MTU</th>             
            </tr>
        </thead>
        <tbody>
          <?php 
          $no = 1;
          foreach ($results as $row): 
          ?>
            <tr>
                  <td align="right"><?php echo $no; ?></td>
					        <td><?php echo $row['Nim']; ?></td>
                  <td><?php echo $row['Nama_Mhs']; ?></td>
                  <td align="right"><?php echo number_format($row['Kehadiran'],2); ?></td>
                  <td align="right"><?php echo number_format($row['Afektif'],2); ?></td>
                  <td align="right"><?php echo number_format($row['Prak'],2); ?></td>
                  <td align="right"><?php echo number_format($row['Tugas'],2); ?></td>
                  <td align="right"><?php echo number_format($row['UTS'],2); ?></td>
                  <td align="right"><?php echo number_format($row['UAS'],2); ?></td>
                  <td align="right"><?php echo number_format($row['Jumlah'],2); ?></td>
                  <td align="center"><?php echo $row['Nilai'] ?></td>
                  <td align="right"><?php echo $row['Angka'] ?></td>             
					        
                </tr>
            <?php 
             $no = $no + 1;
          endforeach; 
          ?>
        </tbody>
    </table>
<em>Keterangan : H = Hadir, I = Ijin, A = Alpha, S = Sakit</em> </div> 

<div class="container mt-3">
<table width="100%" border="0" cellspacing="0" cellpadding="0">
        <tbody>
          <tr>
            <td width="24%" align="center">Ka. Subag Akademik,</td>
            <td width="44%">&nbsp;</td>
            <td width="32%" align="center">Bandung, <?php echo formatTanggal($tglsaja); ?><br> Dosen Pengampu Matakuliah,</td>
          </tr>
          <tr>
            <td>
          <div align="center" id="qrcodea"></div>
          <script type="text/javascript">
             new QRCode(document.getElementById("qrcodea"), {
             text: "<?= $urlverify; ?>",
             width: 90,
             height: 90,
             colorDark: "#000000",
             colorLight: "#ffffff",
             correctLevel: QRCode.CorrectLevel.M
            });            
          </script> 

            </td>
            <td>&nbsp;</td>
            <td>
          <div align="center" id="qrcodeb"></div>
          <script type="text/javascript">
             new QRCode(document.getElementById("qrcodeb"), {
             text: "<?= $urlverify; ?>",
             width: 90,
             height: 90,
             colorDark: "#000000",
             colorLight: "#ffffff",
             correctLevel: QRCode.CorrectLevel.M
            });            
          </script>  
            </td>
          </tr>
          <tr>
            <td align="center"><strong><?php echo getbaak(); ?></strong></td>
            <td>&nbsp;</td>
            <td align="center">(<strong><?php echo $xnama; ?></strong>)</td>
          </tr>
        </tbody>
      </table>

</div>
<?php
}
else {
  // Jika parameter Nim tidak diberikan
  echo "Parameter tidak lengkap.";
}
?>
</body>
</html>
