<?php 
include 'db.php';
include 'funct.php';
?>
<!doctype html>
<html>
<head>
<meta charset="utf-8">
<title>EKPT - Indonesia Mandiri</title>
 <!-- Normalize or reset CSS with your favorite library -->
 <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/normalize/7.0.0/normalize.min.css">
 <!-- Load paper.css for happy printing -->
 <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/paper-css/0.4.1/paper.css">
 <!-- Set page size here: A5, A4 or A3 -->
 <!-- Set also "landscape" if you need -->
 <style>
 @page { size: legal }
/* CSS untuk membuat garis terputus-putus */
body {
    font-family: 'Calibri', sans-serif;
    font-size: 12pt;
}
  .dashed-hr {
        border: none;
        border-top: 2px dashed #000; /* warna dan ketebalan garis dapat disesuaikan */
        margin: 20px 0; /* jarak atas dan bawah */
    }

    .dotted-hr {
        border: none;
        border-top: 2px dotted #000; /* warna dan ketebalan garis dapat disesuaikan */
        margin: 20px 0; /* jarak atas dan bawah */
    }

    .ttd-container {
        position: relative;
        text-align: center;
    }

    .ttd-img {
        position: absolute;
        top: -50px; /* Sesuaikan jarak vertikal tandatangan dengan teks di bawahnya */
        left: 50%;
        transform: translateX(-50%);
    }

  .styled-table {
    border-collapse: collapse;
    width: 100%;
    font-size: 9pt; /* Ukuran font 8 */
  }
  
  .styled-table td, .styled-table th {
    border: 1px solid black;
    padding: 4px;    
    line-height: 1.0; /* Tinggi baris disesuaikan dengan tinggi font */
  }
  
  .styled-table th {
    background-color: #f2f2f2;
  }

  .table-font-9 {
    font-size: 9.5pt;
  }

  


</style>  
 <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
 <link rel="stylesheet" href="table.css">
 <script src="https://cdn.rawgit.com/davidshimjs/qrcodejs/gh-pages/qrcode.min.js"></script>
</head>
<body class="legal">
<?php
// Ambil parameter Nim dari metode GET
function isi($value, $emptyMessage = "0") {
  if (isset($value) && trim($value) !== '') {
      return $value;
  } else {
      return $emptyMessage;
  }
}

if (isset($_GET['nim']) && isset($_GET['id'])) {  
  // Lindungi dari SQL Injection dan XSS Injection  
  $xid = htmlspecialchars($_GET['id']);
  $xnim = htmlspecialchars($_GET['nim']);
  $salt = "86458762398576twuitrweu@#UTUY&*%&****trwerutUTUYT";
  $yid=md5($salt . $xnim);
  //cek md5
  if ($yid === $xid){
   // Awal Resume Mahasiswa 
   try {  
    // SQL untuk menampilkan data dari pmb_mhs berdasarkan Nopen
    $xsql = "SELECT Nim, Nama_Mhs, Prodi, Kode_Fak,	Status_Masuk, PerMasukIM, PerLulusIM, Status, TaAkhir, Status_Akd, Tgl_Lulus, Judul_TA, IPK, TSKS, SK, Ijazah, Ktp, 	KK, 	tandatangan, 
            IjazahIM, TranskriptIM, Skripsi, Plagiat, xphoto, TSem, TASkripsi, (select top 1 filesk FROM SK_LulusPMB WHERE Nim = ekpt_riwayat.Nim) as skpmb FROM ekpt_riwayat WHERE Nim = :nim";

    // Persiapkan statement SQL
    $xstmt = $conn->prepare($xsql);

    // Bind parameter
    $xstmt->bindParam(':nim', $xnim);

    // Eksekusi statement
    $xstmt->execute();

    // Ambil hasil query
    $xresult = $xstmt->fetch(PDO::FETCH_ASSOC);

    // Tampilkan hasil dalam bentuk tabel dua kolom
    if ($xresult) {
     ?>  
    <section class="sheet padding-10mm">     
   <div> 
   <table width="100%" border="0" cellspacing="0" cellpadding="0">
  <tbody>
    <tr>
      <td colspan="4"><h2>RIWAYAT AKADEMIK MAHASISWA</h2></td>
    </tr>
    <tr>
    <td width="15%" rowspan="6" valign="top" align="center">
    <?php if (trim($xresult['xphoto']) !== '') { ?>
        <img src="https://akademik.stmik-im.ac.id/files/photo/<?php echo $xresult['xphoto']; ?>" height="100" alt="Photo"/>
    <?php } else { ?>
        <img src="nophoto.png" height="100" alt="Tidak ada Photo"/>
    <?php } ?>
    </td>
      <td width="30%">Nama Mahasiswa</td>
      <td width="2%">:</td>
      <td width="53%"> <?php echo $xresult['Nama_Mhs'] ?></td>
    </tr>
    <tr>
      <td>NIM</td>
      <td>:</td>
      <td><?php echo $xresult['Nim'] ?></td>
    </tr>
    <tr>
      <td>Program Studi</td>
      <td>:</td>
      <td><?php echo $xresult['Prodi'] ?></td>
    </tr>
    <tr>
      <td>Kelas Program</td>
      <td>:</td>
      <td><?php echo $xresult['Status_Akd'] ?></td>
    </tr>
    <tr>
      <td>Status Masuk </td>
      <td>:</td>
      <td><?php echo $xresult['Status_Masuk'] ?></td>
    </tr>
    <tr>
      <td>Tahun Masuk</td>
      <td>:</td>
      <td><?php echo $xresult['PerMasukIM'] ?></td>
    </tr>   
    <tr>
      <td colspan="4" valign="top"><table width="100%" border="0" cellspacing="0" cellpadding="0">
        <tbody>
          <tr>
            <td width="30%">Jumlah Semester</td>
            <td width="2%">:</td>
            <td width="58%"> <?php echo $xresult['TSem'] ?> </td>
          </tr>
          <tr>
            <td>Semester Terakhir Aktif</td>
            <td>:</td>
            <td><?php echo $xresult['TaAkhir'] ?></td>
    </tr>
          <tr>
            <td>SKS Ditempuh</td>
            <td>:</td>
            <td><?php echo $xresult['TSKS'] ?> SKS</td>
          </tr>
          <tr>
            <td>Status Mahasiswa</td>
            <td>:</td>
            <td><?php echo $xresult['Status'] ?></td>
          </tr>
          <tr>
            <td>IPK</td>
            <td>:</td>
            <td><?php echo round($xresult['IPK'],2) ?></td>
          </tr>
          <?php
            $xlulus = 0;
           if (trim($xresult['Status'])==="Lulus") { 
            $xlulus = 1;
          ?>
            <tr>
            <td>Tanggal Lulus</td>
            <td>:</td>
            <td><?php echo  date("d F Y", strtotime($xresult['Tgl_Lulus'])); ?></td>
          </tr>
          <tr>
            <td>No SK Lulusan</td>
            <td>:</td>
            <td><?php echo $xresult['SK'] ?> </td>
          </tr>
          <tr>
            <td valign="top">Judul Skripsi</td>
            <td valign="top">:</td>
            <td valign="top"><?php echo $xresult['Judul_TA'] ?></td>
          </tr> 
          <tr>
            <td valign="top">Berkas Skripsi</td>
            <td valign="top">:</td>
            <td valign="top">
            1. <a href="https://akademik.stmik-im.ac.id/views/uploads/riwayat/<?php echo $xresult['Skripsi'] ?>" target="_blank"><?php echo $xresult['Skripsi'] ?>
              <?php echo (isi($xresult['Skripsi']) === "0") ? "(Tidak ada)" : ""; ?>
            </a><br>
            2. <a href="https://akademik.stmik-im.ac.id/docs/TaSkripsi/<?php echo $xresult['TASkripsi'] ?>" target="_blank"><?php echo $xresult['TASkripsi'] ?>
              <?php echo (isi($xresult['TASkripsi']) === "0") ? "(Tidak ada)" : ""; ?>
            </a>
            </td>
          </tr>         
          <?php $filesk = $xresult['skpmb']; ?>
          <?php }?>          
          <tr>
            <td>&nbsp;</td>
            <td>&nbsp;</td>
            <td>&nbsp;</td>
          </tr>
        </tbody>
      </table>
      </td>
    </tr>
  </tbody>
</table>
<p><strong>Dokumen Mahasiswa Bersangkutan</strong> :</p>
	<ol>
	  <li><a href="#FPD">Formulir Pendaftaran</a></li>
	  <li><a href="https://akademik.stmik-im.ac.id/views/uploads/<?php echo $xresult['Ijazah'] ?>" target="_blank">Ijazah SMA/Sederajat
    <?php echo (isi($xresult['Ijazah']) === "0") ? "(Tidak ada)" : ""; ?>
</a></li>
	  <li><a href="https://akademik.stmik-im.ac.id/views/uploads/<?php echo $xresult['Ktp'] ?>" target="_blank">KTP
    <?php echo (isi($xresult['Ktp']) === "0") ? "(Tidak ada)" : ""; ?>
</a></li>
	  <li><a href="https://akademik.stmik-im.ac.id/views/uploads/<?php echo $xresult['KK'] ?>" target="_blank">Kartu Keluarga/ Akta Kelahiran
    <?php echo (isi($xresult['KK']) === "0") ? "(Tidak ada)" : ""; ?>
</a></li>
    <?php if (trim($xresult['Status_Masuk'])==="Mutasi") { ?>
    <li><a href="#konversi">Konversi Mahasiswa Pindahan</a> (jika status masuk = Mutasi/Pindahan)</li>
    <?php }?>    
	  <li><a href="#pembayaran">Pembayaran Pendaftaran</a></li>
	  <li><a href="#riwayatbyr">Riwayat Pembayaran Uang Kuliah</a></li>
	  <li><a href="#KRS">KRS (Rencana Studi)</a></li>
	  <li><a href="#KHS">KHS (Hasil Studi Semester)</a></li>
    <?php if ($xlulus == 1) {
     ?> 
        <li><a href="#SIDANG">Berita Acara Sidang</a></li>
    <?php    
    }
	  ?>
	  <li><a href="#DNS">DNS (Daftar Nilai Sementara)</a></li>
	  <li><a href="https://akademik.stmik-im.ac.id/views/uploads/riwayat/<?php echo $xresult['IjazahIM'] ?>" target="_blank">Ijazah
    <?php echo (isi($xresult['IjazahIM']) === "0") ? "(Tidak ada)" : ""; ?>
    </a></li>
	  <li><a href="https://akademik.stmik-im.ac.id/views/uploads/riwayat/<?php echo $xresult['TranskriptIM'] ?>" target="_blank">Transkript
    <?php echo (isi($xresult['TranskriptIM']) === "0") ? "(Tidak ada)" : ""; ?>
  </a>
</li>
	<li><a href="#HADIR">Riwayat Kehadiran Mahasiswa dan Dosen</a></li>
	<li><a href="https://baak.stmik-im.ac.id/files/sk_pmb/<?php echo $filesk; ?>">SK PMB (Mahasiswa diterima)</a></li>
</ol>

   </div>
   </section>
   <?php 
    } else {
      echo "Data Mahasiswa tidak ditemukan.";
    }
      } catch (PDOException $e) {
        echo "Terjadi Kesalahan  : " . $e->getMessage();
      }    
   //Akhir Resume Mahasiswa
   //awal pedaftaran form pmb
  try {  
    // SQL untuk menampilkan data dari pmb_mhs berdasarkan Nopen
    $sql = "SELECT Nopen, Nim, Nama_Mhs, Kode_jp, Prodi, Kode_Fak, Tmp_Lahir, Tgl_Lahir, Jenis_Kel, Gol_darah, Agama_Mhs, Alamat_Mhs,
            rt, rw, Kelurahan, id_wilayah, nama_wilayah, id_negara, Kecamatan, Kota_Mhs, Provinsi_mhs, Kodepos_Mhs, Tlp_Mhs, TlpRumah, 
            Email, NIK, NamaIbu, Status_Akd, ThMasuk, tglmasuk, Status_Masuk, TaMasuk, PerMasuk, Pendidikan_Akhir, Jurusan, Thn_Selesai, 
            Kota_Pdkk, propinsi, NamaSekolahAsal, AlamatSekolahAsal, IdBeasiswa, NamaBeasiswa, NISN, tglDaftar, Ijazah, KK, Ktp, tandatangan,
            Nama, Jabatan, xphoto, ttd, tanggal, Password From IM_Daftar WHERE Nim = :nim";

    // Persiapkan statement SQL
    $stmt = $conn->prepare($sql);

    // Bind parameter
    $stmt->bindParam(':nim', $xnim);

    // Eksekusi statement
    $stmt->execute();

    // Ambil hasil query
    $result = $stmt->fetch(PDO::FETCH_ASSOC);

    // Tampilkan hasil dalam bentuk tabel dua kolom
    if ($result) {
		    $kodefak=trim($result['Kode_Fak']);
        if ($result['Jenis_Kel']=="L") {
            $kel = "Laki - Laki";
        }else{
            $kel = "Perempuan";
        }
        if (trim($result['Status_Akd']==="Reguler")) {
           $kls  = "Reguler";
        } else {
          $kls  = "Non Reguler / Karyawan";
        }
		
    ?> 
  <section class="sheet padding-10mm">     
	<div>    
	<?php	
		if ($kodefak === "T") {
		echo '<img src="kstmik.jpg"  height="85" alt=""/>';
		$pt = "STMIK IM";	
		} else {
		echo '<img src="kstan.jpeg"  height="85" alt=""/>';
		    $pt = "STIE STAN";
		}		
	?>	
  <hr>
	  
	</div>

        <div id="FPD">
        <table class="table-border-1">
        <tr>
          <td colspan="4" align="center"><strong>FORM PENDAFTARAN</strong><br> Nomor : <?php echo $result['Nopen'] ?></td>
        </tr>
        <tr>
          <td colspan="4" align="center"><strong>DATA CALON MAHASISWA</strong></td>
          </tr>
        <tr>
          <td width="14%">Nama Lengkap</td>
          <td width="40%">: <?php echo $result['Nama_Mhs'] ?></td>
          <td width="12%">NIK</td>
          <td width="34%">: <?php echo $result['NIK'] ?></td></tr>
        <tr>
          <td>Tempat Lahir </td>
          <td>: <?php echo $result['Tmp_Lahir'] ?></td>
          <td>Tanggal Lahir</td>
          <td>:  <?php echo date("d F Y", strtotime($result['Tgl_Lahir']));?> </td></tr>
        <tr>
          <td>Jenis Kelamin</td>
          <td>: <?php echo $kel ?></td>
          <td>Gol Darah</td>
          <td>: <?php echo $result['Gol_darah'] ?></td>
        </tr>
        <tr>
          <td>Agama</td>
          <td>: <?php echo $result['Agama_Mhs'] ?></td>
          <td>Warganegara</td>
          <td>: <?php echo $result['id_negara'] ?></td>
        </tr>
        <tr>
          <td>Alamat</td>
          <td>: <?php echo $result['Alamat_Mhs'] ?></td>
          <td>RT, RW</td>
          <td>: <?php echo $result['rt'] ?> / <?php echo $result['rw'] ?></td>
        </tr>
        <tr>
          <td>Kelurahan</td>
          <td>: <?php echo $result['Kelurahan'] ?></td>
          <td>Kecamatan</td>
          <td>: <?php echo $result['Kecamatan'] ?></td>
        </tr>
        <tr>
          <td>Kota</td>
          <td>: <?php echo $result['Kota_Mhs'] ?></td>
          <td>Provinsi</td>
          <td>: <?php echo $result['Provinsi_mhs'] ?></td>
        </tr>
        <tr>
          <td>No Telepon</td>
          <td>: <?php echo $result['Tlp_Mhs'] ?>, <?php echo $result['TlpRumah'] ?></td>
          <td>Email</td>
          <td>: <?php echo $result['Email'] ?></td>
        </tr>
        <tr>
          <td>Nama ibu</td>
          <td colspan="3">: <?php echo $result['NamaIbu'] ?></td>
          </tr>
        <tr>
          <td colspan="4" align="center"><strong>DATA PENDIDIKAN TERAKHIR</strong></td>
          </tr>
        <tr>
          <td>Jenjang</td>
          <td>: <?php echo $result['Pendidikan_Akhir'] ?>, <?php echo $result['Jurusan'] ?></td>
          <td>Nama Sekolah</td>
          <td>: <?php echo $result['NamaSekolahAsal'] ?></td>
        </tr>
        <tr>
          <td>Alamat</td>
          <td>: <?php echo $result['AlamatSekolahAsal'] ?></td>
          <td>Kota</td>
          <td>: <?php echo $result['Kota_Pdkk'] ?></td>
        </tr>
		    <tr>
          <td>Tahun Lulus</td>
          <td>: <?php echo $result['Thn_Selesai'] ?></td>
          <td>NISS</td>
          <td>: <?php echo $result['NISN'] ?></td>
        </tr>
        <tr>
          <td colspan="4" align="center"><strong>INFORMASI PENDAFTARAN</strong></td>
          </tr>
        <tr>
          <td>Fakultas</td>
          <td>: <?php echo $pt; ?></td>
          <td>Program Studi</td>
          <td>: <?php echo $result['Prodi'] ?></td>
        </tr>
        <tr>
          <td>NIM</td>
          <td>: <?php echo $result['Nim'] ?></td>
          <td>Kelas/Program</td>
          <td>: <?php echo $kls; ?></td>
        </tr>
        <tr>
          <td>Tahun Akademik</td>
          <td>: <?php echo $result['TaMasuk'] ?> - <?php echo $result['PerMasuk'] ?></td>
          <td>Status Masuk</td>
          <td>: <?php echo $result['Status_Masuk'] ?></td>
        </tr>
        <tr>
          <td>Beasiswa</td>
          <td>: <?php echo $result['NamaBeasiswa'] ?></td>
          <td>Tgl Registrasi</td>
          <td>:  <?php echo date("d F Y", strtotime($result['tglDaftar']));?></td>
        </tr>   
        <tr>
          <td colspan="4" align="left"><strong>DOKUMEN PERSYARATAN :</strong>
        <ol>
          <li><a href="https://akademik.stmik-im.ac.id/views/uploads/<?php echo $result['Ktp'] ?>" target="_blank">KTP</a></li>
          <li><a href="https://akademik.stmik-im.ac.id/views/uploads/<?php echo $result['Ijazah'] ?>" target="_blank">Ijazah & Transkript</a></li>
          <li><a href="https://akademik.stmik-im.ac.id/views/uploads/<?php echo $result['KK'] ?>" target="_blank">Kartu Keluarga</a></li>
        </ol>       
        
        </td>
        </tr>     
        </table>
<i><b>Catatan</b> : Silahkan lengkapi data di portal mahasiswa https://akademik.stmik-im.ac.id</i>
<?php
$protocol = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http';
$host = $_SERVER['HTTP_HOST'];
$url = $_SERVER['REQUEST_URI'];
$full_url = $protocol . "://" . $host . $url;

$currentDate = getdate();
$year = $currentDate['year'];
$month = str_pad($currentDate['mon'], 2, '0', STR_PAD_LEFT); // Menambahkan nol di depan jika bulan hanya satu digit
$day = str_pad($currentDate['mday'], 2, '0', STR_PAD_LEFT); // Menambahkan nol di depan jika tanggal hanya satu digit

// Menyusun hasil dalam format "YYYY-MM-DD"
$xTanggal = "$year-$month-$day";
$id = "ADMISI".$xnim;
$xkunci = md5(time() . $id);
$xLink = $full_url;

$arraypesan = array(
'Jenis Dokumen' => 'PENDAFTARAN MAHASISWA BARU',
'Nama ' => $result['Nama_Mhs'],
'NIM' => $xnim,
'Program Studi' => $result['Prodi'],
'Informasi' => 'No Pendaftaran = ' . $result['Nopen'], 
'Ditandatangani oleh' => $result['Jabatan'].' : '.$result['Nama'],
'Tanggal Cetak' => date('d-m-Y H:i:s'),
);
$pesan = json_encode($arraypesan);
catatdoc($xkunci, $pesan, $xLink);
$urlverify = $protocol . "://" . $host . "/custom/verifikasi.php?kunci=" . $xkunci;
?>

	<table width="100%" class="table-no-border">
  <tbody>
    <tr>
      <td width="50%"><p>&nbsp;</p></td>
      <td width="50%"></td>
    </tr>
    
    <tr>
      <td align="center">
      <?php
        if (!empty($result['xphoto'])) {
      ?>
          <img src="https://akademik.stmik-im.ac.id/files/photo/<?php echo $result['xphoto'] ?>" height="130" alt="<?php echo $result['Nama_Mhs'] ?>">
      <?php
        }
      ?>
      </td>
      <td align="center">Bandung, <?php echo date("d F Y", strtotime($result['tglDaftar']));?> <br> <?php echo $result['Jabatan'] ?>,
      <?php
      #if ($kodefak === "T") { 
      ?> 

      <div align="center" id="x<?php echo $id;?>"></div>
        <script type="text/javascript">
           new QRCode(document.getElementById("x<?php echo $id;?>"), {
           text: "<?= $urlverify; ?>",
           width: 80,
           height: 80,
           colorDark: "#000000",
           colorLight: "#ffffff",
           correctLevel: QRCode.CorrectLevel.M
          });            
        </script>
      <?php 
       #} else {
        echo "<p>&nbsp; </p>";
       #}
      ?> 
      <br>
      (<u><b><?php echo $result['Nama'] ?>)</b></u>
      </td>
    </tr>
    <tr>
      <td>&nbsp;</td>
		<td align="center"></td>
    </tr>
    
  </tbody>
</table>	
</div>
<?php    
    } else {
        echo "Data pendaftaran tidak ditemukan.";
    }
  } catch (PDOException $e) {
    echo "Terjadi Kesalahan  : " . $e->getMessage();
  } 
  //akhir form pmb
?>
</section>


<?php
//Pemcetakan Pembayaran Admisi

// Query SQL untuk mendapatkan data berdasarkan NIM
$query = "SELECT pmb_Byr.Nopen, tblMHS.Nim, tblMHS.Nama_Mhs, tblMHS.Kode_jp, RTRIM(TblJurusan.Program)+' - '+RTRIM(TblJurusan.Jurusan) as Prodi, 
TblJurusan.Kode_Fak, tblMHS.JalurMasuk, tblMHS.TaMasuk, tblMHS.PerMasuk, tblMHS.Status_Akd, tblMHS.tglmasuk, tblMHS.Status_Masuk, 
pmb_Byr.tglDaftar, pmb_Byr.ByrDaftar, pmb_Byr.tglReg, pmb_Byr.ByrReg, pmb_Byr.tglReg1, pmb_Byr.ByrReg1, pmb_Byr.Konversi, tblDosen.Nama, tblPengesahanPMB.Jabatan 
FROM dbo.tblMHS INNER JOIN dbo.pmb_Byr ON tblMHS.Nopen = pmb_Byr.Nopen 
left JOIN dbo.TblJurusan ON tblMHS.Kode_jp = TblJurusan.Kode_Jp
LEFT JOIN dbo.tblPengesahanPMB ON tblMHS.TaMasuk = tblPengesahanPMB.Thn_Akademik AND tblMHS.PerMasuk = tblPengesahanPMB.Periode
LEFT JOIN dbo.tblDosen ON tblPengesahanPMB.NIDN = tblDosen.NIDN
WHERE tblMHS.Nim = :nim";
$stmt = $conn->prepare($query);
$stmt->bindParam(':nim', $xnim);
$stmt->execute();
$result = $stmt->fetch(PDO::FETCH_ASSOC);

if (isset($result['Kode_Fak'])) {
  $xfak = trim($result['Kode_Fak']);
} else {
  // Berikan pesan atau tindakan jika tidak ada data
  $xfak ='';
}

// Menampilkan hasil query
if ($result) {
  $mutasi = trim($result['Status_Masuk']);
  $jmlbayar = 0;
  $no = 0;
  if (trim($result['Kode_Fak']) === "T") {
    $kop = "kstmik.jpg";
   } else
   {
    $kop = "kstan.jpeg";
   }
 
?>
<section class="sheet padding-10mm" id="pembayaran">

<table width="100%" class="table-no-border">
<tbody>
<tr>
<td colspan="7" align="left"><img src="<?php echo $kop; ?>"  height="75" alt=""/><hr></td>
</tr>
<tr>
<td colspan="7" align="center">
<table width="100%" class="table-font">
  <tbody>
    <tr>
      <td align="center" ><strong><u>PEMBAYARAN REGISTRASI MAHASISWA BARU</u></strong></td>
    </tr>
  </tbody>
</table>
</td>
</tr>
<tr>      
<td width="17%">Nama</td>
<td width="1%">:</td>
<td width="34%"><?php echo $result['Nama_Mhs']; ?></td>
<td width="15%">Tahun Akademik</td>
<td width="1%">:</td>
<td width="32%"><?php echo $result['TaMasuk']; ?> - <?php echo $result['PerMasuk']; ?></td>
</tr>
<tr>     
<td>No. Registrasi</td>
<td>:</td>
<td><?php echo $result['Nopen']; ?></td>
<td>Program Studi</td>
<td>:</td>
<td><?php echo $result['Prodi']; ?></td>
</tr>
<tr>     
<td>Kelas/Program</td>
<td>:</td>
<td><?php echo $kls; ?></td>
<td>Baru/Mutasi</td>
<td>:</td>
<td><?php echo $result['Status_Masuk']; ?></td>
</tr>
</tbody>
</table>

<table width="100%" class="table-border-1">
  <tbody>
    <tr>
      <td width="5%" align="center">No</td>
      <td width="20%" align="center">Tanggal Bayar <br></td>
      <td width="50%" align="center">Item Pembayaran</td>      
      <td width="25%" align="center">Jumlah</td>      
    </tr>
    <?php if (!empty($result['ByrDaftar']) && $result['ByrDaftar'] > 0): $no +=1; ?>
    <tr>
      <td align="right"><?php echo $no; ?></td>
      <td align="center"><?php echo formatTanggal($result['tglDaftar']); ?></td>
      <td>Pendaftaran</td>      
      <td align="right"><?php echo number_format($result['ByrDaftar'], 0, ',', '.'); ?></td>
    </tr>
    <?php $jmlbayar += $result['ByrDaftar']; $tgl = $result['tglDaftar']; endif; ?>
    <?php if (!empty($result['ByrReg']) && $result['ByrReg'] > 0): $no +=1; ?>
    <tr>
      <td align="right"><?php echo $no; ?></td>
      <td align="center"><?php echo formatTanggal($result['tglReg']); ?></td>
      <td>Pembayaran Registrasi Ke 1</td>      
      <td align="right"><?php echo number_format($result['ByrReg'], 0, ',', '.'); ?></td>
    </tr>
    <?php $jmlbayar += $result['ByrReg']; $tgl = $result['tglReg']; endif; ?>
    <?php if (!empty($result['ByrReg1']) && $result['ByrReg1'] > 0): $no +=1; ?>
    <tr>
      <td align="right"><?php echo $no; ?></td>
      <td align="center"><?php echo formatTanggal($result['tglReg1']); ?></td>
      <td>Pembayaran Registrasi Ke 2</td>      
      <td align="right"><?php echo number_format($result['ByrReg1'], 0, ',', '.'); ?></td>
    </tr>
    <?php $jmlbayar += $result['ByrReg1']; $tgl = $result['tglReg1']; endif; ?>
    <?php if (!empty($result['Konversi']) && $result['Konversi'] > 0): $no +=1; ?>
    <tr>
      <td align="right"><?php echo $no; ?></td>
      <td align="center">-</td>
      <td>Biaya Konversi</td>      
      <td align="right"><?php echo number_format($result['Konversi'], 0, ',', '.'); ?></td>
    </tr>
    <?php $jmlbayar += $result['Konversi']; endif; ?>
    <tr>
      <td colspan="3" align="right">Total Bayar </td>
      <td align="right"><?php echo number_format($jmlbayar, 0, ',', '.'); ?></td>         
    </tr>
  </tbody>
</table>

<?php
$protocol = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http';
$host = $_SERVER['HTTP_HOST'];
$url = $_SERVER['REQUEST_URI'];
$full_url = $protocol . "://" . $host . $url;

$currentDate = getdate();
$year = $currentDate['year'];
$month = str_pad($currentDate['mon'], 2, '0', STR_PAD_LEFT); // Menambahkan nol di depan jika bulan hanya satu digit
$day = str_pad($currentDate['mday'], 2, '0', STR_PAD_LEFT); // Menambahkan nol di depan jika tanggal hanya satu digit

// Menyusun hasil dalam format "YYYY-MM-DD"
$xTanggal = "$year-$month-$day";
$id = "B-REG".$xnim;
$xkunci = md5(time() . $id);
$xLink = $full_url;

$arraypesan = array(
  'Jenis Dokumen' => 'PEMBAYARAN REGISTRASI MAHASISWA BARU ',
  'Tahun Akademik - Periode' =>$result['TaMasuk'].' '.$result['PerMasuk'],
  'Nama Mahasiswa' => $result['Nama_Mhs'],
  'Nomor Pendaftaran' => $result['Nopen'],
  'Program Studi' => $result['Prodi'],
  'Informasi' => 'Jumlah Pembayaran = ' . $jmlbayar, 
  'Ditandatangani oleh' => $result['Jabatan'].' : '.$result['Nama'],
  'Tanggal Cetak' => date('d-m-Y H:i:s'),
);
$pesan = json_encode($arraypesan);
catatdoc($xkunci, $pesan, $xLink);
$urlverify = $protocol . "://" . $host . "/custom/verifikasi.php?kunci=" . $xkunci;
?>
<table width="100%" class="table-no-border">
  <tbody>
    <tr>
      <td width="67%">&nbsp;</td>
      <td width="33%" align="center">Bandung, <?php echo formatTanggal($tgl);?> <br> 
      <?php echo $result['Jabatan'];?></td>
    </tr>
    
    <tr>
      <td>&nbsp;</td>
      <td>
      <?php
      #if (trim($xfak) === "T") { 
      ?> 
      <div align="center" id="x<?php echo $id;?>"></div>
          <script type="text/javascript">
             new QRCode(document.getElementById("x<?php echo $id;?>"), {
             text: "<?= $urlverify; ?>",
             width: 80,
             height: 80,
             colorDark: "#000000",
             colorLight: "#ffffff",
             correctLevel: QRCode.CorrectLevel.M
            });            
          </script>  
      <?php 
       #} else {
        #echo "<p>&nbsp; </p>";
       #}
      ?>  
     </td>
    </tr>
    <tr>
      <td>&nbsp;</td>
      <td align="center"><strong><?php echo $result['Nama'];?></strong></td>
    </tr>    
  </tbody>
</table>
</section>

<?php   
} else {
    echo "Data pembayaran tidak ditemukan.";
}

// Akhir pencetakan Struk Admisi
?>

<?php
// Awal Konversi Mahasiswa

 
$xquery = "select top 1 Nim, Nama_Mhs, Kode_jp, Prodi, Kode_Fak, Status_Masuk, Status_Akd, Jabatan, Nama, ttd, TaMasuk, PerMasuk, KPTSASAL, NMPTITBPTI, 
           PSASAL, NMPSTTBPST, tglKonversi, NoSuratKonversi, JENASAL, NIMASAL FROM IM_MhsKonversi WHERE Nim = :nim ";

try {
    
    // Eksekusi query menggunakan prepared statement
    $stmt = $conn->prepare($xquery);
    
    // Binding parameter
    $stmt->bindParam(':nim', $xnim, PDO::PARAM_STR);        
    
    // Eksekusi prepared statement
    $stmt->execute();
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
     $xfak = trim($row['Kode_Fak']);
     $xthn_akademik =  $row['TaMasuk'];
     $xperiode = $row['PerMasuk'];
     $ps = $row['Prodi'];     
     $xpjb = $row['Nama'];
     $xjab = $row['Jabatan'];
     $xtgl = $row['tglKonversi'];
     $xnama = $row['Nama_Mhs'];
     if (trim($row['JENASAL']) === "C") {
      $jj = "S1";
     } else {
      $jj = "D3";
     }


     if (trim($row['Kode_Fak']) === "T") {
      $kop = "kstmik.jpg";
     } else
     {
      $kop = "kstan.jpeg";
     }
        
?>
<section class="sheet padding-10mm">
<table width="100%" class="table-no-border">
<tbody>
<tr>
  <td colspan="7" align="left"><img src="<?php echo $kop; ?>"  height="75" alt=""/><hr></td>
</tr>
<tr>
  <td colspan="7" align="center">
<table width="100%" class="table-font" id="konversi">
    <tbody>
      <tr>
        <td align="center"><strong><u>KONVERSI NILAI MAHASISWA PINDAHAN</u></strong><br> Nomor : <?php echo $row['NoSuratKonversi']; ?></td>
      </tr>
    </tbody>
  </table>
</td>
</tr>
<tr>      
  <td width="17%">Nama Mahasiswa</td>
  <td width="1%">:</td>
  <td width="34%"><?php echo $row['Nama_Mhs']; ?></td>
  <td width="15%">Tahun Akademik</td>
  <td width="1%">:</td>
  <td width="32%"><?php echo $row['TaMasuk']; ?> - <?php echo $row['PerMasuk']; ?></td>
</tr>
<tr>     
  <td>NIM</td>
  <td>:</td>
  <td><?php echo $row['Nim']; ?></td>
  <td>Program Studi</td>
  <td>:</td>
  <td><?php echo $row['Prodi']; ?></td>
</tr>
<tr>     
  <td>Kelas/Program</td>
  <td>:</td>
  <td><?php echo $kls; ?></td>
  <td>NIM Asal</td>
  <td>:</td>
  <td><?php echo $row['NIMASAL']; ?></td>
</tr>
<tr>     
  <td>PT Asal</td>
  <td>:</td>
  <td><?php echo $row['NMPTITBPTI']; ?></td>
  <td>PS Asal</td>
  <td>:</td>
  <td><?php echo $jj." - ".$row['NMPSTTBPST']; ?></td>
</tr>
</tbody>
</table>
<?php
// Query untuk mengambil data dari Wali_Nilai dengan kondisi
$query = "SELECT 	tblkonv.Nim, tblkonv.mk_asal, tblkonv.sks_asal, tblkonv.nilai_asal, tblkonv.kode_mk, tblMK.Nama_Mk_Ind, tblMK.SKS, tblkonv.nilai 
FROM dbo.tblkonv INNER JOIN dbo.tblMK ON tblkonv.kode_mk = tblMK.Kode_MK WHERE tblkonv.Nim = :nim Order By mk_asal, sks_asal ";

try {
// Eksekusi query menggunakan prepared statement
$xstmt = $conn->prepare($query);

// Binding parameter
$xstmt->bindParam(':nim', $xnim, PDO::PARAM_STR);

// Eksekusi prepared statement
$xstmt->execute();

// Inisialisasi variabel untuk menghitung total SKS dan total mutu
$totalSKS = 0;
$no = 1;
?>

<table width="100%" class="table-border-1">
<tbody>
<tr>
  <td width="4%" rowspan="2" align="center">No</td>
  <td colspan="3" align="center">Matakuliah Asal</td>
  <td colspan="4" align="center">Matakuliah Hasil Konversi</td>
  </tr>
<tr>
  <td width="36%" align="center">Matakuliah</td>
  <td width="4%" align="center">SKS</td>
  <td width="4%" align="center">Nilai</td>
  <td width="8%" align="center">Kode</td>
  <td width="36%" align="center">Matakuliah</td>
  <td width="4%" align="center">SKS</td>
  <td width="4%" align="center">Nilai</td>        
</tr>
<?php
while ($row = $xstmt->fetch(PDO::FETCH_ASSOC)) {
  if ($no == 31) {
?>    
 </tbody></table> </section> <section class="sheet padding-10mm">
 <table width="100%" class="table-border-1"><tbody>
<tr>
  <td width="4%" rowspan="2" align="center">No</td>
  <td colspan="3" align="center">Matakuliah Asal</td>
  <td colspan="4" align="center">Matakuliah Hasil Konversi</td>
</tr>
<tr>
  <td width="36%" align="center">Matakuliah</td>
  <td width="4%" align="center">SKS</td>
  <td width="4%" align="center">Nilai</td>
  <td width="8%" align="center">Kode MK</td>
  <td width="36%" align="center">Matakuliah</td>
  <td width="4%" align="center">SKS</td>
  <td width="4%" align="center">Nilai</td>        
</tr>
<?php
  } 

?>
<tr>
  <td align="right"><?php echo $no; ?></td>
  <td><?php echo $row['mk_asal']; ?></td>
  <td align="center"><?php echo $row['sks_asal']; ?></td>
  <td align="center"><?php echo $row['nilai_asal']; ?></td>        
  <td align="center"><?php echo $row['kode_mk']; ?></td>
  <td><?php echo $row['Nama_Mk_Ind']; ?></td>
  <td align="center"><?php echo $row['SKS']; ?></td>
  <td align="center"><?php echo $row['nilai']; ?></td>  
</tr>
<?php

  // Menambahkan nilai SKS dan Mutu ke total
  $totalSKS += $row['SKS'];    
  $no += 1;
}  
} catch (PDOException $e) {
echo "Terjadi Kesalahan: " . $e->getMessage();
}
?>
</tbody>
</table><br>
<strong>
 Jumlah SKS yang di Konversikan = <?php echo $totalSKS; ?> dari <?php echo $no; ?> Matakuliah
</strong>
<?php
$protocol = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http';
$host = $_SERVER['HTTP_HOST'];
$url = $_SERVER['REQUEST_URI'];
$full_url = $protocol . "://" . $host . $url;

$currentDate = getdate();
$year = $currentDate['year'];
$month = str_pad($currentDate['mon'], 2, '0', STR_PAD_LEFT); // Menambahkan nol di depan jika bulan hanya satu digit
$day = str_pad($currentDate['mday'], 2, '0', STR_PAD_LEFT); // Menambahkan nol di depan jika tanggal hanya satu digit

// Menyusun hasil dalam format "YYYY-MM-DD"
$xTanggal = "$year-$month-$day";
$id = "KONVERSI".$xnim;
$xkunci = md5(time() . $id);
$xLink = $full_url;

$arraypesan = array(
'Jenis Dokumen' => 'KONVERSI NILAI MAHASISWA PINDAHAN',
'Tahun Akademik - Periode' => $xthn_akademik.' '.$xperiode,
'Nama Mahasiswa' => $xnama,
'NIM' => $xnim,
'Program Studi' => $ps,
'Informasi' => 'Jumlah SKS = ' . $totalSKS, 
'Ditandatangani oleh' => $xjab.' : '.$xpjb,
'Tanggal Cetak' => date('d-m-Y H:i:s'),
);
$pesan = json_encode($arraypesan);
catatdoc($xkunci, $pesan, $xLink);
$urlverify = $protocol . "://" . $host . "/custom/verifikasi.php?kunci=" . $xkunci;
?>



<table width="100%" class="table-no-border">
<tbody>
<tr>
  <td width="67%">&nbsp;</td>
  <td width="33%" align="center">Bandung, <?php echo formatTanggal($xtgl);?> <br> 
  <?php echo ($xjab);?></td>
</tr>

<tr>
  <td>&nbsp;
  </td>
  <td>
  <?php
    #  if (trim($xfak) === "T") { 
  ?>
  <div align="center" id="x<?php echo $id;?>"></div>
      <script type="text/javascript">
         new QRCode(document.getElementById("x<?php echo $id;?>"), {
         text: "<?= $urlverify; ?>",
         width: 80,
         height: 80,
         colorDark: "#000000",
         colorLight: "#ffffff",
         correctLevel: QRCode.CorrectLevel.M
        });            
      </script>  
     <?php 
     #  } else {
     #   echo "<p>&nbsp; </p>";
     #  }
      ?> 

  </td>
</tr>
<tr>
  <td>&nbsp;</td>
  <td align="center"><strong><?php echo ($xpjb);?></strong></td>
</tr>    
</tbody>
</table>
</section>
<?php
}

} catch (PDOException $e) {
echo "Terjadi Kesalahan: " . $e->getMessage();
} 

 //Akhir Konversi
?>

<?php
    //Awal Keuangan
  // Query untuk mengambil data dari Mhs Keu dengan kondisi Nim      
  $xquery = "select Nim, Nama_Mhs, Kode_Jp, Prodi, Kode_Fak, Status_Akd, Status_Masuk, TaMasuk, PerMasuk, Status, JalurMasuk, NamaPejabat, Pejabat from IM_MhsKeu WHERE Nim = :nim ";
  try {      
      // Eksekusi query menggunakan prepared statement
      $stmt = $conn->prepare($xquery);
      
      // Binding parameter
      $stmt->bindParam(':nim', $xnim, PDO::PARAM_STR);        
      
      // Eksekusi prepared statement
      $stmt->execute();
      while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
       
       $ps = $row['Prodi'];       
       $xpjb = $row['NamaPejabat'];
       $xjab = $row['Pejabat'];       
       $xnama = $row['Nama_Mhs'];
       $xfak  = trim($row['Kode_Fak']);

       if (trim($row['Kode_Fak']) === "T") {
        $kop = "kstmik.jpg";
       } else
       {
        $kop = "kstan.jpeg";
       }       
?>
<section class="sheet padding-10mm">
<table width="100%" class="table-no-border">
<tbody>
  <tr>
    <td colspan="7" align="left"><img src="<?php echo $kop; ?>"  height="75" alt=""/><hr></td>
  </tr>
  <tr>
    <td colspan="7" align="center">
  <table width="100%" class="table-font" id="riwayatbyr">
      <tbody>
        <tr>
          <td align="center"><strong><u>RIWAYAT PEMBAYARAN BIAYA PENDIDIKAN</u></strong></td>
        </tr>
      </tbody>
    </table>
</td>
  </tr>
  <tr>      
    <td width="17%">Nama Mahasiswa</td>
    <td width="1%">:</td>
    <td width="34%"><?php echo $row['Nama_Mhs']; ?></td>
    <td width="15%">Angkatan </td>
    <td width="1%">:</td>
    <td width="32%"><?php echo $row['TaMasuk']; ?></td>
  </tr>
  <tr>     
    <td>NIM</td>
    <td>:</td>
    <td><?php echo $row['Nim']; ?></td>
    <td>Program Studi</td>
    <td>:</td>
    <td><?php echo $row['Prodi']; ?></td>
  </tr>
</tbody>
</table><br>
<?php

// Query SQL untuk mendapatkan data berdasarkan NIM
$query = "SELECT tahunakd, periode, kditem, itembayar, jmlbyr, tglbayar, operator, keterangan FROM keu_ekpt WHERE NIM = :nim order by tahunakd, periode,tglbayar ";
$stmt = $conn->prepare($query);
$stmt->bindParam(':nim', $xnim);
$stmt->execute();
$data = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Array untuk menyimpan subtotal setiap kelompok tahunakd, periode
$subtotals = array();

// Inisialisasi grand total
$grandTotal = 0;

foreach ($data as $row) {
    $tahunakd = trim($row['tahunakd']);
    $periode = trim($row['periode']);
    $kditem = $row['kditem'];
    $itembayar = $row['itembayar'];
    $jmlbyr = $row['jmlbyr'];
    $tglbayar = formatTanggal($row['tglbayar']); // Mengubah format tanggal
    $operator = $row['operator'];
    $keterangan = $row['keterangan'];

// Menghitung subtotal untuk setiap kelompok tahunakd, periode
$key = "$tahunakd-$periode";
if (!isset($subtotals[$key]['subtotal'])) {
    $subtotals[$key]['subtotal'] = 0;
}
$subtotals[$key]['subtotal'] += $jmlbyr;
$subtotals[$key]['data'][] = array(
    'kditem' => $kditem,
    'itembayar' => $itembayar,
    'jmlbyr' => $jmlbyr,
    'tglbayar' => $tglbayar,
    'operator' => $operator,
    'keterangan' => $keterangan
);

    // Menambahkan jumlah bayar ke grand total
    $grandTotal += $jmlbyr;
}
$stmt->closeCursor();
$grp = 1;
// Memulai tabel untuk setiap kelompok
foreach ($subtotals as $key => $subgroup) {
    list($tahunakd, $periode) = explode("-", $key);    
    echo "<strong>Tahun Akademik: $tahunakd - $periode </strong>";
    echo "<table width='100%' class='table-border-1'>";
    echo "<tr>
			<th width='5%' >No</th>
			<th width='7%'>Kode</th>
			<th width='23%'>Item Bayar</th>
			<th width='15%'>Jumlah Bayar</th>
			<th width='15%'>Tanggal</th>
			<th width='10%'>Operator</th>
			<th width='25%'>Keterangan</th>
		 </tr>";

    // Inisialisasi nomor urut
    $grp +=1;
    $nomor = 1;

    // Menampilkan data untuk setiap kelompok
    foreach ($subgroup['data'] as $subrow) {
        echo "<tr>";
        echo "<td align='right'>" . $nomor++ . "</td>";
        echo "<td align='center'>{$subrow['kditem']}</td>";
        echo "<td>{$subrow['itembayar']}</td>";
        echo "<td align='right'>".number_format($subrow['jmlbyr'], 0, ',', '.')."</td>";
        echo "<td align='center'>".$subrow['tglbayar']."</td>";
        echo "<td>{$subrow['operator']}</td>";
        echo "<td>{$subrow['keterangan']}</td>";
        echo "</tr>";
    }

 // Tambahkan baris subtotal jika 'subtotal' tersedia
if (array_key_exists('subtotal', $subgroup)) {
    echo "<tr><td colspan='2'></td><td><strong>Subtotal</strong></td><td align='right'>".number_format($subgroup['subtotal'], 0, ',', '.')."</td><td  colspan='3'>&nbsp;</td></tr>";
}

    // Menutup tabel untuk setiap kelompok
    echo "</table><br>";
    if ($grp == 6){
      echo "</section>";
      echo  "<section class='sheet padding-10mm'>";

    }
}

// Menampilkan grand total di luar semua tabel
?>
<strong>
 Jumlah Total Pembayaran : = <?php echo number_format($grandTotal, 0, ',', '.'); ?>
</strong>

<?php
$protocol = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http';
$host = $_SERVER['HTTP_HOST'];
$url = $_SERVER['REQUEST_URI'];
$full_url = $protocol . "://" . $host . $url;

$currentDate = getdate();
$year = $currentDate['year'];
$month = str_pad($currentDate['mon'], 2, '0', STR_PAD_LEFT); // Menambahkan nol di depan jika bulan hanya satu digit
$day = str_pad($currentDate['mday'], 2, '0', STR_PAD_LEFT); // Menambahkan nol di depan jika tanggal hanya satu digit

// Menyusun hasil dalam format "YYYY-MM-DD"
$xTanggal = "$year-$month-$day";
$id = "KEU".$xnim;
$xkunci = md5(time() . $id);
$xLink = $full_url;

$arraypesan = array(
'Jenis Dokumen' => 'RIWAYAT PEMBAYARAN BIAYA PENDIDIKAN',
'Nama Mahasiswa' => $xnama,
'NIM' => $xnim,
'Program Studi' => $ps,
'Informasi' => 'Jumlah Total Pembayaran = ' . number_format($grandTotal, 0, ',', '.'), 
'Ditandatangani oleh' => $xjab.' : '.$xpjb,
'Tanggal Cetak' => date('d-m-Y H:i:s'),
);
$pesan = json_encode($arraypesan);
catatdoc($xkunci, $pesan, $xLink);
$urlverify = $protocol . "://" . $host . "/custom/verifikasi.php?kunci=" . $xkunci;
?>

<table width="100%" class="table-no-border">
<tbody>
  <tr>
    <td width="67%">&nbsp;</td>
    <td width="33%" align="center">Bandung, <?php echo formatTanggal(date('Y-m-d'));?> <br> 
    <?php echo ($xjab);?></td>
  </tr>
  
  <tr>
    <td>&nbsp;</td>
    <td>
    <?php
     # if (trim($xfak) === "T") { 
    ?> 
    <div align="center" id="x<?php echo $id;?>"></div>
        <script type="text/javascript">
           new QRCode(document.getElementById("x<?php echo $id;?>"), {
           text: "<?= $urlverify; ?>",
           width: 80,
           height: 80,
           colorDark: "#000000",
           colorLight: "#ffffff",
           correctLevel: QRCode.CorrectLevel.M
          });            
        </script>  
      <?php 
      # } else {
      #  echo "<p>&nbsp; </p>";
      # }
      ?> 

    </td>
  </tr>
  <tr>
    <td>&nbsp;</td>
    <td align="center"><strong><?php echo ($xpjb);?></strong></td>
  </tr>    
</tbody>
</table>
</section>
<?php

}
} catch (PDOException $e) {
  echo "Terjadi Kesalahan  : " . $e->getMessage();
} 

//Akhir Keuangan






  //Awal KRS
  // Query untuk mengambil data dari KRS dengan kondisi Nim    
    $xquery = "Select Thn_Akademik, Periode, Nim, Nama_Mhs, Tgl_Prw, NIDNKRS, JabatanKRS, TanggalKRS, ttdKRS, Kode_jp, Rtrim(Program)+' - '+Rtrim(Jurusan) as Prodi, Kode_Fak, NamaKRS from IM_KHS_KRS WHERE (Periode in ('1','2','3','SP')) AND (Nim = :nim) ";

    try {
        $grp = 1;
        // Eksekusi query menggunakan prepared statement
        $stmt = $conn->prepare($xquery);
        
        // Binding parameter
        $stmt->bindParam(':nim', $xnim, PDO::PARAM_STR);        
        
        // Eksekusi prepared statement
        $stmt->execute();
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
         $xthn_akademik =  $row['Thn_Akademik'];
         $xperiode = $row['Periode'];
         $ps = $row['Prodi'];
         $xnidn = $row['NIDNKRS'];
         $xpjb = $row['NamaKRS'];
         $xjab = $row['JabatanKRS'];
         $xtgl = $row['TanggalKRS'];
         $xnama = $row['Nama_Mhs'];
         $xfak = $row['Kode_Fak'];

         if (trim($row['Kode_Fak']) === "T") {
          $kop = "kstmik.jpg";
         } else
         {
          $kop = "kstan.jpeg";
         }

         if ($grp % 2 != 0){
          echo '<section class="sheet padding-10mm">';
          $tutup = 0;
          }
         
?>
<table width="100%" class="table-no-border" id="KRS">
  <tbody>
    <tr>
      <td colspan="7" align="left"><img src="<?php echo $kop; ?>"  height="75" alt=""/><hr></td>
    </tr>
    <tr>
      <td colspan="7" align="center">
		<table width="100%" class="table-font">
        <tbody>
          <tr>
            <td align="center"><strong><u>KARTU RENCANA STUDI</u></strong></td>
          </tr>
        </tbody>
      </table>
	</td>
    </tr>
    <tr>      
      <td width="17%">Nama Mahasiswa</td>
      <td width="1%">:</td>
      <td width="34%"><?php echo $row['Nama_Mhs']; ?></td>
      <td width="15%">Tahun Akademik</td>
      <td width="1%">:</td>
      <td width="32%"><?php echo $row['Thn_Akademik']; ?> - <?php echo $row['Periode']; ?></td>
    </tr>
    <tr>     
      <td>NIM</td>
      <td>:</td>
      <td><?php echo $row['Nim']; ?></td>
      <td>Program Studi</td>
      <td>:</td>
      <td><?php echo $row['Prodi']; ?></td>
    </tr>
  </tbody>
</table>
<?php
// Query untuk mengambil data dari Wali_Nilai dengan kondisi
$query = "Select Nim, Kode_MK, Nama_Mk_Ind, SKS, Nilai, Angka, Mutu from Wali_Nilai WHERE Nim = :nim AND Thn_Akademik = :thn_akademik AND Periode = :periode";
try {
    // Eksekusi query menggunakan prepared statement
    $xstmt = $conn->prepare($query);
    
    // Binding parameter
    $xstmt->bindParam(':nim', $xnim, PDO::PARAM_STR);
    $xstmt->bindParam(':thn_akademik', $xthn_akademik, PDO::PARAM_STR);
    $xstmt->bindParam(':periode', $xperiode, PDO::PARAM_STR);
    
    // Eksekusi prepared statement
    $xstmt->execute();

    // Inisialisasi variabel untuk menghitung total SKS dan total mutu
    $totalSKS = 0;
    $totalMutu = 0;
    $no = 1;
?>

  <table width="100%" class="table-border-1">
  <tbody>
    <tr>
      <td width="5%" align="center">No</td>
      <td width="12%" align="center">Kode <br></td>
      <td width="50%" align="center">Nama Matakuliah</td>
      <td width="5%" align="center">SKS</td>
      <td width="28%" align="center">Keterangan</td>      
    </tr>
<?php
 while ($row = $xstmt->fetch(PDO::FETCH_ASSOC)) {

?>
    <tr>
      <td align="right"><?php echo $no; ?></td>
      <td align="center"><?php echo $row['Kode_MK']; ?></td>
      <td><?php echo $row['Nama_Mk_Ind']; ?></td>
      <td align="center"><?php echo $row['SKS']; ?></td>      
      <td align="center">&nbsp;</td>
    </tr>
<?php
      // Menambahkan nilai SKS dan Mutu ke total
      $totalSKS += $row['SKS'];     
      $no += 1;
  }  
  
} catch (PDOException $e) {
  echo "Terjadi Kesalahan: " . $e->getMessage();
}
?>
    <tr>
      <td colspan="3" align="right">Jumlah SKS </td>
      <td align="center"><?php echo $totalSKS; ?></td>
      <td>&nbsp;</td>
     
    </tr>
  </tbody>
</table>
  <?php
$protocol = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http';
$host = $_SERVER['HTTP_HOST'];
$url = $_SERVER['REQUEST_URI'];
$full_url = $protocol . "://" . $host . $url;

$currentDate = getdate();
$year = $currentDate['year'];
$month = str_pad($currentDate['mon'], 2, '0', STR_PAD_LEFT); // Menambahkan nol di depan jika bulan hanya satu digit
$day = str_pad($currentDate['mday'], 2, '0', STR_PAD_LEFT); // Menambahkan nol di depan jika tanggal hanya satu digit

// Menyusun hasil dalam format "YYYY-MM-DD"
$xTanggal = "$year-$month-$day";
$id = "KRS".$xnim.$xthn_akademik.$xperiode;
$xkunci = md5(time() . $id);
$xLink = $full_url;

$arraypesan = array(
  'Jenis Dokumen' => 'KARTU RENCANA STUDI',
  'Tahun Akademik - Periode' => $xthn_akademik.' '.$xperiode,
  'Nama Mahasiswa' => $xnama,
  'NIM' => $xnim,
  'Program Studi' => $ps,
  'Informasi' => 'Jumlah SKS = ' . $totalSKS, 
  'Ditandatangani oleh' => $xjab.' : '.$xpjb,
  'Tanggal Cetak' => date('d-m-Y H:i:s'),
);
$pesan = json_encode($arraypesan);
catatdoc($xkunci, $pesan, $xLink);
$urlverify = $protocol . "://" . $host . "/custom/verifikasi.php?kunci=" . $xkunci;
?>



<table width="100%" class="table-no-border">
  <tbody>
    <tr>
      <td width="67%">&nbsp;</td>
      <td width="33%" align="center">Bandung, <?php echo formatTanggal($xtgl);?> <br> 
      <?php echo ($xjab);?></td>
    </tr>
    
    <tr>
      <td>&nbsp;</td>
      <td>
      <?php
     # if (trim($xfak) === "T") { 
      ?>
      <div align="center" id="x<?php echo $id;?>"></div>
          <script type="text/javascript">
             new QRCode(document.getElementById("x<?php echo $id;?>"), {
             text: "<?= $urlverify; ?>",
             width: 80,
             height: 80,
             colorDark: "#000000",
             colorLight: "#ffffff",
             correctLevel: QRCode.CorrectLevel.M
            });            
          </script>  
      <?php 
      # } else {
      #  echo "<p>&nbsp; </p>";
      # }
      ?> 
      </td>
    </tr>
    <tr>
      <td>&nbsp;</td>
      <td align="center"><strong><?php echo ($xpjb);?></strong></td>
    </tr>    
  </tbody>
</table>

<?php

if ($grp % 2 == 0){
echo '</section>';
$tutup = 1;
} else {
  echo '<hr class="dashed-hr"><br>';
  }


$grp = $grp + 1;

}
if ($tutup==0) {
  echo '</section>';
}

  } catch (PDOException $e) {
    echo "Terjadi Kesalahan: " . $e->getMessage();
  } 

//Akhir KRS  

// Awal KHS

// Query untuk mengambil data dari KHS dengan kondisi Nim    
$xquery = "Select Thn_Akademik, Periode, Nim, Nama_Mhs, Tgl_Prw, NIDNKHS, JabatanKHS, TanggalKHS, ttdKHS, Kode_jp, Rtrim(Program)+' - '+Rtrim(Jurusan) as Prodi, Kode_Fak, NamaKHS from IM_KHS_KRS WHERE  (Periode in ('1','2','3','SP')) AND (Nim = :nim) ";

try {
    $grp = 1;
    // Eksekusi query menggunakan prepared statement
    $stmt = $conn->prepare($xquery);
    
    // Binding parameter
    $stmt->bindParam(':nim', $xnim, PDO::PARAM_STR);        
    
    // Eksekusi prepared statement
    $stmt->execute();
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
     $xthn_akademik =  $row['Thn_Akademik'];
     $xperiode = $row['Periode'];
     $ps = $row['Prodi'];
     $xnidn = $row['NIDNKHS'];
     $xpjb = $row['NamaKHS'];
     $xjab = $row['JabatanKHS'];
     $xtgl = $row['TanggalKHS'];
     $xnama = $row['Nama_Mhs'];
     $xfak = $row['Kode_Fak'];

     if (trim($row['Kode_Fak']) === "T") {
      $kop = "kstmik.jpg";
     } else
     {
      $kop = "kstan.jpeg";
     }
     if ($grp % 2 != 0){
      echo '<section class="sheet padding-10mm">';
      $tutup = 0;
      }
     
?>
<table width="100%" class="table-no-border" id="KHS">
<tbody>
<tr>
  <td colspan="7" align="left"><img src="<?php echo $kop; ?>"  height="75" alt=""/><hr></td>
</tr>
<tr>
  <td colspan="7" align="center">
<table width="100%" class="table-font">
    <tbody>
      <tr>
        <td align="center"><strong><u>KARTU HASIL STUDI</u></strong></td>
      </tr>
    </tbody>
  </table>
</td>
</tr>
<tr>      
  <td width="17%">Nama Mahasiswa</td>
  <td width="1%">:</td>
  <td width="34%"><?php echo $row['Nama_Mhs']; ?></td>
  <td width="15%">Tahun Akademik</td>
  <td width="1%">:</td>
  <td width="32%"><?php echo $row['Thn_Akademik']; ?> - <?php echo $row['Periode']; ?></td>
</tr>
<tr>     
  <td>NIM</td>
  <td>:</td>
  <td><?php echo $row['Nim']; ?></td>
  <td>Program Studi</td>
  <td>:</td>
  <td><?php echo $row['Prodi']; ?></td>
</tr>
</tbody>
</table>
<?php
// Query untuk mengambil data dari Wali_Nilai dengan kondisi
$query = "Select Nim, Kode_MK, Nama_Mk_Ind, SKS, Nilai, Angka, Mutu, Kehadiran, Tugas, UTS, UAS, Jumlah from Wali_Nilai WHERE Nim = :nim AND Thn_Akademik = :thn_akademik AND Periode = :periode";
try {
// Eksekusi query menggunakan prepared statement
$xstmt = $conn->prepare($query);

// Binding parameter
$xstmt->bindParam(':nim', $xnim, PDO::PARAM_STR);
$xstmt->bindParam(':thn_akademik', $xthn_akademik, PDO::PARAM_STR);
$xstmt->bindParam(':periode', $xperiode, PDO::PARAM_STR);

// Eksekusi prepared statement
$xstmt->execute();

// Inisialisasi variabel untuk menghitung total SKS dan total mutu
$totalSKS = 0;
$totalMutu = 0;
$hdr = 0;
$no = 1;
?>

<table width="100%" class="table-border-1">
<tbody>
<tr>
  <td width="4%" align="center">No</td>
  <td width="10%" align="center">Kode <br></td>
  <td width="42%" align="center">Nama Matakuliah</td>
  <td width="4%" align="center">SKS</td>
  <td width="5%" align="center">HDR</td>
  <td width="5%" align="center">TGS</td>
  <td width="5%" align="center">UTS</td>
  <td width="5%" align="center">UAS</td>
  <td width="5%" align="center">JML</td>
  <td width="5%" align="center">Nilai</td>      
  <td width="5%" align="center">Bobot</td>      
  <td width="5%" align="center">Mutu</td>      
</tr>
<?php
while ($row = $xstmt->fetch(PDO::FETCH_ASSOC)) {

?>
<tr>
  <td align="right"><?php echo $no; ?></td>
  <td align="center"><?php echo $row['Kode_MK']; ?></td>
  <td><?php echo $row['Nama_Mk_Ind']; ?></td>
  <td align="center"><?php echo $row['SKS']; ?></td>    
  <td align="center"><?php echo round($row['Kehadiran'],2); ?></td>    
  <td align="center"><?php echo round($row['Tugas'],2); ?></td>    
  <td align="center"><?php echo round($row['UTS'],2); ?></td>    
  <td align="center"><?php echo round($row['UAS'],2); ?></td>    
  <td align="center"><?php echo round($row['Jumlah'],2); ?></td>         
  <td align="center"><?php echo $row['Nilai']; ?></td>
  <td align="center"><?php echo $row['Angka']; ?></td>
  <td align="center"><?php echo $row['Mutu']; ?></td>
  
</tr>
<?php
  // Menambahkan nilai SKS dan Mutu ke total
  $totalSKS += $row['SKS'];  
  $totalMutu +=  $row['Mutu']; 
  $hdr +=  $row['Kehadiran']; 
  $no += 1;
}  

} catch (PDOException $e) {
echo "Terjadi Kesalahan: " . $e->getMessage();
}
?>
<tr>
  <td colspan="3" align="right">Jumlah</td>
  <td align="center"><?php echo $totalSKS; ?></td>
  <td>
  <?php
    if ($no - 1 != 0) {
    echo round($hdr/($no-1),2);
    } else {
    echo "-";
    }
?>

  </td>
  <td>&nbsp;</td>
  <td>&nbsp;</td>
  <td>&nbsp;</td>
  <td>&nbsp;</td>
  <td>&nbsp;</td>
  <td>&nbsp;</td>
  <td  align="center"><?php echo $totalMutu; ?></td>
 
</tr>
</tbody>
</table>

<?php
if ($totalSKS != 0) {
    $ips = $totalMutu / $totalSKS;
} else {
    $ips = "0";
}
?>
<strong>
 Index Prestasi Sementara (IPS) = <?php echo $totalMutu; ?> / <?php echo $totalSKS; ?> : <?php echo number_format(ceil($ips * 100) / 100, 2, ',', '.'); ?>
</strong>
<?php
$protocol = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http';
$host = $_SERVER['HTTP_HOST'];
$url = $_SERVER['REQUEST_URI'];
$full_url = $protocol . "://" . $host . $url;

$currentDate = getdate();
$year = $currentDate['year'];
$month = str_pad($currentDate['mon'], 2, '0', STR_PAD_LEFT); // Menambahkan nol di depan jika bulan hanya satu digit
$day = str_pad($currentDate['mday'], 2, '0', STR_PAD_LEFT); // Menambahkan nol di depan jika tanggal hanya satu digit

// Menyusun hasil dalam format "YYYY-MM-DD"
$xTanggal = "$year-$month-$day";
$id = "KHS".$xnim.$xthn_akademik.$xperiode;
$xkunci = md5(time() . $id);
$xLink = $full_url;

$arraypesan = array(
'Jenis Dokumen' => 'KARTU HASIL STUDI',
'Tahun Akademik - Periode' => $xthn_akademik.' - '.$xperiode,
'Nama Mahasiswa' => $xnama,
'NIM' => $xnim,
'Program Studi' => $ps,
'Informasi' => 'Jumlah SKS = ' . $totalSKS . ' IPS = '.round($ips,2), 
'Ditandatangani oleh' => $xjab.' : '.$xpjb,
'Tanggal Cetak' => date('d-m-Y H:i:s'),
);
$pesan = json_encode($arraypesan);
catatdoc($xkunci, $pesan, $xLink);
$urlverify = $protocol . "://" . $host . "/custom/verifikasi.php?kunci=" . $xkunci;
?>



<table width="100%" class="table-no-border">
<tbody>
<tr>
  <td width="67%">&nbsp;</td>
  <td width="33%" align="center">Bandung, <?php echo formatTanggal($xtgl);?> <br> 
  <?php echo ($xjab);?></td>
</tr>

<tr>
  <td>Penilaian : <br>
  A=4; B=3; C=2; D=1; E=0; 
  </td>
  <td>
  
  <?php
  # if (trim($xfak) === "T") { 
  ?>
  <div align="center" id="x<?php echo $id;?>"></div>
      <script type="text/javascript">
         new QRCode(document.getElementById("x<?php echo $id;?>"), {
         text: "<?= $urlverify; ?>",
         width: 80,
         height: 80,
         colorDark: "#000000",
         colorLight: "#ffffff",
         correctLevel: QRCode.CorrectLevel.M
        });            
      </script>  
   <?php
   #} else {

    #echo "<p>&nbsp; </p>";

   #}

   ?>   
  </td>
</tr>
<tr>
  <td>&nbsp;</td>
  <td align="center"><strong><?php echo ($xpjb);?></strong></td>
</tr>    
</tbody>
</table>

<?php

if ($grp % 2 == 0){
echo '</section>';
$tutup = 1;
} else {
echo '<hr class="dashed-hr"><br>';
}


$grp = $grp + 1;

}
if ($tutup==0) {
echo '</section>';
}

} catch (PDOException $e) {
echo "Terjadi Kesalahan: " . $e->getMessage();
} 

//Akhir KHS


 //Awal Berita Acara Sidan


 
 $xquery = "Select TOP 1 Tahun_akd, Periode, Nim, Nama_Mhs, Judul, ttdPembimbing, Pembimbing, ttdPenguji1, Penguji1, ttdPenguji2, Penguji2, TGL_sidang, Jam_Sidang, Ruangan, Info_Link, BerkasTA, Prodi, Kode_Fak, Jabatan, Nama, BerkasTA from Sidang_Jadwal WHERE Nim = :nim ";

 try {
 
 // Eksekusi query menggunakan prepared statement
 $stmt = $conn->prepare($xquery);
 
 // Binding parameter
 $stmt->bindParam(':nim', $xnim, PDO::PARAM_STR);        
 
 // Eksekusi prepared statement
 $stmt->execute();
 while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
 $xthn_akademik =  $row['Tahun_akd'];
 $xperiode = $row['Periode'];
 $ps = $row['Prodi'];     
 $xpjb = $row['Nama'];
 $xjab = $row['Jabatan'];
 $xtgl = $row['TGL_sidang'];
 $xnama = $row['Nama_Mhs'];
 $pbb =  $row['Pembimbing'];
 $pj1 =  $row['Penguji1'];
 $pj2 =  $row['Penguji2'];
 $ttdpbb =  $row['ttdPembimbing'];
 $ttdpj1 =  $row['ttdPenguji1'];
 $ttdpj2 =  $row['ttdPenguji2'];
 $xfak = trim($row['Kode_Fak']);
 
 
if (trim($row['Kode_Fak']) === "T") {
 $kop = "kstmik.jpg";
 $fak = "STMIK IM";
 } else
 {
 $kop = "kstan.jpeg";
 $fak = "STIE STAN-IM";
 }
 
 ?>
 <section class="sheet padding-10mm">
 <table width="100%" class="table-no-border">
 <tbody>
 <tr>
 <td colspan="7" align="left"><img src="<?php echo $kop; ?>"  height="75" alt=""/><hr></td>
 </tr>
 <tr>
 <td colspan="7" align="center">
 <table width="100%" class="table-font">
 <tbody>
 <tr>
 <td align="center" id="SIDANG"><strong><u>BERITA ACARA SIDANG TUGAS AKHIR/ SKRIPSI</u></strong></td>
 </tr>
 <tr>
 <td style="text-align: justify">
 <p>Pada hari ini, tanggal <?php echo formatTanggal($xtgl); ?> Jam <?php echo substr($row['Jam_Sidang'], 0, 5);?>, telah dilaksanakan sidang tugas akhir/skripsi di <?php echo $fak; ?>, untuk peserta sebagai berikut :</p>
 <table width="100%" border="0" cellspacing="0" cellpadding="0">
   <tbody>
     <tr>
       <td width="17%">Nama Mahasiswa</td>
       <td width="1%">:</td>
       <td width="82%"><?php echo $row['Nama_Mhs'];?> - <?php echo $row['Nim'];?></td>
     </tr>     
     <tr>
       <td>Program Studi</td>
       <td>:</td>
       <td><?php echo $row['Prodi'];?></td>
     </tr>
     <tr>
       <td valign="top">Judul Skripsi/TA</td>
       <td valign="top">:</td>
       <td  ><?php echo $row['Judul'];?></td>
     </tr>
     <tr>
       <td valign="top">Berkas </td>
       <td valign="top">:</td>
       <td ><a href="https://sidang.imandiri.id/admin/uploads/berkas/<?php echo$row['BerkasTA'];?>" target="_blank"> <?php echo$row['BerkasTA'];?> </a></td>
     </tr>
     <tr>
       <td>Tempat/Ruangan</td>
       <td>:</td>
       <td><?php echo $row['Ruangan'];?></td>
     </tr>
     <tr>
       <td valign="top">Keterangan</td>
       <td valign="top">:</td>
       <td style="text-align: left"><?php echo $row['Info_Link'];?></td>
     </tr>
   </tbody>
 </table><br>
 Pada agenda sidang tersebut, dihadiri oleh :
 <ol>
   <li><?php echo $row['Pembimbing'];?>, Sebagai Pembimbing</li>
   <li><?php echo $row['Penguji1'];?>, Sebagai Penguji 1</li>
   <li><?php echo $row['Penguji2'];?>, Sebagai Penguji 2</li>
 </ol>
 <p>Setelah mendengarkan presentasi dan diskusi yang disampaikan oleh mahasiswa, kami sebagai dosen penguji dan pembimbing memberikan penilaian terhadap empat unsur sebagai berikut:</p>
 </td>
 </tr>
 </tbody>
 </table>
 </td>
 </tr>
 </tbody>
 </table>
 <?php
 // Query untuk mengambil data dari Nilai Sidang
 $query = "SELECT Nilai, Pembimbing, Penguji1,Penguji2 FROM dbo.Sidang_BaNilai(:nim);";
 
 try {
 // Eksekusi query menggunakan prepared statement
 $xstmt = $conn->prepare($query);
 
 // Binding parameter
 $xstmt->bindParam(':nim', $xnim, PDO::PARAM_STR);
 
 // Eksekusi prepared statement
 $xstmt->execute();
 
 // Inisialisasi variabel untuk menghitung total SKS dan total mutu
 $Pembimbing = 0;
 $Penguji1 = 0;
 $Penguji2 = 0;
 $no = 1;
 ?>
 
 <table width="100%" class="table-border-1">
   <tbody>
     <tr>
       <td width="4%" rowspan="2" style="text-align: center">No</td>
       <td width="60%" rowspan="2">Unsur Penilaian</td>
       <td colspan="3" style="text-align: center">Penilaian</td>
     </tr>
     <tr>
       <td width="12%" style="text-align: center">Pembimbing</td>
       <td width="12%" style="text-align: center">Penguji 1</td>
       <td width="12%" style="text-align: center">Penguji 2</td>
     </tr>  
 <?php
 while ($row = $xstmt->fetch(PDO::FETCH_ASSOC)) {
 ?>
 <tr>
   <td style="text-align: center"><?php echo $no ?></td>
   <td><?php echo $row['Nilai'];?></td>
   <td style="text-align: right"><?php echo $row['Pembimbing'];?></td>
   <td style="text-align: right"><?php echo $row['Penguji1'];?></td>
   <td style="text-align: right"><?php echo $row['Penguji2'];?></td>
 </tr>
 <?php
 // Menambahkan nilai SKS dan Mutu ke total
 $Pembimbing += $row['Pembimbing'];    
 $Penguji1 += $row['Penguji1']; 
 $Penguji2 += $row['Penguji2']; 
 $no += 1;
 }  
 } catch (PDOException $e) {
 echo "Terjadi Kesalahan: " . $e->getMessage();
 }
 ?>
 <tr>
       <td colspan="2" style="text-align: right"><strong>Rerata</strong></td>
       <td style="text-align: right"><strong><?php echo ($Pembimbing/4) ?></strong></td>
       <td style="text-align: right"><strong><?php echo ($Penguji1/4) ?></strong></td>
       <td style="text-align: right"><strong><?php echo ($Penguji2/4) ?></strong></td>
     </tr>
 </tbody>
 </table>
 <p><span style="text-align: justify">Berdasarkan penilaian tersebut, kami menyimpulkan bahwa mahasiswa telah berhasil menjalani sidang tugas akhir/skripsi dengan baik dan perlu melakukan perbaikan yang di sarankan oleh dosen penguji dengan terlebih dahulu dikoordinasikan dengan dosen pembimbing, daftar perbaikan yang harus dilakukan terdapat pada lampiran. </span></p>
 <p><span style="text-align: justify">Demikianlah berita acara penilaian ini dibuat dengan sebenarnya untuk menjadi catatan resmi dari proses sidang tugas akhir/skripsi.</span></p>
 
 <?php
 $protocol = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http';
 $host = $_SERVER['HTTP_HOST'];
 $url = $_SERVER['REQUEST_URI'];
 $full_url = $protocol . "://" . $host . $url;
 
 $currentDate = getdate();
 $year = $currentDate['year'];
 $month = str_pad($currentDate['mon'], 2, '0', STR_PAD_LEFT); // Menambahkan nol di depan jika bulan hanya satu digit
 $day = str_pad($currentDate['mday'], 2, '0', STR_PAD_LEFT); // Menambahkan nol di depan jika tanggal hanya satu digit
 
 // Menyusun hasil dalam format "YYYY-MM-DD"
 $xTanggal = "$year-$month-$day";
 $id = "NILAISIDANG".$xnim.$xthn_akademik.$xperiode;
 $xkunci = md5(time() . $id);
 $xLink = $full_url;
 
 $arraypesan = array(
 'Jenis Dokumen' => 'BERITA ACARA SIDANG TUGAS AKHIR/SKRIPSI',
 'Tahun Akademik - Periode' => $xthn_akademik.' '.$xperiode,
 'Nama Mahasiswa' => $xnama,
 'NIM' => $xnim,
 'Program Studi' => $ps,
 'Ditandatangani oleh' => $xjab.' : '.$xpjb,
 'Tanggal Cetak' => date('d-m-Y H:i:s'),
 );
 $pesan = json_encode($arraypesan);
 catatdoc($xkunci, $pesan, $xLink);
 $urlverify = $protocol . "://" . $host . "/custom/verifikasi.php?kunci=" . $xkunci;
 ?>
 <br>
 <table width="100%" border="0" cellspacing="0" cellpadding="0">
   <tbody>
     <tr>
       <td width="33%">&nbsp;</td>
       <td width="34%" align="center">Bandung, <?php echo formatTanggal($xtgl); ?></td>
       <td width="33%">&nbsp;</td>
     </tr>
     <tr>
       <td align="center">Penguji 1<br><br><br></td>
       <td align="center">Pembimbing<br><br><br></td>
       <td align="center">Penguji 2<br><br><br></td>
     </tr>
     <tr>
        <td align="center" class="ttd-container">
            <img src="https://baak.stmik-im.ac.id/files/ttd/<?php echo $ttdpj1;?>" width="85" alt="TTD" class="ttd-img">
            <div>(<?php echo $pj1;?>)</div>
        </td>
        <td align="center" class="ttd-container">
            <img src="https://baak.stmik-im.ac.id/files/ttd/<?php echo $ttdpbb;?>" width="85" alt="TTD" class="ttd-img">
            <div>(<?php echo $pbb;?>)</div>
        </td>
        <td align="center" class="ttd-container">
            <img src="https://baak.stmik-im.ac.id/files/ttd/<?php echo $ttdpj2;?>" width="85" alt="TTD" class="ttd-img">
            <div>(<?php echo $pj2;?>)</div>
        </td>
    </tr>
     <tr>
       <td></td>
       <td align="center"><br>Mengetahui,</td>
       <td>&nbsp;</td>
     </tr>
     <tr>
       <td></td>
       <td  align="center"><?php echo ($xjab);?></td>
       <td>&nbsp;</td>
     </tr>
     <tr>
       <td>&nbsp;</td>
       <td>
       <?php
       # if (trim($xfak) === "T") { 
       ?>
       <div align="center" id="x<?php echo $id;?>"></div>
       <script type="text/javascript">
          new QRCode(document.getElementById("x<?php echo $id;?>"), {
           text: "<?= $urlverify; ?>",
           width: 80,
           height: 80,
           colorDark: "#000000",
           colorLight: "#ffffff",
           correctLevel: QRCode.CorrectLevel.M
         });            
       </script>  
      <?php 
       #} else {
       # echo "<p>&nbsp; </p>";
       #}
      ?> 
 
       </td>
       <td>&nbsp;</td>
     </tr>
     <tr>
       <td>&nbsp;</td>
       <td  align="center">(<?php echo ($xpjb);?>)</td>
       <td>&nbsp;</td>
     </tr>
   </tbody>
 </table>
 
 </section>
 <?php
 }
 
 } catch (PDOException $e) {
 echo "Terjadi Kesalahan: " . $e->getMessage();
 } 
  //Akhir Berita Acara Sidang
  
  // Awal DNS
    try {
      // Query untuk menampilkan record berdasarkan NIM
      $query = "SELECT NIM, Nama_Mhs, Tmp_Lahir, Tgl_Lahir, Program, TblJurusan.Jurusan, Rtrim(Program)+' - '+TblJurusan.Jurusan as Prodi, dbo.Lipk(Nim) as IPK, dbo.tsks(Nim) as SKS, TblJurusan.Kode_Fak FROM tblMHS INNER JOIN TblJurusan on tblMhs.Kode_jp=TblJurusan.Kode_Jp WHERE NIM = :nim";
      
	  $stmt = $conn->prepare($query);
      $stmt->bindParam(':nim', $xnim, PDO::PARAM_STR);
      $stmt->execute();
  
      // Tampilkan hasil query
      while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
          // Output hasil query setelah membersihkan dari XSS injection
          $xnim = htmlspecialchars($row['NIM']);
          $xnama = htmlspecialchars($row['Nama_Mhs']);
          $xTmpLahir = htmlspecialchars($row['Tmp_Lahir']);
          $yTglLahir = $row['Tgl_Lahir'];
          $xprodi = $row['Prodi'];
          if ($row['Tgl_Lahir'] !== null) {
              $xTglLahir = formatTanggal($row['Tgl_Lahir']);
          } else {
              $xTglLahir = '';
          }
          
          $xjur = ucwords(strtolower($row['Jurusan'])); 
          if ($row['Program']=='D3') 
          {
              $xprog = 'Diploma III (Tiga)' ;
          } else
          {
              $xprog = 'Sarjana S1' ;
          }
          
          $xsk = '';//htmlspecialchars($row['SK']);                  
          
          $xIPK = number_format($row['IPK'], 2, ',', '.');           
          $xsks = $row['SKS'];
          $xfak = trim($row['Kode_Fak']);
          if (trim($row['Kode_Fak']) === "T") {
            $kop = "kstmik.jpg";
           } else
           {
            $kop = "kstan.jpeg";
           }
      }
  } catch (PDOException $e) {
      echo "Terjadi Kesalahan pada Query: " . $e->getMessage();
  }
?>

 <section class="sheet padding-10mm">

<div>    
 <img src="<?php echo $kop; ?>"  height="75" alt=""/><hr>  
</div>
 <p><h3 style="text-align: center;" id="DNS">DAFTAR NILAI SEMENTARA (DNS)</h3></p>
 <table width="100%" border="0" class="table-font-9">
   <tbody>          
     <tr>
       <td>Nama</td>
       <td>: <?php echo $xnama; ?> </td>
     </tr>
     <tr>
       <td>Nomor Induk Mahasiswa</td>
       <td>: <?php echo $xnim; ?></td>
     </tr>
     <tr>
       <td>Tempat Tanggal Lahir</td>
       <td>: <?php echo rtrim($xTmpLahir); ?>, <?php echo $xTglLahir; ?> </td>
     </tr>
     <tr>
       <td>Program Studi</td>
       <td>: <?php echo $xprodi; ?></td>
     </tr>     
     <tr>
       <td>Tanggal Kelulusan</td>
       <td>: <?php echo '' ?></td>
     </tr>
   </tbody>
 </table>
 
 <?php
 
 try {
     // Query untuk menampilkan semua record
     $query = "SELECT Kode_MK, Nama_Mk_Ind, Nama_Mk_Ing, SKS, dbo.n2a(Grade) as Nilai, Grade FROM dbo.ctranskrip(:nim) Order By Semester";
     $stmt = $conn->prepare($query);
     $stmt->bindParam(':nim', $xnim, PDO::PARAM_STR);
     $stmt->execute();
 
     // Ambil semua data hasil query
     $allData = $stmt->fetchAll(PDO::FETCH_ASSOC);
 
     // Hitung jumlah data
     $totalData = count($allData);
 
     // Bagi data menjadi dua bagian
     $half = ceil($totalData / 2);
     $firstHalf = array_slice($allData, 0, $half);
     $secondHalf = array_slice($allData, $half);
   ?>
 
 <table width="100%" border="0">
   <tbody>
     <tr>
     <td width="50%" valign="top">
      <table width="100%" class="styled-table">
       <thead>
           <tr align="center">
             <th>No</th>
             <th>Kode</th>
             <th>Nama Matakuliah</th>
             <th>SKS</th>
             <th>N</th>
           </tr>
         </thead>        
           <tbody>
 <?php
         foreach ($firstHalf as $index => $row) {
 ?>            
           <tr align="center">
             <td align="right"><?php echo ($index + 1); ?></td>
             <td><?php echo $row['Kode_MK'];?></td>
             <td align="left"><?php echo $row['Nama_Mk_Ind'];?></td>
             <td><?php echo $row['SKS'];?></td>
             <td align="left"><?php echo $row['Nilai'];?></td>
           </tr>          
 <?php
     }
 ?>               
         </tbody>
       </table></td>
       <td width="50%" valign="top">
      <table width="100%" class="styled-table">
         <thead>
           <tr align="center">
             <th>No</th>
             <th>Kode</th>
             <th>Nama Matakuliah</th>
             <th>SKS</th>
             <th>N</th>
           </tr>
         </thead>
         <tbody>
 <?php
         foreach ($secondHalf as $index => $row) {
 ?>            
         <tr align="center">
             <td align="right"><?php echo ($index + $half + 1); ?></td>
             <td><?php echo $row['Kode_MK'];?></td>
             <td align="left"><?php echo $row['Nama_Mk_Ind'];?></td>
             <td><?php echo $row['SKS'];?></td>
             <td align="left"><?php echo $row['Nilai'];?></td>
           </tr> 
  <?php 
     }
   ?>  
           <tr align="center">
             <td colspan="3"><strong>Jumlah</strong></td>            
             <td><b><?php echo $xsks; ?></b></td>
             <td></td>
           </tr>
         </tbody>
       </table>
   </td>
     </tr>
   </tbody>
 </table>
 <?php
 
 } catch (PDOException $e) {
     echo "Terjadi Kesalahan pada Query: " . $e->getMessage();
 }
 ?>

<?php
//Qrcode
$protocol = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http';
$host = $_SERVER['HTTP_HOST'];
$url = $_SERVER['REQUEST_URI'];
$full_url = $protocol . "://" . $host . $url;

$currentDate = getdate();
$year = $currentDate['year'];
$month = str_pad($currentDate['mon'], 2, '0', STR_PAD_LEFT); // Menambahkan nol di depan jika bulan hanya satu digit
$day = str_pad($currentDate['mday'], 2, '0', STR_PAD_LEFT); // Menambahkan nol di depan jika tanggal hanya satu digit

// Menyusun hasil dalam format "YYYY-MM-DD"
$xTanggal = "$year-$month-$day";
$id = "DNS".$xnim;
$xkunci = md5(time() . $id);
$xLink = $full_url;

$arraypesan = array(
'Jenis Dokumen' => 'DAFTAR NILAI SEMENTARA',
'Nama Mahasiswa' => $xnama,
'NIM' => $xnim,
'Program Studi' => $ps,
'Informasi' => 'Jumlah SKS = ' . $xsks . ' IPKS = '.$xIPK, 
'Ditandatangani oleh' => $xjab.' : '.$xpjb,
'Tanggal Cetak' => date('d-m-Y H:i:s'),
);
$pesan = json_encode($arraypesan);
catatdoc($xkunci, $pesan, $xLink);
$urlverify = $protocol . "://" . $host . "/custom/verifikasi.php?kunci=" . $xkunci;
?>
 <table width="100%" border="0" class="table-font-9">
   <tbody>     
     <tr>
       <td width="35%"><strong>Index Prestasi Komulatif Sementara (IPKS)</strong></td>
       <td colspan="3"><strong>: <?php echo $xIPK; ?></strong></td>
     </tr>
     
     <tr>
       <td colspan="4">&nbsp;</td>
       </tr>
     <tr>
       <td colspan="2">&nbsp;</td>
       <td width="27%" colspan="2">&nbsp;</td>
     </tr>
     <tr>
       <td colspan="2">&nbsp;</td>
       <td colspan="2">Bandung, <?php echo date("d-m-Y"); ?></td>
     </tr>
     <tr>
       <td colspan="2">&nbsp;</td>
       <td colspan="2"><?php echo $xjab; ?></td>
     </tr>  
     
     <tr>
       <td colspan="2">&nbsp;</td>
       <td colspan="2">
       <div align="left" id="x<?php echo $id;?>"></div>
       <?php
       # if (trim($xfak) === "T") { 
        ?>
       <script type="text/javascript">
          new QRCode(document.getElementById("x<?php echo $id;?>"), {
           text: "<?= $urlverify; ?>",
           width: 80,
           height: 80,
           colorDark: "#000000",
           colorLight: "#ffffff",
           correctLevel: QRCode.CorrectLevel.M
         });            
       </script>
 <?php 
       #} else {
       # echo "<p>&nbsp; </p>";
       #}
      ?> 

       </td>
     </tr>
     <tr>
       <td colspan="2"><strong> &nbsp;</strong></td>
       <td colspan="2"><strong><u><?php echo $xpjb; ?> </u></strong></td>
     </tr>
   </tbody>
 </table>
  </section>	

<?php
// AKhir DNS

// Awal DHMD
  // Query untuk mengambil data dari DHMD dengan kondisi Nim    
    $xquery = "Select Thn_Akademik, Periode, Nim, Nama_Mhs, Tgl_Prw, NIDNKHS, JabatanKHS, TanggalKHS, ttdKHS, Kode_jp, Rtrim(Program)+' - '+Rtrim(Jurusan) as Prodi, Kode_Fak, NamaKHS from IM_KHS_KRS WHERE (Periode in ('1','2','3','SP')) AND (Nim = :nim) AND Thn_Akademik>='2017/2018' ";

    try {
        $grp = 1;
        // Eksekusi query menggunakan prepared statement
        $stmt = $conn->prepare($xquery);
        
        // Binding parameter
        $stmt->bindParam(':nim', $xnim, PDO::PARAM_STR);        
        
        // Eksekusi prepared statement
        $stmt->execute();
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
         $xthn_akademik =  $row['Thn_Akademik'];
         $xperiode = $row['Periode'];
         $ps = $row['Prodi'];
         $xnidn = $row['NIDNKHS'];
         $xpjb = $row['NamaKHS'];
         $xjab = $row['JabatanKHS'];
         $xtgl = $row['TanggalKHS'];
         $xnama = $row['Nama_Mhs'];
         $xfak = trim($row['Kode_Fak']);
         if (trim($row['Kode_Fak']) === "T") {
          $kop = "kstmik.jpg";
         } else
         {
          $kop = "kstan.jpeg";
         }

         if ($grp % 2 != 0){
          echo '<section class="sheet padding-10mm">';
          $tutup = 0;
          }
         
?>
<table width="100%" class="table-no-border" id="KRS">
  <tbody>
    <tr>
      <td colspan="7" align="left"><img src="<?php echo $kop; ?>"  height="75" alt=""/><hr></td>
    </tr>
    <tr>
      <td colspan="7" align="center">
		<table width="100%" class="table-font">
        <tbody>
          <tr>
            <td align="center"><h3 id="HADIR"><u>RIWAYAT KEHADIRAN MAHASISWA</u></h3></td>
          </tr>
        </tbody>
      </table>
	</td>
    </tr>
    <tr>      
      <td width="17%">Nama Mahasiswa</td>
      <td width="1%">:</td>
      <td width="34%"><?php echo $row['Nama_Mhs']; ?></td>
      <td width="15%">Tahun Akademik</td>
      <td width="1%">:</td>
      <td width="32%"><?php echo $row['Thn_Akademik']; ?> - <?php echo $row['Periode']; ?></td>
    </tr>
    <tr>     
      <td>NIM</td>
      <td>:</td>
      <td><?php echo $row['Nim']; ?></td>
      <td>Program Studi</td>
      <td>:</td>
      <td><?php echo $row['Prodi']; ?></td>
    </tr>
  </tbody>
</table>
<?php
// Query untuk mengambil data dari Wali_Nilai dengan kondisi
//$query = "Select Nim, Kode_MK, Nama_Mk_Ind, SKS, Nilai, Angka, Mutu, Kehadiran from Wali_Nilai WHERE Nim = :nim AND Thn_Akademik = :thn_akademik AND Periode = :periode";
$query = "Select Nim, Thn_Akademik, Periode, Status_Akd, Kode_MK, Nama_Mk_Ind, SKS, Nilai, Kehadiran, Tugas, Quiz, UTS, UAS, Jumlah, Angka, Mutu, kls, NIDN from EKPT_DHMD WHERE Nim = :nim AND Thn_Akademik = :thn_akademik AND Periode = :periode";
try {
    // Eksekusi query menggunakan prepared statement
    $xstmt = $conn->prepare($query);
    
    // Binding parameter
    $xstmt->bindParam(':nim', $xnim, PDO::PARAM_STR);
    $xstmt->bindParam(':thn_akademik', $xthn_akademik, PDO::PARAM_STR);
    $xstmt->bindParam(':periode', $xperiode, PDO::PARAM_STR);
    
    // Eksekusi prepared statement
    $xstmt->execute();

    // Inisialisasi variabel untuk menghitung total SKS dan total mutu
    $totalSKS = 0;
    $totalMutu = 0;
    $reratahdr = 0;
    $no = 1;   
?>

  <table width="100%" class="table-border-1">
  <tbody>
    <tr>
      <td width="5%" align="center">No</td>
      <td width="12%" align="center">Kode <br></td>
      <td width="40%" align="center">Nama Matakuliah</td>
      <td width="5%" align="center">SKS</td>
      <td width="10%" align="center">Kehadiran</td>
      <td width="28%" align="center">Riwayat</td>      
    </tr>
<?php
 while ($row = $xstmt->fetch(PDO::FETCH_ASSOC)) {
  $th = $row['Thn_Akademik'];
  $per = rtrim($row['Periode']);
  $nidn = rtrim($row['NIDN']);
  $klsakd = rtrim($row['Status_Akd']);
  $kodemk = rtrim($row['Kode_MK']);
  $xkls = rtrim($row['kls']);

?>
    <tr>
      <td align="right"><?php echo $no; ?></td>
      <td align="center"><?php echo $row['Kode_MK']; ?></td>
      <td><?php echo $row['Nama_Mk_Ind']; ?></td>
      <td align="right"><?php echo $row['SKS']; ?></td>      
      <td align="right"><?php echo round($row['Kehadiran'],2); ?></td>
      <td align="center">
      <?php if ($row['Kehadiran'] > 0): ?>
          <a href="xsap.php?thn_akademik=<?php echo $th; ?>&periode=<?php echo urlencode($per); ?>&nidn=<?php echo urlencode($nidn); ?>&klsakd=<?php echo urlencode($klsakd); ?>&kodemk=<?php echo urlencode($kodemk); ?>&grp=<?php echo urlencode($xkls); ?>" target="_blank">DHMD</a>
      <?php endif; ?>
        
      </td>
    </tr>
<?php
      // Menambahkan nilai SKS dan Mutu ke total
      $totalSKS += $row['SKS'];   
      $reratahdr += $row['Kehadiran'];
      $no += 1;
  }  
  
} catch (PDOException $e) {
  echo "Terjadi Kesalahan: " . $e->getMessage();
}
$rata = round($reratahdr/$no,2);
?>
    <tr>
      <td colspan="3" align="right">Jumlah SKS </td>
      <td align="right"><?php echo $totalSKS; ?></td>
      <td align="right"><?php echo $rata; ?></td>
      <td>&nbsp;</td>
     
    </tr>
  </tbody>
</table>
  <?php
$protocol = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http';
$host = $_SERVER['HTTP_HOST'];
$url = $_SERVER['REQUEST_URI'];
$full_url = $protocol . "://" . $host . $url;

$currentDate = getdate();
$year = $currentDate['year'];
$month = str_pad($currentDate['mon'], 2, '0', STR_PAD_LEFT); // Menambahkan nol di depan jika bulan hanya satu digit
$day = str_pad($currentDate['mday'], 2, '0', STR_PAD_LEFT); // Menambahkan nol di depan jika tanggal hanya satu digit

// Menyusun hasil dalam format "YYYY-MM-DD"
$xTanggal = "$year-$month-$day";
$id = "DHMD".$xnim.$xthn_akademik.$xperiode;
$xkunci = md5(time() . $id);
$xLink = $full_url;

$arraypesan = array(
  'Jenis Dokumen' => 'RIWAYAT KEHADIRAN MAHASISWA',
  'Tahun Akademik - Periode' => $xthn_akademik.' '.$xperiode,
  'Nama Mahasiswa' => $xnama,
  'NIM' => $xnim,
  'Program Studi' => $ps,
  'Informasi' => 'Rerata Kehadiran = ' . $rata, 
  'Ditandatangani oleh' => $xjab.' : '.$xpjb,
  'Tanggal Cetak' => date('d-m-Y H:i:s'),
);
$pesan = json_encode($arraypesan);
catatdoc($xkunci, $pesan, $xLink);
$urlverify = $protocol . "://" . $host . "/custom/verifikasi.php?kunci=" . $xkunci;
?>



<table width="100%" class="table-no-border">
  <tbody>
    <tr>
      <td width="67%">&nbsp;</td>
      <td width="33%" align="center">Bandung, <?php echo formatTanggal($xtgl);?> <br> 
      <?php echo ($xjab);?></td>
    </tr>
    
    <tr>
      <td>&nbsp;</td>
      <td>
      <div align="center" id="x<?php echo $id;?>"></div>
      <?php
     # if (trim($xfak) === "T") { 
      ?>
          <script type="text/javascript">
             new QRCode(document.getElementById("x<?php echo $id;?>"), {
             text: "<?= $urlverify; ?>",
             width: 80,
             height: 80,
             colorDark: "#000000",
             colorLight: "#ffffff",
             correctLevel: QRCode.CorrectLevel.M
            });            
          </script>  
 <?php 
     #  } else {
     #   echo "<p>&nbsp; </p>";
     #  }
      ?> 

      </td>
    </tr>
    <tr>
      <td>&nbsp;</td>
      <td align="center"><strong><?php echo ($xpjb);?></strong></td>
    </tr>    
  </tbody>
</table>

<?php

if ($grp % 2 == 0){
echo '</section>';
$tutup = 1;
} else {
  echo '<hr class="dashed-hr"><br>';
}


$grp = $grp + 1;

}
if ($tutup==0) {
  echo '</section>';
}

  } catch (PDOException $e) {
    echo "Terjadi Kesalahan: " . $e->getMessage();
  } 
//AKhir DHMD
?>



<?php

//cek end md5
} else {
    echo "Illegal Access...";
  }

} else {
    // Jika parameter Nim
    echo "Parameter tidak diisi...";
}
?> 
</body>
</html>