<?php 
include 'db.php';
include 'funct.php';
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <title>Form Pendaftaran Mahasiswa</title>
 <!-- Normalize or reset CSS with your favorite library -->
 <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/normalize/7.0.0/normalize.min.css">
 <!-- Load paper.css for happy printing -->
 <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/paper-css/0.4.1/paper.css">
 <!-- Set page size here: A5, A4 or A3 -->
 <!-- Set also "landscape" if you need -->
 <style>
 @page { size: legal }
 body {
    font-family: 'Calibri', sans-serif;
    font-size: 12pt;
}
 </style>  
 <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
 <link rel="stylesheet" href="table.css">
 <script src="https://cdn.rawgit.com/davidshimjs/qrcodejs/gh-pages/qrcode.min.js"></script>
 </head>
<body class="legal">
<section class="sheet padding-10mm">
<?php
// Ambil nilai parameter $Nopen dari URL dengan metode GET
$xnim = isset($_GET['nim']) ? $_GET['nim'] : '';

try {  
    // SQL untuk menampilkan data dari pmb_mhs berdasarkan Nopen
    $sql = "SELECT Nopen, Nim, Nama_Mhs, Kode_jp, Prodi, Kode_Fak, Tmp_Lahir, Tgl_Lahir, Jenis_Kel, Gol_darah, Agama_Mhs, Alamat_Mhs,
            rt, rw, Kelurahan, id_wilayah, nama_wilayah, id_negara, Kecamatan, Kota_Mhs, Provinsi_mhs, Kodepos_Mhs, Tlp_Mhs, TlpRumah, 
            Email, NIK, NamaIbu, Status_Akd, ThMasuk, tglmasuk, Status_Masuk, TaMasuk, PerMasuk, Pendidikan_Akhir, Jurusan, Thn_Selesai, 
            Kota_Pdkk, propinsi, NamaSekolahAsal, AlamatSekolahAsal, IdBeasiswa, NamaBeasiswa, NISN, tglDaftar, Ijazah, KK, Ktp, tandatangan,
            Nama, Jabatan, xphoto, ttd, tanggal, Password From IM_Daftar WHERE Nim = :nim";

    // Persiapkan statement SQL
    $stmt = $conn->prepare($sql);

    // Bind parameter
    $stmt->bindParam(':nim', $xnim);

    // Eksekusi statement
    $stmt->execute();

    // Ambil hasil query
    $result = $stmt->fetch(PDO::FETCH_ASSOC);

    // Tampilkan hasil dalam bentuk tabel dua kolom
    if ($result) {
		    $kodefak=trim($result['Kode_Fak']);
        if ($result['Jenis_Kel']=="L") {
            $kel = "Laki - Laki";
        }else{
            $kel = "Perempuan";
        }
        if (trim($result['Status_Akd']==="Reguler")) {
           $kls  = "Reguler";
        } else {
          $kls  = "Non Reguler / Karyawan";
        }
		
    ?>    
	<div>
	<?php	
		if ($kodefak === "T") {
		echo '<img src="kstmik.jpg"  height="85" alt=""/>';
		$pt = "STMIK IM";	
		} else {
		echo '<img src="kstan.jpeg"  height="85" alt=""/>';
		    $pt = "STIE STAN";
		}		
	?>	
  <hr>
	  
	</div>
        <div>
        <table class="table-border-1">
        <tr>
          <td colspan="4" align="center"><strong>FORM PENDAFTARAN</strong><br> Nomor : <?php echo $result['Nopen'] ?></td>
        </tr>
        <tr>
          <td colspan="4" align="center"><strong>DATA CALON MAHASISWA</strong></td>
          </tr>
        <tr>
          <td width="14%">Nama Lengkap</td>
          <td width="40%">: <?php echo $result['Nama_Mhs'] ?></td>
          <td width="12%">NIK</td>
          <td width="34%">: <?php echo $result['NIK'] ?></td></tr>
        <tr>
          <td>Tempat Lahir </td>
          <td>: <?php echo $result['Tmp_Lahir'] ?></td>
          <td>Tanggal Lahir</td>
          <td>:  <?php echo date("d F Y", strtotime($result['Tgl_Lahir']));?> </td></tr>
        <tr>
          <td>Jenis Kelamin</td>
          <td>: <?php echo $kel ?></td>
          <td>Gol Darah</td>
          <td>: <?php echo $result['Gol_darah'] ?></td>
        </tr>
        <tr>
          <td>Agama</td>
          <td>: <?php echo $result['Agama_Mhs'] ?></td>
          <td>Warganegara</td>
          <td>: <?php echo $result['id_negara'] ?></td>
        </tr>
        <tr>
          <td>Alamat</td>
          <td>: <?php echo $result['Alamat_Mhs'] ?></td>
          <td>RT, RW</td>
          <td>: <?php echo $result['rt'] ?> / <?php echo $result['rw'] ?></td>
        </tr>
        <tr>
          <td>Kelurahan</td>
          <td>: <?php echo $result['Kelurahan'] ?></td>
          <td>Kecamatan</td>
          <td>: <?php echo $result['Kecamatan'] ?></td>
        </tr>
        <tr>
          <td>Kota</td>
          <td>: <?php echo $result['Kota_Mhs'] ?></td>
          <td>Provinsi</td>
          <td>: <?php echo $result['Provinsi_mhs'] ?></td>
        </tr>
        <tr>
          <td>No Telepon</td>
          <td>: <?php echo $result['Tlp_Mhs'] ?>, <?php echo $result['TlpRumah'] ?></td>
          <td>Email</td>
          <td>: <?php echo $result['Email'] ?></td>
        </tr>
        <tr>
          <td>Nama ibu</td>
          <td colspan="3">: <?php echo $result['NamaIbu'] ?></td>
          </tr>
        <tr>
          <td colspan="4" align="center"><strong>DATA PENDIDIKAN TERAKHIR</strong></td>
          </tr>
        <tr>
          <td>Jenjang</td>
          <td>: <?php echo $result['Pendidikan_Akhir'] ?>, <?php echo $result['Jurusan'] ?></td>
          <td>Nama Sekolah</td>
          <td>: <?php echo $result['NamaSekolahAsal'] ?></td>
        </tr>
        <tr>
          <td>Alamat</td>
          <td>: <?php echo $result['AlamatSekolahAsal'] ?></td>
          <td>Kota</td>
          <td>: <?php echo $result['Kota_Pdkk'] ?></td>
        </tr>
		<tr>
          <td>Tahun Lulus</td>
          <td>: <?php echo $result['Thn_Selesai'] ?></td>
          <td>NISS</td>
          <td>: <?php echo $result['NISN'] ?></td>
        </tr>
        <tr>
          <td colspan="4" align="center"><strong>INFORMASI PENDAFTARAN</strong></td>
          </tr>
        <tr>
          <td>Fakultas</td>
          <td>: <?php echo $pt; ?></td>
          <td>Program Studi</td>
          <td>: <?php echo $result['Prodi'] ?></td>
        </tr>
        <tr>
          <td>NIM</td>
          <td>: <?php echo $result['Nim'] ?></td>
          <td>Kelas/Program</td>
          <td>: <?php echo $kls; ?></td>
        </tr>
        <tr>
          <td>Tahun Akademik</td>
          <td>: <?php echo $result['TaMasuk'] ?> - <?php echo $result['PerMasuk'] ?></td>
          <td>Status Masuk</td>
          <td>: <?php echo $result['Status_Masuk'] ?></td>
        </tr>
        <tr>
          <td>Beasiswa</td>
          <td>: <?php echo $result['NamaBeasiswa'] ?></td>
          <td>Tgl Registrasi</td>
          <td>:  <?php echo date("d F Y", strtotime($result['tglDaftar']));?></td>
        </tr>   
        <tr>
          <td colspan="4" align="left"><strong>DOKUMEN PERSYARATAN :</strong>
        <ol>
          <li><a href="https://akademik.stmik-im.ac.id/views/uploads/<?php echo $result['Ktp'] ?>" target="_blank">KTP</a></li>
          <li><a href="https://akademik.stmik-im.ac.id/views/uploads/<?php echo $result['Ijazah'] ?>" target="_blank">Ijazah & Transkript</a></li>
          <li><a href="https://akademik.stmik-im.ac.id/views/uploads/<?php echo $result['KK'] ?>" target="_blank">Kartu Keluarga</a></li>
        </ol>       
        
        </td>
        </tr>     
        </table>
<i><b>Catatan</b> : Silahkan lengkapi data di portal mahasiswa https://akademik.stmik-im.ac.id</i>
<?php
$protocol = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http';
$host = $_SERVER['HTTP_HOST'];
$url = $_SERVER['REQUEST_URI'];
$full_url = $protocol . "://" . $host . $url;

$currentDate = getdate();
$year = $currentDate['year'];
$month = str_pad($currentDate['mon'], 2, '0', STR_PAD_LEFT); // Menambahkan nol di depan jika bulan hanya satu digit
$day = str_pad($currentDate['mday'], 2, '0', STR_PAD_LEFT); // Menambahkan nol di depan jika tanggal hanya satu digit

// Menyusun hasil dalam format "YYYY-MM-DD"
$xTanggal = "$year-$month-$day";
$id = "ADMISI".$xnim;
$xkunci = md5(time() . $id);
$xLink = $full_url;

$arraypesan = array(
'Jenis Dokumen' => 'PENDAFTARAN MAHASISWA BARU',
'Nama ' => $result['Nama_Mhs'],
'NIM' => $result['Nopen'],
'Program Studi' => $result['Prodi'],
'Informasi' => 'NIM = ' . $xnim, 
'Ditandatangani oleh' => $result['Jabatan'].' : '.$result['Nama'],
'Tanggal Cetak' => date('d-m-Y H:i:s'),
);
$pesan = json_encode($arraypesan);
catatdoc($xkunci, $pesan, $xLink);
$urlverify = $protocol . "://" . $host . "/custom/verifikasi.php?kunci=" . $xkunci;
?>

	<table width="100%" class="table-no-border">
  <tbody>
    <tr>
      <td width="50%"><p>&nbsp;</p></td>
      <td width="50%"></td>
    </tr>
    
    <tr>
      <td align="center">
      <?php
        if (!empty($result['xphoto'])) {
      ?>
          <img src="https://akademik.stmik-im.ac.id/files/photo/<?php echo $result['xphoto'] ?>" height="130" alt="<?php echo $result['Nama_Mhs'] ?>">
      <?php
        }
      ?>
      </td>
      <td align="center">Bandung, <?php echo date("d F Y", strtotime($result['tglDaftar']));?> <br> <?php echo $result['Jabatan'] ?>,
      <div align="center" id="x<?php echo $id;?>"></div>
        <script type="text/javascript">
           new QRCode(document.getElementById("x<?php echo $id;?>"), {
           text: "<?= $urlverify; ?>",
           width: 80,
           height: 80,
           colorDark: "#000000",
           colorLight: "#ffffff",
           correctLevel: QRCode.CorrectLevel.M
          });            
        </script><br>
      (<u><b><?php echo $result['Nama'] ?>)</b></u>
      </td>
    </tr>
    <tr>
      <td>&nbsp;</td>
		<td align="center"></td>
    </tr>
    
  </tbody>
</table>	
</div>
<?php    
    } else {
        echo "Data pendaftaran tidak ditemukan.";
    }
?>
</section>



<?php
//Pemcetakan Pembayaran Admisi

// Query SQL untuk mendapatkan data berdasarkan NIM
$query = "SELECT pmb_Byr.Nopen, tblMHS.Nim, tblMHS.Nama_Mhs, tblMHS.Kode_jp, RTRIM(TblJurusan.Program)+' - '+RTRIM(TblJurusan.Jurusan) as Prodi, 
TblJurusan.Kode_Fak, tblMHS.JalurMasuk, tblMHS.TaMasuk, tblMHS.PerMasuk, tblMHS.Status_Akd, tblMHS.tglmasuk, tblMHS.Status_Masuk, 
pmb_Byr.tglDaftar, pmb_Byr.ByrDaftar, pmb_Byr.tglReg, pmb_Byr.ByrReg, pmb_Byr.tglReg1, pmb_Byr.ByrReg1, pmb_Byr.Konversi, tblDosen.Nama, tblPengesahanPMB.Jabatan 
FROM dbo.tblMHS INNER JOIN dbo.pmb_Byr ON tblMHS.Nopen = pmb_Byr.Nopen 
INNER JOIN dbo.TblJurusan ON tblMHS.Kode_jp = TblJurusan.Kode_Jp
LEFT JOIN dbo.tblPengesahanPMB ON tblMHS.TaMasuk = tblPengesahanPMB.Thn_Akademik AND tblMHS.PerMasuk = tblPengesahanPMB.Periode
LEFT JOIN dbo.tblDosen ON tblPengesahanPMB.NIDN = tblDosen.NIDN
WHERE tblMHS.Nim = :nim";
$stmt = $conn->prepare($query);
$stmt->bindParam(':nim', $xnim);
$stmt->execute();
$result = $stmt->fetch(PDO::FETCH_ASSOC);

// Menampilkan hasil query
if ($result) {
  $mutasi = trim($result['Status_Masuk']);
  $jmlbayar = 0;
  $no = 0;
  if (trim($result['Kode_Fak']) === "T") {
    $kop = "kstmik.jpg";
   } else
   {
    $kop = "kstan.jpeg";
   }
 
?>
<section class="sheet padding-10mm">

<table width="100%" class="table-no-border">
<tbody>
<tr>
<td colspan="7" align="left"><img src="<?php echo $kop; ?>"  height="75" alt=""/><hr></td>
</tr>
<tr>
<td colspan="7" align="center">
<table width="100%" class="table-font">
  <tbody>
    <tr>
      <td align="center"><strong><u>PEMBAYARAN REGISTRASI MAHASISWA BARU</u></strong></td>
    </tr>
  </tbody>
</table>
</td>
</tr>
<tr>      
<td width="17%">Nama</td>
<td width="1%">:</td>
<td width="34%"><?php echo $result['Nama_Mhs']; ?></td>
<td width="15%">Tahun Akademik</td>
<td width="1%">:</td>
<td width="32%"><?php echo $result['TaMasuk']; ?> - <?php echo $result['PerMasuk']; ?></td>
</tr>
<tr>     
<td>No. Registrasi</td>
<td>:</td>
<td><?php echo $result['Nopen']; ?></td>
<td>Program Studi</td>
<td>:</td>
<td><?php echo $result['Prodi']; ?></td>
</tr>
<tr>     
<td>Kelas/Program</td>
<td>:</td>
<td><?php echo $kls; ?></td>
<td>Baru/Mutasi</td>
<td>:</td>
<td><?php echo $result['Status_Masuk']; ?></td>
</tr>
</tbody>
</table>

<table width="100%" class="table-border-1">
  <tbody>
    <tr>
      <td width="5%" align="center">No</td>
      <td width="20%" align="center">Tanggal Bayar <br></td>
      <td width="50%" align="center">Item Pembayaran</td>      
      <td width="25%" align="center">Jumlah</td>      
    </tr>
    <?php if (!empty($result['ByrDaftar']) && $result['ByrDaftar'] > 0): $no +=1; ?>
    <tr>
      <td align="right"><?php echo $no; ?></td>
      <td align="center"><?php echo formatTanggal($result['tglDaftar']); ?></td>
      <td>Pendaftaran</td>      
      <td align="right"><?php echo number_format($result['ByrDaftar'], 0, ',', '.'); ?></td>
    </tr>
    <?php $jmlbayar += $result['ByrDaftar']; $tgl = $result['tglDaftar']; endif; ?>
    <?php if (!empty($result['ByrReg']) && $result['ByrReg'] > 0): $no +=1; ?>
    <tr>
      <td align="right"><?php echo $no; ?></td>
      <td align="center"><?php echo formatTanggal($result['tglReg']); ?></td>
      <td>Pembayaran Registrasi Ke 1</td>      
      <td align="right"><?php echo number_format($result['ByrReg'], 0, ',', '.'); ?></td>
    </tr>
    <?php $jmlbayar += $result['ByrReg']; $tgl = $result['tglReg']; endif; ?>
    <?php if (!empty($result['ByrReg1']) && $result['ByrReg1'] > 0): $no +=1; ?>
    <tr>
      <td align="right"><?php echo $no; ?></td>
      <td align="center"><?php echo formatTanggal($result['tglReg1']); ?></td>
      <td>Pembayaran Registrasi Ke 2</td>      
      <td align="right"><?php echo number_format($result['ByrReg1'], 0, ',', '.'); ?></td>
    </tr>
    <?php $jmlbayar += $result['ByrReg1']; $tgl = $result['tglReg1']; endif; ?>
    <?php if (!empty($result['Konversi']) && $result['Konversi'] > 0): $no +=1; ?>
    <tr>
      <td align="right"><?php echo $no; ?></td>
      <td align="center">-</td>
      <td>Biaya Konversi</td>      
      <td align="right"><?php echo number_format($result['Konversi'], 0, ',', '.'); ?></td>
    </tr>
    <?php $jmlbayar += $result['Konversi']; endif; ?>
    <tr>
      <td colspan="3" align="right">Total Bayar </td>
      <td align="right"><?php echo number_format($jmlbayar, 0, ',', '.'); ?></td>         
    </tr>
  </tbody>
</table>

<?php
$protocol = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http';
$host = $_SERVER['HTTP_HOST'];
$url = $_SERVER['REQUEST_URI'];
$full_url = $protocol . "://" . $host . $url;

$currentDate = getdate();
$year = $currentDate['year'];
$month = str_pad($currentDate['mon'], 2, '0', STR_PAD_LEFT); // Menambahkan nol di depan jika bulan hanya satu digit
$day = str_pad($currentDate['mday'], 2, '0', STR_PAD_LEFT); // Menambahkan nol di depan jika tanggal hanya satu digit

// Menyusun hasil dalam format "YYYY-MM-DD"
$xTanggal = "$year-$month-$day";
$id = "B-REG".$xnim;
$xkunci = md5(time() . $id);
$xLink = $full_url;

$arraypesan = array(
  'Jenis Dokumen' => 'PEMBAYARAN REGISTRASI MAHASISWA BARU ',
  'Tahun Akademik - Periode' =>$result['TaMasuk'].' '.$result['PerMasuk'],
  'Nama Mahasiswa' => $result['Nama_Mhs'],
  'Nomor Pendaftaran' => $result['Nopen'],
  'Program Studi' => $result['Prodi'],
  'Informasi' => 'Jumlah Pembayaran = ' . $jmlbayar, 
  'Ditandatangani oleh' => $result['Jabatan'].' : '.$result['Nama'],
  'Tanggal Cetak' => date('d-m-Y H:i:s'),
);
$pesan = json_encode($arraypesan);
catatdoc($xkunci, $pesan, $xLink);
$urlverify = $protocol . "://" . $host . "/custom/verifikasi.php?kunci=" . $xkunci;
?>
<table width="100%" class="table-no-border">
  <tbody>
    <tr>
      <td width="67%">&nbsp;</td>
      <td width="33%" align="center">Bandung, <?php echo formatTanggal($tgl);?> <br> 
      <?php echo $result['Jabatan'];?></td>
    </tr>
    
    <tr>
      <td>&nbsp;</td>
      <td>
      <div align="center" id="x<?php echo $id;?>"></div>
          <script type="text/javascript">
             new QRCode(document.getElementById("x<?php echo $id;?>"), {
             text: "<?= $urlverify; ?>",
             width: 80,
             height: 80,
             colorDark: "#000000",
             colorLight: "#ffffff",
             correctLevel: QRCode.CorrectLevel.M
            });            
          </script>  
     </td>
    </tr>
    <tr>
      <td>&nbsp;</td>
      <td align="center"><strong><?php echo $result['Nama'];?></strong></td>
    </tr>    
  </tbody>
</table>
</section>

<?php   
} else {
    echo "Data pembayaran tidak ditemukan.";
}

// Akhir pencetakan Struk Admisi



// Awal Konversi Mahasiswa

 
$xquery = "select Nim, Nama_Mhs, Kode_jp, Prodi, Kode_Fak, Status_Masuk, Status_Akd, Jabatan, Nama, ttd, TaMasuk, PerMasuk, KPTSASAL, NMPTITBPTI, 
           PSASAL, NMPSTTBPST, tglKonversi, NoSuratKonversi, JENASAL, NIMASAL FROM IM_MhsKonversi WHERE Nim = :nim ";

try {
    
    // Eksekusi query menggunakan prepared statement
    $stmt = $conn->prepare($xquery);
    
    // Binding parameter
    $stmt->bindParam(':nim', $xnim, PDO::PARAM_STR);        
    
    // Eksekusi prepared statement
    $stmt->execute();
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
     $xthn_akademik =  $row['TaMasuk'];
     $xperiode = $row['PerMasuk'];
     $ps = $row['Prodi'];     
     $xpjb = $row['Nama'];
     $xjab = $row['Jabatan'];
     $xtgl = $row['tglKonversi'];
     $xnama = $row['Nama_Mhs'];
     if (trim($row['JENASAL']) === "C") {
      $jj = "S1";
     } else {
      $jj = "D3";
     }


     if (trim($row['Kode_Fak']) === "T") {
      $kop = "kstmik.jpg";
     } else
     {
      $kop = "kstan.jpeg";
     }
        
?>
<section class="sheet padding-10mm">
<table width="100%" class="table-no-border">
<tbody>
<tr>
  <td colspan="7" align="left"><img src="<?php echo $kop; ?>"  height="75" alt=""/><hr></td>
</tr>
<tr>
  <td colspan="7" align="center">
<table width="100%" class="table-font">
    <tbody>
      <tr>
        <td align="center"><strong><u>KONVERSI NILAI MAHASISWA PINDAHAN</u></strong><br> Nomor : <?php echo $row['NoSuratKonversi']; ?></td>
      </tr>
    </tbody>
  </table>
</td>
</tr>
<tr>      
  <td width="17%">Nama Mahasiswa</td>
  <td width="1%">:</td>
  <td width="34%"><?php echo $row['Nama_Mhs']; ?></td>
  <td width="15%">Tahun Akademik</td>
  <td width="1%">:</td>
  <td width="32%"><?php echo $row['TaMasuk']; ?> - <?php echo $row['PerMasuk']; ?></td>
</tr>
<tr>     
  <td>NIM</td>
  <td>:</td>
  <td><?php echo $row['Nim']; ?></td>
  <td>Program Studi</td>
  <td>:</td>
  <td><?php echo $row['Prodi']; ?></td>
</tr>
<tr>     
  <td>Kelas/Program</td>
  <td>:</td>
  <td><?php echo $kls; ?></td>
  <td>NIM Asal</td>
  <td>:</td>
  <td><?php echo $row['NIMASAL']; ?></td>
</tr>
<tr>     
  <td>PT Asal</td>
  <td>:</td>
  <td><?php echo $row['NMPTITBPTI']; ?></td>
  <td>PS Asal</td>
  <td>:</td>
  <td><?php echo $jj." - ".$row['NMPSTTBPST']; ?></td>
</tr>
</tbody>
</table>
<?php
// Query untuk mengambil data dari Wali_Nilai dengan kondisi
$query = "SELECT 	tblkonv.Nim, tblkonv.mk_asal, tblkonv.sks_asal, tblkonv.nilai_asal, tblkonv.kode_mk, tblMK.Nama_Mk_Ind, tblMK.SKS, tblkonv.nilai 
FROM dbo.tblkonv INNER JOIN dbo.tblMK ON tblkonv.kode_mk = tblMK.Kode_MK WHERE tblkonv.Nim = :nim Order By mk_asal, sks_asal ";

try {
// Eksekusi query menggunakan prepared statement
$xstmt = $conn->prepare($query);

// Binding parameter
$xstmt->bindParam(':nim', $xnim, PDO::PARAM_STR);

// Eksekusi prepared statement
$xstmt->execute();

// Inisialisasi variabel untuk menghitung total SKS dan total mutu
$totalSKS = 0;
$no = 1;
?>

<table width="100%" class="table-border-1">
<tbody>
<tr>
  <td width="4%" rowspan="2" align="center">No</td>
  <td colspan="3" align="center">Matakuliah Asal</td>
  <td colspan="4" align="center">Matakuliah Hasil Konversi</td>
  </tr>
<tr>
  <td width="36%" align="center">Matakuliah</td>
  <td width="4%" align="center">SKS</td>
  <td width="4%" align="center">Nilai</td>
  <td width="8%" align="center">Kode</td>
  <td width="36%" align="center">Matakuliah</td>
  <td width="4%" align="center">SKS</td>
  <td width="4%" align="center">Nilai</td>        
</tr>
<?php
while ($row = $xstmt->fetch(PDO::FETCH_ASSOC)) {
  if ($no == 31) {
?>    
 </tbody></table> </section> <section class="sheet padding-10mm">
 <table width="100%" class="table-border-1"><tbody>
<tr>
  <td width="4%" rowspan="2" align="center">No</td>
  <td colspan="3" align="center">Matakuliah Asal</td>
  <td colspan="4" align="center">Matakuliah Hasil Konversi</td>
</tr>
<tr>
  <td width="36%" align="center">Matakuliah</td>
  <td width="4%" align="center">SKS</td>
  <td width="4%" align="center">Nilai</td>
  <td width="8%" align="center">Kode MK</td>
  <td width="36%" align="center">Matakuliah</td>
  <td width="4%" align="center">SKS</td>
  <td width="4%" align="center">Nilai</td>        
</tr>
<?php
  } 

?>
<tr>
  <td align="right"><?php echo $no; ?></td>
  <td><?php echo $row['mk_asal']; ?></td>
  <td align="center"><?php echo $row['sks_asal']; ?></td>
  <td align="center"><?php echo $row['nilai_asal']; ?></td>        
  <td align="center"><?php echo $row['kode_mk']; ?></td>
  <td><?php echo $row['Nama_Mk_Ind']; ?></td>
  <td align="center"><?php echo $row['SKS']; ?></td>
  <td align="center"><?php echo $row['nilai']; ?></td>  
</tr>
<?php

  // Menambahkan nilai SKS dan Mutu ke total
  $totalSKS += $row['SKS'];    
  $no += 1;
}  
} catch (PDOException $e) {
echo "Terjadi Kesalahan: " . $e->getMessage();
}
?>
</tbody>
</table><br>
<strong>
 Jumlah SKS yang di Konversikan = <?php echo $totalSKS; ?> dari <?php echo $no; ?> Matakuliah
</strong>
<?php
$protocol = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http';
$host = $_SERVER['HTTP_HOST'];
$url = $_SERVER['REQUEST_URI'];
$full_url = $protocol . "://" . $host . $url;

$currentDate = getdate();
$year = $currentDate['year'];
$month = str_pad($currentDate['mon'], 2, '0', STR_PAD_LEFT); // Menambahkan nol di depan jika bulan hanya satu digit
$day = str_pad($currentDate['mday'], 2, '0', STR_PAD_LEFT); // Menambahkan nol di depan jika tanggal hanya satu digit

// Menyusun hasil dalam format "YYYY-MM-DD"
$xTanggal = "$year-$month-$day";
$id = "KONV".$xnim.$xthn_akademik.$xperiode;
$xkunci = md5(time() . $id);
$xLink = $full_url;

$arraypesan = array(
'Jenis Dokumen' => 'KONVERSI NILAI MAHASISWA PINDAHAN',
'Tahun Akademik - Periode' => $xthn_akademik.' '.$xperiode,
'Nama Mahasiswa' => $xnama,
'NIM' => $xnim,
'Program Studi' => $ps,
'Informasi' => 'Jumlah SKS = ' . $totalSKS, 
'Ditandatangani oleh' => $xjab.' : '.$xpjb,
'Tanggal Cetak' => date('d-m-Y H:i:s'),
);
$pesan = json_encode($arraypesan);
catatdoc($xkunci, $pesan, $xLink);
$urlverify = $protocol . "://" . $host . "/custom/verifikasi.php?kunci=" . $xkunci;
?>



<table width="100%" class="table-no-border">
<tbody>
<tr>
  <td width="67%">&nbsp;</td>
  <td width="33%" align="center">Bandung, <?php echo formatTanggal($xtgl);?> <br> 
  <?php echo ($xjab);?></td>
</tr>

<tr>
  <td>&nbsp;
  </td>
  <td>
  <div align="center" id="x<?php echo $id;?>"></div>
      <script type="text/javascript">
         new QRCode(document.getElementById("x<?php echo $id;?>"), {
         text: "<?= $urlverify; ?>",
         width: 80,
         height: 80,
         colorDark: "#000000",
         colorLight: "#ffffff",
         correctLevel: QRCode.CorrectLevel.M
        });            
      </script>  


  </td>
</tr>
<tr>
  <td>&nbsp;</td>
  <td align="center"><strong><?php echo ($xpjb);?></strong></td>
</tr>    
</tbody>
</table>
</section>
<?php
}

} catch (PDOException $e) {
echo "Terjadi Kesalahan: " . $e->getMessage();
} 

 //Akhir Konversi


 //Awal Berita Acara Sidang


 
$xquery = "Select Tahun_akd, Periode, Nim, Nama_Mhs, Judul, Pembimbing, Penguji1, Penguji2, TGL_sidang, Jam_Sidang, Ruangan, Info_Link, BerkasTA, Prodi, Kode_Fak, Jabatan, Nama from Sidang_Jadwal WHERE Nim = :nim ";

try {

// Eksekusi query menggunakan prepared statement
$stmt = $conn->prepare($xquery);

// Binding parameter
$stmt->bindParam(':nim', $xnim, PDO::PARAM_STR);        

// Eksekusi prepared statement
$stmt->execute();
while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
$xthn_akademik =  $row['Tahun_akd'];
$xperiode = $row['Periode'];
$ps = $row['Prodi'];     
$xpjb = $row['Nama'];
$xjab = $row['Jabatan'];
$xtgl = $row['TGL_sidang'];
$xnama = $row['Nama_Mhs'];
$pbb =  $row['Pembimbing'];
$pj1 =  $row['Penguji1'];
$pj2 =  $row['Penguji2'];

if (trim($row['Kode_Fak']) === "T") {
$kop = "kstmik.jpg";
$fak = "STMIK IM";
} else
{
$kop = "kstan.jpeg";
$fak = "STIE STAN-IM";
}

?>
<section class="sheet padding-10mm">
<table width="100%" class="table-no-border">
<tbody>
<tr>
<td colspan="7" align="left"><img src="<?php echo $kop; ?>"  height="75" alt=""/><hr></td>
</tr>
<tr>
<td colspan="7" align="center">
<table width="100%" class="table-font">
<tbody>
<tr>
<td align="center"><strong><u>BERITA ACARA SIDANG TUGAS AKHIR/ SKRIPSI</u></strong></td>
</tr>
<tr>
<td style="text-align: justify">
<p>Pada hari ini, tanggal <?php echo formatTanggal($xtgl); ?> Jam <?php echo substr($row['Jam_Sidang'], 0, 5);?>, telah dilaksanakan sidang tugas akhir/skripsi di <?php echo $fak; ?>, untuk peserta sebagai berikut :</p>
<table width="100%" border="0" cellspacing="0" cellpadding="0">
  <tbody>
    <tr>
      <td width="17%">Nama Mahasiswa</td>
      <td width="1%">:</td>
      <td width="82%"><?php echo $row['Nama_Mhs'];?></td>
    </tr>
    <tr>
      <td>NIM</td>
      <td>:</td>
      <td><?php echo $row['Nim'];?></td>
    </tr>
    <tr>
      <td>Program Studi</td>
      <td>:</td>
      <td><?php echo $row['Prodi'];?></td>
    </tr>
    <tr>
      <td valign="top">Judul Tugas Akhir</td>
      <td valign="top">:</td>
      <td  ><?php echo $row['Judul'];?></td>
    </tr>
    <tr>
      <td>Tempat/Ruangan</td>
      <td>:</td>
      <td><?php echo $row['Ruangan'];?></td>
    </tr>
    <tr>
      <td valign="top">Keterangan</td>
      <td valign="top">:</td>
      <td style="text-align: left"><?php echo $row['Info_Link'];?></td>
    </tr>
  </tbody>
</table><br>
Pada agenda sidang tersebut, dihadiri oleh :
<ol>
  <li><?php echo $row['Pembimbing'];?>, Sebagai Pembimbing</li>
  <li><?php echo $row['Penguji1'];?>, Sebagai Penguji 1</li>
  <li><?php echo $row['Penguji2'];?>, Sebagai Penguji 2</li>
</ol>
<p>Setelah mendengarkan presentasi dan diskusi yang disampaikan oleh mahasiswa, kami sebagai dosen penguji dan pembimbing memberikan penilaian terhadap empat unsur sebagai berikut:</p>
</td>
</tr>
</tbody>
</table>
</td>
</tr>
</tbody>
</table>
<?php
// Query untuk mengambil data dari Nilai Sidang
$query = "SELECT Nilai, Pembimbing, Penguji1,Penguji2 FROM dbo.Sidang_BaNilai(:nim);";

try {
// Eksekusi query menggunakan prepared statement
$xstmt = $conn->prepare($query);

// Binding parameter
$xstmt->bindParam(':nim', $xnim, PDO::PARAM_STR);

// Eksekusi prepared statement
$xstmt->execute();

// Inisialisasi variabel untuk menghitung total SKS dan total mutu
$Pembimbing = 0;
$Penguji1 = 0;
$Penguji2 = 0;
$no = 1;
?>

<table width="100%" class="table-border-1">
  <tbody>
    <tr>
      <td width="4%" rowspan="2" style="text-align: center">No</td>
      <td width="60%" rowspan="2">Unsur Penilaian</td>
      <td colspan="3" style="text-align: center">Penilaian</td>
    </tr>
    <tr>
      <td width="12%" style="text-align: center">Pembimbing</td>
      <td width="12%" style="text-align: center">Penguji 1</td>
      <td width="12%" style="text-align: center">Penguji 2</td>
    </tr>  
<?php
while ($row = $xstmt->fetch(PDO::FETCH_ASSOC)) {
?>
<tr>
  <td style="text-align: center"><?php echo $no ?></td>
  <td><?php echo $row['Nilai'];?></td>
  <td style="text-align: right"><?php echo $row['Pembimbing'];?></td>
  <td style="text-align: right"><?php echo $row['Penguji1'];?></td>
  <td style="text-align: right"><?php echo $row['Penguji2'];?></td>
</tr>
<?php
// Menambahkan nilai SKS dan Mutu ke total
$Pembimbing += $row['Pembimbing'];    
$Penguji1 += $row['Penguji1']; 
$Penguji2 += $row['Penguji2']; 
$no += 1;
}  
} catch (PDOException $e) {
echo "Terjadi Kesalahan: " . $e->getMessage();
}
?>
<tr>
      <td colspan="2" style="text-align: right"><strong>Rerata</strong></td>
      <td style="text-align: right"><strong><?php echo ($Pembimbing/4) ?></strong></td>
      <td style="text-align: right"><strong><?php echo ($Penguji1/4) ?></strong></td>
      <td style="text-align: right"><strong><?php echo ($Penguji2/4) ?></strong></td>
    </tr>
</tbody>
</table>
<p><span style="text-align: justify">Berdasarkan penilaian tersebut, kami menyimpulkan bahwa mahasiswa telah berhasil menjalani sidang tugas akhir/skripsi dengan baik dan perlu melakukan perbaikan yang di sarankan oleh dosen penguji dengan terlebih dahulu dikoordinasikan dengan dosen pembimbing, daftar perbaikan yang harus dilakukan terdapat pada lampiran. </span></p>
<p><span style="text-align: justify">Demikianlah berita acara penilaian ini dibuat dengan sebenarnya untuk menjadi catatan resmi dari proses sidang tugas akhir/skripsi.</span></p>

<?php
$protocol = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http';
$host = $_SERVER['HTTP_HOST'];
$url = $_SERVER['REQUEST_URI'];
$full_url = $protocol . "://" . $host . $url;

$currentDate = getdate();
$year = $currentDate['year'];
$month = str_pad($currentDate['mon'], 2, '0', STR_PAD_LEFT); // Menambahkan nol di depan jika bulan hanya satu digit
$day = str_pad($currentDate['mday'], 2, '0', STR_PAD_LEFT); // Menambahkan nol di depan jika tanggal hanya satu digit

// Menyusun hasil dalam format "YYYY-MM-DD"
$xTanggal = "$year-$month-$day";
$id = "NILAISIDANG".$xnim.$xthn_akademik.$xperiode;
$xkunci = md5(time() . $id);
$xLink = $full_url;

$arraypesan = array(
'Jenis Dokumen' => 'BERITA ACARA SIDANG TUGAS AKHIR/SKRIPSI',
'Tahun Akademik - Periode' => $xthn_akademik.' '.$xperiode,
'Nama Mahasiswa' => $xnama,
'NIM' => $xnim,
'Program Studi' => $ps,
'Ditandatangani oleh' => $xjab.' : '.$xpjb,
'Tanggal Cetak' => date('d-m-Y H:i:s'),
);
$pesan = json_encode($arraypesan);
catatdoc($xkunci, $pesan, $xLink);
$urlverify = $protocol . "://" . $host . "/custom/verifikasi.php?kunci=" . $xkunci;
?>
<br>
<table width="100%" border="0" cellspacing="0" cellpadding="0">
  <tbody>
    <tr>
      <td width="33%">&nbsp;</td>
      <td width="34%" align="center">Bandung, 22 Oktober 2022</td>
      <td width="33%">&nbsp;</td>
    </tr>
    <tr>
      <td align="center">Penguji 1</td>
      <td align="center">Pembimbing</td>
      <td align="center">Penguji 2</td>
    </tr>
    <tr>
      <td><p>&nbsp;</p><br></td>
      <td><p>&nbsp;</p><br></td>
      <td><p>&nbsp;</p><br></td>
    </tr>
    <tr>
      <td align="center">(<?php echo $pj1;?>)</td>
      <td align="center">(<?php echo $pbb;?>)</td>
      <td align="center">(<?php echo $pj2;?>)</td>
    </tr>
    <tr>
      <td></td>
      <td align="center">Mengetahui,</td>
      <td>&nbsp;</td>
    </tr>
    <tr>
      <td></td>
      <td  align="center"><?php echo ($xjab);?></td>
      <td>&nbsp;</td>
    </tr>
    <tr>
      <td>&nbsp;</td>
      <td>
      <div align="center" id="x<?php echo $id;?>"></div>
      <script type="text/javascript">
         new QRCode(document.getElementById("x<?php echo $id;?>"), {
          text: "<?= $urlverify; ?>",
          width: 80,
          height: 80,
          colorDark: "#000000",
          colorLight: "#ffffff",
          correctLevel: QRCode.CorrectLevel.M
        });            
      </script>  

      </td>
      <td>&nbsp;</td>
    </tr>
    <tr>
      <td>&nbsp;</td>
      <td  align="center">(<?php echo ($xpjb);?>)</td>
      <td>&nbsp;</td>
    </tr>
  </tbody>
</table>

</section>
<?php
}

} catch (PDOException $e) {
echo "Terjadi Kesalahan: " . $e->getMessage();
} 
 //Akhir Berita Acara Sidang

} catch(PDOException $e) {
    // Tangkap kesalahan dan tampilkan pesan error
    echo "Terjadi kesalahan: " . $e->getMessage();
}
?>
</body>
</html>
