<?php
function formatTanggal($tanggal) {
    // Cek apakah tanggal tidak null
    if ($tanggal !== null) {
        $bulan = array(
            '01' => 'Januari',
            '02' => 'Februari',
            '03' => 'Maret',
            '04' => 'April',
            '05' => 'Mei',
            '06' => 'Juni',
            '07' => 'Juli',
            '08' => 'Agustus',
            '09' => 'September',
            '10' => 'Oktober',
            '11' => 'November',
            '12' => 'Desember'
        );   

        $split = preg_split('/[- :.]/', $tanggal);
        $tahun = $split[0];
        $bulanIndex = $split[1];
        $tanggal = $split[2];

        // Pastikan bulanIndex ada dalam array bulan
        if (array_key_exists($bulanIndex, $bulan)) {
            $namaBulan = $bulan[$bulanIndex];
            return $tanggal . ' ' . $namaBulan . ' ' . $tahun;
        } else {
            return 'Format bulan tidak valid';
        }
    } else {
        return 'Tanggal tidak valid (null)';
    }
}

function fjam($jam) {
    // Cek apakah jam tidak null
    if ($jam !== null) {
        // Ambil hanya bagian jam dan menit dari string jam
        $formattedJam = substr($jam, 0, 5);
        return $formattedJam;
    } else {
        return 'Jam tidak valid (null)';
    }
}

function catatdoc($kunci, $pesan, $Link) {
    global $conn;

    try {
        // SQL untuk memasukkan data ke dalam tabel tblVerifikasi
        $sql = "INSERT INTO tblVerifikasi (xKey, Pesan, Link) VALUES (:xKey, :Pesan, :Link)";

        // Persiapkan statement SQL
        $stmt = $conn->prepare($sql);

        // Bind parameter
        $stmt->bindParam(':xKey', $kunci);
        $stmt->bindParam(':Pesan', $pesan);
        $stmt->bindParam(':Link', $Link);

        // Eksekusi statement
        $stmt->execute();

        // Tampilkan pesan sukses jika berhasil
        //echo "Data berhasil dimasukkan ke dalam tabel tblVerifikasi.";
    } catch (PDOException $e) {
        if ($e->errorInfo[0] == "22001") {
            echo "Terjadi kesalahan: String atau data biner terlalu panjang.";
        } else {
            echo "Terjadi kesalahan: " . $e->getMessage();
        }
    }
}

function getbaak() {
    // Menggunakan koneksi dari db.php atau koneksi database yang sesuai
    include 'db.php';

    try {
        // Query SQL
        $sql = "SELECT TOP 1 BAAK, NikBAAK FROM tblFak";

        // Menyiapkan dan menjalankan query
        $stmt = $conn->prepare($sql);
        $stmt->execute();

        // Mengambil hasil query
        $result = $stmt->fetchAll(PDO::FETCH_ASSOC);

        // Menampilkan hasil dalam bentuk tabel HTML
        if (!empty($result)) {
            foreach ($result as $row) {
                echo htmlspecialchars($row['BAAK']);                
            }            
        } else {
            echo 'Tidak ada data BAAK.';
        }

    } catch (PDOException $e) {
        echo "Terjadi kesalahan: " . $e->getMessage();
    }

    // Menutup koneksi
    $conn = null;
}

function getHari($tanggal)
{
    $hari = date('N', strtotime($tanggal));

    $namaHari = [
        1 => 'Senin',
        2 => 'Selasa',
        3 => 'Rabu',
        4 => 'Kamis',
        5 => 'Jumat',
        6 => 'Sabtu',
        7 => 'Minggu',
    ];

    return isset($namaHari[$hari]) ? $namaHari[$hari] : '';
}



