<?php
include 'db.php';

// Fungsi untuk mengubah format tanggal dari YYYY-MM-DD HH:MM:SS menjadi DD-MM-YYYY
function formatTanggal($tanggal) {
    return date('d-m-Y', strtotime($tanggal));
}

// Fungsi untuk menghindari serangan SQL Injection dan XSS
function sanitize($input) {
    return htmlspecialchars(strip_tags($input));
}

// Mencegah SQL Injection pada parameter NIM
$nim = isset($_GET['nim']) ? sanitize($_GET['nim']) : '';

// Query SQL untuk mendapatkan data berdasarkan NIM
$query = "SELECT tahunakd, periode, kditem, itembayar, jmlbyr, tglbayar, operator, keterangan FROM keu_ekpt WHERE NIM = :nim order by tahunakd, periode,tglbayar ";
$stmt = $conn->prepare($query);
$stmt->bindParam(':nim', $nim);
$stmt->execute();
$data = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Array untuk menyimpan subtotal setiap kelompok tahunakd, periode
$subtotals = array();

// Inisialisasi grand total
$grandTotal = 0;

foreach ($data as $row) {
    $tahunakd = trim($row['tahunakd']);
    $periode = trim($row['periode']);
    $kditem = $row['kditem'];
    $itembayar = $row['itembayar'];
    $jmlbyr = $row['jmlbyr'];
    $tglbayar = formatTanggal($row['tglbayar']); // Mengubah format tanggal
    $operator = $row['operator'];
    $keterangan = $row['keterangan'];

// Menghitung subtotal untuk setiap kelompok tahunakd, periode
$key = "$tahunakd-$periode";
if (!isset($subtotals[$key]['subtotal'])) {
    $subtotals[$key]['subtotal'] = 0;
}
$subtotals[$key]['subtotal'] += $jmlbyr;
$subtotals[$key]['data'][] = array(
    'kditem' => $kditem,
    'itembayar' => $itembayar,
    'jmlbyr' => $jmlbyr,
    'tglbayar' => $tglbayar,
    'operator' => $operator,
    'keterangan' => $keterangan
);

    // Menambahkan jumlah bayar ke grand total
    $grandTotal += $jmlbyr;
}

// Memulai tabel untuk setiap kelompok
foreach ($subtotals as $key => $subgroup) {
    list($tahunakd, $periode) = explode("-", $key);
    echo "Tahun Akademik: $tahunakd - $periode";
    echo "<table width='100%' border='1'>";
    echo "<tr>
			<th width='5%' >No</th>
			<th width='7%'>Kode</th>
			<th width='23%'>Item Bayar</th>
			<th width='15%'>Jumlah Bayar</th>
			<th width='15%'>Tanggal</th>
			<th width='10%'>Operator</th>
			<th width='25%'>Keterangan</th>
		 </tr>";

    // Inisialisasi nomor urut
    $nomor = 1;

    // Menampilkan data untuk setiap kelompok
    foreach ($subgroup['data'] as $subrow) {
        echo "<tr>";
        echo "<td align='right'>" . $nomor++ . "</td>";
        echo "<td align='center'>{$subrow['kditem']}</td>";
        echo "<td>{$subrow['itembayar']}</td>";
        echo "<td align='right'>".number_format($subrow['jmlbyr'], 0, ',', '.')."</td>";
        echo "<td align='center'>{$subrow['tglbayar']}</td>";
        echo "<td>{$subrow['operator']}</td>";
        echo "<td>{$subrow['keterangan']}</td>";
        echo "</tr>";
    }

 // Tambahkan baris subtotal jika 'subtotal' tersedia
if (array_key_exists('subtotal', $subgroup)) {
    echo "<tr><td colspan='2'></td><td><strong>Subtotal</strong></td><td align='right'>".number_format($subgroup['subtotal'], 0, ',', '.')."</td><td  colspan='3'>&nbsp;</td></tr>";
}

    // Menutup tabel untuk setiap kelompok
    echo "</table><br>";
}

// Menampilkan grand total di luar semua tabel
echo "<strong>Jumlah Total Pembayaran : ".number_format($grandTotal, 0, ',', '.')."</strong>";
?>
