<!DOCTYPE html>
<html lang="en">
<head>
  <title>Presensi Mahasiswa ATB-BANDUNG</title>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.1/dist/css/bootstrap.min.css" rel="stylesheet">
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.1/dist/js/bootstrap.bundle.min.js"></script>
</head>
<body>

<div class="container mt-3">
  <h4 class="text-decoration-underline">Presensi Mahasiswa</h4>

<?php

include 'db.php';

$xkmk = rtrim($_GET["kmk"]);
$xjp = rtrim($_GET["jp"]);
$xth = rtrim($_GET["th"]);
$xper = rtrim($_GET["per"]);
$xkelas = rtrim($_GET["kelas"]);
$xgroup = rtrim($_GET["group"]);
$xnidn = rtrim($_GET["nidn"]);
$_SESSION["snidn"] = $xnidn;
$_SESSION["sjp"] = $xjp;
$_SESSION["skelas"] = $xkelas;
$_SESSION["sgroup"] = $xgroup;
$_SESSION["ss"] = "reiuthewrt9238519357192rhqwfkdnsakjnask*&(^#";

$sql = "SELECT Thn_Akademik, Periode, Kode_Jp, Kode_Mk, Nama_Mk_Ind, sks, Kelas_Akd, Kelas, Hari, JM, JS, Ruang, Prodi, Nama, NIDN FROM Wali_JadKul WHERE NIDN=:nidn AND Kode_Mk=:kmk AND Kelas=:group AND Kelas_Akd=:kelas AND Thn_Akademik=:th AND Periode=:per AND Kode_Jp=:jp";
$stmt = $conn->prepare($sql);
$stmt->bindParam(':nidn', $xnidn, PDO::PARAM_STR);
$stmt->bindParam(':kmk', $xkmk, PDO::PARAM_STR);
$stmt->bindParam(':group', $xgroup, PDO::PARAM_STR);
$stmt->bindParam(':kelas', $xkelas, PDO::PARAM_STR);
$stmt->bindParam(':th', $xth, PDO::PARAM_STR);
$stmt->bindParam(':per', $xper, PDO::PARAM_STR);
$stmt->bindParam(':jp', $xjp, PDO::PARAM_STR);
$stmt->execute();
$row = $stmt->fetch(PDO::FETCH_ASSOC);

if ($row) {
?>

	<table>
		<tr>
			<td>Matakuliah</td>
			<td>: <?= $row['Kode_Mk'] ?> - <?= $row['Nama_Mk_Ind'] ?> (<?= $row['sks'] ?> SKS)</td>
		</tr>
		<tr>
			<td>Program Studi</td>
			<td>: <?= $row['Prodi'] ?></td>
		</tr>
		<tr>
			<td>Kelas/Group</td>
			<td>: <?= $row['Kelas_Akd'] ?>/<?= $row['Kelas'] ?></td>
		</tr>
		<tr>
			<td>Dosen Pengampu &nbsp;</td>
			<td>: <?= $row['NIDN'] ?> - <?= $row['Nama'] ?></td>
		</tr>
		<tr>
			<td>Hari, Jam</td>
			<td>: <?= $row['Hari'] ?>, <?= date('H:i', strtotime($row['JM'])) ?> - <?= date('H:i', strtotime($row['JS'])) ?></td>
		</tr>
	</table>

<?php
}

$stmt->closeCursor();
?>
</div>

<?php
$sql = "SELECT tblNilai.Nim, tblmhs.Nama_Mhs, tblNilai.Kehadiran, tblNilai.Minggu1, tblNilai.Minggu2, tblNilai.Minggu3, tblNilai.Minggu4, 
        tblNilai.Minggu5, tblNilai.Minggu6, tblNilai.Minggu7, tblNilai.Minggu8, tblNilai.Minggu9, tblNilai.Minggu10, 
        tblNilai.Minggu11, tblNilai.Minggu12, tblNilai.Minggu13, tblNilai.Minggu14, tblNilai.Minggu15, tblNilai.Minggu16 
        FROM tblNilai 
        INNER JOIN tblMHS ON tblNilai.Nim=tblMHS.Nim 
        WHERE tblMhs.Kode_jp=:jp AND tblmhs.Status_Akd=:kelas AND tblNilai.Thn_Akademik=:th AND tblNilai.Periode=:per AND 
        tblnilai.Kode_MK=:kmk AND kls=:group";

$stmt = $conn->prepare($sql);
$stmt->bindParam(':jp', $xjp, PDO::PARAM_STR);
$stmt->bindParam(':kelas', $xkelas, PDO::PARAM_STR);
$stmt->bindParam(':th', $xth, PDO::PARAM_STR);
$stmt->bindParam(':per', $xper, PDO::PARAM_STR);
$stmt->bindParam(':kmk', $xkmk, PDO::PARAM_STR);
$stmt->bindParam(':group', $xgroup, PDO::PARAM_STR);
$stmt->execute();
$result = $stmt->fetchAll(PDO::FETCH_ASSOC);

if ($result) {
?>

<div class="container mt-3">  
    <table class="table table-sm table-hover table-bordered">
    <thead>
      <tr>
        <th>&nbsp;</th>
        <th>&nbsp;</th>
        <th>&nbsp;</th>
		<th colspan="17">Minggu Ke</th>
      </tr>
    </thead>
    <tbody>
      <tr>
        <th>No</th>
        <th>Nim</th>
        <th>Nama</th>
		<th>%</th>
<?php
for ($i = 1; $i <= 16; $i++) {
    echo '<th><a class="btn btn-primary btn-sm" href="presensiedit.php?jp=' . $xjp . '&kelas=' . $xkelas . '&th=' . $xth . '&per=' . $xper . '&kmk=' . $xkmk . '&group=' . $xgroup . '&minggu=Minggu' . $i . '&PA=PA' . $i . '&nidn=' . $xnidn . '&key=' . md5($xjp . $xkelas . $xth . $xper . $xkmk . $xgroup . 'Minggu' . $i . 'PA' . $i . $xnidn . $_SESSION["ss"]) . '" role="button">' . $i . '</a></th>';
}
?>
      </tr>
<?php
$no = 0;
foreach ($result as $row) {
    $no++;
    echo '<tr>';
    echo '<td>' . $no . '</td>';
    echo '<td>' . $row["Nim"] . '</td>';
    echo '<td>' . $row["Nama_Mhs"] . '</td>';
    echo '<td class="text-end">' . number_format($row["Kehadiran"], 2) . '</td>';
    for ($i = 1; $i <= 16; $i++) {
        echo '<td class="text-center">' . $row["Minggu$i"] . '</td>';
    }
    echo '</tr>';
}
?>
    </tbody>
  </table>
   <a href="../WaliJadKulList" class="btn btn-warning">Selesai</a>
  <p><em>Keterangan : H = hadir; I = Ijin; A = absen</em></p>
</div>

<?php
} else {
    echo "Data Presensi tidak ditemukan...";
}

$stmt->closeCursor();
$conn = null;
?>

</body>
</html>
