<?php 
include 'db.php';
include 'funct.php';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">    
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <style>
        @media print {
            table {
                page-break-inside: auto;
                font-size: 8pt;
                font-family: 'Calibri', sans-serif;
            }

            tr {
                page-break-inside: avoid;
                page-break-after: auto;
            }

            thead {
                display: table-header-group;
            }

            tfoot {
                display: table-footer-group;
            }
        }
    </style>
    <title>Daftar Nilai Sementara</title>
    <script src="https://cdn.rawgit.com/davidshimjs/qrcodejs/gh-pages/qrcode.min.js"></script>
</head>
<body>

<?php
$key="0986ABC7C9DGHJGJJHGJH5975XHDLNLKFKGJGKBKGFPPJUDFSW";
$tkn=md5(rtrim($_GET['nim']).$key);
// Ambil parameter Nim dari metode GET
if (isset($_GET['nim']) && ($tkn == $_GET['key'])) {
    // Lindungi dari SQL Injection
    $nim = htmlspecialchars($_GET['nim']);
    

// Query untuk mengambil data dari VIEW_MHS dengan kondisi Nim
$query = "SELECT Nim, Nama_Mhs, Prodi, Kajur, Dekan, Status_Akd, dbo.lipk(Nim) as ipk,  dbo.tsks(Nim) as tsks, Kode_Fak, Nama_Fak FROM VIEW_MHS WHERE Nim = :nim";

try {
    // Eksekusi query menggunakan prepared statement
    $stmt = $conn->prepare($query);
    
    // Binding parameter
    $stmt->bindParam(':nim', $nim, PDO::PARAM_STR);
    
    // Eksekusi prepared statement
    $stmt->execute();
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
    $Kajur = $row['Kajur'];
    $Dekan = $row['Dekan'];
    $Prodi = $row['Prodi'];    
    $xnama =  $row['Nama_Mhs'];   
    $xipk  =  $row['ipk'];    
    $nFak  =  $row['Nama_Fak'];    

    if ($row['Kode_Fak']="T") {
      $fak = "kstmik.jpg";
    } else {
      $fak = "kstan.jpeg";
    }
?>
<div class='container mt-3'>
<table class='table table-borderless table-sm'>
<tbody>
<tr>
  <td colspan="6" align="left"><img src="<?php echo $fak; ?>" height="100" alt=""/><hr></td>
</tr>
<tr>
  <td colspan="6" align="center"><h5>DAFTAR HASIL STUDI (DHS)</h5></td>
</tr>
<tr>
  <td width="16%">NPM</td>
  <td width="1%">:</td>
  <td width="29%"><?php echo $row['Nim']; ?></td>
  <td width="21%">Nama Mahasiswa</td>
  <td width="1%">:</td>
  <td width="32%"><?php echo $row['Nama_Mhs']; ?></td>
</tr>
<tr>
  <td>Program </td>
  <td>:</td>
  <td><?php echo $row['Status_Akd']; ?></td>
  <td>Program Studi</td>
  <td>:</td>
  <td><?php echo $row['Prodi']; ?></td>
</tr>
<tr>
  <td>IPK</td>
  <td>:</td>
  <td><?php echo  number_format($row['ipk'],2); ?></td>
  <td>Total SKS</td>
  <td>:</td>
  <td><?php echo $row['tsks']; ?></td>
</tr>
</tbody>
</table>
</div>
<?php
}
} catch (PDOException $e) {
echo "Terjadi Kesalahan: " . $e->getMessage();
} 
?>
<?php
    // Query untuk mengambil data dari tabel Wali_Nilai dengan kondisi Nim
    $query = "SELECT Semester, Kode_Mk, Nama_Mk_Ind, SKS, Nilai, Angka, Mutu FROM Wali_Nilai WHERE Nim = :nim ORDER BY Semester ";

    try {
        // Eksekusi query menggunakan prepared statement
        $stmt = $conn->prepare($query);
        
        // Binding parameter
        $stmt->bindParam(':nim', $nim, PDO::PARAM_STR);
        
        // Eksekusi prepared statement
        $stmt->execute();
        
        // Inisialisasi array untuk menyimpan hasil sesuai semester
        $resultBySemester = array();

        // Loop melalui hasil query
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
            // Menyusun hasil berdasarkan semester
            $semester = $row['Semester'];
            $resultBySemester[$semester][] = $row;
        }

        // Loop melalui hasil sesuai semester
        foreach ($resultBySemester as $semester => $result) {
            // Menampilkan tabel untuk setiap semester dengan menggunakan Bootstrap
            echo "<div class='container mt-1'>
                    <h6>Semester $semester</h6>
                    <table class='table table-bordered table-sm'>
                        <thead>
                        <tr>
                          <th class='text-center' width='5%'>No</th>
                          <th class='text-center' width='12%'>Kode</th>
                          <th width='43%'>Matakuliah</th>
                          <th class='text-center' width='10%'>SKS</th>
                          <th class='text-center' width='10%'>Nilai</th>
                          <th class='text-center' width='10%'>Angka</th>
                          <th class='text-center' width='10%'>Mutu</th>
                        </tr>
                        </thead>
                        <tbody>";

            // Inisialisasi variabel untuk menghitung jumlah SKS dan jumlah mutu
            $totalSKS = 0;
            $totalMutu = 0;

            // Loop melalui hasil setiap semester
            $nomorUrut = 1;
            foreach ($result as $row) {
                // Menampilkan data dengan menghindari XSS
                echo "<tr>
                        <td class='text-center'>{$nomorUrut}</td>
                        <td class='text-center'>" . htmlspecialchars($row['Kode_Mk']) . "</td>
                        <td>" . htmlspecialchars($row['Nama_Mk_Ind']) . "</td>
                        <td class='text-center'>" . htmlspecialchars($row['SKS']) . "</td>
                        <td class='text-center'>" . htmlspecialchars($row['Nilai']) . "</td>
                        <td class='text-center'>" . htmlspecialchars($row['Angka']) . "</td>
                        <td class='text-center'>" . number_format($row['Mutu'],0) . "</td>
                    </tr>";

                // Menambahkan nilai SKS dan Mutu ke total
                $totalSKS += $row['SKS'];
                $totalMutu += $row['Mutu'];

                // Meningkatkan nomor urut
                $nomorUrut++;
            }

            // Menampilkan baris total SKS dan Mutu
            echo "<tr>
                    <td colspan='3' class='text-end'>Total</td>
                    <td class='text-center'>{$totalSKS}</td>
                    <td colspan='2'>-</td>
                    <td class='text-center'>{$totalMutu}</td>
                </tr>";

            // Menghitung IPS dengan dua digit dibelakang koma
            $ips = ($totalMutu / $totalSKS);
            echo "<tr>
                    <td colspan='6' class='text-end'>IPS</td>
                    <td class='text-center'>" . number_format($ips, 2) . "</td>
                </tr>";

            echo "</tbody></table></div>";
        }

    } catch (PDOException $e) {
        echo "Terjadi Kesalahan: " . $e->getMessage();
    }

    // Tutup koneksi database
   // $conn = null;


$protocol = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http';
$host = $_SERVER['HTTP_HOST'];
$url = $_SERVER['REQUEST_URI'];
$full_url = $protocol . "://" . $host . $url;

$currentDate = getdate();
$year = $currentDate['year'];
$month = str_pad($currentDate['mon'], 2, '0', STR_PAD_LEFT); // Menambahkan nol di depan jika bulan hanya satu digit
$day = str_pad($currentDate['mday'], 2, '0', STR_PAD_LEFT); // Menambahkan nol di depan jika tanggal hanya satu digit

$xTanggal = "$year-$month-$day";
$xkunci = md5(time() . $nim);
$xLink = $full_url;

$arraypesan = array(
  'Jenis Dokumen' => 'DAFTAR HASIL STUDI (DHS)',  
  'Nama Mahasiswa' => $xnama,
  'NPM' => $nim,
  'Program Studi' => $Prodi,
  'Informasi' => 'IPK = ' . number_format($xipk, 2),
  'Penandatangan 1' => 'Ketua : '.$Dekan,
  'Penandatangan 2' => 'Ka. Program Studi, : '.$Kajur,
  'Tanggal Cetak' => date('d-m-Y H:i:s'),
);

$pesan = json_encode($arraypesan);
catatdoc($xkunci, $pesan, $xLink);
$urlverify = $protocol . "://" . $host . "/surat/verifikasi.php?key=" . $xkunci;  
?>
<div class='container mt-3'>
<table class='table table-borderless table-sm'>
  <tbody>
    <tr>
      <td colspan="3" class="text-center">Bandung,  <?php echo formatTanggal($xTanggal);?> </td>
    </tr>
    <tr>
      <td width="33%" class="text-center">Ketua<br> <?php echo $nFak; ?></td>
      <td width="33%" >&nbsp;</td>
      <td width="34%" class="text-center">Ketua Program Studi,<br><?php echo $Prodi; ?></td>
    </tr>
    <tr>
      <td>
        <div align="center" id="qrcode"></div>
          <script type="text/javascript">
             new QRCode(document.getElementById("qrcode"), {
             text: "<?= $urlverify; ?>",
             width: 90,
             height: 90,
             colorDark: "#000000",
             colorLight: "#ffffff",
             correctLevel: QRCode.CorrectLevel.M
            });            
          </script>  

      </td>
      <td>&nbsp;</td>
      <td>
      <div align="center" id="xqrcode"></div>
          <script type="text/javascript">
             new QRCode(document.getElementById("xqrcode"), {
             text: "<?= $urlverify; ?>",
             width: 90,
             height: 90,
             colorDark: "#000000",
             colorLight: "#ffffff",
             correctLevel: QRCode.CorrectLevel.M
            });            
          </script>  
      </td>
    </tr>
    <tr>
      <td class="text-center">(<?php echo $Dekan; ?>)</td>
      <td>&nbsp;</td>
      <td class="text-center">(<?php echo $Kajur; ?>)</td>
    </tr>
  </tbody>
</table>
</div>
<div class='container mt-3'>
<i>Pencetakan Daftar Hasil Studi pada tanggal <?php echo date('d-m-Y H:i:s');?> oleh NPM : <?php echo $nim?></i>
</div>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<?php
} else {
  // Jika parameter Nim tidak diberikan
  echo "Parameter Nim tidak ditemukan.";
}
?>


</body>
</html>
