<?php 
include 'db.php';
include 'funct.php';
?>
<!doctype html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">    
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <style>
        @media print {
            table {
                page-break-inside: auto;
                font-size: 10pt;
                font-family: 'Calibri', sans-serif;
            }

            tr {
                page-break-inside: avoid;
                page-break-after: auto;
            }

            thead {
                display: table-header-group;
            }

            tfoot {
                display: table-footer-group;
            }
        }
    </style>
    <style>
        .page-break {
      page-break-before: always; /* Gunakan 'always' jika ingin elemen dimulai di halaman baru */    
    }
  </style>
    <script src="https://cdn.rawgit.com/davidshimjs/qrcodejs/gh-pages/qrcode.min.js"></script>
    <title>Berita Acara Perkuloiahan - ATB Bandung</title>
</head>


<body>
<div class='container mt-4'>
<?php
// Ambil parameter Nim dari metode GET
if (isset($_GET['nidn']) && isset($_GET['thn_akademik']) && isset($_GET['periode']) && isset($_GET['klsakd']) && isset($_GET['kodemk']) && isset($_GET['grp'])) {
  // Lindungi dari SQL Injection dan XSS Injection
  $nidn = htmlspecialchars($_GET['nidn']);
  $thn_akademik = htmlspecialchars($_GET['thn_akademik']);
  $periode = htmlspecialchars($_GET['periode']);
  $klsakd = htmlspecialchars($_GET['klsakd']);
  $kmk = htmlspecialchars($_GET['kodemk']);
  $grp = htmlspecialchars($_GET['grp']);
  //$kjp = htmlspecialchars($_GET['kjp']);
  if ($periode=="1") {
    $sem = "Ganjil";
  } elseif ($periode=="2") {
    $sem = "Genap";
  } else {
    $sem = "Alih Tahun";
  }
  
    
    // Query untuk mengambil data dari VIEW_MHS dengan kondisi Nim
    $query = "select Kode_Fak, Kode_Mk, Nama_Mk_Ind, SKS, Kelas, Hari, JM, JS, Ruang, NIDN, Nama  from Wali_Jadkulmin Where Thn_Akademik=:th and Periode=:per and Kelas_Akd=:kls and NIDN=:nidn and Kode_Mk=:kmk and Kelas=:grp";
    try {
        // Eksekusi query menggunakan prepared statement
        $stmt = $conn->prepare($query);
        
        // Binding parameter        
        $stmt->bindParam(':th', $thn_akademik, PDO::PARAM_STR);
        $stmt->bindParam(':per', $periode, PDO::PARAM_STR);
        $stmt->bindParam(':kls', $klsakd, PDO::PARAM_STR);
        $stmt->bindParam(':nidn', $nidn, PDO::PARAM_STR);
        $stmt->bindParam(':kmk', $kmk, PDO::PARAM_STR);
        $stmt->bindParam(':grp', $grp, PDO::PARAM_STR);
        //$stmt->bindParam(':kjp', $kjp, PDO::PARAM_STR);
        
        // Eksekusi prepared statement
        $stmt->execute();
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {        
          $xnama = $row['Nama'];
          $mk = $row['Kode_Mk'].' - '.$row['Nama_Mk_Ind'].' ('.$row['SKS'].'SKS)';
          $jadwal =$row['Hari'].', '.date('H:i', strtotime($row['JM'])).'-'.date('H:i', strtotime($row['JS']));
          $ruang = $row['Ruang'];
          //$prod = $row['Prodi'];
          $xkunci = md5(time() . $nidn);
          if ($row['Kode_Fak']="T") {
            $fak = "kstmik.jpg";
          } else {
            $fak = "kstan.jpeg";
          }
          

 ?>

<table width="100%" border="0" cellspacing="0" cellpadding="0">
  <tbody>
    <tr>
      <td colspan="6"><img src="<?php echo $fak; ?>" height="100" alt=""/><hr></td>
    </tr>
    <tr>
      <td colspan="6" align="center"><b><u>DAFTAR HADIR MAHASISWA DAN DOSEN</u></b><br>TAHUN : <?php echo $thn_akademik.' '.strtoupper($sem); ?><br><br></td>
    </tr>
    <tr>
      <td width="12%">Matakuliah</td>
      <td width="1%">:</td>
      <td width="38%"><?php echo $row['Kode_Mk']; ?> - <?php echo $row['Nama_Mk_Ind']; ?> (<?php echo $row['SKS']; ?> SKS)</td>
      <td width="12%">Hari & Jam</td>
      <td width="1%">:</td>
      <td width="36%"><?php echo $row['Hari']; ?>, <?php echo date('H:i', strtotime($row['JM'])); ?> : <?php echo date('H:i', strtotime($row['JS'])); ?></td>
    </tr>
    <tr>
      <td>Dosen Pengampu</td>
      <td>:</td>
      <td><?php echo $row['NIDN']; ?> - <?php echo $row['Nama']; ?></td>
      <td>Ruangan</td>
      <td>:</td>
      <td><?php echo $row['Ruang']; ?></td>
    </tr>
  </tbody>
</table>
<?php
}
  } catch (PDOException $e) {
    echo "Terjadi Kesalahan: " . $e->getMessage();
  } 
  
?>
	<br>  
<?php
// Query untuk mengambil data dari Wali_Nilai dengan kondisi
$query = "select Pertemuan_ke, Tanggal, JM, JS, Jenis, PokokBahasan, SubPokokBahasan, Referensi from Rkp_AbsenDosen Where Thn_Akademik=:th and Periode=:per and Kelas_Akd=:kls and NIDN=:nidn and Kode_Mk=:kmk and Kelas=:grp order by Pertemuan_ke";

try {
    // Eksekusi query menggunakan prepared statement
    $stmt = $conn->prepare($query);
    
    // Binding parameter
    $stmt->bindParam(':th', $thn_akademik, PDO::PARAM_STR);
    $stmt->bindParam(':per', $periode, PDO::PARAM_STR);
    $stmt->bindParam(':kls', $klsakd, PDO::PARAM_STR);
    $stmt->bindParam(':nidn', $nidn, PDO::PARAM_STR);
    //$stmt->bindParam(':nidn1', $nidn, PDO::PARAM_STR);
    $stmt->bindParam(':kmk', $kmk, PDO::PARAM_STR);
    $stmt->bindParam(':grp', $grp, PDO::PARAM_STR);
    //$stmt->bindParam(':kjp', $kjp, PDO::PARAM_STR);

    // Eksekusi prepared statement
    $stmt->execute();
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {    
    $tgl = "";
    $prt = "";
?> 
 <table class='table table-bordered table-sm'>
   <thead>
      <tr>
           <th  colspan="4" align="left">Pertemuan ke : <?php echo $row['Pertemuan_ke']; ?>, Tanggal : <?php echo date('d-m-Y', strtotime($row['Tanggal'])); ?>, Jam : <?php echo date('H:i', strtotime($row['JM'])); ?>-<?php echo date('H:i', strtotime($row['JS'])); ?></th>         
      </tr>
     <tr>
            <th width="15%" align="center">Jenis Perkuliahan</th>
            <th width="25%" align="center">Pokok Bahasan</th>
            <th width="30%" align="center">Sub Pokok Bahasan</th>
            <th width="30%" align="center">Referensi</th>
      </tr>
      </thead>
      <tbody>
        <tr>            
            <td valign="top"> <?php echo $row['Jenis']; ?></td>
            <td valign="top"><?php echo $row['PokokBahasan']; ?></td>
            <td valign="top"><?php echo $row['SubPokokBahasan']; ?></td>
            <td valign="top"><?php echo $row['Referensi']; ?></td>
          </tr>                              
        </tbody>
      </table>        
      
<?php  
$tgl = date('d-m-Y', strtotime($row['Tanggal'] . ' +5 days'));
$prt = $row['Pertemuan_ke'];
}    
  } catch (PDOException $e) {
    echo "Terjadi Kesalahan: " . $e->getMessage();
  }
$protocol = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http';
$host = $_SERVER['HTTP_HOST'];
$url = $_SERVER['REQUEST_URI'];
$full_url = $protocol . "://" . $host . $url;

$xLink = $full_url;

$arraypesan = array(
  'Jenis Dokumen' => 'DAFTAR HADIR DOSEN DAN MAHASISWA',  
  'Tanggal Dokumen' => $tgl,
  'Tahun Akademik' => $thn_akademik.' - '.$sem,
  'Nama Dosen' => $xnama,
  'NIDN' => $nidn,  
  'Matakuliah' => $mk,  
  'Jadwal Kuliah' => $jadwal,
  'Jumlah Pertemuan' => $prt,    
  //'Informasi' => 'Jumlah SKS = ' . $totalSKS, 
  //'Ditandatangani oleh' => $ttd.', '.$namattd,
  'Tanggal Cetak' => date('d-m-Y H:i:s'),
);
$pesan = json_encode($arraypesan);
catatdoc($xkunci, $pesan, $xLink);
$urlverify = $protocol . "://" . $host . "/custom/verifikasi.php?kunci=" . $xkunci;
?>
 <table width="100%" border="0" cellspacing="0" cellpadding="0">
        <tbody>
          <tr>
            <td width="32%" align="center">Ka. BAAK,</td>
            <td width="36%">&nbsp;</td>
            <td width="32%" align="center">Bandung, <?php echo $tgl; ?><br> Dosen Pengampu Matakuliah,</td>
          </tr>
          <tr>
            <td>
          <div align="center" id="qrcodex"></div>
          <script type="text/javascript">
             new QRCode(document.getElementById("qrcodex"), {
             text: "<?= $urlverify; ?>",
             width: 90,
             height: 90,
             colorDark: "#000000",
             colorLight: "#ffffff",
             correctLevel: QRCode.CorrectLevel.M
            });            
          </script> 

            </td>
            <td>&nbsp;</td>
            <td>
          <div align="center" id="qrcode"></div>
          <script type="text/javascript">
             new QRCode(document.getElementById("qrcode"), {
             text: "<?= $urlverify; ?>",
             width: 90,
             height: 90,
             colorDark: "#000000",
             colorLight: "#ffffff",
             correctLevel: QRCode.CorrectLevel.M
            });            
          </script>  
            </td>
          </tr>
          <tr>
            <td align="center"><strong><?php echo getbaak(); ?></strong></td>
            <td>&nbsp;</td>
            <td align="center">(<strong><?php echo $xnama; ?></strong>)</td>
          </tr>
        </tbody>
      </table>
      <p>&nbsp;</p>
<?php

// Daftar hadir Mahasiswa


// Query SQL dengan parameter yang telah dibersihkan
$sql = "SELECT tblnilai.Nim, Nama_Mhs, Kehadiran, Minggu1, Minggu2, Minggu3, Minggu4, Minggu5, Minggu6, Minggu7, Minggu8, Minggu9, Minggu10, Minggu11, Minggu12, Minggu13, Minggu14, Minggu15, Minggu16 
        FROM tblNilai 
        INNER JOIN tblMHS ON tblNilai.Nim = tblmhs.Nim 
        WHERE Thn_Akademik = :th AND Periode = :per AND tblMHS.Status_Akd = :kelas AND Kode_Mk = :mk AND Kls = :grp ";

// Gunakan bind parameters untuk mencegah SQL injection
$stmt = $conn->prepare($sql);
$stmt->bindParam(':th', $thn_akademik, PDO::PARAM_STR);
$stmt->bindParam(':per', $periode, PDO::PARAM_STR);
$stmt->bindParam(':kelas', $klsakd, PDO::PARAM_STR);
$stmt->bindParam(':mk', $kmk, PDO::PARAM_STR);
//$stmt->bindParam(':jp', $kjp, PDO::PARAM_STR);
$stmt->bindParam(':grp', $grp, PDO::PARAM_STR);

// Eksekusi query
$stmt->execute();

// Ambil hasil query
$results = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Tutup koneksi
$conn = null;

?>

</div>
<div class="container mt-3 page-break">
<table width="100%" border="0" cellspacing="0" cellpadding="0">
  <tbody>
    <tr>
      <td colspan="6"><img src="<?php echo $fak; ?>" height="100" alt=""/><hr></td>
    </tr>
    <tr>
      <td colspan="6" align="center"><b><u>DAFTAR HADIR MAHASISWA</u></b><br>TAHUN : <?php echo $thn_akademik.' '.strtoupper($sem); ?><br><br></td>
    </tr>
    <tr>
      <td width="12%">Matakuliah</td>
      <td width="1%">:</td>
      <td width="38%"><?php echo $mk; ?> SKS)</td>
      <td width="12%">Hari & Jam</td>
      <td width="1%">:</td>
      <td width="36%"><?php echo $jadwal; ?></td>
    </tr>
    <tr>
      <td>Dosen Pengampu</td>
      <td>:</td>
      <td><?php echo $nidn; ?> - <?php echo $xnama; ?> </td>
      <td>Ruangan</td>
      <td>:</td>
      <td><?php echo $ruang; ?></td>
    </tr>
  </tbody>
</table>

    <table class="table table-sm table-hover table-bordered">
        <thead>
            <tr>
              <th rowspan="2" align="center">No</th>
              <th rowspan="2">Nim</th>
              <th rowspan="2">Nama Mahasiswa</th>
              <th rowspan="2" align="center">Kehadiran</th>
              <th colspan="16" align="center">Pertemuan Ke</th>
            </tr>
            <tr>
        <th>1</th>
				<th>2</th>
				<th>3</th>
				<th>4</th>
				<th>5</th>
				<th>6</th>
				<th>7</th>
				<th>8</th>
				<th>9</th>
				<th>10</th>
				<th>11</th>
				<th>12</th>
				<th>13</th>
				<th>14</th>
				<th>15</th>
				<th>16</th>
            </tr>
        </thead>
        <tbody>
          <?php 
          $no = 1;
          foreach ($results as $row): 
          ?>
            <tr>
                  <td align="right"><?php echo $no; ?></td>
					        <td><?php echo $row['Nim']; ?></td>
                  <td><?php echo $row['Nama_Mhs']; ?></td>
                  <td><?php echo $row['Kehadiran']; ?></td>
                  <td><?php echo $row['Minggu1']; ?></td>
					        <td><?php echo $row['Minggu2']; ?></td>
					        <td><?php echo $row['Minggu3']; ?></td>
					        <td><?php echo $row['Minggu4']; ?></td>
					        <td><?php echo $row['Minggu5']; ?></td>
					        <td><?php echo $row['Minggu6']; ?></td>
					        <td><?php echo $row['Minggu7']; ?></td>
					        <td><?php echo $row['Minggu8']; ?></td>
					        <td><?php echo $row['Minggu9']; ?></td>
					        <td><?php echo $row['Minggu10']; ?></td>
					        <td><?php echo $row['Minggu11']; ?></td>
					        <td><?php echo $row['Minggu12']; ?></td>
					        <td><?php echo $row['Minggu13']; ?></td>
					        <td><?php echo $row['Minggu14']; ?></td>
					        <td><?php echo $row['Minggu15']; ?></td>					
                  <td><?php echo $row['Minggu16']; ?></td>
                </tr>
            <?php 
             $no = $no + 1;
          endforeach; 
          ?>
        </tbody>
    </table>
<em>Keterangan : H = Hadir, I = Ijin, A = Alpha, S = Sakit</em> </div> 

<div class="container mt-3">
<table width="100%" border="0" cellspacing="0" cellpadding="0">
        <tbody>
          <tr>
            <td width="32%" align="center">Ka. BAAK,</td>
            <td width="36%">&nbsp;</td>
            <td width="32%" align="center">Bandung, <?php echo $tgl; ?><br> Dosen Pengampu Matakuliah,</td>
          </tr>
          <tr>
            <td>
          <div align="center" id="qrcodea"></div>
          <script type="text/javascript">
             new QRCode(document.getElementById("qrcodea"), {
             text: "<?= $urlverify; ?>",
             width: 90,
             height: 90,
             colorDark: "#000000",
             colorLight: "#ffffff",
             correctLevel: QRCode.CorrectLevel.M
            });            
          </script> 

            </td>
            <td>&nbsp;</td>
            <td>
          <div align="center" id="qrcodeb"></div>
          <script type="text/javascript">
             new QRCode(document.getElementById("qrcodeb"), {
             text: "<?= $urlverify; ?>",
             width: 90,
             height: 90,
             colorDark: "#000000",
             colorLight: "#ffffff",
             correctLevel: QRCode.CorrectLevel.M
            });            
          </script>  
            </td>
          </tr>
          <tr>
            <td align="center"><strong><?php echo getbaak(); ?></strong></td>
            <td>&nbsp;</td>
            <td align="center">(<strong><?php echo $xnama; ?></strong>)</td>
          </tr>
        </tbody>
      </table>

</div>
<?php
}
else {
  // Jika parameter Nim tidak diberikan
  echo "Parameter tidak lengkap.";
}
?>
</body>
</html>
