<?php
include 'db.php';

function ambilNPM($string) {
    // Memisahkan string berdasarkan koma
    $separated = explode(',', $string);

    // Mengambil bagian kiri dari hasil pemisahan
    $npm = isset($separated[0]) ? trim($separated[0]) : '';

    return $npm;
}

function formatTanggal($tanggal) {
    $bulan = array(
        '01' => 'Januari',
        '02' => 'Februari',
        '03' => 'Maret',
        '04' => 'April',
        '05' => 'Mei',
        '06' => 'Juni',
        '07' => 'Juli',
        '08' => 'Agustus',
        '09' => 'September',
        '10' => 'Oktober',
        '11' => 'November',
        '12' => 'Desember'
    );   

    $split = preg_split('/[- :.]/', $tanggal);
    $tahun = $split[0];
    $bulanIndex = $split[1];
    $tanggal = $split[2];

    // Pastikan bulanIndex ada dalam array bulan
    if (array_key_exists($bulanIndex, $bulan)) {
        $namaBulan = $bulan[$bulanIndex];
        return $tanggal . ' ' . $namaBulan . ' ' . $tahun;
    } else {
        return 'Format bulan tidak valid';
    }
}


function Predikat($ipk) {
    if ($ipk > 3.5) {
        return 'Dengan Pujian';
    } elseif ($ipk > 2.75 && $ipk <= 3.5) {
        return 'Sangat Memuaskan';
    } elseif ($ipk >= 2 && $ipk <= 2.75) {
        return 'Memuaskan';
    } else {
        return 'Tidak Ada Predikat';
    }
}

function Predeng($ipk) {
  if ($ipk > 3.5) {
      return 'Dengan Pujian / With Honor';
  } elseif ($ipk > 2.75 && $ipk <= 3.5) {
      return 'Sangat Memuaskan / Highly Satisfactory';
  } elseif ($ipk >= 2 && $ipk <= 2.75) {
      return 'Memuaskan / Satisfactory';
  } else {
      return 'Tidak Ada Predikat';
  }
}

function Pred($ipk) {
  if ($ipk > 3.5) {
      return 'With Honor';
  } elseif ($ipk > 2.75 && $ipk <= 3.5) {
      return 'Highly Satisfactory';
  } elseif ($ipk >= 2 && $ipk <= 2.75) {
      return 'Satisfactory';
  } else {
      return 'Tidak Ada Predikat';
  }
}




// Fungsi untuk membersihkan input dari SQL injection
function cleanInput($input) {
    $search = array(
        '@<script[^>]*?>.*?</script>@si',   // Menghapus script
        '@<[\/\!]*?[^<>]*?>@si',            // Menghapus tag HTML
        '@<style[^>]*?>.*?</style>@siU',    // Menghapus tag style
        '@<![\s\S]*?--[ \t\n\r]*>@'         // Menghapus komentar multi-baris
    );

    $output = preg_replace($search, '', $input);
    return $output;
}

// Fungsi untuk membersihkan input dari XSS injection
function sanitize($input) {
    if (is_array($input)) {
        foreach ($input as $key => $val) {
            $input[$key] = sanitize($val);
        }
    } else {
        $input = cleanInput($input);
    }
    return $input;
}

// Ambil NIM dari parameter GET dan bersihkan dari SQL dan XSS injection
$xnim = isset($_GET['nim']) ? sanitize($_GET['nim']) : '';
$nim = ambilNPM($xnim);

try {
    // Query untuk menampilkan record berdasarkan NIM
    $query = "SELECT NIM, Nama_Mhs, Tmp_Lahir, Tgl_Lahir, Tgl_Cetak, Jurusan, Program, SK, Pin, Kepribadian, Konsentrasi, Tgl_Lulus, Judul_TA, IPK, sks FROM Luusan WHERE NIM = :nim";
    $stmt = $conn->prepare($query);
    $stmt->bindParam(':nim', $nim, PDO::PARAM_STR);
    $stmt->execute();

    // Tampilkan hasil query
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        // Output hasil query setelah membersihkan dari XSS injection
        $xnim = htmlspecialchars($row['NIM']);
        $xnama = htmlspecialchars($row['Nama_Mhs']);
        $xTmpLahir = htmlspecialchars($row['Tmp_Lahir']);
        $yTglLahir = $row['Tgl_Lahir'];
        if ($row['Tgl_Lahir'] !== null) {
            $xTglLahir = formatTanggal($row['Tgl_Lahir']);
        } else {
            $xTglLahir = '';
        }
        
        if ($row['Tgl_Cetak'] !== null) {
            $xTglCetak = formatTanggal($row['Tgl_Cetak']);
        } else {
            $xTglCetak = '';
        }
        $yTglCetak = $row['Tgl_Cetak'];
        $xjur = ucwords(strtolower($row['Jurusan'])); 
        if ($row['Program']=='D3') 
        {
            $xprog = 'Diploma III (Tiga)' ;
        } else
        {
            $xprog = 'Program Satu Tahun' ;
        }
        
        $xsk = htmlspecialchars($row['SK']);
        $xpin = htmlspecialchars($row['Pin']);
        $xpribadi = htmlspecialchars($row['Kepribadian']);
        $xkonsen = htmlspecialchars($row['Konsentrasi']);
        
        if ($row['Tgl_Lulus'] !== null) {
            $xtgllulus = formatTanggal($row['Tgl_Lulus']);        
        } else {
            $xtgllulus = '';
        }        
        $xTA = htmlspecialchars($row['Judul_TA']);
        $xIPK = number_format($row['IPK'], 2, ',', '.'); 
        $xpredikat = Predikat($row['IPK']); 
        $xpredeng = Predeng($row['IPK']);         
        $xpred = Pred($row['IPK']);         
        $xsks = $row['sks'];
    }
} catch (PDOException $e) {
    echo "Terjadi Kesalahan pada Query: " . $e->getMessage();
}
?>

<!doctype html>
<html>
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Transkrip Akademik</title> 
 <!-- Normalize or reset CSS with your favorite library -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/normalize/7.0.0/normalize.min.css">
  <!-- Load paper.css for happy printing -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/paper-css/0.4.1/paper.css">
  <!-- Set page size here: A5, A4 or A3 -->
  <!-- Set also "landscape" if you need -->
  <style>@page { size: legal }</style> 
  <link rel="stylesheet" href="trans.css">
</head>
<body class="legal">
<?php
if ($xprog == 'Diploma III (Tiga)') {
?>

<section class="sheet padding-10mm">
 <p>&nbsp;</p> <p>&nbsp;</p> <p>&nbsp;</p>
<p><h3 style="text-align: center;">TRANSKRIP AKADEMIK</h3></p>
<table width="100%" border="0" class="table-font-9">
  <tbody>
    <tr>
      <td width="35%">PIN</td>
      <td width="65%">: 234567890</td>
    </tr>
    <tr>
      <td>Nomor Seri Ijazah</td>
      <td>: 0736 /TB. D-III/2023</td>
    </tr>
    <tr>
      <td>Nama</td>
      <td>: <?php echo $xnama; ?> </td>
    </tr>
    <tr>
      <td>Nomor Induk Mahasiswa</td>
      <td>: <?php echo $xnim; ?></td>
    </tr>
    <tr>
      <td>Tempat Tanggal Lahir</td>
      <td>: <?php echo rtrim($xTmpLahir); ?>, <?php echo $xTglLahir; ?> </td>
    </tr>
    <tr>
      <td>Program Pendidikan</td>
      <td>: <?php echo $xprog; ?></td>
    </tr>
    <tr>
      <td>Konsentrasi</td>
      <td>: <?php echo $xjur; ?></td>
    </tr>
    <tr>
      <td>Tanggal Kelulusan</td>
      <td>: <?php echo $xtgllulus; ?></td>
    </tr>
  </tbody>
</table>

<?php

try {
    // Query untuk menampilkan semua record
    $query = "SELECT Kode_MK, Nama_Mk_Ind, Nama_Mk_Ing, SKS, dbo.n2a(Grade) as Nilai, Grade FROM dbo.ctranskrip(:nim) Order By Semester";
    $stmt = $conn->prepare($query);
    $stmt->bindParam(':nim', $nim, PDO::PARAM_STR);
    $stmt->execute();

    // Ambil semua data hasil query
    $allData = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Hitung jumlah data
    $totalData = count($allData);

    // Bagi data menjadi dua bagian
    $half = ceil($totalData / 2);
    $firstHalf = array_slice($allData, 0, $half);
    $secondHalf = array_slice($allData, $half);
  ?>

<table width="100%" border="0">
  <tbody>
    <tr>
    <td width="50%" valign="top">
	   <table width="100%" class="styled-table">
      <thead>
          <tr align="center">
            <th>No</th>
            <th>Kode</th>
            <th>Nama Matakuliah</th>
            <th>SKS</th>
            <th>N</th>
          </tr>
        </thead>        
          <tbody>
<?php
        foreach ($firstHalf as $index => $row) {
?>            
          <tr align="center">
            <td align="right"><?php echo ($index + 1); ?></td>
            <td><?php echo $row['Kode_MK'];?></td>
            <td align="left"><?php echo $row['Nama_Mk_Ind'];?></td>
            <td><?php echo $row['SKS'];?></td>
            <td align="left"><?php echo $row['Nilai'];?></td>
          </tr>          
<?php
    }
?>               
        </tbody>
      </table></td>
      <td width="50%" valign="top">
	   <table width="100%" class="styled-table">
        <thead>
          <tr align="center">
            <th>No</th>
            <th>Kode</th>
            <th>Nama Matakuliah</th>
            <th>SKS</th>
            <th>N</th>
          </tr>
        </thead>
        <tbody>
<?php
        foreach ($secondHalf as $index => $row) {
?>            
        <tr align="center">
            <td align="right"><?php echo ($index + $half + 1); ?></td>
            <td><?php echo $row['Kode_MK'];?></td>
            <td align="left"><?php echo $row['Nama_Mk_Ind'];?></td>
            <td><?php echo $row['SKS'];?></td>
            <td align="left"><?php echo $row['Nilai'];?></td>
          </tr> 
 <?php 
    }
  ?>  
          <tr align="center">
            <td colspan="3"><strong>Jumlah</strong></td>            
            <td><b><?php echo $xsks; ?></b></td>
            <td></td>
          </tr>
        </tbody>
      </table>
	</td>
    </tr>
  </tbody>
</table>
<?php

} catch (PDOException $e) {
    echo "Terjadi Kesalahan pada Query: " . $e->getMessage();
}
?>

<table width="100%" border="0" class="table-font-9">
  <tbody>
    <tr>
      <td colspan="4">Judul Laporan : <?php echo $xTA; ?><br></td>
    </tr>    
    <tr>
      <td width="35%">IPK</td>
      <td colspan="3">: <?php echo $xIPK; ?></td>
      </tr>
    <tr>
      <td>Predikat</td>
      <td colspan="3">: <?php echo $xpredikat; ?></td>
      </tr>
    <tr>
      <td>Kepribadian</td>
      <td colspan="3">: <?php echo $xpribadi; ?></td>
      </tr>
    <tr>
      <td colspan="4">&nbsp;</td>
      </tr>
    <tr>
      <td colspan="2">TRANSKRIP INI DIBUAT DENGAN SEBENARNYA</td>
      <td width="27%" colspan="2">&nbsp;</td>
    </tr>
    <tr>
      <td colspan="2">&nbsp;</td>
      <td colspan="2">Bandung, <?php echo $xTglCetak;?></td>
    </tr>
    <tr>
      <td colspan="2">Direktur,</td>
      <td colspan="2">Wakil Direktur Bidang Akademik,</td>
    </tr>
    <tr>
      <td colspan="2">&nbsp;</td>
      <td colspan="2">&nbsp;</td>
    </tr>
    <tr>
      <td colspan="2">&nbsp;</td>
      <td colspan="2">&nbsp;</td>
    </tr>
    <tr>
      <td colspan="2">&nbsp;</td>
      <td colspan="2">&nbsp;</td>
    </tr>
    <tr>
      <td colspan="2">&nbsp;</td>
      <td colspan="2">&nbsp;</td>
    </tr>
    <tr>
      <td colspan="2">&nbsp;</td>
      <td colspan="2">&nbsp;</td>
    </tr>
    <tr>
      <td colspan="2"><strong> <u>Dr. Diah Banyuni,S.Sos., M.Pd. </u><br>
      NIY. 1993090008</strong></td>
      <td colspan="2"><strong><u>Yudha Abubakar, S.Sos.,M.Pd. </u><br>
      NIY. 200608158 </strong></td>
    </tr>
  </tbody>
</table>
 </section>	


<!-- Start English D3 -->


 <section class="sheet padding-10mm">
 <p>&nbsp;</p> <p>&nbsp;</p> <p>&nbsp;</p>
<p><h3 style="text-align: center;">ACADEMIC TRANSCRIPT</h3></p>
<table width="100%" border="0" class="table-font-9">
  <tbody>
    <tr>
      <td width="35%">PIN</td>
      <td width="75%">: 234567890</td>
    </tr>
    <tr>
      <td>Number Of Diploma</td>
      <td>: 0736 /TB. D-III/2023</td>
    </tr>
    <tr>
      <td>Name</td>
      <td>: <?php echo $xnama; ?> </td>
    </tr>
    <tr>
      <td>Registration Number</td>
      <td>: <?php echo $xnim; ?></td>
    </tr>
    <tr>
      <td>Place-Date of Birth</td>
      <td>: <?php echo rtrim($xTmpLahir); ?>, <?php echo  date("F j, Y", strtotime($xTglLahir)); ?> </td>
    </tr>
    <tr>
      <td>Degree of Education</td>
      <td>: <?php echo $xprog; ?></td>
    </tr>
    <tr>
      <td>Concentration</td>
      <td>: <?php echo $xjur; ?></td>
    </tr>
    <tr>
      <td>Date of Graduation</td>
      <td>: <?php echo $xtgllulus; ?></td>
    </tr>
  </tbody>
</table>

<?php

try {
    // Query untuk menampilkan semua record
    $query = "SELECT Kode_MK, Nama_Mk_Ind, Nama_Mk_Ing, SKS, dbo.n2a(Grade) as Nilai, Grade FROM dbo.ctranskrip(:nim) Order By Semester";
    $stmt = $conn->prepare($query);
    $stmt->bindParam(':nim', $nim, PDO::PARAM_STR);
    $stmt->execute();

    // Ambil semua data hasil query
    $allData = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Hitung jumlah data
    $totalData = count($allData);

    // Bagi data menjadi dua bagian
    $half = ceil($totalData / 2);
    $firstHalf = array_slice($allData, 0, $half);
    $secondHalf = array_slice($allData, $half);
  ?>

<table width="100%" border="0">
  <tbody>
    <tr>
    <td width="50%" valign="top">
	   <table width="100%" class="styled-table">
      <thead>
          <tr align="center">
            <th>No.</th>
            <th>Code</th>
            <th>Name of Courses</th>
            <th>SKS</th>
            <th>N/G</th>
          </tr>
        </thead>        
          <tbody>
<?php
        foreach ($firstHalf as $index => $row) {
?>            
          <tr align="center">
            <td align="right"><?php echo ($index + 1); ?></td>
            <td><?php echo $row['Kode_MK'];?></td>
            <td align="left"><?php echo $row['Nama_Mk_Ing'];?></td>
            <td><?php echo $row['SKS'];?></td>
            <td align="left"><?php echo $row['Nilai'];?></td>
          </tr>          
<?php
    }
?>               
        </tbody>
      </table></td>
      <td width="50%" valign="top">
	   <table width="100%" class="styled-table">
        <thead>
          <tr align="center">
            <th>No</th>
            <th>Kode</th>
            <th>Nama Matakuliah</th>
            <th>SKS</th>
            <th>N</th>
          </tr>
        </thead>
        <tbody>
<?php
        foreach ($secondHalf as $index => $row) {
?>            
        <tr align="center">
            <td align="right"><?php echo ($index + $half + 1); ?></td>
            <td><?php echo $row['Kode_MK'];?></td>
            <td align="left"><?php echo $row['Nama_Mk_Ing'];?></td>
            <td><?php echo $row['SKS'];?></td>
            <td align="left"><?php echo $row['Nilai'];?></td>
          </tr> 
 <?php 
    }
  ?>  
          <tr align="center">
            <td colspan="3"><strong>Jumlah</strong></td>            
            <td><b><?php echo $xsks; ?></b></td>
            <td></td>
          </tr>
        </tbody>
      </table>
	</td>
    </tr>
  </tbody>
</table>
<?php

} catch (PDOException $e) {
    echo "Terjadi Kesalahan pada Query: " . $e->getMessage();
}
?>

<table width="100%" border="0" class="table-font-9">
  <tbody>
    <tr>
      <td colspan="4">Title of the Final Report : <?php echo $xTA; ?><br></td>
    </tr>  
    <tr>
      <td width="35%">Grade Point Average</td>
      <td colspan="3">: <?php echo $xIPK; ?></td>
      </tr>
    <tr>
      <td>Yudicium</td>
      <td colspan="3">: <?php echo $xpred; ?></td>
      </tr>
    <tr>
      <td>Profesional Attitude</td>
      <td colspan="3">: <?php echo $xpribadi; ?></td>
      </tr>
    <tr>
      <td colspan="4">&nbsp;</td>
      </tr>
    <tr>
      <td colspan="2">THIS TRANSCRIPT TIS CERTIFIED TO BE CORRECT AND ACCURATE</td>
      <td width="27%" colspan="2">&nbsp;</td>
    </tr>
    <tr>
      <td colspan="2">&nbsp;</td>
      <td colspan="2">Bandung, <?php echo date("F j, Y", strtotime($yTglCetak));?></td>
    </tr>
    <tr>
      <td colspan="2">Director,</td>
      <td colspan="2">Vice Director of Academic,</td>
    </tr>
    <tr>
      <td colspan="2">&nbsp;</td>
      <td colspan="2">&nbsp;</td>
    </tr>
    <tr>
      <td colspan="2">&nbsp;</td>
      <td colspan="2">&nbsp;</td>
    </tr>
    <tr>
      <td colspan="2">&nbsp;</td>
      <td colspan="2">&nbsp;</td>
    </tr>
    <tr>
      <td colspan="2">&nbsp;</td>
      <td colspan="2">&nbsp;</td>
    </tr>
    <tr>
      <td colspan="2">&nbsp;</td>
      <td colspan="2">&nbsp;</td>
    </tr>
    <tr>
      <td colspan="2"><strong> <u>Dr. Diah Banyuni,S.Sos., M.Pd. </u><br>
      NIY. 1993090008</strong></td>
      <td colspan="2"><strong><u>Yudha Abubakar, S.Sos.,M.Pd.</u> <br>
      NIY. 200608158 </strong></td>
    </tr>
  </tbody>
</table>
 </section>	



<!-- End English D3 -->









 <?php
 } else
 { 
  ?> 
<section class="sheet padding-10mm">
 <p>&nbsp;</p> <p>&nbsp;</p> <p>&nbsp;</p>
<p><h2 style="text-align:center;">TRANSKRIP AKADEMIK<br><i>ACADEMIC TRANSCRIPT</i></h3></p>
<table width="100%" border="0" class="table-font-9">
  <tbody>
    <tr>
      <td width="35%">Nomor Seri Serifikat / <i>Number of Certificate</i></td>
      <td width="75%">: 234567890</td>
    </tr>    
    <tr>
      <td>Nama / <i>Name</></td>
      <td>: <?php echo $xnama; ?> </td>
    </tr>
    <tr>
      <td>NPD / <i>Registration Number</i></td>
      <td>: <?php echo $xnim; ?></td>
    </tr>
    <tr>
      <td>Tempat Tanggal Lahir / <i>Place-Date of Birth</i></td>
      <td>: <?php echo rtrim($xTmpLahir); ?>, <?php echo $xTglLahir; ?> </td>
    </tr>
    <tr>
      <td>Program Pendidikan / <i>Degree of Education</i></td>
      <td>: <?php echo $xprog; ?></td>
    </tr>
    <tr>
      <td>Konsentrasi / <i>Concentration</i></td>
      <td>: <?php echo $xjur; ?></td>
    </tr>
    <tr>
      <td>Tanggal Sertifikat / <i>Date of Certificate</i></td>
      <td>: <?php echo $xtgllulus; ?></td>
    </tr>
  </tbody>
</table>

<?php

try {
    // Query untuk menampilkan semua record
    $query = "SELECT Kode_MK, Nama_Mk_Ind, Nama_Mk_Ing, SKS, dbo.n2a(Grade) as Nilai, Grade FROM dbo.ctranskrip(:nim) Order By Semester";
    $stmt = $conn->prepare($query);
    $stmt->bindParam(':nim', $nim, PDO::PARAM_STR);
    $stmt->execute();

    // Ambil semua data hasil query
    $allData = $stmt->fetchAll(PDO::FETCH_ASSOC);
  ?>

<table width="100%" border="0">
  <tbody>
    <tr>    
    <td width="50%" valign="top">
	   <table width="100%" class="styled-table">
        <thead>
          <tr align="center">
            <th>No</th>
            <th>Kode</th>
            <th>Nama Mata Kuliah / <i>Name of Courses</i></th>
            <th>SKS/S</th>
            <th>N/G</th>
          </tr>
        </thead>
        <tbody>
<?php  
  $no=1;
        foreach ($allData as $row) {
?>            
        <tr align="center">
            <td align="right"><?php echo $no; ?></td>
            <td><?php echo $row['Kode_MK'];?></td>
            <td align="left"><?php echo $row['Nama_Mk_Ind']."<i>/".$row['Nama_Mk_Ing']."</i>";?></td>
            <td><?php echo $row['SKS'];?></td>
            <td align="left"><?php echo $row['Nilai'];?></td>
          </tr> 
 <?php 
 $no++;
    }
  ?>  
          <tr align="center">
            <td colspan="3"><strong>JUMLAH / <i>AMOUNT</i></strong></td>            
            <td><b><?php echo $xsks; ?></b></td>
            <td></td>
          </tr>
        </tbody>
      </table>
	</td>
    </tr>
  </tbody>
</table>
<?php

} catch (PDOException $e) {
    echo "Terjadi Kesalahan pada Query: " . $e->getMessage();
}
?>

<table width="100%" border="0" class="table-font-9">
  <tbody>    
    <tr>
      <td colspan="4">&nbsp;</td>
    </tr>
    <tr>
      <td width="35%">IPK / <i>Grade Point Average</i></td>
      <td colspan="3">: <?php echo $xIPK; ?></td>
      </tr>
    <tr>
      <td>Predikat / <i>Yudicium</i></td>
      <td colspan="3">: <?php echo $xpredeng; ?></td>
      </tr>
    <tr>
      <td>Kepribadian / <i>Profesional Attitude</i></td>
      <td colspan="3">: <?php echo $xpribadi; ?></td>
      </tr>
    <tr>
      <td colspan="4">&nbsp;</td>
      </tr>
    <tr>
      <td colspan="2">TRANSKRIP INI DIBUAT DENGAN SEBENARNYA<br> <i>THIS TRANSCRIPT IS CERTIFIED TO BE CORRECT AND ACCURATE</i></td>
      <td width="27%" colspan="2">&nbsp;</td>
    </tr>
    <tr>
      <td colspan="2">&nbsp;</td>
      <td colspan="2">Bandung, <?php echo $xTglCetak;?></td>
    </tr>
    <tr>
      <td colspan="2">Direktur / <i>Director,</i></td>
      <td colspan="2">Wakil Direktur / <i>Vice Director,</i></td>
    </tr>
    <tr>
      <td colspan="2">&nbsp;</td>
      <td colspan="2">&nbsp;</td>
    </tr>
    <tr>
      <td colspan="2">&nbsp;</td>
      <td colspan="2">&nbsp;</td>
    </tr>
    <tr>
      <td colspan="2">&nbsp;</td>
      <td colspan="2">&nbsp;</td>
    </tr>
    <tr>
      <td colspan="2">&nbsp;</td>
      <td colspan="2">&nbsp;</td>
    </tr>
    <tr>
      <td colspan="2">&nbsp;</td>
      <td colspan="2">&nbsp;</td>
    </tr>
    <tr>
      <td colspan="2"><strong>Dr. Diah Banyuni,S.Sos., M.Pd. <br>
      NIY. 1993090008</strong></td>
      <td colspan="2"><strong>Yudha Abubakar, S.Sos.,M.Pd. <br>
      NIY. 200608158 </strong></td>
    </tr>
  </tbody>
</table>
 </section>	


<?php
 }
 ?>
</body>
</html>

