<?php 
include 'db.php';
include 'funct.php';
?>
<!doctype html>
<html>
<head>
<meta charset="utf-8">
<title>Surat Tugas Pengampu - ATB BANDUNG</title>
 <!-- Normalize or reset CSS with your favorite library -->
 <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/normalize/7.0.0/normalize.min.css">
 <!-- Load paper.css for happy printing -->
 <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/paper-css/0.4.1/paper.css">
 <!-- Set page size here: A5, A4 or A3 -->
 <!-- Set also "landscape" if you need -->
 <style>@page { size: A4 }</style>  
 <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
 <link rel="stylesheet" href="table.css">
 <script src="https://cdn.rawgit.com/davidshimjs/qrcodejs/gh-pages/qrcode.min.js"></script>
</head>
<body class="A4">
<section class="sheet padding-10mm">
<?php
// Ambil parameter Nim dari metode GET
if (isset($_GET['nidn']) && isset($_GET['thn_akademik']) && isset($_GET['periode'])) {
  // Lindungi dari SQL Injection dan XSS Injection
  $nidn = htmlspecialchars($_GET['nidn']);
  $thn_akademik = htmlspecialchars($_GET['thn_akademik']);
  $periode = htmlspecialchars($_GET['periode']);
  if ($periode=="1") {
    $sem = "Ganjil";
  } elseif ($periode=="2") {
    $sem = "Genap";
  } else {
    $sem = "Alih Tahun";
  }

   
    
    // Query untuk mengambil data dari VIEW_MHS dengan kondisi Nim
    $query = "select Thn_Akademik, Periode, Kelas_Akd, NIDN, Nama, Gol, Pangkat, JabatanFungsional, NomorSK, TglSK, ttdOleh, NamaTTd from Vriwayatngajar where NIDN=:nidn and Thn_Akademik=:th and Periode=:per";

    try {
        // Eksekusi query menggunakan prepared statement
        $stmt = $conn->prepare($query);
        
        // Binding parameter
        $stmt->bindParam(':nidn', $nidn, PDO::PARAM_STR);
        $stmt->bindParam(':th', $thn_akademik, PDO::PARAM_STR);
        $stmt->bindParam(':per', $periode, PDO::PARAM_STR);
        
        // Eksekusi prepared statement
        $stmt->execute();
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {        
          $nosk = $row['NomorSK'];
          $tgl  = $row['TglSK']; 
          $ttd  = $row['ttdOleh']; 
          $namattd  = $row['NamaTTd']; 
          $xnama = $row['Nama'];
?>
<table width="100%" class="table-no-border">
  <tbody>
    <tr>
      <td colspan="4" align="left"><img src="kopatb.png" height="85"  alt="ATB-BANDUNG" /><hr></td>
    </tr>
    <tr>
      <td colspan="4">
		<table width="100%">
        <tbody>
          <tr>
            <td align="center"><strong><u>SURAT TUGAS</u></strong><br>Nomor : <?php echo $row['NomorSK']; ?> </td>
          </tr>
        </tbody>
      </table>
		 <p>Yang bertanda tangan dibawah ini Direktur Akademi Tata Boga Bandung, memberikan tugas kepada  :</p>
	</td>
    </tr>
    <tr>      
      <td width="21%">Nama</td>
      <td width="2%">:</td>
      <td width="77%"><?php echo $row['Nama']; ?></td>
      </tr>
    <tr>     
      <td>NIDN</td>
      <td>:</td>
      <td><?php echo $row['NIDN']; ?></td>
      </tr>
    <tr>
      <td>Gol / Pangkat</td>
      <td>:</td>
      <td><?php echo $row['Gol']; ?> / <?php echo $row['Pangkat']; ?></td>
      </tr>
    <tr>
      <td>Jabatan Fungsional</td>
      <td>:</td>
      <td><?php echo $row['JabatanFungsional']; ?></td>
      </tr>
	  <tr>
	  <td colspan="4"> 
		 <p>untuk mengampu dan menguji matakuliah di Akademi Tata Boga Bandung Tahun Akademik <?php echo $thn_akademik; ?> Semester <?php echo $sem; ?>, sebagai berikut : </p>
	  </td>
	  </tr>
  </tbody>
</table>
<?php
}
  } catch (PDOException $e) {
    echo "Terjadi Kesalahan: " . $e->getMessage();
  } 
  
?>
	<br>

<?php
// Query untuk mengambil data dari Wali_Nilai dengan kondisi
$query = "select Kode_Mk, Matakuliah, SKS, Kelas, Hari, JM, JS, Ruang, Prodi  from VJadwalKuliah WHERE NIDN = :nidn AND Thn_Akademik = :thn_akademik AND Periode = :periode";

try {
    // Eksekusi query menggunakan prepared statement
    $stmt = $conn->prepare($query);
    
    // Binding parameter
    $stmt->bindParam(':nidn', $nidn, PDO::PARAM_STR);
    $stmt->bindParam(':thn_akademik', $thn_akademik, PDO::PARAM_STR);
    $stmt->bindParam(':periode', $periode, PDO::PARAM_STR);
    
    // Eksekusi prepared statement
    $stmt->execute();

    // Inisialisasi variabel untuk menghitung total SKS dan total mutu
    $totalSKS = 0;    
    $no = 1;
?>

  <table width="100%" class="table-border-1">
  <tbody>
    <tr>
      <td width="4%" align="center">No</td>
      <td width="10%" align="center">Kode <br></td>
      <td width="40%" align="center">Nama Matakuliah</td>
      <td width="5%" align="center">SKS</td>
      <td width="6%" align="center">Rombel</td>
      <td width="25%" align="center">Program Studi</td>      
    </tr>
<?php
 while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {

?>
    <tr>
      <td align="right"><?php echo $no; ?></td>
      <td align="center"><?php echo $row['Kode_Mk']; ?></td>
      <td><?php echo $row['Matakuliah']; ?></td>
      <td align="center"><?php echo $row['SKS']; ?></td>
      <td align="center"><?php echo $row['Kelas']; ?></td>
      <td align="center"><?php echo $row['Prodi']; ?></td>      
    </tr>
<?php
      // Menambahkan nilai SKS dan Mutu ke total
      $totalSKS += $row['SKS'];     
      $no += 1;
  }  
  
} catch (PDOException $e) {
  echo "Terjadi Kesalahan: " . $e->getMessage();
}
?>
    <tr>
      <td colspan="3" align="right">Jumlah SKS </td>
      <td align="center"><?php echo $totalSKS; ?></td>
      <td>&nbsp;</td>
      <td>&nbsp;</td>      
    </tr>
  </tbody>
</table>
<i>Jadwal bisa dilihat di portal dosen : <a href="https//dsn.atb-bandung.ac.id">https//dsn.atb-bandung.ac.id</a></i>
<?php
$protocol = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http';
$host = $_SERVER['HTTP_HOST'];
$url = $_SERVER['REQUEST_URI'];
$full_url = $protocol . "://" . $host . $url;

$currentDate = getdate();
$year = $currentDate['year'];
$month = str_pad($currentDate['mon'], 2, '0', STR_PAD_LEFT); // Menambahkan nol di depan jika bulan hanya satu digit
$day = str_pad($currentDate['mday'], 2, '0', STR_PAD_LEFT); // Menambahkan nol di depan jika tanggal hanya satu digit

// Menyusun hasil dalam format "YYYY-MM-DD"
$xTanggal = "$year-$month-$day";
$xkunci = md5(time() . $nidn);
$xLink = $full_url;

$arraypesan = array(
  'Jenis Dokumen' => 'SURAT TUGAS PENGAMPU MATAKULIAH',
  'Nomor' => $nosk,
  'Tanggal' => $tgl,
  'Tahun Akademik' => $sem.' '.$thn_akademik,
  'Nama Dosen' => $xnama,
  'NIDN' => $nidn,  
  'Informasi' => 'Jumlah SKS = ' . $totalSKS, 
  'Ditandatangani oleh' => $ttd.', '.$namattd,
  'Tanggal Cetak' => date('d-m-Y H:i:s'),
);
$pesan = json_encode($arraypesan);
catatdoc($xkunci, $pesan, $xLink);
$urlverify = $protocol . "://" . $host . "/custom/verifikasi.php?kunci=" . $xkunci;
?>



<table width="100%" class="table-no-border">
  <tbody>
    <tr>
      <td colspan="2" class="paragraph"> <p> Mengingat pentingnya peran Saudara dalam memberikan materi perkuliahan, kami berharap agar Saudara dapat melaksanakan tugas ini dengan penuh tanggung jawab. Mohon untuk menyampaikan perkembangan dan kendala yang dihadapi selama pelaksanaan perkuliahan kepada Koordinator Program Studi.</p>
      <p>Demikian surat tugas ini kami sampaikan. Atas perhatian dan kerjasama Saudara, kami mengucapkan terima kasih.</p></td>
      </tr>
    <tr>
      <td width="67%">&nbsp;</td>
      <td width="33%" align="center">Bandung, <?php echo formatTanggal($xTanggal);?> <br> 
      <?php echo $ttd; ?>,</td>
    </tr>
    
    <tr>
      <td>&nbsp;</td>
      <td>
      <div align="center" id="qrcode"></div>
          <script type="text/javascript">
             new QRCode(document.getElementById("qrcode"), {
             text: "<?= $urlverify; ?>",
             width: 90,
             height: 90,
             colorDark: "#000000",
             colorLight: "#ffffff",
             correctLevel: QRCode.CorrectLevel.M
            });            
          </script>  


      </td>
    </tr>
    <tr>
      <td>&nbsp;</td>
      <td align="center"><strong>(<?php echo $namattd; ?>)</strong><br></td>
    </tr>
    
  </tbody>
</table>
<?php	
} else {
    // Jika parameter Nim, Thn_Akademik, atau Periode tidak diberikan
    echo "Parameter Nim, Tahun Akademik, atau Periode tidak ditemukan.";
}
?> 
</section>
</body>
</html>
