<!DOCTYPE html>
<html lang="en">
<head>
  <title>IM - Verifikasi Dokument</title>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
 </head>
<body>
<?php
// Include file db.php untuk mendapatkan koneksi database
include 'db.php';

// Ambil nilai parameter $key dari URL dengan metode GET
$key = isset($_GET['kunci']) ? $_GET['kunci'] : '';

try {
    // SQL untuk menampilkan data dari tblVerifikasi berdasarkan xKey
    $sql = "SELECT xKey, Pesan, Link FROM tblVerifikasi WHERE xKey = :key";

    // Persiapkan statement SQL
    $stmt = $conn->prepare($sql);

    // Bind parameter
    $stmt->bindParam(':key', $key);

    // Eksekusi statement
    $stmt->execute();

    // Ambil hasil query
    $result = $stmt->fetch(PDO::FETCH_ASSOC);

    // Tampilkan hasil
    if ($result) {     

        // Dekode Pesan dari format JSON
        $pesanData = json_decode($result['Pesan'], true);
        
        if (substr($pesanData['NIM'],0,2) === "35" || substr($pesanData['NIM'],0,2) === "36" || substr($pesanData['NIM'],0,2) === "25" || substr($pesanData['NIM'],0,2) === "26") {
            $logo = "stmik.png";
        } else {
            $logo = "stan.png";  
        }
        
        // Tampilkan dalam bentuk tabel dinamis dengan Bootstrap 5
        echo '<div class="container mt-4">';		
        echo '<table class="table table-bordered">';
        echo '<thead><tr><th class="text-center" scope="col" colspan="2" > <img src="'.$logo.'" height="85" alt="ulbi"/></th></tr></thead>';
        echo '<tbody>';

        foreach ($pesanData as $field => $value) {
            echo "<tr><td>$field</td><td>$value</td></tr>";
        }
		//echo '<tr><td colspan="2" class="text-center" > Dokumen terkait versi terupdate dapat diakses <a href="'.$result['Link'].'">disini</a></td></tr>';
        echo '</tbody>';
        echo '</table>';
        echo '</div>';
    } else {
        echo "Data tidak ditemukan.";
    }

} catch(PDOException $e) {
    // Tangkap kesalahan dan tampilkan pesan error
    echo "Terjadi kesalahan: " . $e->getMessage();
}
?>
