<?php
namespace PHPMaker2020\baak;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$docmhs_view = new docmhs_view();

// Run the page
$docmhs_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$docmhs_view->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$docmhs_view->isExport()) { ?>
<script>
var fdocmhsview, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "view";
	fdocmhsview = currentForm = new ew.Form("fdocmhsview", "view");
	loadjs.done("fdocmhsview");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$docmhs_view->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $docmhs_view->ExportOptions->render("body") ?>
<?php $docmhs_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $docmhs_view->showPageHeader(); ?>
<?php
$docmhs_view->showMessage();
?>
<form name="fdocmhsview" id="fdocmhsview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="docmhs">
<input type="hidden" name="modal" value="<?php echo (int)$docmhs_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($docmhs_view->Nim->Visible) { // Nim ?>
	<tr id="r_Nim">
		<td class="<?php echo $docmhs_view->TableLeftColumnClass ?>"><span id="elh_docmhs_Nim"><?php echo $docmhs_view->Nim->caption() ?></span></td>
		<td data-name="Nim" <?php echo $docmhs_view->Nim->cellAttributes() ?>>
<span id="el_docmhs_Nim">
<span<?php echo $docmhs_view->Nim->viewAttributes() ?>><?php echo $docmhs_view->Nim->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($docmhs_view->Ijazah->Visible) { // Ijazah ?>
	<tr id="r_Ijazah">
		<td class="<?php echo $docmhs_view->TableLeftColumnClass ?>"><span id="elh_docmhs_Ijazah"><?php echo $docmhs_view->Ijazah->caption() ?></span></td>
		<td data-name="Ijazah" <?php echo $docmhs_view->Ijazah->cellAttributes() ?>>
<span id="el_docmhs_Ijazah">
<span<?php echo $docmhs_view->Ijazah->viewAttributes() ?>><?php echo GetFileViewTag($docmhs_view->Ijazah, $docmhs_view->Ijazah->getViewValue(), FALSE) ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($docmhs_view->Ktp->Visible) { // Ktp ?>
	<tr id="r_Ktp">
		<td class="<?php echo $docmhs_view->TableLeftColumnClass ?>"><span id="elh_docmhs_Ktp"><?php echo $docmhs_view->Ktp->caption() ?></span></td>
		<td data-name="Ktp" <?php echo $docmhs_view->Ktp->cellAttributes() ?>>
<span id="el_docmhs_Ktp">
<span<?php echo $docmhs_view->Ktp->viewAttributes() ?>><?php echo GetFileViewTag($docmhs_view->Ktp, $docmhs_view->Ktp->getViewValue(), FALSE) ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($docmhs_view->KK->Visible) { // KK ?>
	<tr id="r_KK">
		<td class="<?php echo $docmhs_view->TableLeftColumnClass ?>"><span id="elh_docmhs_KK"><?php echo $docmhs_view->KK->caption() ?></span></td>
		<td data-name="KK" <?php echo $docmhs_view->KK->cellAttributes() ?>>
<span id="el_docmhs_KK">
<span<?php echo $docmhs_view->KK->viewAttributes() ?>><?php echo GetFileViewTag($docmhs_view->KK, $docmhs_view->KK->getViewValue(), FALSE) ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($docmhs_view->tandatangan->Visible) { // tandatangan ?>
	<tr id="r_tandatangan">
		<td class="<?php echo $docmhs_view->TableLeftColumnClass ?>"><span id="elh_docmhs_tandatangan"><?php echo $docmhs_view->tandatangan->caption() ?></span></td>
		<td data-name="tandatangan" <?php echo $docmhs_view->tandatangan->cellAttributes() ?>>
<span id="el_docmhs_tandatangan">
<span<?php echo $docmhs_view->tandatangan->viewAttributes() ?>><?php echo GetFileViewTag($docmhs_view->tandatangan, $docmhs_view->tandatangan->getViewValue(), FALSE) ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($docmhs_view->IjazahIM->Visible) { // IjazahIM ?>
	<tr id="r_IjazahIM">
		<td class="<?php echo $docmhs_view->TableLeftColumnClass ?>"><span id="elh_docmhs_IjazahIM"><?php echo $docmhs_view->IjazahIM->caption() ?></span></td>
		<td data-name="IjazahIM" <?php echo $docmhs_view->IjazahIM->cellAttributes() ?>>
<span id="el_docmhs_IjazahIM">
<span<?php echo $docmhs_view->IjazahIM->viewAttributes() ?>><?php echo GetFileViewTag($docmhs_view->IjazahIM, $docmhs_view->IjazahIM->getViewValue(), FALSE) ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($docmhs_view->TranskriptIM->Visible) { // TranskriptIM ?>
	<tr id="r_TranskriptIM">
		<td class="<?php echo $docmhs_view->TableLeftColumnClass ?>"><span id="elh_docmhs_TranskriptIM"><?php echo $docmhs_view->TranskriptIM->caption() ?></span></td>
		<td data-name="TranskriptIM" <?php echo $docmhs_view->TranskriptIM->cellAttributes() ?>>
<span id="el_docmhs_TranskriptIM">
<span<?php echo $docmhs_view->TranskriptIM->viewAttributes() ?>><?php echo GetFileViewTag($docmhs_view->TranskriptIM, $docmhs_view->TranskriptIM->getViewValue(), FALSE) ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($docmhs_view->Skripsi->Visible) { // Skripsi ?>
	<tr id="r_Skripsi">
		<td class="<?php echo $docmhs_view->TableLeftColumnClass ?>"><span id="elh_docmhs_Skripsi"><?php echo $docmhs_view->Skripsi->caption() ?></span></td>
		<td data-name="Skripsi" <?php echo $docmhs_view->Skripsi->cellAttributes() ?>>
<span id="el_docmhs_Skripsi">
<span<?php echo $docmhs_view->Skripsi->viewAttributes() ?>><?php echo GetFileViewTag($docmhs_view->Skripsi, $docmhs_view->Skripsi->getViewValue(), FALSE) ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($docmhs_view->Plagiat->Visible) { // Plagiat ?>
	<tr id="r_Plagiat">
		<td class="<?php echo $docmhs_view->TableLeftColumnClass ?>"><span id="elh_docmhs_Plagiat"><?php echo $docmhs_view->Plagiat->caption() ?></span></td>
		<td data-name="Plagiat" <?php echo $docmhs_view->Plagiat->cellAttributes() ?>>
<span id="el_docmhs_Plagiat">
<span<?php echo $docmhs_view->Plagiat->viewAttributes() ?>><?php echo GetFileViewTag($docmhs_view->Plagiat, $docmhs_view->Plagiat->getViewValue(), FALSE) ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($docmhs_view->riwayatakademik->Visible) { // riwayatakademik ?>
	<tr id="r_riwayatakademik">
		<td class="<?php echo $docmhs_view->TableLeftColumnClass ?>"><span id="elh_docmhs_riwayatakademik"><?php echo $docmhs_view->riwayatakademik->caption() ?></span></td>
		<td data-name="riwayatakademik" <?php echo $docmhs_view->riwayatakademik->cellAttributes() ?>>
<span id="el_docmhs_riwayatakademik">
<span<?php echo $docmhs_view->riwayatakademik->viewAttributes() ?>><?php echo GetFileViewTag($docmhs_view->riwayatakademik, $docmhs_view->riwayatakademik->getViewValue(), FALSE) ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($docmhs_view->keuangan->Visible) { // keuangan ?>
	<tr id="r_keuangan">
		<td class="<?php echo $docmhs_view->TableLeftColumnClass ?>"><span id="elh_docmhs_keuangan"><?php echo $docmhs_view->keuangan->caption() ?></span></td>
		<td data-name="keuangan" <?php echo $docmhs_view->keuangan->cellAttributes() ?>>
<span id="el_docmhs_keuangan">
<span<?php echo $docmhs_view->keuangan->viewAttributes() ?>><?php echo GetFileViewTag($docmhs_view->keuangan, $docmhs_view->keuangan->getViewValue(), FALSE) ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($docmhs_view->pendukung->Visible) { // pendukung ?>
	<tr id="r_pendukung">
		<td class="<?php echo $docmhs_view->TableLeftColumnClass ?>"><span id="elh_docmhs_pendukung"><?php echo $docmhs_view->pendukung->caption() ?></span></td>
		<td data-name="pendukung" <?php echo $docmhs_view->pendukung->cellAttributes() ?>>
<span id="el_docmhs_pendukung">
<span<?php echo $docmhs_view->pendukung->viewAttributes() ?>><?php echo GetFileViewTag($docmhs_view->pendukung, $docmhs_view->pendukung->getViewValue(), FALSE) ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($docmhs_view->lainlain->Visible) { // lainlain ?>
	<tr id="r_lainlain">
		<td class="<?php echo $docmhs_view->TableLeftColumnClass ?>"><span id="elh_docmhs_lainlain"><?php echo $docmhs_view->lainlain->caption() ?></span></td>
		<td data-name="lainlain" <?php echo $docmhs_view->lainlain->cellAttributes() ?>>
<span id="el_docmhs_lainlain">
<span<?php echo $docmhs_view->lainlain->viewAttributes() ?>><?php echo GetFileViewTag($docmhs_view->lainlain, $docmhs_view->lainlain->getViewValue(), FALSE) ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$docmhs_view->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$docmhs_view->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$docmhs_view->terminate();
?>