<?php
namespace PHPMaker2020\baak;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE, "utf-8");

// Create page object
$ekpt_Ferval_preview = new ekpt_Ferval_preview();

// Run the page
$ekpt_Ferval_preview->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$ekpt_Ferval_preview->Page_Render();
?>
<?php $ekpt_Ferval_preview->showPageHeader(); ?>
<?php if ($ekpt_Ferval_preview->TotalRecords > 0) { ?>
<div class="card ew-grid ekpt_Ferval"><!-- .card -->
<div class="<?php echo ResponsiveTableClass() ?>card-body ew-grid-middle-panel ew-preview-middle-panel"><!-- .table-responsive -->
<table class="table ew-table ew-preview-table"><!-- .table -->
	<thead><!-- Table header -->
		<tr class="ew-table-header">
<?php

// Render list options
$ekpt_Ferval_preview->renderListOptions();

// Render list options (header, left)
$ekpt_Ferval_preview->ListOptions->render("header", "left");
?>
<?php if ($ekpt_Ferval_preview->Nim->Visible) { // Nim ?>
	<?php if ($ekpt_Ferval->SortUrl($ekpt_Ferval_preview->Nim) == "") { ?>
		<th class="<?php echo $ekpt_Ferval_preview->Nim->headerCellClass() ?>"><?php echo $ekpt_Ferval_preview->Nim->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $ekpt_Ferval_preview->Nim->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($ekpt_Ferval_preview->Nim->Name) ?>" data-sort-order="<?php echo $ekpt_Ferval_preview->SortField == $ekpt_Ferval_preview->Nim->Name && $ekpt_Ferval_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ekpt_Ferval_preview->Nim->caption() ?></span><span class="ew-table-header-sort"><?php if ($ekpt_Ferval_preview->SortField == $ekpt_Ferval_preview->Nim->Name) { ?><?php if ($ekpt_Ferval_preview->SortOrder == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($ekpt_Ferval_preview->SortOrder == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ekpt_Ferval_preview->Ferval->Visible) { // Ferval ?>
	<?php if ($ekpt_Ferval->SortUrl($ekpt_Ferval_preview->Ferval) == "") { ?>
		<th class="<?php echo $ekpt_Ferval_preview->Ferval->headerCellClass() ?>"><?php echo $ekpt_Ferval_preview->Ferval->caption() ?></th>
	<?php } else { ?>
		<th class="<?php echo $ekpt_Ferval_preview->Ferval->headerCellClass() ?>"><div class="ew-pointer" data-sort="<?php echo HtmlEncode($ekpt_Ferval_preview->Ferval->Name) ?>" data-sort-order="<?php echo $ekpt_Ferval_preview->SortField == $ekpt_Ferval_preview->Ferval->Name && $ekpt_Ferval_preview->SortOrder == "ASC" ? "DESC" : "ASC" ?>">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ekpt_Ferval_preview->Ferval->caption() ?></span><span class="ew-table-header-sort"><?php if ($ekpt_Ferval_preview->SortField == $ekpt_Ferval_preview->Ferval->Name) { ?><?php if ($ekpt_Ferval_preview->SortOrder == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($ekpt_Ferval_preview->SortOrder == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?><?php } ?></span>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$ekpt_Ferval_preview->ListOptions->render("header", "right");
?>
		</tr>
	</thead>
	<tbody><!-- Table body -->
<?php
$ekpt_Ferval_preview->RecCount = 0;
$ekpt_Ferval_preview->RowCount = 0;
while ($ekpt_Ferval_preview->Recordset && !$ekpt_Ferval_preview->Recordset->EOF) {

	// Init row class and style
	$ekpt_Ferval_preview->RecCount++;
	$ekpt_Ferval_preview->RowCount++;
	$ekpt_Ferval_preview->CssStyle = "";
	$ekpt_Ferval_preview->loadListRowValues($ekpt_Ferval_preview->Recordset);

	// Render row
	$ekpt_Ferval->RowType = ROWTYPE_PREVIEW; // Preview record
	$ekpt_Ferval_preview->resetAttributes();
	$ekpt_Ferval_preview->renderListRow();

	// Render list options
	$ekpt_Ferval_preview->renderListOptions();
?>
	<tr <?php echo $ekpt_Ferval->rowAttributes() ?>>
<?php

// Render list options (body, left)
$ekpt_Ferval_preview->ListOptions->render("body", "left", $ekpt_Ferval_preview->RowCount);
?>
<?php if ($ekpt_Ferval_preview->Nim->Visible) { // Nim ?>
		<!-- Nim -->
		<td<?php echo $ekpt_Ferval_preview->Nim->cellAttributes() ?>>
<span<?php echo $ekpt_Ferval_preview->Nim->viewAttributes() ?>><?php echo $ekpt_Ferval_preview->Nim->getViewValue() ?></span>
</td>
<?php } ?>
<?php if ($ekpt_Ferval_preview->Ferval->Visible) { // Ferval ?>
		<!-- Ferval -->
		<td<?php echo $ekpt_Ferval_preview->Ferval->cellAttributes() ?>>
<span<?php echo $ekpt_Ferval_preview->Ferval->viewAttributes() ?>><?php echo $ekpt_Ferval_preview->Ferval->getViewValue() ?></span>
</td>
<?php } ?>
<?php

// Render list options (body, right)
$ekpt_Ferval_preview->ListOptions->render("body", "right", $ekpt_Ferval_preview->RowCount);
?>
	</tr>
<?php
	$ekpt_Ferval_preview->Recordset->MoveNext();
} // while
?>
	</tbody>
</table><!-- /.table -->
</div><!-- /.table-responsive -->
<div class="card-footer ew-grid-lower-panel ew-preview-lower-panel"><!-- .card-footer -->
<?php echo $ekpt_Ferval_preview->Pager->render() ?>
<?php } else { // No record ?>
<div class="card no-border">
<div class="ew-detail-count"><?php echo $Language->phrase("NoRecord") ?></div>
<?php } ?>
<div class="ew-preview-other-options">
<?php
	foreach ($ekpt_Ferval_preview->OtherOptions as $option)
		$option->render("body");
?>
</div>
<?php if ($ekpt_Ferval_preview->TotalRecords > 0) { ?>
<div class="clearfix"></div>
</div><!-- /.card-footer -->
<?php } ?>
</div><!-- /.card -->
<?php
$ekpt_Ferval_preview->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php
if ($ekpt_Ferval_preview->Recordset)
	$ekpt_Ferval_preview->Recordset->Close();

// Output
$content = ob_get_contents();
ob_end_clean();
echo ConvertToUtf8($content);
?>
<?php
$ekpt_Ferval_preview->terminate();
?>