<?php
namespace PHPMaker2020\baak;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$ekpt_mhsfeed_list = new ekpt_mhsfeed_list();

// Run the page
$ekpt_mhsfeed_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$ekpt_mhsfeed_list->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$ekpt_mhsfeed_list->isExport()) { ?>
<script>
var fekpt_mhsfeedlist, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "list";
	fekpt_mhsfeedlist = currentForm = new ew.Form("fekpt_mhsfeedlist", "list");
	fekpt_mhsfeedlist.formKeyCountName = '<?php echo $ekpt_mhsfeed_list->FormKeyCountName ?>';
	loadjs.done("fekpt_mhsfeedlist");
});
var fekpt_mhsfeedlistsrch;
loadjs.ready("head", function() {

	// Form object for search
	fekpt_mhsfeedlistsrch = currentSearchForm = new ew.Form("fekpt_mhsfeedlistsrch");

	// Validate function for search
	fekpt_mhsfeedlistsrch.validate = function(fobj) {
		if (!this.validateRequired)
			return true; // Ignore validation
		fobj = fobj || this._form;
		var infix = "";

		// Call Form_CustomValidate event
		if (!this.Form_CustomValidate(fobj))
			return false;
		return true;
	}

	// Form_CustomValidate
	fekpt_mhsfeedlistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

		// Your custom validation code here, return false if invalid.
		return true;
	}

	// Use JavaScript validation or not
	fekpt_mhsfeedlistsrch.validateRequired = <?php echo Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

	// Dynamic selection lists
	fekpt_mhsfeedlistsrch.lists["x_Kode_Fak"] = <?php echo $ekpt_mhsfeed_list->Kode_Fak->Lookup->toClientList($ekpt_mhsfeed_list) ?>;
	fekpt_mhsfeedlistsrch.lists["x_Kode_Fak"].options = <?php echo JsonEncode($ekpt_mhsfeed_list->Kode_Fak->lookupOptions()) ?>;
	fekpt_mhsfeedlistsrch.lists["x_Kode_Jp"] = <?php echo $ekpt_mhsfeed_list->Kode_Jp->Lookup->toClientList($ekpt_mhsfeed_list) ?>;
	fekpt_mhsfeedlistsrch.lists["x_Kode_Jp"].options = <?php echo JsonEncode($ekpt_mhsfeed_list->Kode_Jp->lookupOptions()) ?>;
	fekpt_mhsfeedlistsrch.lists["x_Status"] = <?php echo $ekpt_mhsfeed_list->Status->Lookup->toClientList($ekpt_mhsfeed_list) ?>;
	fekpt_mhsfeedlistsrch.lists["x_Status"].options = <?php echo JsonEncode($ekpt_mhsfeed_list->Status->options(FALSE, TRUE)) ?>;
	fekpt_mhsfeedlistsrch.lists["x_StatusSIAP"] = <?php echo $ekpt_mhsfeed_list->StatusSIAP->Lookup->toClientList($ekpt_mhsfeed_list) ?>;
	fekpt_mhsfeedlistsrch.lists["x_StatusSIAP"].options = <?php echo JsonEncode($ekpt_mhsfeed_list->StatusSIAP->options(FALSE, TRUE)) ?>;

	// Filters
	fekpt_mhsfeedlistsrch.filterList = <?php echo $ekpt_mhsfeed_list->getFilterList() ?>;
	loadjs.done("fekpt_mhsfeedlistsrch");
});
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script>
loadjs.ready("head", function() {
	ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
	ew.PREVIEW_SINGLE_ROW = false;
	ew.PREVIEW_OVERLAY = false;
	loadjs("js/ewpreview.js", "preview");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$ekpt_mhsfeed_list->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($ekpt_mhsfeed_list->TotalRecords > 0 && $ekpt_mhsfeed_list->ExportOptions->visible()) { ?>
<?php $ekpt_mhsfeed_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($ekpt_mhsfeed_list->ImportOptions->visible()) { ?>
<?php $ekpt_mhsfeed_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($ekpt_mhsfeed_list->SearchOptions->visible()) { ?>
<?php $ekpt_mhsfeed_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($ekpt_mhsfeed_list->FilterOptions->visible()) { ?>
<?php $ekpt_mhsfeed_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$ekpt_mhsfeed_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$ekpt_mhsfeed_list->isExport() && !$ekpt_mhsfeed->CurrentAction) { ?>
<form name="fekpt_mhsfeedlistsrch" id="fekpt_mhsfeedlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<div id="fekpt_mhsfeedlistsrch-search-panel" class="<?php echo $ekpt_mhsfeed_list->SearchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="ekpt_mhsfeed">
	<div class="ew-extended-search">
<?php

// Render search row
$ekpt_mhsfeed->RowType = ROWTYPE_SEARCH;
$ekpt_mhsfeed->resetAttributes();
$ekpt_mhsfeed_list->renderRow();
?>
<?php if ($ekpt_mhsfeed_list->Kode_Fak->Visible) { // Kode_Fak ?>
	<?php
		$ekpt_mhsfeed_list->SearchColumnCount++;
		if (($ekpt_mhsfeed_list->SearchColumnCount - 1) % $ekpt_mhsfeed_list->SearchFieldsPerRow == 0) {
			$ekpt_mhsfeed_list->SearchRowCount++;
	?>
<div id="xsr_<?php echo $ekpt_mhsfeed_list->SearchRowCount ?>" class="ew-row d-sm-flex">
	<?php
		}
	 ?>
	<div id="xsc_Kode_Fak" class="ew-cell form-group">
		<label for="x_Kode_Fak" class="ew-search-caption ew-label"><?php echo $ekpt_mhsfeed_list->Kode_Fak->caption() ?></label>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Kode_Fak" id="z_Kode_Fak" value="LIKE">
</span>
		<span id="el_ekpt_mhsfeed_Kode_Fak" class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ekpt_mhsfeed" data-field="x_Kode_Fak" data-value-separator="<?php echo $ekpt_mhsfeed_list->Kode_Fak->displayValueSeparatorAttribute() ?>" id="x_Kode_Fak" name="x_Kode_Fak"<?php echo $ekpt_mhsfeed_list->Kode_Fak->editAttributes() ?>>
			<?php echo $ekpt_mhsfeed_list->Kode_Fak->selectOptionListHtml("x_Kode_Fak") ?>
		</select>
</div>
<?php echo $ekpt_mhsfeed_list->Kode_Fak->Lookup->getParamTag($ekpt_mhsfeed_list, "p_x_Kode_Fak") ?>
</span>
	</div>
	<?php if ($ekpt_mhsfeed_list->SearchColumnCount % $ekpt_mhsfeed_list->SearchFieldsPerRow == 0) { ?>
</div>
	<?php } ?>
<?php } ?>
<?php if ($ekpt_mhsfeed_list->Kode_Jp->Visible) { // Kode_Jp ?>
	<?php
		$ekpt_mhsfeed_list->SearchColumnCount++;
		if (($ekpt_mhsfeed_list->SearchColumnCount - 1) % $ekpt_mhsfeed_list->SearchFieldsPerRow == 0) {
			$ekpt_mhsfeed_list->SearchRowCount++;
	?>
<div id="xsr_<?php echo $ekpt_mhsfeed_list->SearchRowCount ?>" class="ew-row d-sm-flex">
	<?php
		}
	 ?>
	<div id="xsc_Kode_Jp" class="ew-cell form-group">
		<label for="x_Kode_Jp" class="ew-search-caption ew-label"><?php echo $ekpt_mhsfeed_list->Kode_Jp->caption() ?></label>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Kode_Jp" id="z_Kode_Jp" value="LIKE">
</span>
		<span id="el_ekpt_mhsfeed_Kode_Jp" class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ekpt_mhsfeed" data-field="x_Kode_Jp" data-value-separator="<?php echo $ekpt_mhsfeed_list->Kode_Jp->displayValueSeparatorAttribute() ?>" id="x_Kode_Jp" name="x_Kode_Jp"<?php echo $ekpt_mhsfeed_list->Kode_Jp->editAttributes() ?>>
			<?php echo $ekpt_mhsfeed_list->Kode_Jp->selectOptionListHtml("x_Kode_Jp") ?>
		</select>
</div>
<?php echo $ekpt_mhsfeed_list->Kode_Jp->Lookup->getParamTag($ekpt_mhsfeed_list, "p_x_Kode_Jp") ?>
</span>
	</div>
	<?php if ($ekpt_mhsfeed_list->SearchColumnCount % $ekpt_mhsfeed_list->SearchFieldsPerRow == 0) { ?>
</div>
	<?php } ?>
<?php } ?>
<?php if ($ekpt_mhsfeed_list->Status->Visible) { // Status ?>
	<?php
		$ekpt_mhsfeed_list->SearchColumnCount++;
		if (($ekpt_mhsfeed_list->SearchColumnCount - 1) % $ekpt_mhsfeed_list->SearchFieldsPerRow == 0) {
			$ekpt_mhsfeed_list->SearchRowCount++;
	?>
<div id="xsr_<?php echo $ekpt_mhsfeed_list->SearchRowCount ?>" class="ew-row d-sm-flex">
	<?php
		}
	 ?>
	<div id="xsc_Status" class="ew-cell form-group">
		<label for="x_Status" class="ew-search-caption ew-label"><?php echo $ekpt_mhsfeed_list->Status->caption() ?></label>
		<span class="ew-search-operator">
<select name="z_Status" id="z_Status" class="custom-select" onchange="ew.searchOperatorChanged(this);">
<option value="="<?php echo $ekpt_mhsfeed_list->Status->AdvancedSearch->SearchOperator == "=" ? " selected" : "" ?>><?php echo $Language->phrase("EQUAL") ?></option>
<option value="<>"<?php echo $ekpt_mhsfeed_list->Status->AdvancedSearch->SearchOperator == "<>" ? " selected" : "" ?>><?php echo $Language->phrase("<>") ?></option>
<option value="<"<?php echo $ekpt_mhsfeed_list->Status->AdvancedSearch->SearchOperator == "<" ? " selected" : "" ?>><?php echo $Language->phrase("<") ?></option>
<option value="<="<?php echo $ekpt_mhsfeed_list->Status->AdvancedSearch->SearchOperator == "<=" ? " selected" : "" ?>><?php echo $Language->phrase("<=") ?></option>
<option value=">"<?php echo $ekpt_mhsfeed_list->Status->AdvancedSearch->SearchOperator == ">" ? " selected" : "" ?>><?php echo $Language->phrase(">") ?></option>
<option value=">="<?php echo $ekpt_mhsfeed_list->Status->AdvancedSearch->SearchOperator == ">=" ? " selected" : "" ?>><?php echo $Language->phrase(">=") ?></option>
<option value="LIKE"<?php echo $ekpt_mhsfeed_list->Status->AdvancedSearch->SearchOperator == "LIKE" ? " selected" : "" ?>><?php echo $Language->phrase("LIKE") ?></option>
<option value="NOT LIKE"<?php echo $ekpt_mhsfeed_list->Status->AdvancedSearch->SearchOperator == "NOT LIKE" ? " selected" : "" ?>><?php echo $Language->phrase("NOT LIKE") ?></option>
<option value="STARTS WITH"<?php echo $ekpt_mhsfeed_list->Status->AdvancedSearch->SearchOperator == "STARTS WITH" ? " selected" : "" ?>><?php echo $Language->phrase("STARTS WITH") ?></option>
<option value="ENDS WITH"<?php echo $ekpt_mhsfeed_list->Status->AdvancedSearch->SearchOperator == "ENDS WITH" ? " selected" : "" ?>><?php echo $Language->phrase("ENDS WITH") ?></option>
<option value="IS NULL"<?php echo $ekpt_mhsfeed_list->Status->AdvancedSearch->SearchOperator == "IS NULL" ? " selected" : "" ?>><?php echo $Language->phrase("IS NULL") ?></option>
<option value="IS NOT NULL"<?php echo $ekpt_mhsfeed_list->Status->AdvancedSearch->SearchOperator == "IS NOT NULL" ? " selected" : "" ?>><?php echo $Language->phrase("IS NOT NULL") ?></option>
<option value="BETWEEN"<?php echo $ekpt_mhsfeed_list->Status->AdvancedSearch->SearchOperator == "BETWEEN" ? " selected" : "" ?>><?php echo $Language->phrase("BETWEEN") ?></option>
</select>
</span>
		<span id="el_ekpt_mhsfeed_Status" class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ekpt_mhsfeed" data-field="x_Status" data-value-separator="<?php echo $ekpt_mhsfeed_list->Status->displayValueSeparatorAttribute() ?>" id="x_Status" name="x_Status"<?php echo $ekpt_mhsfeed_list->Status->editAttributes() ?>>
			<?php echo $ekpt_mhsfeed_list->Status->selectOptionListHtml("x_Status") ?>
		</select>
</div>
</span>
		<span class="ew-search-and d-none"><label><?php echo $Language->phrase("AND") ?></label></span>
		<span id="el2_ekpt_mhsfeed_Status" class="ew-search-field2 d-none">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ekpt_mhsfeed" data-field="x_Status" data-value-separator="<?php echo $ekpt_mhsfeed_list->Status->displayValueSeparatorAttribute() ?>" id="y_Status" name="y_Status"<?php echo $ekpt_mhsfeed_list->Status->editAttributes() ?>>
			<?php echo $ekpt_mhsfeed_list->Status->selectOptionListHtml("y_Status") ?>
		</select>
</div>
</span>
	</div>
	<?php if ($ekpt_mhsfeed_list->SearchColumnCount % $ekpt_mhsfeed_list->SearchFieldsPerRow == 0) { ?>
</div>
	<?php } ?>
<?php } ?>
<?php if ($ekpt_mhsfeed_list->StatusSIAP->Visible) { // StatusSIAP ?>
	<?php
		$ekpt_mhsfeed_list->SearchColumnCount++;
		if (($ekpt_mhsfeed_list->SearchColumnCount - 1) % $ekpt_mhsfeed_list->SearchFieldsPerRow == 0) {
			$ekpt_mhsfeed_list->SearchRowCount++;
	?>
<div id="xsr_<?php echo $ekpt_mhsfeed_list->SearchRowCount ?>" class="ew-row d-sm-flex">
	<?php
		}
	 ?>
	<div id="xsc_StatusSIAP" class="ew-cell form-group">
		<label for="x_StatusSIAP" class="ew-search-caption ew-label"><?php echo $ekpt_mhsfeed_list->StatusSIAP->caption() ?></label>
		<span class="ew-search-operator">
<select name="z_StatusSIAP" id="z_StatusSIAP" class="custom-select" onchange="ew.searchOperatorChanged(this);">
<option value="="<?php echo $ekpt_mhsfeed_list->StatusSIAP->AdvancedSearch->SearchOperator == "=" ? " selected" : "" ?>><?php echo $Language->phrase("EQUAL") ?></option>
<option value="<>"<?php echo $ekpt_mhsfeed_list->StatusSIAP->AdvancedSearch->SearchOperator == "<>" ? " selected" : "" ?>><?php echo $Language->phrase("<>") ?></option>
<option value="<"<?php echo $ekpt_mhsfeed_list->StatusSIAP->AdvancedSearch->SearchOperator == "<" ? " selected" : "" ?>><?php echo $Language->phrase("<") ?></option>
<option value="<="<?php echo $ekpt_mhsfeed_list->StatusSIAP->AdvancedSearch->SearchOperator == "<=" ? " selected" : "" ?>><?php echo $Language->phrase("<=") ?></option>
<option value=">"<?php echo $ekpt_mhsfeed_list->StatusSIAP->AdvancedSearch->SearchOperator == ">" ? " selected" : "" ?>><?php echo $Language->phrase(">") ?></option>
<option value=">="<?php echo $ekpt_mhsfeed_list->StatusSIAP->AdvancedSearch->SearchOperator == ">=" ? " selected" : "" ?>><?php echo $Language->phrase(">=") ?></option>
<option value="LIKE"<?php echo $ekpt_mhsfeed_list->StatusSIAP->AdvancedSearch->SearchOperator == "LIKE" ? " selected" : "" ?>><?php echo $Language->phrase("LIKE") ?></option>
<option value="NOT LIKE"<?php echo $ekpt_mhsfeed_list->StatusSIAP->AdvancedSearch->SearchOperator == "NOT LIKE" ? " selected" : "" ?>><?php echo $Language->phrase("NOT LIKE") ?></option>
<option value="STARTS WITH"<?php echo $ekpt_mhsfeed_list->StatusSIAP->AdvancedSearch->SearchOperator == "STARTS WITH" ? " selected" : "" ?>><?php echo $Language->phrase("STARTS WITH") ?></option>
<option value="ENDS WITH"<?php echo $ekpt_mhsfeed_list->StatusSIAP->AdvancedSearch->SearchOperator == "ENDS WITH" ? " selected" : "" ?>><?php echo $Language->phrase("ENDS WITH") ?></option>
<option value="IS NULL"<?php echo $ekpt_mhsfeed_list->StatusSIAP->AdvancedSearch->SearchOperator == "IS NULL" ? " selected" : "" ?>><?php echo $Language->phrase("IS NULL") ?></option>
<option value="IS NOT NULL"<?php echo $ekpt_mhsfeed_list->StatusSIAP->AdvancedSearch->SearchOperator == "IS NOT NULL" ? " selected" : "" ?>><?php echo $Language->phrase("IS NOT NULL") ?></option>
<option value="BETWEEN"<?php echo $ekpt_mhsfeed_list->StatusSIAP->AdvancedSearch->SearchOperator == "BETWEEN" ? " selected" : "" ?>><?php echo $Language->phrase("BETWEEN") ?></option>
</select>
</span>
		<span id="el_ekpt_mhsfeed_StatusSIAP" class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ekpt_mhsfeed" data-field="x_StatusSIAP" data-value-separator="<?php echo $ekpt_mhsfeed_list->StatusSIAP->displayValueSeparatorAttribute() ?>" id="x_StatusSIAP" name="x_StatusSIAP"<?php echo $ekpt_mhsfeed_list->StatusSIAP->editAttributes() ?>>
			<?php echo $ekpt_mhsfeed_list->StatusSIAP->selectOptionListHtml("x_StatusSIAP") ?>
		</select>
</div>
</span>
		<span class="ew-search-and d-none"><label><?php echo $Language->phrase("AND") ?></label></span>
		<span id="el2_ekpt_mhsfeed_StatusSIAP" class="ew-search-field2 d-none">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ekpt_mhsfeed" data-field="x_StatusSIAP" data-value-separator="<?php echo $ekpt_mhsfeed_list->StatusSIAP->displayValueSeparatorAttribute() ?>" id="y_StatusSIAP" name="y_StatusSIAP"<?php echo $ekpt_mhsfeed_list->StatusSIAP->editAttributes() ?>>
			<?php echo $ekpt_mhsfeed_list->StatusSIAP->selectOptionListHtml("y_StatusSIAP") ?>
		</select>
</div>
</span>
	</div>
	<?php if ($ekpt_mhsfeed_list->SearchColumnCount % $ekpt_mhsfeed_list->SearchFieldsPerRow == 0) { ?>
</div>
	<?php } ?>
<?php } ?>
	<?php if ($ekpt_mhsfeed_list->SearchColumnCount % $ekpt_mhsfeed_list->SearchFieldsPerRow > 0) { ?>
</div>
	<?php } ?>
<div id="xsr_<?php echo $ekpt_mhsfeed_list->SearchRowCount + 1 ?>" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo Config("TABLE_BASIC_SEARCH") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH") ?>" class="form-control" value="<?php echo HtmlEncode($ekpt_mhsfeed_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" id="<?php echo Config("TABLE_BASIC_SEARCH_TYPE") ?>" value="<?php echo HtmlEncode($ekpt_mhsfeed_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $ekpt_mhsfeed_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($ekpt_mhsfeed_list->BasicSearch->getType() == "") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this);"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($ekpt_mhsfeed_list->BasicSearch->getType() == "=") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, '=');"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($ekpt_mhsfeed_list->BasicSearch->getType() == "AND") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'AND');"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($ekpt_mhsfeed_list->BasicSearch->getType() == "OR") { ?> active<?php } ?>" href="#" onclick="return ew.setSearchType(this, 'OR');"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div><!-- /.ew-extended-search -->
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php } ?>
<?php $ekpt_mhsfeed_list->showPageHeader(); ?>
<?php
$ekpt_mhsfeed_list->showMessage();
?>
<?php if ($ekpt_mhsfeed_list->TotalRecords > 0 || $ekpt_mhsfeed->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($ekpt_mhsfeed_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> ekpt_mhsfeed">
<form name="fekpt_mhsfeedlist" id="fekpt_mhsfeedlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="ekpt_mhsfeed">
<div id="gmp_ekpt_mhsfeed" class="<?php echo ResponsiveTableClass() ?>card-body ew-grid-middle-panel">
<?php if ($ekpt_mhsfeed_list->TotalRecords > 0 || $ekpt_mhsfeed_list->isGridEdit()) { ?>
<table id="tbl_ekpt_mhsfeedlist" class="table ew-table"><!-- .ew-table -->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$ekpt_mhsfeed->RowType = ROWTYPE_HEADER;

// Render list options
$ekpt_mhsfeed_list->renderListOptions();

// Render list options (header, left)
$ekpt_mhsfeed_list->ListOptions->render("header", "left");
?>
<?php if ($ekpt_mhsfeed_list->Kode_Fak->Visible) { // Kode_Fak ?>
	<?php if ($ekpt_mhsfeed_list->SortUrl($ekpt_mhsfeed_list->Kode_Fak) == "") { ?>
		<th data-name="Kode_Fak" class="<?php echo $ekpt_mhsfeed_list->Kode_Fak->headerCellClass() ?>"><div id="elh_ekpt_mhsfeed_Kode_Fak" class="ekpt_mhsfeed_Kode_Fak"><div class="ew-table-header-caption"><?php echo $ekpt_mhsfeed_list->Kode_Fak->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Kode_Fak" class="<?php echo $ekpt_mhsfeed_list->Kode_Fak->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $ekpt_mhsfeed_list->SortUrl($ekpt_mhsfeed_list->Kode_Fak) ?>', 1);"><div id="elh_ekpt_mhsfeed_Kode_Fak" class="ekpt_mhsfeed_Kode_Fak">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ekpt_mhsfeed_list->Kode_Fak->caption() ?></span><span class="ew-table-header-sort"><?php if ($ekpt_mhsfeed_list->Kode_Fak->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($ekpt_mhsfeed_list->Kode_Fak->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ekpt_mhsfeed_list->Kode_Jp->Visible) { // Kode_Jp ?>
	<?php if ($ekpt_mhsfeed_list->SortUrl($ekpt_mhsfeed_list->Kode_Jp) == "") { ?>
		<th data-name="Kode_Jp" class="<?php echo $ekpt_mhsfeed_list->Kode_Jp->headerCellClass() ?>"><div id="elh_ekpt_mhsfeed_Kode_Jp" class="ekpt_mhsfeed_Kode_Jp"><div class="ew-table-header-caption"><?php echo $ekpt_mhsfeed_list->Kode_Jp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Kode_Jp" class="<?php echo $ekpt_mhsfeed_list->Kode_Jp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $ekpt_mhsfeed_list->SortUrl($ekpt_mhsfeed_list->Kode_Jp) ?>', 1);"><div id="elh_ekpt_mhsfeed_Kode_Jp" class="ekpt_mhsfeed_Kode_Jp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ekpt_mhsfeed_list->Kode_Jp->caption() ?></span><span class="ew-table-header-sort"><?php if ($ekpt_mhsfeed_list->Kode_Jp->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($ekpt_mhsfeed_list->Kode_Jp->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ekpt_mhsfeed_list->NimIM->Visible) { // NimIM ?>
	<?php if ($ekpt_mhsfeed_list->SortUrl($ekpt_mhsfeed_list->NimIM) == "") { ?>
		<th data-name="NimIM" class="<?php echo $ekpt_mhsfeed_list->NimIM->headerCellClass() ?>"><div id="elh_ekpt_mhsfeed_NimIM" class="ekpt_mhsfeed_NimIM"><div class="ew-table-header-caption"><?php echo $ekpt_mhsfeed_list->NimIM->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="NimIM" class="<?php echo $ekpt_mhsfeed_list->NimIM->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $ekpt_mhsfeed_list->SortUrl($ekpt_mhsfeed_list->NimIM) ?>', 1);"><div id="elh_ekpt_mhsfeed_NimIM" class="ekpt_mhsfeed_NimIM">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ekpt_mhsfeed_list->NimIM->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($ekpt_mhsfeed_list->NimIM->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($ekpt_mhsfeed_list->NimIM->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ekpt_mhsfeed_list->NamaMhs->Visible) { // NamaMhs ?>
	<?php if ($ekpt_mhsfeed_list->SortUrl($ekpt_mhsfeed_list->NamaMhs) == "") { ?>
		<th data-name="NamaMhs" class="<?php echo $ekpt_mhsfeed_list->NamaMhs->headerCellClass() ?>"><div id="elh_ekpt_mhsfeed_NamaMhs" class="ekpt_mhsfeed_NamaMhs"><div class="ew-table-header-caption"><?php echo $ekpt_mhsfeed_list->NamaMhs->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="NamaMhs" class="<?php echo $ekpt_mhsfeed_list->NamaMhs->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $ekpt_mhsfeed_list->SortUrl($ekpt_mhsfeed_list->NamaMhs) ?>', 1);"><div id="elh_ekpt_mhsfeed_NamaMhs" class="ekpt_mhsfeed_NamaMhs">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ekpt_mhsfeed_list->NamaMhs->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($ekpt_mhsfeed_list->NamaMhs->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($ekpt_mhsfeed_list->NamaMhs->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ekpt_mhsfeed_list->Status_Akd->Visible) { // Status_Akd ?>
	<?php if ($ekpt_mhsfeed_list->SortUrl($ekpt_mhsfeed_list->Status_Akd) == "") { ?>
		<th data-name="Status_Akd" class="<?php echo $ekpt_mhsfeed_list->Status_Akd->headerCellClass() ?>"><div id="elh_ekpt_mhsfeed_Status_Akd" class="ekpt_mhsfeed_Status_Akd"><div class="ew-table-header-caption"><?php echo $ekpt_mhsfeed_list->Status_Akd->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Status_Akd" class="<?php echo $ekpt_mhsfeed_list->Status_Akd->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $ekpt_mhsfeed_list->SortUrl($ekpt_mhsfeed_list->Status_Akd) ?>', 1);"><div id="elh_ekpt_mhsfeed_Status_Akd" class="ekpt_mhsfeed_Status_Akd">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ekpt_mhsfeed_list->Status_Akd->caption() ?></span><span class="ew-table-header-sort"><?php if ($ekpt_mhsfeed_list->Status_Akd->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($ekpt_mhsfeed_list->Status_Akd->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ekpt_mhsfeed_list->TSKS->Visible) { // TSKS ?>
	<?php if ($ekpt_mhsfeed_list->SortUrl($ekpt_mhsfeed_list->TSKS) == "") { ?>
		<th data-name="TSKS" class="<?php echo $ekpt_mhsfeed_list->TSKS->headerCellClass() ?>"><div id="elh_ekpt_mhsfeed_TSKS" class="ekpt_mhsfeed_TSKS"><div class="ew-table-header-caption"><?php echo $ekpt_mhsfeed_list->TSKS->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="TSKS" class="<?php echo $ekpt_mhsfeed_list->TSKS->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $ekpt_mhsfeed_list->SortUrl($ekpt_mhsfeed_list->TSKS) ?>', 1);"><div id="elh_ekpt_mhsfeed_TSKS" class="ekpt_mhsfeed_TSKS">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ekpt_mhsfeed_list->TSKS->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($ekpt_mhsfeed_list->TSKS->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($ekpt_mhsfeed_list->TSKS->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ekpt_mhsfeed_list->PerMasuk->Visible) { // PerMasuk ?>
	<?php if ($ekpt_mhsfeed_list->SortUrl($ekpt_mhsfeed_list->PerMasuk) == "") { ?>
		<th data-name="PerMasuk" class="<?php echo $ekpt_mhsfeed_list->PerMasuk->headerCellClass() ?>"><div id="elh_ekpt_mhsfeed_PerMasuk" class="ekpt_mhsfeed_PerMasuk"><div class="ew-table-header-caption"><?php echo $ekpt_mhsfeed_list->PerMasuk->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="PerMasuk" class="<?php echo $ekpt_mhsfeed_list->PerMasuk->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $ekpt_mhsfeed_list->SortUrl($ekpt_mhsfeed_list->PerMasuk) ?>', 1);"><div id="elh_ekpt_mhsfeed_PerMasuk" class="ekpt_mhsfeed_PerMasuk">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ekpt_mhsfeed_list->PerMasuk->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($ekpt_mhsfeed_list->PerMasuk->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($ekpt_mhsfeed_list->PerMasuk->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ekpt_mhsfeed_list->Status->Visible) { // Status ?>
	<?php if ($ekpt_mhsfeed_list->SortUrl($ekpt_mhsfeed_list->Status) == "") { ?>
		<th data-name="Status" class="<?php echo $ekpt_mhsfeed_list->Status->headerCellClass() ?>"><div id="elh_ekpt_mhsfeed_Status" class="ekpt_mhsfeed_Status"><div class="ew-table-header-caption"><?php echo $ekpt_mhsfeed_list->Status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Status" class="<?php echo $ekpt_mhsfeed_list->Status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $ekpt_mhsfeed_list->SortUrl($ekpt_mhsfeed_list->Status) ?>', 1);"><div id="elh_ekpt_mhsfeed_Status" class="ekpt_mhsfeed_Status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ekpt_mhsfeed_list->Status->caption() ?></span><span class="ew-table-header-sort"><?php if ($ekpt_mhsfeed_list->Status->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($ekpt_mhsfeed_list->Status->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ekpt_mhsfeed_list->PerKeluar->Visible) { // PerKeluar ?>
	<?php if ($ekpt_mhsfeed_list->SortUrl($ekpt_mhsfeed_list->PerKeluar) == "") { ?>
		<th data-name="PerKeluar" class="<?php echo $ekpt_mhsfeed_list->PerKeluar->headerCellClass() ?>"><div id="elh_ekpt_mhsfeed_PerKeluar" class="ekpt_mhsfeed_PerKeluar"><div class="ew-table-header-caption"><?php echo $ekpt_mhsfeed_list->PerKeluar->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="PerKeluar" class="<?php echo $ekpt_mhsfeed_list->PerKeluar->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $ekpt_mhsfeed_list->SortUrl($ekpt_mhsfeed_list->PerKeluar) ?>', 1);"><div id="elh_ekpt_mhsfeed_PerKeluar" class="ekpt_mhsfeed_PerKeluar">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ekpt_mhsfeed_list->PerKeluar->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($ekpt_mhsfeed_list->PerKeluar->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($ekpt_mhsfeed_list->PerKeluar->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ekpt_mhsfeed_list->TglKeluar->Visible) { // TglKeluar ?>
	<?php if ($ekpt_mhsfeed_list->SortUrl($ekpt_mhsfeed_list->TglKeluar) == "") { ?>
		<th data-name="TglKeluar" class="<?php echo $ekpt_mhsfeed_list->TglKeluar->headerCellClass() ?>"><div id="elh_ekpt_mhsfeed_TglKeluar" class="ekpt_mhsfeed_TglKeluar"><div class="ew-table-header-caption"><?php echo $ekpt_mhsfeed_list->TglKeluar->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="TglKeluar" class="<?php echo $ekpt_mhsfeed_list->TglKeluar->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $ekpt_mhsfeed_list->SortUrl($ekpt_mhsfeed_list->TglKeluar) ?>', 1);"><div id="elh_ekpt_mhsfeed_TglKeluar" class="ekpt_mhsfeed_TglKeluar">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ekpt_mhsfeed_list->TglKeluar->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($ekpt_mhsfeed_list->TglKeluar->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($ekpt_mhsfeed_list->TglKeluar->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ekpt_mhsfeed_list->StatusSIAP->Visible) { // StatusSIAP ?>
	<?php if ($ekpt_mhsfeed_list->SortUrl($ekpt_mhsfeed_list->StatusSIAP) == "") { ?>
		<th data-name="StatusSIAP" class="<?php echo $ekpt_mhsfeed_list->StatusSIAP->headerCellClass() ?>"><div id="elh_ekpt_mhsfeed_StatusSIAP" class="ekpt_mhsfeed_StatusSIAP"><div class="ew-table-header-caption"><?php echo $ekpt_mhsfeed_list->StatusSIAP->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="StatusSIAP" class="<?php echo $ekpt_mhsfeed_list->StatusSIAP->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $ekpt_mhsfeed_list->SortUrl($ekpt_mhsfeed_list->StatusSIAP) ?>', 1);"><div id="elh_ekpt_mhsfeed_StatusSIAP" class="ekpt_mhsfeed_StatusSIAP">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ekpt_mhsfeed_list->StatusSIAP->caption() ?></span><span class="ew-table-header-sort"><?php if ($ekpt_mhsfeed_list->StatusSIAP->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($ekpt_mhsfeed_list->StatusSIAP->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ekpt_mhsfeed_list->PerMasukIM->Visible) { // PerMasukIM ?>
	<?php if ($ekpt_mhsfeed_list->SortUrl($ekpt_mhsfeed_list->PerMasukIM) == "") { ?>
		<th data-name="PerMasukIM" class="<?php echo $ekpt_mhsfeed_list->PerMasukIM->headerCellClass() ?>"><div id="elh_ekpt_mhsfeed_PerMasukIM" class="ekpt_mhsfeed_PerMasukIM"><div class="ew-table-header-caption"><?php echo $ekpt_mhsfeed_list->PerMasukIM->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="PerMasukIM" class="<?php echo $ekpt_mhsfeed_list->PerMasukIM->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $ekpt_mhsfeed_list->SortUrl($ekpt_mhsfeed_list->PerMasukIM) ?>', 1);"><div id="elh_ekpt_mhsfeed_PerMasukIM" class="ekpt_mhsfeed_PerMasukIM">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ekpt_mhsfeed_list->PerMasukIM->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($ekpt_mhsfeed_list->PerMasukIM->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($ekpt_mhsfeed_list->PerMasukIM->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ekpt_mhsfeed_list->tglmasuk->Visible) { // tglmasuk ?>
	<?php if ($ekpt_mhsfeed_list->SortUrl($ekpt_mhsfeed_list->tglmasuk) == "") { ?>
		<th data-name="tglmasuk" class="<?php echo $ekpt_mhsfeed_list->tglmasuk->headerCellClass() ?>"><div id="elh_ekpt_mhsfeed_tglmasuk" class="ekpt_mhsfeed_tglmasuk"><div class="ew-table-header-caption"><?php echo $ekpt_mhsfeed_list->tglmasuk->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="tglmasuk" class="<?php echo $ekpt_mhsfeed_list->tglmasuk->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $ekpt_mhsfeed_list->SortUrl($ekpt_mhsfeed_list->tglmasuk) ?>', 1);"><div id="elh_ekpt_mhsfeed_tglmasuk" class="ekpt_mhsfeed_tglmasuk">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ekpt_mhsfeed_list->tglmasuk->caption() ?></span><span class="ew-table-header-sort"><?php if ($ekpt_mhsfeed_list->tglmasuk->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($ekpt_mhsfeed_list->tglmasuk->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ekpt_mhsfeed_list->Status_Masuk->Visible) { // Status_Masuk ?>
	<?php if ($ekpt_mhsfeed_list->SortUrl($ekpt_mhsfeed_list->Status_Masuk) == "") { ?>
		<th data-name="Status_Masuk" class="<?php echo $ekpt_mhsfeed_list->Status_Masuk->headerCellClass() ?>"><div id="elh_ekpt_mhsfeed_Status_Masuk" class="ekpt_mhsfeed_Status_Masuk"><div class="ew-table-header-caption"><?php echo $ekpt_mhsfeed_list->Status_Masuk->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Status_Masuk" class="<?php echo $ekpt_mhsfeed_list->Status_Masuk->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $ekpt_mhsfeed_list->SortUrl($ekpt_mhsfeed_list->Status_Masuk) ?>', 1);"><div id="elh_ekpt_mhsfeed_Status_Masuk" class="ekpt_mhsfeed_Status_Masuk">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ekpt_mhsfeed_list->Status_Masuk->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($ekpt_mhsfeed_list->Status_Masuk->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($ekpt_mhsfeed_list->Status_Masuk->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ekpt_mhsfeed_list->PerLulusIM->Visible) { // PerLulusIM ?>
	<?php if ($ekpt_mhsfeed_list->SortUrl($ekpt_mhsfeed_list->PerLulusIM) == "") { ?>
		<th data-name="PerLulusIM" class="<?php echo $ekpt_mhsfeed_list->PerLulusIM->headerCellClass() ?>"><div id="elh_ekpt_mhsfeed_PerLulusIM" class="ekpt_mhsfeed_PerLulusIM"><div class="ew-table-header-caption"><?php echo $ekpt_mhsfeed_list->PerLulusIM->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="PerLulusIM" class="<?php echo $ekpt_mhsfeed_list->PerLulusIM->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $ekpt_mhsfeed_list->SortUrl($ekpt_mhsfeed_list->PerLulusIM) ?>', 1);"><div id="elh_ekpt_mhsfeed_PerLulusIM" class="ekpt_mhsfeed_PerLulusIM">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ekpt_mhsfeed_list->PerLulusIM->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($ekpt_mhsfeed_list->PerLulusIM->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($ekpt_mhsfeed_list->PerLulusIM->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ekpt_mhsfeed_list->Tgl_Lulus->Visible) { // Tgl_Lulus ?>
	<?php if ($ekpt_mhsfeed_list->SortUrl($ekpt_mhsfeed_list->Tgl_Lulus) == "") { ?>
		<th data-name="Tgl_Lulus" class="<?php echo $ekpt_mhsfeed_list->Tgl_Lulus->headerCellClass() ?>"><div id="elh_ekpt_mhsfeed_Tgl_Lulus" class="ekpt_mhsfeed_Tgl_Lulus"><div class="ew-table-header-caption"><?php echo $ekpt_mhsfeed_list->Tgl_Lulus->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Tgl_Lulus" class="<?php echo $ekpt_mhsfeed_list->Tgl_Lulus->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $ekpt_mhsfeed_list->SortUrl($ekpt_mhsfeed_list->Tgl_Lulus) ?>', 1);"><div id="elh_ekpt_mhsfeed_Tgl_Lulus" class="ekpt_mhsfeed_Tgl_Lulus">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ekpt_mhsfeed_list->Tgl_Lulus->caption() ?></span><span class="ew-table-header-sort"><?php if ($ekpt_mhsfeed_list->Tgl_Lulus->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($ekpt_mhsfeed_list->Tgl_Lulus->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ekpt_mhsfeed_list->No_Ijazah->Visible) { // No_Ijazah ?>
	<?php if ($ekpt_mhsfeed_list->SortUrl($ekpt_mhsfeed_list->No_Ijazah) == "") { ?>
		<th data-name="No_Ijazah" class="<?php echo $ekpt_mhsfeed_list->No_Ijazah->headerCellClass() ?>"><div id="elh_ekpt_mhsfeed_No_Ijazah" class="ekpt_mhsfeed_No_Ijazah"><div class="ew-table-header-caption"><?php echo $ekpt_mhsfeed_list->No_Ijazah->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="No_Ijazah" class="<?php echo $ekpt_mhsfeed_list->No_Ijazah->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $ekpt_mhsfeed_list->SortUrl($ekpt_mhsfeed_list->No_Ijazah) ?>', 1);"><div id="elh_ekpt_mhsfeed_No_Ijazah" class="ekpt_mhsfeed_No_Ijazah">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ekpt_mhsfeed_list->No_Ijazah->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($ekpt_mhsfeed_list->No_Ijazah->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($ekpt_mhsfeed_list->No_Ijazah->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ekpt_mhsfeed_list->TaAkhir->Visible) { // TaAkhir ?>
	<?php if ($ekpt_mhsfeed_list->SortUrl($ekpt_mhsfeed_list->TaAkhir) == "") { ?>
		<th data-name="TaAkhir" class="<?php echo $ekpt_mhsfeed_list->TaAkhir->headerCellClass() ?>"><div id="elh_ekpt_mhsfeed_TaAkhir" class="ekpt_mhsfeed_TaAkhir"><div class="ew-table-header-caption"><?php echo $ekpt_mhsfeed_list->TaAkhir->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="TaAkhir" class="<?php echo $ekpt_mhsfeed_list->TaAkhir->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $ekpt_mhsfeed_list->SortUrl($ekpt_mhsfeed_list->TaAkhir) ?>', 1);"><div id="elh_ekpt_mhsfeed_TaAkhir" class="ekpt_mhsfeed_TaAkhir">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ekpt_mhsfeed_list->TaAkhir->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($ekpt_mhsfeed_list->TaAkhir->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($ekpt_mhsfeed_list->TaAkhir->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<th>Riwayat</th>
<?php if ($ekpt_mhsfeed_list->Ijazah->Visible) { // Ijazah ?>
	<?php if ($ekpt_mhsfeed_list->SortUrl($ekpt_mhsfeed_list->Ijazah) == "") { ?>
		<th data-name="Ijazah" class="<?php echo $ekpt_mhsfeed_list->Ijazah->headerCellClass() ?>"><div id="elh_ekpt_mhsfeed_Ijazah" class="ekpt_mhsfeed_Ijazah"><div class="ew-table-header-caption"><?php echo $ekpt_mhsfeed_list->Ijazah->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Ijazah" class="<?php echo $ekpt_mhsfeed_list->Ijazah->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $ekpt_mhsfeed_list->SortUrl($ekpt_mhsfeed_list->Ijazah) ?>', 1);"><div id="elh_ekpt_mhsfeed_Ijazah" class="ekpt_mhsfeed_Ijazah">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ekpt_mhsfeed_list->Ijazah->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($ekpt_mhsfeed_list->Ijazah->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($ekpt_mhsfeed_list->Ijazah->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ekpt_mhsfeed_list->Ktp->Visible) { // Ktp ?>
	<?php if ($ekpt_mhsfeed_list->SortUrl($ekpt_mhsfeed_list->Ktp) == "") { ?>
		<th data-name="Ktp" class="<?php echo $ekpt_mhsfeed_list->Ktp->headerCellClass() ?>"><div id="elh_ekpt_mhsfeed_Ktp" class="ekpt_mhsfeed_Ktp"><div class="ew-table-header-caption"><?php echo $ekpt_mhsfeed_list->Ktp->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Ktp" class="<?php echo $ekpt_mhsfeed_list->Ktp->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $ekpt_mhsfeed_list->SortUrl($ekpt_mhsfeed_list->Ktp) ?>', 1);"><div id="elh_ekpt_mhsfeed_Ktp" class="ekpt_mhsfeed_Ktp">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ekpt_mhsfeed_list->Ktp->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($ekpt_mhsfeed_list->Ktp->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($ekpt_mhsfeed_list->Ktp->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ekpt_mhsfeed_list->KK->Visible) { // KK ?>
	<?php if ($ekpt_mhsfeed_list->SortUrl($ekpt_mhsfeed_list->KK) == "") { ?>
		<th data-name="KK" class="<?php echo $ekpt_mhsfeed_list->KK->headerCellClass() ?>"><div id="elh_ekpt_mhsfeed_KK" class="ekpt_mhsfeed_KK"><div class="ew-table-header-caption"><?php echo $ekpt_mhsfeed_list->KK->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="KK" class="<?php echo $ekpt_mhsfeed_list->KK->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $ekpt_mhsfeed_list->SortUrl($ekpt_mhsfeed_list->KK) ?>', 1);"><div id="elh_ekpt_mhsfeed_KK" class="ekpt_mhsfeed_KK">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ekpt_mhsfeed_list->KK->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($ekpt_mhsfeed_list->KK->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($ekpt_mhsfeed_list->KK->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ekpt_mhsfeed_list->riwayatakademik->Visible) { // riwayatakademik ?>
	<?php if ($ekpt_mhsfeed_list->SortUrl($ekpt_mhsfeed_list->riwayatakademik) == "") { ?>
		<th data-name="riwayatakademik" class="<?php echo $ekpt_mhsfeed_list->riwayatakademik->headerCellClass() ?>"><div id="elh_ekpt_mhsfeed_riwayatakademik" class="ekpt_mhsfeed_riwayatakademik"><div class="ew-table-header-caption"><?php echo $ekpt_mhsfeed_list->riwayatakademik->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="riwayatakademik" class="<?php echo $ekpt_mhsfeed_list->riwayatakademik->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $ekpt_mhsfeed_list->SortUrl($ekpt_mhsfeed_list->riwayatakademik) ?>', 1);"><div id="elh_ekpt_mhsfeed_riwayatakademik" class="ekpt_mhsfeed_riwayatakademik">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ekpt_mhsfeed_list->riwayatakademik->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($ekpt_mhsfeed_list->riwayatakademik->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($ekpt_mhsfeed_list->riwayatakademik->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ekpt_mhsfeed_list->IjazahIM->Visible) { // IjazahIM ?>
	<?php if ($ekpt_mhsfeed_list->SortUrl($ekpt_mhsfeed_list->IjazahIM) == "") { ?>
		<th data-name="IjazahIM" class="<?php echo $ekpt_mhsfeed_list->IjazahIM->headerCellClass() ?>"><div id="elh_ekpt_mhsfeed_IjazahIM" class="ekpt_mhsfeed_IjazahIM"><div class="ew-table-header-caption"><?php echo $ekpt_mhsfeed_list->IjazahIM->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="IjazahIM" class="<?php echo $ekpt_mhsfeed_list->IjazahIM->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $ekpt_mhsfeed_list->SortUrl($ekpt_mhsfeed_list->IjazahIM) ?>', 1);"><div id="elh_ekpt_mhsfeed_IjazahIM" class="ekpt_mhsfeed_IjazahIM">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ekpt_mhsfeed_list->IjazahIM->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($ekpt_mhsfeed_list->IjazahIM->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($ekpt_mhsfeed_list->IjazahIM->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ekpt_mhsfeed_list->TranskriptIM->Visible) { // TranskriptIM ?>
	<?php if ($ekpt_mhsfeed_list->SortUrl($ekpt_mhsfeed_list->TranskriptIM) == "") { ?>
		<th data-name="TranskriptIM" class="<?php echo $ekpt_mhsfeed_list->TranskriptIM->headerCellClass() ?>"><div id="elh_ekpt_mhsfeed_TranskriptIM" class="ekpt_mhsfeed_TranskriptIM"><div class="ew-table-header-caption"><?php echo $ekpt_mhsfeed_list->TranskriptIM->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="TranskriptIM" class="<?php echo $ekpt_mhsfeed_list->TranskriptIM->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $ekpt_mhsfeed_list->SortUrl($ekpt_mhsfeed_list->TranskriptIM) ?>', 1);"><div id="elh_ekpt_mhsfeed_TranskriptIM" class="ekpt_mhsfeed_TranskriptIM">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ekpt_mhsfeed_list->TranskriptIM->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($ekpt_mhsfeed_list->TranskriptIM->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($ekpt_mhsfeed_list->TranskriptIM->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ekpt_mhsfeed_list->Skripsi->Visible) { // Skripsi ?>
	<?php if ($ekpt_mhsfeed_list->SortUrl($ekpt_mhsfeed_list->Skripsi) == "") { ?>
		<th data-name="Skripsi" class="<?php echo $ekpt_mhsfeed_list->Skripsi->headerCellClass() ?>"><div id="elh_ekpt_mhsfeed_Skripsi" class="ekpt_mhsfeed_Skripsi"><div class="ew-table-header-caption"><?php echo $ekpt_mhsfeed_list->Skripsi->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Skripsi" class="<?php echo $ekpt_mhsfeed_list->Skripsi->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $ekpt_mhsfeed_list->SortUrl($ekpt_mhsfeed_list->Skripsi) ?>', 1);"><div id="elh_ekpt_mhsfeed_Skripsi" class="ekpt_mhsfeed_Skripsi">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ekpt_mhsfeed_list->Skripsi->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($ekpt_mhsfeed_list->Skripsi->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($ekpt_mhsfeed_list->Skripsi->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ekpt_mhsfeed_list->TASkripsi->Visible) { // TASkripsi ?>
	<?php if ($ekpt_mhsfeed_list->SortUrl($ekpt_mhsfeed_list->TASkripsi) == "") { ?>
		<th data-name="TASkripsi" class="<?php echo $ekpt_mhsfeed_list->TASkripsi->headerCellClass() ?>"><div id="elh_ekpt_mhsfeed_TASkripsi" class="ekpt_mhsfeed_TASkripsi"><div class="ew-table-header-caption"><?php echo $ekpt_mhsfeed_list->TASkripsi->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="TASkripsi" class="<?php echo $ekpt_mhsfeed_list->TASkripsi->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $ekpt_mhsfeed_list->SortUrl($ekpt_mhsfeed_list->TASkripsi) ?>', 1);"><div id="elh_ekpt_mhsfeed_TASkripsi" class="ekpt_mhsfeed_TASkripsi">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ekpt_mhsfeed_list->TASkripsi->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($ekpt_mhsfeed_list->TASkripsi->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($ekpt_mhsfeed_list->TASkripsi->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ekpt_mhsfeed_list->Plagiat->Visible) { // Plagiat ?>
	<?php if ($ekpt_mhsfeed_list->SortUrl($ekpt_mhsfeed_list->Plagiat) == "") { ?>
		<th data-name="Plagiat" class="<?php echo $ekpt_mhsfeed_list->Plagiat->headerCellClass() ?>"><div id="elh_ekpt_mhsfeed_Plagiat" class="ekpt_mhsfeed_Plagiat"><div class="ew-table-header-caption"><?php echo $ekpt_mhsfeed_list->Plagiat->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Plagiat" class="<?php echo $ekpt_mhsfeed_list->Plagiat->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $ekpt_mhsfeed_list->SortUrl($ekpt_mhsfeed_list->Plagiat) ?>', 1);"><div id="elh_ekpt_mhsfeed_Plagiat" class="ekpt_mhsfeed_Plagiat">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ekpt_mhsfeed_list->Plagiat->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($ekpt_mhsfeed_list->Plagiat->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($ekpt_mhsfeed_list->Plagiat->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ekpt_mhsfeed_list->keuangan->Visible) { // keuangan ?>
	<?php if ($ekpt_mhsfeed_list->SortUrl($ekpt_mhsfeed_list->keuangan) == "") { ?>
		<th data-name="keuangan" class="<?php echo $ekpt_mhsfeed_list->keuangan->headerCellClass() ?>"><div id="elh_ekpt_mhsfeed_keuangan" class="ekpt_mhsfeed_keuangan"><div class="ew-table-header-caption"><?php echo $ekpt_mhsfeed_list->keuangan->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="keuangan" class="<?php echo $ekpt_mhsfeed_list->keuangan->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $ekpt_mhsfeed_list->SortUrl($ekpt_mhsfeed_list->keuangan) ?>', 1);"><div id="elh_ekpt_mhsfeed_keuangan" class="ekpt_mhsfeed_keuangan">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ekpt_mhsfeed_list->keuangan->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($ekpt_mhsfeed_list->keuangan->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($ekpt_mhsfeed_list->keuangan->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ekpt_mhsfeed_list->pendukung->Visible) { // pendukung ?>
	<?php if ($ekpt_mhsfeed_list->SortUrl($ekpt_mhsfeed_list->pendukung) == "") { ?>
		<th data-name="pendukung" class="<?php echo $ekpt_mhsfeed_list->pendukung->headerCellClass() ?>"><div id="elh_ekpt_mhsfeed_pendukung" class="ekpt_mhsfeed_pendukung"><div class="ew-table-header-caption"><?php echo $ekpt_mhsfeed_list->pendukung->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pendukung" class="<?php echo $ekpt_mhsfeed_list->pendukung->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $ekpt_mhsfeed_list->SortUrl($ekpt_mhsfeed_list->pendukung) ?>', 1);"><div id="elh_ekpt_mhsfeed_pendukung" class="ekpt_mhsfeed_pendukung">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ekpt_mhsfeed_list->pendukung->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($ekpt_mhsfeed_list->pendukung->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($ekpt_mhsfeed_list->pendukung->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ekpt_mhsfeed_list->lainlain->Visible) { // lainlain ?>
	<?php if ($ekpt_mhsfeed_list->SortUrl($ekpt_mhsfeed_list->lainlain) == "") { ?>
		<th data-name="lainlain" class="<?php echo $ekpt_mhsfeed_list->lainlain->headerCellClass() ?>"><div id="elh_ekpt_mhsfeed_lainlain" class="ekpt_mhsfeed_lainlain"><div class="ew-table-header-caption"><?php echo $ekpt_mhsfeed_list->lainlain->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="lainlain" class="<?php echo $ekpt_mhsfeed_list->lainlain->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $ekpt_mhsfeed_list->SortUrl($ekpt_mhsfeed_list->lainlain) ?>', 1);"><div id="elh_ekpt_mhsfeed_lainlain" class="ekpt_mhsfeed_lainlain">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ekpt_mhsfeed_list->lainlain->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($ekpt_mhsfeed_list->lainlain->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($ekpt_mhsfeed_list->lainlain->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$ekpt_mhsfeed_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($ekpt_mhsfeed_list->ExportAll && $ekpt_mhsfeed_list->isExport()) {
	$ekpt_mhsfeed_list->StopRecord = $ekpt_mhsfeed_list->TotalRecords;
} else {

	// Set the last record to display
	if ($ekpt_mhsfeed_list->TotalRecords > $ekpt_mhsfeed_list->StartRecord + $ekpt_mhsfeed_list->DisplayRecords - 1)
		$ekpt_mhsfeed_list->StopRecord = $ekpt_mhsfeed_list->StartRecord + $ekpt_mhsfeed_list->DisplayRecords - 1;
	else
		$ekpt_mhsfeed_list->StopRecord = $ekpt_mhsfeed_list->TotalRecords;
}
$ekpt_mhsfeed_list->RecordCount = $ekpt_mhsfeed_list->StartRecord - 1;
if ($ekpt_mhsfeed_list->Recordset && !$ekpt_mhsfeed_list->Recordset->EOF) {
	$ekpt_mhsfeed_list->Recordset->moveFirst();
	$selectLimit = $ekpt_mhsfeed_list->UseSelectLimit;
	if (!$selectLimit && $ekpt_mhsfeed_list->StartRecord > 1)
		$ekpt_mhsfeed_list->Recordset->move($ekpt_mhsfeed_list->StartRecord - 1);
} elseif (!$ekpt_mhsfeed->AllowAddDeleteRow && $ekpt_mhsfeed_list->StopRecord == 0) {
	$ekpt_mhsfeed_list->StopRecord = $ekpt_mhsfeed->GridAddRowCount;
}

// Initialize aggregate
$ekpt_mhsfeed->RowType = ROWTYPE_AGGREGATEINIT;
$ekpt_mhsfeed->resetAttributes();
$ekpt_mhsfeed_list->renderRow();
while ($ekpt_mhsfeed_list->RecordCount < $ekpt_mhsfeed_list->StopRecord) {
	$ekpt_mhsfeed_list->RecordCount++;
	if ($ekpt_mhsfeed_list->RecordCount >= $ekpt_mhsfeed_list->StartRecord) {
		$ekpt_mhsfeed_list->RowCount++;

		// Set up key count
		$ekpt_mhsfeed_list->KeyCount = $ekpt_mhsfeed_list->RowIndex;

		// Init row class and style
		$ekpt_mhsfeed->resetAttributes();
		$ekpt_mhsfeed->CssClass = "";
		if ($ekpt_mhsfeed_list->isGridAdd()) {
		} else {
			$ekpt_mhsfeed_list->loadRowValues($ekpt_mhsfeed_list->Recordset); // Load row values
		}
		$ekpt_mhsfeed->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$ekpt_mhsfeed->RowAttrs->merge(["data-rowindex" => $ekpt_mhsfeed_list->RowCount, "id" => "r" . $ekpt_mhsfeed_list->RowCount . "_ekpt_mhsfeed", "data-rowtype" => $ekpt_mhsfeed->RowType]);

		// Render row
		$ekpt_mhsfeed_list->renderRow();

		// Render list options
		$ekpt_mhsfeed_list->renderListOptions();
?>
	<tr <?php echo $ekpt_mhsfeed->rowAttributes() ?>>
<?php

// Render list options (body, left)
$ekpt_mhsfeed_list->ListOptions->render("body", "left", $ekpt_mhsfeed_list->RowCount);
?>
	<?php if ($ekpt_mhsfeed_list->Kode_Fak->Visible) { // Kode_Fak ?>
		<td data-name="Kode_Fak" <?php echo $ekpt_mhsfeed_list->Kode_Fak->cellAttributes() ?>>
<span id="el<?php echo $ekpt_mhsfeed_list->RowCount ?>_ekpt_mhsfeed_Kode_Fak">
<span<?php echo $ekpt_mhsfeed_list->Kode_Fak->viewAttributes() ?>><?php echo $ekpt_mhsfeed_list->Kode_Fak->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($ekpt_mhsfeed_list->Kode_Jp->Visible) { // Kode_Jp ?>
		<td data-name="Kode_Jp" <?php echo $ekpt_mhsfeed_list->Kode_Jp->cellAttributes() ?>>
<span id="el<?php echo $ekpt_mhsfeed_list->RowCount ?>_ekpt_mhsfeed_Kode_Jp">
<span<?php echo $ekpt_mhsfeed_list->Kode_Jp->viewAttributes() ?>><?php echo $ekpt_mhsfeed_list->Kode_Jp->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($ekpt_mhsfeed_list->NimIM->Visible) { // NimIM ?>
		<td data-name="NimIM" <?php echo $ekpt_mhsfeed_list->NimIM->cellAttributes() ?>>
<span id="el<?php echo $ekpt_mhsfeed_list->RowCount ?>_ekpt_mhsfeed_NimIM">
<span<?php echo $ekpt_mhsfeed_list->NimIM->viewAttributes() ?>><?php echo $ekpt_mhsfeed_list->NimIM->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($ekpt_mhsfeed_list->NamaMhs->Visible) { // NamaMhs ?>
		<td data-name="NamaMhs" <?php echo $ekpt_mhsfeed_list->NamaMhs->cellAttributes() ?>>
<span id="el<?php echo $ekpt_mhsfeed_list->RowCount ?>_ekpt_mhsfeed_NamaMhs">
<span<?php echo $ekpt_mhsfeed_list->NamaMhs->viewAttributes() ?>><?php echo $ekpt_mhsfeed_list->NamaMhs->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($ekpt_mhsfeed_list->Status_Akd->Visible) { // Status_Akd ?>
		<td data-name="Status_Akd" <?php echo $ekpt_mhsfeed_list->Status_Akd->cellAttributes() ?>>
<span id="el<?php echo $ekpt_mhsfeed_list->RowCount ?>_ekpt_mhsfeed_Status_Akd">
<span<?php echo $ekpt_mhsfeed_list->Status_Akd->viewAttributes() ?>><?php echo $ekpt_mhsfeed_list->Status_Akd->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($ekpt_mhsfeed_list->TSKS->Visible) { // TSKS ?>
		<td data-name="TSKS" <?php echo $ekpt_mhsfeed_list->TSKS->cellAttributes() ?>>
<span id="el<?php echo $ekpt_mhsfeed_list->RowCount ?>_ekpt_mhsfeed_TSKS">
<span<?php echo $ekpt_mhsfeed_list->TSKS->viewAttributes() ?>><?php echo $ekpt_mhsfeed_list->TSKS->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($ekpt_mhsfeed_list->PerMasuk->Visible) { // PerMasuk ?>
		<td data-name="PerMasuk" <?php echo $ekpt_mhsfeed_list->PerMasuk->cellAttributes() ?>>
<span id="el<?php echo $ekpt_mhsfeed_list->RowCount ?>_ekpt_mhsfeed_PerMasuk">
<span<?php echo $ekpt_mhsfeed_list->PerMasuk->viewAttributes() ?>><?php echo $ekpt_mhsfeed_list->PerMasuk->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($ekpt_mhsfeed_list->Status->Visible) { // Status ?>
		<td data-name="Status" <?php echo $ekpt_mhsfeed_list->Status->cellAttributes() ?>>
<span id="el<?php echo $ekpt_mhsfeed_list->RowCount ?>_ekpt_mhsfeed_Status">
<span<?php echo $ekpt_mhsfeed_list->Status->viewAttributes() ?>><?php echo $ekpt_mhsfeed_list->Status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($ekpt_mhsfeed_list->PerKeluar->Visible) { // PerKeluar ?>
		<td data-name="PerKeluar" <?php echo $ekpt_mhsfeed_list->PerKeluar->cellAttributes() ?>>
<span id="el<?php echo $ekpt_mhsfeed_list->RowCount ?>_ekpt_mhsfeed_PerKeluar">
<span<?php echo $ekpt_mhsfeed_list->PerKeluar->viewAttributes() ?>><?php echo $ekpt_mhsfeed_list->PerKeluar->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($ekpt_mhsfeed_list->TglKeluar->Visible) { // TglKeluar ?>
		<td data-name="TglKeluar" <?php echo $ekpt_mhsfeed_list->TglKeluar->cellAttributes() ?>>
<span id="el<?php echo $ekpt_mhsfeed_list->RowCount ?>_ekpt_mhsfeed_TglKeluar">
<span<?php echo $ekpt_mhsfeed_list->TglKeluar->viewAttributes() ?>><?php echo $ekpt_mhsfeed_list->TglKeluar->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($ekpt_mhsfeed_list->StatusSIAP->Visible) { // StatusSIAP ?>
		<td data-name="StatusSIAP" <?php echo $ekpt_mhsfeed_list->StatusSIAP->cellAttributes() ?>>
<span id="el<?php echo $ekpt_mhsfeed_list->RowCount ?>_ekpt_mhsfeed_StatusSIAP">
<span<?php echo $ekpt_mhsfeed_list->StatusSIAP->viewAttributes() ?>><?php echo $ekpt_mhsfeed_list->StatusSIAP->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($ekpt_mhsfeed_list->PerMasukIM->Visible) { // PerMasukIM ?>
		<td data-name="PerMasukIM" <?php echo $ekpt_mhsfeed_list->PerMasukIM->cellAttributes() ?>>
<span id="el<?php echo $ekpt_mhsfeed_list->RowCount ?>_ekpt_mhsfeed_PerMasukIM">
<span<?php echo $ekpt_mhsfeed_list->PerMasukIM->viewAttributes() ?>><?php echo $ekpt_mhsfeed_list->PerMasukIM->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($ekpt_mhsfeed_list->tglmasuk->Visible) { // tglmasuk ?>
		<td data-name="tglmasuk" <?php echo $ekpt_mhsfeed_list->tglmasuk->cellAttributes() ?>>
<span id="el<?php echo $ekpt_mhsfeed_list->RowCount ?>_ekpt_mhsfeed_tglmasuk">
<span<?php echo $ekpt_mhsfeed_list->tglmasuk->viewAttributes() ?>><?php echo $ekpt_mhsfeed_list->tglmasuk->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($ekpt_mhsfeed_list->Status_Masuk->Visible) { // Status_Masuk ?>
		<td data-name="Status_Masuk" <?php echo $ekpt_mhsfeed_list->Status_Masuk->cellAttributes() ?>>
<span id="el<?php echo $ekpt_mhsfeed_list->RowCount ?>_ekpt_mhsfeed_Status_Masuk">
<span<?php echo $ekpt_mhsfeed_list->Status_Masuk->viewAttributes() ?>><?php echo $ekpt_mhsfeed_list->Status_Masuk->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($ekpt_mhsfeed_list->PerLulusIM->Visible) { // PerLulusIM ?>
		<td data-name="PerLulusIM" <?php echo $ekpt_mhsfeed_list->PerLulusIM->cellAttributes() ?>>
<span id="el<?php echo $ekpt_mhsfeed_list->RowCount ?>_ekpt_mhsfeed_PerLulusIM">
<span<?php echo $ekpt_mhsfeed_list->PerLulusIM->viewAttributes() ?>><?php echo $ekpt_mhsfeed_list->PerLulusIM->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($ekpt_mhsfeed_list->Tgl_Lulus->Visible) { // Tgl_Lulus ?>
		<td data-name="Tgl_Lulus" <?php echo $ekpt_mhsfeed_list->Tgl_Lulus->cellAttributes() ?>>
<span id="el<?php echo $ekpt_mhsfeed_list->RowCount ?>_ekpt_mhsfeed_Tgl_Lulus">
<span<?php echo $ekpt_mhsfeed_list->Tgl_Lulus->viewAttributes() ?>><?php echo $ekpt_mhsfeed_list->Tgl_Lulus->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($ekpt_mhsfeed_list->No_Ijazah->Visible) { // No_Ijazah ?>
		<td data-name="No_Ijazah" <?php echo $ekpt_mhsfeed_list->No_Ijazah->cellAttributes() ?>>
<span id="el<?php echo $ekpt_mhsfeed_list->RowCount ?>_ekpt_mhsfeed_No_Ijazah">
<span<?php echo $ekpt_mhsfeed_list->No_Ijazah->viewAttributes() ?>><?php echo $ekpt_mhsfeed_list->No_Ijazah->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($ekpt_mhsfeed_list->TaAkhir->Visible) { // TaAkhir ?>
		<td data-name="TaAkhir" <?php echo $ekpt_mhsfeed_list->TaAkhir->cellAttributes() ?>>
<span id="el<?php echo $ekpt_mhsfeed_list->RowCount ?>_ekpt_mhsfeed_TaAkhir">
<span<?php echo $ekpt_mhsfeed_list->TaAkhir->viewAttributes() ?>><?php echo $ekpt_mhsfeed_list->TaAkhir->getViewValue() ?></span>
</span>
</td>
	<?php }
		$salt = "86458762398576twuitrweu@#UTUY&*%&****trwerutUTUYT";
		$id=md5($salt . rtrim($ekpt_mhsfeed_list->NimIM->getViewValue()));
	?>
	<td>
		<a class="btn btn-primary btn-sm" href="custom/ekpt.php?nim=<?php echo rtrim($ekpt_mhsfeed_list->NimIM->getViewValue()) ?>&id=<?php echo $id; ?>" role="button" target="_blank">Riwayat</a>   
	</td>
	<?php if ($ekpt_mhsfeed_list->Ijazah->Visible) { // Ijazah ?>
		<td data-name="Ijazah" <?php echo $ekpt_mhsfeed_list->Ijazah->cellAttributes() ?>>
<span id="el<?php echo $ekpt_mhsfeed_list->RowCount ?>_ekpt_mhsfeed_Ijazah">
<span<?php echo $ekpt_mhsfeed_list->Ijazah->viewAttributes() ?>><?php if (!EmptyString($ekpt_mhsfeed_list->Ijazah->getViewValue()) && $ekpt_mhsfeed_list->Ijazah->linkAttributes() != "") { ?>
<a<?php echo $ekpt_mhsfeed_list->Ijazah->linkAttributes() ?>><?php echo $ekpt_mhsfeed_list->Ijazah->getViewValue() ?></a>
<?php } else { ?>
<?php echo $ekpt_mhsfeed_list->Ijazah->getViewValue() ?>
<?php } ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($ekpt_mhsfeed_list->Ktp->Visible) { // Ktp ?>
		<td data-name="Ktp" <?php echo $ekpt_mhsfeed_list->Ktp->cellAttributes() ?>>
<span id="el<?php echo $ekpt_mhsfeed_list->RowCount ?>_ekpt_mhsfeed_Ktp">
<span<?php echo $ekpt_mhsfeed_list->Ktp->viewAttributes() ?>><?php if (!EmptyString($ekpt_mhsfeed_list->Ktp->getViewValue()) && $ekpt_mhsfeed_list->Ktp->linkAttributes() != "") { ?>
<a<?php echo $ekpt_mhsfeed_list->Ktp->linkAttributes() ?>><?php echo $ekpt_mhsfeed_list->Ktp->getViewValue() ?></a>
<?php } else { ?>
<?php echo $ekpt_mhsfeed_list->Ktp->getViewValue() ?>
<?php } ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($ekpt_mhsfeed_list->KK->Visible) { // KK ?>
		<td data-name="KK" <?php echo $ekpt_mhsfeed_list->KK->cellAttributes() ?>>
<span id="el<?php echo $ekpt_mhsfeed_list->RowCount ?>_ekpt_mhsfeed_KK">
<span<?php echo $ekpt_mhsfeed_list->KK->viewAttributes() ?>><?php if (!EmptyString($ekpt_mhsfeed_list->KK->getViewValue()) && $ekpt_mhsfeed_list->KK->linkAttributes() != "") { ?>
<a<?php echo $ekpt_mhsfeed_list->KK->linkAttributes() ?>><?php echo $ekpt_mhsfeed_list->KK->getViewValue() ?></a>
<?php } else { ?>
<?php echo $ekpt_mhsfeed_list->KK->getViewValue() ?>
<?php } ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($ekpt_mhsfeed_list->riwayatakademik->Visible) { // riwayatakademik ?>
		<td data-name="riwayatakademik" <?php echo $ekpt_mhsfeed_list->riwayatakademik->cellAttributes() ?>>
<span id="el<?php echo $ekpt_mhsfeed_list->RowCount ?>_ekpt_mhsfeed_riwayatakademik">
<span<?php echo $ekpt_mhsfeed_list->riwayatakademik->viewAttributes() ?>><?php if (!EmptyString($ekpt_mhsfeed_list->riwayatakademik->getViewValue()) && $ekpt_mhsfeed_list->riwayatakademik->linkAttributes() != "") { ?>
<a<?php echo $ekpt_mhsfeed_list->riwayatakademik->linkAttributes() ?>><?php echo $ekpt_mhsfeed_list->riwayatakademik->getViewValue() ?></a>
<?php } else { ?>
<?php echo $ekpt_mhsfeed_list->riwayatakademik->getViewValue() ?>
<?php } ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($ekpt_mhsfeed_list->IjazahIM->Visible) { // IjazahIM ?>
		<td data-name="IjazahIM" <?php echo $ekpt_mhsfeed_list->IjazahIM->cellAttributes() ?>>
<span id="el<?php echo $ekpt_mhsfeed_list->RowCount ?>_ekpt_mhsfeed_IjazahIM">
<span<?php echo $ekpt_mhsfeed_list->IjazahIM->viewAttributes() ?>><?php if (!EmptyString($ekpt_mhsfeed_list->IjazahIM->getViewValue()) && $ekpt_mhsfeed_list->IjazahIM->linkAttributes() != "") { ?>
<a<?php echo $ekpt_mhsfeed_list->IjazahIM->linkAttributes() ?>><?php echo $ekpt_mhsfeed_list->IjazahIM->getViewValue() ?></a>
<?php } else { ?>
<?php echo $ekpt_mhsfeed_list->IjazahIM->getViewValue() ?>
<?php } ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($ekpt_mhsfeed_list->TranskriptIM->Visible) { // TranskriptIM ?>
		<td data-name="TranskriptIM" <?php echo $ekpt_mhsfeed_list->TranskriptIM->cellAttributes() ?>>
<span id="el<?php echo $ekpt_mhsfeed_list->RowCount ?>_ekpt_mhsfeed_TranskriptIM">
<span<?php echo $ekpt_mhsfeed_list->TranskriptIM->viewAttributes() ?>><?php if (!EmptyString($ekpt_mhsfeed_list->TranskriptIM->getViewValue()) && $ekpt_mhsfeed_list->TranskriptIM->linkAttributes() != "") { ?>
<a<?php echo $ekpt_mhsfeed_list->TranskriptIM->linkAttributes() ?>><?php echo $ekpt_mhsfeed_list->TranskriptIM->getViewValue() ?></a>
<?php } else { ?>
<?php echo $ekpt_mhsfeed_list->TranskriptIM->getViewValue() ?>
<?php } ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($ekpt_mhsfeed_list->Skripsi->Visible) { // Skripsi ?>
		<td data-name="Skripsi" <?php echo $ekpt_mhsfeed_list->Skripsi->cellAttributes() ?>>
<span id="el<?php echo $ekpt_mhsfeed_list->RowCount ?>_ekpt_mhsfeed_Skripsi">
<span<?php echo $ekpt_mhsfeed_list->Skripsi->viewAttributes() ?>><?php if (!EmptyString($ekpt_mhsfeed_list->Skripsi->getViewValue()) && $ekpt_mhsfeed_list->Skripsi->linkAttributes() != "") { ?>
<a<?php echo $ekpt_mhsfeed_list->Skripsi->linkAttributes() ?>><?php echo $ekpt_mhsfeed_list->Skripsi->getViewValue() ?></a>
<?php } else { ?>
<?php echo $ekpt_mhsfeed_list->Skripsi->getViewValue() ?>
<?php } ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($ekpt_mhsfeed_list->TASkripsi->Visible) { // TASkripsi ?>
		<td data-name="TASkripsi" <?php echo $ekpt_mhsfeed_list->TASkripsi->cellAttributes() ?>>
<span id="el<?php echo $ekpt_mhsfeed_list->RowCount ?>_ekpt_mhsfeed_TASkripsi">
<span<?php echo $ekpt_mhsfeed_list->TASkripsi->viewAttributes() ?>><?php if (!EmptyString($ekpt_mhsfeed_list->TASkripsi->getViewValue()) && $ekpt_mhsfeed_list->TASkripsi->linkAttributes() != "") { ?>
<a<?php echo $ekpt_mhsfeed_list->TASkripsi->linkAttributes() ?>><?php echo $ekpt_mhsfeed_list->TASkripsi->getViewValue() ?></a>
<?php } else { ?>
<?php echo $ekpt_mhsfeed_list->TASkripsi->getViewValue() ?>
<?php } ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($ekpt_mhsfeed_list->Plagiat->Visible) { // Plagiat ?>
		<td data-name="Plagiat" <?php echo $ekpt_mhsfeed_list->Plagiat->cellAttributes() ?>>
<span id="el<?php echo $ekpt_mhsfeed_list->RowCount ?>_ekpt_mhsfeed_Plagiat">
<span<?php echo $ekpt_mhsfeed_list->Plagiat->viewAttributes() ?>><?php if (!EmptyString($ekpt_mhsfeed_list->Plagiat->getViewValue()) && $ekpt_mhsfeed_list->Plagiat->linkAttributes() != "") { ?>
<a<?php echo $ekpt_mhsfeed_list->Plagiat->linkAttributes() ?>><?php echo $ekpt_mhsfeed_list->Plagiat->getViewValue() ?></a>
<?php } else { ?>
<?php echo $ekpt_mhsfeed_list->Plagiat->getViewValue() ?>
<?php } ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($ekpt_mhsfeed_list->keuangan->Visible) { // keuangan ?>
		<td data-name="keuangan" <?php echo $ekpt_mhsfeed_list->keuangan->cellAttributes() ?>>
<span id="el<?php echo $ekpt_mhsfeed_list->RowCount ?>_ekpt_mhsfeed_keuangan">
<span<?php echo $ekpt_mhsfeed_list->keuangan->viewAttributes() ?>><?php if (!EmptyString($ekpt_mhsfeed_list->keuangan->getViewValue()) && $ekpt_mhsfeed_list->keuangan->linkAttributes() != "") { ?>
<a<?php echo $ekpt_mhsfeed_list->keuangan->linkAttributes() ?>><?php echo $ekpt_mhsfeed_list->keuangan->getViewValue() ?></a>
<?php } else { ?>
<?php echo $ekpt_mhsfeed_list->keuangan->getViewValue() ?>
<?php } ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($ekpt_mhsfeed_list->pendukung->Visible) { // pendukung ?>
		<td data-name="pendukung" <?php echo $ekpt_mhsfeed_list->pendukung->cellAttributes() ?>>
<span id="el<?php echo $ekpt_mhsfeed_list->RowCount ?>_ekpt_mhsfeed_pendukung">
<span<?php echo $ekpt_mhsfeed_list->pendukung->viewAttributes() ?>><?php if (!EmptyString($ekpt_mhsfeed_list->pendukung->getViewValue()) && $ekpt_mhsfeed_list->pendukung->linkAttributes() != "") { ?>
<a<?php echo $ekpt_mhsfeed_list->pendukung->linkAttributes() ?>><?php echo $ekpt_mhsfeed_list->pendukung->getViewValue() ?></a>
<?php } else { ?>
<?php echo $ekpt_mhsfeed_list->pendukung->getViewValue() ?>
<?php } ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($ekpt_mhsfeed_list->lainlain->Visible) { // lainlain ?>
		<td data-name="lainlain" <?php echo $ekpt_mhsfeed_list->lainlain->cellAttributes() ?>>
<span id="el<?php echo $ekpt_mhsfeed_list->RowCount ?>_ekpt_mhsfeed_lainlain">
<span<?php echo $ekpt_mhsfeed_list->lainlain->viewAttributes() ?>><?php if (!EmptyString($ekpt_mhsfeed_list->lainlain->getViewValue()) && $ekpt_mhsfeed_list->lainlain->linkAttributes() != "") { ?>
<a<?php echo $ekpt_mhsfeed_list->lainlain->linkAttributes() ?>><?php echo $ekpt_mhsfeed_list->lainlain->getViewValue() ?></a>
<?php } else { ?>
<?php echo $ekpt_mhsfeed_list->lainlain->getViewValue() ?>
<?php } ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$ekpt_mhsfeed_list->ListOptions->render("body", "right", $ekpt_mhsfeed_list->RowCount);
?>
	</tr>
<?php
	}
	if (!$ekpt_mhsfeed_list->isGridAdd())
		$ekpt_mhsfeed_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$ekpt_mhsfeed->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($ekpt_mhsfeed_list->Recordset)
	$ekpt_mhsfeed_list->Recordset->Close();
?>
<?php if (!$ekpt_mhsfeed_list->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$ekpt_mhsfeed_list->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $ekpt_mhsfeed_list->Pager->render() ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $ekpt_mhsfeed_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($ekpt_mhsfeed_list->TotalRecords == 0 && !$ekpt_mhsfeed->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $ekpt_mhsfeed_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$ekpt_mhsfeed_list->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$ekpt_mhsfeed_list->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$ekpt_mhsfeed_list->terminate();
?>