<?php
namespace PHPMaker2020\baak;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$ekpt_mhsfeed_search = new ekpt_mhsfeed_search();

// Run the page
$ekpt_mhsfeed_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$ekpt_mhsfeed_search->Page_Render();
?>
<?php include_once "header.php"; ?>
<script>
var fekpt_mhsfeedsearch, currentPageID;
loadjs.ready("head", function() {

	// Form object for search
	<?php if ($ekpt_mhsfeed_search->IsModal) { ?>
	fekpt_mhsfeedsearch = currentAdvancedSearchForm = new ew.Form("fekpt_mhsfeedsearch", "search");
	<?php } else { ?>
	fekpt_mhsfeedsearch = currentForm = new ew.Form("fekpt_mhsfeedsearch", "search");
	<?php } ?>
	currentPageID = ew.PAGE_ID = "search";

	// Validate function for search
	fekpt_mhsfeedsearch.validate = function(fobj) {
		if (!this.validateRequired)
			return true; // Ignore validation
		fobj = fobj || this._form;
		var infix = "";
		elm = this.getElements("x" + infix + "_Tgl_Lahir");
		if (elm && !ew.checkEuroDate(elm.value))
			return this.onError(elm, "<?php echo JsEncode($ekpt_mhsfeed_search->Tgl_Lahir->errorMessage()) ?>");
		elm = this.getElements("x" + infix + "_tglmasuk");
		if (elm && !ew.checkEuroDate(elm.value))
			return this.onError(elm, "<?php echo JsEncode($ekpt_mhsfeed_search->tglmasuk->errorMessage()) ?>");
		elm = this.getElements("x" + infix + "_Tgl_Lulus");
		if (elm && !ew.checkEuroDate(elm.value))
			return this.onError(elm, "<?php echo JsEncode($ekpt_mhsfeed_search->Tgl_Lulus->errorMessage()) ?>");

		// Call Form_CustomValidate event
		if (!this.Form_CustomValidate(fobj))
			return false;
		return true;
	}

	// Form_CustomValidate
	fekpt_mhsfeedsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

		// Your custom validation code here, return false if invalid.
		return true;
	}

	// Use JavaScript validation or not
	fekpt_mhsfeedsearch.validateRequired = <?php echo Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

	// Dynamic selection lists
	fekpt_mhsfeedsearch.lists["x_Kode_Fak"] = <?php echo $ekpt_mhsfeed_search->Kode_Fak->Lookup->toClientList($ekpt_mhsfeed_search) ?>;
	fekpt_mhsfeedsearch.lists["x_Kode_Fak"].options = <?php echo JsonEncode($ekpt_mhsfeed_search->Kode_Fak->lookupOptions()) ?>;
	fekpt_mhsfeedsearch.lists["x_Kode_Jp"] = <?php echo $ekpt_mhsfeed_search->Kode_Jp->Lookup->toClientList($ekpt_mhsfeed_search) ?>;
	fekpt_mhsfeedsearch.lists["x_Kode_Jp"].options = <?php echo JsonEncode($ekpt_mhsfeed_search->Kode_Jp->lookupOptions()) ?>;
	fekpt_mhsfeedsearch.lists["x_Status_Akd"] = <?php echo $ekpt_mhsfeed_search->Status_Akd->Lookup->toClientList($ekpt_mhsfeed_search) ?>;
	fekpt_mhsfeedsearch.lists["x_Status_Akd"].options = <?php echo JsonEncode($ekpt_mhsfeed_search->Status_Akd->lookupOptions()) ?>;
	fekpt_mhsfeedsearch.lists["x_StatusSIAP"] = <?php echo $ekpt_mhsfeed_search->StatusSIAP->Lookup->toClientList($ekpt_mhsfeed_search) ?>;
	fekpt_mhsfeedsearch.lists["x_StatusSIAP"].options = <?php echo JsonEncode($ekpt_mhsfeed_search->StatusSIAP->options(FALSE, TRUE)) ?>;
	fekpt_mhsfeedsearch.lists["x_TaMasuk"] = <?php echo $ekpt_mhsfeed_search->TaMasuk->Lookup->toClientList($ekpt_mhsfeed_search) ?>;
	fekpt_mhsfeedsearch.lists["x_TaMasuk"].options = <?php echo JsonEncode($ekpt_mhsfeed_search->TaMasuk->lookupOptions()) ?>;
	fekpt_mhsfeedsearch.lists["x_PMasuk"] = <?php echo $ekpt_mhsfeed_search->PMasuk->Lookup->toClientList($ekpt_mhsfeed_search) ?>;
	fekpt_mhsfeedsearch.lists["x_PMasuk"].options = <?php echo JsonEncode($ekpt_mhsfeed_search->PMasuk->options(FALSE, TRUE)) ?>;
	loadjs.done("fekpt_mhsfeedsearch");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php $ekpt_mhsfeed_search->showPageHeader(); ?>
<?php
$ekpt_mhsfeed_search->showMessage();
?>
<form name="fekpt_mhsfeedsearch" id="fekpt_mhsfeedsearch" class="<?php echo $ekpt_mhsfeed_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="ekpt_mhsfeed">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$ekpt_mhsfeed_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($ekpt_mhsfeed_search->Kode_Fak->Visible) { // Kode_Fak ?>
	<div id="r_Kode_Fak" class="form-group row">
		<label for="x_Kode_Fak" class="<?php echo $ekpt_mhsfeed_search->LeftColumnClass ?>"><span id="elh_ekpt_mhsfeed_Kode_Fak"><?php echo $ekpt_mhsfeed_search->Kode_Fak->caption() ?></span>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Kode_Fak" id="z_Kode_Fak" value="LIKE">
</span>
		</label>
		<div class="<?php echo $ekpt_mhsfeed_search->RightColumnClass ?>"><div <?php echo $ekpt_mhsfeed_search->Kode_Fak->cellAttributes() ?>>
			<span id="el_ekpt_mhsfeed_Kode_Fak" class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ekpt_mhsfeed" data-field="x_Kode_Fak" data-value-separator="<?php echo $ekpt_mhsfeed_search->Kode_Fak->displayValueSeparatorAttribute() ?>" id="x_Kode_Fak" name="x_Kode_Fak"<?php echo $ekpt_mhsfeed_search->Kode_Fak->editAttributes() ?>>
			<?php echo $ekpt_mhsfeed_search->Kode_Fak->selectOptionListHtml("x_Kode_Fak") ?>
		</select>
</div>
<?php echo $ekpt_mhsfeed_search->Kode_Fak->Lookup->getParamTag($ekpt_mhsfeed_search, "p_x_Kode_Fak") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ekpt_mhsfeed_search->Kode_Jp->Visible) { // Kode_Jp ?>
	<div id="r_Kode_Jp" class="form-group row">
		<label for="x_Kode_Jp" class="<?php echo $ekpt_mhsfeed_search->LeftColumnClass ?>"><span id="elh_ekpt_mhsfeed_Kode_Jp"><?php echo $ekpt_mhsfeed_search->Kode_Jp->caption() ?></span>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Kode_Jp" id="z_Kode_Jp" value="LIKE">
</span>
		</label>
		<div class="<?php echo $ekpt_mhsfeed_search->RightColumnClass ?>"><div <?php echo $ekpt_mhsfeed_search->Kode_Jp->cellAttributes() ?>>
			<span id="el_ekpt_mhsfeed_Kode_Jp" class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ekpt_mhsfeed" data-field="x_Kode_Jp" data-value-separator="<?php echo $ekpt_mhsfeed_search->Kode_Jp->displayValueSeparatorAttribute() ?>" id="x_Kode_Jp" name="x_Kode_Jp"<?php echo $ekpt_mhsfeed_search->Kode_Jp->editAttributes() ?>>
			<?php echo $ekpt_mhsfeed_search->Kode_Jp->selectOptionListHtml("x_Kode_Jp") ?>
		</select>
</div>
<?php echo $ekpt_mhsfeed_search->Kode_Jp->Lookup->getParamTag($ekpt_mhsfeed_search, "p_x_Kode_Jp") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ekpt_mhsfeed_search->NimIM->Visible) { // NimIM ?>
	<div id="r_NimIM" class="form-group row">
		<label for="x_NimIM" class="<?php echo $ekpt_mhsfeed_search->LeftColumnClass ?>"><span id="elh_ekpt_mhsfeed_NimIM"><?php echo $ekpt_mhsfeed_search->NimIM->caption() ?></span>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_NimIM" id="z_NimIM" value="LIKE">
</span>
		</label>
		<div class="<?php echo $ekpt_mhsfeed_search->RightColumnClass ?>"><div <?php echo $ekpt_mhsfeed_search->NimIM->cellAttributes() ?>>
			<span id="el_ekpt_mhsfeed_NimIM" class="ew-search-field">
<input type="text" data-table="ekpt_mhsfeed" data-field="x_NimIM" name="x_NimIM" id="x_NimIM" size="30" maxlength="14" placeholder="<?php echo HtmlEncode($ekpt_mhsfeed_search->NimIM->getPlaceHolder()) ?>" value="<?php echo $ekpt_mhsfeed_search->NimIM->EditValue ?>"<?php echo $ekpt_mhsfeed_search->NimIM->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ekpt_mhsfeed_search->Nim->Visible) { // Nim ?>
	<div id="r_Nim" class="form-group row">
		<label for="x_Nim" class="<?php echo $ekpt_mhsfeed_search->LeftColumnClass ?>"><span id="elh_ekpt_mhsfeed_Nim"><?php echo $ekpt_mhsfeed_search->Nim->caption() ?></span>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Nim" id="z_Nim" value="LIKE">
</span>
		</label>
		<div class="<?php echo $ekpt_mhsfeed_search->RightColumnClass ?>"><div <?php echo $ekpt_mhsfeed_search->Nim->cellAttributes() ?>>
			<span id="el_ekpt_mhsfeed_Nim" class="ew-search-field">
<input type="text" data-table="ekpt_mhsfeed" data-field="x_Nim" name="x_Nim" id="x_Nim" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($ekpt_mhsfeed_search->Nim->getPlaceHolder()) ?>" value="<?php echo $ekpt_mhsfeed_search->Nim->EditValue ?>"<?php echo $ekpt_mhsfeed_search->Nim->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ekpt_mhsfeed_search->NamaMhs->Visible) { // NamaMhs ?>
	<div id="r_NamaMhs" class="form-group row">
		<label for="x_NamaMhs" class="<?php echo $ekpt_mhsfeed_search->LeftColumnClass ?>"><span id="elh_ekpt_mhsfeed_NamaMhs"><?php echo $ekpt_mhsfeed_search->NamaMhs->caption() ?></span>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_NamaMhs" id="z_NamaMhs" value="LIKE">
</span>
		</label>
		<div class="<?php echo $ekpt_mhsfeed_search->RightColumnClass ?>"><div <?php echo $ekpt_mhsfeed_search->NamaMhs->cellAttributes() ?>>
			<span id="el_ekpt_mhsfeed_NamaMhs" class="ew-search-field">
<input type="text" data-table="ekpt_mhsfeed" data-field="x_NamaMhs" name="x_NamaMhs" id="x_NamaMhs" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($ekpt_mhsfeed_search->NamaMhs->getPlaceHolder()) ?>" value="<?php echo $ekpt_mhsfeed_search->NamaMhs->EditValue ?>"<?php echo $ekpt_mhsfeed_search->NamaMhs->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ekpt_mhsfeed_search->Status_Akd->Visible) { // Status_Akd ?>
	<div id="r_Status_Akd" class="form-group row">
		<label for="x_Status_Akd" class="<?php echo $ekpt_mhsfeed_search->LeftColumnClass ?>"><span id="elh_ekpt_mhsfeed_Status_Akd"><?php echo $ekpt_mhsfeed_search->Status_Akd->caption() ?></span>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Status_Akd" id="z_Status_Akd" value="LIKE">
</span>
		</label>
		<div class="<?php echo $ekpt_mhsfeed_search->RightColumnClass ?>"><div <?php echo $ekpt_mhsfeed_search->Status_Akd->cellAttributes() ?>>
			<span id="el_ekpt_mhsfeed_Status_Akd" class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ekpt_mhsfeed" data-field="x_Status_Akd" data-value-separator="<?php echo $ekpt_mhsfeed_search->Status_Akd->displayValueSeparatorAttribute() ?>" id="x_Status_Akd" name="x_Status_Akd"<?php echo $ekpt_mhsfeed_search->Status_Akd->editAttributes() ?>>
			<?php echo $ekpt_mhsfeed_search->Status_Akd->selectOptionListHtml("x_Status_Akd") ?>
		</select>
</div>
<?php echo $ekpt_mhsfeed_search->Status_Akd->Lookup->getParamTag($ekpt_mhsfeed_search, "p_x_Status_Akd") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ekpt_mhsfeed_search->TglLahir->Visible) { // TglLahir ?>
	<div id="r_TglLahir" class="form-group row">
		<label for="x_TglLahir" class="<?php echo $ekpt_mhsfeed_search->LeftColumnClass ?>"><span id="elh_ekpt_mhsfeed_TglLahir"><?php echo $ekpt_mhsfeed_search->TglLahir->caption() ?></span>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_TglLahir" id="z_TglLahir" value="LIKE">
</span>
		</label>
		<div class="<?php echo $ekpt_mhsfeed_search->RightColumnClass ?>"><div <?php echo $ekpt_mhsfeed_search->TglLahir->cellAttributes() ?>>
			<span id="el_ekpt_mhsfeed_TglLahir" class="ew-search-field">
<input type="text" data-table="ekpt_mhsfeed" data-field="x_TglLahir" name="x_TglLahir" id="x_TglLahir" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($ekpt_mhsfeed_search->TglLahir->getPlaceHolder()) ?>" value="<?php echo $ekpt_mhsfeed_search->TglLahir->EditValue ?>"<?php echo $ekpt_mhsfeed_search->TglLahir->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ekpt_mhsfeed_search->TSKS->Visible) { // TSKS ?>
	<div id="r_TSKS" class="form-group row">
		<label for="x_TSKS" class="<?php echo $ekpt_mhsfeed_search->LeftColumnClass ?>"><span id="elh_ekpt_mhsfeed_TSKS"><?php echo $ekpt_mhsfeed_search->TSKS->caption() ?></span>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_TSKS" id="z_TSKS" value="LIKE">
</span>
		</label>
		<div class="<?php echo $ekpt_mhsfeed_search->RightColumnClass ?>"><div <?php echo $ekpt_mhsfeed_search->TSKS->cellAttributes() ?>>
			<span id="el_ekpt_mhsfeed_TSKS" class="ew-search-field">
<input type="text" data-table="ekpt_mhsfeed" data-field="x_TSKS" name="x_TSKS" id="x_TSKS" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($ekpt_mhsfeed_search->TSKS->getPlaceHolder()) ?>" value="<?php echo $ekpt_mhsfeed_search->TSKS->EditValue ?>"<?php echo $ekpt_mhsfeed_search->TSKS->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ekpt_mhsfeed_search->Prodi->Visible) { // Prodi ?>
	<div id="r_Prodi" class="form-group row">
		<label for="x_Prodi" class="<?php echo $ekpt_mhsfeed_search->LeftColumnClass ?>"><span id="elh_ekpt_mhsfeed_Prodi"><?php echo $ekpt_mhsfeed_search->Prodi->caption() ?></span>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Prodi" id="z_Prodi" value="LIKE">
</span>
		</label>
		<div class="<?php echo $ekpt_mhsfeed_search->RightColumnClass ?>"><div <?php echo $ekpt_mhsfeed_search->Prodi->cellAttributes() ?>>
			<span id="el_ekpt_mhsfeed_Prodi" class="ew-search-field">
<input type="text" data-table="ekpt_mhsfeed" data-field="x_Prodi" name="x_Prodi" id="x_Prodi" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($ekpt_mhsfeed_search->Prodi->getPlaceHolder()) ?>" value="<?php echo $ekpt_mhsfeed_search->Prodi->EditValue ?>"<?php echo $ekpt_mhsfeed_search->Prodi->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ekpt_mhsfeed_search->PerMasuk->Visible) { // PerMasuk ?>
	<div id="r_PerMasuk" class="form-group row">
		<label for="x_PerMasuk" class="<?php echo $ekpt_mhsfeed_search->LeftColumnClass ?>"><span id="elh_ekpt_mhsfeed_PerMasuk"><?php echo $ekpt_mhsfeed_search->PerMasuk->caption() ?></span>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_PerMasuk" id="z_PerMasuk" value="LIKE">
</span>
		</label>
		<div class="<?php echo $ekpt_mhsfeed_search->RightColumnClass ?>"><div <?php echo $ekpt_mhsfeed_search->PerMasuk->cellAttributes() ?>>
			<span id="el_ekpt_mhsfeed_PerMasuk" class="ew-search-field">
<input type="text" data-table="ekpt_mhsfeed" data-field="x_PerMasuk" name="x_PerMasuk" id="x_PerMasuk" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($ekpt_mhsfeed_search->PerMasuk->getPlaceHolder()) ?>" value="<?php echo $ekpt_mhsfeed_search->PerMasuk->EditValue ?>"<?php echo $ekpt_mhsfeed_search->PerMasuk->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ekpt_mhsfeed_search->Status->Visible) { // Status ?>
	<div id="r_Status" class="form-group row">
		<label for="x_Status" class="<?php echo $ekpt_mhsfeed_search->LeftColumnClass ?>"><span id="elh_ekpt_mhsfeed_Status"><?php echo $ekpt_mhsfeed_search->Status->caption() ?></span>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Status" id="z_Status" value="LIKE">
</span>
		</label>
		<div class="<?php echo $ekpt_mhsfeed_search->RightColumnClass ?>"><div <?php echo $ekpt_mhsfeed_search->Status->cellAttributes() ?>>
			<span id="el_ekpt_mhsfeed_Status" class="ew-search-field">
<input type="text" data-table="ekpt_mhsfeed" data-field="x_Status" name="x_Status" id="x_Status" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($ekpt_mhsfeed_search->Status->getPlaceHolder()) ?>" value="<?php echo $ekpt_mhsfeed_search->Status->EditValue ?>"<?php echo $ekpt_mhsfeed_search->Status->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ekpt_mhsfeed_search->PerKeluar->Visible) { // PerKeluar ?>
	<div id="r_PerKeluar" class="form-group row">
		<label for="x_PerKeluar" class="<?php echo $ekpt_mhsfeed_search->LeftColumnClass ?>"><span id="elh_ekpt_mhsfeed_PerKeluar"><?php echo $ekpt_mhsfeed_search->PerKeluar->caption() ?></span>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_PerKeluar" id="z_PerKeluar" value="LIKE">
</span>
		</label>
		<div class="<?php echo $ekpt_mhsfeed_search->RightColumnClass ?>"><div <?php echo $ekpt_mhsfeed_search->PerKeluar->cellAttributes() ?>>
			<span id="el_ekpt_mhsfeed_PerKeluar" class="ew-search-field">
<input type="text" data-table="ekpt_mhsfeed" data-field="x_PerKeluar" name="x_PerKeluar" id="x_PerKeluar" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($ekpt_mhsfeed_search->PerKeluar->getPlaceHolder()) ?>" value="<?php echo $ekpt_mhsfeed_search->PerKeluar->EditValue ?>"<?php echo $ekpt_mhsfeed_search->PerKeluar->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ekpt_mhsfeed_search->TglKeluar->Visible) { // TglKeluar ?>
	<div id="r_TglKeluar" class="form-group row">
		<label for="x_TglKeluar" class="<?php echo $ekpt_mhsfeed_search->LeftColumnClass ?>"><span id="elh_ekpt_mhsfeed_TglKeluar"><?php echo $ekpt_mhsfeed_search->TglKeluar->caption() ?></span>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_TglKeluar" id="z_TglKeluar" value="LIKE">
</span>
		</label>
		<div class="<?php echo $ekpt_mhsfeed_search->RightColumnClass ?>"><div <?php echo $ekpt_mhsfeed_search->TglKeluar->cellAttributes() ?>>
			<span id="el_ekpt_mhsfeed_TglKeluar" class="ew-search-field">
<input type="text" data-table="ekpt_mhsfeed" data-field="x_TglKeluar" name="x_TglKeluar" id="x_TglKeluar" size="30" maxlength="50" placeholder="<?php echo HtmlEncode($ekpt_mhsfeed_search->TglKeluar->getPlaceHolder()) ?>" value="<?php echo $ekpt_mhsfeed_search->TglKeluar->EditValue ?>"<?php echo $ekpt_mhsfeed_search->TglKeluar->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ekpt_mhsfeed_search->Nama_Mhs->Visible) { // Nama_Mhs ?>
	<div id="r_Nama_Mhs" class="form-group row">
		<label for="x_Nama_Mhs" class="<?php echo $ekpt_mhsfeed_search->LeftColumnClass ?>"><span id="elh_ekpt_mhsfeed_Nama_Mhs"><?php echo $ekpt_mhsfeed_search->Nama_Mhs->caption() ?></span>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Nama_Mhs" id="z_Nama_Mhs" value="LIKE">
</span>
		</label>
		<div class="<?php echo $ekpt_mhsfeed_search->RightColumnClass ?>"><div <?php echo $ekpt_mhsfeed_search->Nama_Mhs->cellAttributes() ?>>
			<span id="el_ekpt_mhsfeed_Nama_Mhs" class="ew-search-field">
<input type="text" data-table="ekpt_mhsfeed" data-field="x_Nama_Mhs" name="x_Nama_Mhs" id="x_Nama_Mhs" size="30" maxlength="60" placeholder="<?php echo HtmlEncode($ekpt_mhsfeed_search->Nama_Mhs->getPlaceHolder()) ?>" value="<?php echo $ekpt_mhsfeed_search->Nama_Mhs->EditValue ?>"<?php echo $ekpt_mhsfeed_search->Nama_Mhs->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ekpt_mhsfeed_search->Tmp_Lahir->Visible) { // Tmp_Lahir ?>
	<div id="r_Tmp_Lahir" class="form-group row">
		<label for="x_Tmp_Lahir" class="<?php echo $ekpt_mhsfeed_search->LeftColumnClass ?>"><span id="elh_ekpt_mhsfeed_Tmp_Lahir"><?php echo $ekpt_mhsfeed_search->Tmp_Lahir->caption() ?></span>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Tmp_Lahir" id="z_Tmp_Lahir" value="LIKE">
</span>
		</label>
		<div class="<?php echo $ekpt_mhsfeed_search->RightColumnClass ?>"><div <?php echo $ekpt_mhsfeed_search->Tmp_Lahir->cellAttributes() ?>>
			<span id="el_ekpt_mhsfeed_Tmp_Lahir" class="ew-search-field">
<input type="text" data-table="ekpt_mhsfeed" data-field="x_Tmp_Lahir" name="x_Tmp_Lahir" id="x_Tmp_Lahir" size="30" maxlength="40" placeholder="<?php echo HtmlEncode($ekpt_mhsfeed_search->Tmp_Lahir->getPlaceHolder()) ?>" value="<?php echo $ekpt_mhsfeed_search->Tmp_Lahir->EditValue ?>"<?php echo $ekpt_mhsfeed_search->Tmp_Lahir->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ekpt_mhsfeed_search->Tgl_Lahir->Visible) { // Tgl_Lahir ?>
	<div id="r_Tgl_Lahir" class="form-group row">
		<label for="x_Tgl_Lahir" class="<?php echo $ekpt_mhsfeed_search->LeftColumnClass ?>"><span id="elh_ekpt_mhsfeed_Tgl_Lahir"><?php echo $ekpt_mhsfeed_search->Tgl_Lahir->caption() ?></span>
		<span class="ew-search-operator">
<?php echo $Language->phrase("=") ?>
<input type="hidden" name="z_Tgl_Lahir" id="z_Tgl_Lahir" value="=">
</span>
		</label>
		<div class="<?php echo $ekpt_mhsfeed_search->RightColumnClass ?>"><div <?php echo $ekpt_mhsfeed_search->Tgl_Lahir->cellAttributes() ?>>
			<span id="el_ekpt_mhsfeed_Tgl_Lahir" class="ew-search-field">
<input type="text" data-table="ekpt_mhsfeed" data-field="x_Tgl_Lahir" data-format="7" name="x_Tgl_Lahir" id="x_Tgl_Lahir" maxlength="8" placeholder="<?php echo HtmlEncode($ekpt_mhsfeed_search->Tgl_Lahir->getPlaceHolder()) ?>" value="<?php echo $ekpt_mhsfeed_search->Tgl_Lahir->EditValue ?>"<?php echo $ekpt_mhsfeed_search->Tgl_Lahir->editAttributes() ?>>
<?php if (!$ekpt_mhsfeed_search->Tgl_Lahir->ReadOnly && !$ekpt_mhsfeed_search->Tgl_Lahir->Disabled && !isset($ekpt_mhsfeed_search->Tgl_Lahir->EditAttrs["readonly"]) && !isset($ekpt_mhsfeed_search->Tgl_Lahir->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fekpt_mhsfeedsearch", "datetimepicker"], function() {
	ew.createDateTimePicker("fekpt_mhsfeedsearch", "x_Tgl_Lahir", {"ignoreReadonly":true,"useCurrent":false,"format":7});
});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ekpt_mhsfeed_search->StatusSIAP->Visible) { // StatusSIAP ?>
	<div id="r_StatusSIAP" class="form-group row">
		<label for="x_StatusSIAP" class="<?php echo $ekpt_mhsfeed_search->LeftColumnClass ?>"><span id="elh_ekpt_mhsfeed_StatusSIAP"><?php echo $ekpt_mhsfeed_search->StatusSIAP->caption() ?></span>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_StatusSIAP" id="z_StatusSIAP" value="LIKE">
</span>
		</label>
		<div class="<?php echo $ekpt_mhsfeed_search->RightColumnClass ?>"><div <?php echo $ekpt_mhsfeed_search->StatusSIAP->cellAttributes() ?>>
			<span id="el_ekpt_mhsfeed_StatusSIAP" class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ekpt_mhsfeed" data-field="x_StatusSIAP" data-value-separator="<?php echo $ekpt_mhsfeed_search->StatusSIAP->displayValueSeparatorAttribute() ?>" id="x_StatusSIAP" name="x_StatusSIAP"<?php echo $ekpt_mhsfeed_search->StatusSIAP->editAttributes() ?>>
			<?php echo $ekpt_mhsfeed_search->StatusSIAP->selectOptionListHtml("x_StatusSIAP") ?>
		</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ekpt_mhsfeed_search->PerMasukIM->Visible) { // PerMasukIM ?>
	<div id="r_PerMasukIM" class="form-group row">
		<label for="x_PerMasukIM" class="<?php echo $ekpt_mhsfeed_search->LeftColumnClass ?>"><span id="elh_ekpt_mhsfeed_PerMasukIM"><?php echo $ekpt_mhsfeed_search->PerMasukIM->caption() ?></span>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_PerMasukIM" id="z_PerMasukIM" value="LIKE">
</span>
		</label>
		<div class="<?php echo $ekpt_mhsfeed_search->RightColumnClass ?>"><div <?php echo $ekpt_mhsfeed_search->PerMasukIM->cellAttributes() ?>>
			<span id="el_ekpt_mhsfeed_PerMasukIM" class="ew-search-field">
<input type="text" data-table="ekpt_mhsfeed" data-field="x_PerMasukIM" name="x_PerMasukIM" id="x_PerMasukIM" size="30" maxlength="6" placeholder="<?php echo HtmlEncode($ekpt_mhsfeed_search->PerMasukIM->getPlaceHolder()) ?>" value="<?php echo $ekpt_mhsfeed_search->PerMasukIM->EditValue ?>"<?php echo $ekpt_mhsfeed_search->PerMasukIM->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ekpt_mhsfeed_search->TaMasuk->Visible) { // TaMasuk ?>
	<div id="r_TaMasuk" class="form-group row">
		<label for="x_TaMasuk" class="<?php echo $ekpt_mhsfeed_search->LeftColumnClass ?>"><span id="elh_ekpt_mhsfeed_TaMasuk"><?php echo $ekpt_mhsfeed_search->TaMasuk->caption() ?></span>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_TaMasuk" id="z_TaMasuk" value="LIKE">
</span>
		</label>
		<div class="<?php echo $ekpt_mhsfeed_search->RightColumnClass ?>"><div <?php echo $ekpt_mhsfeed_search->TaMasuk->cellAttributes() ?>>
			<span id="el_ekpt_mhsfeed_TaMasuk" class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ekpt_mhsfeed" data-field="x_TaMasuk" data-value-separator="<?php echo $ekpt_mhsfeed_search->TaMasuk->displayValueSeparatorAttribute() ?>" id="x_TaMasuk" name="x_TaMasuk"<?php echo $ekpt_mhsfeed_search->TaMasuk->editAttributes() ?>>
			<?php echo $ekpt_mhsfeed_search->TaMasuk->selectOptionListHtml("x_TaMasuk") ?>
		</select>
</div>
<?php echo $ekpt_mhsfeed_search->TaMasuk->Lookup->getParamTag($ekpt_mhsfeed_search, "p_x_TaMasuk") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ekpt_mhsfeed_search->PMasuk->Visible) { // PMasuk ?>
	<div id="r_PMasuk" class="form-group row">
		<label for="x_PMasuk" class="<?php echo $ekpt_mhsfeed_search->LeftColumnClass ?>"><span id="elh_ekpt_mhsfeed_PMasuk"><?php echo $ekpt_mhsfeed_search->PMasuk->caption() ?></span>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_PMasuk" id="z_PMasuk" value="LIKE">
</span>
		</label>
		<div class="<?php echo $ekpt_mhsfeed_search->RightColumnClass ?>"><div <?php echo $ekpt_mhsfeed_search->PMasuk->cellAttributes() ?>>
			<span id="el_ekpt_mhsfeed_PMasuk" class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ekpt_mhsfeed" data-field="x_PMasuk" data-value-separator="<?php echo $ekpt_mhsfeed_search->PMasuk->displayValueSeparatorAttribute() ?>" id="x_PMasuk" name="x_PMasuk"<?php echo $ekpt_mhsfeed_search->PMasuk->editAttributes() ?>>
			<?php echo $ekpt_mhsfeed_search->PMasuk->selectOptionListHtml("x_PMasuk") ?>
		</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ekpt_mhsfeed_search->tglmasuk->Visible) { // tglmasuk ?>
	<div id="r_tglmasuk" class="form-group row">
		<label for="x_tglmasuk" class="<?php echo $ekpt_mhsfeed_search->LeftColumnClass ?>"><span id="elh_ekpt_mhsfeed_tglmasuk"><?php echo $ekpt_mhsfeed_search->tglmasuk->caption() ?></span>
		<span class="ew-search-operator">
<?php echo $Language->phrase("=") ?>
<input type="hidden" name="z_tglmasuk" id="z_tglmasuk" value="=">
</span>
		</label>
		<div class="<?php echo $ekpt_mhsfeed_search->RightColumnClass ?>"><div <?php echo $ekpt_mhsfeed_search->tglmasuk->cellAttributes() ?>>
			<span id="el_ekpt_mhsfeed_tglmasuk" class="ew-search-field">
<input type="text" data-table="ekpt_mhsfeed" data-field="x_tglmasuk" data-format="7" name="x_tglmasuk" id="x_tglmasuk" maxlength="8" placeholder="<?php echo HtmlEncode($ekpt_mhsfeed_search->tglmasuk->getPlaceHolder()) ?>" value="<?php echo $ekpt_mhsfeed_search->tglmasuk->EditValue ?>"<?php echo $ekpt_mhsfeed_search->tglmasuk->editAttributes() ?>>
<?php if (!$ekpt_mhsfeed_search->tglmasuk->ReadOnly && !$ekpt_mhsfeed_search->tglmasuk->Disabled && !isset($ekpt_mhsfeed_search->tglmasuk->EditAttrs["readonly"]) && !isset($ekpt_mhsfeed_search->tglmasuk->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fekpt_mhsfeedsearch", "datetimepicker"], function() {
	ew.createDateTimePicker("fekpt_mhsfeedsearch", "x_tglmasuk", {"ignoreReadonly":true,"useCurrent":false,"format":7});
});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ekpt_mhsfeed_search->Status_Masuk->Visible) { // Status_Masuk ?>
	<div id="r_Status_Masuk" class="form-group row">
		<label for="x_Status_Masuk" class="<?php echo $ekpt_mhsfeed_search->LeftColumnClass ?>"><span id="elh_ekpt_mhsfeed_Status_Masuk"><?php echo $ekpt_mhsfeed_search->Status_Masuk->caption() ?></span>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Status_Masuk" id="z_Status_Masuk" value="LIKE">
</span>
		</label>
		<div class="<?php echo $ekpt_mhsfeed_search->RightColumnClass ?>"><div <?php echo $ekpt_mhsfeed_search->Status_Masuk->cellAttributes() ?>>
			<span id="el_ekpt_mhsfeed_Status_Masuk" class="ew-search-field">
<input type="text" data-table="ekpt_mhsfeed" data-field="x_Status_Masuk" name="x_Status_Masuk" id="x_Status_Masuk" size="30" maxlength="10" placeholder="<?php echo HtmlEncode($ekpt_mhsfeed_search->Status_Masuk->getPlaceHolder()) ?>" value="<?php echo $ekpt_mhsfeed_search->Status_Masuk->EditValue ?>"<?php echo $ekpt_mhsfeed_search->Status_Masuk->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ekpt_mhsfeed_search->JalurMasuk->Visible) { // JalurMasuk ?>
	<div id="r_JalurMasuk" class="form-group row">
		<label for="x_JalurMasuk" class="<?php echo $ekpt_mhsfeed_search->LeftColumnClass ?>"><span id="elh_ekpt_mhsfeed_JalurMasuk"><?php echo $ekpt_mhsfeed_search->JalurMasuk->caption() ?></span>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_JalurMasuk" id="z_JalurMasuk" value="LIKE">
</span>
		</label>
		<div class="<?php echo $ekpt_mhsfeed_search->RightColumnClass ?>"><div <?php echo $ekpt_mhsfeed_search->JalurMasuk->cellAttributes() ?>>
			<span id="el_ekpt_mhsfeed_JalurMasuk" class="ew-search-field">
<input type="text" data-table="ekpt_mhsfeed" data-field="x_JalurMasuk" name="x_JalurMasuk" id="x_JalurMasuk" size="30" maxlength="20" placeholder="<?php echo HtmlEncode($ekpt_mhsfeed_search->JalurMasuk->getPlaceHolder()) ?>" value="<?php echo $ekpt_mhsfeed_search->JalurMasuk->EditValue ?>"<?php echo $ekpt_mhsfeed_search->JalurMasuk->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ekpt_mhsfeed_search->PerLulusIM->Visible) { // PerLulusIM ?>
	<div id="r_PerLulusIM" class="form-group row">
		<label for="x_PerLulusIM" class="<?php echo $ekpt_mhsfeed_search->LeftColumnClass ?>"><span id="elh_ekpt_mhsfeed_PerLulusIM"><?php echo $ekpt_mhsfeed_search->PerLulusIM->caption() ?></span>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_PerLulusIM" id="z_PerLulusIM" value="LIKE">
</span>
		</label>
		<div class="<?php echo $ekpt_mhsfeed_search->RightColumnClass ?>"><div <?php echo $ekpt_mhsfeed_search->PerLulusIM->cellAttributes() ?>>
			<span id="el_ekpt_mhsfeed_PerLulusIM" class="ew-search-field">
<input type="text" data-table="ekpt_mhsfeed" data-field="x_PerLulusIM" name="x_PerLulusIM" id="x_PerLulusIM" size="30" maxlength="6" placeholder="<?php echo HtmlEncode($ekpt_mhsfeed_search->PerLulusIM->getPlaceHolder()) ?>" value="<?php echo $ekpt_mhsfeed_search->PerLulusIM->EditValue ?>"<?php echo $ekpt_mhsfeed_search->PerLulusIM->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ekpt_mhsfeed_search->Tgl_Lulus->Visible) { // Tgl_Lulus ?>
	<div id="r_Tgl_Lulus" class="form-group row">
		<label for="x_Tgl_Lulus" class="<?php echo $ekpt_mhsfeed_search->LeftColumnClass ?>"><span id="elh_ekpt_mhsfeed_Tgl_Lulus"><?php echo $ekpt_mhsfeed_search->Tgl_Lulus->caption() ?></span>
		<span class="ew-search-operator">
<?php echo $Language->phrase("=") ?>
<input type="hidden" name="z_Tgl_Lulus" id="z_Tgl_Lulus" value="=">
</span>
		</label>
		<div class="<?php echo $ekpt_mhsfeed_search->RightColumnClass ?>"><div <?php echo $ekpt_mhsfeed_search->Tgl_Lulus->cellAttributes() ?>>
			<span id="el_ekpt_mhsfeed_Tgl_Lulus" class="ew-search-field">
<input type="text" data-table="ekpt_mhsfeed" data-field="x_Tgl_Lulus" data-format="7" name="x_Tgl_Lulus" id="x_Tgl_Lulus" maxlength="8" placeholder="<?php echo HtmlEncode($ekpt_mhsfeed_search->Tgl_Lulus->getPlaceHolder()) ?>" value="<?php echo $ekpt_mhsfeed_search->Tgl_Lulus->EditValue ?>"<?php echo $ekpt_mhsfeed_search->Tgl_Lulus->editAttributes() ?>>
<?php if (!$ekpt_mhsfeed_search->Tgl_Lulus->ReadOnly && !$ekpt_mhsfeed_search->Tgl_Lulus->Disabled && !isset($ekpt_mhsfeed_search->Tgl_Lulus->EditAttrs["readonly"]) && !isset($ekpt_mhsfeed_search->Tgl_Lulus->EditAttrs["disabled"])) { ?>
<script>
loadjs.ready(["fekpt_mhsfeedsearch", "datetimepicker"], function() {
	ew.createDateTimePicker("fekpt_mhsfeedsearch", "x_Tgl_Lulus", {"ignoreReadonly":true,"useCurrent":false,"format":7});
});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ekpt_mhsfeed_search->No_Ijazah->Visible) { // No_Ijazah ?>
	<div id="r_No_Ijazah" class="form-group row">
		<label for="x_No_Ijazah" class="<?php echo $ekpt_mhsfeed_search->LeftColumnClass ?>"><span id="elh_ekpt_mhsfeed_No_Ijazah"><?php echo $ekpt_mhsfeed_search->No_Ijazah->caption() ?></span>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_No_Ijazah" id="z_No_Ijazah" value="LIKE">
</span>
		</label>
		<div class="<?php echo $ekpt_mhsfeed_search->RightColumnClass ?>"><div <?php echo $ekpt_mhsfeed_search->No_Ijazah->cellAttributes() ?>>
			<span id="el_ekpt_mhsfeed_No_Ijazah" class="ew-search-field">
<input type="text" data-table="ekpt_mhsfeed" data-field="x_No_Ijazah" name="x_No_Ijazah" id="x_No_Ijazah" size="30" maxlength="100" placeholder="<?php echo HtmlEncode($ekpt_mhsfeed_search->No_Ijazah->getPlaceHolder()) ?>" value="<?php echo $ekpt_mhsfeed_search->No_Ijazah->EditValue ?>"<?php echo $ekpt_mhsfeed_search->No_Ijazah->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ekpt_mhsfeed_search->TA->Visible) { // TA ?>
	<div id="r_TA" class="form-group row">
		<label for="x_TA" class="<?php echo $ekpt_mhsfeed_search->LeftColumnClass ?>"><span id="elh_ekpt_mhsfeed_TA"><?php echo $ekpt_mhsfeed_search->TA->caption() ?></span>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_TA" id="z_TA" value="LIKE">
</span>
		</label>
		<div class="<?php echo $ekpt_mhsfeed_search->RightColumnClass ?>"><div <?php echo $ekpt_mhsfeed_search->TA->cellAttributes() ?>>
			<span id="el_ekpt_mhsfeed_TA" class="ew-search-field">
<input type="text" data-table="ekpt_mhsfeed" data-field="x_TA" name="x_TA" id="x_TA" size="30" maxlength="9" placeholder="<?php echo HtmlEncode($ekpt_mhsfeed_search->TA->getPlaceHolder()) ?>" value="<?php echo $ekpt_mhsfeed_search->TA->EditValue ?>"<?php echo $ekpt_mhsfeed_search->TA->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ekpt_mhsfeed_search->per->Visible) { // per ?>
	<div id="r_per" class="form-group row">
		<label for="x_per" class="<?php echo $ekpt_mhsfeed_search->LeftColumnClass ?>"><span id="elh_ekpt_mhsfeed_per"><?php echo $ekpt_mhsfeed_search->per->caption() ?></span>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_per" id="z_per" value="LIKE">
</span>
		</label>
		<div class="<?php echo $ekpt_mhsfeed_search->RightColumnClass ?>"><div <?php echo $ekpt_mhsfeed_search->per->cellAttributes() ?>>
			<span id="el_ekpt_mhsfeed_per" class="ew-search-field">
<input type="text" data-table="ekpt_mhsfeed" data-field="x_per" name="x_per" id="x_per" size="30" maxlength="2" placeholder="<?php echo HtmlEncode($ekpt_mhsfeed_search->per->getPlaceHolder()) ?>" value="<?php echo $ekpt_mhsfeed_search->per->EditValue ?>"<?php echo $ekpt_mhsfeed_search->per->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ekpt_mhsfeed_search->ProdiIM->Visible) { // ProdiIM ?>
	<div id="r_ProdiIM" class="form-group row">
		<label for="x_ProdiIM" class="<?php echo $ekpt_mhsfeed_search->LeftColumnClass ?>"><span id="elh_ekpt_mhsfeed_ProdiIM"><?php echo $ekpt_mhsfeed_search->ProdiIM->caption() ?></span>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_ProdiIM" id="z_ProdiIM" value="LIKE">
</span>
		</label>
		<div class="<?php echo $ekpt_mhsfeed_search->RightColumnClass ?>"><div <?php echo $ekpt_mhsfeed_search->ProdiIM->cellAttributes() ?>>
			<span id="el_ekpt_mhsfeed_ProdiIM" class="ew-search-field">
<input type="text" data-table="ekpt_mhsfeed" data-field="x_ProdiIM" name="x_ProdiIM" id="x_ProdiIM" size="30" maxlength="32" placeholder="<?php echo HtmlEncode($ekpt_mhsfeed_search->ProdiIM->getPlaceHolder()) ?>" value="<?php echo $ekpt_mhsfeed_search->ProdiIM->EditValue ?>"<?php echo $ekpt_mhsfeed_search->ProdiIM->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ekpt_mhsfeed_search->TaAkhir->Visible) { // TaAkhir ?>
	<div id="r_TaAkhir" class="form-group row">
		<label for="x_TaAkhir" class="<?php echo $ekpt_mhsfeed_search->LeftColumnClass ?>"><span id="elh_ekpt_mhsfeed_TaAkhir"><?php echo $ekpt_mhsfeed_search->TaAkhir->caption() ?></span>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_TaAkhir" id="z_TaAkhir" value="LIKE">
</span>
		</label>
		<div class="<?php echo $ekpt_mhsfeed_search->RightColumnClass ?>"><div <?php echo $ekpt_mhsfeed_search->TaAkhir->cellAttributes() ?>>
			<span id="el_ekpt_mhsfeed_TaAkhir" class="ew-search-field">
<input type="text" data-table="ekpt_mhsfeed" data-field="x_TaAkhir" name="x_TaAkhir" id="x_TaAkhir" size="30" maxlength="6" placeholder="<?php echo HtmlEncode($ekpt_mhsfeed_search->TaAkhir->getPlaceHolder()) ?>" value="<?php echo $ekpt_mhsfeed_search->TaAkhir->EditValue ?>"<?php echo $ekpt_mhsfeed_search->TaAkhir->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$ekpt_mhsfeed_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $ekpt_mhsfeed_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$ekpt_mhsfeed_search->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php include_once "footer.php"; ?>
<?php
$ekpt_mhsfeed_search->terminate();
?>