<?php

include "db.php";
include "init.php";

function updatefeedperwalian($ta, $per, $nim) {
    global $conn;
    try {
        // Prepare the SQL query
        $query = "UPDATE Perwalian SET feed = '1' WHERE Nim = :xnim AND Thn_Akademik = :xta AND Periode = :xper";
        $stmt = $conn->prepare($query);

        // Bind parameters
        $stmt->bindParam(':xnim', $nim, PDO::PARAM_INT);
        $stmt->bindParam(':xta', $ta, PDO::PARAM_STR);
        $stmt->bindParam(':xper', $per, PDO::PARAM_STR);

        // Execute the update query
        $stmt->execute();

        // Check if the update was successful
        $rowCount = $stmt->rowCount();
        if ($rowCount > 0) {
            return "Feed berhasil ditambahkan di perwalian SIAP <br>";
        } else {
            return "Feed gagal ditambahkan di perwalian SIAP <br>";
        }
    } catch (PDOException $e) {
        return "Error updating data: " . $e->getMessage();
    }
}

function insertPerkuliahanMahasiswa($token, $record) {
    $data = array(
        'act' => 'InsertPerkuliahanMahasiswa',
        'token' => $token,
        'record' => $record,
    );

    $result_string = runWS($data);

    if ($result_string['error_code'] === 0) {
        $hasil = "1";
    } else {
        $hasil = "Gagal menambahkan data perkuliahan mahasiswa. Error: " . $result_string['error_desc']." <br>";
    }

    return $hasil;
}

function GetListPerkuliahanMahasiswa($token, $idregmhs, $idsem) {    
    $filter = "id_registrasi_mahasiswa ='$idregmhs' AND id_semester = '$idsem'";
    $order = "";
    $limit = 1;
    $offset = 0;
    $apiToken = $token;
  
    $data = array(
        'act' => 'GetListPerkuliahanMahasiswa',
        'token' => $apiToken,
        'filter' => $filter,
        'order' => $order,
        'limit' => $limit,
        'offset' => $offset
    );
  
    $result_string = runWS($data);
  
    if ($result_string['error_code'] === 0) {
        if (!empty($result_string['data'])) {
            $hasil = "1";            
            }
         else {
            $hasil = "0";  
        }      
    } else {
        $hasil = "Terjasi kesalahan. Error: " . $result_string['error_desc'];
    }
    return $hasil;
  }


// Ambil nilai dari query string
$Thn_Akademik = isset($_GET['Thn_Akademik']) ? $_GET['Thn_Akademik'] : '';
$Periode = isset($_GET['Periode']) ? $_GET['Periode'] : '';
$Kelas_Akd = isset($_GET['Kelas_Akd']) ? $_GET['Kelas_Akd'] : '';
$Kode_Jp = isset($_GET['Kode_Jp']) ? $_GET['Kode_Jp'] : '';

// Validasi input
if (empty($Thn_Akademik) || empty($Periode) || empty($Kelas_Akd) || empty($Kode_Jp)) {
    // Tampilkan pesan error jika ada parameter yang kosong
    echo "Semua parameter dalam form pencarian harus diisi...";
} else {

    // Buat query berdasarkan kriteria
    $query = "SELECT Nim, id_regmhs, Nama_Mhs, Thn_Akademik, Periode, TSKS, ips, TTSKS, IPK, Kode_jp, Status_Akd, BiayaKuliah, id_pembiayaan, IDTahun
              FROM IPSIPK
              WHERE Thn_Akademik = :Thn_Akademik
                    AND Periode = :Periode
                    AND Status_Akd = :Status_Akd
                    AND Kode_jp = :Kode_Jp";
                    

    // Persiapkan statement
    $stmt = $conn->prepare($query);

    // Bind parameter
    $stmt->bindParam(':Thn_Akademik', $Thn_Akademik, PDO::PARAM_STR);
    $stmt->bindParam(':Periode', $Periode, PDO::PARAM_STR);
    $stmt->bindParam(':Status_Akd', $Kelas_Akd, PDO::PARAM_STR);
    $stmt->bindParam(':Kode_Jp', $Kode_Jp, PDO::PARAM_STR);
    

    // Eksekusi query
    $stmt->execute();

    // Ambil hasil query
    $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
    $token = getToken();
    // Tampilkan hasil atau sesuaikan dengan kebutuhan Anda
    foreach ($result as $row) {
        $cekpk = GetListPerkuliahanMahasiswa($token, $row['id_regmhs'], $row['IDTahun']);
        if ($cekpk == "0") {
            $tsks = hitsks($row['id_regmhs'],$row['IDTahun']);
            $record = array(
                'id_registrasi_mahasiswa' => $row['id_regmhs'],
                'id_semester' => $row['IDTahun'],
                'id_status_mahasiswa' => "A",
                'id_pembiayaan' => $row['id_pembiayaan'],
                'biaya_kuliah_smt' => $row['BiayaKuliah'],
                'ips' => $row['ips'],
                'ipk' => $row['IPK'],
                'sks_semester' => $tsks,
                'total_sks' => $row['TTSKS']                
            );
            //print_r($record);      
            //echo "<br>";
            $insertResult = insertPerkuliahanMahasiswa($token, $record);
            if ($insertResult=="1") {
                $updatefeed = updatefeedperwalian($row['Thn_Akademik'], $row['Periode'], $row['Nim']);               
                echo "Perkuliahan mahasiswa ".$row['id_regmhs']." - ".$row['Nama_Mhs']." berhasil dikirim ke feeder... <br>";
                echo $updatefeed;
            } else {
                echo $insertResult;
            }                       
        } else {
            if (empty($row['id_regmhs'])) {
                echo "Mahasiswa ".$row['Nim']."-".$row['Nama_Mhs']." belum terigistrasi/terdaftar di feeder..<br>";
            } else {
                echo "Perkuliahan mahasiswa ".$row['id_regmhs']." - ".$row['Nama_Mhs']." sudah ada..<br>";
            }                        
        }
        
    }

    // Tutup koneksi ke database
    $conn = null;
}
?>
