<?php
function insertKelasKuliah($token, $record) {
    $data = array(
        'act' => 'InsertKelasKuliah',
        'token' => $token,
        'record' => $record,
    );

    $result_string = runWS($data);

    if ($result_string['error_code'] === 0) {        
        $hasil = $result_string['data']['id_kelas_kuliah'];
    } else {
        $hasil = "Gagal melakukan insert Kelas Kuliah. Error: " . $result_string['error_desc'];
    }

    return $hasil;
}


function UpdateKelasKuliah($token, $key, $record) {
    $data = array(
        'act' => 'UpdateKelasKuliah',
        'token' => $token,
        'key' => array('id_kelas_kuliah' => $key),    
        'record' => $record,
    );

    $result_string = runWS($data);

    if ($result_string['error_code'] === 0) {
        $hasil = "Kelas Kuliah berhasil diperbarui.";
    } else {
        $hasil = "Gagal memperbarui Kelas Kuliah. Error: " . $result_string['error_desc'];
    }

    return $hasil;
}

function GetListKelasKuliah($token, $id_prodi, $id_matkul, $idsemester, $kelas ) {
    $filter = "id_prodi='$id_prodi' and id_matkul='$id_matkul' and id_semester='$idsemester' and nama_kelas_kuliah = '$kelas'";
    $order = "";
    $limit = 10;
    $offset = 0;
    $apiToken = $token;

    $data = array(
        'act' => 'GetListKelasKuliah',
        'token' => $apiToken,
        'filter' => $filter,
        'order' => $order,
        'limit' => $limit,
        'offset' => $offset
    );

    $result_string = runWS($data);

    if ($result_string['error_code'] === 0) {
        if (!empty($result_string['data'])) {
            //$hasil = "1";
            $hasil = $result_string['data'][0]['id_kelas_kuliah'];        
            }
         else {
            $hasil = "0";  
        }      
    } else {
        $hasil = "Gagal mendapatkan id_kelas_kuliah Error: " . $result_string['error_desc'];
    }
    return $hasil;
}



//



function insertDosenPengajarKelasKuliah($token, $record) {
    $data = array(
        'act' => 'InsertDosenPengajarKelasKuliah',
        'token' => $token,
        'record' => $record,
    );

    $result_string = runWS($data);

    if ($result_string['error_code'] === 0) {
        $hasil = $result_string['data']['id_aktivitas_mengajar'];
    } else {
        $hasil = "Gagal melakukan insert Dosen Pengajar Kelas Kuliah. Error: " . $result_string['error_desc'];
    }

    return $hasil;
}

function UpdateDosenPengajarKelasKuliah($token, $key, $record) {
    $data = array(
        'act' => 'UpdateDosenPengajarKelasKuliah',
        'token' => $token,
        'key' => array('id_aktivitas_mengajar' => $key),    
        'record' => $record,
    );

    $result_string = runWS($data);

    if ($result_string['error_code'] === 0) {
        $hasil = "DosenPengajarKelasKuliah berhasil diperbarui.";
    } else {
        $hasil = "Gagal memperbarui DosenPengajarKelasKuliah. Error: " . $result_string['error_desc'];
    }

    return $hasil;
}

function GetDosenPengajarKelasKuliah($token, $idklskuiah, $nidn) {    
    $filter = "id_kelas_kuliah='$idklskuiah' and nidn='$nidn'";  
    $order = "";  
    $limit = 1; 
    $offset = 0; 
    $apiToken = $token; 
    
    $data = array(
        'act' => 'GetDosenPengajarKelasKuliah',
        'token' => $apiToken,  
        'filter' => $filter, 
        'order' => $order, 
        'limit' => $limit, 
        'offset' => $offset
    );

    $result_string = runWS($data);
    if ($result_string['error_code'] === 0) {
        if ($result_string['jumlah'] === 0) {
            $hasil = "0";
        } else {           
            $hasil = $result_string['data'][0]['id_aktivitas_mengajar'];        
        }        
    } else {
        $hasil = "Gagal mendapatkan id_aktivitas_mengajar. Error: " . $result_string['error_desc'];
    }

    return $hasil;
}



function GetListPenugasanDosen($token, $nidn) {    
    $filter = "nidn='$nidn'";  
    $order = "id_tahun_ajaran Desc";  
    $limit = 1; 
    $offset = 0; 
    $apiToken = $token; 
    
    $data = array(
        'act' => 'GetListPenugasanDosen',
        'token' => $apiToken,  
        'filter' => $filter, 
        'order' => $order, 
        'limit' => $limit, 
        'offset' => $offset
    );

    $result_string = runWS($data);
    if ($result_string['error_code'] === 0) {
        if ($result_string['jumlah'] === 0) {
            $hasil = "0";
        } else {           
            $hasil = $result_string['data'][0]['id_registrasi_dosen'];        
        }        
    } else {
        $hasil = "Gagal mendapatkan id_registrasi_dosen. Error: " . $result_string['error_desc'];
    }

    return $hasil;
}


function insertPesertaKelasKuliah($token, $record) {
    $data = array(
        'act' => 'InsertPesertaKelasKuliah',
        'token' => $token,
        'record' => $record,
    );

    $result_string = runWS($data);

    if ($result_string['error_code'] === 0) {
        $hasil = "Insert Peserta Kelas Kuliah berhasil.";
    } else {
        $hasil = "Gagal melakukan Insert Peserta Kelas Kuliah. Error: " . $result_string['error_desc'];
    }

    return $hasil;
}

function GetPesertaKelasKuliah($token, $idkelaskuliah, $idregmhs) {    
    $filter = "id_kelas_kuliah='$idkelaskuliah' and id_registrasi_mahasiswa = '$idregmhs'";
    $order = "";
    $limit = 1;
    $offset = 0;
    $apiToken = $token;
  
    $data = array(
        'act' => 'GetPesertaKelasKuliah',
        'token' => $apiToken,
        'filter' => $filter,
        'order' => $order,
        'limit' => $limit,
        'offset' => $offset
    );
  
    $result_string = runWS($data);
  
    if ($result_string['error_code'] === 0) {
        if (!empty($result_string['data'])) {
            $hasil = "1";
            //$hasil = $result_string['data'][0]['id_registrasi_mahasiswa'];        
            }
         else {
            $hasil = "0";  
        }      
    } else {
        $hasil = "Gagal mendapatkan id_registrasi_mahasiswa. Error: " . $result_string['error_desc'];
    }
    return $hasil;
  }

?>