<?php
function insertKurikulum($token, $record) {
    $data = array(
        'act' => 'InsertKurikulum',
        'token' => $token,
        'record' => $record,
    );

    $result_string = runWS($data);

    if ($result_string['error_code'] === 0) {        
        $hasil = $result_string['data']['id_kurikulum'];
    } else {
        $hasil = "Gagal menambahkan kurikulum. Error: " . $result_string['error_desc'];
    }

    return $hasil;
}

function updateKurikulum($token, $key, $record) {
    $data = array(
        'act' => 'UpdateKurikulum',
        'token' => $token,
        'key' => array('id_kurikulum' => $key),    
        'record' => $record,
    );

    $result_string = runWS($data);

    if ($result_string['error_code'] === 0) {
        $hasil = "Kurikulum berhasil diperbarui.";
    } else {
        $hasil = "Gagal memperbarui kurikulum. Error: " . $result_string['error_desc'];
    }

    return $hasil;
}

function deleteKurikulum($token, $idkurikulum) {
    $data = array(
        'act' => 'DeleteKurikulum',
        'token' => $token,
        'key' => array('id_kurikulum' => $idkurikulum),        
    );

    $result_string = runWS($data);

    if ($result_string['error_code'] === 0) {
        $hasil = "Kurikulum berhasil dihapus.";
    } else {
        $hasil = "Gagal menghapus kurikulum. Error: " . $result_string['error_desc'];
    }

    return $hasil;
}

function insertMatkulKurikulum($token, $record) {
    $data = array(
        'act' => 'InsertMatkulKurikulum',
        'token' => $token,
        'record' => $record,
    );

    $result_string = runWS($data);

    if ($result_string['error_code'] === 0) {             
        $hasil = "1";
    } else {
        $hasil = "Gagal menambahkan Mata Kuliah ke kurikulum. Error: " . $result_string['error_desc'];
    }

    return $hasil;
}

function DeleteMatkulKurikulum($token, $key) {
    $data = array(
        'act' => 'DeleteMatkulKurikulum',
        'token' => $token,
        'key' => $key,
    );

    $result_string = runWS($data);

    if ($result_string['error_code'] === 0) {
        $hasil = "Kurikulum berhasil dihapus.";
    } else {
        $hasil = "Gagal menghapus Kurikulum. Error: " . $result_string['error_desc'];
    }

    return $hasil;
}

function getMatkulKurikulum($token, $id_kurikulum, $id_matkul) {
    $filter = "id_kurikulum='$id_kurikulum' and id_matkul='$id_matkul'";
    $order = "";
    $limit = 10;
    $offset = 0;
    $apiToken = $token;

    $data = array(
        'act' => 'GetMatkulKurikulum',
        'token' => $apiToken,
        'filter' => $filter,
        'order' => $order,
        'limit' => $limit,
        'offset' => $offset
    );

    $result_string = runWS($data);

    if ($result_string['error_code'] === 0) {
        if (!empty($result_string['data'])) {
            $hasil = "1";
            }
         else {
            $hasil = "0";  
        }      
    } else {
        $hasil = "Gagal mendapatkan data Matkul Kurikulum. Error: " . $result_string['error_desc'];
    }
    return $hasil;
}

function getIdKurikulum($token, $id_prodi, $nama_kurikulum) {
    $filter = "id_prodi='$id_prodi' and nama_kurikulum='$nama_kurikulum'";  
    $order = "";  
    $limit = 10; 
    $offset = 0; 
    $apiToken = $token; 
    
    $data = array(
        'act' => 'GetListKurikulum',
        'token' => $apiToken,  
        'filter' => $filter, 
        'order' => $order, 
        'limit' => $limit, 
        'offset' => $offset
    );

    $result_string = runWS($data);
    if ($result_string['error_code'] === 0) {
        if ($result_string['jumlah'] === 0) {
            $hasil = "0";
        } else {           
            $hasil = $result_string['data'][0]['id_kurikulum'];        
        }        
    } else {
        $hasil = "Gagal mendapatkan Id kurikulum. Error: " . $result_string['error_desc'];
    }

    return $hasil;
}
?>
