<?php

function runWS($fields) {
  $fURL = $GLOBALS['urlpddikti'];
  $ch = curl_init();
  curl_setopt($ch, CURLOPT_URL, $fURL);
  curl_setopt($ch, CURLOPT_POST, true);
  $headers = ['Content-Type: application/json'];
  curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
  curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));
  curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

  $output = curl_exec($ch);

  if ($output === false) {
    // Penanganan kesalahan curl
    echo 'Curl error: ' . curl_error($ch);
    return ['error_code' => -1, 'error_desc' => 'Curl error: ' . curl_error($ch)];
  }
  curl_close($ch);
  $output = trim($output);
  $data = json_decode($output, true);
  return $data;
}

function getToken() {
  $fields = [
      'act'      => 'GetToken',
      'username' => $GLOBALS['usernamepddikti'],
      'password' => $GLOBALS['passwordpddikti'],
  ];

  $data = runWS($fields);

  if ($data['error_code'] == '0') {
      return $data['data']['token'];
  } else {
      return '';
  }
}

function getlist($xlist, $xlim, $xoff) {
  $filter = "";
  $order = "";
  $limit = $xlim;
  $offset = $xoff;
  $token = getToken(); // Ambil token dari fungsi getToken
  $data = [
      'act'    => $xlist,
      'token'  => $token,
      'filter' => $filter,
      'order'  => $order,
      'limit'  => $limit,
      'offset' => $offset,
  ];

  $result_string = runWS($data);
  return $result_string;
}

function jsonToTable($data) {
  // Mengecek apakah ada data yang diterima
  if (!$data || !isset($data['data']) || !is_array($data['data']) || empty($data['data'])) {
      return "Tidak ada data untuk ditampilkan.";
  }

  // Membuat header tabel
  $tableHTML = "<table border='1'><tr>";
  foreach (array_keys($data['data'][0]) as $key) {
      $tableHTML .= "<th>" . $key . "</th>";
  }
  $tableHTML .= "</tr>";

  // Menambahkan record data ke dalam tabel
  foreach ($data['data'] as $record) {
      $tableHTML .= "<tr>";
      foreach ($record as $value) {
          $tableHTML .= "<td>" . $value . "</td>";
      }
      $tableHTML .= "</tr>";
  }

  // Menutup tabel
  $tableHTML .= "</table>";

  return $tableHTML;
}

function caribiomhs($idmhs) {
    $filter = "id_mahasiswa='$idmhs'"; 
    $order = ""; 
    $limit = 1; 
    $offset = 0; 
    $data = array('act'=>'GetBiodataMahasiswa', 
                  'token'=>$GLOBALS['token'], 
                  'filter'=>$filter, 
                  'order'=>$order, 
                  'limit'=>$limit, 
                  'offset'=>$offset);
    $result_string = runWS($data);
    
    if (empty($result_string['data'])) {
      $dta = "Tidak ada";
    } else {
      $dta = "Sudah ada";	
    }
    return  $dta;
    }
    
    function GetDetailPerkuliahanMahasiswa($nim,$idsem) {
    $filter = "nim = '$nim' and id_semester = '$idsem'";
    $order = ""; 
    $limit = 1; 
    $offset = 0; 
    $data = array('act'=>'GetDetailPerkuliahanMahasiswa', 
                  'token'=>$GLOBALS['token'], 
                  'filter'=>$filter, 
                  'order'=>$order, 
                  'limit'=>$limit, 
                  'offset'=>$offset);
    $result_string = runWS($data);
    
    if (empty($result_string['data'])) {
      $dta = "Tidak ada";
    } else {
      $dta = "Sudah ada";	
    }
    return  $dta;
    }
    
    function getidmhs($nama,$tgl) {
    if(is_null($tgl)){
        $tgllahir ='2002-01-01';	
    } else
    {
        $tgllahir = date_format($tgl,"Y-m-d"); 	
    }		
    $filter = "nama_mahasiswa='$nama' and tanggal_lahir='$tgllahir'";
    $order = ""; 
    $limit = 1; 
    $offset = 0; 
    $data = array('act'=>'GetListMahasiswa', 
                  'token'=>$GLOBALS['token'], 
                  'filter'=>$filter, 
                  'order'=>$order, 
                  'limit'=>$limit,
                  'offset'=>$offset);
    $result_string = runWS($data);
    
    if (empty($result_string['data'])) {
        return "-";
    } else {
    return $result_string['data'][0]['id_mahasiswa']."|".$result_string['data'][0]['id_registrasi_mahasiswa'];
    }
    }
    
    function getidregmhs($nim) {
    $filter = "nim='$nim'";
    $order = ""; 
    $limit = 1; 
    $offset = 0; 
    $data = array('act'=>'GetListMahasiswa', 
                  'token'=>$GLOBALS['token'], 
                  'filter'=>$filter, 
                  'order'=>$order, 
                  'limit'=>$limit,
                  'offset'=>$offset);
    $result_string = runWS($data);
    
    if (empty($result_string['data'])) {
        return "0";
    } else {
    return $result_string['data'][0]['id_registrasi_mahasiswa'];
    }
    }
    
       
    function hitsks($idreg,$th) {
    $filter = "id_registrasi_mahasiswa = '$idreg' and id_periode = '$th'";
    $order = ""; 
    $limit = 0; 
    $offset = 0; 
    $data = array('act'=>'GetKRSMahasiswa', 
                  'token'=>$GLOBALS['token'], 
                  'filter'=>$filter, 
                  'order'=>$order, 
                  'limit'=>$limit,
                  'offset'=>$offset);
    $result_string = runWS($data);
    $tsks=0;
    if (empty($result_string['data'])) {
        $tsks=0;
    } else {		
        $arrayLength = count($result_string['data']);	
        $i = 0;
          while ($i < $arrayLength) {
                $tsks=$tsks+floatval($result_string['data'][$i]['sks_mata_kuliah']);					
                $i++;
            }
    }	
    return $tsks;
    }

    function GetListRiwayatPendidikanMahasiswa($token, $nim) {
      $filter = "nim='$nim'";
      $order = "";
      $limit = 1;
      $offset = 0;
      $apiToken = $token;
    
      $data = array(
          'act' => 'GetListRiwayatPendidikanMahasiswa',
          'token' => $apiToken,
          'filter' => $filter,
          'order' => $order,
          'limit' => $limit,
          'offset' => $offset
      );
    
      $result_string = runWS($data);
    
      if ($result_string['error_code'] === 0) {
          if (!empty($result_string['data'])) {
              //$hasil = "1";
              $hasil = $result_string['data'][0]['id_registrasi_mahasiswa'];        
              }
           else {
              $hasil = "0";  
          }      
      } else {
          $hasil = "Gagal mendapatkan id_registrasi_mahasiswa. Error: " . $result_string['error_desc'];
      }
      return $hasil;
    }

    function CekMatkulKurikulum($token, $mkkode, $idkur ) {    
      $filter = "kode_mata_kuliah = '$mkkode' and id_kurikulum = '$idkur'";
      $order = "";
      $limit = 10; 
      $offset = 0;
      $apiToken = $token;
  
      $data = array(
          'act' => 'GetMatkulKurikulum',
          'token' => $apiToken,
          'filter' => $filter,
          'order' => $order,
          'limit' => $limit,
          'offset' => $offset
      );
  
      $result_string = runWS($data);
  
      if ($result_string['error_code'] === 0) {
          if (!empty($result_string['data'])) {
              //$hasil = "1";
              $hasil = $result_string['data'][0]['id_matkul'];        
              }
           else {
              $hasil = "0";  
          }      
      } else {
          $hasil = "Error: " . $result_string['error_desc'];
      }
      return $hasil;
  }

  function updateIdMK($idmatkul, $kdkur, $kjp, $kmk) {
    global $conn;

    try {
        // Prepare the SQL query
        $query = "UPDATE tblMk_PSmtr SET id_matkul = :idmatkul WHERE KodeKur = :kdkur AND Kode_Jp = :kjp AND Kode_Mk = :kmk";
        $stmt = $conn->prepare($query);

        // Bind parameters
        $stmt->bindParam(':idmatkul', $idmatkul, PDO::PARAM_INT);
        $stmt->bindParam(':kdkur', $kdkur, PDO::PARAM_STR);
        $stmt->bindParam(':kjp', $kjp, PDO::PARAM_STR);
        $stmt->bindParam(':kmk', $kmk, PDO::PARAM_STR);

        // Execute the update query
        $stmt->execute();

        // Check if the update was successful
        $rowCount = $stmt->rowCount();
        if ($rowCount > 0) {
            return "Id Matkul ".$idmatkul." Berhasil di tambahkan ke MK SIAP <br> <br>";
        } else {
            return "No rows updated. Check your conditions.<br>";
        }
    } catch (PDOException $e) {
        return "Error updating data: " . $e->getMessage();
    }
}

function setketnilai($nim, $th, $per, $kmk) {
    global $conn;

    try {
        // Prepare the SQL query
        $query = "UPDATE tblNilai
                  SET stat_feeder = 'Sudah Sync'
                  WHERE Nim = :nim AND Thn_Akademik = :th AND Periode = :per AND Kode_MK = :kmk";
                  
	    $stmt = $conn->prepare($query);
        // Bind parameters       
        $stmt->bindParam(':nim', $nim, PDO::PARAM_STR);
        $stmt->bindParam(':th', $th, PDO::PARAM_STR);
        $stmt->bindParam(':per', $per, PDO::PARAM_STR);
        $stmt->bindParam(':kmk', $kmk, PDO::PARAM_STR);
        
        // Execute the update query
        $stmt->execute();

        // Check if the update was successful
        $rowCount = $stmt->rowCount();
        if ($rowCount > 0) {
            return "Status Sync untuk ".$nim." - ".$th." - ".$per." - ".$kmk." sukses! ".$rowCount." baris terpengaruh. <br>";
        } else {
            return "Tidak ada baris yang diupdate. Periksa kondisi Anda.<br>";
        }
    } catch (PDOException $e) {
        return "Error updating data: " . $e->getMessage();
    }
}
?>