<?php
include 'db.php'; //contains database connection script
include 'init.php';
include 'crud_mk.php';
include 'crud_kelaskuliah.php';

function updateJadwal($id_kelas_kuliah, $Thn_Akademik, $Periode, $Kelas_Akd, $Kode_Jp, $Kode_Mk, $Kelas) {
    global $conn;

    try {
        // Prepare the SQL query
        $query = "UPDATE tbljadwal
                  SET id_kelas_kuliah = :id_kelas_kuliah
                  WHERE Thn_Akademik = :Thn_Akademik
                  AND Periode = :Periode
                  AND Kelas_Akd = :Kelas_Akd
                  AND Kode_Jp = :Kode_Jp
                  AND Kode_Mk = :Kode_Mk
                  AND Kelas = :Kelas";

        $stmt = $conn->prepare($query);

        // Bind parameters
        $stmt->bindParam(':id_kelas_kuliah', $id_kelas_kuliah, PDO::PARAM_STR);
        $stmt->bindParam(':Thn_Akademik', $Thn_Akademik, PDO::PARAM_STR);
        $stmt->bindParam(':Periode', $Periode, PDO::PARAM_STR);
        $stmt->bindParam(':Kelas_Akd', $Kelas_Akd, PDO::PARAM_STR);
        $stmt->bindParam(':Kode_Jp', $Kode_Jp, PDO::PARAM_STR);
        $stmt->bindParam(':Kode_Mk', $Kode_Mk, PDO::PARAM_STR);
        $stmt->bindParam(':Kelas', $Kelas, PDO::PARAM_STR);

        // Execute the update query
        $stmt->execute();

        // Check if the update was successful
        $rowCount = $stmt->rowCount();
        if ($rowCount > 0) {
            return "id_kelas_kuliah : ".$id_kelas_kuliah." berhasil ditambahkan ke Jadwal SIAP <br>";
        } else {
            return "Tidak ada baris yang diupdate. Periksa kondisi Anda. <br>";
        }
    } catch (PDOException $e) {
        return "Error updating data: " . $e->getMessage();
    }
}

function ListKrs($token, $Thn_Akademik, $Periode, $Status_akd, $Kode_jp, $KodeMK, $kls, $idkelaskuliah) {
    global $conn;

    try {
        // Prepare the SQL query
        $query = "SELECT Nim, KodeMK, MKKode, Jumlah, Nilai, Angka
                  FROM Feed_KRS
                  WHERE Thn_Akademik = :Thn_Akademik
                  AND Periode = :Periode
                  AND Status_akd = :Status_akd
                  AND Kode_jp = :Kode_jp
                  AND KodeMK = :KodeMK
                  AND kls = :kls";

        $stmt = $conn->prepare($query);

        // Bind parameters
        $stmt->bindParam(':Thn_Akademik', $Thn_Akademik, PDO::PARAM_STR);
        $stmt->bindParam(':Periode', $Periode, PDO::PARAM_STR);
        $stmt->bindParam(':Status_akd', $Status_akd, PDO::PARAM_STR);
        $stmt->bindParam(':Kode_jp', $Kode_jp, PDO::PARAM_STR);
        $stmt->bindParam(':KodeMK', $KodeMK, PDO::PARAM_STR);
        $stmt->bindParam(':kls', $kls, PDO::PARAM_STR);

        // Execute the query
        $stmt->execute();

        // Fetch the results
        $result = $stmt->fetchAll(PDO::FETCH_ASSOC);

        // Output the results or handle accordingly
        if ($result) {
            foreach ($result as $row) {
                // Output or process each row as needed
                // echo "Nim: " . $row['Nim'] . ", KodeMK: " . $row['KodeMK'] . ", MKKode: " . $row['MKKode'] . "<br>";
                // Add other fields as needed

                $idregmhs = GetListRiwayatPendidikanMahasiswa($token, $row['Nim']);
                if (strlen($idregmhs) === 36)  {
                    $record = array(
                        "id_kelas_kuliah" => $idkelaskuliah,
                        "id_registrasi_mahasiswa" => $idregmhs,
                    );
                    $psk = GetPesertaKelasKuliah($token, $idkelaskuliah, $idregmhs);
                    if ($psk == "0") {
                        $pstkuliah = insertPesertaKelasKuliah($token, $record);
                        echo $pstkuliah." (". $row['Nim'].")";
                        echo "<br>";
                        $stat = Updkrs($row['Nim'], $Thn_Akademik, $Periode, $KodeMK, '1');
                        echo $stat;
                 } elseif ($psk == "1") {
                    //insert nilai
                    echo "Peserta kuliah dengan nim ".$row['Nim']."sudah ada ....<br>";
                    }
            } else {
                echo " id_registrasi_mahasiswa dengan NPM/NIM = ".$row['Nim']." tidak ditemukan";
                echo "<br>";
            }
          }
        } else {
            echo "No records found for the given parameters.";
        }
    } catch (PDOException $e) {
        echo "Error executing query: " . $e->getMessage();
    }
}


// Get parameters from the query string using $_GET
$Thn_Akademik = isset($_GET['Thn_Akademik']) ? $_GET['Thn_Akademik'] : '';
$Periode = isset($_GET['Periode']) ? $_GET['Periode'] : '';
$Kelas_Akd = isset($_GET['Kelas_Akd']) ? $_GET['Kelas_Akd'] : '';
$Kode_Jp = isset($_GET['Kode_Jp']) ? $_GET['Kode_Jp'] : '';
$Kode_Mk = isset($_GET['Kode_Mk']) ? $_GET['Kode_Mk'] : '';
$Kelas = isset($_GET['Kelas']) ? $_GET['Kelas'] : '';

$token = getToken();
try {
    // Prepare the SQL query
    $query = "SELECT Thn_Akademik, Periode, IDTahun, Kelas_Akd, Feed_Jadwal.Kode_Jp, idprodi, Kode_Mk, MKKode, Nama_Mk_Ind, SKS, Kelas, TanggalKuliah, tglSelesaiKuliah, Feed_Jadwal.NIDN, tblDosen.Nama 
              FROM Feed_Jadwal INNER JOIN tblDosen on Feed_Jadwal.NIDN=tblDosen.NIDN
              WHERE Thn_Akademik = :Thn_Akademik
              AND Periode = :Periode
              AND Kelas_Akd = :Kelas_Akd
              AND Feed_Jadwal.Kode_Jp = :Kode_Jp
              AND Kode_Mk = :Kode_Mk
              AND Kelas = :Kelas";

    $stmt = $conn->prepare($query);

    // Bind parameters
    $stmt->bindParam(':Thn_Akademik', $Thn_Akademik, PDO::PARAM_STR);
    $stmt->bindParam(':Periode', $Periode, PDO::PARAM_STR);
    $stmt->bindParam(':Kelas_Akd', $Kelas_Akd, PDO::PARAM_STR);
    $stmt->bindParam(':Kode_Jp', $Kode_Jp, PDO::PARAM_STR);
    $stmt->bindParam(':Kode_Mk', $Kode_Mk, PDO::PARAM_STR);
    $stmt->bindParam(':Kelas', $Kelas, PDO::PARAM_STR);

    // Execute the query
    $stmt->execute();

    // Fetch the results
    $result = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Output the results or handle accordingly
    if ($result) {
        foreach ($result as $row) {
            // Output or process each row as needed
            echo "Kelas Perkuiahan : <br>";
            echo "Thn_Akademik: " . $row['Thn_Akademik'] . ", Periode: " . $row['Periode'] . ", Matakuiah: " . $row['MKKode'] ." - ". $row['Nama_Mk_Ind'] ." DOSEN NIDN = ". $row['NIDN'] ." - ".$row['Nama']. "<br>";
            // ambil id reg dosen dan id matkul
            $idregdosen = GetListPenugasanDosen($token, $row['NIDN']);            
            //$idmatkul = GetIdMataKuliah($token, $row['MKKode'], $row['idprodi']);  
            $idmatkul = GetIdMataKuliah($token, $row['MKKode'], $row['idprodi'], $row['SKS']);
            //Cek apakah idmatkul dan id dosen sudah terdaftar..?          
            if ((strlen($idmatkul) === 36) && (strlen($idregdosen) === 36)) {            
                $record = array(
                    "id_prodi" => $row['idprodi'],
                    "id_semester" => $row['IDTahun'],
                    "id_matkul" => $idmatkul,
                    "nama_kelas_kuliah" => substr($row['Kelas'],-5),
                    "bahasan" => null,
                    "tanggal_mulai_efektif" => ($row['TanggalKuliah'] !== null) ? date('Y-m-d', strtotime($row['TanggalKuliah'])) : null,
                    "tanggal_akhir_efektif" => ($row['tglSelesaiKuliah'] !== null) ? date('Y-m-d', strtotime($row['tglSelesaiKuliah'])) : null,
                    "tanggal_tutup_daftar" => null,
                    "apa_untuk_pditt" => 0,
                    "kapasitas" => 30,
                    "lingkup" => 1,
                    "mode" => "M"
                );
                //Cek id kelas kuliah
                $idkelaskuliah = GetListKelasKuliah($token, $row['idprodi'], $idmatkul, $row['IDTahun'], $record['nama_kelas_kuliah']);
                if ($idkelaskuliah=="0") { //jika belum ada maka tambahkan
                    $idkelaskuliah = insertKelasKuliah($token, $record);    
                    if (strlen($idkelaskuliah) === 36) {
                        echo "Kelas kuliah dengan id : ". $idkelaskuliah ." berhasil dikirim ke feeder <br>";
                    } else {
                        echo $idkelaskuliah;
                    }
                } 
                if (strlen($idkelaskuliah) === 36) { //jika sudah ada tambahkan dosen    
                    //update id_kelas_kuliah di SIAP 
                    $info = updateJadwal($idkelaskuliah, $row['Thn_Akademik'], $row['Periode'], $row['Kelas_Akd'], $row['Kode_Jp'], $row['Kode_Mk'], $row['Kelas']);
                    echo $info;
                    $xrecord = array(
                        "id_registrasi_dosen" => $idregdosen,
                        "id_kelas_kuliah" => $idkelaskuliah,
                        "id_substansi" => null,
                        "sks_substansi_total" => $row['SKS'],
                        "rencana_minggu_pertemuan" => "16",
                        "realisasi_minggu_pertemuan" => "16",
                        "id_jenis_evaluasi" => 1
                    );                
                    //print_r($xrecord);
                    //echo "<br>";
                    $idaktmengajar = GetDosenPengajarKelasKuliah($token, $idkelaskuliah, $row['NIDN']);                
                    if ($idaktmengajar == "0") { //tambahkan dosen pengajar                 
                        $idakt_mengajar_dsn = insertDosenPengajarKelasKuliah($token, $xrecord);   
                        if (strlen($idakt_mengajar_dsn) === 36) {
                            echo "Dosen : ".$row['Nama']." berhasil ditambahkan ke Pengajar KelasKuliah.. <br> " ;
                        } else {
                            echo $idakt_mengajar_dsn ."<br>";               
                        }
                    } elseif (strlen($idaktmengajar) === 36) {
                        echo "Dosen : ".$row['Nama']." sudah terdaftar Pengajar KelasKuliah dengan id ".$idaktmengajar. " <br> " ;
                    } else {
                        echo $idaktmengajar ."<br>";
                    }

                 //Insert peserta kuliah
                  ListKrs($token, $Thn_Akademik, $Periode, $Kelas_Akd, $Kode_Jp, $row['Kode_Mk'], $Kelas, $idkelaskuliah);
            
                } // end idkelaskuliah            
            
          } else {
               echo " - Salah satu IDMatkul/IDDosen untuk matakuliah ".$row['Kode_Mk']. " - ". $row['Nama_Mk_Ind']."(".$row['SKS'].") belum ada !! <br>";
        }//end idmatkul
      }    

    } else {
        echo "No records found for the given parameters.";
    }
} catch (PDOException $e) {
    echo "Error executing query: " . $e->getMessage();
}
?>