<?php
include "db.php";
include "init.php";

function GetDetailNilaiPerkuliahanKelas($token, $idregmhs, $idsem, $kmk) {    
    $filter = "id_registrasi_mahasiswa = '$idregmhs' AND id_semester = '$idsem' AND kode_mata_kuliah = '$kmk'"; 
    $order = ""; 
    $limit = 1; 
    $offset = 0; 
    $apiToken = $token; 
    $data = array(
        'act' => 'GetDetailNilaiPerkuliahanKelas', 
        'token' => $apiToken,  
        'filter' => $filter, 
        'order' => $order, 
        'limit' => $limit, 
        'offset' => $offset
    );
    $result_string = runWS($data);
    if ($result_string['error_code'] === 0) {
        if ($result_string['jumlah'] === 0) {
            $xid = "0";
        } else {           
            $xid = $result_string['data'][0]['id_kelas_kuliah'];        
        }              
    } else {        
        $xid = "Gagal mendapatkan id_kelas_kuliah. Error: " . $result_string['error_desc'];     
    }
    return $xid;
}

function updateNilaiPerkuliahanKelas($token, $key, $record) {
    $data = array(
        'act' => 'UpdateNilaiPerkuliahanKelas',
        'token' => $token,
        'key' => $key,
        'record' => $record,
    );

    $result_string = runWS($data);

    if ($result_string['error_code'] === 0) {
        $hasil = "1";
    } else {
        $hasil = "Gagal diperbaharui. Error: " . $result_string['error_desc'];
    }

    return $hasil;
}


// Ambil nilai dari query string
$Thn_Akademik = isset($_GET['Thn_Akademik']) ? $_GET['Thn_Akademik'] : '';
$Periode = isset($_GET['Periode']) ? $_GET['Periode'] : '';
$Kelas_Akd = isset($_GET['Kelas_Akd']) ? $_GET['Kelas_Akd'] : '';
$Kode_Jp = isset($_GET['Kode_Jp']) ? $_GET['Kode_Jp'] : '';
$Kode_Mk = isset($_GET['Kode_Mk']) ? $_GET['Kode_Mk'] : '';
$Nim = isset($_GET['Nim']) ? $_GET['Nim'] : '';

// Validasi input
if (empty($Thn_Akademik) || empty($Periode) || empty($Kelas_Akd) || empty($Kode_Jp) || empty($Kode_Mk)) {
    // Tampilkan pesan error jika ada parameter yang kosong
    echo "Semua parameter harus diisi.";
} else {
    // Buat query berdasarkan kriteria
    $query = "SELECT Thn_Akademik, Periode, IDTahun, Nim, Nama_Mhs, Kode_MK, Nama_Mk_Ind, SKS, Kehadiran, Tugas, UTS, UAS, Jumlah, Nilai, Angka, id_feedmhs
              FROM V_NilaiMhs
              WHERE Thn_Akademik = :Thn_Akademik
                    AND Periode = :Periode
                    AND Status_Akd = 'Reguler'
                    AND Kode_jp = :Kode_Jp
                    AND Kode_MK = :Kode_Mk";

    // Persiapkan statement
    $stmt = $conn->prepare($query);

    // Bind parameter
    $stmt->bindParam(':Thn_Akademik', $Thn_Akademik, PDO::PARAM_STR);
    $stmt->bindParam(':Periode', $Periode, PDO::PARAM_STR);
    $stmt->bindParam(':Kode_Jp', $Kode_Jp, PDO::PARAM_STR);
    $stmt->bindParam(':Kode_Mk', $Kode_Mk, PDO::PARAM_STR);

    // Eksekusi query
    $stmt->execute();

    // Ambil hasil query
    $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
    if ($result) {
        echo "===Update nilai mahasiswa untuk kode matakuliah " . $Kode_Mk."===<br>";
        $token = getToken();        
        foreach ($result as $row) {  
            //echo "Update nilai mahasiswa untuk matakuliah " . $row['MKKode']." - ".$row['Nama_Mk_Ind']." (".$row['SKS']." SKS) <br><br> ";         
            //Cari id kelas kuliah       
            $idkelaskuliah = GetDetailNilaiPerkuliahanKelas($token, $row['id_feedmhs'],  $row['IDTahun'], $row['Kode_MK']);
            if (strlen($idkelaskuliah) === 36) { //jika ditemukan
                $key = array(
                    "id_registrasi_mahasiswa" => $row['id_regmhs'],
                    "id_kelas_kuliah" => $idkelaskuliah
                    );
                $record = array(
                    "nilai_angka" =>  $row['Jumlah'],
                    "nilai_indeks" =>  $row['Angka'],
                    "nilai_huruf" =>  $row['Nilai']
                    );
                $updateResult = updateNilaiPerkuliahanKelas($token, $key, $record);
                if ($updateResult == "1") {
                    echo "Nilai untuk mahasiswa : ".$row['Nim']." - ".$row['Nama_Mhs'].", berhasil di update <br>";
                    $stat = setketnilai($row['Nim'], $row['Thn_Akademik'], $row['Periode'], $row['Kode_MK']);
                    echo $stat."<br>";                   
                    
                } else {
                    echo "Nilai untuk mahasiswa : ".$row['Nim']." - ".$row['Nama_Mhs'].", ".$updateResult."<br>";
                }
                
            } elseif ($idkelaskuliah == "0") {
                echo "id kelas kuliah : ".$row['Kode_MK']." - ".$row['Nama_Mk_Ind']." tidak ditemukan <br>";
            } else {
                echo $idkelaskuliah."<br>";
            }
        }     
    } else {
    echo "No records found for the given parameters.";
  
    }
    // Tutup koneksi ke database
    $conn = null;
}
?>
