<?php
include 'db.php'; //contains database connection script
include 'init.php';
include 'crud_mk.php';
include 'crud_kurikulum.php';

function updateIdKur($idkur, $kjp, $kodkur) {
    global $conn;
    try {
        // Prepare the SQL query
        $query = "UPDATE tblMK_Kurikulum SET id_kur = :idkur WHERE Kode_Jp = :kjp AND KodeKur = :kodkur";
        $stmt = $conn->prepare($query);

        // Bind parameters
        $stmt->bindParam(':idkur', $idkur, PDO::PARAM_INT);
        $stmt->bindParam(':kjp', $kjp, PDO::PARAM_STR);
        $stmt->bindParam(':kodkur', $kodkur, PDO::PARAM_STR);

        // Execute the update query
        $stmt->execute();

        // Check if the update was successful
        $rowCount = $stmt->rowCount();
        if ($rowCount > 0) {
            return "ID Kurikulum ".$idkur." berhasil ditambahkan di kurikuum SIAP <br>";
        } else {
            return "ID Kurikulum ".$idkur." gagal ditambahkan di kurikuum SIAP <br>";
        }
    } catch (PDOException $e) {
        return "Error updating data: " . $e->getMessage();
    }
}

function FeedMK($Kodekur, $Kode_Jp, $idprod, $idkur) {
    global $conn;

    $token = getToken();
    try {
        // Prepare the SQL query
        $query = "SELECT Kodekur, Kode_Jp, Kode_MK, MKKode, Nama_Mk_Ind, SKS, sksteory, sksprak, sksplap, Semester, Kjenis, IdKelompok, TglBuat
                  FROM Feed_Kurikulum
                  WHERE Kodekur = :Kodekur AND Kode_Jp = :Kode_Jp";

        $stmt = $conn->prepare($query);

        // Bind parameters
        $stmt->bindParam(':Kodekur', $Kodekur, PDO::PARAM_STR);
        $stmt->bindParam(':Kode_Jp', $Kode_Jp, PDO::PARAM_STR);

        // Execute the query
        $stmt->execute();

        // Fetch all records
        $result = $stmt->fetchAll(PDO::FETCH_ASSOC);

        // Check if any records are found
        if ($result) {
            $records = array();
            // Loop through each row and add it to the array
            echo "<br>Kirim/Syn Matakuliah ke Feeder <br>";
            foreach ($result as $row) {
                $record = array(
                    "kode_mata_kuliah" => $row['MKKode'],
		            "nama_mata_kuliah" => $row['Nama_Mk_Ind'],
		            "id_prodi" => $idprod,
		            "id_jenis_mata_kuliah" => ($row['Kjenis'] !== null) ? $row['Kjenis'] : "A",
		            "id_kelompok_mata_kuliah" => $row['IdKelompok'],
		            "sks_mata_kuliah" => $row['SKS'],
		            "sks_tatap_muka" => $row['sksteory'],
		            "sks_praktek" => $row['sksprak'],
		            "sks_praktek_lapangan" => $row['sksplap'],
		            "sks_simulasi" => 0.00,
                    "metode_kuliah" => "",
		            "ada_sap" => 0,
		            "ada_silabus" => 0,
		            "ada_bahan_ajar" => 0,
		            "ada_acara_praktek" => 0,
		            "ada_diktat" => 0,
		            "tanggal_mulai_efektif" => ($row['TglBuat'] !== null) ? date('Y-m-d', strtotime($row['TglBuat'])) : null,
		            "tanggal_akhir_efektif" => null    
                );   
                
                //Cek matakuiah apakah sudah terdaftar, jika belum kirim ke feeder     
                $kmk = $row['MKKode'];
                $temp_idmatkul = "";
                //$idmk = GetIdMataKuliah($token, $kmk, $idprod);
                $idmk = GetIdMataKuliah($token, $kmk, $idprod, $row['SKS']);    
                if ($idmk == "0") {  //jika belum terdaftar       
                    $id_matkul = insertmatakuliah($token, $record);                     
                    if (strlen($id_matkul) === 36) { //insert berhasil
                        echo "Matakuliahh dengan kode ".$record['kode_mata_kuliah']. "-". $record['nama_mata_kuliah']."(".$record['sks_mata_kuliah']. " SKS)  berhasil dikirim ke feeder matakuliah..<br>";                        
                        
                        //update idmatkul di SIAP
                        //$xstatus = updateIdMK($id_matkul, $Kodekur, $Kode_Jp, $row['Kode_MK']);
                        //echo $xstatus;    
                        $temp_idmatkul = $id_matkul;                                            
                    } else
                    {   //JIka gagal tampilkan error
                        echo  $id_matkul;
                    }         
         
                 } elseif (strlen($idmk) === 36) { // jika sudah ada di feeder
                    //$ystatus = updateMataKuliah($token, $idmk, $record);
                    //echo $ystatus;                    
                    echo "<br>Matakuliah : ".$row['MKKode']." - ".$row['Nama_Mk_Ind']." dengan id matkul : ".$idmk." sudah ada di feeder matakuliah....<br>";
                    $temp_idmatkul = $idmk; 
                 }
                 //Insert Matakuiah di Kurikulum feeder
                 $xrecord = array(
                    "id_kurikulum" => $idkur,
                    "id_matkul" => $temp_idmatkul,
                    "semester" => $row['Semester'],
                    "sks_mata_kuliah" => $row['SKS'],
                    "sks_tatap_muka" => $row['sksteory'],
                    "sks_praktek" => $row['sksprak'],
                    "sks_praktek_lapangan" => $row['sksplap'],
                    "sks_simulasi" => 0.00,        
                    "apakah_wajib" => 1
                ); 
                //cek apakah matakuliah sudah ada di kurikulum feeder
                $gmk = getMatkulKurikulum($token, $idkur, $temp_idmatkul);                
                if ($gmk == "0") {  //jika belum ada di feeder tambahkan     
                    echo "Kirim matakuliah dengan id matkul ".$xrecord['id_matkul']." ke feeder kurikulum..<br>";
                    $simk = insertMatkulKurikulum($token, $xrecord);                     
                    if ($simk == "1") {
                        echo " - Matakuliah Kurikulum dengan id matkul ".$xrecord['id_matkul']. " berhasil dikirim ke feeder...!<br>";   
                        //update idmatkul di kurikulum SIAP
                        $xstatus = updateIdMK($temp_idmatkul, $Kodekur, $Kode_Jp, $row['Kode_MK']);
                        echo $xstatus;                                                 
                    } else {
                       echo  $simk;                       
                    }                       
                 } elseif ($gmk == "1") {
                  // Matakuliah sudah ada di kurikulum
                  echo "Matakuliah dengan id matkul : ".$temp_idmatkul." tersebut sudah terdaftar di kurikulum feeder ..<br>";  
                  $xstatus = updateIdMK($temp_idmatkul, $Kodekur, $Kode_Jp, $row['Kode_MK']);
                  echo $xstatus;                                                 
                 } else {
                    //terjadi kesalahan json
                    echo $gmk;
                 }
                 
            } //end foreach

            
        } else {
            echo "No records found for the given parameters.";
        }
    } catch (PDOException $e) {
        echo "Error executing query: " . $e->getMessage();
    }
}


// Get parameters from the query string using $_GET
$jp = isset($_GET['jp']) ? $_GET['jp'] : '';
$KKur = isset($_GET['KKur']) ? $_GET['KKur'] : '';

// Validate parameters if needed

try {
    // Prepare the SQL query
    $query = "SELECT Kode_Jp, KodeKur, NamaKurikulum, SKSMKPilihan, SKSMKWajib, JmlSks, Feed_TA, idprodi
              FROM Feed_MasterKurikulum
              WHERE Kode_Jp = :jp AND KodeKur = :KKur";

    $stmt = $conn->prepare($query);

    // Bind parameters
    $stmt->bindParam(':jp', $jp, PDO::PARAM_STR);
    $stmt->bindParam(':KKur', $KKur, PDO::PARAM_STR);

    // Execute the query
    $stmt->execute();

    // Fetch the results
    $result = $stmt->fetch(PDO::FETCH_ASSOC);

    // Check if the result is empty
    if (!$result) {
        echo "Record not found.";
    } else {
        echo "<br>Kode_JP: " . $result['Kode_Jp'] . ", Kode Kurikulum: " . $result['KodeKur'] . ", Nama Kurikulum : " . $result['NamaKurikulum'] ."<br>";
        // Output the results in the desired array format
        $kjp = $result['Kode_Jp'];
        $kodkur = $result['KodeKur'];
        $idprod = $result['idprodi'];
        $record = array(  
            "nama_kurikulum" => $result['NamaKurikulum'],
            "id_prodi" => $result['idprodi'],
            "id_semester" => $result['Feed_TA'],
            "jumlah_sks_lulus" => $result['JmlSks'],
            "jumlah_sks_wajib" => $result['SKSMKWajib'],
            "jumlah_sks_pilihan" => $result['SKSMKPilihan'],
        );
        // Output the array
        //print_r($record);        
        $token = getToken();
        $id_prodi = $record['id_prodi'];        
        $nama_kurikulum = $record['nama_kurikulum'];
        $idkur = getIdKurikulum($token, $id_prodi, $nama_kurikulum);           
        if ($idkur == "0") { //jika tidak ditemukan di feeder         
           $id_kurikulum = insertKurikulum($token, $record);                     
           if (strlen($id_kurikulum) === 36) {
               echo "Kurikulum dengan ID ".$id_kurikulum." berhasil dikirim ke feeder <br>";
               $xstatus = updateIdKur($id_kurikulum, $kjp, $kodkur);     
               echo $xstatus;
               
               // Daftarkan master matakuliah dalam kurikulum ke feeder   
               FeedMK($kodkur, $kjp, $idprod, $id_kurikulum);
           } else
           {
               echo  $id_kurikulum;
           }                    

        } elseif (strlen($idkur) === 36) { //jika kurikulum sudah ada
           //$ystatus = updateKurikulum($token, $idkur, $record);
           //echo $ystatus."<br>";
           echo "Kurikulum ".$nama_kurikulum." sudah terdaftar di feeder...!";
           $xstatus = updateIdKur($idkur, $kjp, $kodkur);     
           
           // Daftarkan master matakuliah dalam kurikulum ke feeder   
           FeedMK($kodkur, $kjp, $idprod, $idkur);
        }              
        
    }
} catch (PDOException $e) {
    echo "Error executing query: " . $e->getMessage();
}
?>




