<?php
include 'db.php'; // db.php contains your database connection script
include 'init.php';
include 'crud_mhs.php';

function Randomnisn() {
    $randomNumber = mt_rand(1213212001, 9999999999);
    return (string)$randomNumber;
}
function Updmhs($idmhs, $idregmhs, $nim) {
    global $conn;

    try {
        // Prepare the SQL query
        $query = "UPDATE tblMHS
                  SET id_mhs = :idmhs, id_regmhs = :idregmhs
                  WHERE Nim = :nim";

        $stmt = $conn->prepare($query);

        // Bind parameters
        $stmt->bindParam(':idmhs', $idmhs, PDO::PARAM_INT);
        $stmt->bindParam(':idregmhs', $idregmhs, PDO::PARAM_INT);
        $stmt->bindParam(':nim', $nim, PDO::PARAM_STR);

        // Execute the update query
        $stmt->execute();

        // Check if the update was successful
        $rowCount = $stmt->rowCount();
        if ($rowCount > 0) {
            return "Update id_mahasiswa dan id_registrasi_mahasiswa untuk ".$nim." sukses! $rowCount baris terpengaruh.";
        } else {
            return "Tidak ada baris yang diupdate. Periksa kondisi Anda.";
        }
    } catch (PDOException $e) {
        return "Error updating data: " . $e->getMessage();
    }
}


//http://localhost/ulb/feeder/feed/mahasiswa.php?Nim=613230039&Jp=13

// Get the parameter 'Nim' from the query string using $_GET
//http://localhost/ulb/feeder/feed/mahasiswa.php?x_TaMasuk=2023-2024&x_PerMasuk=1&x_Kode_Jp=13&jenis=thn

$xTaMasuk = isset($_GET['x_TaMasuk']) ? $_GET['x_TaMasuk'] : '';  
$xPerMasuk = isset($_GET['x_PerMasuk']) ? $_GET['x_PerMasuk'] : '';  
$xKodeJp = isset($_GET['x_Kode_Jp']) ? $_GET['x_Kode_Jp'] : '';  
$xjenis = isset($_GET['jenis']) ? $_GET['jenis'] : '';  
$Nim = isset($_GET['Nim']) ? $_GET['Nim'] : ''; 


$token = getToken();
try {
// Prepare the SQL query 
if ($xjenis=='thn'){    
    // Pengecekan ketiga variabel
    if (!empty($xTaMasuk) && !empty($xPerMasuk) && !empty($xKodeJp)) {
        $query = "SELECT Nim, Nama_Mhs, NIK, Tmp_Lahir, Tgl_Lahir, Jenis_Kel, id_agama, Alamat_Mhs, rt, rw, Kelurahan, id_wilayah, Kodepos_Mhs, 
        Kota_Mhs, Provinsi_mhs, JalurMasuk, id_negara, id_jenis_tinggal, id_alat_transportasi, Tlp_Mhs, TlpRumah, Email, TaMasuk, PerMasuk, 
        tglmasuk, nisn, no_kps, penerima_kps, id_kebutuhan_khusus_mahasiswa, id_kebutuhan_khusus_ibu, NIK_ibu, tanggal_lahir_ibu, id_pendidikan_ibu,
        id_pekerjaan_ibu, id_penghasilan_ibu, Nama_Ayah, NIK_Ayah, id_kebutuhan_khusus_ayah, tanggal_lahir_ayah, id_pendidikan_ayah, id_pekerjaan_ayah, 
        IDMasuk, id_penghasilan_ayah, id_mhs, id_regmhs, idprodi, Kode_jp, id_biaya, idpt, NamaIbu, KPTSASAL, PSASAL, TSKSDIAKUI, biayamasuk, id_jenis_daftar
        FROM Feed_Mhs WHERE TaMasuk = :tamasuk and PerMasuk = :Permasuk and Kode_jp = :kodejp";               
        $stmt = $conn->prepare($query);    
        $stmt->bindParam(':tamasuk', $xTaMasuk, PDO::PARAM_STR);
        $stmt->bindParam(':Permasuk', $xPerMasuk, PDO::PARAM_STR);
        $stmt->bindParam(':kodejp', $xKodeJp, PDO::PARAM_STR);
    // Execute the query
    } else {
        // Jika salah satu atau lebih variabel kosong, tampilkan pesan
        header("Location: error.php?error_message=Semua kriteria TA, Periode dan Program Studi harus diisi.");
        exit();
        //echo "Semua variabel harus diisi.";
    }
} elseif ($xjenis=='npm') {
    $query = "SELECT Nim, Nama_Mhs, NIK, Tmp_Lahir, Tgl_Lahir, Jenis_Kel, id_agama, Alamat_Mhs, rt, rw, Kelurahan, id_wilayah, Kodepos_Mhs, 
    Kota_Mhs, Provinsi_mhs, JalurMasuk, id_negara, id_jenis_tinggal, id_alat_transportasi, Tlp_Mhs, TlpRumah, Email, TaMasuk, PerMasuk, 
    tglmasuk, nisn, no_kps, penerima_kps, id_kebutuhan_khusus_mahasiswa, id_kebutuhan_khusus_ibu, NIK_ibu, tanggal_lahir_ibu, id_pendidikan_ibu,
    id_pekerjaan_ibu, id_penghasilan_ibu, Nama_Ayah, NIK_Ayah, id_kebutuhan_khusus_ayah, tanggal_lahir_ayah, id_pendidikan_ayah, id_pekerjaan_ayah, 
    IDMasuk, id_penghasilan_ayah, id_mhs, id_regmhs, idprodi, Kode_jp, id_biaya, idpt, NamaIbu, KPTSASAL, PSASAL, TSKSDIAKUI, biayamasuk, id_jenis_daftar
    FROM Feed_Mhs WHERE Nim = :Nim";               
    $stmt = $conn->prepare($query);
    // Bind parameter
    $stmt->bindParam(':Nim', $Nim, PDO::PARAM_STR);
    
}
    // Execute the query
    $stmt->execute();
    // Fetch the results
    $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
    // Output the results or handle accordingly
    if ($result) {
        foreach ($result as $row) {
            // Output or process each row as needed
            echo "<br>Nim: " . $row['Nim'] . ", Nama Mhs: " . $row['Nama_Mhs'] . ", Kode_Jp : " . $row['Kode_jp'] ."<br>";
            // Add other fields as needed        
            $record = array(
                "nama_mahasiswa" => $row['Nama_Mhs'],
                "jenis_kelamin" => $row['Jenis_Kel'],
                "tempat_lahir" => $row['Tmp_Lahir'],
                "tanggal_lahir" => $row['Tgl_Lahir'],
                "id_agama" => $row['id_agama'],
                "nik" => $row['NIK'],
                "nisn" => ($row['nisn'] !== null) ? $row['nisn'] : Randomnisn(), 
                "npwp" => null,
                "kewarganegaraan" => $row['id_negara'],
                "jalan" => $row['Alamat_Mhs'],
                "dusun" => null,
                "rt" => $row['rt'],
                "rw" => $row['rw'],
                "kelurahan" => $row['Kelurahan'],
                "kode_pos" => $row['Kodepos_Mhs'],
                "id_wilayah" => ($row['id_wilayah'] !== null) ? $row['id_wilayah'] : 999999,    
                "id_jenis_tinggal" => $row['id_jenis_tinggal'],
                "id_alat_transportasi" => $row['id_alat_transportasi'],
                "telepon" => $row['TlpRumah'],
                "handphone" => $row['Tlp_Mhs'],
                "email" => $row['Email'],
                "penerima_kps" => $row['penerima_kps'],
                "nomor_kps" => $row['no_kps'],
                "nik_ayah" => $row['NIK_Ayah'],
                "nama_ayah" => $row['Nama_Ayah'],
                "tanggal_lahir_ayah" => $row['tanggal_lahir_ayah'],
                "id_pendidikan_ayah" => $row['id_pendidikan_ayah'],
                "id_pekerjaan_ayah" => $row['id_pekerjaan_ayah'],
                "id_penghasilan_ayah" => $row['id_penghasilan_ayah'],
                "nik_ibu" =>$row['NIK_ibu'],
                "nama_ibu_kandung" => $row['NamaIbu'],
                "tanggal_lahir_ibu" => $row['tanggal_lahir_ibu'],
                "id_pendidikan_ibu" => $row['id_pendidikan_ibu'],
                "id_pekerjaan_ibu" => $row['id_pekerjaan_ibu'],
                "id_penghasilan_ibu" => $row['id_penghasilan_ibu'],
                "nama_wali" => null,
                "tanggal_lahir_wali" => null,
                "id_pendidikan_wali" => null,
                "id_pekerjaan_wali" => null,
                "id_penghasilan_wali" => null,
                "id_kebutuhan_khusus_mahasiswa" => $row['id_kebutuhan_khusus_mahasiswa'],
                "id_kebutuhan_khusus_ayah" => $row['id_kebutuhan_khusus_ayah'],
                "id_kebutuhan_khusus_ibu" => $row['id_kebutuhan_khusus_ibu']
            );
            // biodata mahasiswa
            $idmhs = GetIdBiodataMahasiswa($token, $row['NIK']);            
            if ($idmhs == "0" ) { 
              $idmhs = insertBiodataMahasiswa($token, $record);  
              if (strlen($idmhs) === 36 ) {
                echo "Insert bio data  <b> ".$record['nama_mahasiswa']."</b>, berhasil id_mahasiswa =".$idmhs."<br>"; 
              } else {
                echo "Insert bio data  <b> ".$record['nama_mahasiswa']."</b>, gagal..! ".$idmhs."<br>"; 
              }

            } else {
                //$ubdtmhs = UpdateBiodataMahasiswa($token, $idmhs, $record);
                //echo  $ubdtmhs."<br>";
                echo "Update di bypass..";
            }
            
            $biorecord = array(
                "id_mahasiswa" => $idmhs,
                "nim" => $row['Nim'], 
                "id_jenis_daftar" => ($row['id_jenis_daftar'] !== null) ? $row['id_jenis_daftar'] : 1,
                "id_jalur_daftar" => $row['JalurMasuk'],
                "id_periode_masuk" => $row['IDMasuk'],
                "tanggal_daftar" => $row['tglmasuk'],
                "id_perguruan_tinggi" => $row['idpt'],
                "id_prodi" => $row['idprodi'],
                "id_bidang_minat" => "",
                "sks_diakui" => $row['TSKSDIAKUI'],
                "id_perguruan_tinggi_asal" => $row['KPTSASAL'],
                "id_prodi_asal" => $row['PSASAL'],
                "id_pembiayaan" => ($row['id_biaya'] !== null) ? $row['id_biaya'] : 1,
                "biaya_masuk" => ($row['biayamasuk'] !== null) ? $row['biayamasuk'] : 5000000,
            );
            //riwayat mahasiswa;
            $idregmhs = GetListRiwayatPendidikanMahasiswa($token,$row['Nim']);                                              
            if ($idregmhs == "0" ) { 
                $idregmhs = InsertRiwayatPendidikanMahasiswa($token, $biorecord);                   
                if (strlen($idregmhs) === 36 ) {
                    echo "Insert riwayat pendidikan  <b> ".$record['nama_mahasiswa']."</b>, berhasil id_registrasi_mahasiswa =".$idregmhs."<br>"; 
                } else {
                    echo "Insert riwayat pendidikan  <b> ".$record['nama_mahasiswa']."</b> gagal : ".$idregmhs; 
                 }
            } else {
                //$ubdt_rw_mhs = UpdateRiwayatPendidikanMahasiswa($token, $idregmhs, $biorecord);
                //echo  $ubdt_rw_mhs."id_registrasi_maasiswa : ".$idregmhs." <br>";
                echo "Update riwayat pendidikan di bypass.....!";
             }
             $InfoUpdmhs = Updmhs($idmhs, $idregmhs, $row['Nim']);  
             echo $InfoUpdmhs;        
             echo "<br>";    
      }
    } else {
        echo "No records found for the given Nim.";
    }
} catch (PDOException $e) {
    echo "Error executing query: " . $e->getMessage();
}
?>
