<?php
include "db.php";
include "init.php";

function getidkelaskuliah($token, $idregmhs, $idsem, $kmk) {    
    $filter = "id_registrasi_mahasiswa = '$idregmhs' AND id_semester = '$idsem' AND kode_mata_kuliah = '$kmk'"; 
    $order = ""; 
    $limit = 1; 
    $offset = 0; 
    $apiToken = $token; 
    $data = array(
        'act' => 'GetDetailNilaiPerkuliahanKelas', 
        'token' => $apiToken,  
        'filter' => $filter, 
        'order' => $order, 
        'limit' => $limit, 
        'offset' => $offset
    );
    $result_string = runWS($data);
    if ($result_string['error_code'] === 0) {
        if ($result_string['jumlah'] === 0) {
            $xid = "0";
        } else {           
            $xid = $result_string['data'][0]['id_kelas_kuliah'];        
        }              
    } else {        
        $xid = "Gagal mendapatkan id_kelas_kuliah. Error: " . $result_string['error_desc'];     
    }
    return $xid;
}
function updatenillaimk($token, $key, $record) {
    $data = array(
        'act' => 'UpdateNilaiPerkuliahanKelas',
        'token' => $token,
        'key' => $key,
        'record' => $record,
    );

    $result_string = runWS($data);

    if ($result_string['error_code'] === 0) {
        $hasil = "1";
    } else {
        $hasil = "Gagal diperbaharui. Error: " . $result_string['error_desc'];
    }

    return $hasil;
}


// Ambil nilai dari query string
$idtahun = isset($_GET['IDTahun']) ? $_GET['IDTahun'] : '';
$Kode_Mk = isset($_GET['Kode_Mk']) ? $_GET['Kode_Mk'] : '';
$Nim = isset($_GET['Nim']) ? $_GET['Nim'] : '';

// Validasi input
if (empty($idtahun) || empty($Kode_Mk) || empty($Nim)) {
    // Tampilkan pesan error jika ada parameter yang kosong
    echo "Semua parameter harus diisi.";
} else {
    // Buat query berdasarkan kriteria
    $query = "SELECT Thn_Akademik, Periode, IDTahun, Nim, Nama_Mhs, Kode_MK, Nama_Mk_Ind, SKS, Kehadiran, Tugas, UTS, UAS, Jumlah, Nilai, Angka, id_feedmhs
              FROM V_NilaiMhs
              WHERE IDTahun = :idtahun AND Kode_MK = :Kode_Mk AND Nim = :Nim";

    //Persiapkan statement
    $stmt = $conn->prepare($query);

    // Bind parameter
    $stmt->bindParam(':idtahun', $idtahun, PDO::PARAM_STR);
    $stmt->bindParam(':Kode_Mk', $Kode_Mk, PDO::PARAM_STR);
    $stmt->bindParam(':Nim', $Nim, PDO::PARAM_STR);
    

    // Eksekusi query
    $stmt->execute();

    // Ambil hasil query
    $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
    if ($result) {
        echo "===Update nilai mahasiswa untuk kode matakuliah " .$Kode_Mk. "===<br>";
        $token = getToken();        
        foreach ($result as $row) {  
            //echo "Update nilai mahasiswa untuk matakuliah " . $row['Kode_MK']." - ".$row['Nama_Mk_Ind']." (".$row['SKS']." SKS) <br><br> ";         
            //Cari id kelas kuliah       
            $idkelaskuliah = getidkelaskuliah($token, $row['id_feedmhs'],  $row['IDTahun'], trim($row['Kode_MK']));
            if (strlen($idkelaskuliah) === 36) { //jika ditemukan
                $key = array(
                    "id_registrasi_mahasiswa" => $row['id_feedmhs'],
                    "id_kelas_kuliah" => $idkelaskuliah
                    );
                $record = array(
                    "nilai_angka" =>  $row['Jumlah'],
                    "nilai_indeks" =>  $row['Angka'],
                    "nilai_huruf" =>  $row['Nilai']
                    );
                $updateResult = updatenillaimk($token, $key, $record);
                if ($updateResult == "1") {
                    echo "Nilai untuk mahasiswa : ".$row['Nim']." - ".$row['Nama_Mhs'].", berhasil di update <br>";
                    $stat = setketnilai($row['Nim'], $row['Thn_Akademik'], $row['Periode'], $row['Kode_MK']);
                    echo $stat."<br>";                   
                    
                } else {
                    echo "Nilai untuk mahasiswa : ".$row['Nim']." - ".$row['Nama_Mhs'].", ".$updateResult."<br>";
                }
                
            } elseif ($idkelaskuliah == "0") {
                echo "id kelas kuliah : ".$row['Kode_MK']." - ".$row['Nama_Mk_Ind']." tidak ditemukan <br>";                
            } else {
                echo $idkelaskuliah."<br>";
            }
        }     
    } else {
    echo "No records found for the given parameters.";
  
    }
    // Tutup koneksi ke database
    $conn = null;
}
?>
