<?php
namespace PHPMaker2020\baak;

// Autoload
include_once "autoload.php";

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	\Delight\Cookie\Session::start(Config("COOKIE_SAMESITE")); // Init session data

// Output buffering
ob_start();
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$mbkm_jadwal_list = new mbkm_jadwal_list();

// Run the page
$mbkm_jadwal_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$mbkm_jadwal_list->Page_Render();
?>
<?php include_once "header.php"; ?>
<?php if (!$mbkm_jadwal_list->isExport()) { ?>
<script>
var fmbkm_jadwallist, currentPageID;
loadjs.ready("head", function() {

	// Form object
	currentPageID = ew.PAGE_ID = "list";
	fmbkm_jadwallist = currentForm = new ew.Form("fmbkm_jadwallist", "list");
	fmbkm_jadwallist.formKeyCountName = '<?php echo $mbkm_jadwal_list->FormKeyCountName ?>';
	loadjs.done("fmbkm_jadwallist");
});
var fmbkm_jadwallistsrch;
loadjs.ready("head", function() {

	// Form object for search
	fmbkm_jadwallistsrch = currentSearchForm = new ew.Form("fmbkm_jadwallistsrch");

	// Validate function for search
	fmbkm_jadwallistsrch.validate = function(fobj) {
		if (!this.validateRequired)
			return true; // Ignore validation
		fobj = fobj || this._form;
		var infix = "";

		// Call Form_CustomValidate event
		if (!this.Form_CustomValidate(fobj))
			return false;
		return true;
	}

	// Form_CustomValidate
	fmbkm_jadwallistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

		// Your custom validation code here, return false if invalid.
		return true;
	}

	// Use JavaScript validation or not
	fmbkm_jadwallistsrch.validateRequired = <?php echo Config("CLIENT_VALIDATE") ? "true" : "false" ?>;

	// Dynamic selection lists
	fmbkm_jadwallistsrch.lists["x_Kode_Fak"] = <?php echo $mbkm_jadwal_list->Kode_Fak->Lookup->toClientList($mbkm_jadwal_list) ?>;
	fmbkm_jadwallistsrch.lists["x_Kode_Fak"].options = <?php echo JsonEncode($mbkm_jadwal_list->Kode_Fak->lookupOptions()) ?>;
	fmbkm_jadwallistsrch.lists["x_Periode"] = <?php echo $mbkm_jadwal_list->Periode->Lookup->toClientList($mbkm_jadwal_list) ?>;
	fmbkm_jadwallistsrch.lists["x_Periode"].options = <?php echo JsonEncode($mbkm_jadwal_list->Periode->options(FALSE, TRUE)) ?>;
	fmbkm_jadwallistsrch.lists["x_Status_Akd"] = <?php echo $mbkm_jadwal_list->Status_Akd->Lookup->toClientList($mbkm_jadwal_list) ?>;
	fmbkm_jadwallistsrch.lists["x_Status_Akd"].options = <?php echo JsonEncode($mbkm_jadwal_list->Status_Akd->lookupOptions()) ?>;

	// Filters
	fmbkm_jadwallistsrch.filterList = <?php echo $mbkm_jadwal_list->getFilterList() ?>;
	loadjs.done("fmbkm_jadwallistsrch");
});
</script>
<script>
loadjs.ready("head", function() {

	// Client script
	// Write your client script here, no need to add script tags.

});
</script>
<?php } ?>
<?php if (!$mbkm_jadwal_list->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($mbkm_jadwal_list->TotalRecords > 0 && $mbkm_jadwal_list->ExportOptions->visible()) { ?>
<?php $mbkm_jadwal_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($mbkm_jadwal_list->ImportOptions->visible()) { ?>
<?php $mbkm_jadwal_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($mbkm_jadwal_list->SearchOptions->visible()) { ?>
<?php $mbkm_jadwal_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($mbkm_jadwal_list->FilterOptions->visible()) { ?>
<?php $mbkm_jadwal_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$mbkm_jadwal_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$mbkm_jadwal_list->isExport() && !$mbkm_jadwal->CurrentAction) { ?>
<form name="fmbkm_jadwallistsrch" id="fmbkm_jadwallistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<div id="fmbkm_jadwallistsrch-search-panel" class="<?php echo $mbkm_jadwal_list->SearchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="mbkm_jadwal">
	<div class="ew-extended-search">
<?php

// Render search row
$mbkm_jadwal->RowType = ROWTYPE_SEARCH;
$mbkm_jadwal->resetAttributes();
$mbkm_jadwal_list->renderRow();
?>
<?php if ($mbkm_jadwal_list->Kode_Fak->Visible) { // Kode_Fak ?>
	<?php
		$mbkm_jadwal_list->SearchColumnCount++;
		if (($mbkm_jadwal_list->SearchColumnCount - 1) % $mbkm_jadwal_list->SearchFieldsPerRow == 0) {
			$mbkm_jadwal_list->SearchRowCount++;
	?>
<div id="xsr_<?php echo $mbkm_jadwal_list->SearchRowCount ?>" class="ew-row d-sm-flex">
	<?php
		}
	 ?>
	<div id="xsc_Kode_Fak" class="ew-cell form-group">
		<label for="x_Kode_Fak" class="ew-search-caption ew-label"><?php echo $mbkm_jadwal_list->Kode_Fak->caption() ?></label>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Kode_Fak" id="z_Kode_Fak" value="LIKE">
</span>
		<span id="el_mbkm_jadwal_Kode_Fak" class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="mbkm_jadwal" data-field="x_Kode_Fak" data-value-separator="<?php echo $mbkm_jadwal_list->Kode_Fak->displayValueSeparatorAttribute() ?>" id="x_Kode_Fak" name="x_Kode_Fak"<?php echo $mbkm_jadwal_list->Kode_Fak->editAttributes() ?>>
			<?php echo $mbkm_jadwal_list->Kode_Fak->selectOptionListHtml("x_Kode_Fak") ?>
		</select>
</div>
<?php echo $mbkm_jadwal_list->Kode_Fak->Lookup->getParamTag($mbkm_jadwal_list, "p_x_Kode_Fak") ?>
</span>
	</div>
	<?php if ($mbkm_jadwal_list->SearchColumnCount % $mbkm_jadwal_list->SearchFieldsPerRow == 0) { ?>
</div>
	<?php } ?>
<?php } ?>
<?php if ($mbkm_jadwal_list->Tahun_Akd->Visible) { // Tahun_Akd ?>
	<?php
		$mbkm_jadwal_list->SearchColumnCount++;
		if (($mbkm_jadwal_list->SearchColumnCount - 1) % $mbkm_jadwal_list->SearchFieldsPerRow == 0) {
			$mbkm_jadwal_list->SearchRowCount++;
	?>
<div id="xsr_<?php echo $mbkm_jadwal_list->SearchRowCount ?>" class="ew-row d-sm-flex">
	<?php
		}
	 ?>
	<div id="xsc_Tahun_Akd" class="ew-cell form-group">
		<label for="x_Tahun_Akd" class="ew-search-caption ew-label"><?php echo $mbkm_jadwal_list->Tahun_Akd->caption() ?></label>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Tahun_Akd" id="z_Tahun_Akd" value="LIKE">
</span>
		<span id="el_mbkm_jadwal_Tahun_Akd" class="ew-search-field">
<input type="text" data-table="mbkm_jadwal" data-field="x_Tahun_Akd" name="x_Tahun_Akd" id="x_Tahun_Akd" size="12" maxlength="10" placeholder="<?php echo HtmlEncode($mbkm_jadwal_list->Tahun_Akd->getPlaceHolder()) ?>" value="<?php echo $mbkm_jadwal_list->Tahun_Akd->EditValue ?>"<?php echo $mbkm_jadwal_list->Tahun_Akd->editAttributes() ?>>
</span>
	</div>
	<?php if ($mbkm_jadwal_list->SearchColumnCount % $mbkm_jadwal_list->SearchFieldsPerRow == 0) { ?>
</div>
	<?php } ?>
<?php } ?>
<?php if ($mbkm_jadwal_list->Periode->Visible) { // Periode ?>
	<?php
		$mbkm_jadwal_list->SearchColumnCount++;
		if (($mbkm_jadwal_list->SearchColumnCount - 1) % $mbkm_jadwal_list->SearchFieldsPerRow == 0) {
			$mbkm_jadwal_list->SearchRowCount++;
	?>
<div id="xsr_<?php echo $mbkm_jadwal_list->SearchRowCount ?>" class="ew-row d-sm-flex">
	<?php
		}
	 ?>
	<div id="xsc_Periode" class="ew-cell form-group">
		<label for="x_Periode" class="ew-search-caption ew-label"><?php echo $mbkm_jadwal_list->Periode->caption() ?></label>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Periode" id="z_Periode" value="LIKE">
</span>
		<span id="el_mbkm_jadwal_Periode" class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="mbkm_jadwal" data-field="x_Periode" data-value-separator="<?php echo $mbkm_jadwal_list->Periode->displayValueSeparatorAttribute() ?>" id="x_Periode" name="x_Periode"<?php echo $mbkm_jadwal_list->Periode->editAttributes() ?>>
			<?php echo $mbkm_jadwal_list->Periode->selectOptionListHtml("x_Periode") ?>
		</select>
</div>
</span>
	</div>
	<?php if ($mbkm_jadwal_list->SearchColumnCount % $mbkm_jadwal_list->SearchFieldsPerRow == 0) { ?>
</div>
	<?php } ?>
<?php } ?>
<?php if ($mbkm_jadwal_list->Status_Akd->Visible) { // Status_Akd ?>
	<?php
		$mbkm_jadwal_list->SearchColumnCount++;
		if (($mbkm_jadwal_list->SearchColumnCount - 1) % $mbkm_jadwal_list->SearchFieldsPerRow == 0) {
			$mbkm_jadwal_list->SearchRowCount++;
	?>
<div id="xsr_<?php echo $mbkm_jadwal_list->SearchRowCount ?>" class="ew-row d-sm-flex">
	<?php
		}
	 ?>
	<div id="xsc_Status_Akd" class="ew-cell form-group">
		<label for="x_Status_Akd" class="ew-search-caption ew-label"><?php echo $mbkm_jadwal_list->Status_Akd->caption() ?></label>
		<span class="ew-search-operator">
<?php echo $Language->phrase("LIKE") ?>
<input type="hidden" name="z_Status_Akd" id="z_Status_Akd" value="LIKE">
</span>
		<span id="el_mbkm_jadwal_Status_Akd" class="ew-search-field">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="mbkm_jadwal" data-field="x_Status_Akd" data-value-separator="<?php echo $mbkm_jadwal_list->Status_Akd->displayValueSeparatorAttribute() ?>" id="x_Status_Akd" name="x_Status_Akd"<?php echo $mbkm_jadwal_list->Status_Akd->editAttributes() ?>>
			<?php echo $mbkm_jadwal_list->Status_Akd->selectOptionListHtml("x_Status_Akd") ?>
		</select>
</div>
<?php echo $mbkm_jadwal_list->Status_Akd->Lookup->getParamTag($mbkm_jadwal_list, "p_x_Status_Akd") ?>
</span>
	</div>
	<?php if ($mbkm_jadwal_list->SearchColumnCount % $mbkm_jadwal_list->SearchFieldsPerRow == 0) { ?>
</div>
	<?php } ?>
<?php } ?>
	<?php if ($mbkm_jadwal_list->SearchColumnCount % $mbkm_jadwal_list->SearchFieldsPerRow > 0) { ?>
</div>
	<?php } ?>
<div id="xsr_<?php echo $mbkm_jadwal_list->SearchRowCount + 1 ?>" class="ew-row d-sm-flex">
	<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
</div>
	</div><!-- /.ew-extended-search -->
</div><!-- /.ew-search-panel -->
</form>
<?php } ?>
<?php } ?>
<?php $mbkm_jadwal_list->showPageHeader(); ?>
<?php
$mbkm_jadwal_list->showMessage();
?>
<?php if ($mbkm_jadwal_list->TotalRecords > 0 || $mbkm_jadwal->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($mbkm_jadwal_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> mbkm_jadwal">
<form name="fmbkm_jadwallist" id="fmbkm_jadwallist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($Page->CheckToken) { ?>
<input type="hidden" name="<?php echo Config("TOKEN_NAME") ?>" value="<?php echo $Page->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="mbkm_jadwal">
<div id="gmp_mbkm_jadwal" class="<?php echo ResponsiveTableClass() ?>card-body ew-grid-middle-panel">
<?php if ($mbkm_jadwal_list->TotalRecords > 0 || $mbkm_jadwal_list->isGridEdit()) { ?>
<table id="tbl_mbkm_jadwallist" class="table ew-table"><!-- .ew-table -->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$mbkm_jadwal->RowType = ROWTYPE_HEADER;

// Render list options
$mbkm_jadwal_list->renderListOptions();

// Render list options (header, left)
$mbkm_jadwal_list->ListOptions->render("header", "left");
?>
<?php if ($mbkm_jadwal_list->Kode_Fak->Visible) { // Kode_Fak ?>
	<?php if ($mbkm_jadwal_list->SortUrl($mbkm_jadwal_list->Kode_Fak) == "") { ?>
		<th data-name="Kode_Fak" class="<?php echo $mbkm_jadwal_list->Kode_Fak->headerCellClass() ?>"><div id="elh_mbkm_jadwal_Kode_Fak" class="mbkm_jadwal_Kode_Fak"><div class="ew-table-header-caption"><?php echo $mbkm_jadwal_list->Kode_Fak->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Kode_Fak" class="<?php echo $mbkm_jadwal_list->Kode_Fak->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $mbkm_jadwal_list->SortUrl($mbkm_jadwal_list->Kode_Fak) ?>', 1);"><div id="elh_mbkm_jadwal_Kode_Fak" class="mbkm_jadwal_Kode_Fak">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $mbkm_jadwal_list->Kode_Fak->caption() ?></span><span class="ew-table-header-sort"><?php if ($mbkm_jadwal_list->Kode_Fak->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($mbkm_jadwal_list->Kode_Fak->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($mbkm_jadwal_list->Tahun_Akd->Visible) { // Tahun_Akd ?>
	<?php if ($mbkm_jadwal_list->SortUrl($mbkm_jadwal_list->Tahun_Akd) == "") { ?>
		<th data-name="Tahun_Akd" class="<?php echo $mbkm_jadwal_list->Tahun_Akd->headerCellClass() ?>"><div id="elh_mbkm_jadwal_Tahun_Akd" class="mbkm_jadwal_Tahun_Akd"><div class="ew-table-header-caption"><?php echo $mbkm_jadwal_list->Tahun_Akd->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Tahun_Akd" class="<?php echo $mbkm_jadwal_list->Tahun_Akd->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $mbkm_jadwal_list->SortUrl($mbkm_jadwal_list->Tahun_Akd) ?>', 1);"><div id="elh_mbkm_jadwal_Tahun_Akd" class="mbkm_jadwal_Tahun_Akd">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $mbkm_jadwal_list->Tahun_Akd->caption() ?></span><span class="ew-table-header-sort"><?php if ($mbkm_jadwal_list->Tahun_Akd->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($mbkm_jadwal_list->Tahun_Akd->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($mbkm_jadwal_list->Periode->Visible) { // Periode ?>
	<?php if ($mbkm_jadwal_list->SortUrl($mbkm_jadwal_list->Periode) == "") { ?>
		<th data-name="Periode" class="<?php echo $mbkm_jadwal_list->Periode->headerCellClass() ?>"><div id="elh_mbkm_jadwal_Periode" class="mbkm_jadwal_Periode"><div class="ew-table-header-caption"><?php echo $mbkm_jadwal_list->Periode->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Periode" class="<?php echo $mbkm_jadwal_list->Periode->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $mbkm_jadwal_list->SortUrl($mbkm_jadwal_list->Periode) ?>', 1);"><div id="elh_mbkm_jadwal_Periode" class="mbkm_jadwal_Periode">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $mbkm_jadwal_list->Periode->caption() ?></span><span class="ew-table-header-sort"><?php if ($mbkm_jadwal_list->Periode->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($mbkm_jadwal_list->Periode->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($mbkm_jadwal_list->Status_Akd->Visible) { // Status_Akd ?>
	<?php if ($mbkm_jadwal_list->SortUrl($mbkm_jadwal_list->Status_Akd) == "") { ?>
		<th data-name="Status_Akd" class="<?php echo $mbkm_jadwal_list->Status_Akd->headerCellClass() ?>"><div id="elh_mbkm_jadwal_Status_Akd" class="mbkm_jadwal_Status_Akd"><div class="ew-table-header-caption"><?php echo $mbkm_jadwal_list->Status_Akd->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="Status_Akd" class="<?php echo $mbkm_jadwal_list->Status_Akd->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $mbkm_jadwal_list->SortUrl($mbkm_jadwal_list->Status_Akd) ?>', 1);"><div id="elh_mbkm_jadwal_Status_Akd" class="mbkm_jadwal_Status_Akd">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $mbkm_jadwal_list->Status_Akd->caption() ?></span><span class="ew-table-header-sort"><?php if ($mbkm_jadwal_list->Status_Akd->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($mbkm_jadwal_list->Status_Akd->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($mbkm_jadwal_list->TM->Visible) { // TM ?>
	<?php if ($mbkm_jadwal_list->SortUrl($mbkm_jadwal_list->TM) == "") { ?>
		<th data-name="TM" class="<?php echo $mbkm_jadwal_list->TM->headerCellClass() ?>"><div id="elh_mbkm_jadwal_TM" class="mbkm_jadwal_TM"><div class="ew-table-header-caption"><?php echo $mbkm_jadwal_list->TM->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="TM" class="<?php echo $mbkm_jadwal_list->TM->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $mbkm_jadwal_list->SortUrl($mbkm_jadwal_list->TM) ?>', 1);"><div id="elh_mbkm_jadwal_TM" class="mbkm_jadwal_TM">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $mbkm_jadwal_list->TM->caption() ?></span><span class="ew-table-header-sort"><?php if ($mbkm_jadwal_list->TM->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($mbkm_jadwal_list->TM->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($mbkm_jadwal_list->TS->Visible) { // TS ?>
	<?php if ($mbkm_jadwal_list->SortUrl($mbkm_jadwal_list->TS) == "") { ?>
		<th data-name="TS" class="<?php echo $mbkm_jadwal_list->TS->headerCellClass() ?>"><div id="elh_mbkm_jadwal_TS" class="mbkm_jadwal_TS"><div class="ew-table-header-caption"><?php echo $mbkm_jadwal_list->TS->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="TS" class="<?php echo $mbkm_jadwal_list->TS->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $mbkm_jadwal_list->SortUrl($mbkm_jadwal_list->TS) ?>', 1);"><div id="elh_mbkm_jadwal_TS" class="mbkm_jadwal_TS">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $mbkm_jadwal_list->TS->caption() ?></span><span class="ew-table-header-sort"><?php if ($mbkm_jadwal_list->TS->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($mbkm_jadwal_list->TS->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($mbkm_jadwal_list->NoSKPenugasan->Visible) { // NoSKPenugasan ?>
	<?php if ($mbkm_jadwal_list->SortUrl($mbkm_jadwal_list->NoSKPenugasan) == "") { ?>
		<th data-name="NoSKPenugasan" class="<?php echo $mbkm_jadwal_list->NoSKPenugasan->headerCellClass() ?>"><div id="elh_mbkm_jadwal_NoSKPenugasan" class="mbkm_jadwal_NoSKPenugasan"><div class="ew-table-header-caption"><?php echo $mbkm_jadwal_list->NoSKPenugasan->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="NoSKPenugasan" class="<?php echo $mbkm_jadwal_list->NoSKPenugasan->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $mbkm_jadwal_list->SortUrl($mbkm_jadwal_list->NoSKPenugasan) ?>', 1);"><div id="elh_mbkm_jadwal_NoSKPenugasan" class="mbkm_jadwal_NoSKPenugasan">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $mbkm_jadwal_list->NoSKPenugasan->caption() ?></span><span class="ew-table-header-sort"><?php if ($mbkm_jadwal_list->NoSKPenugasan->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($mbkm_jadwal_list->NoSKPenugasan->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($mbkm_jadwal_list->TglST->Visible) { // TglST ?>
	<?php if ($mbkm_jadwal_list->SortUrl($mbkm_jadwal_list->TglST) == "") { ?>
		<th data-name="TglST" class="<?php echo $mbkm_jadwal_list->TglST->headerCellClass() ?>"><div id="elh_mbkm_jadwal_TglST" class="mbkm_jadwal_TglST"><div class="ew-table-header-caption"><?php echo $mbkm_jadwal_list->TglST->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="TglST" class="<?php echo $mbkm_jadwal_list->TglST->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $mbkm_jadwal_list->SortUrl($mbkm_jadwal_list->TglST) ?>', 1);"><div id="elh_mbkm_jadwal_TglST" class="mbkm_jadwal_TglST">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $mbkm_jadwal_list->TglST->caption() ?></span><span class="ew-table-header-sort"><?php if ($mbkm_jadwal_list->TglST->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($mbkm_jadwal_list->TglST->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($mbkm_jadwal_list->PejabatTTD->Visible) { // PejabatTTD ?>
	<?php if ($mbkm_jadwal_list->SortUrl($mbkm_jadwal_list->PejabatTTD) == "") { ?>
		<th data-name="PejabatTTD" class="<?php echo $mbkm_jadwal_list->PejabatTTD->headerCellClass() ?>"><div id="elh_mbkm_jadwal_PejabatTTD" class="mbkm_jadwal_PejabatTTD"><div class="ew-table-header-caption"><?php echo $mbkm_jadwal_list->PejabatTTD->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="PejabatTTD" class="<?php echo $mbkm_jadwal_list->PejabatTTD->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $mbkm_jadwal_list->SortUrl($mbkm_jadwal_list->PejabatTTD) ?>', 1);"><div id="elh_mbkm_jadwal_PejabatTTD" class="mbkm_jadwal_PejabatTTD">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $mbkm_jadwal_list->PejabatTTD->caption() ?></span><span class="ew-table-header-sort"><?php if ($mbkm_jadwal_list->PejabatTTD->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($mbkm_jadwal_list->PejabatTTD->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($mbkm_jadwal_list->NIDNTTD->Visible) { // NIDNTTD ?>
	<?php if ($mbkm_jadwal_list->SortUrl($mbkm_jadwal_list->NIDNTTD) == "") { ?>
		<th data-name="NIDNTTD" class="<?php echo $mbkm_jadwal_list->NIDNTTD->headerCellClass() ?>"><div id="elh_mbkm_jadwal_NIDNTTD" class="mbkm_jadwal_NIDNTTD"><div class="ew-table-header-caption"><?php echo $mbkm_jadwal_list->NIDNTTD->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="NIDNTTD" class="<?php echo $mbkm_jadwal_list->NIDNTTD->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event, '<?php echo $mbkm_jadwal_list->SortUrl($mbkm_jadwal_list->NIDNTTD) ?>', 1);"><div id="elh_mbkm_jadwal_NIDNTTD" class="mbkm_jadwal_NIDNTTD">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $mbkm_jadwal_list->NIDNTTD->caption() ?></span><span class="ew-table-header-sort"><?php if ($mbkm_jadwal_list->NIDNTTD->getSort() == "ASC") { ?><i class="fas fa-sort-up"></i><?php } elseif ($mbkm_jadwal_list->NIDNTTD->getSort() == "DESC") { ?><i class="fas fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$mbkm_jadwal_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($mbkm_jadwal_list->ExportAll && $mbkm_jadwal_list->isExport()) {
	$mbkm_jadwal_list->StopRecord = $mbkm_jadwal_list->TotalRecords;
} else {

	// Set the last record to display
	if ($mbkm_jadwal_list->TotalRecords > $mbkm_jadwal_list->StartRecord + $mbkm_jadwal_list->DisplayRecords - 1)
		$mbkm_jadwal_list->StopRecord = $mbkm_jadwal_list->StartRecord + $mbkm_jadwal_list->DisplayRecords - 1;
	else
		$mbkm_jadwal_list->StopRecord = $mbkm_jadwal_list->TotalRecords;
}
$mbkm_jadwal_list->RecordCount = $mbkm_jadwal_list->StartRecord - 1;
if ($mbkm_jadwal_list->Recordset && !$mbkm_jadwal_list->Recordset->EOF) {
	$mbkm_jadwal_list->Recordset->moveFirst();
	$selectLimit = $mbkm_jadwal_list->UseSelectLimit;
	if (!$selectLimit && $mbkm_jadwal_list->StartRecord > 1)
		$mbkm_jadwal_list->Recordset->move($mbkm_jadwal_list->StartRecord - 1);
} elseif (!$mbkm_jadwal->AllowAddDeleteRow && $mbkm_jadwal_list->StopRecord == 0) {
	$mbkm_jadwal_list->StopRecord = $mbkm_jadwal->GridAddRowCount;
}

// Initialize aggregate
$mbkm_jadwal->RowType = ROWTYPE_AGGREGATEINIT;
$mbkm_jadwal->resetAttributes();
$mbkm_jadwal_list->renderRow();
while ($mbkm_jadwal_list->RecordCount < $mbkm_jadwal_list->StopRecord) {
	$mbkm_jadwal_list->RecordCount++;
	if ($mbkm_jadwal_list->RecordCount >= $mbkm_jadwal_list->StartRecord) {
		$mbkm_jadwal_list->RowCount++;

		// Set up key count
		$mbkm_jadwal_list->KeyCount = $mbkm_jadwal_list->RowIndex;

		// Init row class and style
		$mbkm_jadwal->resetAttributes();
		$mbkm_jadwal->CssClass = "";
		if ($mbkm_jadwal_list->isGridAdd()) {
		} else {
			$mbkm_jadwal_list->loadRowValues($mbkm_jadwal_list->Recordset); // Load row values
		}
		$mbkm_jadwal->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$mbkm_jadwal->RowAttrs->merge(["data-rowindex" => $mbkm_jadwal_list->RowCount, "id" => "r" . $mbkm_jadwal_list->RowCount . "_mbkm_jadwal", "data-rowtype" => $mbkm_jadwal->RowType]);

		// Render row
		$mbkm_jadwal_list->renderRow();

		// Render list options
		$mbkm_jadwal_list->renderListOptions();
?>
	<tr <?php echo $mbkm_jadwal->rowAttributes() ?>>
<?php

// Render list options (body, left)
$mbkm_jadwal_list->ListOptions->render("body", "left", $mbkm_jadwal_list->RowCount);
?>
	<?php if ($mbkm_jadwal_list->Kode_Fak->Visible) { // Kode_Fak ?>
		<td data-name="Kode_Fak" <?php echo $mbkm_jadwal_list->Kode_Fak->cellAttributes() ?>>
<span id="el<?php echo $mbkm_jadwal_list->RowCount ?>_mbkm_jadwal_Kode_Fak">
<span<?php echo $mbkm_jadwal_list->Kode_Fak->viewAttributes() ?>><?php echo $mbkm_jadwal_list->Kode_Fak->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($mbkm_jadwal_list->Tahun_Akd->Visible) { // Tahun_Akd ?>
		<td data-name="Tahun_Akd" <?php echo $mbkm_jadwal_list->Tahun_Akd->cellAttributes() ?>>
<span id="el<?php echo $mbkm_jadwal_list->RowCount ?>_mbkm_jadwal_Tahun_Akd">
<span<?php echo $mbkm_jadwal_list->Tahun_Akd->viewAttributes() ?>><?php echo $mbkm_jadwal_list->Tahun_Akd->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($mbkm_jadwal_list->Periode->Visible) { // Periode ?>
		<td data-name="Periode" <?php echo $mbkm_jadwal_list->Periode->cellAttributes() ?>>
<span id="el<?php echo $mbkm_jadwal_list->RowCount ?>_mbkm_jadwal_Periode">
<span<?php echo $mbkm_jadwal_list->Periode->viewAttributes() ?>><?php echo $mbkm_jadwal_list->Periode->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($mbkm_jadwal_list->Status_Akd->Visible) { // Status_Akd ?>
		<td data-name="Status_Akd" <?php echo $mbkm_jadwal_list->Status_Akd->cellAttributes() ?>>
<span id="el<?php echo $mbkm_jadwal_list->RowCount ?>_mbkm_jadwal_Status_Akd">
<span<?php echo $mbkm_jadwal_list->Status_Akd->viewAttributes() ?>><?php echo $mbkm_jadwal_list->Status_Akd->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($mbkm_jadwal_list->TM->Visible) { // TM ?>
		<td data-name="TM" <?php echo $mbkm_jadwal_list->TM->cellAttributes() ?>>
<span id="el<?php echo $mbkm_jadwal_list->RowCount ?>_mbkm_jadwal_TM">
<span<?php echo $mbkm_jadwal_list->TM->viewAttributes() ?>><?php echo $mbkm_jadwal_list->TM->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($mbkm_jadwal_list->TS->Visible) { // TS ?>
		<td data-name="TS" <?php echo $mbkm_jadwal_list->TS->cellAttributes() ?>>
<span id="el<?php echo $mbkm_jadwal_list->RowCount ?>_mbkm_jadwal_TS">
<span<?php echo $mbkm_jadwal_list->TS->viewAttributes() ?>><?php echo $mbkm_jadwal_list->TS->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($mbkm_jadwal_list->NoSKPenugasan->Visible) { // NoSKPenugasan ?>
		<td data-name="NoSKPenugasan" <?php echo $mbkm_jadwal_list->NoSKPenugasan->cellAttributes() ?>>
<span id="el<?php echo $mbkm_jadwal_list->RowCount ?>_mbkm_jadwal_NoSKPenugasan">
<span<?php echo $mbkm_jadwal_list->NoSKPenugasan->viewAttributes() ?>><?php echo $mbkm_jadwal_list->NoSKPenugasan->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($mbkm_jadwal_list->TglST->Visible) { // TglST ?>
		<td data-name="TglST" <?php echo $mbkm_jadwal_list->TglST->cellAttributes() ?>>
<span id="el<?php echo $mbkm_jadwal_list->RowCount ?>_mbkm_jadwal_TglST">
<span<?php echo $mbkm_jadwal_list->TglST->viewAttributes() ?>><?php echo $mbkm_jadwal_list->TglST->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($mbkm_jadwal_list->PejabatTTD->Visible) { // PejabatTTD ?>
		<td data-name="PejabatTTD" <?php echo $mbkm_jadwal_list->PejabatTTD->cellAttributes() ?>>
<span id="el<?php echo $mbkm_jadwal_list->RowCount ?>_mbkm_jadwal_PejabatTTD">
<span<?php echo $mbkm_jadwal_list->PejabatTTD->viewAttributes() ?>><?php echo $mbkm_jadwal_list->PejabatTTD->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($mbkm_jadwal_list->NIDNTTD->Visible) { // NIDNTTD ?>
		<td data-name="NIDNTTD" <?php echo $mbkm_jadwal_list->NIDNTTD->cellAttributes() ?>>
<span id="el<?php echo $mbkm_jadwal_list->RowCount ?>_mbkm_jadwal_NIDNTTD">
<span<?php echo $mbkm_jadwal_list->NIDNTTD->viewAttributes() ?>><?php echo $mbkm_jadwal_list->NIDNTTD->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$mbkm_jadwal_list->ListOptions->render("body", "right", $mbkm_jadwal_list->RowCount);
?>
	</tr>
<?php
	}
	if (!$mbkm_jadwal_list->isGridAdd())
		$mbkm_jadwal_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
<?php if (!$mbkm_jadwal->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($mbkm_jadwal_list->Recordset)
	$mbkm_jadwal_list->Recordset->Close();
?>
<?php if (!$mbkm_jadwal_list->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$mbkm_jadwal_list->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php echo $mbkm_jadwal_list->Pager->render() ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $mbkm_jadwal_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($mbkm_jadwal_list->TotalRecords == 0 && !$mbkm_jadwal->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $mbkm_jadwal_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$mbkm_jadwal_list->showPageFooter();
if (Config("DEBUG"))
	echo GetDebugMessage();
?>
<?php if (!$mbkm_jadwal_list->isExport()) { ?>
<script>
loadjs.ready("load", function() {

	// Startup script
	// Write your table-specific startup script here
	// console.log("page loaded");

});
</script>
<?php } ?>
<?php include_once "footer.php"; ?>
<?php
$mbkm_jadwal_list->terminate();
?>